<?php 
class Payments extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('pdf');
	}
	
	function index()
	{
		//$this->payments();		
		$this->wallet();		
	}
	
	/*
	 * 
	 * name		:payments
	 * @param   :Null
	 * @return  :payments for a particular
	 * 			 Publisher
	 */	
	 	
	public function payments()
	{	
		$data['page_title'] = "Payments";	
		$data['breadcrumb'] = '';		
		
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('payments/payments',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		//$this->rest->debug();
		//exit();
	}
	
	/*
	 * 
	 * name		:payments
	 * @param   :Null
	 * @return  :payments for a particular
	 * 			 Publisher
	 */	
	 	
	public function payments_invoice()
	{	
		$data['page_title'] = "Payments Invoice";	
		$data['breadcrumb'] = '';		
		$invoice_id=$this->uri->segment(4);
		$data['invoice_details']=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id,'api_key'=>get_session('api_key')),'php'); 
		//print_r($data['invoice_details']);
//exit;
		$network			=	$this->rest->get('api/v1/payments/fetch_network_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['network']	=	$network[0];
		
		$publisher			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['publisher']	=	$publisher[0];
		
		//$this->rest->debug();
		/*print_r($data['publisher']);
		exit;*/
		//$this->rest->debug();
				
		
		$data['content'] 	= 	$this->load->view('payments/payments_invoice',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	 /*
   * 
   * name: fetch_publisher_invoice_list
   * @param : account_id
   * @return : all payment invoice details using pub account_id
   */
   
	public function fetch_publisher_invoice_list()
	{
		$filter	=	array(
						'date_from'		=>	($this->input->post('date_from'))?$this->input->post('date_from'):'',
						'date_to'		=>	($this->input->post('date_to'))?$this->input->post('date_to'):'',
						'site'			=>	($this->input->post('site'))?explode(',',$this->input->post('site')):'',
						'status'		=>	($this->input->post('status')!='')?explode(',',$this->input->post('status')):'',
						'payment_type'	=>	($this->input->post('payment_type'))?explode(',',$this->input->post('payment_type')):''
					);
		$invoice_list=$this->rest->get('api/v1/payments/fetch_publisher_invoice_list',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($invoice_list);
	}
	
	
	/*
	 * 
	 * name		:payments_history
	 * @param   :Null
	 * @return  :payments for a particular
	 * 			 Publisher
	 */	
	public function payment_history()
	{	
		$data['page_title'] = "Payments History";	
		$data['breadcrumb'] = '';		
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');		
		$api_key = get_session('api_key');
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		/*****/
		
		$paypal_info=$this->rest->get('api/v1/network/fetch_paypal_info',array("api_key"=>$api_key),'php');	
		$webmoney_info=$this->rest->get('api/v1/network/fetch_webmoney_info',array("api_key"=>$api_key),'php');
		$bitcoin_info=$this->rest->get('api/v1/network/fetch_bitcoin_info',array("api_key"=>$api_key),'php');
		$payment_info=$this->rest->get('api/v1/network/fetch_payment_info',array("api_key"=>$api_key),'php');
		
		$data['payment_details']=$payment_info[0];
		$data['paypal']=	$paypal_info[0];
		$data['webmoney_details']=$webmoney_info[0];		
		$data['bitcoin_details']=$bitcoin_info[0];
		$data['trigger_history']='1';
		/******/
		$data['content'] = $this->load->view('payments/wallet',$data,TRUE);	
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	/*
	 * requesting new payment from publisher
	 * 01-09-2017
	 * */
	public function payment_inv_request()
	{	
		$data['page_title'] = "Payments Request";	
		$data['breadcrumb'] = '';		
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		
		//$data['content'] = $this->load->view('payments/payments_history',$data,TRUE);	
		$data['page_content_info']='new_request';
		$data['content'] = $this->load->view('payments/wallet',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}

		public function individual_payment_history($year,$month)
	{	
             $data['year']=$year;
             $data['month']=$month;
			echo $this->load->view('payments/payment_history_view_more',$data);
	}
	
  /*
   * 
   * name: fetch_publisher_history_list
   * @param : account_id
   * @return : all payment invoice details using pub account_id
   */
  	public function fetch_publisher_history_list()
	{
		$filter	=	array(
						'date_from'		=>	($this->input->post('date_from_scd'))?$this->input->post('date_from_scd'):'',
						'date_to'		=>	($this->input->post('date_to_scd'))?$this->input->post('date_to_scd'):'',
						'site'			=>	($this->input->post('site'))?explode(',',$this->input->post('site')):'',
						'status'		=>	($this->input->post('status'))?explode(',',$this->input->post('status')):'',
						'payment_type'	=>	($this->input->post('payment_type'))?explode(',',$this->input->post('payment_type')):''
					);
					
		$pub_history_list=$this->rest->get('api/v1/payments/fetch_publisher_payment_history',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($pub_history_list);
		
		
	}
	
   /*
   * 
   * name: get_payment_history_details
   * @param : account_id,month,year
   * @return : all payment invoice details using pub account_id
   */
	public function get_payment_history_details()
	{
		$month	=	clean_data($this->input->post('month'));
		$year	=	clean_data($this->input->post('year'));
		$filter	=	array(
						'date_from'		=>	($this->input->post('date_from'))?$this->input->post('date_from'):'',
						'date_to'		=>	($this->input->post('date_to'))?$this->input->post('date_to'):'',
						'site'			=>	($this->input->post('site'))?explode(',',$this->input->post('site')):'',
						'status'		=>	($this->input->post('status'))?explode(',',$this->input->post('status')):'',
						'payment_type'	=>	($this->input->post('payment_type'))?explode(',',$this->input->post('payment_type')):'',
						'search'		=>	$this->input->post('sSearch'),
						'order'			=>	$this->input->post()
					);
		
		#$account_id=clean_data($this->input->post('accountid'));
		$pub_history=$this->rest->post('api/v1/payments/fetch_pub_date_wise_payment',array('api_key'=>get_session('api_key'),'month'=>$month,'year'=>$year,'filter'=>$filter),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($pub_history);
	}

    public function get_individual_payment_history_details($month,$year)
	{
	   $pub_history=$this->rest->post('api/v1/payments/fetch_pub_date_wise_payment',array('api_key'=>get_session('api_key'),'month'=>$month,'year'=>$year,),'json');
	   echo convert_to_datatable_format($pub_history);
	}
	
	public function download_invoice_details($invoice_id)
	{
		/*$network			=	$this->rest->get('api/v1/payments/fetch_network_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['network']	=	$network[0];*/
		//print_r($this->input->post());exit;
		$network			=	$this->rest->get('api/v1/payments/fetch_network_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['network']	=	$network[0];
		
		$publisher			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['publisher']	=	$publisher[0];
		
	    $invoice_information=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('api_key'=>get_session('api_key'),'id'=>$invoice_id),'php');
	 	if($invoice_information)
		{
			$data['invoice_details'] = $invoice_information;
			//$view = $this->load->view('admin/invoice_pub',$data,true);
			#$payment_date = date('Y-m-d',strtotime($data['payment_info']['invoice_paid_date']));
			#$pdf_name = 'invoice_'.$data['payment_info']['invoice_code'].'_'.$payment_date;
			$pdf_name = 'Adgate_Invoice_'.date('d.m.Y');
			$this->pdf->load_view('publisher/payments/download_invoice',$data);
			$this->pdf->render();
			$this->pdf->stream("$pdf_name.pdf");
			#$this->load->view('publisher/payments/download_invoice',$data);	
		}else{
			return FALSE;
		}
	}
	
	/*
	 * Request payout -Manual Invoice
	 * 
	 */
	 
	public function request_payout()
	{			
		$data['payment']	=	$this->default_configurations->get('pub_min_payment_amount');
		echo $this->load->view('payments/modal_payments/content/add_payout',$data);
	}
	
	public function wallet()
	{	
		$data['page_title'] = "Wallet";	
		$data['breadcrumb'] = '';		
		
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		$api_key = get_session('api_key');
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		/*****/
		
		$paypal_info=$this->rest->get('api/v1/network/fetch_paypal_info',array("api_key"=>$api_key),'php');	
		$webmoney_info=$this->rest->get('api/v1/network/fetch_webmoney_info',array("api_key"=>$api_key),'php');
		$bitcoin_info=$this->rest->get('api/v1/network/fetch_bitcoin_info',array("api_key"=>$api_key),'php');
		$payment_info=$this->rest->get('api/v1/network/fetch_payment_info',array("api_key"=>$api_key),'php');
		//~ echo $this->rest->debug();exit;
		$data['payment_details']=$payment_info[0];
		$data['paypal']=	$paypal_info[0];
		$data['webmoney_details']=$webmoney_info[0];		
		$data['bitcoin_details']=$bitcoin_info[0];
		
		/******/
		$data['page_content_info']='wallet';
		$data['content'] = $this->load->view('payments/wallet',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		//$this->rest->debug();
		//exit();
	}
	
	public function export_invoice_details($invoice_id=false)
	{
		$invoice_arr = $this->input->post('down_invoice_id');

		$network_info		=	$this->rest->get('api/v1/payments/fetch_network_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['network']	=	$network_info[0];
		
		if($invoice_id!=false)
		{
			$invoice_information=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id,'api_key'=>get_session('api_key')),'php');
			
			if($invoice_information)
			{
				$data['invoice_details'] = $invoice_information;
				
				$pub_account_id = $invoice_information[0]['account_id'];
				$publisher			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('id'=>$pub_account_id,'api_key'=>get_session('api_key')),'php'); 
				$data['publisher']	=	$publisher[0];					
				$pdf_name = $this->config->item('prod_name').'_Invoice_'.date('d.m.Y');
				$this->pdf->load_view('publisher/payments/download_invoice',$data);
				$this->pdf->render();
				$this->pdf->stream("$pdf_name.pdf");	
			}else{
				return FALSE;
			}
		}
		else
		{	
			$invoicedata	=	explode(',',$invoice_arr);
			
			if(is_array($invoicedata))
			{
				$objPHPExcel = new PHPExcel();
			
				$workSheet	=	 $objPHPExcel->getActiveSheet();			
				
				$objPHPExcel->getProperties()->setCreator("Publisher");
				$objPHPExcel->getProperties()->setLastModifiedBy("Publisher");
				$objPHPExcel->getProperties()->setTitle();			
				
				// Set password for readonly data
				$objPHPExcel->getActiveSheet()->getProtection()->setSheet(true);
				$objPHPExcel->getActiveSheet()->getProtection()->setPassword("password");

				//Default Style Settings For Excel Sheet
				$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
				$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
				$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

				$workSheet->getColumnDimension('B')->setWidth(20);
				$workSheet->getColumnDimension('C')->setWidth(20);
				$workSheet->getColumnDimension('D')->setWidth(10);
				$workSheet->getColumnDimension('E')->setWidth(25);
				$workSheet->getColumnDimension('F')->setWidth(15);
				$workSheet->getColumnDimension('G')->setWidth(15);
				$workSheet->getColumnDimension('H')->setWidth(45);
				$workSheet->getColumnDimension('I')->setWidth(10);
				
				//Set the Row dimensions for Each Row 			
				$workSheet->getRowDimension(6)->setRowHeight(20);
				
				// Decalaration of Style in an Array 		
			
				$titleArray	=	array(
										'font'=>array(
													'bold'	=>	true,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);
				$contentArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);	
									
				$dimensArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);		
										
				$metricsArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
										)	
									);	
					
							
				// Add some data
				//echo date('H:i:s') . " Add some data\n";
				$objPHPExcel->setActiveSheetIndex(0);
				
				$i=3;
				foreach($invoicedata as $inv_id)
				{
					$network	=	$network_info[0];
					$inv_info	=	$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$inv_id,'api_key'=>get_session('api_key')),'php');
					
					if($inv_info)
					{						
						$pub_account_id = 	$inv_info[0]['account_id'];
						$pub			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('id'=>$pub_account_id,'api_key'=>get_session('api_key')),'php'); 
						$publisher		=	$pub[0];	
					
						$from_address	=	(($network['billing_company_name'])?$network['billing_company_name'].', '."\n":'').(($network['billing_block_no'])?$network['billing_block_no'].', '."\n":'').(($network['billing_address'])?$network['billing_address'].', '."\n":'').(($network['billing_city'])?$network['billing_city'].(($network['billing_state'])?','.$network['billing_state']:'').', '."\n":'').(($network['name'])?$network['name']."\n":'');				
						
						$to_address		=	(($publisher['dj_company_name'])?$publisher['dj_company_name'].', '."\n":'').(($publisher['dj_company_block_no'])?$publisher['dj_company_block_no'].', '."\n":'').(($publisher['dj_company_address'])?$publisher['dj_company_address'].', '."\n":'').(($publisher['dj_company_state'])?$publisher['dj_company_city'].(($publisher['dj_company_state'])?','.$publisher['dj_company_state']:'').', '."\n":'').(($publisher['name'])?$publisher['name']."\n":'');				
						
						
						$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, "From");
						$objPHPExcel->getActiveSheet()->getStyle('B'.$i)->applyFromArray($titleArray);						
						$objPHPExcel->getActiveSheet()->getStyle('C'.$i)->getAlignment()->setWrapText(tr‌​ue); 
						$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, ($from_address)?$from_address:'-');	
						$objPHPExcel->getActiveSheet()->getStyle('C'.$i)->applyFromArray($contentArray);			
							
						//$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, "To");
						//$objPHPExcel->getActiveSheet()->getStyle('E'.$i)->applyFromArray($titleArray);
						$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getAlignment()->setWrapText(tr‌​ue); 
					//	$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, ($to_address)?$to_address:'-');
						$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->applyFromArray($contentArray);
							
						$i=$i+2;	
						
						$workSheet->getStyle($i)->applyFromArray($titleArray);
						$workSheet->getStyle('B'.$i.':I'.$i)->applyFromArray(
														array(
															'fill' => array(
																'type' => PHPExcel_Style_Fill::FILL_SOLID,
																'color' => array('rgb' => 'd3d3d3')
															)
														)
													);					
						$workSheet->SetCellValue('B'.$i,"Name");
						$workSheet->SetCellValue('C'.$i,"Invoice #");
						$workSheet->SetCellValue('D'.$i,"Date");
						$workSheet->SetCellValue('E'.$i,"Period");
						$workSheet->SetCellValue('F'.$i,"Invoice Amount");
						$workSheet->SetCellValue('G'.$i,"Invoice Status");					
						$workSheet->SetCellValue('H'.$i,"Description");
						$workSheet->SetCellValue('I'.$i,"Amount");			
						
												
						$i=$i+1;
						
						$workSheet->setCellValueByColumnAndRow('1',$i,$inv_info[0]['name']);
						$workSheet->setCellValueByColumnAndRow('2',$i,$inv_info[0]['invoice_code']);
						$workSheet->setCellValueByColumnAndRow('3',$i,$inv_info[0]['in_date']);
						$workSheet->setCellValueByColumnAndRow('4',$i,$inv_info[0]['start_date'].' to '.$inv_info[0]['end_date']);
						$workSheet->setCellValueByColumnAndRow('5',$i,$inv_info[0]['invoice_earn']);
						
						if($inv_info[0]['invoice_status']==1)
						{
							$inv_status	= 	"Paid";
						}						
						elseif($inv_info[0]['invoice_status']==0)						
						{
							$inv_status	= 	"Pending";
						}						
						elseif($inv_info[0]['invoice_status']==2)						
						{
							$inv_status	= 	"Cancelled";
						}
									
						$workSheet->setCellValueByColumnAndRow('6',$i,$inv_status);
						
						foreach($inv_info as $invin):
							$credit_desc	=	str_replace('Earnings','Credit Balance',$inv_info[0]['item_desc']);
							$workSheet->setCellValueByColumnAndRow('7',$i,(($invin['item_desc']=='0')?$credit_desc:$invin['item_desc']));
							$workSheet->setCellValueByColumnAndRow('8',$i,html_entity_decode($this->config->item('currency')).' '.$invin['amount']);
							$i=$i+1;
						endforeach;
						
						$workSheet->getStyle($i)->applyFromArray($titleArray);	
						$workSheet->setCellValueByColumnAndRow('7',$i,"Total");											
						$workSheet->setCellValueByColumnAndRow('8',$i,html_entity_decode($this->config->item('currency')).' '.ROUND($inv_info[0]['total_earn'],2));
						$i=$i+1;						
						$workSheet->getStyle($i)->applyFromArray($titleArray);
						$workSheet->setCellValueByColumnAndRow('7',$i,"Balance");
						$workSheet->setCellValueByColumnAndRow('8',$i,html_entity_decode($this->config->item('currency')).' '.$inv_info[0]['remaining_earn']);
						
					}
					$i=$i+2;					
				}
				
				$dfilename	=		$this->config->item('prod_name').'_Invoice_'.date('d.m.Y').'_'.time().'.xls';
			
				//********* TO DOWNLOAD THE EXCEL FILE********
				header('Content-Type: text/csv');
				header('Content-Disposition: attachment;filename="'.$dfilename.'"');
				
				$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);		
				//$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);		
				
				$objWriter->save('php://output');
				
			}
			else{
				return FALSE;
			}		
			
		}
	}   

}
