<?php 
class Onetime_wizard extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		/*ini_set('max_execution_time', 0);
		set_time_limit(0);
		ini_set('memory_limit','-1');*/
	}
	
	function index()
	{
		$this->personal_information();		
	}
	
	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List all information for a particular
	 * 			 Publisher
	 */	
		
	public function personal_information()
	{
		$data['page_title'] = "Set up your account preferences";
		$data['breadcrumb'] = '';		
		$api_key = get_session('api_key');
		$personal_info=$this->rest->get('api/v1/onetime_wizard/user_info',array('account_id'=>get_session('account_id'),'type'=>get_session('account_type')),'php');	
		$data['personal_info']=$personal_info[0];
		
		$payment_info	=	$this->rest->get('api/v1/network/fetch_payment_info',array("api_key"=>$api_key),'php');		
		$paypal_info	=	$this->rest->get('api/v1/network/fetch_paypal_info',array("api_key"=>$api_key),'php');	
		$webmoney_info	=	$this->rest->get('api/v1/network/fetch_webmoney_info',array("api_key"=>$api_key),'php');
		$bitcoin_info	=	$this->rest->get('api/v1/network/fetch_bitcoin_info',array("api_key"=>$api_key),'php');	
		
		$data['payment_details']	=	$payment_info[0];
		$data['paypal']				=	$paypal_info[0];
		$data['webmoney_details']	=	$webmoney_info[0];		
		$data['bitcoin_details']	=	$bitcoin_info[0];
		
		/*$perfectmoney_info=	$this->rest->get('api/v1/network/fetch_perfectmoney_info',array("api_key"=>$api_key),'php');
		$epayments_info	=	$this->rest->get('api/v1/network/fetch_epayments_info',array("api_key"=>$api_key),'php');
		$paybit_info	=	$this->rest->get('api/v1/network/fetch_paybit_info',array("api_key"=>$api_key),'php');
		$data['epayments_details']	=	$epayments_info[0];
		$data['paybit_details']		=	$paybit_info[0];
		$data['perfectmoney_details']=	$perfectmoney_info[0];*/
				
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');	
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('onetime_wizard',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}

	
	
	
}
