<?php 
class Mobile_ad_blocks extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->helper('download');
	}
	
	function index()
	{
		$this->mobile_ad_blocks();		
	}
	
	/*
	 * 
	 * name		:mobile_ad_blocks
	 * @param   :Null
	 * @return  :List all the Mobile Adblocks for a particular
	 * 			 Publisher
	 */	
		
	public function mobile_ad_blocks()
	{
		$data['page_title'] = "Mobile Ad Blocks";
		$data['breadcrumb'] = '';	
		#$account_id = get_session('account_id');
		$api_key = get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['CHART']['DEFAULT_INTERVAL']);	
		$data['content'] = $this->load->view('adblocks/mobile_ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		:add_mobile_adblock
	 * @param   :Null
	 * @return  :Adds the mobile zone (or) adblock
	 * 			 
	 */	
	
	public function add_mobile_adblock()
	{
		#$account_id=get_session('account_id');
		$api_key = get_session('api_key');
		$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
		$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
		echo $this->load->view('adblocks/modal_adblocks/content/add_mobile_adblock',$data);
	}
	
	
	/*
	 * Edit the adblock
	 * 
	 * name		:edit_mobile_adblock
	 * @param   :Zone id
	 * @return  :Fetches the ad block content and view it
	 * 
	 * 			 
	 */
	
	public function edit_mobile_adblock($zone_id = FALSE)
	{
		$api_key=get_session('api_key');
		$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
		$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
		
		$mobile_adblock = $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
		
		//$web_adblock = json_decode($web_adblock);
		
		
		
		
		//$data['web_adblock'] = (array)$web_adblock[0];
		
		$data['mobile_adblock'] = $mobile_adblock[0];
		
		echo $this->load->view('adblocks/modal_adblocks/content/edit_mobile_adblock',$data);
	}
	
	/*
	 * Lists the Web ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks()
	{
		#$account_id = get_session('account_id');
		$api_key	 = get_session('api_key');
		$mob_adblocks	= $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key),'json');
		
		echo convert_to_datatable_format($mob_adblocks);
	}
	
		/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_ad_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
			$data['zone_id'] = $zone_id;
			
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}
			
			echo $this->load->view('adblocks/modal_adblocks/content/generate_adtag',$data);
		}else{
			return FALSE;	
		}	
	}
	
	
			/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: mobile sdk
	 * @param   : $zone_id
	 * @return  : Download the mobile SDK for android and ios
	 * 
	 * 			 
	 */	
	
	public function mobile_sdk($zone_id = FALSE)
	{
		if($zone_id)
		{
			#$account_id=get_session('account_id');
			$api_key=get_session('api_key');
			
			$data['zone_id'] = $zone_id;
			
			$mobile_adblock = $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
		
			//$web_adblock = json_decode($web_adblock);
		
		 	//$data['web_adblock'] = (array)$web_adblock[0];
		
			$data['mobile_adblock'] = $mobile_adblock[0];
			
			echo $this->load->view('adblocks/modal_adblocks/content/mobile_sdk',$data);
		}else{
			return FALSE;	
		}	
	}
	
	 /*Dowmloads the android apps
	 * 
	 * 
	 * name		: download
	 * @param   : $zone_id
	 * @return  : Download the mobile SDK for android
	 * 
	 * 			 
	 */	
	
	public function download($type)
	{
		switch($type)
		{
			case 'android':
					$data = file_get_contents("support/mobile_sdk/AdgateAppAndroid.zip"); // Read the file's contents
					$name = 'AdexchangeAppAndroid.zip';
					break;
			case 'ios':
					$data = file_get_contents("support/mobile_sdk/AdgateAppiOS.zip"); // Read the file's contents
					$name = 'AdexchangeAppiOS.zip';
					break;
		}
		force_download($name, $data); 
	}	
}
