<?php 
class Dashboard extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
	}
	
	function index()
	{
		$this->dashboard();		
	}
	
	/*
	 * 
	 * name		:dashboard
	 * @param   :Null
	 * @return  :List all the statistics for a particular
	 * 			 Publisher
	 */	 
		
	public function dashboard()
	{
		$data['page_title'] = "Dashboard";		
		$data['breadcrumb'] = '';
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		$data['Earn_history']	= 	$this->rest->get('api/v1/report/fetch_advertise_earn',array("api_key"=>get_session('api_key')),'php');
			//	print_r($Earn_history['PUB_EARN']);
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		
		$data['search_date'] = get_search_date($set['TRAFFICKER']['DASHBOARD']['CHART']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('dashboard',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		 
	}	
	
	public function session_test(){
		view_session();		
	}	
		
	
}
