<?php 
class Campaigns extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->campaigns();		
	}
	
	/*
	 * 
	 * name		:campaigns
	 * @param   :Null
	 * @return  :List all the campaigns for a particular 
	 * 			 Publisher 
	 */	
	 	
	public function campaigns()
	{	 
		$data['page_title'] = "Campaigns";		
		$data['breadcrumb'] = '';				
		$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');	
		$data['country_list']   =   $this->rest->get('api/v1/countrywise_bidding/fetch_country_list',array("api_key"=>get_session('api_key')),'php');  
		$data['category_list']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');
		$data['creative_size']  = 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		$data['campaign_list']  =	$this->rest->get('api/v1/campaign/fetch_publisher_campaign',array("api_key"=>get_session('api_key')),'php');
		//print_r(get_session('api_key')); 		
		$data['content'] = $this->load->view('campaigns/list',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	
	public function adblocks()
	{ 
		$data['page_title'] = 	"Ad Blocks";	
		$data['breadcrumb'] = 	'';	
		$api_key 			= 	get_session('api_key');
		$data['site_id']	= 	$site_id;
		
		// GET DEFAULT PERIOD FROM CONFIG FILE		
		$data['content'] 	= 	$this->load->view('campaigns/ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);		
	}
	
	
	public function fetch_adblocks()
	{
		
			$pval	=	array(
								"api_key"	=>	get_session('api_key'),
								"rotator_block_status" => '1'
							);
		
		
		$adblocks	= 	$this->rest->get('api/v1/site/fetch_adblocks',$pval,'json');
		//$this->rest->debug();
		
		echo convert_to_datatable_format($adblocks);
	}
	
	
	public function fetch_campaigns($country=false,$category=false,$creatives_size=false)
	{
		//print_r($country.'category'.$category.'sixe'.$creatives_size);
		$api_key 	    = get_session('api_key'); 
		
		$input = array(
					    'api_key'=>$api_key						
					  );
					  
		if($country != 'all'){
			$input['country'] = $country;
		}			
		if($category != 'all'){
			$input['category'] = $category;
		}		
		if($creatives_size != 'all'){
			$input['creatives_size'] 	= $creatives_size;
		}
			
		$campaign_list			= $this->rest->get('api/v1/campaign/fetch_campaign_list',$input,'php');
		
			//$this->rest->debug();		
		//	print_r($campaign_list);	exit;
		$campaign_data = '';
		
		if(!empty($campaign_list))
		{	
			$campaign_data .= '<table>
									<tr id="campaign_tr1">		
									<td>';
									$k=1;								
		foreach ($campaign_list as $cam_list)	
		{
			$file_name = $this->config->item('creative_upload_path').$cam_list['filename'];	 
																		
			$file_available=1;
										
			//$file_url=$this->config->item('creative_path').$cam_list['filename'];										
			$file_url=$this->config->item('base_url').$cam_list['dj_image_path'].$cam_list['filename'];								
			$file_headers = @get_headers($file_url);

            if( $file_headers[0]=='HTTP/1.1 404 Not Found')
			{
				$file_available=2;
									  
			}
			else
			{
				$file_available=1;										
			}
			
			$campaign_data .= "<div id='campaign_base' class='campaign_base_".$cam_list['campaignid']."'>";
			
			if($cam_list['favourite_status'] == 0){
				$campaign_data .='<div class="campaign_fav off"><a  onclick="Add_to_favourites('.$cam_list['campaignid'].','.$cam_list['dj_favourite_status'].',this);">FAV</a></div>';
			}else{
				$campaign_data .='<div class="campaign_fav on"><a  onclick="Add_to_favourites('.$cam_list['campaignid'].','.$cam_list['dj_favourite_status'].',this);">FAV</a></div>';	
				
				}
			 
										
										$campaign_data .="<table>
											<tr>";
											if($file_available=='1' && $cam_list['filename']!='')
												{
												$campaign_data.="<td><a onclick='campaign_details(".$cam_list['campaignid'].",this)'><img src=".$file_url;
												$campaign_data.=" id='campaignid_".$cam_list['campaignid']."'></a></td>";  
												}
												else
												{
												$campaign_data.="<td><a onclick='campaign_details(".$cam_list['campaignid'].",this)'><img src=".$this->config->item('creative_path')."campaign_thumb_empty.jpg";
												$campaign_data.=" id='campaignid_".$cam_list['campaignid']."' style='border:#ccc solid 2px'></a></td>";												
												}
										$campaign_data.="</tr>
											
											<tr><td align='center' valign='middle' class='creative_size_text'><a class='campaign-name' onclick='campaign_details(".$cam_list['campaignid'].",this)' title='". $cam_list['campaignname']."'>".$cam_list['campaignname']."</a></td></tr>											
											<tr><td align='center' valign='middle' class='creative_size_text campaign-overall-payout'>"."$".$cam_list['revenue']."</td></tr>
											</table>
											
										</div>";
			
						if($k % 6 == 0){
									 $campaign_data.= "</td></tr><tr id='campaign_tr".$k."'><td>";	
									}
									$k++;
									
			
		}
		$campaign_data.= "</td>									
									</tr>
									</table>";
		}
		else
		{
			$campaign_data=" No Records Found";
		}
		
		echo $campaign_data;
		
		
	}
	
	
	public function fetch_selected_campaign($campaignid)
	{
		
		$api_key = get_session('api_key'); 
		
		$input = array('api_key'=>$api_key);
					  
		$input['campaignid'] = $campaignid;
					
		$campaign_list			= $this->rest->get('api/v1/campaign/fetch_selected_campaign_list',$input,'php');
		//$this->rest->debug();		
		$cam_list=$campaign_list[0];		
		$file_available=1;
										
			//$file_url=$this->config->item('creative_path').$cam_list['filename'];										
			/*$file_url=$this->config->item('base_url').$cam_list['dj_image_path'].$cam_list['filename'];							
			$file_headers = @get_headers($file_url);

            if( $file_headers[0]=='HTTP/1.1 404 Not Found')
			{
				$file_available=2;
									  
			}
			else
			{
				$file_available=1;										
			}*/
			if(isset($cam_list['storagetype']))
		{
		    $store_type = $cam_list['storagetype'];
			
			if($store_type=='url')//URL STORAGE 
			{
			  //$creative_filename	=	$cam_list['imageurl'];
			  $file_name = $this->config->item('creative_upload_path').$cam_list['imageurl'];										
																		
										$file_available=1;
										
										$file_url=$this->config->item('base_url').$cam_list['dj_image_path'].$cam_list['imageurl'];										
										
										$file_headers = @get_headers($file_url);
										
										if( $file_headers[0]=='HTTP/1.1 404 Not Found')
										{
										   $file_available=2;
											  
										}
										else
										{
											$file_available=1;										
										}
			}
			elseif($store_type=='web')//WEB STORAGE 
			{
			  $file_name = $this->config->item('creative_upload_path').$cam_list['filename'];										
																		
										$file_available=1;
										
										$file_url=$this->config->item('base_url').$cam_list['dj_image_path'].$cam_list['filename'];										
										
										$file_headers = @get_headers($file_url);
										
										if( $file_headers[0]=='HTTP/1.1 404 Not Found')
										{
										   $file_available=2;
											  
										}
										else
										{
											$file_available=1;										
										}
			}
			else 
			{
			  $store_type='';
			  $file_name = $this->config->item('creative_upload_path').$cam_list['filename'];										
																		
										$file_available=1;
										
										$file_url=$this->config->item('base_url').$cam_list['dj_image_path'].$cam_list['filename'];										
										
										$file_headers = @get_headers($file_url);
										
										if( $file_headers[0]=='HTTP/1.1 404 Not Found')
										{
										   $file_available=2;
											  
										}
										else
										{
											$file_available=1;										
										}
			}
		}
		else 
		{
		   $store_type='';
		   $file_name = $this->config->item('creative_upload_path').$cam_list['filename'];										
																		
										$file_available=1;
										
										$file_url=$this->config->item('base_url').$cam_list['dj_image_path'].$cam_list['filename'];										
										
										$file_headers = @get_headers($file_url);
										
										if( $file_headers[0]=='HTTP/1.1 404 Not Found')
										{
										   $file_available=2;
											  
										}
										else
										{
											$file_available=1;										
										}
		}
			
		if(isset($cam_list['url']))
		{
		  $url	=	$cam_list['url'];
		}
		else
		{
		  $url="N/A";
		}
		if($cam_list['banner_type']=="V_OL" ||$cam_list['banner_type']=="V_IN" || $cam_list['banner_type']=="V_RD" || $cam_list['banner_type']=="V_SM" || $cam_list['banner_type']=="V_HEAD" || $cam_list['banner_type']=="V_BOX"){
		$campaigns_data.='<script type="text/javascript" src="'.base_url($this->config->item("theme_file_path")).'/js/jwplayer.js"></script>';
	}
		$campaigns_data .= '<div style="float:right;margin-right:5px;"><a class="collapse-campaign" id="close_button">X</a></div><table width="100%" border="0" cellspacing="0" cellpadding="4"><tbody><tr><td style="width: 300px">';
											if($cam_list['banner_type']=="W_POP"){
												$campaigns_data.='<div class="fileupload-new thumbnail" style="width:80%;">
							<a href="'.$url.'" target="_blank">
								'.$url.'
							</a>
						</div>'; 
												}
												elseif(($cam_list['banner_type']=="W_SL" || $cam_list['banner_type']=='W_LAY') && $cam_list['storagetype']=='url'){
												$campaigns_data.='<div class="fileupload-new thumbnail" style="width:80%;">
							<a href="'.$cam_list['imageurl'].'" target="_blank">
								'.$cam_list['imageurl'].'
							</a>
						</div>	';
												}
												elseif($cam_list['contenttype']=='html'){
													if (preg_match("/<script\b[^>]*>/i",$cam_list['htmltemplate']))
												{
													$campaigns_data.='<div style="width:80%;text-align:justify">
										<textarea rows="8" id="html_content" class="span12" name="html_content">'.$cam_list['htmltemplate'].'</textarea>
									</div>';
												}
												else{
													$campaigns_data.='<div class="fileupload-new thumbnail" style="width:80%;">
										'.$cam_list['htmltemplate'].'
									</div>';
												}
												}
												elseif($cam_list['banner_type']=="W_SWF" ){
												$campaigns_data.='<img id="creative_image" style="" src="'.$file_url.'" width="300" height="250" alt="Tag">';
						}
						elseif($cam_list['banner_type']=="V_OL"){
							
							$video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$cam_list['bannerid']),'php');
							if(($video_details != '' || $video_details != null) ){
							$campaigns_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="Element'.$cam_list['bannerid'].'">Loading video player</div>
									</div>';
								}
								else{
									$video_type_details	= 	$this->rest->get('api/v1/campaign/fetch_video_overlay_details',array("api_key"=>$api_key,"bannerid"=>$cam_list['bannerid']),'php');
								//$this->rest->debug();
								$overlay_format =$video_type_details[0]['overlay_format']; 
								//print_r($video_type_details);
								if($overlay_format == 'image_overlay'){
								$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];
									if($video_type_details[0]['over_wid'] <= 500){
									$reduce_over_width = $video_type_details[0]['over_wid']/1;
									}
									else{
										$reduce_over_width = $video_type_details[0]['over_wid']/1;
									}
									if($video_type_details[0]['over_height'] <= 500){
									$reduce_over_height = $video_type_details[0]['over_height']/1;
									}
									else{
										$reduce_over_height  = $video_type_details[0]['over_height']/1;
									}			
								$campaigns_data.='<img id="creative_image" style="" src="'.$file_img_over.'" width="'.$reduce_over_width.'" height="'.$reduce_over_height.'" alt="Tag">';	
								}
								else if($overlay_format == 'swf_overlay'){
									$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];
									if($video_type_details[0]['over_wid'] <= 500){
									$reduce_over_width = $video_type_details[0]['over_wid']/1;
									}
									else{
										$reduce_over_width = $video_type_details[0]['over_wid']/1;
									}
									if($video_type_details[0]['over_height'] <= 500){
									$reduce_over_height = $video_type_details[0]['over_height']/1;
									}
									else{
										$reduce_over_height  = $video_type_details[0]['over_height']/1;
									}
									
									$campaigns_data.='<object width="'.$reduce_over_width.'" height="'.$reduce_over_height.'">
							<param name="movie" value="'.($cam_list['storagetype']!='url')?($file_img_over):$cam_list['filename'].'">
								<embed src="'.($cam_list['storagetype']!='url')?($file_img_over):$cam_list['filename'].'" width="'.$reduce_over_width.'" height="'.$reduce_over_height.'">
								</embed>
							</param>
						</object>';	
								}
								else{
									$campaigns_data.='<label style="font-size: 14px;">'.$video_type_details[0]['text_description'].'</label>'; 
								}
									
								}
						}
						elseif($cam_list['banner_type']=="V_IN" || $cam_list['banner_type']=="V_RD" || $cam_list['banner_type']=="V_SM" || $cam_list['banner_type']=="V_HEAD" || $cam_list['banner_type']=="V_BOX"){
							
							
						$campaigns_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="Element'.$cam_list['bannerid'].'">Loading video player</div>
									</div>';
						}
												elseif($cam_list['contenttype']=='swf'){
												$campaigns_data.='<object width="100%" height="30%">
							<param name="movie" value="'.($store_type!='url')?($file_url):$cam_list['filename'].'">
								<embed src="'.($store_type!='url')?($file_url):$cam_list['filename'].'" width="100%" height="30%">
								</embed>
							</param>
						</object>';	
												}
												else if($cam_list['filename'] == '' && $cam_list['contenttype'] == 'txt'){
						$campaigns_data.='<label style="font-size: 14px;">'.$cam_list['bannertext'].'</label>';  
					  }
											else if($file_available=='1' && $cam_list['filename']!='')
												{
												$campaigns_data.="<img  src='".$file_url;
												$campaigns_data.="' width='300' height='250' alt='Campaign Logo'>";  
												}
												else
												{
												$campaigns_data.="<img src='".$this->config->item('creative_path')."transparent.png";
												$campaigns_data.="'  width='300'  height='250'  style='border:#ccc solid 2px'>";												
												}
										$campaigns_data.='</td><td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tbody><tr><td style="text-align: left; height: 30px" class="page_title">'  
													.$cam_list['campaignname'].' </td></tr></tbody></table>';											
										$campaigns_data.=	'</td></tr><tr><td colspan="2"><hr></td></tr></tbody></table><div class="tabs ui-tabs ui-widget ui-widget-content ui-corner-all" style="min-height: 400px;">';
										
										if($cam_list['favourite_status'] == 0){
										$campaigns_data.='<button type="button" class="favorites_btn_on favorites_btn off ui-button btn-gradient" style="float: right; display: block;width:150px;height:40px;" onclick="Add_to_favourites('.$cam_list['campaignid'].','.$cam_list['favourite_status'].',this);">Add to favorites</button>';
										}else{
										$campaigns_data.='<button type="button" class="favorites_btn_on favorites_btn on ui-button ui-button-grey" style="float: right;width:150px;height:40px;display: block !important" onclick="Add_to_favourites('.$cam_list['campaignid'].','.$cam_list['favourite_status'].',this);">Remove from favorites</button>';
										}
										$campaigns_data.='<ul class="tabs tabs-inline tabs-top" style="background: #ddd">
												<li class="active">
													<a data-toggle="tab" href="#campaign_payouts_tab">Payouts</a>
												</li>
												<li>
													<a data-toggle="tab" href="#creatives_tab">Banners</a>
												</li>												
											</ul>';	
								                if($cam_list['banner_type']=="V_OL" || $cam_list['banner_type']=="V_IN" || $cam_list['banner_type']=="V_RD" || $cam_list['banner_type']=="V_SM" || $cam_list['banner_type']=="V_HEAD" || $cam_list['banner_type']=="V_BOX"){
			                                     $video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$cam_list['bannerid']),'php');
			//$this->rest->debug();
			
			if(($video_details != '' || $video_details != null) ){
				$video_filename	=	$video_details[0]['video_filename'];
				$video_ext 		= 	strtolower(substr($video_filename, strrpos($video_filename, '.') + 1));
					if(($video_ext == 'mp4' || $video_ext == 'flv')){
					$campaigns_data.='<script>var filename = "'.$video_filename.'";
					jwplayer("Element'.$cam_list['bannerid'].'").setup({		
						file: filename,
						width: "100%",
						height:250
					});</script>';	
					}
			}
			}
			$campaigns_data.='<div class="tab-content padding tab-content-inline tab-content-bottom"><div id="campaign_payouts_tab" class="tab-pane active">												
												<table id="payout-table">';
										$country_bidding_details	= $this->rest->get('api/v1/campaign/fetch_campaign_country_bidding',array("api_key"=>$api_key,"campaign_id"=>$campaignid),'php');			  
										
										//echo $this->rest->debug();
										//print_r($country_bidding_details);  die("dsffsdaf");
									
										foreach($country_bidding_details as $ctr)
										{       
												$cam_type = array("1"=>"Impression", "2"=>"Clicks", "3"=>"Conversion","4"=>"Cost per lead","5"=>"Cost per sale","6"=>"Installation");
												$campaigns_data.='
												<tr>
												<td valign="top" style="padding-bottom:5px; padding-right:20px"><b>'.$ctr['bidding_value'].'</b> USD</td>
												<td valign="top" style="padding-bottom:5px; padding-right:20px">'.$cam_type[$ctr['revenue_type']].'</td>
												<td valign="top" style="padding-bottom:5px; padding-right:5px">'.$ctr['country_value'].'</td>
												</tr>';
										}	  


										$campaigns_data.='</table></div>
										<div id="creatives_tab" class="tab-pane">
										<div id="campaign-browser" class="" style="display: block;color:black">
										<table width="100%" border="0" cellpadding="0" cellspacing="0">
										<tbody><tr>
									    <td width="21%" valign="top" style="vertical-align: top;">
										<table width="100%" border="0" cellspacing="0" cellpadding="0">
										  <tbody>
										  <tr>
											<td height="30" valign="bottom">
											  <label>Available Formats</label>
											</td>
										  </tr>
										  <tr>
											<td valign="top">
											  <select style="width:95%" name="creatives_formats" size="8" id="creatives_formats" onchange="Display_Selected_Size('.$campaignid.',this.value,all);">
											  <option value="all">All</option>';
											  $size_details	= $this->rest->get('api/v1/campaign/fetch_campaign_creative_size',array("api_key"=>$api_key,"campaign_id"=>$campaignid),'php');			  
											  
				         foreach($size_details as $cre_size){
							 if($cre_size['width'] == '-2' || $cre_size['height'] == '-2'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Overlay</option>';
								 
					}
					elseif($cre_size['width'] == '-3' || $cre_size['height'] == '-3'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Inline</option>';
								 
					}
					elseif($cre_size['width'] == '-5' || $cre_size['height'] == '-5'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Read</option>';
								 
					}
					elseif($cre_size['width'] == '-6' || $cre_size['height'] == '-6'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Small</option>';
								 
					}
					elseif($cre_size['width'] == '-7' || $cre_size['height'] == '-7'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Box</option>';
								 
					}
					elseif($cre_size['width'] == '-8' || $cre_size['height'] == '-8'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Head</option>';
								 
					}else{
					  $campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">'.$cre_size['width'].'x'.$cre_size['height'].'</option>';
					}
				  }
					$campaigns_data.='</select>
                </td>
				</tr>
				<tr>
					<td height="30" valign="bottom">
				    <label>Available Languages</label>
					</td>
         		</tr>
				<tr>
					<td valign="top">
				    <select name="all_languages" id="all_languages" size="8" onchange="Display_Selected_Size('.$campaignid.',all,this.value);">
					<option value="all">All</option>';
						 $lang_details	= $this->rest->get('api/v1/campaign/fetch_campaign_language',array("api_key"=>$api_key),'php');			  
						 foreach($lang_details as $lang)
						 {						 
						  $campaigns_data.='<option value="'.$lang['lan_flip'].'">'.$lang['language'].'</option>';
				  }
             $campaigns_data.='</select>
                </td>
              </tr>
               </tbody></table>
          </td>
          <td width="1%" valign="top">&nbsp;</td><td width="78%" valign="top">
            <div id="creatives-container">';          
          $banner_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign_banner',array("api_key"=>$api_key,"campaign_id"=>$campaignid),'php');
		//$this->rest->debug();		
		foreach($banner_details as $banner){
			if($banner['width'] <= 500){
			$reduce_width = $banner['width']/2;
			}
			else{
				$reduce_width = $banner['width']/3;
			}
			if($banner['height'] <= 500){
			$reduce_height = $banner['height']/2;
			}
			else{
				$reduce_width = $banner['height']/3;
			}
			
			if(isset($banner['imageid']))
			{
				$image_id=$banner['imageid'];
			}
			else
			{
				$image_id=0;
			}
			
			$ban_id=$banner['bannerid'];
			if(isset($banner['url']))
				{
				  $url	=	$banner['url'];
				}
				else
				{
				  $url="N/A";
				}
				if($banner['banner_type']=="V_OL" ||$banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
		$campaigns_data.='<script type="text/javascript" src="'.base_url($this->config->item("theme_file_path")).'/js/jwplayer.js"></script>';
	}
			$file_path_img=$this->config->item('base_url').$banner['dj_image_path'].$banner['filename'];			
			$campaigns_data.='<div class="creative_base" id="creative-'.$banner['bannerid'].'">
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tbody><tr>
                    <td  height ="90" align="center" valign="middle" style="text-align: center;" onclick="display('.$ban_id.','.$image_id.');">';
                    if($banner['banner_type']=="W_POP"){
						$campaigns_data.='<div  style="font-size: 14px; overflow-wrap: break-word;word-wrap: break-word;-ms-word-break: break-all;word-break: break-all;word-break: break-word;-ms-hyphens: auto;-moz-hyphens: auto;-webkit-hyphens: auto;hyphens: auto;">
							<a href="'.$banner['url'].'" target="_blank">
								'.$banner['url'].'
							</a>
						</div>'; 
					}
					elseif(($banner['banner_type']=="W_SL" || $banner['banner_type']=='W_LAY') && $banner['storagetype']=='url'){
						$campaigns_data.='<div  style="font-size: 14px;">
							<a href="'.$banner['imageurl'].'" target="_blank">
								'.$banner['imageurl'].'
							</a>
						</div>	';
					}
					elseif($banner['contenttype']=='html'){
						if (preg_match("/<script\b[^>]*>/i",$banner['htmltemplate']))
						{
							$campaigns_data.='<div style="text-align:justify">
										<textarea rows="8" id="html_content" class="span12" name="html_content">'.$banner['htmltemplate'].'</textarea>
									</div>';
						}
						else{
							$campaigns_data.='<div  style="font-size: 14px;">
										'.$banner['htmltemplate'].'
									</div>';
					}
				}
				elseif($banner['banner_type']=="W_SWF" ){
					$campaigns_data.='<img id="creative_image" style="" src="'.$file_path_img.'" width="'.$reduce_width.'" height="'.$reduce_height.'" alt="Tag">';
				}
				elseif($banner['banner_type']=="V_OL"){
							
							$video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
							if(($video_details != '' || $video_details != null) ){
							$campaigns_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="myElement'.$banner['bannerid'].'">Loading video player</div>
									</div>';
								}
								else{
									$video_type_details	= 	$this->rest->get('api/v1/campaign/fetch_video_overlay_details',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
								//$this->rest->debug();
								$overlay_format =$video_type_details[0]['overlay_format']; 
								//print_r($video_type_details);
								if($overlay_format == 'image_overlay'){
								$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];
									if($video_type_details[0]['over_wid'] <= 500){
									$reduce_over_width = $video_type_details[0]['over_wid']/2;
									}
									else{
										$reduce_over_width = $video_type_details[0]['over_wid']/3;
									}
									if($video_type_details[0]['over_height'] <= 500){
									$reduce_over_height = $video_type_details[0]['over_height']/2;
									}
									else{
										$reduce_over_height  = $video_type_details[0]['over_height']/3;
									}			
								$campaigns_data.='<img id="creative_image" style="" src="'.$file_img_over.'" width="'.$reduce_over_width.'" height="'.$reduce_over_height.'" alt="Tag">';	
								}
								else if($overlay_format == 'swf_overlay'){
									$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];
									if($video_type_details[0]['over_wid'] <= 500){
									$reduce_over_width = $video_type_details[0]['over_wid']/2;
									}
									else{
										$reduce_over_width = $video_type_details[0]['over_wid']/3;
									}
									if($video_type_details[0]['over_height'] <= 500){
									$reduce_over_height = $video_type_details[0]['over_height']/2;
									}
									else{
										$reduce_over_height  = $video_type_details[0]['over_height']/3;
									}
									
									$campaigns_data.='<object width="'.$reduce_over_width.'" height="'.$reduce_over_height.'">
							<param name="movie" value="'.($banner['storagetype']!='url')?($file_img_over):$banner['filename'].'">
								<embed src="'.($banner['storagetype']!='url')?($file_img_over):$banner['filename'].'" width="'.$reduce_over_width.'" height="'.$reduce_over_height.'">
								</embed>
							</param>
						</object>';	
								}
								else{
									$campaigns_data.='<label style="font-size: 14px;">'.$video_type_details[0]['text_description'].'</label>'; 
								}
									
								}
						}
						elseif($banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
							
							
						$campaigns_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="myElement'.$banner['bannerid'].'">Loading video player</div>
									</div>';
						}
				elseif($banner['contenttype']=='swf'){
					$campaigns_data.='<object width="'.$reduce_width.'" height="'.$reduce_height.'">
							<param name="movie" value="'.($banner['storagetype']!='url')?($file_path_img):$banner['filename'].'">
								<embed src="'.($banner['storagetype']!='url')?($file_path_img):$banner['filename'].'" width="'.$reduce_width.'" height="'.$reduce_height.'">
								</embed>
							</param>
						</object>';	
				}
                else if($banner['filename'] != '' && $banner['contenttype'] != 'swf'){
                      $campaigns_data.='<img id="creative_image" style="" src="'.$file_path_img.'" width="'.$reduce_width.'" height="'.$reduce_height.'" alt="Tag">';
                }
                else if($banner['filename'] != '' && $banner['contenttype'] == 'swf'){
					$campaigns_data.='<object width="'.$reduce_width.'" height="'.$reduce_height.'" >
									<param name="SRC" value="'.$banner['filename'].'">
									<embed src="'.$file_path_img.'" id="creative_image" width="'.$reduce_width.'" height="'.$reduce_height.'"></embed>
								</object>'; 
				}
                else if($banner['filename'] == '' && $banner['contenttype'] == 'txt'){
					$campaigns_data.='<label style="font-size: 14px;">'.$banner['bannertext'].'</label>';  
				}
                else{
					$campaigns_data.='<img id="creative_image" style="" src="'.$file_path_img.'" width="'.$reduce_width.'" height="'.$reduce_height.'" alt="Tag">';
				}
                   $campaigns_data.='</td>
                  </tr>
                  <tr>';
                  
                     if($banner['width'] == '-2' || $banner['height'] == '-2'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Overlay</td>';
								 
					}
					elseif($banner['width'] == '-3' || $banner['height'] == '-3'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Inline</td>';
								 
					}
					elseif($banner['width'] == '-5' || $banner['height'] == '-5'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Read</td>';
								 
					}
					elseif($banner['width'] == '-6' || $banner['height'] == '-6'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Small</td>';
								 
					}
					elseif($banner['width'] == '-7' || $banner['height'] == '-7'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Box</td>';
								 
					}
					elseif($banner['width'] == '-8' || $banner['height'] == '-8'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Head</td>';
								 
					}else{
                    $campaigns_data.='<td align="center" valign="middle" class="creative_size_text">'.$banner['width'].'x'.$banner['height'].'</td>';
					}
                  $campaigns_data.='</tr>
                </tbody></table>
              </div>';
		   if($banner['banner_type']=="V_OL" || $banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
			$video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
			//$this->rest->debug();
			
			if(($video_details != '' || $video_details != null) ){
				$video_filename	=	$video_details[0]['video_filename'];
				$video_ext 		= 	strtolower(substr($video_filename, strrpos($video_filename, '.') + 1));
					if(($video_ext == 'mp4' || $video_ext == 'flv')){
					$campaigns_data.='<script>var filename = "'.$video_filename.'";
					jwplayer("myElement'.$banner['bannerid'].'").setup({		
						file: filename,
						width: "100%",
						height:100
					});</script>';	
					}
			}
			}
		}					
		 $campaigns_data.='</div>
          </td>
        </tr>
      </tbody></table>
    </div><div id="modal"></div><div id="campaign_creatives" class="campaign-creatives">

          </div>
        </div></div>
		</div>
        <script>
      jQuery(document).ready(function() {
			$(".creative_base img").hover(function() {
				$(this).addClass("transition");
 
			}, function() {
				$(this).removeClass("transition");
			});
			
			});
			
			$("#close_button").click(function(){
			$("#campaign_details").hide();
			}); 
			
			</script>';
			echo $campaigns_data;				
		
	}
	
	/*
	 * Lists the creative size of selected adsize
	 * 
	 * name		:selected adsize
	 * @param   :Null
	 * @return  :Lists the creative of selected adsize
	 * 
	 * 			 
	 */	
	
	function selected_adsize()
	{
		$api_key 	    = get_session('api_key'); 
		
		$campaignid = $_POST['campaignid'];
		$adsize = $_POST['adsize'];
		$lang=$_POST['ad_lang'];
		
		$input = array(
					    'api_key'=>$api_key	,
						'campaignid'=>$campaignid
					  );
					  
		if($adsize != 'all' && $adsize!='')
		{	 
			$ad_size=explode("x",$adsize);			
			$adwidth=$ad_size[0];
			$adheight=$ad_size[1];
			$input['width'] = $adwidth;	
			$input['height']=$adheight;			
		}
		else
		{  
			$input['width']="all";
			$input['height']="all";
		}	

		if($lang!='' && $lang!='all')
		{ 
			$input['lang']=$lang;
		}
		else
		{  
			$input['lang']="all";
		}  
		
						
		$banner_list			= $this->rest->get('api/v1/campaign/fetch_adsize_list',$input,'php');
		
							 
		foreach ($banner_list as $banner_data)
		{
			$campaignid=$banner_data['campaignid'];
			$width=$banner_data['width'];
			$height=$banner_data['height'];
			$ad_size=$width."x".$height;		
		}	
		
		//echo $this->rest->debug();
		//print_r($banner_list);  die("testing");     
																
	$campaigns_data.='<div id="campaign-browser" class="" style="display: block;color:black">
      <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tbody><tr>
          <td width="21%" valign="top" style="vertical-align: top;">
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
              <tbody><tr>
                <td height="30" valign="bottom">
                  <label>Available Formats</label>
                </td>
              </tr>
              <tr>
                <td valign="top">
                  <select name="creatives_formats" style="width:95%" size="8" id="creatives_formats" onchange="Display_Selected_Size('.$campaignid.',this.value,all);">';
				  if($input['width']=="all" && $input['height']=="all")
				  {
					  $campaigns_data.='<option selected value="all">All</option>';
				  }
				  else
				  {
					  $campaigns_data.='<option value="all">All</option>';
				  }
                  
                  $size_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign_creative_size',array("api_key"=>$api_key,"campaign_id"=>$campaignid),'php');
				  
				  
                  foreach($size_details as $cre_size){
					  
					 // echo "1--->".$width;  echo "<br/>";
					  //echo "2--->".$height; echo "<br/>";
					  
					  //print_r($cre_size['width']); echo "<br/>";
					  
					  //print_r($cre_size['height']);  echo "<br/>";
					  if($width==''){$width=$input['width'];}				  
					  if($height==''){$height=$input['height'];}
					  
					  if($cre_size['width']==$width && $cre_size['height']==$height && $input['width']!='all' && $input['height']!='all')
					  { 
						  if($cre_size['width'] == '-2' || $cre_size['height'] == '-2'){
						$campaigns_data.='<option selected value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Overlay</option>';
								 
						}
						elseif($cre_size['width'] == '-3' || $cre_size['height'] == '-3'){
						$campaigns_data.='<option selected value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Inline</option>';
								 
						}
						elseif($cre_size['width'] == '-5' || $cre_size['height'] == '-5'){
						$campaigns_data.='<option selected value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Read</option>';
								 
						}
						elseif($cre_size['width'] == '-6' || $cre_size['height'] == '-6'){
						$campaigns_data.='<option selected bvalue="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Small</option>';
								 
						}
						elseif($cre_size['width'] == '-7' || $cre_size['height'] == '-7'){
						$campaigns_data.='<option selected value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Box</option>';
								 
						}
						elseif($cre_size['width'] == '-8' || $cre_size['height'] == '-8'){
						$campaigns_data.='<option selected value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Head</option>';
								 
						}else{
						  $campaigns_data.='<option selected value="'.$cre_size['width'].'x'.$cre_size['height'].'">'.$cre_size['width'].'x'.$cre_size['height'].'</option>';
					    }
					  }
					  else
					  {  
				         
						 if($cre_size['width'] == '-2' || $cre_size['height'] == '-2'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Overlay</option>';
								 
						}
						elseif($cre_size['width'] == '-3' || $cre_size['height'] == '-3'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Inline</option>';
								 
						}
						elseif($cre_size['width'] == '-5' || $cre_size['height'] == '-5'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Read</option>';
								 
						}
						elseif($cre_size['width'] == '-6' || $cre_size['height'] == '-6'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Small</option>';
								 
						}
						elseif($cre_size['width'] == '-7' || $cre_size['height'] == '-7'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Box</option>';
								 
						}
						elseif($cre_size['width'] == '-8' || $cre_size['height'] == '-8'){
						$campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">Video Head</option>';
								 
						}else{
						  $campaigns_data.='<option value="'.$cre_size['width'].'x'.$cre_size['height'].'">'.$cre_size['width'].'x'.$cre_size['height'].'</option>';
					    }
					  }
					  
				  }  
             $campaigns_data.='</select>
                </td>
              </tr>
			  <tr>
					<td height="30" valign="bottom">
				    <label>Available Languages</label>
					</td>
         		</tr>
				<tr>
					<td valign="top">
				    <select name="all_languages" id="all_languages" size="8" onchange="Display_Selected_Size('.$campaignid.',all,this.value);">
					<option value="all">All</option>';
						 $lang_details	= $this->rest->get('api/v1/campaign/fetch_campaign_language',array("api_key"=>$api_key),'php');			  
						 foreach($lang_details as $lang_det)
						 {	
						 	if($lang==$lang_det['lan_flip'])
							{
								$campaigns_data.='<option selected value="'.$lang_det['lan_flip'].'">'.$lang_det['language'].'</option>';
							}
							else
							{
								$campaigns_data.='<option value="'.$lang_det['lan_flip'].'">'.$lang_det['language'].'</option>';
							}
						  
						 }
					$campaigns_data.='</select>
                </td>
				</tr>
			  
               </tbody></table>
          </td>
          <td width="1%" valign="top">&nbsp;</td><td width="78%" valign="top">
            <div id="creatives-container">';
          
		  
          $banner_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign_banner_display',array("api_key"=>$api_key,"campaign_id"=>$campaignid,"width"=>$input['width'],"height"=>$input['height'],"lang"=>$input['lang']),'php');			
			//echo $this->rest->debug(); die("test");    
		  foreach($banner_details as $banner){
			if($banner['width'] <= 500){
			$reduce_width = $banner['width']/2;
			}
			else{
				$reduce_width = $banner['width']/3;
			}
			if($banner['height'] <= 500){
			$reduce_height = $banner['height']/2;
			}
			else{
				$reduce_width = $banner['height']/3;
			}
			if($banner['banner_type']=="V_OL" ||$banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
		$campaigns_data.='<script type="text/javascript" src="'.base_url($this->config->item("theme_file_path")).'/js/jwplayer.js"></script>';
	}
			$file_path_img=$this->config->item('base_url').$banner['dj_image_path'].$banner['filename'];
			$campaigns_data.='<div class="creative_base" id="creative-'.$banner['bannerid'].'">
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tbody><tr>
                    <td  height ="90" align="center" valign="middle" style="text-align: center;" onclick="display('.$banner['bannerid'].','.$banner['imageid'].');">';
                      if($banner['banner_type']=="W_POP"){
						$campaigns_data.='<div  style="font-size: 14px; overflow-wrap: break-word;word-wrap: break-word;-ms-word-break: break-all;word-break: break-all;word-break: break-word;-ms-hyphens: auto;-moz-hyphens: auto;-webkit-hyphens: auto;hyphens: auto;">
							<a href="'.$banner['url'].'" target="_blank">
								'.$banner['url'].'
							</a>
						</div>'; 
					}
					elseif(($banner['banner_type']=="W_SL" || $banner['banner_type']=='W_LAY') && $banner['storagetype']=='url'){
												$campaigns_data.='<div  style="font-size: 14px;">
							<a href="'.$banner['imageurl'].'" target="_blank">
								'.$banner['imageurl'].'
							</a>
						</div>	';
					}
					elseif($banner['contenttype']=='html'){
						if (preg_match("/<script\b[^>]*>/i",$banner['htmltemplate']))
						{
							$campaigns_data.='<div style="text-align:justify">
										<textarea rows="8" id="html_content" class="span12" name="html_content">'.$banner['htmltemplate'].'</textarea>
									</div>';
						}
						else{
							$campaigns_data.='<div  style="font-size: 14px;">
										'.$banner['htmltemplate'].'
									</div>';
						}
					}
					elseif($banner['banner_type']=="W_SWF" ){
						$campaigns_data.='<img id="creative_image" style="" src="'.$file_path_img.'" width="'.$reduce_width.'" height="'.$reduce_height.'" alt="Tag">';
					}
					elseif($banner['banner_type']=="V_OL"){
							
							$video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
							if(($video_details != '' || $video_details != null) ){
							$campaigns_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="myElement'.$banner['bannerid'].'">Loading video player</div>
									</div>';
								}
								else{
									$video_type_details	= 	$this->rest->get('api/v1/campaign/fetch_video_overlay_details',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
								//$this->rest->debug();
								$overlay_format =$video_type_details[0]['overlay_format']; 
								//print_r($video_type_details);
								if($overlay_format == 'image_overlay'){
								$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];	
								if($video_type_details[0]['over_wid'] <= 500){
									$reduce_over_width = $video_type_details[0]['over_wid']/2;
									}
									else{
										$reduce_over_width = $video_type_details[0]['over_wid']/3;
									}
									if($video_type_details[0]['over_height'] <= 500){
									$reduce_over_height = $video_type_details[0]['over_height']/2;
									}
									else{
										$reduce_over_height  = $video_type_details[0]['over_height']/3;
									}			
								$campaigns_data.='<img id="creative_image" style="" src="'.$file_img_over.'" width="'.$reduce_over_width.'" height="'.$reduce_over_height.'" alt="Tag">';	
								}
								else if($overlay_format == 'swf_overlay'){
									if($video_type_details[0]['over_wid'] <= 500){
									$reduce_over_width = $video_type_details[0]['over_wid']/2;
									}
									else{
										$reduce_over_width = $video_type_details[0]['over_wid']/3;
									}
									if($video_type_details[0]['over_height'] <= 500){
									$reduce_over_height = $video_type_details[0]['over_height']/2;
									}
									else{
										$reduce_over_height  = $video_type_details[0]['over_height']/3;
									}
									$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];
									$campaigns_data.='<object width="'.$reduce_over_width.'" height="'.$reduce_over_height.'">
							<param name="movie" value="'.($banner['storagetype']!='url')?($file_img_over):$banner['filename'].'">
								<embed src="'.($banner['storagetype']!='url')?($file_img_over):$banner['filename'].'" width="'.$reduce_over_width.'" height="'.$reduce_over_height.'">
								</embed>
							</param>
						</object>';	
								}
								else{
									$campaigns_data.='<label style="font-size: 14px;">'.$video_type_details[0]['text_description'].'</label>'; 
								}
									
								}
						}
						elseif( $banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
							
						$campaigns_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="myElement'.$banner['bannerid'].'">Loading video player</div>
									</div>';
						}
					elseif($banner['contenttype']=='swf'){
						$campaigns_data.='<object width="'.$reduce_width.'" height="'.$reduce_height.'">
							<param name="movie" value="'.($banner['storagetype']!='url')?($file_path_img):$banner['filename'].'">
								<embed src="'.($banner['storagetype']!='url')?($file_path_img):$banner['filename'].'" width="'.$reduce_width.'" height="'.$reduce_height.'">
								</embed>
							</param>
						</object>';	
					}
                    else if($banner['filename'] != '' && $banner['contenttype'] != 'swf'){
                      $campaigns_data.='<img id="creative_image" style="" src="'.$file_path_img.'" width="'.$reduce_width.'" height="'.$reduce_height.'" alt="Tag">';
                    }
                    else if($banner['filename'] != '' && $banner['contenttype'] == 'swf'){
						$campaigns_data.='<object width="'.$reduce_width.'" height="'.$reduce_height.'" >
									<param name="SRC" value="'.$banner['filename'].'">
									<embed src="'.$file_path_img.'" id="creative_image" width="'.$reduce_width.'" height="'.$reduce_height.'"></embed>
								</object>'; 
					}
                    else if($banner['filename'] == '' && $banner['contenttype'] == 'txt'){
						$campaigns_data.='<label style="font-size: 14px;">'.$banner['bannertext'].'</label>';  
					}
                   else{
					    $campaigns_data.='<img id="creative_image" style="" src="'.$file_path_img.'" width="'.$reduce_width.'" height="'.$reduce_height.'" alt="Tag">';
				   }
                   $campaigns_data.='</td>
                  </tr>
                  <tr>';
                  if($banner['width'] == '-2' || $banner['height'] == '-2'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Overlay</td>';
								 
					}
					elseif($banner['width'] == '-3' || $banner['height'] == '-3'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Inline</td>';
								 
					}
					elseif($banner['width'] == '-5' || $banner['height'] == '-5'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Read</td>';
								 
					}
					elseif($banner['width'] == '-6' || $banner['height'] == '-6'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Small</td>';
								 
					}
					elseif($banner['width'] == '-7' || $banner['height'] == '-7'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Box</td>';
								 
					}
					elseif($banner['width'] == '-8' || $banner['height'] == '-8'){
						$campaigns_data.='<td align="center" valign="middle" class="creative_size_text">Video Head</td>';
								 
					}else{
                    $campaigns_data.='<td align="center" valign="middle" class="creative_size_text">'.$banner['width'].'x'.$banner['height'].'</td>';
					}
                   $campaigns_data.='</tr>
                </tbody></table>
              </div>';
		   if($banner['banner_type']=="V_OL" || $banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
			$video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
			//$this->rest->debug();
				if(($video_details != '' || $video_details != null) ){
					$video_filename	=	$video_details[0]['video_filename'];
					//$campaigns_data.=$video_filename;
					$video_ext 		= 	strtolower(substr($video_filename, strrpos($video_filename, '.') + 1));
					if(($video_ext == 'mp4' || $video_ext == 'flv')){
					$campaigns_data.='<script>var filename = "'.$video_filename.'";
					jwplayer("myElement'.$banner['bannerid'].'").setup({		
						file: filename,
						width: "100%",
						height:100
					});</script>';	
					}
			 }
			}
		}					
		 $campaigns_data.='</div>
          </td>
        </tr>
      </tbody></table>
    </div><div id="modal"></div><div id="campaign_creatives" class="campaign-creatives">

          </div>
		  <script>
      jQuery(document).ready(function() {
			$(".creative_base img").hover(function() {
				$(this).addClass("transition"); 
			}, function() {
				$(this).removeClass("transition");
			});			
			});
		</script>';
		  
		  echo $campaigns_data;						
		
	}
	
	function display_selected_ad($bannerid=false,$imageid=false,$size=false)
	{	
	
	$api_key 	    = get_session('api_key');    
	if($size !== "all"){
		$creative_size = explode('x',$size);
		$width = $creative_size[0];
		$height = $creative_size[1];
	}
	else
	{
		$width = "all";
		$height = "all";
	}	
	if(!empty($imageid) || $imageid != 0)
	{
		$banner_details	= 	$this->rest->get('api/v1/campaign/fetch_display_banner',array("api_key"=>$api_key,"bannerid"=>$bannerid,"imageid"=>$imageid,"width"=>$width,"height"=>$height),'php');
	}
	else
	{
		$banner_details	= 	$this->rest->get('api/v1/campaign/fetch_display_banner',array("api_key"=>$api_key,"bannerid"=>$bannerid,"width"=>$width,"height"=>$height),'php');
	}		
			
	$banner=$banner_details[0];	
	
	$linking_zone=$this->rest->get('api/v1/campaign/fetch_linking_zone',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');   
	
	$campaignid=$banner['campaignid'];
	if($banner['banner_type']=="V_OL" ||$banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
		$banners_data.='<script type="text/javascript" src="'.base_url($this->config->item("theme_file_path")).'/js/jwplayer.js"></script>';
	}
	$banners_data.='<div class="content" id="creative-preview" style="display: block;">
      <table width="100%" cellspacing="0" cellpadding="0" border="0">
        <tbody><tr>
          <td align="right">	
				<a id="banner_close_button"><img src="'.base_url().'/template/images/closeicon_new.png"></a>
		         </td>
        </tr>
        <tr>';      

		//die("sasasas");		
		$pagination_details	= $this->rest->get('api/v1/campaign/fetch_banner_count',array("api_key"=>$api_key,"campaign_id"=>$campaignid,"width"=>$width,"height"=>$height),'php');			
	//$this->rest->debug();
		$count_bannerid='';
		
		$bannerid=$banner['bannerid'];
		$image_id=$banner['imageid'];
		$count=count($pagination_details)-1;
		$page_array = array();
		foreach($pagination_details as $key=>$page)
		{
			$page_array[$key]['bannerid']=$page['bannerid'];
			$page_array[$key]['imageid']=$page['imageid'];
			//print_r($page_array);	
		}
		//print_r($pagination_details);
		$counts=count($page_array)-1;
		$find=$this->multidimensional_search($page_array, array('bannerid'=>$bannerid, 'imageid'=>$image_id));
		if(!empty($imageid))
		{
			foreach($pagination_details as $page)
			{
				$count_bannerid[]=$page['bannerid'];
				$count_imageid[]=$page['imageid'];
			}
			
			$key=array_search($bannerid,$count_bannerid);
			$key2=array_search($image_id,$count_imageid);
		}
		else
		{
			foreach($pagination_details as $page)
			{
				$count_bannerid[]=$page['bannerid'];
				$count_imageid[]=$page['imageid'];
			}
			$key=array_search($bannerid,$count_bannerid);
			$key2=array_search($image_id,$count_imageid);
		}
				
		//print_r($bannerid);print_r($image_id);
		
		//print_r($find);
		$pre_status='';
		$next_status='';
		if($find>0)
		{
			$pre_status="Previous";
		}
		if($find<$counts)
		{
			$next_status="Next";
		}
		else{
			$next_status="";
		}
		
		if($find!=0)
		{
			$previous_bannerid=$count_bannerid[$key-1];
			$next_bannerid=$count_bannerid[$key+1];
			$previous_imageid=$count_imageid[$key2-1];
			$next_imageid=$count_imageid[$key2+1];
			
			$previous_bannid=$page_array[$find-1]['bannerid'];
			$next_bannid=$page_array[$find+1]['bannerid'];
			$previous_imaid=$page_array[$find-1]['imageid'];
			$next_imaid=$page_array[$find+1]['imageid'];
		}
		else
		{
			$next_bannerid=$count_bannerid[$key+1];
			$next_imageid=$count_imageid[$key2+1];
			
			$next_bannid=$page_array[$find+1]['bannerid'];
			$next_imaid=$page_array[$find+1]['imageid'];
		}	
				
		
		if(!empty($image_id))		
		{
			//$invocation_code='<textarea id="js_text" class="input-block-level ui-wizard-content valid" readonly="readonly" rows="1" onmouseover="this.focus();this.select()"><script type="text/javascript" src="'.$this->config->item("adverser_tags")."ads.js?id=".$bannerid.'&ban='.$image_id.'"></script></textarea>';
			$invocation_code='<textarea id="js_text" class="input-block-level ui-wizard-content valid" readonly="readonly" rows="1" onmouseover="this.focus();this.select()"><script type="text/javascript" src="'.$this->config->item("adverser_tags")."ads.js?id=".$bannerid.'&ban='.$image_id.'"></script></textarea>';
		}
		else
		{
		$invocation_code='<textarea id="js_text" class="input-block-level ui-wizard-content valid" readonly="readonly" rows="1" onmouseover="this.focus();this.select()"><script type="text/javascript" src="'.$this->config->item("adverser_tags").$bannerid.'.js"></script></textarea>';	
		}
		

		$banners_data.='<td valign="top" height="40" align="center">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody><tr style="color:black">
			    <input type="hidden" name="previous_banneid" id="previous_bannerid" value='.$previous_bannid.'>
				<input type="hidden" name="next_banneid" id="next_bannerid" value='.$next_bannid.'>
				<input type="hidden" name="previous_imgid" id="previous_imgid" value='.$previous_imaid.'>
				<input type="hidden" name="next_imgid" id="next_imgid" value='.$next_imaid.'>
                <td width="60" valign="bottom" align="right"><a id="previous-creative">'.$pre_status.'</a></td>
                <td width="20" valign="bottom" align="center" class="black_title">&nbsp;</td>';
                 if($banner['width'] == '-2' || $banner['height'] == '-2'){
						$banners_data.='<td valign="bottom" align="center" class="black_title" id="creative-title">Video Overlay</td>';
								 
					}
					elseif($banner['width'] == '-3' || $banner['height'] == '-3'){
						$banners_data.='<td valign="bottom" align="center" class="black_title" id="creative-title">Video Inline</td>';
								 
					}
					elseif($banner['width'] == '-5' || $banner['height'] == '-5'){
						$banners_data.='<td valign="bottom" align="center" class="black_title" id="creative-title">Video Read</td>';
								 
					}
					elseif($banner['width'] == '-6' || $banner['height'] == '-6'){
						$banners_data.='<td valign="bottom" align="center" class="black_title" id="creative-title">Video Small</td>';
								 
					}
					elseif($banner['width'] == '-7' || $banner['height'] == '-7'){
						$banners_data.='<td valign="bottom" align="center" class="black_title" id="creative-title">Video Box</td>';
								 
					}
					elseif($banner['width'] == '-8' || $banner['height'] == '-8'){
						$banners_data.='<td valign="bottom" align="center" class="black_title" id="creative-title">Video Head</td>';
								 
					}else{
						$banners_data.='<td valign="bottom" align="center" class="black_title" id="creative-title">'.$banner['width'].'x'.$banner['height'].'</td>';
					}
                $banners_data.='<td width="20" valign="bottom">&nbsp;</td>
                <td width="60" valign="bottom"><a id="next-creative">'.$next_status.'</a></td>
              </tr>
            </tbody>
			</table>
          </td>
        </tr>
        <tr>
          <td>
            <table width="100%" cellspacing="0" cellpadding="0" border="0">
              <tbody><tr>
                <td height="30" class="script-data">
                  <label style="color:black" >Invocation code:</label>
                </td>
              </tr>
              <tr class="script-data">
                <td style="color:black" class="blue_drop_area" id="creative-script">'.$invocation_code.'</td>
              </tr>
              </tbody>
			  </table>
          </td>
        </tr>

        <tr>
          <td>&nbsp;</td>
        </tr>
        <tr>
          <td valign="middle" style="color:black" align="center" id="creative-file">';
		  $file_path_img=$this->config->item('base_url').$banner['dj_image_path'].$banner['filename'];
		   if($banner['banner_type']=="W_POP"){
						$banners_data.='<div  style="font-size: 14px; overflow-wrap: break-word;word-wrap: break-word;-ms-word-break: break-all;word-break: break-all;word-break: break-word;-ms-hyphens: auto;-moz-hyphens: auto;-webkit-hyphens: auto;hyphens: auto;">
							<a href="'.$banner['url'].'" target="_blank">
								'.$banner['url'].'
							</a>
						</div>'; 
						}
						elseif(($banner['banner_type']=="W_SL" || $banner['banner_type']=='W_LAY') && $banner['storagetype']=='url'){
							$banners_data.='<div  style="font-size: 14px;">
							<a href="'.$banner['imageurl'].'" target="_blank">
								'.$banner['imageurl'].'
							</a>
							</div>	';
						}
						elseif($banner['contenttype']=='html'){
							if (preg_match("/<script\b[^>]*>/i",$banner['htmltemplate'])){
													$banners_data.='<div style="text-align:justify">
										<textarea rows="8" id="html_content" class="span12" name="html_content">'.$banner['htmltemplate'].'</textarea>
									</div>';
												}
												else{
													$banners_data.='<div  style="font-size: 14px;">
										'.$banner['htmltemplate'].'
									</div>';
							}
						}
												
						elseif($banner['banner_type']=="W_SWF" ){
												$banners_data.='<img  style="" src="'.$file_path_img.'" width="'.$banner['width'].'" height="'.$banner['height'].'" alt="Tag">';
						}
						elseif($banner['banner_type']=="V_OL"){
							
							$video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
							if(($video_details != '' || $video_details != null) ){
							$banners_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="myElements'.$banner['bannerid'].'">Loading video player</div>
									</div>';
								}
								else{
									$video_type_details	= 	$this->rest->get('api/v1/campaign/fetch_video_overlay_details',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
								//$this->rest->debug();
								$overlay_format =$video_type_details[0]['overlay_format']; 
								//print_r($video_type_details);
								if($overlay_format == 'image_overlay'){
								$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];				
								$banners_data.='<img style="" src="'.$file_img_over.'" width="'.$video_type_details[0]['over_wid'].'" height="'. $video_type_details[0]['over_height'].'" alt="Tag">';	
								}
								else if($overlay_format == 'swf_overlay'){
									$file_img_over=$this->config->item('base_url').$video_type_details[0]['dj_image_path'].$video_type_details[0]['filename'];
									$banners_data.='<object width="'.$video_type_details[0]['over_wid'].'" height="'. $video_type_details[0]['over_height'].'">
							<param name="movie" value="'.($banner['storagetype']!='url')?($file_img_over):$banner['filename'].'">
								<embed src="'.($banner['storagetype']!='url')?($file_img_over):$banner['filename'].'" width="'.$video_type_details[0]['over_wid'].'" height="'. $video_type_details[0]['over_height'].'">
								</embed>
							</param>
						</object>';	
								}
								else{
									$banners_data.='<label style="font-size: 14px;">'.$video_type_details[0]['text_description'].'</label>'; 
								}
									
								}
						}
						elseif($banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
							
							
						$banners_data.='<div class="fileupload-new thumbnail" style="width:100%;">
										<div id="myElements'.$banner['bannerid'].'">Loading video player</div>
									</div>';
						}
						elseif($banner['contenttype']=='swf'){
												$banners_data.='<object width="'.$banner['width'].'" height="'.$banner['height'].'">
							<param name="movie" value="'.($banner['storagetype']!='url')?($file_path_img):$banner['filename'].'">
								<embed src="'.($banner['storagetype']!='url')?($file_path_img):$banner['filename'].'" width="'.$banner['width'].'" height="'.$banner['height'].'">
								</embed>
							</param>
						</object>';	
						}
		  elseif($banner['filename'] != '' && $banner['contenttype'] != 'swf'){
		  $banners_data.='<img src="'.$file_path_img.'" width="'.$banner['width'].'" height="'.$banner['height'].'" alt="Creative">';
		  }
		  else if($banner['filename'] != '' && $banner['contenttype'] == 'swf'){
						$banners_data.='<object width="'.$banner['width'].'" height="'.$banner['height'].'" >
									<param name="SRC" value="'.$banner['filename'].'">
									<embed src="'.$file_path_img.'" width="'.$banner['width'].'" height="'.$banner['height'].'"></embed>
								</object>'; 
					  }
		   else if($banner['filename'] == '' && $banner['contenttype'] == 'txt'){
						$banners_data.='<label style="font-size: 14px;font-weight: bold;text-decoration: underline;">'.$banner['bannertext'].'</label>';  
					  }
		   else{
					    $banners_data.='<img  style="" src="'.$file_path_img.'" width="'.$banner['width'].'" height="'.$banner['height'].'" alt="Tag">';
				   }
         $banners_data.='</td>
        </tr>

        <tr>
          <td>&nbsp;</td>
        </tr>
         </tbody></table>
    </div>';
   if($banner['banner_type']=="V_OL" || $banner['banner_type']=="V_IN" || $banner['banner_type']=="V_RD" || $banner['banner_type']=="V_SM" || $banner['banner_type']=="V_HEAD" || $banner['banner_type']=="V_BOX"){
			$video_details	= 	$this->rest->get('api/v1/campaign/fetch_video_filename',array("api_key"=>$api_key,"bannerid"=>$banner['bannerid']),'php');
			//$this->rest->debug();
			
			if(($video_details != '' || $video_details != null) ){
				$video_filename	=	$video_details[0]['video_filename'];
				$video_ext 		= 	strtolower(substr($video_filename, strrpos($video_filename, '.') + 1));
					if(($video_ext == 'mp4' || $video_ext == 'flv')){
					$banners_data.='<script>var filename = "'.$video_filename.'";
					jwplayer("myElements'.$banner['bannerid'].'").setup({		
						file: filename,
						width: "50%",
						height:250
					});</script>';	
					}
			}
			}
			 $banners_data.='<script>
			$("#banner_close_button").click(function(){	
			$("#creative-preview").hide();
			$("#campaign-browser").show();
			//$("#creatives_tab").focus();
			$("#campaign_payouts_tab").focus();
			}); 
			
			$("#previous-creative").click(function(){			
			var previous_id=$("#previous_bannerid").val();
			var previous_imgid=$("#previous_imgid").val();
			display(previous_id,previous_imgid);
			});
			
			$("#next-creative").click(function(){			
			var next_id=$("#next_bannerid").val();
			var next_imgid=$("#next_imgid").val();
			display(next_id,next_imgid);
			});
			
			
			</script>';
		 		
	echo $banners_data;
		
	}
	
	
	/*
	 * Lists the creative size of selected campaign
	 * 
	 * name		:rotator
	 * @param   :Null
	 * @return  :Lists the creative size of selected campaign
	 * 
	 * 			 
	 */	
	
	public function rotator()
	{
		$campaign_ids = $_POST['campaign_list'];
		$website_id = $_POST['website_id'];
		
		$api_key = get_session('api_key');
		$data['campaign_id']			=	$campaign_ids;
		$data['website_id']			=	$website_id;
			
		$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_rotator_campaign',array("api_key"=>$api_key,"campaign_ids"=>$campaign_ids),'php');
		//echo $this->rest->debug();  die();
		$responsearray=array();
		$cam_details_array=array();$bannertypes=array();
		$i=0;
		foreach($campaign_details as $val){			
			
			$widtharray[$i]["width"] = $val['width'];
			$widtharray[$i]["height"] = $val['height'];
			$i++;
		}
		
		$k=0;
		foreach($campaign_details as $val){
			
			$cam_name[$k] = $val['campaignname'];
			
			$k++;
		}
		$campaign_name_array = array_map("unserialize", array_unique(array_map("serialize", $cam_name)));
		
		
		$width_height_array = array_map("unserialize", array_unique(array_map("serialize", $widtharray)));
		$data['width_height']			=	$width_height_array;
		
		$j=0;$t=0;
		foreach($width_height_array as $dim){
			
			$responsearray[$j]	= 	$this->rest->get('api/v1/campaign/fetch_exist_banner',array("api_key"=>$api_key,"campaign_ids"=>$campaign_ids,"width"=>$dim['width'],"height"=>$dim['height']),'php');
			
			$ss=$this->rest->get('api/v1/campaign/fetch_exist_banner',array("api_key"=>$api_key,"campaign_ids"=>$campaign_ids,"width"=>$dim['width'],"height"=>$dim['height']),'php');
			foreach($ss as $keys=>$values){
				$bannertypes[$t]	= 	$values;
				$t++;
			}
			$j++;
		}
		//print_r($responsearray); 
		
		foreach($responsearray as $key=>$res){
			//print_r($res);echo ":";echo "<br>";
			$cam_details_array[$key]['width']=$res[0]['width'];
			$cam_details_array[$key]['height']=$res[0]['height'];
			$cam_details_array[$key]['banner_type']=$res[0]['dj_banner_type'];
			$found_camp='';$notfound_camp='';
			$result=$this->fetch_banner_adblock_type($bannertypes,$res[0]['width'],$res[0]['height']);
			$cam_details_array[$key]['banner_types']=$result;
			foreach($campaign_name_array as $camp_name){
				
				
				if($this->find_campaign_name($res,"campaignname",$camp_name) == true){
					
					$found_camp = $found_camp.$camp_name.',';
				}
				else{
					
					$notfound_camp=$notfound_camp.$camp_name.',';
				}
				
				
			}
			//print_r($found_camp);echo " found ";echo "<br>";
			//print_r($notfound_camp);echo " not found ";echo "<br>";
			$cam_details_array[$key]['missing_campaign']=rtrim($notfound_camp,",");
			$cam_details_array[$key]['present_campaign']=rtrim($found_camp,",");
			
		}
		//print_r($cam_details_array);echo " cam ";echo "<br>";
		$data['campaign_details']	=	$cam_details_array;
		$data['campaign']			=	$campaign_details[0];
		
		$data['content']		= 	$this->load->view('campaigns/campaigns_getrotator',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);
	}
	/*
	 * Find campaign name form an array
	 * 
	 * name		:find_campaign_name
	 * @param   :Null
	 * @return  :Return the matching element from an array
	 * 
	 * 			 
	 */
	function find_campaign_name($array, $key, $val) {
    foreach ($array as $item)
        if (isset($item[$key]) && $item[$key] == $val)
            return true;
    return false;
	}
	
	/*
	 * Create new zone based on selected size and generate script tag
	 * 
	 * name		:zone_creator
	 * @param   :Null
	 * @return  :Create new zone based on selected size and generate script tag
	 * 
	 * 			 
	 */	
	
	public function zone_creator()
	{
		$campaign_ids = $_POST['campaign_list'];
		$website_id = $_POST['website_id'];
		$radio_format = $_POST['format'];
		$banner_format = $_POST['format_banner'];
		$api_key = get_session('api_key');
		$explode_radio=explode("@",$radio_format);
		
		$explode_banner=explode(":",$banner_format);
		$banner_type =$explode_banner[0];
		$campaign_id=$explode_banner[1];
		$campaigns_id=explode(",",$campaign_id);
		//$campaign_id=$explode_banner[2];
		if(empty($campaigns_id[count($campaigns_id)-1])) {
			unset($campaigns_id[count($campaigns_id)-1]);
		}
		//$banner_type=$explode_radio[1];
		$ad_block_size=$explode_radio[0];
		if($banner_type == 'W_SQL' || $banner_type == 'W_URL' || $banner_type == 'W_IMG' || $banner_type == 'W_HTML'|| $banner_type == 'W_SWF'){
			$zone_type= 'W_BAN';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'W_TEXT'){
			$zone_type= 'W_TEXT';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'W_POP'){
			$zone_type= 'W_A_PUP';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'W_LAY'){
			$zone_type= 'W_A_LAY';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'W_GB'){
			$zone_type= 'W_A_GB';
			$mobile_ad_type='';
		}
		else if($banner_type == 'W_BB'){
			$zone_type= 'W_A_BB';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'W_SL'){
			$zone_type= 'W_A_SL';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'W_CF'){
			$zone_type= 'W_A_CF';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'W_SS'){
			$zone_type= 'W_A_SS';
			$mobile_ad_type='';
			if($ad_block_size == '120x600'){
				$ad_block_type = 'LR';
			}
			else{
				$ad_block_type = 'BGD';
			}
		}
		else if($banner_type == 'M_IMG'){
			$zone_type= 'M_A_IM';
			$mobile_ad_type='basic';
			$ad_block_type = '';
		}
		else if($banner_type == 'M_TEXT'){
			$zone_type= 'M_A_TXT';
			$mobile_ad_type='basic';
			$ad_block_type = '';
		}
		else if($banner_type == 'M_MR_EXP'){
			$zone_type= 'M_A_EXD';
			$mobile_ad_type='mraid';
			$ad_block_type = '';
		}
		else if($banner_type == 'M_MR_REV'){
			$zone_type= 'M_A_RVL';
			$mobile_ad_type='mraid';
			$ad_block_type = '';
		}
		else if($banner_type == 'M_MR_INT'){
			$zone_type= 'M_A_INT';
			$mobile_ad_type='mraid';
			$ad_block_type = '';
		}
		else if($banner_type == 'M_RS_FL'){
			$zone_type= 'M_A_FX';
			$mobile_ad_type='rising';
			$ad_block_type = '';
		}
		else if($banner_type == 'M_RS_ADH'){
			$zone_type= 'M_A_AD';
			$mobile_ad_type='rising';
			$ad_block_type = '';
		}
		else if($banner_type == 'M_RS_PL'){
			$zone_type= 'M_A_PULL';
			$mobile_ad_type='rising';
			$ad_block_type = '';
			
		}
		else if($banner_type == 'M_RS_SL'){
			$zone_type= 'M_A_SLI';
			$mobile_ad_type='rising';
			$ad_block_type = 'top';
		}
		else if($banner_type == 'M_RS_FS'){
			$zone_type= 'M_A_FS';
			$mobile_ad_type='rising';
			$ad_block_type = 'top';
		}
		else if($banner_type == 'V_OL'){
					
			$zone_type= 'V_A_OL';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'V_IN'){
					
			$zone_type= 'V_A_IN';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'V_SM'){
					
			$zone_type= 'V_A_SM';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'V_RD'){
					
			$zone_type= 'V_A_RD';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'V_BOX'){
					
			$zone_type= 'V_A_BOX';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		else if($banner_type == 'V_HEAD'){
					
			$zone_type= 'V_A_HEAD';
			$mobile_ad_type='';
			$ad_block_type = '';
		}
		/*print_r($campaign_ids);echo "<br>";
		print_r($banner_format);echo "<br>";		
		print_r($campaigns_id);echo  "<br>";
		print_r($campaign_id);echo  "<br>";
		print_r($banner_type);echo "<br>";
		print_r($ad_block_size);echo "<br>";
		exit;*/
		
		$input = array(
						'api_key'		=>	$api_key,
						'choose_type'   => '1',
						'zone_type'			=>	$zone_type,
						'ad_block_size'	=>	$ad_block_size,
						'ad_block_type'		=>	$ad_block_type,
						'site_id'		=>	$website_id,
						'mobile_ad_type'		=>	$mobile_ad_type,
						'_adblock_id'		=>	'',
						'rotator'	=>			'Y'
					  );
		$res		= $this->rest->post('api/v1/site/add_ad_block',$input,'json');
		
		$json_decoded = json_decode($res);
		
		//print_r($json_decoded->adblock_id);
		$zoneid=$json_decoded->adblock_id;
		$adblock_type= $json_decoded->adblock_type;
		$zone_name='Rotator_adblock_'.$zoneid.'_'.$ad_block_size;
		$inputs = array(
						'api_key'		=>	$api_key,
						'_adblock_id'			=>	$zoneid,
						'select_cpm'	=>	'3',
						'fixed_cpm_rate'		=>	0,
						'site_id'		=>	$website_id,
						'fixed_system_cpm_rate'		=>	0,
						'adblock_name'		=>	$zone_name,
						'passback'		=>	'',
						'floor_price'		=>	'0.01'
					  );
					  
			$datas		= $this->rest->post('api/v1/site/complete_ad_block',$inputs,'json');	
			/*linking campaign banners with new zone created */  
			
			
			$responselinking	= 	$this->rest->get('api/v1/auto_link/link_rotator_camapign_ads',array("api_key"=>$api_key,"campaign_id"=>$campaigns_id,"zone_id"=>$zoneid,"size"=>$ad_block_size,"banner_type"=>$banner_type),'php');
			
			
			//echo $this->rest->debug();
			//print_r($responselinking);
			
						
			//$del_path= $this->config->item("adserving_url");
			$del_path= $this->config->item("adverser_tags");
			$adt_pre='<script type="text/javascript" src="'.$del_path;
			//$adt_suf		=	'?id='.$zoneid.'"></script>';
			$adt_suf		=	$zoneid.'.js"></script>';
			$adtag_url1=$adt_pre.$adt_suf;
			if($adblock_type == 'W_BAN'  || $adblock_type == 'W_TEXT'){
				$adtag_url=$adt_pre."banners.js".$adt_suf;
				
			}
			else if($adblock_type == 'W_A_PUP'){
				$adtag_url=$adt_pre."popup.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_PUN'){
				$adtag_url=$adt_pre."popunder.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_LAY'){
				$adtag_url=$adt_pre."layer.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_GB'){
				$adtag_url=$adt_pre."gamebox.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_BB'){
				$adtag_url=$adt_pre."bannerbox.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_SL'){
				$adtag_url=$adt_pre."slider.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_CF'){
				$adtag_url=$adt_pre."catfish.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_SS'){
				$adtag_url=$adt_pre."site-skin.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_IM' || $adblock_type == 'M_A_TXT'){
				$adtag_url=$adt_pre."mob_banners.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_INT'){
				$adtag_url=$adt_pre."mob_interstital.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_EXD'){
				$adtag_url=$adt_pre."mob_expand.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_RVL'){
				$adtag_url=$adt_pre."mob_reveal.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_FX'){
				$adtag_url=$adt_pre."mob_fullpage.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_AD'){
				$adtag_url=$adt_pre."mob_adhesion.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_FS'){
				$adtag_url=$adt_pre."mob_filmstrip.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_SLI'){
				$adtag_url=$adt_pre."mob_slider.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_PULL'){
				$adtag_url=$adt_pre."mob_pull.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_OL'){
				$adtag_url=$adt_pre."overlay.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_IN'){
				$adtag_url=$adt_pre."inline.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_RD'){
				$adtag_url=$adt_pre."readvid.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_SM'){
				$adtag_url=$adt_pre."smallvid.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_BOX'){
				$adtag_url=$adt_pre."boxvid.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_HEAD'){
				$adtag_url=$adt_pre."headvid.js".$adt_suf;
			}
			else {
				$adtag_url=$adt_pre."banners.js".$adt_suf;
			}
			
			$data['adtag']			=	$adtag_url1;
			$data['zone_id']		=	$zoneid;
			$data['zone_name']		=	$zone_name;
			$data['zone_type']		=	$adblock_type;
			$data['content']		= 	$this->load->view('campaigns/campaigns_rotator_adtag',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);
			}
			
	public function add_favourite_campaigns($campaignid)
	{
		
		$api_key = get_session('api_key'); 
		
		$input = array('api_key'=>$api_key);
					  
		$input['campaignid'] = $campaignid;
		
		//print_r($input);  
		//die("dsa");
				
		$campaign_list			= $this->rest->post('api/v1/campaign/add_favourite_campaigns',$input,'php');
		
	}
	
	public function fetch_campaigns_all_fav($val)
	{
		
		$api_key 	    = get_session('api_key'); 
		
		$input = array(
					    'api_key'=>$api_key						
					  );
					  
		//if($val != 'all'){
			$input['fav'] = $val;
		//}			
		
			
		$campaign_list			= $this->rest->get('api/v1/campaign/fetch_campaign_fav',$input,'php');
			//$this->rest->debug();		
			//print_r($campaign_list);	
		$campaign_data = '';
		
		if(!empty($campaign_list))
		{	
			$campaign_data .= '<table>
									<tr id="campaign_tr1">		
									<td>';
									$k=1;								
		foreach ($campaign_list as $cam_list)	
		{
			$file_name = $this->config->item('creative_upload_path').$cam_list['filename'];	 
																		
			$file_available=1;
										
			//$file_url=$this->config->item('creative_path').$cam_list['filename'];										
			$file_url=$this->config->item('base_url').$cam_list['dj_image_path'].$cam_list['filename'];							
			$file_headers = @get_headers($file_url);

            if( $file_headers[0]=='HTTP/1.1 404 Not Found')
			{
				$file_available=2;
									  
			}
			else
			{
				$file_available=1;										
			}
			
			$campaign_data .= "<div id='campaign_base' class='campaign_base_".$cam_list['campaignid']."'>";
			
			if($cam_list['dj_favourite_status'] == 0){
				$campaign_data .='<div class="campaign_fav off"><a  onclick="Add_to_favourites('.$cam_list['campaignid'].','.$cam_list['dj_favourite_status'].',this);">FAV</a></div>';
			}else{
				$campaign_data .='<div class="campaign_fav on"><a  onclick="Add_to_favourites('.$cam_list['campaignid'].','.$cam_list['dj_favourite_status'].',this);">FAV</a></div>';	
				
				}
			 
										
										$campaign_data .="<table>
											<tr>";
											if($file_available=='1' && $cam_list['filename']!='')
												{
												$campaign_data.="<td><a onclick='campaign_details(".$cam_list['campaignid'].",this)'><img src=".$file_url;
												$campaign_data.=" id='campaignid_".$cam_list['campaignid']."' class='ui-draggable'></a></td>";  
												}
												else
												{
												$campaign_data.="<td><a onclick='campaign_details(".$cam_list['campaignid'].",this)'><img src=".$this->config->item('creative_path')."campaign_thumb_empty.jpg";
												$campaign_data.=" id='campaignid_".$cam_list['campaignid']."' style='border:#ccc solid 2px'></a></td>";												
												}
										$campaign_data.="</tr>
											
											<tr><td align='center' valign='middle' class='creative_size_text'><a class='campaign-name' onclick='campaign_details(".$cam_list['campaignid'].",this)' title='". $cam_list['campaignname']."'>".$cam_list['campaignname']."</a></td></tr>											
											<tr><td align='center' valign='middle' class='creative_size_text campaign-overall-payout'>"."$".$cam_list['revenue']."</td></tr>
											</table>
											
										</div>";
			
						if($k % 6 == 0){
									 $campaign_data.= "</td></tr><tr id='campaign_tr".$k."'><td>";	
									}
									$k++;
									
			
		}
		$campaign_data.= "</td>									
									</tr>
									</table>";
		}
		else
		{
			$campaign_data=" No Records Found";
		}
		
		echo $campaign_data;
		
		
	}
	
	public function edit_ad_block_url_id1()
	{
		$this->session->unset_userdata('rotator_url_id1');
		$this->session->set_userdata('rotator_url_id1', $_POST['url_id']);
		echo json_encode($this->session->userdata('rotator_url_id1'));
	}
	/*
	 * 
	 * name		:edit_rotator_site
	 * @param   :Null
	 * @return  :List all the campaigns for a particular 
	 * 			 Publisher 
	 */	
	 	
	public function edit_rotator_site()
	{	 
		
		$zoneid=$this->session->userdata('rotator_url_id1');
		
		$data['page_title'] = "Campaigns";		
		$data['breadcrumb'] = '';				
		
		$data['zone_details']  =	$this->rest->get('api/v1/campaign/fetch_zone_details',array("api_key"=>get_session('api_key'),"zoneid"=>$zoneid),'php');
		
		//$data['selected_campaign_list']  =	$this->rest->get('api/v1/campaign/fetch_publisher_selected_campaign',array("api_key"=>get_session('api_key'),"zoneid"=>$zoneid),'php');
		
		$cam_list=	$this->rest->get('api/v1/campaign/fetch_zone_campaigns',array("api_key"=>get_session('api_key'),"zoneid"=>$zoneid),'php');
		
		$data['zone_campaign_list'] =$cam_list;
		$data['zone_id']=$zoneid;
		$data['selected_cam_count']=count($data['selected_campaign_list']);
		//$this->rest->debug();
		//print_r($data['zone_campaign_list']);
		//exit;
		$data['content'] = $this->load->view('campaigns/edit_rotator_site',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	/*
	 * 
	 * name		:edit_site_campaigns
	 * @param   :Null
	 * @return  :List all the campaigns for a particular 
	 * 			 Publisher 
	 */	
	 	
	public function edit_site_campaigns($zoneid = false)
	{	 
		$campaign_ids = $_GET['campaign_list'];
		$zoneid = $_GET['zone_id'];
		//print_r($zoneid);echo "<br/>";
		
		//print_r($campaign_ids);
		$data['selected_campaign_list']  =	$this->rest->get('api/v1/campaign/fetch_publisher_selected_campaign',array("api_key"=>get_session('api_key'),"zoneid"=>$zoneid,"campaign_id"=>$campaign_ids),'php');
		//$this->rest->debug();
		//exit;
		$data['page_title'] = "Campaigns";		
		$data['breadcrumb'] = '';				
		$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');	
		$data['country_list']   =   $this->rest->get('api/v1/countrywise_bidding/fetch_country_list',array("api_key"=>get_session('api_key')),'php');  
		$data['category_list']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');
		$data['creative_size']  = 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		$data['campaign_list']  =	$this->rest->get('api/v1/campaign/fetch_publisher_campaign',array("api_key"=>get_session('api_key')),'php');
		
		$data['zone_id']=$zoneid;
		
		$data['selected_cam_count']=count($data['selected_campaign_list']);
		//echo $this->rest->debug(); exit;
		//print_r($data['selected_campaign_list']);exit;
		$data['content'] = $this->load->view('campaigns/edit_site_campaign',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	public function update_rotator()
	{
		$campaign_ids = $_POST['campaign_list'];
		$website_id = $_POST['website_id'];
		$zone_id = $_POST['zone_id'];
	
		$api_key = get_session('api_key');
		
		if(isset($_POST['adblock_name']) || isset($_POST['passback'])){
			$zone_name = $_POST['adblock_name'];
			$passback = $_POST['passback'];
			$inputs = array(
						'api_key'		=>	$api_key,
						'_adblock_id'			=>	$zone_id,
						'select_cpm'	=>	'3',
						'fixed_cpm_rate'		=>	0,
						'site_id'		=>	$website_id,
						'fixed_system_cpm_rate'		=>	0,
						'adblock_name'		=>	$zone_name,
						'passback'		=>	$passback,
						'floor_price'		=>	'0.01'
					  );
			//	print_r($inputs);exit;	  
			$datas		= $this->rest->post('api/v1/site/complete_ad_block',$inputs,'json');
			
		}
		//$bann_type = $this->rest->get('api/v1/campaign/fetch_ban_type',array("api_key"=>$api_key,"zone_id"=>$zone_id),'php');
		//$this->rest->debug();
		//exit;
		$adblock_size = $this->rest->get('api/v1/campaign/fetch_adblock_size',array("api_key"=>$api_key,"zone_id"=>$zone_id),'php');
		
		
		$ad_block_size = $adblock_size[0]['width'].'x'.$adblock_size[0]['height'];
		$adblock_type = $adblock_size[0]['dj_zone_type'];
		$zone_name = $adblock_size[0]['zonename'];
		
		if($adblock_type == 'W_BAN'){
			$banner_type = 'W_IMG';
		}
		else if($adblock_type == 'W_TEXT'){
			$banner_type= 'W_TEXT';
			
		}
		else if($adblock_type == 'W_A_PUP'){
			$banner_type = 'W_POP';
			
		}
		else if($adblock_type == 'W_A_LAY'){
			$banner_type = 'W_LAY';
			
		}
		else if($adblock_type == 'W_A_GB'){
			$banner_type = 'W_GB';
			
		}
		else if($adblock_type == 'W_A_BB'){
			$banner_type = 'W_BB';
			
		}
		else if($adblock_type == 'W_A_SL'){
			$banner_type == 'W_SL';
			
		}
		else if($adblock_type == 'W_A_CF'){
			$banner_type = 'W_CF';
			
		}
		else if($adblock_type == 'W_A_SS'){
			$banner_type = 'W_SS';
			
		}
		else if($adblock_type == 'M_A_IM'){
			$banner_type = 'M_IMG';
			
		}
		else if($adblock_type == 'M_A_TXT'){
			$banner_type = 'M_TEXT';
			
		}
		else if($adblock_type == 'M_A_EXD'){
			$banner_type = 'M_MR_EXP';
			
		}
		else if($adblock_type == 'M_A_RVL'){
			$banner_type = 'M_MR_REV';
			
		}
		else if($adblock_type == 'M_A_INT'){
			$banner_type = 'M_MR_INT';
			
		}
		else if($adblock_type == 'M_A_FX'){
			$banner_type = 'M_RS_FL';
			
		}
		else if($adblock_type == 'M_A_AD'){
			$banner_type = 'M_RS_ADH';
			
		}
		else if($adblock_type == 'M_A_PULL'){
			$banner_type = 'M_RS_PL';
			
			
		}
		else if($adblock_type == 'M_A_SLI'){
			$banner_type = 'M_RS_SL';
			
		}
		else if($adblock_type == 'M_A_FS'){
			$banner_type = 'M_RS_FS';
			
		}
		else if($ad_block_type == 'V_A_OL'){
			$banner_type= 'V_OL';
		}
		else if($ad_block_type == 'V_A_IN'){
			$banner_type= 'V_IN';
		}
		else if($ad_block_type == 'V_A_SM'){
				$banner_type= 'V_SM';
		}
		else if($ad_block_type == 'V_A_RD'){
				$banner_type= 'V_RD';
		}
		else if($ad_block_type == 'V_A_BOX'){
				$banner_type= 'V_BOX';
		}
		else if($ad_block_type == 'V_A_HEAD'){
				$banner_type= 'V_HEAD';
		}
	//	$camp_id=implode(',',$campaign_ids);
	//print_r($campaign_ids);
	//	exit;
		$responselinking	= 	$this->rest->get('api/v1/auto_link/link_rotator_camapign_ads',array("api_key"=>$api_key,"campaign_id"=>$campaign_ids,"zone_id"=>$zone_id,"size"=>$ad_block_size,"banner_type"=>$banner_type),'php');
		//$this->rest->debug();
		//print_r($responselinking);
	//exit;
		//$del_path= $this->config->item("adserving_url");
			$del_path= $this->config->item("adverser_tags");
			$adt_pre='<script type="text/javascript" src="'.$del_path;
			//$adt_suf		=	'?id='.$zone_id.'"></script>';
				$adt_suf		=	$zone_id.'.js"></script>';
			$adtag_url1=$adt_pre.$adt_suf;
			if($adblock_type == 'W_BAN'  || $adblock_type == 'W_TEXT'){
				$adtag_url=$adt_pre."banners.js".$adt_suf;
					//$adtag_url= '<script type="text/javascript" src="'.$del_path.'banners.js?id='.$zoneid.'"></script>';
			}
			else if($adblock_type == 'W_A_PUP'){
				$adtag_url=$adt_pre."popup.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_PUN'){
				$adtag_url=$adt_pre."popunder.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_LAY'){
				$adtag_url=$adt_pre."layer.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_GB'){
				$adtag_url=$adt_pre."gamebox.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_BB'){
				$adtag_url=$adt_pre."bannerbox.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_SL'){
				$adtag_url=$adt_pre."slider.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_CF'){
				$adtag_url=$adt_pre."catfish.js".$adt_suf;
			}
			else if($adblock_type == 'W_A_SS'){
				$adtag_url=$adt_pre."site-skin.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_IM' || $adblock_type == 'M_A_TXT'){
				$adtag_url=$adt_pre."mob_banners.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_INT'){
				$adtag_url=$adt_pre."mob_interstital.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_EXD'){
				$adtag_url=$adt_pre."mob_expand.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_RVL'){
				$adtag_url=$adt_pre."mob_reveal.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_FX'){
				$adtag_url=$adt_pre."mob_fullpage.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_AD'){
				$adtag_url=$adt_pre."mob_adhesion.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_FS'){
				$adtag_url=$adt_pre."mob_filmstrip.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_SLI'){
				$adtag_url=$adt_pre."mob_slider.js".$adt_suf;
			}
			else if($adblock_type == 'M_A_PULL'){
				$adtag_url=$adt_pre."mob_pull.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_OL'){
				$adtag_url=$adt_pre."overlay.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_IN'){
				$adtag_url=$adt_pre."inline.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_RD'){
				$adtag_url=$adt_pre."readvid.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_SM'){
				$adtag_url=$adt_pre."smallvid.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_BOX'){
				$adtag_url=$adt_pre."boxvid.js".$adt_suf;
			}
			else if($adblock_type == 'V_A_HEAD'){
				$adtag_url=$adt_pre."headvid.js".$adt_suf;
			}
			else {
				$adtag_url=$adt_pre."banners.js".$adt_suf;
			}
				//print_r($del_path);	
			$data['adtag']			=	$adtag_url1;
			$data['zone_id']		=	$zone_id;
			$data['zone_name']		=	$zone_name;
			$data['zone_type']		=	$adblock_type;
			$data['content']		= 	$this->load->view('campaigns/campaigns_rotator_adtag',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);
	}
	function fetch_banner_adblock_type($bannertypes,$width,$height){
			$bannertype_exist='';$campaignid='';
			$banners_exist='';$bannerformat =array();$inc=0;
			$find=$this->multi_array_search($bannertypes, array('width'=>$width, 'height'=>$height));
			//print_r($find);echo ":";echo "<br>";
			foreach($find as $k=>$find_val){
				$banner_type=$bannertypes[$find_val]['banner_type'];
				
				if( $banner_type == 'W_IMG' ){
					$ad_block_type= 'W_BAN';
					$zone_name='Banner ads';
					
				}
				else if($banner_type == 'W_SQL'){
					
					$ad_block_type= 'W_BAN';
					$zone_name='Banner ads - Database';
				}
				else if($banner_type == 'W_URL'){
					
					$ad_block_type= 'W_BAN';
					$zone_name='Banner ads - URL';
				}
				else if($banner_type == 'W_SWF'){
					
					$ad_block_type= 'W_BAN';
					$zone_name='Banner ads - SWF';
				}
				else if($banner_type == 'W_TEXT'){
					
					$ad_block_type= 'W_TEXT';
					$zone_name='Text ads';
				}
				else if($banner_type == 'W_TB'){
					
					$ad_block_type= 'W_TB';
					$zone_name='TopBar Ads';
				}
				else if($banner_type == 'W_NA'){
					
					$ad_block_type= 'W_A_NAT';
					$zone_name='Native Ads';
				}
				else if($banner_type == 'W_POP'){
					
					$ad_block_type= 'W_A_PUP';
					$zone_name='Pop up ads';
				}
				else if($banner_type == 'W_LAY'){
					
					$ad_block_type= 'W_A_LAY';
					$zone_name='Layer ads';
				}
				else if($banner_type == 'W_GB'){
					
					$ad_block_type= 'W_A_GB';
					$zone_name='Gamebox ads';
				}
				else if($banner_type == 'W_BB'){
					
					$ad_block_type= 'W_A_BB';
					$zone_name='Bannerbox ads';
				}
				else if($banner_type == 'W_SL'){
					
					$ad_block_type= 'W_A_SL';
					$zone_name='Slider ads';
				}
				else if($banner_type == 'W_CF' || $banner_type=='A_CF' || $banner_type=='M_CF'){
					
					$ad_block_type= 'W_A_SL';
					$zone_name='Catfish ads';
				}
				else if($banner_type == 'W_SS'){
					
					$ad_block_type= 'W_A_SS';
					$zone_name='Siteskin ads';
				}
				else if($banner_type == 'M_IMG'){
					
					$ad_block_type= 'M_A_IM';
					$zone_name='Mobile ads - Image';
				}
				else if($banner_type == 'M_TEXT'){
					
					$ad_block_type= 'M_A_TXT';
					$zone_name='Mobile ads - Text';
				}
				else if($banner_type == 'M_MR_EXP'){
					
					$ad_block_type= 'M_A_EXD';
					$zone_name='Mobile ads - Expand';
				}
				else if($banner_type == 'M_MR_REV'){
					
					$ad_block_type= 'M_A_RVL';
					$zone_name='Mobile ads - Reveal';
				}
				else if($banner_type == 'M_MR_INT'){
					
					$ad_block_type= 'M_A_INT';
					$zone_name='Mobile ads - Interstital';
				}
				else if($banner_type == 'M_MR_DLG')
				{
					$ad_block_type= 'M_A_DLG';
					$zone_name='Mobile ads - Dialog Ads';
				}
				else if($banner_type == 'M_MR_NF')
				{
					$ad_block_type= 'M_A_NF';
					$zone_name='Mobile ads - Notification';
				}				
				else if($banner_type == 'M_RS_FL'){
					
					$ad_block_type= 'M_A_FX';
					$zone_name='Mobile ads - Fullpage Flex';
				}
				else if($banner_type == 'M_RS_ADH'){
					
					$ad_block_type= 'M_A_AD';
					$zone_name='Mobile ads - Adhesion';
				}
				else if($banner_type == 'M_RS_PL'){
					
					$ad_block_type= 'M_A_PULL';
					$zone_name='Mobile ads - Pull';
					
				}
				else if($banner_type == 'M_RS_SL'){
					
					$ad_block_type= 'M_A_SLI';
					$zone_name='Mobile ads - Slider';
				}
				else if($banner_type == 'M_RS_FS'){
					
					$ad_block_type= 'M_A_FS';
					$zone_name='Mobile ads - Filmstrip';
				}
				else if($banner_type == 'V_OL'){
					
					$ad_block_type= 'V_A_OL';
					$zone_name='Video Overlay ads';
				}
				else if($banner_type == 'V_IN'){
					
					$ad_block_type= 'V_A_IN';
					$zone_name='Video Inline ads';
				}
				else if($banner_type == 'V_SM'){
					
					$ad_block_type= 'V_A_SM';
					$zone_name='Video Small ads';
				}
				else if($banner_type == 'V_RD'){
					
					$ad_block_type= 'V_A_RD';
					$zone_name='Video Read ads';
				}
				else if($banner_type == 'V_BOX'){
					
					$ad_block_type= 'V_A_BOX';
					$zone_name='Video Box ads';
				}
				else if($banner_type == 'V_HEAD'){
					
					$ad_block_type= 'V_A_HEAD';
					$zone_name='Video Head ads';
				}
				//$bannertype_exist = $bannertype_exist.$banner_type."*".$zone_name.",";
				//$campaignid=$campaignid.$bannertypes[$find_val]['campaignid'].",";
				$finds=$this->multi_array_search($bannerformat, array('banner_type'=>$banner_type."*".$zone_name, 'campaignid'=>$bannertypes[$find_val]['campaignid']));
				//print_r($finds);echo " 999 ";echo "<br>";
				if(count($finds) <= 0){
					$bannerformat[$inc]['banner_type'] =$banner_type."*".$zone_name;
					$bannerformat[$inc]['campaignid'] = $bannertypes[$find_val]['campaignid'];
					$inc++;
				}
			}
			///print_r($campaignid);echo " 000 ";echo "<br>";
			//print_r($bannerformat);echo " 111 ";echo "<br>";
			//print_r($bannertype_exist);echo " 2222 ";echo "<br>";
			$bannerdistinct =array();$count_inc=0;
			foreach($bannerformat as $key=>$value){
				$previous_banner_type='';
				$finding=$this->multi_array_search($bannerdistinct, array('banner_type'=>$value['banner_type']));
				if(count($finding) <= 0){
				$finds=$this->multi_array_search($bannerformat, array('banner_type'=>$value['banner_type']));
				
				
				if(count($finds) > 0){
				foreach($finds as $key_val => $values) 
					$previous_banner_type =$previous_banner_type.$bannerformat[$values]['campaignid'].",";
				}
				
				$bannerdistinct[$count_inc]['banner_type'] = $value['banner_type'];
				$bannerdistinct[$count_inc]['campaignid'] = $previous_banner_type;
				$count_inc++;
				}
				
			}
			foreach($bannerdistinct as $keys=>$values){
			$bannertype_exist = $bannertype_exist.$values['banner_type']."*".$values['campaignid'].":";	
			}
			//print_r($bannerdistinct);echo " 2222 ";echo "<br>";
			
			return rtrim($bannertype_exist,",");
			//print_r($bannertype_exist);echo " 3333 ";echo "<br>";
			
	}
	function multidimensional_search($parents, $searched) { 
		  if (empty($searched) || empty($parents)) { 
			return false; 
		  } 

		  foreach ($parents as $key => $value) { 
			$exists = true; 
			foreach ($searched as $skey => $svalue) { 
			  $exists = ($exists && IsSet($parents[$key][$skey]) && $parents[$key][$skey] == $svalue); 
			} 
			if($exists){ return $key; } 
		  } 

		  return false; 
	}
  function multi_array_search($array, $search)
  {

		// Create the result array
		$result = array();

		// Iterate over each array element
		foreach ($array as $key => $value)
		{

		  // Iterate over each search condition
		  foreach ($search as $k => $v)
		  {

			// If the array element does not meet the search condition then continue to the next element
			if (!isset($value[$k]) || $value[$k] != $v)
			{
			  continue 2;
			}

		  }

		  // Add the array element's key to the result array
		  $result[] = $key;

		}

		// Return the result array
		return $result;

  }
}
