<?php 
class Apps extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->apps();		
	}
	
	/*
	 * 
	 * name		:apps
	 * @param   :Null
	 * @return  :List all the apps for a particular
	 * 			 Publisher
	 */	
	 	
	public function apps()
	{	
		$data['page_title'] = "Apps";		
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('apps/apps',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		:add_website
	 * @param   :Null
	 * @return  :Adds the website
	 * 			 
	 */	
	
	public function add_app()
	{
		$api_key = get_session('api_key');
		
		$category =$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
	
	//	echo $this->load->view('apps/modal_apps/content/add_app',$data);
		$data['content'] 	= 	$this->load->view('apps/modal_apps/content/add_app',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	public function edit_app_url_id()
	{
		$this->session->unset_userdata('pub_edit_app_url_id');
		$this->session->set_userdata('pub_edit_app_url_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_edit_app_url_id'));
	}
	public function edit_app($app_id = FALSE)
	{		
		$api_key = get_session('api_key');
		
		$app_id	=	 $this->session->userdata('pub_edit_app_url_id');
				
		$app_info = $this->rest->get('api/v1/apps/fetch_apps',array('app_id'=>$app_id, "api_key"=>$api_key),'php');
		    		
		$sel_category_id = $this->rest->get('api/v1/apps/fetch_app_cat',array('app_id'=>$app_id, "api_key"=>$api_key), 'json');
		
		$category=$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
		
		if(!empty($sel_category_id))
		{  
		  $data['sel_category'] = json_decode($sel_category_id);
			
		}else{
			$data['sel_category'] = '';
		}
		
		$data['app_info'] = $app_info[0];
				
		//echo $this->load->view('apps/modal_apps/content/edit_app',$data);
		$data['content'] 	= 	$this->load->view('apps/modal_apps/content/edit_app',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_apps()
	{		
		$api_key = get_session('api_key'); 			 
		$apps		= $this->rest->get('api/v1/apps/fetch_apps',array("api_key"=>$api_key),'json');
		//echo $this->rest->debug();  die();  
		echo convert_to_datatable_format($apps);		
	}
	
	/*
	 * 
	 * name		:ad_blocks
	 * @param   :Null
	 * @return  :List all the Web adblocks for a particular
	 * 			 Publisher
	 */	
	public function edit_mob_adb_list_ids()
	{
	
		$this->session->unset_userdata('pub_mob_add_app_lit');
		$this->session->set_userdata('pub_mob_add_app_lit', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_mob_add_app_lit'));
	}
	public function ad_blocks($site_id=FALSE)
	{	
		$data['page_title'] = 	"Ad Blocks";	
		$data['breadcrumb'] = 	'';	
		$api_key 			= 	get_session('api_key');
		//$data['site_id']	= 	$site_id;
		$data['site_id']	= 	$this->session->userdata('pub_mob_add_app_lit');

		
		// GET DEFAULT PERIOD FROM CONFIG FILE		
		$data['content'] 	= 	$this->load->view('sites/ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks($site_id=FALSE)
	{
		if($site_id!=FALSE)
		{
			$pval	=	array(
								"api_key"	=>	get_session('api_key'),
								"site_id"	=>	$site_id
							);
		}
		else
		{
			$pval	=	array(
								"api_key"	=>	get_session('api_key')
							);
		}
		
		$adblocks	= 	$this->rest->get('api/v1/site/fetch_adblocks',$pval,'json');
		//$this->rest->debug();
		
		echo convert_to_datatable_format($adblocks);
	}
	public function edit_mob_ad_blck_id()
	{
	
		$this->session->unset_userdata('pub_mob_adblk_add');
		$this->session->set_userdata('pub_mob_adblk_add', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_mob_adblk_add'));
	}
	/*
	 * 
	 * name		:add_adblock
	 * @param   :Null
	 * @return  :Adds the adblock
	 * 			 
	 */	
	
	public function add_ad_block($app_id=FALSE)
	{
		$app_id = $this->session->userdata('pub_mob_adblk_add');
			if($app_id!=FALSE)
			{  
				$data['app_id']		=	$app_id;
				$data['from_app']="1";
				$data['app_list']	=   $this->rest->get('api/v1/apps/fetch_applist',array("api_key"=>get_session('api_key'),"app_id"=>$app_id),'php');								
			}
			else
			{  
				$data['app_id']		=	'';
				$data['app_list']	=   $this->rest->get('api/v1/apps/fetch_applist',array("api_key"=>get_session('api_key')),'php');
			}

			//echo $this->rest->debug();  die();
			
			
			$data['page_title'] 	= 	"Add Ad Block";					
					
			$api_key				=	get_session('api_key');
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$data['content']		= 	$this->load->view('sites/add_ad_block',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);  																																																				
				
	}
	
	
	/*
	 * 
	 * name		:add_adblock
	 * @param   :Null
	 * @return  :Adds the adblock
	 * 			 
	 */	
	
	public function edit_ad_block($zone_id=FALSE)
	{
		if($zone_id!=FALSE)
		{	
			$data['page_title'] 	= 	"Edit Ad Block";		
			
			$data['adblock_id']		=	$zone_id;
				
			$api_key				=	get_session('api_key');
			
						
			$site			=   $this->rest->get('api/v1/site/fetch_siteid',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['siteid'] = $site[0]['site_id'];
			
			
			//echo $this->rest->debug();  die();	
			$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');
	
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$adb					= 	$this->rest->get('api/v1/site/fetch_adblocks',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			
			/***************** Fecth Tag parameters ***********************/
			$tag					= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['tag']			=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
						
			$data['adb']			=	$adb[0];
			$data['site_id']		=	$data['adb']['site_id'];
			
			$data['content']		= 	$this->load->view('sites/edit_ad_block',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);
		}		
	}
}
