<?php 
class Reports extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
		
		/*Libraries */
		$this->load->library("PHPExcel");
		$this->load->library("PHPExcel/IOFactory");
		
		$this->load->library('zip');
	}

	function index()
	{
		$this->overview();
	}

	/*
	 * 
	 * name		:overview
	 * @param   :Null
	 * @return  :Generate advertser reports by the datewise.
	 */	

	public function overview()
	{
		$data['page_title'] 	= 	"Overview reports";
		$data['breadcrumb'] 	= 	'';
		// GET DEFAULT PERIOD FROM CONFIG FILE
     		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		
		
		
		
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 		= 	$this->load->view('reports/overview',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_OVERVIEW';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		if($camps != FALSE){
			$input['camp_show'] = $camps;
		}			  
		if($displays != FALSE){
			$input['displays'] = $displays;
		}			  
		 
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';
		
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	
	
	/*
	 * 
	 * name		:geographic
	 * @param   :Null
	 * @return  :Generate advertser reports by the countrywise.
	 */	

	public function geographic()
	{
		$data['page_title'] 	= 	"Geographic reports";

		$data['breadcrumb'] 	= 	'';
		
		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE

		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('reports/geographic',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_country_stat($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = 	get_session('api_key');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'COUNTRY',
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';			  
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//$this->rest->debug();
		echo $data;
	}
	
	
	/*
	 * 
	 * name		:campaign
	 * @param   :Null
	 * @return  :Generate advertser reports by campaign.
	 */	

	public function campaign($campaign_id=FALSE)
	{
		$data['page_title'] 	= 	"Campaign reports";

		$data['breadcrumb'] 	= 	'';

		$data['campaign_id'] 	= 	($campaign_id!=FALSE)?$campaign_id:'';
		
		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_CAMPAIGN']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 		= 	$this->load->view('reports/campaigns',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

     public function url()
     {
		$data['page_title'] 	= 	"Url reports";

		$data['breadcrumb'] 	= 	'';

		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_CREATIVE']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('reports/url',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	 }	 

	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_campaign_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_CAMPAIGN';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
				
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';			  
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		echo $data;
		  //echo $this->rest->debug();exit;
	}
	
	/*
	 * 
	 * name		:creatives
	 * @param   :Null
	 * @return  :Generate advertser reports by creatives.
	 */	

	public function creatives($creative_id=FALSE)
	{
		$data['page_title'] 	= 	"Creatives reports";

		$data['breadcrumb'] 	= 	'';

		$data['creative_id'] 	= 	($creative_id!=FALSE)?$creative_id:'';
		
		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_CREATIVE']['TABLE']['DEFAULT_INTERVAL']);
		$data['camp_creative'] 	=	$this->session->userdata('revenue_period');
		$data['content'] 		= 	$this->load->view('reports/creatives',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_creative_stats($env='all',$cam_id='all',$creative_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_CREATIVE';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($creative_id != 'all'){
			$input['creative_id'] = $creative_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		$input['result_type'] 	= 'DATA';			  
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	/*
	 * for automatic filter of banners mod  dac094 20-11-2018
	 * 
	 * */
	public function fetch_camp_creative_stats($env='all',$cam_id='all',$creative_id='all',$from_date=FALSE,$to_date=FALSE)
	{  
		
		 
		$api_key 		= 	get_session('api_key');
		$cam_id 		= 	$this->session->userdata('camp_cre_id');
		$revenue_period 		= 	$this->session->userdata('revenue_period');
		$page			= 	'REPORT_CREATIVE';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		 
			$input['camp_id_alter'] = $cam_id;
		 
		
		if($creative_id != 'all'){
			$input['creative_id'] = $creative_id;
		}
		
		 //~ if($from_date != FALSE){
			//~ $input['date_from'] =  date('Y-m-d', strtotime('-30 days'));
		 //~ }
		//~ 
		//~ if($to_date != FALSE){
			//~ $input['date_to'] =  date('Y-m-d', strtotime('-1 days'));
		//~ }			  
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		$input['result_type'] 	= 'DATA';			  
			//print_r($input);exit;		  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//~ print_r($this->rest->debug());exit;	
		echo $data;
	}
	
		
	public function fetch_url_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_URL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'stat_type'		=>	'URL',
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
				
		$input['result_type'] 	= 'DATA';			  
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
				
        //$this->rest->debug();
        
		echo $data;
	}
	/*
	 * 
	 * name		:spend
	 * @param   :Null
	 * @return  :Generate advertser reports by their spend.
	 */	

	public function spend()
	{
		$data['page_title'] = "Spend reports";

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('reports/spend',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:video
	 * @param   :Null
	 * @return  :Generate advertser reports for video.
	 */	

	public function video()
	{
		$data['page_title'] 	= 	"Video reports";

		$data['breadcrumb'] 	= 	'';		
		
		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		$data['creative_data']	= 	$this->rest->get('api/v1/report/fetch_video_creative',array("api_key"=>get_session('api_key')),'php');
				
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_VIDEO']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 		= 	$this->load->view('reports/video',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_video_stats($env='all',$cam_id='all',$ban_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_VIDEO';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'VIDEO'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($ban_id != 'all'){
			$input['creative_id'] = $ban_id;
		}

		if($_POST['dimensions'] != 'all'){
			$input['dimensions'] 	= 	$_POST['dimensions'];
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  

    	if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
				
		$input['result_type'] 	= 'DATA';				  			  
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	
	
	
	/***************************************************************
	 * 						Request Report
	 **************************************************************/ 
	 
	 /*
	 * 
	 * name		:adblocks
	 * @param   :Null
	 * @return  :List all the  Addblocks & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function request()
	{
		$data['page_title'] =	"Request Report";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		// Fetch creative list
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		$data['download'] 	= 	$this->rest->get('api/v1/report/download_report',array('api_key'=>$api_key),'json');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADVERTISER']['REPORT_CAMPAIGN']['TABLE']['DEFAULT_INTERVAL']);
		
		//$this->rest->debug();
		//exit;
		$data['content'] 	= 	$this->load->view('reports/request',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	* Lists the Web ad blocks
	* 
	* name		:fetch_adblocks
	* @param   :Null
	* @return  :returns the JSON Object for datatable
	*  			 
	*/	
	
	public function fetch_request()
	{
		$api_key	= 	get_session('api_key');
		$request	= 	$this->rest->get('api/v1/report/fetch_request',array("api_key"=>$api_key),'json');
		
		echo convert_to_datatable_format($request);
	}
	
	/*
	 * 
	 * name		:group_report
	 * @param   :Null
	 * @return  :Generate advertser reports by campaign.
	 */	

	public function group_report()
	{
		$data['page_title'] = "Group Report";

		$data['breadcrumb'] = '';

		$api_key	=	get_session('api_key');
		
		/* Basic */
		$data['timezone'] =	$this->rest->get('api/v1/report/fetch_timezone',array('api_key'=>get_session('api_key')),'php');
		
		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CAMPAIGN']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/group_report',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_group_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_group_stats($format='json')
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$timezone	= 	clean_data($this->input->post('timezone'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));

		$cam_id		=  	clean_data($this->input->post('campaign'));
		$cre_id		= 	clean_data($this->input->post('creative'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));
		
		$dimens		= 	clean_data($this->input->post('dimensions'));


		$api_key 	= 	get_session('api_key');
		
		$page		= 	'REPORT_CAMPAIGN';
		
		$input 		=	array(
							'api_key'		=>	$api_key,
							'page'			=>	$page,
							'interval'		=>	$interval,
							'timezone'		=>	$timezone,
							'environment'	=>	$environment					
						);
		
		$input['display_type'] 	= 'TABLE';
				
		if($cam_id != 'all'){
			$input['campaign_id'] = ($cam_id)?((is_array($cam_id))?$cam_id:explode(',',$cam_id)):'';
		}
		
		if($cre_id != 'all'){
			$input['creative_id'] = ($cre_id)?((is_array($cre_id))?$cre_id:explode(',',$cre_id)):'';
		}
		
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}				
			
		
		if($format!='php')
		{
			$input['stat_type']		=	'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			//print_r($data);exit;
			//echo $this->rest->debug();exit;
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
	}

	public function generate_zip()
	{	
		$time	=	time();	
		$rep_name	=	'report_'.$time;
		
		$sdata		=	$this->fetch_group_stats('php');
		
		$interval	= 	clean_data($this->input->post('interval'));
		$from_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('from_date'))));
		$to_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('to_date'))));		
		
		//$met		= 	clean_data($this->input->post('metrics'));
		//$mcol		= 	clean_data($this->input->post('m_col'));
		$met			="TIME_DATES,IMP,CLK,CON,SPEND,CTR,ECPM,FILL_RATE";
		$mcol			="TIME_DATES,Imp,Clk,Conv,Spend,CTR,ECPM,Fill Rate";
		$dim		= 	clean_data($this->input->post('dimensions'));
		$dcol		= 	clean_data($this->input->post('d_col'));
		$dname		= 	clean_data($this->input->post('d_name'));
		
		$metrics 	= 	($met)?((is_array($met))?$met:explode(',',$met)):'';
		$m_col 		= 	($mcol)?((is_array($mcol))?$mcol:explode(',',$mcol)):'';	
		$dimens		= 	($dim)?((is_array($dim))?$dim:explode(',',$dim)):'';			
		$d_col		= 	($dcol)?((is_array($dcol))?$dcol:explode(',',$dcol)):'';
		$d_name 	= 	($dname)?((is_array($dname))?$dname:explode(',',$dname)):'';	
		
		if(!empty($sdata))
		{
			
			$objPHPExcel = new PHPExcel();
			
			$workSheet	=	 $objPHPExcel->getActiveSheet();			
			
			$objPHPExcel->getProperties()->setCreator("Administrator");
			$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
			$objPHPExcel->getProperties()->setTitle("Advertiser_Report_".$time);			
			
			//Default Style Settings For Excel Sheet
			$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
			$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
			$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										
  
			// Set column width
			
			//Set the dimensions for the Table Title Attributes
			$i='A';
			
			$workSheet->getColumnDimension('B')->setWidth(20);
			
			if($interval!='CUMULATIVE'):				
				if($interval=='HOUR'):	
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
					
					$i++;
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
				else:				
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
				endif;
				$i++;
			endif;
			
			if(!empty($dimens)):
				foreach($dimens as $d):	
					if($interval=='HOUR')
					{
						if($d!='DATE')
						{
							if($i=='B')
							{
								$workSheet->getColumnDimension($i)->setWidth(20);
							}
							else
							{
								$workSheet->getColumnDimension($i)->setAutoSize(true);
							}	
						}
					}
					else
					{
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}	
					}
					$i++;				
				endforeach;	
			endif;
			
			if(!empty($metrics)):
				foreach($metrics as $m):
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
					$i++;				
				endforeach;	
			endif;
			
			//Set the Row dimensions for Each Row 			
			$workSheet->getRowDimension(6)->setRowHeight(20);
			
			// Decalaration of Style in an Array 		
			
			$titleArray	=	array(
									'font'=>array(
												'bold'	=>	true,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);
			$contentArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);	
								
			$dimensArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);		
									
			$metricsArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
									)	
								);	
				
						
			// Add some data
			//echo date('H:i:s') . " Add some data\n";
			$objPHPExcel->setActiveSheetIndex(0);
			
			//Set the Title and Start Date ,End Date Details 
			$objPHPExcel->getActiveSheet()->SetCellValue('A1', "Report Name");
			$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Platform Report - '.$from_date.' to '.$to_date);
			$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($contentArray);
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A2', "Report ID");
			$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B2', $time);
			$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($contentArray);
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A3', "From Date");
			$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B3', $from_date);	
			$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($contentArray);			
					
			$objPHPExcel->getActiveSheet()->SetCellValue('A4', "To Date");
			$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B4', $to_date);
			$objPHPExcel->getActiveSheet()->getStyle('B4')->applyFromArray($contentArray);
			
			$workSheet->getStyle(6)->applyFromArray($titleArray);
			$j='A';
			if($interval!='CUMULATIVE'):
				if($interval=='HOUR'):
					$workSheet->SetCellValue($j.'6',"Date");
					$j++;
					$workSheet->SetCellValue($j.'6',"Hour");	
				else:
					$workSheet->SetCellValue($j.'6',ucfirst(strtolower($interval)));	
				endif;
				$j++;
			endif;
			
			if(!empty($d_name)):
				foreach($d_name as $d):
					$workSheet->SetCellValue($j.'6',ucfirst($d));
					$j++;
				endforeach;	
			endif;
			
			if(!empty($m_col)):
				foreach($m_col as $m):
					$workSheet->SetCellValue($j.'6',ucfirst($m));
					$j++;
				endforeach;	
			endif;
			
			$workSheet->getStyle(6)->applyFromArray($titleArray);
			
			$col		=	0;
			$row		=	7;
			
			$k=0;
			
			foreach($sdata as $stat_data):
				$cv=0;
				if($interval!='CUMULATIVE'):
					if($interval=='HOUR'):
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->DATE);	
						$cv++;
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->HOUR);
					else:
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$interval);	
					endif;
					$cv++;
				endif;
			
				if(!empty($d_col)):
					foreach($d_col as $dc):
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$dc);
						$cv++;
					endforeach;	
				endif;
				
				if(!empty($metrics)):
					foreach($metrics as $m):
						if($m=='FILL_RATE')
						{
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m.'%');
						}
						else
						{
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m);
						}					
						
						$cv++;
					endforeach;	
				endif;
				
				$row++;	
			endforeach;			
			ob_end_clean();
			ob_start();
			$filename	=		$rep_name.'.xls';
			
			//********* TO DOWNLOAD THE EXCEL FILE********
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="'.$filename.'"');
			
			$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);		
			
			$objWriter->save($this->config->item('csv_report').$filename);
			
			if($row>1000)
			{
				// Download the file to your desktop. Name it "my_backup.zip"
				$this->zip->read_file($this->config->item('csv_report').$filename);			
				$this->zip->download($rep_name.'.zip');
			}
			else
			{
				$objWriter->save('php://output');
			}
		}
		else
		{
			return false;
		}	
	}	
	
	public function download_request()
	{
		//$res		=	clean_data($this->input->post('last_request'));
		$api_key 	= 	get_session('api_key');
		
		$res 		= 	$this->rest->get('api/v1/report/download_report',array('api_key'=>$api_key),'json');
	
		if($res)
		{
			$stat	=	json_decode($res);
			
	
			$time		=	time();	
			$rep_name	=	'report_'.$time;
			
			$request	=	$stat->request;
			$search		=	$stat->search;
			$rep_data	=	$stat->data;
			$f_date=$stat->data[0];
			
				
			//$from_date	= 	date('d/m/Y',strtotime($search->date_from));
			$from_date	= 	date('d/m/Y',strtotime($f_date->DATE));
			//$to_date	= 	date('d/m/Y',strtotime($search->date_to));
			$to_date	= 	date('d/m/Y',strtotime($request->date_time));
			
			if($rep_data)
			{
				$objPHPExcel= 	new PHPExcel();
				$workSheet	=	$objPHPExcel->getActiveSheet();			
				
				$objPHPExcel->getProperties()->setCreator("Administrator");
				$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
				$objPHPExcel->getProperties()->setTitle();				

				//Default Style Settings For Excel Sheet
				$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
				$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
				$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

				// Set column width
				
				//Set the dimensions for the Table Title Attributes
				$workSheet->getColumnDimension('A')->setAutoSize(true);
				$workSheet->getColumnDimension('B')->setAutoSize(true);
				$workSheet->getColumnDimension('C')->setAutoSize(true);
				$workSheet->getColumnDimension('D')->setAutoSize(true);
				$workSheet->getColumnDimension('E')->setAutoSize(true);
				$workSheet->getColumnDimension('F')->setAutoSize(true);
				$workSheet->getColumnDimension('G')->setAutoSize(true);
				$workSheet->getColumnDimension('H')->setAutoSize(true);		
				
				//Set the Row dimensions for Each Row 			
				$workSheet->getRowDimension(6)->setRowHeight(20);
				
				// Decalaration of Style in an Array 		
				
				$titleArray	=	array(
										'font'=>array(
													'bold'	=>	true,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);
				$contentArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);	
									
				$dimensArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);		
										
				$metricsArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
										)	
									);				
							
				// Add some data
				//echo date('H:i:s') . " Add some data\n";
				$objPHPExcel->setActiveSheetIndex(0);
				
				//Set the Title and Start Date ,End Date Details 
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', "Report Name");
				$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Report - '.$from_date.' to '.$to_date);
				$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A2', "Report ID");
				$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B2', $time);
				$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A3', "From Date");
				$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B3', $from_date);	
				$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($contentArray);			
						
				$objPHPExcel->getActiveSheet()->SetCellValue('A4', "To Date");
				$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B4', $to_date);
				$objPHPExcel->getActiveSheet()->getStyle('B4')->applyFromArray($contentArray);
				
				if($search->account_type=='ADVERTISER'):
					$workSheet->SetCellValue('A6',"Campaign");
					$workSheet->SetCellValue('B6',"Creative");	
					$workSheet->SetCellValue('F6',"Spend");				
				elseif($search->account_type=='TRAFFICKER'):
					$workSheet->SetCellValue('A6',"Site");
					$workSheet->SetCellValue('B6',"Adblock");
					$workSheet->SetCellValue('F6',"Revenue");
				endif; 
				$workSheet->SetCellValue('C6',"Impressions");
				$workSheet->SetCellValue('D6',"Clicks");
				$workSheet->SetCellValue('E6',"Conversions");			
				$workSheet->SetCellValue('G6',"CTR");
				$workSheet->SetCellValue('H6',"ECPM");
				
				$workSheet->getStyle('A6:H6')->applyFromArray($titleArray);
				
				$col		=	0;
				$row		=	7;
				
				$k=0;
				
				foreach($rep_data as $stat_data):
					if($search->account_type=='ADVERTISER'):
						$workSheet->setCellValueByColumnAndRow(0,$row,$stat_data->CAM_NAME);	
						$workSheet->setCellValueByColumnAndRow(1,$row,$stat_data->BAN_NAME);
						$workSheet->setCellValueByColumnAndRow(6,$row,html_entity_decode($this->config->item('currency')).$stat_data->SPEND);
						$workSheet->setCellValueByColumnAndRow(7,$row,html_entity_decode($this->config->item('currency')).$stat_data->ECPM);
					elseif($search->account_type=='TRAFFICKER'):
						$workSheet->setCellValueByColumnAndRow(0,$row,$stat_data->SITE_URL);	
						$workSheet->setCellValueByColumnAndRow(1,$row,$stat_data->ZONE_NAME);	
						$workSheet->setCellValueByColumnAndRow(6,$row,html_entity_decode($this->config->item('currency')).$stat_data->PUB_EARN);
						$workSheet->setCellValueByColumnAndRow(7,$row,html_entity_decode($this->config->item('currency')).$stat_data->PUB_ECPM,ENT_QUOTES);
					endif;
					
					$workSheet->setCellValueByColumnAndRow(2,$row,$stat_data->IMP);	
					$workSheet->setCellValueByColumnAndRow(3,$row,$stat_data->CLK);	
					$workSheet->setCellValueByColumnAndRow(4,$row,$stat_data->CON);	
					$workSheet->setCellValueByColumnAndRow(5,$row,$stat_data->CTR.'%');				
					
							
					$row++;	
				endforeach;			
				ob_end_clean();
				ob_start();
				if($search->format=='xls'):
					$filename	=		$rep_name.'.xls';
					//********* TO DOWNLOAD THE EXCEL FILE********
					header('Content-Type: application/vnd.ms-excel');
					header('Content-Disposition: attachment;filename="'.$filename.'"');
				elseif($search->format=='csv'):
					$filename	=		$rep_name.'.csv';
					//********* TO DOWNLOAD THE EXCEL FILE********
					header('Content-Type: text/csv');
					header('Content-Disposition: attachment;filename="'.$filename.'"');
				endif;
				
				$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);	
				
				$objWriter->save('php://output');
				
			}
			else
			{
				echo 'error';
			}
		}
		else
		{
			echo 'error';
		}	
		
	}
	
	public function generate_pdf($orientation = 'portrait')
	{//print_r($this->input->post()); exit;
		$time	=	time();	
		$rep_name	=	'pdf_report_'.$time;
		
		$sdata		=	$this->fetch_group_stats('php');
		
		$interval	= 	clean_data($this->input->post('interval'));
		$from_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('from_date'))));
		$to_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('to_date'))));		
		
		$met		= 	clean_data($this->input->post('metrics'));
		$mcol		= 	clean_data($this->input->post('m_col'));
		
		$dim		= 	clean_data($this->input->post('dimensions'));
		$dcol		= 	clean_data($this->input->post('d_col'));
		$dname		= 	clean_data($this->input->post('d_name'));
		
		$metrics 	= 	($met)?((is_array($met))?$met:explode(',',$met)):'';
		$m_col 		= 	($mcol)?((is_array($mcol))?$mcol:explode(',',$mcol)):'';	
		$dimens		= 	($dim)?((is_array($dim))?$dim:explode(',',$dim)):'';			
		$d_col		= 	($dcol)?((is_array($dcol))?$dcol:explode(',',$dcol)):'';
		$d_name 	= 	($dname)?((is_array($dname))?$dname:explode(',',$dname)):'';	
		
		if(!empty($sdata))
		{ print_r($sdata); exit;
			$this->fpdf->SetFont('Arial','B',14);
		$arraysss = json_decode(json_encode($sdata), true);
			
			$setvalues = array_values($arraysss[0]);
			 
			if(!empty($m_col)):
				foreach($m_col as $m):
				
				 	$this->fpdf->Cell('25','8',$m,1,0,'C');
				 
				endforeach;	
						 
					$this->fpdf->Ln();
				$i=0;	$j=0;
				 foreach($setvalues as $col):
				
				if($col!='' && $j<8)
				 {
					 $this->fpdf->Cell(25,8,$col,1,0,'C');$j++; 
					// echo $j.':'.$col.'<br>'; $i++; $j++; 
				 }
				endforeach;	
				 
				$this->fpdf->Ln();
			endif;
			 
			
		/*	$arraysss = json_decode(json_encode($sdata), true);
			
			$setvalues = array_values($arraysss[0]);
			
			foreach($arraysss[0] as $d):
			
					$this->fpdf->Cell('25','8',$d,1,0,'C');
			endforeach;	*/
			 
			
			 
			 echo $this->fpdf->Output($rep_name.'.pdf','D');
			 /*echo'0';
			 print_r($metrics);
			 echo'<br>';
			 echo'1';
			 print_r($dim);
			 echo'<br>';
			 echo'2';
			 print_r($dcol);
			 echo'<br>';
			 echo'3';
			 print_r($dname);
			 echo'<br>';*/
			 
			 
		}
		else
		{
			return false;
		}
	}
	
	public function fetch_adv_filter_stats($type=false,$format='json')   
	{//print_r($this->input->get());exit;
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$from_date	= 	date("Y-m-d", strtotime($from_date));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));

		$cam_id		=  	clean_data($this->input->post('campaign'));
		$cre_id		= 	clean_data($this->input->post('creative'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));		
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
		
		if($type!=false && $type=='COUNTRY')
		{
			$page		=	'REPORT_GEO_GRAPHICAL';
		}
		elseif($type!=false && $type=='URL')
		{
			$page		=	'REPORT_URL';
		}
		elseif($type!=false && $type=='VIDEO')
		{
			$page		=	'REPORT_VIDEO';
		}
		else
		{
			$page		= 	'REPORT_CAMPAIGN';
		}
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		$input['display_type'] 	= 'TABLE';
				
		if($cam_id != 'all'){
			$input['campaign_id'] = ($cam_id)?((is_array($cam_id))?$cam_id:explode(',',$cam_id)):'';
		}
		
		if($cre_id != 'all'){
			$input['creative_id'] = ($cre_id)?((is_array($cre_id))?$cre_id:explode(',',$cre_id)):'';
		}
		
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['stat_type']		=	($type!=false)?$type:'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			//print_r($input);exit;
			//echo $this->rest->debug();exit;
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
	}

	public function fetch_adv_filter_stats_custom($type=false,$format='json')   //DAC094 20-10-2017 for  camp preview
	{//print_r($this->input->post());exit;
		$interval	= 	'CUMULATIVE';
		$environment= 	'all';
		$date = new DateTime();
		$from_date	= 	clean_data($this->input->post('from_date'));
		$from_date	= 	$date->setTimestamp($from_date)->modify('+1 day')->format('Y/m/d');
		$to_date	= 	clean_data($this->input->post('to_date'));
		$to_date	= 	$date->setTimestamp($to_date)->modify('+1 day')->format('Y/m/d');
		//echo $from_date.' -- '.$to_date;exit;
		$metrics	= 	'TIME_DATE,IMP,CLK,CON,SPEND,CTR,ECPM,FILL_RATE';//clean_data($this->input->get('metrics'));

		$cam_id		=  	clean_data($this->input->post('campaign'));
		$cre_id		= 	'all';//clean_data($this->input->get('creative'));
		$country	= 	'all';//clean_data($this->input->get('country'));
		$adsize		= 	'all';//clean_data($this->input->get('adsize'));
		$camtyp 	= 	'all';//clean_data($this->input->get('revtype'));		
		
		$dimens		= 	'CAM_ID,COUNTRY,DATE';//clean_data($this->input->get('dimensions'));

		$api_key 	= 	get_session('api_key');
		
		if($type!=false && $type=='COUNTRY')
		{
			$page		=	'REPORT_GEO_GRAPHICAL';
		}
		elseif($type!=false && $type=='URL')
		{
			$page		=	'REPORT_URL';
		}
		elseif($type!=false && $type=='VIDEO')
		{
			$page		=	'REPORT_VIDEO';
		}
		else
		{
			$page		= 	'REPORT_CAMPAIGN';
		}
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		$input['display_type'] 	= 'TABLE';
				
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($cre_id != 'all'){
			$input['creative_id'] = ($cre_id)?((is_array($cre_id))?$cre_id:explode(',',$cre_id)):'';
		}
		
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		//print_r($input);exit;
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['stat_type']		=	($type!=false)?$type:'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			//print_r($input);exit;
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			
			//echo $this->rest->debug(); exit;
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
	}

	
	public function fetch_dashboard_stats($type=FALSE,$from_date=FALSE,$to_date=FALSE,$group_by=FALSE)
	{ 
			
			
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_DASHBOARD';
		$display_type	= 	'TABLE';
		
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($group_by!=FALSE)
		{
		$input['group_by']	= 	$group_by;
	   }
	//print_r($input);exit;
		if($type!=FALSE && $type=='zone')
		{
			$input['adv_type']	= 	'zone';
		}
		elseif($type!=FALSE && $type=='traffic')
		{
			
		}
		elseif($type!=FALSE && $type=='top_coutry')
		{
			$input['adv_type']	= 	'top_coutry';
		}		
		if($from_date != FALSE){
			$input['date_from'] = 	$from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= 	$to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] 	= 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 		= 	$_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = 	$_REQUEST;
		
		$input['result_type'] 	= 	'DATA';
		
		$data			= 	$this->rest->post('api/v1/report/fetch',$input,'json');
		
	//	echo $this->rest->debug();  die();
		
		echo $data;
	}	
	
	
	public function fetch_detail_overview_stats($date='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = get_session('api_key');
		$page			= 'REPORT_OVERVIEW';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($_POST['campaign'] != 'all'){
			$input['campaign'] = $_POST['campaign'];
		}
		
		if($_POST['creative'] != 'all'){
			$input['creative'] 	= 	$_POST['creative'];
		}
		if($_POST['dimensions'] != 'all'){
			$input['dimensions'] 	= 	$_POST['dimensions'];
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}

		$input['date'] = $date;
		$input['field_name'] = $field_name;
				
		$input['datatable_obj'] = $_REQUEST;
		$input['report_type'] 	= 'overview';
		$input['result_type'] 	= 'DATA';			  
		
		$data			= $this->rest->post('api/v1/report/fetch_detail_overview',$input,'json');
		//echo $this->rest->debug();
		// exit();
		echo $data;
    
	}
	
	
	
		
	public function fetch_country_detail_stat($date=FALSE,$field_name=FALSE,$country=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY',
						'date'=>$date
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($_POST['campaign'] != 'all'){
			$input['campaign'] = $_POST['campaign'];
		}
		
		if($_POST['creative'] != 'all'){
			$input['creative'] 	= 	$_POST['creative'];
		}
		
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}		
		else
		{
			$input['country'] 	= 	$country;
			$input['report_type'] 	= 'geo';
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}
				if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		$input['date'] = $date;
		$input['field_name'] = $field_name;
				
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  

		$data			= $this->rest->post('api/v1/report/fetch_detail_overview',$input,'json');
		
		//echo $this->rest->debug();exit;
		
		echo $data;
	}
	
	public function fetch_campaign_detail_stats($env='all',$cam_id='all',$field_name=FALSE,$camp_name=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_CAMPAIGN';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($_POST['campaign'] != 'all'){
			$input['campaign_id'] = $_POST['campaign'];
		}
		
		if($_POST['creative'] != 'all'){
			$input['creative'] 	= 	$_POST['creative'];
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}
		
				
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		$input['cam_id'] 		= $cam_id;
		$input['field_name'] 	= $field_name;
		$input['camp_name'] 	= $camp_name;
		
		$input['result_type'] 	= 'DATA';			  
		
		$data			= $this->rest->post('api/v1/report/fetch_campaign_detail',$input,'json');
	//log_message('error','campaign_report');
	//log_message('error',print_r($data,true));

		echo $data;
		 // echo $this->rest->debug();exit;
	}
	
	
				
	public function fetch_detail_creative_stats($env='all',$ad_id='all',$field_name=FALSE,$ad_name=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_CAMPAIGN';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($ad_id != 'all'){
			$input['ad_id'] = $ad_id;
		}
		
		if($_POST['creative'] != 'all'){
			$input['creative'] 	= 	$_POST['creative'];
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}
		
				
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		$input['field_name'] 	= $field_name;
		$input['ad_name'] 		= $ad_name;
		
		$input['result_type'] 	= 'DATA';			  
					  
		$data			= $this->rest->post('api/v1/report/fetch_creative_detail',$input,'json');

		echo $data;
		  //echo $this->rest->debug();exit;
	}			
	
		
		
	public function fetch_url_detail_stats($env='all',$ad_id='all',$field_name=FALSE,$hostname=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_CAMPAIGN';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	

		if($_POST['campaign'] != FALSE){
			$input['date_from'] = $_POST['campaign'];
		}
		
		if($_POST['creative'] != FALSE && $_POST['creative'] != 'all'){
			$input['ad_id'] = $_POST['creative'];
		}				
		else
		{
			$input['ad_id'] = $ad_id;
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		else
		{
			$input['date_from'] = $from_date;
		}			
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}
		else
		{
			$input['date_to'] = $to_date;
		}
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}
						
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		$input['field_name'] 	= $field_name;
		$input['hostname'] 		= $hostname;
		
		$input['result_type'] 	= 'DATA';			  
					  
		$data			= $this->rest->post('api/v1/report/fetch_creative_detail',$input,'json');

		echo $data;
		  //echo $this->rest->debug();exit;
	}
	
	//api-home//
	
	
	
	
	public function fetch_advertiser_stats_home($api_key=false,$account_id=false,$account_type=false,$env='all',$adv_id='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{	
		
		
		$api_key 		= 	$api_key;
		$page			= 	'REPORT_ADVERTISER_HOME';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		$input['account_id'] = $account_id;
		$input['account_type'] = $account_type;
		
		if(	clean_data($this->input->post('from_date')) && clean_data($this->input->post('to_date')))
		{
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($adv_id != 'all'){
			$input['adv_account_id'] = $adv_id;
		}
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}			  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/home_fetch',$input,'json');

		#$this->rest->debug();

		echo $data;
	}
	
	public function fetch_home_filter_stats($type=false,$format='json',$api_key=false,$account_id=false,$account_type=false)   
	{
		
		
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		//$adv_id		= 	clean_data($this->input->post('advertiser'));
		$cam_id		=  	clean_data($this->input->post('campaign'));
		$cre_id		= 	clean_data($this->input->post('creative'));
		//$pub_id		= 	clean_data($this->input->post('publisher'));
		//$sit_id		= 	clean_data($this->input->post('site'));
		//$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));		
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		//$api_key 	= 	get_session('api_key');
		
		if($type!=false && $type=='COUNTRY')
		{
			$page		=	'REPORT_GEO_GRAPHICAL';
		}
	/*	elseif($type!=false && $type=='ENVIRONMENT')
		{
			$page		=	'REPORT_ENVIRONMENT';
		}*/
		elseif($type!=false && $type=='URL')
		{
			$page		=	'REPORT_URL';
		}
		elseif($type!=false && $type=='VIDEO')
		{
			$page		=	'REPORT_VIDEO';
		}
		else
		{
			$page		= 	'REPORT_ADVERTISER_HOME';
		}
		
		$input = array(
						'api_key'		=>	$api_key,
						'account_id'	=>	$account_id,
						'account_type'	=>	$account_type,
						'page'			=>	$page,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );		
		
		$input['display_type'] 	= 	'TABLE';
			
		/*if($adv_id != 'all'){
			$input['adv_account_id'] = ($adv_id)?((is_array($adv_id))?$adv_id:explode(',',$adv_id)):'';	
		}*/
		
		if($cam_id != 'all'){
			$input['campaign_id'] = ($cam_id)?((is_array($cam_id))?$cam_id:explode(',',$cam_id)):'';
		}
		
		if($cre_id != 'all'){
			$input['creative_id'] = ($cre_id)?((is_array($cre_id))?$cre_id:explode(',',$cre_id)):'';
		}
		
		/*if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}*/
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		$type=false;
		
		if($format!='php')
		{
			
			$input['stat_type']		=	($type!=false)?$type:'REPORT_ADVERTISER_HOME';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/home_fetch',$input,'json');
			//print_r($input);exit;
			 //$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/home_fetch',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
	}

	
	
	public function fetch_pixtrack_report()
	{
		$campaign_id	= 	clean_data($this->input->post('campaign_id'));
		$from_date= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));	
		
		$input['campaign_id'] = $campaign_id;
		$input['from_date'] = $from_date;
		$input['to_date'] 	= $to_date;		
		
		$data			= $this->rest->post('api/v1/report/fetch_pixtrack_report',$input,'json');	
		
	}
	
			
}
