<?php 
class Payments extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('memcached_library');
		$this->load->library('Default_configurations');
	}

	function index()
	{
		$this->payments();
	}

	/*
	 * 
	 * name		:payments
	 * @param   :Null
	 * @return  :Generate advertser payments/Invoice
	 */	

	public function payments()
	{
		$data['page_title'] = "Payments";
		$data['breadcrumb'] = '';
		$payment_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>1),'php');
		
		$paypal_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>2),'php');
		
		$webmoney_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>3),'php');
		$bitcoin_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>4),'php');
		$authorize_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>5),'php');
		
		
		$data['wire_details']		=	($payment_info!='error' && is_array($payment_info))?$payment_info[0]:'';
		
		$data['paypal_details']		=	($paypal_info!='error' && is_array($paypal_info))?$paypal_info[0]:'';	
		
		$data['webmoney_details']	=	($webmoney_info!='error' && is_array($webmoney_info))?$webmoney_info[0]:'';
		$data['bitcoin_details']	=	($bitcoin_info!='error' && is_array($bitcoin_info))?$bitcoin_info[0]:'';
		$data['authorize_details']	=	($authorize_info!='error' && is_array($authorize_info))?$authorize_info[0]:'';
		
		$account_details	=	array(
								'wire_info'		=>	$data['wire_details'],
								'paypal_info'	=>	$data['paypal_details'],
								'webmoney_info'	=>	$data['webmoney_details'],
								'bit_info'		=>	$data['bitcoin_details'],
								'auth_info'		=>	$data['authorize_details']
							);
		$data['account_details']	=	$account_details;					
		$data['content'] = $this->load->view('payments/payments',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:add_fund
	 * @param   :Null
	 * @return  :Loads the add fund module for the payment
	 */	

	public function add_fund()
	{
		$data['page_title'] = "Add Fund";
		$data['breadcrumb'] = '';
		$data['account_id'] = get_session('account_id');
		if(!empty($data['account_id']))
		{  $this->load->view('payments/modal_payments/content/add_fund',$data);
		}else{
			echo 'Sorry Login to continue';	
		}
	}
	
	/*
	 * 
	 * name		:add_fund
	 * @param   :Null
     * @return  :Loads the add fund module for the payment
	*/	
	public function fetch_advertiser_payment_list()
	{  
	   $pay_list=$this->rest->get('api/v1/payments/fetch_advertiser_payment',array('api_key'=>get_session('api_key')),'json');

	   echo convert_to_datatable_format($pay_list);
	}
	
	/*
	 * 
	 * name		:get_payment_details
	 * @param   :Null
     * @return  :Loads the add fund module for the payment
	*/
	
	public function get_payment_details()
	{
	   $month=$this->input->post('month');
	   $year=$this->input->post('year');
	   $account_id=$this->input->post('accountid');
	   $pay_list=$this->rest->post('api/v1/payments/fetch_advertiser_date_wise_payment',array('api_key'=>get_session('api_key'),'month'=>$month,'year'=>$year,),'json');
	   echo convert_to_datatable_format($pay_list);
	}
	
	/*
	 * 
	 * name		:deposits
	 * @param   :Null
     * @return  :Loads the add fund module for the payment
	*/
	public function deposits()
	{
		$data['page_title'] = "Deposit Amount Details";
		$data['breadcrumb'] = '';
		$admin_details		=	$this->rest->get('api/v1/network/get_network_account_details',array('api_key'=>get_session('api_key')),'php');
	
		$payment_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>1),'php');
		
		$paypal_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>2),'php');
		
		$webmoney_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>3),'php');
		$bitcoin_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>4),'php');
		$authorize_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>5),'php');
		
		
		$data['wire_details']		=	($payment_info!='error' && is_array($payment_info))?$payment_info[0]:'';
		
		$data['paypal_details']		=	($paypal_info!='error' && is_array($paypal_info))?$paypal_info[0]:'';	
		
		$data['webmoney_details']	=	($webmoney_info!='error' && is_array($webmoney_info))?$webmoney_info[0]:'';
		$data['bitcoin_details']	=	($bitcoin_info!='error' && is_array($bitcoin_info))?$bitcoin_info[0]:'';
		$data['authorize_details']	=	($authorize_info!='error' && is_array($authorize_info))?$authorize_info[0]:'';
		
		$account_details	=	array(
								'wire_info'		=>	$data['wire_details'],
								'paypal_info'	=>	$data['paypal_details'],
								'webmoney_info'	=>	$data['webmoney_details'],
								'bit_info'		=>	$data['bitcoin_details'],
								'auth_info'		=>	$data['authorize_details']
							);
		$data['account_details']	=	$account_details;					
		
		$data['content'] = $this->load->view('payments/deposits/deposit_details',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: fetch_payment_deposit_list
	 * @param : null
	 * @return : list of payments need to be approve.
	 */	
	public function fetch_payment_deposit_list()
	{
		$filter	=	array(
						'status'	=>	($this->input->post('status')!='')?explode(',',$this->input->post('status')):'',
						'payment_type'	=>	($this->input->post('payment_type')!='')?explode(',',$this->input->post('payment_type')):'','daterangepicker_cs'	=>	($this->input->post('daterangepicker_cs')!='')?explode(' - ',$this->input->post('daterangepicker_cs')):''
					);
		
		$deposit_list	  = $this->rest->get('api/v1/payments/fetch_deposit_amount_list',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($deposit_list);
	}
	
	public function advertiser_billing_information()
	{
		$b_id=$this->input->post("b_id");
		$data['billing_details']=$this->rest->get('api/v1/payments/advertiser_billing_details',array('billing_id'=>$b_id,'api_key'=>get_session('api_key')),'php');
		$content = $this->load->view('payments/deposits/billing_preview',$data,TRUE);
		 
	}
	public function advertiser_payment_deposit_details($date)
	{
      		$data['date']=$date;
       		echo $this->load->view('payments/modal_payments/depost_view_more',$data);	 
	}
	public function fetch_payment_datewise_deposit_list($date)
	{

	 	$deposit_list	  = $this->rest->get('api/v1/payments/fetch_monthly_deposit_amount_list',array('api_key'=>get_session('api_key'),'date'=>$date),'json');
		echo convert_to_datatable_format($deposit_list);
	}
	public function payments_activity_log($type=FALSE,$state=FALSE)
	{
		if($type || $state)
		{
			$pay_act_list=$this->rest->get('api/v1/payments/fetch_advertiser_payment_activity',array('api_key'=>get_session('api_key'),'payment_type'=>$type,'state'=>$state),'json');
		}
		else
		{
			$pay_act_list=$this->rest->get('api/v1/payments/fetch_advertiser_payment_activity',array('api_key'=>get_session('api_key')),'json');
		}
		echo convert_to_datatable_format($pay_act_list);
	}
}
