<?php 
class Network extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->countrywise_bidding();  
	}

	/*
	 * 
	 * name		:countrywise_bidding
	 * @param   :Null
	 * @return  :List the countrywise bidding for particular Advertiser
	 */	

	public function countrywise_bidding()
	{
		$data['page_title'] = "Countrywise Bidding";
		$data['selected_country']=$this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key')),'php');
		$data['content'] = $this->load->view('bidding/countrywise_bidding',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
		
	public function fetch_country_list($admarket=false)
	{
		$filter	=	array(
						'campaign'	=>	($this->input->post('campaign')!='')?explode(',',$this->input->post('campaign')):'',
						'campaign_type'	=>	($this->input->post('campaign_type')!='')?explode(',',$this->input->post('campaign_type')):''
					);					
		$country_list	  = $this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key'),'filter'=>$filter,'admarket'=>$admarket),'json');	
		//echo $this->rest->debug(); die("directads"); 
		//$country_list = json_encode($country_list,true);
		echo convert_to_datatable_format($country_list);
	}
	public function S2S_Tracking()
	{		
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('campaigns/s2scode',$data,TRUE); 
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
		
	/*
	 * 
	 * name		:add_countrywise_bidding
	 * @param   :Null
	 * @return  :Loads the country
	 */	

	public function add_countrywise_bidding($admarket=false)
	{ 
		$data['admarket']		=	$admarket;
		$data['country_data'] = $this->rest->get('api/v1/countrywise_bidding/fetch_unbiddingcountrylist',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_data'] =$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key'),"admarket"=>$data['admarket']),'php');
		
		$data['campaign_type']	= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('bidding/modal_bidding/content/add_countrywise_bidding',$data);	
	}
	
	/*
	 * 
	 * name		:edit_countrywise_bidding
	 * @param   :Null
	 * @return  :Loads the country
	 */	

	public function edit_countrywise_bidding($country_id=false)
	{
		$data['country_data'] = $this->rest->get('api/v1/countrywise_bidding/fetch_countrylist',array("api_key"=>get_session('api_key')),'php');
			
		$data['campaign_data'] =$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_type']		= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['countrybidding_data'] = $this->rest->get('api/v1/countrywise_bidding/editcountrylist',array("id"=>$country_id,"api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('bidding/modal_bidding/content/edit_countrywise_bidding',$data);	
	}
	
	public function zone_limitation()
	{ 
		$data['page_title'] = "Zone Limitation";
		$data['content'] = $this->load->view('zone_limitation/manage_zone_limitation',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_zone_limitation_list()
	{
		$filter	=	array(
						'traffic_source'	=>	($this->input->post('traffic_source')!='')?explode(',',$this->input->post('traffic_source')):'',
						'zone_id'	=>	($this->input->post('zone_id')!='')?explode(',',$this->input->post('zone_id')):''
					);  								
		$zonelist_list	  = $this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');	
		//echo $this->rest->debug(); exit;  
		echo convert_to_datatable_format($zonelist_list);
	}
	
	public function fetch_update_zonelist()
	{
		if($this->input->post('traffic_source')!='')
		{  					
			$data['zone_list']		=  $this->rest->get('api/v1/zone_limitations/fetch_filter_zone',array('api_key'=>get_session('api_key'),'traffic_source'=>$this->input->post('traffic_source')),'php');		
		}
		return $data;
	}
	/*
	 * 
	 * name		:add_zone_limitation
	 * @param   :Null
	 * @return  :Loads the zoneids
	 */	

	public function add_zone_limitation()
	{		
		   $zone_list  = $this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');	
		   $data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');
		   
		   
		   $unsetzone_list = $this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');			
           $zone_list_array = array();
           foreach($zone_list as $zone){
           		$zone_list_array[] = $zone['zoneid'];
           }
           $unsetzone = array();
           foreach($unsetzone_list as $unset){
           	$unsetzone = array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
           }
           $result=  array_diff($zone_list_array, $unsetzone);
           $data['zone_list'] =$result;
		   		   
           echo $this->load->view('zone_limitation/modal_zone_limitation/content/add_list',$data);	
	}
	
	/*
	 * 
	 * name		:edit_zone_limitation
	 * @param   :Null
	 * @return  :Loads the zone
	 */	

	public function edit_zone_limitation($advertiser_id=false)
	{
		$zone_list= $this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');
		$unsetzone_list = $this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');		
		$data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');	
		$zone_list_array = array();
		foreach($zone_list as $zone){
			$zone_list_array[] = $zone['zoneid'];
		}
		$unsetzone = array();
		foreach($unsetzone_list as $unset){
			$unsetzone = array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
		}

		$result=  array_diff($zone_list_array, $unsetzone);
		$data['zone_limitation_data'] = $this->rest->get('api/v1/zone_limitations/edit_zone_limitation',array("id"=>$advertiser_id,"api_key"=>get_session('api_key')),'php');
		$data['zone_list'] =array_merge($result, explode(',',$data['zone_limitation_data'][0]['zoneids']));
	 	echo $this->load->view('zone_limitation/modal_zone_limitation/content/edit_list',$data);	
	}
	
	
	
	public function zone_bidding()
	{ 
		$data['page_title'] = "Zone Bidding";
						
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher_traffic',array("api_key"=>get_session('api_key')),'php');
		
		$data['camp_lists']=$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['traffic_sourced_list']= $this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'php');
		
		$data['content'] = $this->load->view('zone_bidding/manage_zone_bidding',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_zone_bidding_list()
	{
		$filter	=	array(
						'zone_id'	=>	($this->input->post('zone_id')!='')?explode(',',$this->input->post('zone_id')):''
					);  								
		$zonelist_list	  = $this->rest->get('api/v1/zone_bidding/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');	
		//echo $this->rest->debug(); exit;
		echo convert_to_datatable_format($zonelist_list);
	}
	
	public function zone_bidding_adv_list($admarket=false)
	{  
		$filter	=	array(
						'campaign_type'	=>	($this->input->post('filter_campaign_type')!='')?explode(',',$this->input->post('filter_campaign_type')):''
					);
		$advertiser_camp_id=$this->rest->get('api/v1/network/fetch_zone_bidding',array("api_key"=>get_session('api_key'),"filter"=>$filter,'admarket'=>$admarket),'json');	
		//echo $this->rest->debug(); exit;		   
		echo convert_to_datatable_format($advertiser_camp_id);
	}
	
	/*
	 * 
	 * name		:add_zone_bidding
	 * @param   :Null
	 * @return  :Loads the zoneids
	 */	

	public function add_zone_bidding()
	{
		
		   $zone_list  = $this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');	
		   $unsetzone_list = $this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');			
           $zone_list_array = array();
           foreach($zone_list as $zone){
           		$zone_list_array[] = $zone['zoneid'];
           }
           $unsetzone = array();
           foreach($unsetzone_list as $unset){
           	$unsetzone = array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
           }

           $result=  array_diff($zone_list_array, $unsetzone);
           $data['zone_list'] =$result;
           echo $this->load->view('zone_limitation/modal_zone_limitation/content/add_list',$data);	
	}
	
	/*
	 * 
	 * name		:edit_zone_limitation
	 * @param   :Null
	 * @return  :Loads the zone
	 */	

	public function edit_zone_bidding($advertiser_id=false)
	{

		$zone_list= $this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');
		$unsetzone_list = $this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');			
		$zone_list_array = array();
		foreach($zone_list as $zone){
			$zone_list_array[] = $zone['zoneid'];
		}
		$unsetzone = array();
		foreach($unsetzone_list as $unset){
			$unsetzone = array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
		}

		$result=  array_diff($zone_list_array, $unsetzone);
		$data['zone_limitation_data'] = $this->rest->get('api/v1/zone_limitations/edit_zone_limitation',array("id"=>$advertiser_id,"api_key"=>get_session('api_key')),'php');
		$data['zone_list'] =array_merge($result, explode(',',$data['zone_limitation_data'][0]['zoneids']));
	 	echo $this->load->view('zone_limitation/modal_zone_limitation/content/edit_list',$data);	
	}
	
	
	
	public function filter_country($campaignid=false,$revenueid=false)
	{
		$data['campaign_data'] = $this->rest->get('api/v1/countrywise_bidding/filter_country',array("api_key"=>get_session('api_key'), "campaignid" => $campaignid, "revenueid" => $revenueid),'php');
		echo $this->load->view('bidding/modal_bidding/content/filtercountry',$data);	
	}
	
	public function traffic_sources()
	{ 
        $data['page_title'] = "Traffic Sources";
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher_traffic',array("api_key"=>get_session('api_key')),'php');
		
		$data['camp_lists']=$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['traffic_sourced_list']= $this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'php');
		
		$data['content'] = $this->load->view('special_bidding/traffic_sources',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function traffic_sources_adv_list($admarket=FALSE)
	{
		$filter	=	array(
						'campaign_type'	=>	($this->input->post('campaign_type')!='')?explode(',',$this->input->post('campaign_type')):''
					);
		if($admarket!=FALSE)
		{
			$admarket=1;
		}
		else
		{
			$admarket=0;
		}
		$advertiser_camp_id=$this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key'),'filter'=>$filter,'admarket'=>$admarket),'json');  
		
		//print_r($filter);  echo "<br/>";
		
		//echo $this->rest->debug();  die("5678");   
		
		echo convert_to_datatable_format($advertiser_camp_id);
	}
	
	
	public function zone_limitation_traffic_list()
	{  
		$filter	=	array(
						'traffic_source'	=>	($this->input->post('traffic_source')!='')?explode(',',$this->input->post('traffic_source')):''
		);  
		
		$source_id=$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array("api_key"=>get_session('api_key'),'filter'=>$filter),'json');
						
		echo convert_to_datatable_format($source_id);
	}
	
	/*public function traffic_sources_remove_list()
	{
		 $post = clean_data($this->post());
		 print_r($post); exit;
	}*/
	
	/*
	* 
	* name		:network
	* @param   :Null
	* @return  :Network page
	*/	
	 
	function networkkit()
	{		
		$data['page_title'] = 	"Media Kit";

		$data['breadcrumb'] = 	'';
		
		$data['api_key']			=	get_session('api_key');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'	=>	$data['api_key']),'php');
		
		$set = $this->config->item('report_config');
				
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'	=>	$data['api_key']),'php');
		
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
						
		$data['content'] 		= 	$this->load->view('reports/network',$data,TRUE);
				
		$this->template->set_layout('advertiser_layout');
		
		$this->template->build('view', $data);
	}
	
	public function fetch_network_stat($format='json',$c,$from_date,$to_date)
	{
		
		$api_key		=	get_session('api_key');		
		
		$account_type 	= 	get_session('account_type');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'NETWORK',
					  );
					  
		$env 		= 	$this->input->post('env');
		
		$country 	= 	$this->input->post('country');
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));		
		
		if($from_date == NULL){
		  $from_date = $this->input->post('from_date');
		}
		if($to_date == NULL){
			$to_date = $this->input->post('to_date');
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($country != 'all'){
			$input['country_id'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
			
		$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');
		
		//$this->rest->debug();
		
		echo $data;
	
	}
	//fetch top geo list
	public function fetch_top_geo_stat($format='json',$c,$from_date,$to_date)
	{
		
		$api_key		=	get_session('api_key');		
		
		$account_type 	= 	get_session('account_type');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$adv_type		=	'top_geo';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'NETWORK',
						'adv_types'		=> $adv_type,
					  );
					  
		$env 		= 	$this->input->post('env');
		
		$country 	= 	$this->input->post('country');
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$brow		= 	clean_data($this->input->post('browser'));
		$os			= 	clean_data($this->input->post('os'));
		
		if($from_date == NULL){
		  $from_date = $this->input->post('from_date');
		}
		if($to_date == NULL){
			$to_date = $this->input->post('to_date');
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($country != 'all'){
			$input['country_id'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
		
		if($brow != 'all'){
			$input['browser'] = ($brow)?((is_array($brow))?$brow:explode(',',$brow)):'';
		}
		
		if($os != 'all'){
			$input['os'] = ($os)?((is_array($os))?$os:explode(',',$os)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
			
		$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');
		//print_r($data);exit;
		//$this->rest->debug();
		
		echo $data;  
	
	}
	//top zone
	public function fetch_top_zones_list()
	{ 	   
		$topzones_list	  = $this->rest->get('api/v1/report/fetch_top_zones',array('api_key'=>get_session('api_key')),'json');			
		echo convert_to_datatable_format($topzones_list);
	}
	//top Sources
	public function fetch_top_sources_list()
	{ 
		$topsources_list	  = $this->rest->get('api/v1/report/fetch_top_sources',array('api_key'=>get_session('api_key')),'json');	
		
		echo convert_to_datatable_format($topsources_list);
	}
	
}
