<?php 

class Campaigns extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->load->library('user_authentication');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->campaigns();
	}
	
	/*
	 * 
	 * name		:campaigns
	 * @param   :Null
	 * @return  :List all the campaigns for a particular
	 *
	 */	

	public function campaigns()
	{

		$data['page_title'] 	= 	"Manage your campaign";

		$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		$data['campaign_det']	=	$campaign_details[0];
		$data['groups'] 		=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');
		$data['msg_dat']		= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');	
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['MANAGE_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('campaigns/manage_campaigns',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:fetch_campaign
	 * @param   :Null
	 * @return  :List all the creatives for a particular
	 * 			 advertiser
	 */	

	public function fetch_campaign($from_date=false,$to_date=false, $admarket = false)
	{		
		$group=$this->input->post('group');
		$status=$this->input->post('status');
		$revenue_type=$this->input->post('revenue_type');
		$group_by=$this->input->post('group_by');
		$groupby_date=$this->input->post('groupby_date');
		$startdate=$this->input->post('startdate');
		$enddate=$this->input->post('enddate');
		
		$campaigns_state=$this->input->post('campaign_state');
        //vales get from datatable source url.
		//$admarket = $this->uri->segment(4);  //if value is 1-admarketcampaigns, 0- normal campaigns

		if(!empty($group) || !empty($status) || !empty($revenue_type)|| (!empty($group_by) && $group_by != 'campaign') || !empty($groupby_date) || $from_date || $startdate)
		{ 
			
			$api_key=get_session('api_key');
			$input = array('api_key'	=>	$api_key);
			$input['group'] = ($group)?((is_array($group))?$group:explode(',',$group)):'';
			$input['status']= ($status)?((is_array($status))?$status:explode(',',$status)):'';
			$input['revenue_type']= ($revenue_type)?((is_array($revenue_type))?$revenue_type:explode(',',$revenue_type)):'';								
			//$input['group_by']=$group_by;
			$input['groupby_date']=$groupby_date;			
			$input['startdate']=$startdate;
			$input['enddate']=$enddate;
			$date_fil="date";
			 if($from_date != FALSE){
			 
			$input['date_from'] = 	$from_date;
			$input['group_by']	 =$date_fil;
	
			}else
			{
			$input['group_by']=$group_by;
		    $input['date_from'] = $startdate;

			}	
			if($to_date != FALSE){
				$input['date_to'] 	= 	$to_date;
			}
			else{
				$input['date_to'] = $enddate;
			}
	         if($group_by == false)
	         {
	         	$input['group_by']=$date_fil;
	         }
			$input['admarket']=$admarket; //admarket values pass to the campaign api.
			$campaigns		= $this->rest->get('api/v1/campaign/fetch_filter',$input,'json');
			
		}
		elseif(!empty($campaigns_state))
		{  
			$input['admarket']	 =$admarket;
			$input['campaign_state']=$campaigns_state;
			$input["api_key"]=get_session('api_key');
			$campaigns		= $this->rest->get('api/v1/campaign/fetch_filter_status',$input,'json');		 
		}
		else
		{    
			$campaigns		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key'),'admarket'=>$admarket),'json');
			
		}
		
		 
		echo convert_to_datatable_format($campaigns);  
	}
	
	public function fetch_campaign_fund($from_date=false,$to_date=false, $admarket = false)
	{
		 $admarket='0,1';
		if(!empty($campaigns_state))
		{
			$input['admarket']	 =$admarket;
			$input['campaign_state']=$campaigns_state;
			$input["api_key"]=get_session('api_key');
			$campaigns		= $this->rest->get('api/v1/campaign/fetch_filter_status',$input,'json');	
		 
		}
		else
		{    

			$campaigns		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key'),'admarket'=>$admarket),'json');
		}
		echo convert_to_datatable_format($campaigns);  
	}
	/*
	* 
	* name   : add_campaigns
	* @param : Null
	* @return: Loads a page to create a new campaign
	* 
	*/	

	public function add_campaigns()
	{
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
		
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');
		
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	     //print_r($data['campaign_type']);  die();
	
		$data['target']				=	$this->targeting_list();
		
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
		
		$data['bid_data']			=	($bid_data!='error')?$bid_data[0]:'';
			
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
			
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
			$data['campaign_det']=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		
		/**** Cookie setup-- end ************/
		
		$data['content'] = $this->load->view('campaigns/add_campaign',$data,TRUE);
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	* 
	* name   : edit_campaign
	* @param : Null
	* @return: Loads a page to edit a new campaign
	* 
	*/	

	public function edit_campaign($campaign_id=false)
	{
		if($campaign_id)
		{
			$data['page_title'] = "Optimize campaign";

			$data['breadcrumb'] = '';
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			
			//Minimum Budget & Bid Rate & creatives allowed
			$data['min_budget']		=	$this->default_configurations->get('min_budget');
			
			$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			
			$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
			
			/************ Video Enable/Disable *************/
			
			$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
			
			$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
			
			$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
			
			//Fetch Publisher
			$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
			$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
			$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
			$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
			$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
				
			//Fetch available site categories
			$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

			$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

			//Fetch Country
			$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
			
			//Fetch available campaign type
			$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
			
			$data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
			
			$data['target']				=	$this->targeting_list();
			
			$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array("api_key"=>get_session('api_key')),'php');
			
			
			$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$select_group				=	(!empty($selected_group))?$selected_group:'';
			
			
			foreach ($select_group as $sel)
			{
				$sel_group[]=$sel['group_id'];   
			}
			
			$data['sel_group']=$sel_group;
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			//Fetch Campaign details
			$campaign_details			= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				
			$data['campaign_det']		=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
								
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			/***********End campaign details*********************/
			
			$data['content'] = $this->load->view('campaigns/edit_campaigns',$data,TRUE);
			
			$this->template->set_layout('advertiser_layout');
			$this->template->build('view', $data);
		}
	}

	/*
	 * 
	 * name   : fetch_campaign_crative
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function fetch_campaign_creative($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');
					
		//Fetch available linked creatives
		$data['existing_creative']	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		//echo $this->rest->debug();exit;
		
		//print_r($data);  die("123");

		echo $this->load->view('campaigns/existing_creative',$data);

	}
	/*
	 * 
	 * name   : overview
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function overview($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');

		//Fetch Campaign details
		$camapaign_details['campaign_details']= $this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key'),"view_type"=>'formated'),'json');
		$camp_details_to_php_array=json_decode($camapaign_details['campaign_details']);//For verification
		if($camp_details_to_php_array[0]->dj_targetting_type=='WEB')
		{
			//Fetch browser targeting details
			$browser_details= $this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_browsers_display_name='';
			if(isset($browser_details[0]['data']) AND !empty($browser_details[0]['data']))
			{
				$browser_details_array=explode(',',$browser_details[0]['data']);
				foreach($browser_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_BROWSERS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_browsers_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch os targeting details
			$os_details= $this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_os_display_name='';
			if(isset($os_details[0]['data']) AND !empty($os_details[0]['data']))
			{
				$os_details_array=explode(',',$os_details[0]['data']);
				foreach($os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch time targeting details
			$time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_time_display_name='';
			if(isset($time_details[0]['data']) AND !empty($time_details[0]['data']))
			{
				$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
				$time_details_array=explode(',',$time_details[0]['data']);
				foreach($time_details_array as $value)
				{
					if(isset($targ_time_array[$value]) AND !empty($targ_time_array[$value]))
						$targetted_time_display_name.=ucfirst($targ_time_array[$value]).',';
				}
			}
			
			//Fetch geo targeting details
			$geo_details= $this->rest->get('api/v1/campaign/fetch_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_geo_display_name='';
			if(isset($geo_details[0]['data']) AND !empty($geo_details[0]['data']))
			{
				$geo_details_array=explode(',',$geo_details[0]['data']);
				foreach($geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			
			$capping=$camp_details_to_php_array[0]->capping;
			$block=$camp_details_to_php_array[0]->block/3600;
			$frequency_capping=$capping.'&nbsp;impression in '.$block.'&nbsp;Hours';
			
			//Fetch keyword targeting details

			$profile_keyword = $this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');

			$targetted_profile_keyword_display_name='';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))

			{

				$profile_keyword_array=explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_array as $value)

				{
				

					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);	

					$result = $query->result_array();
					

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targetted_profile_keyword_display_name.=ucfirst($result[0]['keyword']).',';

				}

			}

			//Fetch profile targeting details
			$profile_age= $this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_age_display_name='';
			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_array=array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');
				$profile_age_details_array=explode(',',$profile_age[0]['data']);
				foreach($profile_age_details_array as $value)
				{
					if(isset($targ_profile_age_array[$value]) AND !empty($targ_profile_age_array[$value]))
						$targetted_profile_age_display_name.=ucfirst($targ_profile_age_array[$value]).',';
				}
			}
			
			$profile_gender= $this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_gender_display_name='';
			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_array=array('male'=>'Gender: Male','female'=>'Gender: Female');
				$profile_gender_details_array=explode(',',$profile_gender[0]['data']);
				foreach($profile_gender_details_array as $value)
				{
					if(isset($targ_profile_gender_array[$value]) AND !empty($targ_profile_gender_array[$value]))
						$targetted_profile_gender_display_name.=ucfirst($targ_profile_gender_array[$value]).',';
				}
			}
			$profile_color= $this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_color_display_name='';
			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_array=array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');
				$profile_color_details_array=explode(',',$profile_color[0]['data']);
				foreach($profile_color_details_array as $value)
				{
					if(isset($targ_profile_color_array[$value]) AND !empty($targ_profile_color_array[$value]))
						$targetted_profile_color_display_name.=ucfirst($targ_profile_color_array[$value]).',';
				}
			}
			$profile_height= $this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_height_display_name='';
			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_array=array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');
				$profile_height_details_array=explode(',',$profile_height[0]['data']);
				foreach($profile_height_details_array as $value)
				{
					if(isset($targ_profile_height_array[$value]) AND !empty($targ_profile_height_array[$value]))
						$targetted_profile_height_display_name.=ucfirst($targ_profile_height_array[$value]).',';
				}
			}
			$profile_weight= $this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_weight_display_name='';
			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_array=array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');
				$profile_weight_details_array=explode(',',$profile_weight[0]['data']);
				foreach($profile_weight_details_array as $value)
				{
					if(isset($targ_profile_weight_array[$value]) AND !empty($targ_profile_weight_array[$value]))
						$targetted_profile_weight_display_name.=ucfirst($targ_profile_weight_array[$value]).',';
				}
			}
			$final_profile_targ=$targetted_profile_age_display_name.''.$targetted_profile_gender_display_name.''.$targetted_profile_color_display_name.''.$targetted_profile_height_display_name.''.$targetted_profile_weight_display_name;

			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_browsers_display_name,'targ_2'=>$targetted_os_display_name,'targ_3'=>$targetted_time_display_name,'targ_4'=>$targetted_geo_display_name,'targ_5'=>$frequency_capping,'targ_6'=>$final_profile_targ,'targ_7'=>$targetted_profile_keyword_display_name)
			);
		}
		elseif($camp_details_to_php_array[0]->dj_targetting_type=='MOBILE')
		{
			//Fetch mobile os targeting details
			$mobile_os_details= $this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_os_display_name='';
			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_details_array=explode(',',$mobile_os_details[0]['data']);
				foreach($mobile_os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details
			$mobile_manu_details= $this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_manu_display_name='';
			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_details_array=explode(',',$mobile_manu_details[0]['data']);
				foreach($mobile_manu_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_MANU);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_manu_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch mobile capability details
			$mobile_capa_details= $this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_capa_display_name='';
			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_details_array=explode(',',$mobile_capa_details[0]['data']);
				foreach($mobile_capa_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_capa_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch mobile tecom details
			$mobile_telecom_details= $this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_telecom_display_name='';
			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{
				$mobile_telecom_details_array=explode(',',$mobile_telecom_details[0]['data']);
				foreach($mobile_telecom_details_array as $value)
				{
					$this->db->select("id as id,CONCAT(country,'-',carriername) as name",false);
					$this->db->where('id',$value);
					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		
					$result = $query->result_array();
					if(isset($result[0]['id']) AND !empty($result[0]['name']))
						$targetted_mob_telecom_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch moblie geo targetting details
			$mobile_geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_geo_display_name='';
			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_details_array=explode(',',$mobile_geo_details[0]['data']);
				foreach($mobile_geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}


            ///Fetch keyword targeting details

			$profile_keyword= $this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');

			$targetted_profile_keyword_display_name='';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))

			{

				$profile_keyword_array=explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_array as $value)

				{

					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);		

					$result = $query->result_array();

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targetted_profile_keyword_display_name.=ucfirst($result[0]['keyword']).',';

				}

			}
			
			

			//Fetch profile targeting details
			$profile_age= $this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_age_display_name='';
			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_array=array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');
				$profile_age_details_array=explode(',',$profile_age[0]['data']);
				foreach($profile_age_details_array as $value)
				{
					if(isset($targ_profile_age_array[$value]) AND !empty($targ_profile_age_array[$value]))
						$targetted_profile_age_display_name.=ucfirst($targ_profile_age_array[$value]).',';
				}
			}
			
			$profile_gender= $this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_gender_display_name='';
			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_array=array('male'=>'Gender: Male','female'=>'Gender: Female');
				$profile_gender_details_array=explode(',',$profile_gender[0]['data']);
				foreach($profile_gender_details_array as $value)
				{
					if(isset($targ_profile_gender_array[$value]) AND !empty($targ_profile_gender_array[$value]))
						$targetted_profile_gender_display_name.=ucfirst($targ_profile_gender_array[$value]).',';
				}
			}
			$profile_color= $this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_color_display_name='';
			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_array=array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');
				$profile_color_details_array=explode(',',$profile_color[0]['data']);
				foreach($profile_color_details_array as $value)
				{
					if(isset($targ_profile_color_array[$value]) AND !empty($targ_profile_color_array[$value]))
						$targetted_profile_color_display_name.=ucfirst($targ_profile_color_array[$value]).',';
				}
			}
			$profile_height= $this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_height_display_name='';
			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_array=array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');
				$profile_height_details_array=explode(',',$profile_height[0]['data']);
				foreach($profile_height_details_array as $value)
				{
					if(isset($targ_profile_height_array[$value]) AND !empty($targ_profile_height_array[$value]))
						$targetted_profile_height_display_name.=ucfirst($targ_profile_height_array[$value]).',';
				}
			}
			$profile_weight= $this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_weight_display_name='';
			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_array=array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');
				$profile_weight_details_array=explode(',',$profile_weight[0]['data']);
				foreach($profile_weight_details_array as $value)
				{
					if(isset($targ_profile_weight_array[$value]) AND !empty($targ_profile_weight_array[$value]))
						$targetted_profile_weight_display_name.=ucfirst($targ_profile_weight_array[$value]).',';
				}
			}
			$final_profile_targ=$targetted_profile_age_display_name.''.$targetted_profile_gender_display_name.''.$targetted_profile_color_display_name.''.$targetted_profile_height_display_name.''.$targetted_profile_weight_display_name;

			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_mob_os_display_name,'targ_2'=>$targetted_mob_manu_display_name,'targ_3'=>$targetted_mob_capa_display_name,'targ_4'=>$targetted_mob_telecom_display_name,'targ_5'=>$targetted_mob_geo_display_name,'targ_6'=>$final_profile_targ,'targ_7'=>$targetted_profile_keyword_display_name)
			);
		}

		$existing_creative	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		if(!empty($existing_creative))
			$no_of_creative['no_of_linked_creative']=sizeof($existing_creative);
		else
			$no_of_creative['no_of_linked_creative']='0';
		
		$result_tmp=array_merge($camapaign_details,$no_of_creative);
		
		if(isset($final_targeting))
		{
			$result=json_encode(array_merge($result_tmp,$final_targeting));
			print_r($result);
		}
		else
		{
			$result=json_encode($result_tmp);
			print_r($result);
		}
		
		
	}

	
	/*
	 * 
	 * name   : view_tracker
	 * @param : campaign_id
	 * @return: Fetch campaign tracker code for particular campaign
	 */	
	public function view_tracker($campaign_id)
	{
		$data['track_id'] = 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'json');
		
		$tracker_data		=	array();
		if($data['track_id']!='error')
		{
			$tracker_data 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>str_replace('"', "", $data['track_id']),"api_key"=>get_session('api_key')),'php');
		}
		
		$data['tracker_data']	=	$tracker_data;
		
		echo $this->load->view('campaigns/view_trackers_content',$data);		
	}
	
	public function targeting_list()
	{
		$api_key		=	get_session('api_key');
		
		$data['browsers']	= 	$this->rest->get('api/v1/utilities/fetch_target_browsers',array("api_key"=>$api_key),'php');
		
		$data['language']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'language'),'php');
		
		$data['os_set']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'os_set'),'php');
		
		$data['os']			= 	$this->rest->get('api/v1/utilities/fetch_target_os',array("api_key"=>$api_key),'php');
		
		$data['keywords']	= 	$this->rest->get('api/v1/utilities/fetch_target_keyword',array("api_key"=>$api_key),'php');
		
		$data['mobile_os']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_os',array("api_key"=>$api_key),'php');
		
		$data['manu']		= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_manu',array("api_key"=>$api_key),'php');
		
		$data['capability']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_capability',array("api_key"=>$api_key),'php');
		
		$data['carrier']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_carrier',array("api_key"=>$api_key),'php');
		
		$data['continent']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'continent'),'php');
		
		$data['countries']	= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>$api_key),'php');
		
		$data['time']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		
		$data['days']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'days'),'php');
		
		$data['dev_type']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'dev_type'),'php');
		
		$data['device']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'device'),'php');
		
		$data['connection']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'connection'),'php');
		
		
		return $data;
	}
	
	public function add_group()
	{
		$data	=	'';
		$api_key=	get_session('api_key'); 
		echo $this->load->view('creatives/modal_creatives/content/add_group',$data);	
	}
	
	/*
	* 
	* name   : duplicate
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function duplicate($campaignid=false,$campname=false)
	{
		//Fetch Country
		$data['countries']		= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>get_session("api_key")),'php');
		
		//Fetch available campaign type
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
		$data['campaignid']		=	$campaignid;
		
		$data['campname']		=	$campname;
		
		echo $this->load->view('campaigns/duplicate_campaign_multiple',$data);		
	}
	
	
	public function view_creative_demo($campaign_id=false)
	{
		$data['campaign_id']	= $campaign_id;
		
		$data['campaign_data'] = 	$this->rest->get('api/v1/creative/fetch_demo_creative_campaign',array("cam_id"=>$data['campaign_id'],"api_key"=>get_session('api_key')),'php');
		//echo "<pre>"; print_r($data['campaign_data']); echo "</pre>";die("ddd");
		foreach($data['campaign_data'] as $val)
		{
		        $banner_type[]=$val['banner_type'];
		      	//echo 'api/v1/creative/fetch_demo_additional_creative',array("creative_id"=>$val['bannerid']);die("ddd");
		      	if( $val['banner_type']=="M_MR_REV" || $val['banner_type']=="W_SS" || $val['banner_type']=="M_RS_PL" || $val['banner_type']=="M_RS_FL" || $val['banner_type']=="M_RS_FS" || $val['banner_type']=="W_GB" || $val['banner_type']="W_BB" || $val['banner_type']=="M_MR_EXP" || $val['banner_type']=="M_RS_ADH"|| $val['banner_type']=="W_SS")
		      	{
			      $additional_banners[]=$this->rest->get('api/v1/creative/fetch_demo_additional_creative',array("creative_id"=>$val['bannerid'],"api_key"=>get_session('api_key')),'php');
			    } 
			
	    }	
	    $data['bannertype']=$banner_type;
	    $data['additional_banners']=$additional_banners;
		//echo "<pre>";print_r($data['additional_banners']); echo "</pre>";die("ddd12");
		echo $this->load->view('campaigns/view_creative_content',$data);	
    }	

    /*
	 * 
	 * name   : view_retarget_tracker
	 * @param : campaign_id
	 * @return: Fetch campaign tracker code for particular campaign
	 */	
	public function view_retargeting($campaign_id)
	{
		 
		//$data['track_id'] = 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'json');
		
		/*$tracker_data		=	array();
		if($data['track_id']!='error')
		{
			$tracker_data 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>str_replace('"', "", $data['track_id']),"api_key"=>get_session('api_key')),'php');
		}
		*/
		$data['campaignid']	=	$campaign_id;
		
		echo $this->load->view('campaigns/view_retargeting_content',$data);		
	}
	public function fetch_min_bid()
	{
		$data	=	'';
		$api_key=	get_session('api_key'); 
		echo $this->load->view('creatives/modal_creatives/content/min_bid',$data);	
	}
	 public function fetch_datatable_bid()
	 {
	    $browser_admin		= $this->rest->get('api/v1/campaign/country_bid',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($browser_admin);
	 }	

	public function fetch_targeting_elements($campaign_id=false)
	{

		$data	= '';
		
		//print_r($data);  die("123");

		echo $this->load->view('campaigns/target_visitors',$data);

	}	 
	 	
}
