<?php 
class Admarket extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{ 
		$this->publishers_list();  
	}
	
	public function publishers_list($from_date=FALSE,$to_date=FALSE)
	{ 			
		$filter	=	array(
						'pub_account_id'	=>	($this->input->post('account_id')!='')?explode(',',$this->input->post('account_id')):''						
					);
		$publisher_list=$this->rest->get('api/v1/admarket/fetch_publisher_list',array("api_key"=>get_session('api_key'),'admarket'=>1, 'filter'=>$filter,'from_date'=>$from_date,'to_date'=>$to_date),'json');
		
		//$publisher_list=$this->rest->get('api/v1/publisher/fetch_publisher_list',array("api_key"=>get_session('api_key'),'filter'=>$filter,'from_date'=>$from_date,'to_date'=>$to_date),'json');	
		
		//echo $this->rest->debug();  die("123");  
							
		echo convert_to_datatable_format($publisher_list);   
	}	
	
	public function denied_publishers_list($from_date=FALSE,$to_date=FALSE)
	{
		$filter	=	array(
						'pub_account_id'	=>	($this->input->post('account_id')!='')?explode(',',$this->input->post('account_id')):''						
					);
		$publisher_list=$this->rest->get('api/v1/admarket/fetch_denied_publisher_list',array("api_key"=>get_session('api_key'),'filter'=>$filter,'from_date'=>$from_date,'to_date'=>$to_date),'json');	
		
		//echo $this->rest->debug();  die("2334");
										
		echo convert_to_datatable_format($publisher_list);         
		
	}
	
	public function all_publishers_list($from_date=FALSE,$to_date=FALSE)
	{
		$filter	=	array(
						'pub_account_id'	=>	($this->input->post('account_id')!='')?explode(',',$this->input->post('account_id')):''						
					);
		$publisher_list=$this->rest->get('api/v1/admarket/fetch_all_publisher_list',array("api_key"=>get_session('api_key'),'filter'=>$filter,'from_date'=>$from_date,'to_date'=>$to_date),'json');	
		
		//echo $this->rest->debug();  die("2334");  
										
		echo convert_to_datatable_format($publisher_list);    
	}
	
	public function add_pixel_tracker()
	{				
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');  
						
		echo $this->load->view('admarket/tracker/modal_tracker/content/add_tracker',$data);	
	}
	
	public function fetch_pixel_list()
	{
		$filter	=	array(
						'pixel_type'	=>	($this->input->post('pixel_type')!='')?explode(',',$this->input->post('pixel_type')):''						
					);
		
		$tracker_list	  = $this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key'),"admarket"=>'1','filter'=>$filter),'json');	   

		//echo $this->rest->debug();  die("testing");
		
		echo convert_to_datatable_format($tracker_list);  
	}
	
	public function tracker()
	{
		$data['page_title'] = $this->lang->line('admarket_pixel_tracker');
		
		$data['content'] = $this->load->view('admarket/tracker/pixel_tracker',$data,TRUE);
		
		$this->template->set_layout('advertiser_layout');  
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:edit_pixel_tracker
	 * @param   :Null
	 * @return  :Loads the pixel
	 */	

	public function edit_pixel_tracker($tracker_id=false)
	{
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		//Fetch available campaign's	
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
			
		$data['tracker_data'] 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key'),"admarket"=>'1'),'php');
						
		echo $this->load->view('admarket/tracker/modal_tracker/content/edit_tracker',$data);	         
	}
	
}