<?php
Class Do_zonelimitations extends CI_Model
{
	  function list_zone()
	 { 
		$key = 'list_zone';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	  	$this->db->select('zoneid');	
	  	$this->db->where('dj_is_deleted','0');
	  	$query = $this->db->get(TAB_ZONES);	
	   if($query->num_rows() >0)
		{
		$result = 	$query->result_array();
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}else{
		return FALSE;	
		} 
		}
	 }
	 
	 function list_filter_zone($filter=FALSE)
	 { 
		$key = 'list_filter_zone';
		if($filter!=FALSE)
		{
			$key.='_'.$filter;
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	  	$this->db->select('zoneid,zonename');	
	  	$this->db->where('dj_is_deleted','0');
		if($filter!=FALSE)
		{			
			$this->db->where_in('affiliateid',$filter);
		}
	  	$query = $this->db->get(TAB_ZONES);		
		
	    if($query->num_rows() >0)
		{
		$result = 	$query->result_array();
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}else{
		return FALSE;	
		} 
		}
	 }

	 function list_traffic_source()
	 {
		$key = 'list_traffic_source';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	  	$this->db->select('affiliateid,name');	
	  	$this->db->where('dj_is_deleted','0');
	  	$query = $this->db->get(TAB_AFFILIATE);	
	   if($query->num_rows() >0)
		{
		$result = 	$query->result_array();
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
				return FALSE;	
		} 
		}
	 }	

	function add_pub_zonelimitation($pub_limitation_data)
	{
		if($pub_limitation_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_ZONE_PUB_LIT,$pub_limitation_data);
			
			$zonelimit_id=$this->db->insert_id();
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $zonelimit_id;
			}	
		}
		
	}
	 
	 
	function add_zonelimitation($limitation_data)
	{
		if($limitation_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_ZONE_LIT,$limitation_data);
			
			$zonelimit_id=$this->db->insert_id();
			$this->db->trans_complete();
			
			$this->memcached_library->set(ADV_ZONE_LIMITATIONS,'1');
			$this->memcached_library->set(ADV_ZONE_LIMITATIONS_EDIT,'1');
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $zonelimit_id;
			}	
		}
	}
	 

	 
	function list_zone_limitations($account_id=FALSE,$adblock_type=FALSE,$filter=FALSE,$zonelimits=FALSE)
	{		
		$key ='list_zone_limitations';
		if($account_id!=FALSE)
		{
		$key.= '_'.$account_id;
		}
		if($adblock_type!=FALSE)
		{
		$key.='_'.$adblock_type;
		}
		
		if($filter!=FALSE):
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;			
		
		$ret = $this->memcached_library->get($key);
		$check_db_changes = $this->memcached_library->get(ADV_ZONE_LIMITATIONS);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{		
		
			$SQL = "SELECT a.advertiserid as id,a.adblock_list_name as name,IF(a.adblock_type=0, 'Black List', 'White List') as type,a.selected_zone_ids as zoneids,a.bid_rate as bid_rate,
					oxc.clientname
					FROM ".TAB_ZONE_LIT." as a 
					JOIN ".TAB_CLIENTS." as oxc ON oxc.account_id=a.account_id ";
					//JOIN ".TAB_ZONE_PUB_LIT." as lit ON lit.zone_limit_id=a.advertiserid AND lit.account_id=oxc.account_id   
					//WHERE 1";
						if($account_id!=FALSE)
						{		
							$SQL .= " AND a.account_id=".$account_id."";
						}	
						if($zonelimits!=FALSE)
						{		
							$SQL .= " AND a.advertiserid in (".$zonelimits.") ";
						}
						if($adblock_type!=FALSE)
						{		
							if($adblock_type=='black')
							{
								$atype	=	0;
							}
							elseif($adblock_type=='white')
							{
								$atype	=	1;
							}
							
							$SQL .= " AND a.adblock_type=".$atype."";
						}	
						if($filter!=FALSE && $filter['traffic_source']!=FALSE)
						{
							$traffic_source=implode(",",$filter['traffic_source']);
							$SQL .= " AND lit.publisher_id in(".$traffic_source.")";
						}
						if($filter!=FALSE && $filter['zone_id']!=FALSE)
						{	
							$zone_id=implode(",",$filter['zone_id']);							
							$SQL .= " AND lit.zone_id IN(".$zone_id.")";
						}				
						$SQL .= " group by a.advertiserid  ORDER BY a.advertiserid DESC";
						
					
							
			$query = $this->db->query($SQL);
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				$i=0;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$i+1;
					$i+=1;
				}		
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(ADV_ZONE_LIMITATIONS,'2');
					$set = $this->memcached_library->get($key);	 
					return $set;
				}
				else
					return $result;
				
			}else{
					return FALSE;	
			}
			
		}
	}
	
	function list_bindzone_list($account_id)
	{


		if($account_id)
		{
			$SQL = "SELECT selected_zone_ids FROM ".TAB_ZONE_LIT." WHERE  account_id=".$account_id;					
		}
			
		$query = $this->db->query($SQL);
		
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();

				return $result;
		}else{
				return FALSE;	
		}
		}
	function edit_zone_limitation($id=false)
	{
		
		$key = 'edit_zone_limitation_'.$id;
		$ret = $this->memcached_library->get($key);
		$check_db_changes = $this->memcached_library->get(ADV_ZONE_LIMITATIONS_EDIT);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
		
		//$SQL 	= 	"SELECT advertiserid as id,adblock_list_name as name,adblock_type as type,selected_zone_ids as zoneids,account_id,bid_rate,site_type,site_id FROM ".TAB_ZONE_LIT." where advertiserid=".$id."";					
		
		$SQL 	= 	"SELECT advertiserid as id,adblock_list_name as name,adblock_type as type,selected_zone_ids as zoneids,selected_site_ids,account_id,bid_rate FROM ".TAB_ZONE_LIT." where advertiserid=".$id."";					
		
		
		$query 	= 	$this->db->query($SQL);
				
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();   
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set(ADV_ZONE_LIMITATIONS_EDIT,'2');
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
		}else{
				return FALSE;	
		}
		
	}
	
}

	function edit_zonelimitation($limitation_data,$advertiser_id)
	{
		
		if($limitation_data)
		{
			$this->db->trans_start();
			
			$this->db->where('advertiserid',$advertiser_id);

			$this->db->update(TAB_ZONE_LIT,$limitation_data);
			
			$this->memcached_library->set(ADV_ZONE_LIMITATIONS,'1');
			$this->memcached_library->set(ADV_ZONE_LIMITATIONS_EDIT,'1');
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
	
		}
		
	}
	
	function delete_zonelimitations($zonelimitation_id=false)
	{ 
		if($zonelimitation_id)
		{

			$this->db->trans_start();			

			$this->db->where('advertiserid',$zonelimitation_id); 

			$this->db->delete(TAB_ZONE_LIT);

				

			$this->memcached_library->set(ADV_ZONE_LIMITATIONS,'1');
			$this->memcached_library->set(ADV_ZONE_LIMITATIONS_EDIT,'1');
			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;

		

	}

	function get_zonelimitations($zonelimitation_id=false) 
	{
		
		if($zonelimitation_id)
		{
			$this->db->select('*');			

			$this->db->where('advertiserid',$zonelimitation_id); 

			$result = $this->db->get(TAB_ZONE_LIT);

			$zone_limit_data = $result->result_array();
			
			return $zone_limit_data;

		}

		else

			return FALSE;
		
	}
	
	function fetch_publisher($zoneid)
	{
		$result = $this->db->query('select ox_z.affiliateid,aff.account_id,ox_z.zonename from '.TAB_ZONES.' as ox_z join '.TAB_AFFILIATE.' as aff where zoneid IN('.$zoneid.') and aff.affiliateid= ox_z.affiliateid');
		
		//return $this->db->last_query();
		return $result->result_array();
		
	}
	function check_zone_lists($account_id,$ids)
	{
		$this->db->select('selected_zone_ids');	
	  	$this->db->where('account_id',$account_id);
	  	$this->db->like('selected_zone_ids', $ids); 
	  	$query = $this->db->get(TAB_ZONE_LIT);	//return $this->db->last_query();
		if($query->num_rows() >0)
		{
			return '1';
		}
		else return '2';
	}
	
	function add_zonelimits($zone_data)
	{
		if($zone_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_ZONE_LIT,$zone_data);
			
			$tracker_id		=	$this->db->insert_id();
		 
			$this->memcached_library->set(ADVERTISER_ZONELIMIT_LIST,'1');
			
						
			$this->db->trans_complete();
			
			if($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $tracker_id;
			}	
		}
	}	
	
	function list_url_data()
	{
		$this->db->select('site_id,account_id,site_name,site_url');	
	  	$this->db->where('is_deleted','0');
	  	$this->db->where('status','0');
	  
	  	$query = $this->db->get(TAB_PUB_SITES);	
		if($query->num_rows() >0)
		{
			$site_url_list = $query->result_array();
			return $site_url_list;
		}
	
	}
	function list_url_site_data()
	{
		$result = $this->db->query('select 	b.zone_id,a.site_url,a.site_id from djax_publisher_sites as a join djax_site_zone_assoc as b on a.site_id = b.site_id');
		return $result->result_array();
	}
	function fetch_sitelist_url_data($site=false)
	{
		$this->db->select('site_id,account_id,site_name,site_url');	
	  	$this->db->where('is_deleted','0');
	  	$this->db->where('status','0');
	  	$this->db->where_in('site_id',$site);
	  
	  	$query = $this->db->get(TAB_PUB_SITES);	//return $this->db->last_query();
		if($query->num_rows() >0)
		{
			$site_url_list = $query->result_array();
			return $site_url_list;
		}
	
	}
}
?>
