<?php
class Do_video_creative extends CI_Model
{
	 /*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Lists a video creative of an advertiser
	 */
	function check_companion_size($campaign_id=false,$width=false,$height=false)
	{
		$where	=	array(
							'width'			=>	$width,
							'height'		=>	$height,
							'campaignid'	=>	$campaign_id,
							'storagetype'	=>	'web',
							'dj_banner_type'=>	WEB_CREATIVE_WEB,
							'dj_is_deleted'	=>	'0'
						);
						
		$this->db->select('bannerid,description,filename,storagetype,width,height');		
		$this->db->where($where);
		$this->db->order_by('dj_added_date ');
		$query 	= 	$this->db->get(TAB_BANNERS);		
		$result = 	$query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: add_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Add the video creative into the database
	 */
	
	function add_video($creative_data,$agencyid=FALSE)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_BANNERS,$creative_data);
			
			$creative_id	= $this->db->insert_id();
			
			if($agencyid!=FALSE)
			{
				// Process of auto link adblocks
				if($creative_data['dj_admarket_status']!='1')
				{
					$this->do_auto_link->link_adblocks($creative_id,$agencyid);
				}
			}
			
			$this->db->trans_complete();
			$this->memcached_library->set(FETCH_CREATIVES,'1');
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				
				return $creative_id;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: add_video_vast
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Add the video vast creative into the database
	 */
	
	function add_video_vast($creative_data)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banner_vast_element */
			$this->db->insert(TAB_BAN_VAST_ELE,$creative_data);

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: update_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Update the video creative into the database
	 */
	
	function update_video($creative_data,$creative_id,$agencyid=FALSE)
	{
		
		
		if($creative_data)
		{
			$this->db->trans_start();
			/*Update in ox_banners */
			$this->db->where('bannerid',$creative_id);
			$this->db->update(TAB_BANNERS,$creative_data);
			$this->memcached_library->set(FETCH_CREATIVES,'1');
			$this->memcached_library->set(FETCH_MODAL_CREATIVES,'1');
			$this->memcached_library->set(FETCH_VIDEO_MEMCACHE_INLINE,'1');
			$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$creative_id,'1');
			
			// Process of auto link adblocks
			if($agencyid!=FALSE)
			{
				if($creative_data['dj_admarket_status']!='1')
				{
					$this->do_auto_link->link_adblocks($creative_id,$agencyid);
				}
			}
			
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: update_video_vast
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Update the video vast creative into the database
	 */
	
	function update_video_vast($creative_data,$creative_id)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Update in ox_banner_vast_element */
			$this->db->where('banner_id',$creative_id);
			$this->db->update(TAB_BAN_VAST_ELE,$creative_data);
			$this->memcached_library->set(FETCH_CREATIVES,'1');
			$this->memcached_library->set(FETCH_MODAL_CREATIVES,'1');
			$this->memcached_library->set(FETCH_VIDEO_VAST_MEMCACHE_INLINE,'1');
			$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$creative_id,'1');
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Get the video creative from the database
	 */
	
	function fetch_video($creative_id)
	{	
		
		
		$key = 'fetch_video_'.$creative_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_VIDEO_MEMCACHE_INLINE);

		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
			
		if($creative_id)
		{	
			
			//echo $creative_id;
			/*Get records from ox_banner_vast_element */
			$this->db->where('bannerid',$creative_id);
			$query	=	$this->db->get(TAB_BANNERS);
			$result	=	$query->result_array();
			
			if($result)
			{
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);
			$this->memcached_library->set(FETCH_VIDEO_MEMCACHE_INLINE,'2');	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
			}
			else
				return FALSE;
		}
		else
			return FALSE;
		}
		
	}
	
	
	
	
	function add_small_image($creative_data)
	{
		
		if($creative_data)
		{
			$this->db->insert(TAB_BAN_DEPEND,$creative_data);
			
				return true;		
		}
		else{
			return FALSE;
		}
		
	}

/*
	 * 
	 * name: fetch_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Get the video creative from the database
	 */
	
	function fetch_small_image($creative_id)
	{	
		
		
		$key = 'fetch_small_image'.$creative_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			
		if($creative_id)
		{	
			
			//echo $creative_id;
			/*Get records from ox_banner_vast_element */
			$this->db->where('banner_id',$creative_id);
			$query	=	$this->db->get(TAB_BAN_DEPEND);
			
			$result	=	$query->result_array();
			
			if($result)
			{
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
			
		}
		else
			return FALSE;
		}
	}
		
	}
	
	
	function update_small_image($creative_id,$creative_data,$type)
	{
		
		if($creative_data)
		{
			if(!empty($type))
			{
				$this->db->where('display_type',$type);
			}				
			$this->db->where('banner_id',$creative_id);
			$this->db->update(TAB_BAN_DEPEND,$creative_data);
			
				return true;		
		}
		else{
			return FALSE;
		}
		
	}
	
	
	
	
	
	/*
	 * 
	 * name: fetch_video_vast
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Get the video vast creative from the database
	 */
	
	function fetch_video_vast($creative_id)
	{
			
			
			
		$key = 'fetch_video_vast'.$creative_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_VIDEO_VAST_MEMCACHE_INLINE);
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
					
		if($creative_id)
		{
			/*Get records from ox_banner_vast_element */
			$this->db->where('banner_id',$creative_id);
			$query	=	$this->db->get(TAB_BAN_VAST_ELE);
			$result	=	$query->result_array();
			if($result)
			{
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$this->memcached_library->set(FETCH_VIDEO_VAST_MEMCACHE_INLINE,'2');
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
			}
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
}

}
