<?php
Class Do_tracker extends CI_Model
{
	
	/*   djax_targ_country
	 * ---------------------
	 * name
	 * value
	 * status
	 * */
	 function fetch_tracker_name($campaign_id=FALSE)
	{
		
		$key = 'fetch_tracker_'.$campaign_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		$check_db_changes = $this->memcached_library->get(ADV_TRACKER_LIST);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{	
			
			$this->db->select('trackername');
			$this->db->join(TAB_CAM_TRACKERS.' as oxct','oxct.trackerid=oxt.trackerid');
			$this->db->where('oxct.campaignid',$campaign_id);
			$query 	= 	$this->db->get(TAB_TRACKERS.' as oxt');		
			$result = 	$query->result_array();
								
			if($query->num_rows>0)
			{	
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(ADV_TRACKER_LIST,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				
				return FALSE;
			} 
		}
	}	 
	 
	function fetch_tracker($tracker_id=FALSE,$account_id=FALSE,$global_tracker=FALSE,$admarket=FALSE,$filter=FALSE,$is_house_pixel=FALSE)
	{
		
		$key = 'fetch_tracker_'.$tracker_id.$account_id.$global_tracker;
		if($tracker_id!=FALSE)
		{
			$key.='_'.$tracker_id;
		}
		if($account_id!=FALSE)
		{
			$key.='_'.$account_id;
		}
		if($global_tracker!=FALSE)
		{
			$key.='_'.$global_tracker;
		}
		if($filter!=FALSE)
		{
			$key.='_'.$filter;
		}
	
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		$check_db_changes = $this->memcached_library->get(ADV_TRACKER_LIST);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
		
			if($tracker_id!=FALSE)
			{
				$this->db->where_in('oxt.trackerid',$tracker_id);
			}
			if($global_tracker!=FALSE)
			{
				if($global_tracker==1)
				{
					$this->db->where_in('oxt.pixel_type',array('s2s','mobile_s2s'));
				}
				else
				{
					$this->db->where_in('oxt.pixel_type',array('html'));
				}
			}
			if($account_id!=FALSE)
			{
				$this->db->where('oxcl.account_id',$account_id);
			}
			
			if($admarket!=FALSE)
			{
				$this->db->where('oxt.admarket',$admarket);
			} 
			else
			{
				$this->db->where('oxt.admarket','0');
			}
			if($is_house_pixel=='housead' )
			{ 
				 $this->db->where('oxcl.clientid','1');
			}
			else
			{
				$this->db->where('oxcl.clientid !=','1');
			}			
				
			if($filter!=FALSE){
					if($filter!=FALSE && $filter['pixel_type']!=FALSE)
						{							
							$this->db->where_in('oxt.pixel_type',$filter['pixel_type']);
						}						
					}
			
			//$this->db->select('oxt.*,oxct.campaignid,oxc.campaignname,oxcl.clientname');
			$this->db->select('oxt.*,oxcl.clientname');
			$this->db->join(TAB_CLIENTS.'as oxcl','oxcl.clientid=oxt.clientid','left');
			//$this->db->join(TAB_CAM_TRACKERS.' as oxct','oxct.trackerid=oxt.trackerid','left');
			//$this->db->join(TAB_CAMPAIGNS.' as oxc','oxc.campaignid=oxct.campaignid','left');
			$this->db->order_by('oxt.trackerid','DESC');
			$query 	= 	$this->db->get(TAB_TRACKERS.' as oxt');
		
			$result = 	$query->result_array();
		//return $this->db->last_query();
			
						
			if($query->num_rows>0)
			{	
				$count	=	$query->num_rows();
				$i	=	0;	$j	=	$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				//return $result;
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(ADV_TRACKER_LIST,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				
				return FALSE;
			} 
		}
	}
	
	function add_tracker($pixel_data,$campaign_id=FALSE)
	{
		if($pixel_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_TRACKERS,$pixel_data);    
			
			$tracker_id		=	$this->db->insert_id();
			if($campaign_id!=FALSE)
			{
				$tracker_data	=	array(
										"campaignid"			=>	$campaign_id,
										"trackerid"				=>	$tracker_id
									);
									
				$this->db->insert(TAB_CAM_TRACKERS,$tracker_data);
			}
			$this->memcached_library->set(ADV_TRACKER_LIST,'1');
			
			/*************message requirements***************/
			
				/*$client_id 		=	$this->user_authentication->client_id;
				$account_id 		=	$this->user_authentication->account_id;
				$acc_type	=	$this->user_authentication->account_type;
				$network_id	=	$this->do_message->fetch_admin_network_id();
				$message  = $this->default_configurations->get('message_type');	
			
				if($acc_type=='TRAFFICKER')
				{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$reciever = $this->do_message->get_affiliate($affiliate_id); 
				}
				else
				{
				$reciever= $this->do_message->get_profile($account_id);
				}
				
				if($acc_type=='TRAFFICKER')
				{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$user = $this->do_message->get_affiliate($affiliate_id); 
				}
				else{ 
						$user = $this->do_message->get_profile('2'); 
				}
			
			//	return $reciever;
				$type_details		=	array(
											'msg_type'		=> $message,
											'type'			=> "ADMIN_MESSAGE_SETTINGS",
											'string'		=> "pixel_track_add",
											'column_name'	=> "campaigns"
										);
				$message_data		=	array(
											'sender_id'		=>	'2',
											'receiver_id'	=>	$reciever['account_id'],
											'subject'		=>	'Pixel Track added',
											'content'		=>	'A new pixel tracker has been added <br><table><tr><td>'.$pixel_data['trackername'].'</td></tr></table>',
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	$acc_type,
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')
											);
								
									
									//return $reciever;
				/*********Message Requirements**************/
				

				//$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
			
			
			
			$this->db->trans_complete();
			
			if($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $tracker_id;
			}	
		}
	}	
	
	
	function fetch_tracker_details($tracker_id)
	{
		$result = $this->db->query('select * from '.TAB_TRACKERS.' where trackerid='.$tracker_id);
		return $result->result_array();
	}
		
	
	function edit_tracker($pixel_data,$tracker_id=FALSE)
	{
		if($pixel_data)
		{
			$this->db->trans_start();
			
			$this->db->where('trackerid',$tracker_id);

			$this->db->update(TAB_TRACKERS,$pixel_data);
			
			$this->memcached_library->set(ADV_TRACKER_LIST,'1');
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}	
		}
	}
	
	/* 

	* Delete the countrybidding

	*/

	function delete_tracker($tracker_id=false)
	{	 		 
		if($tracker_id)
		{
			$this->db->trans_start();			

			$this->db->where('trackerid',$tracker_id); 

			$this->db->delete(TAB_CAM_TRACKERS);
			
			$this->db->where('trackerid',$tracker_id); 

			$this->db->delete(TAB_TRACKERS);
			
			$this->memcached_library->set(ADV_TRACKER_LIST,'1');
			
			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;	

	}
	
	/*
	 * name: fetch_campaign_tracker
	 * @param
	 * @return
	 *
	 * This method get the campaign corresponding tracker code
	 * 
	 */

	function fetch_campaign_tracker($campaign_id=false)
	{		
		if($campaign_id)
		{
			$this->db->select('trackerid,cookieless_tracker');
			
			if($campaign_id!=false)
			{
				$this->db->where('campaignid',$campaign_id);
				$this->db->order_by('campaign_trackerid', 'desc');
			}
			
			$query = $this->db->get(TAB_CAM_TRACKERS);		
			
			$result = $query->result_array();			
			
			if($query->num_rows()>0)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	/*
	 * name: fetch_tracker_campaign
	 * @param
	 * @return
	 *
	 * This method get the campaign corresponding tracker code
	 * 
	 */

	function fetch_tracker_campaign($tracker_id=false)
	{	
		//	return $tracker_id;
		if($tracker_id)
		{
			$this->db->select('*');
			
			if($tracker_id!=false)
			{
				$this->db->where('trackerid',$tracker_id);
			}
									
			$query = $this->db->get(TAB_CAM_TRACKERS);		
			
			$result = $query->result_array();			
			
			if($query->num_rows()>0)
				return $result;
			else
				return FALSE;
		}
		else{
			return FALSE;
		}
	}
	
	function fetch_admarket_tracker_campaign($tracker_id=false,$admarket=false)
	{		
		if($tracker_id)
		{
			$this->db->select('*');
			$this->db->join(TAB_CAM_TRACKERS.' as oxct','oxct.trackerid=oxt.trackerid');
			$this->db->where('oxt.trackerid',$tracker_id);
			if($admarket!=false)
			{
				$this->db->where('oxt.admarket',$admarket);
			}
			$query 	= 	$this->db->get(TAB_TRACKERS.' as oxt');	  	
			$result = 	$query->result_array();
			
			if($query->num_rows()>0)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;   
	}
	
	function link_campaign_tracker($tracker_id=FALSE,$campaign_id=FALSE)
	{
		$tracker_data	=	array(
									"campaignid"			=>	$campaign_id,
									"trackerid"				=>	$tracker_id
								);							
		$this->db->select('*');
		$this->db->where($tracker_data);
		$query	=	$this->db->get(TAB_CAM_TRACKERS);
		
		if($query->num_rows()>0)
		{
			return TRUE;
		}
		else
		{
			$this->db->insert(TAB_CAM_TRACKERS,$tracker_data);
			return TRUE;
		}
	}
	
	function delete_tracker_campaign($tracker_id=FALSE,$campaign_id=FALSE)
	{
		$where	=	array(
							"campaignid"			=>	$campaign_id,
							"trackerid"				=>	$tracker_id
						);
						
		$this->db->where($where); 

		if($this->db->delete(TAB_CAM_TRACKERS))
		{		
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	function update_conversion_settings($campaign_id=FALSE,$update=FALSE)
	{
		$where	=	array(
							"campaignid"	=>	$campaign_id
						);
						
		$this->db->where($where);		
		
		if($this->db->update(TAB_CAMPAIGNS,$update))
		{	
			$this->memcached_library->set(CONVERSION_CHANGES,'1');
				
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	function add_import_tracker($pixel_data=false,$pixel_data_where_data=false)
	{
		if($pixel_data)
		{
			$this->db->trans_start();
			$this->db->select('trackerid,clientid,trackername,pixel_type,pixel_category,protocol,pixel_goal,admarket');
			$this->db->where($pixel_data_where_data);
			$query=$this->db->get(TAB_TRACKERS);
			if($query->num_rows()>0)
			{ 			
			return false;
			}
			else
			{  
			$this->db->insert(TAB_TRACKERS,$pixel_data);
			
			$tracker_id		=	$this->db->insert_id();
		/*	if($campaign_id!=FALSE)
			{
				$tracker_data	=	array(
										"campaignid"			=>	$campaign_id,
										"trackerid"				=>	$tracker_id
									);
									
				$this->db->insert(TAB_CAM_TRACKERS,$tracker_data);
			}*/
			$this->memcached_library->set(ADV_TRACKER_LIST,'1');
			
						
			$this->db->trans_complete();
			
			if($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $tracker_id;
			}	
		}
		}
	}	
	
	function exists_tracker_check($trackerid=FALSE)
	{
		$this->db->select('trackerid');
		$this->db->where_in('trackerid',$trackerid);
		//$this->db->where('is_deleted','0');
		$query=$this->db->get(TAB_TRACKERS);
	
		
		if($query->num_rows()>0)
		{ 
			return $query->num_rows();
		}
		else
		{  
			return "NULL";
		}
	}
	public function update_pixel_bidding($track_id,$bid_rate)
	{
		$data = array('pixel_goal'=>$bid_rate);
		
		$this->db->update(TAB_TRACKERS,$data,array('trackerid'=>$track_id));
			
		if($this->db->affected_rows()>0)
		{
			return TRUE;	
		}
		else
		{
			return FALSE;	
		}
	}
	public function fetch_eventLogs($account_id)
	{
		$today = date("Y-m-d").' 00:00:00';
		$from_date = date("Y-m-d"." 23:59:59", strtotime("59 days ago"));
		 //$this->db->select("c.id,DATE_FORMAT(c.date_time,'%d-%m-%Y' ) as date_time,c.tracker_id,c.creative_id,c.zone_id,c.status,c.price,c.dj_publisher_revenue,c.udid,c.variables,c.operating_system,c.browser_name,c.browser_language");
		 $sql= "select c.id,DATE_FORMAT(c.date_time,'%d-%m-%Y' ) as date_time,c.tracker_id,c.creative_id,c.zone_id,c.status,c.price,c.dj_publisher_revenue,c.udid,c.variables,c.operating_system,c.browser_name,c.browser_language from djax_conversion_list as c ";
		$sql.=" join rv_banners as ba on ba.bannerid = c.creative_id where ba.dj_account_id='".$account_id."' and (date_time BETWEEN '".$from_date."' AND '".$today."')";
		  
		 $query = $this->db->query($sql);
		 
	//	 $this->db->join(TAB_BANNERS.' as ba','ba.bannerid = c.creative_id');
		// $this->db->where('ba.dj_account_id',$account_id);
		// $query=$this->db->get(TAB_CONV_LIST.' as c');
		 
		 return $query->result_array();			
	}
	
	
}
