<?php
Class Do_template extends CI_Model
{
	
	/*   djax_targ_country
	 * ---------------------
	 * name
	 * value
	 * status
	 * */
	 
	 function template_settings()
	 {
		 
		$key = 'template_settings';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
	 
			$query = $this->db->get(TAB_TARG_COUNTRY);
		
			$result = $query->result_array();
			//return $this->db->last_query(); exit();
			
			if($result)
			{			
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			} 
		}
	}	 

	 function list_state()
	 {
		 
		$key = 'list_state';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
	 
			$query = $this->db->get(TAB_TARG_STATE);
		
			$result = $query->result_array();
			//return $this->db->last_query(); exit();
			
			if($result)
			{			
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			} 
		}
	}	 
	 
	function add_countrybidding($bidding_data)
	{

		if($bidding_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_COUN_BID,$bidding_data);
			$bidding_id=$this->db->insert_id();
			$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $bidding_id;
			}
	
		 }
	 }
	 
	 /*
   * 
   * name: fetch_job_category
   * @param : 
   * @return :all the job categories
   * 
   */
	public function fetch_job_category()
	{
		
		//$this->db->where('parent_category_id','0');
		//$this->db->where('is_deleted',0);
		$this->db->order_by('job_id','desc');
		$query = $this->db->get('job_category');
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			$i	=	0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}
			return $result;
		}
		else
		{
			return FALSE;
		}  
	}
	
	public function fetch_country($country_value)
	{		
		$this->db->select('*');
		$this->db->where('id',$country_value);
		$query = $this->db->get(TAB_TARG_COUNTRY);
		
		//echo $this->db->last_query(); die("test");
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			
			return $result;  
		}
		else
		{
			return FALSE;
		}  
	}
	
	 
	 function edit_countrybidding($bidding_data,$id)
	 {
		 if($bidding_data)
		{
			$this->db->trans_start();
			
			$this->db->where('id',$id);

			$this->db->update(TAB_COUN_BID,$bidding_data);
			
			$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');
			$this->memcached_library->set(FETCH_EDIT_COUNTRY_BIDDING,'1');
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}

	
		 }
	 }
	 
	 
	 
	 
	function list_unbidding_country($account_id)
	{
		if($account_id)
		{
			$SQL = "SELECT name,value FROM ".TAB_TARG_COUNTRY." WHERE value NOT IN(select country_value from ".TAB_COUN_BID." where  account_id=".$account_id.")";					
		}
		else
		{
			$SQL = "SELECT name,value FROM ".TAB_TARG_COUNTRY."";	
		}
		
				
		$query = $this->db->query($SQL);
		
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();
				return $result;
		}else{
				return FALSE;	
		}
		
	}

	function list_unbind_country($account_id,$campaignid,$revenueid)
	{


		if($account_id)
		{
			$SQL = "SELECT name,value FROM ".TAB_TARG_COUNTRY." WHERE value NOT IN(select country_value from ".TAB_COUN_BID." where campaign_id=".$campaignid." and revenue_type=".$revenueid." and account_id=".$account_id.")";					
		}
			
		$query = $this->db->query($SQL);
		
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();
				return $result;
		}else{
				return FALSE;	
		}
		
	}
	 
	function list_bidding_country($account_id,$filter=FALSE)
	{
		
		$key = 'list_bidding_country_'.$account_id;
						
		if($filter!=FALSE):
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;		
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_COUNTRY_BIDDING);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{  
			return $ret;
		}
		else{	 
			
			$SQL = "SELECT @i := @i -1 AS row_number,c.*
					FROM
					(SELECT b.id as id ,b.country_value,b.bidding_value,b.campaign_id,b.revenue_type,c.name as name,b.bidding_value as bidding,c.status as status,

						case  

						when b.campaign_id=-1 then 'All Campaigns'

						ELSE camp.campaignname 

						END as camp_name,d.revenue_type as rev_type,oxc.clientname,b.account_id

						FROM djax_country_bidding as b 

						LEFT JOIN ".TAB_TARG_COUNTRY." as c on c.value=b.country_value

						LEFT JOIN ".TAB_CAMPAIGNS." as camp ON camp.campaignid=b.campaign_id 
	 
						LEFT JOIN ".TAB_CONF_REVENUE_TYPE." as d ON d.revenue_id=b.revenue_type  

						JOIN ".TAB_CLIENTS." as oxc ON oxc.account_id=b.account_id 

						WHERE 1 ";
						if($account_id)
						{
							$SQL .= " AND b.account_id=".$account_id."";
						}
						if($filter!=FALSE && $filter['campaign']!=FALSE)
						{
							$campaign_id=implode(",",$filter['campaign']);
							$SQL .= " AND camp.campaignid in(".$campaign_id.")";
						}
						if($filter!=FALSE && $filter['campaign_type']!=FALSE)
						{	
							$campaign_type=implode(",",$filter['campaign_type']);							
							$SQL .= " AND d.revenue_type_value in(".$campaign_type.")";
						}					
							
				//test sorting.. code  start	
				$in_sel= "select count(*) 
					FROM ".TAB_TARG_COUNTRY." as a join ".TAB_COUN_BID." as b 
					where FIND_IN_SET(a.value,b.country_value) ";
				
				if($account_id)
				{	
					$in_sel .= " and b.account_id=".$account_id."";
				}			
				
					
			//test sorting.. code end
					
			$SQL .= " ORDER BY b.id DESC) as c,(SELECT @i := ($in_sel) + 1) as rowcount ";
															
			$query 	= 	$this->db->query($SQL);
			
			//return $this->db->last_query();
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($result)
				{
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$result,$account_type);	
						$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'2');	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $result;
					}
				}
				else
				{
					return FALSE;
				}
					//return $this->db->last_query();
			}else{
					return FALSE;	
			}
			
		}
	}
	
	function fetch_countrywise_bidding($id=false)
	{
		$key = 'edit_country_bid_'.$id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_COUNTRY_BIDDING);
		$check_edit_changes = $this->memcached_library->get(FETCH_EDIT_COUNTRY_BIDDING);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' && $check_edit_changes!='1')
		{
			return $ret;
		}
		else{
			$SQL = "SELECT revenue_type,campaign_id,country_value as value,bidding_value as bidding,id as id,account_id FROM ".TAB_COUN_BID." where id=".$id."";					
			$SQL1="SELECT c.campaignname,d.revenue_type,b.bidding_value,b.id
					FROM  ".TAB_COUN_BID." as b join ".TAB_CAMPAIGNS." as c ON c.campaignid =b.campaign_id or b.campaign_id=0 join ".TAB_CONF_REVENUE_TYPE." as d ON d.revenue_id=b.revenue_type
					where  b.id=".$id.""; 

			$query 	= 	$this->db->query($SQL);
			$result = 	$query->result_array();
					
			if($result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'2');
					$this->memcached_library->set(FETCH_EDIT_COUNTRY_BIDDING,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}else{
					return FALSE;	
			}
		}
	}
	
	 /* 

	 * Delete the countrybidding

	 */

	 function delete_countrybidding($country_bidding_id=false)
	 {			 
		 
		if($country_bidding_id)
		{

			$this->db->trans_start();			

			$this->db->where('id',$country_bidding_id); 

			$this->db->delete(TAB_COUN_BID);

			$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');	

			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;	

	}

	
	function fetch_country_list($country_id)
	{		 
		$this->db->where('id',$country_id);
		$query = $this->db->get(TAB_TARG_COUNTRY);		
		$result = $query->result_array();
		//return $this->db->last_query(); exit();
		if($result)
		{
			return $result[0]['value'];
		}
		else
		{
			return FALSE;
		}
			
			
	}
	
	
	function add_newsletter_info($data)
	{
		$this->db->insert(TAB_NEWSLETTER,$data);
		$insert_id	=	$this->db->insert_id();
		if($insert_id)
		{
			return $insert_id;
		}
		else
		{
			return FALSE;
		}
	}
	
	public function fetch_newsletter()
	{
		$key = FETCH_NEWSLETTER;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_ALL_EMAIL_TEMPLATE);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		$this->db->select('*');
		$this->db->where('is_deleted',0);
		$query = $this->db->get(TAB_NEWSLETTER);
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set(FETCH_NEWSLETTER_SETTINGS,'2');
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else
			{
				return $result;
			}
			
		}
		}
		
	}
	
		/*
   * 
   * name: block_template_data
   * @param : id
   * @return :id
   * 
   */
	public function block_template_data($id=FALSE) 
	{
		if($id)
		{  
		    $data=array('is_active'=>0);
		    $this->db->where('id', $id);
			$this->db->update(TAB_NEWSLETTER,$data);
			$this->memcached_library->set(FETCH_ALL_EMAIL_TEMPLATE,'1');
			return $id;
		}
	}
	
	public function unblock_template_data($id=FALSE) 
	{
		if($id)
		{  
		    $data=array('is_active'=>1);
		    $this->db->where('id', $id);
			$this->db->update(TAB_NEWSLETTER,$data);
			$this->memcached_library->set(FETCH_ALL_EMAIL_TEMPLATE,'1');
			return $id;
		}
	}
		public function delete_template_list($id=FALSE)
	{
		if($id)
		{
			$data=array('is_deleted'=>1);
		    $this->db->where('id', $id);
			$this->db->update(TAB_NEWSLETTER,$data);
			$this->memcached_library->set(FETCH_ALL_EMAIL_TEMPLATE,'1');
			return $id;
			 
		}
		else
		{
			return FALSE;	
		}
    }
    
    public function temp_file_upload_data($filename=FALSE,$imgfilename=FALSE)
    {
		if($filename)
		{
			$this->db->select('*');
		$this->db->where('status', '0');
		$this->db->where('filename', $filename);
		$query = $this->db->get(TAB_TEMP_MAIL);
		if($query->num_rows()==0)
		{			
			$data=array('filename'=>$filename,'img_file_name'=>$imgfilename,'date'=>date("Y-m-d"),'status'=>'0');
			$this->db->insert(TAB_TEMP_MAIL,$data);
			$bidding_id=$this->db->insert_id();
			//$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');
			
			$this->db->select('*');
		$this->db->where('status', '0');
		 $this->db->where('id', $bidding_id);
		$query = $this->db->get(TAB_TEMP_MAIL);
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			return $result;
		}
		}
			
	
		 }
	}
	
	 public function temp_delete_data()
    {
		$this->db->select('*');
		$this->db->where('status', '0');
		$query = $this->db->get(TAB_TEMP_MAIL);
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			return $result;
		}
	}
	
	public function temp_deletetion_remove_data($id=FALSE)
    {
			$this->db->where('id',$id);
			$data=array('status'=>'1');
			$this->db->update(TAB_TEMP_MAIL,$data);
			
			$this->db->select('*');
			$this->db->where('status', '0');
			$query = $this->db->get(TAB_TEMP_MAIL);
			if($query->num_rows()>0)
			{
			$result	=	$query->result_array();
			return $result;
			}
	}
	public function temp_edit_data($id=FALSE)
	{
		$this->db->select('filename');
		$data=array('status'=>'0','id'=>$id);
			$this->db->where($data);
			$query = $this->db->get(TAB_TEMP_MAIL);
			if($query->num_rows()>0)
			{
			$result	=	$query->result_array();
			return $result;
			}
	
	}
	public function temp_img_data()
	{
		$this->db->select('*');
		$data=array('status'=>'0');
			$this->db->where($data);
			$query = $this->db->get(TAB_TEMP_MAIL);
			if($query->num_rows()>0)
			{
			$result	=	$query->result_array();
			return $result;
			}
	
	}
}


?>
