<?php
class Do_targeting extends CI_Model
{
	 /*
	 * 
	 * name: add
	 * @param :$ox_acls_data
	 * @return : TRUE (or) FALSE
	 * 
	 * This method adds targetting acls to the particular campaign
	 */
	
	function add($ox_acls_data=FALSE,$campaign_id=FALSE)
	{
		if($ox_acls_data AND $campaign_id)
		{
			$tartype	=	explode(':',$ox_acls_data['type']);
			$devtype	=	array('all','web','mobile','tablet');
				
			$this->db->trans_start();

			/*Insert in ox_acls */
			$this->db->select('campaignid');		
			$this->db->where('campaignid ',$campaign_id);
			/*if(isset($tartype[0]) && $tartype[0]=='device')
			{
				$this->db->like('type','device:');
			}
			else
			{*/
				$this->db->where('type',$ox_acls_data['type']);
				$this->db->where('comparison',$ox_acls_data['comparison']);				
			//}
				
			$query = $this->db->get(TAB_ACLS);
				
			if($query->num_rows()>0)
			{
				/*if($tartype[0]=='device')
				{				
					$this->db->where('campaignid ',$campaign_id);	
					$this->db->like('type','device:');
					$this->db->delete(TAB_ACLS,$where);
				}
				else
				{*/
					$where=array('campaignid'=>$campaign_id,'type'=>$ox_acls_data['type'],'comparison'=>$ox_acls_data['comparison']);
					$this->db->delete(TAB_ACLS,$where);
				//}

				$this->db->insert(TAB_ACLS,$ox_acls_data);

				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			else
			{
				$this->db->insert(TAB_ACLS,$ox_acls_data);

				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			$this->memcached_library->set(ADD_TARGETING,'1');
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}

	 /*
	 * 
	 * name: delete
	 * @param :$ox_acls_data
	 * @return : TRUE (or) FALSE
	 * 
	 * This method adds targetting acls to the particular campaign
	 */
	
	function delete($ox_acls_data=FALSE,$campaign_id=FALSE)
	{
		if($ox_acls_data AND $campaign_id)
		{
			$this->db->trans_start();

			/*Insert in ox_acls */
			$this->db->select('campaignid');		
			$this->db->where('campaignid ',$campaign_id);
			$this->db->where('type',$ox_acls_data['type']);
			$this->db->where('comparison',$ox_acls_data['comparison']);
			$query = $this->db->get(TAB_ACLS);
				
			if($query->num_rows()>0)
			{
				$where=array('campaignid'=>$campaign_id,'type'=>$ox_acls_data['type'],'comparison'=>$ox_acls_data['comparison']);
				$this->db->delete(TAB_ACLS,$where);

				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			else
			{
				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	function delete1($ox_acls_data=FALSE,$campaign_id=FALSE)
	{
		if($ox_acls_data AND $campaign_id)
		{
			$this->db->trans_start();

			/*Insert in ox_acls */
			$this->db->select('campaignid');		
			$this->db->where('campaignid ',$campaign_id);
			$this->db->like('type',$ox_acls_data["type"]);
			$query = $this->db->get(TAB_ACLS);
				
			if($query->num_rows()>0)
			{
				$where=array('campaignid'=>$campaign_id);
				$this->db->like('type',$ox_acls_data["type"]);
				$this->db->delete(TAB_ACLS,$where);

				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			else
			{
				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}


	/*
	 * 
	 * name: update_campaign_targetting
	 * @param :$campaign_targ_data,$campaign_id
	 * @return : TRUE (or) FALSE
	 * 
	 * Update the delivery options in the ox campaigns table
	 *
	 * This method ched weater it has targeting defind already.
	 * If it exisits , it will return the processed data,
	 * If not exisits, it will return data as such,
	 */
		
		
	function update_campaign_targetting($campaign_id,$ox_acls_data)
	{
		if($campaign_id and $ox_acls_data)
		{
			$this->db->select('logical,type,comparison,data');
			$this->db->where('campaignid',$campaign_id);					
			$query = $this->db->get(TAB_ACLS);
			$result= $query->result_array();

				$compiledlimitations="";
				$acl_plugins="";

				foreach($result as $data)
				{
					$acl_plugins.=$data['type'].',';
					$target_data =$data['data'];
					
					//Fetch constants for targeting type	
					$compiled_constants=$this->fetch_complied_constant($data['type'],$data['comparison']);

					$compiledlimitations.=$compiled_constants['prefix'].$data['data'].$compiled_constants['suffix'].' and ';
			
				}

				$acl_plugins=substr($acl_plugins, 0, -1);
				$compiledlimitations=substr($compiledlimitations, 0, -5);
				
				$campaign_targ_data=array(
								"compiledlimitation"=> $compiledlimitations,
								"acl_plugins"=> $acl_plugins,
								);
								
				if($campaign_targ_data && $campaign_id)
				{
					$this->db->trans_start();

					$this->db->where('campaignid',$campaign_id);
					$this->db->update(TAB_CAMPAIGNS,$campaign_targ_data);

					$this->db->trans_complete();
					if ($this->db->trans_status() === FALSE)
					{
						$this->db->trans_rollback();
						return FALSE;
					}
					else
					{
						$this->db->trans_commit();
						return TRUE;
					}
				}
				else
					return FALSE;
		}
	}
	/*
	 * 
	 * name: update_capping
	 * @param :$ox_campaigns_frquency_data,$campaign_id
	 * @return : TRUE (or) FALSE
	 * 
	 * Update the delivery options in the ox campaigns table
	 *
	 * This method will add capping details to the campaign
	 * 
	 */
		
	function update_capping($ox_campaigns_frquency_data,$campaign_id)
	{
		
		if($campaign_id and $ox_campaigns_frquency_data)
		{
			$this->db->trans_start();

			$this->db->where('campaignid',$campaign_id);
			$this->db->update(TAB_CAMPAIGNS,$ox_campaigns_frquency_data);

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_complied_constant
	 * @param $type targetting type
	 * @return
	 *
	 * This function will return prefix and suffix for the given targetting type
	 */
		
		
	function fetch_complied_constant($type =FALSE,$comparison =FALSE)
	{
		if($type !=FALSE && $comparison !=FALSE)
		{
			//IF written below lets the both mobile targeing and web-> profile targeting alone.
			/*if($type!='os' and $type!='handset' and $type!='capability'  and $type!='teleco' and $type!='country' and $type!='profile:age' and $type!='profile:gender' and $type!='profile:color' and $type!='profile:weight' and $type!='profile:height' )
			{
				$targeting_type=explode(':',$type);
				$targeting_type=$targeting_type[2];
			}
			else
			{
				$targeting_type=$type;
			}*/
			
			$targ_type	=	explode(':',$type);
			$targeting_type	=	(is_array($targ_type) && $targ_type[2])?$targ_type[2]:$type;
				
			switch ($targeting_type)
			{
				case 'Browser':
					$compiledlimitation_prefix="MAX_checkClient_Browser('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'Browser_Exclude':
					$compiledlimitation_prefix="MAX_checkClient_Browser_Exclude('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				case 'Language':
					$compiledlimitation_prefix="MAX_checkClient_Language('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;	
				case 'Language_Exclude':
					$compiledlimitation_prefix="MAX_checkClient_Language_Exclude('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;					
				case 'BrowserVersion':
					$compiledlimitation_prefix="MAX_checkClient_BrowserVersion('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				case 'BrowserVersionExclude':
					$compiledlimitation_prefix="MAX_checkClient_BrowserVersionExclude('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;					
				case 'Os':
					$compiledlimitation_prefix="MAX_checkClient_Os('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'Os_Exclude':
					$compiledlimitation_prefix="MAX_checkClient_Os_Exclude('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				/*case 'Os_version_Include':
					$compiledlimitation_prefix="MAX_checkClient_Os_version_Include('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;		*/		
				case 'OsVersion':
					$compiledlimitation_prefix="MAX_checkClient_OsVersion('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				case 'Include_country':
					$compiledlimitation_prefix="Includecountry('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'Exclude_country':
					$compiledlimitation_prefix="Excludecountry('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'City':
					$compiledlimitation_prefix="MAX_checkGeo_City('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'City_Exclude':
					$compiledlimitation_prefix="MAX_checkGeo_City_Exclude('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				case 'Zip':
					$compiledlimitation_prefix="MAX_checkGeo_Zip('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;		
				case 'Zip_Exclude':
					$compiledlimitation_prefix="MAX_checkGeo_Zip_Exclude('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;							
				case 'Hour':
					$time_zone=$this->config->item('time_zone');//get_session('time_zone');
					$compiledlimitation_prefix="MAX_checkTime_Hour('";
					$compiledlimitation_suffix="@$time_zone', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'Day':
					$time_zone=$this->config->item('time_zone');//get_session('time_zone');
					$compiledlimitation_prefix="MAX_checkTime_Day('";
					$compiledlimitation_suffix="@$time_zone', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'Time':
					$time_zone=$this->config->item('time_zone');//get_session('time_zone');
					$compiledlimitation_prefix="MAX_checkDay_Time('";
					$compiledlimitation_suffix="@$time_zone', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'device:web':
					$compiledlimitation_prefix="device_web('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'device:mobile':
					$compiledlimitation_prefix="device_mobile('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'device:tablet':
					$compiledlimitation_prefix="device_tablet('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'device:all':
					$compiledlimitation_prefix="device_all('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'exclude_device:web':
					$compiledlimitation_prefix="exclude_device_web('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'exclude_device:mobile':
					$compiledlimitation_prefix="exclude_device_mobile('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'exclude_device:tablet':
					$compiledlimitation_prefix="exclude_device_tablet('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'exclude_device:all':
					$compiledlimitation_prefix="exclude_device_all('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:blacklist':
					$compiledlimitation_prefix="profile:blacklist('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:whitelist':
					$compiledlimitation_prefix="profile:whitelist('";
					$compiledlimitation_suffix="', '=~')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:url':
					$compiledlimitation_prefix="profile:url('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:avail_keyword':
					$compiledlimitation_prefix="profile:avail_keyword('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:blocked_keyword':
					$compiledlimitation_prefix="profile:blocked_keyword('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:keyword':
					$compiledlimitation_prefix="profile:keyword('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				
				//MOBILE CONSTANTS
				case 'handset':
					$compiledlimitation_prefix="handset('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'capability':
					$compiledlimitation_prefix="capability('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'connection':
					$compiledlimitation_prefix="connection('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				case 'carrier':
					$compiledlimitation_prefix="carrier('";
					$compiledlimitation_suffix="', '".$comparison."')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				case 'handset_Exclude':
					$compiledlimitation_prefix="handset_Exclude('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'capability_Exclude':
					$compiledlimitation_prefix="capability_Exclude('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'connection_Exclude':
					$compiledlimitation_prefix="connection_Exclude('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				case 'carrier_Exclude':
					$compiledlimitation_prefix="carrier_Exclude('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;				
				
				case 'profile:age':
					$compiledlimitation_prefix="profile:age('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:gender':
					$compiledlimitation_prefix="profile:gender('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:color':
					$compiledlimitation_prefix="profile:color('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:height':
					$compiledlimitation_prefix="profile:height('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
				case 'profile:weight':
					$compiledlimitation_prefix="profile:weight('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
				break;
			}
			return $compiled_constants;
		}	
		
	}
	/*
	 * 
	 * name: get_options
	 * @param $type targetting type
	 * @return
	 *
	 * Call Function to get options for targetting
	 */
		
		
	function fetch_targ_options($type =FALSE)
	{
		$key = 'fetch_targ_options_'.$type;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		
		if($type !=FALSE)
		{
			
			$opt_tables	=	  array(
									TAB_TARG_BROWSERS		=> 	'browser',
									TAB_TARG_OS				=> 	'os',
									TAB_TARG_COUNTRY		=> 	'geo',
									TAB_TARG_CITY			=> 	'city',
									TAB_TARG_MOB_OS			=> 	'mobile_os',
									TAB_TARG_MOB_MANU		=> 	'mobile_manu',
									TAB_TARG_MOB_TC			=> 	'mobile_telecom',
									TAB_TARG_MOBILE_CARRIER	=> 	'mobile_carrier',
									TAB_TARG_MOB_CAPA		=> 	'mobile_capability',
									TAB_TARG_KEYWORD		=>	'keyword',
									TAB_TARG_BROWSER_LANG	=> 	'language',
									TAB_TARG_CONTINENT		=> 	'continent',
									TAB_TARG_OS_SET			=> 	'os_set',
									TAB_TARG_TIME			=> 	'time',
									TAB_TARG_DAYS			=> 	'days',
									TAB_TARG_DEV_TYPE		=> 	'dev_type',
									TAB_TARG_DEVICE			=> 	'device',
									TAB_TARG_CONN_TYPE		=> 	'connection'
									);
									
									
									
			$tbl_name = array_search($type,$opt_tables);
			if($type!='mobile_carrier' && $type!='keyword')
			{
				if($type=='geo')
				{
					$this->db->select('value as id,name as text,continent_code as region,');
				}
				else if($type=='city')
				{
					$this->db->select('country_region_city as id,city as text,country,region,');
				}
				else if($type=='os' || $type=='device' || $type=='browser')
				{
					$this->db->select('value as id,name as text,device,');
				}
				else
				{
					$this->db->select('value as id,name as text,');
				}
			}
			elseif($type=='keyword')
			{
				
				$this->db->select('keyword as id,keyword as text,');
				$this->db->where('is_deleted','0');	
				
			}				
			else
			{
				//$this->db->select('id as id,country as text_1,carriername as text_2,');
				$this->db->select("id as id,CONCAT(country,'-',carriername) as text",false);
			}
			if($type!='keyword' && $type!='city' && $type!='connection' && $type!='language')
			{
				$this->db->where('status',1);
		    }
			if($type!='geo' && $type!='city' && $type!='continent' && $type!='os_set' && $type!='mobile_telecom')
			{				
				$this->db->where('is_blocked',0);					
			}	
				
			$query = $this->db->get($tbl_name);
			if($query->num_rows>0)
			{
				$result = $query->result_array();
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
				
				
			}
			else
				return FALSE;
		}	
		else
			return FALSE;
	}
	
}
	
	
	   /*
   * 
   * name: add
   * @param : categoryname,categoryvalue
   * @return :lastinsertid
   * 
   * Fetch list of n/w users (pub or adv)
   */

	public function add_category($ins_data=FALSE){
						
		if($this->db->insert(TAB_SITE_CATEGORIES,$ins_data)){
			$this->memcached_library->set(ADD_TARGETING,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 
	/*
   * 
   * name: add_main_category
   * @param : categoryname,categoryvalue
   * @return :lastinsertid
   * 
   * Fetch list of n/w users (pub or adv)
   */

	public function add_main_category($cat_name=FALSE,$cat_value=FALSE){
		
		$ins_data	= array('category_name'	=>$cat_name,
							'value'			=>$cat_value
							);
						
		if($this->db->insert(TAB_SITE_CATEGORIES,$ins_data)){
			$this->memcached_library->set(ADMIN_MAIN_CATEGORY,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 } 
	 
	 	/*
   * 
   * name: add_inline_keywords
   * @param : keywords
   * @return :lastinsertid
   * 
   * Fetch list of n/w users (pub or adv)
   */

	public function add_line_keywords($keywords=FALSE){
		
		$ins_data	= array('keywords'	=>$keywords,
							'status'			=>'1'
							);
						
		if($this->db->insert(TAB_INLINE_KEYWORDS,$ins_data)){
			
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	 } 
	 
	 public function fetch_inline_keyword()
	{ 
	  $this->db->select('*');
	  $this->db->where('status','1');
	  $this->db->where('is_delete','0');
	  $query = $this->db->get(TAB_INLINE_KEYWORDS);
	  $result=$query->result_array();
	  return $result;
	}
	 
   /*
   * 
   * name: fetch
   * @param : 
   * @return :all the creatives details need to be approve
   * 
   */
	public function fetch()
	{ 
		
		$key = 'fetch_targetting';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes_targ = $this->memcached_library->get(ADD_TARGETING);
		if($ret && $mem_cache=='enable' && $check_db_changes_targ!='1')
		{  
			return $ret;
		}
		else{
			
			$this->db->where('is_deleted',0);
			$this->db->where_not_in('parent_category_id','0');
			$this->db->order_by('category_id','desc');
			$query = $this->db->get(TAB_SITE_CATEGORIES);		
			
			if($query->num_rows()>0){
				$result	=	$query->result_array();
				$count=$query->num_rows();
				$i	=	0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(ADD_TARGETING,'2');
					$set = $this->memcached_library->get($key);						
					return $set;
				}
				else
				{	
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
			
			/*$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT category_name,value from ".TAB_SITE_CATEGORIES."where parent_category_id NOT IN ('0') AND is_deleted=0"; 
			$in_sel = "SELECT count(*) from ".TAB_SITE_CATEGORIES."where parent_category_id NOT IN ('0') AND is_deleted=0";
			$SQL.= " ORDER BY category_id DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
			
			$query = $this->db->query($SQL);
			
			$result = $query->result_array();		
			
			if($query->num_rows()>0)
			{
				return $result;
			}
			else
			{
				return FALSE;
			}*/
		   
		}
	}
	
   /*
   * 
   * name: fetch_select
   * @param : category_id
   * @return :categoryname,categoryvalue
   * 
   */
	public function fetch_select($cat_id=FALSE)
	{ 
	  $this->db->select('*');
	  $this->db->where('category_id',$cat_id);
	  $query = $this->db->get(TAB_SITE_CATEGORIES);
	  $result=$query->result_array();
	  return $result;
	}
	
   /*
   * 
   * name: update_category
   * @param : categoryname,categoryvalue,categoryid
   * @return : category id
   * 
   */
	public function update_category($category_info=FALSE)
	{
	  $catObj=array( 'category_name'=>$category_info['category_name']);
	  if(!empty($catObj)){
			$this->db->where('category_id',$category_info['category_id']);
			$this->db->update(TAB_SITE_CATEGORIES,$catObj);
			$this->memcached_library->set(ADD_TARGETING,'1');
			return $category_info['category_id'];
		}
		else
		{
			return FALSE;
		}
	
	}
	
   /*
   * 
   * name: delete_category
   * @param : categoryid
   * @return : status true or false
   * 
   */
   
	public function delete_category($cat_id=FALSE)
	{
		
	if($cat_id){
		$data=array('is_deleted'=>1);
		$this->db->where('category_id', $cat_id);
		$this->db->update(TAB_SITE_CATEGORIES,$data);
		$this->memcached_library->set(ADD_TARGETING,'1');
		$this->memcached_library->set(ADMIN_MAIN_CATEGORY,'1');
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
			
	  }
	  else{
		  return FALSE;	
	  }
	}
	
	
  /*
   * 
   * name: add_os
   * @param : osname,osvalue
   * @return :lastinsertid
   * 
   */
	
	public function add_os($device_os=FALSE,$os_value=FALSE,$device=FALSE){
		
		$osObj = array(
							"name" => $device_os,
							"value"=> $os_value,
							"device"=>implode(',',$device)
						);
						
		if($this->db->insert(TAB_TARG_OS,$osObj)){
			$this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 
	 
	public function add_os_version($device_os=FALSE,$os_value=FALSE){
		
		$osObj = array(
							"os_val" => $device_os,
							"os_version"=> $os_value						
						);
						
		if($this->db->insert(TAB_TARG_OS_VERSION,$osObj)){
			
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 
	 
   /*
   name : fetch_os_name
   @param : --
   @return : All os name details.   
   */    
   public function fetch_os_name()
   {	    
		$key = 'fetch_os_name';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_OPERATING_SYSTEM);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		
		$this->db->where('is_blocked', '0');
		$this->db->order_by('name','ASC');
		$query = $this->db->get(TAB_TARG_OS);
			if($query->num_rows()>0){
				$result	=	$query->result_array();
				$count=$query->num_rows();
				$i	=	0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'2');
					$this->memcached_library->set($key,$result,$account_type);	
					
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}	  
		}
   
   }
	 
   /*
   * 
   * name: fetch_os
   * @param : 
   * @return :all the os details.
   * 
   */
	public function fetch_os()
	{
		$key = 'fetch_os';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_OPERATING_SYSTEM);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		
		$this->db->where('is_blocked', '0');
		$this->db->order_by('id','desc');
		$query = $this->db->get(TAB_TARG_OS);
		if($query->num_rows()>0){
			$result	=	$query->result_array();
			$count=$query->num_rows();
			$i	=	0;$j=$count;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'2');
				$this->memcached_library->set($key,$result,$account_type);	
				
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
		}
		else
		{
			return FALSE;
		}
		
		
		/*$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT name,value from ".TAB_TARG_OS."where is_blocked=0"; 
		$in_sel = "SELECT count(*) from ".TAB_TARG_OS."where is_blocked=0";
		$SQL.= " ORDER BY id DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
		
		$query = $this->db->query($SQL);
		
		$result = $query->result_array();		
		
		if($query->num_rows()>0)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}*/
		
		
		
	}
	
}
   
   /*
   * 
   * name: fetch_os_select
   * @param : os id
   * @return :selected os details.
   * 
   */
   public function fetch_os_select($id=FALSE)
   {
      $this->db->select('*');
	  $this->db->where('id',$id);
	  $query = $this->db->get(TAB_TARG_OS);
	  $result=$query->result_array();
	  return $result;
   }
   
   public function fetch_os_vers_data($id=FALSE)
   {
      $this->db->select('gic.*,dtc.name');
      $this->db->join(TAB_TARG_OS.' as dtc','dtc.id=gic.os_val');
	  $this->db->where('gic.id',$id);
	  $query = $this->db->get(TAB_TARG_OS_VERSION.' as gic');
	  $result=$query->result_array();
	  return $result;
   }
   
  /*
   * 
   * name: update_os
   * @param : osname,osvalue,osid
   * @return : os id
   * 
   */
   	public function update_os($os_info=FALSE)
	{
	  $osObj=array( 'name'=>$os_info['device_os'],
	                 'value'=>$os_info['os_value'],
	                 'device'=>implode(',',$os_info['edit_device'])
	              );
	  if(!empty($osObj)){
			$this->db->where('id',$os_info['os_id']);
			$this->db->update(TAB_TARG_OS,$osObj);
			$this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'1');
			return $os_info['os_id'];
		}
		else
		{
			return FALSE;
		}
	
	}
	
	
   	public function update_os_version($os_info=FALSE)
	{
	  $osObj=array(  'os_version'=>$os_info['os_value'],
	                 );
	  if(!empty($osObj)){
			$this->db->where('id',$os_info['os_id']);
			$this->db->update(TAB_TARG_OS_VERSION,$osObj);			
			return $os_info['os_id'];
		}
		else
		{
			return FALSE;
		}
	
	}
	
  /*
   * 
   * name: delete_os
   * @param : os_id
   * @return : status true or false
   * 
   */

	public function delete_os($id=FALSE)
	{				
	 if($id){
	   $this->db->where('id', $id);
       $this->db->delete(TAB_TARG_OS);
	    
       $this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'1'); 
       $this->memcached_library->set(ADD_TARGETING,'1'); 
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
		 return true;	
	   }
	  else{
		  return FALSE;	
	  }
    }
	public function delete_os_version($id=FALSE)
	{
		
	 if($id){
	   $this->db->where('id', $id);
       $this->db->delete(TAB_TARG_OS_VERSION);

	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
		 return true;	
	   }
	  else{
		  return FALSE;	
	  }
    }
	
  /*
   * 
   * name: add_browser
   * @param : browsername,browservalue
   * @return :lastinsertid
   * 
   */
	public function add_browser($browser_info=FALSE){
	
	 $browserObj = array( "name" => $browser_info['browser_name'],
					 "value"=> $browser_info['browser_code']
				  );
	  if($this->db->insert(TAB_TARG_BROWSERS,$browserObj)){
		  
		  $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	
	}
	
	public function add_browser_version($browser_info=FALSE){
	
	 $browserObj = array( "browser_version" => $browser_info['browser_version'],
					 "browser_code"=> $browser_info['browser_name'],
					 "status"=> "1"
				  );
	  if($this->db->insert(TAB_TARG_BROWSER_VERSION,$browserObj)){
		  
		  $this->memcached_library->set(ADMIN_TARGETTING_BROWSER_VERSION,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	
	}
	
  /*
   * 
   * name: fetch_browser
   * @param : 
   * @return :all the browser details.
   * 
   */
    public function fetch_browser(){
		$key = 'fetch_browser';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_TARGETTING_BROWSER);
		if($ret && $mem_cache=='enable' && $check_db_changes !='1' )
		{
			return $ret;
		}
		else{
		
		
			$this->db->order_by('id','desc');
			$query = $this->db->get(TAB_TARG_BROWSERS);
			if($query->num_rows()>0){
				$result	=	$query->result_array();
				$count=$query->num_rows();
				$i	=	0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					 $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'2');
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			} 
			
			/*$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT name,value from ".TAB_TARG_BROWSERS." where is_blocked=0"; 
			$in_sel = "SELECT count(*) from ".TAB_TARG_BROWSERS." where is_blocked=0";
			$SQL.= " ORDER BY id DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
			
			$query = $this->db->query($SQL);
			
			$result = $query->result_array();		
			
			if($query->num_rows()>0)
			{
				return $result;
			}
			else
			{
				return FALSE;
			}*/
			
			
			
	   }
	   
	}
	

	public function fetch_browsings()
	{
			$this->db->select('value ,name');
			$this->db->order_by('id','desc');
			$query = $this->db->get(TAB_TARG_BROWSERS);
			if($query->num_rows()>0){
				$result	=	$query->result_array();
				
			}
			return $result;
	}
    public function fetch_browser_version(){
		    $this->db->select('gic.*,dtc.name as browser_name');
			$this->db->join(TAB_TARG_BROWSERS.' as dtc','dtc.value=gic.browser_code');
			$this->db->order_by('gic.id','desc');
			$query = $this->db->get(TAB_TARG_BROWSER_VERSION.' as gic');
			if($query->num_rows()>0){
				$result	=	$query->result_array();
				$count=$query->num_rows();
				$i	=	0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}

					return $result;
				
			}
			else
			{
				return FALSE;
			} 			
	   
	   
	}
   
   /*
   * 
   * name: fetch_browser_select
   * @param : browser_id
   * @return :slected  browser details.
   * 
   */
    public function fetch_browser_select($id=FALSE)
   {
      $this->db->select('*');
	  $this->db->where('id',$id);
	  $query = $this->db->get(TAB_TARG_BROWSERS);
	  $result=$query->result_array();
	  return $result;
   }


    public function fetch_browser_version_select($id=FALSE)
   {
      $this->db->select('gic.*,dtc.name as browser_name');
      $this->db->join(TAB_TARG_BROWSERS.' as dtc','dtc.value=gic.browser_code');
	  $this->db->where('gic.id',$id);
	  $query = $this->db->get(TAB_TARG_BROWSER_VERSION.' as gic');
	  $result=$query->result_array();
	  return $result;
   }

    public function fetch_browser_version_select1($browser=FALSE)
   {
	   
      $this->db->select('gic.id,gic.browser_version as text');
      $this->db->join(TAB_TARG_BROWSERS.' as dtc','dtc.value=gic.browser_code');

	  if($browser)
	  {
		$this->db->where_in('gic.browser_code',$browser);
	  }
	  $query = $this->db->get(TAB_TARG_BROWSER_VERSION.' as gic');
	  $result=$query->result_array();
	  return $result;
   }   
    public function fetch_os_version_select1($os=FALSE)
   {
	   
      $this->db->select('gic.id,gic.os_version as text');
      $this->db->join(TAB_TARG_OS.' as dtc','dtc.id=gic.os_val');

	  if($os)
	  {
		$this->db->where_in('dtc.value',$os);
	  }
	  $query = $this->db->get(TAB_TARG_OS_VERSION.' as gic');
	  $result=$query->result_array();
	  return $result;
   }   
   
   /*
   * 
   * name: update_browser
   * @param : browsername,browservalue,browserid
   * @return : category id
   * 
   */
   public function update_browser($browser_info=FALSE){
	
	 $browserObj = array( "name" => $browser_info['browser_name'],
					 "value"=> $browser_info['browser_code']
				  );

	if(!empty($browserObj)){
			$this->db->where('id',$browser_info['browser_id']);
			$this->db->update(TAB_TARG_BROWSERS,$browserObj);
			 $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
			return $browser_info['browser_id'];
		}
		else
		{
			return FALSE;
		}
	
	}
   public function update_browser_version($browser_info=FALSE){
	
	 $browserObj = array( "browser_version"=> $browser_info['browser_version']
				  );

	if(!empty($browserObj)){
			$this->db->where('id',$browser_info['browser_version_id']);
			$this->db->update(TAB_TARG_BROWSER_VERSION,$browserObj);
			
			return $browser_info['browser_version_id'];
		}
		else
		{
			return FALSE;
		}
	
	}
    
	/*
   * 
   * name: delete_browser
   * @param : browserid
   * @return : status true or false
   * 
   */

	public function delete_browser($id=FALSE){
	 if($id){
	   $this->db->where('id', $id);
       $this->db->delete(TAB_TARG_BROWSERS); 
       $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
	   }
	  else{
		  return FALSE;	
	   }

	}
	public function delete_browser_version($id=FALSE){
	 if($id){
	   $this->db->where('id', $id);
       $this->db->delete(TAB_TARG_BROWSER_VERSION); 
     //  $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
	   }
	  else{
		  return FALSE;	
	   }

	}
	
   /*
   * 
   * name: add_manu
   * @param : manuname,manuvalue
   * @return :lastinsertid
   * 
   */
	public function add_manu($manu_info=FALSE){
	   $manuObj = array( "name" => $manu_info['manu_name'],
					 "value"=> $manu_info['manu_value']
				  );
	  if($this->db->insert(TAB_MOB_MANUFACT,$manuObj)){
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	}
	
  /*
   * 
   * name: fetch_manu
   * @param : 
   * @return :all the manufacturers details.
   * 
   */
	public function fetch_manu(){
		$this->db->order_by('id','desc');
		$query = $this->db->get(TAB_MOB_MANUFACT);
		if($query->num_rows()>0){
			$result	=	$query->result_array();
			$i	=	0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}
			return $result;
		}
		else
		{
			return FALSE;
		} 
	}
   
   /*
   * 
   * name: fetch_manu_select
   * @param : manufacturers id
   * @return :all the selected manufacturers details.
   * 
   */
    public function fetch_manu_select($id=FALSE)
   {
      $this->db->select('*');
	  $this->db->where('id',$id);
	  $query = $this->db->get(TAB_MOB_MANUFACT);
	  $result=$query->result_array();
	  return $result;
   }	 
   
   /*
   * 
   * name: update_manu
   * @param : manufacturers name,manufacturers value,manufacturers id
   * @return : category id
   * 
   */
   public function update_manu($manu_info=FALSE){
    
	 $manuObj = array( "name" => $manu_info['manu_name'],
					 "value"=> $manu_info['manu_value']
				  );
	 
	 if(!empty($manuObj)){
			$this->db->where('id',$manu_info['manu_id']);
			$this->db->update(TAB_MOB_MANUFACT,$manuObj);
			return $manu_info['manu_id'];
		}
		else
		{
			return FALSE;
		}

	 }
	 
   /*
   * 
   * name: delete_manu
   * @param : manufacturers id
   * @return : status true or false
   * 
   */
    public function delete_manu($id=FALSE){
	 
	   if($id){
	     $this->db->where('id', $id);
         $this->db->delete(TAB_MOB_MANUFACT); 
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
	   }
	    else{
		  return FALSE;	
	   }
	  }
	  
/* Mobile Targeting */	  
	
	/*
   * 
   * name: add_mobile_os
   * @param : Mobile osname, Mobile osvalue
   * @return :lastinsertid
   * 
   */
	
	public function add_mobile_os($device_os=FALSE,$os_value=FALSE){
		
		$osObj = array(
							"name" => $device_os,
							"value"=> $os_value,
						);
						
		if($this->db->insert(TAB_TARG_MOB_OS,$osObj)){
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 
   /*
   * 
   * name: fetch_os
   * @param : 
   * @return :all the os details.
   * 
   */
	public function fetch_mobile_os()
	{
		$this->db->order_by('id','desc');
		$query = $this->db->get(TAB_TARG_MOB_OS);
		if($query->num_rows()>0){
			$result	=	$query->result_array();
			$count=$query->num_rows();
			$i	=	0;$j=$count;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}
			return $result;
		}
		else
		{
			return FALSE;
		}
		
        /*$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT name,value from ".TAB_TARG_MOB_OS." where is_blocked=0"; 
		$in_sel = "SELECT count(*) from ".TAB_TARG_MOB_OS." where is_blocked=0";
		$SQL.= " ORDER BY id DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
		
		$query = $this->db->query($SQL);
		
		$result = $query->result_array();		
		
		if($query->num_rows()>0)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}*/	
			
	}
   
   /*
   * 
   * name: fetch_mobile_os_select
   * @param : os id
   * @return :selected os details.
   * 
   */
	public function fetch_mobile_os_select($id=FALSE)
   {
      $this->db->select('*');
	  $this->db->where('id',$id);
	  $query = $this->db->get(TAB_TARG_MOB_OS);
	  $result=$query->result_array();
	  return $result;
   }
   
  /*
   * 
   * name: update_mobile_os
   * @param : osname,osvalue,osid
   * @return : os id
   * 
   */
	public function update_mobile_os($os_info=FALSE)
	{
	  $osObj=array( 'name'=>$os_info['device_os'],
	                 'value'=>$os_info['os_value']
	              );
	  if(!empty($osObj)){
			$this->db->where('id',$os_info['os_id']);
			$this->db->update(TAB_TARG_MOB_OS,$osObj);
			return $os_info['os_id'];
		}
		else
		{
			return FALSE;
		}
	
	}
	
  /*
   * 
   * name: delete_mobile_os
   * @param : os_id
   * @return : status true or false
   * 
   */

	public function delete_mobile_os($id=FALSE)
	{
	 if($id){
	   $this->db->where('id', $id);
       $this->db->delete(TAB_TARG_MOB_OS); 
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
	   }
	  else{
		  return FALSE;	
	  }
    }   
	  


 /*
   * 
   * name: add_mobile_manufacturers
   * @param : manuname,manuvalue
   * @return :lastinsertid
   * 
   */
  public function add_mobile_manufacturers($manufact_name=FALSE,$manufact_value=FALSE){
	  
	  $manuObj = array(
							"name" => $manufact_name,
							"value"=> $manufact_value,
						);	
	 
	  if($this->db->insert(TAB_TARG_MOB_MANU,$manuObj)){
			$this->memcached_library->set(ADMIN_MOBILE_MANUFACTURER,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	}
	
  /*
   * 
   * name: fetch_mobile_manufacturers
   * @param : 
   * @return :all the manufacturers details.
   * 
   */
	public function fetch_mobile_manufacturers(){
		
		$key = FETCH_MOBILE_MANUFACTURER;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_MOBILE_MANUFACTURER);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return 	$ret;	
		}
		else{
		
		$this->db->order_by('id','desc');
		$query = $this->db->get(TAB_TARG_MOB_MANU);
		if($query->num_rows()>0){
			$result	=	$query->result_array();
			$count=$query->num_rows();
			$i	=	0;$j=$count;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}
			if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set(ADMIN_MOBILE_MANUFACTURER,'2');
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
					}
		
		
		
		
		/*$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT name,value from ".TAB_TARG_MOB_MANU." where is_blocked=0"; 
		$in_sel = "SELECT count(*) from ".TAB_TARG_MOB_MANU." where is_blocked=0";
		$SQL.= " ORDER BY id DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
		
		$query = $this->db->query($SQL);
		
		$result = $query->result_array();		
		
		if($query->num_rows()>0)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}*/
		
	}
	else
		{
			return FALSE;
		} 
}
}
   
   /*
   * 
   * name: fetch_mobile_manufacturer_select
   * @param : manufacturers id
   * @return :all the selected manufacturers details.
   * 
   */
    public function fetch_mobile_manufacturers_select($id=FALSE)
   {
      $this->db->select('*');
	  $this->db->where('id',$id);
	  $query = $this->db->get(TAB_TARG_MOB_MANU);
	  $result=$query->result_array();	 
	  return $result;
   }	 
   
   /*
   * 
   * name: update_mobile_manufacturers
   * @param : manufacturers name,manufacturers value,manufacturers id
   * @return : category id
   * 
   */
   public function update_mobile_manufacturers($manu_info=FALSE){
    
	 $manuObj = array( "name" => $manu_info['manu_name'],
					 "value"=> $manu_info['manu_value']
				  );
	 
	 if(!empty($manuObj)){
			$this->db->where('id',$manu_info['manu_id']);
			$this->db->update(TAB_TARG_MOB_MANU,$manuObj);
			
			$this->memcached_library->set(ADMIN_MOBILE_MANUFACTURER,'1');
			return $manu_info['manu_id'];
		}
		else
		{
			return FALSE;
		}

	 }
	 
   /*
   * 
   * name: delete_mobile_manufacturers
   * @param : manufacturers id
   * @return : status true or false
   * 
   */
    public function delete_mobile_manufacturers($id=FALSE){
	 
	   if($id){
	     $this->db->where('id', $id);
         $this->db->delete(TAB_TARG_MOB_MANU);
         $this->memcached_library->set(ADMIN_MOBILE_MANUFACTURER,'1');
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
		  return true;	
		 
	   }
	    else{
		  return FALSE;	
	   }
	  }
	  
	  
	 /*
   * 
   * name: add_mobile_capability
   * @param : Mobile capability name, Mobile capability value
   * @return :lastinsertid
   * 
   */
	
	public function add_mobile_capability($capability_name=FALSE,$capability_value=FALSE){
		
		$capabilityObj = array(
							"name" => $capability_name,
							"value"=> $capability_value,
						);
						
		if($this->db->insert(TAB_TARG_MOB_CAPA,$capabilityObj)){
			$this->memcached_library->set(ADMIN_MOBILE_CAPABILITIES,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 
   /*
   * 
   * name: fetch_capability
   * @param : 
   * @return :all the capability details.
   * 
   */
	public function fetch_mobile_capability()
    {
		
		$key = FETCH_MOBILE_CAPABILITIES;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_MOBILE_CAPABILITIES);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		$this->db->order_by('id','desc');
		$query = $this->db->get(TAB_TARG_MOB_CAPA);
		if($query->num_rows()>0){
			$result	=	$query->result_array();
			$count=$query->num_rows();
			$i	=	0;$j=$count;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set(ADMIN_MOBILE_CAPABILITIES,'2');
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
		}
		else
		{
			return FALSE;
		}
		
		/*$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT name,value from ".TAB_TARG_MOB_CAPA." where is_blocked=0"; 
		$in_sel = "SELECT count(*) from ".TAB_TARG_MOB_CAPA." where is_blocked=0";
		$SQL.= " ORDER BY id DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
		
		$query = $this->db->query($SQL);
		
		$result = $query->result_array();		
		
		if($query->num_rows()>0)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}*/
	}

}
   /*
   * 
   * name: fetch_mobile_capability_select
   * @param : capability id
   * @return :selected capability details.
   * 
   */
	public function fetch_mobile_capability_select($id=FALSE)
   {
      $this->db->select('*');
	  $this->db->where('id',$id);
	  $query = $this->db->get(TAB_TARG_MOB_CAPA);
	  $result=$query->result_array();
	  return $result;
   }
   
  /*
   * 
   * name: update_mobile_capability
   * @param : capabilityname,capabilityvalue,capabilityid
   * @return : capability id
   * 
   */
	public function update_mobile_capability($capability_info=FALSE)
	{
	  $capabilityObj=array( 'name'=>$capability_info['capability_name'],
	                 'value'=>$capability_info['capability_value']
	              );
	  if(!empty($capabilityObj)){
			$this->db->where('id',$capability_info['capability_id']);
			$this->db->update(TAB_TARG_MOB_CAPA,$capabilityObj);
			
			$this->memcached_library->set(ADMIN_MOBILE_CAPABILITIES,'1');
			return $capability_info['capability_id'];
		}
		else
		{
			return FALSE;
		}
	
	}
	
  /*
   * 
   * name: delete_mobile_capability
   * @param : os_id
   * @return : status true or false
   * 
   */

	public function delete_mobile_capability($id=FALSE)
	{
	 if($id){
	   $this->db->where('id', $id);
       $this->db->delete(TAB_TARG_MOB_CAPA); 
       $this->memcached_library->set(ADMIN_MOBILE_CAPABILITIES,'1');
	   	if ($this->db->trans_status() === FALSE)
		 {
		  $this->db->trans_rollback();
		 }
		else
		 {
		  $this->db->trans_commit();
		 }
		 
		 return 'true';
	   }
	  else{
		  return FALSE;	
	  }
    }
	
	   /*
   * 
   * name: block_category
   * @param : categoryid
   * @return : categoryid
   * 
   */
	public function block_category($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('category_id', $id);
			 $this->db->update(TAB_SITE_CATEGORIES,$data);
			 $this->memcached_library->set(ADD_TARGETING,'1');
			 $this->memcached_library->set(ADMIN_MAIN_CATEGORY,'1');
			return $id;
		 }
   }
   
      /*
   * 
   * name: unblock_category
   * @param : categoryid
   * @return : categoryid
   * 
   */
   	public function unblock_category($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('category_id', $id);
			 $this->db->update(TAB_SITE_CATEGORIES,$data);
			 $this->memcached_library->set(ADD_TARGETING,'1');
			 $this->memcached_library->set(ADMIN_MAIN_CATEGORY,'1');
			return $id;
		 }
   }     

    /*
   * 
   * name: block_os
   * @param : osid
   * @return : osid
   * 
   */
	public function block_os($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_OS,$data);
			 $this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'1');
			 $this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'1');
			return $id;
		 }
   }
   
	public function block_os_version($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_OS_VERSION,$data);

			return $id;
		 }
   }
   
      /*
   * 
   * name: unblock_os
   * @param : osid
   * @return : osid
   * 
   */
   	public function unblock_os($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_OS,$data);
			 $this->memcached_library->set(ADMIN_OPERATING_SYSTEM,'1');
			return $id;
		 }
   }   
   	public function unblock_os_version($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_OS_VERSION,$data);
			 
			return $id;
		 }
   }   
   
     	   /*
   * 
   * name: block_browser
   * @param : browser id
   * @return :browserid
   * 
   */
	public function block_browser($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_BROWSERS,$data);
			 $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
			return $id;
		 }
   }
	public function blockbrowserversion($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_BROWSER_VERSION,$data);
			// $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
			return $id;
		 }
   }
   
 	   /*
   * 
   * name: block_browser
   * @param : browser id
   * @return :browserid
   * 
   */
   	public function unblock_browser($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_BROWSERS,$data);
			 $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
			return $id;
		 }
   }
   
   
   	public function unblock_browser_version($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_BROWSER_VERSION,$data);
			// $this->memcached_library->set(ADMIN_TARGETTING_BROWSER,'1');
			return $id;
		 }
   }
   
   public function fetch_city_name($id=FALSE) 
   {
	   if($id)
	     {  
			 $this->db->select('city');
		     $this->db->where_in('id', $id);
			 $query = $this->db->get(TAB_TARG_CITY);	
			 if($query->num_rows()>0)
			 {
				$result		=	$query->result_array();
				foreach($result as $res_val)
				{
					$record[] = $res_val['city'];
				}				
				return $record;
			 }
		 }
   }
   
   /*
   * 
   * name: block_manu
   * @param :manu id
   * @return :manu id
   * 
   */
	public function block_manu($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_MOB_MANUFACT,$data);
			
			return $id;
		 }
   }
   
   /*
   * 
   * name: block_manu
   * @param : manu id
   * @return :manu id
   * 
   */
   	public function unblock_manu($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_MOB_MANUFACT,$data);
			return $id;
		 }
   }
   
     /*
   * 
   * name: block_os
   * @param : osid
   * @return : osid
   * 
   */
	public function mobile_block_os($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOB_OS,$data);
			return $id;
		 }
   }
   
      /*
   * 
   * name: unblock_os
   * @param : osid
   * @return : osid
   * 
   */
   	public function mobile_unblock_os($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOB_OS,$data);
			return $id;
		 }
   }   

    /*
   * 
   * name: mobile_block_manu
   * @param :manu id
   * @return :manu id
   * 
   */
	public function mobile_block_manu($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOB_MANU,$data);
			  $this->memcached_library->set(ADMIN_MOBILE_MANUFACTURER,'1');
			return $id;
		 }
   }
   
   /*
   * 
   * name: block_manu
   * @param : manu id
   * @return :manu id
   * 
   */
   	public function mobile_unblock_manu($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOB_MANU,$data);
			  $this->memcached_library->set(ADMIN_MOBILE_MANUFACTURER,'1');
			return $id;
		 }
   }
   
       /*
   * 
   * name: mobile_block_manu
   * @param :manu id
   * @return :manu id
   * 
   */
	public function mobile_block_capability($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOB_CAPA,$data);
			 $this->memcached_library->set(ADMIN_MOBILE_CAPABILITIES,'1');
			return $id;
		 }
   }
   
   /*
   * 
   * name: block_manu
   * @param : manu id
   * @return :manu id
   * 
   */
   	public function mobile_unblock_capability($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('is_blocked'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOB_CAPA,$data);
			 $this->memcached_library->set(ADMIN_MOBILE_CAPABILITIES,'1');
			 
			return $id;
		 }
   }
   
   /*
   * 
   * name: fetch_telecom_values
   * @param : 
   * @return :all the telecom operators details.
   * 
   */
	public function fetch_telecom_values()
	{
		$this->db->order_by('id','desc');
		$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			$i	=	0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}
			return $result;
		}
		else
		{
			return FALSE;
		} 
	}
   
	/*
   * 
   * name: block_telecom
   * @param : 
   * @return :block selected telecom operator.
   * 
   */
    public function block_telecom($id=FALSE)
    {
		if($id)
	     {  
		     $data=array('status'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOBILE_CARRIER,$data);
			return $id;
		 }
	} 
	
	/*
   * 
   * name: unblock_telecom
   * @param : 
   * @return :unblock selected telecom operator.
   * 
   */  	  
	public function unblock_telecom($id=FALSE)
	{
		if($id)
	     {  
		     $data=array('status'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_TARG_MOBILE_CARRIER,$data);
			return $id;
		 }
	}
	
/*
   * 
   * name: check_ip_exist
   * @param : 
   * @return :check for already exixt ip's.
   * 
   */  	  
	public function check_ip_exist($start_ip=FALSE,$end_ip=FALSE,$country,$carriername)
	{
		$this->db->select('*');
		$this->db->where('start_ip', $start_ip);
		$this->db->where('end_ip', $end_ip);
		//$this->db->where('country',$country);
		$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);
		#echo $this->db->last_query();exit;	
		if($query->num_rows()>0)
		{ 
			return '1';
			/*$this->db->select('*');
			$this->db->where('start_ip', $start_ip);
			$this->db->where('end_ip', $end_ip);
			$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);
			if($query->num_rows()>0)
		    {   
			    return '1';
			}
			else
			{
				return '0';
			}*/
		}
		else
		{
			return '0';
		}
		
	}
	
	/*
   * 
   * name: insert_tele_data
   * @param : 
   * @return :insert telecom operator data.
   * 
   */ 
	public function insert_tele_data($ins_data=FALSE)
    {
		$this->db->insert(TAB_TARG_MOBILE_CARRIER,$ins_data);
		return TRUE;
    }
    
    /*
   * 
   * name: update_tele_data
   * @param : 
   * @return :update already existing record with different country name.
   * 
   */ 
    public function update_tele_data($start_ip=FALSE,$end_ip=FALSE,$up_data=FALSE)
    {
		$this->db->where('start_ip',$start_ip);
		$this->db->where('end_ip',$end_ip);
		$this->db->update(TAB_TARG_MOBILE_CARRIER,$up_data);
		return TRUE;
	}
	
	/*
   * 
   * name: fetch_main_category
   * @param : 
   * @return :all the creatives details need to be approve
   * 
   */
	public function fetch_main_category()
	{
		
		$key = 'fetch_main_category';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_MAIN_CATEGORY);
		
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
		
			//$this->db->where('parent_category_id','0');
			//$this->db->where('is_deleted',0);
			//$this->db->order_by('category_id','desc');
			//$query = $this->db->get(TAB_SITE_CATEGORIES);
			
			$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT * from ".TAB_SITE_CATEGORIES."where parent_category_id='0' AND is_deleted='0'"; 
			$in_sel = "SELECT count(*) from ".TAB_SITE_CATEGORIES."where parent_category_id='0' AND is_deleted='0'";
			$SQL.= " ORDER BY category_name ASC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount ORDER BY c.category_name ASC"; 
			$query = $this->db->query($SQL);
			
			$result = $query->result_array();		
			
			if($query->num_rows()>0)
			{
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$this->memcached_library->set(ADMIN_MAIN_CATEGORY,'2');
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
			}
			else
			{
				return FALSE;
			}  
		}
		
	}
	
	public function update_category_value($category=FALSE,$final_cat=FALSE)
	{
		$this->db->where('category_id',$category);
		$updata = array('value'=>$final_cat);
		$this->db->update(TAB_SITE_CATEGORIES,$updata);
		$this->memcached_library->set(ADMIN_SUB_CATEGORY,'1');
		$this->memcached_library->set(ADD_TARGETING,'1');
	}
	
	public function dup_category_name_chk($cat_id=FALSE,$cat_name=FALSE)
	{
		$this->db->select('category_name');
		$this->db->where('category_name',$cat_name);
		$this->db->where_not_in('category_id',$cat_id);
		$query = $this->db->get(TAB_SITE_CATEGORIES)->num_rows();
		
		#echo $this->db->last_query();exit;
		#$query_count	=	$this->db->query($query)->num_rows();
		if($query)
		{			
			return $query;
		}
		else
		{
			return FALSE;
		} 		
	}
	
	/*
   * 
   * name: update_main_category
   * @param : categoryname,categoryvalue,categoryid
   * @return : category id
   * 
   */
	public function update_main_category($category_info=FALSE)
	{
	  $catObj=array( 'category_name'=>$category_info['category_name']
	                );
	  if(!empty($catObj)){
			$this->db->where('category_id',$category_info['category_id']);
			$this->db->update(TAB_SITE_CATEGORIES,$catObj);
			$this->memcached_library->set(ADMIN_MAIN_CATEGORY,'1');
			return $category_info['category_id'];
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
	 * 
	 * Check For Parent Category
	 */
	function check_category($cat_id=FALSE)
	{
		$this->db->select('parent_category_id,value');
		$this->db->where('category_id',$cat_id);
		$query =$this->db->get(TAB_SITE_CATEGORIES);
		
		if($query->num_rows()>0)
		{
			$result=$query->result_array();
			return $result;
		}
		else
		{
			return FALSE;
		} 
	}
	
	/*
	 * 
	 * 
	 * 
	 */
	public function delete_assoc_category($cat_id=FALSE,$par_val=FALSE)
	{
		
		/* Delete Child Category */
		$this->db->where('parent_category_id',$par_val);
		$this->db->delete(TAB_SITE_CATEGORIES);
		
		
		/* Delete Parent Category */
		$this->db->where('category_id',$cat_id);
		$this->db->delete(TAB_SITE_CATEGORIES);
		$this->memcached_library->set(ADD_TARGETING,'1');
		$this->memcached_library->set(ADMIN_MAIN_CATEGORY,'1');
		
	} 
	function check_category_root($par_val=FALSE)
	{ 
		$this->db->select('category_name,value');
		$this->db->where('value',$par_val);
		$query = $this->db->get(TAB_SITE_CATEGORIES);
		if($query->num_rows()>0)
		{
			$result=$query->result_array();
			return $result;
		}
		else
		{
			return FALSE;
		} 
	}
	
	/*
	* 
	* name: add_keyword
	* @param : 
	* @return :add the keyword details.
	* 
	*/
	public function add_keyword($keydata=FALSE){
		$this->db->insert(TAB_TARG_KEYWORD,$keydata);
		if($this->db->affected_rows()){
			$this->memcached_library->set(ADMIN_CONTEXTUAL_KEYWORD,'1');
			return TRUE;
		}
		else
		{
			return FALSE;
		} 
	}
	/*
	* 
	* name: fetch_keyword
	* @param : 
	* @return :all the keyword details.
	* 
	*/
	public function fetch_keyword($keyword_id=FALSE){
		
		$key = ADMIN_TARGETTING_FETCH_KEYWORD.'_'.$keyword_id;		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_CONTEXTUAL_KEYWORD.(($keyword_id!=FALSE)?'_'.$keyword_id:''));
		
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{		
		
			if($keyword_id!=FALSE)
			{
				$this->db->where('id',$keyword_id);
			}
			$this->db->where('is_deleted','0');
			$this->db->order_by('id','desc');
			$query = $this->db->get(TAB_TARG_KEYWORD);
			if($query->num_rows()>0){
				
				$result	=	$query->result_array();
								
				$count=$query->num_rows();
				$i	=	0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;					
					$this->memcached_library->set($key,$result,$account_type);
					$this->memcached_library->set(ADMIN_CONTEXTUAL_KEYWORD.(($keyword_id!=FALSE)?'_'.$keyword_id:''),'2');	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
				
			}
			else
			{
				return FALSE;
			} 
			
			/*if($keyword_id=FALSE)
			{
				$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT keyword from ".TAB_TARG_KEYWORD." where is_deleted=0 AND id=".$keyword_id; 
				$in_sel = "SELECT count(*) from ".TAB_TARG_KEYWORD." where is_deleted=0 AND id=".$keyword_id;
			
			}
			else
			{
				$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT keyword from ".TAB_TARG_KEYWORD." where is_deleted=0";
				$in_sel = "SELECT count(*) from ".TAB_TARG_KEYWORD." where is_deleted=0";
			}
			
			$SQL.= " ORDER BY id DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
			
			$query = $this->db->query($SQL);
			
			$result = $query->result_array();		  
			
			if($query->num_rows()>0)
			{
				return $result;
			}
			else
			{
				return FALSE;
			}*/	
				
		}	
	}
	
	/*
	* 
	* name: update_keyword
	* @param : 
	* @return :update the keyword details.
	* 
	*/
	public function update_keyword($id=FALSE,$keydata=FALSE){
		if($id!=FALSE)
		{
			$this->db->where('id',$id);
		}  
		$this->db->update(TAB_TARG_KEYWORD,$keydata);
		if($this->db->affected_rows()){
			$this->memcached_library->set(ADMIN_CONTEXTUAL_KEYWORD.'_'.$id,'1');
			$this->memcached_library->set(ADMIN_CONTEXTUAL_KEYWORD,'1');
			return TRUE;
		}
		else
		{
			return FALSE;
		} 
	}
	
	/*
   * 
   * name: delete_keyword
   * @param : keywordid
   * @return : status true or false
   * 
   */
   
	public function delete_keyword($id=FALSE)
	{
		if($id!=FALSE)
		{
			$this->db->where('id',$id);
		}  
		
		$data	=	array('is_deleted'=>1);			
		$this->db->update(TAB_TARG_KEYWORD,$data);
		if($this->db->affected_rows()){
			$this->memcached_library->set(ADMIN_CONTEXTUAL_KEYWORD,'1');
			return TRUE;
		}
		else
		{
			return FALSE;
		} 
	}
	
	/*
	* 
	* name: block_keyword
	* @param : 
	* @return :block the keyword details.
	* 
	*/
	public function block_keyword($id=FALSE){
		if($id!=FALSE)
		{
			$this->db->where('id',$id);
		}  
		$keydata	=	array('is_blocked'=>'1');
		$this->db->update(TAB_TARG_KEYWORD,$keydata);
		if($this->db->affected_rows()){
			$this->memcached_library->set(ADMIN_CONTEXTUAL_KEYWORD,'1');
			return TRUE;
		}
		else
		{
			return FALSE;
		} 
	}
	
	/*
	* 
	* name: unblock_keyword
	* @param : 
	* @return :unblock the keyword details.
	* 
	*/
	public function unblock_keyword($id=FALSE){
		if($id!=FALSE)
		{
			$this->db->where('id',$id);
		}  
		$keydata	=	array('is_blocked'=>'0');
		$this->db->update(TAB_TARG_KEYWORD,$keydata);
		if($this->db->affected_rows()){
			$this->memcached_library->set(ADMIN_CONTEXTUAL_KEYWORD,'1');
			return TRUE;
		}
		else
		{
			return FALSE;
		} 
	}
	
	/*
	* 
	* name: keyword_check
	* @param : 
	* @return :check the keyword details.
	* 
	*/
	function keyword_count_check($keyword)
	{	 
		$this->db->select('*');
		$this->db->where('is_deleted',0);
		$this->db->where("keyword",$keyword);
		$query_count	=	$this->db->get(TAB_TARG_KEYWORD)->num_rows();			
		if($query_count)
		{			
		     return $query_count;
		}
	}
	
	/****************************************************************************
	* Common Targeting Action
	****************************************************************************/ 
	 
	/*
	* 
	* name: fetch_targ_list
	* @param : os id
	* @return :selected os details.
	* 
	*/
	public function fetch_targ_list($tab=FALSE,$id=FALSE)
	{
		
		$key = 'fetch_targ_list_'.$tab.'_'.$id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_TARGETTING_BROWSER_LANGUAGE);
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
		
		
			$this->db->select('*');
			if($id!=FALSE)
			{
				$this->db->where('id',$id);
			}
			$this->db->order_by('id','desc');
			$query 	= 	$this->db->get($tab);
			if($query->num_rows()>0)
			{
				$result	=	$query->result_array();
				$count	=	$query->num_rows();
				$i	=0;	$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(ADMIN_TARGETTING_BROWSER_LANGUAGE,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
		}
		
	}
	
	/*
	* 
	* name: add_targeting
	* @param : name,value
	* @return :lastinsertid
	* 
	*/
	public function add_targeting($info=FALSE){
		if($info['targ_type']=='carrier')
		{
			$targObj = 	array(	"start_ip" 		=> 	$info['targ_start_ip'],
								"end_ip" 		=> 	$info['targ_end_ip'],
								"carriername" 	=> 	$info['targ_name'],
								"country"		=> 	$info['targ_country']
							);
		}
		else
		{
			$targObj = 	array(	"name" 	=> 	$info['targ_name'],
								"value"	=> 	$info['targ_value']
							);
		}
		if($this->db->insert($info['targ_table'],$targObj)){
			
			$this->memcached_library->set(ADMIN_TARGETTING_BROWSER_LANGUAGE,'1');
			return $this->db->insert_id();
			
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
	* 
	* name: update_targeting
	* @param : Name,Value,Id
	* @return : targeting id
	* 
	*/
	
	public function update_targeting($info=FALSE){
		if($info['targ_type']=='carrier')
		{
			$targObj 	= 	array(	"start_ip" 		=> 	$info['targ_start_ip'],
									"end_ip" 		=> 	$info['targ_end_ip'],
									"carriername" 	=> 	$info['targ_name'],
									"country"		=> 	$info['targ_country']
								);
		}
		else
		{
			$targObj 	= 	array( 	"name" 	=> 	$info['targ_name'],
									"value"	=> 	$info['targ_value']
								);
		}
		
		if($info['targ_id']){
			$this->db->where('id',$info['targ_id']);
			$this->db->update($info['targ_table'],$targObj);
			$this->memcached_library->set(ADMIN_TARGETTING_BROWSER_LANGUAGE,'1');
			return $info['targ_id'];
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
	* 
	* name: delete_targeting
	* @param : targeting id
	* @return : status true or false
	* 
	*/
    public function delete_targeting($info=FALSE){			 
		if($info['del_targ_id']){
			$this->db->where('id', $info['del_targ_id']);
			$this->db->delete($info['del_targ_table']); 
			$this->memcached_library->set(ADMIN_TARGETTING_BROWSER_LANGUAGE,'1');
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->trans_commit();
			}
		}
		else{
			return FALSE;	
		}
	}
	
	/*
	* 
	* name: block_targeting
	* @param : id
	* @return : id
	* 
	*/
	public function block_targeting($info=FALSE) 
	{
		if($info['targ_id'])
	    {  
		    $data	=	array('is_blocked'	=>	1);
		    $this->db->where('id', $info['targ_id']);
			$this->db->update($info['targ_table'],$data);
			$this->memcached_library->set(ADMIN_TARGETTING_BROWSER_LANGUAGE,'1');
			return $info['targ_id'];
		}
	}
   
    /*
	* 
	* name: unblock_targeting
	* @param : id
	* @return : id
	* 
	*/
   	public function unblock_targeting($info=FALSE) 
	{
		if($info['targ_id'])
	    {  
		    $data	=	array('is_blocked'	=>	0);
		    $this->db->where('id', $info['targ_id']);
			$this->db->update($info['targ_table'],$data);
			$this->memcached_library->set(ADMIN_TARGETTING_BROWSER_LANGUAGE,'1');
			return $info['targ_id'];
		}
	}	
	
	/*
	* 
	* name: fetch_city_country
	* @param : id
	* @return : id
	* 
	*/
   	public function fetch_city_country($where=FALSE) 
	{
		$this->db->select('country,region,city,country_region_city');
		if($where!=FALSE)
		{
			$this->db->where('id',$where['city']);
		}
		
		$query 	= 	$this->db->get(TAB_TARG_CITY);
		if($query->num_rows()>0)
		{
			$result		=	$query->result_array();
			$city_val	=	$result[0]['country'].'|'.$result[0]['city'];
			return $city_val;
		}
		else
		{
			return FALSE;
		}
	}	

   	public function fetch_country_city($where=FALSE,$city=FALSE) 
	{
		$this->db->distinct();
		$this->db->select('gic.id,gic.country,dtc.name,dtcr.region,gic.city');
		//$this->db->from('GeoIPCity as gic');
		$this->db->join('Geo_region as dtcr','dtcr.region_code=gic.region AND dtcr.country_code = gic.country');
		$this->db->join(TAB_TARG_COUNTRY.' as dtc','dtc.value=gic.country');
		if($where!=FALSE)
		{
			$this->db->where_in('gic.country',$where['country']);
		}
		if($city!=FALSE)
		{
			$this->db->where_not_in('gic.city',$city);
		}
		$this->db->where('gic.city is  NOT NULL');
		$this->db->group_by('gic.city');
		$query 	= 	$this->db->get(TAB_TARG_CITY.' as gic');
		if($query->num_rows()>0)
		{
			$result		=	$query->result_array();
			$i = 0;
			foreach($result as $res_val)
			{
				
				$test[$i]['id'] = $res_val['id'];
				$test[$i]['text'] = $res_val['city'].', '.$res_val['region'].', '.$res_val['name'];
				$i++;
			}
			return $test;
		}
		else
		{
			return FALSE;
		}
	}
   	public function fetch_country_cities($where=FALSE) 
	{
		$this->db->distinct();
		$this->db->select('gic.country,dtc.name,dtcr.region,gic.city');
		//$this->db->from('GeoIPCity as gic');
		$this->db->join('Geo_region as dtcr','dtcr.region_code=gic.region AND dtcr.country_code = gic.country');
		$this->db->join(TAB_TARG_COUNTRY.' as dtc','dtc.value=gic.country');
		if($where!=FALSE)
		{
			$this->db->where_in('gic.country',$where['country']);
		}
		$this->db->where('gic.city is  NOT NULL');
		$query 	= 	$this->db->get(TAB_TARG_CITY.' as gic');
		if($query->num_rows()>0)
		{
			$result		=	$query->result_array();
			$i = 0;
			foreach($result as $res_val)
			{
				
				$test[$i] = $res_val['city'].', '.$res_val['region'].', '.$res_val['name'];
				$i++;
			}
			return $test;
		}
		else
		{
			return FALSE;
		}
		/*$this->db->distinct();
		$this->db->select('city');
		if($where!=FALSE)
		{
			$this->db->where_in('country',$where['country']);
		}
		$this->db->where('city is  NOT NULL');
		$query 	= 	$this->db->get(TAB_TARG_CITY);				
			
			if($query->num_rows()>0)
			{
				$result		=	$query->result_array();
				$i = 0;
				foreach($result as $res_val)
				{
					$test[$i] = $res_val['city'];
					$i++;
				}
				return $test;
			}*/								
	}
   	public function fetch_zip_codes($where=FALSE) 
	{
		$this->db->distinct();
		$this->db->select('city as id,postalCode as text');
		
		if($where!=FALSE)
		{
			$this->db->where_in('country',$where['country']);
		}
		$this->db->where('postalCode !="" AND postalCode !=  "0"');
		$query 	= 	$this->db->get(TAB_TARG_CITY);
		if($query->num_rows()>0)
		{
			$result		=	$query->result_array();

			return $result;
		}
		else
		{
			return FALSE;
		}
	}
   	public function fetch_zip_codes1($where=FALSE,$zip=FALSE) 
	{
		$this->db->distinct();
		//$this->db->select('city as id,postalCode as text');
		$this->db->select('postalCode as id,postalCode as text');
		
		if($where!=FALSE)
		{
			$this->db->where_in('country',$where['country']);
		}
		if($zip!=FALSE)
		{
			$this->db->where_not_in('postalCode',$zip);
		}
		$this->db->where('postalCode !="" AND postalCode !=  "0"');
		$query 	= 	$this->db->get(TAB_TARG_CITY);
		if($query->num_rows()>0)
		{
			$result		=	$query->result_array();
			$i = 0;
			foreach($result as $res_val)
			{
				
				$test[$i]['id'] = $res_val['id'];
				$test[$i]['text'] = $res_val['text'];
				$i++;
			}
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
		
	function category_parent_id($cat_id=FALSE)
	{
		$this->db->select('parent_category_id');
		$this->db->where('category_id', $cat_id);
		$query=$this->db->get(TAB_SITE_CATEGORIES);
		if($query->num_rows()>0)
		{
			$result		=	$query->result_array();
			$val	=	$result[0]['parent_category_id'];
			return $val;
		}
		else
		{
			return FALSE;
		}
			 
	}
	
	public function fetch_os_version()
	{		
			//$this->db->select('gic.os_version as id,gic.os_version as os_version,dtc.name as os_name');//gic.*
			$this->db->select('gic.*,dtc.name as os_name');
			$this->db->join(TAB_TARG_OS.' as dtc','dtc.id=gic.os_val');
			$this->db->order_by('gic.id','desc');
			$query = $this->db->get(TAB_TARG_OS_VERSION.' as gic');
								
			if($query->num_rows()>0){
				$result	=	$query->result_array();
				$count=$query->num_rows();
				$i	=	0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
					return $result;				
			}
			
	}		         		   	    	   	 		
	
	public function remove_conflicts($value=FALSE,$table=FALSE,$column=FALSE,$where=FALSE,$where_in=FALSE)
	{
		$this->db->select($column);		
		$this->db->where_not_in($where,$value);
		if($where_in)
		{
			$this->db->where_in($where_in[0],$where_in[1]);
		}
		$query = $this->db->get($table);
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();	
			return $result;		
		}		
	}
	//checking countryblock performance/optimization
	public function fetch_country_optimization($campaign_id=FALSE,$country_value=FALSE,$country_edata=false)
	{
		$this->db->select('data');
		$this->db->where('campaignid',$campaign_id);	
		$this->db->where('type','Exclude_country');	
		//$this->db->where("FIND_IN_SET(data,'$country_value')!=", 0);	
		$this->db->from(TAB_ACLS);
		$query	=	$this->db->get();
		
		if($query->num_rows()>0)
		{
			$result= $query->result_array();	
			if (in_array($country_value, $result))
			{
				return true;
			}else
			{
			//update Query
		
			$country_data	=	array(
									"data"=>	$result[0]['data'].','.$country_value
									);
			$this->db->where('campaignid',$campaign_id);	
			$this->db->where('type','Exclude_country');	
			$this->db->update(TAB_ACLS,$country_data);
			return  true;
			}
		}
		else
		{
			
		$ox_acls_data =	$country_edata;
		$this->delete($ox_acls_data,$campaign_id);
			if($ox_acls_data AND $campaign_id)
		{
			$tartype	=	explode(':',$ox_acls_data['type']);
			$devtype	=	array('all','web','mobile','tablet');
				
			$this->db->trans_start();

			/*Insert in ox_acls */
			$this->db->select('campaignid');		
			$this->db->where('campaignid ',$campaign_id);
			/*if(isset($tartype[0]) && $tartype[0]=='device')
			{
				$this->db->like('type','device:');
			}
			else
			{*/
				$this->db->where('type',$ox_acls_data['type'].'IS NOT NULL');
				$this->db->where('comparison',$ox_acls_data['comparison']);
			//}
				
			$query = $this->db->get(TAB_ACLS);
				
			if($query->num_rows()>0)
			{
				/*if($tartype[0]=='device')
				{				
					$this->db->where('campaignid ',$campaign_id);	
					$this->db->like('type','device:');
					$this->db->delete(TAB_ACLS,$where);
				}
				else
				{*/
					$where=array('campaignid'=>$campaign_id,'type'=>$ox_acls_data['type'],'comparison'=>$ox_acls_data['comparison']);
					$this->db->delete(TAB_ACLS,$where);
				//}
			
				$this->db->insert(TAB_ACLS,$ox_acls_data);

				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			else
			{
				$this->db->insert(TAB_ACLS,$ox_acls_data);
				
				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			$this->memcached_library->set(ADD_TARGETING,'1');
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
		}
	}
	//checking countryunblock performance/optimization
	public function fetch_country_unblock_optimization($campaign_id=FALSE,$country_value=FALSE)
	{
		$this->db->select('data');
		$this->db->where('campaignid',$campaign_id);	
		$this->db->where('type','Exclude_country');	
		//$this->db->where("FIND_IN_SET(data,'$country_value')!=", 0);	
		$this->db->from(TAB_ACLS);
		$query	=	$this->db->get();
		
		if($query->num_rows()>0)
		{
			$result= $query->result_array();	
			$result_arr =	$result[0]['data'];
			$ctry_ex=explode(",",$result_arr);
			if (in_array($country_value, $ctry_ex))
			{
				if (($key = array_search($country_value, $ctry_ex)) !== false)
				 {
					unset($ctry_ex[$key]);
					$country_data	=	array(
									"data"=>	implode(',',$ctry_ex)
									);
									
					$this->db->where('campaignid',$campaign_id);	
					$this->db->where('type','Exclude_country');	
					$this->db->update(TAB_ACLS,$country_data);
					return  true;
				}
			}
		}
		
	}
	
	//checking zoneblock performance/optimization
	public function fetch_zone_block_optimization($campaign_id=FALSE,$zone_id=FALSE,$black_data=false)
	{
		$this->db->select('data');
		$this->db->where('campaignid',$campaign_id);	
		$this->db->where('type','profile:blacklist');	
		//$this->db->where("FIND_IN_SET(data,'$country_value')!=", 0);	
		$this->db->from(TAB_ACLS);
		$query	=	$this->db->get();
		
		if($query->num_rows()>0)
		{
			$result= $query->result_array();
			
			if (in_array($zone_id, $result))
			{
				return true;
			}else
			{
			//update Query
		
			$zone_data	=	array(
									"data"=>	$result[0]['data'].','.$zone_id
									);
			$this->db->where('campaignid',$campaign_id);	
			$this->db->where('type','profile:blacklist');	
			$this->db->update(TAB_ACLS,$zone_data);
			return  true;
			}
		}
		else
		{
			
			$ox_acls_data =	$black_data;
			$this->delete($ox_acls_data,$campaign_id);
			if($ox_acls_data AND $campaign_id)
		{
			$tartype	=	explode(':',$ox_acls_data['type']);
			$devtype	=	array('all','web','mobile','tablet');
				
			$this->db->trans_start();

			/*Insert in ox_acls */
			$this->db->select('campaignid');		
			$this->db->where('campaignid ',$campaign_id);
			/*if(isset($tartype[0]) && $tartype[0]=='device')
			{
				$this->db->like('type','device:');
			}
			else
			{*/
				$this->db->where('type',$ox_acls_data['type'].'IS NOT NULL');
				$this->db->where('comparison',$ox_acls_data['comparison']);
			//}
				
			$query = $this->db->get(TAB_ACLS);
				
			if($query->num_rows()>0)
			{
				/*if($tartype[0]=='device')
				{				
					$this->db->where('campaignid ',$campaign_id);	
					$this->db->like('type','device:');
					$this->db->delete(TAB_ACLS,$where);
				}
				else
				{*/
					$where=array('campaignid'=>$campaign_id,'type'=>$ox_acls_data['type'],'comparison'=>$ox_acls_data['comparison']);
					$this->db->delete(TAB_ACLS,$where);
				//}
			
				$this->db->insert(TAB_ACLS,$ox_acls_data);

				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			else
			{
				$this->db->insert(TAB_ACLS,$ox_acls_data);
				
				//UPDATE IN OX ACLS TABLE
				$this->update_campaign_targetting($campaign_id,$ox_acls_data);
			}
			$this->memcached_library->set(ADD_TARGETING,'1');
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		}
	}
	//checking zoneunblock performance/optimization
	public function fetch_zone_unblock_optimization($campaign_id=FALSE,$zone_id=FALSE,$black_data=FALSE)
	{
		$this->db->select('data');
		$this->db->where('campaignid',$campaign_id);	
		$this->db->where('type','profile:blacklist');	
		//$this->db->where("FIND_IN_SET(data,'$country_value')!=", 0);	
		$this->db->from(TAB_ACLS);
		$query	=	$this->db->get();
		
		if($query->num_rows()>0)
		{
			$result= $query->result_array();	
			$result_arr =	$result[0]['data'];
			$ctry_ex=explode(",",$result_arr);
			$db_c=count($ctry_ex);
			$view_c=count($zone_id);
			$ox_acls_data=$black_data;
			if (in_array($zone_id, $ctry_ex))
			{
				if (($key = array_search($zone_id, $ctry_ex)) !== false)
				 {
					unset($ctry_ex[$key]);
						if($view_c == $db_c)
						{
						$this->delete($ox_acls_data,$campaign_id);
						}
					$zone_data	=	array(
									"data"=>	implode(',',$ctry_ex)
									);
								
					$this->db->where('campaignid',$campaign_id);	
					$this->db->where('type','profile:blacklist');	
					$this->db->update(TAB_ACLS,$zone_data);
					return  true;
				}
			}
		}
		
	}
	public function delete_inline_keyword($key_id=FALSE)
	{
		
	if($key_id){
		$data=array('is_delete'=>1);
		$this->db->where('id', $key_id);
		if($this->db->update(TAB_INLINE_KEYWORDS,$data))
		{
		
		return TRUE;	
	  }
	  else{
		  return FALSE;	
	  }
	}
	}
	public function fetch_inline_keyword_select($id=FALSE)
	{ 
	  $this->db->select('*');
	  $this->db->where('id',$id);
	  $query = $this->db->get(TAB_INLINE_KEYWORDS);
	  $result=$query->result_array();
	  return $result;
	}
	public function update_main_inline_keywords($keyword_info=FALSE)
	{
	  $catObj=array( 'keywords'=>$keyword_info['keyword_name']
	                );
	  if(!empty($catObj)){
			$this->db->where('id',$keyword_info['id']);
			$this->db->update(TAB_INLINE_KEYWORDS,$catObj);
			
			return $keyword_info['id'];
		}
		else
		{
			return FALSE;
		}
	}
}
