<?php
class Do_subaccount extends CI_Model
{
	/*  djax_network_managers
	* ---------------------
	*  agency_id
		network_account_id
		manager_account_id
		role
		default_manager
		manager_status
		is_deleted
	* */
	 
	function fetch($account_id=FALSE,$account_type=FALSE,$user_id=FALSE)
	{		
		$key = SUBACCOUNT;
		if(!empty($account_id))
		{
			$key.='_'.$account_id;
		}
		if(!empty($account_type))
		{
			$key.='_'.$account_type;
		}
		if(!empty($user_id))
		{
			$key.='_'.$user_id;
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');
		$check_db_changes = $this->memcached_library->get(SUBACCOUNT_CHANGES);  
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{			
			return $ret;
		}
		else
		{
		$SQL = "SELECT 
					oxu.*,
					oxsr.*,oxsa.user_status,oxsa.role_block
				FROM ".TAB_USERS." as oxu
				JOIN ".TAB_ACCOUNTS." as oxac ON `oxac`.`account_id`=`oxu`.`default_account_id`
				JOIN ".TAB_SUB_ACCOUNT_ROLE_ASSOC." as oxsa ON oxsa.user_id=oxu.user_id AND oxsa.is_deleted=0 
				JOIN ".TAB_SUB_ACCOUNT_ROLES." as oxsr ON oxsr.role_id=oxsa.role_id
				WHERE 1 ";
		
		if($account_id!=FALSE)
		{
			$SQL .= " AND oxu.default_account_id={$account_id} ";
		}			
		
		//if($account_type!=FALSE)
		//{
			//$SQL .= " AND oxac.account_type='".$account_type."' ";
		//}
		
		if($user_id!=FALSE)
		{
			$SQL .= " AND oxu.user_id={$user_id} ";
		}
				
		$SQL .=	" GROUP BY oxu.user_id ORDER BY oxu.user_id DESC";
			
		$query 	= 	$this->db->query($SQL);
		
		$result = 	$query->result_array();
			
		if($result)
		{	
			$i	=	0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i	+=	1;
			}			
				if($mem_cache=='enable')
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set(SUBACCOUNT_CHANGES,'2');
						$this->memcached_library->set($key,$result,$account_type);
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else
					{
			return $result;
		}
			}
		else
		{
			return FALSE;
			}	
		}		
	}
		 
	function remove($user_id=FALSE)
	{
		if($user_id!=FALSE)
		{
			$where	=	array("user_id" 	=> 	$user_id);
			$data	=	array("is_deleted"	=>	1);
			
			$this->db->update(TAB_SUB_ACCOUNT_ROLE_ASSOC,$data,$where);
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{			
				$this->db->trans_commit();
				return TRUE;
			}	
		}
		else
		{
			return FALSE;
		}		
	}
	
	/* method : fetch_users
	 * 
	 * params : account_id
	 * 
	 * returns users and their assoc
	 * 
	 * */
	
	
	function fetch_users($account_id=FALSE)
	{					
		/*$key = 'fetch_users_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_FETCH_USERS);
		if($ret && $mem_cache=='enable' && $check_db_changes !='1' )
		{
			return $ret;
		}
		else{*/
		if($account_id!=FALSE)
		{
			$this->db->where('oxu.parent_account_id',$account_id);
		}
			
		$this->db->select('*,dura.is_default as default_user');
		$this->db->join(TAB_USER_ROLE_ASSOC.' as dura','dura.user_id=oxu.user_id');
		$this->db->join(TAB_ROLES.' as dr','dr.role_id=dura.role_id');
		$this->db->join(TAB_ACCOUNTS.' as oxac','oxac.account_id=oxu.default_account_id');
		$this->db->where('oxac.account_type','MANAGER');		
		$this->db->order_by('oxu.user_id','DESC');		
		$query = $this->db->get(TAB_USERS.' as oxu');
		$result = $query->result_array();
		$count=$query->num_rows();
		$i	=	0;$j=$count;
		if($result)
		{	
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}		
			/*if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$this->memcached_library->set(ADMIN_FETCH_USERS,'2');
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{*/
				return $result;
			//}
		}
		else
		{
	  		return FALSE;
		}			
			
	//}
}
	
	/* method : fetch_roles
	 * 
	 * params : 
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	function fetch_roles($account_type=FALSE,$role_id=FALSE)
	{
		$key = ROLES_LIST;
		if(!empty($role_id))
		{
			$key.='_'.$role_id;
		}
		if($account_type!=FALSE)
		{
			$key.='_'.$account_type;
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');
		if($ret && $mem_cache=='enable')
		{ 			
			return $ret;
		}
		else
		{		
		if($role_id!=FALSE)
		{
			$this->db->where('role_id', $role_id);
		}
		
		$query 	= 	$this->db->get_where(TAB_SUB_ACCOUNT_ROLES,array('status'=>1,'account_type'=>$account_type));	
		$count	=	$query->num_rows();
		$i	=	0; $j=$count;
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}
															
				if($mem_cache=='enable')
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else
				{	
			return $result;	
				}
			}
			else
			{				
			return FALSE;	
			}
		}		
	}
		
	
	/* method : add_user
	 * 
	 * params : $data
	 * 
	 * returns  users and their assoc
	 * 
	 * */
	function add_user($data=FALSE)
	{		
		$this->db->trans_begin();
		
		$cur_date	=	date('Y-m-d H:i:s');
		$account_id = 	$data['account_id'];
		/*$account_type = 	$data['account_type'];
		$agency_id = 	$data['agency_id'];
		$account_data = array(
							"account_type" 	=> 	$account_type,
							"account_name" 	=> 	$data['first_name']." ".$data['last_name']
						);*/
						
		//if($this->db->insert(TAB_ACCOUNTS,$account_data))
		//{
			$parent_account_id	=	$account_id;	
		/*-------------------------------------------
			INSERT OX USERS TABLE
		---------------------------------------------*/
		$user_data	=	array(
								"contact_name" 			=> 	$data['user_name'],
								"email_address" 		=> 	$data['email'],
								"username" 				=> 	$data['email'],
								"password" 				=> 	$data['password'],
								"default_account_id" 	=> 	$account_id,
								"active" 				=> 	1,
								"date_created"			=>	$cur_date,
								"parent_account_id" 	=> 	$parent_account_id
							);
							
		$this->db->insert(TAB_USERS,$user_data);
			
		$this->memcached_library->set(SUBACCOUNT_CHANGES,'1');
			
		$user_id	=	$this->db->insert_id();
				
		/*-------------------------------------------
		 INSERT dJAX_USER_APIKEY TABLE
		---------------------------------------------*/
		$api_key 	= 	generate_user_apikey($user_id);
		$key_data	=	array(   
							'user_id'	=> 	$user_id,
							'api_key'	=> 	$api_key
						);
		
		$this->db->insert(TAB_USER_APIKEY,$key_data);
		
		/*-------------------------------------------
				INSERT USER ACCOUNT ASSOCIATION
		---------------------------------------------*/		
		$user_assoc_data=	array(
								"account_id"	=>	$account_id,
								"user_id"		=>	$user_id,
								"linked"		=>	$cur_date
								);
								
		$this->db->insert(TAB_ACC_USER_ASSOC,$user_assoc_data);
		/*if($account_type == "ADVERTISER"){
		$clientInfo	=	array(
								"email"					=>	$data['email'],
								"contact"				=>	$data['first_name']." ".$data['last_name'],
								"clientname"			=>	$data['first_name']." ".$data['last_name'],
								"agencyid"				=>	$agency_id,
								"account_id"			=>	$account_id,
								"dj_first_name" 		=>  $data['first_name'],
								"dj_last_name"  		=>  $data['last_name'],
								"dj_added_date" 		=> 	$cur_date,
								"dj_approved_date"  	=> 	$cur_date,
								"dj_approval_status"  	=> 	1
								
								);
			
			$this->db->insert(TAB_CLIENTS,$clientInfo);
		}
		else if($account_type == "TRAFFICKER"){
			$affiliateInfo	=	array(
								"email"					=>	$data['email'],
								"contact"				=>	$data['first_name']." ".$data['last_name'],
								"name"					=>	$data['first_name']." ".$data['last_name'],
								"agencyid"				=>	$agency_id,
								"account_id"			=>	$account_id,
								"website"				=>	$data['site_url'],	
								"floor_price_enable"	=>	0,
								"dj_first_name" 		=>  $data['first_name'],
								"dj_last_name"  		=>  $data['last_name'],
								"dj_added_date" 		=> 	$cur_date,
								"referral_id"			=>	0,
								"dj_approved_date"  	=> 	$cur_date,
								"dj_approval_status"  	=> 	1
								);
			
			$this->db->insert(TAB_AFFILIATE,$affiliateInfo);
		}*/
		/*-------------------------------------------
				INSERT SECURITY
			---------------------------------------------*/
			/*$ox_security	=	array(
								"account_id"	=>	$account_id,
								"security"		=>	"1,2,3,4,5",
								"token_type"		=>	3,
								"security_question_id"					=>	$data['security_id'],
								"security_question_answer"					=>	$data['security_answer'],
								);
			$this->db->insert(TAB_SECURITY,$ox_security);*/
		/*-------------------------------------------
				INSERT USER PERMISSION
		---------------------------------------------*/
			
		$perm_array 	= 	array('1','2','4','10','11','13','15','19','31','51','52','54','55','56','57','58','61');
		$ins_per_arr 	= 	array();
		
		if(!empty($perm_array))
		{
			foreach($perm_array as $perm_id)
			{
				$ins_per_arr[] 	= 	array('account_id'	=>	$account_id,
										'user_id'		=>	$user_id,
										'permission_id'	=>	$perm_id
									);	
			}
			$this->db->insert_batch(TAB_ACC_USER_PER_ASSOC,$ins_per_arr);	
		}
		
		$user_role_assoc = 	array(
								"user_id"		=>	$user_id,
								"role_id"		=>	$data['role_id'],
								"account_type"	=>	$data['account_type']
							);
		
		$this->db->insert(TAB_SUB_ACCOUNT_ROLE_ASSOC,$user_role_assoc);				
				
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return FALSE;
		}
		else
		{
			$this->db->trans_commit();
			return $user_id;
		}
		//}
		//else{
		//return FALSE;	
		//}			
	}
	
	
	/* method : update
	 * 
	 * params : $data
	 * 
	 * returns users and their assoc
	 * 
	 * */
	function update($data=FALSE)
	{		
		$this->db->trans_begin();
		
			/*$where_acc	=	array('account_id'	=>	$data['account_id'],'account_type'	=>	$data['account_type']);
			$acc_data	=	array(
							"account_name"	=>	$data['first_name'].' '.$data['last_name']
							);
		
		
		$this->db->where($where_acc);				
		$this->db->update(TAB_ACCOUNTS,$acc_data);*/
		$where		=	array('default_account_id' => $data['account_id'],'user_id' => $data['user_id']);
			
		$user_data	=	array( 	"contact_name" 	=> 	$data['user_name'],
								"email_address" => 	$data['email'],
							);
			
		$this->db->update(TAB_USERS,$user_data,$where);
		
		$this->memcached_library->set(SUBACCOUNT_CHANGES,'1');  
		
		//compare previous role id with selected role id
		$this->db->select('role_id,role_block');
		$this->db->where('user_id',$data['user_id']);
		$query	=	$this->db->get(TAB_SUB_ACCOUNT_ROLE_ASSOC);
		$result	=	$query->result_array();
		
		if($result)
		{
			$role_id		=	$result[0]['role_id'];
			$role_blocked	=	$result[0]['role_block'];
		}
		
		//IF same role-id and role is blocked
		if($role_blocked==1 && $role_id==$data['role_id'])
		{
			$role_assoc			=	array('user_id' => $data['user_id']);
			 
			$user_role_assoc 	= 	array(	'role_id'	=>	$data['role_id'] );
			
			$this->db->update(TAB_SUB_ACCOUNT_ROLE_ASSOC,$user_role_assoc,$role_assoc);
		}
		//IF unblocked role-id updated
		else
		{
			$role_assoc	=	array('user_id'	=> 	$data['user_id']);
			 
			$user_role_assoc = array( 'role_id'		=>	$data['role_id'],
									  'role_block'	=> 	0
									);
									
			$this->db->update(TAB_SUB_ACCOUNT_ROLE_ASSOC,$user_role_assoc,$role_assoc);
		}
		
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return FALSE;
		}
		else
		{
			$this->db->trans_commit();
			return TRUE;
	    }
	}
	
	/* method : block_users
	 * 
	 * params : $user_id
	 * 
	 * returns  users and their assoc
	 * 
	 * */
	public function block_users($user_id)
	{
		$this->db->trans_begin();
		
		$where	=	array('user_id'		=>	$user_id);
		$data	=	array('user_status'	=>	0);
	   				  
		$this->db->update(TAB_SUB_ACCOUNT_ROLE_ASSOC,$data,$where);
	   
		//$this->memcached_library->set(ADMIN_FETCH_USERS,'1');
	   
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return FALSE;
		}
		else
		{			
			$this->db->trans_commit();
			return TRUE;
	    }
	}
	
	/* method : block_users
	* 
	* params : $user_id
	* 
	* returns  users and their assoc
	* 
	* */
	public function unblock_users($user_id)
	{
		$this->db->trans_begin();
		
		$where	=	array('user_id'		=>	$user_id);
		$data	=	array('user_status'	=>	1);				  
		$this->db->update(TAB_SUB_ACCOUNT_ROLE_ASSOC,$data,$where);
	   
		//$this->memcached_library->set(ADMIN_FETCH_USERS,'1');
	   
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return FALSE;
		}
		else
		{
			$this->db->trans_commit();
			return TRUE;
	    }
	}
	
	public function get_user_api_key($account_id)
	{
		
		$key = 'get_user_api_key_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	    $this->db->select('dua.api_key');
		$this->db->from(TAB_USER_APIKEY.' as dua');
		$this->db->where('du.default_account_id',$account_id);
		$this->db->join(TAB_USERS.' as du','du.user_id=dua.user_id');
		$query=$this->db->get();
		if($query->num_rows>0)
		{
			$result=$query->result_array();
			if($mem_cache=='enable' )
			{
				$account_type	=	$this->user_authentication->account_type;
				//$this->memcached_library->set($key,$result[0],$account_type);	
				$set = 	$this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result[0];
			}
		}
		else
			{
				return FALSE;
			}
		}
	}
	
	public function fetch_role_permission($role_id,$user_id)
	{
		$key = FETCH_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_SUB_ACCOUNT_ROLE_PERMISSION);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		
			$this->db->select('permission_value');
			$this->db->where('role_id',$role_id);
			$this->db->where('user_id',$user_id);
			$query=$this->db->get(TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC);
			$result=$query->result_array(); 
			//return $this->db->last_query();
			$final_arr = array();
			if($result)
			{
				foreach($result as $key=>$value)
				{
					$final_arr[$key] = $value['permission_value'];
				}
			   
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set(FETCH_SUB_ACCOUNT_ROLE_PERMISSION,'2');
					$this->memcached_library->set($key,$final_arr,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $final_arr;
				}
			}
		}
	}
		/* 
	* name: fetch_user_role_list
	* @param : null
	* @return : return all user_role list from djax_roles
	*/
	public function fetch_user_role_list()
	{
		
		/*$key = ADMIN_FETCH_USER_ROLE;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(USER_ROLE_LIST);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{*/
		$this->db->select('*');
		$this->db->order_by("role_id");
		$query	=	$this->db->get(TAB_SUB_ACCOUNT_ROLES);
		$result	=	$query->result_array();
		if($result)
		{	
			$i=0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}			
			/*if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set(USER_ROLE_LIST,'2');
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{*/
				return $result;
			//}
		}
		else
		{
			return FALSE;
		}
	// }
	}
	 public function add_role($roles)
	 {
		 //DELETE THE EXISTING ID IF VALUES FOUND
		$this->db->delete(TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC,array('role_id'=>$roles['role_id'],'user_id'=>$roles['user_id']));
	//return $roles;
		//CALL TO ANOTHER METHOD TO INSERT
		
		$res=$this->add_role_permission($roles,$roles['role_id']);
		return $res;
	}
	
	public function update_role($roles)
	{		
	    
		//DELETE THE EXISTING ID IF VALUES FOUND
		$this->db->delete(TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC,array('role_id'=>$roles['role_id'],'user_id'=>$roles['user_id']));
	
		//CALL TO ANOTHER METHOD TO INSERT
		$res=$this->add_role_permission($roles);
		return $res;
	}
	
	public function add_role_permission($roles,$last_inserted_id=FALSE)
	{
	    //INSERT MANAGER PERMISSION ID's into djax_role_permission_assoc
		$final_arr=array();
		if($last_inserted_id!=FALSE)
		{
			foreach($roles['man_per'] as $permission)
			{  
			  $perm_data=array( 'role_id'=>$last_inserted_id,
								'permission_value'=>$permission,
								'user_id'=>$roles['user_id']
							  );
			   array_push($final_arr,$perm_data);
			}
		   $this->db->insert_batch(TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC,$final_arr);
		   $this->memcached_library->set(FETCH_SUB_ACCOUNT_ROLE_PERMISSION,'1');
		}
		else
		{
		    foreach($roles['man_per'] as $permission)
			{  
			  $perm_data=array( 'role_id'=>$roles['role_id'],
								'permission_value'=>$permission,
								'user_id'=>$roles['user_id']
							  );
			   array_push($final_arr,$perm_data);
			}
			//return $roles;
		   $this->db->insert_batch(TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC,$final_arr);
		   $this->memcached_library->set(FETCH_SUB_ACCOUNT_ROLE_PERMISSION,'1');
		}
		return TRUE;
	}
	function fetch_user_details($account_id=FALSE,$account_type=FALSE,$user_id=FALSE)
	{		
		$SQL = "SELECT 
					oxu.*,
					oxsr.*,oxsa.user_status,oxsa.role_block
				FROM ".TAB_USERS." as oxu
				JOIN ".TAB_ACCOUNTS." as oxac ON `oxac`.`account_id`=`oxu`.`default_account_id`
				JOIN ".TAB_SUB_ACCOUNT_ROLE_ASSOC." as oxsa ON oxsa.user_id=oxu.user_id AND oxsa.is_deleted=0 
				JOIN ".TAB_SUB_ACCOUNT_ROLES." as oxsr ON oxsr.role_id=oxsa.role_id WHERE 1 ";
		
		if($account_id!=FALSE)
		{
			$SQL .= " AND oxu.default_account_id={$account_id} ";
		}			
		
		
		
		if($user_id!=FALSE)
		{
			$SQL .= " AND oxu.user_id={$user_id} ";
		}
				
		$SQL .=	" GROUP BY oxu.user_id ORDER BY oxu.user_id DESC";
			
		$query 	= 	$this->db->query($SQL);
		
		$result = 	$query->result_array();
			
		if($result)
		{	
			$i	=	0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i	+=	1;
			}			
			return $result;
		}
		else
		{
			return FALSE;
		}		
	}
	/* method : fetch_roles
	 * 
	 * params : 
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	function fetch_subaccount_roles_set($account_type=FALSE,$role_id=FALSE,$user_id=FALSE)
	{
		
		$this->db->select('permission_value');
			$this->db->where('role_id',$role_id);
			$this->db->where('user_id',$user_id);
			$query=$this->db->get(TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC);
			
		$count	=	$query->num_rows();
		
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			
			return $result;	
		}else{
			return FALSE;	
		}		
	}
	
	public function fetch_role_permission_value($role_id,$parent_account_id)
	{
		/*$key = FETCH_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_SUB_ACCOUNT_ROLE_PERMISSION);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{*/
		
			
			$this->db->select('dua.permission_value');
		$this->db->from(TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC.' as dua');
		$this->db->where('du.default_account_id',$parent_account_id);
		$this->db->where('dua.role_id',$role_id);
		$this->db->join(TAB_USERS.' as du','du.user_id=dua.user_id');
		$query=$this->db->get();
			$result=$query->result_array(); 
			//return $this->db->last_query();
			$final_arr = array();
			if($result)
			{
				foreach($result as $key=>$value)
				{
					$final_arr[$key] = $value['permission_value'];
				}
			   
				/*if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set(FETCH_SUB_ACCOUNT_ROLE_PERMISSION,'2');
					$this->memcached_library->set($key,$final_arr,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{*/
					return $final_arr;
				//}
			}
		//}
	}
}
