<?php
Class Do_special_bidding extends CI_Model
{

	function add_traffic_sources($traffic_source_data)
	{
		if($traffic_source_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_CAMP_TRAFFIC,$traffic_source_data);
			$traffic_id=$this->db->insert_id();
			$this->memcached_library->set(ADV_ADD_TRAFFIC_SOURCES,'1');
			
			$this->memcached_library->set(ADV_CHECK_TRAFFIC_SOURCES,'1');
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				
				return $traffic_id;
			}
		}
	}
	
	
	function check_traffic_sources($source=FALSE,$campaign_det=FALSE,$account_id=FALSE,$admarket=FALSE)
	{
		$key = 'check_traffic_sources'.$source.$campaign_det.$account_id;
		if($campaign_det):
			foreach($campaign_det as $value)
			{
				$key .= '_'.$value;
			}
		endif;
		
		if($admarket!=FALSE)
		{
			$key.='_'.$admarket;
		}
						
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes	=	$this->memcached_library->get(ADV_CHECK_TRAFFIC_SOURCES);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{ 
			if($source)
			{
				$this->db->select('id');
				if($source!='' AND $campaign_det=='')
				{
				$this->db->where('traffic_id',$source); 
				$this->db->where('campaign_id',''); 
				$this->db->where('account_id',$account_id); 
				}	
				else if($source!='' AND $campaign_det!='')
				{
				$this->db->where('traffic_id',$source); 
				$this->db->where('account_id',$account_id); 
				$this->db->where('campaign_id',$campaign_det); 				
				}
				if($admarket!=FALSE)
				{
					$this->db->where('admarket',$admarket);
				}
				else
				{
					$this->db->where('admarket','0');
				}
				
				$query = 	$this->db->get(TAB_CAMP_TRAFFIC);  
				$result=	$query->result_array();
				
				if($result)
				{
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,FALSE,$account_type);	
						$this->memcached_library->set(ADV_CHECK_TRAFFIC_SOURCES,'2');	
						$set = $this->memcached_library->get($key);	
						
						return $set;
					}
					else{
						return FALSE;
					}
				}
				else
				{
					return TRUE;
				}
			}
		}
	}
	
	
	public function fetch_traffic_source($cid)
	{
		if($cid)
		{
			
			$this->db->select('*');
				$this->db->where('id',$cid); 
				$query = 	$this->db->get(TAB_CAMP_TRAFFIC);
				$result=	$query->result_array();
			
			
			if($result)
			{
				return $result[0];
			}
			else
			{
				return FALSE;
			}	 
		}
		else
		{
			return FALSE;
		}	   
	}
	
	public function fetch_zone_id($cid)
	{
		if($cid)
		{
			
			$this->db->select('*');
				$this->db->where('id',$cid); 
				$query = 	$this->db->get(TAB_CAMP_ZONE);
				$result=	$query->result_array();
			
			
			if($result)
			{
				return $result[0];
			}
			else
			{
				return FALSE;
			}	 
		}
		else
		{
			return FALSE;
		}	   
	}
	
	
	function add_zone_bidding($zone_bidding_data)
	{
		if($zone_bidding_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_CAMP_ZONE,$zone_bidding_data);
			$zone_id=$this->db->insert_id();
			$this->memcached_library->set(ADV_ADD_ZONE_BIDDING,'1');			
			$this->memcached_library->set(ADV_CHECK_ZONE_BIDDING,'1');			
			$this->db->trans_complete();
			//return $this->db->last_query();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				
				return $zone_id;
			}
		}
	}
	
	function check_zone_bidding($zone_bid=FALSE,$campaign_det=FALSE,$account_id=FALSE,$admarket=FALSE)
	{
		$key = 'check_zone_bidding_'.$zone_bid.$campaign_det.$account_id;   
		if($campaign_det):
			foreach($campaign_det as $value)
			{
				$key .= '_'.$value;
			}
		endif;
		
		if($admarket!=FALSE)
		{
			$key.='_'.$admarket;
		}
						
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes	=	$this->memcached_library->get(ADV_CHECK_ZONE_BIDDING);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{ 
			if($zone_bid)
			{
				$this->db->select('id');
				if($zone_bid!='' AND $campaign_det=='')
				{
				$this->db->where('zone_id',$zone_bid); 
				$this->db->where('campaign_id',''); 
				$this->db->where('account_id',$account_id); 
				}	
				else if($zone_bid!='' AND $campaign_det!='')
				{
				$this->db->where('zone_id',$zone_bid); 
				$this->db->where('account_id',$account_id); 
				$this->db->where('campaign_id',$campaign_det); 				
				}
				
				if($admarket!=FALSE)
				{
					$this->db->where('admarket',$admarket);
				}
				else
				{
					$this->db->where('admarket','0');
				}
				
				$query = 	$this->db->get(TAB_CAMP_ZONE);
				$result=	$query->result_array();
				
				//echo $this->db->last_query(); exit;
				
				if($result)
				{
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,FALSE,$account_type);	
						$this->memcached_library->set(ADV_CHECK_ZONE_BIDDING,'2');	
						$set = $this->memcached_library->get($key);	 
						
						return $set;
					}
					else{
						return FALSE;
					}
				}
				else
				{
					return TRUE;
				}
			}
		}
	}	
	
	function import_zonebidding($import_bidding_data)
	{
        
		if($import_bidding_data)
		{
			$this->db->trans_start();
						
			$SQL="INSERT INTO `djax_campaign_zone_bidding` (`account_id`,`campaign_id`, `campaign_type`, `zone_id`,`bid_rate`,`status`,`admarket`) VALUES ('".$import_bidding_data['account_id']."','".$import_bidding_data['campaign_id']."','".$import_bidding_data['bidding_type']."', '".$import_bidding_data['zoneid']."','".$import_bidding_data['bidding_value']."','".$import_bidding_data['status']."','".$import_bidding_data['admarket']."')";
						
			$query = $this->db->query($SQL);
     		$bidding_id=$this->db->insert_id();						
			$this->db->trans_complete();
			if($bidding_id)
			{				
			  return  $bidding_id;  
			}
			else
			{
			  return FALSE;	
			}	
	
		 }
	 }
	 
	 function fetch_export_trafficsource_data($id=FALSE,$account_id=FALSE,$admarket=FALSE)
	 {
		$this->db->select('a.account_id as account_id, a.campaign_id as campaignid,a.source_type as bidding_type ,a.traffic_id as sourceid,a.bid_rate as bidrate,a.status as status,a.admarket as admarket,a.id as c_id');
		$this->db->from(TAB_CAMP_TRAFFIC.' as a');
		$this->db->join(TAB_AFFILIATE.' as b', 'b.account_id = a.traffic_id','left');
		$this->db->where_in('a.id',$id);
		if($admarket!=FALSE)
		{
			$this->db->where('admarket','1');
		}
		else
		{
			$this->db->where('admarket','0');		
		}
		//$this->db->where('a.account_id',$account_id );  
		$query = $this->db->get();		
		
		//echo $this->db->last_query();		
		//return $this->db->last_query();  die();
		$result = $query->result_array();
		$count=$query->num_rows();   
		
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
			
	 }
	 
	 function fetch_export_zonebidding_data($id=FALSE,$account_id=FALSE,$admarket=FALSE)
	{
		
		$this->db->select('a.account_id as account_id, a.campaign_id as campaignid,a.campaign_type as bidding_type ,a.zone_id as zoneid,a.bid_rate as bidrate,a.status as status,a.admarket as admarket,a.id as c_id');
		$this->db->from(TAB_CAMP_ZONE.' as a');
		$this->db->join(TAB_ZONES.' as b', 'b.zoneid = a.zone_id','left');
		$this->db->where_in('a.id',$id);
		if($admarket!=FALSE)
		{
			$this->db->where('admarket','1');
		}
		else
		{
			$this->db->where('admarket','0');		
		}
		//$this->db->where('a.account_id',$account_id );
		$query = $this->db->get();		
		$result = $query->result_array();
		$count=$query->num_rows();   
		
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
			
		
	}  
	
	 
	 function check_traffic_sources_import($source=FALSE)
	{
			if($source)
			{ 
				$this->db->select('*');
				$this->db->from(TAB_CAMP_TRAFFIC);
				$this->db->where('campaign_id',$source['campaign_id']);
				$this->db->where('traffic_id',$source['traffic_id']);
				if(!empty($source['source_type']))
				{
				$this->db->where('source_type',$source['source_type']);
				}	
				if(!empty($source['admarket']))
				{
				$this->db->where('admarket',$source['admarket']);
				}
				$query = $this->db->get();		
				$result=	$query->result_array(); 
				$count=$query->num_rows(); 
							 
				if($query->num_rows()>0) 
				{
					return FALSE;
				}
				else
				{
					return TRUE;
				}
			}
		
	}
	
	function check_zone_bidding_import($source=FALSE)
	{
			if($source)
			{ 
				$this->db->select('*');
				$this->db->from(TAB_CAMP_ZONE);
				$this->db->where('campaign_id',$source['campaign_id']);
				$this->db->where('zone_id',$source['zone_id']);
				if(!empty($source['admarket']))
				{
				$this->db->where('admarket',$source['admarket']);
				}
				$query = $this->db->get();		
				$result=	$query->result_array();   
				$count=$query->num_rows(); 
				 
				if($query->num_rows()>0) 
				{
					return FALSE;
				}
				else
				{
					return TRUE;
				}
			}
		
	}
	
	
	function check_zone_bid_exist($import_bidding_data)
	{
		$this->db->select('account_id,campaign_id,zone_id');
		$this->db->from(TAB_CAMP_ZONE);
		$this->db->where('account_id',$import_bidding_data['account_id']);
		$this->db->where('campaign_id',$import_bidding_data['campaign_id']);
		$this->db->where('zone_id',$import_bidding_data['zone_id']);
		$query = $this->db->get();		
		$result = $query->result_array();
		$count=$query->num_rows();   
		
		if($count>0)
		{
			return FALSE;
		}
		else
		{
			return TRUE;  
		}
	}	
	
}