<?php
class Do_site extends CI_Model
{
	/*  djax_publisher_sites
	 * ---------------------
	 *  site_id
		account_id
		site_name
		site_url
		comments
		is_default
		added_date
		updated_date
		is_deleted
	 * */
	 
	 function add($account_id,$name,$url,$comments='',$is_default=0){
		
		$siteObj = array(
							"account_id" 	=> $account_id,
							"site_name" 	=> $name,
							"site_url" 		=> $url,
							"comments" 		=> $comments,
							"is_default" 	=> $is_default,
							"verify"		=> '0',
							"added_date" 	=> date("Y-m-d H:i:s")
						);
						
		if($this->db->insert(TAB_PUB_SITES,$siteObj)){
			
			$this->memcached_library->set(SITE_CHANGES,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 /* Mass Import*/
	  function add_import($add_data){
		

						
		if($this->db->insert(TAB_PUB_SITES,$add_data)){
			
			//$this->memcached_library->set(SITE_CHANGES,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 /* Mass Import*/
	 function add_zone_import($add_data){
		

						
		if($this->db->insert(TAB_ZONES,$add_data)){
			
			//$this->memcached_library->set(SITE_CHANGES,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 /* Mass Import*/
	 
	 
	 function update($site_info,$site_url){
		
		
		$siteObj = array('site_name'=>$site_info['site_name'],
						'site_url'=>$site_url,
						'updated_date'=>date('Y-m-d H:i:s')
					);
		
		if(!empty($siteObj)){
			
			$this->db->where('site_id',$site_info['site_id']);
			$this->db->update(TAB_PUB_SITES,$siteObj);
			$this->memcached_library->set(SITE_CHANGES,'1');
			$this->memcached_library->set(EDIT_SITE_CHANGES,'1');
			
			return $site_info['site_id'];
			
		}
		else
		{
			return FALSE;
		}
	 }
	 
	  public function url_creation($url)
	{
		
		if (!preg_match("~^(?:f|ht)tps?://~i", $url)) 
		{
			
           $site_url = "http://" . $url;
        }
        else
        {
		   $site_url = $url;	
		}	
		//$this->response($site_url,200);
		return $site_url;
    }		
	 
	 function fetch_verify($site_id=FALSE)
	 {
		 $SQL ="select verify FROM ".TAB_PUB_SITES." where site_id=".$site_id;
		 
		 $query = $this->db->query($SQL);		
		
		 $result = $query->result_array();
		 
		 if($result)
		 {
			return $result; 
		 }
		 else
		 {
			 return FALSE;
		 }
		 
	 }
	 
	 function fetch_db_site($site_id=FALSE)
	 {
		 $SQL ="select site_url FROM ".TAB_PUB_SITES." where site_id=".$site_id;
		 
		 $query = $this->db->query($SQL);		
		
		 $result = $query->result_array();
		 
		 if($result)
		 {
			return $result; 
		 }
		 else
		 {
			 return FALSE;
		 }
		 
	 }
	 
	 function edit_fetch($site_id=FALSE)
	 {
		 $this->db->where_not_in("site_id",$site_id);
			
		 $query = $this->db->get(TAB_PUB_SITES);
				
		 $result = $query->result_array();  
		 
		 if($result)
		 {
			 return $result;
		 }
		 else
		 {
			 return FALSE;
		 }
				 
	 }
	 
	  function update_db_site($site_id=FALSE,$site_url=FALSE)
	 {
		 $site_val = array('site_url'=>$site_url);
		 if($site_id)
		 {
			$this->db->where('site_id',$site_id);
			$this->db->update(TAB_PUB_SITES,$site_val);
			return TRUE;  
		 }
		 else
		 {
			return FALSE;
		 }	 
			
	 }
	 
	 function update_verify($site_id=FALSE,$verify=FALSE)
	 {
		 $verify_val = array('verify'=>$verify);
		 if($site_id)
		 {
			$this->db->where('site_id',$site_id);
			$this->db->update(TAB_PUB_SITES,$verify_val);
			return TRUE;  
		 }
		 else
		 {
			return FALSE;
		 }	 
			
	 }
	 

	 
	 function fetch($where=FALSE,$site_id=FALSE){		 		 	 
		 		 
		/**************fetch sites****************/
		$key = PUB_SITE.'account_'.$where['oxa.account_id'];
		
		if(!empty($site_id))
		{
			$key.='_site_'.implode('_',$site_id);
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(SITE_CHANGES);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			
			return $ret;
		}
		else{
						
	 
	 	$SQL = "SELECT @i := @i -1 AS row_number,c.*
				FROM
				(SELECT ps.site_id,ps.account_id,ps.verify,ps.site_name,ps.site_url,ps.is_default,oxa.name,
				IFNULL(imp,0) as IMP,
				IFNULL(clk,0) as CLK,	
				IFNULL(conv,0) as CONV,
				TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((clk/imp)*100,0),2))) as CTR	,
				TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((revenue/imp)*1000,0),2))) as ECPM,
				TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(revenue,0),4))) as Revenue
				FROM 
					 ".TAB_PUB_SITES." as ps			
				JOIN ".TAB_AFFILIATE." as oxa ON ps.account_id = oxa.account_id
				LEFT JOIN (
					SELECT 
						sza.site_id,
						sum(oxah.impressions) as imp,
						sum(oxah.clicks) as clk,
						sum(oxah.conversions) as conv,
						sum(oxah.dj_publisher_earnings) as revenue
					FROM
						".TAB_DATA_SUM_AD_HOURLY." as oxah
					JOIN 
						".TAB_SITE_ZONE_ASSOC." as sza ON sza.zone_id=oxah.zone_id
					GROUP BY
						sza.site_id
						
				) as oxd ON oxd.site_id=ps.site_id				
				WHERE 
					 ps.is_deleted =0 AND oxa.dj_is_deleted =0 ";
					if($where!=false)
					{
						$SQL	.=" AND oxa.account_id=".$where['oxa.account_id'];
					}
					else
					{					
					if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
			
							$SQL	.=" AND oxa.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
						
					endif;
					}
					
					if($site_id!=false)
					{
						if(count($site_id)>1)
						{
						$SQL	.=" AND ps.site_id IN (".implode(',', $site_id).")";
						}
						else
						{
							$SQL	.=" AND ps.site_id IN (".$site_id.")";
						}
					}
					
					
					// code  start	
					
			 $in_sel= "select count(*) 	FROM 
					 ".TAB_PUB_SITES." as ps

				JOIN ".TAB_AFFILIATE." as oxa ON ps.account_id = oxa.account_id
				
				WHERE 
					 ps.is_deleted =0 AND oxa.dj_is_deleted =0 ";   
			 if($where!=false)
				{
					$in_sel .=" AND oxa.account_id=".$where['oxa.account_id'];
				}
				else
					
				{
					if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
		
						$in_sel	.=" AND oxa.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
					endif;
				}

				if($site_id!=false)
					{												
						if(count($site_id)>1)
						{
						    $in_sel	.=" AND ps.site_id IN (".implode(',', $site_id).")";
						}
						else
						{
							$in_sel	.=" AND ps.site_id IN (".$site_id.")";
						}
					}
					
					
				
				// code end
					 
		$SQL .= " ORDER BY ps.site_id DESC) as c,(SELECT @i := ($in_sel) + 1) as rowcount" ;	
							
		$query = $this->db->query($SQL);		
		
		$result = $query->result_array();
	
				
		if($result)
		{
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set(SITE_CHANGES,'2');
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
			return $result;
		}
	}
		else
			return FALSE;
		
	 }
	 
}
	 
	 function get_info($site_id){
		 
		$key = 'get_info_'.$site_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes=$this->memcached_library->get(EDIT_SITE_CHANGES);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		
			if(!empty($site_id)){
				$this->db->where("site_id",$site_id);
				
				$query = $this->db->get(TAB_PUB_SITES);
				
				$result = $query->result_array();
				
				if($result)
				{			
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$result,$account_type);	
						$this->memcached_library->set(EDIT_SITE_CHANGES,'2');
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $result;
					}
				}
				else
				{
					return FALSE;
				}
			}
		}
	}
	 
	function fetch_appinfo($account_id=FALSE)
	{		
		$key = 'fetch_appinfo_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$check_db_changes = $this->memcached_library->get('manage_site');
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			if($account_id != FALSE){
				$this->db->where('oxa.account_id',$account_id);
			}	
			else
			{
				if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
					$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
				
					$this->db->where_in('oxa.account_id',$pub);
				endif;
			}
			
		$this->db->select('oxa.*,ap.*');
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'ap.account_id = oxa.account_id');
		$this->db->where('ap.is_deleted','0');		
		$this->db->where('ap.status','1');		
		$this->db->order_by('ap.added_date');
		$query 	= 	$this->db->get(TAB_TEMP_URL . ' AS ap');
			
		$result = 	$query->result_array();
					
		if($result)
		{			
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
		}
		else
		{
			return FALSE;
		} 
				 
		}
	}
	  
	 
	 
	function fetch_siteinfo($account_id=FALSE,$site_id=FALSE)
	{		
		$key = 'fetch_siteinfo_'.$account_id."_".$site_id;
		$ret = $this->memcached_library->get($key);
		$check_db_changes = $this->memcached_library->get('manage_site');
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		if($account_id != FALSE){
			$this->db->where('oxa.account_id',$account_id);
		}	
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('oxa.account_id',$pub);
			endif;
		}
			
		$this->db->select('oxa.*,ps.*');
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'ps.account_id = oxa.account_id');
		$this->db->where('ps.is_deleted','0');		
		$this->db->where('ps.verify','1');		
		$this->db->order_by('ps.added_date');
		if($site_id!=FALSE)
		{
			$this->db->where('site_id',$site_id);
		}
		$query 	= 	$this->db->get(TAB_PUB_SITES . ' AS ps');
		
		//return $this->db->last_query();  die("test");  
			
		$result = 	$query->result_array();
					
		if($result)
		{			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		} 
				 
	}	  
}
	 
	function set_assoc_category($site_id,$category){
		 
		if($site_id != FALSE){
			
			$this->db->delete(TAB_SITE_CAT_ASSOC,array('site_id'=>$site_id));
			if(!empty($category)){
				foreach($category as $_id){
					$this->db->insert(TAB_SITE_CAT_ASSOC,array("site_id"=>$site_id,"category_id"=>$_id));
				}
				$this->memcached_library->set(EDIT_SITE_CATEGORY_CHANGES,'1');
				return TRUE;
			}
			else
			{
				$this->memcached_library->set(EDIT_SITE_CATEGORY_CHANGES,'1');
				return FALSE;
			}
		 }
		 else
		 {
			return FALSE;
		 }
	 }
	 
	function remove($id){
		
		$this->db->trans_start();
		 if(is_array($id)){
			 
			$siteObj = array();
			foreach($id as $val){
				$siteObj[]= array('is_deleted'=>'1','site_id'=>$val);
			}
			$this->db->update_batch(TAB_PUB_SITES,$siteObj,'site_id');
			$this->memcached_library->set(SITE_CHANGES,'1');
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				
				$this->db->trans_commit();
			}
			
		 }
		 else if(!empty($id)){
			/*Associated Zones with sites delete*/
			$SQL = 'UPDATE '.TAB_ZONES.' as oxz 
					LEFT JOIN  '.TAB_SITE_ZONE_ASSOC.' as sz ON sz.zone_id=oxz.zoneid 
					SET dj_is_deleted=1 WHERE sz.site_id='.$id.'';
			
			$this->db->query($SQL);
			$this->db->where('site_id',$id); 
			$this->db->update(TAB_PUB_SITES,array('is_deleted'=>'1'));
			$this->memcached_library->set(SITE_CHANGES,'1');
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->trans_commit();
			} 
			
		 }
	 }
	 
	 /**
       * Retreives the categories associated with this site
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
	 
	 function get_site_category_assoc($site_id =FALSE)
	 {
		 
		$key = 'get_site_category_assoc_'.$site_id ;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes=$this->memcached_library->get(EDIT_SITE_CATEGORY_CHANGES);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		
			if($site_id)
			{
				$this->db->select('category_id');
				$query = $this->db->get_where(TAB_SITE_CAT_ASSOC,array('site_id'=>$site_id));
				if($query->num_rows()>0)
				{
					$result = array();
					foreach($query->result_array() as $row)
					{
						array_push($result,$row['category_id']);	
						
					}
					if($mem_cache=='enable' )
					{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(EDIT_SITE_CATEGORY_CHANGES,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
					}
					else{
					return $result;
					}
				 }else{
					return FALSE;	
				 }
			 }else{
				return FALSE; 
			 } 
		 }
	}
	 
	/**
       * Deletes the site and associated categories
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
    function delete($site_id =FALSE)
    {
		if($site_id)
		{
			$this->db->trans_start();
			
			$tables = array(TAB_PUB_SITES,TAB_SITE_CAT_ASSOC);
			
			$this->db->where('site_id',$site_id);
			$this->db->delete($tables);
			
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->trans_commit();
			}
			
		}else{
			return FALSE;	
		}	
	}
	
	/**
       * Updates the Zones and Sites
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
	
	function update_ad_block($adblock=FALSE, $where=FALSE,$agency_id=FALSE)
	{


		$this->db->trans_begin();  
		
		if($where!=FALSE)
		{
			$this->db->where($where);
		}
		
		//print_r($where);  die("renuka");
			
		$this->db->update(TAB_ZONES,$adblock);
		$this->memcached_library->set(PUB_ADBLOCK_CHANGES,'1');
		$this->memcached_library->set(ADBLOCK_CHANGES,'1');
		
		
		if($agency_id!=FALSE)
		{
			//Auto Linking of zones
			$this->do_auto_link->link_ads($where['zoneid'],$agency_id);
			
		}
		
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return FALSE;
		}
		else
		{
			$this->db->trans_commit();
			return $where['zoneid'];
		}
	}
	
	function fetch_adblock_size($account_id=false,$zone_id=false)
	{
		$SQL="select width,height from ".TAB_ZONES." as z where z.zoneid=".$zone_id;
				
		$query = $this->db->query($SQL);
		
		$result = 	$query->result_array();
						
		if($result)
		{		
			return $result;  
		}
		else
		{
			return FALSE;
		}
	}
	
	
	/**
       * Retreives the Zones and Sites
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
	 
	 function fetch_adblocks($account_id=FALSE,$site_id=FALSE,$zone_id=FALSE,$rotator_adblock=FALSE,$ad_type=FALSE,$zone_type=FALSE){
			
		/*$key = FETCH_PUB_ADBLOCK.$account_id.'_'.$site_id.'_'.$zone_id.'_'.$rotator_adblock;		
		$check_db_changes = $this->memcached_library->get(PUB_ADBLOCK_CHANGES);
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_adb_changes = $this->memcached_library->get(ADBLOCK_CHANGES);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' && $check_adb_changes!='1')
		{
			return $ret;
		}
		else{*/
		$type_values=array();
		$ad_type_values=array();
			if($ad_type){
					$i=0;
					foreach($ad_type as $key)
					{					
						$ad_type_values[$i]="'".$key."'";$i++;
						$type_values[$i]="'".$key."'";$i++;
					}
			}
		if($zone_type){
					 
			
			if (in_array("application", $zone_type))
			{
				$type_values[]="'".MOBILE_APP_AD_BLOCK_INTERSTITIAL."'";
				$type_values[]="'".MOBILE_APP_AD_BLOCK_FOOTER."'";
				$type_values[]="'".MOBILE_APP_AD_BLOCK_VIDEO."'";
			}
			if (in_array("display", $zone_type))
			{
				$type_values[]="'".WEB_AD_BLOCK_BANNER."'";
				$type_values[]="'".WEB_AD_BLOCK_DHTML."'";
				$type_values[]="'".WEB_AD_BLOCK_TEXT."'";
				$type_values[]="'".WEB_AD_BLOCK_GOOGLE_TEXT."'";
				$type_values[]="'".WEB_AD_BLOCK_EMAIL_NL."'";			
				$type_values[]="'".WEB_AD_BLOCK_POPUP."'";
				$type_values[]="'".WEB_AD_BLOCK_POPUNDER."'";
				$type_values[]="'".WEB_AD_BLOCK_LAYER."'";
				$type_values[]="'".WEB_AD_BLOCK_INTERSTITIAL."'";
				$type_values[]="'".WEB_AD_BLOCK_GAMEBOX."'";
				$type_values[]="'".WEB_AD_BLOCK_DIRECT."'";
				$type_values[]="'".WEB_AD_BLOCK_BANNERBOX."'";
				$type_values[]="'".WEB_AD_BLOCK_CATFISH."'";
				$type_values[]="'".WEB_AD_BLOCK_SITESKIN."'";
				$type_values[]="'".WEB_AD_BLOCK_TOPBAR."'";
				$type_values[]="'".WEB_AD_BLOCK_NATIVE."'";
				$type_values[]="'".VIDEO_AD_BLOCK_OVERLAY."'";
				$type_values[]="'".VIDEO_AD_BLOCK_INLINE."'";
				$type_values[]="'".VIDEO_AD_BLOCK_REAL."'";
				$type_values[]="'".VIDEO_AD_BLOCK_SMALL."'";
				$type_values[]="'".VIDEO_AD_BLOCK_BOX."'";
				$type_values[]="'".VIDEO_AD_BLOCK_HEAD."'";
				$type_values[]="'".MOBILE_AD_BLOCK_IMAGE."'";
				$type_values[]="'".MOBILE_AD_BLOCK_TEXT."'";
				$type_values[]="'".MOBILE_AD_BLOCK_INTERSTITIAL."'";
				$type_values[]="'".MOBILE_AD_BLOCK_EXPAND."'";
				$type_values[]="'".MOBILE_AD_BLOCK_REVEAL."'";
				$type_values[]="'".MOBILE_AD_BLOCK_FLEX."'";
				$type_values[]="'".MOBILE_AD_BLOCK_ADHENSION."'";
				$type_values[]="'".MOBILE_AD_BLOCK_FLIMSTRIP."'";
				$type_values[]="'".MOBILE_AD_BLOCK_SLIDER."'";
				$type_values[]="'".MOBILE_AD_BLOCK_PULL."'";
				$type_values[]="'".MOBILE_AD_BLOCK_DIALOG."'";
				$type_values[]="'".MOBILE_AD_BLOCK_NOTIFICATION."'";
				$type_values[]="'".WEB_AD_BLOCK_EXIT_POPUNDER."'";				
				
			}		
			}
					 
			 
		$key = FETCH_PUB_ADBLOCK.$account_id;
		if(!empty($site_id))
		{
			$key.='_'.$site_id;
		}
		if(!empty($zone_id))
		{
			$key.='_'.$zone_id;
		}
		if(!empty($rotator_adblock))
		{
			$key.='_'.$rotator_adblock;
		}
		if(!empty($ad_type))
		{
			foreach($ad_type as $akey=>$value)
			{
			$key .=	$akey.'_'.((is_array($value))?implode('_',$value):$value);
		    }			
		}		
		if(!empty($zone_type))
		{
			foreach($zone_type as $zkey=>$value) 
			{
			$key .=	$zkey.'_'.((is_array($value))?implode('_',$value):$value);     
		    }			
		}		
				
		$check_db_changes = $this->memcached_library->get(PUB_ADBLOCK_CHANGES);
				
		$ret = $this->memcached_library->get($key);		
				
		$mem_cache = $this->default_configurations->get('adgate_memcache');
			
		//$check_adb_changes = $this->memcached_library->get(ADBLOCK_CHANGES);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{			
			return $ret;
		}
		else{
							
			$SQL = "SELECT @i := @i -1 AS row_number,a.*
					FROM
					(SELECT oxz.dj_added_date as creation_date,z.url as url,oxa.dj_first_name,oxa.dj_last_name,z.type as ostype,z.name as name,oxz.*,
					CASE
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_BANNER."'  	  THEN 'Banner'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_DHTML."'   	  THEN 'DHtml'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_TEXT."'    	  THEN 'Text'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_GOOGLE_TEXT."'    THEN 'Text'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_EMAIL_NL."' 	  THEN 'Email'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_POPUP."' 	  	  THEN 'Pop-Up'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_POPUNDER."' 	  THEN 'Pop-Under'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_DIRECT."' 	  THEN 'Direct Link'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_LAYER."' 	  	  THEN 'Layer' 
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_INTERSTITIAL."' THEN 'Web Interstitial'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_GAMEBOX."' 	  THEN 'Gamebox'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_BANNERBOX."' 	  THEN 'Bannerbox'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_SLIDER."' 	  THEN 'Slider'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_CATFISH."' 	  THEN 'Catfish'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_SITESKIN."' 	  THEN 'Site-Skin'					
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_TOPBAR."' 	  THEN 'TopBar'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_NATIVE."' 	  THEN 'Native' 
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_OVERLAY."'    THEN 'Video Overlay'
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_INLINE."'     THEN 'Video Inline'	
						
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_REAL."'     THEN 'Video Read'	
						
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_SMALL."'     THEN 'Video Small'	
						
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_BOX."'     THEN 'Video Box'	
						
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_HEAD."'     THEN 'Video Head'		
									
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_IMAGE."'  		THEN 'Image'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_TEXT."' 		THEN 'Text'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_INTERSTITIAL."'THEN 'Interstitial'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_EXPAND."'  	THEN 'Expand'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_REVEAL."'  	THEN 'Reveal'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_FLEX."'  		THEN 'Flex'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_ADHENSION."'  	THEN 'Adhesion'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_FLIMSTRIP."'  	THEN 'Filmstrip'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_SLIDER."'  	THEN 'Slider'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_PULL."'  		THEN 'Pull'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_DIALOG."'  	THEN 'Dialog'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_NOTIFICATION."'  THEN 'Notification'
						WHEN `dj_zone_type` = '".MOBILE_APP_AD_BLOCK_INTERSTITIAL."' THEN 'Interstitial'
						WHEN `dj_zone_type` = '".MOBILE_APP_AD_BLOCK_FOOTER."' THEN 'Footer'
						WHEN `dj_zone_type` = '".MOBILE_APP_AD_BLOCK_VIDEO."' THEN 'HTML5 video'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_EXIT_POPUNDER."' THEN 'Exit Popunder'
					END as ad_type,
					CASE
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_POPUP."' 	  	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_POPUNDER."' 	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_DIRECT."' 	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_LAYER."' 	  	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_INTERSTITIAL."' THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_GAMEBOX."' 	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_BANNERBOX."' 	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_SLIDER."' 	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_CATFISH."' 	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_SITESKIN."' 	  THEN 'Special'
						WHEN `dj_zone_type` = '".WEB_AD_BLOCK_TOPBAR."' 	  THEN 'Special'					
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_OVERLAY."'  THEN 'Video'
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_REAL."'  	THEN 'Video'
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_SMALL."' 	THEN 'Video'
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_BOX."' 		THEN 'Video'
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_HEAD."' 	THEN 'Video'
						WHEN `dj_zone_type` = '".VIDEO_AD_BLOCK_INLINE."' 	THEN 'Video'
						WHEN `dj_mobile_ad_type` = 'mraid'  THEN 'Mobile - MRAID'
						WHEN `dj_mobile_ad_type` = 'rising' THEN 'Mobile - Rising Stars'
						WHEN `dj_mobile_ad_type` = 'basic'  THEN 'Mobile - Basic'
						WHEN `dj_zone_type` = '".MOBILE_APP_AD_BLOCK_INTERSTITIAL."' THEN 'Mobile-App'
						WHEN `dj_zone_type` = '".MOBILE_APP_AD_BLOCK_FOOTER."' THEN 'Mobile-App'
						WHEN `dj_zone_type` = '".MOBILE_APP_AD_BLOCK_VIDEO."' THEN 'Mobile-App'
					ELSE 'Display'
					END as zone_type,
					IFNULL(imp,0) as IMP,
					IFNULL(clk,0) as CLK,
					IFNULL(conv,0) as CONV,
					TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((clk/imp)*100,0),2))) as CTR	,
					TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((Revenue/imp)*1000,0),2))) as ECPM,
					TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(Revenue,0),4))) as Revenue,  
					IFNULL(last_imp_date,0) as imp_date
					FROM 
						".TAB_ZONES." as oxz   
					JOIN	
					(SELECT djszass.site_id as id,site_url as url,site_name as name,0 as type,is_deleted as is_deleted,zone_id as zone_id,djs.account_id as account_id 
                         FROM ".TAB_SITE_ZONE_ASSOC." as djszass 
                         JOIN ".TAB_PUB_SITES." as djs ON djs.site_id=djszass.site_id
					UNION 
					SELECT djsapp.app_id as id,app_url as url,app_name as name,os_type as type,is_deleted as is_deleted,zone_id as zone_id,app.account_id as account_id 
                         FROM ".TAB_APP_ZONE_ASSOC." as djsapp
                        JOIN ".TAB_TEMP_URL." as app ON app.id=djsapp.app_id
                       ) as z ON z.zone_id = oxz.zoneid 
					JOIN 
						".TAB_AFFILIATE." as oxa ON oxa.account_id=z.account_id  
					LEFT JOIN (
						SELECT 
							oxah.zone_id,
							sum(oxah.impressions) as imp,
							sum(oxah.clicks) as clk,
							sum(oxah.conversions) as conv,
							sum(oxah.dj_publisher_earnings)as Revenue,
							date(date_time) as last_imp_date
						FROM
							".TAB_DATA_SUM_AD_HOURLY." as oxah
						JOIN 
							".TAB_ZONES." as tab ON tab.zoneid=oxah.zone_id
						GROUP BY
							tab.zoneid order by date_time desc
							
					) as oxd ON oxd.zone_id=oxz.zoneid					
						
					WHERE 
						 oxz.dj_is_deleted =0 AND oxa.dj_is_deleted =0 AND z.is_deleted=0 ";
		
				if($account_id != FALSE){
					$SQL .= " AND oxa.account_id = {$account_id}";
				}
				
				if($site_id != FALSE){
					$SQL .= " AND z.id = {$site_id}";
				}
			
				if($zone_id !=FALSE)
				{
					$SQL .= " AND zoneid = {$zone_id}";
				}
				if($rotator_adblock!=FALSE)
				{
					$SQL.= " AND rotator_block_status = {$rotator_adblock}";
				}
				else
				{
					$SQL.= " AND rotator_block_status = 0";
				}
			//test sorting.. code  start	
				$in_sel= "select count(*) 
					FROM 
						".TAB_ZONES." as oxz 
					JOIN 
					(SELECT djszass.site_id as id,site_url as url,site_name as name,0 as type,is_deleted as is_deleted,zone_id as zone_id,djs.account_id as account_id 
                         FROM ".TAB_SITE_ZONE_ASSOC." as djszass 
                         JOIN ".TAB_PUB_SITES." as djs ON djs.site_id=djszass.site_id

						UNION 

					SELECT djsapp.app_id as id,app_url as url,app_name as name,os_type as type,is_deleted as is_deleted,zone_id as zone_id,app.account_id as account_id 
                         FROM ".TAB_APP_ZONE_ASSOC." as djsapp
                        JOIN ".TAB_TEMP_URL." as app ON app.id=djsapp.app_id
                       ) as z ON z.zone_id = oxz.zoneid 
         			JOIN 
						".TAB_AFFILIATE." as oxa ON oxa.account_id=z.account_id
					WHERE 
						 oxz.dj_is_deleted =0 AND oxa.dj_is_deleted =0 AND z.is_deleted=0 ";
		
				if($account_id != FALSE){
					$in_sel .= " AND oxa.account_id = {$account_id}";
				}
				if($ad_type!=false && $zone_type != FALSE)
				{ 
					$SQL	.=" AND oxz.dj_zone_type IN (".implode(",",$ad_type_values).")";
				}
				if($ad_type==false && $zone_type != FALSE)
				{ 
					$SQL	.=" AND oxz.dj_zone_type IN (".implode(",",$type_values).")";
				}
				
				if($site_id != FALSE){
					$in_sel .= " AND z.id = {$site_id}";
				}
			
				if($zone_id !=FALSE)
				{
					$in_sel .= " AND zoneid = {$zone_id}";
				}
				if($rotator_adblock!=FALSE)
				{
					$in_sel.= " AND rotator_block_status = {$rotator_adblock}";
				}
				else
				{
					$in_sel.= " AND rotator_block_status = 0";
				}
					
					//test sorting.. code end
			$SQL .= " ORDER BY zoneid DESC) as a,(SELECT @i := ($in_sel) + 1) as rowcount" ;
									
			$query = $this->db->query($SQL);
			//return $this->db->last_query();   
			//return $SQL;  die();  
			
			$result = $query->result_array();
			//echo "<pre>"; print_r($result);exit;	
			//return $set;
			if($result)
			{			
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set(PUB_ADBLOCK_CHANGES,'2');
			$this->memcached_library->set(PUB_ADBLOCK_CHANGES,'1');
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else
			return $result;
			}
			else
			{
				return FALSE;
			}

		}
		
	} 

	function fetch_affiliate_default_exit_popunder($account_id=FALSE)
	{
		$SQL="select default_exit_popunder from ".TAB_AFFILIATE." as a JOIN ".TAB_ZONES." as z ON a.affiliateid = z.affiliateid where a.account_id=".$account_id ." AND default_exit_popunder='1'";
				
		$query = $this->db->query($SQL);
		
		$result = 	$query->result_array();
						
		if($result)
		{		
			return $result[0];  
		}
		else
		{
			return FALSE;
		} 
	}
	
	/* Fetch Affiliate */
	 function fetch_affiliate($account_id=FALSE)
	 { 
		 
		$key = 'fetch_affiliate_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
				
		if($account_id != FALSE){
			$this->db->where('account_id',$account_id);
		}
		
		$this->db->select('affiliateid,floor_price_enable');		
		
		$query 	= 	$this->db->get(TAB_AFFILIATE);
		
		$result = 	$query->result_array();
		
		if($result)
		{	
			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result[0],$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else
			return $result[0];
		}
		else
		{
			return FALSE;
		} 
	 }
	 
	}
	
	
	/* Fetch Affiliate from app  */
	function fetch_affiliate_app($app_id=FALSE)
	{ 		
		
		$key = 'fetch_affiliate_app_'.$app_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		if($app_id != FALSE){
			$this->db->where('au.id',$app_id);
		}				
		$this->db->select('oxa.account_id,oxa.affiliateid,oxa.floor_price_enable,au.os_type');
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'au.account_id = oxa.account_id');
		$this->db->where('au.is_deleted','0');		
		$this->db->order_by('au.added_date');
		$query 	= 	$this->db->get(TAB_TEMP_URL .' AS au');
		
		//echo $this->db->last_query(); die("testing");
			
		$result = 	$query->result_array();
					
		if($result)
		{			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		} 
		}
	}
	
	
	
	 
	/* Fetch Affiliate from site  */
	function fetch_affiliate_site($site_id=FALSE)
	{ 		
		
		$key = 'fetch_affiliate_site_'.$site_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		if($site_id != FALSE){
			$this->db->where('ps.site_id',$site_id);
		}	
			
		$this->db->select('oxa.account_id,oxa.affiliateid,oxa.floor_price_enable');
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'ps.account_id = oxa.account_id');
		$this->db->where('ps.is_deleted','0');		
		$this->db->order_by('ps.added_date');
		$query 	= 	$this->db->get(TAB_PUB_SITES . ' AS ps');
			
		$result = 	$query->result_array();
					
		if($result)
		{			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		} 
	}
}
	 
	/* Fetch Affiliate from site  */
	function fetch_affiliate_zone($zone_id=FALSE)
	{ 	
		
		$key = 'fetch_affiliate_zone_'.$zone_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
				 
		if($zone_id != FALSE){
			$this->db->where('zoneid',$zone_id);
		}		
		$this->db->select('oxz.affiliateid,oxa.account_id');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		$query = $this->db->get(TAB_ZONES.' as oxz');
				
		$result = $query->result_array();
							
		if($result)
		{			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		} 
	}
}
	 
	/**
       * Retreives the Zones and Sites
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
	 
	 function fetch_topbottom_adblocks($account_id=FALSE,$site_id=FALSE,$zone=FALSE){
		 
	    $key = 'fetch_topbottom_adblocks_'.$account_id.'_'.$site_id.'_'.$zone;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		 
		 		
		
		$SQL = "SELECT djs.site_id as site_id, oxz.zoneid, oxz.zonename, oxz.dj_zone_type, oxz.width, oxz.height, oxz.dj_zone_type 
				FROM 
					".TAB_ZONES." as oxz 
				JOIN 
					".TAB_SITE_ZONE_ASSOC." as djszass ON djszass.zone_id=oxz.zoneid
				JOIN 
					".TAB_PUB_SITES." as djs ON djs.site_id=djszass.site_id
				WHERE 
					 dj_is_deleted =0 AND `dj_zone_type` IN ('".WEB_AD_BLOCK_BANNER."','".WEB_AD_BLOCK_DHTML."') ";
	
			if($zone != FALSE && isset($zone['width'])){
				$SQL .= " AND width = ".$zone['width'];
			}
			
			if($zone != FALSE && isset($zone['height'])){
				$SQL .= " AND height = ".$zone['height'];
			}
			
			if($account_id != FALSE){
				$SQL .= " AND djs.account_id = {$account_id}";
			}
			
			if($site_id != FALSE){
				$SQL .= " AND djs.site_id = {$site_id}";
			}
		
		$SQL .= " ORDER BY dj_added_date" ;
		
		$query = $this->db->query($SQL);
		
		$result = $query->result_array();
		//echo "<pre>"; print_r($result);exit;	
		if($result)
		{	
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		}

	}
}


function fetch_tag_parameters_exit($where=FALSE){		
		
		if($where != FALSE){
			$this->db->where($where);
		}
		$this->db->select('dtp.*,oxz.dj_zone_type');
		$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=dtp.tag_id');
		$query = $this->db->get(TAB_TAG_PARAMETERS.' as dtp');		
						
		if($query->num_rows()>0)
		{		
			$result = $query->result_array();						
			return $result;		
		}
		else
		{
			return FALSE;
		}		
	
}
	
	
	/************** Fetch Tag parameters ***************/
	function fetch_tag_parameters($where=FALSE){
		
		$key 	= 	'fetch_tag_parameters';
		
		if($where != FALSE):
			foreach($where as $skey=>$value):
				$key	.=	'_'.$skey.'_'.$value;
			endforeach;
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_SITE_TAG_PARAMETERS);
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			
			return $ret;
		}
		else{
		
		if($where != FALSE){
			$this->db->where($where);
		}
		$this->db->select('dtp.*,oxz.dj_zone_type');
		$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=dtp.tag_id');
		$query = $this->db->get(TAB_TAG_PARAMETERS.' as dtp');		
		
		if($query->num_rows()>0)
		{		
			$result = $query->result_array();			
					
		if($mem_cache=='enable')
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$this->memcached_library->set(FETCH_SITE_TAG_PARAMETERS,'2');
		$set = $this->memcached_library->get($key);	
	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		}		
	}
}
	
	/************** Add Tag parameters ***************/
	function add_tag_parameters($parameters=FALSE){
		
		if($this->db->insert(TAB_TAG_PARAMETERS,$parameters))
		{
			$this->memcached_library->set(FETCH_SITE_TAG_PARAMETERS,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}		
	}
	
	/************** Update Tag parameters ***************/
	function update_tag_parameters($where=FALSE,$parameters=FALSE){
		
		if($where != FALSE){
			$this->db->where($where);
		}
		$this->memcached_library->set(FETCH_SITE_TAG_PARAMETERS,'1');
		if($this->db->update(TAB_TAG_PARAMETERS,$parameters))
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}		
	}
	
	/************** Update Tag parameters ***************/
	function reset_tag_parameters($where=FALSE){
		
		if($where != FALSE){
			$this->db->where($where);
		}
		
		$this->db->delete(TAB_TAG_PARAMETERS);
		
		$this->memcached_library->set(FETCH_SITE_TAG_PARAMETERS,'1');
		
		if($this->db->affected_rows()>0)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}		
	}
	
	function fetch_exit_popunder_zone($aff_id=FALSE,$width=FALSE,$height=FALSE)
	{
		$this->db->select('zoneid,zonename');
		if(!empty($aff_id))
		{
			$this->db->where('affiliateid',$aff_id);
			$this->db->where('dj_zone_type','W_A_EP');
			$this->db->where('width',$width);
			$this->db->where('height',$height);
			$this->db->where('default_exit_popunder','0');
			$this->db->or_where('default_exit_popunder','1');
			$this->db->where('width','0');
			$this->db->where('height','0');	
			$this->db->where('affiliateid',$aff_id);
			$this->db->where('dj_zone_type','W_A_EP');			
			$this->db->or_where('default_exit_popunder','0');
			$this->db->where('width','0');
			$this->db->where('height','0');
			$this->db->where('affiliateid',$aff_id);
			$this->db->where('dj_zone_type','W_A_EP');						
			$this->db->order_by("default_exit_popunder", "DESC");   			
		}
		$query = $this->db->get(TAB_ZONES);			
								
		if($query->num_rows()>0)
		{		
			$result = $query->result_array();			
		    return $result;
		}
		else
		{
		   return FALSE;	
		}  
		
	}
	
	function fetch_siteid($zone_id=FALSE,$account_id=FALSE)
	{	
		
		$this->db->select('ps.site_id,ps.site_url');
		$this->db->join(TAB_SITE_ZONE_ASSOC.' as sz','sz.site_id=ps.site_id');
		$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=sz.zone_id');
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'ps.account_id = oxa.account_id');
		if(!empty($zone_id))
		{
			$this->db->where('sz.zone_id',$zone_id);
		}
		if(!empty($account_id))
		{
			$this->db->where('ps.account_id',$account_id);
		}
		$query = $this->db->get(TAB_PUB_SITES.' as ps');		
								
		if($query->num_rows()>0)
		{		
			$result = $query->result_array();			
		    return $result;
		}
		else
		{
		   return FALSE;	
		}  
		
		
	}
	  
	function fetch_appid($zone_id=FALSE,$account_id=FALSE)
	{	
		
		$this->db->select('ap.id,ap.app_url');
		$this->db->join(TAB_APP_ZONE_ASSOC.' as az','az.app_id=ap.id');
		$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=az.zone_id');
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'ap.account_id = oxa.account_id');
		if(!empty($zone_id))
		{
			$this->db->where('az.zone_id',$zone_id);
		}
		if(!empty($account_id))
		{
			$this->db->where('ap.account_id',$account_id);
		}
		$query = $this->db->get(TAB_TEMP_URL.' as ap');		
								
		if($query->num_rows()>0)
		{		
			$result = $query->result_array();			
		    return $result;
		}
		else
		{
		   return FALSE;	
		}  
		
		
	} 
	  // For news functionality 1*-11-2017 DAC094
	  function fetch_news_data($month=FALSE,$year=FALSE,$news_id=FALSE) 		
	  {
		if($month && $year)
		{
			$date= $year.'-'.$month.'-1';
			$sql= "SELECT sno,date,content,website,heading,logo,is_display FROM `djax_news` WHERE MONTH(date) = MONTH('".$date."')
			AND YEAR(date) = YEAR('".$date."') AND is_display=1";
			$query = $this->db->query($sql);
		}
		elseif($news_id)
		{
			$sql= "SELECT sno,date,content,website,heading,logo,is_display FROM `djax_news` WHERE  sno ='".$news_id."'  AND is_display=1";
			$query = $this->db->query($sql);
		}
		
		else 
		{
			$this->db->select('sno,date,content,website,heading,logo,is_display');
			$this->db->where('is_display',1);
			$query = $this->db->get('djax_news');			
		}
			
		$result = $query->result_array();			
		//return $this->db->last_query();
		return $result;
	  }
	  function fetch_admin_news_data($month=FALSE,$year=FALSE,$news_id=FALSE) 		
	  {
		$this->db->select('sno,date,content,website,heading,logo,is_display');		 
		$query = $this->db->get('djax_news');
		$result = $query->result_array();
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	  }
	  function add_news_data($heading=FALSE,$html_content=FALSE,$image_url=FALSE)
	  {
		  $addObj = array(
							 "heading"=>$heading,
							 "content"=>$html_content,
							 "logo"=>$image_url,
							"date" 	=> date("Y-m-d H:i:s")
						);
						
		if($this->db->insert(TAB_NEWS,$addObj))
		{
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	  }
	  function edit_news_data($heading=FALSE,$html_content=FALSE,$image_url=FALSE,$newsid=FALSE)
	  {
		$editObj = array(
							 "heading"=>$heading,
							 "content"=>$html_content,
							 "logo"=>$image_url,
							 
						); 
		if($editObj)
		{
			$this->db->where('sno',$newsid);
			$update= $this->db->update(TAB_NEWS,$editObj);	
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	  }
	  
	  function news_status_change($news_id=FALSE,$status=FALSE)
	  {
		  if($news_id && $status)
		  { if($status==2)
			{
				$status=0;
			}
		  $editObj = array(
							 "is_display"=>$status,
							); 
		  
			$this->db->where('sno',$news_id);
			$update= $this->db->update(TAB_NEWS,$editObj);	
			return TRUE;
		  }
		  else
		  {
			  return FALSE;
		  }
	  }
	/*  function get_market_camp($market_id=FALSE)
	  {
		
			$this->db->select('rvc.contact,rvc.account_id,count(ba.bannerid) as total_banners,ca.campaignid,ca.campaignname,ca.clientid,ca.dj_is_admarket,ca.admarket_description as description');
			$this->db->join(TAB_BANNERS.' as ba', 'ba.campaignid = ca.campaignid' );
			$this->db->join(TAB_CLIENTS.' as rvc','rvc.clientid=ca.clientid');
			$this->db->where('ca.dj_is_admarket ', 1);
			$this->db->where('ca.status ',0);
			$this->db->where('ca.dj_is_deleted ', 0);
			if($market_id)
			{
				$this->db->where('ca.campaignid', $market_id);
			}
			$this->db->where('ca.clientid != ', 1);
			$this->db->group_by('ca.campaignid');
			$query 	= 	$this->db->get(TAB_CAMPAIGNS.' AS ca');	
			$result = $query->result_array();
			if($result)		return $result;
			else return FALSE;
					
	  }*/
	  
	   function get_market_camp($adv_id=FALSE,$category=FALSE,$country=FALSE,$campid=FALSE,$account_id=false)
	  {
		$this->db->select('rvc.contact,rvc.dj_profile_image,rvc.account_id,count(ba.bannerid) as total_banners,sum(ba.storagetype="txt") AS text_total,sum(ba.storagetype="web") AS banner_total,sum(ba.storagetype="html") AS html_total,date(ca.dj_added_date) as begin_date,ca.campaignid,ca.campaignname,ca.sales,ca.commission,ca.clientid,ca.dj_is_admarket,ca.admarket_description as description,ca.dj_max_retargetting,rva.data as country_flag,adv_app.dj_is_approved,adv_app.dj_request,dsc.category_name');
			$this->db->join(TAB_BANNERS.' as ba', 'ba.campaignid = ca.campaignid' );
			$this->db->join(TAB_CLIENTS.' as rvc','rvc.clientid=ca.clientid');
			if($country){
				$this->db->join(TAB_ACLS.' as rva','rva.campaignid=ca.campaignid and rva.type = "Include:country" AND rva.data LIKE "%'.$country.'%"', 'left');	
			}
			else
			{
				$this->db->join(TAB_ACLS.' as rva','rva.campaignid=ca.campaignid and rva.type = "Include:country"', 'left');	
			}
	
			$this->db->join('djax_admarket_adv_pub_appr'.' as adv_app','adv_app.campaign_id=ca.campaignid and adv_app.dj_request = "1" and adv_app.pub_id = '.$account_id, 'left');
			$this->db->join('djax_site_categories as dsc','dsc.value=ca.dj_category_id', 'left');
			$this->db->where('ca.dj_is_admarket', 1);
			$this->db->where('ca.status',0);
			$this->db->where('ca.dj_is_deleted', 0);
	
			$this->db->where('ba.dj_admin_approve', 1);
			if($category)
			{
				$this->db->where('ca.dj_category_id', $category);
			}
			
			if($campid)
			{
				$this->db->where('ca.campaignid', $campid);
			}
			$this->db->where('ca.clientid != ', 1);
			$this->db->group_by('ca.campaignid');
			$this->db->order_by('ca.campaignid', 'desc');
			$query 	= 	$this->db->get(TAB_CAMPAIGNS.' AS ca ');	
			$result = $query->result_array();
		//	return $this->db->last_query(); 
			if($result)		return $result;
			else return FALSE;
	  }
	  
	  
	  function get_market_camp_country($market_id=FALSE)
	  { 
		if($market_id)
		{ 
		  $this->db->select('data');
		  $this->db->where('campaignid',$market_id);
		  $this->db->like('type','Include:country');
		  $query 	=  $this->db->get(TAB_ACLS);//return $this->db->last_query();
		  $result = $query->result_array();return $result;
		}
		else{ return false;}
	  }
	  function banner_counts($market_id=FALSE)
	  {
		  $this->db->select('count(ba.bannerid) as total_items, ba.dj_banner_type ');
		  $this->db->join(TAB_CAMPAIGNS.' as ca','ca.campaignid=ba.campaignid');
		  //$this->db->join(TAB_CLIENTS.' as rvc','rvc.clientid=ca.clientid');
		  $this->db->where('ca.dj_is_admarket',1);
		  $this->db->where('ba.dj_admin_approve',1);
		  //$this->db->where('rvc.account_id',$market_id);
		  $this->db->where('ca.campaignid',$market_id);
		  $this->db->group_by(' ba.contenttype');
		  $query=$this->db->get( TAB_BANNERS.' as ba' );//return $this->db->last_query();	
		  $result = $query->result_array();return $result;
	  }
	 function get_market_creatives($market_id=FALSE,$type=FALSE,$formats=FALSE,$web_creative_size=FALSE,$account_id=false)
	  {
		if($market_id)
		{
			$this->db->select('ba.bannerid, ba.description, ba.width, ba.height, ba.contenttype, ba.filename, ba.htmltemplate, ba.htmlcache, ba.dj_image_path, ba.backgroundcolor, ba.fontcolor, ba.fontcolor,ba.bannertext,ba.storagetype,ba.url,ba.imageurl,ba.width,ba.height,rvc.dj_profile_image,rvc.contact,cm.campaignid,raza.zone_id,adv_app.dj_is_approved,adv_app.pub_id,rv.dj_is_deleted');
			$this->db->join(TAB_BANNERS.' as ba','ba.campaignid = cm.campaignid');
			$this->db->join(TAB_CLIENTS.' as rvc','rvc.clientid=cm.clientid');
			$this->db->join('djax_admarket_adv_pub_appr'.' as adv_app','adv_app.campaign_id=cm.campaignid and adv_app.dj_is_approved = "1" and adv_app.dj_request = "1" and adv_app.pub_id = '.$account_id , 'left');
			$this->db->join('rv_ad_zone_assoc'.' as raza','raza.ad_id=ba.bannerid','left');
			$this->db->join('rv_zones'.' as rv','rv.zoneid=raza.zone_id and rv.dj_is_deleted !="1"','left');
			//$this->db->order_by('rv.zoneid',"asc");
			//~ if($adv_id)
			//~ {
				//~ $this->db->join(TAB_CLIENTS.' as cl' ,'cl.clientid=cm.clientid');
				//~ $this->db->where('cl.account_id',$adv_id);	
			//~ }
			$this->db->where('cm.dj_is_admarket',"1");
			$this->db->where('cm.campaignid',$market_id);
			$this->db->where('ba.dj_admin_approve',1);
			if($type)	
			{
				if($formats=='txt' || $formats=='web' || $formats=='html')
				{
				$this->db->where('ba.storagetype',$formats);	
				}
				else if($type!='adv_material')
				{
				$this->db->where('ba.storagetype',$type);
				}	
			}
			//return $formats;
			//~ if($formats!='all')
			//~ {
			//~ $this->db->where('ba.storagetype',$formats);	
			//~ }
			//~ 
			if($web_creative_size)
			{
				$banner_size = explode("x",$web_creative_size);
				
				 $width  = $banner_size[0]; 
			   	 $height = $banner_size[1]; 
				
				$this->db->where(array('ba.width' => $width, 'ba.height' => $height));
			}	
			$this->db->group_by('ba.bannerid');
			$query = $this->db->get(TAB_CAMPAIGNS.' as cm');
			$result = $query->result_array();
		//	return $this->db->last_query();	
		}
		    
		
		if($result){
			return $result;			
		}
		else
		{
			return false;			
		}
	  }
	  
	  function get_market_pub_earning($campid=false,$from_date=false,$to_date=false,$one_month=false)
	{	
		$this->db->select('dsh.date_time,sum(dsh.dj_total_revenue) as total,ban.campaignid');
		$this->db->join('rv_banners'.' as ban','ban.campaignid=cm.campaignid','left');
		$this->db->join('rv_data_summary_ad_hourly'.' as dsh','dsh.ad_id=ban.bannerid','left');
		$this->db->where('cm.campaignid', $campid);
		if(!empty($from_date))
		{
		$this->db->where('dsh.date_time >=', $from_date);
		$this->db->where('dsh.date_time <=', $to_date);
		}
		if(!empty($one_month))
		{
		$this->db->where('dsh.date_time >=', $one_month);
		$this->db->where('dsh.date_time <=', $to_date);
		}
		$this->db->group_by('cm.campaignid');
		$query 	= 	$this->db->get('rv_campaigns'.' AS cm');	
		$result = $query->result_array();
		//return $this->db->last_query(); 
		if($result)		return $result;
			else return FALSE;
	}
	  function fetch_pub_detail($aff_id=FALSE)
	  {
		  
		 $SQL ="select date(dj_added_date) as added_date FROM ".TAB_AFFILIATE." where affiliateid=".$aff_id;
		 
		 $query = $this->db->query($SQL);		
		
		 $result = $query->result_array();
		 
		 if($result)
		 {
			return $result; 
		 }
		 else
		 {
			 return FALSE;
		 }
	  }
	  
	  function fetch_daily_statistics($date,$account_id=FALSE)
	  { 

		$SQL = "SELECT sum(oxah.impressions)as imp,sum(oxah.clicks)as clk,sum(oxah.conversions)as conv,sum(oxah.dj_publisher_earnings) as revenue,TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((sum(oxah.dj_publisher_earnings)/sum(oxah.impressions))*1000,0),2))) as ECPM FROM ".TAB_DATA_SUM_AD_HOURLY." as oxah join ".TAB_ZONES." as z on z.zoneid=oxah.zone_id JOIN ".TAB_AFFILIATE." as a ON a.affiliateid=z.affiliateid WHERE a.account_id='".$account_id."' AND date(oxah.date_time)='".$date."'";
		
		$query = $this->db->query($SQL);
								
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();    
			 
			return $result;  
			 				
		}
		else
		{
			return FALSE;	
		}
		
	  }
	  
	  function total_balance($account_id=FALSE)
	  {
		 
		$SQL = "SELECT sum(oxah.dj_publisher_earnings) as revenue FROM ".TAB_DATA_SUM_AD_HOURLY." as oxah join ".TAB_ZONES." as z on z.zoneid=oxah.zone_id JOIN ".TAB_AFFILIATE." as a ON a.affiliateid=z.affiliateid WHERE a.account_id='".$account_id."'";
		
		$query = $this->db->query($SQL);
								
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();    
			 
			return $result;  
			 				
		}
		else
		{
			return FALSE;	
		}
 
	 }
	  function admarket_new_list($campid = false)
	  {
		 
		$this->db->select('dan.campaign_id,dan.dj_subject,dan.dj_content,dan.date');
		$this->db->where('dan.campaign_id', $campid);
		$query 	= 	$this->db->get('djax_admarket_news'.' AS dan');	
		$result = $query->result_array();
		if($result)		return $result;
			else return FALSE;
	  }
}
