<?php
Class Do_report extends CI_Model
{	 
	function fetch_top_sources($account_id=FALSE)
	{
		$key = 'fetch_top_traffic_source_'.$account_id;
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($vet && $mem_cache=='enable' )
		{
			return $vet;
		}
		else
		{		
		$sql = "SELECT z.affiliateid as id,aff.name as name,sum(h.dj_publisher_earnings) as pub_revenue,ROUND(IFNULL(((SUM(h.clicks)/SUM(h.impressions))*100),0),2) as ctr,h.impressions,h.clicks,ROUND(IFNULL(((SUM(h.total_revenue)/SUM(h.impressions))*1000),0),2) as ecpm FROM ".TAB_AFFILIATE." as aff JOIN ".TAB_ZONES." as z ON z.affiliateid=aff.affiliateid JOIN ".TAB_DATA_SUM_AD_HOURLY." as h ON h.zone_id = z.zoneid JOIN ".TAB_BANNERS." as ban ON ban.bannerid=h.ad_id JOIN ".TAB_CAMPAIGNS." as cam ON cam.campaignid=ban.campaignid JOIN ".TAB_CLIENTS." as c ON cam.clientid=c.clientid where c.account_id='".$account_id."' group by z.affiliateid";    
						
		$query = $this->db->query($sql);
		
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$det = $this->memcached_library->get($key);	
			return $det;
			}
			else
			{
			return $result;
			}				
		}
		else
		{
			return FALSE;	
		}	
		
		}
		
	}
	
	function fetch_top_zones($account_id=FALSE)
	{
		$key = 'fetch_top_zone_'.$account_id;
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
				
		if($vet && $mem_cache=='enable' )
		{ 
			return $vet;
		}
		else
		{		
		$sql = "SELECT aff.name as name,z.zoneid as id,z.zonename as zone_name,sum(h.dj_publisher_earnings) as pub_revenue,h.impressions,h.clicks,ROUND(IFNULL(((SUM(h.clicks)/SUM(h.impressions))*100),0),2) as ctr,ROUND(IFNULL(((SUM(h.total_revenue)/SUM(h.impressions))*1000),0),2) as ecpm FROM ".TAB_AFFILIATE." as aff JOIN ".TAB_ZONES." as z ON z.affiliateid=aff.affiliateid JOIN ".TAB_DATA_SUM_AD_HOURLY." as h ON h.zone_id = z.zoneid JOIN ".TAB_BANNERS." as ban ON ban.bannerid=h.ad_id JOIN ".TAB_CAMPAIGNS." as cam ON cam.campaignid=ban.campaignid JOIN ".TAB_CLIENTS." as c ON cam.clientid=c.clientid where c.account_id='".$account_id."' group by z.zoneid"; 
	    								 
		$query = $this->db->query($sql);
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$det = $this->memcached_library->get($key);	
			return $det;
			}
			else
			{
			return $result;
			}				
		}
		else
		{
			return FALSE;	
		}	
		
		}
		
	}
	 
	 function fetch_top_geos($account_id=FALSE)
	{
		$key = 'fetch_top_geos_'.$account_id;
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
				
		if($vet && $mem_cache=='enable' )
		{ 
			return $vet;
		}
		else
		{		
		$sql = "SELECT bid.country_value as country_name,bid.bidding_value as bidding_value h.impressions as imp,h.clicks as clk,ROUND(IFNULL(SUM(h.total_revenue),0),4))) as spend,ROUND(IFNULL(((SUM(h.clicks)/SUM(h.impressions))*100),0),2))) as ctr,ROUND(IFNULL(((SUM(h.total_revenue)/SUM(h.impressions))*1000),0),2))) END as ecpm FROM ".TAB_AFFILIATE." as aff JOIN ".TAB_ZONES." as z ON z.affiliateid=aff.affiliateid JOIN ".TAB_DATA_SUM_AD_HOURLY." as h ON h.zone_id = z.zoneid JOIN ".TAB_BANNERS." as ban ON ban.bannerid=h.ad_id JOIN ".TAB_CAMPAIGNS." as cam ON cam.campaignid=ban.campaignid JOIN ".TAB_CLIENTS." as c ON cam.clientid=c.clientid JOIN ".TAB_COUN_BID." as bid ON bid.account_id=c.account_id where c.account_id='".$account_id."'  group by bid.country_value"; 
	    								 
		$query = $this->db->query($sql);
						
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$det = $this->memcached_library->get($key);	
			return $det;
			}
			else
			{
			return $result;
			}				
		}
		else
		{
			return FALSE;	
		}	
		
		}
		
	}
		 
	 function fetch($columns,$search,$group,$order,$limit,$dataTable=FALSE,$display=FALSE,$campaign_id=false)
	 {		
			 	
		$key = 	'fetch_report_data_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'];


		
		if($dataTable!=FALSE)
		{
			$key.='_'.$dataTable;
		}
		if($display!=FALSE)
		{
			$key.='_'.$display;
		}			
				
		$ret = $this->memcached_library->get($key);
						
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{			
			if(is_array($group) AND in_array('DATE',$group)){
				if(isset($search['timezone']) AND $search ['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%b-%d-%Y')";
				}
				else
				{//'%d-%m-%Y'  %b-%d-%Y
					$date_field = "DATE_FORMAT(oxah.date_time,'%b-%d')";
				}
			}
			else if(is_array($group) AND in_array('TIME',$group))
			{
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "TIME(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'))";
				}
				else
				{
					$date_field = "TIME(oxah.date_time)";
				}	
			}
			else if(is_array($group) AND in_array('MONTH',$group)){
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%b %Y')";
				}
				else
				{
					$date_field = "DATE_FORMAT(oxah.date_time,'%b %Y')";
				}			
			}
			else
			{
				$date_field = "DATE_FORMAT(oxah.date_time,'%d-%m-%Y')";
			}
			
			/*
				DATE
				IMP
				CLK
				UIMP // !Publisher
				UCLK // !Publisher
				CON
				SPEND // !Publisher
				PUB_EARN // ! Advertiser
				ADM_EARN // ! Advertiser & !Publisher
				CTR // !Publisher
				ECPM // !Publisher
				PUB_ECPM // !advertiser
				CAM_ID
				CAM_NAME
				BAN_ID
				BAN_NAME
				ACC_ID
				SITE_ID
				ZONE_ID
				
			*/
			
			$SQL = "SELECT SQL_CALC_FOUND_ROWS null as rows,r.* FROM (SELECT ";
			
			if(empty($display))
			{
			$SQL .= " dcts.traffic_id as TRAFFIC, oxah.browser_name  as BROWSER_NAMES,oxah.browser_language as BROWSER_LANGS,oxz.zonename as ZONE_NAMES,oxah.date_time as TIME_DATE, ";
			}
			 if($search['page'] === 'REPORT_DASHBOARD')
			 {
				 
				$SQL .= " (oxaff.account_id) as AFF_ACC_ID, (oxaff.name) as AFF_ACC_NAME,(dtc.name) as HR_COUNTRY,";
												
			}						
			//return $SQL; die();  
		// print_r($columns);die();
			if(is_array($columns) AND count($columns) > 0){
				foreach($columns as $val){
					
					switch(strtoupper($val)){
						case 'DATE';
							$SQL .= " {$date_field} as ".$val.',';
							break;
						case 'TIME_DATE';
							$SQL .= " oxah.date_time as TIME_DATES, ";
							break;
						case 'IMP';
							$SQL .= " IFNULL(SUM(oxah.impressions),0) as ".$val.',';
							break;
					//DAC107
						case 'REQUEST';
							if($dataTable==TRUE):
								$SQL .= " IFNULL(SUM(oxah.requests),0) as ".$val.',';
							else:
								$SQL .= " SUM(oxah.requests) as ".$val.',';
							endif;
							
							break;	
					
						case 'CLK';
							$SQL .= " IFNULL(SUM(oxah.clicks),0) as ".$val.',';
							break;
						case 'UIMP';
							//if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .=" IFNULL(SUM(oxah.dj_unique_impressions),0) as ".$val.",";	
							//}
							break;
						case 'UCLK';
							//if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .=" IFNULL(SUM(oxah.dj_unique_clicks),0) as ".$val.",";	
							//}
							break;	
						case 'CON';
							$SQL .= " IFNULL(SUM(oxah.conversions),0) as ".$val.',';
							break;
						case 'SPEND';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(oxah.dj_total_revenue),0),4))) as ".$val.',';							
							}
							break;
						case 'PUB_EARN';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(oxah.dj_publisher_earnings),0),4))) as ".$val.',';
							}
							break;	
						case 'ADM_EARN';
							if($search['account_type'] === 'ADMIN'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((SUM(oxah.dj_total_revenue) - SUM(oxah.dj_publisher_earnings)),0),4))) as ".$val.',';
							}
							break;		
						case 'CTR';
							//if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.clicks)/SUM(oxah.impressions))*100),0),2))) as ".$val.',';
							//}
							break;	
						case 'ECPM';
							if($search['account_type'] == 'ADVERTISER'){
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000),0),2))) END as ".$val.',';
							}
							else{
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0),2))) END as ".$val.',';
							}
							break;
						case 'PUB_ECPM';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0),2))) END as ".$val.',';
							}
							break;
					
						case 'HOUR';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%d-%m-%Y') as DATE , ";
								}
								$SQL .= " TIME(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."')) as ".$val.',';
							}
							else
							{
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(oxah.date_time,'%d-%m-%Y') as DATE ,";
								}
								$SQL .= " TIME(oxah.date_time) as ".$val.',';
							}						
							break;
						case 'MONTH';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{
								$SQL .= " DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%b %Y') as ".$val.',';
							}
							else
							{
								$SQL .= " DATE_FORMAT(oxah.date_time,'%b %Y') as ".$val.',';
							}
							break;
						case 'YEAR';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{
								$SQL .= " DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%Y') as ".$val.',';
							}
							else
							{
								$SQL .= " DATE_FORMAT(oxah.date_time,'%Y') as ".$val.',';
							}
							break;	
						case 'ERPM';
							if($dataTable==TRUE):
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000),0),2))) END as ".$val.',';
							else:
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000))) END as ".$val.',';
							endif;						
							break;
						case 'EPPM';
							if($dataTable==TRUE):
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((((SUM(oxah.dj_total_revenue) - SUM(oxah.dj_publisher_earnings))/SUM(oxah.impressions))*1000),0),2))) END as ".$val.',';
							else:
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM (((SUM(oxah.dj_total_revenue) - SUM(oxah.dj_publisher_earnings))/SUM(oxah.impressions))*1000))) END as ".$val.',';
							endif;
							
							break;
						
						case 'FILL_RATE';
							$SQL .= " CASE WHEN SUM(oxah.requests)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.impressions)/SUM(oxah.requests))*100),0),2))) END as ".$val.',';
							break;
						case 'RTYPE';
							$SQL .= " (dcrt.revenue_type) as ".$val.',';
							$SQL .= " (oxc.revenue_type) as revenue_type,";
							break;
						case 'ADSIZE';
							if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
							}
							else
							{
								if($page==='REPORT_PUBLISHER')
								{
									$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
								}
								else
								{
									$SQL .= " CONCAT(oxb.width, 'x', oxb.height) as ".$val.',';
								}							
							}
							break;	
					//DAC107
						case 'ACC_ID';
							if($search['account_type'] === 'ADVERTISER'){
								$SQL .= " (oxcl.account_id) as ".$val.',';
								$SQL .= " (oxcl.clientname) as ACC_NAME,";
							}
							else if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= " (oxaff.account_id) as ".$val.',';
								$SQL .= " (oxaff.name) as ACC_NAME,";
							}
							else if($search['account_type'] === 'ADMIN'){
								
								if($search['page']==='REPORT_ADVERTISER'){
									$SQL .= " (oxcl.account_id) as ".$val.',';
									$SQL .= " (oxcl.clientname) as ACC_NAME,";
									$SQL .= " (oxcl.dj_is_deleted) as DEL_STATUS,";
									#$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxcl.account_id ) as ACTIVE_STATUS,";
									
								}
								else if($search['page']==='REPORT_PUBLISHER')
								{
									$SQL .= " (oxaff.account_id) as ".$val.',';
									$SQL .= " (oxaff.name) as ACC_NAME,";
								}

							}
							break;		
						case 'ADV_ID';
							$SQL .= " (oxcl.account_id) as ".$val.',';
							$SQL .= " (oxcl.clientname) as CLIENT_NAME,";
							$SQL .= " (oxcl.dj_is_deleted) as ADV_DEL_STATUS,";
							//$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxcl.account_id ) as ADV_ACTIVE_STATUS,";
							break;
						case 'AFF_ID';
							$SQL .= " (oxaff.account_id) as ".$val.',';
							$SQL .= " (oxaff.name) as AFF_NAME,";
							$SQL .= " (oxaff.dj_is_deleted) as PUB_DEL_STATUS,";
							//$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxaff.account_id ) as PUB_ACTIVE_STATUS,";
							break;
						
						case 'CAM_ID';
							$SQL .= " (oxc.campaignid) as ".$val.',';
							$SQL .= " (oxc.campaignname) as CAM_NAME,";
							//$SQL .= " (oxcl.clientname) as ACC_NAME,";
							//$SQL .= " (oxz.zonename) as ZONE_NAME,";
							break;
						case 'BAN_ID';
							$SQL .= " (oxb.bannerid) as ".$val.',';
							$SQL .= " (oxb.storagetype) as ST_TYPE,";
							$SQL .= " (oxb.dj_banner_type) as BAN_TYPE,";
							$SQL .= " (oxb.description) as BAN_NAME,";
							//$SQL .= " (oxcl.clientname) as ACC_NAME,";
							//$SQL .= " (oxz.zonename) as ZONE_NAME,";
							
							break;		
						case 'SITE_ID';
							$SQL .= " (sa.id) as ".$val.',';
							$SQL .= " (sa.site_name) as SITE_NAME,";
							$SQL .= " (sa.site_url) as SITE_URL,";
							//$SQL .= " (oxaff.name) as ACC_NAME,";
							break;
						case 'APP_ID';
							$SQL .= " (sa.id) as ".$val.',';
							$SQL .= " (sa.site_name) as APP_NAME,";
							$SQL .= " (sa.site_url) as APP_URL,";
							//$SQL .= " (oxaff.name) as ACC_NAME,";
							break;	
						case 'ZONE_ID';
							$SQL .= " (oxz.zoneid) as ".$val.',';
							$SQL .= " (oxz.zonename) as ZONE_NAME,";
							//$SQL .= " (oxaff.name) as ACC_NAME,";
							break;	
						case 'SITE_URL';
							//$SQL .= " IFNULL(djs.site_url,'Nil') as ".$val.',';
							break;
						case 'SITE_REFERRER';
							//$SQL .= " IFNULL(djs.site_referrer_url,'Nil') as ".$val.',';
							break;
						case 'DOMAIN';
							//$SQL .= " IFNULL(djs.domain,'Nil') as ".$val.',';
							break;	
						case 'COUNTRY';
							//$SQL .= " (oxah.country) as ".$val.",";
							
							$SQL .= " (dtc.name) as ".$val.",";
							$SQL .= " (oxah.country_code) as country_code,";
							break;
						/*case 'USER_AGENT';
								$SQL .= " (dbs.user_agent) as ".$val.",";
							break;

						case 'BROWSER';
								$SQL .= " (dbs.browser_name) as ".$val.",";
							break;
						case 'OS';
								$SQL .= " (dcs.os) as ".$val.",";
							break;
						case 'REFERRER_URL';
								$SQL .= " (dss.site_referrer_url) as ".$val.",";
							break;
						case 'DOMAIN';
								$SQL .= " (dss.domain) as ".$val.",";
							break;*/


						case 'ENV';
								$SQL .= " (oxah.dj_delivery_media_type) as ".$val.",";
							break;						
					}
				}
				
				$SQL .= " DATE(oxah.date_time) as date_time,IFNULL(SUM(oxah.impressions),0) as impr,IFNULL(SUM(oxah.clicks),0) as click,IFNULL(SUM(oxah.conversions),0) as conv,IFNULL(SUM(oxah.requests),0) as req ";	
					
				//REMOVE comma at End of the string
			
				$SQL = rtrim($SQL, ",");
				
				$SQL .= " FROM rv_data_summary_ad_hourly as oxah";
												
				if(is_array($search) AND count($search) > 0 AND array_key_exists('account_id',$search) AND $search['account_id'] != ''){
				/*$SQL .= " LEFT JOIN (SELECT dgs.ad_id,dgs.browser_name,dgs.browser_language,dgs.country,dgs.country_code FROM djax_geographical_stats as dgs WHERE dgs.browser_name IS NOT NULL GROUP BY dgs.ad_id) as temm ON temm.ad_id=oxah.ad_id ";*/
					/*$SQL .= " LEFT JOIN djax_geographical_stats as dgs ON ( dgs.ad_id=oxah.ad_id AND dgs.zone_id=oxah.zone_id AND dgs.date_time=oxah.date_time )";
					$SQL .= " LEFT JOIN	djax_sites_stats as djs ON ( djs.ad_id=oxah.ad_id AND djs.zone_id=oxah.zone_id AND djs.date_time=oxah.date_time )";*/
					
					if($search['account_type'] === "TRAFFICKER"){
					
						/*$SQL .= " LEFT JOIN djax_browsers_stats as dbs ON ( dbs.ad_id=oxah.ad_id AND dbs.zone_id=oxah.zone_id AND dbs.date_time=oxah.date_time )";
						$SQL .=" LEFT JOIN djax_clients_stats as dcs ON ( dcs.ad_id=oxah.ad_id AND dcs.zone_id=oxah.zone_id AND dcs.date_time=oxah.date_time )";
						$SQL .="LEFT JOIN djax_sites_stats as dss ON ( dss.ad_id=oxah.ad_id AND dss.zone_id=oxah.zone_id AND dss.date_time=oxah.date_time ) ";*/
					}
					
					if($search['account_type'] === "ADVERTISER"){
					
						if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
							$creativeid	=	implode(',',$search['creative_id']);
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$creativeid.") )";
							
							//$SQL .= "  JOIN djax_geographical_stats as dgs ON (oxb.bannerid=dgs.ad_id)";
						}
						else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid='".$search['creative_id']."')";
						}
						else
						{
							$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id";
						}
						
						if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
							if(in_array('custom',$search['adsize']))
							{
								$si	=	array();
								foreach($search['adsize'] as $siz):
									if($siz!='custom')
									{
										$si[]	=	$siz;
									}
								endforeach;
								if(!empty($si)):	
									$size	=	implode("','",$si);												
									$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
								endif;
							}
							else
							{
								$size	=	implode("','",$search['adsize']);												
								$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
							}
						}
						else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
							$size	=	explode('x',$search['adsize']);
							$SQL .= " AND oxb.width=".$size[0]." AND oxb.height=".$size[1]." ";
						}			
						
						if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
							$campid	=	implode(',',$search['campaign_id']);
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
						}
						else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
						}
						else
						{
						$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid ";
							
							
						}
						$SQL .= " LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=oxc.campaignid 
								  LEFT JOIN djax_targ_country as dtc ON dtc.value=oxah.country_code ";
						
					
						
						
						if(isset($search['revenue_type']) AND $search['revenue_type']!='' AND is_array($search['revenue_type'])){
							$camp_type	=	implode(',',$search['revenue_type']);
							$SQL .= " AND oxc.revenue_type IN (".$camp_type.") ";
						}
						else if(isset($search['revenue_type']) AND $search['revenue_type'] != '' AND !is_array($search['revenue_type'])){
							$SQL .= " AND oxc.revenue_type='".$search['revenue_type']." ";
						}
						
						$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
										
						$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['account_id'].")";
						//// GET STATISTICS VALUES FOR AN ADVERTISER
						
						// LINK TRAFFICKER RELATED TABLES
							if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
								$adblockid	=	implode(',',$search['adblock_id']);
								$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$adblockid.") )";
							}
							else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
								$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
							}
							else
							{
								$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id";
							}
						
							
							$SQL .= " JOIN ( SELECT 
											dsza.zone_id,
											oxps.site_id as id,
											oxps.account_id,
											oxps.site_name as site_name,
											oxps.site_url as site_url
										FROM 
											djax_publisher_sites as oxps
										JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
										
										WHERE 1 ";
										if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
											$siteid	=	implode(',',$search['site_id']);
											$SQL .= " AND oxps.site_id IN (".$siteid.") ";
										}
										else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
											$SQL .= " AND oxps.site_id='".$search['site_id']."' ";
										}
										
							$SQL .= " UNION
										
										SELECT 
											daza.zone_id,
											daza.app_id as id,
											dtu.account_id,
											dtu.app_name as site_name,
											dtu.app_url as site_url
										FROM 
											djax_temp_url as dtu
										JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
										WHERE 1 ";
										if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
											$appid	=	implode(',',$search['app_id']);
											$SQL .= " AND dtu.id IN (".$appid.") ";
										}
										else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
											$SQL .= " AND dtu.id='".$search['app_id']."' ";
										}
										
							$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";
					
							if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
								$pubid	=	implode(',',$search['pub_account_id']);
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id IN (".$pubid.") )";
							
							}
							else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id=".$search['pub_account_id'].")";
							
							}else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
								$SQL .= " JOIN rv_affiliates as oxaff ON (oxaff.account_id=sa.account_id AND oxaff.agencyid=".$search['agency_id'].")";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
									$SQL	.=" AND oxaff.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}else{
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id)";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
									$SQL	.=" AND oxaff.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}						
					}
					else if($search['account_type'] === "TRAFFICKER"){
						
						if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
							$creativeid	=	implode(',',$search['creative_id']);
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$creativeid.") )";
						}
						else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid='".$search['creative_id']."')";
						}
						else
						{
							$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id";
						}
						
						if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
							$campid	=	implode(',',$search['campaign_id']);
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
						}
						else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
							
						}	
						$SQL .= " LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=oxc.campaignid 
						          LEFT JOIN djax_targ_country as dtc ON dtc.value=oxah.country_code";
						//// GET STATISTICS VALUES FOR AN TRAFFICKER
						if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
							$adblockid	=	implode(',',$search['adblock_id']);
							$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$adblockid.") )";
						}
						else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
							$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id";
						}
						//DAC107
						if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
							if(in_array('custom',$search['adsize']))
							{
								$si	=	array();
								foreach($search['adsize'] as $siz):
									if($siz!='custom')
									{
										$si[]	=	$siz;
									}
								endforeach;
								if(!empty($si)):	
									$size	=	implode("','",$si);												
									$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) NOT IN ('".$size."') ";
								endif;
							}
							else
							{
								$size	=	implode("','",$search['adsize']);												
								$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) IN ('".$size."') ";
							}
						}
						
						else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
							$size	=	explode('x',$search['adsize']);
							$SQL .= " AND oxz.width=".$size[0]." AND oxz.height=".$size[1]." ";
						}
						if($search['report_type'] == 'site')
						{
						$SQL .= " JOIN ( SELECT 
										dsza.zone_id,
										oxps.site_id as id,
										oxps.account_id,
										oxps.site_name as site_name,
										oxps.site_url as site_url
									FROM 
										djax_publisher_sites as oxps
									JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
									
									WHERE 1 ";
									if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
										$siteid	=	implode(',',$search['site_id']);
										$SQL .= " AND oxps.site_id IN (".$siteid.") ";
									}
									else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
										$SQL .= " AND oxps.site_id='".$search['site_id']."' ";
									}
									$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";
						}
						//$SQL .= " UNION";
						if($search['report_type'] == 'app')
						{		
						$SQL .= " JOIN (
									
									SELECT 
										daza.zone_id,
										daza.app_id as id,
										dtu.account_id,
										dtu.app_name as site_name,
										dtu.app_url as site_url
									FROM 
										djax_temp_url as dtu
									JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
									WHERE 1 ";
									if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
										$appid	=	implode(',',$search['app_id']);
										$SQL .= " AND dtu.id IN (".$appid.") ";
									}
									else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
										$SQL .= " AND dtu.id='".$search['app_id']."' ";
									}
									$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";
						}
						
						if($search['report_type'] == 'adblock' || $search['report_type'] == 'overview' ||  $search['report_type'] == 'dash' ||  $search['report_type'] == '')
						{
						$SQL .= " JOIN ( SELECT 
										dsza.zone_id,
										oxps.site_id as id,
										oxps.account_id,
										oxps.site_name as site_name,
										oxps.site_url as site_url
									FROM 
										djax_publisher_sites as oxps
									JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
									
									WHERE 1 ";
									if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
										$siteid	=	implode(',',$search['site_id']);
										$SQL .= " AND oxps.site_id IN (".$siteid.") ";
									}
									else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
										$SQL .= " AND oxps.site_id='".$search['site_id']."' ";
									}
		
						$SQL .= " UNION
									
									SELECT 
										daza.zone_id,
										daza.app_id as id,
										dtu.account_id,
										dtu.app_name as site_name,
										dtu.app_url as site_url
									FROM 
										djax_temp_url as dtu
									JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
									WHERE 1 ";
									if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
										$appid	=	implode(',',$search['app_id']);
										$SQL .= " AND dtu.id IN (".$appid.") ";
									}
									else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
										$SQL .= " AND dtu.id='".$search['app_id']."' ";
									}
									$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";							
						}
						
						
						/*if(!empty($search['site_id']))
						{
							$SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
							if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
								$siteid	=	implode(',',$search['site_id']);
								$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id IN (".$siteid.") )";
							}
							else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
								$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='".$search['site_id']."')";
							}
							else
							{
								$SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
							}
						}
						if(!empty($search['app_id']))
						{
							$SQL .= " JOIN djax_app_zone_assoc as daza ON daza.zone_id=oxz.zoneid";
							if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
								$appid	=	implode(',',$search['app_id']);
								$SQL .= " JOIN djax_temp_url as oxps ON (oxps.id=daza.app_id AND oxps.id IN (".$appid.") )";
							}
							else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
								$SQL .= " JOIN djax_temp_url as oxps ON (oxps.id=daza.app_id AND oxps.id='".$search['app_id']."')";
							}
							else
							{
								$SQL .= " JOIN djax_temp_url as oxps ON oxps.id=daza.app_id";
							}
						}*/			
						
						/*if($search['page'] == 'REPORT_DASHBOARD')
						{											
						$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=".$search['account_id'].")";
						}
						else if($search['report_type'] == 'site' || $search['report_type'] == 'app' || $search['report_type'] == 'adblock' || $search['report_type'] == 'overview')
						{*/
						$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id AND oxaff.account_id=".$search['account_id'].")";								
						/*}
						else
						{
						$SQL .= " JOIN rv_affiliates as oxaff ON (  oxaff.account_id=".$search['account_id'].")";							
						}*/
						
						
				  }
				  else if($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER"){
				  
						// LINK ADVERTISER RELATED TABLES
						if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
								$creativeid	=	implode(',',$search['creative_id']);
								$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$creativeid.") )";
							}
							else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
								$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid='".$search['creative_id']."')";
							}
							else
							{
								$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id";
							}
							
							if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
								
								if(in_array('custom',$search['adsize']))
								{
									$si	=	array();
									foreach($search['adsize'] as $siz):
										if($siz!='custom')
										{
											$si[]	=	$siz;
										}
									endforeach;
									if(!empty($si)):	
										$size	=	implode("','",$si);												
										$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
									endif;
								}
								else
								{
									$size	=	implode("','",$search['adsize']);												
									$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
								}
							}
							else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
								$size	=	explode('x',$search['adsize']);
								$SQL .= " AND oxb.width=".$size[0]." AND oxb.height=".$size[1]." ";
							}			
							
							if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
								$campid	=	implode(',',$search['campaign_id']);
								$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
							}
							else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
								$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
							}
							else
							{
								$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
								
							}
							$SQL .= " LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=oxc.campaignid 
									  LEFT JOIN djax_targ_country as dtc ON dtc.value=oxah.country_code ";
							if(isset($search['revenue_type']) AND $search['revenue_type']!='' AND is_array($search['revenue_type'])){
								$camp_type	=	implode(',',$search['revenue_type']);
								$SQL .= " AND oxc.revenue_type IN (".$camp_type.") ";
							}
							else if(isset($search['revenue_type']) AND $search['revenue_type'] != '' AND !is_array($search['revenue_type'])){
								$SQL .= " AND oxc.revenue_type='".$search['revenue_type']." ";
							}					
							$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
							
							if(isset($search['adv_account_id']) AND $search['adv_account_id'] !== '' AND is_array($search['adv_account_id']) AND $search['adv_account_id'] > 0){
								$advid	=	implode(',',$search['adv_account_id']);
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id IN (".$advid.") )";
							}
							else if(isset($search['adv_account_id']) AND $search['adv_account_id'] !== '' AND !is_array($search['adv_account_id']) AND $search['adv_account_id'] > 0){
								
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['adv_account_id'].")";
							}else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=".$search['agency_id'].")";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
									$SQL	.=" AND oxcl.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}
							else
							{
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
									$SQL	.=" AND oxcl.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}
											
							// LINK TRAFFICKER RELATED TABLES
							if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
								$adblockid	=	implode(',',$search['adblock_id']);
								$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$adblockid.") )";
							}
							else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
								$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
							}
							else
							{
								$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id";
							}
						
							
							$SQL .= " JOIN ( SELECT 
											dsza.zone_id,
											oxps.site_id as id,
											oxps.account_id,
											oxps.site_name as site_name,
											oxps.site_url as site_url
										FROM 
											djax_publisher_sites as oxps
										JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
										
										WHERE 1 ";
										if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
											$siteid	=	implode(',',$search['site_id']);
											$SQL .= " AND oxps.site_id IN (".$siteid.") ";
										}
										else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
											$SQL .= " AND oxps.site_id='".$search['site_id']."' ";
										}
										
							$SQL .= " UNION
										
										SELECT 
											daza.zone_id,
											daza.app_id as id,
											dtu.account_id,
											dtu.app_name as site_name,
											dtu.app_url as site_url
										FROM 
											djax_temp_url as dtu
										JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
										WHERE 1 ";
										if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
											$appid	=	implode(',',$search['app_id']);
											$SQL .= " AND dtu.id IN (".$appid.") ";
										}
										else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
											$SQL .= " AND dtu.id='".$search['app_id']."' ";
										}
										
							$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";
					
							if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
								$pubid	=	implode(',',$search['pub_account_id']);
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id IN (".$pubid.") )";
							
							}
							else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id=".$search['pub_account_id'].")";
							
							}else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
								$SQL .= " JOIN rv_affiliates as oxaff ON (oxaff.account_id=sa.account_id AND oxaff.agencyid=".$search['agency_id'].")";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
									$SQL	.=" AND oxaff.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}else{
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id)";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
									$SQL	.=" AND oxaff.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}		
					}		
				}	
				
				$SQL .= "  WHERE 1 ";			
							
				if(is_array($search) AND count($search) > 0){
					
					if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
						$country	=	implode("','",$search['country']);
						$SQL .= " AND oxah.country_code IN ('".$country."') ";
					}
					else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
						$SQL .= " AND oxah.country_code = '".$search['country']." ";
					}			
					
					if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
						if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
							$SQL .= " AND DATE(oxah.date_time) = '".$search['date_from']."'";
						}
						else
						{					
							$SQL .= " AND (DATE(oxah.date_time)  >= '".$search['date_from']."' AND DATE(oxah.date_time) <= '".$search['date_to']."')";
						}
					}
					else if(isset($search['date_from']) AND $search['date_from'] != ''){
						$SQL .= " AND DATE(oxah.date_time) = '".$search['date_from']."'";
					}
					/* Fetch Current Month Data - START */
					if(isset($search['month']) AND $search['year'])
					{
						$SQL .= " AND month(oxah.date_time) = '".$search['month']."' AND year(oxah.date_time)='".$search['year']."'";
					}
					/* END */
					
					if(isset($search['environment']) AND $search['environment'] != ''){
						$SQL .= " AND dj_delivery_media_type='".$search['environment']."'";
					}
					
					
					if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
						$SQL .= " AND (";
						foreach($search['search_fields'] as $sObj){
							$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
						}
					
						$SQL = rtrim($SQL, "OR");
					
						$SQL .= " )";					
					}
					
				}
				
				if($campaign_id)
				{
					$SQL .= " AND oxc.campaignid = '".$campaign_id."'";
				}
				if(is_array($group) AND count($group) > 0){
											
					$SQL .= " GROUP BY ";
					
					foreach($group as $val){
						switch($val){
							case 'DATE';
							case 'TIME';
								$SQL .= " {$date_field} ,";
								break;
							case 'MONTH';						
								$SQL .= " MONTHNAME({$date_field}) ,";
								break;	
							case 'YEAR';						
								$SQL .= " YEAR({$date_field}) ,";
								break;					
							case 'HOUR';
								$SQL .= " DATE_FORMAT(oxah.date_time,'%d-%m-%Y'), TIME(oxah.date_time) ,";
								break;
							case 'RTYPE';
								$SQL .= "oxc.revenue_type,";
								break;
							case 'ADSIZE';
								if($search['account_type'] === 'TRAFFICKER'){
									$SQL .= "oxz.width,oxz.height,";
								}
								else
								{
									if($page==='REPORT_PUBLISHER')
									{
										$SQL .= "oxz.width,oxz.height,";
									}
									else
									{
										$SQL .= "oxb.width,oxb.height,";
									}
								}
								break;			
						
							case 'ACC_ID';
								if($search['account_type'] === 'ADVERTISER'){
									$SQL .= "oxcl.account_id,";
								}
								else if($search['account_type'] === 'TRAFFICKER'){
									$SQL .= "oxaff.account_id,";
								}
								else if($search['account_type'] === 'ADMIN'){
									
									if($search['page']==='REPORT_ADVERTISER'){
										$SQL .= "oxcl.account_id,";
									}
									else if($search['page']==='REPORT_PUBLISHER')
									{
										$SQL .= "oxaff.account_id,";
									}
								}
								break;
							case 'ADV_ID';							
								$SQL .= "oxcl.account_id,";
								break;
							case 'AFF_ID';
								$SQL .= "oxaff.account_id,";
								break;						
							case 'CAM_ID';
								$SQL .= "oxc.campaignid,";
								break;
							case 'BAN_ID';
								$SQL .= "oxb.bannerid,";
								break;
							case 'SITE_ID';
								$SQL .= "sa.id,";
								break;	
							case 'APP_ID';
								$SQL .= "sa.id,";
								break;									
							case 'ZONE_ID';
								$SQL .= "oxz.zoneid,";
								break;
							case 'COUNTRY';
								$SQL .= "oxah.country_code,";
								break;
							case 'SITE_URL';							
								//$SQL .= "djs.site_url,";
								break;
							case 'DOMAIN';							
								//$SQL .= "djs.domain,";
								break;
							case 'SITE_REFERRER';							
								//$SQL .= "djs.site_referrer_url,";
								break;
							case 'ENV';
								$SQL .= "oxah.dj_delivery_media_type,";
								break;		
							case 'BROWSER';
								$SQL .= "oxah.browser_name,";
								break;		
							case 'LANGUAGE';
								$SQL .= "oxah.browser_language,";
								break;		
						}
					}
					
				}
				
				$SQL = rtrim($SQL, ",");
				
				$da		=	array('DATE','TIME','HOUR','MONTH');
				
				if(is_array($order) AND count($order) > 0){
					
					$of	=	0;
					
					foreach($order as $key=>$option){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY oxah.date_time {$option} ";
					}
					//REMOVE comma at End of the string
					
					$SQL = rtrim($SQL, ",");
				}
				elseif((!is_array($order)) && $order!='')
				{
					$ord	=	explode(',', $order);
					
					$of	=	0;
					
					foreach($ord as $key){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY oxah.date_time ASC ";
					}
					else
					{
						$SQL .= " ORDER BY oxah.date_time DESC ";
					}					
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				else
				{
					$SQL .= " ORDER BY oxah.date_time DESC ";
				}
				
			}
			
			$SQL .= " ) as r WHERE r.impr>0 OR r.click>0 OR r.conv>0 OR r.req>0 ";
			
			/*if(is_array($order) AND count($order) > 0){
				
				$OSQL	=	'';
				foreach($order as $key=>$option){
					$OSQL .= " {$key} {$option},";
				}
				$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";		
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				$OSQL	=	'';
				
				foreach($ord as $key){
					$OSQL .= " {$key} ASC,";
				}
				
			//	$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";			
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}*/	
			
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
					
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			//return $SQL; die();
			$query = $this->db->query($SQL);	
			//~ return $this->db->last_query();   
			//echo $SQL;  die();			
									
			if($dataTable){
				$data = $query->result_array();
				if($data)
				{
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$data,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $data;
					}
			
				}
				else
				{
					return FALSE;
				} 
			}
			else
			{
				$fields = $query->list_fields(); 
				
				$data = $query->result_array();
				$res['fields'] = $fields;
				$res['records'] = $data; 
				
				if($data)
				{
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$res,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $res;
					}
				//return $SQL;
				}
				else
				{
					return FALSE;
				} 
			}
		}
	}

	function fetch_country($columns,$search,$group,$order,$limit,$dataTable=FALSE)
	{
		
		$key = 	'fetch_country_report_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';

		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$dataTable;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$searching=array();
			$searching[0]=$search['date_from'];
			$searching[1]=$search['date_to'];
			$searching[2]=$search['environment'];
			$searching[3]=$search['country_id'];
			if(!is_array($group))
			{
				$group = explode(",",$group);
			}
			if(is_array($group) AND in_array('DATE',$group)){
				if(isset($search['timezone']) AND $search ['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','".$search['timezone']."'),'%d-%m-%Y')";
				}
				else
				{
					$date_field = "DATE_FORMAT(dgs.date_time,'%d-%m-%Y')";
				}
			}
			else if(is_array($group) AND in_array('TIME',$group))
			{
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','".$search['timezone']."'))";
				}
				else
				{
					$date_field = "TIME(dgs.date_time)";
				}	
			}
			else if(is_array($group) AND in_array('MONTH',$group)){
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','".$search['timezone']."'),'%b %Y')";
				}
				else
				{
					$date_field = "DATE_FORMAT(dgs.date_time,'%b %Y')";
				}			
			}
			
			/*
				DATE
				IMP
				CLK
				UIMP // !Publisher
				UCLK // !Publisher
				CON
				SPEND // !Publisher
				PUB_EARN // ! Advertiser
				ADM_EARN // ! Advertiser & !Publisher
				CTR // !Publisher
				ECPM // !Publisher
				PUB_ECPM // !advertiser
				CAM_ID
				CAM_NAME
				BAN_ID
				BAN_NAME
				ACC_ID
				SITE_ID
				ZONE_ID
				
			*/
			
			
			$SQL = "SELECT SQL_CALC_FOUND_ROWS null as rows,r.* FROM (SELECT ";
			$SQL .= " oxz.zonename,DATE_FORMAT(dgs.date_time,'%M %Y') as MONTHs,
									  DATE_FORMAT(dgs.date_time,'%H:%i:%s') as HOURs,			
									  DATE_FORMAT(dgs.date_time,'%d-%m-%Y') as DATES,
									  dgs.date_time as TIME_DATE,
									  DATE_FORMAT(dgs.date_time,'%Y') as YEAR,
									  WEEK(dgs.date_time,'%d-%m-%Y') as WEEK,
									  dgs.browser_language as BROWSER_LANG, 
									  dgs.browser_name as BROWSER_NAME,";	
			if(is_array($columns) AND count($columns) > 0){
				foreach($columns as $val){
				
					switch(strtoupper($val)){
						
						case 'DATE';
							$SQL .= " DATE(dgs.date_time) as ".$val.',';
													
							break;
						case 'TIME_DATE';
							$SQL .= " dgs.date_time as TIME_DATES, ";
							break;							
						case 'IMP';
							$SQL .= " IFNULL(SUM(dgs.impressions),0) as ".$val.',';
							break;
						case 'REQUEST';
							if($dataTable==TRUE):
								$SQL .= " IFNULL(SUM(dgs.requests),0) as ".$val.',';
							else:
								$SQL .= " SUM(dgs.requests) as ".$val.',';
							endif;
							
							break;	
						case 'CLK';
							$SQL .= " IFNULL(SUM(dgs.clicks),0) as ".$val.',';
							break;
						case 'UIMP';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .=" IFNULL(SUM(dgs.uniq_impressions),0) as ".$val.",";	
							}
							break;
						case 'UCLK';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .=" IFNULL(SUM(dgs.uniq_clicks),0) as ".$val.",";	
							}
							break;	
						case 'CON';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " IFNULL(SUM(dgs.conversions),0) as ".$val.',';
							}
							break;		
						case 'CTR';
							//if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),0),2))) as ".$val.',';
							//}
							break;	
						
						case 'SPEND';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(dgs.total_revenue),0),4))) as ".$val.',';							
							}
							break;
						case 'PUB_EARN';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(dgs.publisher_earnings),0),4))) as ".$val.',';
							}
							break;	
						case 'ADM_EARN';
							if($search['account_type'] === 'ADMIN'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((SUM(dgs.total_revenue) - SUM(dgs.publisher_earnings)),0),4))) as ".$val.',';
							}
							break;		
						
						case 'ECPM';
							if($search['account_type'] == 'ADVERTISER'){
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(dgs.total_revenue)/SUM(dgs.impressions))*1000),0),2))) END as ".$val.',';
							}
							else{
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(dgs.publisher_earnings)/SUM(dgs.impressions))*1000),0),2))) END as ".$val.',';
							}
							break;
						case 'PUB_ECPM';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(dgs.publisher_earnings)/SUM(dgs.impressions))*1000),0),2))) END as ".$val.',';
							}
							break;
					
						case 'HOUR';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{							
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','".$search['timezone']."'),'%d-%m-%Y') as DATE , ";
								}
								$SQL .= " TIME(CONVERT_TZ(dgs.date_time,'+00:00','".$search['timezone']."')) as ".$val.',';
							}
							else
							{
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(dgs.date_time,'%d-%m-%Y') as DATE ,";
								}
								$SQL .= " TIME(dgs.date_time) as ".$val.',';
							}						
							break;
						case 'MONTH';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{
								$SQL .= " DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','".$search['timezone']."'),'%b %Y') as ".$val.',';
							}
							else
							{
								$SQL .= " DATE_FORMAT(dgs.date_time,'%b %Y') as ".$val.',';
							}
							break;
							
						case 'ERPM';
							if($dataTable==TRUE):
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(dgs.total_revenue)/SUM(dgs.impressions))*1000),0),2))) END as ".$val.',';
							else:
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ((SUM(dgs.total_revenue)/SUM(dgs.impressions))*1000))) END as ".$val.',';
							endif;						
							break;
						case 'EPPM';
							if($dataTable==TRUE):
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((((SUM(dgs.total_revenue) - SUM(dgs.publisher_earnings))/SUM(dgs.impressions))*1000),0),2))) END as ".$val.',';
							else:
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM (((SUM(dgs.total_revenue) - SUM(dgs.publisher_earnings))/SUM(dgs.impressions))*1000))) END as ".$val.',';
							endif;
							
							break;
						
						case 'FILL_RATE';
							$SQL .= " CASE WHEN SUM(dgs.requests)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(dgs.impressions)/SUM(dgs.requests))*100),0),2))) END as ".$val.',';
							break;					
						
						case 'ACC_ID';
							if($search['account_type'] === 'ADVERTISER'){
								$SQL .= " (oxcl.account_id) as ".$val.',';
								$SQL .= " (oxcl.clientname) as ACC_NAME,";
							}
							else if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= " (oxaff.account_id) as ".$val.',';
								$SQL .= " (oxaff.name) as ACC_NAME,";
							}
							else if($search['account_type'] === 'ADMIN'){
								
								if($search['page']==='REPORT_ADVERTISER'){
									$SQL .= " (oxcl.account_id) as ".$val.',';
									$SQL .= " (oxcl.clientname) as ACC_NAME,";
									$SQL .= " (oxcl.dj_is_deleted) as DEL_STATUS,";
									#$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxcl.account_id ) as ACTIVE_STATUS,";
									
								}
								else if($search['page']==='REPORT_PUBLISHER')
								{
									$SQL .= " (oxaff.account_id) as ".$val.',';
									$SQL .= " (oxaff.name) as ACC_NAME,";
								}

							}
							break;		
						case 'ADV_ID';
							$SQL .= " (oxcl.account_id) as ".$val.',';
							$SQL .= " (oxcl.clientname) as CLIENT_NAME,";
							$SQL .= " (oxcl.dj_is_deleted) as ADV_DEL_STATUS,";
							//$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxcl.account_id ) as ADV_ACTIVE_STATUS,";
							break;
						case 'AFF_ID';
							$SQL .= " (oxaff.account_id) as ".$val.',';
							$SQL .= " (oxaff.name) as AFF_NAME,";
							$SQL .= " (oxaff.dj_is_deleted) as PUB_DEL_STATUS,";
							//$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxaff.account_id ) as PUB_ACTIVE_STATUS,";
							break;
						
						case 'CAM_ID';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " (oxc.campaignid) as ".$val.',';
								$SQL .= " (oxc.campaignname) as CAM_NAME,";
								//$SQL .= " (oxcl.clientname) as ACC_NAME,";
								//$SQL .= " (oxz.zonename) as ZONE_NAME,";
							}
							break;
						case 'BAN_ID';
							if($search['account_type'] != 'TRAFFICKER'){
								$SQL .= " (oxb.bannerid) as ".$val.',';
								$SQL .= " (oxb.storagetype) as ST_TYPE,";
								$SQL .= " (oxb.dj_banner_type) as BAN_TYPE,";
								$SQL .= " (oxb.description) as BAN_NAME,";
								//$SQL .= " (oxcl.clientname) as ACC_NAME,";
								//$SQL .= " (oxz.zonename) as ZONE_NAME,";
							}
							
							break;		
						case 'SITE_ID';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " (sa.id) as ".$val.',';
								$SQL .= " (sa.site_name) as SITE_NAME,";
								$SQL .= " (sa.site_url) as SITE_URL,";
								//$SQL .= " (oxaff.name) as ACC_NAME,";
							}
							break;
						case 'ZONE_ID';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " (oxz.zoneid) as ".$val.',';
								$SQL .= " (oxz.zonename) as ZONE_NAME,";
								//$SQL .= " (oxaff.name) as ACC_NAME,";
							}
							break;		
						case 'ENV';
							$SQL .= " (dgs.delivery_media_type) as ".$val.",";
							break;	
						case 'COUNTRY_CODE':
							$SQL .= " (dgs.country_code) as ".$val.",";
							$SQL .= " (dgs.country) as COUNTRY,";
							$SQL .= " (oxb.width) as WIDTH,";
							$SQL .= " (oxb.height) as HEIGHT,";
							$SQL .= " oxb.dj_banner_type as adtype,";
							break;
						case 'COUNTRY':
							$SQL .= " (dgs.country_code) as COUNTRY_CODE,";
							$SQL .= " (dgs.country) as ".$val.",";
							$SQL .= " (oxb.width) as WIDTH,";
							$SQL .= " (oxb.height) as HEIGHT,";
							$SQL .= " oxb.dj_banner_type as adtype,";
							//$SQL .= " IFNULL(SUM(dgs.impressions),0) as IMPR,";		
							//$SQL .= " ROUND(IFNULL(((SUM(dgs.total_revenue)/SUM(dgs.impressions))*1000),0),2) as CPM,";
											
							break;
							
						case 'LATITUDE':
							$SQL .= " (dgs.latitude) as ".$val.",";
							break;
						case 'LONGITUDE':
							$SQL .= " (dgs.longitude) as ".$val.",";
							break;
						case 'RTYPE';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " (dcrt.revenue_type) as ".$val.',';
								$SQL .= " (oxc.revenue_type) as revenue_type,";
							}
							break;
						case 'ADSIZE';
							if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
							}
							else
							{
								if($page==='REPORT_PUBLISHER')
								{
									$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
								}
								else
								{
									$SQL .= " CONCAT(oxb.width, 'x', oxb.height) as ".$val.',';
								}							
							}
							break;									
					}
				}
				
				$SQL .= " DATE(dgs.date_time) as date_time,IFNULL(SUM(dgs.impressions),0) as impr,IFNULL(SUM(dgs.clicks),0) as click,IFNULL(SUM(dgs.conversions),0) as conv,IFNULL(SUM(dgs.requests),0) as req ";	
					
				//REMOVE comma at End of the string
			
				$SQL = rtrim($SQL, ",");
				
				$SQL .= " FROM djax_geographical_stats as dgs ";
				
				if(is_array($search) AND count($search) > 0 AND array_key_exists('account_id',$search) AND $search['account_id'] != ''){
				
				
					if($search['account_type'] === "ADVERTISER"){
					
						if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
							$creativeid	=	implode(',',$search['creative_id']);
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=dgs.ad_id AND oxb.bannerid IN (".$creativeid.") )";
						}
						else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=dgs.ad_id AND oxb.bannerid='".$search['creative_id']."')";
						}
						else
						{
							$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=dgs.ad_id";
						}
						
						if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
							if(in_array('custom',$search['adsize']))
							{
								$si	=	array();
								foreach($search['adsize'] as $siz):
									if($siz!='custom')
									{
										$si[]	=	$siz;
									}
								endforeach;
								if(!empty($si)):	
									$size	=	implode("','",$si);												
									$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
								endif;
							}
							else
							{
								$size	=	implode("','",$search['adsize']);												
								$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
							}
						}
						else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
							$size	=	explode('x',$search['adsize']);
							$SQL .= " AND oxb.width=".$size[0]." AND oxb.height=".$size[1]." ";
						}			
						
						if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
							$campid	=	implode(',',$search['campaign_id']);
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
						}
						else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";						
						}
						
						if(isset($search['revenue_type']) AND $search['revenue_type']!='' AND is_array($search['revenue_type'])){
							$camp_type	=	implode(',',$search['revenue_type']);
							$SQL .= " AND oxc.revenue_type IN (".$camp_type.") ";
						}
						else if(isset($search['revenue_type']) AND $search['revenue_type'] != '' AND !is_array($search['revenue_type'])){
							$SQL .= " AND oxc.revenue_type='".$search['revenue_type']." ";
						}
						
						$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
					
						$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['account_id'].")";
						
						//// GET STATISTICS VALUES FOR AN TRAFFICKER
						if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
							$adblockid	=	implode(',',$search['adblock_id']);
							$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=dgs.zone_id AND oxz.zoneid IN (".$adblockid.") )";
						}
						else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
							$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=dgs.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=dgs.zone_id";
						}
						
						//DAC107
						$SQL .= " JOIN ( SELECT 
										dsza.zone_id,
										oxps.site_id as id,
										oxps.account_id,
										oxps.site_name as site_name,
										oxps.site_url as site_url
									FROM 
										djax_publisher_sites as oxps
									JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
									
									WHERE 1 ";
									if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
										$siteid	=	implode(',',$search['site_id']);
										$SQL .= " AND oxps.site_id IN (".$siteid.") ";
									}
									else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
										$SQL .= " AND oxps.site_id='".$search['site_id']."' ";
									}
									
						$SQL .= " UNION
									
									SELECT 
										daza.zone_id,
										daza.app_id as id,
										dtu.account_id,
										dtu.app_name as site_name,
										dtu.app_url as site_url
									FROM 
										djax_temp_url as dtu
									JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
									WHERE 1 ";
									if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
										$appid	=	implode(',',$search['app_id']);
										$SQL .= " AND dtu.id IN (".$appid.") ";
									}
									else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
										$SQL .= " AND dtu.id='".$search['app_id']."' ";
									}
									
						$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";
				
						if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
							$pubid	=	implode(',',$search['pub_account_id']);
							$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id IN (".$pubid.") )";
						
						}
						else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
							$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id=".$search['pub_account_id'].")";
						
						}
						else
						{
							$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id )";
						}

					}
					else if($search['account_type'] === "TRAFFICKER"){
						
						$SQL .= " JOIN rv_banners as oxb ON oxb.bannerid=dgs.ad_id";
						
						if(isset($search['campaign_id']) AND $search['campaign_id'] != ''){
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
						}	
						
						//// GET STATISTICS VALUES FOR AN TRAFFICKER
						if(isset($search['adblock_id']) AND $search['adblock_id'] != ''){
							$SQL .= " JOIN rv_zones as oxz ON (oxz.zoneid=dgs.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=dgs.zone_id";
						}
						
						//DAC107
						if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
							if(in_array('custom',$search['adsize']))
							{
								$si	=	array();
								foreach($search['adsize'] as $siz):
									if($siz!='custom')
									{
										$si[]	=	$siz;
									}
								endforeach;
								if(!empty($si)):	
									$size	=	implode("','",$si);												
									$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) NOT IN ('".$size."') ";
								endif;
							}
							else
							{
								$size	=	implode("','",$search['adsize']);												
								$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) IN ('".$size."') ";
							}
						}
						
						else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
							$size	=	explode('x',$search['adsize']);
							$SQL .= " AND oxz.width=".$size[0]." AND oxz.height=".$size[1]." ";
						}
						
						//DAC107
						$SQL .= " JOIN ( SELECT 
										dsza.zone_id,
										oxps.site_id as id,
										oxps.account_id,
										oxps.site_name as site_name,
										oxps.site_url as site_url
									FROM 
										djax_publisher_sites as oxps
									JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
									
									WHERE 1 ";
									if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
										$siteid	=	implode(',',$search['site_id']);
										$SQL .= " AND oxps.site_id IN (".$siteid.") ";
									}
									else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
										$SQL .= " AND oxps.site_id='".$search['site_id']."' ";
									}
									
						$SQL .= " UNION
									
									SELECT 
										daza.zone_id,
										daza.app_id as id,
										dtu.account_id,
										dtu.app_name as site_name,
										dtu.app_url as site_url
									FROM 
										djax_temp_url as dtu
									JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
									WHERE 1 ";
									if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
										$appid	=	implode(',',$search['app_id']);
										$SQL .= " AND dtu.id IN (".$appid.") ";
									}
									else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
										$SQL .= " AND dtu.id='".$search['app_id']."' ";
									}
									
						$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";
				
						$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id AND oxaff.account_id=".$search['account_id'].")";
					}
					else if($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER"){
				  
						// LINK ADVERTISER RELATED TABLES
						if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
							$creativeid	=	implode(',',$search['creative_id']);
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=dgs.ad_id AND oxb.bannerid IN (".$creativeid.") )";
						}
						else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=dgs.ad_id AND oxb.bannerid='".$search['creative_id']."')";
						}
						else
						{
							$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=dgs.ad_id";
						}
							
							if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
								
								if(in_array('custom',$search['adsize']))
								{
									$si	=	array();
									foreach($search['adsize'] as $siz):
										if($siz!='custom')
										{
											$si[]	=	$siz;
										}
									endforeach;
									if(!empty($si)):	
										$size	=	implode("','",$si);												
										$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
									endif;
								}
								else
								{
									$size	=	implode("','",$search['adsize']);												
									$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
								}
							}
							else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
								$size	=	explode('x',$search['adsize']);
								$SQL .= " AND oxb.width=".$size[0]." AND oxb.height=".$size[1]." ";
							}			
							
							if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
								$campid	=	implode(',',$search['campaign_id']);
								$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
							}
							else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
								$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
							}
							else
							{
								$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
								
							}
							if(isset($search['revenue_type']) AND $search['revenue_type']!='' AND is_array($search['revenue_type'])){
								$camp_type	=	implode(',',$search['revenue_type']);
								$SQL .= " AND oxc.revenue_type IN (".$camp_type.") ";
							}
							else if(isset($search['revenue_type']) AND $search['revenue_type'] != '' AND !is_array($search['revenue_type'])){
								$SQL .= " AND oxc.revenue_type='".$search['revenue_type']." ";
							}					
							$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
							
							if(isset($search['adv_account_id']) AND $search['adv_account_id'] !== '' AND is_array($search['adv_account_id']) AND $search['adv_account_id'] > 0){
								$advid	=	implode(',',$search['adv_account_id']);
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id IN (".$advid.") )";
							}
							else if(isset($search['adv_account_id']) AND $search['adv_account_id'] !== '' AND !is_array($search['adv_account_id']) AND $search['adv_account_id'] > 0){
								
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['adv_account_id'].")";
							}else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=".$search['agency_id'].")";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
									$SQL	.=" AND oxcl.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}
							else
							{
								$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
									$SQL	.=" AND oxcl.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}
											
							// LINK TRAFFICKER RELATED TABLES
							if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
								$adblockid	=	implode(',',$search['adblock_id']);
								$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=dgs.zone_id AND oxz.zoneid IN (".$adblockid.") )";
							}
							else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
								$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=dgs.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
							}
							else
							{
								$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=dgs.zone_id";
							}
						
							$SQL .= " JOIN ( SELECT 
											dsza.zone_id,
											oxps.site_id as id,
											oxps.account_id,
											oxps.site_name as site_name,
											oxps.site_url as site_url
										FROM 
											djax_publisher_sites as oxps
										JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
										
										WHERE 1 ";
										if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
											$siteid	=	implode(',',$search['site_id']);
											$SQL .= " AND oxps.site_id IN (".$siteid.") ";
										}
										else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
											$SQL .= " AND oxps.site_id='".$search['site_id']."' ";
										}
										
							$SQL .= " UNION
										
										SELECT 
											daza.zone_id,
											daza.app_id as id,
											dtu.account_id,
											dtu.app_name as site_name,
											dtu.app_url as site_url
										FROM 
											djax_temp_url as dtu
										JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
										WHERE 1 ";
										if(isset($search['app_id']) AND $search['app_id'] != '' AND is_array($search['app_id']) ){
											$appid	=	implode(',',$search['app_id']);
											$SQL .= " AND dtu.id IN (".$appid.") ";
										}
										else if(isset($search['app_id']) AND $search['app_id'] != '' AND !is_array($search['app_id'])){
											$SQL .= " AND dtu.id='".$search['app_id']."' ";
										}
										
							$SQL .=	" ) as sa ON sa.zone_id=oxz.zoneid ";
					
							if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
								$pubid	=	implode(',',$search['pub_account_id']);
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id IN (".$pubid.") )";
							
							}
							else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id  AND oxaff.account_id=".$search['pub_account_id'].")";
							
							}else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
								$SQL .= " JOIN rv_affiliates as oxaff ON (oxaff.account_id=sa.account_id AND oxaff.agencyid=".$search['agency_id'].")";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
									$SQL	.=" AND oxaff.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}else{
								$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id)";
								if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
									$SQL	.=" AND oxaff.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
								endif;
							}		
					}		
							 
				}	
				
				
				$SQL 	.= 	"  WHERE 1";
				
				if(is_array($search) AND count($search) > 0){
					
					if(isset($search['bid_price']) AND $search['bid_price'] != ''){
						$SQL .= " AND oxc.revenue = '".$search['bid_price']."' ";
					}
					
					if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
						$country	=	implode("','",$search['country']);
						$SQL .= " AND dgs.country_code IN ('".$country."') ";
					}
					else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
						$SQL .= " AND dgs.country_code = '".$search['country']." ";
					}			
					
					if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
						$adblocks_id	=	implode("','",$search['adblock_id']);
						$SQL .= " AND dgs.zone_id IN ('".$adblocks_id."') ";
					}
					else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
						$SQL .= " AND dgs.zone_id = '".$search['adblock_id']."' ";
					}
					
					if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
						$pub_accoun	=	implode("','",$search['adblock_id']);
						$SQL .= " AND oxaff.account_id IN ('".$pub_accoun."') ";
					}
					else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
						$SQL .= " AND oxaff.account_id = '".$search['pub_account_id']."' ";
					}
					
					if(isset($search['dev_type']) AND $search['dev_type'] != '' AND is_array($search['pub_account_id'])){
						$dev_type	=	implode("','",$search['dev_type']);
						$SQL .= " AND dgs.delivery_media_type IN ('".$dev_type."') ";
					}
					else if(isset($search['dev_type']) AND $search['dev_type'] != '' AND !is_array($search['dev_type'])){
						$SQL .= " AND dgs.delivery_media_type = '".$search['dev_type']."' ";
					}
					
					if(isset($search['browser']) AND $search['browser'] != '' AND is_array($search['browser'])){
						$browser	=	implode("','",$search['browser']);
						$SQL .= " AND dgs.browser_name IN (SELECT name FROM djax_targ_browsers WHERE value IN ('".$browser."')) 
						 ";
					}
					else if(isset($search['browser']) AND $search['browser'] != '' AND !is_array($search['browser'])){
						$SQL .= " AND dgs.browser_name = (SELECT name FROM djax_targ_browsers 
						WHERE value = ".$search['browser'].") ";
					}
					if(isset($search['brow_lang']) AND $search['brow_lang'] != '' AND is_array($search['brow_lang'])){
						$browser	=	implode("','",$search['brow_lang']);
						$SQL .= " AND dgs.browser_language IN ('".$browser."') 
						 ";
					}
					else if(isset($search['brow_lang']) AND $search['brow_lang'] != '' AND !is_array($search['brow_lang'])){
						$SQL .= " AND dgs.browser_language = '".$search['brow_lang']."' ";
					}
					
					if(isset($search['os']) AND $search['os'] != '' AND is_array($search['os'])){
						$os	=	implode("','",$search['os']);
						$SQL .= " AND dgs.operating_system IN (SELECT name FROM djax_targ_operating_system WHERE value IN ('".$os."')) ";
					}
					else if(isset($search['os']) AND $search['os'] != '' AND !is_array($search['os'])){
						$SQL .= " AND dgs.operating_system = (SELECT name FROM djax_targ_operating_system WHERE value = '".$search['os']."') ";
					}	
					
					if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
						if($search['page']!=='REPORT_GEO_GRAPHICAL' && $search['account_type'] == 'ADMIN' )
						{
							$SQL .= " AND (DATE(oxah.date_time)  >= '".$search['date_from']."' AND DATE(oxah.date_time) <= '".$search['date_to']."')";
						}
						
						if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
							$SQL .= " AND DATE(dgs.date_time) = '".$search['date_from']."'";
						}
						else
						{					
							$SQL .= " AND (DATE(dgs.date_time)  >= '".$search['date_from']."' AND DATE(dgs.date_time) <= '".$search['date_to']."')";
						}
					}
					else if(isset($search['date_from']) AND $search['date_from'] != ''){
						$SQL .= " AND DATE(dgs.date_time) = '".$search['date_from']."'";
					}
					/* Fetch Current Month Data - START */
					if(isset($search['month']) AND $search['year'])
					{
						$SQL .= " AND month(dgs.date_time) = '".$search['month']."' AND year(dgs.date_time)='".$search['year']."'";
					}
					
					if(isset($search['environment']) AND $search['environment'] != ''){
						if($search['environment']=='Tablet'):
							$SQL .= " AND dgs.delivery_media_type='Display'";
						else:
							$SQL .= " AND dgs.delivery_media_type='".$search['environment']."'";
						endif;						
					}
			
					if(isset($search['country_id']) AND $search['country_id'] != '' AND is_array($search['country_id'])){
						$country	=	implode("','",$search['country_id']);
						$SQL .= " AND dgs.country_code IN ('".$country."') ";
					}
					else if(isset($search['country_id']) AND $search['country_id'] != '' AND !is_array($search['country_id'])){
						$SQL .= " AND dgs.country_code = '".$search['country_id']." ";
					}
					if(isset($search['camtyp']) AND $search['camtyp'] != '' AND is_array($search['camtyp'])){
						$camtyp	=	implode("','",$search['camtyp']);
						$SQL .= " AND oxc.revenue_type IN ('".$camtyp."') ";
					}
					else if(isset($search['camtyp']) AND $search['camtyp'] != '' AND !is_array($search['camtyp'])){
						$SQL .= " AND oxc.revenue_type = '".$search['camtyp']." ";
					}
				
				}
				if(!is_array($group))
				{
					$group = explode(",",$group);
				}
				
				if(is_array($group) AND count($group) > 0){
				
					$SQL .= " GROUP BY ";
					
					foreach($group as $val){
						switch($val){
							case 'DATE';
							case 'TIME';
								$SQL .= " {$date_field} ,";
								break;
							case 'MONTH';						
								$SQL .= " MONTHNAME({$date_field}) ,";
								break;					
							case 'HOUR';
								$SQL .= " DATE_FORMAT(dgs.date_time,'%d-%m-%Y'), TIME(dgs.date_time) ,";
								break;
							case 'RTYPE';
								$SQL .= "oxc.revenue_type,";
								break;
							case 'ADSIZE';
								if($search['account_type'] === 'TRAFFICKER'){
									$SQL .= "oxz.width,oxz.height,";
								}
								else
								{
									if($page==='REPORT_PUBLISHER')
									{
										$SQL .= "oxz.width,oxz.height,";
									}
									else
									{
										$SQL .= "oxb.width,oxb.height,";
									}
								}
								break;			
						
							case 'ACC_ID';
								if($search['account_type'] === 'ADVERTISER'){
									$SQL .= "oxcl.account_id,";
								}
								else if($search['account_type'] === 'TRAFFICKER'){
									$SQL .= "oxaff.account_id,";
								}
								else if($search['account_type'] === 'ADMIN'){
									
									if($search['page']==='REPORT_ADVERTISER'){
										$SQL .= "oxcl.account_id,";
									}
									else if($search['page']==='REPORT_PUBLISHER')
									{
										$SQL .= "oxaff.account_id,";
									}
								}
								break;
							case 'ADV_ID';							
								$SQL .= "oxcl.account_id,";
								break;
							case 'AFF_ID';
								$SQL .= "oxaff.account_id,";
								break;						
							case 'CAM_ID';
								$SQL .= "oxc.campaignid,";
								break;
							case 'BAN_ID';
								$SQL .= "oxb.bannerid,";
								break;
							case 'SITE_ID';
								$SQL .= "sa.id,";
								break;	
							case 'ZONE_ID';
								$SQL .= "oxz.zoneid,";
								break;
							case 'ENV';
								$SQL .= "dgs.delivery_media_type,";
								break;	
							case 'COUNTRY';
								$SQL .= " dgs.country_code,";
								break;
							case 'COUNTRY_CODE';
								$SQL .= " dgs.country_code,";
								break;
							case 'SIZE';
								$SQL .= " oxb.width,";
								$SQL .= " oxb.height,";							
								break;
							case 'LATITUDE';
								$SQL .= " dgs.latitude,";
								break;
							case 'LONGITUDE';
								$SQL .= " dgs.longitude,";
								break;		
							case 'IMPRESSION';
								$SQL .= " dgs.impressions,";
								break;		
							case 'WEEK';
								$SQL .= " WEEK(dgs.date_time),";
								break;		
							case 'MONTH';
								$SQL .= " MONTH(dgs.date_time),";
								break;		
							case 'YEAR';
								$SQL .= " YEAR(dgs.date_time),";
								break;		
							case 'BROWSER';
								$SQL .= " dgs.browser_name,";
								break;		
							case 'LANGUAGE';
								$SQL .= " dgs.browser_language,";
								break;		
						}
					}
					
				}

				
				
				$SQL = rtrim($SQL, ",");			
				
				$da		=	array('DATE','TIME','HOUR','MONTH');
				
				if(is_array($order) AND count($order) > 0){
					
					$of	=	0;
					
					foreach($order as $key=>$option){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY dgs.date_time {$option} ";
					}
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				elseif((!is_array($order)) && $order!='')
				{
					$ord	=	explode(',', $order);
					
					$of	=	0;
					
					foreach($ord as $key){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY dgs.date_time ASC ";
					}
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				
				/*if(is_array($order) AND count($order) > 0){
					
					$SQL .= " ORDER BY ";
					
					foreach($order as $key=>$option){
						$SQL .= " {$key} {$option},";				
					}
				
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				
				if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
					
					$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
				}
				else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
					$SQL .=	 " LIMIT ".$limit['end']."";
				}*/
				
			}
			
			$SQL .= " ) as r WHERE r.impr>0 OR r.click>0 OR r.conv>0 OR r.req>0 ";
			
			if(is_array($order) AND count($order) > 0){
				
				$OSQL	=	'';	
				if($adv_types!='top_geo'){
				foreach($order as $key=>$option){
					if($key != "IMPRESSION" && $key != "WEEK" && $key != "MONTH" && $key != "YEAR" && $key != "ADSIZE" && $key != "DATE" && $key != "BROWSER" && $key != "LANGUAGE" )
					{
					$OSQL .= " {$key} {$option},";
					}
				}
	
				$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";	
					}
				
				else{
					$SQL .= " ORDER BY  r.impr DESC";
					}


			
				//greatest cmp
					//$SQL .= ($OSQL!='')?" ORDER BY  r.impr DESC":"";	
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				$OSQL	=	'';
				
				foreach($ord as $key){
					if($key != "IMPRESSION" && $key != "WEEK" && $key != "MONTH" && $key != "YEAR" && $key != "ADSIZE" && $key != "DATE" && $key != "BROWSER" && $key != "LANGUAGE" )
					{					
					$OSQL .= " {$key} ASC,";
					}
				}
				
				$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";			
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}	
			
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
					
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			
			/*$mc = new Memcached();
			$isMemcacheAvailable=$mc->addServer("127.0.0.1", 11211);
			
			if ($isMemcacheAvailable)
			{ 
				if(isset($search['date_from']) && $search['date_from']!='' && isset($search['date_to']) && $search['date_to']!='' && isset($search['environment']) && $search['environment']!='' && isset($search['country_id']) && $search['country_id']!='')
				{
					$key=$search['date_from']."_".$search['date_to']."_".$search['environment']."_".$search['country_id'];
				}
				elseif(isset($search['date_from']) && $search['date_from']!='' && isset($search['date_to']) && $search['date_to']!='' && isset($search['environment']) && $search['environment']!='')
				{
					$key=$search['date_from']."_".$search['date_to']."_".$search['environment'];
				}
				elseif(isset($search['date_from']) && $search['date_from']!='' && isset($search['date_to']) && $search['date_to']!='')
				{
					$key=$search['date_from']."_".$search['date_to'];
				}
				
				$result = $mc->get($key);
				
				if($result==null)
				{												
					$query 		= 	$this->db->query($SQL);
					$data 		= 	$query->result_array();	
					$data_res	=	$mc->set($key,$data_res);
					
				} 
				else
				{						
					$data	=	$result;
				}
			}
			else
			{				
				$query 		= 	$this->db->query($SQL);
				$data_res 	= 	$query->result_array();	
				$data		=	$mc->set($key,$data_res);
					
			}*/
			
			$query 	= 	$this->db->query($SQL);
			$data 	= 	$query->result_array();
			
			if($dataTable){
				
				if($data)
				{		
					
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$data,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $data;
					}
				}
				else
				{
					return FALSE;
				} 
			}
			else
			{
				$fields = $query->list_fields(); 
				
				//$data = $query->result_array();
				
				$res['fields'] = $fields;
				$res['records'] = $data; 
				if($data)
				{			
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$res,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $res;
					}	
				}
				else
				{
					return FALSE;
				} 
			}
		}
		
	}

	 
	function get_impression_count($search){
	 

		$SQL =" SELECT SUM( oxah.impressions ) AS total_impressions, ROUND( IFNULL( (
			(
			SUM( oxah.dj_total_revenue ) / SUM( oxah.impressions ) ) *1000 ) , 0
			), 2
			) AS total_CPM
			FROM djax_geographical_stats AS dgs
			JOIN rv_banners AS oxb ON oxb.bannerid = dgs.ad_id
			JOIN rv_data_summary_ad_hourly AS oxah ON oxah.ad_id = dgs.ad_id
			JOIN rv_campaigns AS oxc ON oxc.campaignid = oxb.campaignid
			JOIN rv_clients AS oxcl ON ( oxc.clientid = oxcl.clientid
			AND oxcl.agencyid =1 ) 
			JOIN rv_zones AS oxz ON oxz.zoneid = dgs.zone_id
			JOIN djax_site_zone_assoc AS dsza ON dsza.zone_id = oxz.zoneid
			JOIN djax_publisher_sites AS oxps ON oxps.site_id = dsza.site_id
			JOIN rv_affiliates AS oxaff ON ( oxaff.account_id = oxps.account_id
			AND oxaff.agencyid =1 )"; 


			$SQL.="  WHERE 1";

			if(is_array($search) AND count($search) > 0){
				
				if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(dgs.date_time)  >= '".$search['date_from']."' AND DATE(dgs.date_time) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
					$SQL .= " AND DATE(dgs.date_time) = '".$search['date_from']."'";
				}
				
				if(isset($search['environment']) AND $search['environment'] != ''){
					$SQL .= " AND delivery_media_type='".$search['environment']."'";
				}
				
				if(isset($search['country_id']) AND $search['country_id'] != '' AND is_array($search['country_id'])){
					$country	=	implode("','",$search['country_id']);
					$SQL .= " AND dgs.country_code IN ('".$country."') ";
				}
				else if(isset($search['country_id']) AND $search['country_id'] != '' AND !is_array($search['country_id'])){
					$SQL .= " AND dgs.country_code = '".$search['country_id']." ";
				}
				
				
			}
			
			//echo $SQL;
			//return $SQL;
			//exit;	
			$query = $this->db->query($SQL);
		///echo $this->db->last_query();
		//exit;
			
			//echo $query;
			//return $query;
			
			
			$data = $query->result_array();
			
			if($data)
			{			
				return $data[0];
			}
			else
			{
				return FALSE;
			} 			
			break;
		
	 }	 
	 
	 function get_inventory_count($user,$date,$agency_id){
	 
	 	switch($user){
			case 'ADMIN':
				$SQL = "SELECT 
					(SELECT SUM(c)  as adv_count
						FROM ( 
						(SELECT count(*) as c FROM `rv_clients` WHERE  DATE(`dj_added_date`) = '".$date."' AND agencyid='".$agency_id."')  UNION  
						(SELECT count(*) as c  FROM  djax_temp_user WHERE DATE(`created_date`)  = '".$date."' AND account_type='ADVERTISER' AND agency_id='".$agency_id."') 
					) as t) as adv_count,
					
					(SELECT SUM(c) as pub_count
					FROM ( 
						(SELECT count(*) as c FROM `rv_affiliates` WHERE  DATE(`dj_added_date`) = '".$date."' AND agencyid='".$agency_id."')  UNION  
						(SELECT count(*) as c  FROM  djax_temp_user WHERE DATE(`created_date`)  = '".$date."' AND account_type='TRAFFICKER' AND agency_id='".$agency_id."') 
					) as t) as pub_count,
					
					(SELECT count(*) FROM `rv_banners` as oxb JOIN rv_campaigns as oxc ON oxb.campaignid=oxc.campaignid JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid='".$agency_id."') WHERE DATE(oxb.`dj_added_date`)='".$date."') as ban_count,
					
					(SELECT count(*) FROM `rv_campaigns` as oxc JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid='".$agency_id."')  WHERE DATE(oxc.`dj_added_date`)='".$date."') as cam_count,
					
					(SELECT count(*) FROM `rv_zones` as oxz JOIN rv_affiliates as oxaff ON (oxz.affiliateid=oxaff.affiliateid AND oxaff.agencyid='".$agency_id."') WHERE DATE(oxz.`dj_added_date`)='".$date."') as zone_count";	
			$query = $this->db->query($SQL);
			
			$data = $query->result_array();
			
			if($data)
			{			
				return $data[0];
			}
			else
			{
				return FALSE;
			} 			
			break;
		}
		
	 }
	 
	function fetch_url($columns,$search,$group,$order,$limit,$dataTable=FALSE)
	{	
		$key = 	'fetch_url_report_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$dataTable;
				
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{			
			if(is_array($group) AND in_array('DATE',$group)){
				if(isset($search['timezone']) AND $search ['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(djs.date_time,'+00:00','".$search['timezone']."'),'%d-%m-%Y')";
				}
				else
				{
					$date_field = "DATE_FORMAT(djs.date_time,'%d-%m-%Y')";
				}
			}
			else if(is_array($group) AND in_array('TIME',$group))
			{
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "TIME(CONVERT_TZ(djs.date_time,'+00:00','".$search['timezone']."'))";
				}
				else
				{
					$date_field = "TIME(djs.date_time)";
				}	
			}
			else if(is_array($group) AND in_array('MONTH',$group)){
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(djs.date_time,'+00:00','".$search['timezone']."'),'%b %Y')";
				}
				else
				{
					$date_field = "DATE_FORMAT(djs.date_time,'%b %Y')";
				}			
			}
		
		
			/*
				DATE
				IMP
				CLK
				UIMP // !Publisher
				UCLK // !Publisher
				CON
				SPEND // !Publisher
				PUB_EARN // ! Advertiser
				ADM_EARN // ! Advertiser & !Publisher
				CTR // !Publisher
				ECPM // !Publisher
				PUB_ECPM // !advertiser
				CAM_ID
				CAM_NAME
				BAN_ID
				BAN_NAME
				ACC_ID
				SITE_ID
				ZONE_ID
				
			*/
			
			
			$SQL = "SELECT SQL_CALC_FOUND_ROWS null as rows,r.* FROM (SELECT dcts.traffic_id as TRAFFIC, temm.browser_name  as BROWSER_NAMES,temm.browser_language as BROWSER_LANGS,oxz.zonename as ZONE_NAMES,djs.date_time as TIME_DATE, ";
		 
			if(is_array($columns) AND count($columns) > 0){
				foreach($columns as $val){
					
					switch(strtoupper($val)){
						case 'DATE';
							$SQL .= " {$date_field} as ".$val.',';
							break;
						case 'TIME_DATE';
							$SQL .= " djs.date_time as TIME_DATES, ";
							break;								
						case 'IMP';
							$SQL .= " IFNULL(SUM(djs.impressions),0) as ".$val.',';
							break;
						case 'REQUEST';
							if($dataTable==TRUE):
								$SQL .= " IFNULL(SUM(djs.requests),0) as ".$val.',';
							else:
								$SQL .= " SUM(djs.requests) as ".$val.',';
							endif;
							
							break;	
						case 'CLK';
							$SQL .= " IFNULL(SUM(djs.clicks),0) as ".$val.',';
							break;
						case 'UIMP';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .=" IFNULL(SUM(djs.uniq_impressions),0) as ".$val.",";	
							}
							break;
						case 'UCLK';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .=" IFNULL(SUM(djs.uniq_clicks),0) as ".$val.",";	
							}
							break;	
						case 'CON';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " IFNULL(SUM(djs.conversions),0) as ".$val.',';
							}
							break;		
						case 'CTR';
							//if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(djs.clicks)/SUM(djs.impressions))*100),0),2))) as ".$val.',';
							//}
							break;	
						
						/*case 'SPEND';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(djs.total_revenue),0),4))) as ".$val.',';							
							}
							break;
						case 'PUB_EARN';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(djs.publisher_earnings),0),4))) as ".$val.',';
							}
							break;	
						case 'ADM_EARN';
							if($search['account_type'] === 'ADMIN'){
								$SQL .= " TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((SUM(djs.total_revenue) - SUM(djs.publisher_earnings)),0),4))) as ".$val.',';
							}
							break;		
						
						case 'ECPM';
							if($search['account_type'] == 'ADVERTISER'){
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(djs.total_revenue)/SUM(djs.impressions))*1000),0),2))) END as ".$val.',';
							}
							else{
								$SQL .= " CASE WHEN SUM(dgs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(djs.publisher_earnings)/SUM(djs.impressions))*1000),0),2))) END as ".$val.',';
							}
							break;
						case 'PUB_ECPM';
							if($search['account_type'] !== 'ADVERTISER'){
								$SQL .= " CASE WHEN SUM(djs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(djs.publisher_earnings)/SUM(djs.impressions))*1000),0),2))) END as ".$val.',';
							}
							break;*/
					
						case 'HOUR';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{							
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(CONVERT_TZ(djs.date_time,'+00:00','".$search['timezone']."'),'%d-%m-%Y') as DATE , ";
								}
								$SQL .= " TIME(CONVERT_TZ(djs.date_time,'+00:00','".$search['timezone']."')) as ".$val.',';
							}
							else
							{
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(djs.date_time,'%d-%m-%Y') as DATE ,";
								}
								$SQL .= " TIME(djs.date_time) as ".$val.',';
							}						
							break;
						case 'MONTH';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{
								$SQL .= " DATE_FORMAT(CONVERT_TZ(djs.date_time,'+00:00','".$search['timezone']."'),'%b %Y') as ".$val.',';
							}
							else
							{
								$SQL .= " DATE_FORMAT(djs.date_time,'%b %Y') as ".$val.',';
							}
							break;
							
						/*case 'ERPM';
							if($dataTable==TRUE):
								$SQL .= " CASE WHEN SUM(djs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(djs.total_revenue)/SUM(djs.impressions))*1000),0),2))) END as ".$val.',';
							else:
								$SQL .= " CASE WHEN SUM(djs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ((SUM(djs.total_revenue)/SUM(djs.impressions))*1000))) END as ".$val.',';
							endif;						
							break;
						case 'EPPM';
							if($dataTable==TRUE):
								$SQL .= " CASE WHEN SUM(djs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((((SUM(djs.total_revenue) - SUM(djs.publisher_earnings))/SUM(djs.impressions))*1000),0),2))) END as ".$val.',';
							else:
								$SQL .= " CASE WHEN SUM(djs.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM (((SUM(djs.total_revenue) - SUM(djs.publisher_earnings))/SUM(djs.impressions))*1000))) END as ".$val.',';
							endif;
							
							break;*/
						
						case 'FILL_RATE';
							$SQL .= " CASE WHEN SUM(djs.requests)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(djs.impressions)/SUM(djs.requests))*100),0),2))) END as ".$val.',';
							break;					
						
						case 'ACC_ID';
							if($search['account_type'] === 'ADVERTISER'){
								$SQL .= " (oxcl.account_id) as ".$val.',';
								$SQL .= " (oxcl.clientname) as ACC_NAME,";
							}
							else if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= " (oxaff.account_id) as ".$val.',';
								$SQL .= " (oxaff.name) as ACC_NAME,";
							}
							else if($search['account_type'] === 'ADMIN'){
								
								if($search['page']==='REPORT_ADVERTISER'){
									$SQL .= " (oxcl.account_id) as ".$val.',';
									$SQL .= " (oxcl.clientname) as ACC_NAME,";
									$SQL .= " (oxcl.dj_is_deleted) as DEL_STATUS,";
									#$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxcl.account_id ) as ACTIVE_STATUS,";
									
								}
								else if($search['page']==='REPORT_PUBLISHER')
								{
									$SQL .= " (oxaff.account_id) as ".$val.',';
									$SQL .= " (oxaff.name) as ACC_NAME,";
								}

							}
							break;		
						case 'ADV_ID';
							$SQL .= " (oxcl.account_id) as ".$val.',';
							$SQL .= " (oxcl.clientname) as CLIENT_NAME,";
							$SQL .= " (oxcl.dj_is_deleted) as ADV_DEL_STATUS,";
							//$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxcl.account_id ) as ADV_ACTIVE_STATUS,";
							break;
						case 'AFF_ID';
							$SQL .= " (oxaff.account_id) as ".$val.',';
							$SQL .= " (oxaff.name) as AFF_NAME,";
							$SQL .= " (oxaff.dj_is_deleted) as PUB_DEL_STATUS,";
							//$SQL .= " (SELECT active FROM rv_users WHERE default_account_id =oxaff.account_id ) as PUB_ACTIVE_STATUS,";
							break;
						
						case 'CAM_ID';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " (oxc.campaignid) as ".$val.',';
								$SQL .= " (oxc.campaignname) as CAM_NAME,";
								//$SQL .= " (oxcl.clientname) as ACC_NAME,";
								//$SQL .= " (oxz.zonename) as ZONE_NAME,";
							}
							break;
						case 'BAN_ID';
							if($search['account_type'] != 'TRAFFICKER'){
								$SQL .= " (oxb.bannerid) as ".$val.',';
								$SQL .= " (oxb.storagetype) as ST_TYPE,";
								$SQL .= " (oxb.dj_banner_type) as BAN_TYPE,";
								$SQL .= " (oxb.description) as BAN_NAME,";
								//$SQL .= " (oxcl.clientname) as ACC_NAME,";
								//$SQL .= " (oxz.zonename) as ZONE_NAME,";
							}
							
							break;
						case 'ENV';
							$SQL .= " (djs.delivery_media_type) as ".$val.",";
							break;
						case 'SITE_ID';
							$SQL .= " djs.sites_stat_id as ".$val.',';
							break;
						case 'SITE_URL';
							$SQL .= " djs.site_url as ".$val.',';
							break;
						case 'SITE_REFERRER';
							$SQL .= " djs.ad_id as BAN_ID, djs.site_referrer_url as ".$val.',';
							break;
						case 'DOMAIN';
							$SQL .= " djs.domain as ".$val.',';
							break;
						case 'COUNTRY';						
							$SQL .= " (SELECT name FROM djax_targ_country WHERE value=djs.country) as ".$val.",";
							$SQL .= " (djs.country) as country_code,";
							break;		
						case 'RTYPE';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " (dcrt.revenue_type) as ".$val.',';
								$SQL .= " (oxc.revenue_type) as revenue_type,";
							}
							break;
						case 'ADSIZE';
							if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
							}
							else
							{
								if($page==='REPORT_PUBLISHER')
								{
									$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
								}
								else
								{
									$SQL .= " CONCAT(oxb.width, 'x', oxb.height) as ".$val.',';
								}							
							}
							break;				
					}
				}
		  
				$SQL .= " DATE(djs.date_time) as date_time,IFNULL(SUM(djs.impressions),0) as impr,IFNULL(SUM(djs.clicks),0) as click,IFNULL(SUM(djs.conversions),0) as conv,IFNULL(SUM(djs.requests),0) as req ";		
				//REMOVE comma at End of the string
			
				$SQL = rtrim($SQL, ",");
				
				$SQL .= " FROM	djax_sites_stats as djs	";
				
				if(is_array($search) AND count($search) > 0 AND array_key_exists('account_id',$search) AND $search['account_id'] != ''){
				
					if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
						$creativeid	=	implode(',',$search['creative_id']);
						$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=djs.ad_id AND oxb.bannerid IN (".$creativeid.") )";
					}
					else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
						$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=djs.ad_id AND oxb.bannerid='".$search['creative_id']."')";
					}
					else
					{
						$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=djs.ad_id";
					}
					
					if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
						
						if(in_array('custom',$search['adsize']))
						{
							$si	=	array();
							foreach($search['adsize'] as $siz):
								if($siz!='custom')
								{
									$si[]	=	$siz;
								}
							endforeach;
							if(!empty($si)):	
								$size	=	implode("','",$si);												
								$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
							endif;
						}
						else
						{
							$size	=	implode("','",$search['adsize']);												
							$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
						}
					}
					else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
						$size	=	explode('x',$search['adsize']);
						$SQL .= " AND oxb.width=".$size[0]." AND oxb.height=".$size[1]." ";
					}			
					
					if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
						$campid	=	implode(',',$search['campaign_id']);
						$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
					}
					else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
						$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
					}
					else
					{
						$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";						
					}
							
					if(isset($search['revenue_type']) AND $search['revenue_type']!='' AND is_array($search['revenue_type'])){
						$camp_type	=	implode(',',$search['revenue_type']);
						$SQL .= " AND oxc.revenue_type IN (".$camp_type.") ";
					}
					else if(isset($search['revenue_type']) AND $search['revenue_type'] != '' AND !is_array($search['revenue_type'])){
						$SQL .= " AND oxc.revenue_type='".$search['revenue_type']." ";
					}
					
					$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
					
					$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['account_id'].") ";					
					
					$SQL .= " LEFT JOIN (SELECT dgs.ad_id,dgs.browser_name,dgs.browser_language,dgs.country,dgs.country_code FROM djax_geographical_stats as dgs WHERE dgs.browser_name IS NOT NULL GROUP BY dgs.ad_id) as temm ON temm.ad_id=djs.ad_id
					LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=oxc.campaignid
					JOIN rv_zones as oxz ON oxz.zoneid=djs.zone_id ";
				}
				
				$SQL .= "  WHERE 1 AND djs.site_url!='' ";
				
							
				if(is_array($search) AND count($search) > 0){
					
					if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
						$country	=	implode("','",$search['country']);
						$SQL .= " AND djs.country IN ('".$country."') ";
					}
					else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
						$SQL .= " AND djs.country = '".$search['country']." ";
					}	
					
					if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
						$SQL .= " AND (DATE(djs.date_time)  >= '".$search['date_from']."' AND DATE(djs.date_time) <= '".$search['date_to']."')";
					}
					else if(isset($search['date_from']) AND $search['date_from'] != ''){
						$SQL .= " AND DATE(djs.date_time) = '".$search['date_from']."'";
					}
					
					if(isset($search['environment']) AND $search['environment'] != ''){
						$SQL .= " AND delivery_media_type='".$search['environment']."'";
					}
					
					if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
							$SQL .= " AND (";
							foreach($search['search_fields'] as $sObj){
								$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
							}
						
							$SQL = rtrim($SQL, "OR");
						
							$SQL .= " )";
						
					}
					
				}
				
				if(is_array($group) AND count($group) > 0){
				
					$SQL .= " GROUP BY ";
					
					foreach($group as $val){
						switch($val){
							case 'DATE';
							case 'TIME';
								$SQL .= " {$date_field} ,";
								break;
							case 'MONTH';						
								$SQL .= " MONTHNAME({$date_field}) ,";
								break;					
							case 'HOUR';
								$SQL .= " DATE_FORMAT(djs.date_time,'%d-%m-%Y'), TIME(djs.date_time) ,";
								break;
							case 'RTYPE';
								$SQL .= "oxc.revenue_type,";
								break;
							case 'ADSIZE';
								if($search['account_type'] === 'TRAFFICKER'){
									$SQL .= "oxz.width,oxz.height,";
								}
								else
								{
									if($page==='REPORT_PUBLISHER')
									{
										$SQL .= "oxz.width,oxz.height,";
									}
									else
									{
										$SQL .= "oxb.width,oxb.height,";
									}
								}
								break;			
						
							case 'ACC_ID';
								if($search['account_type'] === 'ADVERTISER'){
									$SQL .= "oxcl.account_id,";
								}
								else if($search['account_type'] === 'TRAFFICKER'){
									$SQL .= "oxaff.account_id,";
								}
								else if($search['account_type'] === 'ADMIN'){
									
									if($search['page']==='REPORT_ADVERTISER'){
										$SQL .= "oxcl.account_id,";
									}
									else if($search['page']==='REPORT_PUBLISHER')
									{
										$SQL .= "oxaff.account_id,";
									}
								}
								break;
							case 'ADV_ID';							
								$SQL .= "oxcl.account_id,";
								break;	
							case 'CAM_ID';
								$SQL .= "oxc.campaignid,";
								break;
							case 'BAN_ID';
								$SQL .= "oxb.bannerid,";
								break;						
							case 'ENV';
								$SQL .= "djs.delivery_media_type,";
								break;
							case 'SITE_URL';							
								$SQL .= "djs.site_url,";
								break;
							case 'DOMAIN';							
								$SQL .= "djs.domain,";
								break;
							case 'SITE_REFERRER';							
								$SQL .= "djs.site_referrer_url,";
								break;
							case 'COUNTRY';
								$SQL .= "djs.country,";
								break;
							case 'BROWSER';
								$SQL .= "temm.browser_name,";
								break;		
							case 'LANGUAGE';
								$SQL .= "temm.browser_language,";
								break;									
						}
					}
					
				}
				
				$SQL = rtrim($SQL, ",");			
				
				$da		=	array('DATE','TIME','HOUR','MONTH');
				
				if(is_array($order) AND count($order) > 0){
					
					$of	=	0;
					
					foreach($order as $key=>$option){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY djs.date_time {$option} ";
					}
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				elseif((!is_array($order)) && $order!='')
				{
					$ord	=	explode(',', $order);
					
					$of	=	0;
					
					foreach($ord as $key){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY djs.date_time ASC ";
					}
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				
				/*if(is_array($order) AND count($order) > 0){
					
					$SQL .= " ORDER BY ";
					
					foreach($order as $key=>$option){
						$SQL .= " {$key} {$option},";				
					}
				
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				
				if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
					
					$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
				}
				else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
					$SQL .=	 " LIMIT ".$limit['end']."";
				}*/
				
			}
			
			$SQL .= " ) as r WHERE r.impr>0 OR r.click>0 OR r.conv>0 OR r.req>0 ";
			
			if(is_array($order) AND count($order) > 0){
				
				$OSQL	=	'';
				foreach($order as $key=>$option){
					if($key != 'BROWSER' && $key != 'LANGUAGE')
					{					
					$OSQL .= " {$key} {$option},";
					}
				}
				$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";		
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				$OSQL	=	'';
				
				foreach($ord as $key){
					if($key != 'BROWSER' && $key != 'LANGUAGE')
					{
					$OSQL .= " {$key} ASC,";
					}
				}
				
				$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";			
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}	
			
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
					
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			
			//echo $SQL;
			//exit;
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			
			   
			if($dataTable){
			
				$data = $query->result_array();
				
				if($data)
				{			
					
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$data,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $data;
					}
					
				}
				else
				{
					return FALSE;
				} 
			}
			else
			{
				$fields = $query->list_fields(); 
				
				$data = $query->result_array();
				$res['fields'] = $fields;
				$res['records'] = $data; 
				
				if($data)
				{			
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$res,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $res;
					}
				}
				else
				{
					return FALSE;
				} 
			}
		 }
		 
	}

	 
	function fetch_video($columns,$search,$group,$order,$limit,$dataTable=FALSE)
	{
		
		$key = 	'fetch_video_report_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$dataTable;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		
		
			if(is_array($group) AND in_array('DATE',$group)){
				if(isset($search['timezone']) AND $search ['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(vid.date,'+00:00','".$search['timezone']."'),'%d-%m-%Y')";
				}
				else
				{
					$date_field = "DATE_FORMAT(vid.date,'%d-%m-%Y')";
				}
			}
			else if(is_array($group) AND in_array('TIME',$group))
			{
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "TIME(CONVERT_TZ(vid.date,'+00:00','".$search['timezone']."'))";
				}
				else
				{
					$date_field = "TIME(vid.date)";
				}	
			}
			else if(is_array($group) AND in_array('MONTH',$group)){
				if(isset($search['timezone']) AND $search['timezone'] != '')
				{
					$date_field = "DATE_FORMAT(CONVERT_TZ(vid.date,'+00:00','".$search['timezone']."'),'%b %Y')";
				}
				else
				{
					$date_field = "DATE_FORMAT(vid.date,'%b %Y')";
				}			
			}
			
			/*
				DATE
				IMP
				CLK
				UIMP // !Publisher
				UCLK // !Publisher
				CON
				SPEND // !Publisher
				PUB_EARN // ! Advertiser
				ADM_EARN // ! Advertiser & !Publisher
				CTR // !Publisher
				ECPM // !Publisher
				PUB_ECPM // !advertiser
				CAM_ID
				CAM_NAME
				BAN_ID
				BAN_NAME
				ACC_ID
				SITE_ID
				ZONE_ID
				
			*/
			
			
			$SQL = "SELECT vid.date as DATE,oxz.zonename as ZONE,temm.browser_name as BROWSER,temm.browser_language as LANGUAGE,dcts.traffic_id as TRAFFIC,vid.date as TIME_DATE, ";
		 
			if(is_array($columns) AND count($columns) > 0){
				foreach($columns as $val){
					
					switch(strtoupper($val)){
						case 'DATE';
							$SQL .= " {$date_field} as ".$val.',';
							break;
						case 'TIME_DATE';
							$SQL .= " vid.date as TIME_DATES, ";
							break;							
						case 'START';
							$SQL .= " IFNULL(SUM(vid.Started),0) as ".$val.',';
							break;
						case 'FQ';
							$SQL .= " IFNULL(SUM(vid.firstQuartile),0) as ".$val.',';
							break;
						case 'MP';
							$SQL .= " IFNULL(SUM(vid.midpoint),0) as ".$val.',';
							break;
						case 'TQ';
							$SQL .= " IFNULL(SUM(vid.thirdQuartile),0) as ".$val.',';
							break;
						case 'COMP';
							$SQL .= " IFNULL(SUM(vid.Completed),0) as ".$val.',';
							break;
						case 'PAUSED';
							$SQL .= " IFNULL(SUM(vid.Paused),0) as ".$val.',';
							break;
						case 'PTP';
							$SQL .= " IFNULL(SUM(vid.PausetoPlay),0) as ".$val.',';
							break;
						case 'MUTE';
							$SQL .= " IFNULL(SUM(vid.Muted) ,0)as ".$val.',';
							break;
						case 'UNMUTE';
							$SQL .= " IFNULL(SUM(vid.Unmute),0) as ".$val.',';
							break;
						case 'FS';
							$SQL .= " IFNULL(SUM(vid.Fullscreen),0) as ".$val.',';
							break;
						case 'CVIEW';
							$SQL .= " IFNULL(SUM(vid.creativeView),0) as ".$val.',';
							break;
						case 'EXPAND';
							$SQL .= " IFNULL(SUM(vid.Expand),0) as ".$val.',';
							break;
						case 'COLLAPSE';
							$SQL .= " IFNULL(SUM(vid.Collapse),0) as ".$val.',';
							break;
						case 'AINVITE';
							$SQL .= " IFNULL(SUM(vid.acceptInvitation),0) as ".$val.',';
							break;
						case 'CLOSE';
							$SQL .= " IFNULL(SUM(vid.Close),0) as ".$val.',';
							break;
						case 'PROGRESS';
							$SQL .= " IFNULL(SUM(vid.Progress),0) as ".$val.',';
							break;
						case 'SKIP';
							$SQL .= " IFNULL(SUM(vid.Skip),0) as ".$val.',';
							break;
						case 'CLINEAR';
							$SQL .= " IFNULL(SUM(vid.closeLinear),0) as ".$val.',';
							break;
						case 'EFS';
							$SQL .= " IFNULL(SUM(vid.exitfullscreen),0) as ".$val.',';
							break;
						case 'AINVITELINEAR';
							$SQL .= " IFNULL(SUM(vid.acceptInvitationLinear),0) as ".$val.',';
							break;
						case 'REWIND';
							$SQL .= " IFNULL(SUM(vid.Rewind),0) as ".$val.',';
						case 'BAN_ID';
							$SQL .= " vid.creative_id as ".$val.',';
							$SQL .= " (oxb.description) as BAN_NAME,";
							break;
						case 'CAM_ID';
							if($search['account_type'] !== 'TRAFFICKER'){
								$SQL .= " (oxc.campaignid) as ".$val.',';
								$SQL .= " (oxc.campaignname) as CAM_NAME,";
							}
							break;
						case 'HOUR';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{							
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(CONVERT_TZ(vid.date,'+00:00','".$search['timezone']."'),'%d-%m-%Y') as DATE , ";
								}
								$SQL .= " TIME(CONVERT_TZ(vid.date,'+00:00','".$search['timezone']."')) as ".$val.',';
							}
							else
							{
								if(is_array($columns) AND !in_array('DATE',$columns))
								{
									$SQL .= " DATE_FORMAT(vid.date,'%d-%m-%Y') as DATE ,";
								}
								$SQL .= " TIME(vid.date) as ".$val.',';
							}						
							break;
						case 'MONTH';
							if(isset($search['timezone']) AND $search['timezone'] != '')
							{
								$SQL .= " DATE_FORMAT(CONVERT_TZ(vid.date,'+00:00','".$search['timezone']."'),'%b %Y') as ".$val.',';
							}
							else
							{
								$SQL .= " DATE_FORMAT(vid.date,'%b %Y') as ".$val.',';
							}
							break;
					}
				}
					
				//REMOVE comma at End of the string
			
				$SQL = rtrim($SQL, ",");
				
				$SQL .= " FROM
							(
								SELECT
									DATE(vas.interval_start) AS date,
									vas.creative_id,
									CASE WHEN vast_event_name = 'Started' THEN vas.count END AS Started,
									CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
									CASE WHEN vast_event_name = 'firstQuartile' THEN vas.count END AS firstQuartile,
									CASE WHEN vast_event_name = 'thirdQuartile' THEN vas.count END AS thirdQuartile,
									CASE WHEN vast_event_name = 'Completed' THEN vas.count END AS Completed, 
									CASE WHEN vast_event_name = 'Muted' THEN vas.count END AS Muted,
									CASE WHEN vast_event_name = 'Fullscreen' THEN vas.count END AS Fullscreen,
									CASE WHEN vast_event_name = 'Unmute' THEN vas.count END AS Unmute,
									CASE WHEN vast_event_name = 'PausetoPlay' THEN vas.count END AS PausetoPlay,
									CASE WHEN vast_event_name = 'Paused' THEN vas.count END AS Paused,
									CASE WHEN vast_event_name = 'creativeView' THEN vas.count END AS creativeView,
									CASE WHEN vast_event_name = 'Expand' THEN vas.count END AS Expand,
									CASE WHEN vast_event_name = 'Collapse' THEN vas.count END AS Collapse,
									CASE WHEN vast_event_name = 'acceptInvitation' THEN vas.count END AS acceptInvitation,
									CASE WHEN vast_event_name = 'Close' THEN vas.count END AS Close,
									CASE WHEN vast_event_name = 'Progress' THEN vas.count END AS Progress,
									CASE WHEN vast_event_name = 'Skip' THEN vas.count END AS Skip,
									CASE WHEN vast_event_name = 'closeLinear' THEN vas.count END AS closeLinear,
									CASE WHEN vast_event_name = 'exitfullscreen' THEN vas.count END AS exitfullscreen,
									CASE WHEN vast_event_name = 'acceptInvitationLinear' THEN vas.count END AS acceptInvitationLinear,
									CASE WHEN vast_event_name = 'Rewind' THEN vas.count END AS Rewind
								  FROM 
									djax_banner_vast_events
								  JOIN 
								  (
										SELECT vast.interval_start, vast.creative_id, vast.zone_id, vast.vast_event_id, SUM(vast.count) as count
										FROM
										(
											SELECT 
												rv_stats_vast.interval_start, 
												rv_stats_vast.creative_id, 
												rv_stats_vast.zone_id, 
												rv_stats_vast.vast_event_id, 
												rv_stats_vast.count 
											FROM rv_stats_vast 
											JOIN  djax_banner_vast_events 
											ON djax_banner_vast_events.vast_event_id=rv_stats_vast.vast_event_id 
											GROUP BY 
												rv_stats_vast.vast_event_id,rv_stats_vast.zone_id,rv_stats_vast.creative_id,rv_stats_vast.interval_start
										) AS vast
										GROUP BY vast_event_id, zone_id, creative_id, interval_start
										ORDER BY interval_start, creative_id, zone_id
								  ) AS vas ON vas.vast_event_id=djax_banner_vast_events.vast_event_id) AS vid ";
				
				if(is_array($search) AND count($search) > 0 AND array_key_exists('account_id',$search) AND $search['account_id'] != ''){
				
				
					if($search['account_type'] === "ADVERTISER"){
					
						if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
							$creativeid	=	implode(',',$search['creative_id']);
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=vid.creative_id AND oxb.bannerid IN (".$creativeid.") )";
						}
						else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=vid.creative_id AND oxb.bannerid='".$search['creative_id']."')";
						}
						else
						{
							$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=vid.creative_id";
						}
						
						if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
							$campid	=	implode(',',$search['campaign_id']);
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
						}
						else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";						
						}
						
						$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['account_id'];
						if(isset($search['agency_id']) AND $search['agency_id'] != '' AND !is_array($search['agency_id'])){
							$SQL	.=	" AND oxcl.agencyid=".$search['agency_id'];
						}
					}	$SQL	.=	" )";
				}			
				
				$SQL .= "  LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=oxc.campaignid

LEFT JOIN (SELECT dgs.ad_id,dgs.zone_id,dgs.browser_name,dgs.browser_language FROM djax_geographical_stats as dgs WHERE dgs.browser_name IS NOT NULL GROUP BY dgs.ad_id) as temm ON temm.ad_id=oxb.bannerid 

JOIN rv_zones as oxz ON oxz.zoneid=temm.zone_id  WHERE 1";
				
							
				if(is_array($search) AND count($search) > 0){
					
					if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
						$SQL .= " AND (DATE(vid.date)  >= '".$search['date_from']."' AND DATE(vid.date) <= '".$search['date_to']."')";
					}
					else if(isset($search['date_from']) AND $search['date_from'] != ''){
						$SQL .= " AND DATE(vid.date) = '".$search['date_from']."'";
					}				
				}
				
				if(!is_array($group))
				{
					$group = explode(",",$group);
				}
								
				if(is_array($group) AND count($group) > 0){
				
					$SQL .= " GROUP BY ";
					
					foreach($group as $val){
						switch($val){
							case 'DATE';
							case 'TIME';
								$SQL .= " {$date_field} ,";
								break;
							case 'MONTH';						
								$SQL .= " MONTHNAME({$date_field}) ,";
								break;					
							case 'HOUR';
								$SQL .= " DATE_FORMAT(vid.date,'%d-%m-%Y'), TIME(vid.date) ,";
								break;						
							case 'CAM_ID';
								$SQL .= "oxc.campaignid,";
								break;
							case 'BAN_ID';
								$SQL .= "oxb.bannerid,";
								break;					
							case 'TRAFFIC';
								$SQL .= " dcts.traffic_id ,";
								break;						
							case 'BROWSER';
								$SQL .= "temm.browser_name,";
								break;
							case 'LANGUAGE';
								$SQL .= "temm.browser_language,";
								break;					
							/*case 'ENV';
								$SQL .= "vid.delivery_media_type,";
								break;*/
						}
					}
					
				}
				
				$SQL = rtrim($SQL, ",");
				
				$da		=	array('DATE','TIME','HOUR','MONTH');
				
				if(is_array($order) AND count($order) > 0){
					
					$of	=	0;
					
					foreach($order as $key=>$option){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY vid.date {$option} ";
					}
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				elseif((!is_array($order)) && $order!='')
				{
					$ord	=	explode(',', $order);
					
					$of	=	0;
					
					foreach($ord as $key){
						if(in_array($key,$da))
						{
							$of	=	1;	
						}			
					}
					
					if($of==1)
					{
						$SQL .= " ORDER BY vid.date ASC ";
					}
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}
				
				/*if(is_array($order) AND count($order) > 0){
					
					$SQL .= " ORDER BY ";
					
					foreach($order as $key=>$option){
						$SQL .= " {$key} {$option},";				
					}
				
					//REMOVE comma at End of the string
			
					$SQL = rtrim($SQL, ",");
				}*/			
				
				
				if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
					
					$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
				}
				else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
					$SQL .=	 " LIMIT ".$limit['end']."";
				}
				
			}
			
			$query = $this->db->query($SQL);
			
			//echo $this->db->last_query();exit;

			if($dataTable){
				$data = $query->result_array();
				if($data)
				{			
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$data,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $data;
					}
				}
				else
				{
					return FALSE;
				} 
			}
			else
			{
				$fields = $query->list_fields(); 
				
				$data = $query->result_array();
				$res['fields'] = $fields;
				$res['records'] = $data; 
				
				if($data)
				{			
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$res,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
					return $res;
					}
				}
				else
				{
					return FALSE;
				} 
			}
		}		 
		 
	}
	 
	 /*
	 * 
	 * name: fetch_active_campaign_count
	 * @param :
	 * @return : $result
	 * 
	 * count of active campaign of an advertiser
	 */
	 
	 function active_campaign_count($account_id=false)
	 {
		 $key = 'active_campaign_count_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		 
		 
		    $SQL = "SELECT  count(*) as count
			FROM (".TAB_CAMPAIGNS." as oxc) 
			JOIN ".TAB_CLIENTS." as oxcl ON `oxcl`.`clientid`=`oxc`.`clientid` 
			 WHERE oxc.status=0";
			 if($account_id!=false)
			 {
				$SQL.=" AND `oxcl`.`account_id`= ".$account_id.""; 
			 }
			$query=$this->db->query($SQL); 		
			$count_result	=	$query->result_array();
			
			if($count_result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$count_result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $count_result;
				}
			}
			else
				return FALSE;
	 }
	 
}
	 function complete_campaign_count($account_id=false)
	 {
		 
		  $key = 'complete_campaign_count'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		    $SQL = "SELECT  count(*) as count
			FROM (".TAB_CAMPAIGNS." as oxc) 
			JOIN ".TAB_CLIENTS." as oxcl ON `oxcl`.`clientid`=`oxc`.`clientid` 
			WHERE oxc.status=3";
			if($account_id!=false)
			{
				$SQL.=" AND `oxcl`.`account_id`= ".$account_id."";
			}
			
			$query=$this->db->query($SQL); 		
			$count_result	=	$query->result_array();
			
			if($count_result)
			{
					if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$count_result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $count_result;
				}
				
				
			}
			else
				return FALSE;
	 }
	 
}
	
	 
	 /*
	 * 
	 * name: fetch_campaign
	 * @param :
	 * @return : $result
	 * 
	 * Lists a campaign of an advertiser
	 */
	 function fetch_campaign($account_id,$campaign_type=false,$agency_id=FALSE,$admarket=FALSE)
	 {		 
		$key = 'fetch_campaign_report_'.$account_id;
		
		if(!empty($campaign_type))
		{
			$key.='_'.$campaign_type;
		}
		if(!empty($agency_id))
		{
			$key.='_'.$agency_id;
		}
		if(!empty($admarket))
		{
			$key.='_'.$admarket;
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
	 	$this->db->select('oxc.campaignid, oxc.campaignname');
		$this->db->join(TAB_CLIENTS.' as oxcl', 'oxcl.clientid=oxc.clientid')	;	
		//$this->db->where('oxc.dj_is_deleted ','0');
		
		if($agency_id)
		{
			$this->db->where('oxcl.agencyid', $agency_id);
		}
		
		if($account_id)
		{
			$this->db->where('oxcl.account_id', $account_id);
		}
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
				$adv	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('oxcl.account_id',$adv);
			endif;
		}
		
		if($admarket)
		{
			$this->db->where('dj_is_admarket',$admarket);  
		}
		
		if($campaign_type)
		$this->db->where('oxc.dj_targetting_type', $campaign_type);		
		$this->db->order_by('oxc.dj_added_date ');
		$query = $this->db->get(TAB_CAMPAIGNS.' as oxc');
		$result = $query->result_array();		
		
		if($result)
		{
		if($mem_cache=='enable' )
		{  
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else  
			return $result;
		}
		else
			return FALSE;
	}
	
}

		/*
	 * 
	 * name: fetch_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Get the video creative from the database
	 */
	
	function fetch_video_creatives($account_id)
	{	
		
		$key = 'fetch_video_creatives_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		if($account_id)
		{	
			/*Get records from rv_banner_vast_element */
			$this->db->where('dj_account_id',$account_id);
			$this->db->where_in('dj_banner_type',array(VIDEO_CREATIVE_OVERLAY,VIDEO_CREATIVE_INLINE));
			$query	=	$this->db->get(TAB_BANNERS);
			$result	=	$query->result_array();
			//echo $this->db->last_query();
			if($result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
				return FALSE;
		}
		else
			return FALSE;
	
	}
	
}
	 
	
	 /*
	 * 
	 * name: fetch_site
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all sites for the report
	 */
	 function fetch_sites($data=FALSE,$siteid=FALSE)
	 {
		$key = 'fetch_sites';
		 
		if($data['account_id']!=FALSE) 
		{
		$key.='_'.$data['account_id'];
		}
		if($siteid!=FALSE)
		{
		$key.='_'.$siteid;
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		if(!empty($data['account_id']) && isset($data['account_id'])){
			$account_id = $data['account_id'];
			$this->db->where('sites.account_id',$account_id);
		}
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('sites.account_id',$pub);
			endif;
		}
		if(!empty($siteid))
		{
			$this->db->where('sites.site_id',$siteid);
		}
		
		$this->db->select('sites.site_id,sites.account_id,sites.site_name,sites.site_url');		
		$this->db->order_by('added_date');
		
		if(!empty($data['agency_id']))
		{
			$this->db->where('oxa.agencyid',$data['agency_id']);
		}
		
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.account_id=sites.account_id');
		
		$query = $this->db->get(TAB_PUB_SITES.' as sites');		
		
		
		
		$result = $query->result_array();
			
		if($result)
		{			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		}

		
	 }
	 
}




 /*
	 * 
	 * name: fetch_apps
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all apps for the report
	 */
	 function fetch_apps($data=FALSE,$appid=FALSE){
		 
		$key = 'fetch_apps';		
		if($data['account_id']!=FALSE)
		{
			$key.='_'.$data['account_id'];
		}
		if($appid!=FALSE)
		{
			$key.='_'.$appid;
		}		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		if(!empty($data['account_id']) && isset($data['account_id'])){
			$account_id = $data['account_id'];
			$this->db->where('sites.account_id',$account_id);
		}
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('sites.account_id',$pub);
			endif;
		}
		if(!empty($appid))
		{
			$this->db->where('sites.id',$appid);
		}
		
		$this->db->select('sites.id,sites.account_id,sites.app_name,sites.app_url');		
		$this->db->order_by('added_date');
		
		if(!empty($data['agency_id']))
		{
			$this->db->where('oxa.agencyid',$data['agency_id']);
		}
		
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.account_id=sites.account_id');
		
		$query = $this->db->get(TAB_TEMP_URL.' as sites');				
		
		$result = $query->result_array();
			
		if($result)
		{			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
		{
			return FALSE;
		}
		}
	 }



	/*
	 * 
	 * name: fetch_advertiser
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all advertisers for the report
	 */


	function fetch_advertiser($network_id=FALSE,$network_account_id=FALSE,$account_id=FALSE)
	{
		$key = 'fetch_advertiser_report';
		if(!empty($network_id))
		{
			$key.='_'.$network_id;
		}
		if(!empty($network_account_id))
		{
			$key.='_'.$network_account_id;
		}
		if(!empty($account_id))
		{
			$key.='_'.$account_id;
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		if($account_id!=FALSE)
		{
			$this->db->where('oxa.account_id',$account_id);
		}
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
				$adv	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('oxa.account_id',$adv);
			endif;
		}
		
		if($network_account_id !=FALSE)
		{
			$where	=	array(
								'dnm.network_account_id'	=>	$network_account_id,
								'dnm.manager_account_id'	=>	$network_id,
								'dnm.is_deleted'			=>	0,
								'oxcl.dj_is_deleted'		=>	0
							);
		}
		else
		{
			$where	=	array(
								'dnm.network_account_id'	=>	$network_id,
								'dnm.default_manager'		=>	1,
								'dnm.is_deleted'			=>	0,
								'oxcl.dj_is_deleted'		=>	0
							);				
		}
		
		$this->db->select(	'COUNT(oxca.clientid) as camp_count,
							SUM(oxds.dj_total_revenue) as spend_amount,
							oxcl.clientid,
							oxcl.agencyid as agencyid,
							oxcl.clientname as name,
							oxcl.email,
							oxcl.dj_first_name as first_name,
							oxcl.dj_last_name as last_name,
							oxcl.dj_is_denied as status,
							oxa.account_id as account_id,
							oxa.account_type as account_type'
							);
		$this->db->from(TAB_USERS.' as oxu');
		$this->db->join(TAB_ACCOUNTS.' as oxa','oxa.account_id=oxu.default_account_id');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.account_id=oxa.account_id');
		$this->db->join(TAB_NWK_MANAGERS.' as dnm','dnm.agency_id=oxcl.agencyid');
		$this->db->join(TAB_CAMPAIGNS.' as oxca','oxca.clientid=oxcl.clientid AND oxca.dj_is_deleted="0"','left');
		$this->db->join(TAB_BANNERS.' as oxb','oxb.campaignid=oxca.campaignid AND oxb.dj_is_deleted="0"','left');
		$this->db->join(TAB_DATA_SUM_AD_HOURLY.' as oxds','oxds.ad_id=oxb.bannerid','left');
		$this->db->where($where);	
		$this->db->group_by('oxa.account_id');
		$this->db->order_by('oxa.account_id','desc');
		$query = $this->db->get();
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
		}else{
			return FALSE;	
		}	
	}
}
	/*
	 * 
	 * name: fetch_publisher
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all publishers for the report
	 */


	function fetch_publisher($network_id=FALSE,$network_account_id=FALSE,$account_id=FALSE)
	{
		
		$key = 'fetch_publisher_report';
		if(!empty($network_id))
		{
			$key.='_'.$network_id;
		}
		if(!empty($network_account_id))
		{
			$key.='_'.$network_account_id;
		}
		if(!empty($account_id))
		{
			$key.='_'.$account_id;
		}
				
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		$SQL = "SELECT  site_count, COALESCE(ROUND(SUM(oxds.dj_publisher_earnings),2),0) as earning, `oxaf`.`affiliateid`, `oxaf`.`agencyid`, `oxaf`.`name`, `oxaf`.`email`, `oxaf`.`website`, `oxaf`.`dj_first_name` as first_name, `oxaf`.`dj_last_name` as last_name, `oxaf`.`dj_is_denied` as status, `oxaf`.`account_id` as account_id
			FROM (".TAB_USERS." as oxu) 
			JOIN ".TAB_AFFILIATE." as oxaf ON `oxaf`.`account_id`=`oxu`.`default_account_id` 
			JOIN ".TAB_NWK_MANAGERS." as dnm ON `dnm`.`agency_id`=`oxaf`.`agencyid` 
			LEFT JOIN (SELECT dps.account_id,count(*) as site_count FROM ".TAB_PUB_SITES." as dps WHERE dps.is_deleted='0' GROUP BY dps.account_id) m ON `m`.`account_id`=`oxaf`.`account_id` 
			LEFT JOIN ".TAB_ZONES." as oxz ON `oxz`.`affiliateid`=`oxaf`.`affiliateid` 
			LEFT JOIN ".TAB_DATA_SUM_AD_HOURLY." as oxds ON `oxds`.`zone_id`=`oxz`.`zoneid`";
			
		$SQL .= " WHERE dnm.is_deleted =0";	
		if($network_account_id)
		{
			$SQL .= " AND dnm.network_account_id= ".$network_account_id." AND dnm.manager_account_id = ".$network_id."";	
			//$SQL .= " AND dnm.network_account_id= ".$network_account_id." AND dnm.manager_account_id = 2 ";	
		}else{
			$SQL .= " AND dnm.network_account_id= ".$network_id." AND dnm.default_manager = 1";	
		}
		
		if($account_id)
		{
			$SQL .= " AND oxaf.account_id= ".$account_id."";	
		}	
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$SQL	.=" AND oxaf.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
			endif;
		}
		
		$SQL .= " GROUP BY `oxaf`.`account_id` ORDER BY `oxaf`.`account_id` DESC";
		
		$query = $this->db->query($SQL);
		
		
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
		}else{
				return FALSE;	
		}	
	}
}
	
	function fetch_publisher_traffic_source($network_id=FALSE,$network_account_id=FALSE,$account_id=FALSE)
	{
		
		$key = 'fetch_publisher_traffic_source';		
		if(!empty($network_id))
		{
			$key.='_'.$network_id;
		}
		if(!empty($network_account_id))
		{
			$key.='_'.$network_account_id;
		}
		if(!empty($account_id))
		{
			$key.='_'.$account_id;
		}
				
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($vet && $mem_cache=='enable' )
		{
			return $vet;
		}
		else{
		
		$sql = "SELECT DISTINCT `account_id`
				FROM `rv_affiliates` where `account_id`!='' 
				and `dj_is_deleted`!='1' 
				and `dj_is_denied` !='1'";
		 
		$query = $this->db->query($sql);
		
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$det = $this->memcached_library->get($key);	
		return $det;
		}
		else{
		return $result;
		}
				
		}else{
				return FALSE;	
		}	
		
	}
}
	
	function fetch_adblocks_site($account_id=FALSE,$agency_id=FALSE,$adblock_id=FALSE)
	{		 
		 
		$key = 'fetch_adblocks_site';
		
		if(!empty($account_id))
		{
			$key.='_'.$account_id;
		}
		if(!empty($agency_id))
		{
			$key.='_'.$agency_id;
		}
		if(!empty($adblock_id))
		{
			$key.='_'.$adblock_id;
		}
				
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		 
	 	$this->db->select('oxps.site_id, oxps.site_name');
		$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz', 'oxsz.zone_id=oxz.zoneid');	
		$this->db->join(TAB_PUB_SITES.' as oxps', 'oxps.site_id=oxsz.site_id');	
		$this->db->join(TAB_AFFILIATE.' as oxa', 'oxa.account_id=oxps.account_id');	
		
		if($agency_id)
		{
			$this->db->where('oxa.agencyid', $agency_id);
		}
		
		if($account_id)
		{
			$this->db->where('oxa.account_id', $account_id);
		}
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('oxa.account_id',$pub);
			endif;
		}
				
		if($adblock_id)
		{
			$this->db->where('oxz.zoneid', $adblock_id);
		}
		
		$this->db->where('oxz.dj_is_deleted','0');
		
		$this->db->order_by('oxz.dj_added_date','desc');
		$query 	= 	$this->db->get(TAB_ZONES.' as oxz');	
		
		$result = 	$query->result_array();
		if($result)
		{
			
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
		}
		else
			return FALSE;
	}
	
}
	
	
	
	/*
	 * 
	 * name: fetch_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Lists a campaign of an advertiser
	 */
	 function fetch_adblocks($account_id=FALSE,$site_id=FALSE,$agency_id=FALSE,$adblock_id=FALSE)
	 {
		$key = 'fetch_adblocks_report';
		
		if(!empty($account_id))
		{
			$key.='_'.$account_id;
		}
		if(!empty($site_id))
		{
			$key.='_'.$site_id;
		}
		if(!empty($agency_id))
		{
			$key.='_'.$agency_id;
		}
		if(!empty($adblock_id))
		{
			$key.='_'.$adblock_id;
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	 	$this->db->select('oxz.zoneid, oxz.zonename');
		$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz', 'oxsz.zone_id=oxz.zoneid');	
		$this->db->join(TAB_PUB_SITES.' as oxps', 'oxps.site_id=oxsz.site_id');	
		$this->db->join(TAB_AFFILIATE.' as oxa', 'oxa.account_id=oxps.account_id');	
		
		if($agency_id)
		{
			$this->db->where('oxa.agencyid', $agency_id);
		}
		
		if($account_id)
		{
			$this->db->where('oxa.account_id', $account_id);
		}
		else
		{
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('oxa.account_id',$pub);
			endif;
		}
		
		if($site_id)
		{
			$this->db->where('oxps.site_id', $site_id);
		}
		if($adblock_id)
		{
			$this->db->where('oxz.zoneid', $adblock_id);
		}
		
		$this->db->where('oxz.dj_is_deleted','0');
		
		//$this->db->order_by('oxz.dj_added_date','desc');
		$this->db->order_by('oxz.zonename','asc');
		$query 	= 	$this->db->get(TAB_ZONES.' as oxz');		
		
		$result = 	$query->result_array();
		if($result)
		{
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
		}
		else
			return FALSE;
	}
	
}

	
	/*
	 * 
	 * name: fetch_creatives
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Get all the creative from the database
	 */
	
	function fetch_creatives($account_id=false)
	{
		$key = 'fetch_creatives';
		if($account_id!=FALSE)
		{
			$key.='_'.$account_id;
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		$this->db->join(TAB_CAMPAIGNS.' as oxc', 'oxc.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl', 'oxcl.clientid=oxc.clientid');	
		//$this->db->where('oxc.dj_is_deleted ','0');
		
		if($account_id)
		{
			$this->db->where('oxcl.account_id', $account_id);
		}
		$this->db->limit('100');
		$query	=	$this->db->get(TAB_BANNERS.' as oxb');
		//	return $this->db->last_query();
		$result = 	$query->result_array();
		//	return $result;
		if($result)
			{
				
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
				}
			else
			return FALSE;
	
		}
	
	}
	
	function fetch_request_report($search=FALSE)
	{	
		$key = 'fetch_request_report';
		
		if($search!=FALSE):
			foreach($search as $skey=>$value)
			{
				$key .=	'_'.$skey.'_'.((is_array($value))?implode('_',$value):str_replace(',','_',$value));
			}
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		$check_db_changes=$this->memcached_library->get(FETCH_REQUEST_REPORT);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{			
			return $ret;
		}
		else{
			$SQL = "SELECT 
						DATE_FORMAT(oxah.date_time,'%d-%m-%Y') as DATE,
						TIME(oxah.date_time) as TIME,
						TIME(oxah.date_time) as HOUR,
						DATE_FORMAT(oxah.date_time,'%b %Y') as MONTH,
						DATE_FORMAT(oxah.date_time,'%Y') as YEAR,
						oxah.dj_delivery_media_type as device,
						dgs.country as COUNTRY,
						dgs.country_code,
						IFNULL(SUM(oxah.requests),0) as REQUEST,
						IFNULL(SUM(oxah.impressions),0) as IMP, 
						IFNULL(SUM(oxah.clicks),0) as CLK,
						IFNULL(SUM(oxah.dj_unique_impressions),0) as UIMP,
						IFNULL(SUM(oxah.dj_unique_clicks),0) as UCLK,
						IFNULL(SUM(oxah.conversions),0) as CON,
						CASE WHEN SUM(oxah.requests)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.impressions)/SUM(oxah.requests))*100),0),2))) END as FILL_RATE,
						CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000),0),2))) END as ERPM,
						CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL((((SUM(oxah.dj_total_revenue) - SUM(oxah.dj_publisher_earnings))/SUM(oxah.impressions))*1000),0),2))) END as EPPM,
						ROUND(IFNULL(((SUM(oxah.clicks)/SUM(oxah.impressions))*100),0),2) as CTR, ";					
			if($search['account_type'] == 'ADMIN' || $search['account_type'] == 'MANAGER'){
				$SQL.=	"ROUND(IFNULL(SUM(oxah.dj_total_revenue),0),2) as SPEND,				
						ROUND(IFNULL(((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000),0),2) as ECPM,
						(oxcl.account_id) as ADV_ID,
						(oxcl.clientid),
						(oxcl.clientname) as CLIENT_NAME,
						(oxc.campaignid) as CAM_ID,
						(oxc.campaignname) as CAM_NAME,
						dcrt.revenue_type as RTYPE,
						oxc.revenue_type,
						(oxb.bannerid) as BAN_ID,
						CONCAT(oxb.width, 'x', oxb.height) as ADSIZE,
						(oxb.storagetype) as ST_TYPE,
						(oxb.dj_banner_type) as BAN_TYPE,
						(oxb.description) as BAN_NAME,
						ROUND(IFNULL(SUM(oxah.dj_total_revenue),0),2) as ADM_EARN,				
						ROUND(IFNULL(((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000),0),2) as ADM_ECPM,
						ROUND(IFNULL(SUM(oxah.dj_publisher_earnings),0),2) as PUB_EARN,
						ROUND(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0),2) as PUB_ECPM,					
						(oxaff.account_id) as AFF_ID,
						(oxaff.affiliateid),
						(oxaff.name) as AFF_NAME,
						(oxps.site_id) as SITE_ID,
						(oxps.site_name) as SITE_NAME,
						(oxps.site_url) as SITE_URL,
						(oxaff.name) as AFF_NAME,
						(oxz.zoneid) as ZONE_ID,
						(oxz.zonename) as ZONE_NAME
					FROM rv_data_summary_ad_hourly as oxah ";
					
				$SQL .= " LEFT JOIN djax_geographical_stats as dgs ON ( dgs.ad_id=oxah.ad_id AND dgs.zone_id=oxah.zone_id AND dgs.date_time=oxah.date_time )";
					
				// LINK ADVERTISER RELATED TABLES
				if(isset($search['creative']) AND $search['creative'] != '' AND is_array($search['creative'])){
					$creative_id	=	implode(',',$search['creative']);
					$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$creative_id.") )";
				}
				else if(isset($search['creative']) AND $search['creative'] != '' AND !is_array($search['creative'])){
					$SQL .= " JOIN rv_banners as oxb ON (oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$search['creative'].") )";
				}
				else
				{
					$SQL .= " JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id";
				}
				
				if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
					if(in_array('custom',$search['adsize']))
					{
						$si	=	array();
						foreach($search['adsize'] as $siz):
							if($siz!='custom')
							{
								$si[]	=	$siz;
							}
						endforeach;
						if(!empty($si)):	
							$size	=	implode("','",$si);												
							$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
						endif;
					}
					else
					{
						$size	=	implode("','",$search['adsize']);												
						$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
					}
				}
				else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
					$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$search['adsize']."') ";
				}
						
				if(isset($search['campaign']) AND $search['campaign'] != '' AND is_array($search['campaign'])){
					$campaign_id	=	implode(',',$search['campaign']);
					$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campaign_id.") )";
				}
				else if(isset($search['campaign']) AND $search['campaign'] != '' AND !is_array($search['campaign'])){
					$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$search['campaign'].") )";
				}
				else
				{
					$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
				}
				
				if(isset($search['rtype']) AND $search['rtype']!='' AND is_array($search['rtype'])){
					$revtype	=	implode(',',$search['rtype']);
					$SQL .= " AND oxc.revenue_type IN (".$revtype.") ";
				}
				else if(isset($search['rtype']) AND $search['rtype'] != '' AND !is_array($search['rtype'])){
					$SQL .= " AND oxc.revenue_type IN (".$search['rtype'].") ";
				}
				
				$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
									
				if(isset($search['advertiser']) AND $search['advertiser'] != '' AND is_array($search['advertiser'])){
					$advertiser_id	=	implode(',',$search['advertiser']);
					$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id IN (".$advertiser_id.") )";
				}
				else if(isset($search['advertiser']) AND $search['advertiser'] != '' AND !is_array($search['advertiser'])){
					$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id IN (".$search['advertiser'].") )";
				}
				else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
					$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=".$search['agency_id'].")";
				}
				else
				{
					$SQL .= " JOIN rv_clients as oxcl ON oxc.clientid=oxcl.clientid ";
				}
				
				if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
					$SQL	.=" AND oxcl.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
				endif;
				
				// LINK TRAFFICKER RELATED TABLES
				if(isset($search['zone']) AND $search['zone'] != '' AND is_array($search['zone'])){
					$adblock_id	=	implode(',',$search['zone']);
					$SQL .= " JOIN rv_zones as oxz ON (oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$adblock_id.") )";
				}
				else if(isset($search['zone']) AND $search['zone'] != '' AND !is_array($search['zone'])){
					$SQL .= " JOIN rv_zones as oxz ON (oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$search['zone'].") )";
				}
				else
				{
					$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id";
				}
				
				$SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
				
				if(isset($search['site']) AND $search['site'] != '' AND is_array($search['site'])){
					$site_id	=	implode(',',$search['site']);
					$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id IN (".$site_id.") )";
				}
				else if(isset($search['site']) AND $search['site'] != '' AND !is_array($search['site'])){
					$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id IN (".$search['site'].") )";
				}
				else
				{
					$SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
				}
				
				if(isset($search['publisher']) AND $search['publisher'] != '' AND is_array($search['publisher'])){
					$publisher_id	=	implode(',',$search['publisher']);
					$SQL .= " JOIN rv_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.account_id IN (".$publisher_id.") )";
				}
				else if(isset($search['publisher']) AND $search['publisher'] != '' AND !is_array($search['publisher'])){
					$SQL .= " JOIN rv_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.account_id IN (".$search['publisher'].") )";
				}
				else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
					$SQL .= " JOIN rv_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=".$search['agency_id'].")";
				}
				else
				{
					$SQL .= " JOIN rv_affiliates as oxaff ON oxaff.account_id=oxps.account_id ";
				}
				
				if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
					$SQL	.=" AND oxaff.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
				endif; 
			}
			
			if($search['account_type'] == 'ADVERTISER'){
				$SQL.=	"ROUND(IFNULL(SUM(oxah.dj_total_revenue),0),2) as SPEND,				
						ROUND(IFNULL(((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000),0),2) as ECPM,
						(oxc.campaignid) as CAM_ID,
						(oxc.campaignname) as CAM_NAME,
						dcrt.revenue_type as RTYPE,
						oxc.revenue_type,
						(oxcl.clientname) as CLIENT_NAME,					
						(oxb.bannerid) as BAN_ID,
						(oxb.storagetype) as ST_TYPE,
						(oxb.dj_banner_type) as BAN_TYPE,
						(oxb.description) as BAN_NAME,
						CONCAT(oxb.width, 'x', oxb.height) as ADSIZE
					FROM rv_data_summary_ad_hourly as oxah ";
				
				$SQL .= " LEFT JOIN djax_geographical_stats as dgs ON ( dgs.ad_id=oxah.ad_id AND dgs.zone_id=oxah.zone_id AND dgs.date_time=oxah.date_time )";
				
				if(isset($search['creative']) AND $search['creative'] != '' AND is_array($search['creative'])){
					$creative_id	=	implode(',',$search['creative']);
					$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$creative_id.") )";
				}
				else if(isset($search['creative']) AND $search['creative'] != '' AND !is_array($search['creative'])){
					
					$SQL .= " JOIN rv_banners as oxb ON (oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$search['creative'].") )";
				}
				else
				{
					$SQL .= " JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id";
				}
				
				if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
					if(in_array('custom',$search['adsize']))
					{
						$si	=	array();
						foreach($search['adsize'] as $siz):
							if($siz!='custom')
							{
								$si[]	=	$siz;
							}
						endforeach;
						if(!empty($si)):	
							$size	=	implode("','",$si);												
							$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
						endif;
					}
					else
					{
						$size	=	implode("','",$search['adsize']);												
						$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
					}
				}
				else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
					$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$search['adsize']."') ";
				}
						
				if(isset($search['campaign']) AND $search['campaign'] != '' AND is_array($search['campaign'])){
					$campaign_id	=	implode(',',$search['campaign']);
					$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campaign_id.") )";
				}
				else if(isset($search['campaign']) AND $search['campaign'] != '' AND !is_array($search['campaign'])){
					$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$search['campaign'].") )";
				}
				else
				{
					$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
				}
				
				if(isset($search['rtype']) AND $search['rtype']!='' AND is_array($search['rtype'])){
					$revtype	=	implode(',',$search['rtype']);
					$SQL .= " AND oxc.revenue_type IN (".$revtype.") ";
				}
				else if(isset($search['rtype']) AND $search['rtype'] != '' AND !is_array($search['rtype'])){
					$SQL .= " AND oxc.revenue_type IN (".$search['rtype'].") ";
				}
				
				$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
				
				$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['account_id'].")";
			}
			if($search['account_type'] == 'TRAFFICKER'){
				$SQL.= 	"ROUND(IFNULL(SUM(oxah.dj_publisher_earnings),0),2) as PUB_EARN,
						ROUND(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0),2) as PUB_ECPM,
						(oxps.site_id) as SITE_ID,
						(oxps.site_name) as SITE_NAME,
						(oxps.site_url) as SITE_URL,
						(oxaff.name) as AFF_NAME,
						(oxz.zoneid) as ZONE_ID,
						(oxz.zonename) as ZONE_NAME,
						CONCAT(oxz.width, 'x', oxz.height) as ADSIZE 
					FROM rv_data_summary_ad_hourly as oxah ";
				
				$SQL .= " LEFT JOIN djax_geographical_stats as dgs ON ( dgs.ad_id=oxah.ad_id AND dgs.zone_id=oxah.zone_id AND dgs.date_time=oxah.date_time )";
				
				if(isset($search['zone']) AND $search['zone'] != '' AND is_array($search['zone'])){
					$adblock_id	=	implode(',',$search['zone']);
					$SQL .= " JOIN rv_zones as oxz ON (oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$adblock_id.") )";
				}
				else if(isset($search['zone']) AND $search['zone'] != '' AND !is_array($search['zone'])){
					$SQL .= " JOIN rv_zones as oxz ON (oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$search['zone'].") )";
				}
				else
				{
					$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id";
				}
				
				if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
					if(in_array('custom',$search['adsize']))
					{
						$si	=	array();
						foreach($search['adsize'] as $siz):
							if($siz!='custom')
							{
								$si[]	=	$siz;
							}
						endforeach;
						if(!empty($si)):	
							$size	=	implode("','",$si);												
							$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) NOT IN ('".$size."') ";
						endif;
					}
					else
					{
						$size	=	implode("','",$search['adsize']);												
						$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) IN ('".$size."') ";
					}
				}
				else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
					$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) IN ('".$search['adsize']."') ";
				}
				
				$SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
				
				if(isset($search['site']) AND $search['site'] != '' AND is_array($search['site'])){
					$site_id	=	implode(',',$search['site']);
					$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id IN (".$site_id.") )";
				}
				else if(isset($search['site']) AND $search['site'] != '' AND !is_array($search['site'])){
					$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id IN (".$search['site'].") )";
				}
				else
				{
					$SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
				}
		
				$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=".$search['account_id'].")";
			}
			
			$SQL .= "  WHERE 1";			
						
			if(is_array($search) AND count($search) > 0){
				
				if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(oxah.date_time)  >= '".$search['date_from']."' AND DATE(oxah.date_time) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
					$SQL .= " AND DATE(oxah.date_time) = '".$search['date_from']."'";
				}
				
				if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
					$country	=	implode("','",$search['country']);
					$SQL .= " AND dgs.country_code IN ('".$country."') ";
				}
				else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
					$SQL .= " AND dgs.country_code IN ('".$search['country']."') ";
				}	
					
				if(isset($search['device']) AND $search['device'] != '' AND $search['device'] !='all'){
					$SQL .= " AND oxah.dj_delivery_media_type  = '".$search['device']."' ";
				}			
			}
			
			if($search['account_type'] == 'ADVERTISER'){
				if(isset($search['group_by']) AND $search['group_by'] != '')
				{
					$SQL.=	" GROUP BY ".$search['group_by']." ";
				}
				else
				{
					$SQL.=	" GROUP BY oxc.campaignid,oxb.bannerid ";
				}
			}
			elseif($search['account_type'] == 'TRAFFICKER'){
				if(isset($search['group_by']) AND $search['group_by'] != '')
				{
					$SQL.=	" GROUP BY ".$search['group_by']." ";
				}
				else
				{
					$SQL.=	" GROUP BY oxps.site_id,oxz.zoneid ";
				}
			}
			elseif($search['account_type'] == 'ADMIN' || $search['account_type'] == 'MANAGER'){
				if(isset($search['group_by']) AND $search['group_by'] != '')
				{
					$SQL.=	" GROUP BY ".$search['group_by']." ";
				}
				else
				{
					$SQL.=	" GROUP BY oxc.campaignid,oxb.bannerid,oxps.site_id,oxz.zoneid ";
				}
			}		
			
			$query = $this->db->query($SQL);
	//	return  $this->db->last_query();
			//echo $this->db->last_query();exit;
			$result	=	$query->result_array();
			if($result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(FETCH_REQUEST_REPORT,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			} 
		}
	}	
	
	/*
	 * 
	 * name: add_request
	 * @param :
	 * @return : $add_request	
	 */
	
	function add_request($data)
	{
		$this->db->insert(TAB_REQUEST_REPORT,$data);
		$this->memcached_library->set(GET_REQUEST_REPORT,'1');
		$this->memcached_library->set(FETCH_REQUEST_REPORT,'1');
		
		if($this->db->affected_rows()>0)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
	* 
	* name: get_request
	* @param :
	* @return : $get_request	
	*/
	 
	function get_request($where=FALSE)
	{
		$key = 'get_request_report';
		
		if($where!=FALSE):
			foreach($where as $skey=>$value)
			{
				$key .=	'_'.$skey.'_'.$value;
			}
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		$check_db_changes=$this->memcached_library->get(GET_REQUEST_REPORT);
		
		//~ if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		//~ {
			//~ return $ret;
		//~ }
		//~ else{
		
			if(time() < strtotime("10:00:00")):
				$daily	=	"Today 10:00:00";			
			else:
				$daily	=	"Tomorrow 10:00:00";
			endif;
			
			if(date('D')=='Sun' && time() < strtotime("10:00:00")):
				$weekly	=	"Today 10:00:00";			
			else:
				$weekly	=	date('d M,Y 10:00:00',strtotime('next Sunday'));
			endif;
			
			if(date('d')==date('d',mktime(0,0,0,date('m'),1,date('Y')))):
				$monthly=	"Today 10:00:00";			
			else:
				$monthly=	date('d M,Y 10:00:00',mktime(0,0,0,date('m')+1,1,date('Y')));
			endif;
			
			$SQL	=	"SELECT 
							drr.*,
							CASE 
								WHEN drr.frequency='Daily' THEN '".$daily."'
								WHEN drr.frequency='Weekly' THEN '".$weekly."'
								WHEN drr.frequency='Monthly' THEN '".$monthly."'
							END as date,
							CASE 
								WHEN drr.filter_by= 'advertiser' THEN 
									(SELECT 
										GROUP_CONCAT(oxcl.clientname SEPARATOR ', ') 
									FROM 
										".TAB_CLIENTS." as oxcl
									WHERE 
										FIND_IN_SET(oxcl.clientid, drr.`filter_id`) 
									)
								WHEN drr.filter_by= 'campaign' THEN 
									(SELECT 
										GROUP_CONCAT(oxca.campaignname SEPARATOR ', ') 
									FROM 
										".TAB_CAMPAIGNS." as oxca 
									WHERE 
										FIND_IN_SET(oxca.campaignid, drr.`filter_id`) 
									)
								WHEN drr.filter_by= 'creative' THEN 
									(SELECT 
										GROUP_CONCAT(oxb.description SEPARATOR ', ') 
									FROM 
										".TAB_BANNERS." as oxb 
									WHERE 
										FIND_IN_SET(oxb.bannerid, drr.`filter_id`)
									)
								WHEN drr.filter_by= 'publisher' THEN 
									(SELECT 
										GROUP_CONCAT(oxa.name SEPARATOR ', ') 
									FROM 
										".TAB_AFFILIATE." as oxa
									WHERE 
										FIND_IN_SET(oxa.affiliateid, drr.`filter_id`) 
									)
								WHEN drr.filter_by= 'site' THEN 
									(SELECT 
										GROUP_CONCAT(dps.site_url SEPARATOR ', ') 
									FROM 
										".TAB_PUB_SITES." as dps 
									WHERE 
										FIND_IN_SET(dps.site_id, drr.`filter_id`)
									)
								WHEN drr.filter_by= 'adblock' THEN 
									(SELECT 
										GROUP_CONCAT(oxz.zonename SEPARATOR ', ') 
									FROM 
										".TAB_ZONES." as oxz 
									WHERE 
										FIND_IN_SET(oxz.zoneid, drr.`filter_id`)
									)
							END as filter_item,
							
							(SELECT 
								GROUP_CONCAT(oxcl.clientname SEPARATOR ', ') 
							FROM 
								".TAB_CLIENTS." as oxcl
							WHERE 
								FIND_IN_SET(oxcl.account_id, drr.`advertiser`) 
							) as advertiser,
							(SELECT 
								GROUP_CONCAT(oxca.campaignname SEPARATOR ', ') 
							FROM 
								".TAB_CAMPAIGNS." as oxca 
							WHERE 
								FIND_IN_SET(oxca.campaignid, drr.`campaign`) 
							) as campaign,
							(SELECT 
								GROUP_CONCAT(oxb.description SEPARATOR ', ') 
							FROM 
								".TAB_BANNERS." as oxb 
							WHERE 
								FIND_IN_SET(oxb.bannerid, drr.`creative`)
							) as creative,
							(SELECT 
								GROUP_CONCAT(oxa.name SEPARATOR ', ') 
							FROM 
								".TAB_AFFILIATE." as oxa
							WHERE 
								FIND_IN_SET(oxa.affiliateid, drr.`publisher`) 
							) as publisher,							
							(SELECT 
								GROUP_CONCAT(dps.site_url SEPARATOR ', ') 
							FROM 
								".TAB_PUB_SITES." as dps 
							WHERE 
								FIND_IN_SET(dps.site_id, drr.`site`)
							) as site,
							(SELECT 
								GROUP_CONCAT(oxz.zonename SEPARATOR ', ') 
							FROM 
								".TAB_ZONES." as oxz 
							WHERE 
								FIND_IN_SET(oxz.zoneid, drr.`zone`)
							) as zone,
							(SELECT 
								GROUP_CONCAT(dcrt.revenue_type SEPARATOR ', ') 
							FROM 
								".TAB_CONF_REVENUE_TYPE." as dcrt 
							WHERE 
								FIND_IN_SET(dcrt.revenue_type_value, drr.`rtype`)
							) as rtype
						
						FROM 
							".TAB_REQUEST_REPORT." as drr 
						WHERE 1 
							AND drr.frequency != 'One' ";
						if($where!=FALSE):								
							$SQL	.=	" AND drr.account_id = '".$where['account_id']."' 
										AND drr.account_type = '".$where['account_type']."'
										AND status='".$where['status']."' ";
						else:
							$SQL	.=	"AND drr.account_id = ".$this->user_authentication->account_id." 
										AND drr.account_type = '".$this->user_authentication->account_type."' ";
						endif;
					$SQL	.=	" AND is_deleted = 0 
						GROUP BY 
							drr.id";
			
			$query	=	$this->db->query($SQL);
			//echo $this->db->last_query();exit;
			if($query->num_rows()>0)
			{	
			
				$result= $query->result();
				//print_r($result);exit;
				//~ if($mem_cache=='enable' )
				//~ {
					//~ $account_type=$this->user_authentication->account_type;
					//~ $this->memcached_library->set($key,$result,$account_type);	
					//~ $this->memcached_library->set(GET_REQUEST_REPORT,'2');
					//~ $set = $this->memcached_library->get($key);	
					//~ return $set;
				//~ }
				//~ else{
					return $result;
			//	}
			}
			else
			{
				return FALSE;			
			}
		//}	
	}
	
	/*
	* 
	* name: update_request
	* @param :
	* @return : $update_request	
	*/
	 
	function update_request($req_id=FALSE,$where=FALSE)
	{
		if($req_id!=FALSE)
		{					
			$this->db->where('id',$req_id);
		}
		
		if($this->db->update(TAB_REQUEST_REPORT,$where))
		{
			$this->memcached_library->set(GET_REQUEST_REPORT,'1');
			$this->memcached_library->set(FETCH_REQUEST_REPORT,'1');
			return TRUE;
		}
		else
		{
			return FALSE;			
		}
	}	
	
	
	/*
	* 
	* name: request_report_send_mail
	* @param : Msudhakar
	* @return : $update_request	
	*/
	
	function fetch_request_report_user($account_id,$search){
		
		//echo $search['account_type'];
		//echo $account_id;
		$SQL = '';
		
		if($search['account_type'] == 'ADVERTISER'){
			$SQL.=	"SELECT 
					IFNULL(SUM(oxah.impressions),0) as IMP, 
					IFNULL(SUM(oxah.clicks),0) as CLK,
					IFNULL(SUM(oxah.dj_unique_impressions),0) as UIMP,
					IFNULL(SUM(oxah.dj_unique_clicks),0) as UCLK,
					IFNULL(SUM(oxah.conversions),0) as CON,
					ROUND(IFNULL(((SUM(oxah.clicks)/SUM(oxah.impressions))*100),0),2) as CTR, ROUND(IFNULL(SUM(oxah.dj_total_revenue),0),2) as SPEND,				
					ROUND(IFNULL(((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000),0),2) as ECPM,
					(oxc.campaignid),
					(oxc.campaignname) as CAM_NAME,
					(oxcl.clientname) as ACC_NAME,					
					(oxb.bannerid),
					(oxb.storagetype) as ST_TYPE,
					(oxb.dj_banner_type) as BAN_TYPE,
					(oxb.description) as BAN_NAME
				FROM rv_data_summary_ad_hourly as oxah 
				JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=78)  WHERE 1 AND (DATE(oxah.date_time)  >= '2015-09-28' AND DATE(oxah.date_time) <= '2015-10-27') GROUP BY oxc.campaignid,oxb.bannerid";
		}
		

	if($search['account_type'] == 'TRAFFICKER'){
		$SQL.="SELECT 
					IFNULL(SUM(oxah.impressions),0) as IMP, 
					IFNULL(SUM(oxah.clicks),0) as CLK,
					IFNULL(SUM(oxah.dj_unique_impressions),0) as UIMP,
					IFNULL(SUM(oxah.dj_unique_clicks),0) as UCLK,
					IFNULL(SUM(oxah.conversions),0) as CON,
					ROUND(IFNULL(((SUM(oxah.clicks)/SUM(oxah.impressions))*100),0),2) as CTR, ROUND(IFNULL(SUM(oxah.dj_publisher_earnings),0),2) as PUB_EARN,
					ROUND(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0),2) as PUB_ECPM,

					(oxps.site_id),
					(oxps.site_name) as SITE_NAME,
					(oxps.site_url) as SITE_URL,
					(oxaff.name) as ACC_NAME,
					(oxz.zoneid),
					(oxz.zonename) as ZONE_NAME
				FROM rv_data_summary_ad_hourly as oxah  JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id JOIN djax_site_zone_assoc
 as dsza ON dsza.zone_id=oxz.zoneid JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id JOIN
 rv_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=82)  WHERE 1 AND 
(DATE(oxah.date_time)  >= '2015-09-28' AND DATE(oxah.date_time) <= '2015-10-27') GROUP BY oxps.site_id,oxz.zoneid";	
		
		}
		
	$query = $this->db->query($SQL);
	//return $query->result_array();
		//echo $this->db->last_query();exit;
	
		
		if($query->num_rows()>0)
		{			
			return $query->result_array();
		}
		else
		{
			//return FALSE;
			return ;
		}
		
	
	}
	
	function test_user($account_id,$search){
	
	
	$test = 'Welcome to This Functions';
	
	return $test;
	
	
	}
	
	/*
	 * 
	 * name: fetch_dsp_stats
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all dsp stats for the report
	 */

	function fetch_dsp_stats($search,$order=null,$limit=false,$agency_id=false)
	{
		$key = 	'fetch_dsp_report_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$agency_id;
		
		$key = 'fetch_dsp_stats_'.$search.'_'.$order.'_'.$limit.'_'.$agency_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
					
			$SQL 	= 	"SELECT
							 IFNULL(COUNT(w.win_count),0) as win_count,
							 IFNULL(SUM(w.win_price),0) as win_price,
							 IFNULL(COUNT(req.id),0) as req_count,
							 req.exchange_id,
							 adx.exchange_name,
							 IFNULL(COUNT(r.res_count),0) as res_count,
							 IFNULL(SUM(r.bid_price),0) as bid_price,
							 IFNULL(SUM(r.sbid_price),0) as sbid_price,
							 IFNULL(SUM(r.admin_price),0) as admin_price
						FROM 
							".TAB_DSP_BID_REQ." as req
						LEFT JOIN  
						(
							SELECT 
								DATE(res.datetime) as rdate,
								res.requset_id as request_id,
								IFNULL(COUNT(res.response_id),0) as res_count, 
								IFNULL(SUM(res.advertiser_bid_price),0) as bid_price, 
								IFNULL(SUM(res.smaato_bid_price),0) as sbid_price, 
								IFNULL(SUM(res.admin_rev),0) as admin_price 
							FROM 
								".TAB_DSP_RESPONSE." as res 
							WHERE 1 ";
							if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
								$SQL .= " AND (DATE(datetime)  >= '".$search['date_from']."' AND DATE(datetime) <= '".$search['date_to']."')";
							}
							else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
								
				$SQL .= " GROUP BY 
								request_id
						) as r ON r.request_id=req.id
						LEFT JOIN  
						(
							SELECT 
								DATE(win.datetime)as wdate, 
								win.request_id,
								IFNULL(COUNT(win.id),0) as win_count, 
								IFNULL(SUM(win.price),0) as win_price 
							FROM 
								".TAB_DSP_WIN_NOTICE." as win 
							WHERE 1 ";
							if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
								$SQL .= " AND (DATE(datetime)  >= '".$search['date_from']."' AND DATE(datetime) <= '".$search['date_to']."')";
							}
							else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
				$SQL .= " GROUP BY 
								request_id
						) as w ON w.request_id=req.id 
						LEFT JOIN ".TAB_3RD_ADX." as adx ON adx.exchange_id=req.exchange_id 
						WHERE 1 AND adx.type='DSP' AND adx.agency_id=".$agency_id."";
					
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				$SQL .= " AND (DATE(req.datetime)  >= '".$search['date_from']."' AND DATE(datetime) <= '".$search['date_to']."')";
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$SQL .= " AND DATE(req.datetime) = '".$search['date_from']."'";
			}
			
			if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
				$SQL .= " AND (";
				foreach($search['search_fields'] as $sObj){
					$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
				}
			
				$SQL = rtrim($SQL, "OR");
			
				$SQL .= " )";			
			}
		
			$SQL .= " GROUP BY req.exchange_id ";
			
			if($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY ".$order['field']." ". $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY req.exchange_id DESC";
			}
			
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
				
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			/*$SQL = "SELECT 
						IFNULL(count(res.response_id),0) as res,
						IFNULL(count(req.id),0) as req,
						req.exchange_id as exchange_id,
						adx.exchange_name,
						IFNULL(COUNT(win.id),0) as win_count,
						IFNULL(SUM(win.price)/1000,0) as win_price,
						IFNULL(SUM(res.advertiser_bid_price)/1000,0) as bid_price

						FROM 
							djax_dsp_win_notice as win 
							left join djax_dsp_response as res on res.requset_id= win.request_id 
							left join  djax_dsp_bid_request as req on req.id=res.requset_id 				
							LEFT JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.exchange_id 
						WHERE 
								adx.type='DSP'";
		   if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(res.datetime)  >= '".$search['date_from']."' AND DATE(res.datetime) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(res.datetime) = '".$search['date_from']."'";
							}
							
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(win.datetime)  >= '".$search['date_from']."' AND DATE(win.datetime) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(win.datetime) = '".$search['date_from']."'";
							}
			
			if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
			}
			else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['end'] . "";
			}*/
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				return $result;
			}
			else
			{
				return FALSE;	
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_dsp_stats
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all dsp stats for the report
	 */

	function fetch_dsp_date_stats($exchange_id,$search,$order=null,$limit=false,$agency_id=false)
	{	
		
		$key = 	'fetch_dsp_date_report_'.$exchange_id.'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$agency_id;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
							
			$SQL 	= 	"SELECT
							 IFNULL(COUNT(w.win_count),0) as win_count,
							 IFNULL(SUM(w.win_price),0) as win_price,
							 IFNULL(COUNT(req.id),0) as req_count,
							 DATE(req.datetime) as dbdate,
							 req.exchange_id,
							 IFNULL(COUNT(r.res_count),0) as res_count,
							 IFNULL(SUM(r.bid_price),0) as bid_price,
							 IFNULL(SUM(r.sbid_price),0) as sbid_price,
							 IFNULL(SUM(r.admin_price),0) as admin_price
						FROM 
							".TAB_DSP_BID_REQ." as req
						LEFT JOIN  
						(
							SELECT 
								DATE(res.datetime) as rdate,
								res.requset_id as request_id,
								IFNULL(COUNT(res.response_id),0) as res_count, 
								IFNULL(SUM(res.advertiser_bid_price),0) as bid_price, 
								IFNULL(SUM(res.smaato_bid_price),0) as sbid_price, 
								IFNULL(SUM(res.admin_rev),0) as admin_price 
							FROM 
								".TAB_DSP_RESPONSE." as res 
							WHERE 1 ";
							if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
								$SQL .= " AND (DATE(datetime)  >= '".$search['date_from']."' AND DATE(datetime) <= '".$search['date_to']."')";
							}
							else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
								
				$SQL .= " GROUP BY 
								request_id
						) as r ON r.request_id=req.id
						LEFT JOIN  
						(
							SELECT 
								DATE(win.datetime)as wdate, 
								win.request_id,
								IFNULL(COUNT(win.id),0) as win_count, 
								IFNULL(SUM(win.price),0) as win_price 
							FROM 
								".TAB_DSP_WIN_NOTICE." as win 
							WHERE 1 ";
							if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
								$SQL .= " AND (DATE(datetime)  >= '".$search['date_from']."' AND DATE(datetime) <= '".$search['date_to']."')";
							}
							else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
				$SQL .= " GROUP BY 
								request_id
						) as w ON w.request_id=req.id 
						LEFT JOIN ".TAB_3RD_ADX." as adx ON adx.exchange_id=req.exchange_id 
						WHERE 1 AND adx.type='DSP' AND req.exchange_id='".$exchange_id."' AND adx.agency_id=".$agency_id."";
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				$SQL .= " AND (DATE(req.datetime)  >= '".$search['date_from']."' AND DATE(datetime) <= '".$search['date_to']."')";
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$SQL .= " AND DATE(req.datetime) = '".$search['date_from']."'";
			}
			
			if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
				$SQL .= " AND (";
				foreach($search['search_fields'] as $sObj){
					$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
				}
			
				$SQL = rtrim($SQL, "OR");
			
				$SQL .= " )";			
			}
		
			$SQL .= " GROUP BY DATE(req.datetime) ";
			
			if($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY ".$order['field']." ". $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY DATE(req.datetime) DESC";
			}
			
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
				
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			/*$SQL = "SELECT 
						IFNULL(count(res.response_id),0) as res,
						IFNULL(count(req.id),0) as req,
						req.exchange_id as exchange_id,
						adx.exchange_name,
						 DATE(req.datetime) as dbdate,
						IFNULL(COUNT(win.id),0) as win_count,
						IFNULL(SUM(win.price)/1000,0) as win_price,
						IFNULL(SUM(res.advertiser_bid_price)/1000,0) as bid_price

						FROM 
							djax_dsp_win_notice as win 
							left join djax_dsp_response as res on res.requset_id= win.request_id 
							left join  djax_dsp_bid_request as req on req.id=res.requset_id 				
							LEFT JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.exchange_id 
						WHERE 
								  adx.type='DSP' AND req.exchange_id='".$exchange_id."' ";
		   if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(res.datetime)  >= '".$search['date_from']."' AND DATE(res.datetime) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
							
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(res.datetime)  >= '".$search['date_from']."' AND DATE(res.datetime) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
			$SQL .= "GROUP BY DATE(req.datetime),req.exchange_id ";
			if ($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY " . $order['field'] . " " . $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY DATE(req.datetime) DESC";
			}
			if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
			}
			else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['end'] . "";
			}*/
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;	
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_dsp_stats
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all dsp stats for the report
	 */

	function fetch_dsp_detail_stats($exchange_id,$date,$search,$order=null,$limit=false,$agency_id=false)
	{	
		
		$key = 	'fetch_dsp_detail_report_'.$exchange_id.'_'.$date.'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$agency_id;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$SQL 	= 	"SELECT
							 r.client_name,
							 r.camp_name,
							 r.ban_name,
							 IFNULL(COUNT(w.win_count),0) as win_count,
							 IFNULL(SUM(w.win_price),0) as win_price,
							 IFNULL(COUNT(req.id),0) as req_count,
							 IFNULL(COUNT(r.res_count),0) as res_count,
							 IFNULL(SUM(r.bid_price),0) as bid_price,
							 IFNULL(SUM(r.sbid_price),0) as sbid_price,
							 IFNULL(SUM(r.admin_price),0) as admin_price
						FROM 
							".TAB_DSP_BID_REQ." as req 
						LEFT JOIN  
						(
							SELECT 
								oxcl.clientname as client_name, 
								oxc.campaignname as camp_name, 
								oxb.description as ban_name,
								res.adid,
								res.campaign_id,
								res.requset_id as request_id,
								res.response_id as res_count, 
								res.advertiser_bid_price as bid_price, 
								res.smaato_bid_price as sbid_price, 
								res.admin_rev as admin_price
							FROM 
								".TAB_DSP_RESPONSE." as res 
							JOIN 
								".TAB_BANNERS." as oxb ON oxb.bannerid=res.adid
							JOIN 
								".TAB_CAMPAIGNS." as oxc ON oxc.campaignid=oxb.campaignid
							JOIN 
								".TAB_CLIENTS." as oxcl ON oxcl.clientid=oxc.clientid 
							WHERE 1 
								AND DATE(res.datetime)='".$date."' 
						) as r ON r.request_id=req.id
						LEFT JOIN  
						(
							SELECT 
								oxcl.clientname as client_name, 
								oxc.campaignname as camp_name, 
								oxb.description as ban_name,
								win.adid,
								win.request_id,
								win.id as win_count, 
								win.price as win_price
							FROM 
								".TAB_DSP_WIN_NOTICE." as win 
							JOIN 
								".TAB_BANNERS." as oxb ON oxb.bannerid=win.adid
							JOIN 
								".TAB_CAMPAIGNS." as oxc ON oxc.campaignid=oxb.campaignid
							JOIN 
								".TAB_CLIENTS." as oxcl ON oxcl.clientid=oxc.clientid 
							WHERE 1 
								AND DATE(win.datetime)='".$date."' 
						) as w ON w.request_id=req.id 
						LEFT JOIN ".TAB_3RD_ADX." as adx ON adx.exchange_id=req.exchange_id 					
						WHERE 1 
							AND adx.type='DSP' 
							AND req.exchange_id='".$exchange_id."' 
							AND adx.agency_id='".$agency_id."'
							AND DATE(req.datetime)='".$date."' ";		
			
			if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
				$SQL .= " AND (";
				foreach($search['search_fields'] as $sObj){
					$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
				}
			
				$SQL = rtrim($SQL, "OR");
			
				$SQL .= " )";			
			}
			
			$SQL .= " GROUP BY r.adid ";
			if($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY ".$order['field']." ". $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY r.adid DESC";
			}	
				
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
				
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			/*$SQL = "SELECT 
						IFNULL(count(res.response_id),0) as res,
						IFNULL(count(req.id),0) as req,
						req.exchange_id as exchange_id,
						adx.exchange_name,
						oxcl.clientname as client_name, 
								oxc.campaignname as camp_name, 
								oxb.description as ban_name,
						 DATE(req.datetime) as dbdate,
						IFNULL(COUNT(win.id),0) as win_count,
						IFNULL(SUM(win.price)/1000,0) as win_price,
						IFNULL(SUM(res.advertiser_bid_price)/1000,0) as bid_price

						FROM 
							djax_dsp_win_notice as win 
							left join djax_dsp_response as res on res.requset_id= win.request_id 
							left join  djax_dsp_bid_request as req on req.id=res.requset_id 				
							LEFT JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.exchange_id
							JOIN 
								rv_banners as oxb ON oxb.bannerid=res.adid
							JOIN 
								rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid
							JOIN 
								rv_clients as oxcl ON oxcl.clientid=oxc.clientid  
						WHERE 
						
						 adx.type='DSP' AND req.exchange_id='".$exchange_id."' ";
		   if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(res.datetime)  >= '".$search['date_from']."' AND DATE(res.datetime) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
							
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND (DATE(res.datetime)  >= '".$search['date_from']."' AND DATE(res.datetime) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(datetime) = '".$search['date_from']."'";
							}
			$SQL .= "GROUP BY DATE(req.datetime),req.exchange_id ";
			if ($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY " . $order['field'] . " " . $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY DATE(req.datetime) DESC";
			}
			if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
			}
			else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['end'] . "";
			}*/
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;	
			}
		}
	}
	
	/*
	* 
	* name: fetch_ssp_stats
	* @param : $data
	* @return : $result
	* 
	* Lists all ssp stats for the report
	*/

	function fetch_ssp_stats($search,$order=null,$limit=false,$agency_id=false)
	{	
		$key = 	'fetch_ssp_report_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$agency_id;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			$SQL 	= 	"SELECT	
						 adx.exchange_name,
						 r.exchange_id,
						 adx.ping_url,
						 IFNULL(r.req_count,0) as req_count,
						 IFNULL(r.bid_floor,0) as floor_price,
						 IFNULL(w.res_count,0) as res_count,
						 IFNULL(w.win_count,0) as win_count,
						 IFNULL(w.win_amt,0) as win_price,
						 w.win_notice_url
					FROM 
						(SELECT 
							DATE(req.requested_date_time) as reqdate,
							req.request_for_network as exchange_id,
							req.campaign_id, 
							IFNULL(COUNT(req.request_id),0) as req_count,
							IFNULL(SUM(req.bid_floor),0) as bid_floor
						FROM 
							".TAB_RTB_REQUEST." as req 
						WHERE 1 ";
						if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
							$SQL .= " AND (DATE(requested_date_time)  >= '".$search['date_from']."' AND DATE(requested_date_time) <= '".$search['date_to']."')";
						}
						else if(isset($search['date_from']) AND $search['date_from'] != ''){
							$SQL .= " AND DATE(requested_date_time) = '".$search['date_from']."'";
						} 
				$SQL .= "	GROUP BY 
							req.request_for_network
						) as r 
					LEFT JOIN  
					(
						SELECT 
							 DATE(res.response_date_time) as resdate, 
							 res.exchange_id,
							 res.campaign_id, 
							 res.win_notice_url,
							 IFNULL(COUNT(res.response_pk_id),0) as res_count,
							 IFNULL(COUNT(CASE WHEN res.win_notice=1 THEN 1 ELSE NULL END),0) as win_count,
							 IFNULL(SUM(CASE WHEN res.win_notice=1 THEN res.win_bid_amt ELSE 0 END),0) as win_amt 
							 
						FROM 
							".TAB_RTB_RESPONSE." as res 
						WHERE 1 ";
						if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
							$SQL .= " AND (DATE(response_date_time)  >= '".$search['date_from']."' AND DATE(response_date_time) <= '".$search['date_to']."')";
						}
						else if(isset($search['date_from']) AND $search['date_from'] != ''){
							$SQL .= " AND DATE(response_date_time) = '".$search['date_from']."'";
						}
			$SQL .= "	GROUP BY 
							res.exchange_id
					) as w ON w.exchange_id=r.exchange_id
					LEFT JOIN ".TAB_3RD_ADX." as adx ON adx.exchange_id=r.exchange_id 
					WHERE 1 AND adx.type='SSP' AND adx.agency_id=".$agency_id."";
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				$SQL .= " AND (DATE(r.reqdate)  >= '".$search['date_from']."' AND DATE(r.reqdate) <= '".$search['date_to']."')";
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$SQL .= " AND DATE(r.reqdate) = '".$search['date_from']."'";
			}
			if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
				$SQL .= " AND (";
				foreach($search['search_fields'] as $sObj){
					$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
				}
			
				$SQL = rtrim($SQL, "OR");
			
				$SQL .= " )";			
			}
		
			$SQL .= " GROUP BY r.exchange_id ";
			
			if($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY ".$order['field']." ". $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY r.exchange_id DESC";
			}
			
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
				
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;	
			}
		}
		
	}
	
	/*
	 * 
	 * name: fetch_ssp_stats
	 * @param : $data
	 * @return : $result
	 * 
	 * Lists all ssp stats for the report
	 */

	function fetch_ssp_detail_stats($exchange_id,$search,$order=null,$limit=false,$agency_id=false)
	{			
		$key = 	'fetch_ssp_detail_report_'.$exchange_id.'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$agency_id;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$SQL 	= 	"SELECT	
							 adx.exchange_name,
							 r.exchange_id,
							 r.reqdate as dbdate,
							 adx.ping_url,
							 IFNULL(r.req_count,0) as req_count,
							 IFNULL(r.bid_floor,0) as floor_price,
							 IFNULL(w.res_count,0) as res_count,
							 IFNULL(w.win_count,0) as win_count,
							 IFNULL(w.win_amt,0) as win_price,
							 w.win_notice_url
						FROM 
							(SELECT 
								DATE(req.requested_date_time) as reqdate,
								req.request_for_network as exchange_id,
								req.campaign_id, 
								IFNULL(COUNT(req.request_id),0) as req_count,
								IFNULL(SUM(req.bid_floor),0) as bid_floor
							FROM 
								".TAB_RTB_REQUEST." as req 
							WHERE 1 AND request_for_network = '".$exchange_id."' ";
							if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
								$SQL .= " AND (DATE(requested_date_time)  >= '".$search['date_from']."' AND DATE(requested_date_time) <= '".$search['date_to']."')";
							}
							else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(requested_date_time) = '".$search['date_from']."'";
							}
								
				$SQL .= " GROUP BY 
								DATE(req.requested_date_time)
							) as r 
						LEFT JOIN  
						(
							SELECT 
								 DATE(res.response_date_time) as resdate, 
								 res.exchange_id,
								 res.campaign_id, 
								 res.win_notice_url,
								 IFNULL(COUNT(res.response_pk_id),0) as res_count,
								 IFNULL(COUNT(CASE WHEN res.win_notice=1 THEN 1 ELSE NULL END),0) as win_count,
								 IFNULL(SUM(CASE WHEN res.win_notice=1 THEN res.win_bid_amt ELSE 0 END),0) as win_amt 
								 
							FROM 
								".TAB_RTB_RESPONSE." as res 
							WHERE 1 
								AND exchange_id  = '".$exchange_id."' ";
							if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
								$SQL .= " AND (DATE(response_date_time)  >= '".$search['date_from']."' AND DATE(response_date_time) <= '".$search['date_to']."')";
							}
							else if(isset($search['date_from']) AND $search['date_from'] != ''){
								$SQL .= " AND DATE(response_date_time) = '".$search['date_from']."'";
							}
				$SQL .= " GROUP BY 
								date(res.response_date_time)
						) as w ON w.resdate=r.reqdate
						LEFT JOIN ".TAB_3RD_ADX." as adx ON adx.exchange_id=r.exchange_id 
						WHERE 1 AND adx.type='SSP' AND r.exchange_id  = '".$exchange_id."' AND adx.agency_id=".$agency_id."";
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				$SQL .= " AND (DATE(r.reqdate)  >= '".$search['date_from']."' AND DATE(r.reqdate) <= '".$search['date_to']."')";
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$SQL .= " AND DATE(r.reqdate) = '".$search['date_from']."'";
			}
			
			if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
				$SQL .= " AND (";
				foreach($search['search_fields'] as $sObj){
					$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
				}
			
				$SQL = rtrim($SQL, "OR");
			
				$SQL .= " )";			
			}
		
			$SQL .= " GROUP BY DATE(r.reqdate) ";
			
			if($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY ".$order['field']." ". $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY DATE(r.reqdate) DESC";
			}
			
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
				
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
			
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
					return $result;
			}
			}
			else
			{
				return FALSE;	
			}			
			
		}
		
	}
	
	function fetch_platform($columns,$search,$group,$order,$limit,$dataTable=FALSE,$page=FALSE)
	{		
		
	//	return $search['timezone'] ;
		if(is_array($group) AND in_array('DATE',$group)){
			if(isset($search['timezone']) AND $search['timezone'] != '')
			{
				$date_field = "DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%d-%m-%Y')";
			}
			else
			{
				$date_field = "DATE_FORMAT(oxah.date_time,'%d-%m-%Y')";
			}
		}
		else if(is_array($group) AND in_array('TIME',$group))
		{
			if(isset($search['timezone']) AND $search['timezone'] != '')
			{
				$date_field = "TIME(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'))";
			}
			else
			{
				$date_field = "TIME(oxah.date_time)";
			}	
		}
		else if(is_array($group) AND in_array('MONTH',$group)){
			if(isset($search['timezone']) AND $search['timezone'] != '')
			{
				$date_field = "DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%b %Y')";
			}
			else
			{
				$date_field = "DATE_FORMAT(oxah.date_time,'%b %Y')";
			}			
		}

		
		
		$SQL = "SELECT SQL_CALC_FOUND_ROWS null as rows,r.* FROM (SELECT ";
	 
	 	if(is_array($columns) AND count($columns) > 0){
	 		foreach($columns as $val){
				
				switch(strtoupper($val)){
					case 'DATE';
						$SQL .= " {$date_field} as ".$val.',';
						break;
					case 'HOUR';
						if(isset($search['timezone']) AND $search['timezone'] != '')
						{
							$SQL .= " DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."'),'%d-%m-%Y') as DATE , ";
							$SQL .= " TIME(CONVERT_TZ(oxah.date_time,'+00:00','".$search['timezone']."')) as ".$val.',';
						}
						else
						{
							$SQL .= " DATE_FORMAT(oxah.date_time,'%d-%m-%Y') as DATE ,";
							$SQL .= " TIME(oxah.date_time) as ".$val.',';
						}						
					break;
					case 'MONTH';
						$SQL .= " {$date_field} as ".$val.',';
					break;
			
					case 'IMP';
						if($dataTable==TRUE):
							$SQL .= " FORMAT(SUM(oxah.impressions),0) as ".$val.',';
						else:
							$SQL .= " SUM(oxah.impressions) as ".$val.',';
						endif;
						
					break;
					case 'CLK';
						if($dataTable==TRUE):
							$SQL .= " FORMAT(SUM(oxah.clicks),0) as ".$val.',';
						else:
							$SQL .= " SUM(oxah.clicks) as ".$val.',';
						endif;
						
					break;
					case 'UIMP';
						if($search['account_type'] !== 'TRAFFICKER'){
							if($dataTable==TRUE):
								$SQL .=" FORMAT(SUM(oxah.dj_unique_impressions),0) as ".$val.",";	
							else:
								$SQL .=" SUM(oxah.dj_unique_impressions) as ".$val.",";	
							endif;							
						}
					break;
					case 'UCLK';
						if($search['account_type'] !== 'TRAFFICKER'){
							if($dataTable==TRUE):
								$SQL .=" FORMAT(SUM(oxah.dj_unique_clicks),0) as ".$val.",";	
							else:
								$SQL .=" SUM(oxah.dj_unique_clicks) as ".$val.",";	
							endif;							
						}
					break;	
					case 'CON';
						if($dataTable==TRUE):
							$SQL .= " FORMAT(SUM(oxah.conversions),0) as ".$val.',';
						else:
							$SQL .= " SUM(oxah.conversions) as ".$val.',';
						endif;
					break;
					case 'SPEND';
						if($search['account_type'] !== 'TRAFFICKER'){
							if($dataTable==TRUE):
								$SQL .= " FORMAT(SUM(oxah.dj_total_revenue),2) as ".$val.',';
							else:
								$SQL .= " SUM(oxah.dj_total_revenue) as ".$val.',';
							endif;							
						}else if($search['account_type'] === 'TRAFFICKER'){
							$SQL .= " ROUND(SUM(oxah.dj_publisher_earnings),4) as ".$val.',';
						}
					
					break;
					case 'EARNINGS';
						if($search['account_type'] === 'TRAFFICKER'){
							$SQL .= " ROUND(SUM(oxah.dj_publisher_earnings),4) as ".$val.',';
						}
					
					break;
					case 'REVENUE';
						if($search['account_type'] !== 'ADVERTISER'){
							if($dataTable==TRUE):
								$SQL .= " FORMAT(SUM(oxah.dj_publisher_earnings),2) as ".$val.',';
							else:
								$SQL .= " SUM(oxah.dj_publisher_earnings) as ".$val.',';
							endif;							
						}
					break;	
					case 'PROFIT';
						if($search['account_type'] === 'ADMIN'){
							if($dataTable==TRUE):
								$SQL .= " FORMAT((SUM(oxah.dj_total_revenue) - SUM(oxah.dj_publisher_earnings)),2) as ".$val.',';
							else:
								$SQL .= " (SUM(oxah.dj_total_revenue) - SUM(oxah.dj_publisher_earnings)) as ".$val.',';
							endif;
							
						}
					break;		
					case 'CTR';
						if($dataTable==TRUE):
							$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0.00 ELSE FORMAT(((SUM(oxah.clicks)/SUM(oxah.impressions))*100),2) END as ".$val.',';
						else:
							$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0.00 ELSE ((SUM(oxah.clicks)/SUM(oxah.impressions))*100) END as ".$val.',';
						endif;	
						
					break;	
					case 'ECPM';
						if($dataTable==TRUE):
							$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0.00 ELSE FORMAT(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),2) END as ".$val.',';
						else:
							$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0.00 ELSE ((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000) END as ".$val.',';
						endif;						
					break;
					case 'ECPC';
						if($dataTable==TRUE):
							$SQL .= " CASE WHEN SUM(oxah.clicks)=0 then 0.00 ELSE FORMAT(((SUM(oxah.dj_total_revenue)/SUM(oxah.clicks))),2) END as ".$val.',';
						else:
							$SQL .= " CASE WHEN SUM(oxah.clicks)=0 then 0.00 ELSE ((SUM(oxah.dj_total_revenue)/SUM(oxah.clicks))) END as ".$val.',';
						endif;						
					break;
			
					case 'PUB_ECPM';
						if($search['account_type'] !== 'ADVERTISER'){
							if($dataTable==TRUE):
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0.00 ELSE FORMAT(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),2) END as ".$val.',';
							else:
								$SQL .= " CASE WHEN SUM(oxah.impressions)=0 then 0.00 ELSE ((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000) END as ".$val.',';
							endif;							
						}
					break;	
					case 'FILL_RATE';
						$SQL .= " CASE WHEN SUM(oxah.requests)=0 then 0 ELSE ROUND(((SUM(oxah.impressions)/SUM(oxah.requests))*100)) END as ".$val.',';
					break;
					case 'ACC_ID';
						if($search['account_type'] === 'ADVERTISER'){
							$SQL .= " (oxcl.account_id) as ".$val.',';
							$SQL .= " (oxcl.clientname) as ACC_NAME,";
						}
						else if($search['account_type'] === 'TRAFFICKER'){
							$SQL .= " (oxaff.account_id) as ".$val.',';
							$SQL .= " (oxaff.name) as ACC_NAME,";
						}
						else if($search['account_type'] === 'ADMIN'){
							
							if($search['page']==='REPORT_ADVERTISER'){
								$SQL .= " (oxcl.account_id) as ".$val.',';
								$SQL .= " (oxcl.clientname) as ACC_NAME,";
								$SQL .= " (oxcl.dj_is_deleted) as DEL_STATUS,";
								
							}
							else if($search['page']==='REPORT_PUBLISHER')
							{
								$SQL .= " (oxaff.account_id) as ".$val.',';
								$SQL .= " (oxaff.name) as ACC_NAME,";
								$SQL .= " (oxaff.dj_is_deleted) as DEL_STATUS,";
							}					
						}
					
					break;
					case 'ADV_ID';
						$SQL .= " (oxcl.account_id) as ".$val.',';
						$SQL .= " (oxcl.clientname) as CLIENT_NAME,";
						$SQL .= " (oxcl.dj_is_deleted) as ADV_DEL_STATUS,";
					break;
					case 'AFF_ID';
						$SQL .= " (oxaff.account_id) as ".$val.',';
						$SQL .= " (oxaff.name) as AFF_NAME,";
						$SQL .= " (oxaff.dj_is_deleted) as PUB_DEL_STATUS,";
					break;
					case 'CAM_ID';
						if($search['account_type'] !== 'TRAFFICKER'){
							$SQL .= " (oxc.campaignid) as ".$val.',';
							$SQL .= " (oxc.campaignname) as CAM_NAME,";
						}
					break;
					case 'RTYPE';
						if($search['account_type'] !== 'TRAFFICKER'){
							$SQL .= " (dcrt.revenue_type) as ".$val.',';
							$SQL .= " (oxc.revenue_type) as revenue_type,";
						}
					break;
					case 'BAN_ID';
						if($search['account_type'] !== 'TRAFFICKER'){
							$SQL .= " (oxb.bannerid) as ".$val.',';
							$SQL .= " (oxb.description) as BAN_NAME,";
						}
					break;
					case 'ADSIZE';
						if($search['account_type'] === 'TRAFFICKER'){
							$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
						}
						else
						{
							if($page==='REPORT_PUBLISHER')
							{
								$SQL .= " CONCAT(oxz.width, 'x', oxz.height) as ".$val.',';
							}
							else
							{
								$SQL .= " CONCAT(oxb.width, 'x', oxb.height) as ".$val.',';
							}							
						}
					break;		
					case 'SITE_ID';
						if($search['account_type'] !== 'ADVERTISER'){
							$SQL .= " (oxps.site_id) as ".$val.',';
							$SQL .= " (oxps.site_name) as SITE_NAME,";
							$SQL .= " (oxps.site_url) as SITE_URL,";
						}
					break;
					case 'ZONE_ID';
						if($search['account_type'] !== 'ADVERTISER'){
							$SQL .= " (oxz.zoneid) as ".$val.',';
							$SQL .= " (oxz.zonename) as ZONE_NAME,";
						}
					break;		
					case 'COUNTRY';
						
						$SQL .= " (djc.name) as ".$val.",";
						$SQL .= " (oxah.country) as country_code,";
					break;
					case 'DOMAIN_ID';
						$SQL .= " (oxah.domain) as ".$val.',';
						$SQL .= " (oxah.domain) as DOMAIN_NAME,";
					break;
					case 'ENV';
						$SQL .= " (oxah.dj_delivery_media_type) as ".$val.",";
					break;						
				}
			}
			
			$SQL .= " IFNULL(SUM(oxah.impressions),0) as impr,IFNULL(SUM(oxah.clicks),0) as click,IFNULL(SUM(oxah.conversions),0) as conv,IFNULL(SUM(oxah.requests),0) as req ";	
			//REMOVE comma at End of the string
		
			$SQL = rtrim($SQL, ",");
			
			$SQL .= " FROM rv_data_summary_ad_hourly as oxah ";
			
			if(is_array($search) AND count($search) > 0 AND array_key_exists('account_id',$search) AND $search['account_id'] != ''){
			
				$SQL .= " LEFT JOIN djax_targ_country as djc ON djc.value=oxah.country ";
				
				if($search['account_type'] === "ADVERTISER"){				
					
					if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
						$creativeid	=	implode(',',$search['creative_id']);
						$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$creativeid.") )";
					}
					else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
						$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid='".$search['creative_id']."')";
					}
					else
					{
						$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id";
					}
					
					if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
						
						if(in_array('custom',$search['adsize']))
						{
							$si	=	array();
							foreach($search['adsize'] as $siz):
								if($siz!='custom')
								{
									$si[]	=	$siz;
								}
							endforeach;
							if(!empty($si)):	
								$size	=	implode("','",$si);												
								$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
							endif;
						}
						else
						{
							$size	=	implode("','",$search['adsize']);												
							$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
						}
					}
					else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
						$size	=	explode('x',$search['adsize']);
						$SQL .= " AND oxb.width=".$size[0]." AND oxb.height=".$size[1]." ";
					}			
					
					if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
						$campid	=	implode(',',$search['campaign_id']);
						$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
					}
					else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
						$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
					}
					else
					{
						$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
						
					}
					if(isset($search['revenue_type']) AND $search['revenue_type']!='' AND is_array($search['revenue_type'])){
						$camp_type	=	implode(',',$search['revenue_type']);
						$SQL .= " AND oxc.revenue_type IN (".$camp_type.") ";
					}
					else if(isset($search['revenue_type']) AND $search['revenue_type'] != '' AND !is_array($search['revenue_type'])){
						$SQL .= " AND oxc.revenue_type='".$search['revenue_type']." ";
					}
					
					$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
				
					$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['account_id'].")";
					
				}
				else if($search['account_type'] === "TRAFFICKER"){
				
					if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
						$adblockid	=	implode(',',$search['adblock_id']);
						$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$adblockid.") )";
					}
					else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
						$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
					}
					else
					{
						$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id";
					}
					
					if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
						
						if(in_array('custom',$search['adsize']))
						{
							$si	=	array();
							foreach($search['adsize'] as $siz):
								if($siz!='custom')
								{
									$si[]	=	$siz;
								}
							endforeach;
							if(!empty($si)):	
								$size	=	implode("','",$si);												
								$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) NOT IN ('".$size."') ";
							endif;
						}
						else
						{
							$size	=	implode("','",$search['adsize']);												
							$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) IN ('".$size."') ";
						}
					}
					
					else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
						$size	=	explode('x',$search['adsize']);
						$SQL .= " AND oxz.width=".$size[0]." AND oxz.height=".$size[1]." ";
					}
					$SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
					
					if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
						$siteid	=	implode(',',$search['site_id']);
						$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id IN (".$siteid.") )";
					}
					else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
						$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='".$search['site_id']."')";
					}
					else
					{
						$SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
					}
			
					$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=".$search['account_id'].")";
			  }
			  else if($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER"){
			  
			  		// LINK ADVERTISER RELATED TABLES	
					if($page!='REPORT_PUBLISHER')
					{
						if(isset($search['creative_id']) AND $search['creative_id'] != '' AND is_array($search['creative_id'])){
							$creativeid	=	implode(',',$search['creative_id']);
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid IN (".$creativeid.") )";
						}
						else if(isset($search['creative_id']) AND $search['creative_id'] != '' AND !is_array($search['creative_id'])){
							$SQL .= "  JOIN rv_banners as oxb ON ( oxb.bannerid=oxah.ad_id AND oxb.bannerid='".$search['creative_id']."')";
						}
						else
						{
							$SQL .= "  JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id";
						}
						
						if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
							
							if(in_array('custom',$search['adsize']))
							{
								$si	=	array();
								foreach($search['adsize'] as $siz):
									if($siz!='custom')
									{
										$si[]	=	$siz;
									}
								endforeach;
								if(!empty($si)):	
									$size	=	implode("','",$si);												
									$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) NOT IN ('".$size."') ";
								endif;
							}
							else
							{
								$size	=	implode("','",$search['adsize']);												
								$SQL .= " AND CONCAT_WS('x', oxb.`width`, oxb.`height`) IN ('".$size."') ";
							}
						}
						else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
							$size	=	explode('x',$search['adsize']);
							$SQL .= " AND oxb.width=".$size[0]." AND oxb.height=".$size[1]." ";
						}			
						
						if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND is_array($search['campaign_id'])){
							$campid	=	implode(',',$search['campaign_id']);
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid IN (".$campid.") )";
						}
						else if(isset($search['campaign_id']) AND $search['campaign_id'] != '' AND !is_array($search['campaign_id'])){
							$SQL .= " JOIN rv_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='".$search['campaign_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
							
						}
						if(isset($search['revenue_type']) AND $search['revenue_type']!='' AND is_array($search['revenue_type'])){
							$camp_type	=	implode(',',$search['revenue_type']);
							$SQL .= " AND oxc.revenue_type IN (".$camp_type.") ";
						}
						else if(isset($search['revenue_type']) AND $search['revenue_type'] != '' AND !is_array($search['revenue_type'])){
							$SQL .= " AND oxc.revenue_type='".$search['revenue_type']." ";
						}					
						$SQL .= " JOIN djax_conf_revenue_type as dcrt ON dcrt.revenue_type_value=oxc.revenue_type ";					
						
						if(isset($search['adv_account_id']) AND $search['adv_account_id'] !== '' AND is_array($search['adv_account_id']) AND $search['adv_account_id'] > 0){
							$advid	=	implode(',',$search['adv_account_id']);
							$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id IN (".$advid.") )";
						}
						else if(isset($search['adv_account_id']) AND $search['adv_account_id'] !== '' AND !is_array($search['adv_account_id']) AND $search['adv_account_id'] > 0){
							
							$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=".$search['adv_account_id'].")";
						}
						else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
							$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=".$search['agency_id'].")";
						}
						else
						{
							$SQL .= " JOIN rv_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
						}			
					}	
					
					if($page!=='REPORT_ADVERTISER')
					{
						// LINK TRAFFICKER RELATED TABLES
						
						if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
							$adblockid	=	implode(',',$search['adblock_id']);
							$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid IN (".$adblockid.") )";
						}
						else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
							$SQL .= " JOIN rv_zones as oxz ON ( oxz.zoneid=oxah.zone_id AND oxz.zoneid='".$search['adblock_id']."')";
						}
						else
						{
							$SQL .= " JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id";
						}
						
						if($page!=='PLATFORM_REPORT')
						{
							if(isset($search['adsize']) AND $search['adsize'] != '' AND is_array($search['adsize'])){
						
								if(in_array('custom',$search['adsize']))
								{
									$si	=	array();
									foreach($search['adsize'] as $siz):
										if($siz!='custom')
										{
											$si[]	=	$siz;
										}
									endforeach;
									if(!empty($si)):	
										$size	=	implode("','",$si);												
										$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) NOT IN ('".$size."') ";
									endif;
								}
								else
								{
									$size	=	implode("','",$search['adsize']);												
									$SQL .= " AND CONCAT_WS('x', oxz.`width`, oxz.`height`) IN ('".$size."') ";
								}
							}
							
							else if(isset($search['adsize']) AND $search['adsize'] != '' AND !is_array($search['adsize'])){
								$size	=	explode('x',$search['adsize']);
								$SQL .= " AND oxz.width=".$size[0]." AND oxz.height=".$size[1]." ";
							}
						}
						
						$SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
						
						if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id']) ){
							$siteid	=	implode(',',$search['site_id']);
							$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id IN (".$siteid.") )";
						}
						else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
							$SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='".$search['site_id']."')";
						}
						else
						{
							$SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
						}
				
						if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
							$pubid	=	implode(',',$search['pub_account_id']);
							$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id IN (".$pubid.") )";
						
						}
						else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
							$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=".$search['pub_account_id'].")";
						
						}
						else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
							$SQL .= " JOIN rv_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=".$search['agency_id'].")";
						}else{
							$SQL .= " JOIN rv_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
						}	
					}		
				}			
			}				
			
			$SQL .= "  WHERE 1 ";
					
			if(is_array($search) AND count($search) > 0){
				
				if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
					$country	=	implode("','",$search['country']);
					$SQL .= " AND oxah.country IN ('".$country."') ";
				}
				else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
					$SQL .= " AND oxah.country = '".$search['country']." ";
				}				
				
				if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
					$SQL .= " AND ((oxah.date_time)  >= '".$search['date_from']."' AND (oxah.date_time) <= '".$search['date_to']."')";
				}
				else if(isset($search['date_from']) AND $search['date_from'] != ''){					
					$SQL .= " AND (oxah.date_time) = '".$search['date_from']."'";					
				}
				
				if(isset($search['environment']) AND $search['environment'] != ''){
					$SQL .= " AND dj_delivery_media_type='".$search['environment']."'";
				}
				
				
				if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
					$SQL .= " AND (";
					foreach($search['search_fields'] as $sObj){
						$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
					}
				
					$SQL = rtrim($SQL, "OR");
				
					$SQL .= " )";					
				}
				
			}			
			
			if(is_array($group) AND count($group) > 0){
			
				$SQL .= " GROUP BY ";
				
				foreach($group as $val){
					switch($val){
						case 'DATE';
						case 'TIME';
						case 'MONTH';
							$SQL .= " {$date_field} ,";
							break;
						case 'HOUR';
							$SQL .= " DATE_FORMAT(oxah.date_time,'%d-%m-%Y'), TIME(oxah.date_time) ,";
							break;
						case 'ACC_ID';
							if($search['account_type'] === 'ADVERTISER'){
								$SQL .= "oxcl.account_id,";
							}
							else if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= "oxaff.account_id,";
							}
							else if($search['account_type'] === 'ADMIN'){
								
								if($search['page']==='REPORT_ADVERTISER'){
									$SQL .= "oxcl.account_id,";
								}
								else if($search['page']==='REPORT_PUBLISHER')
								{
									$SQL .= "oxaff.account_id,";
								}
							}
							break;
						case 'ADV_ID';							
							$SQL .= "oxcl.account_id,";
							break;
						case 'AFF_ID';
							$SQL .= "oxaff.account_id,";
							break;
						case 'CAM_ID';
							$SQL .= "oxc.campaignid,";
							break;
						case 'RTYPE';
							$SQL .= "oxc.revenue_type,";
							break;
						case 'BAN_ID';
							$SQL .= "oxb.bannerid,";
							break;
						case 'ADSIZE';
							if($search['account_type'] === 'TRAFFICKER'){
								$SQL .= "oxz.width,oxz.height,";
							}
							else
							{
								if($page==='REPORT_PUBLISHER')
								{
									$SQL .= "oxz.width,oxz.height,";
								}
								else
								{
									$SQL .= "oxb.width,oxb.height,";
								}
							}
							break;
						case 'AFF_ID';
							$SQL .= "oxaff.account_id,";
							break;
						case 'SITE_ID';
							$SQL .= "oxps.site_id,";
							break;	
						case 'ZONE_ID';
							$SQL .= "oxz.zoneid,";
							break;
						case 'COUNTRY';
							$SQL .= "oxah.country,";
							break;
						case 'DOMAIN_ID';
							$SQL .= "oxah.domain,";
							break;
						case 'ENV';
							$SQL .= "oxah.dj_delivery_media_type,";
							break;		
					}
				}
				
			}			
			$SQL = rtrim($SQL, ",");	
			
			$da		=	array('DATE','TIME','HOUR','MONTH');
			
			if(is_array($order) AND count($order) > 0){
				
				$of	=	0;
				
				foreach($order as $key=>$option){
					if(in_array($key,$da))
					{
						$of	=	1;	
					}			
				}
				
				if($of==1)
				{
					$SQL .= " ORDER BY oxah.date_time {$option} ";
				}
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				$of	=	0;
				
				foreach($ord as $key){
					if(in_array($key,$da))
					{
						$of	=	1;	
					}			
				}
				
				if($of==1)
				{
					$SQL .= " ORDER BY oxah.date_time ASC ";
				}
				//REMOVE comma at End of the string
		
				$SQL = rtrim($SQL, ",");
			}
							
		}
		
		$SQL .= " ) as r WHERE r.impr>0 OR r.click>0 OR r.conv>0 OR r.req>0 ";
		
		$num	=	array('IMP','CLK','CON','SPEND','REVENUE','PROFIT','CTR','ECPM','ECPC');
		
		if(is_array($order) AND count($order) > 0){
			
			$OSQL	=	'';
			foreach($order as $key=>$option){
				if(in_array($key,$num))
				{
					$OSQL .= " REPLACE({$key},',','') + 0 {$option},";	
				}
				else
				{
					if(!in_array($key,$da))
					{
						$OSQL .= " {$key} {$option},";
					}
				}		
			}
			$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";		
			//REMOVE comma at End of the string
	
			$SQL = rtrim($SQL, ",");
		}
		elseif((!is_array($order)) && $order!='')
		{
			$ord	=	explode(',', $order);
			
			$OSQL	=	'';
			
			foreach($ord as $key){
				if(in_array($key,$num))
				{
					$OSQL .= " REPLACE({$key},',','') + 0 ASC,";	
				}
				else
				{
					if(!in_array($key,$da))
					{
						$OSQL .= " {$key} ASC,";
					}
				}		
			}
			
			$SQL .= ($OSQL!='')?" ORDER BY ".$OSQL:"";			
			//REMOVE comma at End of the string
	
			$SQL = rtrim($SQL, ",");
		}	
		
		if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
				
			$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
		}
		else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
			$SQL .=	 " LIMIT ".$limit['end']."";
		}
      
    // return  $SQL;
        $query = $this->db->query($SQL); 
		//echo $this->db->last_query();exit;
		
        if($dataTable){
			$data 	= 	$query->result_array();
			
			$total	= 	$this->db->query('SELECT FOUND_ROWS() count;')->row()->count;
			
			if($data)
			{	
				
				$res	=	array(
									'data'	=>	$data,
									'total'	=>	$total
								);	
				return $res;
			}
			else
			{
				return FALSE;
			} 
		}
		else
		{
			$fields = $query->list_fields(); 
			
			$data = $query->result_array();
			$res['fields'] = $fields;
			$res['records'] = $data; 
			
			if($data)
			{			
				return $res;
			}
			else
			{
				return FALSE;
			} 
		}
	}
	
	function fetch_last_request($where=FALSE)
	{	
		
		$key = 'fetch_last_request';		
		if($where!=FALSE)
		{
			$key.='_'.$where['account_type'].'_'.$where['account_id'];
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		//~ if($ret && $mem_cache=='enable' )
		//~ {
			//~ return $ret;
		//~ }
		//~ else{
		
		
			if($where!=FALSE)
			{
				$this->db->where($where);
			}
			$this->db->order_by('id','desc');
			
			$query	=	$this->db->get(TAB_REQUEST_REPORT);
			
			if($query->num_rows()>0)
			{
				
				$res	=	$query->result_array();
				$request	=	$res[0];
			
				$search	=	array(
								'account_type'	=>	$request['account_type'],
								'account_id'	=>	$request['account_id'],
								'agency_id'		=>	$this->user_authentication->agency_id,
								'format'		=>	$request['format']
							);
				
				$search['advertiser']	=	($request['advertiser'])?$request['advertiser']:'';
				$search['campaign']		=	($request['campaign'])?$request['campaign']:'';
				$search['creative']		=	($request['creative'])?$request['creative']:'';
				$search['publisher']	=	($request['publisher'])?$request['publisher']:'';
				$search['site']			=	($request['site'])?$request['site']:'';
				$search['zone']			=	($request['zone'])?$request['zone']:'';
				$search['rtype']		=	($request['rtype'])?$request['rtype']:'';
				$search['adsize']		=	($request['adsize'])?$request['adsize']:'';
				
				$search['device']		=	$request['device'];
				
				$search['display_by']	=	$request['display_by'];
				
				$search['columns']		=	($request['columns'])?$request['columns']:'';
				
				$search['group_by']		=	($request['group_by'])?$request['group_by']:'';
				
				if($request['frequency']=='Daily')
				{
					$search['date_from']	=	'2016-01-01';//date('Y-m-d H:i:s', strtotime('Yesterday'));
					
					$search['date_to']		=	date('Y-m-d H:i:s', strtotime('Yesterday'));
				}
				else if($request['frequency']=='Weekly')
				{
					$search['date_from']	=	date('Y-m-d H:i:s', strtotime('last Sunday'));//'2015-12-04 00:00:00';

					$search['date_to']		=	date('Y-m-d H:i:s', strtotime('last Saturday'));
				}
				else if($request['frequency']=='Monthly')
				{
					$search['date_from']	=	date('Y-m-d H:i:s', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));

					$search['date_to']		=	date('Y-m-d H:i:s', mktime(0, 0, 0, date('m'), 0, date('Y')));
				}
				else
				{
					$search['date_from']	=	$request['from_date'];

					$search['date_to']		=	$request['to_date'];
				}			
			
				$data	=	$this->fetch_request_report($search);
				
				$result		=	array(
									'request'	=>	$request,
									'search'	=>	$search,
									'data'		=>	$data
								);
				
				//~ if($mem_cache=='enable' )
				//~ {
					//~ $account_type=$this->user_authentication->account_type;
					//~ $this->memcached_library->set($key,$result,$account_type);	
					//~ $set = $this->memcached_library->get($key);	
					//~ return $set;
				//~ }
				//~ else{
					return $result;
			//	}
				
			}
			else
			{
				return FALSE;
			}
		//}
	
	}
	


	function fetch_detail_info($search,$order=null,$limit=false,$agency_id=false)
	{
		log_message('error','-------------------');
		log_message('error',print_r($search,true));
		log_message('error','-------------------');
		$key = 	'fetch_detail_info_report_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		$key .=	$limit['start'].'_'.$limit['end'].'_'.$agency_id;
		
		//$key = 'fetch_detail_info_stats_'.$search.'_'.$order.'_'.$limit.'_'.$agency_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			if(empty($search['app_id']))
			{
			$SQL 	= 	"SELECT 
			imr.zoneid, 
			imr.adid, 
			imr.domain as DOMAIN, 
			imr.ip as IP, 
			imr.country_name as COUNTRY, 
			imr.region as REGIN, 
			imr.device_type as DEVICE_TYPE, 
			imr.user_agent as USER_AGENT, 
			imr.os as OS, 
			imr.sitereferurl as REFERRER_URL, 
			imr.device_model, 
			imr.browsername as BROWSER,
			oxps.site_name as SITE_NAME,
			oxps.site_url as SITE_URL			


FROM  ";
if($search['field_name']=='imp')
{
$SQL  	.= "rv_djax_impression_reports  as imr";
}
if($search['field_name']=='clk')
{
$SQL  	.= "rv_djax_click_reports  as imr";
}
$SQL  	.= "  JOIN rv_banners as oxb ON oxb.bannerid=imr.adid
    
JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid 
    
JOIN rv_zones as oxz ON oxz.zoneid=imr.zoneid

JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid 

JOIN djax_publisher_sites as oxps on   oxps.site_id=dsza.site_id 

WHERE 1";


$SQL	.= " AND oxps.site_id='".$search['site_id']."' ";
}
else if(!empty($search['app_id']))
{
				$SQL 	= 	"SELECT 
			imr.zoneid, 
			imr.adid, 
			imr.domain as DOMAIN, 
			imr.ip as IP, 
			imr.country_name as COUNTRY, 
			imr.region as REGIN, 
			imr.device_type as DEVICE_TYPE, 
			imr.user_agent as USER_AGENT, 
			imr.os as OS, 
			imr.sitereferurl as REFERRER_URL, 
			imr.device_model, 
			imr.browsername as BROWSER,
			tmp.app_name as APP_NAME,
			tmp.app_url as APP_URL,
			tmp.platform as PLATFORM,
			tmp.site_url as SITE_URL			


FROM  ";
if($search['field_name']=='imp')
{
$SQL  	.= "rv_djax_impression_reports  as imr";
}
if($search['field_name']=='clk')
{
$SQL  	.= "rv_djax_click_reports  as imr";
}
$SQL  	.= "  JOIN rv_banners as oxb ON oxb.bannerid=imr.adid
    
JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid 
    
JOIN rv_zones as oxz ON oxz.zoneid=imr.zoneid

JOIN djax_app_zone_assoc as daza ON daza.zone_id=oxz.zoneid 

JOIN djax_temp_url as tmp on   tmp.account_id=daza.account_id 

WHERE 1";


$SQL	.= " AND tmp.email='".$search['email']."' ";
}

					
			/*if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				$SQL .= " AND (DATE(req.datetime)  >= '".$search['date_from']."' AND DATE(datetime) <= '".$search['date_to']."')";
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$SQL .= " AND DATE(req.datetime) = '".$search['date_from']."'";
			}
			
			if(isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term']!= ''){
				$SQL .= " AND (";
				foreach($search['search_fields'] as $sObj){
					$SQL .="  {$sObj} LIKE '%".$search['search_term']."%' OR";	
				}
			
				$SQL = rtrim($SQL, "OR");
			
				$SQL .= " )";			
			}
		
			$SQL .= " GROUP BY req.exchange_id ";
			
			if($order != null && !empty($order['field']) && !empty($order['order']))
			{
				$SQL .= " ORDER BY ".$order['field']." ". $order['order'];
			}
			else
			{
				$SQL .= " ORDER BY req.exchange_id DESC";
			}
			*/
			if(is_array($limit) AND array_key_exists('start',$limit) AND $limit['start'] !=0 AND array_key_exists('end',$limit) AND $limit['end'] !='' ){
				
				$SQL .=	 " LIMIT ".$limit['start'].",".$limit['end']."";
			}
			else if(is_array($limit) AND array_key_exists('end',$limit) AND $limit['end'] !=''){
				$SQL .=	 " LIMIT ".$limit['end']."";
			}
		
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			log_message('error',$SQL.'-------------------------');
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else
				{				
				return $result;
				}			
				
			}
			else
			{
				return FALSE;	
			}
		}
	}	
	
	
	
	/*function fetch_detail_info1($search,$order=null,$limit=false,$agency_id=false,$totals=false,$chart=false)
	{
		

		$SQL = "SELECT SQL_CALC_FOUND_ROWS null as rows,r.* FROM (SELECT (sa.id) as APP_ID, 
		(sa.site_name) as APP_NAME, 
		(sa.site_url) as APP_URL, 
		(dbs.user_agent) as USER_AGENT,
		(dss.site_referrer_url) as REFERRER_URL, 
		(dgs.country) as COUNTRY, 
		(dgs.country_code) as country_code, 
		DATE_FORMAT(oxah.date_time,'%d-%m-%Y') as DATE, 
		IFNULL(SUM(oxah.impressions),0) as IMP, 
		IFNULL(SUM(oxah.clicks),0) as CLK,
		IFNULL(SUM(oxah.conversions),0) as CONVS,
		IFNULL(SUM(oxah.requests),0) as REQUEST, 
		(dbs.browser_name) as BROWSER, 
		(dcs.os) as OS, 
		(djs.domain) as DOMAIN,
		IFNULL(SUM(oxah.dj_unique_impressions),0) as UIMP,
		IFNULL(SUM(oxah.dj_unique_clicks),0) as UCLK,
		 TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(oxah.dj_publisher_earnings),0),4))) as PUB_EARN, 
		 CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0),2))) END as PUB_ECPM, DATE(oxah.date_time) as date_time,
		 IFNULL(SUM(oxah.impressions),0) as impr,
		 IFNULL(SUM(oxah.clicks),0) as click,
		 IFNULL(SUM(oxah.conversions),0) as conv,
		 IFNULL(SUM(oxah.requests),0) as req 
		 FROM rv_data_summary_ad_hourly as oxah 
		 
		 
		 
		 LEFT JOIN djax_geographical_stats as dgs ON ( dgs.ad_id=oxah.ad_id AND dgs.zone_id=oxah.zone_id AND dgs.date_time=oxah.date_time )
		 
		  LEFT JOIN djax_sites_stats as djs ON ( djs.ad_id=oxah.ad_id AND djs.zone_id=oxah.zone_id AND djs.date_time=oxah.date_time ) 
		  LEFT JOIN djax_browsers_stats as dbs ON ( dbs.ad_id=oxah.ad_id AND dbs.zone_id=oxah.zone_id AND dbs.date_time=oxah.date_time ) 
		  LEFT JOIN djax_clients_stats as dcs ON ( dcs.ad_id=oxah.ad_id AND dcs.zone_id=oxah.zone_id AND dcs.date_time=oxah.date_time )
		  LEFT JOIN djax_sites_stats as dss ON ( dss.ad_id=oxah.ad_id AND dss.zone_id=oxah.zone_id AND dss.date_time=oxah.date_time ) 
		  JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid 
		  JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id 
		  JOIN ( SELECT  dsza.zone_id, oxps.site_id as id, oxps.account_id, oxps.site_name as site_name, oxps.site_url as site_url FROM  djax_publisher_sites as oxps JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
		
		
		
		 WHERE 1 UNION SELECT  daza.zone_id, daza.app_id as id, dtu.account_id, dtu.app_name as site_name, dtu.app_url as site_url FROM  djax_temp_url as dtu JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id  WHERE 1 ) as sa ON sa.zone_id=oxz.zoneid 
		 
		 
		 
		 		 
		 
		 
		 JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id AND oxaff.account_id=21) 
		 
		 WHERE 1 AND oxah.date_time BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE()";
		 if(empty($totals)){
		 $SQL .=" GROUP BY DATE_FORMAT(oxah.date_time,'%d-%m-%Y') ORDER BY oxah.date_time DESC";
		}
		 
		$SQL .= " ) as r 
		 
		 WHERE r.impr>0 OR r.click>0 OR r.conv>0 OR r.req>0 ORDER BY APP_ID DESC, DATE DESC";
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			log_message('error',$SQL.'-------------------------');
			
			if($query->num_rows() >0)
			{
				if(empty($chart))
				{
				$result = 	$query->result_array();
				return $result;
				}
				else
				{
				$fields = $query->list_fields(); 
				
				$data = $query->result_array();
				$res['fields'] = $fields;
				$res['records'] = $data;
				return $res;
				}
			}
			else
			{
				

				return FALSE;	
			}
		}*/
		
	function fetch_detail_info2($search=false)
	{
		$mem_key = 	'detail_info2';
		
		if(!empty($search['site_id']))
		{
			$mem_key.='_'.$search['site_id'];
		}
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}		
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device'];
		}
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{	
			return $ret;  
		}
		else{
		if(!empty($search['site_id']))
		{
		if(!empty($search['field_name']))
		{			
		$SQL = "SELECT
				DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
				DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,	
				DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
				t1.interval_start as TIME_DATE,
				rz.zonename as ZONE_NAME,			
				t1.country_name as COUNTRY,
				t1.domain as DOMAIN,
				t1.user_agent as USER_AGENT,
				t1.os as OS,t1.browsername as BROWSER,
				t1.sitereferurl as REFERRER_URL,
				oxps.site_name as SITE_NAME,
				oxps.site_url as SITE_URL
				FROM "; 
				
				if($search['field_name']=='imp')
				{
				$SQL  	.= " rv_djax_impression_reports as t1 ";
				}
				if($search['field_name']=='clk')
				{
				$SQL  	.= " rv_djax_click_reports  as t1";
				}
				if($search['field_name']=='con')
				{
				$SQL  	.= " rv_djax_conversion_reports  as t1";
				}				
		        $SQL  	.=" JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=t1.zoneid 
					JOIN rv_zones as rz ON rz.zoneid = t1.zoneid
				JOIN djax_publisher_sites as oxps on   (oxps.site_id=dsza.site_id 
				AND oxps.site_id='".$search['site_id']."')
				WHERE t1.zoneid= dsza.zone_id ";
				if(!empty($search['date_from']) && !empty($search['date_to']))
				{
				$SQL  	.="	AND t1.interval_start BETWEEN '".$search['date_from']." 00:00:00.000000' AND '".$search['date_to']." 23:59:59.999999'";
				}
				if(!empty($search['country']) && $search['country'] != 'all')
				{
						//$c_name = $this->fetch_group($search['country']);
						$c_name = explode(',',$search['country']);
						$max = count($c_name)-1;
						for($i=0;$i<count($c_name);$i++) 
						{							
							if($max != $i)
							{
							$stringd .= "'".$c_name[$i]."',";
							}
							else
							{
							$stringd .= "'".$c_name[$i]."'";
							}								
						}			
				$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
									 WHERE value IN (".$stringd.") )";	
				}					
				if(!empty($search['device']) && $search['device'] != 'all')
				{
					if($search['device'] == 'Display')
					{
						$SQL	.= " AND t1.device_type = 'web' ";
					}
					else if($search['device'] == 'Mobile')
					{
						$SQL	.= " AND t1.device_type = 'mobile' ";
					}
					else if($search['device'] == 'Tablet')
					{
						$SQL	.= " AND t1.device_type = 'tablet' ";
					}
				}				
				$query = $this->db->query($SQL);		
			
				if($query->num_rows() >0)
				{
					$result = 	$query->result_array();
					
					if($mem_cache=='enable')
				    {
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($mem_key,$result,$account_type);	
					$set = $this->memcached_library->get($mem_key);	
					return $set;
				    }
				    else
					{
					return $result;
				    }
				}
				else
				{
					return FALSE;	
				}
		}
		}
		
		}
		}		
	function fetch_detail_info3($search=false)
	{
		$mem_key ='detail_info3';
		
		if(!empty($search['app_id']))
		{
			$mem_key.='_'.$search['app_id'];
		}
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}		
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device'];
		}
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{	
			return $ret;  
		}
		else
		{			
		if(!empty($search['app_id'])){
			if(!empty($search['field_name'])){
		$SQL = "SELECT 
				DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
				DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,	
				DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
				t1.interval_start as TIME_DATE,				
				t1.country_name as COUNTRY,t1.domain as DOMAIN,
				t1.user_agent as USER_AGENT,t1.os as OS,t1.browsername as BROWSER,
				t1.sitereferurl as REFERRER_URL,
				oxps.app_name as APP_NAME,
				oxps.app_url as APP_URL
				FROM "; 
				
if($search['field_name']=='imp')
{
$SQL  	.= " rv_djax_impression_reports as t1 ";
}
if($search['field_name']=='clk')
{
$SQL  	.= " rv_djax_click_reports  as t1";
}	
if($search['field_name']=='con')
{
$SQL  	.= " rv_djax_conversion_reports  as t1";
}			
		$SQL  	.=" JOIN djax_app_zone_assoc as dsza ON dsza.zone_id=t1.zoneid 

				JOIN djax_temp_url as oxps on oxps.id='".$search['app_id']."'
				WHERE  t1.zoneid IN (SELECT zone_id FROM djax_app_zone_assoc WHERE app_id='".$search['app_id']."' )
				";
if(!empty($search['date_from']) && !empty($search['date_to']))
{
		$SQL  	.="	AND t1.interval_start 
					BETWEEN '".$search['date_from']." 00:00:00.000000' 
					AND '".$search['date_to']." 23:59:59.999999'
					";
}				
if(!empty($search['country']) && $search['country'] != 'all')
{
		//$c_name = $this->fetch_group($search['country']);
		$c_name = explode(',',$search['country']);
		$max = count($c_name)-1;
		for($i=0;$i<count($c_name);$i++) 
		{
			
			if($max != $i)
			{
			$stringd .= "'".$c_name[$i]."',";
			}
			else
			{
			$stringd .= "'".$c_name[$i]."'";
			}
				
		}			
		$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
					 WHERE value IN (".$stringd.") )";	
}					
if(!empty($search['device']) && $search['device'] != 'all')
{
	if($search['device'] == 'Display')
	{
		$SQL	.= " AND t1.device_type = 'web' ";
	}
	else if($search['device'] == 'Mobile')
	{
		$SQL	.= " AND t1.device_type = 'mobile' ";
	}
	else if($search['device'] == 'Tablet')
	{
		$SQL	.= " AND t1.device_type = 'tablet' ";
	}
}				
				
				
			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				
				if($mem_cache=='enable')
				    {
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($mem_key,$result,$account_type);	
					$set = $this->memcached_library->get($mem_key);	
					return $set;
				    }
				    else
					{
				return $result;
			}
			}
			else
			{
				return FALSE;	
			}
		}
		}
		}
	}

	function fetch_detail_info4($search=false)
	{
		$mem_key = 	'detail_info4';
		
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}		
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device'];
		}
		
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		
		if($ret && $mem_cache=='enable' )
		{				
			return $ret;  
		}
		else
		{	
			if(!empty($search['field_name'])){
		$SQL = "SELECT 
				DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
				DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,	
				DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,		
				t1.interval_start as TIME_DATE,			
				t1.country_name as COUNTRY,t1.domain as DOMAIN,
				t1.user_agent as USER_AGENT,t1.os as OS,t1.browsername as BROWSER,
				t1.sitereferurl as REFERRER_URL,

				rz.zonename as ZONE_NAME
				FROM"; 
				
if($search['field_name']=='imp')
{
$SQL  	.= " rv_djax_impression_reports as t1 ";
}
if($search['field_name']=='clk')
{
$SQL  	.= " rv_djax_click_reports  as t1";
}
if($search['field_name']=='con')
{
$SQL  	.= " rv_djax_conversion_reports  as t1";
}			
if($search['search_fields']=='site_name')	
{
		$SQL  	.=" JOIN djax_site_zone_assoc as dsza ON (dsza.zone_id=t1.zoneid 
				AND dsza.zone_id='".$search['adblock_id']."')
				
				JOIN djax_publisher_sites as oxps on   (oxps.site_id=dsza.site_id )";
}
else
{
		$SQL  	.=" JOIN djax_app_zone_assoc as dsza ON (dsza.zone_id=t1.zoneid 
				AND dsza.zone_id='".$search['adblock_id']."')
				
				JOIN djax_temp_url as oxps on   (oxps.id=dsza.app_id )";
}
		$SQL	.=" JOIN rv_zones as rz ON rz.zoneid='".$search['adblock_id']."'
				WHERE t1.zoneid=  '".$search['adblock_id']."'
				";
if(!empty($search['date_from']) && !empty($search['date_to']))
{
		$SQL  	.="	AND t1.interval_start 
					BETWEEN '".$search['date_from']." 00:00:00.000000' 
					AND '".$search['date_to']." 23:59:59.999999'
					";
}				
if(!empty($search['country']) && $search['country'] != 'all')
{
		//$c_name = $this->fetch_group($search['country']);
		$c_name = explode(',',$search['country']);
		$max = count($c_name)-1;
		for($i=0;$i<count($c_name);$i++) 
		{
			
			if($max != $i)
			{
			$stringd .= "'".$c_name[$i]."',";
			}
			else
			{
			$stringd .= "'".$c_name[$i]."'";
			}
				
		}			
		$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
					 WHERE value IN (".$stringd.") )";	
}					
if(!empty($search['device']) && $search['device'] != 'all')
{
	if($search['device'] == 'Display')
	{
		$SQL	.= " AND t1.device_type = 'web' ";
	}
	else if($search['device'] == 'Mobile')
	{
		$SQL	.= " AND t1.device_type = 'mobile' ";
	}
	else if($search['device'] == 'Tablet')
	{
		$SQL	.= " AND t1.device_type = 'tablet' ";
	}
}				
			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				    {
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($mem_key,$result,$account_type);	
					$set = $this->memcached_library->get($mem_key);	
					return $set;
				    }
				    else
					{
				return $result;
			}
			}
			else
			{
				return FALSE;	
			}
		}
	}
		}
		
		
function fetch_app_site_details($search=false)				
	{
		$key="fetch_app_site";
		if(!empty($search['adblock_id']))
		{
			$key.='_'.$search['adblock_id'];
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
				
		if($ret && $mem_cache=='enable' )
		{	
			return $ret;  
		}
		else
		{		
			$SQL = "SELECT site_id FROM djax_site_zone_assoc WHERE zone_id = '".$search['adblock_id']."'";
			$query = $this->db->query($SQL);
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$result,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
				}
				else
				{
				return $result;
				}
			}
			else
			{
				return FALSE;	
			}	
		}		
	}
		
		
	/*function fetch_overview_detail_info($search=false)
	{

		if(!empty($search['field_name'])){
		$SQL = "SELECT DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
				t1.country_name as COUNTRY,t1.domain as DOMAIN,
				t1.user_agent as USER_AGENT,t1.os as OS,t1.browsername as BROWSER,
				t1.sitereferurl as REFERRER_URL

				FROM"; 
				
if($search['field_name']=='imp')
{
$SQL  	.= " rv_djax_impression_reports as t1 ";
}
if($search['field_name']=='clk')
{
$SQL  	.= " rv_djax_click_reports  as t1";
}				
		$SQL  	.=" WHERE t1.interval_start BETWEEN '".$search['date']." 00:00:00.000000' AND 
				'".$search['date']." 23:59:59.999999' ";
		
				
				
			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				return $result;
			}
			else
			{
				return FALSE;	
			}
		}
		
		}*/	
		
		
    function fetch_group($group_id)
    {
		if ($group_id) {
		$c_name = explode(',',$group_id);
		$max = count($c_name)-1;
		for($i=0;$i<count($c_name);$i++) 
		{
			
			if($max != $i)
			{
			$stringd .= "'".$c_name[$i]."',";
			}
			else
			{
			$stringd .= "'".$c_name[$i]."'";
			}
				
		}			

        if ($stringd)
            return $stringd;
        else
            return FALSE;
			
		}

	}		
		
		
	function fetch_overview_detail_info($search=false)
	{ 
		$mem_key="fetch_overview_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['account_type']))
		{
			$mem_key.='_'.$search['account_type'];
		}
		if(!empty($search['site_id']))
		{
			$mem_key.='_'.$search['site_id'];
		}
		if(!empty($search['adblock_id']))
		{
			$mem_key.='_'.$search['adblock_id']; 
		}
		if(!empty($search['campaign_id']))
		{
			$mem_key.='_'.$search['campaign_id']; 
		}
		if(!empty($search['creative_id']))
		{
			$mem_key.='_'.$search['creative_id']; 
		}
		if(!empty($search['report_type']))
		{
			$mem_key.='_'.$search['report_type']; 
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country']; 
		}
		if(!empty($search['dimensions']))
		{
			$mem_key.='_'.$search['dimensions']; 
		}
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');			

		if($ret && $mem_cache=='enable' )
		{			
			return $ret;
		}
		else{	
		if(!empty($search['field_name'])){
			$SQL = "SELECT 
					DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
					DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,
					t1.interval_start as TIME_DATE,
					";
			if($search['account_type'] == 'TRAFFICKER')
			{				
			$SQL  	.= 	   "rz.zonename as ZONE_NAME,
							t2.site_id as SITE_ID,
							t2.site_name as SITE_NAME,
							t2.site_url as SITE_URL,
							
							temm.browser_language as LANGUAGE,
							dcts.traffic_id as TRAFFIC,
							rc.campaignid as CAM_ID,
							rc.campaignname as CAM_NAME,
							rb.bannerid as BAN_ID,
							rb.description as BAN_NAME,";
			}
			else if($search['account_type'] == 'ADVERTISER')
			{
			$SQL  	.= 	   "oxz.zonename as ZONE,
							temm.browser_language as LANGUAGE,
							dcts.traffic_id as TRAFFIC,
							rc.campaignid as CAM_ID,
							rc.campaignname as CAM_NAME,
							rb.bannerid as BAN_ID,
							rb.description as BAN_NAME,";	
			}
				
			$SQL  	.= 	   "DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
							t1.country_name as COUNTRY,
							t1.domain as DOMAIN,
							t1.user_agent as USER_AGENT,
							t1.os as OS,t1.browsername as BROWSER,
							t1.sitereferurl as REFERRER_URL

							FROM "; 
				
			if($search['field_name']=='imp')
			{
			$SQL  	.= " rv_djax_impression_reports as t1 ";
			}
			if($search['field_name']=='clk')
			{
			$SQL  	.= " rv_djax_click_reports  as t1";
			}
			if($search['field_name']=='con')
			{
			$SQL  	.= " rv_djax_conversion_reports  as t1";
			}					
			if($search['account_type'] == 'TRAFFICKER')
			{		
					$SQL  	.=" JOIN djax_site_zone_assoc as t3 ON t3.zone_id = t1.zoneid
								JOIN djax_publisher_sites as t2 ON t2.site_id = t3.site_id AND t2.account_id = '".$search['account_id']."'
								JOIN rv_zones as rz ON rz.zoneid = t1.zoneid 
								JOIN rv_banners as rb ON rb.bannerid = t1.adid 
								JOIN rv_campaigns as rc ON rc.campaignid=rb.campaignid 
								LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=rc.campaignid 

								LEFT JOIN (SELECT dgs.ad_id,dgs.browser_name,dgs.browser_language FROM djax_geographical_stats as dgs WHERE dgs.browser_name IS NOT NULL GROUP BY dgs.ad_id) as temm ON temm.ad_id=rb.bannerid ";
			}
			else if($search['account_type'] == 'ADVERTISER')
			{
					$SQL  	.=" JOIN rv_banners as rb ON rb.bannerid = t1.adid
								JOIN rv_campaigns as rc ON rc.campaignid=rb.campaignid 
								JOIN rv_clients as rcl ON rcl.clientid=rc.clientid AND rcl.account_id = '".$search['account_id']."'
								JOIN rv_zones as oxz ON oxz.zoneid=t1.zoneid 

								LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=rc.campaignid 

								LEFT JOIN (SELECT dgs.ad_id,dgs.browser_name,dgs.browser_language FROM djax_geographical_stats as dgs WHERE dgs.browser_name IS NOT NULL GROUP BY dgs.ad_id) as temm ON temm.ad_id=rb.bannerid ";	
			}
					$SQL  	.="	WHERE t1.interval_start BETWEEN '".$search['date']." 00:00:00.000000' AND 
								'".$search['date']." 23:59:59.999999' ";

				if($search['account_type'] == 'TRAFFICKER')
				{
				if(!empty($search['site_id']))
				{
						$site_id = $this->fetch_group($search['site_id']);
						$SQL	.= " AND t1.zoneid IN (SELECT zone_id FROM djax_site_zone_assoc 
									 WHERE site_id IN (".$site_id."))";
				}					
				if(!empty($search['adblock_id']))
				{
						$adblock_id = $this->fetch_group($search['adblock_id']);
						$SQL	.= " AND t1.zoneid IN (".$adblock_id.") ";
				}
				}
				else if($search['account_type'] == 'ADVERTISER')
				{
				if(!empty($search['campaign_id']) && $search['campaign_id'] != 'all')
				{
						$campaign_id = $this->fetch_group($search['campaign_id']);
						$SQL	.= " AND t1.adid IN (SELECT bannerid FROM rv_banners 
									 WHERE campaignid IN (".$campaign_id."))";
				}					
				if(!empty($search['creative_id']) && $search['creative_id'] != 'all')
				{
						$creative_id = $this->fetch_group($search['creative_id']);
						$SQL	.= " AND t1.adid IN (".$creative_id.") ";
				}	
				}
				if($search['report_type'] == 'geo')
				{			
					$SQL	.= " AND t1.country_name = '".$search['country']."'";
				}
				else
				{		
				if(!empty($search['country']) && $search['country'] != 'all')
				{
						//$c_name = $this->fetch_group($search['country']);
						$c_name = explode(',',$search['country']);
						$max = count($c_name)-1;
						for($i=0;$i<count($c_name);$i++) 
						{
							
							if($max != $i)
							{
							$stringd .= "'".$c_name[$i]."',";
							}
							else
							{
							$stringd .= "'".$c_name[$i]."'";
							}
								
						}			
						$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
									 WHERE value IN (".$stringd.") )";
				}
				}					
				if(!empty($search['device']) && $search['device'] != 'all')
				{
					if($search['device'] == 'Display')
					{
						$SQL	.= " AND t1.device_type = 'web' ";
					}
					else if($search['device'] == 'Mobile')
					{
						$SQL	.= " AND t1.device_type = 'mobile' ";
					}
					else if($search['device'] == 'Tablet')
					{
						$SQL	.= " AND t1.device_type = 'tablet' ";
					}
				}
				if(!empty($search['dimensions']))
				{	
					$group = $search['dimensions'];
					if(!is_array($group))
					{
					$group = explode(",",$search['dimensions']);
					}
		
				if(is_array($group) AND count($group) > 0){
											
					$SQL .= " GROUP BY ";
					
					foreach($group as $val){
						switch($val){	
							case 'CAM_ID';
								$SQL .= "rc.campaignid,";
								break;
							case 'DATE';
								$SQL .= "t1.interval_start,";
								break;
							case 'SITE_ID';
								$SQL .= "t2.site_id,";
								break;
							case 'BAN_ID';
								$SQL .= "rb.bannerid,";
								break;
							case 'ZONE';
								$SQL .= "oxz.zoneid,";
							case 'ZONE_ID';
								$SQL .= "rz.zoneid,";
								break;
							case 'TRAFFIC';
								$SQL .= "dcts.traffic_id,";
								break;
							case 'BROWSER';
								$SQL .= "t1.browsername,";
								break;
							case 'LANGUAGE';
								$SQL .= "temm.browser_language,";
								break;
	
						}
					}
					
				}
				}
				$SQL = rtrim($SQL, ",");


				
											
			$query = $this->db->query($SQL);
				//return $SQL;		
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
			}
			}else
			{
				return FALSE;	
			}
		}
	}
	}
				
		
			
	function fetch_campaign_detail_info($search=false)
	{
		$mem_key="fetch_campaign_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['cam_id']))
		{
			$mem_key.='_'.$search['cam_id'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{		
			return $ret;
		}
		else{
		if(!empty($search['field_name'])){   
		if(!empty($search['cam_id'])){
				$SQL = "SELECT 
				DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
				DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,
				DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
				t1.interval_start as TIME_DATE,
				t1.country_name as COUNTRY,
				t1.domain as DOMAIN,
				t1.user_agent as USER_AGENT,
				t1.os as OS,
				t1.browsername as BROWSER,
				t1.sitereferurl as REFERRER_URL,
				rc.campaignid as CAM_ID,
				rc.campaignname as CAM_NAME,
				rb.bannerid as BAN_ID,
				rb.description as BAN_NAME

				FROM "; 
				
			if($search['field_name']=='imp')
			{
			$SQL  	.= " rv_djax_impression_reports as t1 ";
			}
			if($search['field_name']=='clk')
			{
			$SQL  	.= " rv_djax_click_reports  as t1 ";
			}
			if($search['field_name']=='con')
			{
			$SQL  	.= " rv_djax_conversion_reports  as t1";
			}				
					$SQL  	.=" JOIN rv_banners as rb ON rb.campaignid='".$search['cam_id']."' 
								JOIN rv_campaigns as rc ON ( rc.campaignid='".$search['cam_id']."' 
								AND rc.campaignid=rb.campaignid )
								WHERE t1.adid=rb.bannerid ";
			if(!empty($search['date_from']) && !empty($search['date_to']))
			{
					$SQL  	.="	AND t1.interval_start 
								BETWEEN '".$search['date_from']." 00:00:00.000000' 
								AND '".$search['date_to']." 23:59:59.999999'
								";
			}				
			if(!empty($search['country']) && $search['country'] != 'all')
			{
					//$c_name = $this->fetch_group($search['country']);
					$c_name = explode(',',$search['country']);
					$max = count($c_name)-1;
					for($i=0;$i<count($c_name);$i++) 
					{
						
						if($max != $i)
						{
						$stringd .= "'".$c_name[$i]."',";
						}
						else
						{
						$stringd .= "'".$c_name[$i]."'";
						}
							
					}			
					$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
								 WHERE value IN (".$stringd.") )";	
			}					
			if(!empty($search['device']) && $search['device'] != 'all')
			{
				if($search['device'] == 'Display')
				{
					$SQL	.= " AND t1.device_type = 'web' ";
				}
				else if($search['device'] == 'Mobile')
				{
					$SQL	.= " AND t1.device_type = 'mobile' ";
				}
				else if($search['device'] == 'Tablet')
				{
					$SQL	.= " AND t1.device_type = 'tablet' ";
				}
			}		
				
				
			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
			}
			}
			else
			{
				return FALSE;	
			}
		}
		}
		}	
		}
		
				
function fetch_creative_detail_info($search=false)
{
		$mem_key="fetch_creative_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['ad_id']))
		{
			$mem_key.='_'.$search['ad_id'];
		}
		if(!empty($search['hostname']))
		{
			$mem_key.='_'.$search['hostname'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{			
	if(!empty($search['field_name']))
	{
		if(!empty($search['ad_id']))
		{
			$SQL = "SELECT 
			DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
			DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,			
			DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
			t1.interval_start as TIME_DATE,
			t1.country_name as COUNTRY,
			t1.domain as DOMAIN,
			t1.user_agent as USER_AGENT,
			t1.os as OS,
			t1.browsername as BROWSER,
			t1.sitereferurl as REFERRER_URL,
			rc.campaignid as CAM_ID,
			rc.campaignname as CAM_NAME,
			rb.bannerid as BAN_ID,
			rb.description as BAN_NAME
			 FROM "; 

			if($search['field_name']=='imp')
			{
			$SQL  	.= " rv_djax_impression_reports as t1 ";
			}
			if($search['field_name']=='clk')
			{
			$SQL  	.= " rv_djax_click_reports  as t1 ";
			}
			if($search['field_name']=='con')
			{
			$SQL  	.= " rv_djax_conversion_reports  as t1 ";
			}							


			$SQL  	.=" JOIN rv_banners as rb ON rb.bannerid='".$search['ad_id']."' 	
						JOIN rv_campaigns as rc ON rc.campaignid=rb.campaignid 
						WHERE t1.adid='".$search['ad_id']."'  ";
			
if(!empty($search['hostname']))
{
		$SQL  	.="	AND t1.site_url LIKE '%".$search['hostname']."%' ";	
}		
if(!empty($search['date_from']) && !empty($search['date_to']))
{
		$SQL  	.="	AND t1.interval_start 
					BETWEEN '".$search['date_from']." 00:00:00.000000' 
					AND '".$search['date_to']." 23:59:59.999999'
					";
}				
if(!empty($search['country']) && $search['country'] != 'all')
{
		//$c_name = $this->fetch_group($search['country']);
		$c_name = explode(',',$search['country']);
		$max = count($c_name)-1;
		for($i=0;$i<count($c_name);$i++) 
		{
			
			if($max != $i)
			{
			$stringd .= "'".$c_name[$i]."',";
			}
			else
			{
			$stringd .= "'".$c_name[$i]."'";
			}
				
		}			
		$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
					 WHERE value IN (".$stringd.") )";	
}					
if(!empty($search['device']) && $search['device'] != 'all')
{
	if($search['device'] == 'Display')
	{
		$SQL	.= " AND t1.device_type = 'web' ";
	}
	else if($search['device'] == 'Mobile')
	{
		$SQL	.= " AND t1.device_type = 'mobile' ";
	}
	else if($search['device'] == 'Tablet')
	{
		$SQL	.= " AND t1.device_type = 'tablet' ";
	}
}
			$query = $this->db->query($SQL);

			if($query->num_rows() >0)
			{
			$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
			return $result;
			}
			}
			else
			{
			return FALSE;	
			}
			}
		}
	}
}		
	
	
	function fetch_adm_adv_detail_info($search=false)
	{
		$mem_key="fetch_adm_adv_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['account_id']))
		{
			$mem_key.='_'.$search['account_id'];
		}
		if(!empty($search['cam_id']))
		{
			$mem_key.='_'.$search['cam_id'];
		}
		if(!empty($search['creative_id']))
		{
			$mem_key.='_'.$search['creative_id'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable')
		{			
			return $ret;
		}
		else{			
		if(!empty($search['field_name'])){
			if(!empty($search['account_id']) || !empty($search['cam_id']) || !empty($search['creative_id'])){
				

		$account_id = $this->fetch_group($search['account_id']);
		$cam_id = $this->fetch_group($search['cam_id']);
		$creative_id = $this->fetch_group($search['creative_id']);
		$SQL		= "SELECT 
						DATE_FORMAT(rimp.interval_start,'%M %Y') as MONTH,
						DATE_FORMAT(rimp.interval_start,'%H:%i:%s') as HOUR,				
						DATE_FORMAT(rimp.interval_start,'%d-%m-%Y') as DATE,
						rimp.interval_start as TIME_DATE,
						rimp.country_name as COUNTRY,
						rimp.domain as DOMAIN,
						rimp.user_agent as USER_AGENT,
						rimp.os as OS,
						rimp.browsername as BROWSER,
						rimp.sitereferurl as REFERRER_URL,								
						rcls.clientname as ADV_NAME,
						rc.campaignname as CAM_NAME,
						rb.description as BAN_NAME 
								FROM ";
						if(!empty($search['account_id']))
						{
		$SQL		.=	" rv_clients as rcls
						LEFT JOIN rv_campaigns as rc ON rc.clientid = rcls.clientid ";
						if(!empty($search['cam_id']))
						{
							$SQL	.= "AND rc.campaignid IN ($cam_id)";
						}
		$SQL		.=	" JOIN rv_banners as rb ON rb.campaignid = rc.campaignid ";
						if(!empty($search['creative_id']))
						{
							$SQL	.= "AND rb.bannerid IN ($creative_id)";
						}
if($search['field_name']=='imp')
{								
		$SQL		.=	" JOIN rv_djax_impression_reports ";
}	
else if($search['field_name']=='clk')
{
$SQL  				.=  " JOIN rv_djax_click_reports ";
}
else if($search['field_name']=='con')
{
$SQL  	.= " JOIN rv_djax_conversion_reports ";
}			 
$SQL  				.=  " as rimp ON rimp.adid = rb.bannerid
		
						WHERE rcls.account_id IN(".$account_id.")";
						}
						
						
						
						
						
						
						else if(!empty($search['cam_id']))
						{
										
		$SQL		.=	" rv_campaigns as rc
						 JOIN rv_clients as rcls ON rcls.clientid = rc.clientid";
						if(!empty($search['account_id']))
						{						 
		$SQL		.=	 " AND rcls.account_id IN(".$account_id.")";
						}
		$SQL		.=	" JOIN rv_banners as rb ON rb.campaignid = rc.campaignid";
						if(!empty($search['creative_id']))
						{						 
		$SQL		.=	 " AND rb.bannerid IN(".$creative_id.")";
						}
if($search['field_name']=='imp')
{								
		$SQL		.=	" JOIN rv_djax_impression_reports ";
}	
else if($search['field_name']=='clk')
{
		$SQL  		.=  " JOIN rv_djax_click_reports ";
}
else if($search['field_name']=='con')
{
$SQL  	.= " JOIN rv_djax_conversion_reports ";
}								
		$SQL		.= " as rimp ON rimp.adid = rb.bannerid
						 WHERE rc.campaignid IN (".$cam_id.")";
						}
						
						
						
						
						
						
						else if(!empty($search['creative_id']))
						{
										
		$SQL		.=	" rv_banners as rb ";
if($search['field_name']=='imp')
{								
		$SQL		.=	" JOIN rv_djax_impression_reports ";
}	
else if($search['field_name']=='clk')
{
		$SQL  		.=  " JOIN rv_djax_click_reports ";
}
else if($search['field_name']=='con')
{
$SQL  	.= " JOIN rv_djax_conversion_reports ";
}						  
						  
		$SQL		.=  " as rimp 
						  ON rimp.adid = rb.bannerid AND rimp.adid IN (".$creative_id.")
						  JOIN rv_campaigns as rc ON rc.campaignid = rb.campaignid ";
						if(!empty($search['cam_id']))
						{
							$SQL	.= "AND rc.campaignid IN ($cam_id)";
						}						  
		$SQL		.=  " JOIN rv_clients as rcls ON rcls.clientid = rc.clientid ";
						if(!empty($search['account_id']))
						{						 
		$SQL		.=	 " AND rcls.account_id IN(".$account_id.")";
						}						  
		$SQL		.=   " WHERE rb.bannerid IN (".$creative_id.")";
						}
						


if(!empty($search['date_from']) && !empty($search['date_to']))
{
		$SQL  	.="	AND rimp.interval_start 
					BETWEEN '".$search['date_from']." 00:00:00.000000' 
					AND '".$search['date_to']." 23:59:59.999999'
					";
}				
if(!empty($search['country']) && $search['country'] != 'all')
{
		//$c_name = $this->fetch_group($search['country']);
		$c_name = explode(',',$search['country']);
		$max = count($c_name)-1;
		for($i=0;$i<count($c_name);$i++) 
		{
			
			if($max != $i)
			{
			$stringd .= "'".$c_name[$i]."',";
			}
			else
			{
			$stringd .= "'".$c_name[$i]."'";
			}
				
		}			
		$SQL	.= " AND rimp.country_name IN (SELECT name FROM djax_targ_country 
					 WHERE value IN (".$stringd.") )";	
}					
if(!empty($search['device']) && $search['device'] != 'all')
{
	if($search['device'] == 'Display')
	{
		$SQL	.= " AND rimp.device_type = 'web' ";
	}
	else if($search['device'] == 'Mobile')
	{
		$SQL	.= " AND rimp.device_type = 'mobile' ";
	}
	else if($search['device'] == 'Tablet')
	{
		$SQL	.= " AND rimp.device_type = 'tablet' ";
	}
}
			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	  
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
			}
			}
			else
			{
				return FALSE;	
			}
			}
		}
		}
		}
		
		
	function fetch_adm_pub_detail_info($search=false)
	{
		$mem_key="fetch_adm_pub_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['account_id']))
		{
			$mem_key.='_'.$search['account_id'];
		}
		if(!empty($search['site_id']))
		{
			$mem_key.='_'.$search['site_id'];
		}
		if(!empty($search['adblock_id']))
		{
			$mem_key.='_'.$search['adblock_id'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable' )
		{	
			return $ret;
		}
		else{
		if(!empty($search['field_name'])){
			if(!empty($search['account_id']) || !empty($search['site_id']) || !empty($search['adblock_id'])){


			$account_id 	= $this->fetch_group($search['account_id']);
			$site_id 		= $this->fetch_group($search['site_id']);
			$adblock_id 	= $this->fetch_group($search['adblock_id']);

			$SQL	=  "SELECT 
						DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
						DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,				
						DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
						t1.interval_start as TIME_DATE,
						t1.country_name as COUNTRY,
						t1.domain as DOMAIN,
						t1.user_agent as USER_AGENT,
						t1.os as OS,
						t1.browsername as BROWSER,
						ra.name as AFF_NAME,
						dps.site_name as SITE_NAME,
						rz.zonename as ZONE_NAME,
						t1.sitereferurl as REFERRER_URL
						FROM ";
			if(!empty($search['account_id']))
			{		
			$SQL	.=	" rv_affiliates as ra 
						JOIN rv_zones as rz ON rz.affiliateid = ra.affiliateid";
						if(!empty($search['adblock_id']))
						{	
							$SQL	.=  " AND rz.zoneid IN (".$adblock_id.")";
						}
						if($search['field_name']=='imp')
						{
			$SQL	.=  " JOIN rv_djax_impression_reports ";
						}
						else if($search['field_name']=='clk')
						{
			$SQL	.=  " JOIN rv_djax_click_reports ";
						}
else if($search['field_name']=='con')
{
$SQL  	.= " JOIN rv_djax_conversion_reports ";
}						
			$SQL	.=  " as t1 ON t1.zoneid = rz.zoneid
						JOIN djax_site_zone_assoc as dsza ON dsza.zone_id = rz.zoneid";
						if(!empty($search['site_id']))
						{						
			$SQL	.=  " AND dsza.site_id IN (".$site_id.")";
						}						
			$SQL	.=  " LEFT JOIN djax_publisher_sites as dps ON dps.site_id=dsza.site_id";
						if(!empty($search['site_id']))
						{						
			$SQL	.=  " AND dps.site_id IN (".$site_id.")";
						}
			$SQL	.=  " WHERE ra.account_id IN (".$account_id.")";
			}
			else if(!empty($search['site_id']))
			{		
			$SQL	.=	" djax_publisher_sites as dps
						JOIN djax_site_zone_assoc as dsza ON dsza.site_id IN (".$site_id.")
						JOIN rv_zones as rz ON rz.zoneid = dsza.zone_id ";
						if(!empty($search['adblock_id']))
						{	
							$SQL	.=  " AND rz.zoneid IN (".$adblock_id.")";
						}						
						if($search['field_name']=='imp')
						{
			$SQL	.=  " JOIN rv_djax_impression_reports ";
						}
						else if($search['field_name']=='clk')
						{
			$SQL	.=  " JOIN rv_djax_click_reports ";
						}
else if($search['field_name']=='con')
{
$SQL  	.= " JOIN rv_djax_conversion_reports ";
}						
			$SQL	.=  " as t1 ON t1.zoneid = rz.zoneid
						JOIN rv_affiliates as ra ON ra.affiliateid = rz.affiliateid";
						if(!empty($search['account_id']))
						{						
			$SQL	.=  " AND ra.account_id IN (".$account_id.")";
						}						
			$SQL	.=	" WHERE dps.site_id IN (".$site_id.")";
			}
			else if(!empty($search['adblock_id']))
			{		
			$SQL	.=	" rv_zones as rz ";
						if($search['field_name']=='imp')
						{
			$SQL	.=  " JOIN rv_djax_impression_reports ";
						}
						else if($search['field_name']=='clk')
						{
			$SQL	.=  " JOIN rv_djax_click_reports ";
						}
else if($search['field_name']=='con')
{
$SQL  	.= " JOIN rv_djax_conversion_reports ";
}						
			$SQL	.=  " as t1 ON t1.zoneid = rz.zoneid
						JOIN djax_site_zone_assoc as dsza ON dsza.zone_id = rz.zoneid ";
						if(!empty($search['site_id']))
						{						
			$SQL	.=  " AND dsza.site_id IN (".$site_id.") ";
						}						
			$SQL	.=	" LEFT JOIN djax_publisher_sites as dps ON dps.site_id=dsza.site_id ";
						if(!empty($search['site_id']))
						{						
			$SQL	.=  " AND dps.site_id IN (".$site_id.") ";
						}						
			$SQL	.=	" JOIN rv_affiliates as ra ON ra.affiliateid = rz.affiliateid ";
						if(!empty($search['account_id']))
						{						
			$SQL	.=  " AND ra.account_id IN (".$account_id.")";
						}						
			$SQL	.= 	" WHERE rz.zoneid IN (".$adblock_id.")";
			}

if(!empty($search['date_from']) && !empty($search['date_to']))
{
		$SQL  	.="	AND t1.interval_start 
					BETWEEN '".$search['date_from']." 00:00:00.000000' 
					AND '".$search['date_to']." 23:59:59.999999'
					";
}				
if(!empty($search['country']) && $search['country'] != 'all')
{
		//$c_name = $this->fetch_group($search['country']);
		$c_name = explode(',',$search['country']);
		$max = count($c_name)-1;
		for($i=0;$i<count($c_name);$i++) 
		{
			
			if($max != $i)
			{
			$stringd .= "'".$c_name[$i]."',";
			}
			else
			{
			$stringd .= "'".$c_name[$i]."'";
			}
				
		}			
		$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
					 WHERE value IN (".$stringd.") )";	
}					
if(!empty($search['device']) && $search['device'] != 'all')
{
	if($search['device'] == 'Display')
	{
		$SQL	.= " AND t1.device_type = 'web' ";
	}
	else if($search['device'] == 'Mobile')
	{
		$SQL	.= " AND t1.device_type = 'mobile' ";
	}
	else if($search['device'] == 'Tablet')
	{
		$SQL	.= " AND t1.device_type = 'tablet' ";
	}
}

			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
			}
				
			}
			else
			{
				return FALSE;	
			}
			}
		}
		}
		}
		
		
		
function fetch_main($columns,$search,$group,$order,$limit,$dataTable=FALSE)
{		
		$mem_key="fetch_main";
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['account_id']))
		{
			$mem_key.='_'.$search['account_id'];
		}		
					
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable' )
		{			
			return $ret;
		}
		else{			
	$SQL  = "SELECT DATE_FORMAT(date_time,'%Y-%m-%d') as DATE,
					SUM(impressions) as IMP,
					SUM(clicks) as CLK,
					SUM(conversions) as CONV,
				    ROUND(IFNULL(SUM(dj_publisher_earnings),0),4) as PUB_EARN, 
				    ROUND(IFNULL(((SUM(dj_publisher_earnings)/SUM(impressions))*1000),0),2)  as PUB_ECPM	
				FROM rv_data_summary_ad_hourly 
			WHERE DATE(date_time) >= '".$search['date_from']."' 
				AND DATE(date_time) <= '".$search['date_to']."' 
				AND zone_id IN (SELECT zone_id FROM djax_site_zone_assoc 
				WHERE site_id IN(SELECT site_id FROM djax_publisher_sites
				WHERE account_id = '".$search['account_id']."'))
				GROUP BY DATE_FORMAT(date_time,'%d-%m-%Y')
				ORDER BY date_time DESC";
				
				
			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
			}
			}
			else
			{
				return FALSE;	
			}	
			}	
}		
							
function fetch_environment_detail_info($search=false)
{
		$mem_key="fetch_environment_detail_info";
	if(!empty($search['field_name']))
	{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['environment']))
		{
			$mem_key.='_'.$search['environment'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable' )
		{			
			return $ret;
		}
		else{
			
		if(!empty($search['field_name']))
		{
			$SQL = "SELECT 
			DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
			DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,			
			DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
			t1.interval_start as TIME_DATE,
			t1.country_name as COUNTRY,
			t1.domain as DOMAIN,
			t1.user_agent as USER_AGENT,
			t1.os as OS,
			t1.browsername as BROWSER,
			t1.sitereferurl as REFERRER_URL,
			t1.device_type as ENV
			 FROM "; 

			if($search['field_name']=='imp')
			{
			$SQL  	.= " rv_djax_impression_reports as t1 ";
			}
			if($search['field_name']=='clk')
			{
			$SQL  	.= " rv_djax_click_reports  as t1 ";
			}				
			if($search['field_name']=='con')
			{
			$SQL  	.= " rv_djax_conversion_reports  as t1 ";
			}
if($search['environment'] == 'Display' || $search['device'] == 'Display')
{
	$env = 'web';
}
else if($search['environment'] == 'a')
{
	$env = '';
}
else if($search['device'] == 'Mobile')
{
	$env = 'mobile';
}
else if($search['device'] == 'Tablet')
{
	$env = 'tablet';
}

			$SQL  	.="	WHERE t1.device_type='".$env."'  ";
			
		
if(!empty($search['date_from']) && !empty($search['date_to']))
{
		$SQL  	.="	AND t1.interval_start 
					BETWEEN '".$search['date_from']." 00:00:00.000000' 
					AND '".$search['date_to']." 23:59:59.999999'
					";
}				
if(!empty($search['country']) && $search['country'] != 'all')
{
		//$c_name = $this->fetch_group($search['country']);
		$c_name = explode(',',$search['country']);
		$max = count($c_name)-1;
		for($i=0;$i<count($c_name);$i++) 
		{
			
			if($max != $i)
			{
			$stringd .= "'".$c_name[$i]."',";
			}
			else
			{
			$stringd .= "'".$c_name[$i]."'";
			}
				
		}			
		$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
					 WHERE value IN (".$stringd.") )";	
}	/*				
if(!empty($search['device']) && $search['device'] != 'all')
{
	if($search['device'] == 'Display')
	{
		$SQL	.= " AND t1.device_type = 'web' ";
	}
	else if($search['device'] == 'Mobile')
	{
		$SQL	.= " AND t1.device_type = 'mobile' ";
	}
	else if($search['device'] == 'Tablet')
	{
		$SQL	.= " AND t1.device_type = 'tablet' ";
	}
}*/
			$query = $this->db->query($SQL);

			if($query->num_rows() >0)
			{
			$result = 	$query->result_array();
			if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
			return $result;
			}
			}
			else
			{
			return FALSE;	
			}
			}
		}
	
}



	function fetch_request_overview_detail_info($search=false)
	{
		$mem_key="fetch_request_overview_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['date']))
		{
			$mem_key.='_'.$search['date'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['account_id']))
		{
			$mem_key.='_'.$search['account_id']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			if(!empty($search['field_name']))
		{
			$SQL = "SELECT 
					DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
					DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,
					t1.interval_start as TIME_DATE,
					t1.country_name as COUNTRY,
					t1.operating_system as OS,
					t1.browser_name as BROWSER,
					t1.domain as DOMAIN,
					t1.user_agent as USER_AGENT,
					djv.referrer as REFERRER_URL
					FROM rv_djax_track_ad_requests as t1
					JOIN rv_zones as rz ON rz.zoneid = t1.zone_id
					JOIN rv_affiliates as ra ON ra.affiliateid = rz.affiliateid AND ra.account_id = '".$search['account_id']."'
					JOIN djax_jsvalues as djv ON djv.random_number = t1.random_no 
					WHERE t1.interval_start BETWEEN '".$search['date']." 00:00:00.000000' 
					AND '".$search['date']." 23:59:59.999999' ";

			if(!empty($search['country']))
			{
					$SQL  	.="	AND t1.country_name = '".$search['country']."' ";
			}

			$query = $this->db->query($SQL);
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
			}
			}
			else
			{
				return FALSE;	
			}
		}			
		}		
	}
	function fetch_request_campaign_detail_info($search=false)
	{
		$mem_key="fetch_request_campaign_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['cam_id']))
		{
			$mem_key.='_'.$search['cam_id'];
		}
		if(!empty($search['ad_id']))
		{
			$mem_key.='_'.$search['ad_id'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}					
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable' )
		{			
			return $ret;
		}
		else{			
		if(!empty($search['field_name']))
		{
			$SQL = "SELECT 
			DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
			DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,			
			DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
			t1.interval_start as TIME_DATE,
			t1.country_name as COUNTRY,
			t1.domain as DOMAIN,
			t1.user_agent as USER_AGENT,
			t1.operating_system as OS,
			t1.browser_name as BROWSER,
			t1.site_referrer_url as REFERRER_URL,
			rc.campaignid as CAM_ID,
			rc.campaignname as CAM_NAME,
			rb.bannerid as BAN_ID,
			rb.description as BAN_NAME			
			
			
			FROM rv_djax_track_ad_requests as t1
			JOIN rv_banners as rb ON rb.campaignid = '".$search['cam_id']."'
			JOIN rv_campaigns as rc ON rc.campaignid = '".$search['cam_id']."'
			
			WHERE zone_id IN(SELECT zone_id FROM rv_ad_zone_assoc WHERE ad_id='".$search['ad_id']."')";
			
			if(!empty($search['date_from']) && !empty($search['date_to']))
			{
					$SQL  	.="	AND t1.interval_start 
								BETWEEN '".$search['date_from']." 00:00:00.000000' 
								AND '".$search['date_to']." 23:59:59.999999'
								";
			}
			if(!empty($search['country']))
			{
					$SQL  	.="	AND t1.country_name = '".$search['country']."' ";
			}

			$query = $this->db->query($SQL);
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;	
			}	
			}						
		}		
	}
	function fetch_request_creative_detail_info($search=false)
	{
		$mem_key="fetch_request_creative_detail_info";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['ad_id']))
		{
			$mem_key.='_'.$search['ad_id'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	

		if($ret && $mem_cache=='enable' )
		{			
			return $ret;
		}
		else{		
				
		if(!empty($search['field_name']))
		{
			$SQL = "SELECT 

			DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
			DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,			
			DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,
			t1.interval_start as TIME_DATE,
			t1.country_name as COUNTRY,
			t1.domain as DOMAIN,
			t1.user_agent as USER_AGENT,
			t1.operating_system as OS,
			t1.browser_name as BROWSER,
			t1.site_referrer_url as REFERRER_URL,
			rc.campaignid as CAM_ID,
			rc.campaignname as CAM_NAME,
			rb.bannerid as BAN_ID,
			rb.description as BAN_NAME			
			
			
			FROM rv_djax_track_ad_requests as t1
			JOIN rv_banners as rb ON rb.bannerid = '".$search['ad_id']."'
			JOIN rv_campaigns as rc ON rc.campaignid = rb.campaignid
			
					WHERE zone_id IN(SELECT zone_id FROM rv_ad_zone_assoc WHERE ad_id='".$search['ad_id']."')";
			
			if(!empty($search['date_from']) && !empty($search['date_to']))
			{
					$SQL  	.="	AND t1.interval_start 
								BETWEEN '".$search['date_from']." 00:00:00.000000' 
								AND '".$search['date_to']." 23:59:59.999999'
								";
			}
			if(!empty($search['country']))
			{
					$SQL  	.="	AND t1.country_name = '".$search['country']."' ";
			}

			$query = $this->db->query($SQL);
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
			}
			}
			else
			{
				return FALSE;	
			}						
		}		
	}
}
	

	function fetch_detail_request_info4($search=false)
	{
		$mem_key="fetch_detail_request_info4";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['account_id']))
		{
			$mem_key.='_'.$search['account_id'];
		}
		if(!empty($search['site_id']))
		{
			$mem_key.='_'.$search['site_id'];
		}
		if(!empty($search['adblock_id']))
		{
			$mem_key.='_'.$search['adblock_id'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{		
			return $ret;
		}
		else{	
			if(!empty($search['field_name'])){
			$SQL = "SELECT 
				DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
				DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,	
				DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,	
				t1.interval_start as TIME_DATE,					
				t1.country_name as COUNTRY,t1.domain as DOMAIN,
				t1.user_agent as USER_AGENT,t1.operating_system as OS,t1.browser_name as BROWSER,
				t1.site_referrer_url as REFERRER_URL,";
				if($search['site_id'])
				{
		$SQL  	.=" dps.site_name as SITE_NAME,
					dps.site_url as SITE_URL,";					
				}
				else if($search['adblock_id'])
				{
		$SQL  	.=" rz.zonename as ZONE_NAMES,";					
				}
				else if($search['account_id'])
				{
		$SQL  	.=" ra.name as AFF_NAME,";					
				}
		$SQL  	.=" rz.zonename as ZONE_NAME
				FROM rv_djax_track_ad_requests  as t1 ";
				if(!empty($search['adblock_id']))
				{
		$SQL  	.=" JOIN rv_zones as rz ON rz.zoneid='".$search['adblock_id']."'
				WHERE t1.zone_id=  '".$search['adblock_id']."'";
				}
				else if($search['site_id'])
				{
		$SQL  	.=" JOIN rv_zones as rz ON rz.zoneid = t1.zone_id
					JOIN djax_publisher_sites as dps ON dps.site_id = '".$search['site_id']."'
					WHERE t1.zone_id IN (SELECT zone_id from djax_site_zone_assoc WHERE site_id = '".$search['site_id']."')";		
				}
				else if($search['account_id'])
				{
		$SQL  	.="  JOIN rv_affiliates as ra ON ra.account_id = '".$search['account_id']."'
				
				 JOIN djax_publisher_sites as dps ON dps.account_id = '".$search['account_id']."'
				
				JOIN rv_zones as rz ON rz.zoneid = t1.zone_id
					
					
					WHERE t1.zone_id IN (SELECT zone_id FROM rv_zones WHERE affiliateid IN (SELECT affiliateid FROM rv_affiliates WHERE account_id = '".$search['account_id']."'))	AND t1.interval_start 
					BETWEEN '2017-01-12 00:00:00.000000' 
					AND '2017-01-12 23:59:59.999999'";		
				}
					
		if(!empty($search['date_from']) && !empty($search['date_to']))
		{
				$SQL  	.="	AND t1.interval_start 
							BETWEEN '".$search['date_from']." 00:00:00.000000' 
							AND '".$search['date_to']." 23:59:59.999999'
							";
		}				
		if(!empty($search['country']) && $search['country'] != 'all')
		{
				//$c_name = $this->fetch_group($search['country']);
				$c_name = explode(',',$search['country']);
				$max = count($c_name)-1;
				for($i=0;$i<count($c_name);$i++) 
				{
					
					if($max != $i)
					{
					$stringd .= "'".$c_name[$i]."',";
					}
					else
					{
					$stringd .= "'".$c_name[$i]."'";
					}
						
				}			
				$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
							 WHERE value IN (".$stringd.") )";	
		}					
			if(!empty($search['device']) && $search['device'] != 'all')
			{
				if($search['device'] == 'Display')
				{
					$SQL	.= " AND t1.device_type = 'web' ";
				}
				else if($search['device'] == 'Mobile')
				{
					$SQL	.= " AND t1.device_type = 'mobile' ";
				}
				else if($search['device'] == 'Tablet')
				{
					$SQL	.= " AND t1.device_type = 'tablet' ";
				}
			}				
					$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else
				{
				return $result;
				}				
			}
			else
			{
				return FALSE;	
			}
		}
		
	}
}	
		
		
	function fetch_detail_request_info3($search=false)
	{
		$mem_key="fetch_detail_request_info3";
		if(!empty($search['field_name']))
		{
			$mem_key.='_'.$search['field_name'];
		}
		if(!empty($search['app_id']))
		{
			$mem_key.='_'.$search['app_id'];
		}
		if(!empty($search['date_from']))
		{
			$mem_key.='_'.$search['date_from'];
		}
		if(!empty($search['date_to']))
		{
			$mem_key.='_'.$search['date_to'];
		}
		if(!empty($search['country']))
		{
			$mem_key.='_'.$search['country'];
		}		
		if(!empty($search['device']))
		{
			$mem_key.='_'.$search['device']; 
		}				
		$ret = $this->memcached_library->get($mem_key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
				
		if($ret && $mem_cache=='enable' )
		{			
			return $ret;
		}
		else{			
		
		if(!empty($search['app_id'])){
			if(!empty($search['field_name'])){
		$SQL = "SELECT 
				DATE_FORMAT(t1.interval_start,'%M %Y') as MONTH,
				DATE_FORMAT(t1.interval_start,'%H:%i:%s') as HOUR,	
				DATE_FORMAT(t1.interval_start,'%d-%m-%Y') as DATE,		
				t1.interval_start as TIME_DATE,		
				t1.country_name as COUNTRY,t1.domain as DOMAIN,
				t1.user_agent as USER_AGENT,t1.operating_system as OS,t1.browser_name as BROWSER,
				t1.site_referrer_url as REFERRER_URL,
				oxps.app_name as APP_NAME,
				oxps.app_url as APP_URL
				FROM  rv_djax_track_ad_requests  as t1 
				
				JOIN djax_app_zone_assoc as dsza ON dsza.zone_id=t1.zone_id 

				JOIN djax_temp_url as oxps on oxps.id='".$search['app_id']."'
				WHERE  t1.zone_id IN 
				(SELECT zone_id FROM djax_app_zone_assoc WHERE app_id='".$search['app_id']."' )
				";
			if(!empty($search['date_from']) && !empty($search['date_to']))
			{
					$SQL  	.="	AND t1.interval_start 
								BETWEEN '".$search['date_from']." 00:00:00.000000' 
								AND '".$search['date_to']." 23:59:59.999999'
								";
			}				
			if(!empty($search['country']) && $search['country'] != 'all')
			{
					//$c_name = $this->fetch_group($search['country']);
					$c_name = explode(',',$search['country']);
					$max = count($c_name)-1;
					for($i=0;$i<count($c_name);$i++) 
					{
						
						if($max != $i)
						{
						$stringd .= "'".$c_name[$i]."',";
						}
						else
						{
						$stringd .= "'".$c_name[$i]."'";
						}
							
					}			
					$SQL	.= " AND t1.country_name IN (SELECT name FROM djax_targ_country 
								 WHERE value IN (".$stringd.") )";	
			}					
			if(!empty($search['device']) && $search['device'] != 'all')
			{
				if($search['device'] == 'Display')
				{
					$SQL	.= " AND t1.device_type = 'web' ";
				}
				else if($search['device'] == 'Mobile')
				{
					$SQL	.= " AND t1.device_type = 'mobile' ";
				}
				else if($search['device'] == 'Tablet')
				{
					$SQL	.= " AND t1.device_type = 'tablet' ";
				}
			}				
				
				
			$query = $this->db->query($SQL);
						
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($mem_cache=='enable')
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($mem_key,$result,$account_type);	
				$set = $this->memcached_library->get($mem_key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;	
			}
		}
		}
		}
		}		


	function fetch_traffc_source_total($camp_id)
	{
		
		$key = 'fetch_traffc_source_total'.$account_id;
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		 
		if($vet && $mem_cache=='enable' )
		{ 
			return $vet;
		}
		else
		{	
		$sql = "SELECT rva.account_id, rvz.affiliateid, sun.zone_id, sum(sun.requests) as requests, SUM(sun.impressions) as impressions, SUM(sun.clicks) as clicks, SUM(sun.conversions) as conversions, SUM(sun.dj_total_revenue) as spend,SUM(sun.dj_publisher_earnings) as pub_earn
					FROM ".TAB_DATA_SUM_AD_HOURLY." as sun 
					JOIN ".TAB_BANNERS." as rvb on rvb.bannerid = sun.creative_id
					JOIN ".TAB_CAMPAIGNS." as rvc on rvc.campaignid = rvb.campaignid
					JOIN ".TAB_ZONES." as rvz on rvz.zoneid = sun.zone_id
					JOIN ".TAB_AFFILIATE." as rva on rva.affiliateid = rvz.affiliateid
					
					WHERE rvc.campaignid = '".$camp_id."'
					GROUP BY rva.account_id";  //JOIN ".TAB_CAMP_TRAFFIC." as dct on dct.traffic_id  = rva.account_id
		$query = $this->db->query($sql);
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$det = $this->memcached_library->get($key);	
			return $det;
			}
			else
			{
			return $result;
			}				
		}
		else
		{
			return FALSE;	
		}
	}	
	}	
	 	
				
	function fetch_zonebid_total($camp_id)
	{
		
		$key = 'fetch_zonebid_total'.$account_id;
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		 
		if($vet && $mem_cache=='enable' )
		{ 
			return $vet;
		}
		else
		{	
		$sql = "SELECT a.zone_id, sum(a.requests) as requests, sum(a.impressions) as impressions,sum(a.clicks) as clicks,sum(a.conversions) as conversions, sum(a.dj_total_revenue) as spend, SUM(a.dj_publisher_earnings) as pub_earn  FROM ".TAB_DATA_SUM_AD_HOURLY." as a 
		WHERE zone_id in (SELECT zone_id from ".TAB_CAMP_ZONE." WHERE campaign_id in (0,".$camp_id.") )
		AND ad_id IN (SELECT bannerid from ".TAB_BANNERS." where campaignid = ".$camp_id." )
		 group by a.zone_id ";
		$query = $this->db->query($sql); 
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$det = $this->memcached_library->get($key);	
			return $det;
			}
			else
			{
			return $result;
			}				
		}
		else
		{
			return FALSE;	
		}
	}	
	}
	
	function fetch_countrybid_total($camp_id)
	{
		
		$key = 'fetch_countrybid_total'.$account_id;
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		 
		if($vet && $mem_cache=='enable' )
		{ 
			return $vet;
		}
		else
		{	
		$sql = "SELECT t1.country_code, sum(t1.requests) as requests, sum(t1.impressions) as impressions,sum(t1.clicks) as clicks,sum(t1.conversions) as conversions, sum(t1.dj_total_revenue) as spend, SUM(t1.dj_publisher_earnings) as pub_earn  FROM ".TAB_DATA_SUM_AD_HOURLY." as t1
		JOIN ".TAB_BANNERS." as rb ON  rb.bannerid = t1.`ad_id` AND rb.campaignid =".$camp_id."
		JOIN ".TAB_COUN_BID." as t2 ON t2.country_value = t1.`country_code` AND t2.campaign_id IN (".$camp_id.")
		 group by t1.zone_id ";
		 
		  $query = $this->db->query($sql);
		  //return $this->db->last_query();
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$det = $this->memcached_library->get($key);	
			return $det;
			}
			else
			{
			return $result;
			}				
		}
		else
		{
			return FALSE;	
		}
	}	
	}	
	function fetch_pixtrack_report($camp_id,$from_date,$to_date)
	{
		
		$key = 'fetch_pixtrack_report'.$camp_id.$from_date.$to_date;
		$vet = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		 
		if($vet && $mem_cache=='enable' )
		{ 
			return $vet;
		}
		else
		{	
		$sql = " SELECT COUNT(t1.tracker_id) as length,t1.interval_start,COUNT(t1.tracker_id) as 	
					conversion,t1.tracker_id,t2.trackername,t2.pixel_type,t2.pixel_category,t2.pixel_goal,t2.status 
					FROM rv_djax_conversion_reports as t1
					JOIN rv_trackers as t2 ON t2.trackerid = tracker_id
					WHERE tracker_id IN(SELECT trackerid  FROM rv_campaigns_trackers WHERE campaignid = '".$camp_id."')
					";
		if(!empty($from_date) && !empty($to_date))
		{
	$sql .= 	" AND t1.interval_start BETWEEN '".$from_date." 00:00:00.000000' AND '".$to_date." 23:59:59.999999' ";
		}	
		$sql .= 	" GROUP BY t1.tracker_id";
		 
		  $query = $this->db->query($sql);

		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$det = $this->memcached_library->get($key);	
			return $det;
		}
		else
		{
			return $result;
			}				
		}
		else
		{
			return FALSE;	
		}
	}
}

	/*function fetch_daily_statstics($date,$account_id=FALSE)
	{  
		$SQL = "SELECT sum(impressions)as imp FROM ".TAB_DATA_SUM_AD_HOURLY." as oxah join ".TAB_BANNERS." as b on b.bannerid=oxah.ad_id JOIN ".TAB_CAMPAIGNS." as c ON c.campaignid=b.campaignid JOIN ".TAB_CLIENTS." as cl ON c.clientid=cl.clientid WHERE date(oxah.date_time)=".$date;

		if($account_id!=FALSE)
		{
			$SQL.=" and cl.account_id=".$account_id;
		}
		
		$query = $this->db->query($SQL);
				
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();
			 
			return $result;
			 				
		}
		else
		{
			return FALSE;	
		}
		
	}*/
	

	function fetch_advertiser_earn($data=false,$search=false)
	{
		$SQL="SELECT SQL_CALC_FOUND_ROWS null as rows,r.* FROM 
(SELECT  dcts.traffic_id as TRAFFIC, oxah.browser_name  as BROWSER_NAMES,oxah.browser_language as BROWSER_LANGS,oxz.zonename as ZONE_NAMES,oxah.date_time as TIME_DATE,  DATE_FORMAT(oxah.date_time,'%b-%d') as DATE, IFNULL(SUM(oxah.impressions),0) as IMP, IFNULL(SUM(oxah.clicks),0) as CLK, TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(SUM(oxah.dj_publisher_earnings),0),4))) as PUB_EARN, CASE WHEN SUM(oxah.impressions)=0 then 0 ELSE TRIM(TRAILING '.' FROM TRIM(TRAILING '0' FROM ROUND(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0),2))) END as PUB_ECPM, DATE(oxah.date_time) as date_time,IFNULL(SUM(oxah.impressions),0) as impr,IFNULL(SUM(oxah.clicks),0) as click,IFNULL(SUM(oxah.conversions),0) as conv,IFNULL(SUM(oxah.requests),0) as req,rvc.clientname FROM rv_data_summary_ad_hourly as oxah 
 JOIN rv_banners as oxb ON oxb.bannerid=oxah.ad_id 
 JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid 
 JOIN rv_clients as rvc ON rvc.clientid=oxc.clientid
 LEFT JOIN djax_campaign_traffic_source as dcts ON dcts.campaign_id=oxc.campaignid 
						          LEFT JOIN djax_targ_country as dtc ON dtc.value=oxah.country_code JOIN rv_zones as oxz ON oxz.zoneid=oxah.zone_id JOIN ( SELECT 
										dsza.zone_id,
										oxps.site_id as id,
										oxps.account_id,
										oxps.site_name as site_name,
										oxps.site_url as site_url
									FROM 
										djax_publisher_sites as oxps
									JOIN djax_site_zone_assoc as dsza ON dsza.site_id=oxps.site_id 
									
									WHERE 1  UNION
									
									SELECT 
										daza.zone_id,
										daza.app_id as id,
										dtu.account_id,
										dtu.app_name as site_name,
										dtu.app_url as site_url
									FROM 
										djax_temp_url as dtu
									JOIN djax_app_zone_assoc as daza ON daza.app_id=dtu.id 
									WHERE 1  ) as sa ON sa.zone_id=oxz.zoneid  JOIN rv_affiliates as oxaff ON ( oxaff.account_id=sa.account_id AND oxaff.account_id='".$data."')  WHERE 1  AND (DATE(oxah.date_time)  >= '".$search['date_from']."' AND DATE(oxah.date_time) <= '".$search['date_to']."') GROUP BY rvc.clientid  ORDER BY oxah.date_time DESC  ) as r WHERE r.impr>0 OR r.click>0 OR r.conv>0 OR r.req>0 ";
									$query = $this->db->query($SQL);
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				return $result;
			}
			else
			{
				return FALSE;	
			}	
		
	}
	
	function fetch_profit_earn($search=FALSE,$order=FALSE) //DAC 094
	{
		$key = 'publisher_earning_profit_'.$account_id.'_'.$enddate;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{   
		
		
		$SQL = "SELECT DATE(oxds.date_time) as date ,COALESCE(ROUND(SUM(oxds.dj_publisher_earnings),4),0) as earnings
				FROM ".TAB_AFFILIATE." as oxa 
				JOIN ".TAB_ZONES." as oxz ON oxz.affiliateid=oxa.affiliateid
				JOIN ".TAB_DATA_SUM_AD_HOURLY." as oxds ON `oxds`.`zone_id`=`oxz`.`zoneid`
				WHERE `oxa`.`account_id` = ".$search['account_id']."";
		$SQL	.=	" AND DATE(oxds.date_time) >= '".$search['date_from']."'";
		$SQL	.=	" AND DATE(oxds.date_time) <= '".$search['date_to']."' GROUP BY DATE(oxds.date_time) ";
		 
		$query = $this->db->query($SQL);

		$result = $query->result_array();		
		//~ return $this->db->last_query(); 
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		}
		
	}
		  
	}
	
	function publisher_earnings_menu($search)
	{
		$SQL = "SELECT DATE(oxds.date_time) as date  , SUM(oxds.impressions) AS imps, SUM(oxds.clicks) AS clicks, SUM(oxds.conversions) as convs, SUM(oxds.dj_publisher_earnings) as revenue
				FROM ".TAB_AFFILIATE." as oxa 
				JOIN ".TAB_ZONES." as oxz ON oxz.affiliateid=oxa.affiliateid
				JOIN ".TAB_DATA_SUM_AD_HOURLY." as oxds ON `oxds`.`zone_id`=`oxz`.`zoneid`
				WHERE `oxa`.`account_id` = ".$search['account_id']."";
		$SQL	.=	" AND DATE(oxds.date_time) >= '".$search['date_from']."' AND DATE(oxds.date_time) <= '".$search['date_to']."' GROUP BY DATE(oxds.date_time) ";
		 
		$query = $this->db->query($SQL);
		//~ return $this->db->last_query(); 
		$result = $query->result_array();
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	function fetch_topmenu_model($search=FALSE,$order=FALSE) //DAC 094
	{
		$key = 'publisher_earning_profit_'.$account_id.'_'.$enddate;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{   
		//~ $search['date_from']='2017-07-08';
		//~ $search['date_to']='2017-05-04';
		
	 
		$this->db->select("DATE(rvd.date_time) as date, SUM(rvd.impressions) as impressions,SUM(rvd.clicks)as clicks,SUM(rvd.conversions)as conversions,SUM(rvd.dj_total_revenue) as spend");
		$this->db->join(TAB_BANNERS." as rvb ", "rvd.ad_id =rvb.bannerid");
		$this->db->join(TAB_CAMPAIGNS." as rvca ","rvca.campaignid =rvb.campaignid" );
		if($search['account_type'] == 'ADVERTISER')
		{
			$this->db->join(TAB_CLIENTS." as rvc ","rvc.clientid = rvca.clientid");
		}
	  
		$this->db->where("DATE(rvd.date_time)",$search['date_from']);
		
		if($search['account_type'] == 'ADVERTISER')
		{ 
			$this->db->where("rvc.account_id ",$search['account_id']);
		}
		$this->db->group_by('DATE(rvd.date_time)');
		$query =  $this->db->get(TAB_DATA_SUM_AD_HOURLY." as rvd");
		 
		//~ return  $this->db->last_query();
		$result = $query->result_array();		
		
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		}
		
	}
		 return $search;
	}
	 
	 function wallet_money_advertiser($account_id)
	 {
		 $this->db->select('account_id,dj_wallet_balance');
		 $this->db->where("account_id",$account_id);
		 $query =  $this->db->get(TAB_CLIENTS);
		 $result = $query->result_array();
		 if($result)
		 {			
			return $result[0];
		 }
		 else
		 {
			return FALSE;
		 }
	 }
}
