<?php
class Do_referral extends CI_Model
{
	/*  djax_publisher_sites
	 * ---------------------
	 *  site_id
		account_id
		site_name
		site_url
		comments
		is_default
		added_date
		updated_date
		is_deleted
	 * */
	 
	 function fetch($account_id=FALSE){
		
		$key = 'fetch_referrals_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(PUBLISHER_REFERRAL_LIST);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		
			$SQL = "SELECT 
					COALESCE(ROUND(SUM(pub_earn),2),0) as earning,
					COALESCE(ROUND(SUM(ref.ref_amt),2),0) as income, 
					`oxaf`.`affiliateid`, 
					`oxaf`.`agencyid`, 
					`oxaf`.`name`, 
					`oxaf`.`email`, 
					`oxaf`.`website`, 
					`oxaf`.`dj_first_name` as first_name, 
					`oxaf`.`dj_last_name` as last_name,
					`oxaf`.`account_id` as account_id,
					`oxaf`.`dj_added_date` 
				FROM (".TAB_USERS." as oxu) 
				JOIN ".TAB_AFFILIATE." as oxaf ON `oxaf`.`account_id`=`oxu`.`default_account_id` 
				LEFT JOIN ( 
						SELECT 
							dps.account_id,
							SUM(oxds.dj_publisher_earnings) as pub_earn,
							0 as ref_amt
						FROM
							".TAB_DATA_SUM_AD_HOURLY." as oxds 
						JOIN ".TAB_ZONES." as oxz ON `oxz`.`zoneid`=`oxds`.`zone_id`
						JOIN ".TAB_SITE_ZONE_ASSOC." as osza ON osza.zone_id=oxz.zoneid
						JOIN ".TAB_PUB_SITES." as dps ON dps.site_id=`osza`.`site_id`
						GROUP BY 
							dps.account_id
						
						UNION
						
						SELECT 
							ti.referral as account_id,
							0 as pub_earn,
							SUM(ti.invoice_net_amount) as ref_amt
						FROM
							".TAB_INVOICE." as ti
						WHERE 
							ti.invoice_status=1 AND ti.referral!=0
						GROUP BY
							ti.referral
				) as ref ON ref.account_id=oxaf.account_id";
			
			$SQL .= " WHERE oxaf.dj_is_deleted =0 ";	
			
			if($account_id)
			{
				$SQL .= " AND oxaf.referral_id= ".$account_id."";	
			}	
			
			$SQL .= 	" GROUP BY `oxaf`.`account_id` 
						ORDER BY `oxaf`.`account_id` DESC";
			
			$query = $this->db->query($SQL);
			//echo $this->db->last_query();exit;
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);
					$this->memcached_library->get(PUBLISHER_REFERRAL_LIST,'2');	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else
				{
					return $result;
				}
			}else{
				return FALSE;	
			}	
		}

	}
}		  

