
<?php
class Do_payments extends CI_Model

{

	/*  djax_payment_transaction

	 * ---------------------

	 *  id

		account_id

		name

		email

		payment_type

		date

		amount

		currency

		account_no

		payment_no

		clearing_date

		status

		id_no

		transaction

		payment_response_id

		admin_approval_status

		approved_date

	 * */

	 

	  /*

	   * Adds the Advertiser fund and waiting for admin approval

	   * 

	   * name: add_fund

	   * @param : $fund_details

	   * @return :Insert id OR FALSE

	   * 

	   */

	 

	function add_fund($fund_details,$account_id){
		
		$this->db->trans_begin();

		$adv_final_details	=	'';
		//Fetch the advertiser information
		if($fund_details['page_type']!='signup')
		{
			$adv_details = $this->do_advertiser->get_user_information($account_id);
			$adv_final_details = $adv_details[0];
		}

		if($fund_details['payment_type']=='wire')
		{
			$pay_type 	= 	1;
			
			$billing_detail = 	array(

									'name' 				=> (($fund_details['page_type']!='signup') && $adv_final_details)?$adv_final_details['clientname']:$fund_details['clientname'],

									'email'				=> (($fund_details['page_type']!='signup') && $adv_final_details)?$adv_final_details['email']:$fund_details['email'],

									'payment_type'		=> $pay_type,

									'bank_name' 		=> $fund_details['bank_name'],

									'bank_address'		=> $fund_details['bank_address'],

									'bank_account_no'	=> $fund_details['bank_acc_no'],

									//'paypal_id'			=> $fund_details['paypal_id'],

									'created_date'		=> date('Y-m-d H:i:s'),
									
									'verification_status'=> '1'

									);

			
			$this->db->insert(TAB_BILL_INFO,$billing_detail);						

			$billing_ins_id = $this->db->insert_id();			

		}
		elseif($fund_details['payment_type']=='webmoney')
		{

			$pay_type = 3;	
			
			$billing_detail = array(

									'name' 				=> 	$adv_final_details['clientname'],

									'email'				=> 	$adv_final_details['email'],

									'payment_type'		=> 	$pay_type,

									'bank_account_no'	=> 	$fund_details['payer_id'],

									'created_date'		=> 	date('Y-m-d H:i:s'),
									
									'verification_status'=> '1'

									);	    

			$this->db->insert(TAB_BILL_INFO,$billing_detail);						

			$billing_ins_id = $this->db->insert_id();

		}
		
		elseif($fund_details['payment_type']=='bitcoin')
		{

			$pay_type = 4;	
			
			$billing_detail = array(

									'name' 				=> 	$adv_final_details['clientname'],

									'email'				=> 	$adv_final_details['email'],

									'payment_type'		=> 	$pay_type,

									'api_signature'		=> 	$fund_details['payer_id'],

									'created_date'		=> 	date('Y-m-d H:i:s'),
									
									'verification_status'=> '1'

									);	    

			$this->db->insert(TAB_BILL_INFO,$billing_detail);						

			$billing_ins_id = $this->db->insert_id();

		}
		
		elseif($fund_details['payment_type']=='authorize')
		{

			$pay_type = 5;	
			
			$billing_detail = array(

									'name' 				=> 	$adv_final_details['clientname'],

									'email'				=> 	$adv_final_details['email'],

									'payment_type'		=> 	$pay_type,

									'api_username'		=> 	$fund_details['payer_id'],
									
									'api_signature'		=> 	$fund_details['api_signature'],

									'created_date'		=> 	date('Y-m-d H:i:s'),
									
									'verification_status'=> '1'

									);	    

			$this->db->insert(TAB_BILL_INFO,$billing_detail);						

			$billing_ins_id = $this->db->insert_id();

		}	
		else

		{

			$pay_type = 2;	
			
			$admin_paypal = $this->get_admin_payment_info();			
			
			$billing_detail = array(

									'name' 				=> $adv_final_details['clientname'],

									'email'				=> $adv_final_details['email'],

									'payment_type'		=> $pay_type,

									'paypal_id'			=> $fund_details['paypal_id'],

									'created_date'		=> date('Y-m-d H:i:s'),
									
									'verification_status'=> '1'

									);

	    

			$this->db->insert(TAB_BILL_INFO,$billing_detail);						

			$billing_ins_id = $this->db->insert_id();

		}

		//Adds the advertiser fund into db

		$addfundObj = array(
						 "name" 				=> 	(($fund_details['page_type']!='signup') && $adv_final_details)?$adv_final_details['clientname']:$fund_details['clientname'],

						 "email" 				=> 	(($fund_details['page_type']!='signup') && $adv_final_details)?$adv_final_details['email']:$fund_details['email'],

						 "payment_type" 		=> 	$pay_type,//$fund_details['payment_type'],

						 "amount" 				=> 	$fund_details['amount'],

						 "currency" 			=> 	$this->config->item('currency'),

						 "transaction" 			=> 	'credit',

						 "admin_approval_status"=> 	0,

						 "date"					=>	date('Y-m-d H:i:s'),

						 "ref_billing_id"		=> 	$billing_ins_id 	

						);
						
		if($fund_details['page_type']=='signup')
		{
			$addfundObj["temp_user_id"]	= 	$fund_details['temp_user_id'];
		}
		else
		{
			$addfundObj["account_id"]	= 	$account_id;
		}
		
		$this->db->insert(TAB_PAY_TRANS,$addfundObj);			
		$this->memcached_library->set(ADVERTISER_PAYMENT_APPROVE_LIST,'1');	
		$this->memcached_library->set(ADVERTISER_PAYMENT_LIST,'1');	
		$this->memcached_library->set(ADVERTISER_DATEWISE_PAYMENT_LIST,'1');
		$this->memcached_library->set(ADVERTISER_DEPOSIT_LIST,'1');	
			
		$last_insert_id = $this->db->insert_id();
		

		if($last_insert_id){

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();

				return FALSE;
			}
			else
			{
				$this->db->trans_commit();

				return $last_insert_id;
			}
		}
		else
		{
			return FALSE;
		}
	}

	public function get_admin_payment_info()
	{    
	   
		$this->db->select('paypal_id');
		$this->db->where('payment_type',2);
		$query = $this->db->get(TAB_ADMIN_PAYD);
		$result = $query->result_array();
	    if($result)
		{			
			return $result[0]['paypal_id'];
		}
		else
		{
			return FALSE;
		}
	} 

	 /*

	   * Make Payment for publisher based on invoices

	   * 

	   * name: make_payment

	   * @param : $fund_details

	   * @return :Insert id OR FALSE

	   * 

	   */

	 function make_payment($details,$pay=FALSE){

		$this->memcached_library->set(ADVERTISER_PAYMENT_APPROVE_LIST,'1');
		$this->memcached_library->set(FETCH_PUB_PAYMENT_LIST_APPROVAL,'1');
		$invoice_id = $details['invoice_id'];
		//Get the Invoice Details based on invoice_id
		$invoice_details = $this->fetch_invoice_account_details($invoice_id);
		$invoice_details = $invoice_details[0];
		//Get the Account details 
		$account_details = $this->fetch_publisher_account_details($invoice_details['account_id']);
		//Transaction Begin
		$this->db->trans_begin();
		//Inserts array for payment response
		if($pay!=FALSE && is_array($pay) && $pay['paytype']=='paypal')
		{
			$payment_response_id = $pay['payment_response_id'];
		}
		else
		{
			if($account_details){
			$ins_pay_response = array('account_id'=>$invoice_details['account_id'],
									'payment_type'=>$account_details['payment_type'],
								   'payment_request_id'=>$invoice_details['id'],
								   'payer_email'=>get_session('email'),
								   'receiver_email'=>$invoice_details['email'],
								   'payment_gross'=>$invoice_details['amount'],
								   'payment_status'=>1,
								   'payment_date'=>$invoice_details['in_date'],
								   'payment_paid_date'=>date('Y-m-d H:i:s'),
								);

			$this->db->insert(TAB_PAY_RES,$ins_pay_response);

			$payment_response_id = $this->db->insert_id();
			}
		else
		{
		return 'update_payment_detail';
		}
		}

		if($payment_response_id)
		{
			// Billing information name to be considered
			if ($account_details['payment_type'] == 1)
			{
				$ins_pay_trans = array(
					'account_id' => $account_details['account_id'],
					'name' => $invoice_details['name'],
					'email' => $invoice_details['email'],
					'payment_type' => $account_details['payment_type'],
					'date' => date('Y-m-d H:i:s'),
					'amount' => $invoice_details['amount'],
					'currency' => $this->config->item('currency'),
					'account_no' => $account_details['bank_account_no'],
					'clearing_date' => date('Y-m-d H:i:s'),
					'status' => 1,
					'transaction' => 'debit',
					'payment_response_id' => $payment_response_id,
					'admin_approval_status' => 1,
					'approved_date'=>date('Y-m-d H:i:s'),
				);
				$this->db->insert(TAB_PAY_TRANS, $ins_pay_trans);
			}
			else
			{
				$ins_pay_trans = array(
					'account_id' => $account_details['account_id'],
					'name' => $invoice_details['name'],
					'email' => $invoice_details['email'],
					'payment_type' => $account_details['payment_type'],
					'date' => date('Y-m-d H:i:s'),
					'amount' => $invoice_details['amount'],
					'currency' => $this->config->item('currency'),
					'clearing_date' => date('Y-m-d H:i:s'),
					'status' => 1,
					'transaction' => 'debit',
					'payment_response_id' => $payment_response_id,
					'admin_approval_status' => 1,
					'approved_date'=>date('Y-m-d H:i:s')
				);
				$this->db->insert(TAB_PAY_TRANS, $ins_pay_trans);
			}
			
			// Billing information name to be considered
			$payment_transaction_id = $this->db->insert_id();

		}else{
			$payment_transaction_id = '';
		}

		if($payment_transaction_id)
		{					
			//Insert one mapping table for further reference

			$ins_pay_invoice_payment = array('payment_id'=>$payment_transaction_id,

											'invoice_id'=>$invoice_details['id']
										);	
			$this->db->insert(TAB_INVOICE_PAY,$ins_pay_invoice_payment);

		}

		//Update the Billing Information
		$billing_address = $invoice_details['address'].','.$invoice_details['city'].','.$invoice_details['state'].','.$invoice_details['country'];
		if ($account_details['payment_type'] == 1)
		{
			$ins_bill_info = array(
				'name' => $invoice_details['name'],
				'email' => $invoice_details['email'],
				'company_name' => $invoice_details['company_name'],
				'billing_address' => $billing_address,
				'email' => $invoice_details['email'],
				'payment_type' => $account_details['payment_type'],
				'bank_name' => $account_details['bank_name'],
				'bank_address' => $account_details['bank_address'],
				'swift_bic' => $account_details['swift_bic'],
				'iban' => $account_details['iban'],
				'routing_number' => $account_details['routing_number'],
				'bank_account_no' => $account_details['bank_account_no'],
				'account_holder_name' => $account_details['account_holder_name'],
				'paypal_id' => $account_details['paypal_id'],
				'created_date' => date('Y-m-d H:i:s')
			);
		}
		else
		{
			$ins_bill_info = array(
				'name' => $invoice_details['name'],
				'company_name' => $invoice_details['company_name'],
				'billing_address' => $billing_address,
				'email' => $invoice_details['email'],
				'payment_type' => $account_details['payment_type'],
				'paypal_id' => $account_details['paypal_id'],
				'created_date' => date('Y-m-d H:i:s')
			);
		}
		
		$this->db->insert(TAB_BILL_INFO,$ins_bill_info);

		$billing_id = $this->db->insert_id();			

		//Updates the Invoice is paid

		$this->db->update(TAB_INVOICE,array('invoice_paid_date' => date('Y-m-d H:i:s'),'invoice_status'=>1,'billing_id'=>$billing_id),array('invoice_id'=>$invoice_details['id']));	
		$this->memcached_library->set(ADVERTISER_PAYMENT_APPROVE_LIST,'1');	
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();

			return FALSE;
		}
		else
		{
			$this->db->trans_commit();

			$invoice_details = array('invoice'=>$invoice_details);

			$account_details = array('account'=>$account_details);

			$final_details = array_merge($invoice_details,$account_details);

			return $final_details;

		}

	}

	 function fetch($where=FALSE){

		

		if($where != FALSE){

			$this->db->where($where);

		}

		

		$this->db->select('site_id,account_id,site_name,site_url');		

		$this->db->where('is_deleted','0');

		

		$this->db->order_by('added_date');

		

		

		$query = $this->db->get(TAB_PUB_SITES);		

		

		$result = $query->result_array();

			

		if($result)

		{			

			return $result;

		}

		else

		{

			return FALSE;

		}



		

	 }

	
  /*

   * 

   * name: fetch_payment_list

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

	public function fetch_payment_list($agencyid)
	{
	  /* $this->db->select('*');

	   $this->db->where('tpt.transaction',"credit");

	   $this->db->where_not_in('tpt.account_id',0);

	   $this->db->where('tpt.admin_approval_status',0);

	   $this->db->where('tc.agencyid',$agencyid);

	   $this->db->join(TAB_CLIENTS.' as tc','tpt.account_id=tc.account_id');

	   $this->db->order_by('tpt.date');

	   $query = $this->db->get(TAB_PAY_TRANS.' as tpt');

	   $result=$query->result_array();

	   echo $this->db->last_query();exit;

		/*if($result)
		{
			$i=0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}	
			return $result;
		}
		else
	    {
		   return FALSE;
		}*/
		
		$key = 'fetch_payment_list_'.$agencyid;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADVERTISER_PAYMENT_APPROVE_LIST);	
		if($ret && $mem_cache=='enable' && $check_db_changes!=1)
		{
			return $ret;
		}
		else
		{
			$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT id,tpt.account_id,name,tpt.email,date,amount,currency,
				CASE 
					WHEN payment_type=1 THEN 'Wire'
					WHEN payment_type=2 THEN 'Paypal'
					WHEN payment_type=3 THEN 'Zpurse'
					WHEN payment_type=4 THEN 'Bitcoin'
					WHEN payment_type=5 THEN 'Authorize'
				ELSE tpt.payment_type
				END as payment_type 
			from ".TAB_PAY_TRANS." as tpt join ".TAB_CLIENTS." as tc ON tpt.account_id=tc.account_id WHERE tpt.transaction='credit' AND tpt.account_id NOT IN('0') AND tpt.admin_approval_status='0' AND tc.agencyid=".$agencyid; 
			$in_sel = "SELECT count(*) from ".TAB_PAY_TRANS." as tpt join ".TAB_CLIENTS." as tc ON tpt.account_id=tc.account_id  WHERE tpt.transaction='credit' AND tpt.account_id NOT IN('0') AND tpt.admin_approval_status='0' AND tc.agencyid=".$agencyid;
			$SQL.= " ORDER BY tpt.date DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
			$query = $this->db->query($SQL);
			
			$result = $query->result_array();		
			
			if($query->num_rows()>0)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(ADVERTISER_PAYMENT_APPROVE_LIST,'2');	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else
				{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
		}   
	}
	

   /*

   * 

   * name: fetch_unapproved_advertiser_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

   public function fetch_unapproved_advertiser_payment($agency_id,$adv_account_id=FALSE)

    {

	   

	   $SQL = "

				SELECT oxp.`date` as last_create_date, (

						SELECT count(*) FROM 

							".TAB_PAY_TRANS." as oxp

							JOIN ".TAB_CLIENTS." as oxcl  ON oxcl.account_id=oxp.account_id

						WHERE

						oxcl.agencyid={$agency_id} ";

						

		if($adv_account_id != FALSE){

			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

		}		

				

								

		$SQL .= "  AND oxp.`admin_approval_status`=0 AND 

					   oxp.`transaction` = 'credit'

					) as deposit_count 

				FROM 

					".TAB_PAY_TRANS." as oxp

					JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxp.account_id

				WHERE

					oxcl.agencyid={$agency_id}	";

		

		if($adv_account_id != FALSE){

			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

		}			

		

		$SQL  .= "	AND oxp.`admin_approval_status`=0 AND 

					   oxp.`transaction` = 'credit'";

					

		$SQL .= " ORDER BY 

					oxp.`date` DESC LIMIT 0,1";

	

	  $query = $this->db->query($SQL);



	  $result=$query->result_array(); 



		 if($result)



		{			



			return $result[0];



		}



		else



		{



			return FALSE;



		}	

   }

   

   

   /*

   * 

   * name: fetch_approved_advertiser_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

	public function fetch_approved_advertiser_payment($agency_id,$adv_account_id=FALSE)
    {

		$key = 'fetch_approved_advertiser_payment_'.$agency_id.'_'.$adv_account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{

			$SQL = "

					SELECT oxp.`date` as last_create_date, (

							SELECT count(*) FROM 

								".TAB_PAY_TRANS." as oxp

								JOIN ".TAB_CLIENTS." as oxcl  ON oxcl.account_id=oxp.account_id

							WHERE

							oxcl.agencyid={$agency_id} ";
						
			if($adv_account_id != FALSE){

				$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

			}		
								

			$SQL .= "  AND oxp.`admin_approval_status`=1 AND 

						   oxp.`transaction` = 'credit'

						) as deposit_count 

					FROM 

						".TAB_PAY_TRANS." as oxp

						JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxp.account_id

					WHERE

						oxcl.agencyid={$agency_id}	";

			if($adv_account_id != FALSE){

				$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 

			}			

			$SQL  .= "	AND oxp.`admin_approval_status`=1 AND 

						   oxp.`transaction` = 'credit'";

			$SQL .= " ORDER BY 

						oxp.`date` DESC LIMIT 0,1";

		

			$query = $this->db->query($SQL);

			$result=$query->result_array(); 

			if($result)
			{	
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result[0],$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
			
					return $result[0];
				}
			}
			else
			{
				return FALSE;
			}	

		}
	   
	}

   /*

   * 

   * name: fetch_unapproved_advertiser_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

   public function fetch_unapproved_publisher_payment($agency_id,$pub_account_id=FALSE)

    {

	   

	   $SQL = "

				SELECT oxi.`invoice_date` as last_create_date, (

						SELECT count(*) FROM 

							".TAB_INVOICE." as oxi

							JOIN ".TAB_AFFILIATE." as oxaff  ON oxaff.account_id=oxi.account_id

							JOIN ".TAB_PUB_PAYD." as pp  ON oxaff.account_id=pp.account_id

						WHERE

						oxaff.agencyid={$agency_id} AND pp.is_default=1 ";

						

		if($pub_account_id != FALSE){

			$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

		}		

				

								

		$SQL .= "  AND oxi.`invoice_status`=0 

					) as invoice_count 

				FROM 

					".TAB_INVOICE." as oxi

					JOIN ".TAB_AFFILIATE." as oxaff ON oxaff.account_id=oxi.account_id

					JOIN ".TAB_PUB_PAYD." as pp  ON oxaff.account_id=pp.account_id

				WHERE

					oxaff.agencyid={$agency_id}	AND pp.is_default=1 ";

		

		if($pub_account_id != FALSE){

			$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

		}			

		

		$SQL  .= "	AND oxi.`invoice_status`=0 ";

					

		$SQL .= " ORDER BY 

					oxi.`invoice_date` DESC LIMIT 0,1";

	

	  $query = $this->db->query($SQL);



	  $result=$query->result_array(); 



		 if($result)



		{			



			return $result[0];



		}



		else



		{



			return FALSE;



		}	

   }

   

   

   /*

   * 

   * name: fetch_approved_publisher_payment

   * @param : none

   * @return :$result

   * 

   * Fetch list of payments need to be approve

   */

   

	public function fetch_approved_publisher_payment($agency_id,$pub_account_id=FALSE,$date=FALSE)

    {
		$key = 'fetch_approved_publisher_payment_'.$agency_id.'_'.$pub_account_id.'_'.$date;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{

			$SQL = "

					SELECT oxi.`invoice_date` as last_create_date, (

							SELECT count(*) FROM 

								".TAB_INVOICE." as oxi

								JOIN ".TAB_AFFILIATE." as oxaff  ON oxaff.account_id=oxi.account_id

							WHERE

							oxaff.agencyid={$agency_id}  ";							

			if($pub_account_id != FALSE){

				$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

			}	

			if($date != FALSE){

				$SQL .= "  AND DATE(oxi.invoice_paid_date) = '".$date."'"; 

			}				

			$SQL .= "  AND oxi.`invoice_status`=1 

						) as invoice_count 

					FROM 

						".TAB_INVOICE." as oxi

						JOIN ".TAB_AFFILIATE." as oxaff ON oxaff.account_id=oxi.account_id

					WHERE

						oxaff.agencyid={$agency_id}	";			

			if($pub_account_id != FALSE){

				$SQL .= "  AND oxaff.account_id = {$pub_account_id}"; 

			}
			
			if($date != FALSE){

				$SQL .= "  AND DATE(oxi.invoice_paid_date) = '".$date."'"; 

			}		

			$SQL  .= "	AND oxi.`invoice_status`=1 ";						

			$SQL .= " ORDER BY 

						oxi.`invoice_date` DESC LIMIT 0,1";		

			$query = 	$this->db->query($SQL);

			$result=	$query->result_array(); 

			if($result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result[0],$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result[0];
				}

			}
			else
			{
				return FALSE;
			}	

		}
	   
	}

   

   /*

   * 

   * name: payment_approve

   * @param : payment id,amount,account_id

   * @return :Payment id OR FLASE

   * 

   */

   public function payment_approve($id=FALSE,$amount=FALSE,$account_id=FALSE)

   {

	 $data=array(

	              'admin_approval_status'=>1,

				  'approved_date'=>date('Y-m-d H:m:s'),

				  'clearing_date'=>date('Y-m-d H:m:s')

	          );

	 if(!empty($data))

	 {

		$this->db->where('id',$id);

		$this->db->update(TAB_PAY_TRANS,$data);

		//add approve amount into rv_clients

		$this->db->select('dj_cur_balance,dj_wallet_balance');

		$this->db->where('account_id',$account_id);

		$query = $this->db->get(TAB_CLIENTS);

		$result=$query->result_array();

		$tot_amount=$result[0]['dj_cur_balance']+$amount;
		$tot_wallet_amount=$result[0]['dj_wallet_balance']+$amount;

		$add=array('dj_cur_balance'=>$tot_amount,'dj_wallet_balance'=>$tot_wallet_amount);

		$this->db->where('account_id',$account_id);

		$this->db->update(TAB_CLIENTS,$add);
		$this->memcached_library->set(ADVERTISER_PAYMENT_APPROVE_LIST,'1');	
		$this->memcached_library->set(ADVERTISER_PAYMENT_LIST,'1');	
		$this->memcached_library->set(ADVERTISER_DATEWISE_PAYMENT_LIST,'1');
		$this->memcached_library->set(ADVERTISER_DEPOSIT_LIST,'1');
		return $id;

	 }

	 else

	 {

		 return FALSE;

	 }

   }
   
	/******************** Direct Campaign Payment Approve/Reject ********************/
	
	public function direct_payment_approve($id=FALSE,$amount=FALSE,$campaignid=FALSE)
	{
		$date=date('Y-m-d H:m:s');
		
		if(!empty($campaignid))
		{
			$Qry 	= 	"UPDATE `djax_direct_campaign_payment` SET admin_approval_status='1', is_default='1',approved_date='".$date."', clearing_date='".$date."' WHERE campaign_id='".$campaignid."' and is_default=0";
			$query 	= 	$this->db->query($Qry);
			$this->memcached_library->set(FETCH_DIRECT_CAMPAIGN,'1');
				$this->memcached_library->set(ADMIN_DIRECT_CAMPAIGN_APPROVALS,'1');
			
			return TRUE;
		}		
		else
		{
			return FALSE;
		}
	}
	
	public function direct_payment_reject($id=FALSE)
	{
		$data=array(
		'admin_approval_status'	=>	-1,
		'transaction'	=>	'refund',
		'approved_date'	=>	date('Y-m-d H:m:s'),
		'clearing_date'	=>	date('Y-m-d H:m:s')
		);
		if(!empty($data))
		{
			//update reject status and return account_id
			
			$this->db->where('id',$id);
			$this->db->update('djax_direct_campaign_payment',$data);
			
			$this->db->select('campaign_id,is_default');
			$this->db->where('id',$id);
			$query	=	$this->db->get('djax_direct_campaign_payment');
			$result	=	$query->result_array();
			$acc_id	=	$result[0]['campaign_id'];
			$is_default=	$result[0]['is_default'];
			if($is_default == 1)//reject increased fund only, not the campaign
			{
				$SQL = "UPDATE ".TAB_CAMPAIGNS." SET dj_is_approved='-1' WHERE campaignid='".$acc_id."'";
				$query = $this->db->query($SQL);
			}
				
			if($result){
				$this->memcached_library->set(FETCH_DIRECT_CAMPAIGN,'1');
				$this->memcached_library->set(ADMIN_DIRECT_CAMPAIGN_APPROVALS,'1');
				return $acc_id;
			}
		}
		else
		{
			return FALSE;
		}
	}
	
	
	public function fetch_dcampaign_list()
	{
		/*$where	=	array(
							'tpt.is_default'			=>	0,
							'tpt.admin_approval_status'	=>	0,
							'tc.dj_is_direct'			=>	1,
							'tc.dj_is_checkout'			=>	1,
							'tc.dj_is_approved'			=>	1
						);
		$this->db->select('tpt.*, tc.campaignid, tc.campaignname');
		
		$this->db->where($where);
		
		$this->db->join(TAB_CAMPAIGNS.' as tc','tpt.campaign_id=tc.campaignid');
		$this->db->order_by('tpt.date');
	
		$query 	= 	$this->db->get('djax_direct_campaign_payment as tpt');
		$result	=	$query->result_array();
		//return $this->db->last_query();exit;
		*/
		$key = 'fetch_dcampaign_list';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_DIRECT_CAMPAIGN_APPROVALS);	
		if($ret && $mem_cache=='enable' && $check_db_changes !=1)
		{
			return $ret;
		}
		else{
		$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT tpt.*, tc.campaignid, tc.campaignname from djax_direct_campaign_payment as tpt join ".TAB_CAMPAIGNS." as tc ON tpt.campaign_id=tc.campaignid where tpt.is_default=0 AND tpt.admin_approval_status=0 AND tc.dj_is_direct=1 AND tc.dj_is_checkout=1 AND tc.dj_is_approved=0"; 
		$in_sel = "SELECT count(*) from djax_direct_campaign_payment as tpt join ".TAB_CAMPAIGNS." as tc ON tpt.campaign_id=tc.campaignid where tpt.is_default=0 AND tpt.admin_approval_status=0 AND tc.dj_is_direct=1 AND tc.dj_is_checkout=1 AND tc.dj_is_approved=0";
		$SQL.= " ORDER BY tpt.date DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount";
		
		$query = $this->db->query($SQL);
		
		$result = $query->result_array();		
		
		if($query->num_rows()>0)
		{
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			$this->memcached_library->set(ADMIN_DIRECT_CAMPAIGN_APPROVALS,'2');	
			return $set;
			}
			else{
			return $result;
			}
		}
		else
		{
			return FALSE;
		}
	}
}
	/******************** Direct Campaign Payment Approve/Reject ********************/

   /*

   * 
	film movie
   * name: payment_reject

   * @param : payment id

   * @return :Payment id OR FLASE

   * 

   */

   public function payment_reject($id=FALSE)

	{

          $data=array(

	              'admin_approval_status'=>-1,

				  'approved_date'=>date('Y-m-d H:m:s'),

				  'clearing_date'=>date('Y-m-d H:m:s')

	          );

	 if(!empty($data))

	 {

	    //update reject status and return account_id

		$this->db->select('account_id');

		$this->db->where('id',$id);

		$this->db->update(TAB_PAY_TRANS,$data);

		$this->db->where('id',$id);

		$query=$this->db->get(TAB_PAY_TRANS);

		$result=$query->result_array();
		$this->memcached_library->set(ADVERTISER_PAYMENT_APPROVE_LIST,'1');	
		if($result){

			$acc_id=$result[0]['account_id'];

			return $acc_id;

		}

	 }

	 else

	 {

		 return FALSE;

	 }
	
   
	}

   

   /*

   * 

   * name: payment_viewmore

   * @param : payment id

   * @return :Payment detailed list of payment

   * 

   */

   public function payment_viewmore($id=FALSE)

   {
	   
	   
	   $key = 'payment_viewmore_'.$id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		

     $this->db->select('*');

	 $this->db->where('id',$id);

	 $query=$this->db->get(TAB_PAY_TRANS);

	 $result=$query->result_array();

	 if($result)

	 {

		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}

	 }

	 else

	 {

	    return FALSE;

	 }

   }
   
}

   

   /*

   * 

   * name: fetch_pub_payment_list

   * @param : none

   * @return :detailed list of publisher payment

   * 

   */

	public function fetch_pub_payment_list($invoice_id =FALSE,$agencyid=FALSE)
	{
		
		$key = 'fetch_pub_payment_list_'.$invoice_id.'_'.$agencyid;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_PUB_PAYMENT_LIST_APPROVAL);
		$check_payout_db_changes = $this->memcached_library->get(REQUEST_PAYOUT);	
		if($ret && $mem_cache=='enable' && $check_db_changes!='1'&& $check_payout_db_changes!='1')
		{
			return $ret;
		}
		else{

		$this->db->select('ti.invoice_id,ti.payment_gateway,ti.account_id as account_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,
		ti.invoice_period_days as days,ti.invoice_status,ti.invoice_net_amount as amount,tu.contact_name as name,tu.email_address as email1,tpp.*');

		$this->db->where('ti.invoice_status',0);
		
		//$this->db->where('ti.referral',0);

		$this->db->join(TAB_USERS.' as tu ','tu.default_account_id = ti.account_id');

		$this->db->join(TAB_PUB_PAYD.' as tpp ','tpp.account_id = ti.account_id');

		$this->db->where('tpp.is_default',1);
		
		$this->db->order_by('ti.invoice_date',DESC);

		if($agencyid!=FALSE)
		{
			$this->db->where('tf.agencyid',$agencyid);

			$this->db->join(TAB_AFFILIATE.' as tf','tpp.account_id=tf.account_id');
		}
		
		if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
			$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
		
			$this->db->where_in('tf.account_id',$pub);
		endif;
	   
		$this->db->order_by('ti.invoice_net_amount','desc');

		if($invoice_id)
		{
			$query=$this->db->get_where(TAB_INVOICE.' as ti ',array('invoice_id'=>$invoice_id));

		}else{
			$query=$this->db->get(TAB_INVOICE.' as ti ');
		}

		$result	=	$query->result_array();

		#echo $this->db->last_query();exit;
		//return $this->db->last_query();
		//exit;
		$count=$query->num_rows();
		if($result)
		{
			$i=0;$j=$count;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}	
			if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$this->memcached_library->set(FETCH_PUB_PAYMENT_LIST_APPROVAL,'2');
		$this->memcached_library->set(REQUEST_PAYOUT,'2');
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
	    {
			return FALSE;
		}
		
   }
   
}

   

  /*

  * name: publisher_invoice_viewmore

  * @param : $invoice_id

  * @return :detailed list of publisher payment 

  */

	public function fetch_individual_invoice($invoice_id=FALSE)
	{
		$key = 'fetch_individual_invoice_'.$invoice_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$this->db->select('ti.account_id,ti.invoice_id as id,ti.invoice_net_amount as invoice_earn,ti.invoice_remaining_amount as remaining_earn,(ti.invoice_net_amount + ti.invoice_remaining_amount) as total_earn,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,tii.item_code,tii.item_desc,tii.amount,tii.currency');

			$this->db->where('ti.invoice_id',$invoice_id);

			$this->db->from(TAB_INVOICE.' as ti ');

			$this->db->join(TAB_INVOICE_ITEM.' as tii ','tii.invoice_id=ti.invoice_id','left');

			//$this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id'); 	//do not comment this line. DAC 094
			//~ $this->db->join(TAB_AFFILIATE . ' as aff', 'aff.account_id=ti.account_id');   // 
			$query=$this->db->get();
			  
			$result=$query->result_array();

			if($result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
		}
	}
    

    /*

	 * name: publisher_invoice_viewmore

	 * @param : $invoice_id

     * @return :detailed list of publisher payment 

    */

    public function fetch_publisher_account_details($account_id=FALSE)

    {

		if($account_id)

		{

			$this->db->where('is_default',1);

			$query = $this->db->get_where(TAB_PUB_PAYD,array('account_id'=>$account_id));

			

			if($query->num_rows>0)

			{

				$result = $query->result_array();

				return $result[0];

			}else{

				return FALSE;	

			}

		

		}else{

			return FALSE;	

		}	

	}

	/*

   * name: fetch_campaign_invoice_list

   * @param : none

   * @return :detailed list of campaign payment 

   */

	public function fetch_campaign_invoice_list($campaign_id=FALSE)

	{

	   $this->db->select('dc.name,dc.campaign_id,dc.email,dc.payment_type,dc.admin_approval_status,dc.date,c.dj_added_date,dc.id, dc.currency,dc.invoice_code, dc.amount as netamount');

	   if($campaign_id)
	   {

	     $this->db->where('c.campaignid',$campaign_id);

	   }

	   $this->db->from(TAB_DIR_CAMP_PAY.' as dc ');

	   $this->db->join(TAB_CAMPAIGNS.' as c ','c.campaignid=dc.campaign_id');

	   $this->db->where('dc.is_default','0');

	   $query=$this->db->get();

	   $result=$query->result_array();

	   if($result)

	    {

		  return $result;

		}

	   else

	    {

		   return FALSE;

		}

	}
	

	/*

   * name: fetch_publisher_invoice_list

   * @param : none

   * @return :detailed list of publisher payment 

   */

	public function fetch_publisher_invoice_list($account_id=FALSE,$filter=FALSE)
	{
		
		$key = 'fetch_publisher_invoice_list'.$account_id;
		
		if($filter!=FALSE):
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(REQUEST_PAYOUT);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1' )
		{
			return $ret;
		}
		else{		
			
			$this->db->select('tu.contact_name as name,MONTHNAME(ti.invoice_date)as month,YEAR(ti.invoice_date)as year,ti.invoice_status,ti.invoice_id,ti.invoice_code,ti.invoice_net_amount as netamount,MONTH(ti.invoice_date) as month_number,DATE(ti.invoice_date) as invoice_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,tu.email_address as email,tbi.payment_type');

			if($account_id)
			{
				$this->db->where('ti.account_id',$account_id);
			}
			else
			{
				if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
					$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
				
					$this->db->where_in('ti.account_id',$pub);
				endif;
			}

			$this->db->from(TAB_INVOICE.' as ti ');

			$this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id');
			
			$this->db->join(TAB_BILL_INFO. ' as tbi ','tbi.billing_id=ti.billing_id','left');
			
			$this->db->order_by('ti.invoice_date','DESC');
			
			$this->db->where('ti.referral','0'); //To add for referral
			$this->db->where('tu.parent_account_id','0'); //To avoid multiple entries, parent account id is used
			
			/*if($filter!=FALSE && $filter['site']!=FALSE)
			{
				$sit	=	is_array($filter['site'])?implode("','",$filter['site']):$filter['site'];
			}*/
			if($filter!=FALSE && $filter['date_from']!=FALSE)
			{
				$this->db->where('DATE(ti.invoice_date) >=',$filter['date_from']);
			}
			if($filter!=FALSE && $filter['date_to']!=FALSE)
			{
				$this->db->where('DATE(ti.invoice_date) <=',$filter['date_to']);
			}
			
			if($filter!=FALSE && $filter['status']!=FALSE)
			{
				$stat	=	is_array($filter['status'])?$filter['status']:array($filter['status']);
				$this->db->where_in('ti.invoice_status',$stat);
			}
			
			if($filter!=FALSE && $filter['payment_type']!=FALSE)
			{
				$ptype	=	is_array($filter['payment_type'])?implode("','",$filter['payment_type']):$filter['payment_type'];
				$this->db->where_in('tbi.payment_type',$ptype);
			}
					
			$query=$this->db->get();
			//echo $this->db->last_query();exit;
			//return $this->db->last_query();
			$result=$query->result_array();
			$count=$query->num_rows();
			if($result)
			{
				$i=0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set(REQUEST_PAYOUT,'2');
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
		}
	}
	
	/*

   * name: fetch_referral_invoice_list

   * @param : none

   * @return :detailed list of publisher payment 

   */

	public function fetch_referral_invoice_list($account_id=FALSE,$filter=FALSE)
	{
		
		$key = 'fetch_referral_invoice_list_'.$account_id;
		
		if($filter!=FALSE):
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$this->db->select('tu.contact_name as name,tu.email_address as email,ti.account_id,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,MONTHNAME(ti.invoice_date)as month,YEAR(ti.invoice_date)as year,ti.invoice_status,ti.invoice_id,ti.invoice_code,ti.invoice_net_amount as netamount,ti.referral as referral_id,ref.ref_name,ref.ref_email,ref.ref_amt,tpp.paypal_id,tpp.payment_type');

			if($account_id)
			{
				$this->db->where('ti.account_id',$account_id);
			}
			else
			{
				if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
					$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
				
					$this->db->where_in('ti.account_id',$pub);
				endif;
			}

			$this->db->from(TAB_INVOICE.' as ti ');		

			$this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id');
			
			$this->db->join(TAB_PUB_PAYD.' as tpp','tpp.account_id = ti.account_id','left');
			
			$this->db->join("(SELECT contact_name as ref_name,email_address as ref_email,tin.account_id,DATE(tin.invoice_date) as date,tin.invoice_net_amount as ref_amt FROM ".TAB_INVOICE." as tin JOIN ".TAB_USERS." as tus ON tus.default_account_id=tin.account_id WHERE tin.referral=0) as ref","ref.account_id=ti.referral AND ref.date=DATE(ti.invoice_date)");
			
			$this->db->where('tpp.is_default',1);
			
			$this->db->order_by('ti.invoice_date','DESC');
			
			$this->db->where('ti.referral !=','0'); //To add for referral
			$implode_val = implode(',',$filter['status']); 
			if($filter!=FALSE && $filter['status']!=FALSE && $implode_val!='')
			{  
				$stat	=	is_array($filter['status'])?$filter['status']:array($filter['status']);
				$this->db->where_in('ti.invoice_status',$stat);
			}
				
			$query=$this->db->get();
			//~ return $this->db->last_query();exit;
			
			$result	=	$query->result_array();
			$count	=	$query->num_rows();
			if($result)
			{
				$i=0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
		}		
		
	}

	 /**

       * Retreives the categories associated with this site

       * 

       * @param numeric $site_id Site id

       * 

	   * @return boolean Returns TRUE (or) FALSE

    */

	 

	 public function fetch_publisher_invoice_item($invoice_id =FALSE)

	 {

		 if($invoice_id)

		 {

			 $this->db->select('item_desc,amount,currency');

			 $query = $this->db->get_where(TAB_INVOICE_ITEM,array('invoice_id'=>$invoice_id));

			 $result = $query->result_array();

			 return $result;

		  }else{

				return FALSE;	

			 }

		  

	 }

	 

	    /*

   * 

   * name: fetch_invoice_account_details

   * @param : none

   * @return :detailed list of publisher payment

   * 

   */

   public function fetch_invoice_account_details($invoice_id =FALSE)

   {

       $this->db->select('ti.invoice_id as id,ti.account_id as account_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,ti.invoice_net_amount as amount,tu.contact_name as name,tu.email_address as email,ta.dj_company_name as company_name,ta.dj_address as address,ta.dj_state as state,ta.dj_city as city,ta.dj_country as country,ti.referral as referral_id');

	   $this->db->where('ti.invoice_status',0);

       $this->db->join(TAB_USERS.' as tu ','tu.default_account_id=ti.account_id');

       $this->db->join(TAB_AFFILIATE.' as ta','ta.account_id=ti.account_id');

       if($invoice_id)

       {

		   $query=$this->db->get_where(TAB_INVOICE.' as ti ',array('invoice_id'=>$invoice_id));

	   }else{

			$query=$this->db->get(TAB_INVOICE.' as ti ');

	   }

	   $result=$query->result_array();

	   if($result)

	    {

		  return $result;

		}

	   else

	    {

		   return FALSE;

		}

   }

   

   /*

   * 

   * name: insert_paypal_response

   * @param : $paypal_order

   * @return :TRUE or FALSE

   * 

   */

    function insert_paypal_order($paypal_order)

    {

        $this->db->insert(TAB_PAY_RES, $paypal_order);



        if($this->db->affected_rows()>0)

        {

                return $this->db->insert_id();

        }

        else

        {

                return FALSE;

        }

    }

   

   /*

   * 

   * name: fetch_advertiser_payment

   * @param : $account_id

   * @return : Sumary details of advertiser payments

   * 

   */

	public function fetch_advertiser_payment($account_id=FALSE)
	{
		$key = 'fetch_advertiser_payment_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		$check_db_changes = $this->memcached_library->get(ADVERTISER_PAYMENT_LIST);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		   $sql="SELECT ROUND(SUM(spend),4) as tot_spend,ROUND(SUM(paid),4) as tot_paid,ROUND((SUM(paid) - SUM(spend)),4) as balance, month,year,month_number,account_id,d

			FROM 

		   (SELECT sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id as account_id,tds.date_time as d  FROM `rv_data_summary_ad_hourly` as tds JOIN `rv_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY YEAR(tds.date_time),MONTH(tds.date_time) 

			UNION

			SELECT 0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year, MONTH(approved_date) as month_number, account_id,approved_date as d FROM `djax_payment_transaction` WHERE  `account_id` = $account_id  AND  `transaction` = 'credit'  AND `admin_approval_status` = 1 GROUP BY YEAR(approved_date),MONTH(approved_date)

			UNION

			SELECT sum(oba.dj_win_bid) as spend ,0 as paid,MONTHNAME(oba.date_time) as month,YEAR(oba.date_time) as year, MONTH(oba.date_time) as month_number,tcl.account_id as account_id,oba.date_time as d FROM `rv_data_bkt_a` as oba JOIN `rv_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY YEAR(oba.date_time),MONTH(oba.date_time)

			UNION

			SELECT sum(obc.dj_win_bid * obc.count) as spend ,0 as paid,MONTHNAME(obc.interval_start) as month,YEAR(obc.interval_start) as year, MONTH(obc.interval_start) as month_number,tcl.account_id as account_id,obc.interval_start  as d   FROM `rv_data_bkt_c` as obc JOIN `rv_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY YEAR(obc.interval_start),MONTH(obc.interval_start)

			UNION

			SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,MONTHNAME(obm.interval_start) as month,YEAR(obm.interval_start) as year, MONTH(obm.interval_start) as month_number,tcl.account_id as account_id,obm.interval_start as d FROM `rv_data_bkt_m` as obm JOIN `rv_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY YEAR(obm.interval_start),MONTH(obm.interval_start)

			) as final GROUP BY YEAR(d),MONTH(d) ORDER BY DATE(d) DESC";
			//$data=$this->db->last_query();
 
			$result=$this->db->query($sql);
		  
			$data=$result->result_array();

			if($data){

				if($mem_cache=='enable')
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$data,$account_type);	
					$this->memcached_library->set(ADVERTISER_PAYMENT_LIST,'2');	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $data;
				}
			}
			else
			{
				return FALSE;
			} 

		}
	}

   

   /*

   * 

   * name: fetch_advertiser_date_wise_payment

   * @param : $account_id

   * @return : detailed info of advertiser payments date wise

   * 

   */

	public function fetch_advertiser_date_wise_payment($month=FALSE,$year=FALSE,$account_id=FALSE)
	{
		$key = 'fetch_advertiser_date_wise_payment';
		if($month!=FALSE)
		{
			$key.='_'.$month;
		}
		if($year!=FALSE)
		{
			$key.='_'.$year;
		}
		if($account_id!=FALSE)
		{
			$key.='_'.$account_id;
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		$check_db_changes = $this->memcached_library->get(ADVERTISER_DATEWISE_PAYMENT_LIST);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{

			$sql= "SELECT ROUND(sum(spend),4) as tot_spend,ROUND(sum(paid),4) as tot_paid,date FROM

			(

				SELECT (sum(tds.dj_total_revenue)) as spend,0 as paid, DATE(tds.date_time) as date FROM `rv_data_summary_ad_hourly` as tds JOIN `rv_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id  GROUP BY DATE(tds.date_time)UNION

				SELECT 0 as spend,sum(amount) as paid, DATE(approved_date) as date FROM `djax_payment_transaction` WHERE `account_id` = $account_id AND `transaction` = 'credit' AND `admin_approval_status` = 1 GROUP BY DATE(approved_date)

				UNION

				SELECT sum(oba.dj_win_bid) as spend ,0 as paid,DATE(oba.date_time) as date FROM `rv_data_bkt_a` as oba JOIN `rv_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(oba.date_time)

				UNION

				SELECT sum(obc.dj_win_bid * obc.count) as spend ,0 as paid,DATE(obc.interval_start) as date FROM `rv_data_bkt_c` as obc JOIN `rv_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(obc.interval_start)

				UNION

				SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,DATE(obm.interval_start) as date FROM `rv_data_bkt_m` as obm JOIN `rv_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(obm.interval_start)

				)as final WHERE MONTH(date)=$month AND YEAR(date)=$year GROUP BY date ORDER BY date DESC";

			$result=$this->db->query($sql);

			$data=$result->result_array();

			if($data){

				if($mem_cache=='enable')
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$data,$account_type);	
					$this->memcached_library->set(ADVERTISER_DATEWISE_PAYMENT_LIST,'2');	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $data;
				}
			}
			else
			{
				return FALSE;
			}
		}		
	}

	/*

	* 

	* name: fetch_publisher_invoice_payment_list

	* @param : $account_id

	* @return : detailed info of publisher payments invoice 

	* 

	*/

 	public function fetch_publisher_invoice_payment_list($account_id=FALSE,$filter=FALSE) 

	{ 
		
		$key = 'fetch_publisher_invoice_payment_list_'.$account_id;
		
		if($filter!=FALSE):
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		

			$sql= "SELECT month_name,year,month,date,pub_earn,cumm_earn,cumm_paid,(@final_paid:= @final_paid + cumm_paid) as final_paid,
					accountid,invoice_paid_date,invoice_status,invoice_id,invoice_code,netamount,balance,paid_amount,payment_type FROM (

			SELECT MONTHNAME(date)as month_name,YEAR(date) as year,MONTH(date) as month,date,ROUND(SUM(pub_earn),4) as pub_earn,ROUND(SUM(cumm_earn),4) as cumm_earn,

			   ROUND(SUM(cumm_paid),4) as cumm_paid,accountid,
			   invoice_paid_date,invoice_status,invoice_id,invoice_code,ROUND(SUM(netamount),4) as netamount,
			   CASE WHEN invoice_status=1 THEN (ROUND(SUM(pub_earn),4)-ROUND(SUM(netamount),4)) ELSE ROUND(SUM(pub_earn),4) END as balance, ROUND(SUM(paid_amount),4) as paid_amount,payment_type
			   FROM 

			   (
				SELECT invoice_date as date,account_id as accountid,0 as pub_earn,0 as cumm_earn,(@csum := @csum + invoice_amount) as cumm_paid,
						invoice_paid_date,invoice_id,invoice_code,netamount,paid_amount,
						CASE 
							WHEN invoice_status=0 THEN 'Pending'
							WHEN invoice_status=1 THEN 'Paid'
							WHEN invoice_status=2 THEN 'Cancelled'
						END as invoice_status,
						CASE 
							WHEN payment_type=1 THEN 'Wire'
							WHEN payment_type=2 THEN 'Paypal'
							WHEN payment_type=3 THEN 'Zpurse'
							WHEN payment_type=4 THEN 'Bitcoin'
							WHEN payment_type=5 THEN 'Authorize'
						END as payment_type
				FROM 

				  (

					SELECT dji.invoice_paid_date,dji.invoice_date,dji.invoice_status,dji.invoice_id,dji.invoice_code,SUM(dji.invoice_net_amount) as netamount,MONTH(dji.invoice_date) as month_number, 
					CASE
						WHEN dji.invoice_status=1 THEN SUM(dji.invoice_net_amount)
						ELSE 0
					END as paid_amount,
					SUM(dji.invoice_net_amount) as invoice_amount,dji.account_id,djb.payment_type

					from djax_invoice as dji
					JOIN djax_billing_information as djb ON djb.billing_id=dji.billing_id 
					,(SELECT @csum:=0) as t 
					WHERE 
						dji.account_id='".$account_id."' AND dji.referral=0 ";
						if($filter!=FALSE && $filter['date_from']!=FALSE)
						{
							$sql	.=	" AND DATE(dji.invoice_date) >='".$filter['date_from']."' ";
						}
						if($filter!=FALSE && $filter['date_to']!=FALSE)
						{
							$sql	.=	" AND DATE(dji.invoice_date) <='".$filter['date_to']."' ";
						}
						
					$sql	.=	" GROUP BY 
						YEAR(dji.invoice_date),MONTH(dji.invoice_date)

				  ) as t
				
				UNION
				
				SELECT date_time as date,account_id as accountid,pub_earn,(@cearn := @cearn + pub_earn) as cumm_earn,0 as cumm_paid, 
					'' as invoice_paid_date,'' as invoice_id,'' as invoice_code,0 as netamount, 0 as paid_amount,'' as invoice_status, '' as payment_type
				FROM

				  (

					SELECT t1.date_time,tf.account_id,SUM(t1.`dj_publisher_earnings`)  as pub_earn FROM `rv_data_summary_ad_hourly` 

					as t1 JOIN rv_zones as tz ON tz.zoneid=t1.zone_id 
					JOIN djax_site_zone_assoc as djsz ON djsz.zone_id=tz.zoneid 
					JOIN djax_publisher_sites as djps ON djps.site_id=djsz.site_id 
					JOIN rv_affiliates as tf ON tf.affiliateid=tz.affiliateid AND tf.account_id=djps.account_id, (SELECT @cearn:=0) as temp 

					WHERE tf.account_id='".$account_id."' ";
					
				if($filter!=FALSE && $filter['site']!=FALSE)
				{
					$sit	=	is_array($filter['site'])?implode("','",$filter['site']):$filter['site'];
					$sql	.=	" AND djps.site_id IN ('".$sit."') ";
				}
				if($filter!=FALSE && $filter['date_from']!=FALSE)
				{
					$sql	.=	" AND DATE(t1.date_time) >='".$filter['date_from']."' ";
				}
				if($filter!=FALSE && $filter['date_to']!=FALSE)
				{
					$sql	.=	" AND DATE(t1.date_time) <='".$filter['date_to']."' ";
				}
					
				$sql	.= 	" GROUP BY YEAR(t1.date_time),MONTH(t1.date_time) 
				
				   )as final
				
				) as l_final WHERE 1 ";
				
				/*if($filter!=FALSE && $filter['search']!=FALSE)
				{
					$sql	.=	" AND (date like '%".$filter['search']."%' OR pub_earn like '%".$filter['search']."%' OR netamount like '%".$filter['search']."%' OR invoice_code like '%".$filter['search']."%' OR payment_type like '%".$filter['search']."%' OR invoice_status like '%".$filter['search']."%')";
				}*/
				
				if($filter!=FALSE && $filter['status']!=FALSE)
				{
					$stat	=	is_array($filter['status'])?implode("','",$filter['status']):$filter['status'];
					$sql	.=	" AND invoice_status IN ('".$stat."') ";
				}
				
				if($filter!=FALSE && $filter['date_from']!=FALSE)
				{
					$sql	.=	" AND DATE(date) >='".$filter['date_from']."' ";
				}
				if($filter!=FALSE && $filter['date_to']!=FALSE)
				{
					$sql	.=	" AND DATE(date) <='".$filter['date_to']."' ";
				}
				
				if($filter!=FALSE && $filter['payment_type']!=FALSE)
				{
					$ptype	=	is_array($filter['payment_type'])?implode("','",$filter['payment_type']):$filter['payment_type'];
					$sql	.=	" AND payment_type IN ('".$ptype."') ";
				}
				
				$sql	.=	" GROUP BY YEAR(date),MONTH(date)

			)as td,(SELECT @final_paid:=0) as final_paid GROUP BY year,month ORDER BY date DESC";

			$query	=	$this->db->query($sql);//echo $this->db->last_query();exit;

			$result	=	$query->result_array();
			$count	=	$query->num_rows();

			if($result)
			{
				$i=0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			} 

		}

	}
	

  /*

   * 

   * name  : fetch_pub_date_wise_payment

   * @param: account_id,month,year

   * @return:detailed info of publisher payments history 

   * 

   */ 

   public function fetch_pub_date_wise_payment($month=FALSE,$year=FALSE,$account_id=FALSE,$filter=FALSE,$order=FALSE)

	{   

	   $sql="SELECT @i := @i -1 AS row_number,c.* FROM (SELECT DATE(date)as date,ROUND(SUM(pub_earn),4) as pub_earn,ROUND(SUM(cumm_earn),4) as cumm_earn,

			   ROUND(SUM(cumm_paid),4) as cumm_paid,accountid,
			   invoice_paid_date,invoice_status,invoice_id,invoice_code,ROUND(SUM(netamount),4) as netamount,
			   CASE 
					WHEN invoice_status=1 THEN (ROUND(SUM(pub_earn),4)-ROUND(SUM(netamount),4)) 
					ELSE ROUND(SUM(pub_earn),4) 
			  END as balance, 
			   ROUND(SUM(paid_amount),4) as paid_amount,
			   payment_type
		   FROM 

		   (
			SELECT 
				invoice_date as date,0 as accountid,0 as pub_earn,0 as cumm_earn,(@csum := @csum + invoice_amount) as cumm_paid, 
				invoice_paid_date,invoice_id,invoice_code,netamount,paid_amount,
				CASE 
					WHEN invoice_status=0 THEN 'Pending'
					WHEN invoice_status=1 THEN 'Paid'
					WHEN invoice_status=2 THEN 'Cancelled'
				END as invoice_status,
				CASE 
					WHEN payment_type=1 THEN 'Wire'
					WHEN payment_type=2 THEN 'Paypal'
					WHEN payment_type=3 THEN 'Zpurse'
					WHEN payment_type=4 THEN 'Bitcoin'
					WHEN payment_type=5 THEN 'Authorize'
				END as payment_type

			FROM 

			  (

				select dji.invoice_date, SUM(dji.invoice_net_amount) as invoice_amount, dji.invoice_paid_date,dji.invoice_status,dji.invoice_id,dji.invoice_code,SUM(dji.invoice_net_amount) as netamount,
				CASE
					WHEN dji.invoice_status=1 THEN SUM(dji.invoice_net_amount)
					ELSE 0
				END as paid_amount,djb.payment_type

				from djax_invoice as dji
				JOIN djax_billing_information as djb ON djb.billing_id=dji.billing_id
				,(SELECT @csum:=0) as t 
				WHERE dji.account_id=$account_id AND dji.referral=0 GROUP BY DATE(dji.invoice_date)

			  ) as t 
			  
			  UNION
			 
			SELECT 
				date_time as date,account_id as accountid,pub_earn,(@cearn := @cearn + pub_earn) as cumm_earn,0 as cumm_paid,
				'' as invoice_paid_date,'' as invoice_status,'' as invoice_id,'' as invoice_code,0 as netamount, 0 as paid_amount, '' as payment_type 

			FROM

			  (

				SELECT t1.date_time,tf.account_id,SUM(t1.`dj_publisher_earnings`) as pub_earn FROM `rv_data_summary_ad_hourly` 

				as t1 JOIN rv_zones as tz ON tz.zoneid=t1.zone_id JOIN djax_site_zone_assoc as djsz ON djsz.zone_id=tz.zoneid 
				JOIN djax_publisher_sites as djps ON djps.site_id=djsz.site_id 
				JOIN rv_affiliates as tf  ON tf.affiliateid=tz.affiliateid AND tf.account_id=djps.account_id,

				(SELECT @cearn:=0) as temp WHERE tf.account_id=$account_id ";
				
				if($filter!=FALSE && $filter['site']!=FALSE)
				{
					$sit	=	is_array($filter['site'])?implode("','",$filter['site']):$filter['site'];
					$sql	.=	" AND djps.site_id IN ('".$sit."') ";
				}
				
				$sql	.=	" GROUP BY DATE(t1.date_time)

			   )as final

			
            ) as l_final WHERE MONTH(date)=$month AND YEAR(date)=$year"; 
		if($filter!=FALSE && $filter['search']!=FALSE)
		{
			$sql	.=	" AND (date like '%".$filter['search']."%' OR pub_earn like '%".$filter['search']."%' OR netamount like '%".$filter['search']."%' OR invoice_code like '%".$filter['search']."%' OR payment_type like '%".$filter['search']."%' OR invoice_status like '%".$filter['search']."%')";
		}
		if($filter!=FALSE && $filter['date_from']!=FALSE)
		{
			$sql	.=	" AND DATE(date) >='".$filter['date_from']."' ";
		}
		if($filter!=FALSE && $filter['date_to']!=FALSE)
		{
			$sql	.=	" AND DATE(date) <='".$filter['date_to']."' ";
		}
		
		if($filter!=FALSE && $filter['status']!=FALSE)
		{
			$stat	=	is_array($filter['status'])?implode("','",$filter['status']):$filter['status'];
			$sql	.=	" AND invoice_status IN ('".$stat."') ";
		}
		if($filter!=FALSE && $filter['payment_type']!=FALSE)
		{
			$ptype	=	is_array($filter['payment_type'])?implode("','",$filter['payment_type']):$filter['payment_type'];
			$sql	.=	" AND payment_type IN ('".$ptype."') ";
		}
		$in_sel = "SELECT count(*)
		   FROM 

		   (
			SELECT 
				invoice_date as date,0 as accountid,0 as pub_earn,0 as cumm_earn,(@csum := @csum + invoice_amount) as cumm_paid, 
				invoice_paid_date,invoice_id,invoice_code,netamount,paid_amount,
				CASE 
					WHEN invoice_status=0 THEN 'Pending'
					WHEN invoice_status=1 THEN 'Paid'
					WHEN invoice_status=2 THEN 'Cancelled'
				END as invoice_status,
				CASE 
					WHEN payment_type=1 THEN 'Wire'
					WHEN payment_type=2 THEN 'Paypal'
					WHEN payment_type=3 THEN 'Zpurse'
					WHEN payment_type=4 THEN 'Bitcoin'
					WHEN payment_type=5 THEN 'Authorize'
				END as payment_type

			FROM 

			  (

				select dji.invoice_date, SUM(dji.invoice_net_amount) as invoice_amount, dji.invoice_paid_date,dji.invoice_status,dji.invoice_id,dji.invoice_code,SUM(dji.invoice_net_amount) as netamount,
				CASE
					WHEN dji.invoice_status=1 THEN SUM(dji.invoice_net_amount)
					ELSE 0
				END as paid_amount,djb.payment_type

				from djax_invoice as dji
				JOIN djax_billing_information as djb ON djb.billing_id=dji.billing_id
				,(SELECT @csum:=0) as t 
				WHERE dji.account_id=$account_id AND dji.referral=0 GROUP BY DATE(dji.invoice_date)

			  ) as t 
			  
			  UNION
			 
			SELECT 
				date_time as date,account_id as accountid,pub_earn,(@cearn := @cearn + pub_earn) as cumm_earn,0 as cumm_paid,
				'' as invoice_paid_date,'' as invoice_status,'' as invoice_id,'' as invoice_code,0 as netamount, 0 as paid_amount, '' as payment_type 

			FROM

			  (

				SELECT t1.date_time,tf.account_id,SUM(t1.`dj_publisher_earnings`) as pub_earn FROM `rv_data_summary_ad_hourly` 

				as t1 JOIN rv_zones as tz ON tz.zoneid=t1.zone_id JOIN djax_site_zone_assoc as djsz ON djsz.zone_id=tz.zoneid 
				JOIN djax_publisher_sites as djps ON djps.site_id=djsz.site_id 
				JOIN rv_affiliates as tf  ON tf.affiliateid=tz.affiliateid AND tf.account_id=djps.account_id,

				(SELECT @cearn:=0) as temp WHERE tf.account_id=$account_id ";
				
				if($filter!=FALSE && $filter['site']!=FALSE)
				{
					$sit	=	is_array($filter['site'])?implode("','",$filter['site']):$filter['site'];
					$in_sel	.=	" AND djps.site_id IN ('".$sit."') ";
				}
				
				$in_sel	.=	" GROUP BY DATE(t1.date_time)

			   )as final

			
            ) as l_final WHERE MONTH(date)=$month AND YEAR(date)=$year"; 
		if($filter!=FALSE && $filter['search']!=FALSE)
		{
			$in_sel	.=	" AND (date like '%".$filter['search']."%' OR pub_earn like '%".$filter['search']."%' OR netamount like '%".$filter['search']."%' OR invoice_code like '%".$filter['search']."%' OR payment_type like '%".$filter['search']."%' OR invoice_status like '%".$filter['search']."%')";
		}
		if($filter!=FALSE && $filter['date_from']!=FALSE)
		{
			$in_sel	.=	" AND DATE(date) >='".$filter['date_from']."' ";
		}
		if($filter!=FALSE && $filter['date_to']!=FALSE)
		{
			$in_sel	.=	" AND DATE(date) <='".$filter['date_to']."' ";
		}
		
		if($filter!=FALSE && $filter['status']!=FALSE)
		{
			$stat	=	is_array($filter['status'])?implode("','",$filter['status']):$filter['status'];
			$in_sel	.=	" AND invoice_status IN ('".$stat."') ";
		}
		if($filter!=FALSE && $filter['payment_type']!=FALSE)
		{
			$ptype	=	is_array($filter['payment_type'])?implode("','",$filter['payment_type']):$filter['payment_type'];
			$in_sel	.=	" AND payment_type IN ('".$ptype."') ";
		}
			
		$sql	.=	" GROUP BY date ) as c, (SELECT @i := ($in_sel) + 1) as rowcount ";

		if($order!=FALSE && is_array($order) AND count($order) > 0){
				
			$OSQL	=	'';
			foreach($order as $key=>$option){
				$OSQL .= " {$key} {$option},";
			}
			$sql .= ($OSQL!='')?" ORDER BY ".$OSQL:"";		
			//REMOVE comma at End of the string
	
			$sql = rtrim($sql, ",");
		}
		elseif((!is_array($order)) && $order!=FALSE)
		{
			$ord	=	explode(',', $order);
			
			$OSQL	=	'';
			
			foreach($ord as $key){
				$OSQL .= " {$key} ASC,";
			}
			
			$sql .= ($OSQL!='')?" ORDER BY ".$OSQL:"";			
			//REMOVE comma at End of the string
	
			$sql = rtrim($sql, ",");
		}	
		else
		{
			$sql .=	" ORDER BY date DESC";
		}
			
		$query	=	$this->db->query($sql);
		//echo $this->db->last_query();exit;
		
		$result	=	$query->result_array();
		
		$count	=	$query->num_rows();

		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		}
	}	

	/*

   * ADMIN PANEL

   * name  : advertiser_payment_history

   * @param: none

   * @return:detailed info of advertiser payments history 

   * 

   */  

	public function advertiser_payment_history($agencyid)
	{
		
		$key = 'advertiser_payment_history_'.$agencyid;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{

		$sql	= 	"SELECT name,ROUND(SUM(spend),4) as tot_spend,ROUND(SUM(paid),4) as tot_paid,ROUND((SUM(paid) - SUM(spend)),4) as balance,month,year,month_number,account_id
					FROM 
					(SELECT 
						tcl.contact as name,sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id 
					FROM 
						`rv_data_summary_ad_hourly` as tds 
					JOIN `rv_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` 
					JOIN `rv_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` 
					JOIN `rv_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` AND tcl.dj_is_default!=2
					WHERE tcl.agencyid=".$agencyid." AND 
						tds.date_time BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW())  
					GROUP BY 
						MONTH(tds.date_time) , `tcl`.`account_id`
					
					UNION
					
					SELECT 
						tcl.contact as name,0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year,MONTH(approved_date)as month_number, dpt.account_id as account_id 
					FROM 
						`djax_payment_transaction` as dpt 
					JOIN rv_clients as tcl ON dpt.account_id=tcl.account_id AND tcl.dj_is_default!=2
					WHERE 
						dpt.approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND 
						last_day(NOW()) AND  
						dpt.transaction = 'credit' AND 
						dpt.admin_approval_status = 1 AND tcl.agencyid=".$agencyid."
					GROUP BY 
						MONTH(dpt.approved_date),account_id
					) as final WHERE 1 ";
					if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
						$sql	.=" AND account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
					endif;
					$sql	.=	" GROUP BY month,account_id ORDER BY month";

		$result	=	$this->db->query($sql);

		$data	=	$result->result_array();

		if($data){			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$data,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $data;
		}
		
		}
		else
		{
			return FALSE;
		} 
	}
}

	/*

   * ADMIN PANEL

   * name  : fetch_advertiser_date_wise_payment_history

   * @param: account_id,month,year

   * @return:detailed info of advertiser payments history date wise

   * 

   */

	public function fetch_advertiser_date_wise_payment_history($month=FALSE,$year=FALSE,$account_id=FALSE)

	{
		$key = 'fetch_advertiser_date_wise_payment_history'.$month.'_'.$year.'_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{		

			$sql= "SELECT name,email,payment_type,ROUND(SUM(amount),4) as paid_amt,DATE(approved_date) as date, 		  	        

			YEAR(approved_date) as year,account_id,admin_approval_status as approve FROM djax_payment_transaction 

			WHERE approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW()) AND transaction='credit' AND admin_approval_status=1 AND account_id=$account_id 

			AND MONTH(approved_date)=$month AND YEAR(approved_date)=$year GROUP BY date ORDER BY approved_date DESC";

			$result=$this->db->query($sql);

			$data=$result->result_array();

			if($data){

				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$data,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $data;
				}
			}
			else
			{
				return FALSE;
			}
		}	
	}
  

   /*

   * ADMIN PANEL

   * name  : publisher_payment_history

   * @param: none

   * @return:detailed info of publisher payments history 

   * 

   */  

	public function publisher_payment_history($agencyid)
	{
	//	return '$retqqwewqewqewrwreeretret';
		$key = 'publisher_payment_history_'.$agencyid;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$sql="SELECT dpt.name,ROUND(SUM(dpt.amount),4) as paid_amt,MONTHNAME(dpt.approved_date) as month,MONTH(dpt.approved_date) as 		  	        

			month_number,YEAR(dpt.approved_date) as year,dpt.account_id,0 as spend_amt FROM djax_payment_transaction as dpt JOIN rv_affiliates as dof ON dpt.account_id=dof.account_id

			WHERE dpt.approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW()) AND dpt.transaction='debit' AND dpt.admin_approval_status=1 

			AND dof.agencyid=".$agencyid; 
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$sql	.=" AND account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
			endif;
			
			$sql	.=	" GROUP BY YEAR(dpt.approved_date),MONTH(dpt.approved_date),account_id ORDER BY DATE(dpt.approved_date) DESC";

			$result	=	$this->db->query($sql);
			//echo $this->db->last_query();exit;
			$data	=	$result->result_array();

			if($data){
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$data,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $data;
				}
			}
			else
			{
				return FALSE;
			}
		}	
	}

   /*

   * ADMIN PANEL

   * name  : fetch_publisher_date_wise_payment_history

   * @param: account_id,month,year

   * @return:detailed info of publisher payments history date wise

   * 

   */

	public function fetch_publisher_date_wise_payment_history($month=FALSE,$year=FALSE,$account_id=FALSE)

	{
		
		$key = 'fetch_publisher_date_wise_payment_history_'.$month.'_'.$year.'_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{

		   $sql= "SELECT name,email,payment_type,ROUND(SUM(amount),4) as paid_amt,DATE(approved_date) as date, 		  	        

		   YEAR(approved_date) as year,account_id,admin_approval_status as approve FROM djax_payment_transaction 

		   WHERE approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW()) AND transaction='debit' AND admin_approval_status=1 AND account_id=$account_id AND MONTH(approved_date)=$month AND YEAR(approved_date)=$year GROUP BY date ORDER BY date DESC";

		   $result=$this->db->query($sql);

		   $data=$result->result_array();

		   if($data){

		    	if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$data,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $data;
			}

			}

			else

			{

			  return FALSE;

			}

		}
	
	}

	

	/*

   * ADMIN PANEL

   * name  : fetch_admin_payment_history

   * @param: none

   * @return:detailed info of every month payment history

   */
		
	public function fetch_admin_payment_history($agencyid)
	{
	  	$key = 'fetch_admin_payment_history_'.$agencyid;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	   $sql="SELECT ROUND(SUM(adv_amt),4) as total_credit,ROUND(SUM(pub_amt),4) as total_debit,(ROUND(SUM(adv_amt),4)-ROUND(SUM(pub_amt),4)) as revenue,month,year

			FROM (

			   SELECT SUM(dpt.amount) as adv_amt, 0 as pub_amt,MONTHNAME(dpt.approved_date) as month,YEAR(dpt.approved_date) as year,dpt.approved_date as app

			  FROM  djax_payment_transaction as dpt JOIN rv_clients as dcl ON dpt.account_id=dcl.account_id

			  WHERE dpt.transaction='credit' AND dpt.admin_approval_status=1 AND dcl.agencyid=$agencyid GROUP BY MONTH(dpt.approved_date)

			  UNION 

			   SELECT 0 as adv_amt,SUM(dpt.amount) as pub_amt,MONTHNAME(dpt.approved_date) as month,YEAR(dpt.approved_date) as year,dpt.approved_date as app

			  FROM  djax_payment_transaction as dpt JOIN rv_affiliates as dcl ON dpt.account_id=dcl.account_id 

			  WHERE dpt.transaction='debit' AND dpt.admin_approval_status=1 AND dcl.agencyid=$agencyid GROUP BY MONTH(dpt.approved_date)

			) AS final  GROUP BY year,month ORDER BY app DESC";

	   $result=$this->db->query($sql);

	   $data=$result->result_array();

	   if($data){

	  if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$data,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $data;
		}

		}

		else

		{

		  return FALSE;

		}

	

	}
	
}

  

  

   /*

   * ADMIN PANEL

   * name  : reject_invoice_payment

   * @param: invoice_id

   * @return: invoice Payment canceled by admin

   */	

   public function reject_invoice_payment($invoice_id)

   {

       if($invoice_id)

          $this->db->select('account_id');

		  $this->db->where('invoice_id',$invoice_id);

		  $result=$this->db->get(TAB_INVOICE);

		  $account_id=$result->result_array();

		  if($account_id)

		  	  //CHANGE THE INVOICE STATUS TO CANCEL AND RETURN account_id

			  $data=array('invoice_status'=>2);

			  $this->db->where('invoice_id',$invoice_id);

			  $this->db->update(TAB_INVOICE,$data);

			  $acc_id=$account_id[0]['account_id'];

			  return $acc_id;

    }

    

    /*

   * ADVERTISER PANEL

   * name  : fetch_deposit_list

   * @param: invoice_id

   * @return: invoice Payment canceled by admin

   */

    public function fetch_deposit_list($account_id,$filter=FALSE)
    {

		/*$this->db->select('*');

	    $this->db->where('transaction',"credit");

	    $this->db->where('account_id',$account_id);

	    $this->db->order_by('date');

	    $query = $this->db->get(TAB_PAY_TRANS);

	    $result=$query->result_array();

	    if($result)

		{

		  return $result;

		}

	    else

		{

		   return FALSE;

		}*/
		
		$key = 'fetch_deposit_list_'.$account_id;
		
		if($filter!=FALSE):
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		$check_db_changes = $this->memcached_library->get(ADVERTISER_DEPOSIT_LIST);
		
		if($ret && $mem_cache=='enable'  && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		

			$this->db->select('*');

			$this->db->where('tpt.transaction',"credit");

			$this->db->where('tpt.account_id',$account_id);

			$this->db->from(TAB_PAY_TRANS. ' as tpt ');

			$this->db->join(TAB_BILL_INFO. ' as tbi ','tpt.ref_billing_id=tbi.billing_id');
			
			if($filter!=FALSE && $filter['status']!=FALSE)
			{
				$stat	=	is_array($filter['status'])?$filter['status']:array($filter['status']);
				$this->db->where_in('admin_approval_status',$stat);
			}
			if($filter!=FALSE && $filter['payment_type']!=FALSE)
			{
				$ptype	=	is_array($filter['payment_type'])?$filter['payment_type']:array($filter['payment_type']);
				$this->db->where_in('tbi.payment_type',$ptype);
			}
			if($filter!=FALSE && $filter['daterangepicker_cs']!=FALSE)
			{
				$dates	=	is_array($filter['daterangepicker_cs'])?$filter['daterangepicker_cs']:array($filter['daterangepicker_cs']);
				$this->db->where('DATE(tbi.created_date)>=',$dates[0]);
				$this->db->where('DATE(tbi.created_date)<=',$dates[1]);
			}
			
			$this->db->order_by('tpt.date',DESC);
			$query = $this->db->get();
			//echo $this->db->last_query();exit;
			$result=$query->result_array();
			$count=$query->num_rows();

			if($result)
			{
				$i=0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);
					$this->memcached_library->set(ADVERTISER_DEPOSIT_LIST,'2');	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}

			}
			else
			{

			   return FALSE;

			}

		}
	}

	public function fetch_monthly_deposit_list($account_id,$date)
    	{		
		$key = 'fetch_monthly_deposit_list_'.$account_id;
		if($date!=FALSE)		
		{
			$key.='_'.$date;
		}
				
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');		
		
		if($ret && $mem_cache=='enable')
		{
			return $ret;
		}
		else
		{

		$this->db->select('*');

		$this->db->where('tpt.transaction',"credit");

        $this->db->where('tpt.account_id',$account_id);
       // $this->db->where('tpt.admin_approval_status','1');
        $this->db->like('tpt.approved_date',$date,'after');

		$this->db->from(TAB_PAY_TRANS. ' as tpt ');

        $this->db->join(TAB_BILL_INFO. ' as tbi ','tpt.ref_billing_id=tbi.billing_id');
        
       // $this->db->order_by('tpt.clearing_date',DESC);
		$this->db->order_by('tpt.date',DESC);
        $query = $this->db->get();

	    $result=$query->result_array();
	 #  return $this->db->last_query();
		$count=$query->num_rows();

	    if($result)

		{
			$i=0;$j=$count;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}

		 if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}

		}

	    else

		{

		   return FALSE;

		}

		}
	}

	/*

   * ADMIN PANEL

   * name  : fetch_adv_deposit_list

   * @param: invoice_id

   * @return: Advertiser Deposit Payment

   */

   public function fetch_adv_deposit_list($agencyid,$filter=FALSE)
   {  
	   
	   	$key = 'fetch_adv_deposit_list_'.$agencyid;
		if($filter!=FALSE):
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$this->db->select('*');

			$this->db->where('tpt.transaction',"credit");

			//$this->db->where('tpt.admin_approval_status',1);
			
			$this->db->where('tc.agencyid',$agencyid);

			$this->db->where_not_in('tpt.account_id',0);

			$this->db->from(TAB_PAY_TRANS. ' as tpt ');

			$this->db->join(TAB_BILL_INFO. ' as tbi ','tpt.ref_billing_id=tbi.billing_id');
			
			$this->db->join(TAB_CLIENTS. ' as tc ','tc.account_id=tpt.account_id');
			
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
				$adv	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('tc.account_id',$adv);
			endif;
			
			$stat = explode(',',$filter['status']);	 
			if($filter!=FALSE    && $stat!=FALSE)
			{ 
				//~ $stat	=	is_array($filter['status'])?$filter['status']:explode(',',$filter['status']);
				//$stat	=	explode(',',$filter['status']);
				if($stat[0]=='x'){$stat[0]='0';} 
				if($stat[0]!='')
				{
					$this->db->where_in('admin_approval_status',$stat);
				}
			}
			
			if($filter!=FALSE && $filter['payment_type']!=FALSE)
			{
				//~ $ptype	=	is_array($filter['payment_type'])?$filter['payment_type']:array($filter['payment_type']);
				
				$ptype	=	explode(',',$filter['payment_type']);
				if($ptype)
				{
					$this->db->where_in('tpt.payment_type',$ptype);
				}
			}
				
			$this->db->where_not_in('tc.dj_is_default',2);
			
			$this->db->order_by('tpt.date','DESC');
			
			$query 	= 	$this->db->get(); // return $this->db->last_query();exit;

			$result	=	$query->result_array();
			
			$count	=	$query->num_rows();
			//log_message('ERROR', $this->db->last_query());
			if($result)
			{
				$i=0;$j=$count;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$j;
					$i+=1;$j-=1;
				}
				
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
		} 
	}

   

   /*

   * ADMIN PANEL

   * name  : fetch_billing_details

   * @param: invoice_id

   * @return: Advertiser Billing Details

   */

	public function fetch_billing_details($bi_id)
	{

		$key = 'fetch_billing_details_'.$bi_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
	    $this->db->select('*');

	    $this->db->where('billing_id',$bi_id);

	   //$this->db->order_by('created_date',DESC);
	    $query = $this->db->get(TAB_BILL_INFO);
	    
	    

	    $result=$query->result_array();

		if($result)

		{

		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		
		}

		else

		{

		   return FALSE;

		}

   }
   
}

   

   

   /*

   * ADMIN PANEL

   * name  : check_payment_process

   * @param: pay_id

   * @return: return its approved or rejected

  */

   public function check_payment_process($pay_id)

   {

       $query=$this->db->get_where(TAB_PAY_TRANS,array('admin_approval_status'=>0,'id'=>$pay_id));

	   if($query->num_rows>0)

	          return TRUE;

	   else

	          return FALSE;

   }
   
    public function check_dirpayment_process($pay_id)
	{
       $query=$this->db->get_where('djax_direct_campaign_payment',array('admin_approval_status'=>0,'id'=>$pay_id));
	   if($query->num_rows>0)
          return TRUE;
	   else
          return FALSE;
	}
	
	public function get_dirpayment_details($pay_id)
	{
		$query	=	$this->db->get_where('djax_direct_campaign_payment',array('admin_approval_status'=>0,'id'=>$pay_id));
		if($query->num_rows>0)
			return $query->result_array();
		else
			return FALSE;
	}

   

      /*

   * ADMIN PANEL

   * name  : check_invoice_payment_process

   * @param: invoice_id

   * @return: return its approved or rejected

  */

   public function check_invoice_payment_process($invoice_id)

   {

       $query=$this->db->get_where(TAB_INVOICE,array('invoice_id'=>$invoice_id,'invoice_status'=>0));

	   if($query->num_rows>0)

	          return TRUE;

	   else

	          return FALSE;

   }

   

   /*

   * ADMIN PANEL

   * name  : fetch_admin_revenue_details

   * @param: agencyid

   * @return: return month wise revenue details

  */

   public function fetch_admin_revenue_details($agencyid)

   {
	   
	   $key = 'fetch_admin_revenue_details_'.$agencyid;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		

      $SQL = "SELECT IFNULL(ROUND(SUM(oxds.dj_total_revenue) - SUM(oxds.dj_publisher_earnings),2),0) as tot_revenue,MONTHNAME(oxds.date_time) as month_name,

	            MONTH(oxds.date_time) as month,oxa.agencyid as agencyid,YEAR(oxds.date_time) as year

				FROM ".TAB_DATA_SUM_AD_HOURLY." as oxds

				JOIN ".TAB_ZONES." as oxz ON oxz.zoneid=oxds.zone_id

				JOIN ".TAB_AFFILIATE." as oxa ON (oxa.affiliateid=oxz.affiliateid AND oxa.agencyid={$agencyid}) GROUP BY MONTH(oxds.date_time) DESC

				";  

		$query = $this->db->query($SQL);

		

		$result = $query->result_array();		

		

		if($result)

		{			

		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}

		}

		else

		{

			return FALSE;

		}

   }
   
}

   

   

    /*

   * ADMIN PANEL

   * name  : fetch_admin_revenue_details_date_wise

   * @param: month,year,agencyid

   * @return: return date wise revenue details

  */

   public function fetch_admin_revenue_details_date_wise($month,$year,$agencyid)

   {
	   
	   
	   	$key = 'fetch_admin_revenue_details_date_wise_'.$month.'_'.$year.'_'.$agencyid;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{

        $SQL = "SELECT IFNULL(ROUND(SUM(oxds.dj_total_revenue) - SUM(oxds.dj_publisher_earnings),4),0) as tot_revenue,DATE(oxds.date_time) as date

				FROM ".TAB_DATA_SUM_AD_HOURLY." as oxds

				JOIN ".TAB_ZONES." as oxz ON oxz.zoneid=oxds.zone_id

				JOIN ".TAB_AFFILIATE." as oxa ON (oxa.affiliateid=oxz.affiliateid AND oxa.agencyid={$agencyid}) WHERE MONTH(oxds.date_time)={$month} AND YEAR(oxds.date_time)={$year}

				GROUP BY DATE(oxds.date_time)";  

				

		$query = $this->db->query($SQL);

		

		$result = $query->result_array();		

		

		if($result)

		{			

		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}

		}

		else

		{

			return FALSE;

		}

	

   }
   
   
}

	/* get network details
	  * 
	  *   djax_app_configurations AND djax_networks
	  * ---------------------
	  *  	new_user_approval_type 	
	  * 	email_address 
	  * 
	  * */
	  
	  function get_network_details()
	  {
		  
		  
		  $key = 'get_network_details';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		  	  
		$where	=	array(
							'djn.is_super_admin'=>	1						
							);		
		$this->db->select( 'app.new_user_approval_type as approval_type,
							djn.first_name  as firstname,
							djn.last_name as lastname,
							djn.email_address as email,
							djn.date_added as app_date,
							djn.billing_company_name,
							djn.billing_address,
							djn.billing_block_no,
							djn.billing_city,
							djn.billing_state,
							djn.billing_country,
							dtc.name'							
							);
		$this->db->from(TAB_APP_CONFIG.' as app');
		$this->db->join(TAB_NETWORKS.' as djn','djn.account_id = app.network_account_id');
		$this->db->join('djax_targ_country as dtc', 'dtc.id=djn.billing_country','left');	
		$this->db->where($where);
		$query = $this->db->get();
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}else{
			return FALSE;	
		}	
		
	  }
 }

	/* get publisher details
	  * 
	  *   djax_app_configurations AND djax_networks
	  * ---------------------
	  *  	new_user_approval_type 	
	  * 	email_address 
	  * 
	  * */
	  
	function get_publisher_details($id)
	{
		    $key = 'get_publisher_details'.$id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		  	  
		$this->db->select( 'oxa.dj_company_name,
							oxa.dj_company_address,
							oxa.dj_company_block_no,
							oxa.dj_company_city,
							oxa.dj_company_state,
							oxa.dj_company_country,
							dtc.name'							
							);
		$this->db->from('rv_affiliates as oxa');
		 
	   	$this->db->join('djax_targ_country as dtc','dtc.id=oxa.dj_company_country','left');
		
		$this->db->where('oxa.account_id',$id);
		
		$query = $this->db->get();
				
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}else{
			return FALSE;
		}
		
	  }
	 }
	  
	  /*

  * name: invoice_viewmore

  * @param : $invoice_id

  * @return :detailed list of campaign payment 

  */

   public function fetch_campaign_individual_invoice($invoice_code=FALSE)

   {  
	   	$key = 'fetch_campaign_individual_invoice'.$invoice_code;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	   

     $this->db->select('dc.name,dc.campaign_id,c.campaignname, dc.email,dc.payment_type,dc.admin_approval_status,dc.date,dc.approved_date,c.dj_added_date,dc.id, dc.currency,dc.invoice_code, dc.amount as netamount');

	   $this->db->where('dc.invoice_code',$invoice_code);

       $this->db->from(TAB_DIR_CAMP_PAY.' as dc ');

	   $this->db->join(TAB_CAMPAIGNS.' as c ','c.campaignid=dc.campaign_id');

	   $this->db->where('dc.is_default','0');
	   
	   $query=$this->db->get();
	   
	   $result=$query->result_array();

	   if($result)

	    {

		 if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}

		}

	   else

			{

		   return FALSE;

			}

		}
	}

	public function fetch_pub_payment_approval($pay_type =FALSE,$agencyid=FALSE)
	{
		
		
		if($pay_type == '2'){
		$this->db->select('tpp.paypal_id as paypal_id,ROUND(sum(ti.invoice_net_amount)) as amount,ti.invoice_code,tu.contact_name as name');
		}
		else if($pay_type == '3'){
			$this->db->select('tpp.bank_account_no as bank_account_no,ROUND(sum(ti.invoice_net_amount)) as amount,ti.invoice_code');
		}
		$this->db->where('ti.invoice_status',0);
		
		//$this->db->where('ti.referral',0);

		$this->db->join(TAB_USERS.' as tu ','tu.default_account_id = ti.account_id');

		$this->db->join(TAB_PUB_PAYD.' as tpp ','tpp.account_id = ti.account_id');

		$this->db->where('tpp.is_default',1);
		$this->db->where('tpp.payment_type',$pay_type);
		$this->db->order_by('ti.invoice_date',DESC);

		if($agencyid!=FALSE)
		{
			$this->db->where('tf.agencyid',$agencyid);

			$this->db->join(TAB_AFFILIATE.' as tf','tpp.account_id=tf.account_id');
		}
		
		$this->db->group_by('tpp.account_id');

		if($invoice_id)
		{
			$query=$this->db->get_where(TAB_INVOICE.' as ti ',array('invoice_id'=>$invoice_id));

		}else{
			$query=$this->db->get(TAB_INVOICE.' as ti ');
		}
		
		$result	=	$query->result_array();

		$count=$query->num_rows();
		if($result)
		{
		
			return $result;
		
		}
		else
	    {
			return FALSE;
		}
		
   }
   
   /*********Wallet**********/
	public function get_wallet_bal($account_id)
	{
		if($account_id)
		{
			$this->db->select('dj_wallet_balance');
			$this->db->where('account_id',$account_id);
			$query=$this->db->get(TAB_CLIENTS);
			$result	=	$query->result_array();
			if($result)
			{
				return $result[0]['dj_wallet_balance'];
			}
			else return 'error';
		}
	}
	public function get_wallet_bal_client($client_id)
	{
		if($client_id)
		{
			$this->db->select('dj_wallet_balance');
			$this->db->where('clientid',$client_id);
			$query=$this->db->get(TAB_CLIENTS);
			$result	=	$query->result_array();
			if($result)
			{
				return $result[0]['dj_wallet_balance'];
			}
			else return 'error';
		}
	}
	
	public function get_camp_bal($campaign_id)
	{
		$this->db->select('clientid,(dj_campaign_budget -wcamp_remain) as remain_amount ');
		$this->db->where('campaignid',$campaign_id);
		$query=$this->db->get(TAB_CAMPAIGNS);
		$result	=	$query->result_array();
	   
		return $result[0];
		 
	}
	
	function add_amt_deleted_camp($new_balance,$clientids)
	{
		$SQL_fund="UPDATE ".TAB_CLIENTS." SET `dj_wallet_balance` = ".$new_balance." WHERE `clientid` =".$clientids;
		
		$query = $this->db->query($SQL_fund);
			
		return TRUE;
	}
	
   public function wallet_to_campaign($account_id,$campaign_ids)
   {//for get total campaign fund available balance
	   $this->db->select('rvca.campaignid,rvca.dj_campaign_budget,rvca.wcamp_remain,rvca.dj_daily_budget,rvca.campaignname');
	   $this->db->where('rvc.account_id',$account_id);
	   
	   $this->db->where('rvca.dj_is_deleted','0');
	   if($campaign_ids=='active')
	   {
		     $this->db->where('rvca.status','0');
	   }
	   elseif($campaign_ids=='inactive')
	   {	 $array_inactive=array('1','2','5','6','8');
		     $this->db->where_in('rvca.status',$array_inactive);
	   }
	   elseif($campaign_ids=='all')
	   {
		     $array_all=array('0','1','2','5','6','8');
		     $this->db->where_in('rvca.status',$array_all);
	   }
	   else
	   {	$array_not=array('7','3');
			$this->db->where_not_in('rvca.status',$array_not);
		    $this->db->where_in('rvca.campaignid',$campaign_ids);
	   }
	  
	   $this->db->join(TAB_CLIENTS.'as rvc','rvc.clientid=rvca.clientid');
	   $query=$this->db->get(TAB_CAMPAIGNS.' as rvca ');
	   
	   $result	=	$query->result_array();
	   
			return $result;
		 
   }
   
   
   public function get_camp_count($account_id,$campaign_ids)
   {
		$this->db->select('rvca.campaignname');
		$this->db->where('rvc.account_id',$account_id);
	   
		$this->db->where('rvca.dj_is_deleted','0');
		if($campaign_ids=='active')
	   {
		     $this->db->where('rvca.status','0');
	   }
	   elseif($campaign_ids=='inactive')
	   {	 $array_inactive=array('1','2','5','6','8');
		     $this->db->where_in('rvca.status',$array_inactive);
	   }
	   elseif($campaign_ids=='all')
	   {
		     $array_all=array('0','1','2','5','6','8');
		     $this->db->where_in('rvca.status',$array_all);
	   }
	   else
	   { 	$array_not=array('7','3');
			$this->db->where_not_in('rvca.status',$array_not);
		    $this->db->where_in('rvca.campaignid',$campaign_ids);
		  
	   }
		
		
		$this->db->join(TAB_CLIENTS.'as rvc','rvc.clientid=rvca.clientid');
		$query=$this->db->get(TAB_CAMPAIGNS.' as rvca ');
		$count=$query->num_rows();
		if($count)
		{
			return $count;
		}
		else
	    {
			return FALSE;
		}
   }
	public function campaign_fund_update($camp_data,$account_id,$deducted_amt)
	{ 
		foreach($camp_data as $key=>$value)
		{ 
			 
			//$SQL="UPDATE ".TAB_CAMPAIGNS." SET `dj_campaign_budget` = ".$value['dj_campaign_budget'].", `wcamp_remain`=".$value['wcamp_remain']." WHERE `campaignid` =".$value['campaignid'];
			$SQL="UPDATE ".TAB_CAMPAIGNS." SET `dj_campaign_budget` = ".$value['dj_campaign_budget']." WHERE `campaignid` =".$value['campaignid'];
			$query = $this->db->query($SQL);
		} 
		 
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return FALSE;
		}
		else 
		{
			$SQL_fund="UPDATE ".TAB_CLIENTS." SET `dj_wallet_balance` = ".$deducted_amt." WHERE `account_id` =".$account_id;
			$query = $this->db->query($SQL_fund);
			
			return TRUE;
		}
		
	}
	
	public function get_advcamp_fund($account_id)
	{
		//$this->db->select('rvca.campaignid,rvca.dj_campaign_budget,(rvca.dj_campaign_budget-rvca.dj_campaign_remain_total_budget) as remain_amt');
		$this->db->select('rvca.campaignid,rvca.dj_campaign_budget,(rvca.dj_campaign_budget-rvca.wcamp_remain) as remain_amt');
		$this->db->where('rvc.account_id',$account_id);
		$this->db->where('rvca.dj_is_deleted','0');
		$this->db->where('rvca.dj_campaign_budget >','0');
		$this->db->join(TAB_CLIENTS.'as rvc','rvc.clientid=rvca.clientid');
		$query=$this->db->get(TAB_CAMPAIGNS.' as rvca');
		$result	=	$query->result_array();
		return $result;
	}
	
	public function wallet_fund_update($camp_data=FALSE,$client_id=FALSE,$new_amt=FALSE,$campaignid=FALSE)
	{  
		$SQL="UPDATE ".TAB_CAMPAIGNS."  SET dj_campaign_budget = 0, wcamp_remain = 0 , status = 8	where status not in (7,3) and clientid = ".$client_id." and campaignid in (".$campaignid .")";
		
		$query = $this->db->query($SQL);		
		if ($this->db->trans_status() !== FALSE)
		{
			$SQL_fund="UPDATE ".TAB_CLIENTS." SET `dj_wallet_balance` = ".$new_amt['amount']." WHERE `clientid` =".$client_id;
			$query = $this->db->query($SQL_fund);
			
			
			return TRUE;
		}
		else
		{
			$this->db->trans_rollback();
			return FALSE;
		}
	}
	public function fetch_advertiser_activity_log($account_id,$payment_type=FALSE,$state=FALSE)
	{
		$this->db->select('p.id,p.date,p.browser,p.os,p.ip,p.amount,p.transfer_path,p.campaign_id,p.account_id,
		tc.dj_campaign_budget,p.campaign_budget,p.wallet,tc.dj_is_admarket,p.campaign_remain,tc.campaignname');
		$this->db->join(TAB_CAMPAIGNS.' as tc','p.campaign_id=tc.campaignid','left');
		
		if($payment_type)
		{
			if($payment_type == 'all')
			{	$payments=  array('ctow', 'wtoc');
				$this->db->where_not_in('p.transfer_path', $payments);
			}					
			else
			{
				$this->db->where('p.transfer_path',$payment_type);
			}
		}
		if($state)
		{
			if($state == 'act')
			{
				$this->db->where_in('tc.status','0');
			}
			elseif($state == 'inact')
			{	$camp_state_inact=array('1','2','3','4','5','6','7','8');
				$this->db->where_in('tc.status',$camp_state_inact);
			}
		}
		$this->db->where('p.account_id',$account_id);
		$this->db->order_by("p.date", "desc");
		$query = $this->db->get(TAB_PAY_ACTIVITY.' as p ');//return $this->db->last_query();
		if($query->num_rows()>0)
		{
			return $query->result_array();
		}
		else
		{
			return false;
		}
	}
	
}
