<?php
class do_notification extends CI_Model
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
	}
    
	function getAdminAgencyId($account_id){
		$key = 'getAdminAgencyId_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		$SQL = "SELECT `agency_id` FROM `djax_network_managers` WHERE `manager_account_id`={$account_id} AND role='ADMIN' LIMIT 0,1";
		$query = $this->db->query($SQL);
		if($query->num_rows() > 0){
			$result = $query->result_array();
			if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key, $result[0]['agency_id'],$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else
			return $result[0]['agency_id'];
		}
		else
		{
			return FALSE;
		}
		
	}
	}
	
	function getManagerAgencyId($account_id){
		
		$key = 'getManagerAgencyId'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		
		$SQL = "SELECT `agency_id` FROM `djax_network_managers` WHERE `manager_account_id`={$account_id} LIMIT 0,1";
		$query = $this->db->query($SQL);
		if($query->num_rows() > 0){
			$result = $query->result_array();
			
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key, $result[0]['agency_id'],$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else
			return $result[0]['agency_id'];
			
		}
		else
		{
			return FALSE;
		}
	}
	}
	
	function getAdvertiserAgencyId($account_id){
		
		$key = 'getAdvertiserAgencyId'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			$SQL = "SELECT `agencyid` FROM ".TAB_CLIENTS." WHERE `account_id`={$account_id} LIMIT 0,1";
			$query = $this->db->query($SQL);
			if($query->num_rows() > 0){
				$result = $query->result_array();
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key, $result[0]['agencyid'],$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else
				{	
					return $result[0]['agencyid'];
				}
			}
			else
			{
				return FALSE;
			}
		}
	}
	
	function getPublisherAgencyId($account_id){
		$SQL = "SELECT `agencyid` FROM `rv_affiliates` WHERE `account_id`={$account_id}  LIMIT 0,1";
		$query = $this->db->query($SQL);
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['agencyid'];
		}
		else
		{
			return FALSE;
		}
	}
	
	
	    
	function approval_notification($account_id,$account_type,$agency_id,$manager_role_id=FALSE)
	{
		
				$tot_count = 0; 
				$result = array();
		
		
				switch(strtoupper($account_type)){
			
				case ('ADMIN');
				case ('MANAGER');
				        
						if($manager_role_id ===FALSE OR ($manager_role_id !=FALSE AND check_permission_layout('128',$manager_role_id))){
				
							// GET UNAPPROVED ADVERTISER COUNT
							
							$account_type = 'ADVERTISER';
							
							$advertiser_obj =	$this->do_approval->fetch_user_count($agency_id,$account_type); 
							
							
							if($advertiser_obj != FALSE AND isset($advertiser_obj['user_count']) AND $advertiser_obj['user_count'] != 0) {
							
							$tot_count += $advertiser_obj['user_count'];
							
							$result['advertiser'] = array(
														"COUNT"=>$advertiser_obj['user_count'],
														"URL"=>site_url('admin/approvals'),
														"CLASS"=>'<i class="glyphicon-user"></i>',
														"TIME_DIF"=>$this->_ago($advertiser_obj['last_create_date']),
														"MSG"=>'awaiting approval'
													 );	
							
							}
						
						}
						
						// GET UNAPPROVED PUBLISHER COUNT
						
						if($manager_role_id ===FALSE OR ($manager_role_id !=FALSE AND check_permission_layout('130',$manager_role_id))){
						
							$account_type = 'TRAFFICKER';
							
							$publisher_obj =	$this->do_approval->fetch_user_count($agency_id,$account_type); 
						
							if($publisher_obj != FALSE AND isset($publisher_obj['user_count']) AND $publisher_obj['user_count'] > 0){
							
							$tot_count += $publisher_obj['user_count'];
							
							$result['publisher'] = array(
														"COUNT"=>$publisher_obj['user_count'],
														"URL"=>site_url('admin/approvals/publisher_approvals'),
														"CLASS"=>'<i class="glyphicon-user"></i>',
														"TIME_DIF"=>$this->_ago($publisher_obj['last_create_date']),
														"MSG"=>'awaiting approval'
													 );	
							
							}
						
						}
						
						// GET UNAPPROVED CREATIVE COUNT
						
						if($manager_role_id == FALSE OR ($manager_role_id != FALSE AND check_permission_layout('131',$manager_role_id))){
						
							$creative_obj = $this->do_creative->fetch_creative_by_approve('NAPPROVE',$agency_id);		
							
							if($creative_obj != FALSE AND isset($creative_obj['banner_count']) AND $creative_obj['banner_count'] > 0){
							
								$tot_count += $creative_obj['banner_count'];
							
								$result['creative'] = array(
														"COUNT"=>$creative_obj['banner_count'],
														"URL"=>site_url('admin/approvals/creative_approvals'),
														"CLASS"=>'<i class="icon-picture"></i>',
														"TIME_DIF"=>$this->_ago($creative_obj['last_create_date']),
														"MSG"=>'awaiting approval'
													 );	
							
							}
						
						}
						
						// GET UNAPPROVED ADVERTISER DEPOSITS
						
						if($manager_role_id ===FALSE OR ($manager_role_id !=FALSE AND check_permission_layout('132',$manager_role_id))){
						
							$adv_payment_obj = $this->do_payments->fetch_unapproved_advertiser_payment($agency_id);
							
							if($adv_payment_obj != FALSE AND isset($adv_payment_obj['deposit_count']) AND $adv_payment_obj['deposit_count'] > 0){
							
								$tot_count += $adv_payment_obj['deposit_count'];
							
								$result['deposit'] = array(
														"COUNT"=>$adv_payment_obj['deposit_count'],
														"URL"=>site_url('admin/approvals/advertiser_payment_approvals'),
														"CLASS"=>'<i class="glyphicon-coins"></i>',
														"TIME_DIF"=>$this->_ago($adv_payment_obj['last_create_date']),
														"MSG"=>'awaiting approval'
													 );	
							
							}
						
						}
						
						// GET UNAPPROVED PUBLISHER INVOICES
						
						if($manager_role_id ===FALSE OR ($manager_role_id !=FALSE AND check_permission_layout('132',$manager_role_id))){
						
						
							$pub_payment_obj = $this->do_payments->fetch_unapproved_publisher_payment($agency_id);
			
							
							
							if($pub_payment_obj != FALSE AND isset($pub_payment_obj['invoice_count']) AND $pub_payment_obj['invoice_count'] > 0){
							
								$tot_count += $pub_payment_obj['invoice_count'];
							
								$result['invoice'] = array(
														"COUNT"=>$pub_payment_obj['invoice_count'],
														"URL"=>site_url('admin/approvals/publisher_payment_approvals'),
														"CLASS"=>'<i class="glyphicon-coins"></i>',
														"TIME_DIF"=>$this->_ago($pub_payment_obj['last_create_date']),
														"MSG"=>'awaiting approval'
													 );	
							
							}
						
						}
						break;
						
				case 'ADVERTISER';
			
						
						// GET UNAPPROVED CREATIVE COUNT
						
						$creative_obj = $this->do_creative->fetch_creative_by_approve('NAPPROVE',$agency_id,$account_id);		
						
						if($creative_obj != FALSE AND isset($creative_obj['banner_count']) AND $creative_obj['banner_count'] > 0){
						
							$tot_count += $creative_obj['banner_count'];
						
							$result['creative'] = array(
													"COUNT"=>$creative_obj['banner_count'],
													"URL"=>site_url('advertiser/creatives'),
													"CLASS"=>'<img src='.base_url().'template/images/user_role.jpg>',
													"TIME_DIF"=>$this->_ago($creative_obj['last_create_date']),
													"MSG"=>'awaiting approval'
												 );	
						
						}
						
						// GET UNAPPROVED ADVERTISER DEPOSITS
						
						$adv_payment_obj = $this->do_payments->fetch_unapproved_advertiser_payment($agency_id,$account_id);
						
						if($adv_payment_obj != FALSE AND isset($adv_payment_obj['deposit_count']) AND $adv_payment_obj['deposit_count'] > 0){
						
							$tot_count += $adv_payment_obj['deposit_count'];
						
							$result['deposit'] = array(
													"COUNT"=>$adv_payment_obj['deposit_count'],
													"URL"=>site_url('advertiser/payments/deposits'),
													"CLASS"=>'<i class="glyphicon-coins"></i>',
													"TIME_DIF"=>$this->_ago($adv_payment_obj['last_create_date']),
													"MSG"=>'awaiting approval'
												 );	
						
						}
						
						// GET APPROVED CREATIVE COUNT - TODAYE
						
						$creative_obj = $this->do_creative->fetch_creative_by_approve('APPROVED_TODAY',$agency_id,$account_id);		
						
						if($creative_obj != FALSE AND isset($creative_obj['banner_count']) AND $creative_obj['banner_count'] > 0){
						
							$tot_count += $creative_obj['banner_count'];
						
							$result['creative approved today'] = array(
													"COUNT"=>$creative_obj['banner_count'],
													"URL"=>site_url('advertiser/creatives'),
													"CLASS"=>'<img src='.base_url().'template/metronic/assets/img/msg_adv.png>',     
													"TIME_DIF"=>$this->_ago($creative_obj['last_create_date']),
													"MSG"=>'' //  INDEX value will be taken as message
												 );	
						   
						}
						
						break;
						
			case 'TRAFFICKER';
			
						
						// GET UNAPPROVED PUBLISHER INVOICES
						
						$pub_payment_obj = $this->do_payments->fetch_unapproved_publisher_payment($agency_id,$account_id);
		
						
						
						if($pub_payment_obj != FALSE AND isset($pub_payment_obj['invoice_count']) AND $pub_payment_obj['invoice_count'] > 0){
						
							$tot_count += $pub_payment_obj['invoice_count'];
						
							$result['invoice'] = array(
													"COUNT"=>$pub_payment_obj['invoice_count'],
													"URL"=>site_url('publisher/payments'),
													"CLASS"=>'<i class="glyphicon-coins"></i>',
													"TIME_DIF"=>$this->_ago($pub_payment_obj['last_create_date']),
													"MSG"=>'awaiting approval'
												 );	
						
						}
						
						// GET APPROVED PUBLISHER INVOICES TODAY
						
						$date = date("Y-m-d");
						
						$pub_payment_obj = $this->do_payments->fetch_approved_publisher_payment($agency_id,$account_id,$date);
		
						
						if($pub_payment_obj != FALSE AND isset($pub_payment_obj['invoice_count']) AND $pub_payment_obj['invoice_count'] > 0){
						
							$tot_count += $pub_payment_obj['invoice_count'];
						
							$result['invoice'] = array(
													"COUNT"=>$pub_payment_obj['invoice_count'],
													"URL"=>site_url('publisher/payments'),
													"CLASS"=>'<span class="glyphicon-coins"></i>',
													"TIME_DIF"=>$this->_ago($pub_payment_obj['last_create_date']),
													"MSG"=>'awaiting approval'
												 );	
						
						}
						
						break;			
				
				}
	
		$final_result = array("TOTAL_COUNT"=>$tot_count,"LIST"=>$result);
		return $final_result;
	
	}	
	
	
	function get_today_notifications()
	{
		$admin_id = $this->session->userdata('sessaccadminid');
		
		$tot_count = 0;
		
		$result = array();
		
		/* ADVERTISERS */
		if(has_manager_mod_permissions('inventory'))
		{
			if(has_manager_mod_permissions('advertiser'))
			{
				$this->db->select('id,name,date_added');
				$this->db->from('aff_advertiser_details');
				//$this->db->where('admin_account_id',$admin_id);
				$this->db->where('DATE(date_added)',date('Y-m-d'));
				$query = $this->db->get();
				
				if($query->num_rows() > 0){
					$adv_count = $query->num_rows();
					$data = $query->result();
					$last_date = $data[0]->date_added; 
					
					$tot_count += $adv_count;
					
					$result['ADVERTISER'] = array(
												"COUNT"=>$adv_count,
												"URL"=>site_url('admin/advertiser'),
												"CLASS"=>'<img src='.base_url().'template/metronic/assets/img/msg_adv.png width="25px" height="25px" />',
												"TIME_DIF"=>$this->_ago($last_date)
											 );	
					
				}
			}
		
		
			/* PUBLISHERS */
			if(has_manager_mod_permissions('publisher'))
			{
				$this->db->select('id,name,date_added');
				$this->db->from('aff_publisher_details');
				$this->db->where('admin_account_id',$admin_id);
				$this->db->where('DATE(date_added)',date('Y-m-d'));
				$this->db->order_by('date_added','DESC');
				$query = $this->db->get();
				
				if($query->num_rows() > 0){
					$pub_count = $query->num_rows();
					$data = $query->result();
					$last_date = $data[0]->date_added; 
					$tot_count += $pub_count;
					$result['PUBLISHER'] = array(
												"COUNT"=>$pub_count,
												"URL"=>site_url('admin/publisher'),
												"CLASS"=>'<img src='.base_url().'template/metronic/images/pub.png width="25px" height="25px" />',
												"TIME_DIF"=>$this->_ago($last_date)
											 );	
				}
			}
		
		
		
		/* BANNERS */
			if(has_manager_mod_permissions('events'))
			{
				$this->db->select('oxb.bannerid,oxb.description,oxb.created_date');
				$this->db->from('rv_banners as oxb');
				$this->db->join('rv_campaigns as oxc','oxb.campaignid=oxc.campaignid');
				$this->db->join('rv_clients as oxcl','oxcl.clientid=oxc.clientid');
				/*$this->db->where('oxcl.admin_account_id',$admin_id);*/
				$this->db->where('DATE(oxb.created_date)',date('Y-m-d'));
				$this->db->order_by('oxb.created_date','DESC');
				$query = $this->db->get();
				
				if($query->num_rows() > 0){
					$banners_count = $query->num_rows();
					$data = $query->result();
					$last_date = $data[0]->created_date; 
					$tot_count += $banners_count;
					$result['BANNER'] = array(
												"COUNT"=>$banners_count,
												"URL"=>site_url('admin/events'),
												"CLASS"=>'<img src='.base_url().'template/metronic/images/bann_app.png width="25px" height="25px" />',
												"TIME_DIF"=>$this->_ago($last_date)
											 );	
				}
			}
		
		/* CAMPAIGNS */
			if(has_manager_mod_permissions('campaigns'))
			{
				$this->db->select('oxc.campaignid,oxc.campaignname,oxc.created_date');
				$this->db->from('rv_campaigns as oxc');
				$this->db->join('rv_clients as oxcl','oxcl.clientid=oxc.clientid');
				$this->db->where('oxcl.admin_account_id',$admin_id);
				$this->db->where('DATE(oxc.created_date)',date('Y-m-d'));
				$this->db->order_by('oxc.created_date','DESC');
				$query = $this->db->get();
				
				if($query->num_rows() > 0){
					$campaigns_count = $query->num_rows();
					$data = $query->result();
					$last_date = $data[0]->created_date; 
					$tot_count += $campaigns_count;
					$result['CAMPAIGN'] = array(
												"COUNT"=>$campaigns_count,
												"URL"=>site_url('admin/campaigns'),
												"CLASS"=>'<img src='.base_url().'template/metronic/images/campn.png width="25px" height="25px" />',
												"TIME_DIF"=>$this->_ago($last_date)
											 );	
				}
			}
		
		
		/* ZONES */
			if(has_manager_mod_permissions('zones'))
			{
				$this->db->select('oxz.zoneid,oxz.zonename,oxz.created_date');
				$this->db->from('rv_zones as oxz');
				$this->db->join('rv_affiliates as oxa','oxa.affiliateid=oxz.affiliateid');
				$this->db->where('oxa.admin_account_id',$admin_id);
				$this->db->where('DATE(oxz.created_date)',date('Y-m-d'));
				//$this->db->where_in('oxz.master_zone',array(-1,-2));
				$this->db->order_by('oxz.created_date','DESC');
				$query = $this->db->get();
				
				if($query->num_rows() > 0){
					$zones_count = $query->num_rows();
					$data = $query->result();
					$last_date = $data[0]->created_date; 
					$tot_count += $zones_count;
					$result['ZONE'] = array(
												"COUNT"=>$zones_count,
												"URL"=>site_url('admin/zones'),
												"CLASS"=>'<img src='.base_url().'template/metronic/images/zones_app.png width="25px" height="25px" />',
												"TIME_DIF"=>$this->_ago($last_date)
											 );	
				}
			}
		}
		
		$final_result = array("TOTAL_COUNT"=>$tot_count,"LIST"=>$result);
		
		return $final_result;
	
	}	
	
		
	
		function _ago($time)
		{
		   $periods = array("second", "minute", "hour", "day", "week", "month", "year", "decade");
		   $lengths = array("60","60","24","7","4.35","12","10");

		   $now = time();
		   $time = strtotime($time);
		   $difference     = $now - $time;
		   $tense         = "ago";
			for($j = 0; $difference >= $lengths[$j] && $j < count($lengths)-1; $j++) 
			{
			   $difference /= $lengths[$j];
				}

		   $difference = round($difference);

		   if($difference != 1) 
		   {
			   $periods[$j].= "s";
		   }
		   if($periods[$j]=='days' || $periods[$j]=='day')
			{
				//echo 2; 
				$d =  date("l",mktime(0, 0, 0, date("m"), date("d")-$difference, date("Y")));
				return "On ".$d; 
			}
			else
			{
					 
			 return  "$difference $periods[$j] ago ";
			 }

		 
		 
		}
	
}
