<?php
class Do_mobile_creative extends CI_Model
{
    /*
	 * 
	 * name: fetch_mobile_screen_sizes
	 * @param :
	 * @return : $result
	 * 
	 * Fetch mobile screen sizes for image
	 */
		
	function fetch_mobile_screen_sizes()
	{
		
		$key = 'campaign_list';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		$this->db->select('name, value, width, height');
		$query = $this->db->get(TAB_CONF_MOBILE_SCREEN_SIZE);	
		$result = $query->result_array();
		if($result)
		{
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
			return FALSE;
		}
	}
		
	function add($creative_data,$agency_id=FALSE)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_BANNERS,$creative_data);
			
			$insert_id	= $this->db->insert_id();	
			$this->memcached_library->get(FETCH_MODAL_CREATIVES,'1');		
			$this->memcached_library->set(FETCH_CREATIVES,'1');
			$this->memcached_library->set(FETCH_EXPAND_PARENT_CRE,'1');
			$this->memcached_library->set(FETCH_EXPAND_CHILD_CRE,'1');
			
			// Process of auto link adblocks
			if($agency_id!=FALSE)
			{
				if($creative_data['dj_admarket_status']!='1')
				{
					$this->do_auto_link->link_adblocks($insert_id,$agency_id);
				}
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $insert_id;
			}
		}
		else
			return FALSE;
	}
	
	
	/*
	 * 
	 * name: add_child
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Add the child creative into the database
	 */
	function add_child($creative_data)
	{  #print_r($creative_data);exit;
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_BAN_DEPEND,$creative_data);
			#echo $this->db->last_query();exit;
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: edit_web
	 * @param :$creative_data,$creative_id,$blob_data
	 * @return : TRUE (or) FALSE
	 * 
	 * Edit the WEB creative
	 */
	function edit_mobile($creative_data,$creative_id=false,$agency_id=FALSE)
	{
		if($creative_data && $creative_id)
		{
			$this->db->trans_start();

			/*Update in ox_banners */
			$this->db->where('bannerid',$creative_id);
			$this->db->update(TAB_BANNERS,$creative_data);
			$this->memcached_library->set(FETCH_CREATIVESs,'1');
			$this->memcached_library->set(FETCH_MODAL_CREATIVES,'1');
			$this->memcached_library->set(FETCH_EXPAND_PARENT_CRE,'1');
			$this->memcached_library->set(FETCH_EXPAND_CHILD_CRE,'1');
			$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$creative_id,'1');	
			// Process of auto link adblocks
			if($agency_id!=FALSE)
			{
				if($creative_data['dj_admarket_status']!='1')
				{
					$this->do_auto_link->link_adblocks($creative_id,$agency_id);
				}
			}
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	/*
	 * 
	 * name: edit_expand
	 * @param :$creative_data,$creative_id
	 * @return : TRUE (or) FALSE
	 * 
	 * Edit the EXPAND creative
	 */
	function edit_child_mobile($creative_data,$where=false)
	{
		if($creative_data && $where)
		{
			$this->db->trans_start();

			/*Update in ox_banners */
			$this->db->where($where);
			$this->db->update(TAB_BAN_DEPEND,$creative_data);
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	
	function fetch_creative($creative_id=false)
	 {
	 	if($creative_id)
		{
			// For getting parent banner
			$this->db->select('oxb.contenttype,oxb.bannerid,oxb.campaignid,oxb.description,oxb.filename,oxb.storagetype,oxb.url,oxb.imageurl,oxb.bannertext,oxb.htmltemplate,oxb.dj_master_banner');
			$this->db->from(TAB_BANNERS .'as oxb');
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$this->db->order_by('dj_added_date ');
			$query = $this->db->get();	
			$result = $query->result_array();

			if($result)
				// For getting child banners
				$this->db->select('file_path,width,height,content_type');
				$this->db->where('banner_id', $creative_id);
				$query_child = $this->db->get(TAB_BAN_DEPEND);
				$result_child = $query_child->result_array();

			if($result_child)
				$data = array("0"=>$result, "1"=>$result_child);

			return $data;		
		}
		else
			return FALSE;
	}
	
	function fetch_parent_creative($creative_id=false)
	 {
		 
		$key = 'fetch_parent_creative_'.$creative_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_EXPAND_PARENT_CRE);
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
	 	if($creative_id)
		{
			$this->db->select('*');
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$this->db->order_by('dj_added_date ');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			if($result)
			{
				
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set(FETCH_EXPAND_PARENT_CRE,'2');
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
		else{
		return $result;
		}
			
			}
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
}
	function fetch_child_creative($creative_id=false)
	{
		
		
		$key = 'fetch_child_creative_'.$creative_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_EXPAND_CHILD_CRE);
		if($ret && $mem_cache=='enable'  && $check_db_changes!='1' )
		{
			return $ret;
		}
		else{
		
	 	if($creative_id)
		{	
			$this->db->select('*');
			$this->db->where('banner_id', $creative_id);
			$this->db->order_by('image_id ');
			$query 	= 	$this->db->get(TAB_BAN_DEPEND);
			$result = 	$query->result_array();
			if($result)
			{
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);
			$this->memcached_library->set(FETCH_EXPAND_CHILD_CRE,'2');	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
		}
			else
				return FALSE;
		}
		else
			return FALSE;
	}
}

}
?>
