<?php

class Do_mobile_auto_link extends CI_Model

{

	

	public $agency_id = '';

	

	/*

	 * 

	 * name: fetch_mobile_adblock

	 * @param :

	 * @return : $result

	 * 

	 * Lists a mobile ad block of an advertiser

	 */

	 

	 function fetch_mobile_adblock($zone_id=false)

	 {

		if($zone_id)

		{

			$this->db->select('width,height,delivery,dj_zone_type');		

			$this->db->where('zoneid ',$zone_id);

			$this->db->where('dj_is_deleted ','0');

			$query = $this->db->get(TAB_ZONES);		

			$result = $query->result_array();

			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

		

	}

	

	/*

	 * 

	 * name: fetch_creative

	 * @param :

	 * @return : $result

	 * 

	 * Get Creatives

	 */

	 

	 function fetch_creative($creative_id=false)

	 {

		if($creative_id)

		{

			$this->db->select('dj_banner_type');		

			$this->db->where('bannerid ',$creative_id);

			$this->db->where('dj_is_deleted ','0');

			$query = $this->db->get(TAB_BANNERS);	

			$result = $query->result_array();

			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

		

	}

	

	/*

	 * 

	 * name:mobile_link_ads_get

	 * @param : zone_id

	 * @return : NULL

	 * 

	 * Link zone to creative

	 */

	

	function mobile_link_ads($zone_id,$agency_id=FALSE)

	{

		if($zone_id)

		{

			
                 
			//Sets the agency_id

			if($agency_id!=FALSE)
			{
			 $this->agency_id = $agency_id;
		    }

			

			// Unlink the previously linked creatives for zone

			$this->unlink_ads($zone_id);

			

			$zone_details = $this->fetch_mobile_adblock($zone_id);

			$zone = $zone_details[0];

			$zone_type = $zone['dj_zone_type'];

			switch($zone_type)

			{

				case MOBILE_AD_BLOCK_IMAGE:

								$creatives = $this->fetch_image_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);

									}

								}

								break;

				case MOBILE_AD_BLOCK_INTERSTITIAL:

								$creatives = $this->fetch_interstitial_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);

									}

								}

								break;

				case MOBILE_AD_BLOCK_EXPAND:

								$creatives = $this->fetch_expand_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);	

									}

								}

								break;

				case MOBILE_AD_BLOCK_REVEAL:

								$creatives = $this->fetch_reveal_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);

									}

								}

								break;

				case MOBILE_AD_BLOCK_FLEX:

								$creatives = $this->fetch_flex_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);

									}

								}

								break;

				case MOBILE_AD_BLOCK_ADHENSION:

								$creatives = $this->fetch_adhension_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);

									}

								}

								break;

				case MOBILE_AD_BLOCK_FLIMSTRIP:

								$creatives = $this->fetch_filmstrip_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);

									}

								}

								break;

				case MOBILE_AD_BLOCK_SLIDER:

								$creatives = $this->fetch_slider_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);	

									}

								}

								break;

				case MOBILE_AD_BLOCK_PULL:

								$creatives = $this->fetch_pull_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);

									}

								}

								break;

				case MOBILE_AD_BLOCK_TEXT:

								$creatives = $this->fetch_text_creatives();

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);	

									}

								}

								break;			

			}

		}

	}

	

	/*

	 * 

	 * name: fetch_image_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile image creative

	 */

	 function fetch_image_creatives()

	 {

		$this->db->select('oxb.bannerid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_IMAGE_CREATIVE);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_interstitial_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile interstitial creative

	 */

	 function fetch_interstitial_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_INTERSTITAL);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_expand_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile expand creative

	 */

	 function fetch_expand_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_EXPAND);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');

		$result = $query->result_array(TAB_BANNERS.' as oxb');

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_reveal_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile reveal creative

	 */

	 function fetch_reveal_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_REVEAL);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_flex_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile flex creative

	 */

	 function fetch_flex_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_FLEX);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_adhension_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile adhension creative

	 */

	 function fetch_adhension_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

			$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_ADHESION);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_filmstrip_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile filmstrip creative

	 */

	 function fetch_filmstrip_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

			$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_FILMSTRIP);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_slider_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile slider creative

	 */

	 function fetch_slider_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_SLIDER);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_pull_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile pull creative

	 */

	 function fetch_pull_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_PULL);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_text_creative

	 * @param :

	 * @return : $result

	 * 

	 * Get a text creative

	 */

	 function fetch_text_creatives()

	 {

		$this->db->select('oxb.bannerid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'txt');

		$this->db->where('oxb.dj_banner_type', MOBILE_TEXT_CREATIVE);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	function add_link_ads($link_assoc_data)

	{

		if($link_assoc_data)

		{

			$this->db->trans_start();

			/*Insert in ox_banners */

			$this->db->insert(TAB_AD_ZONE_ASSOC,$link_assoc_data);

			

			$insert_id	= $this->db->insert_id();



			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)

			{

				$this->db->trans_rollback();

				return FALSE;

			}

			else

			{

				$this->db->trans_commit();

				return $insert_id;

			}

		}

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: unlink_ads

	 * @param : zone_id

	 * @return : $result

	 * 

	 * Delete the zone assoc

	 */

	 function unlink_ads($zone_id=false)

	 {

		if($zone_id)

		{

			$this->db->trans_start();

			

			$this->db->where('zone_id',$zone_id);

			$this->db->delete(TAB_AD_ZONE_ASSOC);



			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;

		

	}

	

	/*

	 * 

	 * name: unlink_blocks

	 * @param : creative_id

	 * @return : $result

	 * 

	 * Delete the zone assoc

	 */

	 function unlink_mobile_blocks($creative_id=false)

	 {

		if($creative_id)

		{

			$this->db->trans_start();

			

			$this->db->where('ad_id',$creative_id);

			$this->db->delete(TAB_AD_ZONE_ASSOC);



			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;

		

	}

	

	/*

	 * 

	 * name:link_adblocks

	 * @param : creative_id

	 * @return : NULL

	 * 

	 * Link creative to blocks

	 */

	

	function link_mobile_adblocks($creative_id=false,$agency_id=FALSE)

	{

		if($creative_id)

		{

			

			$this->agency_id= $agency_id;

			

			// Unlink the previously linked creatives for zone

			$this->unlink_mobile_blocks($creative_id);

			

			$creative_details = $this->fetch_creative($creative_id);

			$creative = $creative_details[0];

			//echo "<pre>"; print_r($zone); exit;

			$banner_type = $creative['dj_banner_type'];

			switch($banner_type)

			{

				case MOBILE_IMAGE_CREATIVE:

								$adblocks = $this->fetch_image_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_TEXT_CREATIVE:

								$adblocks = $this->fetch_text_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_MRAID_CREATIVE_INTERSTITAL:

								$adblocks = $this->fetch_interstitial_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_MRAID_CREATIVE_EXPAND:

								$adblocks = $this->fetch_expand_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_MRAID_CREATIVE_REVEAL:

								$adblocks = $this->fetch_reveal_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_RS_CREATIVE_FLEX:

								$adblocks = $this->fetch_flex_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_RS_CREATIVE_ADHESION:

								$adblocks = $this->fetch_adhension_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_RS_CREATIVE_FILMSTRIP:

								$adblocks = $this->fetch_filmstrip_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_RS_CREATIVE_PULL:

								$adblocks = $this->fetch_pull_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				case MOBILE_RS_CREATIVE_SLIDER:

								$adblocks = $this->fetch_slider_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										

									}

								}

								break;

				

			}

			//$this->response($zone);

		}

	}

	

	/*

	 * 

	 * name: fetch_text_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a text blocks

	 */

	

	function fetch_text_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_TEXT);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_image_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a image blocks

	 */

	

	function fetch_image_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_IMAGE);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_interstitial_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a interstitial blocks

	 */

	

	function fetch_interstitial_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_INTERSTITIAL);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	 

	/*

	 * 

	 * name: fetch_expand_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a expand blocks

	 */

	

	function fetch_expand_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_EXPAND);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_reveal_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a reveal blocks

	 */

	

	function fetch_reveal_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_REVEAL);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_flex_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a flex blocks

	 */

	

	function fetch_flex_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLEX);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_adhension_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a adhension blocks

	 */

	

	function fetch_adhension_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_ADHENSION);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_adhension_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a adhension blocks

	 */

	

	function fetch_filmstrip_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLIMSTRIP);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_slider_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a slider blocks

	 */

	

	function fetch_slider_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_SLIDER);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_pull_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a pull blocks

	 */

	

	function fetch_pull_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_PULL);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

}

