<?php
Class Do_mobile_adblock extends CI_Model
{
	var $zone_type ='3';
	
	/*  ox_zones
	 * ---------------------
	 *  zonename
	 * 	width
	 *  Height
	 *  oac_category_id
	 *  dj_added_date
	 * 	is_deleted
	 * */
	 
	 
	function add($add_web_adblockObj){
		
		if($this->db->insert(TAB_ZONES,$add_web_adblockObj)){
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 
	 function addAssoc($add_web_adblockObj){
		
		if($this->db->insert(TAB_SITE_ZONE_ASSOC,$add_web_adblockObj)){
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	 
	 function list_sites($account_id=FALSE)
	 {
	 	$key = 'list_sites_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		 
			if($account_id != FALSE){
			$this->db->where('account_id',$account_id);
			}
		
			$query = $this->db->get(TAB_PUB_SITES);
		
			$result = $query->result_array();
		
			if($result)
			{			
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			} 
	 	}
	}
	
	function list_zonesizes()
	{
		 
		$key = 'list_zonesizes_mobile_adblock';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			$this->db->where('status','1');
			$query = $this->db->get(TAB_CONF_BANNER_SIZE);
		
			$result = $query->result_array();
		
			if($result)
			{			
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
			}
			else
			{
				return FALSE;
			} 
		}
	}
	
	/* Fetch Affiliate id */
	 function fetch_affiliateid($account_id=FALSE)
	 { 
		 $key = 'fetch_affiliateid_mobile_adblock_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		if($account_id != FALSE){
		$this->db->where('account_id',$account_id);
		}
		
		$this->db->select('affiliateid');		
		
		$query = $this->db->get(TAB_AFFILIATE);
		
		$result = $query->result_array();
		
			if($result)
			{	
			
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result[0]['affiliateid'];
				}		
			
			}
			else
			{
				return FALSE;
			} 
		 }
	}
	 
	 function list_category()
	 {
		 
		$key = 'list_category_mobile_adblock';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			$query = $this->db->get(TAB_SITE_CATEGORIES);
	
			$result = $query->result_array();
		
			if($result)
			{			
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			} 
		 }
	}
	 
	 /**
       * Retreives the Zones and Sites
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
	 
	 function fetch($account_id=FALSE,$zone_id=FALSE){
		$key = 'fetch_mobile_adblock_'.$account_id.'_'.$zone_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$SQL = "SELECT djs.site_name as site_name,djs.site_url as site_url,djs.site_id as site_id,oxz.*,
					CASE
						WHEN `dj_mobile_ad_type` = 'mraid'  THEN 'MRAID'
						WHEN `dj_mobile_ad_type` = 'rising' THEN 'Rising Stars'
						WHEN `dj_mobile_ad_type` = 'basic'  THEN 'Basic'
					END as ad_type,
					CASE
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_IMAGE."'  		THEN 'Image'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_TEXT."' 		THEN 'Text'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_INTERSTITIAL."'THEN 'Interstitial'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_EXPAND."'  	THEN 'Expand'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_REVEAL."'  	THEN 'Reveal'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_FLEX."'  		THEN 'Flex'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_ADHENSION."'  	THEN 'Adhesion'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_FLIMSTRIP."'  	THEN 'Filmstrip'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_SLIDER."'  	THEN 'Slider'
						WHEN `dj_zone_type` = '".MOBILE_AD_BLOCK_PULL."'  		THEN 'Pull'
					END as zone_type
					FROM 
						".TAB_ZONES." as oxz 
					JOIN 
						".TAB_SITE_ZONE_ASSOC." as djszass ON djszass.zone_id=oxz.zoneid
					JOIN 
						".TAB_PUB_SITES." as djs ON djs.site_id=djszass.site_id
					WHERE 
						 dj_is_deleted =0 AND dj_mobile_ad_type IN ('mraid','rising','basic')";
	
		 	if($account_id != FALSE){
				$SQL .= " AND account_id = {$account_id}";
			}
		
			if($zone_id !=FALSE)
			{
				$SQL .= " AND zoneid = {$zone_id}";
			}
		
			$SQL .= " ORDER BY dj_added_date" ;
		
			$query = $this->db->query($SQL);
		
			$result = $query->result_array();
						
			if($result)
			{			
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			}
		
		}
	}
	
	 /**
       * Updates the Zones and Sites
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
	
	function update($mobile_adblock_info,$agency_id){
		
		if($mobile_adblock_info['zone_type'] ==='M_A_TXT')
		{
			$mobile_adblock_info['width'] =0;
			$mobile_adblock_info['height'] =0;	
		}
		
		if($mobile_adblock_info['zone_type'] == "M_A_SLI" || $mobile_adblock_info['zone_type']== "M_A_PULL")
		{
			$ad_position = $mobile_adblock_info['ad_position'];
		}
		else
		{
			$ad_position = '';
		}
		
		
		//delivery number
		$delivery = delivery_value($mobile_adblock_info['zone_type']);
		
		$mob_adblock_info  =	array(	 "zonename"  =>	clean_data($mobile_adblock_info['block_name']),
										 "zonetype"	=>	$this->zone_type,
										 "delivery"	=>	$delivery,
										 "dj_zone_type"	=>	clean_data($mobile_adblock_info['zone_type']),
										 "width" 	=>	clean_data($mobile_adblock_info['width']),
										 "height"	=>  clean_data($mobile_adblock_info['height']),
										 "dj_floor_price"		=>	clean_data($mobile_adblock_info['floor_price']),
										 "dj_passback_tag" =>stripslashes($mobile_adblock_info['passback_tag']),
										 "dj_mobile_ad_type"=>clean_data($mobile_adblock_info['mobile_ad_type']),
										 "dj_ad_position"=>$ad_position
							);
		
		
			$this->db->trans_begin();  
			
			$this->db->where('zoneid',$mobile_adblock_info['zone_id']);
			$this->db->update(TAB_ZONES,$mob_adblock_info);
			
			
			
			//Auto Linking of zones
			$this->do_mobile_auto_link->mobile_link_ads($mobile_adblock_info['zone_id'],$agency_id);
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $mobile_adblock_info['zone_id'];
			}
	}
	
	function delete($id){
		 if(is_array($id)){
			 
			$zoneObj = array();
			foreach($id as $val){
				$zoneObj[]= array('dj_is_deleted'=>'1','zoneid'=>$val);
			}
			
			$this->db->update_batch(TAB_ZONES,$zoneObj,'zoneid');
		 }
		 else if(!empty($id)){
			$this->db->where('zoneid',$id); 
			$this->db->update(TAB_ZONES,array('dj_is_deleted'=>'1'));
		 }
	 }
	
}

