<?php
class Do_manager extends CI_Model
{
	/*  djax_network_managers
	* ---------------------
	*  agency_id
		network_account_id
		manager_account_id
		role
		default_manager
		manager_status
		is_deleted
	* */
	 
	function fetch($account_id=FALSE)
	{	
		/*$this->db->select('dnm.*,oxa.name,oxa.email,oxa.active,oxa.account_id');	
		$this->db->from(TAB_AGENCY.' as oxa');	
		$this->db->join(TAB_NWK_MANAGERS.'as dnm','dnm.manager_account_id=oxa.account_id');
		$this->db->join(TAB_ACCOUNTS.' as oxac','oxac.account_id=oxa.account_id');
		$this->db->where('oxac.account_type','MANAGER');		
		$this->db->where('dnm.is_deleted','0');		
		$this->db->order_by('oxa.agencyid');	
		*/
		
			
		$SQL = "SELECT `dnm`.*, 
						`oxa`.`name`, 
						`oxa`.`email`, 
						`oxa`.`active`,	
						`oxa`.`account_id`,
						`oxa`.`agencyid`,
						IFNULL(SUM(impressions),0) as IMP,
						IFNULL(SUM(clicks),0) as CLKS, 
						IFNULL(SUM(conversions),0) as CON, 
						FORMAT(IFNULL(SUM(network_revenue),0),4) as NET_REV, FORMAT(IFNULL(SUM(admin_revenue),0),4) as ADM_SHARE
				FROM (`ox_agency` as oxa)
				JOIN `djax_network_managers` as dnm ON `dnm`.`manager_account_id`=`oxa`.`account_id`
				JOIN `ox_accounts` as oxac ON `oxac`.`account_id`=`oxa`.`account_id`
				LEFT JOIN `djax_network_stats` as dns ON `dns`.`agency_id` = `oxa`.`agencyid`
				WHERE `oxac`.`account_type` = 'MANAGER'";
		
		if($account_id!=FALSE)
		{
			$SQL .= " AND oxa.account_id={$account_id} ";
		}			
				
		$SQL .=" GROUP BY oxa.agencyid ORDER BY oxa.account_id DESC";
			
		$query = $this->db->query($SQL);
		
		//echo $this->db->last_query();
		//exit;	
		
		$result = $query->result_array();
			
		if($result)
		{	
			$i=0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}			
			return $result;
		}
		else
		{
			return FALSE;
		}		
	}
	
	
	public function fetch_manager_details($account_id)
	{
		
	$key = 'fetch_manager_details_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		
		
		
	   $this->db->select('name');
	   $this->db->where('account_id',$account_id);
	   $query=$this->db->get(TAB_AGENCY);
	   $result=$query->result_array();
			if($result){
				if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$result,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else
					{
						return $result;
					}
				}
			}
		}
	 
	function add_manager($data=FALSE)
	{   
		$account_data = array(
							"account_type" 	=> 	'MANAGER',
							"account_name" 	=> 	$data['name']
						);
						
		if($this->db->insert(TAB_ACCOUNTS,$account_data))
		{
			$account_id	=	$this->db->insert_id();
			
			$user_data	=	array(
								"contact_name" 			=> 	$data['name'],
								"email_address" 		=> 	$data['email'],
								"username" 				=> 	$data['email'],
								"password" 				=> 	$data['password'],
								"default_account_id" 	=> 	$account_id,
								"active" 				=> 	1,
								"date_created"			=>	date('Y-m-d H:i:s')
							);
							
			if($this->db->insert(TAB_USERS,$user_data))
			{
				$user_id		=	$this->db->insert_id();
				/*-------------------------------------------
				INSERT dJAX_USER_APIKEY TABLE
				---------------------------------------------*/
				$api_key = generate_user_apikey($user_id);
				$key_data=array(   
								 'user_id'=> $user_id,
								 'api_key'=> $api_key
							   );
				
				$this->db->insert(TAB_USER_APIKEY,$key_data);
				
				$user_assoc_data=	array(
										"account_id"	=>	$account_id,
										"user_id"		=>	$user_id,
										"linked"		=>	date('Y-m-d H:i:s')
										);
										
				$this->db->insert(TAB_ACC_USER_ASSOC,$user_assoc_data);
			}
			
			$agency_data	=	array(
										"name" 			=> 	$data['name'],
										"email" 		=> 	$data['email'],
										"account_id" 	=> 	$account_id,
										"active" 		=> 	1,
										"updated"		=>	date('Y-m-d H:i:s')
									);
							
			if($this->db->insert(TAB_AGENCY,$agency_data))
			{
				$agency_id		=	$this->db->insert_id();
				
	      /*----------------------------------------------
				CREATE ACCOUNT  FOR ADVERTISER
			---------------------------------------------*/
		
			$acc_data	=	array(
							"account_type"	=>	'ADVERTISER',
							"account_name"	=>	'Default'.''.$data['name']
							);
							
			$this->db->insert(TAB_ACCOUNTS,$acc_data);
		
			$advertiser_account_id	=	$this->db->insert_id();		
			
			/*-------------------------------------------
			INSERT OX USERS TABLE
			---------------------------------------------*/
		
			$oxUserDet	=	array(
							"contact_name"			=>	'Default'.''.$data['name'],
							"email_address"			=>	'Default'.''.$data['email'],
							"username"				=>	'Default'.''.$data['email'],
							"password" 				=> 	$data['password'],
							"default_account_id"	=>	$advertiser_account_id	,
							"date_created"			=>	date('Y-m-d H:i:s')
							);
							
			$this->db->insert(TAB_USERS,$oxUserDet);
			
			$ox_user_id	=	$this->db->insert_id();
			
			/*-------------------------------------------
				INSERT dJAX_USER_APIKEY TABLE
				---------------------------------------------*/
				$api_key = generate_user_apikey($user_id);
				$key_data=array(   
								 'user_id'=> $ox_user_id,
								 'api_key'=> $api_key
							   );
				
				$this->db->insert(TAB_USER_APIKEY,$key_data);
				
			/*-------------------------------------------
				INSERT USER ACCOUNT ASSOCIATION
			---------------------------------------------*/
			
			$ox_acc_user_assoc	=	array(
								"account_id"	=>	$advertiser_account_id,
								"user_id"		=>	$ox_user_id,
								"linked"		=>	date('Y-m-d H:i:s')
								);
			$this->db->insert(TAB_ACC_USER_ASSOC,$ox_acc_user_assoc);		
			
			
			/*-------------------------------------------
					INSERT USER PERMISSION
			---------------------------------------------*/
				
			$perm_array = array('1','2','4','10','11','13','15','19','31','51','52','54','55','56','57','58','61');
			$ins_per_arr = array();
			
			if(!empty($perm_array))
			{
				foreach($perm_array as $perm_id)
				{
					$ins_per_arr[] = array('account_id'		=>	$advertiser_account_id,
											'user_id'		=>	$ox_user_id,
											'permission_id'	=>	$perm_id
									 );	
				}
				$this->db->insert_batch(TAB_ACC_USER_PER_ASSOC,$ins_per_arr);	
			}
				
			
			/*------------------------------------------*/
			
			
			/*-------------------------------------------
				INSERT CLIENTS TABLE
			---------------------------------------------*/
			
			$clientInfo	=	array(
								"email"					=>	$data['email'],
								"contact"				=>	'Default  '.''.$data['name'],
								"clientname"			=>	'Default Advertiser',
								"agencyid"				=>	$agency_id,
								"account_id"			=>	$advertiser_account_id,
								"dj_is_default"         =>  1,
		 						"dj_first_name" 		=>  'Default'.''.$data['name'],
								"dj_added_date" 		=> 	date('Y-m-d H:i:s'),
								"dj_approved_date"  	=> 	date('Y-m-d H:i:s'),
								"dj_approval_status"  	=> 	1
								);
			
			$this->db->insert(TAB_CLIENTS,$clientInfo);	
			

	
			if(get_session('account_id'))
				{
					$network_id	=	get_session('account_id');
				}
				else
				{
					$network_id	=	0;
				}
				
				$network_data	=	array(
										"agency_id" 			=> 	$agency_id,
										"network_account_id" 	=> 	$network_id,
										"manager_account_id" 	=> 	$account_id,
										//"role"					=>	$data['role'],
										"default_manager"		=>	0,
										"manager_status" 		=> 	1,
										"is_deleted" 			=> 	0,
										"manager_share"			=>  $data['manager_share']
									);
							
				if($this->db->insert(TAB_NWK_MANAGERS,$network_data))
				{
					$user_role_assoc = array(
										"user_id"	=>	$user_id,
										"role_id"	=>	$this->config->item('default_manager_role'),
										"is_default"=>1,
										"user_status"=>1
									);
				
					$this->db->insert(TAB_USER_ROLE_ASSOC,$user_role_assoc);
					
					/*********************************INSERT A ADVERTISER FOR DEMO PURPOSES******************************/
			
			/*----------------------------------------------
				CREATE ACCOUNT  FOR ADVERTISER
			---------------------------------------------*/
		
			$acc_data	=	array(
							"account_type"	=>	'ADVERTISER',
							"account_name"	=>	'adv_'.''.$data['name']
							);
							
			$this->db->insert(TAB_ACCOUNTS,$acc_data);
		
			$advertiser_account_id	=	$this->db->insert_id();		
			
			
			/*-------------------------------------------
			INSERT OX USERS TABLE
			---------------------------------------------*/
		
			$oxUserDet	=	array(
							"contact_name"			=>	'adv_'.$data['name'],
							"email_address"			=>	'adv_'.$data['email'],
							"username"				=>	'adv_'.$data['email'],
							"password" 				=> 	$data['password'],
							"default_account_id"	=>	$advertiser_account_id	,
							"date_created"			=>	date('Y-m-d H:i:s')
							);
							
			$this->db->insert(TAB_USERS,$oxUserDet);
			
			$ox_user_id	=	$this->db->insert_id();
			
			/*-------------------------------------------
				INSERT dJAX_USER_APIKEY TABLE
				---------------------------------------------*/
				$api_key = generate_user_apikey($user_id);
				$key_data=array(   
								 'user_id'=> $ox_user_id,
								 'api_key'=> $api_key
							   );
				
				$this->db->insert(TAB_USER_APIKEY,$key_data);
				
			/*-------------------------------------------
				INSERT USER ACCOUNT ASSOCIATION
			---------------------------------------------*/
			
			$ox_acc_user_assoc	=	array(
								"account_id"	=>	$advertiser_account_id,
								"user_id"		=>	$ox_user_id,
								"linked"		=>	date('Y-m-d H:i:s')
								);
			$this->db->insert(TAB_ACC_USER_ASSOC,$ox_acc_user_assoc);		
			
			
			/*-------------------------------------------
					INSERT USER PERMISSION
			---------------------------------------------*/
				
			$perm_array = array('1','2','4','10','11','13','15','19','31','51','52','54','55','56','57','58','61');
			$ins_per_arr = array();
			
			if(!empty($perm_array))
			{
				foreach($perm_array as $perm_id)
				{
					$ins_per_arr[] = array('account_id'		=>	$advertiser_account_id,
											'user_id'		=>	$ox_user_id,
											'permission_id'	=>	$perm_id
									 );	
				}
				$this->db->insert_batch(TAB_ACC_USER_PER_ASSOC,$ins_per_arr);	
			}
				
			
			/*------------------------------------------*/
			
			
			/*-------------------------------------------
				INSERT CLIENTS TABLE
			---------------------------------------------*/
			
			$clientInfo	=	array(
								"email"					=>	'adv_'.$data['email'],
								"contact"				=>	'adv_'.$data['name'],
								"clientname"			=>	'adv_'.$data['name'],
								"agencyid"				=>	$agency_id,
								"account_id"			=>	$advertiser_account_id,
								"dj_is_default"         =>  0,
		 						"dj_first_name" 		=>  'adv_'.$data['name'],
								"dj_added_date" 		=> 	date('Y-m-d H:i:s'),
								"dj_approved_date"  	=> 	date('Y-m-d H:i:s'),
								"dj_approval_status"  	=> 	1
								);
			
			$this->db->insert(TAB_CLIENTS,$clientInfo);	
			
			/***************************ADD A DEMO PUBULISHER*********************************/
			    $cur_date = date("Y-m-d H:i:s");
			
		   /*----------------------------------------------
				CREATE ACCOUNT  FOR PUBLISHER
			 ---------------------------------------------*/
		
			$acc_data	=	array(
							"account_type"	=>	'TRAFFICKER',
							"account_name"	=>	'pub_'.$data['name']
							);
							
			$this->db->insert(TAB_ACCOUNTS,$acc_data);
		
			$account_id	=	$this->db->insert_id();		
			
			/*-------------------------------------------
				INSERT OX USERS TABLE
			---------------------------------------------*/
		
			$oxUserDet	=	array(
							"contact_name"			=>	'pub_'.$data['name'],
							"email_address"			=>	'pub_'.$data['email'],
							"username"				=>	'pub_'.$data['email'],
							"password"				=>	$data['password'],
							"default_account_id"	=>	$account_id	,
							"date_created"			=>	$cur_date
							);
							
			$this->db->insert(TAB_USERS,$oxUserDet);
			
			$ox_user_id	=	$this->db->insert_id();
			
			/*-------------------------------------------
			INSERT dJAX_USER_APIKEY TABLE
			---------------------------------------------*/
			//GET FROM UTILITY HELPER FILE
			$api_string = generate_user_apikey($ox_user_id);
			$key_data=array(   
			                 'user_id'=> $ox_user_id,
							 'api_key'=> $api_string
			               );
			
			$this->db->insert(TAB_USER_APIKEY,$key_data);
			
			
			/*-------------------------------------------
				INSERT USER ACCOUNT ASSOCIATION
			---------------------------------------------*/
			
			$ox_acc_user_assoc	=	array(
								"account_id"	=>	$account_id,
								"user_id"		=>	$ox_user_id,
								"linked"		=>	$cur_date
								);
			$this->db->insert(TAB_ACC_USER_ASSOC,$ox_acc_user_assoc);		
			
			
			/*-------------------------------------------
				INSERT USER PERMISSION
			---------------------------------------------*/
			
			$perm_array = array('1','2','4','10','11','13','15','19','31','51','52','54','55','56','57','58','61');
			$ins_per_arr = array();
			
			
			if(!empty($perm_array))
			{
				foreach($perm_array as $perm_id)
				{
					$ins_per_arr[] = array('account_id'		=>	$account_id,
											'user_id'		=>	$ox_user_id,
											'permission_id'	=>	$perm_id
									 );	
				}
				$this->db->insert_batch(TAB_ACC_USER_PER_ASSOC,$ins_per_arr);	
			}
			
			/*------------------------------------------*/
			
			/*---------------------------------------------
				INSERT SITE DETAILS
			----------------------------------------------*/
			
			$siteObj = array(
					"account_id" 	=> $account_id,
					"site_name" 	=> $data['name'],
					"site_url" 		=> 'http://www.yourdomain.com',
					"comments" 		=> 'CHANGE TO YOUR DOMAIN',
					"is_default" 	=> 1,
					"added_date" 	=> date("Y-m-d H:i:s")
				);
			$this->db->insert(TAB_PUB_SITES,$siteObj);
			
			/*-------------------------------------------
				INSERT AFFILIATES TABLE
			---------------------------------------------*/
			
			$affiliateInfo	=	array(
								"email"					=>	'pub_'.$data['email'],
								"contact"				=>	'pub_'.$data['name'],
								"name"					=>	'pub_'.$data['name'],
								"agencyid"				=>	$agency_id,
								"account_id"			=>	$account_id,
								"website"				=>	'http://www.yourdomain.com',	
								"dj_first_name" 		=>  'pub_'.$data['name'],
								"dj_last_name"  		=>  'pub_'.$data['name'],
								"dj_added_date" 		=> 	$cur_date,
								"dj_approved_date"  	=> 	$cur_date,
								"dj_approval_status"  	=> 	1
								);
			
			$this->db->insert(TAB_AFFILIATE,$affiliateInfo);	
			
			/**********************************************REMOVE IN PRODUCTION****************************************/
							
					
					$this->memcached_library->set(ADMIN_FETCH_USERS,'1');
								
					return $network_data;
				}
				else
				{
					return FALSE;
				}
			}
			else
			{
				return FALSE;
			}		
		}
		else
		{
			return FALSE;
		}		
	} 
	 
	function update($account_id=FALSE,$data=FALSE)
	{
		/* Update ox_accounts Table */
		$where_acc		=	array("account_id"	=>	$account_id);
		$account_data 	= 	array(
								"account_name" 	=> 	$data['name']
							);
		$this->db->where($where_acc);
		$this->db->update(TAB_ACCOUNTS,$account_data);
		
		/* Update ox_users Table */
		$where_user		=	array("default_account_id"	=>	$account_id);
		$user_data		=	array(
								"contact_name" 	=> 	$data['name'],
								"email_address" => 	$data['email'],
								"username" 		=> 	$data['email']
							);
		$this->db->where($where_user);
		$this->db->update(TAB_USERS,$user_data);
		
		/* Update ox_agency Table */
		$agency_data	=	array(
								"name" 			=> 	$data['name'],
								"email" 		=> 	$data['email']
								);
		$this->db->where($where_acc);
		if($this->db->update(TAB_AGENCY,$agency_data))
		{
			/* Update djax_network_managers Table */
			$where_net		=	array("manager_account_id" 	=> 	$account_id);
			$network_data	=	array(
								"manager_share"			=>	$data['manager_share']
								);
			$this->db->where($where_net);
		
			if($this->db->update(TAB_NWK_MANAGERS,$network_data))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			} 
		}
		else
		{
			return FALSE;
		}
			
		
		
	}
	 
	function remove($account_id=FALSE)
	{
		if($account_id!=FALSE)
		{
			$where	=	array("manager_account_id" 	=> 	$account_id);
			$data	=	array("is_deleted"	=>	1);
			$this->db->where($where);
			if($this->db->update(TAB_NWK_MANAGERS,$data))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}			
		}
		else
		{
			return FALSE;
		}		
	}
	 
	function block($account_id=FALSE)
	{
		if($account_id!=FALSE)
		{
			/**Block the related advertiser**/
			$this->db->select('dc.account_id as adv_account_id');
			$this->db->where('da.account_id',$account_id);
			$this->db->join(TAB_CLIENTS.' as dc','da.agencyid=dc.agencyid');
			$query=$this->db->get(TAB_AGENCY.' as da');
			$result_adv=$query->result_array();
			if($result_adv!=FALSE)
			{
			  foreach($result_adv as $acc_id=>$value )
			  { 
			    $adv_account_id=$value['adv_account_id'];
				$where = array('default_account_id'=>$adv_account_id );
				$data  = array('active'=>0 );
				$this->db->update(TAB_USERS,$data,$where);
			  }
			}
			
			/**Block the related publisher**/
			$this->db->select('daf.account_id as pub_account_id');
			$this->db->where('da.account_id',$account_id);
			$this->db->join(TAB_AFFILIATE.' as daf','da.agencyid=daf.agencyid');
			$query=$this->db->get(TAB_AGENCY.' as da');
			$result_adv=$query->result_array();
			if($result_adv!=FALSE)
			{
			  foreach($result_adv as $acc_id=>$value )
			  { 
			    $pub_account_id=$value['pub_account_id'];
				$where = array('default_account_id'=>$pub_account_id );
				$data  = array('active'=>0 );
				$this->db->update(TAB_USERS,$data,$where);
			  }
			}
			
			/* Update ox_users Table */
			$where_user		=	array("default_account_id"	=>	$account_id);
			$user_data		=	array(
									"active" 	=> 	0
								);
			$this->db->where($where_user);
			$this->db->update(TAB_USERS,$user_data);
			
			/* Update ox_agency Table */
			$where_acc		=	array("account_id"	=>	$account_id);
			$agency_data	=	array(
									"active" 	=> 	0
								);
			$this->db->where($where_acc);
			$this->db->update(TAB_AGENCY,$agency_data);
		
			/* Update djax_network_managers Table */
			$where_net		=	array("manager_account_id" 	=> 	$account_id);
			$network_data	=	array("manager_status"	=>	0);
			$this->db->where($where_net);
			if($this->db->update(TAB_NWK_MANAGERS,$network_data))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		  
		}
		else
		{
			return FALSE;
		}		
	}
	
	function unblock($account_id=FALSE)
	{
		if($account_id!=FALSE)
		{
			
			/**UnBlock the related advertiser**/
			$this->db->select('dc.account_id as adv_account_id');
			$this->db->where('da.account_id',$account_id);
			$this->db->join(TAB_CLIENTS.' as dc','da.agencyid=dc.agencyid');
			$query=$this->db->get(TAB_AGENCY.' as da');
			$result_adv=$query->result_array();
			if($result_adv!=FALSE)
			{
			  foreach($result_adv as $acc_id=>$value )
			  { 
			    $adv_account_id=$value['adv_account_id'];
				$where = array('default_account_id'=>$adv_account_id );
				$data  = array('active'=>1 );
				$this->db->update(TAB_USERS,$data,$where);
			  }
			}
			
			/**UnBlock the related publisher**/
			$this->db->select('daf.account_id as pub_account_id');
			$this->db->where('da.account_id',$account_id);
			$this->db->join(TAB_AFFILIATE.' as daf','da.agencyid=daf.agencyid');
			$query=$this->db->get(TAB_AGENCY.' as da');
			$result_adv=$query->result_array();
			if($result_adv!=FALSE)
			{
			  foreach($result_adv as $acc_id=>$value )
			  { 
			    $pub_account_id=$value['pub_account_id'];
				$where = array('default_account_id'=>$pub_account_id );
				$data  = array('active'=>1 );
				$this->db->update(TAB_USERS,$data,$where);
			  }
			}
			
			/* Update ox_users Table */
			$where_user		=	array("default_account_id"	=>	$account_id);
			$user_data		=	array(
									"active" 	=> 	1
								);
			$this->db->where($where_user);
			$this->db->update(TAB_USERS,$user_data);
			
			/* Update ox_agency Table */
			$where_acc		=	array("account_id"	=>	$account_id);
			$agency_data	=	array(
									"active" 	=> 	1
								);
			$this->db->where($where_acc);
			$this->db->update(TAB_AGENCY,$agency_data);
		
			
			
			
			/* Update djax_network_managers Table */
			$where_net		=	array("manager_account_id" 	=> 	$account_id);
			$network_data	=	array("manager_status"	=>	1);
			$this->db->where($where_net);
			if($this->db->update(TAB_NWK_MANAGERS,$network_data))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
					
		}
		else
		{
			return FALSE;
		}		
	}
	
	/* method : fetch_users
	 * 
	 * params : account_id
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	
	
	function fetch_users($account_id=FALSE)
	{					
		$key = 'fetch_users_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADMIN_FETCH_USERS);
		if($ret && $mem_cache=='enable' && $check_db_changes !='1' )
		{
			return $ret;
		}
		else{
		if($account_id!=FALSE)
		{
			$this->db->where('oxu.default_account_id',$account_id);
		}
			
		$this->db->select('*,dura.is_default as default_user');
		$this->db->join(TAB_USER_ROLE_ASSOC.' as dura','dura.user_id=oxu.user_id');
		$this->db->join(TAB_ROLES.' as dr','dr.role_id=dura.role_id');
		$this->db->join(TAB_ACCOUNTS.' as oxac','oxac.account_id=oxu.default_account_id');
		$this->db->where('oxac.account_type','MANAGER');		
		$this->db->order_by('oxu.user_id','DESC');		
		$query = $this->db->get(TAB_USERS.' as oxu');
		$result = $query->result_array();
		$count=$query->num_rows();
		$i	=	0;$j=$count;
		if($result)
		{	
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$j;
				$i+=1;$j-=1;
			}		
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$this->memcached_library->set(ADMIN_FETCH_USERS,'2');
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $result;
			}
		}
		else
		{
	  		return FALSE;
		}			
			
	}
}
	
	/* method : fetch_roles
	 * 
	 * params : 
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	function fetch_roles()
	{
		$query = $this->db->get_where(TAB_ROLES,array('status'=>1));	
		
		if($query->num_rows() >0)
		{
			return $query->result_array();	
		}else{
			return FALSE;	
		}
		
	}
	
	
   /* method : edit_fetch_roles
	 * 
	 * params : 
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	function edit_fetch_roles()
	{
		$query = $this->db->get_where(TAB_ROLES);	
		
		if($query->num_rows() >0)
		{
			return $query->result_array();	
		}else{
			return FALSE;	
		}
		
	}
	
	/* method : add_manager_user
	 * 
	 * params : $data
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	function add_manager_user($data=FALSE)
	{
		
		$this->db->trans_begin();
		
		$manager_account_id = $data['manager_account_id'];
			
		$user_data	=	array(
								"contact_name" 			=> 	$data['name'],
								"email_address" 		=> 	$data['email'],
								"username" 				=> 	$data['email'],
								"password" 				=> 	$data['password'],
								"default_account_id" 	=> 	$manager_account_id,
								"active" 				=> 	1,
								"date_created"			=>	date('Y-m-d H:i:s')
			);
			
			
							
				$this->db->insert(TAB_USERS,$user_data);
			
				$user_id		=	$this->db->insert_id();
				/*-------------------------------------------
				 INSERT dJAX_USER_APIKEY TABLE
				---------------------------------------------*/
				$api_key = generate_user_apikey($user_id);
				$key_data=array(   
								 'user_id'=> $user_id,
								 'api_key'=> $api_key
							   );
				
				$this->db->insert(TAB_USER_APIKEY,$key_data);
				
				$user_assoc_data=	array(
										"account_id"	=>	$manager_account_id,
										"user_id"		=>	$user_id,
										"linked"		=>	date('Y-m-d H:i:s')
										);
										
				$this->db->insert(TAB_ACC_USER_ASSOC,$user_assoc_data);
			
				$user_permission_assoc = array(
										  "account_id"	=>	$manager_account_id,
										  "user_id"		=>	$user_id,
										  "permission_id" => 10,
										  "is_allowed"	=> 1		
										);
			
				$this->db->insert(TAB_ACC_USER_PER_ASSOC,$user_permission_assoc);
				
				$user_role_assoc = array(
										"user_id"	=>	$user_id,
										"role_id"	=>	$data['role_id'],
										"adv_pub_assoc" => $data['adv_pub_assoc']
									);
				
				$this->db->insert(TAB_USER_ROLE_ASSOC,$user_role_assoc);
				
				
				if ($this->db->trans_status() === FALSE)
				{
					$this->db->trans_rollback();
					return FALSE;
				}
				else
				{
					$this->memcached_library->set(ADMIN_FETCH_USERS,'1');
					$this->db->trans_commit();
					return $user_id;
				}
			
	}
	
	
	public function fetch_manager_users($user_id,$account_id)
	{ 
		if($account_id!=FALSE)
		{
			$this->db->where('oxu.user_id',$user_id);
			$this->db->where('oxu.default_account_id',$account_id);
		}
		$this->db->join(TAB_USER_ROLE_ASSOC.' as dura','dura.user_id=oxu.user_id');
		$this->db->join(TAB_ROLES.' as dr','dr.role_id=dura.role_id');
		$this->db->join(TAB_ACCOUNTS.' as oxac','oxac.account_id=oxu.default_account_id');
		$this->db->where('oxac.account_type','MANAGER');		
		$query = $this->db->get(TAB_USERS.' as oxu');		
		$result= $query->result_array();
		
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		}		
	}
	
	
	/* method : update_manager_user
	 * 
	 * params : $data
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	function update_manager_user($data=FALSE)
	{
		
		$this->db->trans_begin();
		
		$where=array('default_account_id' => $data['manager_account_id'],'user_id' => $data['user_id']);
			
		$user_data=array( "contact_name" 			=> 	$data['name'],
							"email_address" 		=> 	$data['email'],
						);
			
		$this->db->update(TAB_USERS,$user_data,$where);
		$this->memcached_library->set(ADMIN_FETCH_USERS,'1');
		//compare previous role id with selected role id
		$this->db->select('role_id,role_block');
		$this->db->where('user_id',$data['user_id']);
		$query=$this->db->get(TAB_USER_ROLE_ASSOC);
		$result=$query->result_array();
		if($result)
		{
		 $role_id=$result[0]['role_id'];
		 $role_blocked=$result[0]['role_block'];
		}
		//IF same role-id and role is blocked
		if($role_blocked==1 && $role_id==$data['role_id'])
		{
			$role_assoc=array('user_id' => $data['user_id']);
			 
			$user_role_assoc = array(	'role_id'	=>	$data['role_id'],
										"adv_pub_assoc" => $data['adv_pub_assoc']
									 );
			$this->db->update(TAB_USER_ROLE_ASSOC,$user_role_assoc,$role_assoc);
		}
		//IF unblocked role-id updated
		else
		{
		   $role_assoc=array('user_id' => $data['user_id']);
			 
		   $user_role_assoc = array( 'role_id'	=>	$data['role_id'],
									  'role_block'=> 0,
									  "adv_pub_assoc" => $data['adv_pub_assoc']
									);
			$this->db->update(TAB_USER_ROLE_ASSOC,$user_role_assoc,$role_assoc);
		}
		if ($this->db->trans_status() === FALSE)
		{
		  $this->db->trans_rollback();
		  return FALSE;
		}
		else
		{
		  $this->db->trans_commit();
		  return TRUE;
	    }
	}
	
	/* method : block_manager_users
	 * 
	 * params : $user_id
	 * 
	 * returns manager users and their assoc
	 * 
	 * */
	public function block_manager_users($user_id)
	{
	   $this->db->trans_begin();
	   $where=array('user_id'=>$user_id);
	   $data=array('user_status'=>0);				  
	   $this->db->update(TAB_USER_ROLE_ASSOC,$data,$where);
	   
	   $this->memcached_library->set(ADMIN_FETCH_USERS,'1');
	   
	   if ($this->db->trans_status() === FALSE)
		{
		  $this->db->trans_rollback();
		  return FALSE;
		}
		else
		{
			
		  $this->db->trans_commit();
		  
		  return TRUE;
	    }
	}
	
  /* method : block_manager_users
   * 
   * params : $user_id
   * 
   * returns manager users and their assoc
   * 
   * */
	public function unblock_manager_users($user_id)
	{
	   $this->db->trans_begin();
	   $where=array('user_id'=>$user_id);
	   $data=array('user_status'=>1);				  
	   $this->db->update(TAB_USER_ROLE_ASSOC,$data,$where);
	   
	   $this->memcached_library->set(ADMIN_FETCH_USERS,'1');
	   
	   
	   if ($this->db->trans_status() === FALSE)
		{
		  $this->db->trans_rollback();
		  return FALSE;
		}
		else
		{
		  $this->db->trans_commit();
		  return TRUE;
	    }
	}
	
	public function get_manager_api_key($account_id)
	{
		
		$key = 'get_manager_api_key_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	    $this->db->select('dua.api_key');
		$this->db->from(TAB_USER_APIKEY.' as dua');
		$this->db->where('du.default_account_id',$account_id);
		$this->db->join(TAB_USERS.' as du','du.user_id=dua.user_id');
		$query=$this->db->get();
		if($query->num_rows>0)
		{
		  $result=$query->result_array();
		  if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result[0],$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		 return $result[0];
		}
		}
		else
			{
				return FALSE;
			}
		}
	}

}
