<?php
class Do_linking extends CI_Model
{
	
	public $agency_id='';
	
	
	/*
	 * 
	 * name: fetch_adblock
	 * @param :
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	 
	 function fetch_adblock($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->select('width,height,delivery,dj_zone_type');		
			$this->db->where('zoneid ',$zone_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get Creatives
	 */
	 
	 function fetch_creative($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->select('width,height,dj_banner_type');		
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to creative
	 */
	
	function link_ads($zone_id=false,$agencyid=false)
	{
		//If auto linking FALSE this will return;
		if($this->config->item('zone_ad_auto_link') != TRUE) return;
		
		if($zone_id)
		{
			
			//Sets the agency_id
			$this->agency_id = $agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_ads($zone_id);
			
			$zone_details = $this->fetch_adblock($zone_id);
			$zone = $zone_details[0];
			//echo "<pre>"; print_r($zone); exit;
			$zone_type = $zone['dj_zone_type'];
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_web_creatives($where_web);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									}
								}
								break;
				case WEB_AD_BLOCK_TEXT:
								$creatives = $this->fetch_text_creatives();
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
											
									}
								}
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_dhtml_creatives($where_dhtml);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
								
								
								case VIDEO_AD_BLOCK_REAL:
								$where_real = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_real_creatives($where_real);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
								
				case VIDEO_AD_BLOCK_SMALL:
				
				echo "testpage";
								$where_small = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_small_creatives($where_small);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
								
				case VIDEO_AD_BLOCK_BOX:
								$where_box = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_box_creatives($where_box);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
								
								
				case VIDEO_AD_BLOCK_HEAD:
								$where_head = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_head_creatives($where_head);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
								
								
								
				
			}
			//$this->response($zone);
		}
	}
		
	/*
	 * 
	 * name: fetch_web_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_web_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_dhtml_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_dhtml_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a text creative
	 */
	 function fetch_text_creatives($categories=FALSE)
	 {
		$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		if($categories)
		{
			$this->db->where_in('oxcamp.dj_category_id', $categories);
		}
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.dj_admin_approve', '1');
		$this->db->where('oxb.storagetype', 'txt');
		$this->db->where('oxb.dj_banner_type', WEB_CREATIVE_TEXT);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_inline_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline creative
	 */
	 function fetch_inline_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_INLINE);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	
	
	/* READ VIDEO START  */
	
	/*
	 * 
	 * name: fetch_read_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a read creative
	 */
	 function fetch_real_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_REAL);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	/* READ VIDEO END  */
	
	
	
	/* SMALL VIDEO START  */
	
	 function fetch_small_creatives($where=false, $categories=FALSE)
	 {
		 
		 //echo "<pre>";
		  //print_r($where);
		 //echo "</pre>";
		 
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_SMALL);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	
	/* SMALL VIDEO END  */
	
	/* BOX VIDEO START  */
	
	 function fetch_box_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_BOX);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	/* BOX VIDEO END  */
	
	/* HEAD VIDEO START  */
	
	function fetch_head_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_HEAD);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	/* HEAD VIDEO END  */
	
	
	
	
	/*
	 * 
	 * name: fetch_overlay_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_overlay_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_OVERLAY);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function add_link_ads($link_assoc_data)
	{
		if($link_assoc_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_AD_ZONE_ASSOC,$link_assoc_data);
			
			$insert_id	= $this->db->insert_id();

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $insert_id;
			}
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: unlink_ads
	 * @param : zone_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_ads($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->trans_start();
			
			$this->db->where('zone_id',$zone_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: unlink_blocks
	 * @param : creative_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_blocks($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->trans_start();
			
			$this->db->where('ad_id',$creative_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_adblocks
	 * @param : creative_id
	 * @return : NULL
	 * 
	 * Link creative to blocks
	 */
	
	function link_adblocks($creative_id=false,$agencyid=false)
	{
		//If auto linking FALSE this will return;
		if($this->config->item('zone_ad_auto_link') != TRUE) return;
		
		if($creative_id)
		{
			
			$this->agency_id = $agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_blocks($creative_id);
			
			$creative_details = $this->fetch_creative($creative_id);
			$creative = $creative_details[0];
			//echo "<pre>"; print_r($zone); exit;
			$banner_type = $creative['dj_banner_type'];
			switch($banner_type)
			{
				case WEB_CREATIVE_WEB:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_SQL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_SWF:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_HTML:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_URL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_TEXT:
								$adblocks = $this->fetch_text_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case VIDEO_CREATIVE_OVERLAY:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_overlay_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case VIDEO_CREATIVE_INLINE:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_inline_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
								
								case VIDEO_CREATIVE_REAL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_real_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
								
				case VIDEO_CREATIVE_SMALL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_small_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
								
				case VIDEO_CREATIVE_BOX:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_box_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
								
				case VIDEO_CREATIVE_HEAD:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_head_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
								
								
								
								
				
			}
			//$this->response($zone);
		}
	}
	
	/*
	 * 
	 * name: fetch_banner_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a web blocks
	 */
	 function fetch_banner_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML));
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a text blocks
	 */
	
	function fetch_text_adblocks($categories = FALSE)
	{
		$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id){
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		if($categories)
		{
			$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
			$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id', 'LEFT');
			$this->db->where_in('(s2c.category_id', $categories);
			$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
		}
		$this->db->where('oxa.dj_approval_status', '1');
		$this->db->where('oxa.dj_is_denied', '0');
		$this->db->where('oxa.dj_is_deleted', '0');
		$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_TEXT));
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_overlay_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay blocks
	 */
	 function fetch_overlay_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_OVERLAY);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_inline_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_inline_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_INLINE);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_real_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_real_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_REAL);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	
	/*
	 * 
	 * name: fetch_small_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a Small blocks
	 */
	 function fetch_small_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_SMALL);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_box_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a Box blocks
	 */
	 function fetch_box_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_BOX);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_box_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a Box blocks
	 */
	 function fetch_head_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_HEAD);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	
	
	/*
	 * 
	 * name: fetch_adblocks
	 * @param : creative_id
	 * @return : Adblocks
	 * 
	 * Fetch adblocks that matched with the creative 
	 */
	
	function fetch_adblocks($creative_id=false)
	{
		if($creative_id)
		{
			$this->agency_id 	= 	$agencyid;
			
			$creative_details 	=	$this->fetch_creative($creative_id);
			$creative 			=	$creative_details[0];
			$banner_type 		=	$creative['dj_banner_type'];
			$categories			=	$this->fetch_ads_categories($creative_id);
			
			//echo print_r($categories);exit;
			$linked_zones		=	$this->fetch_adblocks_linked($creative_id);
			
			switch($banner_type)
			{
				case WEB_CREATIVE_WEB:
				case WEB_CREATIVE_SQL:
				case WEB_CREATIVE_SWF:
				case WEB_CREATIVE_HTML:
				case WEB_CREATIVE_URL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_banner_adblocks($where_block);								
								break;
								
				case WEB_CREATIVE_TEXT:
								$result	=	$this->fetch_text_adblocks();
								break;
								
				case VIDEO_CREATIVE_OVERLAY:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_overlay_adblocks($where_block);
								break;
								
				case VIDEO_CREATIVE_INLINE:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_inline_adblocks($where_block);
								break;	
				
				case VIDEO_CREATIVE_REAL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_real_adblocks($where_block);
								break;	
								
								
				case VIDEO_CREATIVE_SMALL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_small_adblocks($where_block);
								break;	
								
				case VIDEO_CREATIVE_BOX:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_box_adblocks($where_block);
								break;	
								
				case VIDEO_CREATIVE_HEAD:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_head_adblocks($where_block);
								break;	
				
				
				case MOBILE_IMAGE_CREATIVE:
								$result = $this->fetch_image_adblocks();
								break;
								
				case MOBILE_TEXT_CREATIVE:
								$result = $this->fetch_mob_text_adblocks();		
								break;	
				
				case MOBILE_MRAID_CREATIVE_INTERSTITAL:
								$result = $this->fetch_interstitial_adblocks();	
								break;
								
				case MOBILE_MRAID_CREATIVE_EXPAND:
								$result = $this->fetch_expand_adblocks();
								break;
								
				case MOBILE_MRAID_CREATIVE_REVEAL:
								$result = $this->fetch_reveal_adblocks();
								break;	
								
				case MOBILE_RS_CREATIVE_FLEX:
								$result = $this->fetch_flex_adblocks();
								break;	
								
				case MOBILE_RS_CREATIVE_ADHESION:
								$result = $this->fetch_adhension_adblocks();
								break;
				
				case MOBILE_RS_CREATIVE_FILMSTRIP:
								$result = $this->fetch_filmstrip_adblocks();
								break;
								
				case MOBILE_RS_CREATIVE_PULL:
								$result = $this->fetch_pull_adblocks();
								break;
								
				case MOBILE_RS_CREATIVE_SLIDER:
								$result = $this->fetch_slider_adblocks();
								break;
			}
			
			
			foreach($result as $zone)
			{
				$ad_block[$zone['affiliateid']]['name'] 								=	$zone['name'];
				$ad_block[$zone['affiliateid']]['zones'][$zone['zoneid']]['name'] 		=	$zone['zonename'];
				$ad_block[$zone['affiliateid']]['zones'][$zone['zoneid']]['linked'] 	=	(is_array($linked_zones) && (in_array($zone['zoneid'], $linked_zones))) ? TRUE : FALSE;
			}
			
			$res = array();
			foreach($ad_block as $key => $value) 
			{
				$tmp		= array();
				foreach($value['zones'] as $zoneid => $zonename){
					$tmp[] 	= array('title' => $zonename['name'],
									'key' => $zoneid,
									'select' => $zonename['linked']);
				}
				
				$res[]		= array('title' 	=> $value['name'],
									'key'		=> $key,									
									'isFolder'	=> TRUE,
									'expand'	=> TRUE,
									'children'	=> $tmp);
			}
			
			/*echo '<pre>';
			print_r(array_values($res));exit;*/
			return $res;
		}
	}
	
	/*
	 * 
	 * name: fetch_adblocks_linked
	 * @param : creative_id
	 * @return : Array
	 * 
	 * Return associated zone ids 
	 */
	
	function fetch_adblocks_linked($creative_id = FALSE)
	{
		if($creative_id)
		{
			$this->db->select('zone_id')->where('ad_id', $creative_id);
			$query 		=	$this->db->get(TAB_AD_ZONE_ASSOC)->result_array();
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['zone_id'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: fetch_ads_linked
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Return associated ads ids 
	 */
	
	function fetch_ads_linked($zone_id = FALSE)
	{
		if($zone_id)
		{
			$this->db->select('ad_id')->where('zone_id', $zone_id);
			$query 		=	$this->db->get(TAB_AD_ZONE_ASSOC)->result_array();
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['ad_id'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: linked_process
	 * @param : creative_id, zone_ids
	 * @return : Array
	 * 
	 * Return associated zone ids 
	 */
	function linked_process($creative_id = FALSE, $zone_ids	= FALSE)
	{
		if($creative_id)
		{
			$update_ids		=	is_array($zone_ids) ? array_map('trim', $zone_ids) : array();
			$exist_ids		=	$this->fetch_adblocks_linked($creative_id);
			$temp_ids		=	$this->fetch_adblocks($creative_id);
			$possible_ids	= 	array();
			foreach($temp_ids as $pub)
			{
				foreach($pub['children'] as $zone)
				{
					$possible_ids[]	=	$zone['key'];
				}
			}
			
			$not_exists		=	array_diff($update_ids, $exist_ids);			
			$remove_ids		=	array_diff($exist_ids, $update_ids);
			
			$insert_ids		=	($exist_ids == FALSE) ? array_intersect($possible_ids, $update_ids) : array_intersect($possible_ids, $not_exists);
			
			//Updating Association Table
			$this->db->trans_start();
			
			$result			=	0;
			//Removing unchecked boxes from Association table
			if(is_array($remove_ids) && count($remove_ids) > 0)
			{
				$this->db->where('ad_id',$creative_id);
				$this->db->where_in('zone_id',$remove_ids);
				$this->db->delete(TAB_AD_ZONE_ASSOC);
				$result	   +=	1;
			}
			
			//Insert New entries
			if(is_array($insert_ids) && count($insert_ids) > 0)
			{
				foreach($insert_ids as $zone_id)
				{
					$this->db->insert(TAB_AD_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'ad_id' => $creative_id));				
				}
				$result	   +=	2;
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $result;
			}
		}
	}
	
	/*
	 * 
	 * name		: linked_process
	 * @param 	: creative_id, zone_ids
	 * @return 	: Array
	 * 
	 * Returns linked status zones with ads 
	 */
	function linked_ads_process($zone_id = FALSE, $ads_ids	= FALSE)
	{
		if($zone_id)
		{
			$update_ids		=	is_array($ads_ids) ? array_map('trim', $ads_ids) : array();
			$exist_ids		=	$this->fetch_ads_linked($zone_id);
			
			$temp_ids		=	$this->fetch_ads($zone_id);
			$possible_ids	= 	array();
			
			
			foreach($temp_ids as $adv)
			{
				foreach($adv['children'] as $zone)
				{
					$possible_ids[]	=	$zone['key'];
				}
			}
			
			$not_exists		=	array_diff($update_ids, $exist_ids);			
			$remove_ids		=	array_diff($exist_ids, $update_ids);
			
			$insert_ids		=	($exist_ids == FALSE) ? array_intersect($possible_ids, $update_ids) : array_intersect($possible_ids, $not_exists);
			
			//Updating Association Table
			$this->db->trans_start();
			
			$result			=	0;
			//Removing unchecked boxes from Association table
			if(is_array($remove_ids) && count($remove_ids) > 0)
			{
				$this->db->where('zone_id',$zone_id);
				$this->db->where_in('ad_id',$remove_ids);
				$this->db->delete(TAB_AD_ZONE_ASSOC);
				$result	   +=	1;
			}
			
			//Insert New entries
			if(is_array($insert_ids) && count($insert_ids) > 0)
			{
				foreach($insert_ids as $ad_id)
				{
					$this->db->insert(TAB_AD_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'ad_id' => $ad_id));				
				}
				$result	   +=	2;
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $result;
			}
		}
	}
		
	/*
	 * 
	 * name: fetch_ads
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns array of banners
	 */
	
	function fetch_ads($zone_id=false,$agencyid=false)
	{
		if($zone_id)
		{
			//Sets the agency_id
			$this->agency_id 	=	$agencyid;
			
			$zone_details 		= 	$this->fetch_adblock($zone_id);
			$zone 				=	$zone_details[0];
			
			$zone_type 			=	$zone['dj_zone_type'];
			$categories			=	$this->fetch_zones_categories($zone_id);
			$linked_ads			=	$this->fetch_ads_linked($zone_id);
			echo "<pre>" . $zone_id; print_r($categories); echo '</pre>';//exit;
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_web_creatives($where_web, $categories);	
								break;
				case WEB_AD_BLOCK_TEXT:
								$creatives = $this->fetch_text_creatives($categories);
								print_r($creatives);
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_dhtml_creatives($where_dhtml, $categories);
								break;
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay, $categories);
								break;
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline, $categories);
								break;
								
								
			 case VIDEO_AD_BLOCK_REAL:
								$where_real = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_real_creatives($where_real, $categories);
								break;
								
			case VIDEO_AD_BLOCK_SMALL:
								$where_small = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_small_creatives($where_small, $categories);
								break;
								
			case VIDEO_AD_BLOCK_BOX:
								$where_box = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_box_creatives($where_box, $categories);
								break;
								
			case VIDEO_AD_BLOCK_HEAD:
								$where_head = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_head_creatives($where_head, $categories);
								break;
								
			}
			
			foreach($creatives as $ads)
			{
				$ad_block[$ads['clientid']]['name'] 							=	$ads['contact'];
				$ad_block[$ads['clientid']]['ads'][$ads['bannerid']]['name'] 	=	$ads['description'];
				$ad_block[$ads['clientid']]['ads'][$ads['bannerid']]['linked'] 	=	(is_array($linked_ads) && (in_array($ads['bannerid'], $linked_ads))) ? TRUE : FALSE;
			}
			
			$res = array();
			foreach($ad_block as $key => $value) 
			{		
				$tmp		= array();		
				foreach($value['ads'] as $ad_id => 	$ads){
					$tmp[] 	= array('title' 	=>	$ads['name'],
									'key' 		=>	$ad_id,
									'select' 	=>	$ads['linked']);
				}
				
				$res[]		= array('title' 	=> $value['name'],
									'key'		=> $key,									
									'isFolder'	=> TRUE,
									'expand'	=> TRUE,
									'children'	=> $tmp);
			}
					
			return $res;
		}
	}
	
	/*
	 * 
	 * name: fetch_zones_categories
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns Parent Categories
	 */
	function fetch_zones_categories($zone_id = FALSE)
	{
		if($zone_id)
		{
			$this->db->select('s2z.zone_id, sc.value, sc.parent_category_id');			
			$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', "s2c.site_id=s2z.site_id");	
			$this->db->join(TAB_SITE_CATEGORIES . ' AS sc', "sc.value = s2c.category_id");		
			$this->db->where('s2z.zone_id', $zone_id);
			$this->db->where('sc.is_deleted', '0');
			$result		=	$this->db->get(TAB_SITE_ZONE_ASSOC . ' AS s2z')->result_array();

			if($result)
			{
				$categories		=	FALSE;
				foreach($result as $cat)
				{
					$categories[]	=	$cat['parent_category_id'];
				}
				return $categories;
			}
			else 
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
	 * 
	 * name: fetch_ads_categories
	 * @param : creative_id
	 * @return : Array
	 * 
	 * Returns Categories
	 */
	function fetch_ads_categories($creative_id = FALSE)
	{
		if($creative_id)
		{
			$this->db->select('sc.value');
			$this->db->join(TAB_CAMPAIGNS . ' AS oxcamp', 'oxcamp.campaignid = oxb.campaignid');
			$this->db->join(TAB_SITE_CATEGORIES . ' AS sc', 'sc.parent_category_id = oxcamp.dj_category_id');
			$this->db->where('oxb.bannerid', $creative_id);
			$result		=	$this->db->get(TAB_BANNERS . ' AS oxb')->result_array();
			//echo $this->db->last_query();exit;
			if($result)
			{
				$categories		=	FALSE;
				foreach($result as $cat)
				{
					$categories[]	=	$cat['value'];
				}
				return $categories;
			}
			else 
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
	 * 
	 * name: fetch_campaign_adblocks
	 * @param : campaign_id
	 * @return : Array
	 * 
	 * Returns Adblocks
	 */
	function fetch_campaign_adblocks($campaign_id = FALSE)
	{
		$result			=	$this->fetch_all_adblocks();
		$linked_zones	=	$this->fetch_campaigns_linked($campaign_id);
		
		foreach($result as $zone)
		{
			$ad_block[$zone['site_id']]['name'] 							=	$zone['name'] . ' - ' . $zone['site_name'] . ' (<u>' . $zone['site_url'] . '</u>)';
			$ad_block[$zone['site_id']]['zones'][$zone['zoneid']]['name'] 	=	$zone['zonename'];
			$ad_block[$zone['site_id']]['zones'][$zone['zoneid']]['linked'] =	(is_array($linked_zones) && (in_array($zone['zoneid'], $linked_zones))) ? TRUE : FALSE;
		}
		
		$res = array();
		foreach($ad_block as $key => $value) 
		{
			$tmp		= array();
			foreach($value['zones'] as $zoneid 	=>	$zonename){
				$tmp[] 	= array('title' 		=>	$zonename['name'],
								'key' 			=>	$zoneid,
								'select' 		=>	$zonename['linked']);
			}
			
			$res[]		= array('title' 		=>	$value['name'],
								'key'			=>	$key,									
								'isFolder'		=>	TRUE,
								'expand'		=>	TRUE,
								'children'		=>	$tmp);
		}
		return $res;
	}
	
	 
	/*
	 * 
	 * name: fetch_adblock
	 * @param :
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	function fetch_all_adblocks()
	{
		$this->db->select('oxz.zoneid, oxz.zonename, oxz.affiliateid, oxa.name, oxs.site_name, oxs.site_id, oxs.site_url');		
		$this->db->where(array('oxz.dj_is_deleted ' => '0', 'oxa.dj_is_deleted '=>'0', 'oxa.dj_is_denied '=>'0', 'oxa.dj_approval_status' => '1'));
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'oxa.affiliateid = oxz.affiliateid');
		$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
		$this->db->join(TAB_PUB_SITES . ' AS oxs', 'oxs.site_id = s2z.site_id');
		$query = $this->db->get(TAB_ZONES . ' AS oxz');	
		return $query->result_array();
	}
	
	/*
	 * 
	 * name: fetch_campaigns_linked
	 * @param : campaign_id
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	function fetch_campaigns_linked($campaign_id = FALSE)
	{
		if($campaign_id)
		{
			$this->db->select('zone_id')->where('placement_id', $campaign_id);
			$query 		=	$this->db->get(TAB_PLACE_ZONE_ASSOC)->result_array();			
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['zone_id'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: linked_campaign_process
	 * @param : campaign_id, zone_ids
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */	 
	function linked_campaign_process($campaign_id = FALSE, $zone_ids = FALSE)
	{
		if($campaign_id)
		{
			$update_ids		=	is_array($zone_ids) ? array_map('trim', $zone_ids) : array();
			$exist_ids		=	$this->fetch_campaigns_linked($campaign_id);
			$temp_ids		=	$this->fetch_campaign_adblocks($campaign_id);
			$possible_ids	= 	array();
			
			foreach($temp_ids as $adv)
			{
				foreach($adv['children'] as $zone)
				{
					$possible_ids[]	=	$zone['key'];
				}
			}
			
			$not_exists		=	array_diff($update_ids, $exist_ids);
			$remove_ids		=	array_diff($exist_ids, $update_ids);
			
			$insert_ids		=	($exist_ids == FALSE) ? $update_ids : array_intersect($possible_ids, $not_exists);	
			
			//Updating Association Table
			$this->db->trans_start();
			
			$result			=	0;
			//Removing unchecked boxes from Association table
			if(is_array($remove_ids) && count($remove_ids) > 0)
			{
				$this->db->where('placement_id', $campaign_id);
				$this->db->where_in('zone_id', $remove_ids);
				$this->db->delete(TAB_PLACE_ZONE_ASSOC);
				$result	   +=	1;
			}
			
			//Insert New entries
			if(is_array($insert_ids) && count($insert_ids) > 0)
			{
				foreach($insert_ids as $zone_id)
				{
					$this->db->insert(TAB_PLACE_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'placement_id' => $campaign_id));
				}
				$result	   +=	2;
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				$this->link_campaign_banners($campaign_id);
				return $result;
			}
		}
	}
	
	function link_campaign_banners($campaign_id	= FALSE)
	{
		if($campaign_id)
		{
			$zone_ids		=	$this->fetch_campaigns_linked($campaign_id);
			$ads_ids		=	$this->fetch_campaign_creative($campaign_id);
			
			if(is_array($zone_ids) && is_array($ads_ids))
			{
				foreach($zone_ids as $zone_id)
				{
					$this->linked_ads_process($zone_id, $ads_ids);
				}
			}
		}
	}
	
	function fetch_campaign_creative($campaign_id = FALSE)
	{
		if($campaign_id)
		{
			$this->db->select('bannerid')->where('campaignid', $campaign_id);
			$query 		=	$this->db->get(TAB_BANNERS)->result_array();
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['bannerid'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: fetch_image_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a image blocks
	 */
	function fetch_image_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_IMAGE);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_mob_text_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a text blocks
	 */
	function fetch_mob_text_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_TEXT);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_interstitial_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a interstitial blocks
	 */
	function fetch_interstitial_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_INTERSTITIAL);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_expand_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a expand blocks
	 */
	function fetch_expand_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_EXPAND);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_reveal_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a reveal blocks
	 */
	function fetch_reveal_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_REVEAL);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_flex_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a flex blocks
	 */
	function fetch_flex_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLEX);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_adhension_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a adhension blocks
	 */
	function fetch_adhension_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_ADHENSION);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_filmstrip_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a adhension blocks
	 */
	function fetch_filmstrip_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLIMSTRIP);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_pull_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a pull blocks
	 */
	function fetch_pull_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_PULL);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_slider_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a slider blocks
	 */
	function fetch_slider_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_SLIDER);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
}
