<?php
class do_invoices extends CI_Model 
{
	
	//Generates Invoices Based on the specific time period
	public function generate_invoices($start_date,$end_date,$period_days)
	{
		
		//Retreive Total payment for each publisher
		//$total_pub_payment = $this->retreive_total_payment();
		$total_pub_list = $this->retreive_publisher_list();
		//Retreive the minimum publisher payments
		$def_min_payment = $this->default_configurations->get('pub_min_amount_invoice');
		
		//invoice generation count
		$i =0;
		
		foreach($total_pub_list as $publisher)
		{			
			//Retreive publisher name from publisher id
			$publisher_name = 	$publisher->contact;
			$pub_acc_id 	= 	$publisher->account_id;
			$affiliateid 	= 	$publisher->affiliateid;
			$referral_id	=	$publisher->referral_id;
			
			//Retreive the overall payment details for the specific invoice
			$total_pub_payment = $this->retreive_overall_payment_details($pub_acc_id);
			
			//print_r($total_pub_payment);
			
			//Check whether the overall payment is greater than config minimum payment
			if(!empty($total_pub_payment['tot_payment']))
			{
				if($total_pub_payment['tot_payment']->min_invoice_amt!=0)
				{
					$min_pub_payment	=	$total_pub_payment['tot_payment']->min_invoice_amt;
				}
				else
				{
					$min_pub_payment	=	$def_min_payment;
				}
				
				//Generate invoice only minimum payment is greater than minimum publisher payment
				if($total_pub_payment['tot_payment']->tot_amount >= $min_pub_payment)
				{
					$invoice_code 		= 	random_string('numeric',10);
					$invoice_date 		= 	date('Y-m-d H:i:s');
					$invoice_tot_amount = 	$total_pub_payment['tot_payment']->tot_amount;
					$prev_invoice_id 	= 	$total_pub_payment['tot_payment']->invoice_id;
					
				
					$this->db->trans_begin();
					
					//Creates the insert variables for invoice
					$ins_arr = array('account_id'		=>	$pub_acc_id,
									'invoice_code'		=>	$invoice_code,
									'invoice_date'		=>	$invoice_date,
									'invoice_net_amount'=>	$invoice_tot_amount,
									'invoice_status'	=>	0,
									'account_id'		=>	$pub_acc_id,
									'invoice_start_date'=>	$start_date,
									'invoice_end_date'	=>	$end_date,
									'invoice_period_days'=>	$period_days
								);
					$this->db->insert(TAB_INVOICE,$ins_arr);
					
					$last_invoice_id = $this->db->insert_id();
					
					if($referral_id!=0)
					{
						$refinv_code 	= 	random_string('numeric',10);
						$referral_amt	=	(5*$invoice_tot_amount)/100;
						$ref_ins_arr 	= 	array('account_id'		=>	$referral_id,
												'invoice_code'		=>	$refinv_code,
												'invoice_date'		=>	$invoice_date,
												'invoice_net_amount'=>	$referral_amt,
												'invoice_status'	=>	0,
												'invoice_start_date'=>	$start_date,
												'referral'			=>	$pub_acc_id,
												'invoice_end_date'	=>	$end_date,
												'invoice_period_days'=>	$period_days
											);
											
						$this->db->insert(TAB_INVOICE,$ref_ins_arr);
						
						$ref_last_invoice_id	=	$this->db->insert_id();
						
						$ref_ins_item_arr 		= 	array('invoice_id'=>	$ref_last_invoice_id,
														  'item_code'	=>	'REF',
														  'item_desc'	=>	'Referral Amount for the period '.$start_date.' to '.$end_date,
														  'amount'		=>	$referral_amt,
														  'currency'	=>	$this->config->item('currency')	
													 );
						$this->db->insert(TAB_INVOICE_ITEM,$ref_ins_item_arr);
					}						
					
					//Inserts the invoice item into TAB_INVOICE_ITEM
					$ins_item_arr = array();
					
					$ins_item_arr[] = array('invoice_id'=>	$last_invoice_id,
										  'item_code'	=>	'ERN',
										  'item_desc'	=>	'Earnings for the period '.$start_date.' to '.$end_date,
										  'amount'		=>	$total_pub_payment['tot_payment']->cur_earn,
										  'currency'	=>	$this->config->item('currency')	
										 );
					if($total_pub_payment['tot_payment']->cry_bal >0)
					{
						$ins_item_arr[] = array('invoice_id'=>$last_invoice_id,
										  'item_code'	=>	'CRYBAL',
										  'item_desc'	=>	'Credit Balance for the period '.$start_date.' to '.$end_date,//lang('previous_balance'),
										  'amount'		=>	$total_pub_payment['tot_payment']->cry_bal,
										  'currency'	=>	$this->config->item('currency')	
										 ); 	
					}		
					
					$this->db->insert_batch(TAB_INVOICE_ITEM,$ins_item_arr);
					
					if($prev_invoice_id!=0)
					{
						//Cancel the previous invoice
						$this->db->update(TAB_INVOICE,array('invoice_status'=>2),array('invoice_id'=>$prev_invoice_id));	
					}
					
					
					if ($this->db->trans_status() === FALSE)
					{
						$this->db->trans_rollback();
					}
					else
					{
						$this->db->trans_commit();
					}
					
					$i++;
				}		
			}	
			
		}
		
		//Insert the djax invoice generation count
			$insert_generated_list = array('no_of_invoices'=>$i,
										   'generation_date'=>date('Y-m-d H:i:s'),
										   'invoice_type'=>'int_pub'
									);
			$this->db->insert('djax_invoice_generation',$insert_generated_list);
		
		return TRUE;
	}
	
	
	/*******************************
	 * Method 		: retreive_overall_payment_details
	 * @param 		: publisher account id
	 * @return 		: return overall payment_details on TRUE (or) FALSE
	 * Description	: Retreive the overall payment details 
	 * *****************************/
	function retreive_overall_payment_details($pub_acc_id)
	{
		
		$key = 'retreive_overall_payment_details_'.$pub_acc_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		
		
		if($pub_acc_id)
		{
			//Create an empty array for the payment
			$overall_payment_details = array();
			
			//Checks Whether Previous Invoices are Available or not
			$start_date = $this->retreive_last_invoice_generate_date($pub_acc_id);
			
			
			//assign total payment based on condition
			$tot_payment_sql = "SELECT accountid,min_invoice_amt,SUM(totalrev) as cur_earn,SUM(remain_bal) as cry_bal,(SUM(totalrev) + SUM(remain_bal)) as tot_amount,invoice_id 
								FROM 
								((SELECT oxa.account_id as accountid,oxa.min_invoice_amt,ROUND(IFNULL(SUM(oxadh.dj_publisher_earnings),0),2) as totalrev,0 as remain_bal,0 as prev_bal,0 as invoice_id 
								FROM ".TAB_DATA_SUM_AD_HOURLY." as oxadh 
								JOIN ".TAB_ZONES." as oxz ON oxz.zoneid=oxadh.zone_id 
								JOIN ".TAB_AFFILIATE." as oxa ON oxa.affiliateid=oxz.affiliateid 
								WHERE oxa.account_id= ".$pub_acc_id;
			if(isset($start_date) && !empty($start_date)) //zone_id
			{
				$tot_payment_sql .=" AND DATE(date_time) BETWEEN '$start_date' AND DATE_SUB(CURDATE(),INTERVAL 1 DAY)";
			}else{
				$tot_payment_sql .=" AND DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date_time)";
			}
			$tot_payment_sql .= " GROUP BY oxa.affiliateid 
								  ORDER BY DATE(date_time) DESC)
								  UNION
								  (SELECT `account_id` as accountid,0 as min_invoice_amt,0 as totalrev,djin.invoice_remaining_amount as remain_bal,djin.invoice_net_amount as prev_bal,djin.invoice_id as invoice_id
								  FROM ".TAB_INVOICE." as djin
								  WHERE account_id= $pub_acc_id AND DATE(invoice_date)='$start_date' 
								  ORDER BY djin.invoice_date DESC LIMIT 1)) as final HAVING final.accountid IS NOT NULL";
			
			$tot_payment_query = $this->db->query($tot_payment_sql);
			
			/*SELECT accountid,SUM(totalrev) as tot_rev,SUM(prev_bal) as unpaid_bal FROM ((SELECT oxa.account_id as accountid,ROUND(IFNULL(SUM(oxadh.dj_publisher_earnings),0),2) as totalrev,0 as prev_bal  FROM `rv_data_summary_ad_hourly` as oxadh  JOIN `rv_zones` as oxz ON oxz.zoneid=oxadh.zone_id  JOIN `rv_affiliates` as oxa ON oxa.affiliateid=oxz.affiliateid WHERE account_id=21  GROUP BY oxa.affiliateid ORDER BY DATE(date_time) DESC )
			UNION
	(SELECT `account_id` as accountid,0 as totalrev,djin.invoice_net_amount as prev_bal FROM djax_invoice as djin WHERE djin.invoice_status=0 AND account_id=21 ORDER BY djin.invoice_date DESC LIMIT 1)) as final HAVING final.accountid IS NOT NULL
			*/
			
			if($tot_payment_query->num_rows()>0)
			{
				$tot_payment_result = $tot_payment_query->row();
				$overall_payment_details['tot_payment'] = $tot_payment_result;
			}else{
				$tot_payment = 0;
				$overall_payment_details['tot_payment'] = 0;
			}
		
			if($mem_cache=='enable' )
			{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$overall_payment_details,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
			}
			else{
				return $overall_payment_details;
			}
			
		}
		else
		{
			return FALSE;
		}	
	}
	
	
	
}
	
	/*******************************
	 * Method 		: retreive_overall_payment_details
	 * @param 		: publisher account id
	 * @return 		: return payment_details on TRUE (or) FALSE
	 * Description	: Retreive the overall payment details 
	 * *****************************/
	function retreive_last_invoice_generate_date($pub_acc_id=FALSE)
	{
		
			$this->db->select('DATE(invoice_date) as last_generate_date');
			$this->db->order_by('invoice_id desc,invoice_date desc');
			
			if($pub_acc_id)
			{
				$query = $this->db->get_where('djax_invoice',array('account_id'=>$pub_acc_id));
			}else
			{
				$query = $this->db->get('djax_invoice');	
			}
			if($query->num_rows>0)
			{
				$result = $query->row();	
				return $result->last_generate_date;
			}else{
				return FALSE;	
			}
	}
	
	
	
	//Retreive Total payment for each publisher from oxm_report table
	public function retreive_total_payment($period_days)
	{
		//  WHERE DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date) 
		
		$query = $this->db->query('SELECT sum(oxmr.publisher_amount) as totalrev, oxa.account_id as publisherid 
						 FROM `oxm_report` as oxmr JOIN rv_affiliates as oxa ON oxa.affiliateid=oxmr.publisherid
						 WHERE DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date)
						 GROUP BY publisherid 
						 ORDER BY DATE(date) desc');
						 
		//echo $this->db->last_query();
		

        return $query->result();
	}
	
	//Retreive Total Paid payment for each publisher from oxm_admin_payment table
	public function retreive_paid_payment($pub_id=FALSE)
	{
		if($pub_id)
		{
			
			$query = $this->db->query('SELECT sum(oxm_admin_payment.amount) as reportpaid 
							FROM oxm_admin_payment
							WHERE DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date) AND status =1 AND publisherid = '.$pub_id.'
							GROUP BY `publisherid`
							');
			
			if($query->num_rows()>0)
			{
				$result = $query->result();
				return $result[0]->reportpaid;
			}else{
				return FALSE;
			}
		 }else{
			return FALSE;
		 }
	}
	
	//Retreive Publisher Name 
	public function retreive_publisher_name($pub_id= FALSE)
	{
		if($pub_id)
		{
			$this->db->select('username');
			$query = $this->db->get_where('oxm_userdetails',array('accountid'=>$pub_id));
			if($query->num_rows()>0)
			{
				$result = $query->result();
				return $result[0]->username;
			}else{
				return FALSE;
			}
		}else{
			
		}
	}
	
	//Generate Payment invoice for the publishers
	public function generate_payment_invoice($inv_id)
	{
		$app_invoice = $this->check_approved_invoice($inv_id);
		if($app_invoice)
		{
			$data['payment_info'] = $this->payment_invoice_information($inv_id);
			
			//$view = $this->load->view('admin/invoice_pub',$data,true);
			
			$payment_date = date('Y-m-d',strtotime($data['payment_info']['invoice_paid_date']));
			$pdf_name = 'invoice_'.$data['payment_info']['invoice_code'].'_'.$payment_date;
			
			$this->pdf->load_view('admin/invoices/invoice_pub',$data);
			$this->pdf->render();
			$this->pdf->stream("$pdf_name.pdf");
			
		}else{
			return FALSE;
		}
	}
	
	//Check whether the Invoice has ben approved or not
	public function check_approved_invoice($inv_id)
	{
		$this->db->join('djax_invoice_payment as dip','dip.invoice_id=di.invoice_id');
		$query = $this->db->get_where('djax_invoices as di',array('di.invoice_status'=>1,'di.invoice_id'=>$inv_id));
		
		if($query->num_rows()>0)
		{
			return TRUE;	
		}else{
			return FALSE;
		}
	}
	
	//Retreive Payment invoice informations based on their invoice id
	public function payment_invoice_information($inv_id)
	{
		$this->db->join('oxm_userdetails as oxu','oxu.accountid=di.publisher_id');
		$this->db->join('djax_invoice_payment as dip','dip.invoice_id = di.invoice_id');
		$this->db->join('oxm_admin_payment as oxap','oxap.id=dip.payment_id');
		$query = $this->db->get_where('djax_invoices as di',array('di.invoice_status'=>1,'di.invoice_id'=>$inv_id));
		
		if($query->num_rows()>0)
		{
			$result = $query->row_array();
			$this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
			$ad_query = $this->db->get_where('oxm_admindetails',array('accountid'=>$this->session->userdata('mads_sess_admin_id')));
			if($ad_query->num_rows()>0)
			{
				$ad_result = $ad_query->row_array();
				$result = array_merge($result,$ad_result);
			}
			return $result;	
		}else{
			return FALSE;
		}
	}
	
	function get_advertiser_payments_datewise($search_array,$start=0,$limit=false){
		
		$this->db->select('*');
		$this->db->from('djax_advertiser_add_fund as daaf');
		$this->db->join('rv_clients as oxc','oxc.clientid=daaf.advertiser_id');
		$sub = $this->subquery->start_subquery('where_in');
		$sub->select('djax_account_id')->from('ad_exchange_mapping');
		$this->subquery->end_subquery('oxc.account_id', FALSE);
		$this->db->order_by('clientname');
		
		if(!empty($search_array['search_field_adv']) && $search_array['search_field_adv'][0] !='all')
		{
			$this->db->where_in('daaf.advertiser_id', $search_array['search_field_adv']);
		}
		
		if(!empty($search_array)  AND isset($search_array['from_date']) AND isset($search_array['to_date']) AND $search_array['from_date'] != '' AND $search_array['to_date'] != '' AND $search_array['search_type'] !='all')
		{	
			$this->db->where('DATE(daaf.added_date) >=', date("Y-m-d",strtotime($search_array['from_date'])));
			$this->db->where('DATE(daaf.added_date) <=', date("Y-m-d",strtotime($search_array['to_date'])));
			//$this->db->where("DATE(di.invoice_date) BETWEEN $search_array['from_date'] AND $search_array['to_date']");
		}
		
		
		$query = $this->db->get();
		
		if($query->num_rows() >0)
		{
			$result = $query->result_array();
			return $result;
		}else{
			
			return FALSE;
		}
	}
	
	function retreive_advertiser_payment_history(){
		
		$this->db->select('*');
		$this->db->from('djax_advertiser_add_fund as daaf');
		$this->db->join('rv_clients as oxc','oxc.clientid=daaf.advertiser_id');
		$sub = $this->subquery->start_subquery('where_in');
		$sub->select('djax_account_id')->from('ad_exchange_mapping');
		$this->subquery->end_subquery('oxc.account_id', FALSE);
		$this->db->order_by('clientname');
		$query = $this->db->get();
		
		if($query->num_rows() >0)
		{
			$result = $query->result_array();
			return $result;
		}else{
			
			return FALSE;
		}
		
	}
	
	//Retreive All the generated invoices
	function retreive_invoice_history()
	{
		$this->db->join('oxm_userdetails as oxu','oxu.accountid=di.publisher_id');
		//$this->db->join('djax_invoice_payment as dip','dip.invoice_id = di.invoice_id');
		//$this->db->join('oxm_admin_payment as oxap','oxap.id=dip.payment_id');
		$query = $this->db->get('djax_invoices as di');
		
		if($query->num_rows()>0)
		{
			$result = $query->result_array();
			
			
			$result_pay =array();
			//Retreive the Payment Other details
			foreach($result as $payment)
			{
					if($payment['invoice_status'] ==1)
					{
						$payment_details = $this->retreive_payment_details($payment['invoice_id']);
						$payment = array_merge($payment,$payment_details);
					}
					array_push($result_pay,$payment);
			}
			
			
			//retreive the admin userdetails
			/*$this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
			$ad_query = $this->db->get_where('oxm_admindetails',array('accountid'=>$this->session->userdata('mads_sess_admin_id')));
			if($ad_query->num_rows()>0)
			{
				$ad_result = $ad_query->row_array();
			}*/
			$final_result = $result_pay;
			//$final_result = array('invoice_list'=>$result_pay,'admin_detail'=>$ad_result);
			return $final_result;
		}else{
			return FALSE;
		}
	}
	
	//Retreive payment details from oxm_admin_payment
	public function retreive_payment_details($inv_id=FALSE)
	{
		if($inv_id)
		{
			$this->db->select('email as pub_email,paymenttype');
			$this->db->join('djax_invoice_payment as dip','dip.payment_id = oxap.id');
			$query = $this->db->get_where('oxm_admin_payment as oxap',array('dip.invoice_id'=>$inv_id));
			
			if($query->num_rows>0)
			{
				return $query->row_array();
			}else{
				return FALSE;
			}
		}else{
			return FALSE;
		}
	}
	
	//Retreive Individual Invoice
	function retreive_individual_invoice_history($inv_id=FALSE)
	{
		if($inv_id)
		{
		$this->db->join('oxm_userdetails as oxu','oxu.accountid=di.publisher_id');
		//$this->db->join('djax_invoice_payment as dip','dip.invoice_id = di.invoice_id');
		//$this->db->join('oxm_admin_payment as oxap','oxap.id=dip.payment_id');
		$query = $this->db->get_where('djax_invoices as di',array('di.invoice_id'=>$inv_id));
		
		if($query->num_rows()>0)
		{
			$result = $query->row_array();
			
			
			
			$result_pay =array();
			//Retreive the Payment Other details
			
			if($result['invoice_status'] ==1)
			{
						$payment_details = $this->retreive_payment_details($result['invoice_id']);
						$result = array_merge($result,$payment_details);
			}
			array_push($result_pay,$result);
			
			
			//retreive the admin userdetails
			$this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
			$ad_query = $this->db->get_where('oxm_admindetails',array('accountid'=>$this->session->userdata('mads_sess_admin_id')));
			if($ad_query->num_rows()>0)
			{
				$ad_result = $ad_query->row_array();
			}
			
			$final_result = array_merge($result_pay[0],$ad_result);
			
			//$final_result = array('invoice_detail'=>$result_pay,'admin_detail'=>$ad_result);
			return $final_result;
		}else{
			return FALSE;
		}
	}else{
		return FALSE;
	}
	}

	/*Retreive the start date from the invoice history */
	function get_start_date(){
		$query = $this->db->query("SELECT date(`invoice_date`) as start_date FROM `djax_invoices` ORDER BY `invoice_date` ASC LIMIT 0,1");
		if($query->num_rows > 0)
		 {
			 $t = $query->result_array();
			 return $t[0]['start_date'];
		 }
		 else
		 {
			return date("Y-m-d");
		 }	 
		}
	
	/*Retreive the invoices based on datewise*/
	function get_invoices_datewise($search_array,$start=0,$limit=false)
	{
		
		$this->db->join('oxm_userdetails as oxu','oxu.accountid=di.publisher_id');
		
		
		if(!empty($search_array['search_field_pub']) && $search_array['search_field_pub'][0] !='all')
		{
				$this->db->where_in('di.publisher_id', $search_array['search_field_pub']);
		}
		
		
		if(!empty($search_array)  AND isset($search_array['from_date']) AND isset($search_array['to_date']) AND $search_array['from_date'] != '' AND $search_array['to_date'] != '' AND $search_array['search_type']!='all')
		{	
			
			
			$this->db->where('DATE(di.invoice_date) >=', $search_array['from_date']);
			$this->db->where('DATE(di.invoice_date) <=', $search_array['to_date']);
			//$this->db->where("DATE(di.invoice_date) BETWEEN $search_array['from_date'] AND $search_array['to_date']");
			$query = $this->db->get('djax_invoices as di');
		}else{
			$query = $this->db->get('djax_invoices as di');
		}
		if($query->num_rows()>0)
		{
			$result = $query->result_array();
			
			
		$result_pay =array();
		//Retreive the Payment Other details
		foreach($result as $payment)
		{
			if($payment['invoice_status'] ==1)
			{
						$payment_details = $this->retreive_payment_details($payment['invoice_id']);
						$payment = array_merge($payment,$payment_details);
			}
					array_push($result_pay,$payment);
		}
			
			
			//retreive the admin userdetails
			/*$this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
			$ad_query = $this->db->get_where('oxm_admindetails',array('accountid'=>$this->session->userdata('mads_sess_admin_id')));
			if($ad_query->num_rows()>0)
			{
				$ad_result = $ad_query->row_array();
			}*/
			$final_result = $result_pay;
			//$final_result = array('invoice_list'=>$result_pay,'admin_detail'=>$ad_result);
			return $final_result;
		}else{
			return FALSE;
		}
	}
	
	//Retreive Active Publisher List
	function retreive_publisher_list()
	{
		$this->db->select('name,contact,email,account_id,affiliateid,referral_id');
		$this->db->order_by('affiliateid');
		$query = $this->db->get('rv_affiliates');
		
		if($query->num_rows() >0)
		{
			$result = $query->result();
			return $result;
		}else{
			
			return FALSE;
		}
	}
	
	//Retreive Active Publisher List
	function retreive_advertiser_list()
	{
		$this->db->select('oxc.clientname,oxc.contact,oxc.email,oxc.account_id,oxc.clientid');
		$this->db->join('oxm_userdetails as oxmu','oxmu.accountid=oxc.account_id');
		$this->db->where('oxmu.super_advertiser !=','1');
		$sub = $this->subquery->start_subquery('where_in');
		$sub->select('djax_account_id')->from('ad_exchange_mapping');
		$this->subquery->end_subquery('oxc.account_id', FALSE);
		$this->db->order_by('clientname');
		$query = $this->db->get('rv_clients as oxc');
		
		if($query->num_rows() >0)
		{
			$result = $query->result();
			return $result;
		}else{
			
			return FALSE;
		}
	}
	
	/******************************
	 * Method 		: retreive_referral_commission_earning
	 * @params		: Publisher_id
	 * description 	: Retreive the referral commission for each publisher
	 * *****************************/
	 function retreive_referral_commission_earning($pub_id =FALSE)
	 {
		if(isset($pub_id) && !empty($pub_id))
		{
			$this->db->select_sum('referer_share_amount');
			$this->db->group_by('referer_publisher_id');
			$query = $this->db->get_where('oxm_report',array('referer_publisher_id'=>$pub_id));
			if($query->num_rows()>0)
			{
				$result = $query->row_array();
				$ref_com = $result['referer_share_amount'];
				return $ref_com;
			}else{
				return 0;	
			}
		}else{
			return FALSE;	
		}	
	 }
	 
	 /******************************
	 * Method 		: retreive_affiliate_id
	 * @params		: Publisher_acc_id
	 * description 	: Retreive the referral commission for each publisher
	 * *****************************/
	 function retreive_affiliate_id($pub_acc_id =FALSE)
	 {
		if($pub_acc_id)
		{
			$query = $this->db->select('affiliateid')->get_where('rv_affiliates',array('account_id'=>$pub_acc_id));
			if($query->num_rows()>0)
			{
				$result = $query->row_array();
				return $result['affiliateid'];
			}else{
				return FALSE;	
			}
			
		}else{
			return FALSE;	
		}
	 }
	 
	 /******************************
	 * Method 		: retreive_count_invoices
	 * @params		: None
	 * @return		: Count should be returned
	 * description 	: Retreive the count of the invoice generation
	 * *****************************/
	 function retreive_count_invoices()
	 {
		 $this->db->where('invoice_type','int_pub');
		 $count = $this->db->count_all_results('djax_invoice_generation');
		 return $count;
	 }
	 
	 /*******************************
	 * Method 		: retreive_last_invoice_generation
	 * @param 		: publisher account id
	 * @return 		: return payment_details on TRUE (or) FALSE
	 * Description	: Retreive the overall payment details 
	 * *****************************/
	function retreive_last_invoice_generation()
	{
		
			if($this->retreive_count_invoices() >0)
			{
				$this->db->select('DATE(generation_date) as last_generate_date');
				$this->db->order_by('id desc,generation_date desc');
				$query = $this->db->get_where('djax_invoice_generation',array('invoice_type'=>'int_pub'));	
				if($query->num_rows>0)
				{
					$result = $query->row();	
					return $result->last_generate_date;
				}else{
					return FALSE;	
				}
			}else{
				$this->db->select('DATE(date_created) as last_generate_date');
				$this->db->order_by('user_id asc');
				$query = $this->db->get('rv_users','1');	
				if($query->num_rows>0)
				{
					$result = $query->row();	
					return $result->last_generate_date;
				}else{
					return FALSE;	
				}
			}
	}
	
	/* Referral Id*/
	function fetch_referral_id($acc_id)
	{
				$this->db->select('referral_id');
				$this->db->where('account_id',$acc_id);
				$query = $this->db->get(TAB_AFFILIATE);	
				if($query->num_rows>0)
				{
					$result = $query->row();	
					return $result->referral_id;
				}else{
					return FALSE;	
				}
	}
	
	/***************************** Request Payment by Publisher ************************/
	
	//Generates Invoices Based on the specific time period
	public function request_invoices($account_id=FALSE,$amount=FALSE,$gateway=FALSE)
	{		
		
		//Retreive the minimum publisher payments
		$min_pub_payment = $this->default_configurations->get('pub_min_payment_amount');
		
		//invoice generation count
		$i =1;		
		
		//Retreive publisher name from publisher id
		$pub_acc_id 	= $account_id;
		
		//Retreive the overall payment details for the specific invoice
		$total_pub_payment = $this->retreive_overall_payment_details($pub_acc_id);
		
		$referral_id=$this->fetch_referral_id($pub_acc_id);		
		//Check whether the overall payment is greater than config minimum payment
		//Generate invoice only minimum payment is greater than minimum publisher payment
		if(!empty($total_pub_payment['tot_payment']))
		{
			if( $amount!=FALSE && $amount<=$total_pub_payment['tot_payment']->tot_amount && $amount >= $min_pub_payment)
			{			
				$invoice_code = random_string('numeric',10);
				$invoice_date = date('Y-m-d H:i:s');
				$invoice_tot_amount = $amount;
				$prev_invoice_id = $total_pub_payment['tot_payment']->invoice_id;		
				$start_date = 	date('Y-m-d H:i:s');
				$end_date 	= 	date('Y-m-d H:i:s', strtotime("+30 days"));
				$period_days=	30;	
				$remain_budget	=	$total_pub_payment['tot_payment']->tot_amount - $amount;			
			
				$this->db->trans_begin();
				
				//Creates the insert variables for invoice
				$ins_arr = array('account_id'			=>	$pub_acc_id,
								'invoice_code'			=>	$invoice_code,
								'invoice_date'			=>	$invoice_date,
								'invoice_net_amount '	=>	$invoice_tot_amount,
								'invoice_status'		=>	0,
								'account_id'			=>	$pub_acc_id,
								'invoice_start_date'	=>	$start_date,
								'invoice_end_date'		=>	$end_date,
								'invoice_remaining_amount'	=>	$remain_budget,
								'invoice_period_days'	=>	$period_days,
								'payment_gateway'	=>	$gateway
							);
				$this->db->insert(TAB_INVOICE,$ins_arr);
				
				$last_invoice_id = $this->db->insert_id();				
				
				/* Referral ID */
				if($referral_id!=FALSE)
				{
					$ref_arr = 	array('account_id'=>	$referral_id,
									'invoice_code'			=>	$invoice_code,
									'invoice_date'			=>	$invoice_date,
									'invoice_net_amount '	=>	(5/100)*$amount,
									'invoice_status'		=>	0,
									'invoice_start_date'	=>	$start_date,
									'invoice_end_date'		=>	$end_date,
									'invoice_period_days'	=>	$period_days,
									'referral'=>$pub_acc_id
							    );
							
					$this->db->insert(TAB_INVOICE,$ref_arr);	
					
					$ref_last_invoice_id	=	$this->db->insert_id();
						
					$ref_ins_item_arr 		= 	array('invoice_id'=>	$ref_last_invoice_id,
													  'item_code'	=>	'REF',
													  'item_desc'	=>	'Referral Amount for the period '.$start_date.' to '.$end_date,
													  'amount'		=>	(5/100)*$amount,
													  'currency'	=>	$this->config->item('currency')	
												 );
					$this->db->insert(TAB_INVOICE_ITEM,$ref_ins_item_arr);
				}
				
				//Inserts the invoice item into TAB_INVOICE_ITEM
				$ins_item_arr = array();
				
				$ins_item_arr[] = array('invoice_id'=>	$last_invoice_id,
									  'item_code'	=>	'ERN',
									  'item_desc'	=>	'Earnings for the period '.$start_date.' to '.$end_date,
									  'amount'		=>	$total_pub_payment['tot_payment']->cur_earn,
									  'currency'	=>	$this->config->item('currency')	
									 );
									 
				if($total_pub_payment['tot_payment']->cry_bal >0)
				{
					$ins_item_arr[] = array('invoice_id'	=>	$last_invoice_id,
											'item_code'		=>	'CRYBAL',
											'item_desc'		=>	lang('previous_balance'), //Previous Balance
											'amount'		=>	$remain_budget, //$total_pub_payment['tot_payment']->cry_bal,
											'currency'		=>	$this->config->item('currency')	
									 ); 	
				}		
									 
				
				$this->db->insert_batch(TAB_INVOICE_ITEM,$ins_item_arr);
				
				/*if($prev_invoice_id!=0)
				{
					//Cancel the previous invoice
					$this->db->update(TAB_INVOICE,array('invoice_status'=>2),array('invoice_id'=>$prev_invoice_id));	
				}*/			
				
				if ($this->db->trans_status() === FALSE)
				{
					$this->db->trans_rollback();
				}
				else
				{
					$this->db->trans_commit();
				}	
				
				//Insert the djax invoice generation count
				$insert_generated_list = array('no_of_invoices'	=>	$i,
											   'generation_date'=>	date('Y-m-d H:i:s'),
											   'invoice_type'	=>	'int_pub'
										);
										
				$this->db->insert('djax_invoice_generation',$insert_generated_list);		
				$this->memcached_library->set(REQUEST_PAYOUT,'1');
				return TRUE;
			}
			else
			{
				return FALSE;
			}		
		}
		else
		{
			return FALSE;
		}
	}
	
}
