<?php
class Do_geo extends CI_Model
{

	/*
	* 
	* name: fetch
	* @param : 
	* @return :all the list of geo settings country details
	* 
	*/
	public function fetch()
	{
		
		
		$key = FETCH_ALL_GEO_SETTINGS;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_ADMIN_GEO_SETTINGS);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		$this->db->select('geo.id,geo.status,geo.is_deleted,geo.cpm_value,cty.name as country_name');
		$this->db->where('geo.is_deleted',0);
		#$this->db->where('geo.status',0);
		$this->db->from(TAB_GEO_SETTING.' as geo ');
		$this->db->join(TAB_TARG_COUNTRY.' as cty ', 'cty.value=geo.value');
		$this->db->order_by('geo.id','desc');
		$query = $this->db->get();
		#echo $this->db->last_query();exit;
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			$i=0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}	
					
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set(FETCH_ADMIN_GEO_SETTINGS,'2');
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
		}
		else
		{
			return FALSE;
		}
	}
}
	
	/*
   * 
   * name: block_geo_data
   * @param : osid
   * @return : osid
   * 
   */
	public function block_geo_data($id=FALSE) 
	{
		if($id)
		{  
		    $data=array('status'=>1);
		    $this->db->where('id', $id);
			$this->db->update(TAB_GEO_SETTING,$data);
			$this->memcached_library->set(FETCH_ADMIN_GEO_SETTINGS,'1');
			return $id;
		}
	}
   
   /*
   * 
   * name: block_geo_data
   * @param : osid
   * @return : osid
   * 
   */
	public function unblock_geo_data($id=FALSE) 
   {
		if($id)
	    {  
		    $data=array('status'=>0);
		    $this->db->where('id', $id);
			$this->db->update(TAB_GEO_SETTING,$data);
			$this->memcached_library->set(FETCH_ADMIN_GEO_SETTINGS,'1');
			return $id;
		}
   }
   
   /*
   * 
   * name: add_os
   * @param : osname,osvalue
   * @return :lastinsertid
   * 
   */
	
	public function add_geo($cpm_val=FALSE,$cty_value=FALSE){
		
		$osObj = array(
							"cpm_value" => $cpm_val,
							"value"=> $cty_value,
						);
						
		if($this->db->insert(TAB_GEO_SETTING,$osObj)){
			$this->memcached_library->set(FETCH_ADMIN_GEO_SETTINGS,'1');
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
   * 
   * name: fetch_select
   * @param : category_id
   * @return :categoryname,categoryvalue
   * 
   */
	public function fetch_select($geo_id=FALSE)
	{ 
		$this->db->select('geo.value,geo.id,geo.status,geo.is_deleted,geo.cpm_value,cty.name as country_name');
		$this->db->where('geo.id',$geo_id);
		$this->db->from(TAB_GEO_SETTING.' as geo ');
		$this->db->join(TAB_TARG_COUNTRY.' as cty ', 'cty.value=geo.value');
		$query = $this->db->get();
		#echo $this->db->last_query();exit;
		if($query->num_rows()>0)
		{
			$result=$query->result_array();
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	function geo_list_sett($table_name,$value,$id)
	{
		$this->db->select('*');	
		$this->db->where("value",$value);
		$this->db->where_not_in('id',$id);
		$query_count	=	$this->db->get($table_name)->num_rows();
		
		if($query_count)
		{			
			return $query_count;
		}
		else
		{
			return FALSE;
		} 	
	}
	
	function update_geo_list($up_val=FALSE,$geo_id=FALSE)
	{
		$this->db->where('id',$geo_id);
		$this->db->update(TAB_GEO_SETTING,$up_val);
		$this->memcached_library->set(FETCH_ADMIN_GEO_SETTINGS,'1');
		return TRUE;
	}
	
	public function delete_geo_list($id=FALSE)
	{
		if($id)
		{
			$this->db->where('id', $id);
			$this->db->delete(TAB_GEO_SETTING);
			$this->memcached_library->set(FETCH_ADMIN_GEO_SETTINGS,'1'); 
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->trans_commit();
			}
		}
		else
		{
			return FALSE;	
		}
    } 

}
