<?php

class Do_creative extends CI_Model
{

	 /*

	 * 

	 * name: fetch

	 * @param :

	 * @return : $result

	 * 

	 * Lists all the web creative of an advertiser

	 */

	function fetch($account_id=false,$campaign_id=false,$adma_id=false)

	{	
		
		$adma_id = ($adma_id == false)?'0':'1';
		$key = 'fetch_report_creative_'.$account_id.'_'.$campaign_id.'_'.$adma_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes 	= 	$this->memcached_library->get(FETCH_CREATIVES);
		
		/*if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			log_message('error','memone');
			return $ret;
		}*/
		//else{ //sql else part commented
       
			$SQL = "
					SELECT @i := @i -1 AS row_number,c.*
					FROM
					(SELECT oxb.bannerid,oxb.campaignid,oxb.weight,oxc.dj_is_rtb_campaign,oxc.campaignname,oxb.description,oxb.filename,oxb.storagetype,oxb.contenttype,oxb.width,oxb.height,oxb.dj_banner_type,REPLACE(oxb.url,' ','%20') as url,oxb.dj_admin_approve,oxb.imageurl,oxbe.vast_video_clickthrough_url,oxb.dj_disable, sum(rvh.dj_total_revenue) as total_spend,

					CASE

						WHEN oxb.`dj_banner_type` = 'W_IMG'  THEN 'Image'

						WHEN oxb.`dj_banner_type` = 'W_URL' THEN 'URL'

						WHEN oxb.`dj_banner_type` = 'W_SQL'  THEN 'Database'

						WHEN oxb.`dj_banner_type` = 'W_HTML'  THEN 'HTML'
						
						WHEN oxb.`dj_banner_type` = 'W_TB'  THEN 'Topbar'

						WHEN oxb.`dj_banner_type` = 'V_IN'  THEN 'Inline'
						
						WHEN oxb.`dj_banner_type` = 'V_RD'  THEN 'Read video'
						
						WHEN oxb.`dj_banner_type` = 'V_SM'  THEN 'Small video'
						
						WHEN oxb.`dj_banner_type` = 'V_HEAD'  THEN 'Head video'
						
						WHEN oxb.`dj_banner_type` = 'V_BOX'  THEN 'Box video'

						WHEN oxb.`dj_banner_type` = 'V_OL'  THEN 'Overlay'
						
						WHEN oxb.`dj_banner_type` = 'W_POP'  THEN 'Pop-under'
						
						WHEN oxb.`dj_banner_type` = 'W_LAY'  THEN 'Layer/Interstitial'
						
						WHEN oxb.`dj_banner_type` = 'W_GB'  THEN 'Gamebox'
						
						WHEN oxb.`dj_banner_type` = 'W_BB'  THEN 'Bannerbox'
						
						WHEN oxb.`dj_banner_type` = 'W_SL'  THEN 'Slider'
						
						WHEN oxb.`dj_banner_type` = 'W_CF'  THEN 'Catfish'
						
						WHEN oxb.`dj_banner_type` = 'W_SS'  THEN 'Site-Skin'
						
						WHEN oxb.`dj_banner_type` = 'W_TAB'  THEN 'Tab-Image'
						
						WHEN oxb.`dj_banner_type` = 'W_EP'  THEN 'Exit Popunder'				

						WHEN oxb.`dj_banner_type` = 'M_MR_INT'  THEN 'Interstital'

						WHEN oxb.`dj_banner_type` = 'M_MR_EXP'  THEN 'Expand'  

						WHEN oxb.`dj_banner_type` = 'M_MR_REV'  THEN 'Reveal'

						WHEN oxb.`dj_banner_type` = 'M_RS_FS'  THEN 'Filmstrip'

						WHEN oxb.`dj_banner_type` = 'M_RS_FL'  THEN 'Flex'

						WHEN oxb.`dj_banner_type` = 'M_RS_PL'  THEN 'Pull'

						WHEN oxb.`dj_banner_type` = 'M_RS_ADH'  THEN 'Adhesion'

						WHEN oxb.`dj_banner_type` = 'M_RS_SL'  THEN 'Slider'

						WHEN oxb.`dj_banner_type` = 'M_IMG'  THEN 'Mob-Image'

						WHEN oxb.`dj_banner_type` = 'M_TEXT'  THEN 'Mob-Text'
						
						WHEN oxb.`dj_banner_type` = 'M_MR_NF'  THEN 'Notification'
						
						WHEN oxb.`dj_banner_type` = 'M_MR_DLG'  THEN 'Dialog'
						
						WHEN oxb.`dj_banner_type` = 'W_TEXT'  THEN 'Text'
						WHEN oxb.`dj_banner_type` = 'WEB_AD_GOOGLE'  THEN 'Google Text'

						WHEN oxb.`dj_banner_type` = 'W_SWF'  THEN 'Flash'
						
						WHEN oxb.`dj_banner_type` = 'M_CF'  THEN 'Mob-Catfish'						
						WHEN oxb.`dj_banner_type` = 'M_SL'  THEN 'Mob-Slider'
						WHEN oxb.`dj_banner_type` = 'A_CF'  THEN 'App-Footer'
						WHEN oxb.`dj_banner_type` = 'A_INT'  THEN 'App-Interstitial'
						WHEN oxb.`dj_banner_type` = 'W_NA'  THEN 'Native'
						WHEN oxb.`dj_banner_type` = 'V_HTML' THEN 'HTML5 video'
						WHEN oxb.`dj_banner_type` = 'A_HTML' THEN 'App-HTML5 video'
						WHEN oxb.`dj_banner_type` = 'W_DIR'  THEN 'Direct Link'		
						
					END as creative_type

					FROM 

						".TAB_BANNERS." AS oxb
					LEFT JOIN ".TAB_BAN_VAST_ELE." AS oxbe ON oxb.bannerid=oxbe.banner_id
					JOIN ".TAB_CAMPAIGNS." as oxc ON oxc.campaignid=oxb.campaignid				
					JOIN ".TAB_CLIENTS." as oxcl ON oxcl.clientid=oxc.clientid
					LEFT JOIN ".TAB_DATA_SUM_AD_HOURLY." as rvh on rvh.creative_id=oxb.bannerid	 				
					WHERE 

						 oxb.dj_is_deleted =0 AND oxc.dj_is_deleted =0 AND oxcl.dj_is_deleted =0 AND dj_admin_approve !=-1 AND oxb.dj_admarket_status=".$adma_id;

					if($account_id!=false)
					{
						$SQL	.=	" AND dj_account_id=".$account_id;
					}
					else
					{
						if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
				
							$SQL	.=" AND dj_account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
						else:						
							$SQL	.=" AND dj_account_id!=".$this->user_authentication->default_advertiser_account_id;
						endif;
						
						$SQL	.=" AND oxb.dj_admin_approve=1 AND oxb.dj_is_direct=0";
					}
					
					if($campaign_id)
					{
						//$campaign_id=implode(",",$filter['campaign']);
						//$SQL	.=	" AND oxb.campaignid in ".$campaign_id;

						$SQL	.=	" AND oxb.campaignid = ".$campaign_id;
					}
					
					$in_sel= "select count(*) FROM
							".TAB_BANNERS." AS oxb
					LEFT JOIN ".TAB_BAN_VAST_ELE." AS oxbe ON oxb.bannerid=oxbe.banner_id
					JOIN ".TAB_CAMPAIGNS." as oxc ON oxc.campaignid=oxb.campaignid				
					JOIN ".TAB_CLIENTS." as oxcl ON oxcl.clientid=oxc.clientid 	
							
					WHERE 

						 oxb.dj_is_deleted =0 AND oxc.dj_is_deleted =0 AND oxcl.dj_is_deleted =0 AND dj_admin_approve !=-1 AND oxb.dj_admarket_status=".$adma_id;

					if($account_id!=false)
					{
						$in_sel	.=	" AND dj_account_id=".$account_id;
					}
					else
					{
						if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
				
							$in_sel	.=" AND dj_account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
						else:						
							$in_sel	.=" AND dj_account_id!=".$this->user_authentication->default_advertiser_account_id;
						endif;
						
						$in_sel	.=" AND oxb.dj_admin_approve=1 AND oxb.dj_is_direct=0";
					}
					
					if($campaign_id)
					{
						$in_sel	.=	" AND oxb.campaignid=".$campaign_id;
					}				
					

			$SQL .= " GROUP BY oxb.bannerid ORDER BY oxb.bannerid DESC) as c,(SELECT @i := ($in_sel)+1) as rowcount" ;

			
			$query = $this->db->query($SQL);
		//	log_message('error','threee');
          //  log_message('error',$this->db->last_query());
           
			$result = $query->result_array();
			$SQL2="SELECT ad_id as bannerid, SUM(`dj_total_revenue`) as today_spend FROM rv_data_summary_ad_hourly WHERE DATE(`date_time`) >= DATE_FORMAT(CURDATE(),'%d/%m/%y %h:%i:%s') GROUP BY `bannerid` ";

			$querys = $this->db->query($SQL2);
			$results = $querys->result_array();
					 
			for($i=0;$i<count($result);$i++)
			{
				for($x=0;$x<count($results);$x++)
				{
					if($result[$i]['bannerid']==$results[$x]['bannerid'])
					{
						$result[$i]['today_spend']=$results[$x]['today_spend']; 
					}
					else {$result[$i]['today_spend']=0;}
				}
			} 
			if($result)
			{			
				return $result;
				/*if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(FETCH_CREATIVES,'2');
					$set = $this->memcached_library->get($key);	
					
				}
				else
					return $result;*/
			}
			else

				return FALSE;

	//	} //sql else part commented
		
	}
	
	
	/*

	 * 

	 * name: fetch_campaign_by_creative

	 * @param :

	 * @return : $result

	 * 

	 * fetch a campaign of an advertiser

	 */
	 
	 function fetch_campaignid_creative($creative_id=false)
	 {
		
		 $dj =  $this->db->query('select campaignid,description,dj_disable from '.TAB_BANNERS.' where bannerid='.$creative_id);
		 return $dj->result_array();
	 }
	
	
	function fetch_language($account_id=false)
	{
		$key = 'fetch_lang_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
				
		if($ret  && $mem_cache=='enable')
		{
			return $ret;
		}
		else
		{
		
			$this->db->select('*');		
			$query = $this->db->get(TAB_LANG);		
			$result = $query->result_array();
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			}
				
		}
	}
	
	function fetch_keyword($account_id=false)
	{		
		$key = 'fetch_group_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADV_KEYWORD_LIST);
		
		if($ret  && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
			
			
			$this->db->select('*');		

			if($account_id!=false)
			{
				$this->db->where('account_id ',$account_id);
			}
			
			$query = $this->db->get(TAB_TARG_KEYWORD);		

			$result = $query->result_array();
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$this->memcached_library->set(ADV_KEYWORD_LIST,'2');
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			}
				
		}
		
	}
	
	
		
	/* fetching group*/
	
	function fetch_group($account_id=false)
	{		
		$key = 'fetch_group_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(ADV_GROUP_LIST);
		
		if($ret  && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
			
			$this->db->select('*');		

			if($account_id!=false)
			{
				$this->db->where('account_id ',$account_id);
			}
			
			$query = $this->db->get(TAB_GROUP);		

			$result = $query->result_array();
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$this->memcached_library->set(ADV_GROUP_LIST,'2');
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			}
				
		}
		
	}
	
	
	function fetch_selected_group($account_id=false,$campaign_id=false)
	{
			$this->db->select('group_id');		

			$this->db->where('campaign_id ',$campaign_id);
			
			$query = $this->db->get(TAB_GROUP_ASSOC);	

			$result = $query->result_array();

			if($result)

				return $result;

			else

				return FALSE;
		
	}

	 /*

	 * 

	 * name: fetch_creative

	 * @param :

	 * @return : $result

	 * 

	 * Lists a web creative of an advertiser

	 */

	function fetch_creative($creative_id=false)
	{
		 
		$key = 'creative_list_'.$creative_id;
		$ret = $this->memcached_library->get($key);
		
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_MODAL_CREATIVES);
	
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
			if($creative_id)

			{
				$SQL	=	"SELECT contenttype,bannerid,campaignid,description,statustext,filename,storagetype,width,height,imageurl,bannertext,htmltemplate,dj_banner_type,dj_account_id,dj_admin_approve,dj_image_path,backgroundcolor,fontcolor,embed, REPLACE(url ,' ', '%20') as url 
							FROM ".TAB_BANNERS."
							WHERE 1 AND bannerid =".$creative_id." AND dj_is_deleted =0 AND dj_admin_approve != '-1' ORDER BY dj_added_date ";
				
				$query = $this->db->query($SQL);
				$result = $query->result_array();

				if($result)
				{
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set(FETCH_MODAL_CREATIVES,'2');
						$this->memcached_library->set($key,$result,$account_type);	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else
						return $result;
				}
				else

					return FALSE;

			}

			else

				return FALSE;

		}
	}
	
	
	/*

	 * 

	 * name: fetch_demo_creative

	 * @param :

	 * @return : $result

	 * 

	 * Lists a web creative of an advertiser

	 */
 function fetch_demo_creative($campaign_id=false)
	 {  
		if($campaign_id)
		{  
			/*$this->db->select('contenttype,bannerid,campaignid,description,filename,storagetype,url,width,height,imageurl,bannertext,htmltemplate,dj_banner_type,dj_account_id,dj_admin_approve,dj_image_path,backgroundcolor');		
				
			$this->db->where('bannerid ',$creative_id);

			$this->db->where('dj_is_deleted ','0');
			* 
			
			$this->db->where('dj_admin_approve !=','-1');

			$this->db->order_by('dj_added_date ');*/
			
			$banner_result=$this->db->query('select oxc.campaignname as campaignname ,
			oxc.campaignid as campaignid,
			oxb.bannerid as bannerid,
			oxb.width as width,
			oxb.height as height,
			oxb.description as description,
			oxb.filename as filename,			
			oxb.dj_banner_type as banner_type,
			0 as display_type,
			0 as imageid,
			oxb.bannerid as bannerid,
			oxb.bannertext as bannertext,
			oxb.contenttype as contenttype ,
			oxb.htmltemplate as htmltemplate,
			oxb.htmlcache as htmlcache,
			0 as position,
			0 as icon_type,
			0 as dj_video_thumb_img,
			0 as dj_content_video_url,
			0 as dj_content_ad_message,
			0 as dj_social_networking,
			0 as display_size,
			oxb.storagetype as storagetype,
			oxc.dj_favourite_status as favourite_status,
			oxb.dj_image_path as dj_image_path,
			oxb.url as url,
			oxb.imageurl as imageurl,
			oxb.backgroundcolor,
			oxb.fontcolor 
			from '.TAB_BANNERS.' AS oxb join '.TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxb.campaignid ='.$campaign_id.' AND oxb.dj_is_deleted="0" AND oxc.dj_is_deleted="0"');  
//return $this->db->last_query();
			
			//log_message("error",$this->db->last_query());
			if($banner_result->num_rows()>0)
			{
				$result = $banner_result->result_array();
				return $result;		
			}
			else
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}

	}
	function fetch_demo_additional_creative($creative_id=false)
	 {  
		if($creative_id)
		{  
			/*$this->db->select('contenttype,bannerid,campaignid,description,filename,storagetype,url,width,height,imageurl,bannertext,htmltemplate,dj_banner_type,dj_account_id,dj_admin_approve,dj_image_path,backgroundcolor');		
				
			$this->db->where('bannerid ',$creative_id);

			$this->db->where('dj_is_deleted ','0');
			
			$this->db->where('dj_admin_approve !=','-1');

			$this->db->order_by('dj_added_date ');*/
			
			$banner_result=$this->db->query('
			select 
			dab.width as width ,
			dab.height as height,			
			dab.file_path as filename,			
			dab.dj_image_path as image_path,			
			dab.display_type as display_type,
			dab.image_id as imageid,
			dab.banner_id as bannerid,			
			dab.position as position,
			dab.icon_type as icon_type,
			dab.dj_video_thumb_img as dj_video_thumb_img,
			dab.dj_content_video_url as dj_content_video_url,
			dab.dj_content_ad_message as dj_content_ad_message,
			dab.dj_social_networking as dj_social_networking,
			dab.display_size as display_size
		
			from '.TAB_BAN_DEPEND.' AS dab WHERE dab.banner_id='.$creative_id.'');
            //  log_message("error",'aaaaaaaaaa');
            //  log_message("error",$this->db->last_query());
			
			if($banner_result->num_rows()>0)
			{
				$result = $banner_result->result_array();
				return $result;		
			}
			else
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}

	}
	 /*

	 * 

	 * name: fetch_creative_dependiences

	 * @param :

	 * @return : $result

	 * 

	 * Lists a creative dependiences if exist

	 */

	 function fetch_creative_dependiences($creative_id=false)

	 {
		 
		$key = 'fetch_creative_dependiences_'.$creative_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		

		if($creative_id)

		{

			$this->db->select('file_path,content_type,dj_image_path');		

			$this->db->where('banner_id ',$creative_id);

			$query = $this->db->get(TAB_BAN_DEPEND);



			$result = $query->result_array();

			if($result)
			{
			if($mem_cache=='enable' )
			{
			$account_type=$this->user_authentication->account_type;
			$this->memcached_library->set($key,$result,$account_type);	
			$set = $this->memcached_library->get($key);	
			return $set;
			}
			else{
			return $result;
			}
			}
			else

				return FALSE;

		}

		else

			return FALSE;

		

	}
}

	 /*

	 * 

	 * name: fetch_creative_approval_type

	 * @param :

	 * @return : $result

	 * 

	 * Says what type of approval is set in the application 

	 */

	 function fetch_creative_approval_type()

	 {

			$this->db->select('creative_approval_type');		

			$query = $this->db->get(TAB_APP_CONFIG);

			$result = $query->result_array();

			if($query->num_rows()>0)

				return $result[0]['creative_approval_type'];

			else

				return FALSE;

	}
	
	
	 function fetch_creative_names($cam_id=false)

	 {
		 if (is_array($cam_id))
			{
              $campaign_id = "'" . implode ( "', '", $cam_id ) . "'";
			}
			else
			{
			  $campaign_id =$cam_id;	
			 }
             // $campaign_id = "'" . implode ( "', '", $cam_id ) . "'";
              //$campaign_id=implode(",",$cam_id);

$sql = "					SELECT @i := @i -1 AS row_number,c.*
					FROM
					(SELECT oxb.bannerid,oxb.campaignid,oxb.weight,oxc.campaignname,oxb.description,oxb.filename,oxb.storagetype,oxb.contenttype,oxb.width,oxb.height,oxb.dj_banner_type,REPLACE(oxb.url,' ','%20') as url,oxb.dj_admin_approve,oxb.imageurl,oxb.dj_disable, 

					CASE

						WHEN oxb.`dj_banner_type` = 'W_IMG'  THEN 'Image'

						WHEN oxb.`dj_banner_type` = 'W_URL' THEN 'URL'

						WHEN oxb.`dj_banner_type` = 'W_SQL'  THEN 'Database'

						WHEN oxb.`dj_banner_type` = 'W_HTML'  THEN 'HTML'
						
						WHEN oxb.`dj_banner_type` = 'W_TB'  THEN 'Topbar'

						WHEN oxb.`dj_banner_type` = 'V_IN'  THEN 'Inline'
						
						WHEN oxb.`dj_banner_type` = 'V_RD'  THEN 'Read video'
						
						WHEN oxb.`dj_banner_type` = 'V_SM'  THEN 'Small video'
						
						WHEN oxb.`dj_banner_type` = 'V_HEAD'  THEN 'Head video'
						
						WHEN oxb.`dj_banner_type` = 'V_BOX'  THEN 'Box video'

						WHEN oxb.`dj_banner_type` = 'V_OL'  THEN 'Overlay'
						
						WHEN oxb.`dj_banner_type` = 'W_POP'  THEN 'Pop-under'
						
						WHEN oxb.`dj_banner_type` = 'W_LAY'  THEN 'Layer/Interstitial'
						
						WHEN oxb.`dj_banner_type` = 'W_GB'  THEN 'Gamebox'
						
						WHEN oxb.`dj_banner_type` = 'W_BB'  THEN 'Bannerbox'
						
						WHEN oxb.`dj_banner_type` = 'W_SL'  THEN 'Slider'
						
						WHEN oxb.`dj_banner_type` = 'W_CF'  THEN 'Catfish'
						
						WHEN oxb.`dj_banner_type` = 'W_SS'  THEN 'Site-Skin'
						
						WHEN oxb.`dj_banner_type` = 'W_TAB'  THEN 'Tab-Image'

						WHEN oxb.`dj_banner_type` = 'M_MR_INT'  THEN 'Interstital'

						WHEN oxb.`dj_banner_type` = 'M_MR_EXP'  THEN 'Expand'

						WHEN oxb.`dj_banner_type` = 'M_MR_REV'  THEN 'Reveal'

						WHEN oxb.`dj_banner_type` = 'M_RS_FS'  THEN 'Filmstrip'

						WHEN oxb.`dj_banner_type` = 'M_RS_FL'  THEN 'Flex'

						WHEN oxb.`dj_banner_type` = 'M_RS_PL'  THEN 'Pull'

						WHEN oxb.`dj_banner_type` = 'M_RS_ADH'  THEN 'Adhesion'

						WHEN oxb.`dj_banner_type` = 'M_RS_SL'  THEN 'Slider'

						WHEN oxb.`dj_banner_type` = 'M_IMG'  THEN 'Mob-Image'

						WHEN oxb.`dj_banner_type` = 'M_TEXT'  THEN 'Mob-Text'
						
						WHEN oxb.`dj_banner_type` = 'M_MR_NF'  THEN 'Notification'
						
						WHEN oxb.`dj_banner_type` = 'M_MR_DLG'  THEN 'Dialog'
						
						WHEN oxb.`dj_banner_type` = 'W_TEXT'  THEN 'Text'

						WHEN oxb.`dj_banner_type` = 'W_SWF'  THEN 'Flash'
						
						WHEN oxb.`dj_banner_type` = 'M_CF'  THEN 'Mob-Catfish'						
						WHEN oxb.`dj_banner_type` = 'M_SL'  THEN 'Mob-Slider'
						WHEN oxb.`dj_banner_type` = 'A_CF'  THEN 'App-Footer'
						WHEN oxb.`dj_banner_type` = 'A_INT'  THEN 'App-Interstitial'
						WHEN oxb.`dj_banner_type` = 'W_NA'  THEN 'Native'
						WHEN oxb.`dj_banner_type` = 'V_HTML' THEN 'HTML5 video'
						WHEN oxb.`dj_banner_type` = 'A_HTML' THEN 'App-HTML5 video'
						WHEN oxb.`dj_banner_type` = 'W_DIR'  THEN 'Direct Link'		
						
					END as creative_type

					FROM rv_banners as oxb 
					JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid
					WHERE oxb.campaignid IN (".$campaign_id.") AND oxb.dj_is_deleted = 0";
					
					$in_sel = "select count(*) FROM  rv_banners as oxb 
					JOIN rv_campaigns as oxc ON oxc.campaignid=oxb.campaignid
					WHERE oxb.campaignid IN (".$campaign_id.") AND oxb.dj_is_deleted = 0";
				$sql .=	") as c,(SELECT @i := ($in_sel)+1) as rowcount";
				//return $sql;exit();
					
        $query = $this->db->query($sql); 
        return $query->result();
        
        
        /*					
			
           //$campaign_id=implode(",",$filter['campaign']);
						//$SQL	.=	" AND oxb.campaignid in ".$campaign_id;

			$this->db->select("*");	
			$this->db->where('campaignid',$cam_id);	
			$this->db->where('dj_is_deleted','0');		

			$query = $this->db->get(TAB_BANNERS);

			$result = $query->result_array();

			if($query->num_rows()>0)

				return $result;

			else

				return FALSE;*/

	}

	 /*

	 * 

	 * name: delete_creative

	 * @param : creative_id

	 * @return : $result

	 * 

	 * Delete the creative

	 */

	 function delete_creative($creative_id=false)
	 {

		if($creative_id)

		{

			$this->db->trans_start();

			

			$this->db->where('bannerid',$creative_id); 

			$this->db->update(TAB_BANNERS,array('dj_is_deleted'=>'1'));

			$this->memcached_library->set(FETCH_CREATIVES,'1');

			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();
				
				return true;

		}

		else

			return FALSE;

		

	}

	/*

	 * 

	 * name: fetch_campaign

	 * @param :

	 * @return : $result

	 * 

	 * Lists a campaign of an advertiser

	 */

	 function fetch_campaign($account_id=false,$campaign_type=false,$admarket_id)

	 {
	 	
		$adma_id = ($admarket_id == false)?'0':'1';
		$key = 'campaign_list_'.$account_id.'_'.$campaign_type.'_'.$adma_id;
		$ret = $this->memcached_library->get($key);
		$msg_type = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $msg_type=='enable' )
		{
			return $ret;
		}
		else{

			$this->db->select('oxc.campaignid, oxc.campaignname');

			$this->db->join(TAB_CLIENTS.' as oxcl', 'oxcl.clientid=oxc.clientid AND oxcl.dj_is_deleted=0');
				
			$this->db->join(TAB_AGENCY.' as oxa', 'oxa.agencyid=oxcl.agencyid');	

			//$this->db->join(TAB_GROUP_ASSOC.' as dga', 'dga.campaign_id=oxc.campaignid','left');

			$this->db->where('oxc.dj_is_deleted','0');
			$this->db->where('oxc.dj_is_approved','0');
			$this->db->where('oxc.dj_is_admarket',$adma_id);

				if($account_id!=false)
				{
					$this->db->where('oxcl.account_id', $account_id);
				}
				else
				{
					if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
					
						$adv	=	explode(',',$this->user_authentication->manager_adv_pub_id);
					
						$this->db->where_in('oxcl.account_id',$adv);
					else:
						$this->db->where_not_in('oxcl.account_id', $this->user_authentication->default_advertiser_account_id);
					endif;
					
					$this->db->where('oxc.dj_is_direct', '0');
				}
		
				if($campaign_type):
					if($campaign_type=='WEB' || $campaign_type=='TABLET'):
						$this->db->where_not_in('oxc.dj_targetting_type', 'MOBILE');		
					elseif($campaign_type=='MOBILE'):
						$this->db->where_not_in('oxc.dj_targetting_type', 'WEB');		
					endif;
					
				endif;	

			$this->db->order_by('oxc.dj_added_date '); 
			
			/*$this->db->order_by('oxc.campaignname', 'ASC'); DAC020 */

			$query = $this->db->get(TAB_CAMPAIGNS.' as oxc');
						
			$result = $query->result_array(); 
			//log_message('error','query_pr_jtest');
			//log_message('error',$this->db->last_query());
			if($result)
			{  
				if($msg_type=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{ 		
				return $result;
				}
			}
			
			else
				
			return FALSE;
			
			}
		//if($result)

			//return $result;

		//else

			//return FALSE;
	}

	/******************** Direct Campaign Fetch ********************/
	// LEFT JOIN djax_direct_campaign_payment as c ON a.campaignid=c.campaign_id

	function fetch_directcampaigns($is_approve=false)
	{
		$key = 'fetch_directcampaigns_'.$is_approve;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_DIRECT_CAMPAIGN);
		if($ret && $mem_cache=='enable' && $check_db_changes !='1' )
		{
			return $ret;
		}
		else{ 
		
		/*$SQL = "SELECT a.campaignid, a.campaignname, a.dj_targetting_type, a.revenue_type as revenue_type, a.dj_campaign_budget, a.status, c.currency, a.dj_company_name as name, a.dj_email_address as email, c.name as payname, c.email as payemail, c.id as id,
			
			CASE
			WHEN `dj_targetting_type` = 'WEB'  THEN 'Web campaign'
			WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile campaign'
			END as formated_dj_targetting_type,
			
			CASE
				WHEN `revenue_type` = '1' THEN 'CPM'
				WHEN `revenue_type` = '2' THEN 'CPC'
				WHEN `revenue_type` = '3' THEN 'CPA'
			END as formated_revenue_type,
			
			CASE
				WHEN a.status = '0' THEN 'Running'
				WHEN a.status = '1' THEN 'Paused'
				WHEN a.status = '2' THEN 'Awaiting'
				WHEN a.status = '3' THEN 'Completed'
				WHEN a.status = '4' THEN 'Halt'
			END as formated_status
			
			FROM 
				".TAB_CAMPAIGNS." as a
			
			
			
			JOIN djax_direct_campaign_payment as c ON a.campaignid=c.campaign_id
			
			WHERE 
				a.dj_is_deleted =0 and a.dj_is_direct=1 and a.dj_is_checkout=1 ";
				
			
			if($is_approve)
			{
				$SQL.=" and a.dj_is_approved='0' ";
			}
			else
			{
				$SQL.=" and a.dj_is_approved='1' ";
			}
			$SQL.=" GROUP BY c.campaign_id ORDER BY a.dj_added_date";*/
			
				
				$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT a.campaignid, a.campaignname, a.dj_targetting_type, a.revenue_type as revenue_type, a.dj_campaign_budget, a.status, c.currency, a.dj_company_name as name, a.dj_email_address as email, c.name as payname, c.email as payemail, c.id as id,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile'
					WHEN `dj_targetting_type` = 'ALL'  THEN 'All'
					WHEN `dj_targetting_type` = 'TABLET'  THEN 'Tablet'
				END as formated_dj_targetting_type,			
				CASE
					WHEN `revenue_type` = '1'  THEN 'CPM'
					WHEN `revenue_type` = '2'  THEN 'CPC'					
					WHEN `revenue_type` = '3'  THEN 'CPA'
					WHEN `revenue_type` = '4'  THEN 'CPL'
					WHEN `revenue_type` = '5'  THEN 'CPS'					
					WHEN `revenue_type` = '6'  THEN 'CPI'					
					WHEN `revenue_type` = '7'  THEN 'CPV'
				END as formated_revenue_type,
				CASE
					WHEN a.`status` = '0' THEN 'Running'
					WHEN a.`status` = '1' THEN 'Stopped'
					WHEN a.`status` = '2' THEN 'Awaiting'
					WHEN a.`status` = '3' THEN 'Completed'
					WHEN a.`status` = '4' THEN 'Halt'
					WHEN a.`status` = '5' THEN 'Draft'
					WHEN a.`status` = '6' THEN 'Moderation'
					WHEN a.`status` = '7' THEN 'Rejected'
					WHEN a.`status` = '8' THEN 'Paused'
				END as formated_status
				FROM ".TAB_CAMPAIGNS." as a JOIN djax_direct_campaign_payment as c ON a.campaignid=c.campaign_id			
				WHERE a.dj_is_deleted =0 and a.dj_is_direct=1 and a.dj_is_checkout=1 ";
				if($is_approve)
				{ 
					$SQL .=	" and a.dj_is_approved='1'";
				}
				else
				{
					$SQL .=	" and a.dj_is_approved='0'";
				}
				
				$in_sel = "SELECT count(*)FROM ".TAB_CAMPAIGNS." as a JOIN djax_direct_campaign_payment as c ON a.campaignid=c.campaign_id WHERE a.dj_is_deleted =0 and a.dj_is_direct=1 and a.dj_is_checkout=1 ";
				
				if($is_approve)
				{ 
					$in_sel .=	" and a.dj_is_approved='1'";
				}
				else
				{
					$in_sel .=	" and a.dj_is_approved='0'";
				}
				
				$SQL.= " GROUP BY c.campaign_id ORDER BY a.dj_added_date DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 
			
					 
			$query 	= 	$this->db->query($SQL);

			$result = 	$query->result_array();
			
			if($result)
			{			
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(FETCH_DIRECT_CAMPAIGN,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
				return $result;
				}
			}
			else{
				return false;
			}
		}
	}

	/******************** Direct Campaign Fetch ********************/	
	
	public function fetch_creative_by_approve($approve_status='NAPPROVE',$agency_id,$adv_account_id=FALSE)
    {  

	
		if($approve_status === 'NAPPROVE'){
			$admin_approve = 0;
		}
		else if($approve_status === 'APPROVED_TODAY')
		{
			$admin_approve = 1;
			$date = date("Y-m-d");
		}
		 
		$SQL = "
				SELECT oxb.`dj_added_date` as last_create_date, (
						SELECT count(*) FROM 
							".TAB_BANNERS." as oxb
							JOIN ".TAB_CAMPAIGNS." as oxc ON oxb.campaignid=oxc.campaignid
							JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxb.dj_account_id
						WHERE
						oxcl.agencyid={$agency_id} ";
						
		if($adv_account_id != FALSE){
			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 
		}		
		
		if($approve_status === 'APPROVED_TODAY'){
			$SQL .= " AND DATE(oxb.dj_approved_date)='".$date."'";
		}
				
								
		$SQL .= "  AND oxb.`dj_admin_approve`={$admin_approve} AND 
						oxb.`dj_is_deleted` != 1
					) as banner_count 
				FROM 
					".TAB_BANNERS." as oxb
					JOIN ".TAB_CAMPAIGNS." as oxc ON oxb.campaignid=oxc.campaignid
					JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxb.dj_account_id
				WHERE
					oxcl.agencyid={$agency_id}	";
		
		if($adv_account_id != FALSE){
			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 
		}		
		
		if($approve_status === 'APPROVED_TODAY'){
			$SQL .= " AND DATE(oxb.dj_approved_date)='".$date."'";
		}	
		
		$SQL  .= "	AND oxb.`dj_admin_approve`={$admin_approve} AND
					  oxb.`dj_is_deleted` != 1 ";
					
		$SQL .= " ORDER BY 
					oxb.`dj_added_date` DESC LIMIT 0,1";
					
	
	  $query = $this->db->query($SQL);

	  $result=$query->result_array(); 

		 if($result)
		{			

			return $result[0];

		}

		else

		{

			return FALSE;

		}	

	}
	

	/*

	* 

	* name: fetch_all_creative

	* @param : 

	* @return :$result

	* 

	* Fetch details of creatives

	*/ 

	

	public function fetch_all_creative($agency_id,$filter=FALSE)
    {				   /*$this->db->select('tb.bannerid,tb.description,tb.filename,tb.url,tb.width,tb.height,tb.dj_banner_type,tb.imageurl,tb.dj_account_id,tu.contact_name,tu.email_address');

		$this->db->where('tb.dj_admin_approve',0);
		  
		$this->db->where('tb.dj_is_deleted',0);
		  
		$this->db->where('ta.agencyid',$agency_id);
		
		$this->db->where('dj_is_direct !=','1');
		
		if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
		
			$adv	=	explode(',',$this->user_authentication->manager_adv_pub_id);
		
			$this->db->where_in('tc.account_id',$adv);
		endif;
		  
		//$this->db->where('dj_admin_approve !=','-1');

		$this->db->from(TAB_BANNERS .'as tb');

		$this->db->join(TAB_USERS .' as tu','tu.default_account_id=tb.dj_account_id');
		  
		$this->db->join(TAB_CLIENTS .' as tc','tc.account_id=tb.dj_account_id');
		  
		$this->db->join(TAB_AGENCY .' as ta','ta.agencyid=tc.agencyid');

		$this->db->order_by('tb.bannerid');

		$query = $this->db->get();

		$result=$query->result_array(); 
		 
		if($result)
		{			
			$i=0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}	
			return $result;
		}
		else
		{
			return FALSE;
		}*/	
		$key = 'fetch_all_creative_'.$agency_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(APPROVAL_FETCH_ALL_CREATIVES);
		$check_changes	=	$this->memcached_library->get(CAMPAIGN_APPROVE_CREATIVE_CHANGES);
		
		/*if($ret && $mem_cache=='enable' && $check_db_changes!='1' && $check_changes!='1')
		{  return "if"; 
			return $ret;
		}
		else
		{ */ 
			$agencyid=$this->user_authentication->agency_id;
			
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4')
			{	 
				
				$adv	=	explode(',',$this->user_authentication->manager_adv_pub_id);
				$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT tb.bannerid,tb.description,tb.filename,tb.url,tb.width,tb.height,tb.dj_banner_type,tb.imageurl,tb.dj_account_id,tu.contact_name,tu.email_address,tb.status as banner_status,oxc.status,oxc.dj_is_approved from ".TAB_BANNERS." as tb JOIN ".TAB_CAMPAIGNS." as oxc JOIN ".TAB_USERS ." as tu JOIN ".TAB_CLIENTS." as tc JOIN ".TAB_AGENCY." as ta ON tc.account_id=tb.dj_account_id AND oxc.campaignid=tb.campaignid AND tu.default_account_id=tb.dj_account_id AND  tu.default_account_id != tu.parent_account_id AND ta.agencyid=tc.agencyid where tb.dj_admin_approve=0 AND tb.dj_is_deleted=0 AND ta.agencyid=".$agencyid." AND tb.dj_is_direct!='1' AND tc.account_id IN (".$adv.")"; 
				
				if($filter!=FALSE && $filter['campaign_name']!=FALSE)
					{
							$campaign_id=implode(",",$filter['campaign_name']);
							$SQL .= " AND oxc.campaignid in(".$campaign_id.")";
					}
				if($filter!=FALSE && $filter['campaign_type']!=FALSE)
					{
							$campaign_type=implode(",",$filter['campaign_type']);
							$SQL .= " AND oxc.revenue_type in(".$campaign_type.")";
					}
				if($filter!=FALSE && $filter['creative_weight']!=FALSE)
					{
							$creative_weight=implode(",",$filter['creative_weight']);
							$SQL .= " AND tb.weight in(".$creative_weight.")";
					}
					
				$in_sel = "SELECT count(*) from ".TAB_BANNERS." as tb JOIN ".TAB_USERS ." as tu JOIN ".TAB_CLIENTS." as tc JOIN ".TAB_AGENCY." as ta ON tc.account_id=tb.dj_account_id AND tu.default_account_id=tb.dj_account_id AND  tu.default_account_id != tu.parent_account_id AND ta.agencyid=tc.agencyid where tb.dj_admin_approve=0 AND tb.dj_is_deleted=0 AND ta.agencyid=".$agencyid." AND tb.dj_is_direct!='1'";
				$SQL.= " GROUP BY bannerid ORDER BY tb.bannerid DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount";   	
				
			}
			else
			{	
				$SQL = "SELECT @i := @i -1 AS row_number,c.* FROM(SELECT tb.bannerid,tb.description,tb.filename,tb.url,tb.width,tb.height,tb.dj_banner_type,tb.imageurl,tb.dj_account_id,tu.contact_name,tu.email_address,tb.status as banner_status,oxc.status,oxc.dj_is_approved from ".TAB_BANNERS." as tb JOIN ".TAB_CAMPAIGNS." as oxc JOIN ".TAB_USERS ." as tu JOIN ".TAB_CLIENTS." as tc JOIN ".TAB_AGENCY." as ta ON tc.account_id=tb.dj_account_id AND oxc.campaignid=tb.campaignid AND tu.default_account_id=tb.dj_account_id AND  tu.default_account_id != tu.parent_account_id AND ta.agencyid=tc.agencyid where tb.dj_admin_approve=0 AND tb.dj_is_deleted=0 AND ta.agencyid=".$agencyid." AND tb.dj_is_direct!='1'"; 
				
				if($filter!=FALSE && $filter['campaign_name']!=FALSE)
					{
							$campaign_id=implode(",",$filter['campaign_name']);
							$SQL .= " AND oxc.campaignid in(".$campaign_id.")";
					}
				if($filter!=FALSE && $filter['campaign_type']!=FALSE)
					{
							$campaign_type=implode(",",$filter['campaign_type']);
							$SQL .= " AND oxc.revenue_type in(".$campaign_type.")";
					}
				if($filter!=FALSE && $filter['creative_weight']!=FALSE)
					{
							$creative_weight=implode(",",$filter['creative_weight']);
							$SQL .= " AND tb.weight in(".$creative_weight.")";
					}
				
				
				$in_sel = "SELECT count(*) from ".TAB_BANNERS." as tb JOIN ".TAB_USERS ." as tu JOIN ".TAB_CLIENTS." as tc JOIN ".TAB_AGENCY." as ta ON tc.account_id=tb.dj_account_id AND tu.default_account_id=tb.dj_account_id AND  tu.default_account_id != tu.parent_account_id AND ta.agencyid=tc.agencyid where tb.dj_admin_approve=0 AND tb.dj_is_deleted=0 AND ta.agencyid=".$agencyid." AND tb.dj_is_direct!='1'";
				$SQL.= " GROUP BY bannerid ORDER BY tb.bannerid DESC) AS c,(SELECT @i := ($in_sel) + 1) as rowcount"; 	
			}	
					
			$query = $this->db->query($SQL);   
			
			//return $this->db->last_query();
			//exit();   
		
			$result = $query->result_array();		
			
			if($query->num_rows()>0)
			{
				//return $result;
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(APPROVAL_FETCH_ALL_CREATIVES,'2');
					$this->memcached_library->set(CAMPAIGN_APPROVE_CREATIVE_CHANGES,'2');
					$set = $this->memcached_library->get($key);	  
					return $set;
				}
				else
				{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}	
			
		/*}*/
	}
	   

   /*

	* 

	* name: approve_creative

	* @param : banner_id

	* @return : TRUE or FALSE

	* 

	* Approve the creative

	*/  

	

	public function approve_creative($banner_id=FALSE)
	{
		$data	=	array(
						'dj_admin_approve'=>1,
						'dj_approved_date'=>date('Y-m-d H:i:s')
					); 

		$this->db->where('bannerid', $banner_id);
		$this->db->update(TAB_BANNERS, $data);
		if($this->db->affected_rows()>0){
			$this->db->select('*');
			$this->db->where('bannerid',$banner_id);
			$query=$this->db->get(TAB_BANNERS);
			$result=$query->result_array();
			$this->memcached_library->set(APPROVAL_FETCH_ALL_CREATIVES,'1');
			$this->memcached_library->set(FETCH_MODAL_CREATIVES,'1');
			$this->memcached_library->set(FETCH_CREATIVES,'1');
			return $result[0];
		}
	    else{
			return FALSE;	
		}
	}
     public function approve_creative_camp($banner_id=FALSE)
				{
					
				$this->db->select('tbd.dj_is_admarket');
				$this->db->where('bannerid',$banner_id);
				$this->db->from(TAB_BANNERS.' as tb');

				$this->db->join(TAB_CAMPAIGNS.' as tbd','tb.campaignid=tbd.campaignid','left');

				$query 	= 	$this->db->get();
                
				$result	=	$query->result_array();
				return $result;
				}
	public function approve_mobileapp($app_id=FALSE)
	{
		$data	=	array(
						'status'=>1						
					); 

			$this->db->where('id', $app_id);
			$this->db->update(TAB_TEMP_URL, $data);
			if($this->db->affected_rows()>0)
			{
			$this->db->select('*');
			$this->db->where('id',$app_id);
			$query=$this->db->get(TAB_TEMP_URL);
			$result=$query->result_array();
			//$this->memcached_library->set(APPROVAL_FETCH_ALL_CREATIVES,'1');
			//$this->memcached_library->set(FETCH_MODAL_CREATIVES,'1');
			//$this->memcached_library->set(FETCH_CREATIVES,'1');
			return $result[0];
		}
	    else{
			return FALSE;	
		}
	}
	
	
	
	public function reject_mobileapp($app_id=FALSE)
	{
		$data	=	array(
						'is_deleted'=>1						
					); 	  

		$this->db->where('id', $app_id);      

		$this->db->update(TAB_TEMP_URL, $data);

		if($this->db->affected_rows()>0){
			
			//$this->unlink_blocks($banner_id);
			
			$this->db->select('*');
			$this->db->where('id',$app_id);
			$query=$this->db->get(TAB_TEMP_URL);
			$result=$query->result_array();
			$this->memcached_library->set(APPROVAL_FETCH_ALL_CREATIVES,'1');
			return $result[0];
		}
	    else{
			return FALSE;
		}
    }


   

   /*
	* 
	* name: reject_creative

	* @param : banner_id

	* @return : TRUE or FALSE

	* 

	* Reject the creative

	*/

	

	public function reject_creative($banner_id=FALSE)
	{
		$data	=	array(
						'dj_admin_approve'=>-1,
						'dj_approved_date'=>date('Y-m-d H:i:s')
					); 	  

		$this->db->where('bannerid', $banner_id);      

		$this->db->update(TAB_BANNERS, $data);

		if($this->db->affected_rows()>0){
			
			$this->unlink_blocks($banner_id);
			
			$this->db->select('*');
			$this->db->where('bannerid',$banner_id);
			$query=$this->db->get(TAB_BANNERS);
			$result=$query->result_array();
			$this->memcached_library->set(APPROVAL_FETCH_ALL_CREATIVES,'1');
			return $result[0];
		}
	    else{
			return FALSE;
		}
    }

	
       /*

	* 

	* name: is_creative_id

	* @param : banner_id

	* @return : TRUE or FALSE

	* Check the banner is approved / rejected previously 
	
	*/  

	

	public function is_creative_id($banner_id=FALSE)
	{

	  $query=$this->db->get_where(TAB_BANNERS,array('dj_admin_approve'=>0,'bannerid'=>$banner_id));
	  if($query->num_rows>0)
	  {
	    return TRUE;
	  }
	  else
	  {
	    return FALSE;
	  }

	}
	
	public function is_app_id($app_id=FALSE)
	{

	  $query=$this->db->get_where(TAB_TEMP_URL,array('status'=>0,'is_deleted'=>0,'id'=>$app_id));
	  if($query->num_rows>0)
	  {
	    return TRUE;
	  }
	  else
	  {
	    return FALSE;
	  }

	}
	
	
	
	
	
	
	/*

	* 

	* name: preview_creative

	* @param : banner_id

	* @return :creative details->creativename,width,height etc..

	* 

	*/

	public function preview_creative($banner_id=FALSE){
	
		$key = 'preview_creative_'.$banner_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_ALL_PREVIEW_CREATIVES.'_'.$banner_id);
		//return $check_db_changes;
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{	
			
   		$this->db->select('contenttype,storagetype,dj_banner_type,imageurl,description,dj_added_date,width,height,weight,filename,bannertext,url,htmltemplate,dj_image_path');

	    $this->db->where('bannerid',$banner_id);

        $query = $this->db->get(TAB_BANNERS);          
		$result=$query->result_array(); 		
		
		if($result){
			$check_width	=	$result['0']['width'];
			$content_type	=	$result['0']['contenttype'];
			$banner_type = $result['0']['dj_banner_type'];
			
			
			/*
			if($check_width=='-7' || $check_width=='-8')
    		{
				$this->db->select('tb.contenttype,tb.url,tb.description,tb.dj_added_date,tb.dj_banner_type,tb.width,tb.height,tb.weight,tb.filename,tb.filename as video_filename');

				$this->db->where('bannerid',$banner_id);

				$this->db->from(TAB_BANNERS.' as tb');
				
				$query 	= 	$this->db->get();
                
				$result	=	$query->result_array();
				return $result;

			}
			*/
			
    	 if($check_width=='-3' || $check_width=='-2' || $check_width=='-5' || $check_width=='-6' || $check_width=='-7' || $check_width=='-8')
    		{
				$this->db->select('tb.contenttype,tb.url,tb.description,tb.dj_added_date,tb.dj_banner_type,tb.width,tb.height,tb.weight,tb.filename,tbv.vast_video_outgoing_filename as video_filename,tbv.vast_overlay_text_description as text_description,tbv.vast_overlay_format as overlay_format,tb.dj_image_path,tbv.vast_overlay_wrapper,tbv.vast_wrapper_url,tbv.vast_video_delivery');

				$this->db->where('bannerid',$banner_id);

				$this->db->from(TAB_BANNERS.' as tb');

				$this->db->join(TAB_BAN_VAST_ELE.' as tbv','tbv.banner_id=tb.bannerid');

				$query 	= 	$this->db->get();
                
               // return $this->db->last_query(); exit();
                
                
				$result	=	$query->result_array();
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);
				$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$banner_id,'2');	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}

			}
			elseif($banner_type=="W_NA")
			{
				$this->db->select('contenttype,storagetype,dj_banner_type,imageurl,description,dj_added_date,weight,filename,bannertext,url,htmltemplate,dj_image_path');

				$this->db->where('bannerid',$banner_id);

				$query = $this->db->get(TAB_BANNERS);
				
			    $result	=	$query->result_array();

				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$banner_id,'2');	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			
			elseif($check_width==0 && $content_type!="txt" && $banner_type!="W_NA" && $banner_type!="M_MR_DLG")
			{
				$this->db->select('tb.description,tb.url,tb.dj_banner_type,tb.dj_added_date,tbd.width,tbd.height,tb.weight,tbd.file_path as filename,tbd.content_type as contenttype,tbd.dj_image_path');

				$this->db->where('bannerid',$banner_id);

				$this->db->from(TAB_BANNERS.' as tb');

				$this->db->join(TAB_BAN_DEPEND.' as tbd','tb.bannerid=tbd.banner_id','left');

				$query 	= 	$this->db->get();
                
				$result	=	$query->result_array();

				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);
				$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$banner_id,'2');		
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}

			}
			elseif($banner_type=="W_SS" || $banner_type=="W_GB" || $banner_type=="W_BB")
			{
				$this->db->select('tb.description,tb.url,tb.dj_banner_type,tb.dj_added_date,tbd.width,tbd.height,tb.weight,tbd.file_path as filename,tbd.content_type as contenttype,tbd.dj_image_path');

				$this->db->where('bannerid',$banner_id);

				$this->db->from(TAB_BANNERS.' as tb');

				$this->db->join(TAB_BAN_DEPEND.' as tbd','tb.bannerid=tbd.banner_id','left');

				$query 	= 	$this->db->get();
                
				$result	=	$query->result_array();

				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);
				$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$banner_id,'2');		
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}

			}
			
			
			else
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$this->memcached_library->set(FETCH_ALL_PREVIEW_CREATIVES.'_'.$banner_id,'2');	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
		}
		else
		{
			return FALSE;
		}
	}
}
	

	
	
	/*
	* 
	* name: preview_adblock
	* @param : zone_id
	* @return :creative details.
	* 
	*/	
	public function preview_additional_banners($banner_id=FALSE)
	{
		if($banner_id!=false)
		{
			$query=$this->db->query("select * from djax_additional_banners where banner_id=".$banner_id);
			$result=$query->result_array(); 
			return $result;		
		}
		else
		{
			return FALSE;
		}
		
	}

	public function preview_adblock($zone_id=FALSE)
	{
		$key = 'preview_adblock_'.$zone_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_ALL_PREVIEW_ADBLOCKS.'_'.$zone_id);
		//return $check_db_changes;
		if($ret && $mem_cache=='enable' && $check_db_changes!='1')
		{
			return $ret;
		}
		else{
		$zone_type_qry=$this->db->query("select * from ".TAB_ZONES." where zoneid=".$zone_id);
		$ztype_qry=$zone_type_qry->result_array();
		$zone_type=$ztype_qry[0]['dj_zone_type']; 
	
		$adblock_type=array("M_A_EXD","M_A_RVL","M_A_FX","M_A_AD","M_A_PULL","M_A_FS");
		
		if(in_array($zone_type,$adblock_type))
		{
		$this->db->select('az.*,ba.*,rz.dj_zone_type');
		$this->db->join(TAB_AD_ZONE_ASSOC . ' AS az', 'az.ad_id = ba.bannerid');
		$this->db->join(TAB_ZONES . ' AS rz', 'rz.zoneid = az.zone_id');			
		}
		else if($zone_type=="W_A_NAT")
		{
		$this->db->select('az.*,ba.*,rz.dj_zone_type');
		$this->db->join(TAB_AD_ZONE_ASSOC . ' AS az', 'az.ad_id = ba.bannerid');
		$this->db->join(TAB_ZONES . ' AS rz', 'rz.zoneid = az.zone_id AND ba.dj_banner_type="W_NA"');						
		}	
		else
		{
		$this->db->select('az.*,ba.*,rz.dj_zone_type');
		$this->db->join(TAB_AD_ZONE_ASSOC . ' AS az', 'az.ad_id = ba.bannerid');
		$this->db->join(TAB_ZONES . ' AS rz', 'rz.zoneid = az.zone_id AND ba.width=rz.width AND ba.height=rz.height');				
		}
		if($zone_id!=FALSE)
		{
			$this->db->where('zone_id',$zone_id);
		}
		$query 	= 	$this->db->get(TAB_BANNERS . ' AS ba');     								              
		$result=$query->result_array(); 		
		
		if($result)
			{						
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(FETCH_ALL_PREVIEW_ADBLOCKS.'_'.$zone_id);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			}
		}
	}	
	
	/*

	 * 

	 * name: fetch_video

	 * @param :

	 * @return : TRUE (or) FALSE

	 * 

	 * Get the video creative from the database

	 */

	

	function fetch_video_creatives($account_id)

	{	

		if($account_id)

		{	

			/*Get records from ox_banner_vast_element */

			$this->db->where('dj_account_id',$account_id);

			$this->db->where('dj_is_deleted',0);

			$this->db->where_in('dj_banner_type',array(VIDEO_CREATIVE_OVERLAY,VIDEO_CREATIVE_INLINE,VIDEO_CREATIVE_REAL,VIDEO_CREATIVE_SMALL,VIDEO_CREATIVE_BOX,VIDEO_CREATIVE_HEAD));
			

			$query	=	$this->db->get(TAB_BANNERS);
						$result	=	$query->result_array();
			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

	

	}


	/*
	 * 
	 * name: unlink_blocks
	 * @param : creative_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_blocks($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->trans_start();
			
			$this->db->where('ad_id',$creative_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*

	 * 

	 * name: fetch_campaign

	 * @param :

	 * @return : $result

	 * 

	 * Lists a cpm campaign of an advertiser

	 */

	 function fetch_campaign_cpm($account_id,$campaign_type=false,$admarket_id=false)

	 {
		$adma_id = ($admarket_id == false)?'0':'1';
		$key = 'fetch_campaign_cpm_'.$account_id.'_'.$campaign_type;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{

			$this->db->select('oxc.campaignid, oxc.campaignname');

			$this->db->join(TAB_CLIENTS.' as oxcl', 'oxcl.clientid=oxc.clientid AND oxcl.dj_is_deleted=0');
				
			$this->db->join(TAB_AGENCY.' as oxa', 'oxa.agencyid=oxcl.agencyid');	

			$this->db->where('oxc.dj_is_deleted ','0');
			$this->db->where('oxc.dj_is_admarket ',$adma_id);

			if($account_id)

				$this->db->where('oxcl.account_id', $account_id);

			if($campaign_type!=false):
				if($campaign_type=='WEB' || $campaign_type=='TABLET'):
					$this->db->where_not_in('oxc.dj_targetting_type', 'MOBILE');		
				elseif($campaign_type=='MOBILE'):
					$this->db->where_not_in('oxc.dj_targetting_type', 'WEB');		
				endif;
				
			endif;
			
			$this->db->where('oxc.revenue_type', 1);		

			$this->db->order_by('oxc.dj_added_date ');

			$query = $this->db->get(TAB_CAMPAIGNS.' as oxc');

			$result = $query->result_array();
			
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}

		else

			return FALSE;

		}
		
	}
	
	function list_bannersize()
	{
		
		
		$key = 'list_bannersize';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
		$query	=	$this->db->get(TAB_CONF_BANNER_SIZE);
		
		if($query->num_rows()>0)
		{
			if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$query->result_array(),$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $query->result_array();
		}
			
		}
		else
		{
			return FALSE;
		}
		
	}
	
}
	/*********************************************************************
	 * Native ads
	 ********************************************************************/ 
	function add_url($url_data)
	{		
		$this->db->insert(TAB_BANNERS,$url_data);
		
		$banner_id	=	$this->db->insert_id();
		
		if($banner_id)
		{
			$this->db->select('bannerid, campaignid, contenttype, storagetype, imageurl, url, statustext, bannertext, description, click, impression,embed,video_url');
			
			$this->db->where('bannerid',$banner_id);
			
			$query 	= 	$this->db->get(TAB_BANNERS);
			
			$result = 	$query->result_array();
			
			if ($result)
			{
				return $result;
			}
			else
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
						
	}
	
	/*
	* name: fetch_url
	* @param
	* @return
	*
	* This method get list of campaign type
	* 
	*/

	function fetch_url($bannerid)
	{		
		$SQL 	= 	"SELECT `bannerid`, `campaignid`, `contenttype`, `storagetype`, `imageurl`, `url`, `statustext`, `bannertext`, `description`, `click`, `impression`,`embed`,`video_url` 
					FROM ".TAB_BANNERS." 
					WHERE `bannerid` = ".$bannerid;
		
		$query 	= 	$this->db->query($SQL);	
		
		$result = 	$query->result_array();
			
		if($result)
			return $result;			
		else
			return FALSE;
			
	}
	
	/*
	* 
	* name		: update_url
	* @param   : url_data,fname,id,imp,click,emb
	* @purpose  : Update url content
	*/	 

	function update_url($id,$url_data)
	{	 
		$this->db->trans_start();

		$this->db->where('bannerid', $id);
		$this->db->update(TAB_BANNERS,$url_data);	
		//return $this->db->last_query();
		$this->db->trans_complete();		
		
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return FALSE;
		}
		else
		{
			$this->db->trans_commit();
			return TRUE;			
		}
	}
	
	function add_group($group_data)
	{		
		$this->db->insert(TAB_GROUP,$group_data);
		
		$group_id	=	$this->db->insert_id();
		
		$this->memcached_library->set(ADV_GROUP_LIST,'1');
		
		if($group_id)
		{			
			return $group_id;			
		}
		else
		{
			return FALSE;
		}
						
	}
	
	function group_check($group_name,$account_id)
	{	 
		$this->db->select('*');	
		$this->db->where("group_name",$group_name);
		$this->db->where_not_in('account_id',$account_id);
		$query_count	=	$this->db->get(TAB_GROUP)->num_rows();			
		if($query_count)
		{			
		     return $query_count;
		}
	}
	
	function keyword_check($keyword,$account_id)
	{
		$this->db->select('*');	
		$this->db->where("keyword",$keyword);
		$this->db->where_in('account_id',$account_id);
		$query_count	=	$this->db->get(TAB_TARG_KEYWORD)->num_rows();	
		if($query_count)
		{			
		     return $query_count;
		}
	}
	
	/*public function is_app_id($app_id=FALSE)
	{
		$query=$this->db->get_where(TAB_TEMP_URL,array('status'=>0,'is_deleted'=>0,'id'=>$app_id));
		if($query->num_rows>0)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}*/	
	
	/*
		* 
		* name: disable_creative
		* @param : creative_id
		* @return : $result 
		* Disable the creative
		*/

	 function disable_creative($creative_id=false)
	 {

		if($creative_id)
		{

			$this->db->trans_start();

			$this->db->where('bannerid',$creative_id); 
			$this->db->update(TAB_BANNERS,array('dj_disable'=>'1'));

			$this->memcached_library->set(FETCH_CREATIVES,'1');
			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();

			else
				$this->db->trans_commit();
				return true;
		}

		else
			return FALSE;
	}
	/*
		* 
		* name: enable_creative
		* @param : creative_id
		* @return : $result 
		* Disable the creative
		*/

	 function enable_creative($creative_id=false)
	 {

		if($creative_id)
		{

			$this->db->trans_start();

			$this->db->where('bannerid',$creative_id); 
			$this->db->update(TAB_BANNERS,array('dj_disable'=>'0'));

			$this->memcached_library->set(FETCH_CREATIVES,'1');
			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();

			else
				$this->db->trans_commit();
				return true;
		}

		else
			return FALSE;
	}


    public function fetch_browser_versions(){
		    $this->db->select('id as id, browser_version as text');
			
			$this->db->order_by('id','desc');
			$query = $this->db->get(TAB_TARG_BROWSER_VERSION);
			if($query->num_rows()>0){
				$result	=	$query->result_array();
				
					return $result;
				
			}
			else
			{
				return FALSE;
			} 			
	   
	   
	}

	function fetch_keywords_ajax($value=false,$sortable2=false)
	{	
		$key='fetch_keywords_ajax';
		if($value!=FALSE)
		{
			$key.= '_'.$value;
		}
		if($sortable2!=FALSE)		
		{
			$key.= '_'.$sortable2;
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	  
		
		if($ret && $mem_cache=='enable')
		{
			return $ret;
		}
		else{	
		if(!empty($value))
		{
			$this->db->select('*');		
			$this->db->like('keyword ',$value);	
			$this->db->where('is_deleted ','0');
			$this->db->where('is_blocked ','0');
			if($sortable2)
			{
				$this->db->where_not_in('id ',$sortable2);
			}	
			$query = $this->db->get(TAB_TARG_KEYWORD);		
			$result = $query->result_array();
			if($result)
			{
				if($mem_cache=='enable')
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
				
			}
			else
			{
				return FALSE;
			}
		}	
		}
	}
	
	function fetch_avg_impression($keywords=false,$sortable2=false,$where=false)
	{		
		$key = 'fetch_avg_impression';
		if($keywords!=FALSE)
		{
			$key.='_'.$keywords;
		}
		if($sortable2!=FALSE)
		{
			$key.='_'.$sortable2;
		}
		if($where!=FALSE)
		{
			$key.='_'.$where;
		}
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
				
		if($ret && $mem_cache=='enable')
		{
			return $ret;
		}
		else{	
			
		if(!empty($keywords) || !empty($where))
		{
			$where_in	= str_replace(",","','",$where);
			$SQL = "SELECT t4.AVG_CPM,t4.TRAFFIC,t4.id,t4.key_name,t4.Keywords FROM(

			SELECT ROUND(IFNULL(t3.bidding_price,0),3) as AVG_CPM, COUNT(t3.bidding_price) as TRAFFIC, 

			t1.keyword as id,LEFT(t1.keyword,20) as key_name,

			t1.keyword as Keywords

			FROM meta_keywords as t1 

			LEFT JOIN rv_djax_track_ad_requests as t2 ON t2.random_no = t1.random

			LEFT JOIN rv_djax_track_ad_responses as t3 ON t3.request_id = t2.request_id

			WHERE ";
			if($where)
			{										
					$SQL	.= " t1.keyword IN('".$where_in."') ";
			}	
			else
			{		
				$SQL	.= " t1.keyword LIKE '%".$keywords."%' ";

							if($sortable2)
							{
								foreach($sortable2 as $sortable2_val)
								{				
									$SQL	.= "AND t1.keyword != '".$sortable2_val."' ";
								}
							}
			}			


			$SQL	.=" GROUP BY t1.keyword

			UNION ALL 

			SELECT 0 as AVG_CPM, 0 as TRAFFIC, keyword as id,LEFT(keyword,20) as key_name,keyword as Keywords

			 FROM djax_targ_keywords

			WHERE ";
		if($where)
		{										
				$SQL	.= " keyword IN('".$where_in."') ";
		}
		else
		{			
			$SQL	.= " keyword LIKE '%".$keywords."%' AND is_blocked =0 AND is_deleted =0 ";

						if($sortable2)
						{
							foreach($sortable2 as $sortable2_val)
							{				
								$SQL	.= "AND keyword != '".$sortable2_val."' ";
							}
						}
		}
			 $SQL	.= " ) as t4";
			$query = $this->db->query($SQL);        
			$result = $query->result_array();
			if($result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
				
			}
			else
			{
				return FALSE;
			}
		}	
	
		}
	}

	function fetch_daily_statistics($date,$account_id=FALSE, $admarket_status=FALSE)
	{ 

		$SQL = "SELECT sum(oxah.impressions)as imp,sum(oxah.clicks)as clk,sum(oxah.conversions)as conv,sum(oxah.dj_total_revenue) as spend, cl.dj_cur_balance as cur_bal FROM ".TAB_DATA_SUM_AD_HOURLY." as oxah join ".TAB_BANNERS." as b on b.bannerid=oxah.ad_id JOIN ".TAB_CAMPAIGNS." as c ON c.campaignid=b.campaignid JOIN ".TAB_CLIENTS." as cl ON c.clientid=cl.clientid WHERE cl.account_id='".$account_id."' and c.dj_is_admarket = '".$admarket_status."' and date(oxah.date_time)='".$date."'";

		/*if($account_id!=FALSE)
		{
			$SQL.=" and cl.account_id='".$account_id."'";
		}
*/
		$query = $this->db->query($SQL);
								
		if($query->num_rows() >0)
		{
		    $result = 	$query->result_array();  
			 
			return $result;  
			 				
		}
		else
		{
			return FALSE;	
		}
		
	}
	 function fetch_demo_creative_bkp($creative_id=false)
	 {  
		$key='fetch_demo_creative_bkp';
		if($creative_id!=FALSE)
		{
			$key.= '_'.$creative_id; 
		}		
		$ret = $this->memcached_library->get($key);		
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
				
		if($ret && $mem_cache=='enable')
		{
			return $ret;
		}
		else{		
		if($creative_id)
		{  
			/*$this->db->select('contenttype,bannerid,campaignid,description,filename,storagetype,url,width,height,imageurl,bannertext,htmltemplate,dj_banner_type,dj_account_id,dj_admin_approve,dj_image_path,backgroundcolor');		
				
			$this->db->where('bannerid ',$creative_id);

			$this->db->where('dj_is_deleted ','0');
			
			$this->db->where('dj_admin_approve !=','-1');

			$this->db->order_by('dj_added_date ');*/
			
			$banner_result=$this->db->query('select campaignname,width,height,filename,banner_type,display_type,imageid,bannerid,bannertext,contenttype,htmltemplate ,htmlcache,position,storagetype,dj_image_path ,url,imageurl,icon_type,dj_video_thumb_img,dj_content_video_url,dj_content_ad_message,dj_social_networking,display_size,backgroundcolor,fontcolor from(select oxc.campaignname as campaignname ,
			oxc.campaignid as campaignid,
			oxb.width as width,
			oxb.height as height,
			oxb.filename as filename,
			oxb.dj_banner_type as banner_type,
			0 as display_type,
			0 as imageid,
			oxb.bannerid as bannerid,
			oxb.bannertext as bannertext,
			oxb.contenttype as contenttype ,
			oxb.htmltemplate as htmltemplate,
			oxb.htmlcache as htmlcache,
			0 as position,
			0 as icon_type,
			0 as dj_video_thumb_img,
			0 as dj_content_video_url,
			0 as dj_content_ad_message,
			0 as dj_social_networking,
			0 as display_size,
			oxb.storagetype as storagetype,
			oxc.dj_favourite_status as favourite_status,
			oxb.dj_image_path as dj_image_path,
			oxb.url as url,
			oxb.imageurl as imageurl,
			oxb.backgroundcolor,
			oxb.fontcolor 
			from '.TAB_BANNERS.' AS oxb join '.TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxb.bannerid ='.$creative_id.' AND oxb.dj_is_deleted="0" AND oxc.dj_is_deleted="0" AND (oxb.filename!="" OR oxb.bannerid NOT IN (SELECT dab.banner_id FROM '.TAB_BAN_DEPEND.' AS dab))  

			union 

			select oxc.campaignname as campaignname ,
			oxc.campaignid as campaignid,
			dab.width as width ,
			dab.height as height,
			dab.file_path as filename,
			oxb.dj_banner_type as banner_type,
			dab.display_type as display_type,
			dab.image_id as imageid,
			dab.banner_id as bannerid,
			oxb.bannertext as bannertext,
			oxb.contenttype as contenttype,
			oxb.htmltemplate as htmltemplate,
			oxb.htmlcache as htmlcache,
			dab.position as position,
			dab.icon_type as icon_type,
			dab.dj_video_thumb_img as dj_video_thumb_img,
			dab.dj_content_video_url as dj_content_video_url,
			dab.dj_content_ad_message as dj_content_ad_message,
			dab.dj_social_networking as dj_social_networking,
			dab.display_size as display_size,
			oxb.storagetype as storagetype,
			oxc.dj_favourite_status as favourite_status ,
			dab.dj_image_path as dj_image_path,
			oxb.url as url,
			oxb.imageurl as imageurl,
			0 as backgroundcolor,
			0 as fontcolor 
			from '.TAB_BAN_DEPEND.' AS dab join '.TAB_BANNERS.' AS oxb on dab.banner_id=oxb.bannerid join '.TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxb.bannerid ='.$creative_id.' AND oxb.dj_is_deleted="0" AND oxc.dj_is_deleted="0" ) as c ');

			
			if($banner_result->num_rows()>0)
			{
				$result = $banner_result->result_array();
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}	
			}
			else
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
		}

	}
	 	
}
