<?php
Class Do_country extends CI_Model
{
	
	/*   djax_targ_country
	 * ---------------------
	 * name
	 * value
	 * status
	 * */
	 
	 function list_country()
	 {		 
		$key = 'list_country';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{			
		
			$this->db->order_by('name','ASC');
	 		$query = $this->db->get(TAB_TARG_COUNTRY);
			$result = $query->result_array();
			if($result)
			{			
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			} 
		}
	}	 

	 function list_state($c_val = FALSE)
	 {
		 
		$key = 'list_state';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			$this->db->select('id,region');
			if($c_val)
			{
			$this->db->where('country_code',$c_val);
			}
			
			$query = $this->db->get(TAB_TARG_STATE);
		
			$result = $query->result_array();
			//return $this->db->last_query(); exit();
			
			if($result)
			{			
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}
			else
			{
				return FALSE;
			} 
		}
	}	 
	 
	function add_countrybidding($bidding_data)
	{

		if($bidding_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_COUN_BID,$bidding_data);
			$bidding_id=$this->db->insert_id();
			$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $bidding_id;
			}
	
		 }
	 }
	 //import country wise bidding
	 
	 function import_countrybidding($import_bidding_data=false,$import_bidding_where_data=false)
	{

		if($import_bidding_data)
		{
			$this->db->trans_start();
					
			$this->db->select('campaign_id,revenue_type,bidding_value,country_value');
			$this->db->where($import_bidding_where_data);
			$query=$this->db->get(TAB_COUN_BID);							
			if($query->num_rows()>0)
			{ 			
			return false;
			}
			else
			{  
				$SQL="INSERT INTO `djax_country_bidding` (`campaign_id`, `revenue_type`, `bidding_value`,`country_value`,`account_id`,`status`,`admarket`) VALUES ('".$import_bidding_data['campaign_id']."','".$import_bidding_data['revenue_type']."','".$import_bidding_data['bidding_value']."', '".$import_bidding_data['country_value']."','".$import_bidding_data['account_id']."','".$import_bidding_data['status']."','".$import_bidding_data['admarket']."')";
				$query = $this->db->query($SQL);
				$bidding_id=$this->db->insert_id();
				$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');
				
				$this->db->trans_complete();
				if($bidding_id)
				{
						
						return  $bidding_id;;
				}
				else{
						return FALSE;	
				}
				
			}						
	
		 }
	 }
	 
	 //export countrywise bidding
	function fetch_export_country_data($campaignid=FALSE,$admarket=FALSE)
	{		
		$this->db->select('rva.account_name, a.id as c_id ,a.account_id as account_id, a.country_value as country_value,a.bidding_value as bidding_value ,a.revenue_type as revenue_type,b.campaignid as campaignid,b.campaignname as campaignname,a.status as status,a.admarket as admarket');
		$this->db->from(TAB_COUN_BID.' as a');
		$this->db->join(TAB_ACCOUNTS.' as rva ',' rva.account_id = a.account_id ');
		$this->db->join(TAB_CAMPAIGNS.' as b', 'b.campaignid = a.campaign_id','left');
		if($admarket!=FALSE)
		{
			$this->db->where('a.admarket','1');
		}
		else
		{
			$this->db->where('a.admarket','0');
		}
		$this->db->where_in('a.id',$campaignid);
		$query = $this->db->get();
		
		$result = $query->result_array();
		$count=$query->num_rows();
		if($result)
		{		
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	 
	 function import_zonebidding($import_bidding_data)
	{

		if($import_bidding_data)
		{
			$this->db->trans_start();
						
			$SQL="INSERT INTO `djax_country_bidding` (`campaign_id`, `campaign_type`, `bid_rate`,`zone_id`,`account_id`,`status`) VALUES ('".$import_bidding_data['campaign_id']."','".$import_bidding_data['bidding_type']."','".$import_bidding_data['bidding_value']."', '".$import_bidding_data['zoneid']."','".$import_bidding_data['account_id']."','".$import_bidding_data['status']."')";
					
				$query = $this->db->query($SQL);
				$bidding_id=$this->db->insert_id();
				$this->memcached_library->set(ZONE_BIDDING,'1');   
			
				$this->db->trans_complete();
				if($bidding_id)
				{			
					return  $bidding_id;;
				}
				else
				{
						return FALSE;	
				}		
	
		 }
	 }
	 
	  
	 
	 /*
   * 
   * name: fetch_job_category
   * @param : 
   * @return :all the job categories
   * 
   */
	public function fetch_job_category()
	{
		
		//$this->db->where('parent_category_id','0');
		//$this->db->where('is_deleted',0);
		$this->db->order_by('job_id','desc');
		$query = $this->db->get('job_category');
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
			$i	=	0;
			foreach($result as $row)
			{
				$result[$i]['row_number']	=	$i+1;
				$i+=1;
			}
			return $result;
		}
		else
		{
			return FALSE;
		}  
	}
	
	public function fetch_country($country_value)
	{		
		$key = 'country_'.$country_value;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');
		
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else
		{		 
		$this->db->select('*');
		$this->db->where('id',$country_value);
		$query = $this->db->get(TAB_TARG_COUNTRY);
		
		//echo $this->db->last_query(); die("test");
		if($query->num_rows()>0)
		{
			$result	=	$query->result_array();
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
			return $result;  
		}
			}
		else
		{
			return FALSE;
			}  
		}  
	}
	
	 
	 function edit_countrybidding($bidding_data,$id)
	 {
		 if($bidding_data)
		{
			$this->db->trans_start();
			
			$this->db->where('id',$id);

			$this->db->update(TAB_COUN_BID,$bidding_data);
			
			$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');
			$this->memcached_library->set(FETCH_EDIT_COUNTRY_BIDDING,'1');
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}

	
		 }
	 }
	 
	 
	 
	 
	function list_unbidding_country($account_id,$admarket=FALSE)
	{
		$key = 'list_unbidding_country_'.$account_id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');
		
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else
	{
		if($account_id)
		{
			if($admarket!=FALSE)
			{
				$SQL = "SELECT name,value FROM ".TAB_TARG_COUNTRY." WHERE value NOT IN(select country_value from ".TAB_COUN_BID." where  account_id=".$account_id." AND admarket=".$admarket.")";	
			}
			else
			{
				$SQL = "SELECT name,value FROM ".TAB_TARG_COUNTRY." WHERE value NOT IN(select country_value from ".TAB_COUN_BID." where  account_id=".$account_id.")";
			}
		}
		else
		{
			$SQL = "SELECT name,value FROM ".TAB_TARG_COUNTRY."";	  
		}
		
				
		$query = $this->db->query($SQL);
		
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();
					
					if($mem_cache=='enable' )
					{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);
					$set = $this->memcached_library->get($key);	
					return $set;
					}
					else
					{
				return $result;
					}
			}
			else
			{
				return FALSE;	
			}
		}
		
	}

	function list_unbind_country($account_id,$campaignid,$revenueid)
	{
		if($account_id)
		{
			$SQL = "SELECT name,value FROM ".TAB_TARG_COUNTRY." WHERE value NOT IN(select country_value from ".TAB_COUN_BID." where campaign_id=".$campaignid." and revenue_type=".$revenueid." and account_id=".$account_id.")";					
		}			
		$query = $this->db->query($SQL);
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();
				return $result;
		}else{
				return FALSE;	
		}		
	}
	 
	function list_bidding_country($account_id,$filter=FALSE,$admarket=FALSE)
	{
		
		$key = 'list_bidding_country_'.$account_id;
						
		if($filter!=FALSE):   
			foreach($filter as $fkey=>$value)
			{
				if($value!='')
				{
					$key .= '_'.$fkey.'_'.((is_array($value))?implode('_',$value):$value);
				}
			}
		endif;	
			
		if($admarket!=FALSE)
		{
			$key.='_'.$admarket;
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_COUNTRY_BIDDING);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' )
		{  
			return $ret;
		}
		else{	 
			
			$SQL = "SELECT @i := @i -1 AS row_number,c.*
					FROM
					(SELECT b.id as id ,b.country_value,b.bidding_value,b.campaign_id,b.revenue_type,c.name as name,b.bidding_value as bidding,c.status as status,

						case  

						when b.campaign_id=-1 then 'All Campaigns'

						ELSE camp.campaignname 

						END as camp_name,d.revenue_type as rev_type,oxc.clientname,b.account_id

						FROM djax_country_bidding as b 

						LEFT JOIN ".TAB_TARG_COUNTRY." as c on c.value=b.country_value

						LEFT JOIN ".TAB_CAMPAIGNS." as camp ON camp.campaignid=b.campaign_id 
	 
						LEFT JOIN ".TAB_CONF_REVENUE_TYPE." as d ON d.revenue_id=b.revenue_type  

						JOIN ".TAB_CLIENTS." as oxc ON oxc.account_id=b.account_id 

						WHERE 1 ";
						if($account_id)
						{
							$SQL .= " AND b.account_id=".$account_id."";
						}
						if($filter!=FALSE && $filter['campaign']!=FALSE)
						{
							$campaign_id=implode(",",$filter['campaign']);
							$SQL .= " AND camp.campaignid in(".$campaign_id.")";
						}
						if($filter!=FALSE && $filter['campaign_type']!=FALSE)
						{	
							$campaign_type=implode(",",$filter['campaign_type']);							
							$SQL .= " AND d.revenue_type_value in(".$campaign_type.")";
						}	
						if($admarket!=FALSE)
						{
							$SQL .= " AND b.admarket in(".$admarket.")";
						}
						else
						{
							$SQL .= " AND b.admarket=0";
						}
									
				//test sorting.. code  start	
				$in_sel= "select count(*) 
					FROM ".TAB_TARG_COUNTRY." as a join ".TAB_COUN_BID." as b 
					where FIND_IN_SET(a.value,b.country_value) ";
				
				if($account_id)
				{	
					$in_sel .= " and b.account_id=".$account_id."";
				}
				if($admarket)
				{
					$SQL .= " AND b.admarket in(".$admarket.")";
				}
				else
				{
					$SQL .= " AND b.admarket=0";
				}
				
					
			//test sorting.. code end
					
		//	$SQL .= " ORDER BY b.id DESC) as c,(SELECT @i := ($in_sel) + 1) as rowcount ";   
			$SQL .= " ORDER BY camp.campaignname ASC) as c,(SELECT @i := ($in_sel) + 1) as rowcount order by c.camp_name ASC"; 													
			$query 	= 	$this->db->query($SQL);
			
			//echo  $this->db->last_query();
			
			if($query->num_rows() >0)
			{
				$result = 	$query->result_array();
				if($result)
				{
					if($mem_cache=='enable' )
					{
						$account_type=$this->user_authentication->account_type;
						$this->memcached_library->set($key,$result,$account_type);	
						$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'2');	
						$set = $this->memcached_library->get($key);	
						return $set;
					}
					else{
						return $result;
					}
				}
				else
				{
					return FALSE;
				}
					//return $this->db->last_query();
			}else{
					return FALSE;	
			}
			
		}
	}
	
	function fetch_countrywise_bidding($id=false)
	{
		$key = 'edit_country_bid_'.$id;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_COUNTRY_BIDDING);
		$check_edit_changes = $this->memcached_library->get(FETCH_EDIT_COUNTRY_BIDDING);
		
		if($ret && $mem_cache=='enable' && $check_db_changes!='1' && $check_edit_changes!='1')
		{
			return $ret;
		}
		else{
			$SQL = "SELECT revenue_type,campaign_id,country_value as value,bidding_value as bidding,id as id,account_id FROM ".TAB_COUN_BID." where id=".$id."";					
			$SQL1="SELECT c.campaignname,d.revenue_type,b.bidding_value,b.id
					FROM  ".TAB_COUN_BID." as b join ".TAB_CAMPAIGNS." as c ON c.campaignid =b.campaign_id or b.campaign_id=0 join ".TAB_CONF_REVENUE_TYPE." as d ON d.revenue_id=b.revenue_type
					where  b.id=".$id.""; 

			$query 	= 	$this->db->query($SQL);
			$result = 	$query->result_array();
					
			if($result)
			{
				if($mem_cache=='enable' )
				{
					$account_type=$this->user_authentication->account_type;
					$this->memcached_library->set($key,$result,$account_type);	
					$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'2');
					$this->memcached_library->set(FETCH_EDIT_COUNTRY_BIDDING,'2');
					$set = $this->memcached_library->get($key);	
					return $set;
				}
				else{
					return $result;
				}
			}else{
					return FALSE;	
			}
		}
	}
	
	 /* 

	 * Delete the countrybidding

	 */

	 function delete_countrybidding($country_bidding_id=false,$admarket=false)
	 {			 
		 
		if($country_bidding_id)
		{

			$this->db->trans_start();			

			$this->db->where('id',$country_bidding_id); 
			
			if($admarket!=false)
			{
				$this->db->where('admarket',$admarket); 
			}

			$this->db->delete(TAB_COUN_BID);

			$this->memcached_library->set(FETCH_COUNTRY_BIDDING,'1');	  

			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;	

	}

	
	function fetch_country_reciever($country_id=FALSE)
	{ 
		if($country_id)
		{
			$client_id1 = $this->db->query('select campaign_id from '.TAB_COUN_BID.' where id ='.$country_id);
			$check_id1= $client_id1->result_array();
			if($check_id1[0]['campaign_id']!='-1')
			{
			$client_id = $this->db->query('select clientid,dj_is_admarket from '.TAB_CAMPAIGNS.' where campaignid ='.$check_id1[0]['campaign_id']);
			$check_id= $client_id->result_array();			
			//return $check_id[0]['clientid'];
			$result=$this->db->query('select tc.account_id,tc.clientid,tc.clientname as name,tc.email,tc.contact,ta.account_type from '.TAB_CLIENTS.' as tc join '.TAB_ACCOUNTS.' as ta where tc.clientid ='. $check_id[0]['clientid'].' AND ta.account_id=tc.account_id');
			$reciever=$result->result_array();
			}
			else
			{
				$receiver="All";
			}
			
			$data=array_merge($reciever[0],$check_id);
			if($reciever!="All")
			{
				return $data;
			}
			else
			{
				return "All";
			}
			
		}
		else
		{
			return FALSE;
		}

	
}
	function fetch_country_list($country_id)
	{		 
		$this->db->where('id',$country_id);
		$query = $this->db->get(TAB_TARG_COUNTRY);		
		$result = $query->result_array();
		//return $this->db->last_query(); exit();
		if($result)
		{
			return $result[0]['value'];
		}
		else
		{
			return FALSE;
		}
			
			
	}
	
	function fetch_language_list()
	{
		$this->db->select('language, lan_flip');
		$query = $this->db->get('djax_language');
		
		$result = $query->result_array();
		//return $this->db->last_query(); exit();
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;  
		}
	}
	
	//check campaign already available
	
	function exists_campaign_check($campaignid=FALSE)
	{
		$this->db->select('campaignid');
		$this->db->where_in('campaignid',$campaignid);
		//$this->db->where('is_deleted','0');
		$query=$this->db->get(TAB_CAMPAIGNS);
	
		
		if($query->num_rows()>0)
		{ 
			return $query->num_rows();
		}
		else
		{  
			return "NULL";
		}
	} 


function fetch_country_name($campaign_id,$country_value)
	{
		//return $country_value;   
		$SQL="select name from ".TAB_TARG_COUNTRY." where value IN (".$country_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	function fetch_browser_name($campaign_id,$browser_value)
	{
		$SQL="select name from ".TAB_TARG_BROWSERS." where value IN (".$browser_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	function fetch_browser_language_name($campaign_id,$lang_value)
	{		
		$SQL="select name from ".TAB_TARG_BROWSER_LANG." where value IN (".$lang_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
		
	}
	function fetch_os_name($campaign_id,$os_value)
	{
		$SQL="select name from ".TAB_TARG_OS." where value IN (".$os_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	function fetch_manu_name($campaign_id,$manufacture_value)
	{
		$SQL="select name from ".TAB_TARG_MOB_MANU." where value IN (".$manufacture_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	function fetch_cap_name($campaign_id,$capability_value)
	{
		$SQL="select name from ".TAB_TARG_MOB_CAPA." where value IN (".$capability_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	function fetch_connection_name($campaign_id,$connection_value)
	{
		$SQL="select name from ".TAB_TARG_CONN_TYPE." where value IN (".$connection_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	function fetch_isp_name($campaign_id,$isp_value)
	{
		$SQL="select country,carriername from ".TAB_TARG_MOBILE_CARRIER." where id IN (".$isp_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
		
	}
	
	function fetch_adlist_name($campaign_id,$blocklist_value)
	{
		$SQL="select adblock_list_name from ".TAB_ZONE_LIT." where advertiserid IN (".$blocklist_value.")";
		$query = $this->db->query($SQL);			
		$result = $query->result_array();  
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	

	

	
	
}


?>
