<?php
class Do_auto_link extends CI_Model
{
	
	public $agency_id='';
	
	/*
	 * 
	 * name: fetch_adblock
	 * @param :
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	 
	 function fetch_adblock($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->select('width,height,delivery,dj_zone_type');		
			$this->db->where('zoneid ',$zone_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get Creatives
	 */
	 
	 function fetch_creative($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->select('width,height,dj_banner_type');		
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to creative
	 */
	
	function link_ads($zone_id=false,$agencyid=false)
	{
		if($zone_id)
		{			
			//Sets the agency_id
			$this->agency_id 	= 	$agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_ads($zone_id);
			
			$zone_details 	= 	$this->fetch_adblock($zone_id);
			
			$zone 			= 	$zone_details[0];			

			$zone_type 		= 	$zone['dj_zone_type'];	
			
			$where_ban 		= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array(
															'web',
															'sql',
															'html',
															'url'
														),
						
									"bannertype"	=>	array(
															WEB_CREATIVE_SQL,
															WEB_CREATIVE_URL,
															WEB_CREATIVE_WEB,
															WEB_CREATIVE_HTML,
															WEB_CREATIVE_SWF
														)
								);
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
					
					$creatives 	= 	$this->fetch_match_creatives($where_ban);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					
					/* Linking mobile banners into display ads*/
					
					$mobile_ban=array(
										"storagetype"	=>	array('web','sql','html','url'),						
										"bannertype"	=>	array(MOBILE_IMAGE_CREATIVE));
										
					$mobile_creatives 	= 	$this->fetch_match_creatives($mobile_ban);
					
					if($mobile_creatives!=FALSE)
					{
						foreach($mobile_creatives as $mc)
						{
							//UPDATE ZONE AND MOBILE CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $mc['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}													
					break;
					case W_TEXT_HIGHLIGHT:
				
					$where_ban_text 		= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array(
															'web',
															'sql',
															'html',
															'url'
														),
						
									"bannertype"	=>	array(
															WEB_CREATIVE_SQL,
															WEB_CREATIVE_URL,
															WEB_CREATIVE_WEB,
															WEB_CREATIVE_HTML,
															WEB_CREATIVE_SWF
														)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where_ban_text);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					/* Linking mobile text banners into text ads*/
					
					$mobile_ban=array(
										"storagetype"	=>	array('web','sql','html','url'),						
										"bannertype"	=>	array(MOBILE_IMAGE_CREATIVE));
								
					$mobile_creatives 	= 	$this->fetch_match_creatives($mobile_ban);

					if($mobile_creatives!=FALSE)
					{
						foreach($mobile_creatives as $mc)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $mc['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}					
					break;  
				case WEB_AD_BLOCK_TEXT:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('txt'),
						
									"bannertype"	=>	array(WEB_CREATIVE_TEXT)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					/* Linking mobile text banners into text ads*/
					
					$mobile_ban = 	array(
									"storagetype"	=>	array('txt'),
						
									"bannertype"	=>	array(MOBILE_TEXT_CREATIVE)
								);
								
					$mobile_creatives 	= 	$this->fetch_match_creatives($mobile_ban);

					if($mobile_creatives!=FALSE)
					{
						foreach($mobile_creatives as $mc)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $mc['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}					
					break;  
					case WEB_AD_GOOGLE:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('txt'),
						
									"bannertype"	=>	array(WEB_AD_GOOGLE)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					/* Linking mobile text banners into text ads*/
					
				/*	$mobile_ban = 	array(
									"storagetype"	=>	array('txt'),
						
									"bannertype"	=>	array(MOBILE_TEXT_CREATIVE)
								);
								
					$mobile_creatives 	= 	$this->fetch_match_creatives($mobile_ban);

					if($mobile_creatives!=FALSE)
					{
						foreach($mobile_creatives as $mc)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $mc['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}		*/			
					break;  
				case W_A_EP:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(W_EP)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					
					break;  
				case WEB_AD_BLOCK_DHTML:				
					
					$creatives 	= 	$this->fetch_match_creatives($where_ban);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
					
				case VIDEO_AD_BLOCK_INLINE:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('html'),
						
									"bannertype"	=>	array(VIDEO_CREATIVE_INLINE)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				//VIDEO_AD_BLOCK_REAL
					
				case VIDEO_AD_BLOCK_REAL:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('html'),
						
									"bannertype"	=>	array(VIDEO_CREATIVE_REAL)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
					
				//VIDEO_AD_BLOCK_SMAll
					
				case VIDEO_AD_BLOCK_SMALL:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('html'),
						
									"bannertype"	=>	array(VIDEO_CREATIVE_SMALL)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
					
					// Small code ads vedio add deveping 
					
					
				//VIDEO_AD_BLOCK_BOX
					
				case VIDEO_AD_BLOCK_BOX:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('html'),
						
									"bannertype"	=>	array(VIDEO_CREATIVE_BOX)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
					
					// Box code ads vedio add deveping 
					
				//VIDEO_AD_BLOCK_HEAD
					
				case VIDEO_AD_BLOCK_HEAD:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('html'),
						
									"bannertype"	=>	array(VIDEO_CREATIVE_HEAD)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
					
					// Head code ads vedio add deveping 
					
								
					
				case VIDEO_AD_BLOCK_OVERLAY:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('html'),
						
									"bannertype"	=>	array(VIDEO_CREATIVE_OVERLAY)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				
				// New customisation Ad Formats 
				case WEB_AD_BLOCK_EXIT_POPUNDER:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_EXIT_POPUNDER)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				
				case WEB_AD_BLOCK_POPUNDER:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_POP)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_POPUP:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_POP)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_DIRECT:				
					
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_DIRECT)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);					
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_LAYER:
					
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web','html','url'),
						
									"bannertype"	=>	array(WEB_CREATIVE_LAYER)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
						
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_NATIVE:
					
					$where 	= 	array(
							
										"storagetype"	=>	array('web','url'),
						
									    "bannertype"	=>	array(WEB_CREATIVE_NATIVE)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					if($creatives!=FALSE)
					{

						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							 $link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

					     	$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_INTERSTITIAL:
					
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web','html','url'),
						
									"bannertype"	=>	array(WEB_CREATIVE_LAYER)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
						
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_GAMEBOX:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_GAMEBOX)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);	
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_BANNERBOX:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_BANNERBOX)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);	
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_SLIDER:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web','html','url'),
						
									"bannertype"	=>	array(WEB_CREATIVE_SLIDER,MOBILE_CREATIVE_SLIDER)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_CATFISH:
					
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web','txt'),
						
									"bannertype"	=>	array(WEB_CREATIVE_CATFISH,MOBILE_CREATIVE_CATFISH,APP_CREATIVE_CATFISH)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_AD_BLOCK_SITESKIN:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_SITESKIN)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
					
				case WEB_AD_BLOCK_TOPBAR:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_TOPBAR)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;	
					
				// Mobile Ad Blocks
				
				case MOBILE_AD_BLOCK_IMAGE:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_IMAGE_CREATIVE)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;

				case MOBILE_AD_BLOCK_INTERSTITIAL:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_MRAID_CREATIVE_INTERSTITAL)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_AD_BLOCK_EXPAND:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_MRAID_CREATIVE_EXPAND)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	

							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;

				case MOBILE_AD_BLOCK_REVEAL:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_MRAID_CREATIVE_REVEAL)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_AD_BLOCK_FLEX:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_RS_CREATIVE_FLEX)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	

							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_AD_BLOCK_ADHENSION:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_RS_CREATIVE_ADHESION)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_AD_BLOCK_FLIMSTRIP:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_RS_CREATIVE_FILMSTRIP)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_AD_BLOCK_SLIDER:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_RS_CREATIVE_SLIDER)
								);							
																
					$creatives 	= 	$this->fetch_match_creatives($where);			
										

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;

				case MOBILE_AD_BLOCK_PULL:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_RS_CREATIVE_PULL)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_AD_BLOCK_TEXT:

					$where 	= 	array(
									"storagetype"	=>	array('txt'),
						
									"bannertype"	=>	array(MOBILE_TEXT_CREATIVE)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;
					
				case MOBILE_AD_BLOCK_DIALOG:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_DIALOGUE_CREATIVE)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;
					
				case MOBILE_AD_BLOCK_NOTIFICATION:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(MOBILE_NOTIFICATION_CREATIVE)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;
				case MOBILE_APP_AD_BLOCK_INTERSTITIAL:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(APP_CREATIVE_INTERSTITAL)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;
					
				case MOBILE_APP_AD_BLOCK_FOOTER:

					$where 	= 	array(
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(APP_CREATIVE_CATFISH)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);

					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;
					
				case MOBILE_APP_AD_BLOCK_VIDEO:
										
					$where 	= 	array(
									"storagetype"	=>	array('html'),
						
									"bannertype"	=>	array(APP_VIDEO_CREATIVE_HTML5)
								);
								
					$creatives 	= 	$this->fetch_match_creatives($where);
										
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;			
								
			}
			//$this->response($zone);
		}
	}
	
	/*
	 * 
	 * name: fetch_web_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	function fetch_web_creatives($where=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}	
	
	/*
	 * 
	 * name: fetch_dhtml_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_dhtml_creatives($where=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a text creative
	 */
	 function fetch_text_creatives()
	 {
		$this->db->select('oxb.bannerid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		
		$this->db->where('oxb.storagetype', 'txt');
		$this->db->where('oxb.dj_banner_type', WEB_CREATIVE_TEXT);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_inline_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline creative
	 */
	 function fetch_inline_creatives($where=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_INLINE);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_overlay_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_overlay_creatives($where=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_OVERLAY);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function add_link_ads($link_assoc_data)
	{
		if($link_assoc_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_AD_ZONE_ASSOC,$link_assoc_data);
			
			$insert_id	= $this->db->insert_id();

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $insert_id;
			}
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: unlink_ads
	 * @param : zone_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_ads($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->trans_start();
			
			$this->db->where('zone_id',$zone_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: unlink_blocks
	 * @param : creative_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_blocks($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->trans_start();
			
			$this->db->where('ad_id',$creative_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_adblocks
	 * @param : creative_id
	 * @return : NULL
	 * 
	 * Link creative to blocks
	 */
	
	function link_adblocks($creative_id=false,$agencyid=false)
	{
		if($creative_id)
		{
			
			$this->agency_id 	= 	$agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_blocks($creative_id);
			
			$creative_details 	= 	$this->fetch_creative($creative_id);
			$creative 			= 	$creative_details[0];
			
			$banner_type 		= 	$creative['dj_banner_type'];
			
			$where_web 	= 	array(
							"size"	=>	array(
										"oxz.width" 	=> 	$creative['width'],
										"oxz.height" 	=> 	$creative['height']
									)
							);
													
			switch($banner_type)
			{
				case WEB_CREATIVE_WEB:
					
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{	
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				case WEB_CREATIVE_SQL:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				case WEB_CREATIVE_SWF:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_CREATIVE_HTML:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				case WEB_CREATIVE_URL:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{	
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}
					break;
				case WEB_CREATIVE_TEXT:
					
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_TEXT);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
				
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				
				case VIDEO_CREATIVE_INLINE:
				
					$where_web["zonetype"] 	= 	array(VIDEO_AD_BLOCK_INLINE);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				case VIDEO_CREATIVE_OVERLAY:
				
					$where_web["zonetype"] 	= 	array(VIDEO_AD_BLOCK_OVERLAY);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				
				// Additional Ad Blocks
				
				case WEB_CREATIVE_EXIT_POPUNDER:
														
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_EXIT_POPUNDER);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
															
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{	
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
													
							$this->add_link_ads($link_assoc_data);
						}
					}		
					
					break;					
					
				
				case WEB_CREATIVE_POP:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_POPUP,WEB_AD_BLOCK_POPUNDER);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				case WEB_CREATIVE_DIRECT:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_DIRECT);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				case WEB_CREATIVE_LAYER:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_LAYER,WEB_AD_BLOCK_INTERSTITIAL);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				case WEB_CREATIVE_GAMEBOX:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_GAMEBOX);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				case WEB_CREATIVE_BANNERBOX:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_BANNERBOX);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				case WEB_CREATIVE_SLIDER:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_SLIDER);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				case WEB_CREATIVE_CATFISH:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_CATFISH);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				case WEB_CREATIVE_SITESKIN:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_SITESKIN);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
					
				case WEB_AD_BLOCK_TOPBAR:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_TOPBAR);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);	
										
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);							
							
						}
					}
					break;
					
				case WEB_CREATIVE_NATIVE:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_NATIVE);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);	
										
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);							
							
						}
					}
					break;
				
				case MOBILE_CREATIVE_CATFISH:
				
					$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_CATFISH);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_web);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;	

				// Mobile Ad Blocks
				
				case MOBILE_DIALOGUE_CREATIVE:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_DIALOG);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;
					
				case MOBILE_NOTIFICATION_CREATIVE:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_NOTIFICATION);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;
				case MOBILE_IMAGE_CREATIVE:

					$where_mob["zonetype"] 	= 	array(WEB_AD_BLOCK_BANNER);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;


				case MOBILE_TEXT_CREATIVE:

					$where_mob["zonetype"] 	= 	array(WEB_AD_BLOCK_TEXT);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;

				case MOBILE_MRAID_CREATIVE_INTERSTITAL:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_INTERSTITIAL);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_MRAID_CREATIVE_EXPAND:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_EXPAND);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_MRAID_CREATIVE_REVEAL:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_REVEAL);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}

					break;

				case MOBILE_RS_CREATIVE_FLEX:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_FLEX);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;

				case MOBILE_RS_CREATIVE_ADHESION:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_ADHENSION);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;

				case MOBILE_RS_CREATIVE_FILMSTRIP:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_FLIMSTRIP);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;

				case MOBILE_RS_CREATIVE_PULL:

					$where_mob["zonetype"] 	= 	array(MOBILE_AD_BLOCK_PULL);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;

				case MOBILE_CREATIVE_SLIDER:

					$where_mob["zonetype"] 	= 	array(WEB_AD_BLOCK_SLIDER);
								
					$adblocks 	= 	$this->fetch_match_adblocks($where_mob);

					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);	
						}
					}

					break;
				case APP_CREATIVE_INTERSTITAL:
				
					$wherewebs["zonetype"] 	= 	array(MOBILE_APP_AD_BLOCK_INTERSTITIAL);
								
					$adblocks 	= 	$this->fetch_match_adblocks($wherewebs);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				case APP_CREATIVE_CATFISH:
				
					$wherewebs["zonetype"] 	= 	array(MOBILE_APP_AD_BLOCK_FOOTER);
								
					$adblocks 	= 	$this->fetch_match_adblocks($wherewebs);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;
				case APP_VIDEO_CREATIVE_HTML5:
				
					$wherewebs["zonetype"] 	= 	array(MOBILE_APP_AD_BLOCK_VIDEO);
								
					$adblocks 	= 	$this->fetch_match_adblocks($wherewebs);
					
					if($adblocks!=FALSE)
					{
						foreach($adblocks as $bl)
						{							
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
							$this->add_link_ads($link_assoc_data);
						}
					}
					break;	
			}
			//$this->response($zone);  
		}
	}
	
	/*
	 * 
	 * name: fetch_banner_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a web blocks
	 */
	 function fetch_banner_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML));
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a text blocks
	 */
	
	function fetch_text_adblocks()
	{
		$this->db->select('oxz.zoneid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id){
		$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_TEXT));
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_overlay_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay blocks
	 */
	 function fetch_overlay_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_OVERLAY);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_inline_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_inline_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_INLINE);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/**************************************************************************************
	 * 									Match AD CREATIVE
	 * ************************************************************************************/
	 
	/*
	 * 
	 * name: fetch_match_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a matched creative with adblock
	 */
	function fetch_match_creatives($where=false)
	{
		if($where)
		{
			$this->db->select('oxb.bannerid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			
			if(isset($where['size']))
			{
				$this->db->where($where['size']);
			}			
			$this->db->where_in('oxb.storagetype', $where['storagetype']);
			$this->db->where_in('oxb.dj_banner_type', $where['bannertype']);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/**************************************************************************************
	 * 									Match AD BLOCK
	 * ************************************************************************************/
	 
	/*
	 * 
	 * name: fetch_match_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a matched blocks with creative
	 */
	 function fetch_match_adblocks($where=false)
	 {
		if($where)
		{
			$key = 'fetch_match_adblocks';
			if($where['size'])
			{
				$key.='_'.$where['size'];
			}
			if($where['zonetype'])
			{
				$key.='_'.$where['zonetype'];
			}			
			$ret = $this->memcached_library->get($key);
			$mem_cache = $this->default_configurations->get('adgate_memcache');	
			if($ret && $mem_cache=='enable' )
			{
			return $ret;
			}
			else{		
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if(isset($where['size']))
			{
				$this->db->where($where['size']);
			}
			$this->db->where_in('oxz.dj_zone_type', $where['zonetype']);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_rotator_camapign_ads
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to selected camapign creative
	 */
	
	function link_rotator_camapign_ads($zone_id=false,$campaign_id=false,$size=false,$banner_type=false)
	{
		if($zone_id)
		{			
			//Sets the agency_id
			$this->agency_id 	= 	$agencyid;
			$result='';
			// Unlink the previously linked creatives for zone
			$this->unlink_ads($zone_id);
			$explode_size = explode("x",$size);
			$where_size 	= 	array(
							"size"	=>	array(
										"oxb.width" 	=> $explode_size[0],
										"oxb.height" 	=> 	$explode_size[1]
									)
							);
			$creative_size=explode('x',$size);				
			foreach($campaign_id as $cam_id){
			$creatives 	= 	$this->fetch_campaign_match_creatives($cam_id,$creative_size[0],$creative_size[1],$banner_type);
				//return $creatives;
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$result =$result.','.$this->add_link_ads($link_assoc_data);
							
						}
					}
					
					
				}
				if($result)
							{			
								return $result;
							}
							else
							{
								return FALSE;
							}
			
		}
		
	}
	
	/*
	 * 
	 * name: fetch_campaign_match_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a matched creative with adblock
	 */
	function fetch_campaign_match_creatives($campaign_id=false,$width=false,$height=false,$banner_type=false)
	{
		if($campaign_id)
		{
			/*$this->db->select('oxb.bannerid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			//if($this->agency_id)
			//{
				//$this->db->where('oxcl.agencyid',$this->agency_id);
			//}
			if(isset($where_size['size']))
			{
				$this->db->where($where_size['size']);
			}
			//if(isset($campaign_id))
			//{
				$this->db->where('oxb.campaignid',$campaign_id);
			//}			
			//$this->db->where_in('oxb.storagetype', $where['storagetype']);
			//$this->db->where_in('oxb.dj_banner_type', $where['bannertype']);
			//$this->db->where('oxb.dj_is_deleted',0);
			$query = $this->db->get(TAB_BANNERS.' as oxb');*/
			
			$query=$this->db->query('select distinct bannerid from(select 
			oxc.campaignname as campaignname ,
			oxc.campaignid as campaignid ,
			oxb.width as width,
			oxb.height as height,
			oxb.filename as filename,
			oxb.dj_banner_type as banner_type,
			0 as display_type,
			0 as imageid,
			oxb.bannerid as bannerid,
			oxb.bannertext as bannertext,
			oxb.contenttype as contenttype
			
			from '.TAB_BANNERS.' AS oxb join ' .TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid ='.$campaign_id.'  and oxc.dj_is_rtb_campaign="0" AND oxb.dj_is_deleted="0" AND oxc.dj_is_deleted="0" and oxb.width = '.$width.' and oxb.height = '.$height.' and oxb.dj_banner_type = "'.$banner_type.'"

			union 

			select oxc.campaignname as campaignname ,
			oxc.campaignid as campaignid,
			dab.width as width ,
			dab.height as height,
			dab.file_path as filename,
			oxb.dj_banner_type as banner_type,
			dab.display_type as display_type,
			dab.image_id as imageid,
			dab.banner_id as bannerid,
			oxb.bannertext as bannertext,
			oxb.contenttype as contenttype
			
			from djax_additional_banners AS dab join '.TAB_BANNERS.' AS oxb on dab.banner_id=oxb.bannerid join ' .TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid='.$campaign_id.' and oxc.dj_is_rtb_campaign="0" AND oxb.dj_is_deleted="0" AND oxc.dj_is_deleted="0" and dab.width = '.$width.' and dab.height = '.$height.' and oxb.dj_banner_type = "'.$banner_type.'") as c ');	
			//return $this->db->last_query(); 	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
}
