<?php
Class Do_antifraud extends CI_Model
{
	
	/*  ox_zones
	 * ---------------------
	 *  zonename
	 * 	width
	 *  Height
	 *  oac_category_id
	 *  dj_added_date
	 * 	is_deleted
	 * */
	 
	 public function list_fraudclicks($search_arr = FALSE)
	 {
		
		$query = $this->db->get(TAB_AD_FRAUD_CLK.' as adfc');
	
		$result = $query->result_array();
		
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		} 
	 }
	 
 	 /*
	* 
	* name: antifraud_valid_list
	* @param : null
	* @return : antifraud list list 
    */
	public function antifraud_statistics_list($columns,$search,$group,$order)
	{
		 
		$key = 'antifraud_statistics_list_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			$this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress,taf.country,ta.account_id,oxz.zonename,djs.site_name,djs.site_url,djs.site_id');
			$this->db->where('taa.agencyid',$search['agency_id']);		
			$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=taf.zone_id');
			$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz','oxsz.zone_id=oxz.zoneid');
			$this->db->join(TAB_PUB_SITES.' as djs','djs.site_id=oxsz.site_id');
			$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid AND ta.account_id=djs.account_id');
			$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('ta.account_id',$pub);
			endif;
			
			if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
				$this->db->where_in('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
				$this->db->where('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
				$this->db->where('taa.agencyid',$search['agency_id']);		
			}
						
			if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id'])){
				$this->db->where_in('djs.site_id',$search['site_id']);		
			}
			else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
				$this->db->where('djs.site_id',$search['pub_account_id']);		
			}
			
			if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
				$this->db->where_in('taf.zone_id',$search['adblock_id']);		
			}
			else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
				$this->db->where('taf.zone_id',$search['adblock_id']);		
			}
			
			if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
				$this->db->where_in('taf.country',$search['country']);		
			}
			else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
				$this->db->where('taf.country',$search['country']);		
			}
			
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
					$this->db->where('DATE(taf.datetime)=',$search['date_from']);
				}
				else
				{
					$this->db->where('DATE(taf.datetime)>=',$search['date_from']);
					$this->db->where('DATE(taf.datetime)<=',$search['date_to']);
				}				
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$this->db->where('DATE(taf.datetime)=',$search['date_from']);
			}
			
			/*if(is_array($group) AND !empty($group) AND count($group) > 0){
				foreach($group as $val){
					$this->db->GROUP_BY($val);
				}
			}
			else
			{*/
				$this->db->GROUP_BY('date');
				$this->db->GROUP_BY('pubid');
				$this->db->GROUP_BY('taf.zone_id');
				$this->db->GROUP_BY('url');
				$this->db->GROUP_BY('ipaddress');
			//}
			
			if(is_array($order) AND count($order) > 0){
			
				foreach($order as $key=>$option){
					$this->db->ORDER_BY($key,$option);
				}
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				foreach($ord as $key){
					$this->db->ORDER_BY($key,'DESC');
				}	
			}
			else
			{
				$this->db->ORDER_BY('taf.id','DESC');	
			}
			
			$query = $this->db->get(TAB_ANTI_FRAUD.' as taf');
			$result = $query->result_array();  
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
				return FALSE;
		}
		 
	}
	 
 	 /*
	* 
	* name: antifraud_valid_list
	* @param : null
	* @return : antifraud list list 
    */
	public function antifraud_statistics_imp_list($columns,$search,$group,$order)
	{
		 
		$key = 'antifraud_statistics_list_imp_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
			$this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress,taf.country,ta.account_id,oxz.zonename,djs.site_name,djs.site_url,djs.site_id');
			$this->db->where('taa.agencyid',$search['agency_id']);		
			$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=taf.zone_id');
			$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz','oxsz.zone_id=oxz.zoneid');
			$this->db->join(TAB_PUB_SITES.' as djs','djs.site_id=oxsz.site_id');
			$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid AND ta.account_id=djs.account_id');
			$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('ta.account_id',$pub);
			endif;
			
			if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
				$this->db->where_in('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
				$this->db->where('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
				$this->db->where('taa.agencyid',$search['agency_id']);		
			}
						
			if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id'])){
				$this->db->where_in('djs.site_id',$search['site_id']);		
			}
			else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
				$this->db->where('djs.site_id',$search['pub_account_id']);		
			}
			
			if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
				$this->db->where_in('taf.zone_id',$search['adblock_id']);		
			}
			else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
				$this->db->where('taf.zone_id',$search['adblock_id']);		
			}
			
			if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
				$this->db->where_in('taf.country',$search['country']);		
			}
			else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
				$this->db->where('taf.country',$search['country']);		
			}
			
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
					$this->db->where('DATE(taf.datetime)=',$search['date_from']);
				}
				else
				{
					$this->db->where('DATE(taf.datetime)>=',$search['date_from']);
					$this->db->where('DATE(taf.datetime)<=',$search['date_to']);
				}				
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$this->db->where('DATE(taf.datetime)=',$search['date_from']);
			}
			
			/*if(is_array($group) AND !empty($group) AND count($group) > 0){
				foreach($group as $val){
					$this->db->GROUP_BY($val);
				}
			}
			else
			{*/
				$this->db->GROUP_BY('date');
				$this->db->GROUP_BY('pubid');
				$this->db->GROUP_BY('taf.zone_id');
				$this->db->GROUP_BY('url');
				$this->db->GROUP_BY('ipaddress');
			//}
			
			if(is_array($order) AND count($order) > 0){
			
				foreach($order as $key=>$option){
					$this->db->ORDER_BY($key,$option);
				}
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				foreach($ord as $key){
					$this->db->ORDER_BY($key,'DESC');
				}	
			}
			else
			{
				$this->db->ORDER_BY('taf.id','DESC');	
			}
			
			$query = $this->db->get(TAB_ANTI_FRAUD_IMP.' as taf');
			$result = $query->result_array();  
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
				return FALSE;
		}
		 
	}

	 /*
	* 
	* name: antifraud_valid_list
	* @param : null
	* @return : antifraud list list 
    */
	public function antifraud_list($columns,$search,$group,$order)
	{	 
		 
		$key = 'antifraud_list_'.implode('_',$columns).'_';
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		 		 
			$this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress,taf.id as id,taf.country,ta.account_id,oxz.zonename,djs.site_name,djs.site_url,djs.site_id');
			$this->db->where_not_in('taf.fclicks',0);
			$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=taf.zone_id');
			$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz','oxsz.zone_id=oxz.zoneid');
			$this->db->join(TAB_PUB_SITES.' as djs','djs.site_id=oxsz.site_id');
			$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid AND ta.account_id=djs.account_id');
			$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('ta.account_id',$pub);
			endif;
			
			if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
				$this->db->where_in('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
				$this->db->where('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
				$this->db->where('taa.agencyid',$search['agency_id']);		
			}
			
			if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id'])){
				$this->db->where_in('djs.site_id',$search['site_id']);		
			}
			else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
				$this->db->where('djs.site_id',$search['pub_account_id']);		
			}
			
			if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
				$this->db->where_in('taf.zone_id',$search['adblock_id']);		
			}
			else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
				$this->db->where('taf.zone_id',$search['adblock_id']);		
			}
			
			if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
				$this->db->where_in('taf.country',$search['country']);		
			}
			else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
				$this->db->where('taf.country',$search['country']);		
			}
			
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
					$this->db->where('DATE(taf.datetime)=',$search['date_from']);
				}
				else
				{
					$this->db->where('DATE(taf.datetime)>=',$search['date_from']);
					$this->db->where('DATE(taf.datetime)<=',$search['date_to']);
				}				
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$this->db->where('DATE(taf.datetime)=',$search['date_from']);
			}
			
			/*if(is_array($group) AND !empty($group) AND count($group) > 0){
				foreach($group as $val){
					$this->db->GROUP_BY($val);
				}
			}
			else
			{*/
				$this->db->GROUP_BY('date');
				$this->db->GROUP_BY('pubid');
				$this->db->GROUP_BY('taf.zone_id');
				$this->db->GROUP_BY('url');
				$this->db->GROUP_BY('ipaddress');
			//}
			
			if(is_array($order) AND count($order) > 0){
			
				foreach($order as $key=>$option){
					$this->db->ORDER_BY($key,$option);
				}
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				foreach($ord as $key){
					$this->db->ORDER_BY($key,'DESC');
				}	
			}
			else
			{
				$this->db->ORDER_BY('taf.id','DESC');	
			}
			
			$query = $this->db->get(TAB_ANTI_FRAUD.' as taf');
			$result = $query->result_array();
			if($result)
			{
				
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
				return FALSE;
		}
     
	}
	
		 /*
	* 
	* name: antifraud_valid_list
	* @param : null
	* @return : antifraud list list 
    */
	public function antifraud_imp_list($columns,$search,$group,$order)
	{	 
		 
		$key = 'antifraud_list_imp_'.implode('_',$columns).'_';
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		 		 
			$this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress,taf.id as id,taf.country,ta.account_id,oxz.zonename,djs.site_name,djs.site_url,djs.site_id');
			$this->db->where_not_in('taf.fclicks',0);
			$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=taf.zone_id');
			$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz','oxsz.zone_id=oxz.zoneid');
			$this->db->join(TAB_PUB_SITES.' as djs','djs.site_id=oxsz.site_id');
			$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid AND ta.account_id=djs.account_id');
			$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('ta.account_id',$pub);
			endif;
			
			if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
				$this->db->where_in('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
				$this->db->where('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
				$this->db->where('taa.agencyid',$search['agency_id']);		
			}
			
			if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id'])){
				$this->db->where_in('djs.site_id',$search['site_id']);		
			}
			else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
				$this->db->where('djs.site_id',$search['pub_account_id']);		
			}
			
			if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
				$this->db->where_in('taf.zone_id',$search['adblock_id']);		
			}
			else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
				$this->db->where('taf.zone_id',$search['adblock_id']);		
			}
			
			if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
				$this->db->where_in('taf.country',$search['country']);		
			}
			else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
				$this->db->where('taf.country',$search['country']);		
			}
			
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
					$this->db->where('DATE(taf.datetime)=',$search['date_from']);
				}
				else
				{
					$this->db->where('DATE(taf.datetime)>=',$search['date_from']);
					$this->db->where('DATE(taf.datetime)<=',$search['date_to']);
				}				
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$this->db->where('DATE(taf.datetime)=',$search['date_from']);
			}
			
			/*if(is_array($group) AND !empty($group) AND count($group) > 0){
				foreach($group as $val){
					$this->db->GROUP_BY($val);
				}
			}
			else
			{*/
				$this->db->GROUP_BY('date');
				$this->db->GROUP_BY('pubid');
				$this->db->GROUP_BY('taf.zone_id');
				$this->db->GROUP_BY('url');
				$this->db->GROUP_BY('ipaddress');
			//}
			
			if(is_array($order) AND count($order) > 0){
			
				foreach($order as $key=>$option){
					$this->db->ORDER_BY($key,$option);
				}
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				foreach($ord as $key){
					$this->db->ORDER_BY($key,'DESC');
				}	
			}
			else
			{
				$this->db->ORDER_BY('taf.id','DESC');	
			}
			
			$query = $this->db->get(TAB_ANTI_FRAUD_IMP.' as taf');
			$result = $query->result_array();
			if($result)
			{
				
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
				return FALSE;
		}
     
	}

	
	
	/*
	* 
	* name: fetch_anti_penality_list
	* @param : null
	* @return : penality list 
    */	
	public function penality_list($columns,$search,$group,$order)
	{
		
		$key = 'penality_list_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$this->db->select('DATE(tp.date_time) as date,tp.pubname as pubname,tp.pubid as pubid,SUM(tp.penaltypoint) as penaltypoint,tp.country,ta.account_id,oxz.zonename,djs.site_name,djs.site_url,djs.site_id');
			$this->db->where('taa.agencyid',$search['agency_id']);
			$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=tp.zone_id');
			$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz','oxsz.zone_id=oxz.zoneid');
			$this->db->join(TAB_PUB_SITES.' as djs','djs.site_id=oxsz.site_id');
			$this->db->join(TAB_AFFILIATE.' as ta','tp.pubid=ta.affiliateid AND ta.account_id=djs.account_id');	
			$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('ta.account_id',$pub);
			endif;
			
			if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
				$this->db->where_in('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
				$this->db->where('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
				$this->db->where('taa.agencyid',$search['agency_id']);		
			}
			
			if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id'])){
				$this->db->where_in('djs.site_id',$search['site_id']);		
			}
			else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
				$this->db->where('djs.site_id',$search['pub_account_id']);		
			}
			
			if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
				$this->db->where_in('tp.zone_id',$search['adblock_id']);		
			}
			else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
				$this->db->where('tp.zone_id',$search['adblock_id']);		
			}
			
			if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
				$this->db->where_in('tp.country',$search['country']);		
			}
			else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
				$this->db->where('tp.country',$search['country']);		
			}
			
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
					$this->db->where('DATE(tp.date_time)=',$search['date_from']);
				}
				else
				{
					$this->db->where('DATE(tp.date_time)>=',$search['date_from']);
					$this->db->where('DATE(tp.date_time)<=',$search['date_to']);
				}				
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$this->db->where('DATE(tp.date_time)=',$search['date_from']);
			}
			
			/*if(is_array($group) AND !empty($group) AND count($group) > 0){
				foreach($group as $val){
					$this->db->GROUP_BY($val);
				}
			}
			else
			{*/
				$this->db->GROUP_BY('date');
				$this->db->GROUP_BY('pubid');
				//$this->db->GROUP_BY('url');
				//$this->db->GROUP_BY('ipaddress');
			//}
			
			if(is_array($order) AND count($order) > 0){
			
				foreach($order as $key=>$option){
					$this->db->ORDER_BY($key,$option);
				}
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				foreach($ord as $key){
					$this->db->ORDER_BY($key,'DESC');
				}	
			}
			else
			{
				//$this->db->ORDER_BY('tp.id','DESC');
				$this->db->order_by('DATE(tp.date_time)',DESC);	
			}			
			
			$query = $this->db->get(TAB_PENALITIES.' as tp');
			//echo $this->db->last_query();exit;
			$result = $query->result_array();
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
				return FALSE;
		}
		
	}
	
		/*
	* 
	* name: fetch_anti_penality_list
	* @param : null
	* @return : penality list 
    */	
	public function penality_imp_list($columns,$search,$group,$order)
	{
		
		$key = 'penality_list_imp_'.implode('_',$columns).'_';
		
		foreach($search as $skey=>$value)
		{
			$key .=	$skey.'_'.((is_array($value))?implode('_',$value):$value).'_';
		}
		
		$key .=	implode('_',$group).'_';
		
		foreach($order as $okey=>$option)
		{
			$key .=	$okey.$option.'_';
		}
		
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		
			$this->db->select('DATE(tp.date_time) as date,tp.pubname as pubname,tp.pubid as pubid,SUM(tp.penaltypoint) as penaltypoint,tp.country,ta.account_id,oxz.zonename,djs.site_name,djs.site_url,djs.site_id');
			$this->db->where('taa.agencyid',$search['agency_id']);
			$this->db->join(TAB_ZONES.' as oxz','oxz.zoneid=tp.zone_id');
			$this->db->join(TAB_SITE_ZONE_ASSOC.' as oxsz','oxsz.zone_id=oxz.zoneid');
			$this->db->join(TAB_PUB_SITES.' as djs','djs.site_id=oxsz.site_id');
			$this->db->join(TAB_AFFILIATE.' as ta','tp.pubid=ta.affiliateid AND ta.account_id=djs.account_id');	
			$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
			if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
				$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
			
				$this->db->where_in('ta.account_id',$pub);
			endif;
			
			if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND is_array($search['pub_account_id'])){
				$this->db->where_in('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['pub_account_id']) AND $search['pub_account_id'] != '' AND !is_array($search['pub_account_id'])){
				$this->db->where('ta.account_id',$search['pub_account_id']);		
			}
			else if(isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0){
				$this->db->where('taa.agencyid',$search['agency_id']);		
			}
			
			if(isset($search['site_id']) AND $search['site_id'] != '' AND is_array($search['site_id'])){
				$this->db->where_in('djs.site_id',$search['site_id']);		
			}
			else if(isset($search['site_id']) AND $search['site_id'] != '' AND !is_array($search['site_id'])){
				$this->db->where('djs.site_id',$search['pub_account_id']);		
			}
			
			if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND is_array($search['adblock_id'])){
				$this->db->where_in('tp.zone_id',$search['adblock_id']);		
			}
			else if(isset($search['adblock_id']) AND $search['adblock_id'] != '' AND !is_array($search['adblock_id'])){
				$this->db->where('tp.zone_id',$search['adblock_id']);		
			}
			
			if(isset($search['country']) AND $search['country'] != '' AND is_array($search['country'])){
				$this->db->where_in('tp.country',$search['country']);		
			}
			else if(isset($search['country']) AND $search['country'] != '' AND !is_array($search['country'])){
				$this->db->where('tp.country',$search['country']);		
			}
			
			if(isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '' ){
				if(isset($search['date_from']) AND $search['date_from'] == $search['date_to']){
					$this->db->where('DATE(tp.date_time)=',$search['date_from']);
				}
				else
				{
					$this->db->where('DATE(tp.date_time)>=',$search['date_from']);
					$this->db->where('DATE(tp.date_time)<=',$search['date_to']);
				}				
			}
			else if(isset($search['date_from']) AND $search['date_from'] != ''){
				$this->db->where('DATE(tp.date_time)=',$search['date_from']);
			}
			
			/*if(is_array($group) AND !empty($group) AND count($group) > 0){
				foreach($group as $val){
					$this->db->GROUP_BY($val);
				}
			}
			else
			{*/
				$this->db->GROUP_BY('date');
				$this->db->GROUP_BY('pubid');
				//$this->db->GROUP_BY('url');
				//$this->db->GROUP_BY('ipaddress');
			//}
			
			if(is_array($order) AND count($order) > 0){
			
				foreach($order as $key=>$option){
					$this->db->ORDER_BY($key,$option);
				}
			}
			elseif((!is_array($order)) && $order!='')
			{
				$ord	=	explode(',', $order);
				
				foreach($ord as $key){
					$this->db->ORDER_BY($key,'DESC');
				}	
			}
			else
			{
				//$this->db->ORDER_BY('tp.id','DESC');
				$this->db->order_by('DATE(tp.date_time)',DESC);	
			}			
			
			$query = $this->db->get(TAB_IMP_PENALITIES.' as tp');
			//echo $this->db->last_query();exit;
			$result = $query->result_array();
			if($result)
			{
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
				return FALSE;
		}
		
	}
	
	public function antifraud_statistics_filter($agencyid,$from_dt,$to_dt)
	{
		
		$key = 'antifraud_statistics_filter_'.$agencyid.'_'.$from_dt.'_'.$to_dt;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
	    $this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress,taf.id as id');
		//$this->db->where_not_in('taf.fclicks',0);
		$this->db->where('taa.agencyid',$agencyid);
		$this->db->where('DATE(taf.datetime)>=',$from_dt);
		$this->db->where('DATE(taf.datetime)<=',$to_dt);		
		$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid');
		$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
		if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
			$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
		
			$this->db->where_in('ta.account_id',$pub);
		endif;
		$this->db->GROUP_BY('date');
		$this->db->GROUP_BY('ta.name');
		$this->db->GROUP_BY('taf.url');
		$this->db->GROUP_BY('taf.ipaddress');
		$this->db->order_by('taf.id');
	    $query = $this->db->get(TAB_ANTI_FRAUD.' as taf');
		$result = $query->result_array();
		if($result)
		{
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}	
		}
		else
			return FALSE;
    }
}
    
    public function penality_statistics_filter($agencyid,$from_dt,$to_dt)
    {
		
		$key = 'penality_statistics_filter_'.$agencyid.'_'.$from_dt.'_'.$to_dt;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		
		if($ret && $mem_cache=='enable' )
		{
			return $ret;
		}
		else{
		$this->db->select('DATE(tp.date_time) as date,tp.pubname as pubname,SUM(tp.penaltypoint) as penaltypoint');
		$this->db->where('taa.agencyid',$agencyid);
		$this->db->where('DATE(tp.date_time)>=',$from_dt);
		$this->db->where('DATE(tp.date_time)<=',$to_dt);		
		$this->db->join(TAB_AFFILIATE.' as ta','tp.pubid=ta.affiliateid');
		$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
		if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='5'):
			$pub	=	explode(',',$this->user_authentication->manager_adv_pub_id);
		
			$this->db->where_in('ta.account_id',$pub);
		endif;
		$this->db->GROUP_BY('tp.pubname');
		$this->db->GROUP_BY('DATE(tp.date_time)');
		$query = $this->db->get(TAB_PENALITIES.' as tp');
		$result = $query->result_array();
		if($result)
		{
		if($mem_cache=='enable' )
		{
		$account_type=$this->user_authentication->account_type;
		$this->memcached_library->set($key,$result,$account_type);	
		$set = $this->memcached_library->get($key);	
		return $set;
		}
		else{
		return $result;
		}
		}
		else
			return FALSE;
	}
}
    
}

?>
