<?php
class Do_adblock_domains extends CI_Model
{
	
	public $agency_id='';
	
	/*
	 * 
	 * name: fetch_domain
	 * @param :
	 * @return : $result
	 * 
	 * Lists a domains
	 */
	 
	 function fetch_domain()
	 {
		$key = FETCH_DOMAINS;
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get(FETCH_DOMAINS);
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{
			$sqls = "SELECT id,url,DATE_FORMAT(date_added,'%Y/%m/%d') as DATE,date_first_use,status,is_deleted FROM djax_adblock_domains WHERE is_deleted = 0";
			$query = $this->db->query($sqls);
			/*$this->db->select('id,url,date_added,date_first_use,status,is_deleted');	
			$this->db->where('is_deleted','0');
			$query = $this->db->get(TAB_ADBLOCK_DOMAIN);*/				
			if($query->num_rows()>0)
			{
				$result = $query->result_array();
				$i=0;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$i+1;
					
					$i+=1;
				}	
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			}
				
		}
	}
	
	function fetch_select($domain_id=FALSE)
	{
		$this->db->select('*');
		$this->db->where('id',$domain_id);
		$this->db->where('is_deleted','0');
		$query = $this->db->get(TAB_ADBLOCK_DOMAIN);
		if($query->num_rows()>0)
		{
			$result=$query->result_array();
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	
	function exists_check($url)
	{
		$this->db->select('url');
		$this->db->where('url',$url);
		$this->db->where('is_deleted','0');
		$query=$this->db->get(TAB_ADBLOCK_DOMAIN);
		
		
		if($query->num_rows()>0)
		{ 
			return $query->num_rows();
		}
		else
		{  
			return "NULL";
		}
	}
	
	function add($url)
	{
			$obj	=	array(
							"url"				=>	$url,
							"date_added"		=>	date("Y-m-d H:i:s"),
							"date_first_use"	=>	'0000-00-00 00:00:00',
							"status"			=>	'1',
						);
							
			$domain_id=$this->db->insert(TAB_ADBLOCK_DOMAIN,$obj);
			$this->memcached_library->set(DOMAIN_CHANGES,'1');
			
			return $domain_id;
			
	}
	
	function delete_domain($id=FALSE)
	{		
		if($id!=FALSE)
		{
			$this->db->where('id',$id);
		}		
		$data	=	array('is_deleted'=>1);			
		$this->db->update(TAB_ADBLOCK_DOMAIN,$data);
		$this->memcached_library->set(DOMAIN_CHANGES,'1');
		if($this->db->affected_rows()){
			return TRUE;
		}
		else
		{
			return FALSE;
		} 
	}
	
   public function block_domain($id=FALSE) 
   {
	   if($id)
	     {  
		     $data=array('status'=>1);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_ADBLOCK_DOMAIN,$data);
			 $this->memcached_library->set(DOMAIN_CHANGES,'1');			 
			return $id;
		 }
   }
   
   public function unblock_domain($id=FALSE) 
   {
	   if($id)
	     {  
			/* $this->db->select('*');
			 $this->db->where('status','0');
			 $this->db->where('is_deleted','0');
			 $query=$this->db->get(TAB_ADBLOCK_DOMAIN);
			 if($query->num_rows()>0)
			 {
				 return false;
			 }	*/	 
	 
		     $data=array('status'=>0);
		     $this->db->where('id', $id);
			 $this->db->update(TAB_ADBLOCK_DOMAIN,$data);			 
			 $this->memcached_library->set(DOMAIN_CHANGES,'1');
			return $id;
		 }
   }
   
   function update_domain_list($up_val=FALSE,$domain_id=FALSE)
	{
		$this->db->where('id',$domain_id);
		$this->db->update(TAB_ADBLOCK_DOMAIN,$up_val);
		$this->memcached_library->set(DOMAIN_CHANGES,'1');
		return TRUE;
	}
	
	function domain_list_check($table_name,$value,$id)
	{
		$this->db->select('*');	
		$this->db->where("url",$value);
		$this->db->where_not_in('id',$id);
		$this->db->where('is_deleted','0');
		$query_count	=	$this->db->get($table_name)->num_rows();
		
		if($query_count)
		{			
			return $query_count;
		}
		else
		{
			return FALSE;
		} 	
	}
   	
   	function dynamic_domain_change()
   	{
		$key = 'dynamic_domain_change';
		$ret = $this->memcached_library->get($key);
		$mem_cache = $this->default_configurations->get('adgate_memcache');	
		$check_db_changes = $this->memcached_library->get('dynamic_domain_change');
		if($ret && $mem_cache=='enable' &&  $check_db_changes!='1')
		{
			return $ret;
		}
		else{
			$sqls = "SELECT id,url,DATE_FORMAT(date_added,'%Y/%m/%d') as DATE,date_first_use,status,is_deleted FROM djax_adblock_domains WHERE is_deleted = 0 and domain_active=1";
			$query = $this->db->query($sqls);
			/*$this->db->select('id,url,date_added,date_first_use,status,is_deleted');	
			$this->db->where('is_deleted','0');
			$query = $this->db->get(TAB_ADBLOCK_DOMAIN);*/				
			if($query->num_rows()>0)
			{
				$result = $query->result_array();
				$i=0;
				foreach($result as $row)
				{
					$result[$i]['row_number']	=	$i+1;
					
					$i+=1;
				}	
				if($mem_cache=='enable' )
				{
				$account_type=$this->user_authentication->account_type;
				$this->memcached_library->set($key,$result,$account_type);	
				$set = $this->memcached_library->get($key);	
				return $set;
				}
				else{
				return $result;
				}
			}
			else
			{
				return FALSE;
			}
				
		}
	}
}
