<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Zone Limitations 
 *
 */

class Zone_limitations extends REST_Controller
{
	
	function __construct()
	{
		
		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->library('memcached_library');		
		$this->load->library('csvreader');		
		$this->load->library('Default_configurations');
		$this->load->model('do_zonelimitations');
		$this->load->model('do_message');
		$this->load->model('do_app_config');
		$this->load->library('notification');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key');
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
		
		
	} 
	
	 /*
	 * 
	 * name: fetch_zonelist_get
	 * @param :
	 * @return : $fetch_zonelist
	 * 
	 * Lists selected zone list of an advertiser
	 */
	 
	function fetch_filter_zone_get()
	{	
		$filter	=	clean_data($this->get('traffic_source'));
				
		$zone_list=$this->do_zonelimitations->list_filter_zone($filter);	

		  if($zone_list)
		 {
			 $this->response($zone_list, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			 $this->response(array('error'=>'Zone could not be found'),404);
		 }
		
	}	
	function fetch_zonelist_get()
	{	
			
		 $zonelist=$this->do_zonelimitations->list_zone();	

		  if($zonelist)
		 {
			 $this->response($zonelist, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>'Zone could not be found'),404);
		 }
		
	}
	
	function zonelist_get()
	{
		
		$filter	=	clean_data($this->get('traffic_source'));
				
		$zone_list=$this->do_zonelimitations->list_filter_zone($filter);	

		  if($zone_list)
		 {
			$form_data= '<select name="zone_id" id="zone_id" class="input-block-level select2-me input-xlarge" multiple data-nosearch="true" onchange="run();" data-placeholder="Zone ID">';
			
			foreach($zone_list as $sel)
			{
				$form_data.='<option value="'.$sel['zoneid'].'">'.$sel['zonename'].'</option>';    
			}
			$form_data.='</select>';
			 $response = array(
							'response' 	=> 	'ok',
							'zonelist'	=>	$form_data,
						);					
		    $this->response($response, 200);
		 }
		 else
		 {
			 $this->response(array('error'=>'Zone could not be found'),404);
		 }
		
	}
	
	function fetch_traffic_sources_get()
	{
		$traffic_list=$this->do_zonelimitations->list_traffic_source();	

		  if($traffic_list)
		 {
			 $this->response($traffic_list, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			 $this->response(array('error'=>'Traffic Source could not be found'),404);
		 }
	}
	
	
	function fetch_zone_limitations_get()
	{
		$filter=clean_data($this->get('filter'));
		$zonelimits=clean_data($this->get('zonelimit_id')); 
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		if($this->user_authentication->account_type=='ADMIN')
		{
			$account_id = '';
		}
		else
		{
			$account_id = $this->user_authentication->account_id;//'';
		}
		
		$adblock_type	=	$this->get('adblock_type');
		
		$zonelimitations=	$this->do_zonelimitations->list_zone_limitations($account_id,$adblock_type,$filter,$zonelimits);
		
		if($zonelimitations)
		{
			$this->response($zonelimitations, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'zone limitations list could not be found'),404);
		}
	}
		
	
	function fetch_list_unsetzone_list_get()
	{
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id = $this->user_authentication->default_advertiser_account_id;
		}
		
		 $bindzonelimitations=$this->do_zonelimitations->list_bindzone_list($account_id);
         $this->response($bindzonelimitations, 200); 
		  if($result)
		 {
			 $this->response($result, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>'Unbind zone could not be found'),404);
		 }
	}
		
	
	/*
	 * 
	 * 
	 * name: add_zone_limitation_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage add  process
	 */
	 
	public function add_zone_limitation_post()
	{	//$this->response($this->post(),200);
		$this->form_validation->set_rules('bw_name','Name', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' => 'error',
								'msg' =>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
			}
			else
			{
				$dj_account_id	=	$this->post('adv_id');
			}
			
			$name			= 	clean_data($this->post('bw_name'));
			$adb_list_type	=	clean_data($this->post('adb_list_type'));
			//$site_url_type	=	clean_data($this->post('site_url_type'));
			$url_block_site	=	clean_data($this->post('url_block_site'));
		
			if($adb_list_type=='0')
			{
				$zonelimit	= 	$this->post('block_zonelist');
				$list_type 	= 	'Blacklist';
			}
			else if($adb_list_type=='1')
			{
				$zonelimit	= 	$this->post('white_zonelist');
				$list_type 	= 	'Whitelist';
			}
		/*	else
			{
				if($site_url_type =='black')
				{
				$zonelimit	= 	$this->post('site_zonelist');
			
				$list_type 	= 	'Blacklist';
				}
				else
				{
				$zonelimit	= 	$this->post('site_zonelist');
				$list_type 	= 	'Whitelist';
				}
				
			}*/
		    $zonelimt 		= 	implode(',', $zonelimit);
		  
		    $url_block_site 		= 	implode(',', $url_block_site);
			
			$bidding_value=$this->post('bidding_value');
		    		    
			$send_pub_email = 	$this->zonelimit_publisher_notification($zonelimt,$list_type,$name);
			
			$limitation_data= 	array(
									"adblock_list_name"	=>	clean_data($name),
									"adblock_type"		=>	clean_data($adb_list_type),	
									"selected_zone_ids"	=>	clean_data($zonelimt),
									"account_id" 		=> 	clean_data($dj_account_id),
									"bid_rate"			=>	clean_data($bidding_value),
								//	"site_type"			=>	clean_data($site_url_type),
									"selected_site_ids"	=>	clean_data($url_block_site),
								);	//$this->response($limitation_data,200);
			$zonelist	=	$this->do_zonelimitations->add_zonelimitation($limitation_data);
								
			/*if(count($zonelimit)>0)
			{
				for ($i=0;$i<count($zonelimit);$i++)
				{		
				$pub_list		=	$this->do_zonelimitations->fetch_publisher($zonelimit[$i]);	
						
				$pub_limitation_data=array(
									"zone_limit_id"		=>	$zonelist,
									"publisher_id"		=>	clean_data($pub_list[0]['affiliateid']),
									"zone_id"			=>	clean_data($zonelimit[$i]),
									"account_id" 		=> 	clean_data($dj_account_id)
									);	
				$zone_list	=	$this->do_zonelimitations->add_pub_zonelimitation($pub_limitation_data);
				}
			}*/					
			
			/* Activity Log for Add zonelimitation - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,ZONE_LIMIT_ADD);
					if($enable=='1')
					{				
						$this->zone_activity_log(ZONE_LIMITATION,ADD,$zonelist);
					}
					/* Activity Log for Add zonelimitation - End*/
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{			
				/*********Message Requirements**************/
		
				$client_id 		=	$this->user_authentication->client_id;

				$account_type	=	$this->user_authentication->account_type;

				$network_id		=	$this->do_message->fetch_admin_network_id();

				$message  		= 	$this->default_configurations->get('message_type');		
				
				if($account_type=='TRAFFICKER')
				{
					$affiliate_id	=	$this->user_authentication->affiliate_id;
					$user 			= 	$this->do_message->get_affiliate($affiliate_id);
				}
				else{
					$user = $this->do_message->get_profile(ADMIN_ID); 
				}
				
				$acc_type='ADVERTISER';
				
				$type_details=	array(
											'msg_type'		=> $message,
											'type'			=> "ADMIN_MESSAGE_SETTINGS",
											'string'		=> 'zone_limit_add',
											'column_name'	=> 'network_settings'
											);
					
					
				$reciever	=	$this->do_message->get_profile($dj_account_id); 
							
				if($limitation_data['adblock_type']=='0')
				{
					$zone_adblock_type= 'blacklist';
				}
				else{
					$zone_adblock_type= 'Whitelist';
				}
				
				$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$reciever['account_id'],
												'dj_is_admarket'=>	'',
												'subject'		=>	'Zone Limitation added',
												'content'		=>	'A new Zone Limitation added successfully<br><br><b>Zone Limitation Details</b><br><br>Name:'.$limitation_data['adblock_list_name'].'<br>List Type:'.$zone_adblock_type.'<br>Selected Zone Id:'.$limitation_data['selected_zone_ids'],
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'notification_type'	=>	"network_setting",	
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);
											
				$admin_name   	=	$user['first_name'].' '.$user['last_name'];	
				$subject 		= 	$message_data['subject'];
				$admin_email   	=	$user['email'];
				$user_email    	=	$reciever['email'];
				$user_name     	=	$reciever['first_name'].' '.$reciever['last_name'];
				$mail_content	=	array(
										"subject" 	   => $message_data['subject'],
										"content" 	   => $message_data['content'],
										"to_name" 	   => $user_name,			
										"from_name"	   => $admin_name ,
										"email"  	   => $user_email,
										'banner_name'  => 'message from'.$admin_name,
										'contenttype'  => 'message'
									);								

			$notification_msg = $this->do_message->get_notification_msg('zone_limit_add'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);	

			$msg_replace = str_replace("{{adblock_list_name}}",$name,$msg_replace);
			$msg_replace = str_replace("{{block_list_type}}",$list_type,$msg_replace);
			$msg_replace = str_replace("{{zone_id}}",$zonelimt,$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$admin_name,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			
			$dat = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
			//$dat 	= 	$this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);

			}
	
			/*********Message Requirements**************/
		
			if($zonelist)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Zone limitation sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/network/zone_limitation/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Zone limitation sucessfully added',
									'redirect'	 	=> 	site_url('admin/network/zone_limitation/'),
									);	
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/network/add_zone_limitation/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/network/add_zone_limitation/'),
								);	
				}
				$this->response( $error, 200);
			}

			
		}
		
		}
	
	public function edit_zone_limitation_post()
	{ 

		$this->form_validation->set_rules('edit_bw_name','Name', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{	
			$advertiser_id	=	clean_data($this->post('advertiser_id'));
			$name			= 	clean_data($this->post('edit_bw_name'));
			$adb_list_type	=	clean_data($this->post('type'));
			$url_block_site	=	clean_data($this->post('url_block_site'));
			$url_block_site = 	implode(',', $url_block_site);
			if($adb_list_type=='0')
			{
				$zonelimt	= 	clean_data($this->post('edit_block_zonelist'));
				$list_type 	= 	'Blacklist';
			}
			else if ($adb_list_type=='1')
			{
				$zonelimt	= 	clean_data($this->post('edit_white_zonelist'));
				$list_type 	= 	'Whitelist';
			}
			
			$bidding_value=$this->post('bidding_value');
			
			$send_pub_email = 	$this->zonelimit_publisher_notification($zonelimt,$list_type,$name);
						
		    $zonelimt 		= 	implode(',', $zonelimt);
			$limitation_data= 	array(
									"adblock_list_name"	=>	clean_data($name),
									"adblock_type"		=>	clean_data($adb_list_type),
									"selected_zone_ids"	=>	clean_data($zonelimt),
									"bid_rate"			=>	clean_data($bidding_value),
									"selected_site_ids"	=>	clean_data($url_block_site)
								);

			$zonelist		=	$this->do_zonelimitations->edit_zonelimitation($limitation_data,$advertiser_id);
			
			if($zonelist)
			{
				/* Activity Log for EDIT zonelimitation - Start*/
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,ZONE_LIMIT_EDIT);
				if($enable=='1')
				{				
					$this->zone_activity_log(ZONE_LIMITATION,EDIT,$advertiser_id);
				}
				/* Activity Log for Edit zonelimitation - End*/	
			
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					/*********Message Requirements**************/
			
					$client_id 		=	$this->user_authentication->client_id;
					
					$account_id 	=	$this->user_authentication->account_id;

					$account_type	=	$this->user_authentication->account_type;

					$network_id		=	$this->do_message->fetch_admin_network_id();

					$message  		= 	$this->default_configurations->get('message_type');		
					
					if($account_type=='TRAFFICKER')
					{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$user 			= 	$this->do_message->get_affiliate($affiliate_id); 

					}
					else{
						$user = $this->do_message->get_profile(ADMIN_ID); 
					}
					
					$acc_type='ADVERTISER';
					
					$type_details		=	array(
												'msg_type'		=> $message,
												'type'			=> "ADMIN_MESSAGE_SETTINGS",
												'string'		=> 'zone_limit_edit',
												'column_name'	=> 'network_settings'
											);
						
						
					$reciever=$this->do_message->get_profile($account_id); 
					
					if($limitation_data['adblock_type']=='0')
					{
						$zone_adblock_type= 'blacklist';
					}
					else{
						$zone_adblock_type= 'Whitelist';
					}
					
					$message_data	=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$reciever['account_id'],
												'dj_is_admarket'=>	'',
												'subject'		=>	'Zone Limitation Edited',
												'content'		=>	'Zone Limitation edited successfully<br><br><b>Zone Limitation Details</b><br><br>Name:'.$limitation_data['adblock_list_name'].'<br>List Type:'.$zone_adblock_type.'<br>Selected Zone Id:'.$limitation_data['selected_zone_ids'],
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'notification_type'	=>	"network_setting",	
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);
												
					$admin_name  	=	$user['first_name'].' '.$user['last_name'];	
					$subject 		= 	$message_data['subject'];
					$admin_email   	=	$user['email'];
					$user_email    	=	$reciever['email'];
					$user_name     	=	$reciever['first_name'].' '.$reciever['last_name'];
					$mail_content=array(
										"subject" 	   => $message_data['subject'],
										"content" 	   => $message_data['content'],
										"to_name" 	   => $user_name,			
										"from_name"	   => $admin_name ,
										"email"  	   => $user_email,
										'banner_name'  => 'message from'.$admin_name,
										'contenttype'  => 'message'
										);								

			$notification_msg = $this->do_message->get_notification_msg('zone_limit_edit'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);	

			$msg_replace = str_replace("{{adblock_list_name}}",$name,$msg_replace);
			$msg_replace = str_replace("{{block_list_type}}",$list_type,$msg_replace);
			$msg_replace = str_replace("{{zone_id}}",$zonelimt,$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$admin_name,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			
			$dat = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
			
				
					//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Zone limitation sucessfully edited',
									'redirect'	 	=> 	site_url('advertiser/network/zone_limitation/'),
									);
				}
				else{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Zone limitation sucessfully edited',
									'redirect'	 	=> 	site_url('admin/network/zone_limitation/'),
									);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/network/edit_zone_limitation/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/network/edit_zone_limitation/'),
								);
				}
				
				$this->response( $error, 200);
			}
			
		}
		
	}

		/*
		* 
		* name: zonelimit_publisher_notification
		* @param :
		* @return : true or false
		* 
		* zonelimit_publisherid
		*/
	
		function zonelimit_publisher_notification($zonelimt,$adblock_type,$name)
		{
			
			
			$dcb='';
			$adblock_id='';
			foreach($zonelimt as $zone_id)
			{
				
				$jb.= $zone_id.',';
				
				$check = $this->do_zonelimitations->fetch_publisher($zone_id);
				
			//	$this->response($check[0],200);
				
				/*$dc .= $check[0]['affiliateid'].'-'.$zone_id.',';
				
				$this->response($check[0]['affiliateid'],200);
				
				if((in_array($check[0]['affiliateid'],explode(',',$dcb)))==FALSE)
				{
					//$this->response('match',200);
					
					$dcb .= $check[0]['affiliateid'].','; 
				}
				else{
				
					$dcb .= $check[0]['affiliateid'].',';
				
				} */
				
			//	$this->response('dfgdfg',200);
				
				
				$pubid_zoneid= $check[0]['account_id'].'-'.$zone_id.'-'.$check[0]['zonename'].',';
				
				$data_id = explode('-',$pubid_zoneid);
				
				//$this->response(print_r($data_id),200);
				
				//if((in_array($data_id[0],$pub_id)==FALSE))
				if((in_array($data_id[0],explode(',',$pub_id))==FALSE))
				{
					$pub_id .= $data_id[0].',';
					$adblock_id[$data_id[0]] .= $data_id[2];
				}
				else
				{
					$adblock_id[$data_id[0]] .= $data_id[2];
				}
			
				
			}
			
		
			
			//sending mails for publisher with adblcok 
			foreach($adblock_id as $key => $value)
			{
				
				
				
				
				
					/*********Message Requirements**************/
	
			$client_id 		=	$this->user_authentication->client_id;

			
			$acc_type='ADVERTISER';
			

			$network_id	=	$this->do_message->fetch_admin_network_id();

			$message  = $this->default_configurations->get('message_type');		
			
			$user = $this->do_message->get_profile(ADMIN_ID); 
			
	
			$type_details		=	array(
				'msg_type'		=> $message,
				'type'			=> "ADMIN_MESSAGE_SETTINGS",
				'string'		=> 'zone_limit_edit',
				'column_name'	=> 'network_settings'
				);
				
				
			$reciever=$this->do_message->get_affiliate($key); 
			
			$message_data		=	array(
											'sender_id'		=>	$key,
											'receiver_id'	=>	$reciever['account_id'],
											'subject'		=>	'1Zone Limitation  '.$adblock_type.' added for adblocks',
											'content'		=>	'A new Zone Limitation Edited successfully<br><br><b>Zne Limitation Details</b><br><br>Name:'.$name.'<br>List Type:'.$adblock_type.'<br>Selected Zones:'.$value,
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	$acc_type,
											'notification_type'	=>	"network_setting",	
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')
											);
											
				$admin_name   =$user['first_name'].' '.$user['last_name'];	
				$subject = $message_data['subject'];
				$admin_email   =$user['email'];
				$user_email    =$reciever['email'];
				$user_name     =$reciever['first_name'].' '.$reciever['last_name'];
				$mail_content=array(
									"subject" 	   => $message_data['subject'],
									"content" 	   => $message_data['content'],
									"to_name" 	   => $user_name,			
									"from_name"	   => $admin_name ,
									"email"  	   => $user_email,
									'banner_name'  => 'message from'.$admin_name,
									'contenttype'  => 'message'
									);								
			
				$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);

				
	
			/*********Message Requirements**************/
				
				
				
			}
				
				
			//$this->response(print_r($adblock_id),200);
			
			return true;
			
			//$this->response($jb,200);
			
		}
		
		
		
		
		
		
	/*
	 * 
	 * name: delete_get
	 * @param :
	 * @return : $delete_zonelimitation_id
	 * 
	 * Delete the given delete_zonelimitation_id
	 */
	
	function delete_get()
	{
		$delete_zonelimitation_id = $this->get('delete_zonelimitation_id');	


		if($delete_zonelimitation_id)
		{
			$delete_zonelimitation_id	=	explode(',',$delete_zonelimitation_id);
			if(is_array($delete_zonelimitation_id))
			{ 
				foreach($delete_zonelimitation_id as $zonelimitation_id)
				{	
					
					$zone_limit		= $this->do_zonelimitations->get_zonelimitations(clean_data($zonelimitation_id));
					$zone_limit_name.= $zone_limit[0]['adblock_list_name'].',';
					$zonelimitation = $this->do_zonelimitations->delete_zonelimitations(clean_data($zonelimitation_id));
				}
			}
			
			else
			{
				$zone_limit		= $this->do_zonelimitations->get_zonelimitations(clean_data($zonelimitation_id));
				$zone_limit_name.= $zone_limit[0]['adblock_list_name'];			
				$zonelimitation = $this->do_zonelimitations->delete_zonelimitations(clean_data($zonelimitation_id));
			}
			
			/* Activity Log for EDIT zonelimitation - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,ZONE_LIMIT_DEL);
					if($enable=='1')
					{				
						$this->zone_activity_log(ZONE_LIMITATION,DELETE,$zonelimitation_id);
					}
					/* Activity Log for Edit zonelimitation - End*/	
				
			if($this->user_authentication->account_type=='ADVERTISER')
			{	
				/*********Message Requirements**************/
		
				$client_id 		=	$this->user_authentication->client_id;
				
				$account_id 		=	$this->user_authentication->account_id;

				$account_type	=	$this->user_authentication->account_type;

				$network_id		=	$this->do_message->fetch_admin_network_id();

				$message  		= 	$this->default_configurations->get('message_type');		
				
				

				if($account_type=='TRAFFICKER')
				{
					$affiliate_id	=	$this->user_authentication->affiliate_id;
					$user 			= 	$this->do_message->get_affiliate($affiliate_id); 

				}
				else{
					$user = $this->do_message->get_profile(ADMIN_ID); 
				}
				
				$acc_type='ADVERTISER';
				
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "ADMIN_MESSAGE_SETTINGS",
					'string'		=> 'zone_limit_del',
					'column_name'	=> 'network_settings'
					);
					
					
				$reciever=$this->do_message->get_profile($account_id); 
				
				$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$reciever['account_id'],
												'dj_is_admarket'=>	'',
												'subject'		=>	'Zone Limitations Deleted',
												'content'		=>	'The Zone Limitations <b>'.$zone_limit_name.'</b> has been deleted successfully<br><br>',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'notification_type'	=>	"network_setting",	
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);
											
				$admin_name   	=	$user['first_name'].' '.$user['last_name'];
				$admin_email   	=	$user['email'];
				$user_email    	=	$reciever['email'];
				$user_name     	=	$reciever['first_name'].' '.$reciever['last_name'];
				$mail_content=array(
									"subject" 	   => $message_data['subject'],
									"content" 	   => $message_data['content'],
									"to_name" 	   => $user_name,			
									"from_name"	   => $admin_name ,
									"email"  	   => $user_email,
									'banner_name'  => 'message from'.$admin_name,
									'contenttype'  => 'message'
									);								

			$notification_msg = $this->do_message->get_notification_msg('zone_limit_del'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS'); 
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);	

			$msg_replace = str_replace("{{adblock_list_name}}",rtrim($zone_limit_name,','),$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$admin_name,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			$dat = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
							
				//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
			}
			
			/*********Message Requirements**************/
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Zone limitation has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => ' Zone limitation id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	

	function edit_zone_limitation_get()
	{
		$advertiser_id = clean_data($this->get('id'));
		if($advertiser_id)
		{
			$zonelimitation_details = $this->do_zonelimitations->edit_zone_limitation($advertiser_id);
			
			$this->response($zonelimitation_details,200);
		}
	}
	function zone_activity_log($module,$process,$zonelimitation_id)
	{
				/* Activity Log for Add/Edit/Delete site - Start	*/			
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$advertiser_id =	$this->user_authentication->client_id;
				//$module=$module;
				//$process=$process;				
				//$campaign_id=$campaign_id;
				
				$activity_log=array(				
								"account_id"=>$account_id,
								"useragent"=>$user_agent,
								"browser"=>$browser,
								"os"=>$os,
								"ip"=>$ip,
								"date"=>$date,
								"module"=>$module,
								"process"=>$process,
								"advertiser_id"=>$advertiser_id,
								"zone_limit_id"=>$zonelimitation_id,
								
								);	

				$this->redis_library->logcount($account_id,$activity_log);  
																									
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	public function import_zonelimit_file_post()
	{	
		$file_id=$this->post('upload_name');
					
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt' || $upload_extension[1]=='xml')
			{	
				
					$csvfilepath 	= $this->config->item('read_csv');	
					$file_name		= $this->getLatestFile($csvfilepath);
					if($upload_extension[1]=='xml')
					{						
						$xml = simplexml_load_file($file_name, 'SimpleXMLElement');	
						$data = json_decode(json_encode((array)$xml), TRUE);
						
						if(!empty($data['Zonelimitation'][0]))
						{
							$data=$data['Zonelimitation'];
						}
						else{
							$datum[0]=$data['Zonelimitation'];
							$data=$datum; 
						}
					}
					else {$data	 		= $this->csvreader->parse_file($file_name);}
			
					$counter		= '1';	
					$ext_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$num_rows=count($data);	
					$count_arr_insert = sizeof($data);											
					if($num_rows>0)
					{
						foreach($data as $row)
						{ 
							if($row['Type'] == 'White List'){$row['Type']= '1';}else if($row['Type'] == 'Black List'){$row['Type']= '0';}
							if(!empty($row['Name']) && ($row['Type']=='0' || $row['Type']=='1') && !empty($row['Zone_ids']))	
							{
												
							if($this->user_authentication->account_type=='ADVERTISER')
							{	
								$client_id 	= 	$this->user_authentication->client_id;
								$account_id = 	$this->user_authentication->account_id;
							}
							$z_ids=str_replace("_",",",$row['Zone_ids']);
							
								$check_duplicate=$this->do_zonelimitations->check_zone_lists($account_id,trim($z_ids));
																								
								if($row['Type']=='0')
								{
								$zone_list_type=0;
								}
								else $zone_list_type=1;
								$zone_data 	= 	array(
									"account_id"			=>	clean_data($account_id),
									"adblock_list_name"		=>	trim($row['Name']),
									"adblock_type" 		=> 	$zone_list_type,
									"selected_zone_ids"	=>	trim(str_replace("_",",",$row['Zone_ids'])), 
								);	
								 			
							$zonelimit=explode(',',str_replace("_",",",$row['Zone_ids']));
							if($check_duplicate=='2'){		
								if(!empty($zone_data))
								{
										
									$zone_id=$this->do_zonelimitations->add_zonelimits($zone_data);
											
									if(count($zonelimit)>0)
									{
										for ($i=0;$i<count($zonelimit);$i++)
										{				
										$pub_list		=	$this->do_zonelimitations->fetch_publisher($zonelimit[$i]);	
										$pub_limitation_data=array(
															"zone_limit_id"		=>	$zone_id,
															"publisher_id"		=>	clean_data($pub_list[0]['affiliateid']),
															"account_id" 		=> 	clean_data($account_id),
															"zone_id"			=>	clean_data($zonelimit[$i])	);	
										$zone_list	=	$this->do_zonelimitations->add_pub_zonelimitation($pub_limitation_data);
										$insert_rec[] =$counter;
										}
									}					
											
											
									}
									else
									{
											$exist_rec[]=$ext_counter;
									}
								}
								else
									{
											$exist_rec[]=$ext_counter;
									}
						$counter++;	
						$ext_counter++;						
						}
						else {
							$error = array(
									'response' => 'error',
									//'redirect'=>site_url('advertiser/network/traffic_sources/'),
									'msg'	 => 'The file contains invalid data for this operation..'
									);
				  
							$this->response($error, 200);
						}
					}
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
							
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'msg'		=> $count_arr_insert.' record(s) are inserted successfully'
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('advertiser/network/zone_limitation/'),
									'msg'	 => 'There is no data in the file!..'
									);
				  
						$this->response($error, 200);	
					}													
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT/XML file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	}
	function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}	
		
    return $max['path'];
	}
	function fetch_url_site_list_get()
	{
		$zonelimitations=	$this->do_zonelimitations->list_url_site_data();
		$this->response($zonelimitations, 200);
	}
	function fetch_url_block_list_get()
	{
		$zonelimitations=	$this->do_zonelimitations->list_url_data();
		$this->response($zonelimitations, 200);
	}
	function fetch_url_block_edit_list_get()
	{
		$site_id=$this->input->get('site_id');    
		if($site_id)
		{
		$zonelimitations=	$this->do_zonelimitations->fetch_sitelist_url_data($site_id);
		$this->response($zonelimitations, 200);
		}
	}
}
