<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Web creatives
 *
 * All web creative will be managed here 
 *
 * @package		ADX
 * @subpackage	Web creatives
 * @category	Controller
 * @author		Vigneswaran a
 * @link		http://www.djaxadserver.com  
*/

class Web_creative extends REST_Controller
{
	function __construct()
	{
		parent::__construct(); 
		$this->load->library('redis_library');		
		$this->load->model('do_web_creative');
		$this->load->model('do_mobile_creative');
		$this->load->model('do_video_creative');
		$this->load->helper('utilities_helper');
		$this->load->library('swf_banner');
		$this->load->model('do_creative');
		$this->load->model('do_auto_link');
		$this->load->library('user_authentication');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_message');
        $this->load->library('user_authentication');
        $this->load->library('notification');
	    $key=$this->input->get_post('api_key');
	    $this->load->model('do_campaign'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	function group_check()
	{
		$group_name		=	clean_data($this->post('group_name'));//strtolower($this->post('group_name'));
		$account_id		=	$this->user_authentication->account_id;
		$count 			= 	$this->do_creative->group_check($group_name,$account_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('group_check', 'Group Name must contain a unique value.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function keyword_check()
	{
		$keyword		=	clean_data($this->post('keyword'));
		$account_id		=	$this->user_authentication->account_id;
		$count 			= 	$this->do_creative->keyword_check($keyword,$account_id);		
		if($count>0)
		{
			$this->form_validation->set_message('keyword_check', 'Keyword must contain a unique value.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function keyword_post()
	{
		
		$this->form_validation->set_rules('keyword', 'lang:keyword_name', 'required|trim|callback_keyword_check');
		$this->form_validation->set_message('is_unique', $this->lang->line('keyword_registered_message'));
		if ($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error     = array(
				'response' => 'error',
				'msg' => $error_msg
			);
			$this->response($error, 200);
		}
		else
		{
			$keydata = array(
				'keyword' => clean_data($this->post('keyword')),
				"account_id" => $this->user_authentication->account_id
				
			);
			
			
			$add     = $this->do_campaign->add_keyword($keydata);
						
			
			if ($add)
			{
				$success = array(
					'response' => 'ok',
					'msg' => $this->lang->line('keyword_created_success')//'Keyword has been created successfully.'
				);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
					'response' => 'error',
					'msg' => $this->lang->line('error_try_again')
				);
				$this->response($error, 200);
			}
		}
		
	}
	
	
	function group_post()
	{
		$this->form_validation->set_rules('group_name', 'Group Name', 'trim|required|callback_group_check');				
		
		if($this->form_validation->run() === FALSE)
		{
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$group_data = array(
									"group_name" =>	clean_data($this->post('group_name')),
									"account_id" => $this->user_authentication->account_id
							    );
		}
			
		$group_add=$this->do_creative->add_group($group_data);				
		
		if($group_add)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$group_add,
									'redirect'	 	=> 	site_url('advertiser/campaigns/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$group_add,
									'redirect'	 	=> 	site_url('admin/campaigns/'),
									);						
					
				}					
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/campaigns/'),
								);					
				}
				
				$this->response( $error, 200);
			}
		
	}

	// validation for image url
	function check_is_image_url()
	{
		$url = clean_data($this->post('external_web_creative'));
		$img = @getimagesize($url);
		
		$mime_arr = array('image/jpeg','image/png','image/gif','image/jpg');
		
		if( @is_array(@getimagesize($url)) && ( in_array($img['mime'],$mime_arr)))
		{
			return TRUE;
		}
		else
		{
			$this->form_validation->set_message('check_is_image_url', 'Enter a valid image url (or) valid image formats like png,gif,jpg and jpeg');
			return FALSE;
		}
	}
	
	// validation for image url
	function check_lay_is_image_url()
	{
		$url = clean_data($this->post('external_url'));
		$img = @getimagesize($url);
		
		$mime_arr = array('image/jpeg','image/png','image/gif','image/jpg');
		
		if( @is_array(@getimagesize($url)) && ( in_array($img['mime'],$mime_arr)))
		{
			return TRUE;
		}
		else
		{
			$this->form_validation->set_message('check_lay_is_image_url', 'Enter a valid image url (or) valid image formats like png,gif,jpg and jpeg');
			return FALSE;
		}
	}

 	/*
	 * 
	 * name: add_web_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage all the three SQL,WEB
	 * and URL CREATIVE adding process
	 */
	public function add_web_creative_post()
	{
		
		$this->form_validation->set_rules('web_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('web_creative_size', 'Creative size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$is_external_web_creative = clean_data($this->post('is_external_web_creative'));

		if($is_external_web_creative =='on')
			$this->form_validation->set_rules('external_web_creative', 'Creative URL', 'required|trim|callback_url_check|callback_check_is_image_url|check_image_size');
		$campaign = clean_data($this->post('_web_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_web_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_web_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			
			$is_db_store = clean_data($this->post('is_db_store'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$blob_data=array();
			$trusted_status='';
			//Get account/agency_id from library file
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_web_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_web_account_id')));
			}
			
			$agency_id	=	$this->user_authentication->agency_id;

			$is_house_ad= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			//If it is a database creative
			if($is_db_store=='on')
			{
				$storage_type	=	'sql';
				$bannertype		=	WEB_CREATIVE_SQL;
				//Fetch width and height of the creative
				$creative_size	=	explode('x',clean_data($this->post('web_creative_size')));
				$creative_width	=	$creative_size[0];
				$creative_height=	$creative_size[1];
				$date			=  	date("Y-m-d");
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = array(
										"contenttype"		=>	clean_data($this->post('tmp_web_creative_content_type')),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('web_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_web_creative')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path										
									);
					$blob_data	=	array(
										"filename"	=>	clean_data($this->post('tmp_web_creative')),
										"contents"	=>	file_get_contents($this->post('tmp_web_creative_url')),
										"t_stamp"	=>	clean_data(date('Y:m:d :H:i:s')),
									);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_web_creative')));				
				}
			}
			else
			{
				//If it is a URL creative
				if($is_external_web_creative=='on')
				{
					$storage_type	=	'url';
					$bannertype		=	WEB_CREATIVE_URL;
					//Fetch width and height of the creative
					$creative_size	=	explode('x',clean_data($this->post('web_creative_size')));
					$creative_width	=	$creative_size[0];
					$creative_height=	$creative_size[1];
					$contentType 	= 	'';
					$external_image_url =	clean_data($this->post('external_web_creative'));
					$ext 			= 	substr($external_image_url, strrpos($external_image_url, '.') + 1);
					switch (strtolower($ext)) {
						case 'jpeg': $contentType = 'jpeg'; break;
						case 'jpg':  $contentType = 'jpeg'; break;
						case 'png':  $contentType = 'png';  break;
						case 'gif':  $contentType = 'gif';  break;
					}
					
					if(isset($creative_width) AND isset($creative_height) )
					{
						$creative_data = array(
											"contenttype"		=>	clean_data($contentType),
											"storagetype"		=>	clean_data($storage_type),
											"campaignid"		=>	clean_data($campaign_id),
											"description"		=>	clean_data($this->post('web_creative_name')),
											"imageurl"			=>	clean_data($this->post('external_web_creative')),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),							
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path										
										);
					}
				}
				else
				{
					//If it is a web creative
					$storage_type	=	'web';
					$bannertype		=	WEB_CREATIVE_WEB;
					//Fetch width and height of the creative
					$creative_size	=	explode('x',clean_data($this->post('web_creative_size')));
					$creative_width	=	$creative_size[0];
					$creative_height=	$creative_size[1];
					if(isset($creative_width) AND isset($creative_height) )
					{
						$creative_data = array(
											"contenttype"		=>	clean_data($this->post('tmp_web_creative_content_type')),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data($storage_type),
											"description"		=>	clean_data($this->post('web_creative_name')),
											"filename"			=>	clean_data($this->post('tmp_web_creative')),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),							
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path										
										);
							
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_web_creative')));
					}
				}
			}
			//Call to add a creative
			$creative_add=$this->do_web_creative->add($creative_data,$blob_data,$agency_id);

			if($creative_add)
			{
				
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Web creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Web Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Web Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);
				}	
					
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
		}
	}
 	
 	/*
	 * 
	 * name: add_display_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage all the three SQL,WEB
	 * and URL CREATIVE adding process
	 */
	public function add_display_creative_post()
	{
		
		$this->form_validation->set_rules('web_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('web_creative_size', 'Creative size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$is_external 	= 	clean_data($this->post('is_external'));
		$is_html 		= 	clean_data($this->post('is_html'));
		$is_flash 		= 	clean_data($this->post('is_flash'));
		$admarket_id		= 	clean_data($this->post('_admarket_id'));

		$adma_id = ($admarket_id == false)?'0':'1';

		if($is_external =='on'):
			$this->form_validation->set_rules('external_web_creative', 'Creative URL', 'required|trim|url|callback_check_is_image_url|check_image_size');
		endif;
		
		if($is_html =='on'):
			$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
		endif;
		
		
		$campaign =clean_data($this->post('_display_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_web_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_display_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$is_db_store 	= 	clean_data($this->post('is_db_store'));
			$dj_image_path 	= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
			$blob_data		=	array();
			$trusted_status='';
			//Get account/agency_id from library file
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_web_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_web_account_id')));
			}
			
			$agency_id	=	$this->user_authentication->agency_id;

			$is_house_ad= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$creative_size	=	explode('x',clean_data($this->post('web_creative_size')));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];
			$date			=	date("Y-m-d");
					
			//If it is a database creative
			if($is_db_store=='on')
			{
				$storage_type	=	'sql';
				$bannertype		=	WEB_CREATIVE_SQL;
				//Fetch width and height of the creative
				
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = array(
										"contenttype"		=>	clean_data($this->post('tmp_web_creative_content_type')),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('web_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_web_creative')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path,			
										"dj_admarket_status" =>  $adma_id			
									);
					$blob_data	=	array(
										"filename"	=>	clean_data($this->post('tmp_web_creative')),
										"contents"	=>	file_get_contents(clean_data($this->post('tmp_web_creative_url'))),
										"t_stamp"	=>	clean_data(date('Y:m:d :H:i:s')),
									);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_web_creative')));				
				}
				//Call to add a creative
				$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
			}
			//If it is a URL creative
			else if($is_external=='on')
			{
				$storage_type	=	'url';
				$bannertype		=	WEB_CREATIVE_URL;
				//Fetch width and height of the creative
				
				$contentType 	= 	'';
				$external_image_url =	clean_data($this->post('external_web_creative'));
				$ext 			= 	substr($external_image_url, strrpos($external_image_url, '.') + 1);
				switch (strtolower($ext)) {
					case 'jpeg': $contentType = 'jpeg'; break;
					case 'jpg':  $contentType = 'jpeg'; break;
					case 'png':  $contentType = 'png';  break;
					case 'gif':  $contentType = 'gif';  break;
				}
				
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = array(
										"contenttype"		=>	clean_data($contentType),
										"storagetype"		=>	clean_data($storage_type),
										"campaignid"		=>	clean_data($campaign_id),
										"description"		=>	clean_data($this->post('web_creative_name')),
										"imageurl"			=>	clean_data($this->post('external_web_creative')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),							
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path,
										"dj_admarket_status" =>  $adma_id										
									);
				}
				//Call to add a creative
				$creative_add=$this->do_web_creative->add($creative_data,$blob_data,$agency_id);

			}
			else if($is_html=='on')
			{
				$storage_type	=	"html";
				$bannertype		=	WEB_CREATIVE_HTML;
				$htmlcache		=	html_anchor_tag_replacer($_REQUEST['html_content']);
				$html_template 	= 	stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
		
				$creative_data 	= 	array(
									"contenttype"		=>	clean_data($storage_type),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('web_creative_name')),
									"width"				=>	clean_data($creative_width),
									"height"			=>	clean_data($creative_height),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"htmltemplate"		=>	html_entity_decode($html_template),
									"htmlcache"			=>	stripslashes($htmlcache),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),												
									"dj_banner_type"	=>	clean_data($bannertype),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									"dj_admarket_status" =>  $adma_id
								);
				
				//Call to add a creative
				$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
			}
			else if($is_flash=='on')
			{
				$content_type	=	'swf';
				$storage_type	=	'web';
				$bannertype		=	WEB_CREATIVE_SWF;
		
				$content		=	file_get_contents(clean_data($this->post('tmp_flash_creative_url')));

				if ($this->swf_banner->phpAds_SWFCompressed($content))
				{
					$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
					$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
					$content =$this->swf_banner->phpAds_SWFCompress($buffer);
				}
				else
				{									
					$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
				}

				//Store width and height
				list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
				$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
				$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
				if(!empty($hardcodedLinks))
				{
					//Remove Hardcoded link from swf file
					 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
					 {
						// SWF's requiring player version 6+ which are already compressed should stay compressed
						if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
						{
							$compress = true;
						}
						elseif (isset($compress))
						{
							$compress = true;
						}
						else
						{
							$compress = false;
						}
						if (!isset($convert_links))
						{
							$convert_links = array();
						}
						$convert_links = array_keys($hardcodedLinks);
						list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
						if ($result != $content)
						{
							if (count($parameters) > 0)
							{
								// Prepare the parameters
								$parameters_complete = array();
								//Small hack to overwrite hard_coded values with destination url
								unset($overwrite_link);
								unset($overwrite_target);	
								$overwrite_link = array('0'=>$banner_url);

								$overwrite_target = array('0'=>$ban_target);	

									foreach ($parameters as $key => $val)
									{
										if (isset($overwrite_source) && $overwrite_source[$val] != '')
										{
											$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
										}
										$parameters_complete[$key] = array(
											'link' => $overwrite_link[0],
											'tar'  =>$overwrite_target[0],
										);
									}
									$parameters = array('swf' => $parameters_complete);
									
							}
							else
							{
								$parameters = '';
							}
							//When storing banner details into table,Don't forget to update parameters field
							$param = empty($parameters) ? null : serialize($parameters);
						}
					}	
				}
				else
				{
					$param = "N;";
				}
				
				$creative_data 	= 	array(
										"contenttype"		=>	clean_data($content_type),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('web_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_flash_creative')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"parameters" 		=> 	$param,
										"pluginversion" 	=>	$pluginVersion ,
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),					
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path,
										"dj_admarket_status" =>  $adma_id										
									);
			
				//Get agencyid
				$creative_id	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
				$creative_add	=	$creative_id;
				
				$backup_image_data	=	array(
											"banner_id"		=>	clean_data($creative_id),
											"file_path"		=>	clean_data($this->post('tmp_backup_flash_creative')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_backup_flash_creative_content_type')),
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				$backup_imagedata	=	$this->do_web_creative->add_creative_dependiences($backup_image_data);
						
				//On sucess move the web creative from tmp location to original location
				$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_flash_creative')));
				$is_backup_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_backup_flash_creative')));

			}
			else
			{
				//If it is a web creative
				$storage_type	=	'web';
				if($this->post('_creative_type')=='Mobile')
				{
					$bannertype		=	MOBILE_IMAGE_CREATIVE;
				}
				else
				{
					$bannertype		=	WEB_CREATIVE_WEB;
				}
				//Fetch width and height of the creative
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = array(
										"contenttype"		=>	clean_data($this->post('tmp_web_creative_content_type')),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('web_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_web_creative')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),							
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path,
										"dj_admarket_status" =>  $adma_id										
									);
						
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_web_creative')));
				}
				//Call to add a creative
				$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);

			}
						
			//$this->response($creative_data,200);    
		
			if($creative_add)
			{
				
				/***creative change for message/mail notification*****/
			$notication_value ='creative_add';				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Display creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Display Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Display Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser($notication_value,'campaigns',null,$content,$campaign_id);					
					
			//$this->response($creative_add,200);
			
			
			

			
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
			   }
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket');
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	$redirect_url,
									);
				}	
					
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket');
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				$this->response( $error, 200);
			}
		}
	}
 	
 	/*
	 * 
	 * name: add_flash_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage  adding of flash creatives
	 */
	public function add_flash_creative_post()
	{
		$this->form_validation->set_rules('flash_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('flash_creative_size', 'Creative size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_fl_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_fl_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_fl_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$content_type	=	'swf';
			$storage_type	=	'web';
			$bannertype		=	WEB_CREATIVE_SWF;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id=$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_fl_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_fl_account_id')));
			}
			$agency_id		=	$this->user_authentication->agency_id;

			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			//FOR SWF FILE VALUES
			$banner_url		=	clean_data($this->url_creation($this->post('destination_url')));
			$ban_target		=	'_blank';
			
			//Fetch width and height of the creative
			$creative_size	=	explode('x',clean_data($this->post('flash_creative_size')));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];

			if(isset($creative_width) AND isset($creative_height) )
			{
				$content	=	file_get_contents(clean_data($this->post('tmp_flash_creative_url')));

				if ($this->swf_banner->phpAds_SWFCompressed($content))
				{
					$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
					$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
					$content =$this->swf_banner->phpAds_SWFCompress($buffer);
				}
				else
				{									
					$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
				}

				//Store width and height
				list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
				$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
				$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
				if(!empty($hardcodedLinks))
				{
					//Remove Hardcoded link from swf file
					 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
					 {
						// SWF's requiring player version 6+ which are already compressed should stay compressed
						if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
						{
							$compress = true;
						}
						elseif (isset($compress))
						{
							$compress = true;
						}
						else
						{
							$compress = false;
						}
						if (!isset($convert_links))
						{
							$convert_links = array();
						}
						$convert_links = array_keys($hardcodedLinks);
						list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
						if ($result != $content)
						{
							if (count($parameters) > 0)
							{
								// Prepare the parameters
								$parameters_complete = array();
								//Small hack to overwrite hard_coded values with destination url
								unset($overwrite_link);
								unset($overwrite_target);	
								$overwrite_link = array('0'=>$banner_url);

								$overwrite_target = array('0'=>$ban_target);	

									foreach ($parameters as $key => $val)
									{
										if (isset($overwrite_source) && $overwrite_source[$val] != '')
										{
											$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
										}
										$parameters_complete[$key] = array(
											'link' => $overwrite_link[0],
											'tar'  =>$overwrite_target[0],
										);
									}
									$parameters = array('swf' => $parameters_complete);
									
							}
							else
							{
								$parameters = '';
							}
							//When storing banner details into table,Don't forget to update parameters field
							$param = empty($parameters) ? null : serialize($parameters);
						}
					}	
				}
				else
				{
					$param = "N;";
				}
				
				$date=date("Y-m-d");
				$creative_data 	= 	array(
										"contenttype"		=>	clean_data($content_type),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('flash_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_flash_creative')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"parameters" 		=> 	$param,
										"pluginversion" 	=>	$pluginVersion ,
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),					
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path										
									);
            
				//Get agencyid
				$blog_data	=	FALSE;
				$creative_id=	$this->do_web_creative->add($creative_data,$blog_data,$agency_id);

				$backup_image_data	=	array(
											"banner_id"		=>	clean_data($creative_id),
											"file_path"		=>	clean_data($this->post('tmp_backup_flash_creative')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_backup_flash_creative_content_type')),
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				$backup_image_data	=	$this->do_web_creative->add_creative_dependiences($backup_image_data);
						
				//On sucess move the web creative from tmp location to original location
				$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_flash_creative')));
				$is_backup_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_backup_flash_creative')));

				if($creative_id)
				{
					
				/***creative change for message/mail notification*****/
				
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Flash creative added';
				$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Flash Creative';
				$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Web Creative';
				$content['creative_type'] = 'Flash Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
				/***creative change for message/mail notification*****/	
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
										);						
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
										);
					}	
					
					$this->response( $success, 200);
					
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}	
			}
		}
	}

	 /*
	 * 
	 * name: add_html_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage HTML creative adding process
	 */
	public function add_html_creative_post()
	{
		$this->form_validation->set_rules('html_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('html_creative_size', 'Creative size', 'required|trim');
		//$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|url');
		$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
		$campaign = clean_data($this->post('_html_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_html_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_html_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			//Fetch width and height of the creative
			$storage_type	=	"html";
			$bannertype		=	WEB_CREATIVE_HTML;
			$creative_size	=	explode('x',clean_data($this->post('html_creative_size')));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id=$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_html_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_html_account_id')));
			}
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';					
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}			

			$htmlcache=html_anchor_tag_replacer($_REQUEST['html_content']);
			$html_template = stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
			
			if(isset($creative_width) AND isset($creative_height) AND isset($htmlcache))
			{
				$creative_data 	= 	array(
										"contenttype"		=>	clean_data($storage_type),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('html_creative_name')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"htmltemplate"		=>	html_entity_decode($html_template),
										"htmlcache"			=>	stripslashes($htmlcache),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),												
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path
									);
				//Get agencyid
				$blog_data=FALSE;
			 
				//Call to add a creative
				$creative_add=$this->do_web_creative->add($creative_data,$blog_data,$agency_id);
			}

			if($creative_add)
			{
				
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='HTML creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; HTML Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'HTML Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);
				}	
				
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}
		}	

	}
	 /*
	 * 
	 * name: add_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage HTML creative adding process
	 */
	public function add_text_creative_post()
	{  
		$this->form_validation->set_rules('text_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('text_content', 'HTML content', 'required|trim');
		$campaign = clean_data($this->post('_wtxt_campaign_id'));

		$admarket_id		= 	clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_wtxt_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_wtxt_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			
			$storage_type	=	"txt";
			$bannertype		=	WEB_CREATIVE_TEXT;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status="";
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wtxt_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wtxt_account_id')));
			}
					
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}				
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}			

			$creative_data = array(
						"contenttype"		=>	clean_data($storage_type),
						"campaignid"		=>	clean_data($campaign_id),
						"storagetype"		=>	clean_data($storage_type),
						"description"		=>	clean_data($this->post('text_creative_name')),
						"bannertext"		=>	htmlentities($this->post('text_content')),
						"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
						"dj_admin_approve"	=>	clean_data($dj_admin_approve),
						"dj_approved_date"	=>	clean_data($dj_approved_date),						
						"dj_banner_type"	=>	clean_data($bannertype),
						"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
						"dj_account_id" 	=> 	clean_data($dj_account_id),
						"dj_is_direct" 		=> 	clean_data($dj_is_direct),
						"dj_admarket_status" =>  $adma_id
					);
					
			
			//Call to add a creative
			$blob_data=FALSE;
			$creative_add=$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
			//$this->response( $creative_add, 200);
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			
			$content['sub'] ='Text creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Web Text Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Web Text Creative';
			
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			/***creative change for message/mail notification*****/
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
				//	$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
			
				
			if($creative_add)
			{			
		
				if($this->user_authentication->account_type=='ADVERTISER')
				{			
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}	
				
				$this->response($success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				
				$this->response( $error, 200);  
			}		

		}
	}

	 /*
	 * 
	 * name: edit_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage text creative edit process
	 * 
	 */
	
	public function edit_text_creative_post()
	{
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		$this->form_validation->set_rules('text_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('text_content','Creative content', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('text_creative_id'));

			$storage_type="txt";

			$creative_data = array(
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('text_creative_name')),
						"bannertext"=>htmlentities($this->post('text_content')),
						"url"=>clean_data($this->url_creation($this->post('destination_url'))),
						//"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
					);

			 //Get agencyid from library file
			 $agency_id=$this->user_authentication->agency_id;			
			 //Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				 /***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Web Text creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Text Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Text Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
				$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
				if($enable=='1')
		        {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}
	 /*
	 * 
	 * name: edit_google_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage google text creative edit process
	 * 
	 */
	
	public function edit_google_text_creative_post()
	{
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		$this->form_validation->set_rules('text_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('text_content','Creative content', 'required|trim');
		$this->form_validation->set_rules('title','title content', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('text_creative_id'));

			$storage_type="txt";

			$creative_data = array(
						"storagetype"	=>	clean_data($storage_type),
						"description"	=>	clean_data($this->post('text_creative_name')),
						"bannertext"	=>	htmlentities($this->post('text_content')),
						"statustext"	=>	htmlentities($this->post('title')),
						"url"			=>	clean_data($this->url_creation($this->post('destination_url'))),
						//"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
					);

			 //Get agencyid from library file
			 $agency_id=$this->user_authentication->agency_id;			
			 //Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				 /***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Web Text creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Text Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Text Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
				$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
				if($enable=='1')
		        {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: add_google_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage HTML creative adding process
	 */
	public function add_google_text_creative_post()
	{  
		$this->form_validation->set_rules('text_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('title', 'HTML heading', 'required|trim');
		$this->form_validation->set_rules('text_content', 'HTML content', 'required|trim');
		$campaign = clean_data($this->post('_wtxt_campaign_id'));

		$admarket_id		= 	clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_wtxt_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_wtxt_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			
			$storage_type	=	"txt";
			$bannertype		=	WEB_AD_GOOGLE;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status="";
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wtxt_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wtxt_account_id')));
			}
					
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}				
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}			

			$creative_data = array(
						"contenttype"		=>	clean_data($storage_type),
						"campaignid"		=>	clean_data($campaign_id),
						"storagetype"		=>	clean_data($storage_type),
						"description"		=>	clean_data($this->post('text_creative_name')),
						"bannertext"		=>	htmlentities($this->post('text_content')),
						"statustext"		=>	htmlentities($this->post('title')),
						"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
						"dj_admin_approve"	=>	clean_data($dj_admin_approve),
						"dj_approved_date"	=>	clean_data($dj_approved_date),						
						"dj_banner_type"	=>	clean_data($bannertype),
						"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
						"dj_account_id" 	=> 	clean_data($dj_account_id),
						"dj_is_direct" 		=> 	clean_data($dj_is_direct),
						"dj_admarket_status" =>  $adma_id
					);
					
			
			//Call to add a creative
			$blob_data=FALSE;
			$creative_add=$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
			//$this->response( $creative_add, 200);
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			
			$content['sub'] ='Google Text creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Web Text Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Web Text Creative';
			
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			/***creative change for message/mail notification*****/
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
				//	$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
			
				
			if($creative_add)
			{			
		
				if($this->user_authentication->account_type=='ADVERTISER')
				{			
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}	
				
				$this->response($success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				
				$this->response( $error, 200);  
			}		

		}
	}
	
	
	 /*
	 * 
	 * name: edit_html_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage text creative edit process
	 * 
	 */
	
	public function edit_html_creative_post()
	{
		$campaign_id= clean_data($this->post('_campaign_id'));
		$this->form_validation->set_rules('html_creative_name','Creative name', 'required|trim');
		//$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|url');
		$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
		

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('html_creative_id'));
			$storage_type="html";
			$htmlcache=html_anchor_tag_replacer($_REQUEST['html_content']);
			$html_template = stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
			
			
			$creative_size=explode('x',clean_data($this->post('html_creative_size')));
			$creative_width=$creative_size[0];
			$creative_height=$creative_size[1];
			if(isset($htmlcache))
			{
				$creative_data = array(
						"description"=>clean_data($this->post('html_creative_name')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"url"=>clean_data($this->url_creation($this->post('destination_url'))),
						"htmltemplate "=>html_entity_decode($html_template),
						"htmlcache"=>stripslashes($htmlcache),
						"updated"=>clean_data(date('Y:m:d :H:i:s')),
					);
			//Get agencyid from library
			 $agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

			}
			if($creative_edit)
			{
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='HTML creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;HTML Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'HTML Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);
				}
					
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}

	 /*
	 * 
	 * name: edit_web_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all the three SQL,WEB
	 * and URL CREATIVE edit process
	 */
	public function edit_web_creative_post()
	{
		$storage_type = clean_data($this->post('storage_type'));

		switch($storage_type)
		{
			case $storage_type=='web':
				$this->edit_image_creative();
			break;	

			case $storage_type=='sql':
				$this->edit_sql_creative();
			break;	

			case $storage_type=='url':
				$this->edit_url_creative();
			break;	
		}
	}
	
	/*
	 * 
	 * name: edit_display_creative_post
	 * @param
	 * @return:response array
	* 
	* In this methosd we will manage all the three SQL,WEB
	* and URL CREATIVE edit process
	*/
	public function edit_display_creative_post()
	{
		$banner_type = clean_data($this->post('banner_type'));
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		$this->form_validation->set_rules('web_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		if($banner_type==WEB_CREATIVE_WEB || $banner_type==WEB_CREATIVE_SQL  || $banner_type==MOBILE_IMAGE_CREATIVE)
		{
			$tmp_web_creative=clean_data($this->post('tmp_web_creative'));
			if (empty($tmp_web_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('web_creative_edit', 'Creative', 'required');
			}
			
		}
		else if($banner_type==WEB_CREATIVE_URL)
		{
			$this->form_validation->set_rules('external_web_creative', 'External URL', 'required|trim|url|callback_check_is_image_url|check_image_size');
		}
		else if($banner_type==WEB_CREATIVE_HTML)
		{
			$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
		}
		else if($banner_type==WEB_CREATIVE_SWF)
		{
			$tmp_flash_creative=clean_data($this->post('tmp_flash_creative'));
			if (empty($tmp_flash_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('flash_creative_edit', 'Creative', 'required');
			}
			
			$tmp_backup_flash_creative=clean_data($this->post('tmp_backup_flash_creative'));
			if (empty($tmp_backup_flash_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('backup_creative_edit', 'Creative', 'required');
			}
		}		

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id	=	clean_data($this->post('display_creative_id'));
			$dj_image_path 	= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
			if($banner_type==WEB_CREATIVE_WEB || $banner_type==WEB_CREATIVE_SQL || $banner_type==MOBILE_IMAGE_CREATIVE)
			{			
				if(clean_data($this->post('old_creative')) != clean_data($this->post('tmp_web_creative')))
				{	
					$creative_data = 	array(
											"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
											"description"=>clean_data($this->post('web_creative_name')),
											"filename"=>clean_data($this->post('tmp_web_creative')),
											"url"=>clean_data($this->url_creation($this->post('destination_url'))),
											"updated"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
				}
				else{
					$creative_data = 	array(
											"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
											"description"=>clean_data($this->post('web_creative_name')),
											"filename"=>clean_data($this->post('tmp_web_creative')),
											"url"=>clean_data($this->url_creation($this->post('destination_url'))),
											"updated"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_admarket_status" =>  $adma_id
										);
				}
				
				if($banner_type==WEB_CREATIVE_SQL)
				{
					$blob_data	=	array(
										"filename"=>clean_data($this->post('tmp_web_creative')),
										"contents"=>file_get_contents(clean_data($this->post('tmp_web_creative_url'))),
										"t_stamp"=>clean_data(date('Y:m:d :H:i:s')),
										"dj_admarket_status" =>  $adma_id
									);
					
				}				
			}
			else if($banner_type==WEB_CREATIVE_URL)
			{
				$contentType= 	'';
				$external_image_url = clean_data($this->post('external_web_creative'));
				$ext 		= 	substr($external_image_url, strrpos($external_image_url, '.') + 1);
				switch (strtolower($ext)) {
					case 'jpeg': $contentType = 'jpeg'; break;
					case 'jpg':  $contentType = 'jpeg'; break;
					case 'png':  $contentType = 'png';  break;
					case 'gif':  $contentType = 'gif';  break;
				}

				$creative_data = array(
									"contenttype"=>clean_data($contentType),
									"description"=>clean_data($this->post('web_creative_name')),
									"imageurl"=>clean_data($this->post('external_web_creative')),
									"url"=>clean_data($this->url_creation($this->post('destination_url'))),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_admarket_status" =>  $adma_id
								);

			}
			else if($banner_type==WEB_CREATIVE_HTML)
			{
				$htmlcache		=	html_anchor_tag_replacer($_REQUEST['html_content']);
				$html_template 	= 	stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
				
				if(isset($htmlcache))
				{
					$creative_data = array(
										"description"=>clean_data($this->post('web_creative_name')),
										"url"=>clean_data($this->url_creation($this->post('destination_url'))),
										"htmltemplate "=>html_entity_decode($html_template),
										"htmlcache"=>stripslashes($htmlcache),
										"updated"=>clean_data(date('Y:m:d :H:i:s')),
										"dj_admarket_status" =>  $adma_id
									);				
				}
			}
			else if($banner_type==WEB_CREATIVE_SWF)
			{				
				//FOR SWF FILE VALUES
				$banner_url=clean_data($this->url_creation($this->post('destination_url')));
				$ban_target='_blank';
				//Fetch width and height of the creative
				//IF FLASH CHANGED
				if(clean_data($this->post('old_flash_creative')) != clean_data($this->post('tmp_flash_creative')))
				{
					$content	=	file_get_contents(clean_data($this->post('tmp_flash_creative_url')));

					if ($this->swf_banner->phpAds_SWFCompressed($content))
					{
						$buffer = 	$this->swf_banner->phpAds_SWFDecompress($content);								
						$buffer = 	preg_replace('/clickTAG/i', 'clickTAG', $buffer);
						$content=	$this->swf_banner->phpAds_SWFCompress($buffer);
					}
					else
					{									
						$content= 	preg_replace('/clickTAG/i', 'clickTAG', $content);
					}

					//Store width and height
					list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
					$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
					$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
					if(!empty($hardcodedLinks))
					{
						//Remove Hardcoded link from swf file
						 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
						 {
							// SWF's requiring player version 6+ which are already compressed should stay compressed
							if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
							{
								$compress = true;
							}
							elseif (isset($compress))
							{
								$compress = true;
							}
							else
							{
								$compress = false;
							}
							if (!isset($convert_links))
							{
								$convert_links = array();
							}
							$convert_links = array_keys($hardcodedLinks);
							list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
							if ($result != $content)
							{
								if (count($parameters) > 0)
								{
									// Prepare the parameters
									$parameters_complete = array();
									//Small hack to overwrite hard_coded values with destination url
									unset($overwrite_link);
									unset($overwrite_target);	
									$overwrite_link = array('0'=>$banner_url);

									$overwrite_target = array('0'=>$ban_target);	

										foreach ($parameters as $key => $val)
										{
											if (isset($overwrite_source) && $overwrite_source[$val] != '')
											{
												$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
											}
											$parameters_complete[$key] = array(
												'link' => $overwrite_link[0],
												'tar'  =>$overwrite_target[0],
											);
										}
										$parameters = array('swf' => $parameters_complete);
										
								}
								else
								{
									$parameters = '';
								}
								//When storing banner details into table,Don't forget to update parameters field
								$param = empty($parameters) ? null : serialize($parameters);
							}
						}	
					}
					else
					{
						$param = "N;";
					}

					$creative_data = array(
											"description"=>clean_data($this->post('web_creative_name')),
											"filename"=>clean_data($this->post('tmp_flash_creative')),
											"parameters" => $param,
											"pluginversion" =>$pluginVersion ,
											"url"=>clean_data($this->url_creation($this->post('destination_url'))),
											"updated"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);						
					
					$old_flashs_creative_path = clean_data($this->post('old_flashs_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_flash_creative')));

					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_flash_creative')),$old_flashs_creative_path);
				
				}
				//IF FLASH NOT CHANGED
				else
				{
					$creative_data = array(
											"description"=>clean_data($this->post('web_creative_name')),
											"filename"=>clean_data($this->post('tmp_flash_creative')),
											"url"=>clean_data($this->url_creation($this->post('destination_url'))),
											"updated"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_admarket_status" =>  $adma_id
										);
				}
				//IF BACK UP CREATIVE CHANGED
				if($this->post('old_backup_creative') != $this->post('tmp_backup_flash_creative'))
				{
					$backup_image_data=array(
									"banner_id"=>clean_data($creative_id),
									"file_path"=>clean_data($this->post('tmp_backup_flash_creative')),
									"content_type"=>clean_data($this->post('tmp_backup_flash_creative_content_type')),
									"created_date"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path,
									"dj_admarket_status" =>  $adma_id
									);
									
					$backup_image_data=$this->do_web_creative->edit_creative_dependiences($backup_image_data,$creative_id);
					$old_backup_creative_path = clean_data($this->post('old_backup_creative_path'));		
					//On sucess move the web creative from tmp location to original location
					$is_backup_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_backup_flash_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_backup_creative')),$old_backup_creative_path);
				}
			}
			
			//Get clientid from library file
			$agency_id=$this->user_authentication->agency_id;

			//Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				if($banner_type==WEB_CREATIVE_WEB || $banner_type==WEB_CREATIVE_SQL || $banner_type==MOBILE_IMAGE_CREATIVE)
				{
					if(clean_data($this->post('old_creative')) != clean_data($this->post('tmp_web_creative')))
					{
						if($banner_type==WEB_CREATIVE_SQL)
						{
							//This method is only for database creative
							$creative_blob_edit=$this->do_web_creative->edit_blob_data($blob_data,clean_data($this->post('old_creative')));
						}
										
						$old_image_path = clean_data($this->post('old_creative_path'));
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_web_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_creative')),$old_image_path);
					}
				}
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Display creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Display Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Display Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/  
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				
				$this->response( $error, 200);
			}			
		}
	}

	 /*
	 * 
	 * name: edit_image_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_image_creative()
	{
		
		
		$this->form_validation->set_rules('web_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$tmp_web_creative=$this->post('tmp_web_creative');
		if (empty($tmp_web_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('web_creative_edit', 'Creative', 'required');
		}

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			
			$creative_id=clean_data($this->post('web_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			if($this->post('old_creative') != $this->post('tmp_web_creative'))
			{
				
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
					"description"=>clean_data($this->post('web_creative_name')),
					"filename"=>clean_data($this->post('tmp_web_creative')),
					"url"=>clean_data($this->url_creation($this->post('destination_url'))),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
				);
			}
			else{
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
					"description"=>clean_data($this->post('web_creative_name')),
					"filename"=>clean_data($this->post('tmp_web_creative')),
					"url"=>clean_data($this->url_creation($this->post('destination_url'))),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					
				);
			}
			
			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;

		    //Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

			 if($creative_edit)
			 {
				 	/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Image creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Image Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Image Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				 /***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->post('old_creative') != $this->post('tmp_web_creative'))
				{
					$old_image_path = $this->post('old_creative_path');
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date($this->post('old_creative'),$old_image_path);
				}
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);
				}
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	 /*
	 * 
	 * name: edit_flash_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_flash_creative_post()
	{
		$this->form_validation->set_rules('flash_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('flash_creative_size', 'Creative size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');

		$tmp_flash_creative=$this->post('tmp_flash_creative');
		if (empty($tmp_flash_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('flash_creative_edit', 'Creative', 'required');
		}
		
		$tmp_backup_flash_creative=$this->post('tmp_backup_flash_creative');
		if (empty($tmp_backup_flash_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('backup_creative_edit', 'Creative', 'required');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$content_type='swf';
			$storage_type='web';
			$bannertype=WEB_CREATIVE_SWF;
			
			//FOR SWF FILE VALUES
			$banner_url=clean_data($this->url_creation($this->post('destination_url')));
			$ban_target='_blank';
			$creative_id=clean_data($this->post('web_creative_id'));
			
			//Fetch width and height of the creative
			$creative_size=explode('x',$this->post('flash_creative_size'));
			$creative_width=$creative_size[0];
			$creative_height=$creative_size[1];
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			//IF FLASH CHANGED
			if($this->post('old_flash_creative') != $this->post('tmp_flash_creative'))
			{
				if(isset($creative_width) AND isset($creative_height) )
				{
					$content		=file_get_contents($this->post('tmp_flash_creative_url'));

					if ($this->swf_banner->phpAds_SWFCompressed($content))
					{
						$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
						$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
						$content =$this->swf_banner->phpAds_SWFCompress($buffer);
					}
					else
					{									
						$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
					}

					//Store width and height
					list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
					$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
					$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
					if(!empty($hardcodedLinks))
					{
						//Remove Hardcoded link from swf file
						 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
						 {
							// SWF's requiring player version 6+ which are already compressed should stay compressed
							if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
							{
								$compress = true;
							}
							elseif (isset($compress))
							{
								$compress = true;
							}
							else
							{
								$compress = false;
							}
							if (!isset($convert_links))
							{
								$convert_links = array();
							}
							$convert_links = array_keys($hardcodedLinks);
							list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
							if ($result != $content)
							{
								if (count($parameters) > 0)
								{
									// Prepare the parameters
									$parameters_complete = array();
									//Small hack to overwrite hard_coded values with destination url
									unset($overwrite_link);
									unset($overwrite_target);	
									$overwrite_link = array('0'=>$banner_url);

									$overwrite_target = array('0'=>$ban_target);	

										foreach ($parameters as $key => $val)
										{
											if (isset($overwrite_source) && $overwrite_source[$val] != '')
											{
												$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
											}
											$parameters_complete[$key] = array(
												'link' => $overwrite_link[0],
												'tar'  =>$overwrite_target[0],
											);
										}
										$parameters = array('swf' => $parameters_complete);
										
								}
								else
								{
									$parameters = '';
								}
								//When storing banner details into table,Don't forget to update parameters field
								$param = empty($parameters) ? null : serialize($parameters);
							}
						}	
					}
					else
					{
						$param = "N;";
					}

					$creative_data = array(
						"contenttype"=>clean_data($content_type),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('flash_creative_name')),
						"filename"=>clean_data($this->post('tmp_flash_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"parameters" => $param,
						"pluginversion" =>$pluginVersion ,
						"url"=>clean_data($this->url_creation($this->post('destination_url'))),
						"dj_banner_type"=>clean_data($bannertype),
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_image_path"		=>  $dj_image_path
					);
					
                    //Get agencyid from library
				    $agency_id=$this->user_authentication->agency_id;
					$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

					$old_flashs_creative_path = $this->post('old_flashs_creative_path');
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_flash_creative'));

					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date($this->post('old_flash_creative'),$old_flashs_creative_path);
				}
			}
			//IF FLASH NOT CHANGED
			else
			{
					$creative_data = array(
						"contenttype"=>clean_data($content_type),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('flash_creative_name')),
						"filename"=>clean_data($this->post('tmp_flash_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"url"=>clean_data($this->url_creation($this->post('destination_url'))),
						"dj_banner_type"=>clean_data($bannertype),
						"updated"=>clean_data(date('Y:m:d :H:i:s')),
					);

					$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id);
				
			}
			//IF BACK UP CREATIVE CHANGED
			if($this->post('old_backup_creative') != $this->post('tmp_backup_flash_creative'))
			{

					$backup_image_data=array(
									"banner_id"=>clean_data($creative_id),
									"file_path"=>clean_data($this->post('tmp_backup_flash_creative')),
									"width"=>clean_data($creative_width),
									"height"=>clean_data($creative_height),
									"content_type"=>clean_data($this->post('tmp_backup_flash_creative_content_type')),
									"created_date"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
									);
									
					$backup_image_data=$this->do_web_creative->edit_creative_dependiences($backup_image_data,$creative_id);
					$old_backup_creative_path = $this->post('old_backup_creative_path');		
					//On sucess move the web creative from tmp location to original location
					$is_backup_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_backup_flash_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date($this->post('old_backup_creative'),$old_backup_creative_path);
			}

			if($creative_edit)
			{
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Flash creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Flash Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Flash Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}	
				
		}
	}
		
	 /*
	 * 
	 * name: edit_sql_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_sql_creative()
	{
		$this->form_validation->set_rules('web_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');

		$tmp_web_creative=$this->post('tmp_web_creative');
		if (empty($tmp_web_creative))
		{
			$this->form_validation->set_message('required', 'This creative is not upto Iab standard.');
			$this->form_validation->set_rules('web_creative_edit', 'Creative', 'required');
		}

		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('web_creative_id');
			$old_creative_name=$this->post('old_creative');#FOR BLOB DATA
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			if($this->post('old_creative') != $this->post('tmp_web_creative'))
				{
					$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
					"description"=>clean_data($this->post('web_creative_name')),
					"filename"=>clean_data($this->post('tmp_web_creative')),
					"url"=>clean_data($this->url_creation($this->post('destination_url'))),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);	
				}
				else{
					$creative_data = array(
						"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
						"description"=>clean_data($this->post('web_creative_name')),
						"filename"=>clean_data($this->post('tmp_web_creative')),
						"url"=>clean_data($this->url_creation($this->post('destination_url'))),
						"updated"=>clean_data(date('Y:m:d :H:i:s')),
					);	
				}
			
			
			$blob_data=array(
				"filename"=>clean_data($this->post('tmp_web_creative')),
				"contents"=>file_get_contents($this->post('tmp_web_creative_url')),
				"t_stamp"=>clean_data(date('Y:m:d :H:i:s')),
			);

			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			
			 if($creative_edit)
			 {
				if($this->post('old_creative') != $this->post('tmp_web_creative'))
				{
					//This method is only for database creative
					$creative_blob_edit=$this->do_web_creative->edit_blob_data($blob_data,$old_creative_name);
					
					$old_image_path = $this->post('old_creative_path');
					
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date($this->post('old_creative'),$old_image_path);
				}
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='SQL creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;SQL Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'SQL Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
					/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
						
				$this->response( $error, 200);
			}
		}
	}
		
	 /*
	 * 
	 * name: edit_url_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_url_creative()
	{
		$this->form_validation->set_rules('web_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('external_web_creative', 'External URL', 'required|trim|callback_url_check|callback_check_is_image_url|check_image_size');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('web_creative_id');
			
			$contentType = '';
			$external_image_url = clean_data($this->post('external_web_creative'));
			$ext = substr($external_image_url, strrpos($external_image_url, '.') + 1);
			switch (strtolower($ext)) {
				case 'jpeg': $contentType = 'jpeg'; break;
				case 'jpg':  $contentType = 'jpeg'; break;
				case 'png':  $contentType = 'png';  break;
				case 'gif':  $contentType = 'gif';  break;
			  }

			$creative_data = array(
				"contenttype"=>clean_data($contentType),
				"description"=>clean_data($this->post('web_creative_name')),
				"imageurl"=>clean_data($this->post('external_web_creative')),
				"url"=>clean_data($this->url_creation($this->post('destination_url'))),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);

			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			

			if($creative_edit)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
		

	/*
	 * 
	 * name: creative_to_tmp_location_post
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected web creative to a temporary location
	 * 
	 */
	public function creative_to_tmp_location_post()
	{	
		
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'   => $_FILES['creative']['name'],
					'tmp_name' => $_FILES['creative']['tmp_name'], 
					);
					//$this->response($creative, 200);
			$tmp_creative=$this->image_lib->move_creative_to_tmp_location($creative);

			if($tmp_creative)
			{
				$success = array(
								'response' => $tmp_creative['upload_data'],
								'msg'	 => 'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'redirect'=>site_url('advertiser/creatives/add_web_creatives'),
								'msg'	 => 'Unable to move to temporary location '
				);
				$this->response($error, 200);
				//$this->last->query(); exit;
			}
		}
	}
	/*
	 * 
	 * name: delete_a_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in its original location
	 */
	
	public function delete_a_creative_post()
	{
		$tmp_creative_name=$this->post('creative_name');
		
		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_original_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Temporary creative deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary creative file'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	/*
	 * 
	 * name: delete_a_tmp_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in temporary location
	 */
	
	public function delete_a_tmp_creative_post()
	{
		$tmp_creative_name=clean_data($this->post('creative_name'));

		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_tmp_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Temporary creative deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary creative file'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	
	/** ADDITIONAL AD FORMATS **/
	/*
	* Name: Ad formats
	* Worked By : suganthi
	* date: 2015-03-05
	*/
	 
	/*
	* 
	* name: add_popup_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage popup creative adding process
	*/
	
	public function add_popup_creative_post()
	{
		$this->form_validation->set_rules('pop_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_wpop_campaign_id'));

		$admarket_id		= 	clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_wpop_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id=clean_data($this->post('_wpop_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			if(clean_data($this->post('is_direct_link'))=='on')
			{
				$bannertype		=	WEB_CREATIVE_DIRECT;				
			}
			else
			{
				$bannertype		=	WEB_CREATIVE_POP;
			}
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wpop_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wpop_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}			

			$creative_data = 	array(
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('pop_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),						
									"dj_banner_type"	=>	clean_data($bannertype),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_admarket_status" =>  $adma_id
								);
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);

			if($creative_add)
			{
							
			/***creative change for message/mail notification*****/
				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Popup creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Popup Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Popup Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}					
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	 $redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: add_layer_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage layer/interstitial creative adding process
	*/
	
	public function add_layer_creative_post()
	{
		$this->form_validation->set_rules('layer_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$is_link = clean_data($this->post('is_link'));
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if($is_link =='url')
		{
			$this->form_validation->set_rules('external_url', 'Creative URL', 'required|trim|url');
			$storage_type	=	'url';	
		}
		elseif($is_link =='html')
		{
			$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
			$storage_type	=	'html';		
		}
		elseif($is_link == 'flash')
		{
			$storage_type = 'web';
		}
		else
		{
			$storage_type	=	'web';		
		}
			
		$campaign = clean_data($this->post('_wlay_campaign_id'));
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id=clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_wlay_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_wlay_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{		
			$storage_type	=	"web";	
			$bannertype		=	WEB_CREATIVE_LAYER;			
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wlay_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wlay_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}	
			
			$creative_size	=	explode('x',$this->post('layer_creative_size'));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];
			if(isset($creative_width) AND isset($creative_height) )
			{			
				
				$creative_data = 	array(										
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('layer_creative_name')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),						
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path,
										"dj_admarket_status" =>  $adma_id
									);				
			}
			
			// Layer type like image, text or url
			if($is_link=='url')
			{	
				$creative_data['contenttype']	=	'url';
				$creative_data['storagetype']	=	'url';
				$creative_data['imageurl']		=	clean_data($this->post('external_url'));			
			}
			elseif($is_link=='html')
			{
				$htmlcache		=	html_anchor_tag_replacer($_REQUEST['html_content']);
				$html_template 	= 	stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
				
				$creative_data['contenttype']	=	clean_data($storage_type);	
				$creative_data['htmltemplate']	=	html_entity_decode($html_template);
				$creative_data['htmlcache']		=	stripslashes($htmlcache);
			}
			elseif($is_link=='flash')
			{
				$creative_data['contenttype']	=	'swf';//clean_data($this->post('tmp_flash_creative_content_type'));
				$creative_data['filename']		=	clean_data($this->post('tmp_flash_creative'));
				$creative_data['file_size']		=	clean_data($this->post('tmp_flash_creative_size'));
				//FOR SWF FILE VALUES
				$banner_url	=	clean_data($this->url_creation($this->post('destination_url')));
				$ban_target	=	'_blank';
				
				$content	=	file_get_contents(clean_data($this->post('tmp_flash_creative_url')));

				if ($this->swf_banner->phpAds_SWFCompressed($content))
				{
					$buffer = 	$this->swf_banner->phpAds_SWFDecompress($content);								
					$buffer = 	preg_replace('/clickTAG/i', 'clickTAG', $buffer);
					$content=	$this->swf_banner->phpAds_SWFCompress($buffer);
				}
				else
				{									
					$content= 	preg_replace('/clickTAG/i', 'clickTAG', $content);
				}

				//Store width and height
				list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
				$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
				$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
				if(!empty($hardcodedLinks))
				{
					//Remove Hardcoded link from swf file
					 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
					 {
						// SWF's requiring player version 6+ which are already compressed should stay compressed
						if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
						{
							$compress = true;
						}
						elseif (isset($compress))
						{
							$compress = true;
						}
						else
						{
							$compress = false;
						}
						if (!isset($convert_links))
						{
							$convert_links = array();
						}
						$convert_links = array_keys($hardcodedLinks);
						list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
						if ($result != $content)
						{
							if (count($parameters) > 0)
							{
								// Prepare the parameters
								$parameters_complete = array();
								//Small hack to overwrite hard_coded values with destination url
								unset($overwrite_link);
								unset($overwrite_target);	
								$overwrite_link = array('0'=>$banner_url);

								$overwrite_target = array('0'=>$ban_target);	

									foreach ($parameters as $key => $val)
									{
										if (isset($overwrite_source) && $overwrite_source[$val] != '')
										{
											$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
										}
										$parameters_complete[$key] = array(
											'link' => $overwrite_link[0],
											'tar'  =>$overwrite_target[0],
										);
									}
									$parameters = array('swf' => $parameters_complete);
									
							}
							else
							{
								$parameters = '';
							}
							//When storing banner details into table,Don't forget to update parameters field
							$param = empty($parameters) ? null : serialize($parameters);
						}
					}	
				}
				else
				{
					$param = "N;";
				}
				
				$creative_data['parameters'] = $param;
				$creative_data['pluginversion'] =	$pluginVersion;
				
				// Move Creative to original Location				
				$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_flash_creative'));	
			}
			else
			{
				$creative_data['contenttype']	=	clean_data($this->post('tmp_layer_creative_content_type'));
				$creative_data['filename']		=	clean_data($this->post('tmp_layer_creative'));
				$creative_data['file_size']		=	clean_data($this->post('tmp_layer_creative_size'));
				// Move Creative to original Location				
				$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_layer_creative')));	
			}
			
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
				
			if($creative_add)
			{
				
				/***creative change for message/mail notification*****/
				
				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Layer/Interstitial creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Layer/Interstitial Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Layer/Interstitial Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		        {
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
					   $redirect_url=site_url('advertiser/creatives/');	
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
					   $redirect_url=site_url('admin/creatives/');	
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');  
					}
					else
					{
					   $redirect_url=site_url('advertiser/creatives/');	
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
					   $redirect_url=site_url('admin/creatives/');	
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: add_gamebox_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage gamebox creative adding process
	*/
	
	public function add_gamebox_creative_post()
	{
		$this->form_validation->set_rules('gamebox_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$campaign = clean_data($this->post('_wgam_campaign_id'));

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_wgam_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			clean_data($campaign_id= $this->post('_wgam_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			$bannertype		=	WEB_CREATIVE_GAMEBOX;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wgam_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wgam_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}			
			
			$creative_width	=	'300';
			$creative_height=	'250';

			$gamead_creative_data = 	array(
											"contenttype"		=>	clean_data($this->post('tmp_game1_creative_content_type')),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data($storage_type),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"description"		=>	clean_data($this->post('gamebox_creative_name')),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),						
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//Call to add a creative
			$blob_data	=	FALSE;
			$banner_id	=	$this->do_web_creative->add($gamead_creative_data,$blob_data,$agency_id);
				
			// Insert Game ad2 banner
							
			$gamead1_creative_data = 	array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_game1_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_game1_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_game1_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_GAME,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_GAMEBOX_ONE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_game1_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game1_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($gamead1_creative_data);
			
			// Insert Game ad2 banner
							
			$gamead2_creative_data = 	array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_game2_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_game2_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_game2_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_GAME,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_GAMEBOX_TWO,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_game2_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game2_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($gamead2_creative_data);
			
			// Insert Game ad3 banner
							
			$gamead3_creative_data 	= 	array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_game3_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_game3_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_game3_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_GAME,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_GAMEBOX_THREE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_game3_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game3_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($gamead3_creative_data);
			
			// Insert Game ad4 banner
							
			$gamead4_creative_data 	= 	array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_game4_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_game4_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_game4_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_GAME,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_GAMEBOX_FOUR,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_game4_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game4_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($gamead4_creative_data);
			
			// Insert Game ad5 banner
							
			$gamead5_creative_data 	= 	array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_game5_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_game5_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_game5_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_GAME,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_GAMEBOX_FIVE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_game5_creative_moved=	$this->image_lib->move_creative_to_original_location($this->post('tmp_game5_creative'));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($gamead5_creative_data);
			
			// Insert Game ad6 banner
							
			$gamead6_creative_data 	= 	array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_game6_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_game6_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_game6_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_GAME,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_GAMEBOX_SIX,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_game6_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game6_creative')));
			
			//Call to add a creative
			$creative_add	=	$this->do_mobile_creative->add_child($gamead6_creative_data);

			if($creative_add)
			{
				
				
			/***creative change for message/mail notification*****/
				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='gamebox creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Gamebox Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $gamead_creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Gamebox Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	=> $redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: add_gamebox_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage gamebox creative adding process
	*/
	
	public function add_bannerbox_creative_post()
	{
		$this->form_validation->set_rules('bannerbox_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		$campaign = clean_data($this->post('_wban_campaign_id'));
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_wban_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= $this->post('_wban_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			$bannertype		=	WEB_CREATIVE_BANNERBOX;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wban_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wban_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}			
			
			$creative_width	=	'300';
			$creative_height=	'250';

			$bannerad_creative_data = 	array(
											"contenttype"		=>	clean_data($this->post('tmp_banner1_creative_content_type')),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data($storage_type),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"description"		=>	clean_data($this->post('bannerbox_creative_name')),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),						
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//Call to add a creative
			$blob_data	=	FALSE;
			$banner_id	=	$this->do_web_creative->add($bannerad_creative_data,$blob_data,$agency_id);
				
			// Insert Game ad2 banner
							
			$bannerad1_creative_data = 	array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_banner1_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_banner1_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"link_url"		=>  clean_data($this->post('url1')),
											"ban_description" => clean_data($this->post('desc1')),
											"content_type"	=>	clean_data($this->post('tmp_banner1_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_BANNER,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_BANNERBOX_ONE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_banner1_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner1_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($bannerad1_creative_data);
			
			// Insert Game ad2 banner
							
			$bannerad2_creative_data = 	array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_banner2_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_banner2_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"link_url"		=>  clean_data($this->post('url2')),
											"ban_description" => clean_data($this->post('desc2')),
											"content_type"	=>	clean_data($this->post('tmp_banner2_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_BANNER,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_BANNERBOX_TWO,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_banner2_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner2_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($bannerad2_creative_data);
			
			// Insert Game ad3 banner
							
			$bannerad3_creative_data 	= 	array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_banner3_creative')),
												"dj_file_size"	=>	clean_data($this->post('tmp_banner3_creative_size')),
												"width"			=>	clean_data($creative_width),
												"height"		=>	clean_data($creative_height),
												"link_url"		=>  clean_data($this->post('url3')),
												"ban_description" => clean_data($this->post('desc3')),
												"content_type"	=>	clean_data($this->post('tmp_banner3_creative_content_type')),
												"display_type" 	=> 	WEB_CREATIVE_BANNER,
												"display_size" 	=> 	MEDIUM,
												"position" 		=> 	WEB_CREATIVE_BANNERBOX_THREE,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path,
												"dj_admarket_status" =>  $adma_id
											);
			
			//On sucess move the expand creative from tmp location to original location
			$is_banner3_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner3_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($bannerad3_creative_data);
			
			// Insert Game ad4 banner
							
			$bannerad4_creative_data 	= 	array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_banner4_creative')),
											"dj_file_size"	=>	clean_data($this->post('tmp_banner4_creative_size')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"link_url"		=>  clean_data($this->post('url4')),
											"ban_description" => clean_data($this->post('desc4')),
											"content_type"	=>	clean_data($this->post('tmp_banner4_creative_content_type')),
											"display_type" 	=> 	WEB_CREATIVE_BANNER,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	WEB_CREATIVE_BANNERBOX_FOUR,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_banner4_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner4_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($bannerad4_creative_data);
			
			// Insert Game ad5 banner
							
			$bannerad5_creative_data 	= 	array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_banner5_creative')),
												"dj_file_size"	=>	clean_data($this->post('tmp_banner5_creative_size')),
												"width"			=>	clean_data($creative_width),
												"height"		=>	clean_data($creative_height),
												"link_url"		=>  clean_data($this->post('url5')),
												"ban_description" => clean_data($this->post('desc5')),
												"content_type"	=>	clean_data($this->post('tmp_banner5_creative_content_type')),
												"display_type" 	=> 	WEB_CREATIVE_BANNER,
												"display_size" 	=> 	MEDIUM,
												"position" 		=> 	WEB_CREATIVE_BANNERBOX_FIVE,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path,
												"dj_admarket_status" =>  $adma_id
											);
			
			//On sucess move the expand creative from tmp location to original location
			$is_banner5_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner5_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($bannerad5_creative_data);
			
			// Insert Game ad6 banner
							
			$bannerad6_creative_data 	= 	array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_banner6_creative')),
												"dj_file_size"	=>	clean_data($this->post('tmp_banner6_creative_size')),
												"width"			=>	clean_data($creative_width),
												"height"		=>	clean_data($creative_height),
												"link_url"		=>  clean_data($this->post('url6')),
												"ban_description" => clean_data($this->post('desc6')),
												"content_type"	=>	clean_data($this->post('tmp_banner6_creative_content_type')),
												"display_type" 	=> 	WEB_CREATIVE_BANNER,
												"display_size" 	=> 	MEDIUM,
												"position" 		=> 	WEB_CREATIVE_BANNERBOX_SIX,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path,
												"dj_admarket_status" =>  $adma_id
											);
			
			//On sucess move the expand creative from tmp location to original location
			$is_banner6_creative_moved=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner6_creative')));
			
			//Call to add a creative
			$creative_add	=	$this->do_mobile_creative->add_child($bannerad6_creative_data);

			if($creative_add)
			{
				
					/***creative change for message/mail notification*****/
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Bannerbox creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Bannerbox Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] =$bannerad_creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Bannerbox Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					/***creative change for message/mail notification*****/	
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,  
								);
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	=> $redirect_url	,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: add_slider_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage slider creative adding process
	*/
	
	public function add_slider_creative_post()
	{
		$this->form_validation->set_rules('slider_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|url');
		$is_link = 	clean_data($this->post('is_link'));

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if($is_link =='url')
		{
			$this->form_validation->set_rules('external_url', 'Creative URL', 'required|trim|callback_url_check');
			$storage_type	=	'url';	
		}
		elseif($is_link =='html')
		{
			$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
			$storage_type	=	'html';		
		}
		elseif($is_link == 'flash')
		{
			$storage_type 	= 	'web';
		}
		else
		{
			$storage_type	=	'web';		
		}
		$campaign = clean_data($this->post('_wsl_campaign_id'));
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_wsl_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_wsl_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			//$storage_type	=	"web";
			
			if(clean_data($this->post('_creative_type'))=='Web')
			{
				$bannertype		=	WEB_CREATIVE_SLIDER;
			}
			else if(clean_data($this->post('_creative_type'))=='Mobile')
			{
				$bannertype		=	MOBILE_CREATIVE_SLIDER;
			}
			else
			{
				$bannertype		=	WEB_CREATIVE_SLIDER;
			}
			
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wsl_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wsl_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}			
			
			$creative_size	=	explode('x',$this->post('slider_creative_size'));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];

			$creative_data = 	array(
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('slider_creative_name')),
									"width"				=>	clean_data($creative_width),
									"height"			=>	clean_data($creative_height),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),						
									"dj_banner_type"	=>	clean_data($bannertype),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									"dj_admarket_status" =>  $adma_id
								);
			
			
			// Layer type like image, text or url
			if($is_link=='url')
			{	
				$creative_data['contenttype']	=	'url';
				$creative_data['storagetype']	=	'url';
				$creative_data['imageurl']		=	clean_data($this->post('external_url'));			
			}
			elseif($is_link=='html')
			{
				$htmlcache		=	html_anchor_tag_replacer($_REQUEST['html_content']);
				$html_template 	= 	stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
				
				$creative_data['contenttype']	=	clean_data($storage_type);	
				$creative_data['htmltemplate']	=	html_entity_decode($html_template);
				$creative_data['htmlcache']		=	stripslashes($htmlcache);
			}
			elseif($is_link=='flash')
			{
				$creative_data['contenttype']	=	'swf';//clean_data($this->post('tmp_flash_creative_content_type'));
				$creative_data['filename']		=	clean_data($this->post('tmp_flash_creative'));
				$creative_data['file_size']		=	clean_data($this->post('tmp_flash_creative_size'));
				//FOR SWF FILE VALUES
				$banner_url=clean_data($this->url_creation($this->post('destination_url')));
				$ban_target='_blank';
				
				$content		=file_get_contents(clean_data($this->post('tmp_flash_creative_url')));

				if ($this->swf_banner->phpAds_SWFCompressed($content))
				{
					$buffer = 	$this->swf_banner->phpAds_SWFDecompress($content);								
					$buffer = 	preg_replace('/clickTAG/i', 'clickTAG', $buffer);
					$content=	$this->swf_banner->phpAds_SWFCompress($buffer);
				}
				else
				{									
					$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
				}

				//Store width and height
				list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
				$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
				$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
				if(!empty($hardcodedLinks))
				{
					//Remove Hardcoded link from swf file
					 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
					 {
						// SWF's requiring player version 6+ which are already compressed should stay compressed
						if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
						{
							$compress = true;
						}
						elseif (isset($compress))
						{
							$compress = true;
						}
						else
						{
							$compress = false;
						}
						if (!isset($convert_links))
						{
							$convert_links = array();
						}
						$convert_links = array_keys($hardcodedLinks);
						list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
						if ($result != $content)
						{
							if (count($parameters) > 0)
							{
								// Prepare the parameters
								$parameters_complete = array();
								//Small hack to overwrite hard_coded values with destination url
								unset($overwrite_link);
								unset($overwrite_target);	
								$overwrite_link = array('0'=>$banner_url);

								$overwrite_target = array('0'=>$ban_target);	

								foreach ($parameters as $key => $val)
								{
									if (isset($overwrite_source) && $overwrite_source[$val] != '')
									{
										$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
									}
									$parameters_complete[$key] = array(
										'link' => $overwrite_link[0],
										'tar'  =>$overwrite_target[0],
									);
								}
								$parameters = array('swf' => $parameters_complete);
									
							}
							else
							{
								$parameters = '';
							}
							//When storing banner details into table,Don't forget to update parameters field
							$param = empty($parameters) ? null : serialize($parameters);
						}
					}	
				}
				else
				{
					$param = "N;";
				}
				
				$creative_data['parameters'] = $param;
				$creative_data['pluginversion'] =	$pluginVersion;
				
				// Move Creative to original Location				
				$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_flash_creative')));	
			}
			else
			{
				$creative_data['contenttype']	=	clean_data($this->post('tmp_slide_creative_content_type'));
				$creative_data['filename']		=	clean_data($this->post('tmp_slide_creative'));
				$creative_data['file_size']		=	clean_data($this->post('tmp_slide_creative_size'));
				
				// Move Creative to original Location				
				$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_slide_creative')));	
			}			
			
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);  

			if($creative_add)
			{
				
			/***creative change for message/mail notification*****/
				
				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Slider creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Slider Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Slider Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			
			/***creative change for message/mail notification*****/	
				
				
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: add_catfish_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage catfish creative adding process
	*/
	
	public function add_catfish_creative_post()
	{
		$this->form_validation->set_rules('catfish_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if(clean_data($this->post('catfish_type'))=='text')
		{
			$this->form_validation->set_rules('catfish_text', 'Text', 'required|trim|url');
		}
		
		$campaign = clean_data($this->post('_wcat_campaign_id'));
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_wcat_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_wcat_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	(clean_data($this->post('catfish_type'))=='image')?"web":"txt";
			
			if(clean_data($this->post('_creative_type'))=='Web')
			{
				$bannertype		=	WEB_CREATIVE_CATFISH;
			}
			else if(clean_data($this->post('_creative_type'))=='Mobile')
			{
				$bannertype		=	MOBILE_CREATIVE_CATFISH;
			}
			else if(clean_data($this->post('_creative_type'))=='App')
			{
				$bannertype		=	APP_CREATIVE_CATFISH;
			}
			else
			{
				$bannertype		=	WEB_CREATIVE_CATFISH;
			}
			
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wcat_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wcat_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}			
			
			$creative_size	=	explode('x',$this->post('catfish_creative_size'));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];
				
			if(clean_data($this->post('catfish_type'))=='image')
			{
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = 	array(
											"contenttype"		=>	clean_data($this->post('tmp_cat_creative_content_type')),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data($storage_type),
											"description"		=>	clean_data($this->post('catfish_creative_name')),
											"filename"			=>	clean_data($this->post('tmp_cat_creative')),
											"file_size"			=>	$this->post('tmp_cat_creative_size'),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),						
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
					
					// Move Creative to original Location
					
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_cat_creative')));					
				}
			}
			elseif(clean_data($this->post('catfish_type'))=='text')
			{
				$creative_data = 	array(
											"contenttype"		=>	clean_data('txt'),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data('txt'),
											"description"		=>	clean_data($this->post('catfish_creative_name')),
											"bannertext"		=>	htmlentities($this->post('catfish_text')),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),						
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			}
			
			//print_r($creative_data);  die("testong");
			
			//$this->response( $creative_data, 200);     
			
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);  
			
			
			/***creative change for message/mail notification*****/
				
				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Catfish creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Cat Fish Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Cat Fish Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					//$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
			if($creative_add)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
						
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,  
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	
	/*
	* 
	* name: add_exit_popunder_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage Exit popunder creative adding process
	*/
	
	public function add_exit_popunder_creative_post()
	{
		$this->form_validation->set_rules('exit_popunder_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if(clean_data($this->post('exit_popunder_type'))=='text')
		{
			$this->form_validation->set_rules('exit_popunder_text', 'Text', 'required|trim|url');
		}
		
		$campaign = clean_data($this->post('_exit_popunder_campaign_id'));
						
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_wexit_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_exit_popunder_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{	
			
			$storage_type	=	(clean_data($this->post('exit_popunder_type'))=='image')?"web":"txt";
			
			$bannertype		=	WEB_CREATIVE_EXIT_POPUNDER;					
			
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wexit_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wexit_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$storage_type	=	"web";
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}			
			
			$creative_size	=	explode('x',$this->post('exit_popunder_creative_size'));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];
			
			if(clean_data($this->post('exit_popunder_type'))=='image')
			{
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = 	array(
											"contenttype"		=>	clean_data($this->post('tmp_exit_popunder_creative_content_type')),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data($storage_type),
											"description"		=>	clean_data($this->post('exit_popunder_creative_name')),
											"filename"			=>	clean_data($this->post('tmp_exit_popunder_creative')),
											"file_size"			=>	$this->post('tmp_exit_popunder_creative_size'),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),						
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
					
					// Move Creative to original Location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_exit_popunder_creative')));								
				}
			}
			elseif(clean_data($this->post('exit_popunder_type'))=='text')
			{
				$creative_data = 	array(
											"contenttype"		=>	clean_data('txt'),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data('txt'),
											"description"		=>	clean_data($this->post('exit_popunder_creative_name')),
											"bannertext"		=>	htmlentities($this->post('exit_popunder_text')),
											"width"				=>	clean_data('0'),
											"height"			=>	clean_data('0'),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),						
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id
										);
			}	
					
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
			
			
			/***creative change for message/mail notification*****/
				
				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Exit Popunder creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Exit Popunder Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Exit Popunder Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					//$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
			if($creative_add)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	
	
	/*
	* 
	* name: add_siteskin_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage siteskin creative adding process
	*/
	
	public function add_siteskin_creative_post()
	{
		$this->form_validation->set_rules('siteskin_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$campaign = clean_data($this->post('_wsit_campaign_id'));
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_wsit_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_wsit_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			$bannertype		=	WEB_CREATIVE_SITESKIN;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_wsit_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_wsit_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}	
			
			if(clean_data($this->post('siteskin_type'))=='LR')
			{
				$creative_width	=	'120';
				$creative_height=	'600';
			}
			else
			{
				$creative_width	=	'1920';
				$creative_height=	'1200';
			}		
			
			if(clean_data($this->post('siteskin_type'))=='LR')
			{
				$contenttype   =    clean_data($this->post('tmp_siteskin_left_creative_content_type'));	
			}		
			
			elseif(clean_data($this->post('siteskin_type'))=='BGD')
			{
				$contenttype   =    clean_data($this->post('tmp_siteskin_background_creative_content_type'));
			}		
			
			$creative_data = 	array(
									"contenttype"		=>	clean_data($contenttype),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"width"				=>	clean_data($creative_width),
									"height"			=>	clean_data($creative_height),
									"description"		=>	clean_data($this->post('siteskin_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),						
									"dj_banner_type"	=>	clean_data($bannertype),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									"dj_admarket_status" =>  $adma_id
								);
			//Call to add a creative
			$blob_data	=	FALSE;
			$banner_id	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
			
			if(clean_data($this->post('siteskin_type'))=='LR')
			{
				$siteskin_left_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_siteskin_left_creative')),
													"dj_file_size"	=>	clean_data($this->post('tmp_siteskin_left_creative_size')),
													"width"			=>	clean_data($creative_width),
													"height"		=>	clean_data($creative_height),
													"content_type"	=>	clean_data($this->post('tmp_siteskin_left_creative_content_type')),
													"display_type" 	=> 	WEB_CREATIVE_SITE,
													"display_size" 	=> 	MEDIUM,
													"position" 		=> 	WEB_CREATIVE_SITESKIN_LEFT,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path,
													"dj_admarket_status" =>  $adma_id
												);
			
				//On sucess move the expand creative from tmp location to original location
				$is_site_left_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_siteskin_left_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($siteskin_left_creative_data);
				
				$siteskin_right_creative_data 	= 	array(
														"banner_id" 	=> 	$banner_id,
														"file_path"		=>	clean_data($this->post('tmp_siteskin_right_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_siteskin_right_creative_size')),
														"width"			=>	clean_data($creative_width),
														"height"		=>	clean_data($creative_height),
														"content_type"	=>	clean_data($this->post('tmp_siteskin_right_creative_content_type')),
														"display_type" 	=> 	WEB_CREATIVE_SITE,
														"display_size" 	=> 	MEDIUM,
														"position" 		=> 	WEB_CREATIVE_SITESKIN_RIGHT,
														"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path,
														"dj_admarket_status" =>  $adma_id
													);
				
				//On sucess move the expand creative from tmp location to original location
				$is_site_right_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_siteskin_right_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($siteskin_right_creative_data);
			}
			elseif($this->post('siteskin_type')=='BGD')
			{
				$siteskin_bgd_creative_data 	= 	array(
														"banner_id" 	=> 	$banner_id,
														"file_path"		=>	clean_data($this->post('tmp_siteskin_background_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_siteskin_background_creative_size')),
														"width"			=>	clean_data($creative_width),
														"height"		=>	clean_data($creative_height),
														"content_type"	=>	clean_data($this->post('tmp_siteskin_background_creative_content_type')),
														"display_type" 	=> 	WEB_CREATIVE_SITE,
														"display_size" 	=> 	MEDIUM,
														"position" 		=> 	WEB_CREATIVE_SITESKIN_BACKGROUND,
														"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path,
														"dj_admarket_status" =>  $adma_id
													);
			
				//On sucess move the expand creative from tmp location to original location
				$is_site_bgd_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_siteskin_background_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($siteskin_bgd_creative_data);	
			}			
						

			if($banner_id)
			{
				
				/***creative change for message/mail notification*****/
				
				
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Siteskin creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Siteskin Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Siteskin Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	=> $redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
										
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										/*'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: edit_popup_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage popup creative editing process
	*/
	
	public function edit_popup_creative_post()
	{		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		$this->form_validation->set_rules('pop_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id	=	clean_data($this->post('web_creative_id'));
			
			$storage_type	=	"web";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('pop_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
			
			//Call to edit a creative
			$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Popup creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Popup Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Popup Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
					/***creative edit for message/mail notification*****/
					/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: edit_layer_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage layer/interstitial creative editing process
	*/
	
	public function edit_layer_creative_post()
	{
		$this->form_validation->set_rules('layer_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		$is_link 		= 	clean_data($this->post('is_link'));

		if($is_link =='url')
		{
			$this->form_validation->set_rules('external_url', 'Creative URL', 'required|trim|url');
			$storage_type	=	'url';	
		}
		elseif($is_link =='html')
		{
			$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
			$storage_type	=	'html';		
		}
		elseif($is_link == 'flash')
		{
			$tmp_flash_creative=clean_data($this->post('tmp_flash_creative'));
			$storage_type = 'web';
			if (empty($tmp_flash_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected.');
				$this->form_validation->set_rules('flash_creative', 'Creative', 'required');
			}
		}
		else
		{
			$storage_type		=	'web';		
			$tmp_layer_creative	=	clean_data($this->post('tmp_layer_creative'));
			if(empty($tmp_layer_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('layer_creative', 'Creative', 'required');
			}
		}
		
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_id	=	clean_data($this->post('web_creative_id'));	
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";		
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('layer_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
			
			// Layer type like image, text or url
			if($is_link=='url')
			{	
				$creative_data['contenttype']	=	'url';
				$creative_data['filename']		=	'';		
				$creative_data['file_size']		=	'';		
				$creative_data['imageurl']		=	clean_data($this->post('external_url'));
				$creative_data['htmltemplate']	=	'';
				$creative_data['htmlcache']		=	'';			
				$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			}

			elseif($is_link=='html')
			{
				$htmlcache		=	html_anchor_tag_replacer($_REQUEST['html_content']);
				$html_template 	= 	stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
				
				$creative_data['contenttype']	=	clean_data($storage_type);	
				$creative_data['filename']		=	'';		
				$creative_data['file_size']		=	'';		
				$creative_data['imageurl']		=	'';
				$creative_data['htmltemplate']	=	html_entity_decode($html_template);
				$creative_data['htmlcache']		=	stripslashes($htmlcache);
				$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			}
			elseif($is_link == 'flash')
			{
				//FOR SWF FILE VALUES
				$banner_url=clean_data($this->url_creation($this->post('destination_url')));
				$ban_target='_blank';
								
				//IF FLASH CHANGED
				if(clean_data($this->post('old_flash_creative')) != clean_data($this->post('tmp_flash_creative')))
				{
						$content		=file_get_contents(clean_data($this->post('tmp_flash_creative_url')));

						if ($this->swf_banner->phpAds_SWFCompressed($content))
						{
							$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
							$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
							$content =$this->swf_banner->phpAds_SWFCompress($buffer);
						}
						else
						{									
							$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
						}

						//Store width and height
						list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
						$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
						$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
						if(!empty($hardcodedLinks))
						{
							//Remove Hardcoded link from swf file
							 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
							 {
								// SWF's requiring player version 6+ which are already compressed should stay compressed
								if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
								{
									$compress = true;
								}
								elseif (isset($compress))
								{
									$compress = true;
								}
								else
								{
									$compress = false;
								}
								if (!isset($convert_links))
								{
									$convert_links = array();
								}
								$convert_links = array_keys($hardcodedLinks);
								list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
								if ($result != $content)
								{
									if (count($parameters) > 0)
									{
										// Prepare the parameters
										$parameters_complete = array();
										//Small hack to overwrite hard_coded values with destination url
										unset($overwrite_link);
										unset($overwrite_target);	
										$overwrite_link = array('0'=>$banner_url);

										$overwrite_target = array('0'=>$ban_target);	

											foreach ($parameters as $key => $val)
											{
												if (isset($overwrite_source) && $overwrite_source[$val] != '')
												{
													$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
												}
												$parameters_complete[$key] = array(
													'link' => $overwrite_link[0],
													'tar'  =>$overwrite_target[0],
												);
											}
											$parameters = array('swf' => $parameters_complete);
											
									}
									else
									{
										$parameters = '';
									}
									//When storing banner details into table,Don't forget to update parameters field
									$param = empty($parameters) ? null : serialize($parameters);
								}
							}	
						}
						else
						{
							$param = "N;";
						}
						
						$creative_data['contenttype'] = 'swf';
						//$creative_data['storagetype'= 'web';
						$creative_data['filename']= clean_data($this->post('tmp_flash_creative'));
						$creative_data['file_size']		=clean_data($this->post('tmp_flash_creative_size'));		
						$creative_data['parameters'] = $param;
						$creative_data['pluginversion'] = $pluginVersion;
						$creative_data['imageurl']		=	'';
						$creative_data['htmltemplate']	=	'';
						$creative_data['htmlcache']		=	'';
						$creative_data['dj_image_path']		=	$dj_image_path;
						
						$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

						$old_layer_flash_creative_path = clean_data($this->post('old_layer_flash_creative_path'));
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_flash_creative')));

						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_flash_creative')),$old_layer_flash_creative_path);
				}
				//IF FLASH NOT CHANGED
				else
				{
						$creative_data['contenttype'] = 'swf';
						//$creative_data['storagetype'] = 'web';
						$creative_data['filename']	  	= 	clean_data($this->post('tmp_flash_creative'));
						$creative_data['file_size']		=	clean_data($this->post('tmp_flash_creative_size'));		
						$creative_data['imageurl']		=	'';
						$creative_data['htmltemplate']	=	'';
						$creative_data['htmlcache']		=	'';	
								
						$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
				}
			}
			else
			{
				$creative_data['contenttype']	=	clean_data($this->post('tmp_layer_creative_content_type'));
				$creative_data['filename']		=	clean_data($this->post('tmp_layer_creative'));
				$creative_data['file_size']		=	clean_data($this->post('tmp_layer_creative_size'));		
				$creative_data['imageurl']		=	'';
				$creative_data['htmltemplate']	=	'';
				$creative_data['htmlcache']		=	'';			
				
				if($this->post('old_layer_creative') != $this->post('tmp_layer_creative'))
				{
					$creative_data['dj_image_path']		=	$dj_image_path;
					$old_layer_creative_path = clean_data($this->post('old_layer_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location($this->post('tmp_layer_creative'));
					//Delete old creative
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_layer_creative')),$old_layer_creative_path);
				}
				
				$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			}
			
			if($creative_edit)
			{	
				
					/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Layer creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Layer Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Layer Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
					/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}					
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: edit_gamebox_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage gamebox creative editing process
	*/
	
	public function edit_gamebox_creative_post()
	{
		$this->form_validation->set_rules('gamebox_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');		
		$tmp_game1_creative	=	clean_data($this->post('tmp_game1_creative'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($tmp_game1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('game1_creative', 'Creative', 'required');
		}
		
		$tmp_game2_creative	=	clean_data($this->post('tmp_game2_creative'));
		if(empty($tmp_game2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('game2_creative', 'Creative', 'required');
		}
		
		$tmp_game3_creative	=	clean_data($this->post('tmp_game3_creative'));
		if(empty($tmp_game3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('game3_creative', 'Creative', 'required');
		}
		
		$tmp_game4_creative	=	clean_data($this->post('tmp_game4_creative'));
		if(empty($tmp_game4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('game4_creative', 'Creative', 'required');
		}
		
		$tmp_game5_creative	=	clean_data($this->post('tmp_game5_creative'));
		if(empty($tmp_game5_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('game5_creative', 'Creative', 'required');
		}
		
		$tmp_game6_creative	=	clean_data($this->post('tmp_game6_creative'));
		if(empty($tmp_game6_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('game6_creative', 'Creative', 'required');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_id	=	clean_data($this->post('web_creative_id'));	
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$gamead_creative_data = 	array(
											"contenttype"		=>	clean_data($this->post('tmp_game1_creative_content_type')),
											"storagetype"		=>	clean_data($storage_type),
											"description"		=>	clean_data($this->post('gamebox_creative_name')),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
										);
			
			//Call to edit a creative
			$creative_edit	=	$this->do_web_creative->edit($gamead_creative_data,$creative_id,$agency_id);
				
			if($creative_edit)
			{	
				
				
					/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Gamebox creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Gamebox Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $gamead_creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Gamebox Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if(clean_data($this->post('old_game1_creative'))!=clean_data($this->post('tmp_game1_creative')))
				{
					// Update game1 creative 
					
					$gamead1_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_game1_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_game1_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_game1_creative_content_type')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_game1 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_GAME,
														"position"		=>	WEB_CREATIVE_GAMEBOX_ONE
														);		
					$old_game1_image_path =clean_data($this->post('old_game1_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_game1_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game1_creative')));
					
					$is_old_game1_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_game1_creative')),$old_game1_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($gamead1_creative_data,$where_game1);	
				}				
				
				if($this->post('old_game2_creative')!=$this->post('tmp_game2_creative'))
				{
					// Update game2 creative 
					
					$gamead2_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_game2_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_game2_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_game2_creative_content_type')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_game2 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_GAME,
														"position"		=>	WEB_CREATIVE_GAMEBOX_TWO
														);		
					$old_game2_image_path = clean_data($this->post('old_game2_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_game2_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game2_creative')));
					
					$is_old_game2_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_game2_creative')),$old_game2_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($gamead2_creative_data,$where_game2);	
				}
				
				if(clean_data($this->post('old_game3_creative'))!=clean_data($this->post('tmp_game3_creative')))
				{
					// Update game3 creative 
					
					$gamead3_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_game3_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_game3_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_game3_creative_content_type')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_game3 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_GAME,
														"position"		=>	WEB_CREATIVE_GAMEBOX_THREE
														);		
					$old_game3_image_path = clean_data($this->post('old_game3_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_game3_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game3_creative')));
					
					$is_old_game3_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_game3_creative')),$old_game3_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($gamead3_creative_data,$where_game3);	
				}
				
				if(clean_data($this->post('old_game4_creative'))!=clean_data($this->post('tmp_game4_creative')))
				{
					// Update game4 creative 
					
					$gamead4_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_game4_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_game4_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_game4_creative_content_type')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_game4 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_GAME,
														"position"		=>	WEB_CREATIVE_GAMEBOX_FOUR
														);		
					$old_game4_image_path = clean_data($this->post('old_game4_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_game4_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game4_creative')));
					
					$is_old_game4_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_game4_creative')),$old_game4_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($gamead4_creative_data,$where_game4);	
				}
				
				if(clean_data($this->post('old_game5_creative'))!=clean_data($this->post('tmp_game5_creative')))
				{
					// Update game5 creative 
					
					$gamead5_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_game5_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_game5_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_game5_creative_content_type')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_game5 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_GAME,
														"position"		=>	WEB_CREATIVE_GAMEBOX_FIVE
														);		
					$old_game5_image_path = clean_data($this->post('old_game5_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_game5_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game5_creative')));
					
					$is_old_game5_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_game5_creative')),$old_game5_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($gamead5_creative_data,$where_game5);	
				}
				
				if(clean_data($this->post('old_game6_creative'))!=clean_data($this->post('tmp_game6_creative')))
				{
					// Update game6 creative 
					
					$gamead6_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_game6_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_game6_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_game6_creative_content_type')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_game6 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_GAME,
														"position"		=>	WEB_CREATIVE_GAMEBOX_SIX
														);		
					$old_game6_image_path = clean_data($this->post('old_game6_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_game6_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_game6_creative')));
					
					$is_old_game6_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_game6_creative')),$old_game6_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($gamead6_creative_data,$where_game6);	
				}	
				
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: edit_bannerbox_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage bannerbox creative editing process
	*/
	
	public function edit_bannerbox_creative_post()
	{
		$this->form_validation->set_rules('bannerbox_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');		
		$tmp_banner1_creative	=	clean_data($this->post('tmp_banner1_creative'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($tmp_banner1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('banner1_creative', 'Creative', 'required');
		}
		
		$tmp_banner2_creative	=	clean_data($this->post('tmp_banner2_creative'));
		if(empty($tmp_banner2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('banner2_creative', 'Creative', 'required');
		}
		
		$tmp_banner3_creative	=	clean_data($this->post('tmp_banner3_creative'));
		if(empty($tmp_banner3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('banner3_creative', 'Creative', 'required');
		}
		
		$tmp_banner4_creative	=	clean_data($this->post('tmp_banner4_creative'));
		if(empty($tmp_banner4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('banner4_creative', 'Creative', 'required');
		}
		
		$tmp_banner5_creative	=	clean_data($this->post('tmp_banner5_creative'));
		if(empty($tmp_banner5_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('banner5_creative', 'Creative', 'required');
		}
		
		$tmp_banner6_creative	=	clean_data($this->post('tmp_banner6_creative'));
		if(empty($tmp_banner6_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('banner6_creative', 'Creative', 'required');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_id	=	clean_data($this->post('web_creative_id'));	
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$bannerad_creative_data = 	array(
											"contenttype"		=>	clean_data($this->post('tmp_banner1_creative_content_type')),
											"storagetype"		=>	clean_data($storage_type),
											"description"		=>	clean_data($this->post('bannerbox_creative_name')),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
										);
			
			//Call to edit a creative
			$creative_edit	=	$this->do_web_creative->edit($bannerad_creative_data,$creative_id,$agency_id);
				
			if($creative_edit)
			{	
				if(clean_data($this->post('old_banner1_creative'))!=clean_data($this->post('tmp_banner1_creative')))
				{
					// Update game1 creative 
					
					$bannerad1_creative_data 		= 	array(
															"file_path"			=>	clean_data($this->post('tmp_banner1_creative')),
															"dj_file_size"		=>	clean_data($this->post('tmp_banner1_creative_size')),
															"content_type"		=>	clean_data($this->post('tmp_banner1_creative_content_type')),
															"link_url"			=>  clean_data($this->post('url1')),
															"ban_description" 	=> 	clean_data($this->post('desc1')),
															"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
															"dj_image_path"		=>  $dj_image_path
														);
						
					$where_banner1 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_ONE
														);
														
					$old_banner1_image_path = clean_data($this->post('old_banner1_creative_path'));											
					//On sucess move the base creative from tmp location to original location
					$is_banner1_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner1_creative')));
					
					$is_old_banner1_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_banner1_creative')),$old_banner1_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($bannerad1_creative_data,$where_banner1);	
				}
				else
				{
					$bannerad1_creative_data 		= 	array(
														"link_url"		=>  clean_data($this->post('url1')),
														"ban_description" => clean_data($this->post('desc1')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													);
					
					$where_banner1 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_ONE
														);		
					//On sucess move the base creative from tmp location to original location
					$this->do_mobile_creative->edit_child_mobile($bannerad1_creative_data,$where_banner1);
				}			
				
				if(clean_data($this->post('old_banner2_creative'))!=clean_data($this->post('tmp_banner2_creative')))
				{
					// Update game2 creative 
					
					$bannerad2_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_banner2_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_banner2_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_banner2_creative_content_type')),
														"link_url"		=>  clean_data($this->post('url2')),
														"ban_description" => clean_data($this->post('desc2')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_banner2 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_TWO
														);		
					
					$old_banner2_image_path = clean_data($this->post('old_banner2_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_banner2_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner2_creative')));
					
					$is_old_banner2_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_banner2_creative')),$old_banner2_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($bannerad2_creative_data,$where_banner2);	
				}
				else
				{
					$bannerad2_creative_data 		= 	array(
														"link_url"		=>  clean_data($this->post('url2')),
														"ban_description" => clean_data($this->post('desc2')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													);
					
					$where_banner2 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_TWO
														);		
					//On sucess move the base creative from tmp location to original location
					$this->do_mobile_creative->edit_child_mobile($bannerad2_creative_data,$where_banner2);
				}	
				
				if(clean_data($this->post('old_banner3_creative'))!=clean_data($this->post('tmp_banner3_creative')))
				{
					// Update game3 creative 
					
					$bannerad3_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_banner3_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_banner3_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_banner3_creative_content_type')),
														"link_url"		=>  clean_data($this->post('url3')),
														"ban_description" => clean_data($this->post('desc3')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_banner3 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_THREE
														);		
					$old_banner3_image_path = clean_data($this->post('old_banner3_creative_path'));
					
					//On sucess move the base creative from tmp location to original location
					$is_banner3_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner3_creative')));
					
					$is_old_banner3_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_banner3_creative')),$old_banner3_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($bannerad3_creative_data,$where_banner3);	
				}
				else
				{
					$bannerad3_creative_data 		= 	array(
														"link_url"		=>  clean_data($this->post('url3')),
														"ban_description" => clean_data($this->post('desc3')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													);
					
					$where_banner3 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_THREE
														);		
					//On sucess move the base creative from tmp location to original location
					$this->do_mobile_creative->edit_child_mobile($bannerad3_creative_data,$where_banner3);
				}	
				
				if(clean_data($this->post('old_banner4_creative'))!=clean_data($this->post('tmp_banner4_creative')))
				{
					// Update game4 creative 
					
					$bannerad4_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_banner4_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_banner4_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_banner4_creative_content_type')),
														"link_url"		=>  clean_data($this->post('url4')),
														"ban_description" => clean_data($this->post('desc4')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_banner4 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_FOUR
														);
					$old_banner4_image_path = clean_data($this->post('old_banner4_creative_path'));											
					//On sucess move the base creative from tmp location to original location
					$is_banner4_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner4_creative')));
					
					$is_old_banner4_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_banner4_creative')),$old_banner4_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($bannerad4_creative_data,$where_banner4);	
				}
				else
				{
					$bannerad4_creative_data 		= 	array(
														"link_url"		=>  clean_data($this->post('url4')),
														"ban_description" => clean_data($this->post('desc4')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													);
					
					$where_banner4 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_FOUR
														);		
					//On sucess move the base creative from tmp location to original location
					$this->do_mobile_creative->edit_child_mobile($bannerad4_creative_data,$where_banner4);
				}
				
				if(clean_data($this->post('old_banner5_creative'))!=clean_data($this->post('tmp_banner5_creative')))
				{
					// Update game5 creative 
					
					$bannerad5_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_banner5_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_banner5_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_banner5_creative_content_type')),
														"link_url"		=>  clean_data($this->post('url5')),
														"ban_description" => clean_data($this->post('desc5')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_banner5 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_FIVE
														);		
					$old_banner5_image_path = clean_data($this->post('old_banner5_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_banner5_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner5_creative')));
					
					$is_old_banner5_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_banner5_creative')),$old_banner5_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($bannerad5_creative_data,$where_banner5);	
				}
				else
				{
					$bannerad5_creative_data 		= 	array(
														"link_url"		=>  clean_data($this->post('url5')),
														"ban_description" => clean_data($this->post('desc5')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													);
					
					$where_banner5 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_FIVE
														);		
					//On sucess move the base creative from tmp location to original location
					$this->do_mobile_creative->edit_child_mobile($bannerad5_creative_data,$where_banner5);
				}	
				
				if(clean_data($this->post('old_banner6_creative'))!=clean_data($this->post('tmp_banner6_creative')))
				{
					// Update game6 creative 
					
					$bannerad6_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_banner6_creative')),
														"dj_file_size"	=>	clean_data($this->post('tmp_banner6_creative_size')),
														"content_type"	=>	clean_data($this->post('tmp_banner6_creative_content_type')),
														"link_url"		=>  clean_data($this->post('url6')),
														"ban_description" => clean_data($this->post('desc6')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_banner6 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_SIX
														);
																
					$old_banner6_image_path = clean_data($this->post('old_banner6_creative_path'));
					//On sucess move the base creative from tmp location to original location
					$is_banner6_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_banner6_creative')));
					
					$is_old_banner6_creative_del	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_banner6_creative')),$old_banner6_image_path);
					
					$this->do_mobile_creative->edit_child_mobile($bannerad6_creative_data,$where_banner6);	
				}
				else
				{
					$bannerad6_creative_data 		= 	array(
														"link_url"		=>  clean_data($this->post('url6')),
														"ban_description" => clean_data($this->post('desc6')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													);
					
					$where_banner6 				= 	array(
														"banner_id"		=>	$creative_id,
														"display_type"	=>	WEB_CREATIVE_BANNER,
														"position"		=>	WEB_CREATIVE_BANNERBOX_SIX
														);		
					//On sucess move the base creative from tmp location to original location
					$this->do_mobile_creative->edit_child_mobile($bannerad6_creative_data,$where_banner6);
				}	
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Bannerbox creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Bannerbox Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $bannerad_creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Bannerbox Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: edit_slider_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage slider creative editing process
	*/
	
	public function edit_slider_creative_post()
	{
		$this->form_validation->set_rules('slider_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$is_link 		= 	clean_data($this->post('is_link'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if($is_link =='url')
		{
			$this->form_validation->set_rules('external_url', 'Creative URL', 'required|trim|url');
			$storage_type	=	'url';	
		}
		elseif($is_link =='html')
		{
			$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
			$storage_type	=	'html';		
		}
		elseif($is_link == 'flash')
		{
			$tmp_flash_creative=clean_data($this->post('tmp_flash_creative'));
			$storage_type = 'web';
			if (empty($tmp_flash_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected.');
				$this->form_validation->set_rules('flash_creative', 'Creative', 'required');
			}
		}
		else
		{
			$tmp_slide_creative	=	clean_data($this->post('tmp_slide_creative'));
			$storage_type = 'web';
			if(empty($tmp_slide_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('slide_creative', 'Creative', 'required');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			//$storage_type	=	"web";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_id	=	clean_data($this->post('web_creative_id'));		
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('slider_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
								
								
			// Layer type like image, text or url
			if($is_link=='url')
			{	
				$creative_data['contenttype']	=	'url';
				$creative_data['filename']		=	'';		
				$creative_data['file_size']		=	0;		
				$creative_data['imageurl']		=	clean_data($this->post('external_url'));
				$creative_data['htmltemplate']	=	'';
				$creative_data['htmlcache']		=	'';			
				$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			}
			elseif($is_link=='html')
			{
				$htmlcache		=	html_anchor_tag_replacer($_REQUEST['html_content']);
				$html_template 	= 	stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
				
				$creative_data['contenttype']	=	clean_data($storage_type);	
				$creative_data['filename']		=	'';	
				$creative_data['file_size']		=	0;			
				$creative_data['imageurl']		=	'';
				$creative_data['htmltemplate']	=	html_entity_decode($html_template);
				$creative_data['htmlcache']		=	stripslashes($htmlcache);
				$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			}
			elseif($is_link == 'flash')
			{
				//FOR SWF FILE VALUES
				$banner_url=clean_data($this->url_creation($this->post('destination_url')));
				$ban_target='_blank';
								
				//IF FLASH CHANGED
				if(clean_data($this->post('old_flash_creative')) != clean_data($this->post('tmp_flash_creative')))
				{
						$content		=file_get_contents(clean_data($this->post('tmp_flash_creative_url')));

						if ($this->swf_banner->phpAds_SWFCompressed($content))
						{
							$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
							$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
							$content =$this->swf_banner->phpAds_SWFCompress($buffer);
						}
						else
						{									
							$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
						}

						//Store width and height
						list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
						$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
						$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
						if(!empty($hardcodedLinks))
						{
							//Remove Hardcoded link from swf file
							 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
							 {
								// SWF's requiring player version 6+ which are already compressed should stay compressed
								if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
								{
									$compress = true;
								}
								elseif (isset($compress))
								{
									$compress = true;
								}
								else
								{
									$compress = false;
								}
								if (!isset($convert_links))
								{
									$convert_links = array();
								}
								$convert_links = array_keys($hardcodedLinks);
								list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
								if ($result != $content)
								{
									if (count($parameters) > 0)
									{
										// Prepare the parameters
										$parameters_complete = array();
										//Small hack to overwrite hard_coded values with destination url
										unset($overwrite_link);
										unset($overwrite_target);	
										$overwrite_link = array('0'=>$banner_url);

										$overwrite_target = array('0'=>$ban_target);	

											foreach ($parameters as $key => $val)
											{
												if (isset($overwrite_source) && $overwrite_source[$val] != '')
												{
													$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
												}
												$parameters_complete[$key] = array(
													'link' => $overwrite_link[0],
													'tar'  =>$overwrite_target[0],
												);
											}
											$parameters = array('swf' => $parameters_complete);
											
									}
									else
									{
										$parameters = '';
									}
									//When storing banner details into table,Don't forget to update parameters field
									$param = empty($parameters) ? null : serialize($parameters);
								}
							}	
						}
						else
						{
							$param = "N;";
						}
						
						$creative_data['contenttype'] = 'swf';
						//$creative_data['storagetype'= 'web';
						$creative_data['filename']		= 	clean_data($this->post('tmp_flash_creative'));
						$creative_data['file_size']		=	clean_data($this->post('tmp_flash_creative_size'));		
						$creative_data['parameters'] = $param;
						$creative_data['pluginversion'] = $pluginVersion;
						$creative_data['imageurl']		=	'';
						$creative_data['htmltemplate']	=	'';
						$creative_data['htmlcache']		=	'';
						$creative_data['dj_image_path']		=	$dj_image_path;
						
						
						$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

						$old_flash_creative_path = clean_data($this->post('old_flash_creative_path'));
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_flash_creative')));

						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_flash_creative')),$old_flash_creative_path);
				}
				//IF FLASH NOT CHANGED
				else
				{
						$creative_data['contenttype'] = 'swf';
						//$creative_data['storagetype'] = 'web';
						$creative_data['filename']	  	= 	clean_data($this->post('tmp_flash_creative'));
						$creative_data['file_size']		=	clean_data($this->post('tmp_flash_creative_size'));		
						$creative_data['imageurl']		=	'';
						$creative_data['htmltemplate']	=	'';
						$creative_data['htmlcache']		=	'';	
								
						$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
				}
			}
			else
			{
				$creative_data['contenttype']	=	clean_data($this->post('tmp_slide_creative_content_type'));
				$creative_data['filename']		=	clean_data($this->post('tmp_slide_creative'));
				$creative_data['file_size']		=	clean_data($this->post('tmp_slide_creative_size'));		
				$creative_data['imageurl']		=	'';
				$creative_data['htmltemplate']	=	'';
				$creative_data['htmlcache']		=	'';			
				
				if(clean_data($this->post('old_slide_creative')) != clean_data($this->post('tmp_slide_creative')))
				{
					$creative_data['dj_image_path']		=	$dj_image_path;
					$old_slide_creative_path = clean_data($this->post('old_slide_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_slide_creative')));
					//Delete old creative
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_slide_creative')),$old_slide_creative_path);
				}
				
				$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			}
			
			//$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			
			if($creative_edit)
			{
					/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Slider creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Slider Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Slider Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
					/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	site_url('advertiser/creatives/'),
									);	
				}
				else
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);  
			}
		}
	}
	
	
	/*
	* 
	* name: edit_exit_popunder_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage catfish creative editing process
	*/
	
	public function edit_exit_popunder_creative_post()
	{
		$this->form_validation->set_rules('exit_popunder_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(clean_data($this->post('exit_popunder_type'))=='text')
		{
			$this->form_validation->set_rules('exit_popunder_text', 'Text', 'required|trim|url');
		}
		
		if(clean_data($this->post('exit_popunder_type'))=='image')
		{
			$tmp_exit_popunder_creative	=	clean_data($this->post('tmp_exit_popunder_creative'));
			if(empty($tmp_exit_popunder_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('exit_popunder_creative', 'Creative', 'required');
			}
		}						
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	(clean_data($this->post('exit_popunder_type'))=='image')?"web":"txt";			
			$agency_id		=	$this->user_authentication->agency_id;			
			$creative_id	=	clean_data($this->post('exit_popunder_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";	
					
			if($this->post('exit_popunder_type')=='image' && clean_data($this->post('old_exit_popunder_creative')) != clean_data($this->post('tmp_exit_popunder_creative')))
			{
				$creative_data = 	array(
										"contenttype"		=>	clean_data($this->post('tmp_exit_popunder_creative_content_type')),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('exit_popunder_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_exit_popunder_creative')),
										"file_size"			=>	$this->post('tmp_exit_popunder_creative_size'),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);	
			}
			else if($this->post('exit_popunder_type')=='image')
			{
				$creative_data = 	array(
										"contenttype"		=>	clean_data($this->post('tmp_exit_popunder_creative_content_type')),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('exit_popunder_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_exit_popunder_creative')),
										"file_size"			=>	$this->post('tmp_exit_popunder_creative_size'),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
									);				
			}
			elseif($this->post('exit_popunder_type')=='text')
			{
				$creative_data = 	array(
											"contenttype"		=>	clean_data('txt'),
											"storagetype"		=>	clean_data('txt'),
											"description"		=>	clean_data($this->post('exit_popunder_creative_name')),
											"bannertext"		=>	htmlentities(clean_data($this->post('exit_popunder_text'))),
											"file_size"			=>	0,
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
										);				
			}
			
			//Call to edit a creative
			$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);					
			if($creative_edit)
			{
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Exit Popunder creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Exit Popunder Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Exit Popunder Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				if(clean_data($this->post('old_exit_popunder_creative')) != clean_data($this->post('tmp_exit_popunder_creative')))
				{
					$old_cat_creative_path = clean_data($this->post('old_exit_popunder_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_exit_popunder_creative')));
					//Delete old creative
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_exit_popunder_creative')),$old_cat_creative_path);
				}		
			
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);   
			}
		}
	}
	
	
	
	
	
	/*
	* 
	* name: edit_catfish_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage catfish creative editing process
	*/
	
	public function edit_catfish_creative_post()
	{
		$this->form_validation->set_rules('catfish_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		if(clean_data($this->post('catfish_type'))=='text')
		{
			$this->form_validation->set_rules('catfish_text', 'Text', 'required|trim|url');
		}
		
		if(clean_data($this->post('catfish_type'))=='image')
		{
			$tmp_cat_creative	=	clean_data($this->post('tmp_cat_creative'));
			if(empty($tmp_cat_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('cat_creative', 'Creative', 'required');
			}
		}

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			
			$storage_type	=	(clean_data($this->post('catfish_type'))=='image')?"web":"txt";			
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_id	=	clean_data($this->post('web_creative_id'));	
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";	
			if($this->post('catfish_type')=='image' && clean_data($this->post('old_cat_creative')) != clean_data($this->post('tmp_cat_creative')))
			{
				$creative_data = 	array(
										"contenttype"		=>	clean_data($this->post('tmp_cat_creative_content_type')),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('catfish_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_cat_creative')),
										"file_size"			=>	$this->post('tmp_cat_creative_size'),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);	
			}
			else if($this->post('catfish_type')=='image')
			{
				$creative_data = 	array(
										"contenttype"		=>	clean_data($this->post('tmp_cat_creative_content_type')),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('catfish_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_cat_creative')),
										"file_size"			=>	$this->post('tmp_cat_creative_size'),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
									);				
			}
			elseif($this->post('catfish_type')=='text')
			{
				$creative_data = 	array(
											"contenttype"		=>	clean_data('txt'),
											"storagetype"		=>	clean_data('txt'),
											"description"		=>	clean_data($this->post('catfish_creative_name')),
											"bannertext"		=>	htmlentities(clean_data($this->post('catfish_text'))),
											"file_size"			=>	0,
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
										);				
			}
			
			//Call to edit a creative
			$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			
			if($creative_edit)
			{
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Catfish creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Catfish Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Catfish Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				if(clean_data($this->post('catfish_type'))=='image' && clean_data($this->post('old_cat_creative')) != clean_data($this->post('tmp_cat_creative')))
				{
					$old_cat_creative_path = clean_data($this->post('old_cat_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_cat_creative')));
					//Delete old creative
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_cat_creative')),$old_cat_creative_path);
				}		
			
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',    
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);  
			}
		}
	}
	
	/*
	* 
	* name: edit_siteskin_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage siteskin creative editing process
	*/
	
	public function edit_siteskin_creative_post()
	{
		$this->form_validation->set_rules('siteskin_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(clean_data($this->post('siteskin_type'))=='LR')
		{
			$tmp_siteskin_left_creative	=	clean_data($this->post('tmp_siteskin_left_creative'));
			$contenttype   =    clean_data($this->post('tmp_siteskin_left_creative_content_type'));	
			if(empty($tmp_siteskin_left_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('siteskin_left_creative', 'Creative', 'required');
			}
			
			$tmp_siteskin_right_creative	=	clean_data($this->post('tmp_siteskin_right_creative'));
			if(empty($tmp_siteskin_right_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('siteskin_right_creative', 'Creative', 'required');
			}
		}	
		
		if(clean_data($this->post('siteskin_type'))=='BGD')
		{
			$tmp_siteskin_background_creative	=	clean_data($this->post('tmp_siteskin_background_creative'));
			$contenttype   =    clean_data($this->post('tmp_siteskin_background_creative_content_type'));
			if(empty($tmp_siteskin_background_creative))
			{
				$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
				$this->form_validation->set_rules('siteskin_background_creative', 'Creative', 'required');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_id	=	clean_data($this->post('web_creative_id'));	
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$creative_data 	= 	array(
									"contenttype"		=>	clean_data($contenttype),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('siteskin_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
			//Call to add a creative
			$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			
			if($creative_edit)
			{
				if($this->post('siteskin_type')=='LR')
				{
					if($this->post('old_siteskin_left_creative')!=$this->post('tmp_siteskin_left_creative'))
					{					
						$siteskin_left_creative_data 	= 	array(
																"file_path"		=>	clean_data($this->post('tmp_siteskin_left_creative')),
																"dj_file_size"	=>	$this->post('tmp_siteskin_left_creative_size'),
																"content_type"	=>	clean_data($this->post('tmp_siteskin_left_creative_content_type')),
																"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
																"dj_image_path"		=>  $dj_image_path
															);
					
						$where_left 					= 	array(
																"banner_id"		=>	$creative_id,
																"display_type"	=>	WEB_CREATIVE_SITE,
																"position"		=>	WEB_CREATIVE_SITESKIN_LEFT
															);	
															
						$old_siteskin_left_image_path = clean_data($this->post('old_siteskin_left_creative_path'));
						//On sucess move the base creative from tmp location to original location
						$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_siteskin_left_creative')));
						
						$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_siteskin_left_creative')),$old_siteskin_left_image_path);
						
						$this->do_mobile_creative->edit_child_mobile($siteskin_left_creative_data,$where_left);
					}
					
					if(clean_data($this->post('old_siteskin_right_creative'))!=clean_data($this->post('tmp_siteskin_right_creative')))
					{						
						$siteskin_right_creative_data 	= 	array(
																"file_path"		=>	clean_data($this->post('tmp_siteskin_right_creative')),
																"dj_file_size"	=>	$this->post('tmp_siteskin_right_creative_size'),
																"content_type"	=>	clean_data($this->post('tmp_siteskin_right_creative_content_type')),
																"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
																"dj_image_path"		=>  $dj_image_path
															);
						
						$where_right 					= 	array(
																"banner_id"		=>	$creative_id,
																"display_type"	=>	WEB_CREATIVE_SITE,
																"position"		=>	WEB_CREATIVE_SITESKIN_RIGHT
															);	
						$old_siteskin_right_image_path = clean_data($this->post('old_siteskin_right_creative_path'));									
						//On sucess move the base creative from tmp location to original location
						$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_siteskin_right_creative')));
						
						$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_siteskin_right_creative')),$old_siteskin_right_image_path);
						
						$this->do_mobile_creative->edit_child_mobile($siteskin_right_creative_data,$where_right);
					}
				}
				elseif(clean_data($this->post('siteskin_type'))=='BGD')
				{
					if(clean_data($this->post('old_siteskin_background_creative'))!=clean_data($this->post('tmp_siteskin_background_creative')))
					{
						$siteskin_bgd_creative_data 	= 	array(
															"file_path"		=>	clean_data($this->post('tmp_siteskin_background_creative')),
															"dj_file_size"	=>	clean_data($this->post('tmp_siteskin_background_creative_size')),
															"content_type"	=>	clean_data($this->post('tmp_siteskin_background_creative_content_type')),
															"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
															"dj_image_path"		=>  $dj_image_path
														);
					
						$where_bgd 				= 	array(
															"banner_id"		=>	$creative_id,
															"display_type"	=>	WEB_CREATIVE_SITE,
															"position"		=>	WEB_CREATIVE_SITESKIN_BACKGROUND
														);	
						$old_siteskin_background_image_path = clean_data($this->post('old_siteskin_background_creative_path'));										
						//On sucess move the base creative from tmp location to original location
						$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_siteskin_background_creative')));
						
						$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_siteskin_background_creative')),$old_siteskin_background_image_path);
						
						$this->do_mobile_creative->edit_child_mobile($siteskin_bgd_creative_data,$where_bgd); 
					}					
				}	
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Steskin creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Siteskin Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Siteskin Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
					/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	$redirect_url,
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	$redirect_url,
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: check_companion_size
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in temporary location
	 */
	
	public function check_creatives_post()
	{
		$campaign_id	=	$this->post('campaign_id');
		$width			=	$this->post('companion_width');
		$height			=	$this->post('companion_height');
		if($width && $height)
		{
			$companion			=	$this->do_video_creative->check_companion_size($campaign_id,$width,$height);
			if($companion)
			{
				$success = array(
							'response' 	=> 'ok',
							'msg'	 	=> 'Creative exist for selected companion size'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Creative does not exist for selected companion size'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Unable to find available banner'
							);
			$this->response($error, 200);
		}
	}
	public function add_topbar_creative_post()
	{
		//$this->response($this->post(),200); exit();  
		
		$this->form_validation->set_rules('topbar_creative_name','Creative name', 'required|trim');
		
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('backgroundcolor', 'Background Color URL', 'required|trim');
		
		$this->form_validation->set_rules('text_msg_field', 'Text message', 'required|trim');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		$campaign = $this->post('_topbar_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_web_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= $this->post('_topbar_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			//$is_db_store = $this->post('is_db_store');
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$blob_data=array();
			$trusted_status='';
			//Get account/agency_id from library file
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_web_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_web_account_id')));
			}
			
			$agency_id	=	$this->user_authentication->agency_id;

			$is_house_ad= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
						
					//If it is a web creative
					$storage_type	=	'web';
					$bannertype		=	WEB_CREATIVE_TOPBAR;
					//Fetch width and height of the creative
					$creative_size	=	explode('x',"20x20");
					$creative_width	=	$creative_size[0];
					$creative_height=	$creative_size[1];
					if(isset($creative_width) AND isset($creative_height) )
					{
						$creative_data = array(
											"contenttype"		=>	clean_data($this->post('tmp_topbar_creative_content_type')),
											"campaignid"		=>	clean_data($campaign_id),
											"storagetype"		=>	clean_data($storage_type),
											"description"		=>	clean_data($this->post('topbar_creative_name')),
											"bannertext"		=>  clean_data($this->post('text_msg_field')),
											"filename"			=>	clean_data($this->post('tmp_topbar_creative')),
											"width"				=>	clean_data($creative_width),
											"height"			=>	clean_data($creative_height),
											"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
											"dj_admin_approve"	=>	clean_data($dj_admin_approve),
											"dj_approved_date"	=>	clean_data($dj_approved_date),						
											"backgroundcolor"	=>	clean_data($this->post('backgroundcolor')),			
											"dj_banner_type"	=>	clean_data($bannertype),
											"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_account_id" 	=> 	clean_data($dj_account_id),
											"dj_is_direct" 		=> 	clean_data($dj_is_direct),
											"dj_image_path"		=>  $dj_image_path,
											"dj_admarket_status" =>  $adma_id									
										);
					//$this->response( $creative_data, 200);	
						//On sucess move the web creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_topbar_creative')));
		
			//Call to add a creative
			$creative_add=$this->do_web_creative->add($creative_data,$blob_data,$agency_id);

			if($creative_add)
			{
				
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Topbar creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Topbar Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Topbar Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);  
				}
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_topbar_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	 $redirect_url,
									/*'redirect'	 	=> 	site_url('admin/creatives/add_topbar_creatives/'),*/
									);
				}	
					
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_topbar_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						//$redirect_url=site_url('admin/admarket/creatives/');
						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_topbar_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,  
								);	
				}	
				$this->response( $error, 200);
			}
		}
	}
 	
	
}
 /*
	 * 
	 * name: edit_topbar_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all the three SQL,WEB
	 * and URL CREATIVE edit process
	 */
	public function edit_topbar_creative_post()
	{
		//$this->response("haiii"); exit();
		$this->form_validation->set_rules('topbar_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('backgroundcolor', 'Background Color', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('text_msg_field', 'Text message', 'required|trim');
		
		$tmp_topbar_creative=clean_data($this->post('tmp_topbar_creative'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if (empty($tmp_topbar_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('topbar_creative_edit', 'Creative', 'required');
		}

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('topbar_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			if(clean_data($this->post('old_creative')) != clean_data($this->post('tmp_topbar_creative_id_creative')))
			{
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_topbar_creative_content_type')),
					"description"=>clean_data($this->post('topbar_creative_name')),
					"backgroundcolor"	=>	clean_data($this->post('backgroundcolor')),	
					"filename"=>clean_data($this->post('tmp_topbar_creative')),
					"url"=>clean_data($this->url_creation($this->post('destination_url'))),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
				);
			}
			else{
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_topbar_creative_content_type')),
					"description"=>clean_data($this->post('topbar_creative_name')),
					"backgroundcolor"	=>	clean_data($this->post('backgroundcolor')),	
					"filename"=>clean_data($this->post('tmp_topbar_creative')),
					"url"=>clean_data($this->url_creation($this->post('destination_url'))),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					
				);
			}
			//$this->response( $creative_data, 200);
			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;

		    //Call to edit a creative
			$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);

			 if($creative_edit)
			 {
				if(clean_data($this->post('old_creative')) != clean_data($this->post('tmp_topbar_creative')))
				{
					$old_image_path = clean_data($this->post('old_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_topbar_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_creative')),$old_image_path);
				}
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,  
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: add_tablet_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage tablet creative adding process
	*/
	
	public function add_tablet_creative_post()
	{
		$this->form_validation->set_rules('tablet_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('tablet_creative_size','Creative size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');		
		
		$campaign = $this->post('_wtab_campaign_id');
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_wcat_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= $this->post('_wtab_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			$bannertype		=	WEB_CREATIVE_TABLET;
			$dj_image_path 	= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	($this->post('_wtab_type')=='housead')?$this->user_authentication->default_advertiser_account_id:(($this->post('adv_id'))?$this->post('adv_id'):$this->post('_wcat_account_id'));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	$this->post('_is_house_ad');
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}			
			
			$creative_size	=	explode('x',$this->post('tablet_creative_size'));
			$creative_width	=	$creative_size[0];
			$creative_height=	$creative_size[1];
				
			
			if(isset($creative_width) AND isset($creative_height) )
			{
				$creative_data = 	array(
										"contenttype"		=>	clean_data($this->post('tmp_tab_creative_content_type')),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('tablet_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_tab_creative')),
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),						
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path
									);
				
				// Move Creative to original Location
				
				$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_tab_creative'));					
			}			
			
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id);
					
			if($creative_add)
			{
				
				/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Tablet creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Slider Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Web Creative';
			$content['creative_type'] = 'Tablet Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: edit_tablet_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage tablet creative editing process
	*/
	
	public function edit_tablet_creative_post()
	{
		$this->form_validation->set_rules('tablet_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('tablet_creative_size','Creative size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
				
		$tmp_tab_creative	=	$this->post('tmp_tab_creative');
		if(empty($tmp_tab_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab_creative', 'Creative', 'required');
		}	
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			
			$storage_type	=	"web";			
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_id	=	$this->post('tab_creative_id');	
			$dj_image_path 	= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";	
			
			$creative_data 	= 	array(
										"contenttype"		=>	clean_data($this->post('tmp_tab_creative_content_type')),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('tablet_creative_name')),
										"filename"			=>	clean_data($this->post('tmp_tab_creative')),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
									);	
			if($this->post('old_tab_creative') != $this->post('tmp_tab_creative'))
			{
				$creative_data["dj_image_path"] = 	$dj_image_path;	
			}
			
			//Call to edit a creative
			$creative_edit	=	$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
			
			if($creative_edit)
			{
				
				
				/***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Tablet creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp;Tablet Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Tablet Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
					/***creative edit for message/mail notification*****/
					/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
					
					
				if($this->post('old_tab_creative') != $this->post('tmp_tab_creative'))
				{
					$old_tab_creative_path 		= 	$this->post('old_tab_creative_path');
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location($this->post('tmp_tab_creative'));
					//Delete old creative
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date($this->post('old_tab_creative'),$old_tab_creative_path);
				}		
			
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	'Creative sucessfully added',
									'redirect'	=> 	site_url('advertiser/creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Creative sucessfully added',
									'redirect'	=> 	site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	site_url('advertiser/creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'Error. Please try again',
										'redirect'	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: add_single_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage HTML creative adding process
	*/
	public function add_single_creative_post()
	{
		
		$this->form_validation->set_rules('creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$adformat	=	$this->post('ad_format');
		
		$is_html	=	$this->post('is_html');
		
		$is_flash 	= 	$this->post('is_flash');
		$admarket_status 	= 	$this->post('admarket_status');
		if($adformat=='text' || $adformat=='mob_text')
		{
			$this->form_validation->set_rules('text_content', 'Text content', 'required|trim');
		}
		if($adformat=='google_text')
		{
		$this->form_validation->set_rules('text_content', 'Text content', 'required|trim');
		$this->form_validation->set_rules('title', 'Title', 'required|trim');
		}
		if($is_html=='on')
		{
			$this->form_validation->set_rules('html_content', 'Html content', 'required|trim');			
		}
		
		$campaign = $this->post('_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_single_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= $this->post('_campaign_id');
		}
		
			/*********Message Requirements**************/
		/*
		$client_id 		=	$this->user_authentication->client_id;
		
		$account_type	=	$this->user_authentication->account_type;
		
		$network_id	=	$this->do_message->fetch_admin_network_id();
		
		$message  = $this->default_configurations->get('message_type');		
	
		if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$user = $this->do_message->get_affiliate($affiliate_id); 
			
			}
			else{
				//$user = $this->do_message->get_profile($account_id); 
				$user = $this->do_message->get_profile('2'); 
			}
		
		
		$acc_type='ADVERTISER';
		
		$reciever= $this->do_campaign->fetch_reciever($campaign_id);
		
		
		$message_data		=	array(
											'sender_id'		=>	'2',
											'receiver_id'	=>	$reciever['account_id'],
											'subject'		=>	'campaign Deleted',
											'content'		=>	'campaign has been deleted',
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	$acc_type,
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')
											);*/
											
		/*********Message Requirements**************/
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$blob_data		=	array();
			$size_type		=	$this->post('size_type');
			$dj_image_path 	= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				//~ $dj_account_id	=	($this->post('_single_type')=='housead')?$this->user_authentication->default_advertiser_account_id:(($this->post('adv_id'))?$this->post('adv_id'):$this->post('_wtxt_account_id'));
				$dj_account_id	=	($this->post('_single_type')=='housead')?$this->user_authentication->default_advertiser_account_id:(($this->post('adv_id'))?end(explode("_",$this->post('adv_id'))):$this->post('_wtxt_account_id'));  // exploded used to remove client id from adv_id  -- DAC094
			}
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	$this->post('_is_house_ad');
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}				
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}			
			
			$date			=	date("Y-m-d");
			$master_banner 	= 	0;
			$creative_width	=	0;
			$creative_height=	0;
			$filename 		= 	'';
			$file_size 		= 	0;
			$bannertext		=	'';
			$htmlcache		=	'';
			$htmltemplate	=	'';
			$param 			= 	'';
			$pluginVersion	=	'';
			
			if($adformat=='text')
			{
				$storage_type	=	"txt";
				$content_type	=	$storage_type;
				$bannertype		=	WEB_CREATIVE_TEXT;
				$bannertext		=	htmlentities($this->post('text_content'));
			}
			else if($adformat=='google_text')
			{
				$storage_type	=	"txt";
				$content_type	=	$storage_type;
				$bannertype		=	WEB_AD_GOOGLE;
				$bannertext		=	htmlentities($this->post('text_content'));
				$statustext		=	htmlentities($this->post('title'));
				
			}
			else if($adformat=='popunder')
			{
				$storage_type	=	"web";
				$content_type	=	'';
				$bannertype		=	WEB_CREATIVE_POP;
			}
			else if($adformat=='directlink')
			{
				$storage_type	=	"web";
				$content_type	=	'';
				$bannertype		=	WEB_CREATIVE_DIRECT;
			}
			else if($adformat=='mob_dialog')
			{
				$storage_type	=	"web";
				$content_type	=	$storage_type;
				$master_banner 	= 	'-2';
				$bannertype		=	MOBILE_DIALOGUE_CREATIVE;
				$bannertext		=	htmlentities($this->post('text_content'));
			}
			else if($adformat=='mob_text')
			{
				$storage_type	=	"txt";
				$content_type	=	$storage_type;
				$master_banner 	= 	'-2';
				$bannertype		=	MOBILE_TEXT_CREATIVE;
				$bannertext		=	htmlentities($this->post('text_content'));
			}
			else
			{
				$creative_size	=	explode('x',$adformat);
				$creative_width	=	$creative_size[0];
				$creative_height=	$creative_size[1];				
				
				if($size_type=='web')
				{
					$storage_type	=	'web';
					$bannertype		=	WEB_CREATIVE_WEB;		
					if($is_html=='on'):
						$bannertype		=	WEB_CREATIVE_HTML;
					endif;
					if($is_flash=='on'):
						$bannertype		=	WEB_CREATIVE_SWF;
					endif;
				}
				else if($size_type=='mobile')
				{
					$storage_type	=	'web';
					$master_banner 	= 	'-2';
					$bannertype		=	MOBILE_IMAGE_CREATIVE;
					if($is_html=='on'):
						$bannertype		=	MOBILE_CREATIVE_HTML;
					endif;
				}
				else
				{
					$storage_type	=	'web';
					$bannertype		=	WEB_CREATIVE_WEB;
					if($is_html=='on'):
						$bannertype		=	WEB_CREATIVE_HTML;
					endif;
					if($is_flash=='on'):
						$bannertype		=	WEB_CREATIVE_SWF;
					endif;
				}
				
				if($is_html=='on')
				{
					$storage_type	=	'html';
					$content_type	=	'html';						
					$htmlcache		=	stripslashes(html_anchor_tag_replacer($_REQUEST['html_content']));
					$htmltemplate 	= 	html_entity_decode(stripslashes( str_ireplace('\n', '', $_REQUEST['html_content'])));
				}
				elseif($is_flash=='on')
				{
					$storage_type		=	'web';
					$content_type		=	'swf';				
					$filename			=	$this->post('tmp_flash_creative');
					$file_size			=	$this->post('tmp_flash_creative_size');
					$content			=	file_get_contents($this->post('tmp_flash_creative_url'));

					if ($this->swf_banner->phpAds_SWFCompressed($content))
					{
						$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
						$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
						$content =$this->swf_banner->phpAds_SWFCompress($buffer);
					}
					else
					{									
						$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
					}

					//Store width and height
					list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
					$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
					$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
					if(!empty($hardcodedLinks))
					{
						//Remove Hardcoded link from swf file
						 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
						 {
							// SWF's requiring player version 6+ which are already compressed should stay compressed
							if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
							{
								$compress = true;
							}
							elseif (isset($compress))
							{
								$compress = true;
							}
							else
							{
								$compress = false;
							}
							if (!isset($convert_links))
							{
								$convert_links = array();
							}
							$convert_links = array_keys($hardcodedLinks);
							list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
							if ($result != $content)
							{
								if (count($parameters) > 0)
								{
									// Prepare the parameters
									$parameters_complete = array();
									//Small hack to overwrite hard_coded values with destination url
									unset($overwrite_link);
									unset($overwrite_target);	
									$overwrite_link = array('0'=>$banner_url);

									$overwrite_target = array('0'=>$ban_target);	

										foreach ($parameters as $key => $val)
										{
											if (isset($overwrite_source) && $overwrite_source[$val] != '')
											{
												$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
											}
											$parameters_complete[$key] = array(
												'link' => $overwrite_link[0],
												'tar'  =>$overwrite_target[0],
											);
										}
										$parameters = array('swf' => $parameters_complete);
										
								}
								else
								{
									$parameters = '';
								}
								//When storing banner details into table,Don't forget to update parameters field
								$param = empty($parameters) ? null : serialize($parameters);
							}
						}	
					}
					else
					{
						$param = "N;";
					}
				
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_flash_creative'));
				}
				else
				{				
					$content_type		=	$this->post('tmp_web_creative_content_type');
					$filename			=	$this->post('tmp_web_creative');
					$file_size			=	$this->post('tmp_web_creative_size');
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
				}
			}
			
			$creative_data = array(
										"contenttype"		=>	$content_type,
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('creative_name')),
										"filename"			=>	$filename,
										"file_size"			=>	$file_size,
										"width"				=>	clean_data($creative_width),
										"height"			=>	clean_data($creative_height),
										"parameters" 		=> 	$param,
										"pluginversion" 	=>	$pluginVersion ,
										"bannertext"		=>	$bannertext,
										"htmltemplate"		=>	$htmltemplate,
										"htmlcache"			=>	$htmlcache,
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),							
										"dj_banner_type"	=>	clean_data($bannertype),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path,
										"statustext"		=>  $statustext
																			
									);
			if($admarket_status==1)						
			{
				$creative_data['dj_admarket_status']=$admarket_status; //DAC094 25/05/2018
			}						
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_id	=	$this->do_web_creative->add($creative_data,$blob_data,$agency_id,$campaign_id);
			
			
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Text Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			//$content['creative_ml']	  = 'Web Creative';
			//$content['creative_type'] = 'Text Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/			
			//$this->response($creative_id,200);
				
			if($is_flash=='on')
			{				
				$backup_image_data	=	array(
											"banner_id"		=>	clean_data($creative_id),
											"file_path"		=>	clean_data($this->post('tmp_backup_flash_creative')),
											"dj_file_size"	=>	$this->post('tmp_backup_flash_creative_size'),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_backup_flash_creative_content_type')),
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"	=>  $dj_image_path
										);
				$backup_imagedata	=	$this->do_web_creative->add_creative_dependiences($backup_image_data);
						
				$is_backup_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_backup_flash_creative'));
				
			}						
			
			if($creative_id)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
				}	
				
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);	
				}	
				
				$this->response( $error, 200);
			}
		}
	}
	
	
	
	
	public function notification_setting_mail($creative_data)
	{
		
		/*********Message Requirements**************/
		
		$client_id 		=	$this->user_authentication->client_id;
		$account_type	=	$this->user_authentication->account_type;
		$network_id	=	$this->do_message->fetch_admin_network_id();
		$message  = $this->default_configurations->get('message_type');		
		if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$user = $this->do_message->get_affiliate($affiliate_id); 
			
			}
			else{
				//$user = $this->do_message->get_profile($account_id); 
				$user = $this->do_message->get_profile('2'); 
			}
		$mail_type = "ADMIN_MESSAGE_SETTINGS";
		$acc_type='ADVERTISER';
		$campaign_details = 'select * from ox_campaigns where campaignid='.$creative_data['campaignid'];
		$campaign_info = $this->db->query($campaign_details);
		$camp = $campaign_info->result_array();
		$reciever= $this->do_campaign->fetch_reciever($creative_data['campaignid']);
		$message_data		=	array(
											'sender_id'		=>	'2',
											'receiver_id'	=>	$reciever['account_id'],
											'subject'		=>	'Creative created',
											'content'		=>	'A new creative '.$creative_data['description'].' with size '.$creative_data['width'].'*'.$creative_data['height'].' added for the campaign '.$camp[0]['campaignname'],
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	$acc_type,
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')
											);
											
											
		/*********Message Requirements**************/
		
	}
	
	/*
	* 
	* name: add_creative_editable_post
	* @param
	* @return:response array
	* 
	* In this methosd we will manage all the three SQL,WEB
	* and CREATIVE edit process
	*/
	public function add_creative_editable_post()
	{
		$creative_id 	= 	$this->post('pk');
		$value 			= 	$this->post('value');
		$name 			= 	$this->post('name');
		
		if($name)
		{
			$creative_data	=	array($name	=>	$value);
		}
		else
		{
			$creative_data	=	array('description'	=>	$value);
		}
		
		//Get clientid from library file
		$agency_id	=	$this->user_authentication->agency_id;

		//Call to edit a creative
		$creative_edit=$this->do_web_creative->edit($creative_data,$creative_id,$agency_id);
		
		if($creative_edit)
		{
			$success = 	array(
							'response' 	=> 	'ok',
							'msg'	 	=> 	'Creative edited sucessfully',					
						);
				
			$this->response($success,200); 
		}
		else
		{
			$error 	= 	array(
							'response' 	=> 'error',
							'msg'	 	=> 'Please try again'						
						);
			$this->response($error,200); 
		}
	}	
	public function url_check($url)
	{
		//$pattern = "/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i";
         $pattern = "/^(http(s?):\/\/)?(www\.)+[a-zA-Z0-9\.\-\_]+(\.[a-zA-Z]{2,3})+(\/[a-zA-Z0-9\_\-\s\.\/\?\%\#\&\=]*)?$/";
		if (preg_match($pattern, $url)) 
		  {
			return TRUE;
		  }
		else
		{
			$this->form_validation->set_message('url_check', 'Please Enter Valid url');
			return FALSE;
		}	
    }	
    public function url_creation($url)
	{
		
		if (!preg_match("~^(?:f|ht)tps?://~i", $url)) 
		{
           $site_url = "http://" . $url;
        }
        else
        {
		   $site_url = $url;	
		}	
		
		return $site_url;
    }


	function add_activity_log($module,$process,$banner_id=false,$campaign_id=FALSE)
	{
				/* Activity Log for Add/Edit/Delete site - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$adv_id =	$this->user_authentication->client_id;
				
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>$adv_id,
				"campaign_id"=>$campaign_id,
				"banner_id"=>$banner_id,
				);		
				$this->redis_library->logcount($account_id,$activity_log);
	}
	
}
