<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
 * All web Adblocks will be managed here 
 *
 * @package		ADX
 * @subpackage	Web Adblocks
 * @category	Controller
 * Author		Dinesh A
 * @link		http://www.djaxadexchange.com
*/


class Web_adblock extends REST_Controller
{
	protected $zone_type=3;
	public $min_floor_price;
	
	function __construct()
	{
		parent::__construct();	
		$this->load->library('redis_library');
		$this->load->model('do_web_adblock');
		$this->load->model('do_auto_link');			
		$this->min_floor_price =  $this->default_configurations->get('pub_min_floor_price');
	    $this->load->library('user_authentication');
	    $this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
	    $key=$this->input->get_post('api_key'); 
	    $this->load->model('do_message');
	    $this->load->model('do_networks');
		$this->load->library('notification');		
        if($this->user_authentication->is_valid_apikey($key)!='')
	    {
	   		$user_auth  = $this->user_authentication;
		    $this->response($user_auth->error, 200); 
	    }
	}
 	

		
	// api.v_1/web_adblock/add/format/json
	
    public function add_post(){
		
		//$this->form_validation->set_rules('site_name','Site Name', 'required|trim');
		$this->form_validation->set_rules('block_name','Ad Block Name', 'required|trim');
		
		if(clean_data($this->post('zone_type'))!='W_TEXT')
		{
			$this->form_validation->set_rules('block_size','Ad Block Size', 'required|trim');
			$this->form_validation->set_rules('width','Width', 'required|trim');
			$this->form_validation->set_rules('height','Height', 'required|trim');
		}
		
		//Sets the minimum floor price
		// $min_floor_price = $this->default_configurations->get('pub_min_floor_price');
		
		$this->form_validation->set_rules('floor_price','Floor Price', 'required|trim|greater_than_equal_to['.$this->min_floor_price.']');
		
		if($this->form_validation->run() === FALSE)
		{
			 $error_msg = $this->form_validation->error_array();			

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{			
			
			if($this->user_authentication->account_type=='TRAFFICKER')
			  {
				$account_id = $this->user_authentication->account_id;
			  }
			  else
			  {
				
				if(clean_data($this->post('account_id'))!='')
				{
					$account_id = clean_data($this->post('account_id'));  
				}
				else
				{
					$account_id = clean_data($this->post('acc_id'));
				}
			  }
						
			
			$agency_id = $user_auth->agency_id;
			#$account_id=$this->post('account_id');
			if($account_id)
			{
				/* Fetch Affiliateid */	
				
				$affiliate_id=$this->do_web_adblock->fetch_affiliateid($account_id);
																
				$this->db->trans_start();
				
				//delivery number
				$delivery = delivery_value(clean_data($this->post('zone_type')));
				
				$add_web_adblockObj=array(							
											"zonename"  =>	clean_data($this->post('block_name')),
											"affiliateid"=>	$affiliate_id,
											"zonetype"	=>	$this->zone_type,
											"delivery"	=>  $delivery,
											"dj_zone_type"	=>	clean_data($this->post('zone_type')),
											"width" 	=>	clean_data($this->post('width')),
											"height"	=>  clean_data($this->post('height')),
											"dj_floor_price"		=>	clean_data($this->post('floor_price')),
											"dj_passback_tag" =>stripslashes($this->post('passback_tag')),
											"dj_added_date"=>date("Y-m-d H:i:s"),
									);		
								
													
													
				$zone_id=$this->do_web_adblock->add($add_web_adblockObj);	
				
				if(clean_data($this->post('site_name'))=='')
				{
					$add_web_adblockAssoc = array("site_id"=> clean_data($this->post('site_id')),
											  "zone_id"=> $zone_id,	
										);
				}
				else
				{									
				$add_web_adblockAssoc = array("site_id"=> clean_data($this->post('site_name')),
											  "zone_id"=> $zone_id,	
										);
				}						
										
				
				$this->do_web_adblock->addAssoc($add_web_adblockAssoc);
				
				//Get the agency id
				#$agency_id = $this->post('agency_id');
				
				//Auto Linking ofZones
				$this->do_auto_link->link_ads($zone_id,$agency_id);
				
				$this->db->trans_complete();
				
				$success = array(
								'response' => 'ok',
								'msg'	 => 'Web Ad blocks are added successfully!..'
				);
			
							
				$this->response($success, 200);
		
			}else{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Not an valid accountid!..'
				);	
			}
		}

	}
	
	function zonesizelist_get()
	 {
					
		    $zone_sizes=$this->do_web_adblock->list_zonesizes();		  
		   
		   if($zone_sizes)
			{
				$this->response($zone_sizes, 200); // 200 being the HTTP response code
			}

			else
			{
				$this->response(array('error' => 'Zone Sizes could not be found'), 404);
			}
		   
	 }
	 
	/**
       * 
       * name : fetch_get()
       * 
       * @params : account_id and zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	 function fetch_get()
	 {
					
		   #$account_id = $this->get('account_id');
		   //$user_auth  = $this->user_authentication;
		   //$account_id = $user_auth->account_id;
		   
			  if($this->user_authentication->account_type=='TRAFFICKER')
			  {
				$account_id = $this->user_authentication->account_id;
			  }
			  else
			  {
				$account_id = $this->get('account_id');
			  }
 
			$zone_id	   = $this->get('zone_id');	
			$site_id	  = $this->get('site_id');
			$ad_type='';
			$zone_type='';
			if(isset($_GET['ad_type']))
			{
				$ad_type=$this->get('ad_type');
			}
			if(isset($_GET['zone_type']))
			{
				$zone_type=$this->get('zone_type');
			}
			
			//if($account_id){
				
				$site_list = $this->do_web_adblock->fetch($account_id,$site_id,$zone_id,$zone_type,$ad_type);
							
				$this->response($site_list);
				
			//}
	}
	
	/**
       * 
       * name : update_put()
       * 
       * @params : zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$agency_id	= $this->user_authentication->agency_id;
		$zoneid 	= clean_data($this->post('zone_id'));
		
		if($zoneid)
		{
			$this->form_validation->set_rules('block_name','Ad Block Name', 'required|trim');
		
			if($this->post('zone_type')!='W_TEXT')
			{
				$this->form_validation->set_rules('block_size','Ad Block Size', 'required|trim');
				$this->form_validation->set_rules('width','Width', 'required|trim');
				$this->form_validation->set_rules('height','Height', 'required|trim');
			}
			$this->form_validation->set_rules('floor_price','Floor Price', 'required|trim||greater_than_equal_to['.$this->min_floor_price.']');
			
			if($this->form_validation->run() ===FALSE){
			
				$error_msg = $this->form_validation->error_array();
				$error = array(
									'response' => 'error',
									'msg' =>  $error_msg
								);

				 $this->response( $error, 200);
			}else{
			
				$this->do_web_adblock->update(clean_data($this->post()),$agency_id);
				
				$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/web_ad_blocks'),
								'msg'	 => 'Web Ad blocks are updated successfully!..'
				);
			
							
				$this->response($success, 200);
			}
		}else{
			$this->response(array('error' => 'Zone is not available for this id'), 404);	
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{
		
		$zone_id = clean_data($this->get('zone_id'));	
		$adcode_name=array(); 
		//$this->response($zone_id,'200');
		if($zone_id)
		{  
			$zoneadb_id	=	explode(',',$zone_id);
			if(is_array($zoneadb_id))
			{ 
				foreach($zoneadb_id as $zone_id)
				{	
					/*Adcode  Details */
					$adcode_res=$this->do_web_adblock->get_info($zone_id);
					$adcode_name[]= $adcode_res[0]['zonename'];					
					/*End*/
					
					/* Activity Log for Delete adblock - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADBLOCK,ADB_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(ADBLOCK,DELETE,$zone_id);
					}
					/* Activity Log for Delete adblock - End*/				
			
					$zone_ids =	$this->do_web_adblock->delete($zone_id);				
				}
			}
			else
			{ 
				/* Activity Log for Delete adblock - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADBLOCK,ADB_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(ADBLOCK,DELETE,$zone_id);
					}
					/* Activity Log for Delete adblock - End*/		
					
					/*Adcode  Details */
					$adcode_res=$this->do_web_adblock->get_info($zone_id);
					$adcode_name= $adcode_res[0]['zonename'];					
					/*End*/
				
				$zone_id = $this->do_web_adblock->delete($zone_id);				
			}
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Ad block has been deleted'
							 );
			 			 
			$message  = $this->default_configurations->get('message_type');	
			 
			$account_id = $this->user_authentication->account_id;
			
			$account_type	=	$this->user_authentication->account_type;
			
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
				 
			$arr_zonename ='';
						
			foreach($zone_list as $values){
										
				$arr_zonename[] =  $values['zonename'];
													
			}
			$mail_content=array("zone_list"	=> $arr_zonename);	
				
			/***************************************/
					
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
						
				$user = $this->do_message->get_profile($admin_id);
				
				$mail_type = "ADBLOCK_DELETE";
				$acc_type='TRAFFICKER';
				
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "ADBLOCK_DELETE",
					'string'		=> 'adb_del',
					'column_name'	=> 'adblock'
					);
				$message_data		=	array(
					'sender_id'		=>	$admin_id,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Adblock',
					'content'		=> 	'Adblock deleted successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"adcodes",	
					'status'		=>	'1',
					'network_id'	=>	$network_id,									
					'date'			=>	date('Y-m-d H:i:s')
					);
					
													
				$user_email	=	$reciever['email'];
				$user_name  =	$reciever['name'];
				$from 		= 	$admin_email;
				$to  		= 	$user_email;		
										
				/*$mail_content=array(
						"subject" 	   => "Adblock deleted",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,
						"zone_list"	=> $arr_zonename
						 
					);*/
					
				$attachement='';
					
				/*$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content); */
					$notification_value ='adb_del';
					$notification_msg = $this->do_message->get_notification_msg($notification_value);   
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$click_directADS	= 	$this->config->item('click_directADS');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
										
					if($count>0)
					{	
					$adcode_name=(count($adcode_name)>0)?implode(",",$adcode_name):$adcode_name;
					$msg = str_replace("{{Product_name}}",'<a href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{adcode_name}}",$adcode_name,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a href="'.base_url().'">'.$click_directADS.'</a>' ,$msg);		  			
					}  
					else
					{
						$mail_content=$notification_content;
					}	
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);			
					
			}	
					
			/***************************************/
			
			$this->response($success, 200);
						
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Zone id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : generate_adtags_post()
       * 
       * Generates the Ad tags with custom settings
       * 
       * @return the generated response
    */
	
	
	function generate_adtags_post()
	{
		
		$zone_id = clean_data($this->post('zoneid'));
	
		
		if($zone_id)
		{
			
			$webadblock_tag = $this->generate_webadblock_tag(clean_data($this->post()));
			
			$success = array('response'=>'ok',
							 'msg'=>$webadblock_tag
						);	 	
			
			
			$this->response($success);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Zone id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	
	private function generate_webadblock_tag($values =FALSE)
	{
		if($values !='')
		{
			$site_url 		= 	str_replace("index.php","",site_url());		
		
			if($values['adbtype']!='')
			{
				/*if($values['adbtype']=='direct')
				{
					$ran2 = 'a'.substr(md5(uniqid('', 1)), 0, 7); 
					unset($values['api_key']);
					unset($values['adbtype']);			
				
					$encoded_string =	http_build_query($values);
					$path = '<a href="'.$site_url.$this->config->item("ads_delivery_path").'/ck.php?n='.$ran2.'&amp;cb=INSERT_RANDOM_NUMBER_HERE" target="_blank"><img src="'.$site_url.$this->config->item("ads_delivery_path").'/avw.php?'.$encoded_string.'&amp;cb=INSERT_RANDOM_NUMBER_HERE&amp;n='.$ran2.'" border="0" alt="" /></a>';				
					
					return $path;
				}
				else
				{*/
					$path 			= 	$site_url."".$this->config->item("ads_delivery_path")."/".$values['adbtype'].".js?";
				//}
			}
			
			unset($values['api_key']);
			unset($values['adbtype']);			
				
			$encoded_string =	http_build_query($values);
			
			$code	=	'<script type="text/javascript" src="'.$path.''.$encoded_string.'"></script>';
							
			return $code;				
		}else{
			return FALSE;	
		}	
	}
	
	function activity_log($module,$process,$zone_id=false)
	{
				/* Activity Log for Add/Edit/Delete adblock - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$publisher_id =	$this->user_authentication->affiliate_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>$publisher_id,
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>$zone_id);				
					
				$this->redis_library->logcount($account_id,$activity_log);  
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete adblock - End*/			
		
	}
	
}
