<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Video creatives
 *
 * All Video creative will be managed here 
 *
 * @package		ADX
 * @subpackage	Video creatives
 * @category	Controller
 * @author		Suganthi s
 * @link		http://www.djaxadserver.com
*/

class Video_creative extends REST_Controller
{
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('do_video_creative');
		$this->load->model('do_auto_link');
		$this->load->model('do_creative');
		$this->load->library('user_authentication');
		$this->load->model('do_message');
        $this->load->library('notification');
	    $this->load->model('do_campaign'); 
		$key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
        $this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	
 	/*
	 * 
	 * name: add_video_inline_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	public function add_video_inline_creative_post()
	{
		$delivery	=	clean_data($this->post('inline_delivery_method'));		
		
		$this->form_validation->set_rules('video_inline_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('inline_delivery_method', 'Delivery Type', 'required|trim');		
		$this->form_validation->set_rules('inline_url', 'Destination URL', 'required|trim|url');
		$campaign = clean_data($this->post('_vin_campaign_id'));

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_vin_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vin_campaign_id'));
		}
		
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('inline_rtmpurl', 'RTMP URL', 'required|trim|url');
			$this->form_validation->set_rules('inline_rtmp_filename', 'RTMP File Name', 'required|trim');
			$this->form_validation->set_rules('inline_rtmp_duration', 'RTMP video duration', 'required|trim');
		}
		else if($delivery=='vast')
		{
			if(clean_data($this->post('is_vast_upload'))=='on')
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_INLINE;			
			$storagetype	=	'html';
			$width			=	'-3';
			$height			=	'-3';
			$ext_bannertype = 	"bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_vin_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_vin_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			//print_r($_post);
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}						
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_inline_creative')!='')
				{	
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	clean_data($this->post('tmp_video_inline_creative'));
						$output 			= 	clean_data($this->post('tmp_video_inline_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_inline_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_inline_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_inline_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_inline_creative')));
							
					$video_name			=	clean_data($this->post('tmp_video_inline_creative'));
					if(clean_data($this->post('tmp_video_inline_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_inline_creative_content_type'));
					}
					
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');					
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_inline_creative'));
				}
			}
			elseif($delivery=='streaming')
			{	
				$video_name			=	'';				
				$video_duration		=	clean_data($this->post('inline_rtmp_duration'));
				$rtmp_url			=	clean_data($this->post('inline_rtmpurl'));
				$rtmp_filename		=	clean_data($this->post('inline_rtmp_filename'));
				if(strpos($rtmp_filename, '.') != false)
				{
					$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
				}
				else
				{
					$type			=	'flv';
				}
				$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
				$video_type			=	'video/x-'.$type;
				
			}
			elseif($delivery=='vast')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
					
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
			}
			
			$skip_duration	=	0;
			$skippable		=	clean_data($this->post('skippable'));
			if($skippable==1)
			{
				$skip_duration	=	clean_data($this->post('skip_duration'));
			}			
			
			if($this->post('inline_companion_size')!='')
			{
				$size 				= 	explode("x",clean_data($this->post('inline_companion_size')));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				if(clean_data($this->post('tmp_inline_companion_creative'))!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_inline_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('inline_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id),
												"dj_is_direct" 		=> 	clean_data($dj_is_direct),
												"dj_image_path"		=>  $dj_image_path,
												"dj_admarket_status" =>  $adma_id
											);
											
						$companion_id		=	$this->do_video_creative->add_video($comp_creative_data);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_inline_companion_creative')));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	clean_data($this->post('vast_companion_id'));
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			/* Added on May10 - DAC020*/
			$imp_track_url				=	$this->post('imp_track_url');
			$thirdparty_click_url		=	$this->post('thirdparty_click_url');
			$thirdparty_custom_url		=	$this->post('thirdparty_custom_url');
			$companion_click_track_url	=	$this->post('companion_track_url');
			$expanded_width				=	$this->post('expanded_width');
			$expanded_height			=	$this->post('expanded_height');			
			/* End */
				
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	clean_data($this->post('inline_url')),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_wrapper_url' 				=> 	$vast_tag_url,
									'vast_version' 					=> 	$vast_tag_version,
									'vast_overlay_wrapper' 			=> 	'',
									'vast_overlay_version' 			=> 	0,
									'vast_skippable' 				=> 	$skippable,
									'vast_video_skip_duration'		=> 	$skip_duration,
									'thirdPartyImpressionUrl'       =>  $imp_track_url,
									'vast_thirdparty_clicktracking' =>  $thirdparty_click_url,
									'vast_thirdparty_clickcustom'   =>  $thirdparty_custom_url,
									'vast_thirdparty_companion_clicktracking' 	=> 	$companion_click_track_url,
									'vast_thirdparty_companion_expandedwidth' 	=> 	$expanded_width,
									'vast_thirdparty_companion_expandedheight' 	=> 	$expanded_height 
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(	
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('inline_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									"dj_admarket_status" =>  $adma_id
								);
			//Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_wrapper_url" 				=> 	$vast_tag_url,
										"vast_version" 					=> 	$vast_tag_version,
										"vast_overlay_wrapper" 			=> 	"",
										"vast_overlay_version" 			=> 	0,
										"vast_skippable" 				=> 	$skippable,
										"vast_video_skip_duration"		=> 	$skip_duration,
										"thirdPartyImpressionUrl"       =>  $imp_track_url,
										"vast_thirdparty_clicktracking" =>  $thirdparty_click_url,
										"vast_thirdparty_clickcustom"   =>  $thirdparty_custom_url,
										"vast_thirdparty_companion_clicktracking" 	=> 	$companion_click_track_url,
										"vast_thirdparty_companion_expandedwidth" 	=> 	$expanded_width,
										"vast_thirdparty_companion_expandedheight" 	=> 	$expanded_height	
									);
									
				$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
				if($vast_add)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						
						if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
						
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	 	=> 	$redirect_url,
										);						
					}
					else
					{
						if($adma_id=='1')
						{
							//$redirect_url=site_url('admin/admarket/creatives/');
							$redirect_url=site_url('admin/creatives/creative/admarket/');						
						}
						else
						{
							$redirect_url=site_url('admin/creatives/');
						}
						
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	 	=> 	$redirect_url,
										);
					}	
					
						
					/***creative change for message/mail notification*****/
					
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video Inline creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video Inline Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video Inline Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					
					/***creative change for message/mail notification*****/	
				
					
					$this->response( $success, 200);			
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
						
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);					
					}
					else
					{
						if($adma_id=='1')
						{
							//$redirect_url=site_url('admin/admarket/creatives/');
							$redirect_url=site_url('admin/creatives/creative/admarket/');						
						}
						else
						{
							$redirect_url=site_url('admin/creatives/');
						}
						
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);	
					}	
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					
					if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}				
					
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
						{
							//$redirect_url=site_url('admin/admarket/creatives/');
							$redirect_url=site_url('admin/creatives/creative/admarket/');						
						}
						else
						{
							$redirect_url=site_url('admin/creatives/');
						}	
						
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				
				$this->response( $error, 200);
			}
			
		}
	}
	
	
	/*
	 * 
	 * name: add_video_real_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all REAL VIDEO CREATIVE add process	   
	 */
	
	public function add_video_real_creative_post()
	{
		$delivery	=	clean_data($this->post('real_delivery_method'));		
		
		$this->form_validation->set_rules('video_real_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('real_url', 'Destination URL', 'required|trim|url');
		
		$campaign = clean_data($this->post('_vre_campaign_id'));
		
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_vre_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vre_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		
		//test1
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_REAL;			
			$storagetype	=	'html';
			$width			=	'-5';
			$height			=	'-5';
			$ext_bannertype = 	"bannerTypeHtml:vastRealBannerTypeHtml:vastRealHtml";
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_vre_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_vre_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			//print_r($_post);
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}						
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			
			
				if(clean_data($this->post('tmp_video_real_creative'))!='')
				{	
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	clean_data($this->post('tmp_video_real_creative'));
						$output 			= 	clean_data($this->post('tmp_video_real_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_real_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_real_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_real_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_real_creative'));
							
					$video_name			=	clean_data($this->post('tmp_video_real_creative'));
					if(clean_data($this->post('tmp_video_real_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_real_creative_content_type'));
					}
					
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_real_creative');
					
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_real_creative'));					
					
				}
			
			$creative_data 	= array(	
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_real_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('real_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path
								);
			//Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('real_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL	
									);
									
				$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
				
				if($vast_add)
				{
					
					
					
						
					/***creative change for message/mail notification*****/
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video Real creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video Real Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video Real Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					/***creative change for message/mail notification*****/	
				
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
										);						
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
										);
					}		
					
					$this->response( $success, 200);			
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
					}	
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);	
				}	
				
				$this->response( $error, 200);
			}
			
		}
	}
	
	
	/* TEST CODE End in the real */
	
	
	/* this Small code start */
	
	
	/*
	 * 
	 * name: add_video_inline_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	public function add_video_small_creative_post()
	{
			
		
		$this->form_validation->set_rules('video_small_creative_name','Creative name', 'required|trim');	
		$this->form_validation->set_rules('small_url', 'Destination URL', 'required|trim|url');
		
		
		$campaign = clean_data($this->post('_vsm_campaign_id'));
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_vsm_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vsm_campaign_id'));
		}
		
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_SMALL;			
			$storagetype	=	'html';
			$width			=	'-6';
			$height			=	'-6';
			$ext_bannertype = 	"bannerTypeHtml:vastSmallBannerTypeHtml:vastSmallHtml";
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";	
			$trusted_status='';
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_vsm_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_vsm_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}						
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			
			
			
				if(clean_data($this->post('tmp_video_small_creative'))!='')
				{	
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	clean_data($this->post('tmp_video_small_creative'));
						$output 			= 	clean_data($this->post('tmp_video_small_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_small_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_small_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_small_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_small_creative')));
							
					$video_name			=	clean_data($this->post('tmp_video_small_creative'));
					if(clean_data($this->post('tmp_video_small_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_small_creative_content_type'));
					}
					
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_small_creative');
					
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_small_creative'));					
					
				}
			
			
			
			
			
			
			
			$creative_data 	= array(	
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_small_creative_name')),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('small_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	'',
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path
								);
			//Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);
			
			/* video added to additional banenrs table*/
			$creative_data_video 	= array(	
									"content_type"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"banner_id" 		=> 	$creative_id,
									"ban_description"	=>	clean_data($this->post('video_small_creative_name')),
									"file_path"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"display_type"		=>	"SMALLVIDEO",
									"link_url"			=>	clean_data($this->post('small_url')),
									"status"			=>	clean_data($status),
									"created_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
								
			$this->do_video_creative->add_small_image($creative_data_video);		

			/* End - Video creation */
								
			if(clean_data($this->post('tmp_small_image_creative'))!='')
				{
					
					
					 $file_name			=	clean_data($this->post('tmp_small_image_creative'));
					 $creative_type		=	clean_data($this->post('tmp_small_image_creative_content_type'));
					$width			=	'300';
					$height			=	'250';
					//On sucess move the web creative from tmp location to original location
					 $is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_small_image_creative')));		
					
										
				}
				
				$creative_image_data 	= array(
									"banner_id" 		=> 	$creative_id,
									"file_path"			=>	$file_name,
									"width"				=>	$width,
									"height"			=>	$height,
									"content_type"		=>  $creative_type,
									"dj_image_path"		=>  $dj_image_path	
									);
				
				
			
			$creative_image	=	$this->do_video_creative->add_small_image($creative_image_data);		
			
			
		
//djax_additional_banners
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL	
									);
									
				$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
				
					
					/***creative change for message/mail notification*****/
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video Small creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video Small Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video Small Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					/***creative change for message/mail notification*****/	
				
				
				if($vast_add)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);						
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}		
					
					$this->response( $success, 200);			
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}	
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				
				$this->response( $error, 200);
			}
			
		}
	}
	
	
		
	
	/* this Small code End */
	
	/* this box model start  */
	
	/*
	 * 
	 * name: add_video_box_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all box VIDEO CREATIVE add process	 
	 */
	
	public function add_video_box_creative_post()
	{
				
		
		$this->form_validation->set_rules('video_box_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('box_url', 'Destination URL', 'required|trim|url');
		
		$campaign = clean_data($this->post('_vbox_campaign_id'));
		
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_vbox_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vbox_campaign_id'));
		}
		
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		
		//test1
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_BOX;			
			$storagetype	=	'html';
			$width			=	'-7';
			$height			=	'-7';
			$ext_bannertype = 	"bannerTypeHtml:vastRealBannerTypeHtml:vastRealHtml";
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_vbox_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_vbox_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}						
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			
			
				if(clean_data($this->post('tmp_video_box_creative'))!='')
				{	
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	clean_data($this->post('tmp_video_box_creative'));
						$output 			= 	clean_data($this->post('tmp_video_box_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_box_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_box_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_box_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_box_creative')));
							
					$video_name			=	clean_data($this->post('tmp_video_box_creative'));
					if(clean_data($this->post('tmp_video_box_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_box_creative_content_type'));
					}
					
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_box_creative');					
					
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_box_creative'));
				}
			
			$creative_data 	= array(	
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_box_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('box_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path
								);
			//Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('box_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL	
									);
									
				$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
				
					/***creative change for message/mail notification*****/
					
					
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video Box creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video Box Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video Box Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					
					/***creative change for message/mail notification*****/	
				
				if($vast_add)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
										);						
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
										);
					}		
					
					$this->response( $success, 200);			
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
					}	
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);	
				}	
				
				$this->response( $error, 200);
			}
			
		}
	}
	
	
	/* TEST BOX CODE End in the real */
	
	/* this box modl end  */
	
	
	/* this head model start  */
	
	/*
	 * 
	 * name: add_video_head_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all head VIDEO CREATIVE add process	 
	 */
	
	public function add_video_head_creative_post()
	{
				
		
		$this->form_validation->set_rules('video_head_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('head_url', 'Destination URL', 'required|trim|url');
		
		$campaign = clean_data($this->post('_vhe_campaign_id'));
		
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_vhe_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vhe_campaign_id'));
		}
		
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		
		//test1
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_HEAD;			
			$storagetype	=	'html';
			$width			=	'-8';
			$height			=	'-8';
			$ext_bannertype = 	"bannerTypeHtml:vastRealBannerTypeHtml:vastRealHtml";
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	($this->post('_vhe_type')=='housead')?$this->user_authentication->default_advertiser_account_id:(($this->post('adv_id'))?clean_data($this->post('adv_id')):clean_data($this->post('_vhe_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}						
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			
			
				if(clean_data($this->post('tmp_video_head_creative'))!='')
				{	
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	clean_data($this->post('tmp_video_head_creative'));
						$output 			= 	clean_data($this->post('tmp_video_head_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_head_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_head_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_head_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_head_creative')));
							
					$video_name			=	clean_data($this->post('tmp_video_head_creative'));
					if(clean_data($this->post('tmp_video_head_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_head_creative_content_type'));
					}
					
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_head_creative');					
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_head_creative'));
				}
			
			$creative_data 	= array(	
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_head_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('head_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path
								);
			//Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('head_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL	
									);
									
				$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
					/***creative change for message/mail notification*****/
					
					
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video head creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video head Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video head Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id); 
					
					/***creative change for message/mail notification*****/	
				
				
				if($vast_add)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
										);						
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
										);
					}		
					
					$this->response( $success, 200);			
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
					}	
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);	
				}	
				
				$this->response( $error, 200);
			}
			
		}
	}
	
	
	/* TEST HEAD CODE End in the real */
	
	/* this head modl end  */
	
	
	/*
	 * 
	 * name: add_video_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	public function add_video_creative_post()
	{	
		$delivery	=	clean_data($this->post('special_delivery_method'));	

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
			
		$this->form_validation->set_rules('video_creative_name','Creative name', 'required|trim');	
		$this->form_validation->set_rules('video_url', 'Destination URL', 'required|trim|url');
				
		$campaign = clean_data($this->post('_vid_campaign_id'));
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_vid_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vid_campaign_id'));
		}
		
		if($delivery=='on')
		{
			if(clean_data($this->post('is_vast_upload'))=='on')
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$storagetype	=	'html';
			
			$vid_type		=	clean_data($this->post('video_type'));
			
			if($vid_type=='real')
			{
				$bannertype		=	VIDEO_CREATIVE_REAL;
				$width			=	'-5';
				$height			=	'-5';
			}
			elseif($vid_type=='small')
			{
				$bannertype		=	VIDEO_CREATIVE_SMALL;
				$width			=	'-6';
				$height			=	'-6';
			}
			elseif($vid_type=='box')
			{
				$bannertype		=	VIDEO_CREATIVE_BOX;
				$width			=	'-7';
				$height			=	'-7';
			}
			elseif($vid_type=='head')
			{
				$bannertype		=	VIDEO_CREATIVE_HEAD;		
				$width			=	'-8';
				$height			=	'-8';
			}
			else
			{
				$bannertype		=	VIDEO_CREATIVE_REAL;
				$width			=	'-5';
				$height			=	'-5';
			}
						
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
						
			//Get account/agency_id from library file
		   
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_vid_type')=='housead'))?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_vsm_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type	=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}						
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
				$dj_is_direct		=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date	=	'';
			}
			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';
			$video_name			=	'';
			$video_duration		=	'30';
			$video_type			=	'';
			$outgoing_filename	=	'';
			$file_size			=	0;
			
			if($delivery=='on')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
				$vid_delivery		=	'vast';
			}
			else
			{
				if(clean_data($this->post('tmp_video_creative'))!='')
				{	
					/*if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	$this->post('tmp_video_creative');
						$output 			= 	$this->post('tmp_video_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_creative_raw_name');

						$ext				=	$this->post('tmp_video_creative_file_ext');

						$input_with_path  	= 	$upload_path.$input;
						$output_with_path 	= 	$upload_path.$output;
						
						$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
					}
					else 
					{
						$video_duration		=	'30';	
					}
					$outgoing_filename	=	$dj_image_path.$this->post('tmp_video_creative');
					*/
					
					$video_duration		=	'30';
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_creative')));
							
					$video_name			=	clean_data($this->post('tmp_video_creative'));
					if(clean_data($this->post('tmp_video_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_creative_content_type'));
					}	
					$outgoing_filename	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_creative'));	
					$file_size			=	clean_data($this->post('tmp_video_creative_size'));	
					
					$vid_delivery		=	'progressive';		
				}
			}
				
			$creative_data 	= array(	
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_creative_name')),
									"filename"			=>	clean_data($video_name),
									"file_size"			=>	clean_data($file_size),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('video_url')),
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									"dj_admarket_status" =>  $adma_id
								);
			//Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);
			
			$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$vid_delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	0,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('video_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_wrapper_url" 				=> 	$vast_tag_url,
										"vast_version" 					=> 	$vast_tag_version,
										"vast_overlay_wrapper" 			=> 	"",
										"vast_overlay_version" 			=> 	0
									);
									
			$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
			if($vid_type=='small')
			{
				/* video added to additional banenrs table*/
				$creative_data_video = 	array(	
												"content_type"		=>	clean_data(str_replace('video/x-','',$video_type)),
												"banner_id" 		=> 	$creative_id,
												"ban_description"	=>	clean_data($this->post('video_creative_name')),
												"file_path"			=>	clean_data($video_name),
												"width"				=>	clean_data($width),
												"height"			=>	clean_data($height),
												"display_type"		=>	"SMALLVIDEO",
												"link_url"			=>	clean_data($this->post('video_url')),
												"status"			=>	clean_data($status),
												"created_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path,
												"dj_admarket_status" =>  $adma_id
											);
									
				$this->do_video_creative->add_small_image($creative_data_video);		

				/* End - Video creation */
									
				if($this->post('tmp_small_image_creative')!='')
				{					
					$file_name		=	clean_data($this->post('tmp_small_image_creative'));
					$creative_type	=	clean_data($this->post('tmp_small_image_creative_content_type'));
					$width			=	'300';
					$height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_small_image_creative')));		
					
					$creative_image_data 	= array(
												"banner_id" 		=> 	$creative_id,
												"file_path"			=>	$file_name,
												"width"				=>	$width,
												"height"			=>	$height,
												"content_type"		=>  $creative_type,
												"dj_image_path"		=>  $dj_image_path,
												"dj_admarket_status" =>  $adma_id	
											);
				
					$creative_image	=	$this->do_video_creative->add_small_image($creative_image_data);
				}		
				
			}	
			//djax_additional_banners
			
			if($creative_id)
			{	
					/***creative change for message/mail notification*****/
					
					
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					
					/***creative change for message/mail notification*****/	
				
								
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}	
				
				$this->response( $success, 200);	
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				
				$this->response( $error, 200);
			}			
		}
	}	
		
	/*
	* 
	* name: add_video_overlay_creative
	* @param
	* @return:response array
	* 
	* In this methosd we will manage all OVERLAY VIDEO CREATIVE add process	 
	*/
	
	public function add_video_overlay_creative_post()
	{
		$ovl_type		=	clean_data($this->post('overlay_type'));
		$ovl_action		=	clean_data($this->post('click_action'));
		$ovl_delivery	=	clean_data($this->post('overlay_delivery_method'));

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		$this->form_validation->set_rules('video_overlay_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('overlay_type', 'Overlay Type', 'required|trim');		
		$this->form_validation->set_rules('click_action', 'Overlay Type', 'required|trim');		
		$this->form_validation->set_rules('overlay_delivery_method', 'Delivery Type', 'required|trim');
		
		$campaign = clean_data($this->post('_vol_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('overlay_campaign','Campaign', 'required|trim');
			$campaign_id	= clean_data($this->post('overlay_campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_vol_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vol_campaign_id'));
		}
			
		if($ovl_type=='text_overlay')
		{
			$this->form_validation->set_rules('txt_title', 'Text Overlay Title', 'required|trim');		
			$this->form_validation->set_rules('txt_action', 'Text Overlay action', 'trim|url');		
		}
		else if($ovl_type=='vast_overlay')
		{
			if(clean_data($this->post('is_vast_upload'))=='on')
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
		
		if($ovl_action=='click_to_video')
		{	
			$this->form_validation->set_rules('overlay_click_url', 'Overlay Click URL', 'required|trim|url');
		}
		else
		{
			$this->form_validation->set_rules('overlay_url', 'Destination URL', 'required|trim|url');
		}
		
		if($ovl_delivery=='streaming')
		{
			$this->form_validation->set_rules('overlay_rtmpurl', 'RTMP URL', 'required|trim|url');
			$this->form_validation->set_rules('overlay_rtmp_filename', 'RTMP File Name', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_duration', 'RTMP video duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			/* Static values */
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_OVERLAY;			
			$storagetype	=	'html';
			$width			=	'-2';
			$height			=	'-2';
			$ext_bannertype = 	"bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml";
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			
			//Get account/clientid from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_vol_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_vol_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}	
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';			
			/* Overlay Type - Image Overlay */
			if($ovl_type=='image_overlay')
			{
				if($this->post('tmp_overlay_image_creative')!='')
				{
					$file_name			=	clean_data($this->post('tmp_overlay_image_creative'));
					$creative_type		=	clean_data($this->post('tmp_overlay_image_creative_content_type'));
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_overlay_image_creative')));
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - SWF Overlay */
			elseif($ovl_type=='swf_overlay')
			{				
				if($this->post('tmp_overlay_swf_creative')!='')
				{
					$file_name			=	clean_data($this->post('tmp_overlay_swf_creative'));
					$creative_type		=	'swf';
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_overlay_swf_creative')));
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - Text Overlay */
			elseif($ovl_type=='text_overlay')
			{
				$file_name			=	'';
				$creative_type		=	'txt';
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	clean_data($this->post('txt_title'));
				$txt_description	=	clean_data($this->post('txt_description'));
				$txt_action			=	clean_data($this->post('txt_action'));
			}
			elseif($ovl_type=='vast_overlay')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
					$ovl_type = 'wrapper_overlay';
					
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
				$file_name			=	'';
				$creative_type		=	'xml';
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			
			$skip_duration	=	0;
			$skippable		=	clean_data($this->post('skippable'));
			if($skippable==1)
			{
				$skip_duration	=	clean_data($this->post('skip_duration'));
			}
					
			/* Overlay Action - Click to Page */
			if($ovl_action=='click_to_page')
			{
				$destination_url	=	clean_data($this->post('overlay_url'));
				$htmlcache			=	'<a href="{clickurl}" target="{target}"></a>';
				$ovl_delivery		=	NULL;
				$click_url			=	NULL;
				$video_type			=	NULL;
				$video_duration		=	NULL;
				$outgoing_filename	=	NULL;
			}
			/* Overlay Action - Click to Video */
			elseif($ovl_action=='click_to_video')
			{	
				/* Overlay Delivery type - Progressive */			
				if($ovl_delivery=='progressive')
				{	
					if(clean_data($this->post('tmp_video_overlay_creative'))!='')
					{
						if($this->commandExists("ffmpeg")>0) 
						{
							##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
							$input  			= 	clean_data($this->post('tmp_video_overlay_creative'));
							$output 			= 	clean_data($this->post('tmp_video_overlay_creative_raw_name')).'.flv';
							
							$upload_path		=	$this->config->item('creative_path');
							$raw_name			=	clean_data($this->post('tmp_video_overlay_creative_raw_name'));

							$ext				=	clean_data($this->post('tmp_video_overlay_creative_file_ext'));

							$input_with_path  	= 	clean_data($upload_path.$this->post('tmp_video_overlay_creative'));
							$output_with_path 	= 	$upload_path.$output;
							
							#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
							$video_duration		=	'30';	
						}
						else 
						{
							$video_duration		=	'30';	
						}
						
						$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_overlay_creative')));
						
						if(clean_data($this->post('tmp_video_overlay_creative_content_type'))=='video/mp4')
						{
							$video_type		=	'video/x-mp4';
						}
						else
						{
							$video_type		=	clean_data($this->post('tmp_video_overlay_creative_content_type'));
						}
						$video_duration		=	'30';	
						//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_overlay_creative');					
						$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_overlay_creative'));
					}
				}
				/* Overlay Delivery type - Streaming */			
				elseif($ovl_delivery=='streaming')
				{	
					$video_duration		=	clean_data($this->post('overlay_rtmp_duration'));
					$rtmp_url			=	clean_data($this->post('overlay_rtmpurl'));
					$rtmp_filename		=	clean_data($this->post('overlay_rtmp_filename'));
					if(strpos($rtmp_filename, '.') != false)
					{
						$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
					}
					else
					{
						$type			=	'flv';
					}
					$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
					$video_type			=	'video/x-'.$type;
				}
				$destination_url	=	'';
				$htmlcache			=	'';
				$click_url			=	clean_data($this->post('overlay_click_url'));
			}
			
			/* Overlay Companion */			
			if($this->post('overlay_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('overlay_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				
				/* Overlay Companion - Upload */			
				if($this->post('tmp_overlay_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_overlay_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_overlay_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_overlay_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data(($destination_url!='')?$destination_url:$click_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id),
												"dj_is_direct" 		=> 	clean_data($dj_is_direct),
												"dj_image_path"		=>  $dj_image_path,
												"dj_admarket_status" =>  $adma_id
											);
											
						$companion_id		=	$this->do_video_creative->add_video($comp_creative_data);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_overlay_companion_creative')));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				/* Overlay Companion - Selection */			
				else
				{
					$companion_id	=	clean_data($this->post('vast_companion_id'));
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			/* Added on May10 - DAC020*/
			$imp_track_url				=	$this->post('imp_track_url');
			$thirdparty_click_url		=	$this->post('thirdparty_click_url');
			$thirdparty_custom_url		=	$this->post('thirdparty_custom_url');
			$overlay_expanded_width		=	$this->post('overlay_expanded_width');
			$overlay_expanded_height	=	$this->post('overlay_expanded_height');			
			$companion_click_track_url	=	$this->post('companion_track_url');
			$expanded_width				=	$this->post('expanded_width');
			$expanded_height			=	$this->post('expanded_height');	
					
			/* End */
				
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$ovl_delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$click_url,
									'vast_overlay_height' 			=> 	$ovl_height,
									'vast_overlay_width' 			=> 	$ovl_width,
									'vast_overlay_text_title' 		=> 	$txt_title,
									'vast_overlay_text_description' => 	$txt_description,
									'vast_overlay_text_call' 		=> 	$txt_action,
									'vast_overlay_format' 			=>	$ovl_type,
									'vast_overlay_action' 			=> 	$ovl_action,
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	$creative_type,
									'vast_thirdparty_impression' 	=> 	'',
									'vast_wrapper_url' 				=> 	'',
									'vast_version' 					=> 	0,
									'vast_overlay_wrapper' 			=> 	$vast_tag_url,
									'vast_overlay_version' 			=> 	$vast_tag_version,
									'vast_skippable' 				=> 	$skippable,
									'vast_video_skip_duration'		=> 	$skip_duration,
									'thirdPartyImpressionUrl'       =>  $imp_track_url,
									'vast_thirdparty_clicktracking' =>  $thirdparty_click_url,
									'vast_thirdparty_clickcustom'   =>  $thirdparty_custom_url,
									'vast_overlay_expanded_width' 	=> 	$overlay_expanded_width,
									'vast_overlay_expanded_width' 	=> 	$overlay_expanded_height, 
									'vast_thirdparty_companion_clicktracking' 	=> $companion_click_track_url,
									'vast_thirdparty_companion_expandedwidth' 	=> $expanded_width,
									'vast_thirdparty_companion_expandedheight'	=> $expanded_height 
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(		
									"contenttype"		=>	clean_data($creative_type),							
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_overlay_creative_name')),
									"filename"			=>	clean_data($file_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"url"				=>	clean_data($destination_url),
									"htmlcache"			=>	$htmlcache,
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									"dj_admarket_status" =>  $adma_id
								);
			
			 //Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);			
			
			if($creative_id)
			{			
				
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$ovl_delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	$ovl_height,
										"vast_overlay_width"			=>	$ovl_width,
										"vast_video_clickthrough_url"	=>	$click_url,
										"vast_overlay_action"			=>	$ovl_action,
										"vast_overlay_format"			=>	$ovl_type,
										"vast_overlay_text_title"		=>	$txt_title,
										"vast_overlay_text_description"	=>	$txt_description,
										"vast_overlay_text_call"		=>	$txt_action,
										"vast_creative_type"			=>	$creative_type,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_wrapper_url" 				=> 	'',
										"vast_version" 					=> 	0,
										"vast_overlay_wrapper" 			=> 	$vast_tag_url,
										"vast_overlay_version" 			=> 	$vast_tag_version,
										"vast_skippable" 				=> 	$skippable,
										"vast_video_skip_duration"		=> 	$skip_duration,
										"thirdPartyImpressionUrl"       =>  $imp_track_url,
										"vast_thirdparty_clicktracking" =>  $thirdparty_click_url,
										"vast_thirdparty_clickcustom"   =>  $thirdparty_custom_url,
										"vast_overlay_expanded_width" 	=> 	$overlay_expanded_width,
										"vast_overlay_expanded_width" 	=> 	$overlay_expanded_height, 
										"vast_thirdparty_companion_clicktracking" 	=> 	$companion_click_track_url,
										"vast_thirdparty_companion_expandedwidth" 	=> 	$expanded_width,
										"vast_thirdparty_companion_expandedheight" 	=> 	$expanded_height 	
									);
									
				$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
				
					
					/***creative change for message/mail notification*****/
					
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video Overlay creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video Overlay Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video Overlay Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					
					/***creative change for message/mail notification*****/	
				
				if($vast_add)
				{
					
					if($this->user_authentication->account_type=='ADVERTISER')
					{		

						if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
										'redirect'	 	=> 	$redirect_url,
										);						
					}
					else
					{
						if($adma_id=='1')
						{
							//$redirect_url=site_url('admin/admarket/creatives/');
							$redirect_url=site_url('admin/creatives/creative/admarket/');						
						}
						else
						{
							$redirect_url=site_url('admin/creatives/');
						}
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	$redirect_url,
										/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
										);
					}	
					
					$this->response( $success, 200);				
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);					
					}
					else
					{
						if($adma_id=='1')
						{
							//$redirect_url=site_url('admin/admarket/creatives/');
							$redirect_url=site_url('admin/creatives/creative/admarket/');						
						}
						else
						{
							$redirect_url=site_url('admin/creatives/');
						}
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);	
					}
					
					$this->response( $success, 200);			
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					
					if($adma_id=='1')
						{
							//$redirect_url=site_url('admin/admarket/creatives/');
							$redirect_url=site_url('admin/creatives/creative/admarket/');						
						}
						else
						{
							$redirect_url=site_url('admin/creatives/');
						}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				
				$this->response( $error, 200);
			}
			
		}
	}
	
	/*
	 * 
	 * name: fetch_video
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage all VIDEO CREATIVE
	 */
	
	public function fetch_video_get()
	{	
		$creative_id	=	$this->get('creative_id');
		
		if($creative_id)
		{
			$video			=	$this->do_video_creative->fetch_video($creative_id);	
			
			if($video)
			{	
				$this->response( $video, 200);
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Creative does not exist'
								);
				$this->response( $error, 200);
			}
		}
	}
	
	
	public function fetch_small_get()
	{	
		$creative_id	=	$this->get('creative_id');
				
				//echo "welcome";
				
		if($creative_id)
		{
			$video			=	$this->do_video_creative->fetch_small_image($creative_id);	
			
			if($video)
			{	
				$this->response( $video, 200);
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Creative does not exist'
								);
				$this->response( $error, 200);
			}
		}
	}
	
	
	/*
	 * 
	 * name: fetch_video_vast
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage all VIDEO CREATIVE
	 */
	public function fetch_video_vast_get()
	{	
		$creative_id	=	$this->get('creative_id');
		
		if($creative_id)
		{
			$vast			=	$this->do_video_creative->fetch_video_vast($creative_id);	
			
			if($vast)
			{	
				$this->response( $vast, 200);
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Creative does not exist'
								);
				$this->response( $error, 200);
			}
		}
	}

	 /*
	 * 
	 * name: edit_video_inline_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	
	public function edit_video_inline_creative_post()
	{
		$creative_id	=	clean_data($this->post('creative_id'));
		
		$delivery		=	clean_data($this->post('inline_delivery_method'));
		$this->form_validation->set_rules('video_inline_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('inline_delivery_method', 'Delivery Type', 'required|trim');		
		$this->form_validation->set_rules('inline_url', 'Destination URL', 'required|trim|url');
		
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('inline_rtmpurl', 'RTMP URL', 'required|trim|url');
			$this->form_validation->set_rules('inline_rtmp_filename', 'RTMP File Name', 'required|trim');
			$this->form_validation->set_rules('inline_rtmp_duration', 'RTMP video duration', 'required|trim');
		}
		else if($delivery=='progressive')
		{
			if(clean_data($this->post('tmp_video_inline')==''))
			{
				$this->form_validation->set_rules('video_inline_creative', 'Video File', 'required|trim');
			}
		}
		else if($delivery=='vast')
		{
			if(clean_data($this->post('is_vast_upload')=='on'))
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			$trusted_status='';
			
			$is_house_ad= clean_data($this->post('_is_house_ad'));
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->do_creative->fetch_creative_approval_type();

				if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
				if($approval_type==="AUTO")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';
			
			if($delivery=='progressive')
			{	
				if(clean_data($this->post('tmp_video_inline_creative'))!='')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{	
						$old_video_inline_creative_path = clean_data($this->post('old_video_inline_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_video_inline_creative_path);
					}
					
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	clean_data($this->post('tmp_video_inline_creative'));
						$output 			= 	clean_data($this->post('tmp_video_inline_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_inline_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_inline_creative_file_ext'));

						$input_with_path  	= 	clean_data($upload_path.$this->post('tmp_video_inline_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_inline_creative')));
					
					$video_name			=	clean_data($this->post('tmp_video_inline_creative'));
					if(clean_data($this->post('tmp_video_inline_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_inline_creative_content_type'));
					}
					$video_duration		=	'30';	
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');
					$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.$this->post('tmp_video_inline_creative');					
					
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];
					$dj_image_path 		=	$video['dj_image_path'];
				}
			}
			elseif($delivery=='streaming')
			{
				if($vast['vast_video_delivery']=='progressive')
				{
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
				}	
				$video_name			=	'';				
				$video_duration		=	clean_data($this->post('inline_rtmp_duration'));
				$rtmp_url			=	clean_data($this->post('inline_rtmpurl'));
				$rtmp_filename		=	clean_data($this->post('inline_rtmp_filename'));
				if(strpos($rtmp_filename, '.') != false)
				{
					$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
				}
				else
				{
					$type			=	'flv';
				}
				$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
				$video_type			=	'video/x-'.$type;
				$dj_image_path		=	'';
				
			}
			elseif($delivery=='vast')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
					
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
				$dj_image_path		=	'';
			}
			
			$skip_duration	=	0;
			$skippable		=	clean_data($this->post('skippable'));
			if($skippable==1)
			{
				$skip_duration	=	clean_data($this->post('skip_duration'));
			}
			
			if($this->post('inline_companion_size')!='')
			{
				$size 				= 	explode("x",clean_data($this->post('inline_companion_size')));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				if(clean_data($this->post('tmp_inline_companion_creative'))!='')
				{
					$storage_type	=	'web';
					$description	=	clean_data($this->post('video_inline_creative_name')).' Companion';
					$dj_image_path_comp = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					if($this->user_authentication->account_type=='ADVERTISER')
					{
					  $dj_account_id=$this->user_authentication->account_id;
					}
					else
					{
					  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					}
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												"campaignid"		=>	clean_data($this->post('campaign')),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('inline_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id"		=>  clean_data($dj_account_id),
												"dj_image_path"		=>  $dj_image_path_comp
											);
											
						$companion_id		=	$this->do_video_creative->add_video($comp_creative_data);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_inline_companion_creative')));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	clean_data($this->post('vast_companion_id'));
				}
			}
			else
			{
				$companion_id	=	0;
			}
			
			/* Added on May10 - DAC020*/
			$imp_track_url				=	$this->post('imp_track_url');
			$thirdparty_click_url		=	$this->post('thirdparty_click_url');
			$thirdparty_custom_url		=	$this->post('thirdparty_custom_url');
			$companion_click_track_url	=	$this->post('companion_track_url');
			$expanded_width				=	$this->post('expanded_width');
			$expanded_height			=	$this->post('expanded_height');			
			/* End */
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	clean_data($this->post('inline_url')),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_wrapper_url' 				=> 	$vast_tag_url,
									'vast_version' 					=> 	$vast_tag_version,
									'vast_overlay_wrapper' 			=> 	'',
									'vast_overlay_version' 			=> 	0,
									'vast_skippable' 				=> 	$skippable,
									'vast_video_skip_duration'		=> 	$skip_duration,
									'thirdPartyImpressionUrl'       =>  $imp_track_url,
									'vast_thirdparty_clicktracking' =>  $thirdparty_click_url,
									'vast_thirdparty_clickcustom'   =>  $thirdparty_custom_url, 
									'vast_thirdparty_companion_clicktracking' 	=> $companion_click_track_url,
									'vast_thirdparty_companion_expandedwidth' 	=> $expanded_width,
									'vast_thirdparty_companion_expandedheight'	=> $expanded_height 
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"dj_image_path"		=>  $dj_image_path
								);
			
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->do_video_creative->update_video($creative_data,$creative_id,$agency_id);
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_wrapper_url" 				=> 	$vast_tag_url,
										"vast_version" 					=> 	$vast_tag_version,
										"vast_overlay_wrapper" 			=> 	'',
										"vast_overlay_version" 			=> 	0,
										"vast_skippable" 				=> 	$skippable,
										"vast_video_skip_duration"		=> 	$skip_duration,
										"thirdPartyImpressionUrl"       =>  $imp_track_url,
										"vast_thirdparty_clicktracking" =>  $thirdparty_click_url,
										"vast_thirdparty_clickcustom"   =>  $thirdparty_custom_url,
										"vast_thirdparty_companion_clicktracking" 	=> 	$companion_click_track_url,
										"vast_thirdparty_companion_expandedwidth" 	=> 	$expanded_width,
										"vast_thirdparty_companion_expandedheight" 	=> 	$expanded_height 										
									);
									
				$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}
					
					$this->response( $success, 200);
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
			
			
			
		}
	}
	
	//test edit code display start
	
	/*
	 * 
	 * name: edit_video_real_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	
	//MSR
	
	public function edit_video_real_creative_post()
	{
		$creative_id	=	clean_data($this->post('creative_id'));
		
				
		
		$this->form_validation->set_rules('video_real_creative_name','Creative name', 'required|trim');		
				
		$this->form_validation->set_rules('real_url', 'Destination URL', 'required|trim|url');
		
		
		
			if(clean_data($this->post('tmp_video_real'))=='')
			{
				$this->form_validation->set_rules('video_real_creative', 'Video File', 'required|trim');
			}
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= clean_data($this->post('_is_house_ad'));
			
			$trusted_status='';
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->do_creative->fetch_creative_approval_type();

				if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
				if($approval_type==="AUTO")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
				
				if($this->post('tmp_video_real_creative')!='')
				{	
					
					if($video['filename']!='')
					{
						$old_video_real_creative_path = clean_data($this->post('old_video_real_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_video_real_creative_path);
					}
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	clean_data($this->post('tmp_video_real_creative'));
						$output 			= 	clean_data($this->post('tmp_video_real_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_real_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_real_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_real_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_real_creative')));
					
					$video_name			=	clean_data($this->post('tmp_video_real_creative'));
					if($this->post('tmp_video_real_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_real_creative_content_type'));
					}
					$video_duration		=	'30';
					$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_real_creative'));
						
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_real_creative');					
					
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];
					$dj_image_path 		=	$video['dj_image_path'];	
				}
			
			
			
				$companion_id	=	0;
			
			
			
						
			$parameters 	= '';
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"description"		=>	clean_data($this->post('video_real_creative_name')),
									"url"				=>	clean_data($this->post('real_url')),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path	
								);
			
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->do_video_creative->update_video($creative_data,$creative_id,$agency_id);
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('real_url'))									
									);
									
				$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}
					
					$this->response( $success, 200);
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
			
			
			
		}
	}
	
	//MSR
	//test edit code display end 
	
	public function edit_video_small_creative_post()
	{
		
			//print_r($_POST);
				//exit;
		
		$creative_id	=	clean_data($this->post('creative_id'));
		
				
		
		$this->form_validation->set_rules('video_small_creative_name','Creative name', 'required|trim');		
				
		$this->form_validation->set_rules('small_url', 'Destination URL', 'required|trim|url');
		
		
		
			if($this->post('tmp_video_small')=='')
			{
				$this->form_validation->set_rules('video_small_creative', 'Video File', 'required|trim');
			}
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= clean_data($this->post('_is_house_ad'));
			
			$trusted_status='';
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->do_creative->fetch_creative_approval_type();

				if($approval_type==="ADMIN")
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				if($approval_type==="AUTO")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
				
				if($this->post('tmp_video_small_creative')!='')
				{	
					
					if($video['filename']!='')
					{
						$old_video_small_creative_path = clean_data($this->post('old_video_small_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_video_small_creative_path);
					}
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	clean_data($this->post('tmp_video_small_creative'));
						$output 			= 	clean_data($this->post('tmp_video_small_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_small_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_small_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_small_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_small_creative')));
					
					$video_name			=	clean_data($this->post('tmp_video_small_creative'));
					if($this->post('tmp_video_small_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_small_creative_content_type'));
					}
					$video_duration		=	'30';	
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_small_creative');					
					$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_small_creative'));
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
					$dj_image_path 		=	$video['dj_image_path'];
				}
			
			
			
				$companion_id	=	0;
			
			
			
						
			$parameters 	= '';
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"description"		=>	clean_data($this->post('video_small_creative_name')),
									"url"				=>	clean_data($this->post('small_url')),
									"filename"			=>	"",
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path	
								);
			
			$creative_data_video 	= array(
									"content_type"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"ban_description"	=>	clean_data($this->post('video_small_creative_name')),
									"link_url"			=>	clean_data($this->post('small_url')),
									"file_path"			=>	clean_data($video_name),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path	
								);			
			
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->do_video_creative->update_video($creative_data,$creative_id,$agency_id);
			
			$creative_image_video	=	$this->do_video_creative->update_small_image($creative_id,$creative_data_video,"SMALLVIDEO");
			
						
				if($this->post('tmp_small_image_creative')!='')
				{
					
					if($this->post('tmp_small_image_creative')!=$this->post('old_small_image_creative'))
					{
						$old_small_image_creative_path = clean_data($this->post('old_small_image_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_small_image_creative_path);
						$dj_image_path_comp = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					}
										
					 $file_name			=	clean_data($this->post('tmp_small_image_creative'));
					 $creative_type		=	clean_data($this->post('tmp_small_image_creative_content_type'));
					$width			=	'300';
					$height			=	'250';
					
					//On sucess move the web creative from tmp location to original location
					 $is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_small_image_creative')));		
							
				}
				if($this->post('tmp_small_image_creative')!=$this->post('old_small_image_creative'))
					{
						$creative_image_data 	= array(
									"banner_id" 		=> 	$creative_id,
									"file_path"			=>	$file_name,
									"width"				=>	$width,
									"height"			=>	$height,
									"content_type"		=>  $creative_type,
									"dj_image_path"		=>  $dj_image_path_comp	
									);
					}else{
				$creative_image_data 	= array(
									"banner_id" 		=> 	$creative_id,
									"file_path"			=>	$file_name,
									"width"				=>	$width,
									"height"			=>	$height,
									"content_type"		=>  $creative_type,
										
									);
					}				
									//echo "<pre>";
										//print_r($creative_image_data);
									//echo"</pre>";
										//exit;
				
			$creative_image	=	$this->do_video_creative->update_small_image($creative_id,$creative_image_data);
			
						
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('small_url'))									
									);
									
				$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}
					
					$this->response( $success, 200);
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
			
			
			
		}
	}
	
	//MSR
	
	//test edit code display end 
	
	//test edit BOX code display start
	
	/*
	 * 
	 * name: edit_video_box_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all BOX VIDEO CREATIVE add process	 
	 */
	
	public function edit_video_box_creative_post()
	{
		$creative_id	=	clean_data($this->post('creative_id'));
		
		
		$this->form_validation->set_rules('video_box_creative_name','Creative name', 'required|trim');		
				
		$this->form_validation->set_rules('box_url', 'Destination URL', 'required|trim|url');
		
		
		
			if($this->post('tmp_video_box')=='')
			{
				$this->form_validation->set_rules('video_box_creative', 'Video File', 'required|trim');
			}
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= clean_data($this->post('_is_house_ad'));
			
			$trusted_status='';
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->do_creative->fetch_creative_approval_type();

				if($approval_type==="ADMIN")
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				if($approval_type==="AUTO")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
				
				if($this->post('tmp_video_box_creative')!='')
				{	
					
					if($video['filename']!='')
					{
						$old_video_box_creative_path = clean_data($this->post('old_video_box_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_video_box_creative_path);
					}
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	clean_data($this->post('tmp_video_box_creative'));
						$output 			= 	clean_data($this->post('tmp_video_box_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_box_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_box_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_box_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_box_creative')));
					
					$video_name			=	clean_data($this->post('tmp_video_box_creative'));
					if($this->post('tmp_video_box_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_box_creative_content_type'));
					}
					$video_duration		=	'30';	
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_box_creative');					
					
					$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_box_creative'));
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
					$dj_image_path 		=	$video['dj_image_path'];
				}
			
			
			
				$companion_id	=	0;
			
			
			
			$parameters 	= '';
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"description"		=>	clean_data($this->post('video_box_creative_name')),
									"url"				=>	clean_data($this->post('box_url')),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path	
								);
			
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->do_video_creative->update_video($creative_data,$creative_id,$agency_id);
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('box_url'))									
									);
									
				$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}
					
					$this->response( $success, 200);
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
			
			
			
		}
	}
	
		
	
	//Test Edit BOX code display end 
	
	
	//test edit HEAD code display start
	
	/*
	 * 
	 * name: edit_video_HEAD_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all HEAD VIDEO CREATIVE add process	 
	 */
	
	public function edit_video_head_creative_post()
	{
		$creative_id	=	clean_data($this->post('creative_id'));
		
		
		$this->form_validation->set_rules('video_head_creative_name','Creative name', 'required|trim');		
				
		$this->form_validation->set_rules('head_url', 'Destination URL', 'required|trim|url');
		
		
		
			if($this->post('tmp_video_head')=='')
			{
				$this->form_validation->set_rules('video_head_creative', 'Video File', 'required|trim');
			}
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			$trusted_status='';
			
			$is_house_ad= clean_data($this->post('_is_house_ad'));
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->do_creative->fetch_creative_approval_type();

				if($approval_type==="ADMIN")
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				if($approval_type==="AUTO")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
				
				if($this->post('tmp_video_head_creative')!='')
				{	
					if($video['filename']!='')
					{
						$old_video_head_creative_path = clean_data($this->post('old_video_head_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_video_head_creative_path);
					}
					
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	clean_data($this->post('tmp_video_head_creative'));
						$output 			= 	clean_data($this->post('tmp_video_head_creative_raw_name')).'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	clean_data($this->post('tmp_video_head_creative_raw_name'));

						$ext				=	clean_data($this->post('tmp_video_head_creative_file_ext'));

						$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_head_creative'));
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_head_creative')));
					
					$video_name			=	clean_data($this->post('tmp_video_head_creative'));
					if($this->post('tmp_video_head_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_head_creative_content_type'));
					}
					$video_duration		=	'30';	
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_head_creative');					
					$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_head_creative'));
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];
					$dj_image_path 		=	$video['dj_image_path'];	
				}
			
			
			
				$companion_id	=	0;
			
			
			
						
			$parameters 	= '';
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"description"		=>	clean_data($this->post('video_head_creative_name')),
									"url"				=>	clean_data($this->post('head_url')),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path	
								);
			
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->do_video_creative->update_video($creative_data,$creative_id,$agency_id);
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('head_url'))									
									);
									
				$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}
					
					$this->response( $success, 200);
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
			
			
			
		}
	}
		
	
	//Test Edit HEAD code display end 
	
	
	
	
	
	/*
	 * 
	 * name: edit_video_overlay_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all OVERLAY VIDEO CREATIVE edit process	 
	 */
	public function edit_video_overlay_creative_post()
	{
		$creative_id	=	clean_data($this->post('creative_id'));
		$ovl_type		=	clean_data($this->post('overlay_type'));
		$ovl_action		=	clean_data($this->post('click_action'));
		$ovl_delivery	=	clean_data($this->post('overlay_delivery_method'));
		
		$this->form_validation->set_rules('video_overlay_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('overlay_type', 'Overlay Type', 'required|trim');		
		$this->form_validation->set_rules('click_action', 'Overlay Type', 'required|trim');		
		$this->form_validation->set_rules('overlay_delivery_method', 'Delivery Type', 'required|trim');
			
		if($ovl_type=='image_overlay')
		{
			if(clean_data($this->post('tmp_overlay_image'))=='')
			{
				$this->form_validation->set_rules('overlay_image', 'Image File', 'required|trim');
			}
		}
		elseif($ovl_type=='swf_overlay')
		{
			if(clean_data($this->post('tmp_overlay_swf'))=='')
			{
				$this->form_validation->set_rules('overlay_swf', 'Swf File', 'required|trim');
			}
		}
		elseif($ovl_type=='text_overlay')
		{
			$this->form_validation->set_rules('txt_title', 'Text Overlay Title', 'required|trim');		
			$this->form_validation->set_rules('txt_action', 'Text Overlay action', 'trim|url');		
		}
		elseif($ovl_type=='vast_overlay')
		{
			if(clean_data($this->post('is_vast_upload'))=='on')
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
		
		if($ovl_action=='click_to_video')
		{	
			$this->form_validation->set_rules('overlay_click_url', 'Overlay Click URL', 'required|trim|url');
			if($ovl_delivery=='progressive')
			{
				if(clean_data($this->post('tmp_video_overlay'))=='')
				{
					$this->form_validation->set_rules('video_overlay_creative', 'Video File', 'required|trim');
				}
			}
		}
		else
		{
			$this->form_validation->set_rules('overlay_url', 'Destination URL', 'required|trim|url');
		}
		
		if($ovl_delivery=='streaming')
		{
			$this->form_validation->set_rules('overlay_rtmpurl', 'RTMP URL', 'required|trim|url');
			$this->form_validation->set_rules('overlay_rtmp_filename', 'RTMP File Name', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_duration', 'RTMP video duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			/* Static values */
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
				
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad=clean_data($this->post('_is_house_ad'));
			
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			
			$trusted_status='';
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->do_creative->fetch_creative_approval_type();

				if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
				if($approval_type==="AUTO")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';		
			/* Overlay Type - Image Overlay */
			if($ovl_type=='image_overlay')
			{
				if(clean_data($this->post('tmp_overlay_image_creative'))!='')
				{
					
					if($video['filename']!='')
					{
						$old_overlay_image_creative_path = clean_data($this->post('old_overlay_image_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_overlay_image_creative_path);
					}
					$file_name			=	clean_data($this->post('tmp_overlay_image_creative'));
					$creative_type		=	clean_data($this->post('tmp_overlay_image_creative_content_type'));
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_overlay_image_creative')));
				}
				else
				{
					$file_name		=	$video['filename'];
					$creative_type	=	$vast['vast_creative_type'];
					$ovl_width		=	$vast['vast_overlay_width'];
					$ovl_height		=	$vast['vast_overlay_height'];
					$dj_image_path 	= 	$video['dj_image_path'];
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - SWF Overlay */
			elseif($ovl_type=='swf_overlay')
			{
				if(clean_data($this->post('tmp_overlay_swf_creative'))!='')
				{
					if($video['filename']!='')
					{
						$old_overlay_swf_creative_path = clean_data($this->post('old_overlay_swf_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_overlay_swf_creative_path);
					}
					$file_name			=	clean_data($this->post('tmp_overlay_swf_creative'));
					$creative_type		=	'swf';
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_overlay_swf_creative')));
				}
				else
				{
					$file_name		=	$video['filename'];
					$creative_type	=	$vast['vast_creative_type'];
					$ovl_width		=	$vast['vast_overlay_width'];
					$ovl_height		=	$vast['vast_overlay_height'];
					$dj_image_path 	= 	$video['dj_image_path'];
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - Text Overlay */
			elseif($ovl_type=='text_overlay')
			{
				if($video['filename']!='')
				{
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
				}
				$file_name			=	'';
				$creative_type		=	'txt';
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	clean_data($this->post('txt_title'));
				$txt_description	=	clean_data($this->post('txt_description'));
				$txt_action			=	clean_data($this->post('txt_action'));
				$dj_image_path 		= 	'';
			}
			elseif($ovl_type=='vast_overlay')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
					
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
				$file_name			=	'';
				$creative_type		=	'xml';
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
				$dj_image_path 		= 	'';
			}
			
			$skip_duration	=	0;
			$skippable		=	clean_data($this->post('skippable'));
			if($skippable==1)
			{
				$skip_duration	=	clean_data($this->post('skip_duration'));
			}
			
			/* Added on May10 - DAC020*/
			$imp_track_url				=	$this->post('imp_track_url');
			$thirdparty_click_url		=	$this->post('thirdparty_click_url');
			$thirdparty_custom_url		=	$this->post('thirdparty_custom_url');
			$overlay_expanded_width		=	$this->post('overlay_expanded_width');
			$overlay_expanded_height	=	$this->post('overlay_expanded_height');	
			$companion_click_track_url	=	$this->post('companion_track_url');
			$expanded_width				=	$this->post('expanded_width');
			$expanded_height			=	$this->post('expanded_height');			
			/* End */
			
			/* Overlay Action - Click to Page */
			if($ovl_action=='click_to_page')
			{
				if($vast['vast_video_delivery']=='progressive')
				{
					$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
					$videoname		= 	$xmlFile['basename'];
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
				}
				$destination_url	=	clean_data($this->post('overlay_url'));
				$htmlcache			=	'<a href="{clickurl}" target="{target}"></a>';
				$ovl_delivery		=	NULL;
				$click_url			=	NULL;
				$video_type			=	NULL;
				$video_duration		=	NULL;
				$outgoing_filename	=	NULL;
			}
			/* Overlay Action - Click to Video */
			elseif($ovl_action=='click_to_video')
			{	
				/* Overlay Delivery type - Progressive */			
				if($ovl_delivery=='progressive')
				{	
					if(clean_data($this->post('tmp_video_overlay_creative'))!='')
					{	
						if($vast['vast_video_delivery']=='progressive')
						{
							$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
							$videoname		= 	$xmlFile['basename'];
							$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
						}
						
						if($this->commandExists("ffmpeg")>0) 
						{
							##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
							$input  			= 	clean_data($this->post('tmp_video_overlay_creative'));
							$output 			= 	clean_data($this->post('tmp_video_overlay_creative_raw_name')).'.flv';
							
							$upload_path		=	$this->config->item('creative_path');
							$raw_name			=	clean_data($this->post('tmp_video_overlay_creative_raw_name'));

							$ext				=	clean_data($this->post('tmp_video_overlay_creative_file_ext'));

							$input_with_path  	= 	$upload_path.clean_data($this->post('tmp_video_overlay_creative'));
							$output_with_path 	= 	$upload_path.$output;
							
							#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
							$video_duration		=	'30';	
						}
						else 
						{
							$video_duration		=	'30';	
						}
						
						$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_overlay_creative')));
						
						if(clean_data($this->post('tmp_video_overlay_creative_content_type'))=='video/mp4')
						{
							$video_type		=	'video/x-mp4';
						}
						else
						{
							$video_type		=	clean_data($this->post('tmp_video_overlay_creative_content_type'));
						}
						$video_duration		=	'30';	
						//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_overlay_creative');					
						$dj_image_path_vid = $this->config->item('creative_upload_path').date("Y-m-d")."/";
						$outgoing_filename	=$this->config->item('base_url').$dj_image_path_vid.clean_data($this->post('tmp_video_overlay_creative'));						
				
					}
					else
					{
						$video_name			=	$video['filename'];
						$video_type			=	$vast['vast_video_type'];
						$video_duration		=	$vast['vast_video_duration'];	
						$outgoing_filename	=	$vast['vast_video_outgoing_filename'];
						$dj_image_path_vid 		=	$video['dj_image_path'];	
					}
				}
				/* Overlay Delivery type - Streaming */			
				elseif($ovl_delivery=='streaming')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{
						$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
						$videoname		= 	$xmlFile['basename'];
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
					}	
					
					$video_duration		=	clean_data($this->post('overlay_rtmp_duration'));
					$rtmp_url			=	clean_data($this->post('overlay_rtmpurl'));
					$rtmp_filename		=	clean_data($this->post('overlay_rtmp_filename'));
					if(strpos($rtmp_filename, '.') != false)
					{
						$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
					}
					else
					{
						$type			=	'flv';
					}
					$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
					$video_type			=	'video/x-'.$type;
				}
				$destination_url	=	'';
				$htmlcache			=	'';
				$click_url			=	clean_data($this->post('overlay_click_url'));
			}
			
			/* Overlay Companion */			
			if($this->post('overlay_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('overlay_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				
				/* Overlay Companion - Upload */			
				if($this->post('tmp_overlay_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	clean_data($this->post('video_overlay_creative_name')).' Companion';
					$dj_image_path_comp = $this->config->item('creative_upload_path').date("Y-m-d")."/";
					if($this->user_authentication->account_type=='ADVERTISER')
					{
					  $dj_account_id=$this->user_authentication->account_id;
					}
					else
					{
					  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					}
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_overlay_companion_creative_content_type')),
												"campaignid"		=>	clean_data($this->post('campaign')),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_overlay_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data(($destination_url!='')?$destination_url:$click_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id"		=>  clean_data($dj_account_id),
												"dj_image_path"		=>  $dj_image_path_comp
											);
											
						$companion_id		=	$this->do_video_creative->add_video($comp_creative_data);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_overlay_companion_creative')));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				/* Overlay Companion - Selection */			
				else
				{
					$companion_id	=	clean_data($this->post('vast_companion_id'));
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$ovl_delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$click_url,
									'vast_overlay_height' 			=> 	$ovl_height,
									'vast_overlay_width' 			=> 	$ovl_width,
									'vast_overlay_text_title' 		=> 	$txt_title,
									'vast_overlay_text_description' => 	$txt_description,
									'vast_overlay_text_call' 		=> 	$txt_action,
									'vast_overlay_format' 			=>	$ovl_type,
									'vast_overlay_action' 			=> 	$ovl_action,
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	$creative_type,
									'vast_thirdparty_impression' 	=> 	'',
									'vast_wrapper_url' 				=> 	'',
									'vast_version' 					=> 	0,
									'vast_overlay_wrapper' 			=> 	$vast_tag_url,
									'vast_overlay_version' 			=> 	$vast_tag_version,
									'vast_skippable' 				=> 	$skippable,
									'vast_video_skip_duration'		=> 	$skip_duration,
									'thirdPartyImpressionUrl'       =>  $imp_track_url,
									'vast_thirdparty_clicktracking' =>  $thirdparty_click_url,
									'vast_thirdparty_clickcustom'   =>  $thirdparty_custom_url,
									'vast_overlay_expanded_width' 	=> 	$overlay_expanded_width,
									'vast_overlay_expanded_width' 	=> 	$overlay_expanded_height, 
									'vast_thirdparty_companion_clicktracking' 	=> $companion_click_track_url,
									'vast_thirdparty_companion_expandedwidth' 	=> $expanded_width,
									'vast_thirdparty_companion_expandedheight'	=> $expanded_height 
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data($creative_type),
									"description"		=>	clean_data($this->post('video_overlay_creative_name')),
									"filename"			=>	clean_data($file_name),
									"parameters"		=>	$parameters,
									"url"				=>	clean_data($destination_url),
									"htmlcache"			=>	$htmlcache,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
			
			//Call to add a creative
			$updated		=	$this->do_video_creative->update_video($creative_data,$creative_id);			
				
			if($updated)	
			{			
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$ovl_delivery,
										"vast_video_type"				=>	$video_type,									
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	$ovl_height,
										"vast_overlay_width"			=>	$ovl_width,
										"vast_video_clickthrough_url"	=>	$click_url,
										"vast_overlay_action"			=>	$ovl_action,
										"vast_overlay_format"			=>	$ovl_type,
										"vast_overlay_text_title"		=>	$txt_title,
										"vast_overlay_text_description"	=>	$txt_description,
										"vast_overlay_text_call"		=>	$txt_action,
										"vast_creative_type"			=>	$creative_type,
										"vast_wrapper_url" 				=> 	'',
										"vast_version" 					=> 	0,
										"vast_overlay_wrapper" 			=> 	$vast_tag_url,
										"vast_overlay_version" 			=> 	$vast_tag_version,
										"vast_skippable" 				=> 	$skippable,
										"vast_video_skip_duration"		=> 	$skip_duration,
										"thirdPartyImpressionUrl"       =>  $imp_track_url,
										"vast_thirdparty_clicktracking" =>  $thirdparty_click_url,
										"vast_thirdparty_clickcustom"   =>  $thirdparty_custom_url,
										"vast_overlay_expanded_width" 	=> 	$overlay_expanded_width,
										"vast_overlay_expanded_width" 	=> 	$overlay_expanded_height, 
										"vast_thirdparty_companion_clicktracking" 	=> 	$companion_click_track_url,
										"vast_thirdparty_companion_expandedwidth" 	=> 	$expanded_width,
										"vast_thirdparty_companion_expandedheight" 	=> 	$expanded_height
										
									);
									
				$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}
					$this->response( $success, 200);
					
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}	
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				
				$this->response( $error, 200);
			}
			
		}
	}

	
	public function edit_video_creative_post()
	{
		$creative_id	=	clean_data($this->post('creative_id'));
		
		$delivery		=	clean_data($this->post('special_delivery_method'));		
		
		$this->form_validation->set_rules('video_creative_name','Creative name', 'required|trim');		
				
		$this->form_validation->set_rules('video_url', 'Destination URL', 'required|trim|url');
				
		if(clean_data($this->post('tmp_video'))=='')
		{
			$this->form_validation->set_rules('video_creative', 'Video File', 'required|trim');
		}	
		
		if($delivery=='on')
		{
			if(clean_data($this->post('is_vast_upload'))=='on')
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
				
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{	
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';
			$video_name			=	'';
			$video_duration		=	'30';
			$video_type			=	'';
			$outgoing_filename	=	'';
			$file_size			=	0;
			
			if($delivery=='on')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
				$vid_delivery		=	'vast';
			}
			else
			{							
				if(clean_data($this->post('tmp_video_creative'))!='')
				{			
					if($video['filename']!='')
					{
						$old_video_creative_path 	= 	clean_data($this->post('old_video_creative_path'));
						$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_video_creative_path);
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_creative')));
					
					$video_name			=	clean_data($this->post('tmp_video_creative'));
					$file_size			=	clean_data($this->post('tmp_video_creative_size'));
					if(clean_data($this->post('tmp_video_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_creative_content_type'));
					}
					$dj_image_path 		= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
					$outgoing_filename	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_creative'));	
					$file_size			=	clean_data($this->post('tmp_video_creative_size'));	
					
					$vid_delivery		=	'progressive';
					
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$video['contenttype'];	
					$dj_image_path 		=	$video['dj_image_path'];
					$file_size			=	$video['file_size'];
					$vid_delivery		=	'progressive';
				}			
			}
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"description"		=>	clean_data($this->post('video_creative_name')),
									"url"				=>	clean_data($this->post('video_url')),
									"filename"			=>	$video_name,
									"file_size"			=>	$file_size,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path	
								);			
						
			//Get agencyid from library file
			$agency_id			=	$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated			=	$this->do_video_creative->update_video($creative_data,$creative_id,$agency_id);
					
			$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$vid_delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	0,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('video_url')),
										"vast_wrapper_url" 				=> 	$vast_tag_url,
										"vast_version" 					=> 	$vast_tag_version,
										"vast_overlay_wrapper" 			=> 	'',
										"vast_overlay_version" 			=> 	0
									);
									
			$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
					
			if($video['dj_banner_type']==VIDEO_CREATIVE_SMALL)
			{	
				$creative_data_video 	= 	array(
												"content_type"		=>	clean_data(str_replace('video/x-','',$video_type)),
												"ban_description"	=>	clean_data($this->post('video_creative_name')),
												"link_url"			=>	clean_data($this->post('video_url')),
												"file_path"			=>	clean_data($video_name),
												"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path	
											);			
				
				$creative_image_video	=	$this->do_video_creative->update_small_image($creative_id,$creative_data_video,"SMALLVIDEO");
						
				if(clean_data($this->post('tmp_small_image_creative'))!='')
				{		
					$file_name		=	clean_data($this->post('tmp_small_image_creative'));
					$creative_type	=	clean_data($this->post('tmp_small_image_creative_content_type'));
					$width			=	'300';
					$height			=	'250';
								
					$creative_image_data 	= array(
														"banner_id" 		=> 	$creative_id,
														"file_path"			=>	$file_name,
														"width"				=>	$width,
														"height"			=>	$height,
														"content_type"		=>  $creative_type															
													);
													
					if(clean_data($this->post('tmp_small_image_creative'))!=clean_data($this->post('old_small_image_creative')))
					{
						$old_small_image_creative_path 	= 	clean_data($this->post('old_small_image_creative_path'));
						$is_old_creative_deleted		=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_small_image_creative_path);
						$dj_image_path_comp 			= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
						
						$creative_image_data["dj_image_path"]	=	$dj_image_path_comp;
					}				
					
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_small_image_creative')));		
										
					$creative_image		=	$this->do_video_creative->update_small_image($creative_id,$creative_image_data);
					
				}
			}
						
			if($updated)
			{	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully updated',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);
				}
				
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: creative_to_tmp_location
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected video creative to a temporary location
	 * 
	 */
	public function creative_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'   	=> 	$_FILES['creative']['name'],
					'tmp_name' 		=> 	$_FILES['creative']['tmp_name'], 
					);
				
			$tmp_creative=$this->image_lib->move_creative_to_tmp_location($creative);

			if($tmp_creative)
			{
				$success = array(
								'response' 	=> 	$tmp_creative['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('advertiser/creative/add_web_creative'),
								'msg'		=> 	'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
		
	}
	
	/*
	 * 
	 * name: creative_video_to_tmp_location
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected video creative video to a temporary location
	 * 
	 */
	public function creative_video_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'  	=> 	$_FILES['creative']['name'],
					'tmp_name' 		=> 	$_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_video_creative_to_tmp_location($creative);
			
			if($tmp_creative)
			{
				$success = array(
								'response' 	=> 	$tmp_creative['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
							$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('advertiser/creative/add_web_creative'),
								'msg'	 	=> 	'Unable to move to temporary location '			
								);
							$this->response($error, 200);
				}
				else
				{
						$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('admin/creative/add_web_creative'),
								'msg'	 	=> 	'Unable to move to temporary location '			
								);
							$this->response($error, 200);
				}
			}
		}
		
	}
	
	/*
	 * 
	 * name: creative_swf_to_tmp_location
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected video creative video to a temporary location
	 * 
	 */
	public function creative_swf_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'  	=> 	$_FILES['creative']['name'],
					'tmp_name' 		=> 	$_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_swf_creative_to_tmp_location($creative);

			if($tmp_creative)
			{
				$success = array(
								'response' 	=> 	$tmp_creative['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('advertiser/creative/add_web_creative'),
								'msg'	 	=> 	'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
		
	}
	
	/*
	 * 
	 * name: delete_a_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the video creative in its original location
	 */
	
	public function delete_a_creative_post()
	{
		$tmp_creative_name	=	clean_data($this->post('creative_name'));
		
		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_original_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Temporary creative deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary creative file'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	/*
	 * 
	 * name: delete_a_tmp_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the video creative in temporary location
	 */
	
	public function delete_a_tmp_creative_post()
	{
		$tmp_creative_name	=	clean_data($this->post('creative_name'));
		if($tmp_creative_name)
		{
			$is_tmp_creative	=	$this->image_lib->delete_creative_in_tmp_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' 	=> 'success',
							'msg'	 	=> 'Temporary creative deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Unable to delete the temporary creative file'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: check_companion_size
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in temporary location
	 */
	
	public function check_companion_size_post()
	{
		$campaign_id	=	clean_data($this->post('campaign_id'));
		$width			=	clean_data($this->post('companion_width'));
		$height			=	clean_data($this->post('companion_height'));
		if($width && $height)
		{
			$companion			=	$this->do_video_creative->check_companion_size($campaign_id,$width,$height);
			if($companion)
			{
				$success = array(
							'response' 	=> 'ok',
							'msg'	 	=> 'Creative exist for selected companion size'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Creative does not exist for selected companion size'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Unable to find available companion banner'
							);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: filter_companions
	 * @param
	 * @return:response array
	 * 
	 * In this method we will filter all COMPANION CREATIVE
	 */
	
	public function filter_companions_get()
	{
		$campaign_id=	$this->get('campaign_id');
		$width		=	$this->get('width');
		$height		=	$this->get('height');
		if($width && $height)
		{
			$companion	=	$this->do_video_creative->check_companion_size($campaign_id,$width,$height);
			if($companion)
			{	
				$this->response($companion, 200);
			}
			else
			{
				$error = array('error'	=> 'Creative does not exist for selected companion size');
				$this->response($error, 200);
			}
		}
	
	}
	
	/*
	 * 
	 * name: fetch_companion_details
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage COMPANION CREATIVE details
	 */
	
	public function fetch_companion_details_get()
	{	
		$companion_id	=	$this->get('companion_id');
		
		if($companion_id)
		{
			$companion		=	$this->do_video_creative->fetch_video($companion_id);	
			
			if($companion)
			{	
				$this->response( $companion, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Creative does not exist'
								);
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: convertToFlv
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage VIDEO CREATIVE details in ffmpeg
	 */
	
	function convertToFlv($input,$output,$raw_name,$upload_path,$ext)
	{
		$time		=	time();
		##CONVERT VIDEO	
		
		//$command = "ffmpeg -i $input -ar 44100 -r 12 $output";
		$command 	= 	"ffmpeg -i $input -vcodec flv -qscale 3 -ar 44100 -f flv $output";
		##FETCH TOTAL TIME

		$time 					=  	shell_exec("ffmpeg -i $input 2>&1 | grep 'Duration' | cut -d ' ' -f 4 | sed s/,//");   
		$duration 				= 	explode(":",$time);   
		$duration_in_seconds 	= 	$duration[0]*3600 + $duration[1]*60+ round($duration[2]);   
		$duration_in_seconds	=	round($duration_in_seconds);
		$time_for_thumb_one		=	0;
		$time_for_thumb_two		=	$duration_in_seconds/2;
		$time_for_thumb_three	=	$duration_in_seconds-1;
		
		##CREATE THUMBNAILS	
		$thumb_230X150_command1 = "ffmpeg  -itsoffset -$time_for_thumb_one  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 230X150 ".$upload_path.$raw_name."-230X150-1.jpg";
		
		$thumb_230X150_command2 = "ffmpeg  -itsoffset -$time_for_thumb_two  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 230X150 ".$upload_path.$raw_name."-230X150-2.jpg";
		
		$thumb_230X150_command3 = "ffmpeg  -itsoffset -$time_for_thumb_three  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 230X150 ".$upload_path.$raw_name."-230X150-3.jpg";
		
		$thumb_486X412_command1 = "ffmpeg  -itsoffset -$time_for_thumb_one  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 486X412 ".$upload_path.$raw_name."-486X412-1.jpg";
		
		$thumb_486X412_command2 = "ffmpeg  -itsoffset -$time_for_thumb_two  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 486X412 ".$upload_path.$raw_name."-486X412-2.jpg";
		
		$thumb_486X412_command3 = "ffmpeg  -itsoffset -$time_for_thumb_three  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 486X412 ".$upload_path.$raw_name."-486X412-3.jpg";

		
		##EXECUTE SHELL COMMANDS
		shell_exec($command);
		shell_exec( $thumb_230X150_command1 );
		shell_exec( $thumb_230X150_command2 );
		shell_exec( $thumb_230X150_command3 );
		
		shell_exec( $thumb_486X412_command1 );
		shell_exec( $thumb_486X412_command2 );
		shell_exec( $thumb_486X412_command3 );
		
		return $duration_in_seconds;
	}
	
	/* FFMPEG EXIST OR NOT */
	public function commandExists($command) 
	{
		$command = escapeshellarg($command);
		$exists = exec("man ".$command,$out);
		return sizeof($out);
	}
	
	/*
	 * 
	 * name: creative_video_to_tmp_location
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected video creative video to a temporary location
	 * 
	 */
	public function creative_xml_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'  	=> 	$_FILES['creative']['name'],
					'tmp_name' 		=> 	$_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_xml_creative_to_tmp_location($creative);
			
			if($tmp_creative)
			{
				$success = array(
								'response' 	=> 	$tmp_creative['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
							$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('advertiser/creative/add_web_creative'),
								'msg'	 	=> 	'Unable to move to temporary location '			
								);
							$this->response($error, 200);
				}
				else
				{
						$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('admin/creative/add_web_creative'),
								'msg'	 	=> 	'Unable to move to temporary location '			
								);
							$this->response($error, 200);
				}
			}
		}		
	}
	
	/*
	 * 
	 * name: add_video_html5_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all Html5 VIDEO CREATIVE add process	 
	 */
	 
	public function add_video_html5_creative_post()
	{
		$delivery	=	clean_data($this->post('html5_delivery_method'));		
		
		$this->form_validation->set_rules('video_html5_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('html5_delivery_method', 'Delivery Type', 'required|trim');		
		$this->form_validation->set_rules('video_html5_url', 'Destination URL', 'required|trim|url');
		$campaign = clean_data($this->post('_vid_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_vid_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_vid_campaign_id'));
		}
		
		if($delivery=='vast')
		{
			if(clean_data($this->post('is_vast_upload'))=='on')
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			if(clean_data($this->post('_creative_type'))=='Web')
			{
				$bannertype		=	VIDEO_CREATIVE_HTML5;
			}
			else if(clean_data($this->post('_creative_type'))=='App')
			{
				$bannertype		=	APP_VIDEO_CREATIVE_HTML5;
			}
			else
			{
				$bannertype		=	VIDEO_CREATIVE_HTML5;
			}
			
			$storagetype	=	'html';
			$width			=	'-3';
			$height			=	'-3';
			$ext_bannertype = 	"bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";
			$dj_image_path 	= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
			
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_vid_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_vin_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						$dj_admin_approve='0';$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}						
			}
			elseif($is_house_ad =='2')
			{
				$dj_admin_approve='0';$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';
			$video_name			=	'';
			$video_type			=	'';
			$video_duration		=	'30';
			$outgoing_filename	=	'';
			$file_size			=	0;
			
			if($delivery=='progressive')
			{	
				if(clean_data($this->post('tmp_video_html5_creative'))!='')
				{	
					/*if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	$this->post('tmp_video_html5_creative');
						$output 			= 	$this->post('tmp_video_html5_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_html5_creative_raw_name');

						$ext				=	$this->post('tmp_video_html5_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_html5_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}*/
					
					$video_duration		=	'30';
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_html5_creative')));
							
					$video_name			=	clean_data($this->post('tmp_video_html5_creative'));
					if(clean_data($this->post('tmp_video_html5_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_html5_creative_content_type'));
					}
					
					//$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');					
					$outgoing_filename	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_html5_creative'));
					
					$file_size			=	clean_data($this->post('tmp_video_html5_creative_size'));
				}
			}
			elseif($delivery=='vast')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
					
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
			}
			
			$skip_duration	=	0;
			$skippable		=	clean_data($this->post('skippable'));
			if($skippable==1)
			{
				$skip_duration	=	clean_data($this->post('skip_duration'));
			}
				
			$companion_id	=	0;
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	clean_data($this->post('video_html5_url')),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_wrapper_url' 				=> 	$vast_tag_url,
									'vast_version' 					=> 	$vast_tag_version,
									'vast_overlay_wrapper' 			=> 	'',
									'vast_overlay_version' 			=> 	0,
									'vast_skippable' 				=> 	$skippable,
									'vast_video_skip_duration'		=> 	$skip_duration
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(	
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_html5_creative_name')),
									"filename"			=>	clean_data($video_name),
									"file_size"			=>	clean_data($file_size),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('video_html5_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path
								);
			//Call to add a creative
			$creative_id	=	$this->do_video_creative->add_video($creative_data,$agency_id);
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('video_html5_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_wrapper_url" 				=> 	$vast_tag_url,
										"vast_version" 					=> 	$vast_tag_version,
										"vast_overlay_wrapper" 			=> 	"",
										"vast_overlay_version" 			=> 	0,
										"vast_skippable" 				=> 	$skippable,
										"vast_video_skip_duration"		=> 	$skip_duration	
									);
									
				$vast_add	=	$this->do_video_creative->add_video_vast($vast_data);
				
					/***creative change for message/mail notification*****/
					
					
					$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Video html5 creative added';
					$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Web Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Video html5 Creative';
					$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Web Creative';
					$content['creative_type'] = 'Video html5 Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
					
					/***creative change for message/mail notification*****/	
				
				if($vast_add)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						
						if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
					
						
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	$redirect_url,
										);						
					}
					else
					{
							if($adma_id=='1')
							{
								//$redirect_url=site_url('admin/admarket/creatives/');
								$redirect_url=site_url('admin/creatives/creative/admarket/');						
							}
							else
							{
								$redirect_url=site_url('admin/creatives/');
							}
					
							$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	$redirect_url,
										);
					}		
					
					$this->response( $success, 200);			
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
									
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	$redirect_url,
									);					
					}
					else
					{
						
					    	if($adma_id=='1')
							{								
								$redirect_url=site_url('admin/creatives/creative/admarket/');						
							}
							else
							{
								$redirect_url=site_url('admin/creatives/');
							}					
						
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	$redirect_url,
									);	
					}	
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					
					    if($adma_id=='1')
						{
							$redirect_url=site_url('advertiser/admarket/creatives/');
						}
						else
						{
							$redirect_url=site_url('advertiser/creatives/');
						}
						
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					
					        if($adma_id=='1')
							{								
								$redirect_url=site_url('admin/creatives/creative/admarket/');						
							}
							else
							{
								$redirect_url=site_url('admin/creatives/');
							}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				
				$this->response( $error, 200);
			}			
		}
	}
	
	/*
	* 
	* name: edit_video_html5_creative
	* @param
	* @return:response array
	* 
	* In this methosd we will manage all HTML5 VIDEO CREATIVE add process	 
	*/
	
	public function edit_video_html5_creative_post()
	{
		$creative_id	=	clean_data($this->post('creative_id'));
		
		$delivery		=	clean_data($this->post('html5_delivery_method'));
		$this->form_validation->set_rules('video_html5_creative_name','Creative name', 'required|trim');		
		$this->form_validation->set_rules('html5_delivery_method', 'Delivery Type', 'required|trim');		
		$this->form_validation->set_rules('video_html5_url', 'Destination URL', 'required|trim|url');
		
		if($delivery=='progressive')
		{
			if(clean_data($this->post('tmp_video_html5'))=='')
			{
				$this->form_validation->set_rules('video_html5_creative', 'Video File', 'required|trim');
			}
		}
		else if($delivery=='vast')
		{
			if(clean_data($this->post('is_vast_upload'))=='on')
			{
				$this->form_validation->set_rules('tmp_vast_tag_upload_creative', 'Vast Upload', 'required|trim');
				$this->form_validation->set_rules('vast_tag_upload', 'Vast Upload', 'trim|callback_xml_file_check');
			}
			else
			{
				$this->form_validation->set_rules('vast_tag_url', 'Vast Tag URL', 'required|trim|url|callback_xml_file_check');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= clean_data($this->post('_is_house_ad'));
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->do_creative->fetch_creative_approval_type();

				if($approval_type==="ADMIN")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type==="AUTO")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			$vast_tag_url		=	'';
			$vast_tag_version	=	'0';
			$video_name			=	'';
			$file_size			=	'0';
			$video_type			=	'';
			$video_duration		=	'30';	
			$outgoing_filename	=	'';
			$dj_image_path 		= 	$this->config->item('creative_upload_path').date("Y-m-d")."/";
			
			if($delivery=='progressive')
			{	
				if(clean_data($this->post('tmp_video_html5_creative'))!='')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{	
						$old_video_inline_creative_path = clean_data($this->post('old_video_html5_creative_path'));
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location_date($video['filename'],$old_video_inline_creative_path);
					}
					
					/*if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_html5_creative');
						$output 			= 	$this->post('tmp_video_html5_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_html5_creative_raw_name');

						$ext				=	$this->post('tmp_video_html5_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_html5_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}*/
					
					$video_duration		=	'30';	
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_video_html5_creative')));
					
					$video_name			=	clean_data($this->post('tmp_video_html5_creative'));
					$file_size			=	clean_data($this->post('tmp_video_html5_creative_size'));
					
					if(clean_data($this->post('tmp_video_html5_creative_content_type'))=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	clean_data($this->post('tmp_video_html5_creative_content_type'));
					}
					$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";					
					$outgoing_filename	=$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_video_html5_creative'));					
					
				}
				else
				{
					$video_name			=	$video['filename'];
					$file_size			=	$video['file_size'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];
					$dj_image_path 		=	$video['dj_image_path'];
				}
			}
			elseif($delivery=='vast')
			{
				if(clean_data($this->post('is_vast_upload'))=='on')
				{
					$vast_tag_url	=	$this->config->item('base_url').$dj_image_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
					
					$is_xml_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				else
				{
					$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
					
				}
				
				$vast_tag_version	=	clean_data($this->post('vast_tag_version'));
			}
			
			$skip_duration	=	0;
			$skippable		=	clean_data($this->post('skippable'));
			if($skippable==1)
			{
				$skip_duration	=	clean_data($this->post('skip_duration'));
			}
						
			$companion_id	=	0;
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	clean_data($this->post('video_html5_url')),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_wrapper_url' 				=> 	$vast_tag_url,
									'vast_version' 					=> 	$vast_tag_version,
									'vast_overlay_wrapper' 			=> 	'',
									'vast_overlay_version' 			=> 	0,
									'vast_skippable' 				=> 	$skippable,
									'vast_video_skip_duration'		=> 	$skip_duration
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(
									"contenttype"		=>	clean_data(str_replace('video/x-','',$video_type)),
									"description"		=>	clean_data($this->post('video_html5_creative_name')),
									"filename"			=>	clean_data($video_name),
									"file_size"			=>	clean_data($file_size),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"dj_image_path"		=>  $dj_image_path
								);
			
			//Get agencyid from library file
			$agency_id		=	$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->do_video_creative->update_video($creative_data,$creative_id,$agency_id);
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('video_html5_url')),
										"vast_wrapper_url" 				=> 	$vast_tag_url,
										"vast_version" 					=> 	$vast_tag_version,
										"vast_overlay_wrapper" 			=> 	'',
										"vast_overlay_version" 			=> 	0,
										"vast_skippable" 				=> 	$skippable,
										"vast_video_skip_duration"		=> 	$skip_duration									
									);
									
				$vast_update	=	$this->do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('advertiser/creatives/'),
										);
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully updated',
										'redirect'	 	=> 	site_url('admin/creatives/'),
										);
					}
					
					$this->response( $success, 200);
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: xml_file_check
	* @param : null
	* @return : Email Count 
	* 
	* checked the email count
	*/
	
	public function xml_file_check()
	{
		$tmp_path 	= 	$this->config->item('creative_tmp_upload_path');
		$vastupload		=	FALSE;
		if(clean_data($this->post('vast_tag_url')))
		{
			$vast_tag_url	=	clean_data($this->post('vast_tag_url'));
		}
		else
		{
			$vast_tag_url	=	$this->config->item('base_url').$tmp_path.clean_data($this->post('tmp_vast_tag_upload_creative'));
			$vastupload		=	TRUE;
		}	
		
		$xml	=	simplexml_load_file($vast_tag_url);
				
		if($xml){
			$vast_ad		=	($xml->Ad)?$xml->Ad:'';	
			$vast_type		=	'';
			$vast_creative	=	'';
			
			if(!empty($vast_ad))
			{
				$vast_type	=	($vast_ad->InLine)?$vast_ad->InLine:'';	
				if(!empty($vast_type))
				{
					$vast_creative	=	($vast_type->Creatives)?$vast_type->Creatives:'';
					if(!empty($vast_creative))
					{
						return TRUE;
					}
					else
					{
						$vast_video	=	($vast_type->Video)?$vast_type->Video:'';
						if(!empty($vast_video))
						{
							return TRUE;
						}
						else{
							if($vastupload)
							{
								$this->image_lib->delete_creative_in_tmp_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
							}
							$this->form_validation->set_message('xml_file_check', "XML File does not contain creative");
							return FALSE;
						}
					}					
				}
				else
				{
					$vast_type	=	($vast_ad->Wrapper)?$vast_ad->Wrapper:'';
					if(!empty($vast_type))
					{
						$vast_creative	=	($vast_type->Creatives)?$vast_type->Creatives:'';
						if(!empty($vast_creative))
						{
							return TRUE;
						}
					}
					else{
						if($vastupload)
						{
							$this->image_lib->delete_creative_in_tmp_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
						}
						$this->form_validation->set_message('xml_file_check', "XML File does not contain valid creative type");
						return FALSE;
					}
				}
			}
			else
			{
				if($vastupload)
				{
					$this->image_lib->delete_creative_in_tmp_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
				}
				$this->form_validation->set_message('xml_file_check', "Uploaded File is not valid xml");
				return FALSE;
			}
		}
		else{
			if($vastupload)
			{
				$this->image_lib->delete_creative_in_tmp_location(clean_data($this->post('tmp_vast_tag_upload_creative')));
			}
			$this->form_validation->set_message('xml_file_check', "Uploaded File is not valid xml");
			return FALSE;
		}
	}
	
}
