<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Utilities (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Utilities extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		
		$this->load->model('do_category');
		$this->load->model('do_country');
		$this->load->model('do_currency');		
		$this->load->model('do_campaign');
		$this->load->model('do_creative');
		$this->load->model('do_targeting');
		$this->load->model('do_template');
		$this->load->model('do_app_config');
		$this->load->model('do_currency');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
        $this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	
	function category_list_get()
	 {	 
	 
		 $category_id = $this->get('category_id');
		
		 $category=$this->do_category->fetch_category($category_id);

		 $this->response($category, 200); // 200 being the HTTP response code
	}

	/*
	 * 
	 * name: unknown
	 * @param
	 * @return
	 */
	 function categorylist_get()
	 {	 
		
		 $parent = $this->get('parent');
		
		 $category=$this->do_category->list_category($parent);

		 $this->response($category, 200); // 200 being the HTTP response code
		 
	 }	
	 
	 /*
	 * 
	 * name: unknown
	 * @param
	 * @return
	 */
	 function currencylist_get()
	 {		 
		 $currency=$this->do_currency->list_currency();	
		 
		  if($currency)
		 {
			 $this->response($currency, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>'currency could not be found'),404);
		 }
		 
	 }

	/*
	 * 
	 * name: countrylist_get
	 * @param
	 * @return
	 */
	 function countrylist_get()
	 {		 
		 $country=$this->do_country->list_country();	  
				
		  if($country)
		 {
			 $this->response($country, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>'country could not be found'),404);
		 }
		 
	 }  
	/*
	 * 
	 * name: template_get
	 * @param
	 * @return
	 */
	 function template_get()
	 {
		 
		 $country=$this->do_template->template_settings();	
		// print_r($country); die("ff");
		  if($country)
		 {
			 $this->response($country, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>'country could not be found'),404);
		 }
		 
	 }

	 function statelist_get()
	 {
		 $c_val = $this->get('country_val'); 
		 if(!empty($c_val))
		 {
			$country=$this->do_country->list_state($c_val);	
		 }
		 else
		 {
			 $country=$this->do_country->list_state();	
		 }
		  if($country)
		 {
			 $this->response($country, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>'country could not be found'),404);
		 }
		 
	 }

	 
	 function country_val_get()
	 { 
		 $country_value=$this->get('value');
		 $country=$this->do_country->fetch_country($country_value);	
		// print_r($country); die("ff");
		  if($country)
		 {
			 $this->response($country, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'country could not be found'),404);
		 }
		 
	 }
	 
	 
	public function fetch_job_category_get()
	{
		 $cat_list = $this->do_country->fetch_job_category();
		
		 $this->response($cat_list);
	}
	
	 
	 /*
	 * name: fetch_type_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the campaign type
	 * 
	 */
	public function fetch_type_get()
	{
		$type = $this->do_campaign->fetch_type();

		if($type)
		{
			$this->response($type, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No campaign type found'),200);
		}
	}
	 
	 /*
	 * name: fetch_target_browsers_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target browsers available
	 * 
	 */
	public function fetch_target_browsers_get()
	{
		$browser_options = $this->do_targeting->fetch_targ_options('browser');

		if($browser_options)
		{
			$this->response($browser_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No browsers available'),200);
		}
	}
	 /*
	 * name: fetch_target_os_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_os_get()
	{
		$os_options = $this->do_targeting->fetch_targ_options('os');

		if($os_options)
		{
			$this->response($os_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No os available'),200);
		}
	}
	 /*
	 * name: fetch_target_countries_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target countries available
	 * 
	 */
	public function fetch_target_countries_get()
	{
		$geo_options = $this->do_targeting->fetch_targ_options('geo');

		if($geo_options)
		{
			$this->response($geo_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No targeting countries available'),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_os_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_mobile_os_get()
	{
		$mobile_os_options = $this->do_targeting->fetch_targ_options('mobile_os');

		if($mobile_os_options)
		{
			$this->response($mobile_os_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No targeting countries available'),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_manu_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target manufacturers available
	 * 
	 */
	public function fetch_target_mobile_manu_get()
	{
		$mobile_manu_options = $this->do_targeting->fetch_targ_options('mobile_manu');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No targeting countries available'),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_telcom_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target telecom operators available available
	 * 
	 */
	public function fetch_target_mobile_telcom_get()
	{
		$mobile_manu_options = $this->do_targeting->fetch_targ_options('mobile_telecom');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No targeting countries available'),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_carrier_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target telecom operators available available in respective country
	 * 
	 */
	public function fetch_target_mobile_carrier_get()
	{
		$mobile_manu_options = $this->do_targeting->fetch_targ_options('mobile_carrier');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No targeting countries available'),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_capability_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target cabality available
	 * 
	 */
	public function fetch_target_mobile_capability_get()
	{
		$mobile_manu_options = $this->do_targeting->fetch_targ_options('mobile_capability');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No targeting countries available'),200);
		}
	}
	
	/*
	 * name: fetch_target_keyword_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target keyword available
	 * 
	 */
	 
	public function fetch_target_keyword_get()
	{
		
		$keyword_options = $this->do_targeting->fetch_targ_options('keyword');

		if($keyword_options)
		{
			
			$this->response($keyword_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_keyword_available')),200);
		}
	}
	
	/*
	 * name: fetch_advertiser_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the advertiser available
	 * 
	 */
	 
	public function fetch_advertiser_get()
	{
		$advertisers = $this->do_campaign->fetch_advertiser();
	
		if($advertisers)
		{
			$this->response($advertisers, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No advertisers available'),200);
		}
	}
	
	 /*
	 * name: currency_type_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the currency type
	 * 
	 */
	 public function currency_type_get()
	{
	
 


     $type = $this->do_currency->list_currency();
		if($type)
		{
			$this->response($type, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('currency_not_found')),200);
		}
		
	}
	/*
	 * name: ssplist_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the ssp type
	 * 
	 */
	public function ssplist_get()
	{
		 $agency_id     = $this->user_authentication->agency_id;
		$type = $this->do_campaign->fetch_ssp_type($agency_id);

		if($type)
		{
			$this->response($type, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('campaign_type_not_found')),200);
		}
	}
	
	/*
	 * 
	 * name: sizelist_get
	 * @param
	 * @return
	 */
	public function sizelist_get()
	{		 
		$size=$this->do_creative->list_bannersize();	
		 
		if($size)
		{
			$this->response($size, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'size could not be found'),404);
		}		 
	}
	
	/*
	* name: fetch_target_option_get
	* @param
	* @return:response array
	* 
	* In this method will fetch all the target available
	* 
	*/
	 
	public function fetch_target_option_get()
	{
		$targ_type	=	$this->get('type');
		
		$targ_options = $this->do_targeting->fetch_targ_options($targ_type);

		if($targ_options)
		{
			$this->response($targ_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No data'),200);
		}
	}	
	
	function careers_list_get()
	{		
		$jobid=$this->get('category');
		$career_options = $this->do_category->careerlist($jobid);

		if($career_options)
		{
			$this->response($career_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No data'),200);
		}
	}
	
	
	function fetch_country_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $country_value=$this->get('country_val');
		 $country=$this->do_country->fetch_country_name($campaign_id,$country_value);	
		 if($country)
		 {
			 $this->response($country, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'country could not be found'),404);
		 }
	 }
	 
	 function fetch_browser_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $browser_value=$this->get('browser_val');
		 $browser=$this->do_country->fetch_browser_name($campaign_id,$browser_value);	
		 if($browser)
		 {
			 $this->response($browser, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'browser could not be found'),404);
		 }
	 }
	 
	 function fetch_browser_language_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $lang_value=$this->get('lang_val');
		 $language=$this->do_country->fetch_browser_language_name($campaign_id,$lang_value);	
		 if($language)
		 {
			 $this->response($language, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'browser language could not be found'),404);
		 }
	 }
	 
	 function fetch_operating_system_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $os_value=$this->get('os_val');
		 $os=$this->do_country->fetch_os_name($campaign_id,$os_value);	
		 if($os)
		 {
			 $this->response($os, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'browser language could not be found'),404);
		 }
	 }
	 
	 function fetch_manufacture_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $manufacture_value=$this->get('manufacture_val');
		 $manufacture=$this->do_country->fetch_manu_name($campaign_id,$manufacture_value);	
		 if($manufacture)
		 {
			 $this->response($manufacture, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'Manufacturer could not be found'),404);
		 }
	 }
	 
	 function fetch_cap_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $capability_value=$this->get('capability_val');
		 $capability=$this->do_country->fetch_cap_name($campaign_id,$capability_value);	
		 if($capability)
		 {
			 $this->response($capability, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'capability could not be found'),404);
		 }
	 }
	 
	 function fetch_connection_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $connection_value=$this->get('connection_val');
		 $connection=$this->do_country->fetch_connection_name($campaign_id,$connection_value);	
		 if($connection)
		 {
			 $this->response($connection, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'connection could not be found'),404);
		 }
	 }
	 
	 function fetch_isp_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $isp_value=$this->get('isp_val');
		 $isp=$this->do_country->fetch_isp_name($campaign_id,$isp_value);	
		 if($isp)
		 {
			 $this->response($isp, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'isp could not be found'),404);
		 }
	 }
	 
	 function fetch_list_name_get()
	 {
		 $campaign_id=$this->get('campaign_id');
		 $blocklist_value=$this->get('blocklist_val');
		 $list=$this->do_country->fetch_adlist_name($campaign_id,$blocklist_value);	
		 if($list)
		 {
			 $this->response($list, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>'adlist could not be found'),404);
		 }
	 }
	 
	function fetch_job_get()
	{
		$id=$this->get('id');				
		$jobs=$this->do_category->joblist($id); 
       	if($jobs)
		{
			$this->response($jobs,200);
		}
		else
		{
		    $this->response(array('error'=>'No Data'),200);
		}
	}
	
	
	function fetch_capability_details_get()
	{
		$capability_value=$this->get('capability_val');
		$capability_val=$this->do_campaign->fetch_capability_details($capability_value); 
       	if($capability_val)
		{
			$this->response($capability_val,200);
		}
		else
		{
		    $this->response(array('error'=>'No Data'),200);
		}
	}
	
	function fetch_carrier_details_get()
	{
		$carrier_value=$this->get('carrier_detail');
		$carrier_val=$this->do_campaign->fetch_carrier_details($carrier_value); 
       	if($carrier_val)
		{
			$this->response($carrier_val,200);
		}
		else
		{
		    $this->response(array('error'=>'No Data'),200);
		}
	}
	
	function fetch_country_details_get()
	{
		$country_value=$this->get('country_detail');
		
		$country_val=$this->do_campaign->fetch_country_details($country_value); 
		
       	if($country_val)
		{
			$this->response($country_val,200);
		}
		else
		{
		    $this->response(array('error'=>'No Data'),200);
		}
	}
	
	
	function fetch_city_details_get()
	{
		$city_value=$this->get('city_detail');
		
		$city_val=$this->do_campaign->fetch_city_details($city_value); 
		
       	if($city_val)
		{
			$this->response($city_val,200);
		}
		else
		{
		    $this->response(array('error'=>'No Data'),200);
		}
	}
	
	
	
	
}
