<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * User
 *
 * Here We have developed services for user related activities
 * based on their roles
 *
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class User extends REST_Controller
{ 
	function __construct(){
		
		parent::__construct();
		$this->load->model('do_payments');
		$this->load->model('do_networks');
		$this->load->model('do_network_managers');
		$this->load->model('do_app_config');		
		$this->load->model('do_advertiser');
		$this->load->model('do_publisher');
		$this->load->model('do_site');		
		$this->load->model('do_jobs');
		$this->load->model('do_tracker');
		$this->load->model('do_email_check');
		$this->load->library('user_agent');
		$this->load->library('email');
		$this->load->library('upload');
		$this->load->helper('cookie');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('user_authentication');
		$this->load->library('notification');
		$this->load->model('do_message');
		$this->load->helper('my_twilio_helper');  // references library/my-twilio-helper.php
	}


	public function validate_post()
	{		
		$accid=get_session('account_id');
			
		if($accid==''){
				
		$role 		= 	array('ADVERTISER','TRAFFICKER','ADMIN','MANAGER');
		
		$password 	= 	base64_decode(str_replace(base64_encode($this->config->item('secure_key')),'',str_rot13(clean_data($this->post('password')))));
		
		if(clean_data($this->post('acc_type')) !='' and in_array(clean_data($this->post('acc_type')),$role))
		{
			switch(strtoupper(clean_data($this->post('acc_type'))))
			{
				case "ADMIN":
					
					$adminObj 	= 	$this->do_networks->validate_user(clean_data($this->post('uemail')),$password,clean_data($this->post('acc_type')));									
					$acc_id=$adminObj['account_id'];  
					$account_type=$adminObj['account_type'];  
					
					if($adminObj != FALSE)
					{
						if($adminObj['denied']==0)
						{
							// CREATE SESSIONS for ADMIN
							if($adminObj['default_manager']==1){
								
								//UPDATE LOGIN COUNT INFORMATION
								/*if(($_SERVER['REMOTE_ADDR']!='182.72.161.90')){
								 $this->update_login_count($adminObj);
								}*/
                           $first_name=$adminObj['first_name'];
                           $last_name=$adminObj['last_name'];
                           $denied=$adminObj['denied'];
                           unset($adminObj['first_name'],$adminObj['last_name'],$adminObj['denied']);
							set_session($adminObj['account_type'],$adminObj);
							
							$session=$this->session->all_userdata();
							
							$newdata = array(
											'Admin_session_id'  => $session['session_id'],
											'Admin_ip_address'  => $session['ip_address'],
											'Admin_user_agent'  => $session['user_agent'],
											'Admin_last_activity'=> $session['last_activity'],
											'Admin_user_data'  => $session['user_data'],
											'Admin_time_zone'  => $session['time_zone'],
											'Admin_Adgate_first_name'  => $first_name,
											'Admin_Adgate_last_name'  => $last_name,
											'Admin_Adgate_username'  => $session['directADS_username'],
											'Admin_Adgate_default_manager'  => $session['directADS_default_manager'],
											'Admin_Adgate_agencyid'  => $session['directADS_agencyid'],
											'Admin_Adgate_account_id'  => $session['directADS_account_id'],
											'Admin_Adgate_account_type'  => $session['directADS_account_type'],
											'Admin_Adgate_email'  => $session['directADS_email'],
											'Admin_Adgate_api_key'  => $session['directADS_api_key'],
											'Admin_Adgate_denied'  => $denied,
											'Admin_Adgate_default_account_id'  => $session['directADS_default_account_id'],
											'Admin_Adgate_default_advertiser_account_id'=>$session['directADS_default_advertiser_account_id'],
											'Admin_Adgate_default_advertiser_client_id'=> $session['directADS_default_advertiser_client_id'],
											'Admin_Adgate_time_zone'=> $session['directADS_time_zone'],
											'Admin_Adgate_cur_login_time'=> $session['directADS_cur_login_time'],
											'account_id'=>$acc_id,
											'account_type'=>$account_type
											);
																																	
							$insert=$this->do_networks->add_session($newdata);							
							
							$this->session->set_userdata('primary_id',$insert);	
																										
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:s");							
							$account_id=$adminObj['default_account_id'];
																				
							$module=ADMIN;
							$process=LOGIN;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
														
							$response 	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('admin/dashboard'),
												'msg'	 	=> 	'Login Success!..'
											);
							
							}
						
							/*Sets the cookies for remember password */
							$prod_name 	= 	$this->config->item('prod_name');
							$prod_name = str_replace(' ', '', $prod_name);
							if(clean_data($this->post('remember'))==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_admin_cookie_user_name',clean_data($this->post('uemail')),$expire,'/');
								setcookie($prod_name.'_admin_cookie_user_pwd',clean_data($this->post('password')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_admin_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_admin_cookie_user_pwd','',$expire,'/');	
							}
							$sus_email_id = $this->post('uemail');
							$sus_acc_type = $this->post('acc_type');
							$sus_acc_id = $adminObj['account_id'];
							$ips=$_SERVER['REMOTE_ADDR'];
							$check_ip= $this->suspicious_ip($ips,$sus_email_id,$sus_acc_type,$sus_acc_id,$adminObj);
							 
						}
						else
						{
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'The adminstrator account has been blocked temporarily.'
										 );
						}
					}
					else
					{
						     // CREATE SESSIONS for MANAGER and their user roles
							 $acc_type='manager';
							 $managerObj=$this->do_network_managers->validate_user(clean_data($this->post('uemail')),$password,$acc_type);
							 
							 if($managerObj!=FALSE && $managerObj['user_role_block']!=1 && $managerObj['user_status']!=0 && $managerObj['is_active']!=0)
							 {
							   set_session($managerObj['account_type'],$managerObj);
							  
								//UPDATE LOGIN COUNT INFORMATION
							  /*if($_SERVER['REMOTE_ADDR']!='182.72.161.90'){
							   $this->update_login_count($managerObj);
							   }*/
							   
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:s");							
							$account_id=$managerObj['account_id'];							
							
							$module=MANAGER;
							$process=LOGIN;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);							
							
							   
							$response 	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('admin/dashboard'),
												'msg'	 	=> 	'Login Success!..'
											);
							
							   $prod_name 	= 	$this->config->item('prod_name');
							   $prod_name = str_replace(' ', '', $prod_name);
							    /*Sets the cookies for remember password */
								if(clean_data($this->post('remember'))==1)
								{
									$expire	=	time()+60*60*24*30;
									setcookie($prod_name.'_admin_cookie_user_name',clean_data($this->post('uemail')),$expire,'/');
									setcookie($prod_name.'_admin_cookie_user_pwd',base64_encode(clean_data($this->post('upw'))),$expire,'/');
								}
								else
								{
									$expire	=	time()-60*60*24*30;
									setcookie($prod_name.'_admin_cookie_user_name','',$expire,'/');
									setcookie($prod_name.'_admin_cookie_user_pwd','',$expire,'/');	
								}
								
								$sus_email_id = $this->post('uemail');
								$sus_acc_type = $this->post('acc_type');
								$sus_acc_id = $managerObj['account_id'];
								$ips=$_SERVER['REMOTE_ADDR'];
								$check_ip= $this->suspicious_ip($ips,$sus_email_id,$sus_acc_type,$sus_acc_id,$managerObj);
							   
							  }
							  elseif($managerObj=='')
							  {
							    $response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'Your username or password is incorrect..!'
										 );
							  }
							  //IF USER A/c IS BLOCKED
							  elseif($managerObj['user_status']==0 || $managerObj['is_active']==0)
							  { 
							    $response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'Your account is currently blocked by admin...!'
										 );
							  }
							  //IF USER ROLE IS BLOCKED
							  elseif($managerObj['user_role_block']==1)
							  { 
							    $response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'Your role is currently blocked by admin...!'
										 );
							  }
							  
					   }				   
					
					$this->response($response, 200);
				break;
				
				case "MANAGER":
					
					$managerObj 	= 	$this->do_network_managers->validate_user(clean_data($this->post('uemail')),$password,clean_data($this->post('acc_type')));

					if($managerObj != FALSE)
					{
						if($managerObj['status']==1)
						{
							// CREATE SESSIONS for Advertiser
							set_session($managerObj['account_type'],$managerObj);
                            
                             //UPDATE LOGIN COUNT INFORMATION
							 /*if($_SERVER['REMOTE_ADDR']!='182.72.161.90'){
								$this->update_login_count($managerObj);
							  }*/
							  
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:s");							
							$account_id=$managerObj['account_id'];							
							
							$module=MANAGER;
							$process=LOGIN;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							  
							$response 	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('admin/dashboard'),
												'msg'	 	=> 	'Login Success!..'
											);
							
							$prod_name 	= 	$this->config->item('prod_name');
							$prod_name = str_replace(' ', '', $prod_name);
							/*Sets the cookies for remember password */
							if(clean_data($this->post('remember'))==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_manager_cookie_user_name',clean_data($this->post('uemail')),$expire,'/');
								setcookie($prod_name.'_manager_cookie_user_pwd',clean_data($this->post('password')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_manager_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_manager_cookie_user_pwd','',$expire,'/');	
							}
							
							$sus_email_id = $this->post('uemail');
							$sus_acc_type = $this->post('acc_type');
							$sus_acc_id = $managerObj['account_id'];
							$ips=$_SERVER['REMOTE_ADDR'];
							$check_ip= $this->suspicious_ip($ips,$sus_email_id,$sus_acc_type,$sus_acc_id,$managerObj);
						}
						else
						{
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'The manager account has been blocked temporarily by administrator.'
										 );
						}
					}
					else
					{
						$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'The username or password you entered is incorrect.'
										 );
					}
					
					$this->response($response, 200);
				break;
				
				case "ADVERTISER":
					
					$advObj 	=	$this->do_advertiser->validate_user(clean_data($this->post('uemail')),$password,clean_data($this->post('acc_type')));		
					$acc_email 	= clean_data($this->post('uemail'));
					$acc_type 	= clean_data($this->post('acc_type'));
					$security_adv 	=	$this->do_advertiser->validate_security_user($acc_email,$acc_type);
				
					if($advObj != FALSE)
					{
						
						if($advObj['denied']==0 && $advObj['is_active']==1)
						{
							$notification_enable	= $this->do_advertiser->app_config_notification();
					
							$advObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
							
							$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($advObj['user_id'],$acc_type);
							//$this->response($subaccount_role, 200);
							$advObj['subaccount_role_id']	= $subaccount_role['role_id'];
							
							$check_log		=	$this->do_app_config->fetch_activity_log($advObj['account_id']);
							$security		=	$this->do_app_config->fetch_security($advObj['account_id']);
							/*if($check_log)
							{
								$advObj['is_login_first']	=	0;
							}
							else
							{
								$advObj['is_login_first']	=	1;
							}*/
							
							
							//$security = 2;							
							$browseragent	=	$this->post('browser_useragent');
							$browser		=	$this->post('browser');
							$os				=	$this->post('os');
							$ip				=	$_SERVER['REMOTE_ADDR'];
							$date			=	date("Y-m-d h:i:s");							
							$account_id		=	$advObj['account_id'];	
							
							if($security == FALSE ){
								
								$check_logs		=	$this->do_app_config->fetch_history_activity_log($account_id,LOGIN);
								$os_founds 				= 	array_keys(array_column($check_logs, 'os'), $os);
								$ip_founds 				= 	array_keys(array_column($check_logs, 'ip'), $ip);
								$browser_founds 		= 	array_keys(array_column($check_logs, 'browser'), $browser);
								$browseragent_founds 	= 	array_keys(array_column($check_logs, 'useragent'), $browseragent);
								if($os_founds == FALSE || $ip_founds== FALSE || $browser_founds== FALSE || $browseragent_founds== FALSE ){	
									$res=$this->notification_login_mail($advObj,"ADVERTISER");
								}
							}
													
							$module=ADVERTISER;
							$process=LOGIN;
							//$yes=$this->security_log_checking($account_id,$ip,$os,$browser,$browseragent,$date,LOGIN,ADVERTISER);
							$yes=$this->security_log_checking($account_id,$ip,$os,$browser,$browseragent,$date,LOGIN,ADVERTISER,$acc_email);
							if($yes != FALSE){
								$response  	= 	array(
												'response' 	=> 	'verification_ok',
												//'redirect'	=>	site_url('advertiser/onetime_wizard'),
												'msg'	 	=> 	$yes
											);
							$this->response($response, 200);
							}
							//$this->session->set_userdata($advObj['account_type'],$advObj);
							/*$advObjs =array(
							"first_name"=>"sruthi",
							"last_name"=>"ps",
							"email"=>"sruthi.ps@dreamajax.com",
							"account_id"=>"136",
							"account_type"=>"ADVERTISER",
							"agencyid"=>"1","is_active"=>"1",
							"client_id"=>"24",
							"denied"=>"0",
							"api_key"=>"jqaRFEPYrDAG2WiHXCzB",
							"onetime_wizard"=>null,
							"network_account_id"=>"1",
							"user_id"=>"51",
							"parent_account_id"=>"0",
							"adv_pub_msg"=>"enable",
							"subaccount_role_id"=>null,
							"is_login_first"=>0);
							set_session($advObjs['account_type'],$advObjs);
							$this->response($advObjs, 200);*/
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							unset($advObj['first_name'],$advObj['last_name'],$advObj['denied'],$advObj['is_active']);
							// CREATE SESSIONS for Advertiser
							set_session($advObj['account_type'],$advObj);
							
							
							//Restrict onetime wizard for subaccount
							if($security_adv['onetime_wizard']==1)
							{
								$advObj['onetime_wizard']='1';
							}	
														
							if($advObj['onetime_wizard']!='1')
							{
								$response  	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('advertiser/onetime_wizard'),
												'msg'	 	=> 	'Login Success!..',
												'security'  =>  $yes
											);						
							}	
							else
							{
								$response  	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('advertiser/dashboard'),
												'msg'	 	=> 	'Login Success!..',
												'security'  =>  $yes
											);
							}						
							
							$prod_name 	= 	$this->config->item('prod_name');
							$prod_name = str_replace(' ', '', $prod_name);
							/*Sets the cookies for remember password */
							if(clean_data($this->post('remember'))==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_adv_cookie_user_name',clean_data($this->post('uemail')),$expire,'/');
								setcookie($prod_name.'_adv_cookie_user_pwd',clean_data($this->post('password')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_adv_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_adv_cookie_user_pwd','',$expire,'/');	
							}
							$sus_email_id = $this->post('uemail');
							$sus_acc_type = $this->post('acc_type');
							$sus_acc_id = $advObj['account_id'];
							$ips=$_SERVER['REMOTE_ADDR'];
							
							$check_ip= $this->suspicious_ip($ips,$sus_email_id,$sus_acc_type,$sus_acc_id,$advObj);
							
						}
						else
						{
							if($security_adv != FALSE){
								$this->notification_failed_loginmail($security_adv,"BLOCKED");
							}
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'The advertiser account has been blocked temporarily by administrator.',
											
										 );
						}

					
				}
				else{
					
						if($security_adv != FALSE){
							$this->notification_failed_loginmail($security_adv,"FAILED");	
						}
						$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'The username or password you entered is incorrect.'
										 );
				}
					$this->response($response, 200);
				break;
				
				case "TRAFFICKER":
					
					$pubObj 	= 	$this->do_publisher->validate_user(clean_data($this->post('uemail')),$password,clean_data($this->post('acc_type')));
					$acc_email 	= clean_data($this->post('uemail'));
					$acc_type 	= clean_data($this->post('acc_type'));
					$security_pub 	=	$this->do_publisher->validate_security_user($acc_email,$acc_type);
					
					if($pubObj != FALSE)
					{
						
						if($pubObj['denied']==0 && $pubObj['is_active']==1)
						{
							$notification_enable	= $this->do_advertiser->app_config_notification();
					
							$pubObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
					
							$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($pubObj['user_id'],$acc_type);
							
							$pubObj['subaccount_role_id']	= $subaccount_role['role_id'];
							
							$check_log		=	$this->do_app_config->fetch_activity_log($pubObj['account_id']);
							$security		=	$this->do_app_config->fetch_security($pubObj['account_id']);
							//UPDATE LOGIN COUNT INFORMATION
							/*if($_SERVER['REMOTE_ADDR']!='182.72.161.90'){
								$this->update_login_count($pubObj);
							}*/
							
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:s");							
							$account_id=$pubObj['account_id'];							
							
							if($security == FALSE ){
								$check_log		=	$this->do_app_config->fetch_history_activity_log($account_id,LOGIN);
								$os_founds 				= 	array_keys(array_column($check_log, 'os'), $os);
								$ip_founds 				= 	array_keys(array_column($check_log, 'ip'), $ip);
								$browser_founds 		= 	array_keys(array_column($check_log, 'browser'), $browser);
								$browseragent_founds 	= 	array_keys(array_column($check_log, 'useragent'), $browseragent);
								if($os_founds == FALSE || $ip_founds== FALSE || $browser_founds== FALSE || $browseragent_founds== FALSE ){
									$res=$this->notification_login_mail($pubObj,"TRAFFICKER");
								}
							}
							
							$module=PUBLISHER;
							$process=LOGIN;
							
							$yes=$this->security_log_checking($account_id,$ip,$os,$browser,$browseragent,$date,LOGIN,PUBLISHER,$acc_email);
							if($yes != FALSE){
								$response  	= 	array(
												'response' 	=> 	'verification_ok',
												//'redirect'	=>	site_url('advertiser/onetime_wizard'),
												'msg'	 	=> 	$yes
											);
							$this->response($response, 200);
							}
							
							$security		=	$this->do_app_config->fetch_security($account_id);
							
						
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							unset($pubObj['first_name'],$pubObj['last_name'],$pubObj['denied'],$pubObj['is_active'],$pubObj['is_active']);
							// CREATE SESSIONS for Publisher
							set_session($pubObj['account_type'],$pubObj);
							
							//Restrict onetime wizard for subaccount
							if($security_pub['onetime_wizard']==1 && $security_pub['onetime_wiz_date']==date("Y-m-d"))
							{
								$pubObj['onetime_wizard']='1';
							}
							
							if($pubObj['onetime_wizard']!='1')
							{
								$response  	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('publisher/onetime_wizard'),
												'msg'	 	=> 	'Login Success!..',
												'security'  =>  $yes
											);				
							
								$this->do_publisher->update_onetime_wiz($this->post('uemail'));                    
					                                  
																				
							}	
							else
							{
							
								$response 	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('publisher/dashboard'),
													'msg'	 	=> 	'Login Success!..',
													'security'  =>  $yes
												);											
							}
							
							$prod_name 	= 	$this->config->item('prod_name');
							$prod_name = str_replace(' ', '', $prod_name);
							/*Sets the cookies for remember password */
							if(clean_data($this->post('remember'))==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_pub_cookie_user_name',clean_data($this->post('uemail')),$expire,'/');
								setcookie($prod_name.'_pub_cookie_user_pwd',clean_data($this->post('password')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_pub_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_pub_cookie_user_pwd','',$expire,'/');	
							}
							
							$sus_email_id = $this->post('uemail');
							$sus_acc_type = $this->post('acc_type');
							$sus_acc_id = $pubObj['account_id'];
							$ips=$_SERVER['REMOTE_ADDR'];
							$check_ip= $this->suspicious_ip($ips,$sus_email_id,$sus_acc_type,$sus_acc_id,$pubObj);
						}
						
						else
						{
							if($security_pub != FALSE){
								$this->notification_failed_loginmail($security_pub,"BLOCKED");
							}
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'The publisher account has been blocked temporarily by administrator.'
										 );
						}
						
					}
					else
					{
						if($security_pub != FALSE){
							$this->notification_failed_loginmail($security_pub,"FAILED");	
						}
						$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'The username or password you entered is incorrect.'
										 );
					}
					$this->response($response, 200);
				break;
			}

		}
		else
		{
			$this->response(array('error' => 'Invalid User Type'), 200);
		}

	}
	else
	{
		if(get_session('account_type')=='TRAFFICKER')
		{
			$redirect_url=site_url('publisher/dashboard');
		}
		elseif(get_session('account_type')=='ADVERTISER')
		{
			$redirect_url=site_url('advertiser/dashboard');
		}
		elseif(get_session('account_type')=='ADMIN')
		{
			$redirect_url=site_url('admin/dashboard');
		}			
		$response 	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	$redirect_url,
												);
		$this->response($response, 200);	
	}

	}


   	/*
	* 
	* name: create
	* @param :
	* @return : adv / pub details
	* 
    */
	public function create($advObj){

		if($advObj != FALSE){

			if($advObj['account_type'] == "ADVERTISER"){
				$advObj = $this->do_advertiser->add($advObj);
			}else if($advObj['account_type'] === "TRAFFICKER"){
				$advObj = $this->do_publisher->add($advObj);
			}

			// Send Mail to Advertiser & Manager

			if($advObj != FALSE){
				return $advObj;
			}
			else
			{
				return FALSE;
			}

		}
	}
		
	public function email_approve_get(){

		$temp_user_id = $this->get('user_id');
		$verification_code = $this->get('email_verification_code');
		$tempObj = $this->do_advertiser->get_temp_user($temp_user_id,$verification_code);

		if($tempObj != FALSE){

			$advObj = $this->create($tempObj);
			$account_type=$advObj['account_type'];
			$user_email=$advObj['email'];
			$password=$advObj['password'];
			$user_name=$advObj['first_name']." ".$advObj['last_name'];
			$pixel_data 	= 	array(
									"clientid"			=>	clean_data($advObj['client_id']),
									"trackername"		=>	clean_data('default_tracker'),
									"pixel_type" 		=> 	clean_data('html'),
									"pixel_category"	=>	clean_data('sale'),
									"protocol"			=>	clean_data('http'),
									"pixel_goal" 		=> 	clean_data('1'),
									"status"			=>	clean_data('1'),
									"appendcode"		=>	clean_data($advObj['first_name'].'_default_tracker'),
									"updated"			=>	date('Y-m-d H:i:s'),
									"admarket"			=>	'',
									"destination_url"	=>	''
								);
			$pixel_data_admarket 	= 	$pixel_data;
			$pixel_data_admarket["admarket"]='1';
		    $success=$this->do_advertiser->remove_temp_user($temp_user_id);

			// SEND APPROVAL EMAIL to USER
			$agency_id	=	$this->user_authentication->agency_id;
			$result=$this->do_networks->agency_owner_details($agency_id);
			if($agency_id ==1)
			{			
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				if($account_type=="ADVERTISER")
				{
					$type="ADV_LOGIN_CREDENTIAL";
					//DAC094 pixel tracker adding
					$pixel_add		=	$this->do_tracker->add_tracker($pixel_data,$campaign_id);			
					$pixel_add_admarket =	$this->do_tracker->add_tracker($pixel_data_admarket,$campaign_id);
				}
				if($account_type=="PUBLISHER")
				{
					$type="PUB_LOGIN_CREDENTIAL";
				}
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
					"subject" 		=> "Login Credentials",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"password"		=> $password								
					);			
				send_mail($type,$from,$to,$mail_content);	
				if($success)
				{
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' => 'error',
									'msg' =>  "User account does not exists in our package."
									);

					$this->response( $error, 200);
				}			
			}
			else
			{
				// IF NOT NETWORK ADMIN SEND BCC
				$network_admin=$this->do_networks->get_network_details();
				$bcc		   = $network_admin['email'];
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
					
				if($account_type=="ADVERTISER")
				{
					$type="ADV_LOGIN_CREDENTIAL";
				}
				if($account_type=="PUBLISHER")
				{
					$type="PUB_LOGIN_CREDENTIAL";
				}
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
					"subject" 		=> "Login Credentials",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"password"		=> $password								
					);
				$attachement = "";				
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
				if($success)
				{
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' => 'error',
									'msg' =>  "User account does not exists in our package."
									);

					$this->response( $error, 200);
				}
			}		
			
	}
		else
		{
			$error = array(
							'response' => 'error',
							'msg' =>  "User account does not exists in our package."
							);

			$this->response( $error, 200);
		}
	}
	
/*Contact us
	 * 
	 * 
	 * */
	 public function contactus_post(){
		
		
		$this->form_validation->set_rules('name','Name', 'trim|required');
		$this->form_validation->set_rules('cemail', 'Email','trim|required|is_email');
		$this->form_validation->set_rules('subject', 'Subject','trim|required');
		$this->form_validation->set_rules('message', 'Message','trim|required');
	
		$this->form_validation->set_rules('g-recaptcha-response', 'recaptcha','trim|required');          
                                  
 		if($this->form_validation->run() === FALSE)
		{
			
			$error_msg = $this->form_validation->error_array();

			 

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
	
		else{
		
			$result=$this->do_networks->get_network_details();			
			
			$admin_name    	= 	$result['firstname']." ".$result['lastname'];			
			
			$admin_email   	= 	$result['email'];
			 
			$to				=	$admin_email;
			
			$from			=	clean_data($this->input->post("cemail"));
			
			$from_name		=	clean_data($this->input->post("name"));
			
			$subject		=	clean_data($this->input->post("subject"));
			 
			$message		=	clean_data($this->input->post("message"));
			 
			$type     	   	= 	"CONTACT_US";			
			
			//If Admin change his password then it will works
			$attachement	=	'';
			$mail_content	=	array(
									"subject"		=> 	$subject,
									"message"		=> 	$message,
									"email"			=>	$from,									
									"to_name"		=> 	$admin_name,
									"from_name"		=>	$from_name
								);
			send_mail($type,$from,$to,$mail_content,$attachement,$from,$subject); 
			
			$success	=	array(
								'response'	=>	'ok',
								'msg'		=>	'Contact information sent successfully to administrator.'
							);	
			$this->response($success,200);	  
			
		} 
			
	}
		/*
   * 
   * name: careers_list_get
   * @param : none
   * @return :slected  browser details.
   * 
   */
	public function careers_list_get(){
		
	   $id = $this->get('id');
	 
	   if($id){
	   $careers_list = $this->do_jobs->fetch_careers_select($id);
	   $this->response($careers_list);
       }
	}
  	public function job_listing_get()
	{
	 	 $job_listing = $this->do_jobs->job_listing();
	 	 $this->response($job_listing,200);
	
	}

	
		public function fetch_careers_get()
	{
	 	 $careers_list = $this->do_jobs->fetch_careers();
		 $this->response($careers_list,200);
	}	
	
	public function apply_job_post()   
	{ 
		$this->form_validation->set_rules('first_name','First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name','trim|required');
		$this->form_validation->set_rules('email', 'Email','trim|required|valid_email|callback_email_check');
		$this->form_validation->set_rules('country', 'Country','trim|required');
		$this->form_validation->set_rules('city', 'City','trim|required');
		$this->form_validation->set_rules('postal_code', 'postal code','trim|required');
		$this->form_validation->set_rules('mob_no', 'Mobile Number','trim|required');
		$this->form_validation->set_rules('biodata', 'biodata','trim|required');
		    
        
		$obj		=	array(
									'first_name'		=>	clean_data($this->post('first_name')),
									'last_name'			=>	clean_data($this->post('last_name')),
									'email'				=>	clean_data($this->post('email')),
									'country'			=>	clean_data($this->post('country')),
									'city'				=>	clean_data($this->post('city')),
									'postal_code'		=>	clean_data($this->post('postal_code')),
									'phone'				=>	clean_data($this->post('mob_no')),
									'resume'			=>	clean_data($this->post('tmp_file_upload_url')),
									'title'				=>  clean_data($this->post('job_title')),
									'created_date'		=>	date('Y-m-d H:i:s')						
									);
								
			/*$blob_data=array(
									"filename"=>clean_data($this->post('tmp_file_upload')),
									"content_type"=>clean_data($this->post('tmp_file_upload_content_type')),
									"url"=>clean_data($this->post('tmp_file_upload_url')),
									"t_stamp"=>clean_data(date('Y:m:d :H:i:s')),
									);
			//On sucess move the web creative from tmp location to original location
			$is_file_moved=$this->image_lib->move_file_to_original_location(clean_data($this->post('tmp_file_upload')));*/
			
								
			$job_add = 	$this->do_jobs->apply_jobs($obj);
				
			//Sending Email to admin
				if($job_add !== FALSE)
				{				
				$result=$this->do_networks->get_network_details();
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];							
				$to_email	   = $admin_email;	
				$user_email	   = clean_data($this->input->post("email"));		 
				$subject	   = clean_data($this->input->post("job_title"));
				$message 	   =  "Hi ".$admin_name.","."<br/>";			 
				$message.=  "You have received an job application form for ".$this->post('job_title')."<br/>";			
				$message.=  "Here with attached the resume with all details <br/><br/>";			
				$message.=  "Thanks & Regards<br/>";			
				$message.= $this->post('first_name').$this->post('last_name');
				$config['protocol'] 	= "sendmail";			 
				$config['wordwrap'] 	=  TRUE;					 
				$config['mailtype'] 	= 'html';			 
				$config['charset']		= 'UTF-8'; 	
				$this->email->initialize($config);
				$this->email->clear();
				$this->email->from($user_email);				
				$this->email->to($to_email); 
				$this->email->attach(clean_data($this->post('tmp_file_upload_url')));				
				$this->email->subject($subject);			       
				$this->email->message($message);  
				$this->email->send();				
				}
			
			$success	=	array(
								'response'	=>	'ok',
								'redirect'	=>	site_url('site/careers'),
								'msg'		=>	'Application has been sent successfully to administrator.'
							);	
			$this->response($success,200);	  
			
			//$this->session->set_flashdata('success', 'Your application has been accepted!!! ');
			//redirect("site/apply_job");
		
	}	
	
    public function signup_post(){
		
		$this->form_validation->set_rules('ufirstname','First Name', 'trim|required');
		$this->form_validation->set_rules('ulastname', 'Last Name','trim|required');
		$this->form_validation->set_rules('uemail', 'Email','trim|required|valid_email|callback_email_check|is_unique[djax_temp_user.email],trim|required|is_unique[rv_users.email_address]');
	
		//$this->form_validation->set_rules('uemail', 'Email address', 'required|trim|valid_email|callback_email_check');
		$this->form_validation->set_rules('upw', 'Password','trim|required');
		$this->form_validation->set_rules('uconfirm_password', 'Confirm Password','trim|required|matches[upw]');
		$this->form_validation->set_rules('account_type', 'User Type','trim|required');   
		$this->form_validation->set_rules('g-recaptcha-response', 'recaptcha','trim|required');          
		
		$this->form_validation->set_rules('sec_qus', 'Security Questions','trim|required');          
		$this->form_validation->set_rules('security_answer', 'Security Answer','trim|required');          
		//$this->response($this->post(),200);
                                  
 		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();

			 //$error_msg 	= transform_errors_to_array($this->form_validation->error_array());

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{
			
			
			// SEND EMAIL To Administrator and Users			
			
			$result=$this->do_networks->get_network_details();
			
			$admin_name    = $result['firstname']." ".$result['lastname'];
			$admin_email   = $result['email'];
			$adv_approval_type = $result['approval_type'];
			//DAC107
			$pub_approval_type = $result['pub_approval_type'];
			
			$acc_type =clean_data($this->post('account_type'));
			
			if($acc_type == "ADVERTISER")
			{
				if($adv_approval_type=="EMAIL")
					{
						
						$activation_code = md5(time());
						$verify=1;
					
					}
				else
					{
						$activation_code = '';
						$verify=0;
					}
				
			}
			if($acc_type =="TRAFFICKER")
			{
				if($pub_approval_type == "EMAIL")
					{
						$activation_code = md5(time());
						$verify=1;
					}
					else
					{
						$activation_code = '';
						$verify=0;
					}
				
				
			}
			
			/*Platform */
			$platform=$this->input->post('platform_select');
			$os_type=$this->input->post('os_select_type');
			$mobile_url_ext=$this->post('mobile_url_ext');
			$app_url=$this->post('app_url');
			$application_name=$this->post('application_name');
			$web_url_ext=$this->post('web_url_ext');
			$site_url = $this->input->post('site_url');
			
			$count 	= 	count($web_url_ext); 
			$web_url = array();
			
			if($count>0)
			{
				for($i=0;$i<$count;$i++)
				{
					$web_url[]= $web_url_ext[$i].$site_url[$i];	
					
				}
			}
								
			$mob_count 	= 	count($mobile_url_ext); 
			$mobile_url	=	array();
			
			if($mob_count>0)
			{
				for($i=0;$i<$mob_count;$i++)
				{
					
					$os[]=$os_type[$i];
					$mobile_url[]= $mobile_url_ext[$i].$app_url[$i];
					$mobile_app_name[]=$application_name[$i];
				}
			}
			
			$website_url = array();		
			for($j=0;$j<count($platform);$j++)
			{	
				$plat_form=explode("_",$platform[$j]);
				$k=$plat_form[0];
				if($k=="website")
				{
					$website_url[$j]=$web_url[$j];
				}
				else if($k=="mobile")
				{
					$mob_os[$j]=$os[$j];
					$mob_url[$j]=$mobile_url[$j];
					$mob_app[$j]=$mobile_app_name[$j];
				}
				
			}
			$mobileno=clean_data($this->post('mob_no'));
			$accounttype=clean_data($this->post('account_type'));
			$phone_verify=clean_data($this->post('phone_verify'));
			if($phone_verify == 'enable' && $accounttype=='ADVERTISER'){	
				$phone=clean_data($this->post('mob_no'));
		
				$verifyCode = rand(100000, 999999);
				$sms_verify=0;							//$phone = $security[0]['mobile_no'];
				$twilioSid = $this->config->item('twilio_AccountSid');
				$twilioToken = $this->config->item('twilio_AuthToken');
				$twiliono = $this->config->item('twilio_FromNumber');
											
				//$client = new Services_Twilio($twilioSid, $twilioToken);
				$service = get_twilio_service();
				// send sms with verifcation code 
				$responses = $service->account->sms_messages->create($twiliono, $phone, 'Your Mobile Verification code ' . $verifyCode);		 
			}
			else{
					$verifyCode =0;
					$sms_verify=1;
			}
			
			if(!empty($website_url))
			{
				$default_url=$web_url[0];
				
			}
			else
			{
				$default_url=$mobile_url[0];				
			}		
						 
			$userObj = array(
							"first_name"			=>	clean_data($this->post('ufirstname')),
							"last_name"				=>	clean_data($this->post('ulastname')),
							"email"					=>	clean_data($this->post('uemail')),
							"agency_id"				=>	clean_data($this->post('agencyid')),
							"password"				=>	clean_data($this->post('upw')),
							"budget"				=>	clean_data($this->post('budget')),
							"mob_no"				=>	clean_data($this->post('mob_no')),
							"skype_id"				=>	clean_data($this->post('skype_id')),
							"additional_info"		=>	clean_data($this->post('additional_info')),
							"account_type"			=>	clean_data($this->post('account_type')),
							"created_date"			=>	date("Y-m-d H:i:s"),
							"email_verification_code"=>	clean_data($activation_code),
							"email_verified" 		=>	$verify,
							"site_url"              =>  $default_url,
							"referral_id" 			=>	clean_data($this->post('referral_id')),
							"security_id"			=>	$this->post('sec_qus'),							
							"security_answer"		=>	$this->post('security_answer'),
							"sms_code"				=> $verifyCode,
							"sms_verify"			=> $sms_verify								
						);
						
			if($userObj['account_type']=='TRAFFICKER' || $userObj['account_type']=='ADVERTISER')
			{
				$temp_user_id=$this->do_advertiser->create_temp_user($userObj);
															
				if($userObj['account_type']=='TRAFFICKER')
				{
					$this->do_publisher->create_temp_url($temp_user_id,$platform,$website_url,$mob_os,$mob_url,$mob_app,$this->post('agencyid'),$this->post('uemail'));
				}
			
				if($userObj['account_type']=='ADVERTISER')
				{
					$budget_data	=	array(
											"clientname"		=>	clean_data($this->post('ufirstname')).' '.clean_data($this->post('ulastname')),
											"email"				=>	clean_data($this->post('uemail')),
											"account_type"		=>	clean_data($this->post('account_type')),
											"bank_name" 		=> 	clean_data($this->post('bank_name')),
											"bank_address"		=> 	clean_data($this->post('bank_address')),
											"bank_acc_no"		=> 	clean_data($this->post('bank_acc_no')),
											"payment_type"		=>	'wire',
											"page_type"			=>	'signup',
											"amount"			=>	clean_data($this->post('budget')),
											"temp_user_id"		=>	$temp_user_id
										);
										
					$payment_id 	= 	$this->do_payments->add_fund($budget_data,$temp_user_id);
				}
			}
			
			$user_name	   = $userObj['first_name']. " ". $userObj['last_name'] ;
			
			$user_email    = $userObj['email'];
			
			$user_account_type=$userObj['account_type'];
			
					
			if($adv_approval_type=="EMAIL" && $sms_verify==1)
			{
				/* Send mail to advertiser/Publisher for activate their account */	
				
				if($user_account_type == "ADVERTISER")
				{
					$type 	= "ADV_APPROVE_EMAIL";
				}
				else
				{
					$type 	= "PUB_APPROVE_EMAIL";
				}
							
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
				"subject" 		=> "Activate your Account",
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"temp_user_id"  => $temp_user_id,
				"activation_code" =>$activation_code													
				);
											
				send_mail($type,$from,$to,$mail_content);			
				
			}
			else if($pub_approval_type == "EMAIL")
			{
				if($user_account_type == "ADVERTISER")
				{
					$type 	= "ADV_APPROVE_EMAIL";
				}
				else
				{
					$type 	= "PUB_APPROVE_EMAIL";
				}
							
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
				"subject" 		=> "Activate your Account",
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"temp_user_id"  => $temp_user_id,
				"activation_code" =>$activation_code													
				);
											
				send_mail($type,$from,$to,$mail_content);		
			}
			else
			{
				/* Send mail to Advertiser/Publisher for registration success  -Start  */
				
				if($user_account_type == "ADVERTISER")
				{
					$type 	= "ADV_REG_SUCCESS";
				}
				else
				{
					$type 	= "PUB_REG_SUCCESS";
				}
								
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
					"subject" 		=> "Registration Success",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name										
					);		
					$sms_notify	= $this->do_advertiser->app_config_notification();
					
					if($sms_notify['0']['welcome_mail']	== 'yes')	
					{						
					send_mail($type,$from,$to,$mail_content);
					}
				/* Send mail to Advertiser/Publisher -End  */	
					
					
				/* Send mail to Admin for Activate User Account  - Start*/	
				
					$type   ="ADMIN_APPROVE_EMAIL";
					$from 	=  $user_email;
					$to  	=  $admin_email;			
					$mail_content=array(
					"subject" 		=> "Approve the User Acocunt",
					"to_name" 		=> $admin_name,				
					"from_name"		=> $user_name										
					);			
					send_mail($type,$from,$to,$mail_content);
					
					/* Send mail to Admin  - End  */
						
			}
			
            if($user_account_type=='TRAFFICKER')
			{
			   $user_account_type='PUBLISHER';
			}
			$success = array(
							'response' 	=> 	'ok',
							'redirect'	=>	site_url('user_registration/success/'.strtolower($user_account_type)),
							'msg'	 	=> 	'Account has been created successfully.',
							'temp_user_id'=>$temp_user_id,
							'account_type'=>$user_account_type
			);

			$this->response($success, 200);  
		}

	}
	
	/*Email Check
	 * 
	 * 
	 * */ 
	
	function reg_email_check()
	{
		$email		=	strtolower(clean_data($this->post('uemail')));
		$count 		= 	$this->do_email_check->reg_email_check($email);
		
		if($count>0)
		{
			$this->form_validation->set_message('reg_email_check', 'Email ID must contain a unique value.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	

	/**
       * 
       * Mails the new password for users, who have forgotten their password.
       
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	

	public function forgot_password_post(){

		if($this->form_validation->run('user_forgot_password') === FALSE)
		{
		
			$error_msg = $this->form_validation->error_array();

			 //$error_msg 	= transform_errors_to_array($this->form_validation->error_array());

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}else{
		
			$role = array('ADVERTISER','PUBLISHER','ADMIN','MANAGER');
			
			// SENT EMAIL To User 	
			
			$result=$this->do_networks->get_network_details();			
				
			$admin_name    = $result['firstname']." ".$result['lastname'];
			
			$admin_email   = $result['email'];	
			
			$email_id = clean_data($this->post('uemail'));
			

			if($this->post('acc_type') !='' and in_array($this->post('acc_type'),$role)){

				switch(strtoupper(clean_data($this->post('acc_type')))){
					case "ADVERTISER":
						
						$advObj = $this->do_advertiser->validate_email(clean_data($this->post('uemail')),clean_data($this->post('acc_type')));
						
						if($advObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							
							
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:sa");							
							$account_id=$advObj->accountid;
							$process=FORGET_PASSWORD;
							$module=ADVERTISER;
							
							$yes=$this->security_log_checking($account_id,$ip,$os,$browser,$browseragent,$date,FORGET_PASSWORD,ADVERTISER);
							if($yes != FALSE){
								$response  	= 	array(
												'response' 	=> 	'verification_ok',
												//'redirect'	=>	site_url('advertiser/onetime_wizard'),
												'msg'	 	=> 	$yes
											);
							$this->response($response, 200);
							}
							if($advObj->parent_account_id)
							{
								$advObj->new_password =  $this->update_new_password($advObj->accountid,false,$advObj->user_id);
							}
							else{
							$advObj->new_password =  $this->update_new_password($advObj->accountid);
							}
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
							
							$user_name	   =  $advObj->name;
			
							$user_email    =  $advObj->email;	
							$admin_email	=	$this->do_networks->get_network_details();
							$from 			=  $admin_email['email'];
							$admin_name 	= $admin_email['firstname']." ".$admin_email['lastname'];
							
							$type   ="ADV_FORGET_PASSWORD";
							//$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> "Advertiser Forget password",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $advObj->new_password 								
							);			
						    send_mail($type,$from,$to,$mail_content); 
							 
							/*$message_data		=	array(
										'sender_id'		=>	ADMIN_ID,
										'receiver_id'	=>	$advObj->accountid,
										'subject'		=>	'Advertiser - Forgot Password',
										'content'		=> 	'Please find the new password and Login. Login Id:'.$pubObj->email.'    Password: '.$advObj->new_password,
										'account_type'	=>	"ADVERTISER",
										'status'		=>	'1',
										'date'			=>	date('Y-m-d H:i:s')
										);
						 
							$user = $this->do_message->get_profile(ADMIN_ID); 
							$type_details	=	array(
								//'msg_type'		=> $message,
								'type'			=> $type,
								'string'		=> "forget_pwd",
								'column_name'	=> "account_settings",
								'bcc'=>$bcc
									);
							$receiver =  (array) $advObj;
							
							$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);*/
							
							if($advObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								'redirect'=>site_url('user_login/'.strtolower(clean_data($this->post('acc_type')))),
								'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower(clean_data($this->post('acc_type')))),
								'msg'	 => 'Oops! Password is not updated'
							);	
							}	
						
						

						}
						else
						{
								$response = array(
										'response' => 'error',
										'msg' =>  'Entered email is not a registered advertiser email'
									 );
						}
						$this->response($response, 200);
					break;
					
					case "PUBLISHER":
						

							$pubObj = $this->do_advertiser->validate_email(clean_data($this->post('uemail')),clean_data($this->post('acc_type')));

						if($pubObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							
							
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:sa");							
							$account_id=$pubObj->accountid;
							$process=FORGET_PASSWORD;
							$module=PUBLISHER;
							$yes=$this->security_log_checking($account_id,$ip,$os,$browser,$browseragent,$date,FORGET_PASSWORD,PUBLISHER);
							if($yes != FALSE){
								$response  	= 	array(
												'response' 	=> 	'verification_ok',
												//'redirect'	=>	site_url('advertiser/onetime_wizard'),
												'msg'	 	=> 	$yes
											);
							$this->response($response, 200);
							}
							
							if($pubObj->parent_account_id)
							{						
							$pubObj->new_password =  $this->update_new_password($pubObj->accountid,false,$pubObj->user_id);
							}
							else{
							$pubObj->new_password =  $this->update_new_password($pubObj->accountid);
							}
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);							
							// SENDS THE EMAIL TO CORRESPONDING PUBLISHER
							
							$user_name	   =  $pubObj->name;
			
							$user_email    =  $pubObj->email;	
							$admin_email	=	$this->do_networks->get_network_details();
							$from 			=  $admin_email['email'];
							$admin_name 	= $admin_email['firstname']." ".$admin_email['lastname'];
							
							$type   ="PUB_FORGET_PASSWORD";
							//$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> "Publisher Forget password",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $pubObj->new_password 								
							);			
							 send_mail($type,$from,$to,$mail_content);
							/*$user = $this->do_message->get_profile(ADMIN_ID); 
							$type_details	=	array(
								//'msg_type'		=> $message,
								'type'			=> $type,
								'string'		=> "forget_pwd",
								'column_name'	=> "account_settings",
								'bcc'=>$bcc
									);
							
							$message_data		=	array(
										'sender_id'		=>	ADMIN_ID,
										'receiver_id'	=>	$pubObj->accountid,
										'subject'		=>	'Publisher - Forgot Password',
										'content'		=> 	'Please find the new password and Login. Login Id:'.$pubObj->email.'    Password: '.$pubObj->new_password,
										'account_type'	=>	"TRAFFICKER",
										'status'		=>	'1',
										'date'			=>	date('Y-m-d H:i:s')
										); 
										
							$receiver =  (array) $pubObj;
							
							$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);*/
							  
							if($pubObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								#'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower(clean_data($this->post('acc_type')))),
								'msg'	 => 'Oops! Password is not updated'
							);	
							}	

                    	}
						else
						{
								$response = array(
										'response' => 'error',
										'msg' =>  'Entered email is not a registered publisher email'
									 );
						}
						$this->response($response, 200);
					break;
				case "ADMIN":
						
							$adminObj = $this->do_advertiser->validate_email(clean_data($this->post('uemail')),clean_data($this->post('acc_type')));

						if($adminObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							$adminObj->new_password =  $this->update_new_password_networks($adminObj->userid);
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:sa");							
							$account_id=$adminObj->accountid;
							$process=FORGET_PASSWORD;
							$module=ADMIN;
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							// SENDS THE EMAIL TO CORRESPONDING ADMIN
							
							$first_name	   =  $adminObj->fname;
							
							#$last_name	   =  $adminObj->lname;
			
							$user_email    =  $adminObj->email;	
							
							$type   ="ADMIN_FORGET_PASSWORD";
							$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> "Forget password",
							"to_name" 		=> $first_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $adminObj->new_password 								
							);			
							send_mail($type,$from,$to,$mail_content);
							
							
							if($adminObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								#'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower(clean_data($this->post('acc_type')))),
								'msg'	 => 'Oops! Password is not updated'
							);	
							}	

                    	}
						else
						{
								$response = array(
										'response' => 'error',
										'msg' =>  'Entered email is not a registered admin / manager email'
									 );
						}
						$this->response($response, 200);
					break;
					
					case "MANAGER":
						
							$adminObj = $this->do_advertiser->validate_email(clean_data($this->post('uemail')),clean_data($this->post('acc_type')));
                           
						if($adminObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							$adminObj->new_password =  $this->update_new_password($adminObj->user_id,clean_data($this->post('acc_type')));
							
							$browseragent=$this->post('browser_useragent');
							$browser=$this->post('browser');
							$os=$this->post('os');
							$ip=$_SERVER['REMOTE_ADDR'];
							$date=date("Y-m-d h:i:sa");							
							$account_id=$adminObj->accountid;
							$process=FORGET_PASSWORD;
							$module=MANAGER;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							// SENDS THE EMAIL TO CORRESPONDING ADMIN
							
							$first_name	   =  $adminObj->fname;
							
							#$last_name	   =  $adminObj->lname;
			
							$user_email    =  $adminObj->email;	
							
							$type   ="MANAGER_FORGET_PASSWORD";
							$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> "Manager Forget password",
							"to_name" 		=> $first_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $adminObj->new_password 								
							);			
							send_mail($type,$from,$to,$mail_content);
														
							if($adminObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								#'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => 'Password is send successfully to your email. Please find the new password and Login.'
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower(clean_data($this->post('acc_type')))),
								'msg'	 => 'Oops! PAssword is not updated'
							);	
							}	

                    	}
						else
						{
								$response = array(
										'response' => 'error',
										'msg' =>  'Entered email is not a registered admin email'
									 );
						}
						$this->response($response, 200);
					break;
				}

			}
			else
			{
				$this->response(array('error' => 'Invalid User Type'), 200);
			}
		}	
	}
	
	
	/** ONLY FOR ADV AND PUB
       * Generates the new password and update the new password
       * 
       * @param $account_id Account id of the publisher (or) advertiser
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	public function update_new_password($account_id ='',$acc_type=FALSE,$userid=FALSE)
	{
		if(!empty($account_id))
		{
		
			$this->load->helper('string');
		
			$new_pass = random_string('alnum',8);
			if($acc_type==FALSE){
			$result = $this->do_advertiser->update_new_password($account_id,$new_pass,$userid);
			}
			if($result)
			{
				return $new_pass;
			}else{
				return FALSE;	
			}
		}else{
			return FALSE;	
		}		
	}
	
	
	/** ONLY FOR ADMIN / MANAGERS
       * Generates the new password and update the new password
       * @param $account_id Account id of the publisher (or) advertiser
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	public function update_new_password_networks($user_id)
	{
		if(!empty($user_id))
		{
			$this->load->helper('string');
		    $new_pass = random_string('alnum',8);
			$result = $this->do_advertiser->update_new_password_networks($user_id,$new_pass);
			if($result)
			{
				return $new_pass;
			}else{
				return FALSE;	
			}
		}else{
			return FALSE;	
		}		
	}
	
	public function profile_info_post(){
		if(clean_data($this->post('account_id')) AND clean_data($this->post('account_type'))){
		
				switch(strtoupper(clean_data($this->post('account_type')))){
					case "ADVERTISER":
						$user_info = $this->do_advertiser->get_profile(clean_data($this->post('account_id')));
						$response = array(
								'response' => 'ok',
								'user'	 => $user_info
								);
						$this->response($response);
						break;	
					case "TRAFFICKER":
						$user_info = $this->do_publisher->get_profile(clean_data($this->post('account_id')));
						$response = array(
								'response' => 'ok',
								'user'	 => $user_info
								);
						$this->response($response);
						break;			
					case "ADMIN":
						$user_info = $this->do_networks->get_profile(clean_data($this->post('account_id')));
						$response = array(
								'response' => 'ok',
								'user'	 => $user_info
								);
						$this->response($response);
						break;			
				}
		}
		else
		{
			$this->response(array('error' => 'Invalid Parameters'), 200);
		}
	}
	
	public function get_agency_id_get()
	{
		
		$agency_id=$this->do_networks->get_agency();
		if($agency_id)
			$this->response($agency_id,200);
	}
	
	/*UPDATE LOGIN DETAILS*/
	public function update_login_count($login_details)
	{
		if($login_details['account_type']=='TRAFFICKER')
		{
			$agency_id=$login_details['agency_id'];
		}
		else{
			$agency_id=$login_details['agencyid']; 
		} 
	   
		$manager_name=$this->do_networks->agency_owner_details($agency_id);

		if(isset($login_details['last_name']))
		{
			$name=$login_details['last_name'];
		}
		else
		{
			$name='';
		}
	   
	   //Get City,Country 
		if($_SERVER['REMOTE_ADDR']!='::1')
		{
			$ip=$_SERVER['REMOTE_ADDR'];
			/*
			$details = json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
			$city=$details->city;
			if(empty($city)){
			$city='unknown';
			}
			$state=$details->region;
			if(empty($state)){
			$city='unknown';
			}
			$country=$details->country;
			if(empty($country)){
			$city='unknown';
			}*/
			$user_details=array( 'account_id'=>$login_details['account_id'],
								'net_name'=>$manager_name['name'],
								'f_name'=>$login_details['first_name'],
								'l_name'=>$name,
								'email_id'=>clean_data($this->post('uemail')),
								'login_time'=>date("Y-m-d H:i:s"),
								'ip_address'=>$_SERVER['REMOTE_ADDR']
							  );
			//$this->do_networks->update_login_details($user_details);

			// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
	    
			$result=$this->do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];
			$admin_email   = $result['email'];	
			
			$type   ="DEMO_VIEWERS";
			$from 	=  $admin_email;
			$to  	=  "info@dreamajax.com";			
		
			$mail_content=array(
			"subject" 		=> "Current demo viewer",
			"to_name" 		=> "",				
			"from_name"		=> $admin_name,
			"viewer_name"	=> $login_details['first_name'].''.$name,	
			"Login_email_id"=> clean_data($this->post('uemail')),
			"ip_address" =>  $_SERVER['REMOTE_ADDR'],
			/*"city"      =>  $city,
			"state"     =>  $state,
			"country"     => $country
			*/
			);			
			//send_mail($type,$from,$to,$mail_content);
		}
	}
	
	/*UPDATE LOGIN-OUT DETAILS*/
	public function logout_info_post()
    {
		$acc_id=clean_data($this->post('account_id'));
		if($acc_id)
		{
			$data=array('logout_time'=>date("Y-m-d H:i:s"),'account_id'=>$acc_id);
			//$res=$this->do_networks->update_logout_details($data);
			// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
			$result=$this->do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];
			$admin_email   = $result['email'];	
				
			$type   ="DEMO_VIEWERS";
			$from 	=  $admin_email;
			$to  	=  "info@dreamajax.com";			

			$mail_content=array(
				"subject" 		=> "Current demo viewer",
				"to_name" 		=> "",				
				"from_name"		=> $admin_name,
				"viewer_name"	=> $res['f_name'].''.$res['l_name'],	
				"Login_email_id"=> $res['email_id'],
				"ip_address" =>  $_SERVER['REMOTE_ADDR'],
				"time_interval"=> $res['interval']
				);			
			//send_mail($type,$from,$to,$mail_content);
		}
	}
	
	/*
	 * name: get_guest_adv_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch a guest advertiser details.
	 * 
	 */
	 
	public function get_guest_adv_get()
	{
		$advertiser = 	$this->do_advertiser->fetch_guest();			
		
		if($advertiser)
		{			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	/*
	 * name: get_admin_api_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch a admin api details.
	 * 
	 */
	 
	public function get_admin_api_get()
	{
		$advertiser = 	$this->do_networks->fetch_admin_api();			
		
		if($advertiser)
		{			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}	
	/*
	 * name: getResponse
	 * @param
	 * @return:response 
	 * 
	 * In this method google captcha response will be fetched
	 * 
	 */
	
	function getResponse($str)
    {
    $secret_key="6Ld13AwTAAAAAPucSPBYn-dRlOnBnJH-UTatGxcD";
    $ip_user=$this->input->ip_address();
    $url="https://www.google.com/recaptcha/api/siteverify?secret=".$secret_key."&response=".$str."&remoteip=".$ip_user;    
    $user_agent='Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERAGENT,$user_agent);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $data = curl_exec($ch);
    curl_close($ch);
    $status= json_decode($data,true);
    if($status['success'])
     {    
      return true;
        }    
        else
        {
         $this->session->set_flashdata('recaptcha', 'incorrect captcha');
        return false;
        }
    }
    
    
	/*
	 * name: get_valid_campaign_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch a guest campaign details.
	 * 
	 */
	 
	public function get_valid_campaign_get()
	{
		$campaign_id=	$this->get('campaign_id');
		$campaign = 	$this->do_advertiser->fetch_guest_campaign($campaign_id);			
		
		if($campaign)
		{			
			$this->response($campaign,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}	
//DAC 107
public function attach_file_to_tmp_location_post()
	{
		if($_FILES['attachment'])
		{
			$attachment		=	array(
								'file_name' => 	$_FILES['attachment']['name'],
								'tmp_name' 	=> 	$_FILES['attachment']['tmp_name'], 
								);
					
			$tmp_attach	=	$this->image_lib->move_attach_file_to_tmp_location($attachment);

			if($tmp_attach)
			{
				$success=	array(
								'response' 	=> 	$tmp_attach['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('site/apply_job'),
								'msg'	 	=> 	'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
	}
	
	public function attach_image_to_tmp_location_post()
	{
		if($_FILES['attachment'])
		{
			$attachment		=	array(
								'file_name' => 	$_FILES['attachment']['name'],
								'tmp_name' 	=> 	$_FILES['attachment']['tmp_name'], 
								);
					
			$tmp_attach	=	$this->image_lib->move_attach_image_to_tmp_location($attachment);
			
			if($tmp_attach)
			{
				$success=	array(
								'response' 	=> 	$tmp_attach['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('admin/messages/messages'),
								'msg'	 	=> 	'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
	}
	public function delete_a_tmp_attach_post()
	{
		$tmp_attach_name	=	clean_data($this->post('attach_name'));
		
		if($tmp_attach_name)
		{
			$is_tmp_attach	=	$this->image_lib->delete_attach_in_tmp_location($tmp_attach_name);

			if($is_tmp_attach)
			{
				$success 	= 	array(
								'response' 	=> 	'success',
								'msg'	 	=> 	'Temporary attachment deleted'
								);
				$this->response($success, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Unable to delete the temporary attachment file'
								);
				$this->response($error, 200);
			}
		}
		else
		{
			$error 	= 	array(
							'response' 	=> 	'error',
							'msg'	 	=> 	'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	
	public function get_invoice_no_get()
	{		
		$where		=	array(
							'invoice_no'	=>	$this->get('invoice_no'),
							'campaign_id'	=>	$this->get('campaign_id')
						);
						
		$invoice	=	$this->do_networks->get_bitpay_invoice($where);
		if($invoice)
		{
			$this->response($invoice,200);
		}
	}
	
	public function get_admin_email_get()
	{		
		$user_id	=	$this->get('user_id');
		$email		=	$this->do_networks->get_user_role_info($user_id);
		if($email)
			$this->response($email,200);
	}

	function suspicious_ip($ips,$sus_email_id,$sus_acc_type,$sus_acc_id,$userObjs)
	{ 
		$return_value = $this->do_networks->check_ip_address($ips);
		 
		if($return_value !=='old')
		{
			//$prof=$this->suspicious_profile_info_post($sus_acc_id,$sus_acc_type);
			$result=$this->do_networks->get_network_details();		
			$user = $this->do_message->get_profile(ADMIN_ID);
			$account_id=$userObjs['account_id'];
			$network_id	=	$this->do_message->fetch_admin_network_id();
			$mail_type = "USER_SUSPICIOUS_LOGIN";
			 
			$message  = $this->default_configurations->get('message_type');	
			$type_details		=	array(
				'msg_type'		=> $message,
				'type'			=> "USER_SUSPICIOUS_LOGIN",
				'string'		=> 'susp_login',
				'column_name'	=> 'login_settings'
				);
				$message_data		=	array(
					'sender_id'		=>	ADMIN_ID,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Suspicious - Login',
					'content'		=> 	'Account logged-in from unknow ip:'.$ips,
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	$sus_acc_type,
					'status'		=>	'1',
					'network_id'	=>	$network_id,									
					'date'			=>	date('Y-m-d H:i:s')
					);
					
			if($sus_acc_type=="ADMIN")
			{
				$login_path='admin';
			}										
			if($sus_acc_type=="ADVERTISER")
			{
				$login_path='advertiser';
			}									
			if($sus_acc_type=="TRAFFICKER")									
			{
				$login_path='publisher';
			}
			$admin_name   =ucfirst($user['first_name']).' '.ucfirst($user['last_name']);	
			$admin_email   =$user['email'];
			$user_email    =$sus_email_id;
			$user_name     =$reciever['name'];
			$from 		   = $admin_email;
			$to  		   = $sus_email_id;		
										
				$mail_content=array(
						"subject" 	   => "Suspicious Login",
						"to_name" 	   => ucfirst($userObjs['first_name']).' '.ucfirst($userObjs['last_name']),				
						"from_name"	   => $admin_name,
						"ip_address"   => $ips,
						"path_login"   =>$login_path,
						"ip"   =>$ips,
						);
				 
			if($sus_acc_type=="ADMIN")	
			{
				 
				send_mail($mail_type,$sus_email_id,$sus_email_id,$mail_content);
				$this->do_networks->send_messages($message_data);	
			}	 
			else
			{	
				$dat = $this->notification->new_mail($message_data,$user,$userObjs,$type_details,$mail_content);
			}
		}
	}
	
	public function sms_verification_code_post(){
		
			$account_id = $this->post('_account_id');
			$account_type = $this->post('_account_type');
			$verification_code=$this->post('verification_code');
			$os=$this->post('os');
			$ip=$this->post('ip');
			$browser=$this->post('browser');
			$browseragent=$this->post('browseragent');
			$date=$this->post('date');
			$action_type=$this->post('action_type');
			if($account_id){
				$success_message=$this->do_advertiser->sms_verification($account_id,$verification_code);
					
				if($success_message == 1){
						if($action_type == LOGIN){
							$process=LOGIN;
							$module=$account_type;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
					if($account_type == ADVERTISER){
						$advObj 	=	$this->do_advertiser->validate_verified_user($account_id);
						$notification_enable	= $this->do_advertiser->app_config_notification();
					
							$advObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
							
							$check_log		=	$this->do_app_config->fetch_activity_log($advObj['account_id']);
							
							if($check_log)
							{
								$advObj['is_login_first']	=	0;
							}
							else
							{
								$advObj['is_login_first']	=	1;
							}									
							// CREATE SESSIONS for Advertiser
							set_session($advObj['account_type'],$advObj);
						$redirecturl = site_url('advertiser/dashboard') ;
						if($advObj['onetime_wizard']!='1')
								{
									$response  	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('advertiser/onetime_wizard'),
													'msg'	 	=> 	'Login Success!..'
												);						
								}	
								else
								{
									$response  	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('advertiser/dashboard'),
													'msg'	 	=> 	'Login Success!..'
												);
								}
								$this->response( $response, 200);
					}
					else if($account_type == PUBLISHER){
						$pubObj 	= 	$this->do_publisher->validate_verified_user($account_id);
						$notification_enable	= $this->do_advertiser->app_config_notification();
					
							$pubObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
							set_session($pubObj['account_type'],$pubObj);
						$redirecturl = site_url('publisher/dashboard') ;
						if($advObj['onetime_wizard']!='1')
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/onetime_wizard'),
														'msg'	 	=> 	'Login Success!..'
													);						
									}	
									else
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/dashboard'),
														'msg'	 	=> 	'Login Success!..'
													);
									}
								$this->response( $response, 200);
					}
				
								/*$success 	= 	array(
												'response'	=> 'ok',
												'msg'=> $success_message,
												'redirect'=> $redirecturl,
												);
						
								$this->response( $success, 200);*/
					}
					else if($action_type == FORGET_PASSWORD){
							$process=FORGET_PASSWORD;
							$module=$account_type;
					
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							
							if($account_type == ADVERTISER){
								$advObj 	=	$this->do_advertiser->validate_verified_user($account_id);
							$advObj['new_password'] =  $this->update_new_password($advObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
									
									$user_name	   =  $advObj['first_name']."".$advObj['last_name'];
					
									$user_email    =  $advObj['email'];	
									
									$type   ="ADV_FORGET_PASSWORD";
									$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Advertiser Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $advObj['new_password'] 								
									);	
									$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$advObj['account_id'],
												'subject'		=>	'Advertiser - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$advObj['email'].'    Password: '.$advObj['new_password'],
												'account_type'	=>	"ADVERTISER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												);
								 
									$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									$receiver =  (array) $advObj;
									
									$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);
									if($advObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							else if($account_type == PUBLISHER){
								$pubObj 	=	$this->do_publisher->validate_verified_user($account_id);
								
							$pubObj['new_password'] =  $this->update_new_password($pubObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING PUBLISHER
									
									$user_name	   =  $pubObj['first_name']."".$pubObj['last_name'];
					
									$user_email    =   $pubObj['email'];		
									
									$type   ="PUB_FORGET_PASSWORD";
									$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Publisher Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $pubObj['new_password']								
									);			
									 
									$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									
									$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$pubObj['account_id'],
												'subject'		=>	'Publisher - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$pubObj['email'].'    Password: '.$pubObj['new_password'],
												'account_type'	=>	"TRAFFICKER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												); 
												
									$receiver =  (array) $pubObj;
									
									$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);
									if($pubObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							
					}
				}
				else{
					$error = array(
							'response' => 'error',
							'msg'	 => 'Please enter correct verification code'
					);
			
				$this->response( $error, 200);
				}
			}
			else{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
				$this->response( $error, 200);
			}
	}
	public function backup_verification_code_post(){
		
			$account_id = $this->post('account_id');
			$account_type = $this->post('account_type');
			$security_answer=$this->post('security_answer');
			$os=$this->post('back_os');
			$ip=$this->post('back_ip');
			$browser=$this->post('back_browser');
			$browseragent=$this->post('back_browseragent');
			$date=$this->post('back_date');
			$action_type=$this->post('back_action_type');
			if($account_id){
				$success_message=$this->do_advertiser->backup_verification($account_id,$security_answer);
					
				if($success_message == 1){
					if($action_type == LOGIN){
							$process=LOGIN;
							$module=$account_type;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
					if($account_type == ADVERTISER){
						
						$advObj 	=	$this->do_advertiser->validate_verified_user($account_id);
						$notification_enable	= $this->do_advertiser->app_config_notification();
					
							$advObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
							
							$check_log		=	$this->do_app_config->fetch_activity_log($advObj['account_id']);
							
							if($check_log)
							{
								$advObj['is_login_first']	=	0;
							}
							else
							{
								$advObj['is_login_first']	=	1;
							}									
							// CREATE SESSIONS for Advertiser
							set_session($advObj['account_type'],$advObj);
						$redirecturl = site_url('advertiser/dashboard') ;
						if($advObj['onetime_wizard']!='1')
								{
									$response  	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('advertiser/onetime_wizard'),
													'msg'	 	=> 	'Login Success!..'
												);						
								}	
								else
								{
									$response  	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('advertiser/dashboard'),
													'msg'	 	=> 	'Login Success!..'
												);
								}
								$this->response( $response, 200);
					}
					else if($account_type == PUBLISHER){
						$pubObj 	= 	$this->do_publisher->validate_verified_user($account_id);
						$notification_enable	= $this->do_advertiser->app_config_notification();
						
							$pubObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
							set_session($pubObj['account_type'],$pubObj);
						$redirecturl = site_url('publisher/dashboard') ;
						if($advObj['onetime_wizard']!='1')
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/onetime_wizard'),
														'msg'	 	=> 	'Login Success!..'
													);						
									}	
									else
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/dashboard'),
														'msg'	 	=> 	'Login Success!..'
													);
									}
								$this->response( $response, 200);
					}
					
						/*$success 	= 	array(
										'response'	=> 'ok',
										'msg'=> $success_message,
										'redirect'=> $redirecturl,
										);
				
						$this->response( $success, 200);*/
					}
					else if($action_type == FORGET_PASSWORD){
							$process=FORGET_PASSWORD;
							$module=$account_type;
					
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							
							if($account_type == ADVERTISER){
								$advObj 	=	$this->do_advertiser->validate_verified_user($account_id);
							$advObj['new_password'] =  $this->update_new_password($advObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
									
									$user_name	   =  $advObj['first_name']."".$advObj['last_name'];
					
									$user_email    =  $advObj['email'];	
									
									$type   ="ADV_FORGET_PASSWORD";
									$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Advertiser Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $advObj['new_password'] 								
									);	
									$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$advObj['account_id'],
												'subject'		=>	'Advertiser - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$advObj['email'].'    Password: '.$advObj['new_password'],
												'account_type'	=>	"ADVERTISER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												);
								 
									$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									$receiver =  (array) $advObj;
									
									$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);
									if($advObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							else if($account_type == PUBLISHER){
								$pubObj 	=	$this->do_publisher->validate_verified_user($account_id);
								
							$pubObj['new_password'] =  $this->update_new_password($pubObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING PUBLISHER
									
									$user_name	   =  $pubObj['first_name']."".$pubObj['last_name'];
					
									$user_email    =   $pubObj['email'];		
									
									$type   ="PUB_FORGET_PASSWORD";
									$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Publisher Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $pubObj['new_password']								
									);			
									 
									$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									
									$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$pubObj['account_id'],
												'subject'		=>	'Publisher - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$pubObj['email'].'    Password: '.$pubObj['new_password'],
												'account_type'	=>	"TRAFFICKER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												); 
												
									$receiver =  (array) $pubObj;
									
									$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);
									if($pubObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							
					}
				}
				else{
					$error = array(
							'response' => 'error',
							'msg'	 => 'Please enter correct answer'
					);
			
				$this->response( $error, 200);
				}
			}
			else{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
				$this->response( $error, 200);
			}
	}
	
	
	
	public function resend_verify_code_post(){
		
			$account_id = $this->post('accountid');
			$account_type = $this->post('account_type');
			$type=$this->post('type');
			$mobileno=$this->post('mobileno');
			$email=$this->post('email');
			if($account_id){
				
				//if($account_type == 'ADVERTISER'){
				//$advObj 	=	$this->do_advertiser->validate_verified_user($account_id);
				
				if($type == 'sms'){
					
					$verifyCode = rand(100000, 999999);
											$phone = $mobileno;
											$twilioSid = $this->config->item('twilio_AccountSid');
											$twilioToken = $this->config->item('twilio_AuthToken');
											$twiliono = $this->config->item('twilio_FromNumber');
											$this->do_app_config->sms_verify($verifyCode,$account_id);
										 //$client = new Services_Twilio($twilioSid, $twilioToken);
										$service = get_twilio_service();
										// send sms with verifcation code 
										$responses = $service->account->sms_messages->create($twiliono, $phone, 'Your Login Verification code ' . $verifyCode);
										//$redirect_url=site_url('user_login/verification_code');	
										$response 	= 	array(
													'response' 	=> 	'ok',
													//'redirect'	=>	$redirect_url,
													'accountid'	=>	$account_id,
													'accounttype'	=>	"ADVERTISER",
													'mobileno'=>$phone,
													'type'=>"sms",
													'msg'=>"Resend successfully to : ".$phone
												);
										$this->response($response, 200);
										
				}
				else if($type == 'mail'){
					
					$verifyCode = rand(100000, 999999);
											$phone = $mobileno;
											
											$this->do_app_config->sms_verify($verifyCode,$account_id);
												$type="ADV_VERIFY_CODE";
											
											$admin_email=$this->do_networks->get_network_details();
											
											$from 	=  $admin_email['email'];
											$admin_name = $admin_email['firstname']." ".$admin_email['lastname'];
											$to  	=  $advObj['email'];
											$user_name = $advObj['first_name']." ".$advObj['last_name'];
											$user_email=$advObj['email'];
											$password=$advObj['password'];
											$account_type= $advObj['account_type'];
											$to_mail = $email;
											$mail_content=array(
												"subject" 		=> "Your Login Verification Code",
												"to_name" 		=> $user_name,				
												"from_name"		=> $admin_name,
												"email"  		=> $user_email,
												"verification_code"		=> $verifyCode,
												"password" =>	$password,
												"account_type" 	=>	$account_type					
												);			
											send_mail($type,$from,$to_mail,$mail_content);
										//$redirect_url=site_url('user_login/verification_code');	
										$response 	= 	array(
													'response' 	=> 	'ok',
													//'redirect'	=>	$redirect_url,
													'accountid'	=>	$account_id,
													'accounttype'	=>	"ADVERTISER",
													'email'	=>	$to_mail,
													'type'=>"mail",
													'msg'=>"Resend successfully to : ".$to_mail
												);
										$this->response($response, 200);
				}
				else{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
				$this->response( $error, 200);
				}
			}
			else{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
				$this->response( $error, 200);
			}
	}
	
	function activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process)
	{
				/* Activity Log for login/forget password - Start*/				
								
					$accntid=	$account_id;		
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$browseragent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				);				
																									
				$this->do_app_config->activity_log($accntid,$activity_log);
				/* Activity Log for login/forget password - End*/			
		
	}
	function notification_login_mail($advObj,$account_type)
	{
		
		$ip				=	$_SERVER['REMOTE_ADDR'];
								$reciever 		= $advObj; 
								$account_id		=	$advObj['account_id'];
								$account_type	=	$advObj['account_type'];
								$country		= 	$this->default_configurations->ip_info($ip, "Country");
								$login_path='user_login/lock_account/'.$account_id.'/'.$account_type;
													
			if($account_type=="ADVERTISER")
			{
				$login_path='user_login/lock_account/'.$account_id.'/'.$account_type;
			}									
			if($account_type=="TRAFFICKER")									
			{
				$login_path='user_login/lock_account/'.$account_id.'/'.$account_type;
			}
								$result	=	$this->do_networks->get_network_details();
								$admin_name    	= 	$result['name'];			
								$admin_email	= 	$result['email'];	
								$admin_id   	= 	$result['account_id'];
			
								//$user = $this->do_message->get_profile($admin_id);
								$result['first_name'] = $result['firstname'];
								unset($result['firstname']);
								$result['last_name'] = $result['lastname'];
								unset($result['lastname']);
								 $user =$result;
								$type='SECURITY_SUSPICIOUS_LOGIN';
								$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "security_disable",
										'column_name'	=> "login_security"
										);
			
							$mail_content=array(
									"to_name"	=>	ucfirst($advObj['first_name']).' '.ucfirst($advObj['last_name']),
									"email"		=>	$advObj['email'],
									"from_name"	=>	$user['first_name'].' '.$user['last_name'],
									'type'		=> 	$type,
									"subject" 		=> "Suspicious Login Detected",
									"ip_address"   => $ip,
									"path_login"   =>$login_path,
									"account_type" 	=>	$account_type,
									"country" 	=>	$country,
									 
								);
								$content = "<b>ip_address :</b>".clean_data($ip)."<br><b>path_login :</b>".clean_data($login_path)."<br><b>account_type :</b>".clean_data($account_type)."<br><b>country :</b>".clean_data($country);
								$message_data		=	array(
									'sender_id'		=>	$admin_id,
									'receiver_id'	=>	$account_id,
									'subject'		=>	'Suspicious Login Detected - Two Factor Disabled',
									'content'		=> 	$content,
									'account_type'	=>	$account_type,
									'status'		=>	'1',
									
									'date'			=>	date('Y-m-d H:i:s')
									);		
							
								$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
					
		return TRUE;
							
		
	}
	function fetch_advertiser_details_get()
	{
		
		$account_id 	= 	$this->get('account_id');
		$account_type 	= 	$this->get('account_type');
		if($account_type == 'ADVERTISER'){
		$notify_list 	= 	$this->do_advertiser->validate_verified_user($account_id);
		}else{
		$notify_list 	= 	$this->do_publisher->validate_verified_user($account_id);
		}
		if($notify_list)
		{
			$this->response($notify_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
		
	}
	function fetch_admin_details_get()
	{
		
		//$account_id 	= 	$this->get('account_id');
		
		$admin_list 	= 	$this->do_networks->get_network_details();
		
		if($admin_list)
		{
			$this->response($admin_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
		
	}
	
	function notification_failed_loginmail($advObj,$login_type)
	{
		
		$ip				=	$_SERVER['REMOTE_ADDR'];
								$reciever 		= $advObj; 
								$account_id		=	$advObj['account_id'];
								$account_type	=	$advObj['account_type'];
								$country		= 	$this->default_configurations->ip_info($ip, "Country");
								$login_path='user_login/lock_account/'.$account_id.'/'.$account_type;
								
								$result	=	$this->do_networks->get_network_details();
								$admin_name    	= 	$result['name'];			
								$admin_email	= 	$result['email'];	
								$admin_id   	= 	$result['account_id'];
			
								//$user = $this->do_message->get_profile($admin_id);
								$result['first_name'] = $result['firstname'];
								unset($result['firstname']);
								$result['last_name'] = $result['lastname'];
								unset($result['lastname']);
								$user =$result; 
								$type='SECURITY_FAILED_LOGIN';
								if($login_type == "FAILED"){
									$type_string = "password_incorrect";
								}
								else if($login_type == "BLOCKED"){
									$type_string = "blocked_user";
								}
								$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> $type_string,
										'column_name'	=> "login_security"
										);
			
							$mail_content=array(
									"to_name"	=>	ucfirst($advObj['first_name']).' '.ucfirst($advObj['last_name']),
									"email"		=>	$advObj['email'],
									"from_name"	=>	$user['first_name'].' '.$user['last_name'],
									'type'		=> 	$type,
									"subject" 		=>$login_type." LOGIN NOTIFICATION",
									"ip_address"   => $ip,
									"login_type"   => $login_type,
									"account_type" 	=>	$account_type,
									"country" 	=>	$country,
									 
								);
								$content = "<b>ip_address :</b>".clean_data($ip)."<br><b>account_type :</b>".clean_data($account_type)."<br><b>country :</b>".clean_data($country);
								$message_data		=	array(
									'sender_id'		=>	$admin_id,
									'receiver_id'	=>	$account_id,
									'subject'		=>	$login_type." LOGIN NOTIFICATION",
									'content'		=> 	$content,
									'account_type'	=>	$account_type,
									'status'		=>	'1',
									
									'date'			=>	date('Y-m-d H:i:s')
									);		
							
								$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
								return true;
	}
	
	function security_log_checking($account_id,$ip,$os,$browser,$browseragent,$date,$action_type,$accnt_type,$email_addr=false){
		$check_log		=	$this->do_app_config->fetch_history_activity_log($account_id,$action_type);
		$security		=	$this->do_app_config->fetch_security($account_id);
		$ip_found 		= array_search($ip, array_column($check_log, 'ip'));
		$browser_found 	= array_search($browser, array_column($check_log, 'browser'));
		$os_found 		= array_search($os, array_column($check_log, 'os'));
		$browseragent_found = array_search($browseragent, array_column($check_log, 'useragent'));
						
		$os_founds 				= 	array_keys(array_column($check_log, 'os'), $os);
		$ip_founds 				= 	array_keys(array_column($check_log, 'ip'), $ip);
		$browser_founds 		= 	array_keys(array_column($check_log, 'browser'), $browser);
		$browseragent_founds 	= 	array_keys(array_column($check_log, 'useragent'), $browseragent);					
		$ips 			= 	explode('.', $ip);
		$last_ip 		= 	array_pop($ips);
		$first_ips 		= 	implode('.', $ips);
		
		foreach ($check_log as $check_logs) {
			if (strpos($check_logs['ip'],$first_ips) !== false) {
			$subnet_founds	=	$check_logs['ip'];
			}
		}
		
		if($security != FALSE ){
		
		if((strpos($security[0]['security'],'1')!== FALSE && $ip_founds == FALSE) || (strpos($security[0]['security'],'2')!== FALSE && $subnet_founds == FALSE) || (strpos($security[0]['security'],'3')!== FALSE && $browser_founds == FALSE) || (strpos($security[0]['security'],'4')!== FALSE && $browseragent_founds == FALSE) || (strpos($security[0]['security'],'5')!== FALSE && $os_founds == FALSE) ){						
								$redirect_url=site_url('user_login/verification_code');
								$security_question=$this->do_advertiser->get_question($security[0]['security_question_id']);
								$response 	= 	array(
													//'response' 	=> 	'errors',
													'redirect'	=>	$redirect_url,
													'accountid'	=>	$account_id,
													'accounttype'	=>	$accnt_type,
													'mobileno'=>$security[0]['mobile_no'],
													'email'	=>	$security[0]['email'],
													'emailid'	=>	$email_addr,
													'question' => $security_question[0]['question'],
													'type'=>"sms",
													'browser'=>$browser,
													'browseragent'=>$browseragent,
													'os'=>$os,
													'ip'=>$ip,
													'date'=>$date,
													'action_type'=>$action_type
												);
												return $response;
									
								}
								else{
										return FALSE;
									}
							
							}
	}
	
	
	public function verification_method_post(){
		
			$account_id = $this->post('_account_id');
			$account_type = $this->post('_account_type');
			$email_addr = $this->post('_emailid');
			$verification_code=$this->post('verification_code');
			$verification_method=$this->post('verification_method');
			$os=$this->post('os');
			$ip=$this->post('ip');
			$browser=$this->post('browser');
			$browseragent=$this->post('browseragent');
			$date=$this->post('date');
			$action_type=$this->post('action_type');
				
			if($account_id){
				$security		=	$this->do_app_config->fetch_security($account_id);
				if($verification_method=='security_question'){
					$success_message=$this->do_advertiser->backup_verification($account_id,$verification_code);
					
					if($success_message == 1){
						if($action_type == LOGIN){
							$process=LOGIN;
							$module=$account_type;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							if($account_type == ADVERTISER){
									$advObj 	=	$this->do_advertiser->validate_verified_user($account_id,$email_addr);
									$notification_enable	= $this->do_advertiser->app_config_notification();
					
									//$advObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
									$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($advObj['user_id'],$account_type);
							
									$advObj['subaccount_role_id']	= $subaccount_role['role_id'];
									$check_log		=	$this->do_app_config->fetch_activity_log($advObj['account_id']);
							
									/*if($check_log)
									{
										$advObj['is_login_first']	=	0;
									}
									else
									{
										$advObj['is_login_first']	=	1;
									}*/									
									// CREATE SESSIONS for Advertiser
									set_session($advObj['account_type'],$advObj);
									$redirecturl = site_url('advertiser/dashboard') ;
									if(get_session('subaccount_role_id'))
									{
										$advObj['onetime_wizard']='1';
									}
									if($advObj['onetime_wizard']!='1')
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('advertiser/onetime_wizard'),
														'msg'	 	=> 	'Login Success!..'
													);						
									}	
									else
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('advertiser/dashboard'),
														'msg'	 	=> 	'Login Success!..'
													);
									}
									$this->response( $response, 200);
							}
							else if($account_type == PUBLISHER){
									$pubObj 	= 	$this->do_publisher->validate_verified_user($account_id,$email_addr);
									//$this->response( $pubObj,200);
									$notification_enable	= $this->do_advertiser->app_config_notification();
					
									//$pubObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
									
									$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($pubObj['user_id'],TRAFFICKER);
							
									$pubObj['subaccount_role_id']	= $subaccount_role['role_id'];
									
									set_session($pubObj['account_type'],$pubObj);
									$redirecturl = site_url('publisher/dashboard');
									
									if(get_session('subaccount_role_id'))
									{
										$pubObj['onetime_wizard']='1';
									}
									
									if($pubObj['onetime_wizard']!='1')
										{
											$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/onetime_wizard'),
														'msg'	 	=> 	'Login Success!..'
													);						
										}	
										else
										{
											$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/dashboard'),
														'msg'	 	=> 	'Login Success!..'
													);
										}
									$this->response( $response, 200);
							}
						}
						else if($action_type == FORGET_PASSWORD){
							$process=FORGET_PASSWORD;
							$module=$account_type;
					
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							
							if($account_type == ADVERTISER){
								$advObj 	=	$this->do_advertiser->validate_verified_user($account_id,$email_addr);
								//$this->response( $advObj, 200);
							$advObj['new_password'] =  $this->update_new_password($advObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
									
									$user_name	   =  $advObj['first_name']."".$advObj['last_name'];
					
									$user_email    =  $advObj['email'];	
									$admin_email=$this->do_networks->get_network_details();
									$from 	=  $admin_email['email'];
									$admin_name = $admin_email['firstname']." ".$admin_email['lastname'];
									$type   ="ADV_FORGET_PASSWORD";
									//$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Advertiser Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $advObj['new_password']
																	
									);	
									/*$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$advObj['account_id'],
												'subject'		=>	'Advertiser - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$advObj['email'].'    Password: '.$advObj['new_password'],
												'account_type'	=>	"ADVERTISER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												);
								 
									$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									$receiver =  (array) $advObj;*/
											
									send_mail($type,$from,$to,$mail_content);
									//$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);
									if($advObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							else if($account_type == PUBLISHER){
								$pubObj 	=	$this->do_publisher->validate_verified_user($account_id,$email_addr);
								
							$pubObj['new_password'] =  $this->update_new_password($pubObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING PUBLISHER
									
									$user_name	   =  $pubObj['first_name']."".$pubObj['last_name'];
					
									$user_email    =   $pubObj['email'];		
									$admin_email=$this->do_networks->get_network_details();
									$from 	=  $admin_email['email'];
									$admin_name = $admin_email['firstname']." ".$admin_email['lastname'];
									$type   ="PUB_FORGET_PASSWORD";
									//$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Publisher Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $pubObj['new_password']								
									);			
									 send_mail($type,$from,$to,$mail_content);
									/*$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									
									$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$pubObj['account_id'],
												'subject'		=>	'Publisher - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$pubObj['email'].'    Password: '.$pubObj['new_password'],
												'account_type'	=>	"TRAFFICKER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												); 
												
									$receiver =  (array) $pubObj;
									
									$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);*/
									if($pubObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							
					}
						
					}
					else{
							$error = array(
								'response' => 'error',
								'msg'	 => 'Please enter correct answer or choose different method for verification'
							);
			
							$this->response( $error, 200);	
					}
				}
				else if($verification_method=='mobile_verification'){
					if($verification_code == $security[0]['mobile_no']){
						
									$verifyCode = rand(100000, 999999);
											$phone = $security[0]['mobile_no'];
											$twilioSid = $this->config->item('twilio_AccountSid');
											$twilioToken = $this->config->item('twilio_AuthToken');
											$twiliono = $this->config->item('twilio_FromNumber');
											$this->do_app_config->sms_verify($verifyCode,$account_id);
										 //$client = new Services_Twilio($twilioSid, $twilioToken);
										$service = get_twilio_service();
										// send sms with verifcation code 
										$responses = $service->account->sms_messages->create($twiliono, $phone, 'Your Login Verification code ' . $verifyCode);
							$response 	= 	array(
													'response' 	=> 	'mobile_ok',
													'redirect'	=>	$redirect_url,
													'accountid'	=>	$account_id,
													'accounttype'	=>	$account_type,
													'mobileno'=>$security[0]['mobile_no'],
													'email'	=>	$security[0]['email'],
													'question' => $security_question[0]['question'],
													'type'=>"sms",
													'browser'=>$browser,
													'browseragent'=>$browseragent,
													'os'=>$os,
													'ip'=>$ip,
													'date'=>$date,
													'action_type'=>$action_type
												);
										$this->response( $response, 200);	
					
					
					
					}
					else{
						$error = array(
								'response' => 'error',
								'msg'	 => 'Please enter correct mobile number or choose different method for verification'
							);
			
							$this->response( $error, 200);
					}
					
				}
				else if($verification_method=='email_verification'){
					
					if($verification_code == $security[0]['email']){
						
									$verifyCode = rand(100000, 999999);
											$phone = $security[0]['mobile_no'];
											
											$this->do_app_config->sms_verify($verifyCode,$account_id);
												$type="ADV_VERIFY_CODE";
											
											$admin_email=$this->do_networks->get_network_details();
											
											$from 	=  $admin_email['email'];
											$admin_name = $admin_email['firstname']." ".$admin_email['lastname'];
											$to  	=  $security[0]['email'];
											//$user_name = $advObj['first_name']." ".$advObj['last_name'];
											$user_email=$security[0]['email'];
											//$password=$advObj['password'];
											//$account_type= $accnt_type;
											$to_mail = $security[0]['email'];
											$mail_content=array(
												"subject" 		=> "Your Login Verification Code",
												"to_name" 		=> "User",				
												"from_name"		=> $admin_name,
												"email"  		=> $user_email,
												"verification_code"		=> $verifyCode,
												"password" =>	$password,
												"account_type" 	=>	$account_type					
												);			
											send_mail($type,$from,$to_mail,$mail_content);
										$redirect_url=site_url('user_login/verification_code');
							$response 	= 	array(
													'response' 	=> 	'mobile_ok',
													'redirect'	=>	$redirect_url,
													'accountid'	=>	$account_id,
													'accounttype'	=>	$account_type,
													'mobileno'=>$security[0]['mobile_no'],
													'email'	=>	$security[0]['email'],
													'question' => $security_question[0]['question'],
													'type'=>"email",
													'browser'=>$browser,
													'browseragent'=>$browseragent,
													'os'=>$os,
													'ip'=>$ip,
													'date'=>$date,
													'action_type'=>$action_type
												);
										$this->response( $response, 200);	
					
					
					
					}
					else{
						$error = array(
								'response' => 'error',
								'msg'	 => 'Please enter correct email id or choose different method for verification'
							);
			
							$this->response( $error, 200);
					}
				}
				
			}
			
		}
		
		public function check_verification_codes_post(){
		
			$account_id = $this->post('account_id');
			$account_type = $this->post('account_type');
			$verification_code=$this->post('verify_codes');
			$os=$this->post('back_os');
			$ip=$this->post('back_ip');
			$browser=$this->post('back_browser');
			$browseragent=$this->post('back_browseragent');
			$date=$this->post('back_date');
			$action_type=$this->post('back_action_type');
			if($account_id){
					$success_message=$this->do_advertiser->sms_verification($account_id,$verification_code);
					
				if($success_message == 1){
					if($action_type == LOGIN){
							$process=LOGIN;
							$module=$account_type;
							
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
						if($account_type == ADVERTISER){
							$advObj 	=	$this->do_advertiser->validate_verified_user($account_id);
							$notification_enable	= $this->do_advertiser->app_config_notification();
					
							$advObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
							
							$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($advObj['user_id'],$account_type);
							
									$advObj['subaccount_role_id']	= $subaccount_role['role_id'];
									
							$check_log		=	$this->do_app_config->fetch_activity_log($advObj['account_id']);
							
							if($check_log)
							{
								$advObj['is_login_first']	=	0;
							}
							else
							{
								$advObj['is_login_first']	=	1;
							}									
							// CREATE SESSIONS for Advertiser
							set_session($advObj['account_type'],$advObj);
						$redirecturl = site_url('advertiser/dashboard') ;
						if($advObj['onetime_wizard']!='1')
								{
									$response  	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('advertiser/onetime_wizard'),
													'msg'	 	=> 	'Login Success!..'
												);						
								}	
								else
								{
									$response  	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('advertiser/dashboard'),
													'msg'	 	=> 	'Login Success!..'
												);
								}
								$this->response( $response, 200);
						}
						else if($account_type == PUBLISHER){
							$pubObj 	= 	$this->do_publisher->validate_verified_user($account_id);
							$notification_enable	= $this->do_advertiser->app_config_notification();
					
							$pubObj['adv_pub_msg']	= $notification_enable[0]['adv_pub_msg'];
							
							$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($pubObj['user_id'],$account_type);
							
									$pubObj['subaccount_role_id']	= $subaccount_role['role_id'];
									
							set_session($pubObj['account_type'],$pubObj);
							$redirecturl = site_url('publisher/dashboard') ;
							if($advObj['onetime_wizard']!='1')
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/onetime_wizard'),
														'msg'	 	=> 	'Login Success!..'
													);						
									}	
									else
									{
										$response  	= 	array(
														'response' 	=> 	'ok',
														'redirect'	=>	site_url('publisher/dashboard'),
														'msg'	 	=> 	'Login Success!..'
													);
									}
								$this->response( $response, 200);
						}
					}
					else if($action_type == FORGET_PASSWORD){
							$process=FORGET_PASSWORD;
							$module=$account_type;
					
							$this->activity_log($account_id,$browseragent,$browser,$os,$ip,$date,$module,$process);
							
							if($account_type == ADVERTISER){
								$advObj 	=	$this->do_advertiser->validate_verified_user($account_id);
							$advObj['new_password'] =  $this->update_new_password($advObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
									
									$user_name	   =  $advObj['first_name']."".$advObj['last_name'];
					
									$user_email    =  $advObj['email'];	
									$admin_email=$this->do_networks->get_network_details();
									$from 	=  $admin_email['email'];
									$admin_name = $admin_email['firstname']." ".$admin_email['lastname'];
									$type   ="ADV_FORGET_PASSWORD";
									//$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Advertiser Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $advObj['new_password'] 								
									);
									send_mail($type,$from,$to,$mail_content);	
									/*$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$advObj['account_id'],
												'subject'		=>	'Advertiser - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$advObj['email'].'    Password: '.$advObj['new_password'],
												'account_type'	=>	"ADVERTISER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												);
								 
									$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									$receiver =  (array) $advObj;
									
									$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);*/
									if($advObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							else if($account_type == PUBLISHER){
								$pubObj 	=	$this->do_publisher->validate_verified_user($account_id);
								
							$pubObj['new_password'] =  $this->update_new_password($pubObj['account_id']);
									// SENDS THE EMAIL TO CORRESPONDING PUBLISHER
									
									$user_name	   =  $pubObj['first_name']."".$pubObj['last_name'];
					
									$user_email    =   $pubObj['email'];		
									$admin_email=$this->do_networks->get_network_details();
									$from 	=  $admin_email['email'];
									$admin_name = $admin_email['firstname']." ".$admin_email['lastname'];
									$type   ="PUB_FORGET_PASSWORD";
									//$from 	=  $admin_email;
									$to  	=  $user_email;			
									$mail_content=array(
									"subject" 		=> "Publisher Forget password",
									"to_name" 		=> $user_name,				
									"from_name"		=> $admin_name,
									"user_email"	=> $user_email,	
									"password"		=> $pubObj['new_password']								
									);			
									 send_mail($type,$from,$to,$mail_content);
									/*$user = $this->do_message->get_profile(ADMIN_ID); 
									$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "forget_pwd",
										'column_name'	=> "account_settings",
										'bcc'=>$bcc
											);
									
									$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$pubObj['account_id'],
												'subject'		=>	'Publisher - Forgot Password',
												'content'		=> 	'Please find the new password and Login. Login Id:'.$pubObj['email'].'    Password: '.$pubObj['new_password'],
												'account_type'	=>	"TRAFFICKER",
												'status'		=>	'1',
												'date'			=>	date('Y-m-d H:i:s')
												); 
												
									$receiver =  (array) $pubObj;
									
									$dd = $this->notification->new_mail($message_data,$user,$receiver,$type_details,$mail_content);*/
									if($pubObj['new_password'] !='')
									{
										$response = array(
										'response' => 'pass_ok',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Password is sent successfully to your email. Please find the new password and Login.'
										);
										
									}else{
										
										$response = array(
										'response' => 'pass_error',
										'redirect'=>site_url('user_login/forget_password/'.strtolower($account_type)),
										'msg'	 => 'Oops! Password is not updated'
									);	
									}
									$this->response( $response, 200);
							}
							
					}
				}
				else{
						$error = array(
								'response' => 'error',
								'msg'	 => 'Please enter correct code ..'
							);
			
							$this->response( $error, 200);
					}
			}
		}
		
		/*
	 * name: get_phone_verify_config_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch a phone verification details.
	 * 
	 */
	 
	public function get_phone_verify_config_get()
	{
		$network_id = $this->get('network_id');
		$phone_veirfy = 	$this->do_app_config->fetch_phone_verify_config($network_id);			
		
		if($phone_veirfy)
		{			
			$this->response($phone_veirfy,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	public function phone_verification_code_post()
	{
		$phone_num			=$this->post('phone_num');
		$temp_user_id		=$this->post('temp_user_id');
		$phone_verify_code	=$this->post('phone_verify_code');
		$user_account_type	=$this->post('accounttype');
		$adv_first_name=clean_data($this->post('adv_first_name'));
		$adv_last_name=clean_data($this->post('adv_last_name'));
		$adv_email=clean_data($this->post('adv_email'));  
		$success_message	=$this->do_advertiser->phone_number_verification($temp_user_id,$phone_verify_code,$phone_num);
		if($success_message){
			
			$result=$this->do_networks->get_network_details();
			
			$admin_name    = $result['firstname']." ".$result['lastname'];
			$admin_email   = $result['email'];
			$adv_approval_type = $result['approval_type'];
			//DAC107
			$activation_code = md5(time());
			if($adv_approval_type=="EMAIL")
			{
				$user_name	   = $adv_first_name. " ". $adv_last_name ;
			
				$user_email    = $adv_email;
			
				//$user_account_type=$userObj['account_type'];
				/* Send mail to advertiser/Publisher for activate their account */	
				
				if($user_account_type == "ADVERTISER")
				{
					$type 	= "ADV_APPROVE_EMAIL";
				}
				else
				{
					$type 	= "PUB_APPROVE_EMAIL";
				}
							
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
				"subject" 		=> "Activate your Account",
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"temp_user_id"  => $temp_user_id,
				"activation_code" =>$activation_code													
				);
											
				send_mail($type,$from,$to,$mail_content);			
				
			}
							$success = array(
							'response' 	=> 	'ok',
							'redirect'	=>	site_url('user_registration/success/'.strtolower($user_account_type)),
							'msg'	 	=> 	'Account has been created successfully.',
							'temp_user_id'=>$temp_user_id
			);

			$this->response($success, 200);  
		}
		else{
			$error = array(
							'response' 	=> 	'error',
							
							'msg'	 	=> 	'Entered Verification code incorrect.',
							'temp_user_id'=>$temp_user_id
			);

			$this->response($error, 200); 
		}
	}
	public function resend_signup_verify_code_post()
	{
		$phone_num=$this->post('phone_num');
		$temp_user_id=$this->post('temp_user_id');
		
		$account_type=$this->post('account_type');
		if($temp_user_id){
		$verifyCode = rand(100000, 999999);
											$phone = $phone_num;
											$twilioSid = $this->config->item('twilio_AccountSid');
											$twilioToken = $this->config->item('twilio_AuthToken');
											$twiliono = $this->config->item('twilio_FromNumber');
											
											$this->do_advertiser->phone_resend_verify($temp_user_id,$verifyCode);
										 //$client = new Services_Twilio($twilioSid, $twilioToken);
										$service = get_twilio_service();
										// send sms with verifcation code 
										$responses = $service->account->sms_messages->create($twiliono, $phone, 'Your Mobile Verification code ' . $verifyCode);
										//$redirect_url=site_url('user_login/verification_code');	
										$response 	= 	array(
													'response' 	=> 	'ok',
													//'redirect'	=>	$redirect_url,
													'temp_user_id'	=>	$temp_user_id,
													
													'mobileno'=>$phone,
													'account_type'=>$account_type,
													'msg'=>"Resend successfully to : ".$phone
												);
										$this->response($response, 200); 
		
		}
		else{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
				$this->response( $error, 200);
		}
	}
	
	
	/*Function	:	validate_user_api	
	* Purpose	: 	get user details via api key for home page report	
	* param		: 	api_key 	
	* return 	:	user details 	
	* */
	public function validate_user_api_post()
	{
		$api_key=clean_data($this->post('api_key'));
		$acc_type=clean_data($this->post('account_type'));
		switch(strtoupper($acc_type))
		{
			case "ADVERTISER":
			$advObj 	=	$this->do_advertiser->validate_user_api($api_key,ADVERTISER);
			if($advObj)
			{
				if($advObj['parent_account_id']!=0)
				{
					$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($advObj[0]['user_id'],$advObj[0]['account_type']);
							
					$advObj['subaccount_role_id']	= $subaccount_role['role_id'];
				}
				
				//set_session($advObj['account_type'],$advObj);
				
					$response 	= 	array(
											'response' 	=> 	'ok',
											'acc_type'	=> 'adv_overview',
											'acc_detail' => $advObj[0],
											'msg' 		=>  'Session has been defined'
										);
				
				$this->response($response,200);
			}
			else
			{
			$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'Enter a valid '.strtolower($acc_type).' api key'
										 );
			}
			$this->response($response,200);
			break;
			
			case "PUBLISHER":
			
			$pubObj 	=	$this->do_publisher->validate_user_api($api_key,TRAFFICKER);
			
			if($pubObj)
			{
				if($pubObj['parent_account_id']!=0)
				{
					$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($pubObj['user_id'],$pubObj['account_type']);
							
					$pubObj['subaccount_role_id']	= $subaccount_role['role_id'];
				}
			
				//set_session($pubObj['account_type'],$pubObj);
				
				$response 	= 	array(
											'response' 	=> 	'ok',
											'acc_type'	=> 'pub_overview',
											'acc_detail' => $pubObj[0],
											'msg' 		=>  'Session has been defined'
										);
			}
			else
			{
			
			$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'Enter a valid '.strtolower($acc_type).' api key'
										 );
			}
			$this->response($response,200);
			break;
		}
		
		$this->response($response,200);
	}

	/*Function	:	validate_user_api	
	* Purpose	: 	get user details via api key for home page report	
	* param		: 	api_key 	
	* return 	:	user details 	
	* */
	public function get_user_api_details_get()
	{
		
		$api_key=clean_data($this->get('api_key'));
		$acc_type=clean_data($this->get('account_type'));
		switch(strtoupper($acc_type))
		{
			case "ADVERTISER":
			$advObj 	=	$this->do_advertiser->validate_user_api($api_key,'ADVERTISER');
			$this->response($advObj,200);
			if($advObj)
			{
				if($advObj['parent_account_id']!=0)
				{
					$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($advObj['user_id'],$advObj['account_type']);
							
					$advObj['subaccount_role_id']	= $subaccount_role['role_id'];
				}
				$this->response($advObj,200);
				
			}
			else
			{
			$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'Enter a valid '.strtolower($acc_type).' api key'
										 );
			}
			$this->response($response,200);
			break;
			
			case "PUBLISHER":
			
			$pubObj 	=	$this->do_publisher->validate_user_api($api_key,TRAFFICKER);
			
			if($pubObj)
			{
				if($pubObj['parent_account_id']!=0)
				{
					$subaccount_role	= $this->do_app_config->fetch_subaccount_roles($pubObj['user_id'],$pubObj['account_type']);
							
					$pubObj['subaccount_role_id']	= $subaccount_role['role_id'];
				}
			
				$this->response($pubObj,200);
				//set_session($pubObj['account_type'],$pubObj);
				
			}
			else
			{
			
			$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  'Enter a valid '.strtolower($acc_type).' api key'
										 );
			}
			$this->response($response,200);
			break;
		}
		
		$this->response($response,200);
	}	
	
	public function resume_to_tmp_location_post()
	{			
		if($_FILES['resume'])
		{
			$resume=array(
					'file_name'   => $_FILES['resume']['name'],
					'tmp_name' => $_FILES['resume']['tmp_name'], 
					);	
									
			$tmp_resume=$this->image_lib->move_resume_to_tmp_location($resume);
			
			if($tmp_resume)
			{
				$success = array(
								'response' => $tmp_resume['upload_data'],
								'msg'	 => 'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Unable to move to temporary location '
				);
				$this->response($error, 200);
				//$this->last->query(); exit;
			}
		}
	}				
	
}
