<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Countrywise Bidding
 *
 */
class Tracker extends REST_Controller
{
	
	function __construct()
	{
		
		parent::__construct();
		$this->load->library('redis_library');
		$this->load->library('csvreader');	
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_tracker');
		$this->load->library('user_authentication');
		$this->load->library('notification');
		$this->load->model('do_app_config');
		$this->load->model('do_message');
		$this->load->model('do_campaign');
	    $key=$this->input->get_post('api_key');
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	} 
	
	 /*
	 * 
	 * name: fetch_tracker
	 * @param :
	 * @return : $tracker_list
	 * 
	 * Lists selected trackers of an advertiser
	 */
	
	function fetch_tracker_get()
	{	
		$tracker_id		=	$this->get('tracker_id');
		$global_tracker	=	$this->get('global_tracker');
		$admarket		=	$this->get('admarket');
		$filter			=	clean_data($this->get('filter'));
		$type			=	clean_data($this->get('type'));
		$is_house_pixel	=	clean_data($this->get('is_house_pixel'));
	
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		elseif($type == 'housead')
		{
			//$account_id =	$this->get('account_id');  
			$account_id =	$this->user_authentication->account_id; //DAC094 05/06/2018
			
		}	
		else
		{
			$account_id =	$this->get('account_id');
		}		
		
		$tracker	=	$this->do_tracker->fetch_tracker(clean_data($tracker_id),$account_id,$global_tracker,$admarket,$filter,$type);	
		 //log_message('error','tracker'); 
		// log_message('error',$this->db->last_query());
		if($tracker)
		{
			$this->response($tracker, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No trackers'),404);
		}		
	}
		
		
	
	/*
	* 
	* 
	* name: add_pixel_tracker_post
	* @param
	* @return:response array
	* 
	* In this method we will manage add pixel process
	*/
	 
	public function add_pixel_tracker_post()
	{   
		$this->form_validation->set_rules('pixel_name', 'Pixel Name', 'required|trim');
		$this->form_validation->set_rules('pixel_type', 'Pixel Type', 'required|trim');
		$this->form_validation->set_rules('pixel_category', 'Pixel Category', 'required|trim');
		//$this->form_validation->set_rules('campaign', 'Campaign', 'required|trim');
						
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();  
			$error 		= 	array(
								'response' => 'error',
								'msg' =>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_client_id	=	$this->user_authentication->client_id;
			}
			elseif($this->post('housead_pix')=='housead')
			{
				$dj_client_id	=	$this->user_authentication->default_advertiser_client_id;
			}	
			else
			{
				$dj_client_id	=	$this->post('adv_id');
			}			
			
			$campaign_id	=	clean_data($this->post('campaign'));
			if($this->post('admarket')!='')
			{
			$admarket	= $this->post('admarket');
			}
			else
			{
			$admarket	= 0;
			}
			$pixel_data 	= 	array(
									"clientid"			=>	clean_data($dj_client_id),
									"trackername"		=>	clean_data($this->post('pixel_name')),
									"pixel_type" 		=> 	clean_data($this->post('pixel_type')),
									"pixel_category"	=>	clean_data($this->post('pixel_category')),
									"protocol"			=>	clean_data($this->post('protocol')),
									"pixel_goal" 		=> 	clean_data($this->post('pixel_goal')),
									"status"			=>	clean_data($this->post('status')),
									"appendcode"		=>	clean_data($this->post('appendcode')),
									"updated"			=>	date('Y-m-d H:i:s'),
									"admarket"			=>	$admarket,
									"destination_url"	=>	clean_data($this->post('pixel_url'))
								);
					
			$pixel_add		=	$this->do_tracker->add_tracker($pixel_data,$campaign_id);
			
			if($pixel_add)
			{
				
				/* Activity Log for add tracker - Start*/
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,PIXEL_TRACK_ADD);
				if($enable=='1')
				{				
					$this->track_activity_log(PIXEL_TRACKER,ADD,$pixel_add);
				}
				/* Activity Log for add tracker - End*/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					/*************message requirements***************/
				
					$client_id 		=	$this->user_authentication->client_id;
					$account_id 	=	$this->user_authentication->account_id;
					$acc_type		=	$this->user_authentication->account_type;
					$network_id		=	$this->do_message->fetch_admin_network_id();
					$message  		= 	$this->default_configurations->get('message_type');	
				
					if($acc_type=='TRAFFICKER')
					{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$reciever 		= 	$this->do_message->get_affiliate($affiliate_id); 
					}
					else
					{
						$reciever	= 	$this->do_message->get_profile($account_id);
					}
					
					$reciever['name'] = $reciever['first_name'].' '.$reciever['last_name'];
					
					$user = $this->do_message->get_profile(ADMIN_ID); 

				
					$type_details		=	array(
												'msg_type'		=> $message,
												'type'			=> "ADMIN_MESSAGE_SETTINGS",
												'string'		=> "pixel_track_add",
												'column_name'	=> "network_settings"
											);
					$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$reciever['account_id'],
												'subject'		=>	'Pixel Track added',
												'content'		=>	'A new pixel tracker has been added <b>'.$pixel_data['trackername'].'</b>',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'notification_type'	=>	"network_setting",
												'dj_is_admarket'=>	$admarket,
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);
												
			$notification_msg = $this->do_message->get_notification_msg('pixel_track_add'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	

			$msg_replace = str_replace("{{tracker_name}}",$pixel_data['trackername'],$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);					
					//$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
			
					/*********Message Requirements**************/
					
					if($this->post('admarket')=='1')
					{
						$success 	= 	array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Pixel Tracker successfully added',
										'redirect'	 	=> 	site_url('buyer/admarket/tracker'),
									);						
					
					}
					else
					{				
					$success 	= 	array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Pixel Tracker successfully added',
										'redirect'	 	=> 	site_url('buyer/tracker'),
									);						
					}
				}
				else
				{
					$success 	= 	array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Pixel Tracker successfully added',
										'redirect'	 	=> 	site_url('admin/tracker'),
									);  
				}
				
				$this->response( $success, 200);	  			
			}	
			else
			{
				if($this->post('admarket')=='1')
				{
				$error 	= 	array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error! please try again..',
									'redirect'	 	=> 	site_url('buyer/admarket/tracker'),
								);	
				}
				else
				{
					                 $error 	= 	array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error! please try again..',
									'redirect'	 	=> 	site_url('buyer/tracker'),
								);	
				}
				$this->response( $error, 200);   
			}		
		}
	}
	
	/*
	 * 
	 * name: delete_get
	 * @param :
	 * @return : $tracker_id
	 * 
	 * Delete the given tracker id
	 */
	
	function delete_get()
	{		
		$tracker_id = 	$this->get('tracker_id');	
		$admarket = '';
			
		if($tracker_id)
		{
			$tracker	=	explode(',',$tracker_id);
		
			if(is_array($tracker) && count($tracker)>1)
			{
				$tracker_name ='';
				
				foreach($tracker as $track)
				{	
					$tracker_det = $this->do_tracker->fetch_tracker_details(clean_data((string)$track));
					
					$tracker_name .= $tracker_det[0]['trackername'].',';
					//$admarket .= $tracker_det[0]['admarket'].',';
					$admarket = $tracker_det[0]['admarket'];
					$pixel_details = $this->do_tracker->delete_tracker(clean_data($track));
					
				}
			}
			
			else
			{
				$tracker_det = $this->do_tracker->fetch_tracker_details($tracker_id);
				
				
				$tracker_name = $tracker_det[0]['trackername'];
				$admarket = $tracker_det[0]['admarket'];
				
				$pixel_details 	= 	$this->do_tracker->delete_tracker(clean_data($tracker_id));
				
			}
		
			if($this->user_authentication->account_type=='ADVERTISER')
			{
			
			/* Activity Log for delete tracker - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,PIXEL_TRACK_DEL);
					if($enable=='1')
					{				
						$this->track_activity_log(PIXEL_TRACKER,DELETE,$tracker_id);
					}
					/* Activity Log for delete tracker - End*/
			
			/*************message requirements***************/
			
				$client_id 		=	$this->user_authentication->client_id;
				$account_id 		=	$this->user_authentication->account_id;
				$acc_type	=	$this->user_authentication->account_type;
				$network_id	=	$this->do_message->fetch_admin_network_id();
				$message  = $this->default_configurations->get('message_type');	
			
				if($acc_type=='TRAFFICKER')
				{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$reciever = $this->do_message->get_affiliate($affiliate_id); 
				}
				else
				{
				$reciever= $this->do_message->get_profile($account_id);
				}
				
				$reciever['name'] = $reciever['first_name'].' '.$reciever['last_name'];
				
				$user = $this->do_message->get_profile(ADMIN_ID); 

			
				$type_details		=	array(
											'msg_type'		=> $message,
											'type'			=> "ADMIN_MESSAGE_SETTINGS",
											'string'		=> "pixel_track_del",
											'column_name'	=> "network_settings"
										);
				$message_data		=	array(
											'sender_id'		=>	ADMIN_ID,
											'receiver_id'	=>	$reciever['account_id'],
											'subject'		=>	'Pixel Track deleted',
											'content'		=>	'The Pixel Trackers '.$tracker_name.' has been deleted successfully',
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	$acc_type,
											'notification_type'	=>	"network_setting",
											'dj_is_admarket'=>	$admarket,
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')
											);
											
			$notification_msg = $this->do_message->get_notification_msg('pixel_track_del'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	

			$msg_replace = str_replace("{{tracker_name}}",$tracker_name,$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);	
							
				//$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
			}
			
			/*********Message Requirements**************/
			
			//$this->response( '$success', 200);
			
			$success 	= 	array(
								'response'	=> 	'ok',
								'msg'		=> 	'Tracker has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}
		else
		{
			$error 	= 	array(
							'response' 	=> 	'error',
							'msg'		=> 	' Tracker id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	function edit_pixel_tracker_post()
	{		
		$tracker_id	=	clean_data($this->post('tracker_id'));
		
		$this->form_validation->set_rules('pixel_name', 'Pixel Name', 'required|trim');
		$this->form_validation->set_rules('pixel_category', 'Pixel Category', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' => 'error',
								'msg' =>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$pixel_data 	= 	array(
									"trackername"		=>	clean_data($this->post('pixel_name')),
									"pixel_category" 	=> 	clean_data($this->post('pixel_category')),
									"pixel_goal" 		=> 	clean_data($this->post('pixel_goal')),
									"status"			=>	clean_data($this->post('status')),
									"appendcode"		=>	clean_data($this->post('appendcode'))
								);
						
			$pixel_edit		=	$this->do_tracker->edit_tracker($pixel_data,$tracker_id);
		
			if($pixel_edit)
			{
				
				/* Activity Log for edit tracker - Start*/
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,PIXEL_TRACK_EDIT);
				if($enable=='1')
				{				
					$this->track_activity_log(PIXEL_TRACKER,EDIT,$tracker_id);
				}
				/* Activity Log for edit tracker - End*/	
				$tracker_det = $this->do_tracker->fetch_tracker_details($tracker_id);
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					/*************message requirements***************/
				  
					$client_id 		=	$this->user_authentication->client_id;
					$account_id 	=	$this->user_authentication->account_id;
					$acc_type		=	$this->user_authentication->account_type;
					$network_id		=	$this->do_message->fetch_admin_network_id();
					$message 		= 	$this->default_configurations->get('message_type');	
					$reciever= $this->do_message->get_profile($account_id);
					$user = $this->do_message->get_profile(ADMIN_ID); 
					$reciever['name'] = $reciever['first_name'].' '.$reciever['last_name'];
					$type_details		=	array(
												'msg_type'		=> $message,
												'type'			=> "ADMIN_MESSAGE_SETTINGS",
												'string'		=> "pixel_track_edit",
												'column_name'	=> "network_settings"
											);
					$message_data		=	array(
												'sender_id'		=>	ADMIN_ID,
												'receiver_id'	=>	$reciever['account_id'],
												'subject'		=>	'Pixel Tracker edited', 
												'content'		=>	'Congrats! The Pixel tracker '.$pixel_data['trackername'].' has been edited successfully',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'dj_is_admarket'=>	$tracker_det[0]['admarket'],
												'notification_type'	=>	"network_setting",
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);
												
			$notification_msg = $this->do_message->get_notification_msg('pixel_track_edit'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	

			$msg_replace = str_replace("{{tracker_name}}",$pixel_data['trackername'],$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);						
					
					//$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
					
					/*********Message Requirements**************/
					
					$success 	= 	array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Pixel Tracker successfully Edited',
										'redirect'	 	=> 	site_url('buyer/tracker'),
									);						
				}
				else
				{
					$success 	= 	array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Pixel Tracker successfully Edited',
										'redirect'	 	=> 	site_url('admin/tracker'),
									);
				}
				
				$this->response( $success, 200);
				
			}
			else
			{
				$error 	= 	array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error! please try again..',
									'redirect'	 	=> 	site_url('buyer/tracker'),
								);	
				$this->response( $error, 200);
			}			
		}
	}
	
	
	/*
	* 
	* name: fetch_campaign_tracker_get
	* @param :
	* @return : $tracker_list
	* 
	* Lists selected trackers of an advertiser
	*/
	
	function fetch_campaign_tracker_get()
	{	
		$campaign_id	=	clean_data($this->get('campaign_id'));				
		
		$tracker		=	$this->do_tracker->fetch_campaign_tracker($campaign_id);	
		 
		if($tracker)
		{
			$this->response($tracker, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response('error',200);
		}		
	}
	
	function fetch_tracker_name_get()
	{	
		$campaign_id	=	clean_data($this->get('campaign_id'));				
		
		$tracker		=	$this->do_tracker->fetch_tracker_name($campaign_id);	
		 
		if($tracker)
		{
			$this->response($tracker, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response('error',200);
		}		
	}
	
	
	
	
	function fetch_admarket_tracker_campaign_get()
	{	
		$tracker_id	=	clean_data($this->get('tracker_id'));
		
		$admarket = clean_data($this->get('admarket'));
		
		$campaign	=	$this->do_tracker->fetch_admarket_tracker_campaign($tracker_id,$admarket);	
		 
		if($campaign)
		{
			$this->response($campaign, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response('error',200);
		}		
	}
	
	
	/*
	 * 
	 * name: fetch_campaign_tracker_get
	 * @param :
	 * @return : $tracker_list
	 * 
	 * Lists selected trackers of an advertiser
	 */
	
	function fetch_tracker_campaign_get()
	{	
		$tracker_id	=	clean_data($this->get('tracker_id'));
					
		$campaign	=	$this->do_tracker->fetch_tracker_campaign($tracker_id);	
	
		// log_message('error',$this->db->last_query());
		if($campaign)
		{
			$this->response($campaign, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response('error',200);
		}		
	}
	
	/*
	 * 
	 * name: delete_get
	 * @param :
	 * @return : $tracker_id
	 * 
	 * Delete the given tracker id
	 */
	
	function link_campaign_tracker_get()
	{
		$campaigns 	= 	$this->get('campaign_id');	
		$tracker_id = 	$this->get('tracker_id');
			
		$campaign	=	$this->do_tracker->fetch_tracker_campaign($tracker_id);	
	
		$camplink	=	array();
		if($campaign):
			foreach($campaign as $cam):
				$camplink[]	=	$cam['campaignid'];
			endforeach;
		endif;
					
		if($campaigns)
		{	
			$camp	=	explode(',',$campaigns);
				
			if(is_array($camp))
			{ 
				if($camplink):
					$diff	=	array_diff($camplink,$camp);
					
					if($diff):
						foreach($diff as $dicamp):
							$this->do_tracker->delete_tracker_campaign($tracker_id,$dicamp);
						endforeach;
					endif;
				endif;
							
				foreach($camp as $campaign_id)
				{	
					$this->do_tracker->link_campaign_tracker($tracker_id,$campaign_id);
				}
			}
			
			else
			{
				$this->do_tracker->link_campaign_tracker($tracker_id,$campaigns);
			}
			
			$success 	= 	array(
								'response'	=> 	'ok',
								'msg'		=> 	'Campaign has been linked successfully.',
								'camplink'	=>	$camp
							 );
			
			$this->response( $success, 200);			
		}
		else
		{
			$error 	= 	array(
							'response' 	=> 	'error',
							'msg'		=> 	' Tracker id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	function update_conversion_settings_post()
	{		
		$tracker_id		=	clean_data($this->post('tracker_id'));
		
		$campaign_id	=	clean_data($this->post('campaign_id'));
				
		$viewwindow		=	($this->post('view_days')*24*60*60) + ($this->post('view_hours')*60*60) + ($this->post('view_mins')*60) + $this->post('view_secs');
		
		$clickwindow	=	($this->post('click_days')*24*60*60) + ($this->post('click_hours')*60*60) + ($this->post('click_mins')*60) + $this->post('click_secs');
		
		$conv_data 	= 	array(
									"viewwindow"		=>	$viewwindow,
									"clickwindow" 		=> 	$clickwindow
								);
				
		$conv_update		=	$this->do_tracker->update_conversion_settings($campaign_id,$conv_data);
	
		if($conv_update)
		{			
			//if($this->user_authentication->account_type=='ADVERTISER')
			//{
				$success 	= 	array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Conversion Settings successfully updated'
								);						
			//}
			
			$this->response( $success, 200);
			
		}
		else
		{
			$error 	= 	array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error! please try again..'
							);	
			$this->response( $error, 200);
		}
	}
	
	function track_activity_log($module,$process,$tracker_id)
	{
				/* Activity Log for Add/Edit/Delete site - Start	*/			
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");		 					
				$account_id=$this->user_authentication->account_id;
				$advertiser_id =	$this->user_authentication->client_id;
				//$module=$module;
				//$process=$process;				
				//$campaign_id=$campaign_id;
				
				$activity_log=array(				
								"account_id"=>$account_id,
								"useragent"=>$user_agent,
								"browser"=>$browser,
								"os"=>$os,
								"ip"=>$ip,
								"date"=>$date,
								"module"=>$module,
								"process"=>$process,
								"advertiser_id"=>$advertiser_id,
								"tracker_id"=>$tracker_id
								
								);				
				$this->redis_library->logcount($account_id,$activity_log);  																					
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}	
	/*
	* 
	* name: add_creative_editable_post
	* @param
	* @return:response array
	* 
	* In this methosd we will manage all the three SQL,WEB
	* and CREATIVE edit process
	*/
	public function add_pixel_editable_post()
	{
		$tracker_id 	= 	$this->post('pk');
		$value 			= 	$this->post('value');
		$name 			= 	$this->post('name');
		
		if($name=="pixelname")
		{
			$pixel_data	=	array('trackername'	=>	$value);
		}
		else if($name=="category")	
		{
			
			$pixel_data	=	array('pixel_category'	=>	$value);
	    }
	    else if($name=="goal")
	    {
			$pixel_data	=	array('pixel_goal'	=>	$value);
	    }		
		//$this->response($pixel_data,200);
		//Get clientid from library file
		$agency_id	=	$this->user_authentication->agency_id;

		//Call to edit a creative
		$pixel_edit=$this->do_tracker->edit_tracker($pixel_data,$tracker_id,$agency_id);
		
		if($pixel_edit)
		{
			$success = 	array(
							'response' 	=> 	'ok',
							'msg'	 	=> 	'Tracker edited sucessfully',					
						);
				
			$this->response($success,200); 
		}
		else
		{
			$error 	= 	array(
							'response' 	=> 'error',
							'msg'	 	=> 'Please try again'						
						);
			$this->response($error,200); 
		}
	}
	
	function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}	
		
    return $max['path'];
	}
	
	//import pixel files
	
	public function import_pixel_file_post()
	{			
		$file_id=$this->post('upload_name');	
	
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);	   	  
			
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt'|| $upload_extension[1]=='xml')
			{	
				
					$csvfilepath 	= $this->config->item('read_csv');	
					$file_name		= $this->getLatestFile($csvfilepath);
					if($upload_extension[1]=='xml')
					{						
						$xml = simplexml_load_file($file_name, 'SimpleXMLElement');	
						$data = json_decode(json_encode((array)$xml), TRUE);
						
						if(!empty($data['pixel'][0]))
						{
							$data=$data['pixel'];
						}
						else{
							$datum[0]=$data['pixel'];
							$data=$datum;
						}
							
						
					}
					else
					{
						$data	 		= $this->csvreader->parse_file($file_name);
					}
					
					
					$counter		= '1';	
					$ext_counter='1';
					$ext_row_counter='1';
					$insert_rec=array();
					$exist_rec=array();
					$exist_row_rec=array();
					$num_rows=count($data);	
							
					
						
					if($num_rows>0)
					{
						foreach($data as $row)
						{ 													
							if(!empty($row['trackername']) && !empty($row['type']) && !empty($row['pixel_category']) )	
							{	
																						
							if($this->user_authentication->account_type=='ADVERTISER')
							{	
							$client_id 	= 	$this->user_authentication->client_id;
						     }	
							
							 $trackerid			= trim($row['trackerid']);
														
								$pixel_data 	= 	array(
									"clientid"			=>	clean_data($client_id),
									"trackername"		=>	trim($row['trackername']),
									"pixel_type" 		=> 	trim($row['pixel_type']),
									"pixel_category"	=>	trim($row['pixel_category']),
									"protocol"			=>	trim($row['protocol']),
									"pixel_goal" 		=> 	trim($row['pixel_goal']),
									"status"			=>	trim($row['status']),
									"appendcode"		=>	clean_data(trim($row['appendcode'])),
									"admarket"          =>  trim($row['admarket']),     
									"updated"			=>	date('Y-m-d H:i:s')   
								);	
									$check_exist='';									
								if($trackerid)
								{
								$check_exist = $this->do_tracker->exists_tracker_check($trackerid); 
								}
								
									if(($check_exist!=='NULL') && isset($check_exist))
								{
									$pixel_data_where_data 	= 	array(
									"trackerid"			=>	trim($row['trackerid']),
									"clientid"			=>	clean_data($client_id),
									"trackername"		=>	trim($row['trackername']),
									"pixel_type" 		=> 	trim($row['pixel_type']),
									"pixel_category"	=>	trim($row['pixel_category']),
									"protocol"			=>	trim($row['protocol']),
									"pixel_goal" 		=> 	trim($row['pixel_goal']),
									"admarket"          =>  trim($row['admarket'])
								);		//$this->response($pixel_data_where_data);
									$pixel_id=$this->do_tracker->add_import_tracker($pixel_data,$pixel_data_where_data);
						
									if($pixel_id)
									{
											$insert_rec[] =$counter;
									}
									else
									{
											$exist_row_rec[]=$ext_row_counter;		
																
									}	
								}
								else
								{
									
										$exist_rec[]=$ext_counter;
										
								}										
								/*if(!empty($pixel_data))
								{
											
									
										$pixel_id=$this->do_tracker->add_import_tracker($pixel_data);
										$insert_rec[] =$counter;
										
								}
								else
								{
										$exist_rec[]=$ext_counter;
								}*/
						$counter++;	
						$ext_counter++;	
						$ext_row_counter++;						
						}
						else {
							$error = array(
									'response' => 'error',
									//'redirect'=>site_url('advertiser/network/traffic_sources/'),
									'msg'	 => 'The file contains invalid data for this operation..'
									);
				  
							$this->response($error, 200);
						}
					}
				
						if(count($insert_rec)>0 && count($exist_rec) >0 && count($exist_row_rec) <=0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0 && count($exist_row_rec) >0)
						{
							
								$ins_count = count($insert_rec);
								$ins_row_count = count($exist_row_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												  'error_msg'=> $ins_row_count.'Rows,All Fields name are same!' 
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0 && count($exist_row_rec) <=0)
						{
							
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
						else if(count($exist_row_rec) >0&& count($insert_rec)<=0   && count($exist_rec) <=0)
						{
								$ins_row_count = count($exist_row_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ins_row_count.'Rows, All Fields name are same! '
										  );
									$this->response( $error, 200);
						}
						else if(count($exist_row_rec) >0&& count($insert_rec)<=0   && count($exist_rec) >0)
						{
								$ins_row_count = count($exist_row_rec);
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										  'msg' => $ex_count.'tracker Name Not Found!'.','.$ins_row_count.'Rows,All Fields name are same!'
										  
										  );
									$this->response( $error, 200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)>0  && count($exist_row_rec) >0)
						{
							
								$ins_count = count($insert_rec);
								$ins_row_count = count($exist_row_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
								//	'redirect'=>site_url('advertiser/network/countrywise_bidding'),
									'msg'		=> $ins_count.' record(s) are inserted successfully',
								'error_msg' => $ex_count.'tracker Name Not Found!'.','.$ins_row_count.' Rows, All Fields name are same!'
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0  && count($exist_row_rec) <=0)
						{

								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
								//	'redirect'=>site_url('advertiser/network/countrywise_bidding'),
									'msg'		=> $ins_count.' record(s) are inserted successfully'
								
												 ); 
								$this->response($success,200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('advertiser/campaigns/'),
									'msg'	 => 'There is no data in the file!..'
									);
				  
						$this->response($error, 200);	
					}													
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT/XML file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT/XML file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	}
		public function update_pixelbid_get()
	{
		$track_id	=	clean_data($this->get('track_id'));
		$bid_rate	=	clean_data($this->get('bid_rate'));
		if($this->user_authentication->account_type=='ADVERTISER')
		{			
			$account_id	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	= 	'';
		}
								 
		$pixel_bidding_list = $this->do_tracker->update_pixel_bidding($track_id,$bid_rate);
		
		$success = array( 
								'response'	=>	'ok',
								'msg'		=>	'pixel rate updated successfully'
							);
		$this->response($success, 200);			
	}
	
	public function fetch_eventlogs_get()
	{
		$account_id	= 	$this->user_authentication->account_id;
		$eventlog_data = $this->do_tracker->fetch_eventLogs($account_id);
		 
		$this->response($eventlog_data, 200);	
		 
				
		
	}
	
}
