<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
	
class Targeting extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->library('csvreader');
		$this->load->model('do_targeting');
		$this->load->model('do_email_check');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('user_authentication');
		 $this->load->model('do_app_config');
	    $key=$this->input->get_post('api_key');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }

	}
	/*
	 * name: browser_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set browser targeting for a campaign
	 * 
	 */
	public function browser_targeting_post()
	{
			//Prepare the target data
			$campaign_id='';
			$prepared_data='';
			$compiledlimitation_prefix='';
			$compiledlimitation_suffix='';
			$compiledlimitation='';
			$acl_plugins='';
			
			$targ_value = clean_data($this->post('value'));

			if(!empty($targ_value))
			{
				foreach($targ_value as $data)
				{
					$prepared_data .= $data.',';
				}
				$prepared_data=substr($prepared_data, 0, -1);
			}
			else
			{
				$prepared_data =FALSE;
			}

				$campaign_id = clean_data($this->post('pk'));
				$logical="or";
				$type="deliveryLimitations:Client:Browser";
				$comparison= "==";
				$executionorder="0";

				$ox_acls_data=	array(

								"campaignid"=> $campaign_id,
								"logical"=> $logical,
								"type"=> $type,
								"comparison"=> $comparison,
								"data"=> $prepared_data,
								"executionorder"=> $executionorder,
								);
			if($prepared_data!=FALSE)
			{
				$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
			}
			else
			{
				$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
			}

			if($ox_acls !== FALSE)
			{
				$success = array(
					'response' 	=> 'ok',
					'msg'	 	=> 'Campaign targeting has been set sucessfully',
					
				);
				$this->response($success,200); 
			}
			else
			{
				$error = array(
					'response' 	=> 'error',
					'msg'	 	=> 'Please try again'
					
					);
				$this->response($error,200); 
			}
	}
	/*
	 * name: os_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set os targeting for a campaign
	 * 
	 */
	public function os_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="deliveryLimitations:Client:Os";
			$comparison= "==";
			$executionorder="1";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: time_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set os targeting for a campaign
	 * 
	 */
	public function time_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="deliveryLimitations:Time:Hour";
			$comparison= "==";
			$executionorder="2";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	
	

	/*
	 * name: geo_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set geo targeting for a campaign
	 * 
	 */
	public function geo_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="deliveryLimitations:Geo:Country";
			$comparison= "==";
			$executionorder="3";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}

	/*
	 * name: profile_targeting_age_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set age targeting for a campaign
	 * 
	 */
	public function profile_targeting_age_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="profile:age";
			$comparison= "==";
			$executionorder="4";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	
	
	
	/*
	 * name: profile_targeting_keyword_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set keyword targeting for a campaign
	 * 
	 */
	public function profile_targeting_keyword_post()
	{
		//Prepare the target data
		$campaign_id               = '';
		$prepared_data             = '';
		$compiledlimitation_prefix = '';
		$compiledlimitation_suffix = '';
		$compiledlimitation        = '';
		$acl_plugins               = '';
		$targ_value                = clean_data($this->post('value'));
		if ($targ_value)
		{
			foreach ($targ_value as $data)
			{
				$prepared_data .= $data . ',';
			}
			$prepared_data = substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data = FALSE;
		}
		$campaign_id    = clean_data($this->post('pk'));
		$logical        = "or";
		$type           = "profile:keyword";
		$comparison     = "==";
		$executionorder = "6";
		$ox_acls_data   = array(
			"campaignid" => $campaign_id,
			"logical" => $logical,
			"type" => $type,
			"comparison" => $comparison,
			"data" => $prepared_data,
			"executionorder" => $executionorder
		);
		
		
		if ($prepared_data != FALSE)
		{
			$ox_acls = $this->do_targeting->add($ox_acls_data, $campaign_id);
			
		}
		else
		{
			$ox_acls = $this->do_targeting->delete($ox_acls_data, $campaign_id);
		}
		if ($ox_acls !== FALSE)
		{
			
			$success = array(
				'response' => 'ok',
				'msg' => $this->lang->line('campaign_target_success')//'Camapign targeting has been set sucessfully'
			);
			
			$this->response($success, 200);
		}
		else
		{
			echo "false";
			exit;
			$error = array(
				'response' => 'error',
				'msg' => $this->lang->line('error_try_again')//'Please try again'
			);
			$this->response($error, 200);
		}
	}
	
	/*
	 * name: profile_targeting_gender_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set gender targeting for a campaign
	 * 
	 */
	 
	public function profile_targeting_gender_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="profile:gender";
			$comparison= "==";
			$executionorder="5";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: profile_targeting_age_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set color targeting for a campaign
	 * 
	 */
	public function profile_targeting_color_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="profile:color";
			$comparison= "==";
			$executionorder="6";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: profile_targeting_height_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set height targeting for a campaign
	 * 
	 */
	public function profile_targeting_height_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="profile:height";
			$comparison= "==";
			$executionorder="7";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: profile_targeting_weight_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set weight targeting for a campaign
	 * 
	 */
	public function profile_targeting_weight_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="profile:weight";
			$comparison= "==";
			$executionorder="8";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	
	/*
	 * name: frequency_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method frequency for the campaign is set
	 * 
	 */
	public function frequency_targeting_post()
	{
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value['targ_capping']!=''){
			$capping=$targ_value['targ_capping'];}
		else{
			$capping='0';}
			
		if($capping!=' ')
		{
			$campaign_id = clean_data($this->post('pk'));

			$block=$targ_value['targ_capping_block']*3600;
		
			$ox_campaigns_frquency_data=	array("block"=> $block,"session_capping"=> $capping);

			$ox_campaigns_frquency=$this->do_targeting->update_capping($ox_campaigns_frquency_data,$campaign_id);

			if($ox_campaigns_frquency !== FALSE)
			{
				$success = array(
					'response' 	=> 'ok',
					'msg'	 	=> 'Camapign targeting has been set sucessfully',
					
				);
				$this->response($success,200); 
			}
			else
			{
				$error = array(
					'response' 	=> 'error',
					'msg'	 	=> 'Please try again'
					
					);
				$this->response($error,200); 
			}
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}

	/*
	 * name: mobile_os_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile os targeting for a campaign
	 * 
	 */
	public function mobile_os_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="os";
			$comparison= "==";
			$executionorder="0";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_manu_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile manufractures targeting for a campaign
	 * 
	 */
	public function mobile_manu_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="handset";
			$comparison= "==";
			$executionorder="1";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_capability_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile capability targeting for a campaign
	 * 
	 */
	public function mobile_capability_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="capability";
			$comparison= "==";
			$executionorder="2";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_telecom_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile capability targeting for a campaign
	 * 
	 */
	public function mobile_telecom_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="teleco";
			$comparison= "==";
			$executionorder="3";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_geo_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will set mobile geo targeting for a campaign
	 * 
	 */
	public function mobile_geo_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = clean_data($this->post('value'));

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = clean_data($this->post('pk'));
			$logical="or";
			$type="country";
			$comparison= "==";
			$executionorder="4";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	
  /*
   * 
   * name: add
   * @param : categoryname,categoryvalue
   * @return :lastinsertid
   * 
   * Fetch list of n/w users (pub or adv)
   */
	public function add_post(){
		
		$this->form_validation->set_rules('category_name', 'Category Name', 'required|trim');
		#$this->form_validation->set_message('is_unique', 'Already this category name is being registered. please enter the unique one');
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$category_name	= clean_data($this->post('category_name'));
			$parent_value 	= clean_data($this->post('parent_value'));
		
			
			
			$ins_data = array('category_name'		=>clean_data($category_name),
							  'value'				=>clean_data($parent_value),
						      'parent_category_id'	=>clean_data($parent_value)
						      );
				
			$category = $this->do_targeting->add_category($ins_data);
			
			   /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,SUB_CAT_ADD);				
				if($enable=='1')
				{										
				$this->activity_log(SUB_CATEGORY,ADD);
				}
				/* Activity Log - End*/
			
			
			
			
			$final_cat_val 	= $parent_value.'-'.$category;
			
			$update_main 	= $this->do_targeting->update_category_value($category,$final_cat_val);
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Category has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding category!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
   /*
   * 
   * name: fetch
   * @param : 
   * @return :all the creatives details need to be approve
   * 
   */
	public function fetch_get()
	{
		 $cat_list = $this->do_targeting->fetch();
		 $this->response($cat_list);
	}
	
   /*
   * 
   * name: fetch_select
   * @param : category_id
   * @return :categoryname,categoryvalue
   * 
   */
	public function category_get()
	{
	    $cat_id = $this->get('category_id');
	   if($cat_id){
	   $cat_list = $this->do_targeting->fetch_select($cat_id);
	   $this->response($cat_list);
	 }
	   
   }
   
   /*
   * 
   * name: update_category
   * @param : categoryname,categoryvalue,categoryid
   * @return : category id
   * 
   */
   public function update_category_post()
   {
		$this->form_validation->set_rules('category_name', 'Category Name', 'required|trim');
		#$this->form_validation->set_message('is_unique', 'Already this category name is being registered. please enter the unique one');
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
		$insert_data=array('category_id'=> clean_data($this->post('category_id')),'category_name'=> clean_data($this->post('category_name')));
           


			$category_update = $this->do_targeting->update_category($insert_data);
			
			   /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,SUB_CAT_EDIT);				
				if($enable=='1')
				{										
				$this->activity_log(SUB_CATEGORY,EDIT);
				}
				/* Activity Log - End*/
			
			
			
			
			if($category_update !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Category has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding category!..'
					);
				
				$this->response( $success, 200);
			}
	   }		
   }
   
  /*
   * 
   * name: delete_category
   * @param : categoryid
   * @return : status true or false
   * 
   */
   
   public function delete_category_get()
   {
      $cat_id = $this->get('sub_category_id');
     if($cat_id)
      {
       $results= $this->del_subcat($cat_id);
  
       	$success = array('response'	=> 'ok','msg'		=> 'Category has been deleted');
		$this->response( $success, 200);
   

      }
      else
      {
       
        $subcat_id = $this->get('subcat_id');
        $arrays	=	explode(',',$subcat_id);

          	 if(is_array($arrays))
			{  
				foreach($arrays as $cat_id)
				{

					 $results= $this->del_subcat($cat_id);
	
	 	     	}

       	$success = array('response'	=> 'ok','msg'		=> 'Category has been deleted');
		$this->response( $success, 200);
  

		
		}
      }
     
   }
   
   function del_subcat($cat_id)
   {  
	   if($cat_id)
		{
			$chk_cat_parent = $this->do_targeting->check_category($cat_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,SUB_CAT_DELETE);				
				if($enable=='1')
				{										
				$this->activity_log(SUB_CATEGORY,DELETE);
				}
				/* Activity Log - End*/			
			
			
			if($chk_cat_parent[0]['parent_category_id']=='0')
			{
			
				$cat_list 		= $this->do_targeting->delete_assoc_category($cat_id,$chk_cat_parent[0]['value']);
			}
			else
			{				
				$cat_list 		= $this->do_targeting->delete_category($cat_id);
			}

			
		}

   }
   /*
   * 
   * name: add_os_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_os_post(){
		
		$this->form_validation->set_rules('device_os', 'Device Name', 'required|trim|is_unique['.TAB_TARG_OS.'.name]');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		$this->form_validation->set_rules('os_value', 'OS Value', 'required|trim|is_unique['.TAB_TARG_OS.'.value]');
		$this->form_validation->set_rules('device[]', 'Device', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device value is being registered. please enter the unique one');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->do_targeting->add_os(clean_data($this->post('device_os')),clean_data($this->post('os_value')),$this->post('device'));
			
			   /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,OS_ADD);				
				if($enable=='1')
				{										
				$this->activity_log(OS,ADD);
				}
				/* Activity Log - End*/
			
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Operating System has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Operating System!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	function add_os_version_post(){
		
		$this->form_validation->set_rules('device_os', 'OS Name', 'required|trim|is_unique['.TAB_TARG_OS.'.name]');

		$this->form_validation->set_rules('os_value', 'OS Value', 'required|trim|is_unique['.TAB_TARG_OS.'.value]');


		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->do_targeting->add_os_version(clean_data($this->post('device_os')),clean_data($this->post('os_value')));
								
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Operating System version has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Operating System!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_os_get
   * @param : none
   * @return :all the os details.
   * 
   */
   public function fetch_os_name_get()
   {
	   $os_names_list=$this->do_targeting->fetch_os_name();
	   $this->response($os_names_list);
   }
   
	public function fetch_os_get()
	{
		 $os_list = $this->do_targeting->fetch_os();
		 $this->response($os_list);
	}
	public function fetch_os_version_get()
	{
		 $os_list = $this->do_targeting->fetch_os_version();
		 $this->response($os_list);
	}
	public function fetch_os_vers_data_get()
	{
	   $id = $this->get('id');
	   if($id)
	   { 
		 $os_edit_list = $this->do_targeting->fetch_os_vers_data($id);
		 $this->response($os_edit_list);
		}
	}
	
   /*
   * 
   * name: os_list_get
   * @param : none
   * @return :selected os details.
   * 
   */
	public function os_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $os_list = $this->do_targeting->fetch_os_select($id);
	   $this->response($os_list);
       }
	}
	
   /*
   * 
   * name: update_os_post
   * @param : none
   * @return : os id
   * 
   */ 
	public function update_os_post()
	{
	    $this->form_validation->set_rules('device_os', 'Device Name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		$this->form_validation->set_rules('os_value', 'OS Value', 'required|trim');
		$this->form_validation->set_rules('edit_device[]', 'Device', 'required|trim');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{  
			$in_data=array('device_os'=>clean_data($this->post('device_os')),'os_value' =>clean_data($this->post('os_value')), 'edit_device'=>clean_data($this->post('edit_device')),'os_id'=> clean_data($this->post('os_id')));
			$operating_sys = $this->do_targeting->update_os($in_data);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,OS_EDIT);				
				if($enable=='1')
				{										
				$this->activity_log(OS,EDIT);
				}
				/* Activity Log - End*/		
			
			
			if($operating_sys !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Operating System has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in updating Operating System!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	public function update_os_version_post()
	{
	  

		$this->form_validation->set_rules('os_value', 'OS Value', 'required|trim');

		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{  
			$in_data=array('device_os'=>clean_data($this->post('device_os')),'os_value' =>clean_data($this->post('os_value')),'os_id'=> clean_data($this->post('os_id')));
			$operating_sys = $this->do_targeting->update_os_version($in_data);			
						
			if($operating_sys !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'OS Version has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in updating Operating System!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
   /*
   * 
   * name: delete_os_get
   * @param : none
   * @return : status true or false
   * 
  */
   public function delete_os_get()
   {
      $id = $this->get('os_id');
      $del_os_id=$this->get('delos_id');
     
    $arrays=	explode(',',$del_os_id);
    if($id)
    { 
	   $results= $this->del_os($id);
       if($results)
       {
	   $success = array('response'	=> 'ok','msg'=> 'Operating system has been deleted');
	   $this->response( $success, 200);
		}
		else
		{
			
			$error = array('response'	=> 'ok','msg'=> 'Operating system is not found');
		   $this->response( $error, 200);
			
		}
     }
	 else if(is_array($arrays))
	 {  
			foreach($arrays as $os_id)
				{
					$results= $this->del_os($os_id);	
	 	     	}
	   $success = array('response'	=> 'ok','msg'=> 'Operating system has been deleted');
	   $this->response( $success, 200);
	 }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Operating system id is not found'
					);
			
			$this->response( $error, 200);
		}
    }
   public function delete_os_version_get()
   {
      $id = $this->get('os_id');
      $del_os_id=$this->get('delos_id');
     
      $arrays=	explode(',',$del_os_id);
     if($id)
      {
       $results= $this->del_os_version($id);
       if($results)
       {
	   $success = array('response'	=> 'ok','msg'=> 'OS Version  has been deleted');
	   $this->response( $success, 200);
	}
	else{
		$error = array('response'	=> 'ok','msg'=> 'OS Version is not found');
	   $this->response( $error, 200);
		
	}
      }else if(is_array($arrays))
			{  
				foreach($arrays as $os_id)
				{

					 $results= $this->del_os_version($os_id);
	
	 	     	}
	   $success = array('response'	=> 'ok','msg'=> 'OS Version has been deleted');
	   $this->response( $success, 200);
		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'OS Version id is not found'
					);
			
			$this->response( $error, 200);
		}
    }

function del_os($id)
{	
	   if($id)
		{
			 $del_os_list = $this->do_targeting->delete_os($id); 

			 /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,OS_DELETE);				
				if($enable=='1')
				{										
				$this->activity_log(OS,DELETE);				
				}
				/* Activity Log - End*/			
			 
			return $del_os_list;
		}
}
function del_os_version($id)
{
	   if($id)
		{
			 $del_os_list = $this->do_targeting->delete_os_version($id);   
			return $del_os_list;
		}
}


   
   
    /*
   * 
   * name: add_browser_post
   * @param : none
   * @return :lastinsertid
   * 
   */
	function add_browser_post(){
		
		$this->form_validation->set_rules('browser_name', 'Browser name', 'required|trim|is_unique['.TAB_TARG_BROWSERS.'.name]');
		//$this->form_validation->set_message('is_unique', 'Already this Browser name is being registered. please enter the unique one');
		$this->form_validation->set_rules('browser_code', 'Browser code', 'required|trim|is_unique['.TAB_TARG_BROWSERS.'.value]');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$browser_data=array('browser_name'=>clean_data($this->post('browser_name')),'browser_code' =>clean_data($this->post('browser_code')));			
			$category = $this->do_targeting->add_browser($browser_data);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_ADD);												
				if($enable=='1')
				{					
				$this->activity_log(BROWSERS,ADD);
				}
				/* Activity Log - End*/
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Browser has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Browser!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	function add_browser_version_post(){
		
		$this->form_validation->set_rules('browser_name', 'Browser name', 'required|trim|is_unique['.TAB_TARG_BROWSERS.'.name]');
		
		$this->form_validation->set_rules('browser_version', 'Browser Version', 'required|trim|is_unique['.TAB_TARG_BROWSERS.'.value]');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$browser_data=array('browser_name'=>clean_data($this->post('browser_name')),'browser_version' =>clean_data($this->post('browser_version')));	 
			
			$category = $this->do_targeting->add_browser_version($browser_data);

				
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Browser Version has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Browser!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_browsers_get
   * @param : none
   * @return :all the browser details.
   * 
   */
	public function fetch_browsers_get()
	{
       $browser_list=$this->do_targeting->fetch_browser();

	   $this->response($browser_list); 
	}
	public function fetch_browsing_get()
	{
       $browsers_list=$this->do_targeting->fetch_browsings();

	   $this->response($browsers_list); 
	}


	public function fetch_browser_versions_get()
	{
       $browser_version_list=$this->do_targeting->fetch_browser_version();

	   $this->response($browser_version_list); 
	}
	
	/*
   * 
   * name: browser_list_get
   * @param : none
   * @return :slected  browser details.
   * 
   */
	public function browser_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $browser_list = $this->do_targeting->fetch_browser_select($id);
	   $this->response($browser_list);
       }
	}
	public function browser_version_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $browser_vers_list = $this->do_targeting->fetch_browser_version_select($id);
	   $this->response($browser_vers_list);
       }
	}
  
    /*
   * 
   * name: update_browser_post
   * @param : none
   * @return : browser id
   * 
   */ 
	public function update_browser_post()
	{
	   
	    $this->form_validation->set_rules('browser_name', 'Browser name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Browser name is being registered. please enter the unique one');
		$this->form_validation->set_rules('browser_code', 'Browser code', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$browser_data=array('browser_id'=>$this->post('browser_id'),'browser_name'=>clean_data($this->post('browser_name')),'browser_code' =>clean_data($this->post('browser_code')));			

			$category = $this->do_targeting->update_browser(clean_data($this->post()));
			
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_EDIT);												
				if($enable=='1')
				{					
				$this->activity_log(BROWSERS,EDIT);
				}
				/* Activity Log - End*/
			
			
			
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Browser has been updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Browser!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	public function update_browser_version_post()
	{
	   
	  //  $this->form_validation->set_rules('browser_name', 'Browser name', 'required|trim');
	     $this->form_validation->set_rules('browser_code', 'Browser Code', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Browser name is being registered. please enter the unique one');
		$this->form_validation->set_rules('browser_version', 'Browser Version', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$browser_data=array('browser_version_id'=>$this->post('browser_version_id'),'browser_version' =>clean_data($this->post('browser_version')));			

			$category = $this->do_targeting->update_browser_version(clean_data($this->post()));
			
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_EDIT);												
				if($enable=='1')
				{					
				$this->activity_log(BROWSERS,EDIT);
				}
				/* Activity Log - End*/
			
			
			
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Browser Version has been updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Browser!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	/*
   * 
   * name: delete_browser_get
   * @param : none
   * @return : status true or false
   * 
   */

	public function delete_browser_get()
   {
	   
    $id = $this->get('browser_id');
	$del_browser_id=$this->get('del_browser_id');
	$arrays=	explode(',',$del_browser_id);
     if($id)
      {   
       		$results= $this->del_browser($id);
       		$success = array('response'	=> 'ok','msg'		=> 'Browser has been deleted');
			$this->response( $success, 200);
      }
	  else if(is_array($arrays))
			{   				
				foreach($arrays as $id)
				{
				$results= $this->del_browser($id);
				}
	 	     	$success = array('response'	=> 'ok','msg'		=> 'Browser has been deleted');
			    $this->response( $success, 200);

		     }

      else{ 
			$error = array(	'response' => 'error','msg'	 => 'Browser id is not found');
			$this->response( $error, 200);

		}
   }
	public function delete_browser_version_get()
   {
     $id = $this->get('browser_version_id');
	 $del_browser_id=$this->get('del_browser_vers_id');
	 $arrays=	explode(',',$del_browser_id);
     if($id)
      {
       		$results= $this->do_targeting->delete_browser_version($id);
       		$success = array('response'	=> 'ok','msg'		=> 'Browser Version has been deleted');
			$this->response( $success, 200);
      }else if(is_array($arrays))
			{  
				foreach($arrays as $id)
				{
				$results= $this->do_targeting->delete_browser_version($id);
				}
	 	     	$success = array('response'	=> 'ok','msg'		=> 'Browser Version has been deleted');
			    $this->response( $success, 200);

		     }

      else{
			$error = array(	'response' => 'error','msg'	 => 'Browser id is not found');
			$this->response( $error, 200);

		}
   }
function del_browser($id)
{

	   if($id)
		{
			$browser_list = $this->do_targeting->delete_browser($id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_DELETE);												
				if($enable=='1')
				{					
				$this->activity_log(BROWSERS,DELETE);
				}
				/* Activity Log - End*/
		}
}
  /*
   * 
   * name: add_manu_post
   * @param : manuname,manuvalue
   * @return :lastinsertid
   * 
   */
   function add_manu_post(){
		
		$this->form_validation->set_rules('manu_name', 'Manufacturers name', 'required|trim|is_unique['.TAB_MOB_MANUFACT.'.name]');
		//$this->form_validation->set_message('is_unique', 'Already this Manufacturers name is being registered. please enter the unique one');
		$this->form_validation->set_rules('manu_value', 'Manufacturers value', 'required|trim|is_unique['.TAB_MOB_MANUFACT.'.value]');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$manu_id = $this->do_targeting->add_manu(clean_data($this->post()));
			
			
			  /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,MANUFACTURER_ADD);				
				if($enable=='1')
				{										
				$this->activity_log(MANUFACTURES,ADD);
				}
				/* Activity Log - End*/
			
			
			
			if($manu_id !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Manufacturers has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Manufacturers!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
  /*
   * 
   * name: fetch_manu_get
   * @param : none
   * @return :all the manufacturers details.
   * 
   */
	public function fetch_manu_get()
	{
       $manu_list=$this->do_targeting->fetch_manu();
	   $this->response($manu_list); 
	}
	
  /*
   * 
   * name: manu_list_get
   * @param : none
   * @return :all the selected manufacturers details.
   * 
   */
	public function manu_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $manu_list = $this->do_targeting->fetch_manu_select($id);
	   $this->response($manu_list);
       }
	}
	
   /*
   * 
   * name: update_manu_post
   * @param : none
   * @return : category id
   * 
   */
	public function update_manu_post(){
	    
		$this->form_validation->set_rules('manu_name', 'Manufacturers name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Manufacturers name is being registered. please enter the unique one');
		$this->form_validation->set_rules('manu_value', 'Manufacturers value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$manu_id = $this->do_targeting->update_manu(clean_data($this->post()));
			
			if($manu_id !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Manufacturers has been updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Manufacturers!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	}
	
   /*
   * 
   * name: delete_manu_get
   * @param : manufacturers id
   * @return : status true or false
   * 
   */
   
	public function delete_manu_get(){
	  
	  $id = $this->get('manu_id');
	  
	   if($id)
		{
			$manu_list = $this->do_targeting->delete_manu($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Manufacturers has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Manufacturers id is not found'
					);
			
			$this->response( $error, 200);
		}
	
	}
	
	
   /*
   * 
   * name: add_mobile_os_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_mobile_os_post(){
		
		$this->form_validation->set_rules('device_os', 'Mobile OS Name', 'required|trim|is_unique['.TAB_TARG_MOB_OS.'.name]');
		$this->form_validation->set_rules('os_value', 'OS Value', 'required|trim|is_unique['.TAB_TARG_MOB_OS.'.value]');
		//$this->form_validation->set_message('is_unique', 'Mobile Os Value already Exists');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$mobile_os = $this->do_targeting->add_mobile_os(clean_data($this->post('device_os')),clean_data($this->post('os_value')));
			
			if($mobile_os !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => ' Mobile Operating System has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding  Mobile Operating System!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_mobile_os_get
   * @param : none
   * @return :all the os details.
   * 
   */
   
	public function fetch_mobile_os_get()
	{
		 $os_list = $this->do_targeting->fetch_mobile_os();
		 $this->response($os_list);
	}
	
   /*
   * 
   * name: mobile_os_list_get
   * @param : none
   * @return :selected os details.
   * 
   */
	public function mobile_os_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $os_list = $this->do_targeting->fetch_mobile_os_select($id);
	   $this->response($os_list);
       }
	}
	
   /*
   * 
   * name: update_mobile_os_post
   * @param : none
   * @return : os id
   * 
   */ 
	public function update_mobile_os_post()
	{
	    $this->form_validation->set_rules('device_os', 'Mobile OS Name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		$this->form_validation->set_rules('os_value', 'Mobile OS Value', 'required|trim|callback_mobile_os_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$operating_sys = $this->do_targeting->update_mobile_os(clean_data($this->post()));
			
			if($operating_sys !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Mobile Operating System has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in updating Mobile Operating System!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	
	function mobile_os_check()
	{
		$os_id		=   clean_data($this->post('os_id'));
		$os_value	=	strtolower(clean_data(clean_data($this->post('os_value'))));
		$table_name =   TAB_TARG_MOB_OS;
		$count 		= 	$this->do_email_check->mobile_targeting_check($table_name,$os_value,$os_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('mobile_os_check', 'Mobile OS value already Exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
   /*
   * 
   * name: delete_mobile_os_get
   * @param : none
   * @return : status true or false
   * 
  */
  public function delete_mobile_os_get()
   {
      $id = $this->get('id');
	  
	   if($id)
		{
			 $cat_list = $this->do_targeting->delete_mobile_os($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Mobile Operating system has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Mobile Operating system id is not found'
					);
			
			$this->response( $error, 200);
		}

   }
	
	
	
	/*
   * 
   * name: add_mobile_manufacturers_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_mobile_manufacturers_post(){
		
		$this->form_validation->set_rules('manu_name', 'Mobile Manufacturer Name', 'required|trim|is_unique['.TAB_TARG_MOB_MANU.'.name]');		
		$this->form_validation->set_rules('manu_value', 'Mobile Manufacturer Value', 'required|trim|is_unique['.TAB_TARG_MOB_MANU.'.value]');
		//$this->form_validation->set_message('is_unique', 'Mobile Manufacturer Value already Exists');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$mobile_manufacturer = $this->do_targeting->add_mobile_manufacturers(clean_data($this->post('manu_name')),clean_data($this->post('manu_value')));
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,MANUFACTURER_ADD);				
				if($enable=='1')
				{										
				$this->activity_log(MANUFACTURES,ADD);
				}
				/* Activity Log - End*/		
			
			
			
			if($mobile_manufacturer !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => ' Mobile manufacturer has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding  Mobile manufacturer!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_mobile_manufacturers_get
   * @param : none
   * @return :all the manufacturer details.
   * 
   */
   
	public function fetch_mobile_manufacturers_get()
	{
		 $manufacturer_list = $this->do_targeting->fetch_mobile_manufacturers();
		 $this->response($manufacturer_list);
	}
	
   /*
   * 
   * name: mobile_manufacturers_list_get
   * @param : none
   * @return :selected manufacturer details.
   * 
   */
	public function mobile_manufacturers_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $manufacturer_list = $this->do_targeting->fetch_mobile_manufacturers_select($id);
	   $this->response($manufacturer_list);
       }
	}
	
   /*
   * 
   * name: update_mobile_manufacturers_post
   * @param : none
   * @return : manufacturer id
   * 
   */ 
	public function update_mobile_manufacturers_post()
	{
	   	$this->form_validation->set_rules('manu_name', 'Mobile Manufacturer Name', 'required|trim');		
		$this->form_validation->set_rules('manu_value', 'Mobile Manufacturer Value', 'required|trim|callback_mobile_manufacturer_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$manu_data=array('manu_id'=>clean_data($this->post('manu_id')),'manu_name'=>clean_data($this->post('manu_name')),'manu_value'=>clean_data($this->post('manu_value')));		
            $manufacturers = $this->do_targeting->update_mobile_manufacturers($manu_data);
            
            
            /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,MANUFACTURER_EDIT);				
				if($enable=='1')
				{										
				$this->activity_log(MANUFACTURES,EDIT);
				}
				/* Activity Log - End*/		
			
            
            
			
			if($manufacturers !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Mobile Operating System has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in updating Mobile Operating System!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	/*
	 * name: mobile_manufacturer_check
	 * @param : none
     * @return : status true or false
	 * 
	 * */
	 
	 
	function mobile_manufacturer_check()
	{
		$manu_id	= 	clean_data($this->post('manu_id'));
		$manu_value	=	strtolower(clean_data($this->post('manu_value')));
		$table_name =   TAB_TARG_MOB_MANU;
		$count 		= 	$this->do_email_check->mobile_targeting_check($table_name,$manu_value,$manu_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('mobile_manufacturer_check', 'Mobile Manufacturer Value already Exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
	
	
   /*
   * 
   * name: delete_mobile_manufacturers_get
   * @param : none
   * @return : status true or false
   * 
  */
  public function delete_mobile_manufacturers_get()
   {
      

      $id = $this->get('mob_manu_id');
	  $del_id=$this->get('del_id');
	  $arrays=	explode(',',$del_id);
      if($id)
      {
       	$results = $this->Mob_Del_Manu($id);
		$success = array('response'	=> 'ok','msg'=> 'Mobile Manufacturers has been deleted successfully!..');
		$this->response( $success, 200);
      }else if(is_array($arrays) && !empty($del_id))
			{  
				foreach($arrays as $del_id)
				{

					 $results= $this->Mob_Del_Manu($del_id);
		 	   	}
			$success = array('response'	=> 'ok','msg'=> 'Mobile Manufacturers has been deleted successfully!..');
			$this->response( $success, 200);
		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Mobile Manufacturers id is not found!'
					);
			
			$this->response( $error, 200);
		}
   }
   
   
   function Mob_Del_Manu($id)
   {
   		   if($id)
		{
			$manufacturer_list = $this->do_targeting->delete_mobile_manufacturers($id);
			
			 /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,MANUFACTURER_DELETE);				
				if($enable=='1')
				{										
				$this->activity_log(MANUFACTURES,DELETE);
				}
				/* Activity Log - End*/		
			
	
	
		}
   }
   /*
   * 
   * name: add_mobile_capability_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_mobile_capability_post(){
		
		$this->form_validation->set_rules('capability_name', 'Mobile Capability Name', 'required|trim|is_unique['.TAB_TARG_MOB_CAPA.'.name]');		
		$this->form_validation->set_rules('capability_value', 'Mobile Capability Value', 'required|trim|is_unique['.TAB_TARG_MOB_CAPA.'.value]');
		//$this->form_validation->set_message('is_unique', 'Mobile Capability Value already Exists');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$mobile_capability = $this->do_targeting->add_mobile_capability(clean_data($this->post('capability_name')),clean_data($this->post('capability_value')));
			
			
			  /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,CAP_ADD);				
				if($enable=='1')
				{										
				$this->activity_log(CAPABILITY,ADD);   
				}
				/* Activity Log - End*/  
			
			
			
			
			if($mobile_capability !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => ' Mobile Capability has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding  Mobile Capability!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_mobile_capability_get
   * @param : none
   * @return :all the Capability details.
   * 
   */
   
	public function fetch_mobile_capability_get()
	{
		 $capability_list = $this->do_targeting->fetch_mobile_capability();
		 $this->response($capability_list);
	}
	
   /*
   * 
   * name: mobile_capability_list_get
   * @param : none
   * @return :selected Capability details.
   * 
   */
	public function mobile_capability_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $capability_list = $this->do_targeting->fetch_mobile_capability_select($id);
	   $this->response($capability_list);
       }
	}
	
   /*
   * 
   * name: update_mobile_capability_post
   * @param : none
   * @return : capability id
   * 
   */ 
	public function update_mobile_capability_post()
	{
	  $this->form_validation->set_rules('capability_name', 'Mobile Capability Name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		$this->form_validation->set_rules('capability_value', 'Mobile Capability Value', 'required|trim|callback_mobile_capability_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$capability_data=array('capability_id'=>clean_data($this->post('capability_id')),'capability_name'=>clean_data($this->post('capability_name')),'capability_value'=>clean_data($this->post('capability_value')));			
			$capability = $this->do_targeting->update_mobile_capability($capability_data);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,CAP_EDIT);				
				if($enable=='1')
				{										
				$this->activity_log(CAPABILITY,EDIT);   
				}
				/* Activity Log - End*/  
			
			
			if($capability !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Mobile Capability has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in updating Mobile capability!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	
	/*
	 * name: mobile_capability_check
	 * @param : none
     * @return : status true or false
	 * 
	 * */
	 
	 
	function mobile_capability_check()
	{
		$cap_id	= 		clean_data($this->post('capability_id'));
		$cap_value	=	strtolower(clean_data($this->post('capability_value')));
		$table_name =   TAB_TARG_MOB_CAPA;
		$count 		= 	$this->do_email_check->mobile_targeting_check($table_name,$cap_value,$cap_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('mobile_capability_check', 'Mobile Capability Value already Exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
   /*
   * 
   * name: delete_mobile_capability_get
   * @param : none
   * @return : status true or false
   * 
  */
  public function delete_mobile_capability_get()
   {
      $id = $this->get('capability_id');
		$mob_capability_id = $this->get('mob_capability_id');
	   if($id)
		{
			$arrays	=	explode(',',$id);

			if(is_array($arrays))
			{ 
				foreach($arrays as $id)
				{				
					$manufacturer_list = $this->do_targeting->delete_mobile_capability($id);
					
					/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,CAP_DELETE);				
					if($enable=='1')
					{										
					$this->activity_log(CAPABILITY,DELETE);   
					}
					/* Activity Log - End*/  
				
				}
			}
			else
			{ 
				$manufacturer_list = $this->do_targeting->delete_mobile_capability($id);
				
				/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,CAP_DELETE);				
					if($enable=='1')
					{										
					$this->activity_log(CAPABILITY,DELETE);   
					}
					/* Activity Log - End*/  
				
			}
			$success = array('response'	=> 'ok','msg'=> 'Mobile Capability has been deleted successfully!..');
			$this->response( $success, 200);
		}
		else if($mob_capability_id){
				$manufacturer_list = $this->do_targeting->delete_mobile_capability($mob_capability_id);
				
				/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,CAP_DELETE);				
					if($enable=='1')
					{										
					$this->activity_log(CAPABILITY,DELETE);   
					}
					/* Activity Log - End*/ 
					$success = array('response'	=> 'ok','msg'=> 'Mobile Capability has been deleted successfully!..');
				$this->response( $success, 200); 
		}
		else
		{
			$error = array(	'response' => 'error','msg'	 => 'Mobile Capability id is not found');
			$this->response( $error, 200);
		}

   }   
      
	/*
   * 
   * name: block_category
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function block_category_get()
	{
	    $cat_id=$this->get('cat_id');
	    $arrays	=	explode(',',$cat_id);
	    if(is_array($arrays))
			{  
				foreach($arrays as $cat_id)
				{
					 $results= $this->block_cat($cat_id);
				}
					
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Category is blocked successfully.. '
										);
					
					$this->response( $success, 200);
			}
			else
			{
				$results= $this->block_cat($cat_id);
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Category is blocked successfully..'
										);
					
				$this->response( $success, 200);
			}

	}

	function block_cat($cat_id)
	{
		
		if($cat_id)
		{
				$block_category = $this->do_targeting->block_category($cat_id);
			
				$parent_category_id = $this->do_targeting->category_parent_id($cat_id);
				
							
			/* Activity Log - Start*/	
				if($parent_category_id!='0')
				{ 
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,SUB_CAT_BLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(SUB_CATEGORY,BLOCK);
				}
				}
				else
				{ 
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,MAIN_CAT_BLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(MAIN_CATEGORY,BLOCK);
				}
				}
				/* Activity Log - End*/		
			
		}
	}
	
	   /*
   * 
   * name: unblock_category
   * @param : categoryid
   * @return :sucess msg
   * 
   */
	public function unblock_category_get()
	{
	    $cat_id=$this->get('cat_id');
	    if($cat_id)
	    {
	    	$results= $this->unblock_cat($cat_id);
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Category is Un-blocked successfully..'
										);
					
				$this->response( $success, 200);
	    }else
	    {
	    $sub_cat_id=$this->get('sub_cat_id');
        $arrays	=explode(',',$sub_cat_id);
	    if(is_array($arrays))
			{  
				foreach($arrays as $cat_id)
				{
					 $results= $this->unblock_cat($cat_id);
				}
					
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Category is Un-blocked successfully.. '
										);
					
					$this->response( $success, 200);
			}
	    }

       
				
	}
	
	function unblock_cat($cat_id)
	{
		if($cat_id)
		{			
			$block_category = $this->do_targeting->unblock_category($cat_id);
			
			$parent_category_id = $this->do_targeting->category_parent_id($cat_id);
			
			/* Activity Log - Start*/	
				if($parent_category_id!='0')
				{
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,SUB_CAT_UNBLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(SUB_CATEGORY,UNBLOCK);
				}
				}
				else
				{
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,MAIN_CAT_UNBLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(MAIN_CATEGORY,UNBLOCK);
				}
				}
				/* Activity Log - End*/
			
			
			
		}
	}
	      
	/*
   * 
   * name: block_category
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function block_os_get()
	{
	    $os_id=$this->get('id');
        if($os_id)
        {
        	 $results= $this->blockos($os_id);
        	 $success = array('response'	=> 'ok',
							 'msg'		=> 'Operating system is blocked successfully'
							 );
			 $this->response( $success, 200);
        }else {

        $a_os_id=$this->get('opt_os_id');
	    $arrays	=	explode(',',$a_os_id);
       	 if(is_array($arrays))
			{  
				foreach($arrays as $os_id)
				{

					 $results= $this->blockos($os_id);
	
	 	     	}

       		$success = array('response'	=> 'ok',
							 'msg'		=> 'Operating system is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}

        }
	    
		
	}
	public function block_os_version_get()
	{
	    $os_id=$this->get('id');
        if($os_id)
        {
        	 $results= $this->blockosversion($os_id);
        	 $success = array('response'	=> 'ok',
							 'msg'		=> 'OS version is blocked successfully'
							 );
			 $this->response( $success, 200);
        }else {

        $a_os_id=$this->get('opt_os_id');
	    $arrays	=	explode(',',$a_os_id);
       	 if(is_array($arrays))
			{  
				foreach($arrays as $os_id)
				{

					 $results= $this->blockosversion($os_id);
	
	 	     	}

       		$success = array('response'	=> 'ok',
							 'msg'		=> 'OS version is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}

        }
	    
		
	}
	function blockos($os_id)
	{
		if($os_id)
		{
			$block_category = $this->do_targeting->block_os($os_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,OS_BLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(OS,BLOCK);
				}
				/* Activity Log - End*/		
			
			
		}
	}
	function blockosversion($os_id)
	{
		if($os_id)
		{
			$block_category = $this->do_targeting->block_os_version($os_id);
		
		}
	}
	   /*
   * 
   * name: unblock_category
   * @param : categoryid
   * @return :sucess msg
   * 
   */
	public function unblock_os_get()
	{
	    $os_id=$this->get('id');

	    if($os_id)
        {
        	 $results= $this->unblockos($os_id);
		     $success = array('response'	=> 'ok',
							 'msg'		=> 'Operating system is Un-blocked successfully'
							 );
			 $this->response( $success, 200);
        }else {

        $unb_os_id=$this->get('unblockos_id');
	    $arrays	=	explode(',',$unb_os_id);
       	 if(is_array($arrays))
			{  
				foreach($arrays as $os_id)
				{

					 $results= $this->unblockos($os_id);
	
	 	     	}

		     $success = array('response'	=> 'ok','msg'=> 'Operating system is Un-blocked successfully'
							 );
			 $this->response( $success, 200);
		}

        }


	}
	public function unblock_os_version_get()
	{
	    $os_id=$this->get('id');

	    if($os_id)
        {
        	 $results= $this->unblockosversion($os_id);
		     $success = array('response'	=> 'ok',
							 'msg'		=> 'OS Version is Un-blocked successfully'
							 );
			 $this->response( $success, 200);
        }else {

        $unb_os_id=$this->get('unblockos_id');
	    $arrays	=	explode(',',$unb_os_id);
       	 if(is_array($arrays))
			{  
				foreach($arrays as $os_id)
				{

					 $results= $this->unblockosversion($os_id);
	
	 	     	}

		     $success = array('response'	=> 'ok','msg'=> 'OS Version is Un-blocked successfully'
							 );
			 $this->response( $success, 200);
		}

        }


	}

	function unblockos($os_id)
	{
		if($os_id)
		{
			$block_category = $this->do_targeting->unblock_os($os_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,OS_UNBLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(OS,UNBLOCK);
				}
				/* Activity Log - End*/		
			

		}

	}
	function unblockosversion($os_id)
	{
		if($os_id)
		{
			$block_category = $this->do_targeting->unblock_os_version($os_id);	

		}

	}
  
  	/*
   * 
   * name: block_browser
   * @param : browserid
   * @return : sucess msg
   * 
   */
	public function block_browser_get()
	{
	  $brow_id=$this->get('id');
	  	  	
      if($brow_id)
      {
	   $arrays=	explode(',',$brow_id);	
	   if(count($arrays)>1)
	   {
		   foreach($arrays as $brow_id)
				{
					$results= $this->blockbrowser($brow_id);
		 	   	}
	   }
	   else
	   {
	   $results = $this->blockbrowser($brow_id);
	   }
	   $success = array('response'	=> 'ok', 'msg'=> 'Browser is blocked successfully');
	   $this->response( $success, 200);
      }
	  else 
	  {   
 			$BBrowser_id=$this->get('BBrowser_id');
			$arrays=	explode(',',$BBrowser_id);	

			if(is_array($arrays))
			{
  
				foreach($arrays as $brow_id)
				{
					$results= $this->blockbrowser($brow_id);
		 	   	}
	              $success = array('response'	=> 'ok', 'msg'=> 'Browser is blocked successfully');
	              $this->response( $success, 200);
			}
			else
			{			
					$error = array(
									'response' => 'error',
									'msg'	 => 'Browser id is not found'
							);
					
					$this->response( $error, 200);
			}
	  }
     

	}
	public function block_browser_version_get()
	{
	  $brow_id=$this->get('id');//$this->response( $brow_id, 200);
	  $BBrowser_id=$this->get('BBrowser_id');
      $arrays=	explode(',',$brow_id);//$this->response( $arrays, 200);
 if(is_array($arrays))
			{  
				foreach($arrays as $brows_id)
				{

					 $results= $this->do_targeting->blockbrowserversion($brows_id);
		 	   	}
	   $success = array('response'	=> 'ok', 'msg'=> 'Browser Version is blocked successfully');
	   $this->response( $success, 200);
		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Browser id is not found'
					);
			
			$this->response( $error, 200);
		}

	}


	function blockbrowser($brow_id)
	{
		if($brow_id)
		{
			$block_category = $this->do_targeting->block_browser($brow_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_BLOCK);												
				if($enable=='1')
				{					
				$this->activity_log(BROWSERS,BLOCK);
				}
				/* Activity Log - End*/
			

		}
	}
	
	   /*
   * 
   * name: unblock_browser
   * @param : browserid
   * @return :sucess msg
   * 
   */
	public function unblock_browser_get()
	{
	 $brow_id=$this->get('id');
	 if($brow_id)
     {
		   $arrays=	explode(',',$brow_id);	
		   if(count($arrays)>1)
		   {
			   foreach($arrays as $brow_id)
					{
						$results= $this->unblock_brow($brow_id);
					}
		   }
		   else
		   {
		   $results = $this->unblock_brow($brow_id);
		   }	   
		   $success = array('response'	=> 'ok','msg'=> 'Browser is Un-blocked successfully');
		   $this->response( $success, 200);
      }
	  else
	  {  

			$Browser_id=$this->get('Browser_id');
			$arrays=	explode(',',$Browser_id);    

			if(is_array($arrays))
			{
  
				foreach($arrays as $brow_id)
				{
					$results= $this->unblock_brow($brow_id);
		 	   	}
	              $success = array('response'	=> 'ok', 'msg'=> 'Browser is Un-blocked successfully');
	              $this->response( $success, 200);
			}
			else
			{			
					$error = array(
									'response' => 'error',
									'msg'	 => 'Browser id is not found'
							);
					
					$this->response( $error, 200);
			}


	   }

    }
	
	
	
	public function unblock_browser_version_get()
	{
	  $brow_id=$this->get('id');
	  $Browser_id=$this->get('Browser_id');
      $arrays=	explode(',',$brow_id);//$this->response( explode(',',$brow_id), 200);
 if(is_array($arrays))
			{  
				foreach($arrays as $brow_id)
				{

					 $results= $this->do_targeting->unblock_browser_version($brow_id);
	
	 	     	}
	 	    $success = array('response'	=> 'ok','msg'=> 'Browser version is Un-blocked successfully');
			$this->response( $success, 200);

		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Browser id is not found'
					);
			
			$this->response( $error, 200);
		}

	}
	
	
	

	function unblock_brow($brow_id)
	{
		if($brow_id)
		{
			$unblock_browsers = $this->do_targeting->unblock_browser($brow_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_UNBLOCK);												
				if($enable=='1')
				{					
				$this->activity_log(BROWSERS,UNBLOCK);
				}
				/* Activity Log - End*/
			

		}
	}
   
   /*
   * 
   * name: block_manu
   * @param : browserid
   * @return : sucess msg
   * 
   */
	public function block_manu_get()
	{
	    $manu_id=$this->get('id');
		if($manu_id)
		{
			$block_category = $this->do_targeting->block_manu($manu_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Manufacturers is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_browser
   * @param : browserid
   * @return :sucess msg
   * 
   */
	public function unblock_manu_get()
	{
	    $manu_id=$this->get('id');
		if($manu_id)
		{
			$block_category = $this->do_targeting->unblock_manu($manu_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Manufacturers is Un-blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: mobile_block_category
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function mobile_block_os_get()
	{
	    $os_id=$this->get('id');
		if($os_id)
		{
			$block_category = $this->do_targeting->mobile_block_os($os_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Mobile Operating system is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_category
   * @param : categoryid
   * @return :sucess msg
   * 
   */
	public function mobile_unblock_os_get()
	{
	    $os_id=$this->get('id');
		if($os_id)
		{
			$block_category = $this->do_targeting->mobile_unblock_os($os_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Mobile Operating system is Un-blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
    
	  /*
   * 
   * name: mobile_block_manu
   * @param : manu id
   * @return : sucess msg
   * 
   */
	public function mobile_block_manu_get()
	{
	    $manu_id=$this->get('id');
	    $block_id=$this->get('block_id');
	    $arrays=	explode(',',$block_id);
     if($manu_id)
      {
       	$results = $this->Mob_Block_Manu($manu_id);
		$success = array('response'	=> 'ok','msg'=> 'Mobile Manufacturers is blocked successfully!..');
		$this->response( $success, 200);
      }else if(is_array($arrays) && !empty($block_id))
			{  
				foreach($arrays as $block_id)
				{

					 $results= $this->Mob_Block_Manu($block_id);
		 	   	}
			$success = array('response'	=> 'ok','msg'=> 'Mobile Manufacturers is blocked successfully!..');
			$this->response( $success, 200);
		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Mobile Manufacturers id is not found!'
					);
			
			$this->response( $error, 200);
		}
	}
	
    function Mob_Block_Manu($manu_id)
    {
		if($manu_id)
		{
			$block_category = $this->do_targeting->mobile_block_manu($manu_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,MANUFACTURER_BLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(MANUFACTURES,BLOCK);
				}
				/* Activity Log - End*/		
			

		}
    }	
	   /*
   * 
   * name: mobile_unblock_browser
   * @param : manu id
   * @return :sucess msg
   * 
   */
	public function mobile_unblock_manu_get()
	{
	    $manu_id=$this->get('id');
	    $unblock_id=$this->get('unblock_id');
	    $arrays=	explode(',',$unblock_id);

     if($manu_id)
      {
       	$results = $this->Mob_UnBlock_Manu($manu_id);
		$success = array('response'	=> 'ok','msg'=> 'Mobile Manufacturers is Un-blocked successfully!..');
		$this->response( $success, 200);
      }else if(is_array($arrays) && !empty($unblock_id))
			{  
				foreach($arrays as $unblock_id)
				{

					 $results= $this->Mob_UnBlock_Manu($unblock_id);
		 	   	}
			$success = array('response'	=> 'ok','msg'=> 'Mobile Manufacturers is Un-blocked successfully!..');
			$this->response( $success, 200);
		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Mobile Manufacturers id is not found!'
					);
			
			$this->response( $error, 200);
		}

	}
	function Mob_UnBlock_Manu($manu_id)
	{
		if($manu_id)
		{
			$block_category = $this->do_targeting->mobile_unblock_manu($manu_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,MANUFACTURER_UNBLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(MANUFACTURES,UNBLOCK);
				}
				/* Activity Log - End*/		
			
		}
	}
   
   	  /*
   * 
   * name: mobile_block_capability
   * @param : manu id
   * @return : sucess msg
   * 
   */
	public function mobile_block_capability_get()
	{
	    $cap_id=$this->get('id');
	    $block_id=$this->get('block_id');
	    $arrays=	explode(',',$block_id);
        if($cap_id)
        {
       	$results = $this->Mob_Block_Capbty($cap_id);
		$success = array('response'	=> 'ok','msg'=> 'Mobile Capability is blocked successfully!..');
		$this->response( $success, 200);
        }else if(is_array($arrays) && !empty($block_id))
			{  
				foreach($arrays as $block_id)
				{

					 $results= $this->Mob_Block_Capbty($block_id);
		 	   	}
			$success = array('response'	=> 'ok','msg'=> 'Mobile Capability is blocked successfully!..');
			$this->response( $success, 200);
		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Mobile Capability id is not found!'
					);
			
			$this->response( $error, 200);
		}

	}
	
function Mob_Block_Capbty($cap_id)
{
		if($cap_id)
		{
			$block_category = $this->do_targeting->mobile_block_capability($cap_id);
			
			/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,CAP_BLOCK);				
					if($enable=='1')
					{										
					$this->activity_log(CAPABILITY,BLOCK);   
					}
					/* Activity Log - End*/  
				
		}
}
	
	   /*
   * 
   * name: mobile_unblock_capability
   * @param : manu id
   * @return :sucess msg
   * 
   */
	public function mobile_unblock_capability_get()
	{
	    $cap_id=$this->get('id');
		$unblock_id=$this->get('unblock_id');
	    $arrays=explode(',',$unblock_id);
        if($cap_id)
        {
       	$results = $this->Mob_UnBlock_Capbty($cap_id);
		$success = array('response'	=> 'ok','msg'=> 'Mobile Capability is Un-blocked successfully!..');
		$this->response( $success, 200);
        }

        else if(is_array($arrays) && !empty($unblock_id))
			{  
				foreach($arrays as $unblock_id)
				{

					 $results= $this->Mob_UnBlock_Capbty($unblock_id);
		 	   	}
			$success = array('response'	=> 'ok','msg'=> 'Mobile Capability is Un-blocked successfully!..');
			$this->response( $success, 200);
		     }

      else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Mobile Capability id is not found!'
					);
			
			$this->response( $error, 200);
		}

	}
	function Mob_UnBlock_Capbty($cap_id)
	{
		if($cap_id)
		{
			$block_category = $this->do_targeting->mobile_unblock_capability($cap_id);
			
			/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(MANUFACTURE_CAP,CAP_UNBLOCK);				
					if($enable=='1')
					{										
					$this->activity_log(CAPABILITY,UNBLOCK);   
					}
					/* Activity Log - End*/  
				
		}
	}

	/*
   * 
   * name: fetch_tele_operators
   * @param : none
   * @return :all the telecom operators details.
   * 
   */
	public function fetch_tele_operators_get()
	{
	   $tele_list=$this->do_targeting->fetch_telecom_values();
	   $this->response($tele_list); 
	}
	
	/*
   * 
   * name: block_tele_operator
   * @param : none
   * @return :block selected telecom operator.
   * 
   */
	public function block_tele_operator_get()
	{
		$tele_id=$this->get('id');
		if($tele_id)
		{
			$block_tele = $this->do_targeting->block_telecom($tele_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Seleceted Telecom Operator Unblocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: unblock_telecom_operator_get
   * @param : none
   * @return :unblock selected telecom operator.
   * 
   */
	public function unblock_telecom_operator_get()
	{
		$tele_id=$this->get('id');
		if($tele_id)
		{
			$block_tele = $this->do_targeting->unblock_telecom($tele_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Seleceted Telecom Operator blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	function getLatestFile($directoryPath) {
    $directoryPath = rtrim($directoryPath, '/');

    $max = ['path' => null, 'timestamp' => 0];

    foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file) {
        $path = $directoryPath . '/' . $file;

        if (!is_file($path)) {
            continue;
        }

        $timestamp = filemtime($path);		
        if ($timestamp > $max['timestamp']) {
            $max['path'] = $path;
            $max['timestamp'] = $timestamp;
        }
    }

    return $max['path'];
}

	/*
   * 
   * name: add_telecom_process
   * @param : none
   * @return :add telecom operators through csv file.
   * 
   */
    public function add_telecom_process_post()
    {
		
		$file_id=clean_data($this->post('filname'));
		
		if($file_id!='')
		{
				$upload_extension = explode(".", $file_id);		
				if($upload_extension[1]!='csv')
				{
					$error = array(
							'response' => 'error',
							'msg'	 => 'Please select a valid CSV file to upload!..'
								);
		  
					$this->response($error, 200);	
				}
				else if($upload_extension[1]=='zip' || $upload_extension[1]=='tar')
				{
					$error = array(
							'response' => 'error',
							'msg'	 => 'Please select a valid CSV file to upload!..'
								);
		  
					$this->response($error, 200);	
				}
				else if($upload_extension[1]=='csv')
				{
					$ff=md5($file_id);
					//$file_info 		= $this->upload->data();
					$csvfilepath 	= $this->config->item('read_csv_telecom');	
					$file_name=$this->getLatestFile($csvfilepath);
			
					$data	 		= $this->csvreader->parse_file($file_name);					
					$counter		= '1';
					$error_head_field_details = array();
					$error_ip			= array();
					$insert_rec	= array();				
					if(count($data) > 0)
					{	
						foreach($data as $row)
						{						
							if($row['start_ip'] !='' AND $row['end_ip'] !='' AND $row['country'] !='' AND $row['carriername'] !='')
							{	
								$start_ip		=$row['start_ip'];
								$end_ip = $row['end_ip'];
								$country = trim($row['country']);
								$carriername = trim($row['carriername']);
								$insert_data		=array("start_ip"  =>$start_ip, "end_ip" =>$end_ip, "country" =>$country, "carriername"=> $carriername, "status"=>1);								
								$start_ip_exist = $this->do_targeting->check_ip_exist($start_ip,$end_ip,$country,$carriername);
								 if($start_ip !='' && $end_ip !=''): 
								 $pattern= preg_match("!^([0-9]{1,3}\.){3}([0-9]{1,3}){1}$!", $start_ip) && preg_match("!^([0-9]{1,3}\.){3}([0-9]{1,3}){1}$!", $end_ip);
								 $chk=1;if(ip2long($start_ip) < ip2long($end_ip)):$ip_long=1;else:$ip_long=0;endif;
								 else:$pattern=preg_match("!^([0-9]{1,3}\.){3}(([0-9]{1,3}|\*|(([0-9]{1,3})\/([0-9]{1,3})))){1}$!",$start_ip); $chk=0; $end_ip_exist=0;$ip_long=1;endif;
								 $start=filter_var($start_ip, FILTER_VALIDATE_IP);
								 $end=filter_var($end_ip, FILTER_VALIDATE_IP);
								//echo $this->db->last_query();
								//echo 'this is condtion'.' '.$start_ip_exist;
								 if(preg_match("/^[a-zA-Z]+$/",$country) && preg_match("/^[a-zA-Z]+$/",$carriername))
								{
								if($start_ip_exist==0)
								{
								  if($pattern && $start && $end)
									 {
										  if($ip_long==1){									
											$this->do_targeting->insert_tele_data($insert_data);
											$insert_rec[] =$counter;									
											}
											else
											{
											$error_lessval_endip[]	=$counter;
											}
									}
									else
									{
												if($chk==1):
												$error_ip[]	=$counter;
												else:
												$error_ip[]	=$counter;
												endif;
									}
								}
								
								else if($start_ip_exist==1)
								{
									$up_data = array("country"=>$country,"carriername"=>$carriername,"status" =>1);
									$this->do_targeting->update_tele_data($start_ip,$end_ip,$up_data);								
									$insert_rec[] =$counter;
								}
								else if($start_ip_exist==2)
								{
									$error_ip[]	= $counter;
								}
								else  
								{
									$error_ip[]	=$counter;
								}
							 }
								else  
								{
									$error_carrier_country[]	=$counter;
								}
							}
							else
							{
								$error_head_field_details[] = $counter;
							}
							$counter++;
							
						}
						
						
						if(count($insert_rec)>0 && (count($error_head_field_details) >0 || count($error_carrier_country) >0 || count($error_lessval_endip) >0 ||count($error_ip) >0))
						{
							$ins_count = count($insert_rec);
							$notify = array('response'	=> 'notify',
											 'redirect' =>site_url('admin/targeting/telecom_operators/'),	
											 'msg'		=> $ins_count.' record(s) are inserted/updated successfully.'.'</br>'.' <span style="color:#FF0000">Invalid/Empty datas are found in the uploaded file(s).</span>'
											 ); 
							$this->response($notify,200);
						}
						
						if(count($error_ip) >0)
						{
							$ids= count($error_ip);
							$error = array(
										   'response' => 'error',
										   'msg' =>  $ids." record(s) have invalid IP format."
										  );
							$this->response( $error, 200);
						}
						if(count($insert_rec)>0)
						{
							$ins_count = count($insert_rec);
							$success = array('response'	=> 'ok',
											 'redirect' =>site_url('admin/targeting/telecom_operators/'),	
											 'msg'		=> $ins_count.' record(s) are inserted/updated successfully.'
											 ); 
									$this->response($success,200);
						}
						if(count($error_carrier_country) >0)
						{
						
							$error = array(
										'response' => 'error',
										'msg' =>  "Please enter alphabets only !"
										  );
							$this->response( $error, 200);
						}
							if(count($error_lessval_endip) >0)
						{
						
							$error = array(
										'response' => 'error',
										'msg' =>  "Start Ip must be less than End Ip"
										  );
							$this->response( $error, 200);
						}
						
						if(count($error_head_field_details) >0)
						{
						
							$error = array(
										'response' => 'error',
										'msg' =>  "Some fields are missing in the uploaded file(s)"
										  );
							$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('admin/targeting/telecom_operators'),
									'msg'	 => 'There is no datas in the file!..'
										);
				  
						$this->response($error, 200);	
					} 	
				}
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Please select a valid CSV file to upload!..'
								);
		  
				$this->response($error, 200);	
			}	
	 
	}
	
	/*
   * 
   * name: fetch_category_main
   * @param : 
   * @return :all the creatives details need to be approve
   * 
   */
	public function fetch_category_main_get()
	{
		 $cat_list = $this->do_targeting->fetch_main_category();
		
		 $this->response($cat_list);
	}
	
	/*
   * 
   * name: add_main_category_post
   * @param : categoryname,categoryvalue
   * @return :lastinsertid
   * 
   * Fetch list of n/w users (pub or adv)
   */
	public function add_main_category_post(){
		
		$this->form_validation->set_rules('category_name', 'Category Name', 'required|trim|is_unique['.TAB_SITE_CATEGORIES.'.category_name]');
		$this->form_validation->set_message('is_unique', 'Already this category name is being registered. please enter the unique one');
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$category_value = "IAB";
			$category 		= $this->do_targeting->add_main_category(clean_data($this->post('category_name')),clean_data($category_value));
			$final_cat_val 	= "IAB".$category;
			
			$update_main 	= $this->do_targeting->update_category_value(clean_data($category),clean_data($final_cat_val)); 
			
			  /* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,MAIN_CAT_ADD);				
				if($enable=='1')
				{										
				$this->activity_log(MAIN_CATEGORY,ADD);
				}
				/* Activity Log - End*/
			
			
			
			 
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Category has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding category!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	/*
   * 
   * name: update_main_category
   * @param : categoryname,categoryvalue,categoryid
   * @return : category id
   * 
   */
	public function update_main_category_post()
	{
		$this->form_validation->set_rules('category_name', 'Category Name', 'required|trim|callback_category_name_check');
		#$this->form_validation->set_message('category_name_check', 'Already this category name is being registered. please enter the unique one');
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category_update = $this->do_targeting->update_main_category(clean_data($this->post()));
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,MAIN_CAT_EDIT);				
				if($enable=='1')
				{										
				$this->activity_log(MAIN_CATEGORY,EDIT);
				}
				/* Activity Log - End*/
			
			
			if($category_update !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Category has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding category!..'
					);
				
				$this->response( $success, 200);
			}
		}		
	}
	
	function category_name_check()
	{
		
		$cat_id 	= clean_data($this->post('cat_id'));
		$cat_name	= clean_data($this->post('category_name'));	
		
		$count 		= $this->do_targeting->dup_category_name_chk($cat_id,$cat_name);
		
		if($count>0)
		{
			$this->form_validation->set_message('category_name_check', "This category name already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/*
	 * category_root_get
	 * GET CATEGORY ROOT
	 * 
	 */
	function category_root_get() 
	{
		$par_value	= $this->get('par_id');
		$get_parent_cat	= $this->do_targeting->check_category_root($par_value);
		$this->response($get_parent_cat); 

	}
	
	/*
   * 
   * name: delete_category
   * @param : categoryid
   * @return : status true or false
   * 
   */
   
   public function delete_main_category_get()
   {
      $cat_id = $this->get('category_id');

     if($cat_id)
      {
       $results= $this->del_maincat($cat_id);
  
       	$success = array('response'	=> 'ok','msg'		=> 'Category has been deleted');
		$this->response( $success, 200);
   

      }
      else
      {
       
        $maincat_id = $this->get('maincat_id');
        $arrays	=	explode(',',$maincat_id);
          	 if(is_array($arrays))
			{  
				foreach($arrays as $cat_id)
				{

					 $results= $this->del_maincat($cat_id);
	
	 	     	}

       	$success = array('response'	=> 'ok','msg'		=> 'Category has been deleted');
		$this->response( $success, 200);
  

		
		}
      }




   }

   function del_maincat($cat_id)
   {
   		   if($cat_id)
		{
			$chk_cat_parent = $this->do_targeting->check_category($cat_id);
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CAT_TARGETING,MAIN_CAT_DELETE);				
				if($enable=='1')
				{										
				$this->activity_log(MAIN_CATEGORY,DELETE);
				}
				/* Activity Log - End*/				
			
			
			if($chk_cat_parent[0]['parent_category_id']=='0')
			{
				$cat_list 		= $this->do_targeting->delete_assoc_category($cat_id,$chk_cat_parent[0]['value']);
			}
			else
			{
				
				$cat_list 		= $this->do_targeting->delete_category($cat_id);
			}
		
			
		}
   }
   
   /*
	 * 
	 * name: add_keyword_post
	 * @param : none
	 * @return :all the keyword details.
	 * 
	 */
	public function add_keyword_post()
	{
		$this->form_validation->set_rules('keyword', 'lang:keyword_name', 'required|trim|callback_keyword_check');
		$this->form_validation->set_message('is_unique', $this->lang->line('keyword_registered_message'));
		if ($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error     = array(
				'response' => 'error',
				'msg' => $error_msg
			);
			$this->response($error, 200);
		}
		else
		{
			$keydata = array(
				'keyword' => clean_data($this->post('keyword'))
			);
			
			
			$add     = $this->do_targeting->add_keyword($keydata);
			
			
			/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CONTEXTUAL,KEYWORD_ADD);
				if($enable=='1')
				{										
				$this->activity_log(KEYWORD,ADD);
				}
				/* Activity Log - End*/
			
			
			
			
			if ($add)
			{
				$success = array(
					'response' => 'ok',
					'msg' => $this->lang->line('keyword_created_success')//'Keyword has been created successfully.'
				);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
					'response' => 'error',
					'msg' => $this->lang->line('error_try_again')
				);
				$this->response($error, 200);
			}
		}
	}
   
   /*
	 * 
	 * name: fetch_keyword_get
	 * @param : none
	 * @return :all the keyword details.
	 * 
	 */
	public function fetch_keyword_get()
	{
		$keyword_id = $this->get('keyword_id');
		$keyword_list = $this->do_targeting->fetch_keyword($keyword_id);
		if ($keyword_list)
		{
			$this->response($keyword_list,200);
		}
		else
		{
			$this->response(array('error'=>'No Keywords'),200);
		}
		
	}
	
	/*
	 * 
	 * name: update_keyword_post
	 * @param : none
	 * @return :all the keyword details.
	 * 
	 */
	public function update_keyword_post()
	{
		$this->form_validation->set_rules('keyword', 'lang:keyword_name', 'required|trim|callback_keyword_check');
		$this->form_validation->set_message('is_unique',  $this->lang->line('keyword_registered_message'));
		if ($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error     = array(
				'response' => 'error',
				'msg' => $error_msg
			);
			$this->response($error, 200);
		}
		else
		{
			$keyword_id = clean_data($this->post('keyword_id'));
			$keydata    = array(
				'keyword' => clean_data($this->post('keyword'))
			);
			$update     = $this->do_targeting->update_keyword($keyword_id, $keydata);
			
						
			/* Activity Log - Start*/	
		
				$enable	=  	$this->default_configurations->activity_log_setting(CONTEXTUAL,KEYWORD_EDIT);		
				
				if($enable=='1')
				{										
				$this->activity_log(KEYWORD,EDIT);
				}
				/* Activity Log - End*/
			
			
			
			if ($update)
			{
				$success = array(
					'response' => 'ok',
					'msg' =>  $this->lang->line('keyword_updated_success')//'Keyword has been updated successfully.'
				);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
					'response' => 'error',
					'msg' => $this->lang->line('error_try_again')
				);
				$this->response($error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: delete_keyword
	 * @param : keywordid
	 * @return : status true or false
	 * 
	 */
	public function delete_keyword_get()
	{
		$keyword_id = $this->get('id');
					
		if ($keyword_id)
		{	
			$connect_id	=	explode(',',$keyword_id);
			if(is_array($connect_id))
			{ 
				foreach($connect_id as $keyword_id)
				{	
					$key_list = $this->do_targeting->delete_keyword($keyword_id);
					
					/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CONTEXTUAL,KEYWORD_DELETE);				
				if($enable=='1')
				{										
				$this->activity_log(KEYWORD,DELETE);
				}
				/* Activity Log - End*/
			
				}
				if ($key_list)
				{
					$success = array(
						'response' => 'ok',
						'msg' => $this->lang->line('keyword_deleted_suc')//'keyword has been deleted'
					);
					$this->response($success, 200);
				}
				else
				{
					$error = array(
						'response' => 'error',
						'msg' => $this->lang->line('unable_delete_keyword')//'Unable to delete the keyword..'
					);
					$this->response($error, 200);
				}
			}
		}
		else
		{
			$error = array(
				'response' => 'error',
				'msg' => $this->lang->line('keyword_not_found')//'keyword is not found'
			);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: block_keyword_get
	 * @param : keywordid
	 * @return : success msg
	 * 
	 */
	public function block_keyword_get()
	{
		$keyword_id = $this->get('keyword_id');
		
		if ($keyword_id)
		{	
			$connect_id	=	explode(',',$keyword_id);
			if(is_array($connect_id))
			{ 
				foreach($connect_id as $keyword_id)
				{	
					$keyword = $this->do_targeting->block_keyword($keyword_id);
					
					/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CONTEXTUAL,KEYWORD_BLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(KEYWORD,BLOCK);
				}
				/* Activity Log - End*/
			
				}
				$success = array(
					'response' => 'ok',
					'msg' => $this->lang->line('keyword_blocked_success')//'Keyword is blocked successfully'
				);
				$this->response($success, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: unblock_keyword_get
	 * @param : keywordid
	 * @return : success msg
	 * 
	 */
	public function unblock_keyword_get()
	{
		$keyword_id = $this->get('keyword_id');
		if ($keyword_id)
		{	
			$connect_id	=	explode(',',$keyword_id);
			if(is_array($connect_id))
			{ 
				foreach($connect_id as $keyword_id)
				{
					$keyword = $this->do_targeting->unblock_keyword($keyword_id);
					
					/* Activity Log - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(CONTEXTUAL,KEYWORD_UNBLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(KEYWORD,UNBLOCK);
				}
				/* Activity Log - End*/
			
				}
				$success = array(
					'response' => 'ok',
					'msg' => $this->lang->line('keyword_unblocked_success')//'Keyword is unblocked successfully'
				);
				$this->response($success, 200);
			}
		}
	}
		/*
	 * 
	 * name: keyword_check
	 * @param : null
	 * @return : keyword Count 
	 * 
	 * checked the keyword count
	 */
	
	public function keyword_check()
	{
		$keyword = clean_data($this->input->post('keyword'));
		//$count=$this->do_email_check->email_check($account_id,$email,$account_type);					
        $count = $this->do_targeting->keyword_count_check($keyword);
		if($count>0)
		{
			$this->form_validation->set_message('keyword_check', "This Keyword already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	
	/*
	* 
	* name: fetch_os_get
	* @param : none
	* @return :all the os details.
	* 
	*/
   
	public function fetch_targ_list_get()
	{
		$targ_id	=	$this->get('targ_id');
		$table		=	$this->get('table');
		
		$targ_list 	= 	$this->do_targeting->fetch_targ_list($table,$targ_id);
		if($targ_list)
		{
			$this->response($targ_list);
		}
		else
		{
			$this->response('error',200);
		}
	}
	
	/*
	* 
	* name: add_targeting_post
	* @param : name,value
	* @return :lastinsertid
	* 
	*/
	function add_targeting_post(){
		if($this->post('targ_type')=='carrier')
		{
			$this->form_validation->set_rules('targ_start_ip', 'Name', 'required|trim|is_unique['.clean_data($this->post('targ_table')).'.start_ip]');
			$this->form_validation->set_rules('targ_end_ip', 'Value', 'required|trim|is_unique['.clean_data($this->post('targ_table')).'.end_ip]');
			$this->form_validation->set_rules('targ_name', 'Name', 'required|trim');
			$this->form_validation->set_rules('targ_country', 'Value', 'required|trim');
		}
		else
		{
			$this->form_validation->set_rules('targ_name', 'Name', 'required|trim|is_unique['.clean_data($this->post('targ_table')).'.name]');
			$this->form_validation->set_rules('targ_value', 'Value', 'required|trim|is_unique['.clean_data($this->post('targ_table').'.value]'));
		}
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error 	= 	array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						);

			$this->response( $error, 200);
		}
		else
		{		
		if(clean_data($this->post('targ_type'))=='carrier')
		{
			$targ_data=array('targ_table'=>clean_data($this->post('targ_table')),'targ_country'=>clean_data($this->post('targ_country')),'targ_type'=>clean_data($this->post('targ_type')),'targ_name' =>clean_data($this->post('targ_name')),'targ_start_ip'=>clean_data($this->post('targ_start_ip')),'targ_end_ip'=>clean_data($this->post('targ_end_ip')));	
		}
		else
		{
			$targ_data=array('targ_table'=>clean_data($this->post('targ_table')),'targ_type'=>clean_data($this->post('targ_type')),'targ_name' =>clean_data($this->post('targ_name')),'targ_value'=>clean_data($this->post('targ_value')));	
		}	
		
		$targ_id = $this->do_targeting->add_targeting($targ_data);
			
	
	        /* Activity Log - Start*/	
	           if($targ_data['targ_type']=="Device")
	           {
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_ADD);				
				if($enable=='1')
				{										
				$this->activity_log(DEVICE,ADD);
				}			
			   }
			   else if($targ_data['targ_type']=="language")
			   {
				 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_ADD);				
				 if($enable=='1')
				 {										
				   $this->activity_log(LANGUAGE,ADD);
				 }   
			    }
			    else if($targ_data['targ_type']=="Connection")
			    {
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_ADD);				
					 if($enable=='1')
					 {										
					   $this->activity_log(CONNECTION,ADD);
					 }
				}
				else if($targ_data['targ_type']=="carrier")
				{
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_ADD);				
					 if($enable=='1')
					 {										
					   $this->activity_log(ISP,ADD);
					 }
					
				}	
			/* Activity Log - End*/		
	
			
			if($targ_id !== FALSE){
				
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	ucfirst(clean_data($this->post('targ_type'))).' has been added successfully!..'
								);
				
				$this->response( $success, 200);
			}
			else{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error! please try again..'
								);
				
				$this->response( $error, 200);
			}			
		}
	}
	
	
	/*
	* 
	* name: update_targeting_post
	* @param : none
	* @return : targeting id
	* 
	*/
	
	public function update_targeting_post(){
		if(clean_data($this->post('targ_type'))=='carrier')
		{
			$this->form_validation->set_rules('targ_start_ip', 'Name', 'required|trim');
			$this->form_validation->set_rules('targ_end_ip', 'Value', 'required|trim');
			$this->form_validation->set_rules('targ_name', 'Name', 'required|trim');
			$this->form_validation->set_rules('targ_country', 'Value', 'required|trim');
		}
		else
		{
			$this->form_validation->set_rules('targ_name', 'Name', 'required|trim');
			$this->form_validation->set_rules('targ_value', 'Value', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response'	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{

		if(clean_data($this->post('targ_type'))=='carrier')
		{

		$targ_data=array('targ_id'=>clean_data($this->post('targ_id')),'targ_table'=>clean_data($this->post('targ_table')),'targ_country'=>clean_data($this->post('targ_country')),'targ_type'=>clean_data($this->post('targ_type')),'targ_name' =>clean_data($this->post('targ_name')),'targ_start_ip'=>clean_data($this->post('targ_start_ip')),'targ_end_ip'=>clean_data($this->post('targ_end_ip')));	
   	}
	else
	{
	$targ_data=array('targ_id'=>clean_data($this->post('targ_id')),'targ_table'=>clean_data($this->post('targ_table')),'targ_type'=>clean_data($this->post('targ_type')),'targ_name' =>clean_data($this->post('targ_name')),'targ_value'=>clean_data($this->post('targ_value')));		
		
	}
				$targ_id = $this->do_targeting->update_targeting($targ_data);						
				
												
				/* Activity Log - Start*/	
	           if($targ_data['targ_type']=="device")
	           {				   
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_EDIT);				
				if($enable=='1')
				{										
				$this->activity_log(DEVICE,EDIT);
				}			
			   }
			   else if($targ_data['targ_type']=="language")
			   {
				 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_EDIT);				
				 if($enable=='1')
				 {										
				   $this->activity_log(LANGUAGE,EDIT);
				 }   
			    }	
			    else if($targ_data['targ_type']=="connection")
			    {
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_EDIT);				
					 if($enable=='1')
					 {										
					   $this->activity_log(CONNECTION,EDIT);
					 }
				}
				else if($targ_data['targ_type']=="carrier")
				{
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_EDIT);				
					 if($enable=='1')
					 {										
					   $this->activity_log(ISP,EDIT);
					 }
					
				}	
			/* Activity Log - End*/		
				
				
				
			
			if($targ_id !== FALSE){
				
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	ucfirst(clean_data($this->post('targ_type'))).' has been updated successfully!..'
								);
				
				$this->response( $success, 200);
			}
			else{
				
				$error 	= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error! Please try again..'
								);
				
				$this->response( $error, 200);
			}
						
		}

	}
	
	/*
	* 
	* name: delete_targeting_get
	* @param : targeting id
	* @return : status true or false
	* 
	*/
   
	public function delete_targeting_get(){
	  	$id 	= 	$this->get('del_targ_id');
		$type 	= 	$this->get('del_targ_type');
		$table 	= 	$this->get('del_targ_table');	
							
		if($id)
		{
			$connect_id	=	explode(',',$id);
			if(is_array($connect_id))
				{ 
					foreach($connect_id as $connect_id)
					{		
						$info = array('del_targ_id'=>$connect_id, 'del_targ_table'=>$table); 
						$targ_list 	= 	$this->do_targeting->delete_targeting($info);
						
											
						
						/* Activity Log - Start*/	
					   if($type=="device")
					   {
						$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_DELETE);				
						if($enable=='1')
						{										
						$this->activity_log(DEVICE,DELETE);
						}			
					   }
					   else if($type=="language")
					   {
						 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_DELETE);				
						 if($enable=='1')
						 {										
						   $this->activity_log(LANGUAGE,DELETE);
						 }   
						}
						else if($type=="connection")
						{
							$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_DELETE);				
							 if($enable=='1')
							 {										
							   $this->activity_log(CONNECTION,DELETE);
							 }
						}
						else if($type=="carrier")
						{
							$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_DELETE);				
							 if($enable=='1')
							 {										
							   $this->activity_log(ISP,DELETE);
							 }
							
						}
							/* Activity Log - End*/		
				
				
						
						
					}
					$success= array(	'response'	=> 	'ok','msg'=>ucfirst($type).' has been deleted successfully!..');
					$this->response( $success, 200);
				}
			else
			{		
				$targ_list 	= 	$this->do_targeting->delete_targeting($this->get());
				
				/* Activity Log - Start*/	
					   if($type=="device")
					   {
						$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_DELETE);				
						if($enable=='1')
						{										
						$this->activity_log(DEVICE,DELETE);
						}			
					   }
					   else if($type=="language")
					   {
						 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_DELETE);				
						 if($enable=='1')
						 {										
						   $this->activity_log(LANGUAGE,DELETE);
						 }   
						}
						else if($type=="connection")
						{
							$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_DELETE);				
							 if($enable=='1')
							 {										
							   $this->activity_log(CONNECTION,DELETE);
							 }
						}
						else if($type=="carrier")
						{
							$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_DELETE);				
							 if($enable=='1')
							 {										
							   $this->activity_log(ISP,DELETE);
							 }
							
						}
							/* Activity Log - End*/		
				
			
				
				
				$success= array(	'response'	=> 	'ok','msg'=>ucfirst($type).' has been deleted successfully!..');
				$this->response( $success, 200);
			}
		}
		else
		{
			  $error = 	array('response' 	=> 	'error','msg'=> ucfirst($type).' id is not found');
			  $this->response( $error, 200);
		}	
		
	}
	
	function del_tar($info)
	{
		if(is_array($info))
		{
			$targ_list 	= 	$this->do_targeting->delete_targeting($info);
		}
	}
	/*
	* 
	* name: block_targeting
	* @param : id
	* @return : success msg
	* 
	*/
	public function block_targeting_get()
	{
	   $targ_id	=	$this->get('targ_id');  
	   $targ_type	=	$this->get('targ_type');
	  //print_r($this->get()); exit;
			$connect_id	=	explode(',',$targ_id);
			if(is_array($connect_id))
			{  
				foreach($connect_id as $connect_id)
				{	
					$info = array('targ_id'=>$connect_id, 'targ_table'=>$this->get('targ_table')); 
					$targ_list 	= 	$this->do_targeting->block_targeting($info);			
					
					
			  /* Activity Log - Start*/	
			   if($targ_type=="device")
	           {
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_BLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(DEVICE,BLOCK);
				}			
			   }
			   else if($targ_type=="language")
			   {
				 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_BLOCK);
				 if($enable=='1')
				 {										
				   $this->activity_log(LANGUAGE,BLOCK);
				 }   
			    }
			    else if($targ_type=="connection")
			    {
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_BLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(CONNECTION,BLOCK);
					 }
				}
				else if($targ_type=="carrier")
				{
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_BLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(ISP,BLOCK);
					 }
					
				}
					/* Activity Log - End*/		
				
					
					
				}
				$success= 	array(	'response'	=> 'ok',
							'msg'		=> ucfirst($targ_type).' is blocked successfully'
						 );
				$this->response( $success, 200);
			}
			else
			{ 
				$block 	= 	$this->do_targeting->block_targeting($this->get());
											
				 /* Activity Log - Start*/	
				if($targ_type=="device")
	           {
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_BLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(DEVICE,BLOCK);
				}			
			   }
			   else if($targ_type=="language")
			   {
				 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_BLOCK);				
				 if($enable=='1')
				 {										
				   $this->activity_log(LANGUAGE,BLOCK);
				 }   
			    }
			    else if($targ_type=="connection")
			    {
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_BLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(CONNECTION,BLOCK);
					 }
				}
				else if($targ_type=="carrier")
				{
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_BLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(ISP,BLOCK);
					 }
					
				}
				
				/* Activity Log - End*/		
			
				
				
				$success= 	array(	'response'	=> 'ok',
							'msg'		=> ucfirst($targ_type).' is blocked successfully'
						 );
		
				
			}
	}
		
	function block_tar($lang_info)
	{

		if(is_array($lang_info))
		{
			$block 	= 	$this->do_targeting->block_targeting($lang_info);	
		}
	

	}
	/*
	* 
	* name: unblock_targeting
	* @param : id
	* @return :success msg
	* 
	*/
	public function unblock_targeting_get()
	{

	    $targ_id	=	$this->get('targ_id');  
	    $targ_type	=	$this->get('targ_type');
		
		 
			$connect_id	=	explode(',',$targ_id);
			
			if(is_array($connect_id))
			{ 
				foreach($connect_id as $connect_id)
				{	
					$lang_info = array('targ_id'=>$connect_id, 'targ_table'=>$this->get('targ_table')); 
					$targ_list 	= 	$this->unblock_tar($lang_info);
					
				/* Activity Log - Start*/	
			   if($targ_type=="device")
	           {
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_UNBLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(DEVICE,UNBLOCK);
				}			
			   }
			   else if($targ_type=="language")
			   {
				 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_UNBLOCK);
				 if($enable=='1')
				 {										
				   $this->activity_log(LANGUAGE,UNBLOCK);
				 }   
			    }
			    else if($targ_type=="connection")
			    {
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_UNBLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(CONNECTION,UNBLOCK);
					 }
				}
				else if($targ_type=="carrier")
				{
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_UNBLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(ISP,UNBLOCK);
					 }
					
				}
				
					
					
				}
				$success= 	array(	'response'	=> 'ok',
							'msg'		=> ucfirst($targ_type).' is unblocked successfully'
						 );
				$this->response( $success, 200);
			}
			else
			{
				
								
				$block 	= 	$this->unblock_tar($this->get());
											
				/* Activity Log - Start*/	
			   if($targ_type=="device")
	           {
				$enable	=  	$this->default_configurations->activity_log_setting(DEVICE_OS,DEVICE_UNBLOCK);				
				if($enable=='1')
				{										
				$this->activity_log(DEVICE,UNBLOCK);
				}			
			   }
			   else if($targ_type=="language")
			   {
				 $enable	=  	$this->default_configurations->activity_log_setting(BROWSERS_LANG,BROWSER_LANG_UNBLOCK);
				 if($enable=='1')
				 {										
				   $this->activity_log(LANGUAGE,UNBLOCK);
				 }   
			    }
			    else if($targ_type=="connection")
			    {
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,CONNECTION_UNBLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(CONNECTION,UNBLOCK);
					 }
				}
				else if($targ_type=="carrier")
				{
					$enable	=  	$this->default_configurations->activity_log_setting(ISP_CONNECTION,ISP_UNBLOCK);				
					 if($enable=='1')
					 {										
					   $this->activity_log(ISP,UNBLOCK);
					 }
					
				}		
				
				
				
				$success= 	array(	'response'	=> 'ok',
							'msg'		=> ucfirst($targ_type).' is unblocked successfully'
						 );
		
				
			}
		
		
     
	}
	function unblock_tar($lang_info)
	{		
	    if(is_array($lang_info))
		{
			$unblock = 	$this->do_targeting->unblock_targeting($lang_info);
		}
	}
	
	
	function activity_log($module,$process)
	{
				/* Activity Log for EDIT setting information - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>'',
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
					
				 $this->redis_library->logcount($account_id,$activity_log);  
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for edit settings information - End*/			
		
	}
	
	public function browser_version_list1_get(){
	  if(is_array($this->get('browser')))
	  {
		  $browser = $this->get('browser');
	  }
	  else
	  {
	   $browser = explode(",",$this->get('browser'));
	  }
	   if($browser){
	   $browser_vers_list = $this->do_targeting->fetch_browser_version_select1($browser);
	   $this->response($browser_vers_list);
       }
		else
		{
			  $error = 	array('response' 	=> 	'error','msg'=> 'Selected Browser not having any version');
			  $this->response( $error, 200);
		}       
	}	
	public function os_version_list1_get(){
	  
	  // $os = explode(",",$this->get('os'));
	   $os =$this->get('os');
	   if($os){ 
	   $os_vers_list = $this->do_targeting->fetch_os_version_select1($os);
	   $this->response($os_vers_list);
       }
		else
		{
			  $error = 	array('response' 	=> 	'error','msg'=> 'Selected OS not having any version');
			  $this->response( $error, 200);
		}       
	}
	public function remove_conflict_get()
	{
       $value = explode(",",$this->get('value'));
       $op_val= explode(",",$this->get('op_val'));
       $table = $this->get('table');
       if($table == 'djax_targ_browser_versions')
		{
			$column = array('browser_version as id','browser_version as text');
			$where  = 'browser_version';
			$where_in  = array("browser_code",$op_val);
		}
		else
		{
			$column= array('value as id','name as text');
			$where  = 'value';
		}
       if($value && $table && $column && $where)
       {
		    $list = $this->do_targeting->remove_conflicts($value,$table,$column,$where,$where_in);
		    //$this->response($this->db->last_query(),200);
			if($list)
			{
				$this->response($list,200);
			}
			else
			{
				$list = 	'';
				$this->response($list, 200);
			}		   
	   }
       
	}

	public function add_main_keywords_post()
	{
	
		$this->form_validation->set_rules('keywords_name', 'keywords Name', 'required|trim|');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$keywords =$this->input->post('keywords_name');
			 if($keywords)
			 {
				$inline_keywords 		= $this->do_targeting->add_line_keywords($keywords);
					if($inline_keywords !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Category has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding category!..'
					);
				
				$this->response( $success, 200);
			}
			 }	
		}
	
	}


public function fetch_inline_keyword_get()
	{
		
		$keyword_list = $this->do_targeting->fetch_inline_keyword();
		if ($keyword_list)
		{
			$this->response($keyword_list,200);
		}
		else
		{
			$this->response(array('error'=>'No Keywords'),200);
		}
		
	}
	public function delete_main_keywords_get()
	{
		$keyword_id = $this->input->get('keyword_id');
		$key_list = $this->do_targeting->delete_inline_keyword($keyword_id);
		if ($key_list)
				{
					$success = array(
						'response' => 'ok',
						'msg' => $this->lang->line('keyword_deleted_suc')
					);
					$this->response($success, 200);
				}
				else
				{
					$error = array(
						'response' => 'error',
						'msg' => $this->lang->line('unable_delete_keyword')//'Unable to delete the keyword..'
					);
					$this->response($error, 200);
				}
	}
	public function inline_keyword_fetch_get()
	{
	    $keyword_id = $this->get('keyword_id');
	   if($keyword_id){
	   $keyword_list = $this->do_targeting->fetch_inline_keyword_select($keyword_id);
	   $this->response($keyword_list);
	 }
	   
   }
   	public function update_main_keywords_post()
	{
		$this->form_validation->set_rules('keyword_name', 'keyword Name', 'required|trim');
		
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$keyword_update = $this->do_targeting->update_main_inline_keywords(clean_data($this->post()));
			
			
			
			
			if($keyword_update !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'keywords has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding keywords!..'
					);
				
				$this->response( $success, 200);
			}
		}		
	}
	




	
}
