<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for user related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Subaccount extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
	
		$this->load->model('do_subaccount');
		$this->load->model('do_advertiser');
		$this->load->model('do_publisher');
		$this->load->model('do_manager');
		$this->load->model('do_email_check');
		$this->load->model('do_networks');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_network_managers');
		$this->load->model('do_roles');
		$this->load->library('user_authentication');
		$this->load->model('do_message');
		$this->load->library('notification');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	} 
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all user information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		$user_id		=	$this->get('user_id');
		
		$account_id		=	'';
		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id		=	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;
		}
		elseif($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id		=	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;
		}
		
		$user 	= 	$this->do_subaccount->fetch($account_id,$account_type,$user_id);
		
		if($user)
		{
			$this->response($user,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	
	//api/v1/user/add
	function add_post()
	{	
		$this->form_validation->set_rules('user_name','User Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		//$this->form_validation->set_rules('last_name','Last Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email', 'Email Address', 'required|trim|is_email|callback_email_check');
		$this->form_validation->set_rules('user_role', 'User Role','required|trim');
		$this->form_validation->set_rules('password', 'Password','required|trim');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password','required|trim|matches[password]');
				
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$account_id		=	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;
			$agency_id			=	$this->user_authentication->agency_id;
			/*if($account_type == "TRAFFICKER"){
				$add_data		=	array(
									'first_name'			=>	clean_data($this->post('first_name')),
									'last_name'			=>	clean_data($this->post('last_name')),
									'email'			=>	clean_data($this->post('email')),
									'role_id'		=>	$this->post('user_role'),
									'password'		=>	md5(clean_data($this->post('password'))),
									'account_id'	=>	$account_id,
									'account_type'	=>	$account_type,
									'agency_id'		=>	$agency_id,
									'site_url'		=> clean_data($this->post('website')),
									'security_id'		=> clean_data($this->post('security_question_id')),
									'security_answer'		=> clean_data($this->post('security_answer'))
									);
			}
			else if($account_type == "ADVERTISER"){
				$add_data		=	array(
									'first_name'			=>	clean_data($this->post('first_name')),
									'last_name'			=>	clean_data($this->post('last_name')),
									'email'			=>	clean_data($this->post('email')),
									'role_id'		=>	$this->post('user_role'),
									'password'		=>	md5(clean_data($this->post('password'))),
									'account_id'	=>	$account_id,
									'account_type'	=>	$account_type,
									'agency_id'		=>	$agency_id,
									'security_id'		=> clean_data($this->post('security_question_id')),
									'security_answer'		=> clean_data($this->post('security_answer'))
									
									);
			}*/
			$add_data		=	array(
									'user_name'			=>	clean_data($this->post('user_name')),
									//'last_name'			=>	clean_data($this->post('last_name')),
									'email'			=>	clean_data($this->post('email')),
									'role_id'		=>	$this->post('user_role'),
									'password'		=>	md5(clean_data($this->post('password'))),
									'account_id'	=>	$account_id,
									'account_type'	=>	$account_type,
									);
									
			$user_add 	= 	$this->do_subaccount->add_user($add_data);
			
			$user_role 	= 	$this->do_subaccount->fetch_roles($account_type,clean_data($this->post('user_role')));
			//$this->response( $user_add, 200);
			if($user_add != FALSE)
			{
				 
				if($account_type =='ADVERTISER')
				{ 
					$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
				}
				else //if($account_type =='TRAFFICKER')
				{ 
					$adv_details	=	$this->do_publisher->get_user_information($account_id); 
				}

				$adv_info		=	$adv_details[0];
					
				//SEND MAIL TO THE ADDED user
				$result			=	$this->do_networks->get_network_details();			
				$admin_name    	= 	$result['firstname']." ".$result['lastname'];			
				$admin_email   	= 	$result['email'];
				
				$from_email    	= 	$adv_info['email'];
				$from_name     	= 	$adv_info['dj_first_name']." ".$adv_info['dj_last_name'];

				$user_email    	= 	clean_data($this->post('email'));
				$password      	= 	clean_data($this->post('password'));
				$user_name     	= 	clean_data($this->post('user_name'));
				
				$type     	   	= 	"ADD_MANAGER_EMAIL";
				$from 	       	=  	$from_email;
				$to  	       	=  	$user_email;
				
				$mail_content	=	array(
										"subject" 			=>	"Sub Account Information",
										"to_name" 			=> 	$user_name,				
										"from_name"			=> 	$from_name,
										"email"  			=> 	$user_email,
										"password"      	=> 	$password,
										"role"				=>	$user_role[0]['role_name']
									);
				
				$attachement	=	'';	
				
    			//send_mail($type,$from,$to,$mail_content,$attachement,$admin_email);
    			$notication_value ='sub_add_user';
				$notification_msg = $this->do_message->get_notification_msg($notication_value); 
				if($notification_msg[0]['msg_type']=='1')
				{
					$notification_content = $notification_msg[0]['content'];
				}
				else
				{
					$template_filename = $notification_msg[0]['template_filename'];
					$csvfilepath 	= $this->config->item('read_settings');	
					$notification_content = file_get_contents($csvfilepath.$template_filename);
				}
				$adgate_url=base_url();
				$prod_name	= 	$this->config->item('prod_name');
				$click_directADS	= 	$this->config->item('click_directADS');
				$msg_replace = str_replace("{{Product_name}}",'<a href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
				$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);	
				$msg_replace = str_replace("{{admin_name}}",$from_name,$msg_replace);
				$msg_replace = str_replace("{{emailid}}",$user_email,$msg_replace);
				$msg_replace = str_replace("{{password}}",$this->post('password'),$msg_replace);
				$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin>Login</a>' ,$msg_replace);
				$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>',$msg_replace);//print_r('$msg_replace3');exit;
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				$headers .= 'From: '.$from_email. "\r\n";
				$received = mail($user_email,'Account Details',$msg_replace,$headers);
    			
				$success 		= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'User has been added successfully!..'
									);
								
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		//$account_id	=	$this->user_authentication->account_id;
		
		$this->form_validation->set_rules('user_name','User Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		//$this->form_validation->set_rules('last_name','Last Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email', 'Email Address', 'required|trim|is_email|callback_edit_email_check');
		$this->form_validation->set_rules('user_role', 'User Role','required|trim');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			$this->response( $error, 200);
		}
		else
		{
			$account_type	=	$this->user_authentication->account_type;
			$update_data	=	array(
									'user_name'			=>	clean_data($this->post('user_name')),
									//'last_name'			=>	clean_data($this->post('last_name')),
									'email'			=>	clean_data($this->post('email')),
									'role_id'		=>	clean_data($this->post('user_role')),
									'user_id'		=>	clean_data($this->post('user_id')),
									'account_id'	=>	clean_data($this->post('account_id')),
									'account_type'	=>	$account_type
									);
						
			$user_update 	= 	$this->do_subaccount->update($update_data);
			
			if($user_update != FALSE)
			{
				$account_id		=	$this->user_authentication->account_id;
				
				if($account_type =='ADVERTISER')
				{ 
					$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
				}
				else //if($account_type =='TRAFFICKER')
				{ 
					$adv_details	=	$this->do_publisher->get_user_information($account_id); 
				}
				
				$adv_info		=	$adv_details[0];
					
				//SEND MAIL TO THE UPDATED user
				$result			=	$this->do_networks->get_network_details(); 	
				$admin_name    	= 	$result['firstname']." ".$result['lastname'];			
				$admin_email   	= 	$result['email'];
				
				$from_email    	= 	$adv_info['email'];
				$from_name     	= 	$adv_info['dj_first_name']." ".$adv_info['dj_last_name'];
			
				$user_email    	= 	clean_data($this->post('email'));
				$user_name     	= 	clean_data($this->post('user_name'));
				$role			=	$this->post('user_role');
				$type     	   	= 	"UPDATE_MANAGER_EMAIL";
				$from 	      	=  	$from_email;
				$to  	       	=  	$user_email;
						
				$mail_content	=	array(
										"subject" 		=> 	"User Updated Information",
										"to_name" 		=> 	$user_name,				
										"from_name"	 	=> 	$from_name,
										"email"  		=> 	$user_email,
										"role" 			=> 	clean_data($this->post('user_role'))						
									);
				$attachement	=	'';	
    			//send_mail($type,$from,$to,$mail_content,$attachement,$admin_email);
    			$notication_value ='sub_edit_user';
				$notification_msg = $this->do_message->get_notification_msg($notication_value); 
				if($notification_msg[0]['msg_type']=='1')
				{
					$notification_content = $notification_msg[0]['content'];
				}
				else
				{
					$template_filename = $notification_msg[0]['template_filename'];
					$csvfilepath 	= $this->config->item('read_settings');	
					$notification_content = file_get_contents($csvfilepath.$template_filename);
				}
				$adgate_url=base_url();
				$prod_name	= 	$this->config->item('prod_name');
				$click_directADS	= 	$this->config->item('click_directADS');
				$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
				$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);	
				$msg_replace = str_replace("{{admin_name}}",$from_name,$msg_replace);
				$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin>Login</a>' ,$msg_replace);
				$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>',$msg_replace);//print_r('$msg_replace3');exit;
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				$headers .= 'From: '.$from_email. "\r\n";
				$received = mail($user_email,'Account details update',$msg_replace,$headers);
    			
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'User has been updated successfully!..'
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}			
		}
	}
	
	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	
	public function email_check()
	{
		$email		=	clean_data($this->post('email'));
		
		$count		=	$this->do_email_check->dup_email_check($email);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', "This Email address already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}	
	
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	function edit_email_check()
	{
		$account_id	=	clean_data($this->post('account_id'));
		$email		=	clean_data($this->post('email'));
		$count 		= 	$this->do_email_check->dup_email_check($email,$account_id);
		
		if($count>0 )
		{
			$this->form_validation->set_message('edit_email_check', "This Email address already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * delete the user information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$user_ids	=	$this->get('del_user_id');
	   
		$users		=	explode(',',$user_ids);
		
		if(is_array($users))
		{  
			foreach($users as $user_id)
			{
				 $results	= $this->delete_user($user_id);
			}
			
			$success 	= 	array(	'response'	=> 	'ok',
									'msg'		=> 	'Selected user has been deleted successfully'
							);
		
			$this->response( $success, 200);
		}
		else
		{
			$results	= 	$this->delete_user($user_id);
			$success 	= 	array(
								'response'	=> 	'ok',
								'msg'		=> 	'Selected user has been deleted successfully'
							);
							
			$this->response( $success, 200);
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the user information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_user($user_id)
	{	
		$user_del 	= 	$this->do_subaccount->remove($user_id);	
		
		if($user_del)
		{	 
			$account_id		=	$this->user_authentication->account_id;       
			
			$adv_details	=	$this->do_advertiser->get_user_information($account_id); 

			$adv_info		=	$adv_details[0];
				
			//SEND MAIL TO THE UPDATED user
			$result			=	$this->do_networks->get_network_details();			
			$admin_name    	= 	$result['firstname']." ".$result['lastname'];			
			$admin_email   	= 	$result['email'];
			
			$from_email    	= 	$adv_info['email'];
			$from_name     	= 	$adv_info['dj_first_name']." ".$adv_info['dj_last_name'];
			
			$user_details  	= 	$this->do_network_managers->get_user_profile($user_id);			
			$user_role     	= 	$user_details[0];
			$user_email    	= 	$user_role['email_address'];
			$user_name     	= 	$user_role['contact_name'];
			$type     	   	= 	"DELETE_MANAGER_ACCOUNT";
			$from 	       	=  	$from_email;
			$to  	       	=  	$user_email;			
			$mail_content	=	array(
									"subject" 	=> 	"Sub Account Deleted",
									"to_name" 	=> 	$user_name,				
									"from_name"	=> 	$from_name,
									"email"  	=> 	$user_email,
									);
			$attachement	=	'';
			
			send_mail($type,$from,$to,$mail_content,$attachement,$admin_email);
						
		}
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the user information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_get()
	{	
		$user_ids	=	$this->get('block_id');
	   
		$users		=	explode(',',$user_ids);
		
		if(is_array($users))
		{  
			foreach($users as $user_id)
			{
				 $results	= $this->block_user($user_id);
			}
			
			$success 	= 	array(	'response'	=> 	'ok',
									'msg'		=> 	'Selected user has been blocked successfully'
							);
		
			$this->response( $success, 200);
		}
		else
		{
			$results	= 	$this->block_user($user_id);
			$success 	= 	array(
								'response'	=> 	'ok',
								'msg'		=> 	'Selected user has been blocked successfully'
							);
							
			$this->response( $success, 200);
		}
	}
	
	/**
       * 
       * name : unblock_get()
       * 
       * block the user information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_get()
	{	
		$user_ids	=	$this->get('unblock_id');
	   
		$users		=	explode(',',$user_ids);
		
		if(is_array($users))
		{  
			foreach($users as $user_id)
			{
				 $results	= $this->unblock_user($user_id);
			}
			
			$success 	= 	array(	'response'	=> 	'ok',
									'msg'		=> 	'Selected user is unblocked successfully'
							);
		
			$this->response( $success, 200);
		}
		else
		{
			$results	= 	$this->unblock_user($user_id);
			$success 	= 	array(
								'response'	=> 	'ok',
								'msg'		=> 	'Selected user is unblocked successfully'
							);
							
			$this->response( $success, 200);
		}
	}
	
	/****
	 * 
	 * method : fetch_roles
	 * 
	 * Fetch the roles for the administrator
	 * 
	 * 
	 */
	function fetch_roles_get()
	{
		$account_id		=	$this->user_authentication->account_id;
		$account_type	=	$this->user_authentication->account_type;
		
		$role_id		=	$this->get('role_id');
		
		$roles 			= 	$this->do_subaccount->fetch_roles($account_type,$role_id);
		
		$this->response($roles,200);			
	}	
	
	public function fetch_role_permission_get()
	{
		$account_id		=	$this->user_authentication->account_id;
		$account_type	=	$this->user_authentication->account_type;
		
	    $role_id 		= 	$this->get('role_id');
	    $user_id 		= 	$this->get('user_id');
		$role_list		=	$this->do_subaccount->fetch_role_permission($role_id, $user_id);
		$this->response($role_list,200); 
	}
	
	function block_user($user_id)
	{ 
		$block_user	=	$this->do_subaccount->block_users($user_id);
		
		if($block_user)
		{
			$account_id		=	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;
			//$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
			if($account_type =='ADVERTISER')
			{ 
				$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
			}
			else
			{ 
				$adv_details	=	$this->do_publisher->get_user_information($account_id); 
			}
			$adv_info		=	$adv_details[0];
				
			//SEND MAIL TO THE UPDATED user
			$result			=	$this->do_networks->get_network_details();			
			$admin_name    	= 	$result['firstname']." ".$result['lastname'];			
			$admin_email   	= 	$result['email'];
			
			$from_email    	= 	$adv_info['email'];
			$from_name     	= 	$adv_info['dj_first_name']." ".$adv_info['dj_last_name'];
			
			//GET USER ROLE EMAIL AND THEIR NAME DETAILS
			$user_details  	= 	$this->do_network_managers->get_user_profile($user_id);			
			$user_role     	= 	$user_details[0];
			$user_email    	= 	$user_role['email_address'];
			$user_name     	= 	$user_role['contact_name'];
			$type     	   	= 	"BLOCK_USER_ROLE";
			$from 	       	= 	$from_email;
			$to  	       	= 	$user_email;			
			
			$mail_content	=	array(
									"subject" 		=>	"Sub Account Blocked",
									"to_name" 		=> 	$user_name,				
									"from_name"		=> 	$from_name,
									"email"  		=> 	$user_email
								);
			
			$attachement	=	'';	
			//send_mail($type,$from,$to,$mail_content,$attachement,$admin_email);	
			$notication_value ='blocked_user';
			$notification_msg = $this->do_message->get_notification_msg($notication_value); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
			}					
			$adgate_url=base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);	
			$msg_replace = str_replace("{{admin_name}}",$from_name,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin>Login</a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>',$msg_replace);//print_r('$msg_replace3');exit;
			$headers = "MIME-Version: 1.0" . "\r\n";
			$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
			$headers .= 'From: '.$from_email. "\r\n";
			$received = mail($user_email,'Notification mail',$msg_replace,$headers);
		}
	}
	
	function unblock_user($user_id)
	{
		$block_user	=	$this->do_subaccount->unblock_users($user_id);
		
		if($block_user)
		{
			$account_id		=	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;			
			//$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
			if($account_type =='ADVERTISER')
			{ 
				$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
			}
			else
			{ 
				$adv_details	=	$this->do_publisher->get_user_information($account_id); 
			}

			$adv_info		=	$adv_details[0];
				
			//SEND MAIL TO THE UPDATED user
			$result			=	$this->do_networks->get_network_details();			
			$admin_name    	= 	$result['firstname']." ".$result['lastname'];			
			$admin_email   	= 	$result['email'];
			
			$from_email    	= 	$adv_info['email'];
			$from_name     	= 	$adv_info['dj_first_name']." ".$adv_info['dj_last_name'];
			
			//GET USER ROLE EMAIL AND THEIR NAME DETAILS
			$user_details  	= 	$this->do_network_managers->get_user_profile($user_id);			
			$user_role     	= 	$user_details[0];
			$user_email    	= 	$user_role['email_address'];
			$user_name     	= 	$user_role['contact_name'];
			$type     	   	= 	"UNBLOCK_USER_ROLE";
			$from 	       	= 	$from_email;
			$to  	       	= 	$user_email;			
			
			$mail_content	=	array(
									"subject" 			=>	"Sub Account UnBlocked",
									"to_name" 			=> 	$user_name,				
									"from_name"			=> 	$from_name,
									"email"  			=> 	$user_email
								);
			
			$attachement	=	'';	
			//send_mail($type,$from,$to,$mail_content,$attachement,$admin_email);
			$notication_value ='user_access_unblock';
			$notification_msg = $this->do_message->get_notification_msg($notication_value); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
			}					
			$adgate_url=base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);	
			$msg_replace = str_replace("{{admin_name}}",$from_name,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin>Login</a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>',$msg_replace);//print_r('$msg_replace3');exit;
			$headers = "MIME-Version: 1.0" . "\r\n";
			$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
			$headers .= 'From: '.$from_email. "\r\n";
			$received = mail($user_email,'Notification mail',$msg_replace,$headers);
		}
	
	}
	/* 
	* name: add_roles_post
	* @param : null
	* @return : insert added roles into djax_rols and djax_role_assoc
    */
	public function add_role_post()
	{		  
		if(clean_data($this->post('man_per'))!='')
		{				
			//IF INSERT 
				
			if(clean_data($this->post('process'))!='UPDATE')
			{
				
				$role_list=$this->do_subaccount->add_role(clean_data($this->post()));
				$this->response( $role_list, 200);
			}
			else
			{   
				//IF UPDATE
				$role_list=$this->do_subaccount->update_role(clean_data($this->post()));
			}
			
			   /* Activity Log for user role - Start*/	
				//$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,USER_ROLE);
				//if($enable=='1')
				//{							
				//$this->activity_log(USER_ROLE,EDIT);
				//}
				/* Activity Log for user role- End*/		
				
			
			$user_id=$this->post('user_id');
			$account_id		=	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;
			//$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
			if($account_type =='ADVERTISER')
			{ 	$notication_value ='user_roles_adv';
				$adv_details	=	$this->do_advertiser->get_user_information($account_id); 
			}
			else
			{ 	$notication_value ='user_roles_pub';
				$adv_details	=	$this->do_publisher->get_user_information($account_id); 
			}
			
			
			$adv_info		=	$adv_details[0];
			$result			=	$this->do_networks->get_network_details();			
			$admin_name    	= 	$result['firstname']." ".$result['lastname'];			
			$admin_email   	= 	$result['email'];
			$admin_id   	= 	$result['account_id'];
			$from_email    	= 	$adv_info['email'];
			$from_name     	= 	$adv_info['dj_first_name']." ".$adv_info['dj_last_name'];
			
			//GET USER ROLE EMAIL AND THEIR NAME DETAILS
			$user_details  	= 	$this->do_network_managers->get_user_profile($user_id);			
			$user_role     	= 	$user_details[0];
			$user_email    	= 	$user_role['email_address'];
			$user_name     	= 	$user_role['contact_name'];
			$type     	   	= 	"USER_ROLE";
			$from 	       	= 	$from_email;
			$to  	       	= 	$user_email;			
			
			$mail_content	=	array(
									"subject" 		=>	"Roles and Permission",
									"to_name" 		=> 	$user_name,				
									"from_name"		=> 	$from_name,
									"email"  		=> 	$user_email
								);
			$user =$result; 
			$reciever=$user_details;
			 
     	 
			$attachement	=	'';	
			//send_mail($type,$from,$to,$mail_content,$attachement,$admin_email);	
			
			$notification_msg = $this->do_message->get_notification_msg($notication_value); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
			} 
			
			$adgate_url=base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content); 
			if($account_type =='ADVERTISER')
			{ 
				$msg_replace = str_replace("{{advertiser_name}}",$user_name,$msg_replace);
			}	
			else
			{
				$msg_replace = str_replace("{{publisher_name}}",$user_name,$msg_replace);	
			}
			
					
			$msg_replace = str_replace("{{admin_name}}",$admin_name,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin>Login</a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>',$msg_replace);
			$message_data		=	array(
									'sender_id'		=>	$admin_id,
									'receiver_id'	=>	$account_id,
									'subject'		=>	'Roles and permission',
									'content'		=> 	'User roles and permission has been updated successfully',
									'account_type'	=>	$account_type,
									'status'		=>	'1',
									
									'date'			=>	date('Y-m-d H:i:s')
									);	
			$type_details	=	array(
										 
								'type'			=> $type,
								'string'		=> 'edit_role',
								'column_name'	=> "account_settings"
								);
			
			if($role_list && clean_data($this->post('process'))!='UPDATE')
			{  
				$success = array( 'response' => 'ok',
								 'msg'	 => 'Roles and permissions added successfully!..'
							   );	 	
				$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace); 
				$this->response( $success, 200);
			}
			else 
			{   
				$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
												
				$success = array( 'response' => 'ok',
								'msg'	 => 'Roles and permissions updated successfully!..'
							  );
				
				$this->response( $success, 200);
			}
			
			
		}
		else
		{
			$success = array( 'response' => 'error',
								 'msg'	 => 'Select any one of the permissions'
							   );	 			 
			$this->response( $success, 200);
		}
	}
	function fetch_user_details_get()
	{	
		$user_id		=	$this->get('user_id');
		$account_id		=	$this->get('account_id');
		
		
		
			$account_type	=	$this->user_authentication->account_type;
		
		//$this->response($account_type,200);
		$user 	= 	$this->do_subaccount->fetch_user_details($account_id,$account_type,$user_id);
		
		if($user)
		{
			$this->response($user,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	/****
	 * 
	 * method : fetch_roles
	 * 
	 * Fetch the roles for the administrator
	 * 
	 * 
	 */
	function fetch_subaccount_roles_set_get()
	{
		$account_id		=	$this->user_authentication->account_id;
		$account_type	=	$this->user_authentication->account_type;
		
		$role_id		=	$this->get('role_id');
		$user_id		=	$this->get('user_id');
		$roles 			= 	$this->do_subaccount->fetch_subaccount_roles_set($account_type,$role_id,$user_id);
		
		if($roles)
		{
			//$this->response($roles,200);
			$success = array( 'response' => 'ok',
								 'msg'	 => 'Permission set already'
							   );	 			 
				$this->response( $success, 200);
		}
		else
		{
			$success = array( 'response' => 'error',
								 'msg'	 => array('user_role'=>'Please assign permission for this role')
							   );	 			 
			$this->response( $success, 200);
		}			
	}
	public function fetch_role_permission_value_get()
	{
		$account_id		=	$this->user_authentication->account_id;
		$account_type	=	$this->user_authentication->account_type;
		
	    $role_id 		= 	$this->get('role_id');
	    $parent_account_id 		= 	$this->get('parent_account_id');
		$role_list		=	$this->do_subaccount->fetch_role_permission_value($role_id, $parent_account_id);
		$this->response($role_list,200); 
	}
}
