<?php defined('BASEPATH') OR exit('No direct script access allowed');


/*
 * Special Bidding
 */

class Special_bidding extends REST_Controller
{
	function __construct()
	{
		
		parent::__construct();
		$this->load->library('redis_library');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_special_bidding');
		$this->load->model('do_message');
		$this->load->model('do_campaign');
		$this->load->model('do_app_config');
		$this->load->library('user_authentication');
		$this->load->library('notification');
		$this->load->library('memcached_library');
	    $key=$this->input->get_post('api_key');
	    $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
	    if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	
	/*
	 *Insert source traffic 
	 */
	function traffic_source_post()
	{
		$source			= 	clean_data($this->post('source'));
		$bid_rate		=	clean_data($this->post('bid_rate'));	
		$source_status	= 	clean_data($this->post('source_status'));
		$campaign_det	= 	clean_data($this->post('camp_det'));
		$source_type    =   clean_data($this->post('source_type'));
		$account_id		=   $this->user_authentication->account_id;
		$admarket		=   clean_data($this->post('admarket'));
			
		$traffic_source_data = 	array(
									"campaign_id" 	=> 	clean_data($campaign_det),
									"traffic_id"	=>	clean_data($source),
									"bid_rate"		=>	clean_data($bid_rate),
									"status"		=>	clean_data($source_status),
									"source_type"   =>  clean_data($source_type),									
									"account_id"    =>  clean_data($account_id),
									"admarket"		=>  clean_data($admarket)
								);
								
		$traffic_source_data_check = array(
											"campaign_id" 	=> 	clean_data($campaign_det),
											"traffic_id"	=>	clean_data($source),
											"admarket"		=>  clean_data($admarket)
										);
										
										
		$traffic_check	=	$this->do_special_bidding->check_traffic_sources($source,$campaign_det,$account_id,$admarket);
		
		if($traffic_check==TRUE)
		{
			$traffic_success=$this->do_special_bidding->add_traffic_sources($traffic_source_data);	

			# print_r($traffic_source_data);  die("123");
						
			if($traffic_success)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					/*********Message Requirements**************/
				/* Activity Log for EDIT zonelimitation - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,TRAFFIC_SOURCE_ADD);
					if($enable=='1')
					{				
						$this->zone_activity_log(TRAFFIC_SOURCE,ADD,$traffic_success);
					}
					/* Activity Log for Edit zonelimitation - End*/	
					$client_id 		=	$this->user_authentication->client_id;

					$account_type	=	$this->user_authentication->account_type;

					$network_id	=	$this->do_message->fetch_admin_network_id();

					$message  = $this->default_configurations->get('message_type');		
					
					if($account_type=='TRAFFICKER')
					{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$user 			= 	$this->do_message->get_affiliate($affiliate_id); 

					}
					else{
						$user = $this->do_message->get_profile(ADMIN_ID); 
					}
					
					$acc_type='ADVERTISER';
					
					$type_details		=	array(
												'msg_type'		=> $message,
												'type'			=> "ADMIN_MESSAGE_SETTINGS",
												'string'		=> 'traffic_source_add',
												'column_name'	=> 'network_settings'
												);
						
						
					$reciever= $this->do_campaign->fetch_reciever($campaign_det);
					$message_data		=	array(
													'sender_id'		=>	ADMIN_ID,
													'receiver_id'	=>	$reciever['account_id'],
													'subject'		=>	'Traffice source Added',
													'content'		=>	'A new traffic source added successfully<br><br><b>Traffic Source Details</b><br><br>Bid Rate:'.$traffic_source_data['bid_rate'].'<br>Status:'.$traffic_source_data['status'].'<br>Traffic Id:'.$traffic_source_data['status'].'<br>Campaign Id:'.$traffic_source_data['campaign_id'],
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'notification_type'	=>	"network_setting",
													'dj_is_admarket'=>	$admarket,
													'status'		=>	'1',
													'network_id'	=>	$network_id,									
													'date'			=>	date('Y-m-d H:i:s')
													);
			$notification_msg = $this->do_message->get_notification_msg('traffic_source_add'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	

			$msg_replace = str_replace("{{bid_rate}}",$traffic_source_data['bid_rate'],$msg_replace);
			$msg_replace = str_replace("{{traffic_status}}",$traffic_source_data['status'],$msg_replace);
			$msg_replace = str_replace("{{traffic_id}}",$traffic_source_data['traffic_id'],$msg_replace);
			$msg_replace = str_replace("{{campaign_id}}",$traffic_source_data['campaign_id'],$msg_replace);
			
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
					//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
			
					/*********Message Requirements**************/
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Traffic_sources successfully added',
									'redirect'	 	=> 	site_url('advertiser/network/traffic_sources'),
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Traffic_sources successfully added',
									'redirect'	 	=> 	site_url('admin/network/traffic_sources'),
									);
				}	
				
				$this->response($success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/network/traffic_sources'),
									);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/network/traffic_sources'),
									);
				}	
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
						'response' 		=> 	'error',
						'msg'	 		=> 	'Error. This combination is already exists',
						'redirect'	 	=> 	site_url('advertiser/network/traffic_sources'),
						);	
			$this->response($error, 200);
		}		
	}

	function zone_activity_log($module,$process,$traffic_id)
	{
				/* Activity Log for Add/Edit/Delete site - Start	*/			
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$advertiser_id =	$this->user_authentication->client_id;
				//$module=$module;
				//$process=$process;				
				//$campaign_id=$campaign_id;
				
				$activity_log=array(				
								"account_id"=>$account_id,
								"useragent"=>$user_agent,
								"browser"=>$browser,
								"os"=>$os,
								"ip"=>$ip,
								"date"=>$date,
								"module"=>$module,
								"process"=>$process,
								"advertiser_id"=>$advertiser_id,
								"traffic_id"=>$traffic_id,
								
								);				
				$this->redis_library->logcount($account_id,$activity_log);  																						
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	
	/*
	 *Insert source traffic 
	 */
	function zone_bidding_post()
	{
		$zone_bid		= 	clean_data($this->post('zone_bid'));
		$bid_rate		=	clean_data($this->post('zone_bid_rate'));	
		$zone_status	= 	clean_data($this->post('zone_status'));
		$campaign_det	= 	clean_data($this->post('camp_det'));	
		$campaign_type  =   clean_data($this->post('campaign_type'));
		$account_id		=   $this->user_authentication->account_id;
		$admarket       =   clean_data($this->post('admarket'));
		
		$zone_bidding_data = 	array(
									"campaign_id" 	=> 	clean_data($campaign_det),
									"zone_id"		=>	clean_data($zone_bid),
									"bid_rate"		=>	clean_data($bid_rate),
									"status"		=>	clean_data($zone_status),
									"campaign_type" =>  clean_data($campaign_type),
									"account_id"    =>  clean_data($account_id),
									"admarket"      =>  clean_data($admarket)
								);
								
		$zone_bidding_data_check = array(
											"campaign_id" 	=> 	clean_data($campaign_det),
											"zone_id"		=>	clean_data($zone_bid),
											"admarket"      =>  clean_data($admarket)
										);
		$zone_bidding_check	=	$this->do_special_bidding->check_zone_bidding($zone_bid,$campaign_det,$account_id,$admarket);
		
		if($admarket=='1')
		{
			$url=site_url('advertiser/admarket/zone_bidding');
		}
		else
		{
			$url=site_url('advertiser/network/countrywise_bidding');
		}
	
		if($zone_bidding_check==TRUE)
		{
			$zone_bidding_success=$this->do_special_bidding->add_zone_bidding($zone_bidding_data);				
						
			if($zone_bidding_success)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					/*********Message Requirements**************/
				/* Activity Log for EDIT zonelimitation - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,ZONE_BIDDING_ADD);
					if($enable=='1')
					{				
						$this->zone_activity_log_for_zoneid(ZONE_BIDDING,ADD,$zone_bidding_success);
					}
					/* Activity Log for Edit zonelimitation - End*/	
					$client_id 		=	$this->user_authentication->client_id;

					$account_type	=	$this->user_authentication->account_type;

					$network_id	=	$this->do_message->fetch_admin_network_id();

					$message  = $this->default_configurations->get('message_type');		
					
					if($account_type=='TRAFFICKER')
					{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$user 			= 	$this->do_message->get_affiliate($affiliate_id); 

					}
					else{
						$user = $this->do_message->get_profile(ADMIN_ID); 
					}
					
					$acc_type='ADVERTISER';
					
					$type_details		=	array(
												'msg_type'		=> $message,
												'type'			=> "ADMIN_MESSAGE_SETTINGS",
												'string'		=> 'zone_bid_add',
												'column_name'	=> 'network_settings'
												);
						
							
					$reciever= $this->do_campaign->fetch_reciever($campaign_det);
					
					$message_data		=	array(
													'sender_id'		=>	ADMIN_ID,
													'receiver_id'	=>	$reciever['account_id'],
													'dj_is_admarket'=>	$reciever[0]['dj_is_admarket'],
													'subject'		=>	'Zone Bidding Added',
													'content'		=>	'A new Zone bidding added successfully<br><br><b>Zone Bidding Details</b><br><br>Bid Rate:'.$zone_bidding_data['bid_rate'].'<br>Status:'.$zone_bidding_data['status'].'<br>Zone Id:'.$zone_bidding_data['zone_id'].'<br>Campaign Id:'.$zone_bidding_data['campaign_id'],
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'notification_type'	=>	"network_setting",	
													'status'		=>	'1',
													'network_id'	=>	$network_id,									
													'date'			=>	date('Y-m-d H:i:s')
													);
			
			$notification_msg = $this->do_message->get_notification_msg('ad_zone_bid_add'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$click_directADS	= 	$this->config->item('click_directADS');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	

			$msg_replace = str_replace("{{bid_rate}}",$zone_bidding_data['bid_rate'],$msg_replace);
			$msg_replace = str_replace("{{zone_bid_status}}",$zone_bidding_data['status'],$msg_replace);
			$msg_replace = str_replace("{{zone_id}}",$zone_bidding_data['zone_id'],$msg_replace);
			$msg_replace = str_replace("{{campaign_id}}",$zone_bidding_data['campaign_id'],$msg_replace);
			
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$click_directADS.'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
					
					//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);  
	
					/*********Message Requirements**************/
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Zone Bidding successfully added',
									'redirect'	 	=> 	$url,
									);
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Zone Bidding successfully added',
									'redirect'	 	=> 	$url,
									);
				}	
				
				$this->response($success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	$url,
									);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	$url,
									);
				}	
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
						'response' 		=> 	'error',
						'msg'	 		=> 	'Error. This combination is already exists',
						'redirect'	 	=> 	$url,
						);	
			$this->response($error, 200);
		}		
	}
	
	
	function zone_activity_log_for_zoneid($module,$process,$traffic_id)
	{
				/* Activity Log for Add/Edit/Delete site - Start	*/			
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:sa");							
				$account_id=$this->user_authentication->account_id;
				$advertiser_id =	$this->user_authentication->client_id;
				//$module=$module;
				//$process=$process;				
				//$campaign_id=$campaign_id;
				
				$activity_log=array(				
								"account_id"=>$account_id,
								"useragent"=>$user_agent,
								"browser"=>$browser,
								"os"=>$os,
								"ip"=>$ip,
								"date"=>$date,
								"module"=>$module,
								"process"=>$process,
								"advertiser_id"=>$advertiser_id,
								"traffic_id"=>$traffic_id,
								
								);				
																									
				$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	
	

}
?>
