<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Site extends REST_Controller
{
	public 		$min_floor_price;
	
	function __construct(){

		parent::__construct();	
		$this->load->library('redis_library');		
		$this->load->model('do_site');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');	
		$this->load->model('do_web_adblock');
		$this->load->model('do_app_config');
		$this->load->model('do_auto_link');			
		$this->min_floor_price 		=  	$this->default_configurations->get('pub_min_floor_price');
		$this->floor_price_enable 	=  	$this->default_configurations->get('floor_price_enable');
		$this->load->model('do_message');
		$this->load->model('do_networks');
		$this->load->library('notification');
        $this->load->library('user_authentication');
	    $key		=	$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = 	$this->user_authentication;
        $this->load->library('csvreader');
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }		   
	}
	
	
	//api/v1/site/add
	function add_post(){   
		
		$this->form_validation->set_rules('site_name','Site Name', 'required|trim|alpha_numeric_dash_space');
		$this->form_validation->set_rules('site_url', 'Website URL', 'required|trim|callback_siteurl_check|is_unique['.TAB_PUB_SITES.'.site_url]'); //|url_exists
		$this->form_validation->set_message('is_unique', 'Already this website url is being registered. please enter the unique one');
		//$this->form_validation->set_rules('category', 'Category', 'required');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			#$account_id = $this->post('account_id');
			//$user_auth  = $this->user_authentication;
			//$account_id = $user_auth->account_id;
			
			if($this->user_authentication->account_type=='TRAFFICKER')
			{
				$account_id = $this->user_authentication->account_id;
			}
			else
			{
				if($this->post('account_id')!='')
				{
					$account_id = $this->post('account_id');  
				}
				else
				{
					$account_id = $this->post('acc_id');
				}
				
			}
			    	
				$site_url = $this->url_creation($this->post('site_url'));	
			    	
			
				$site_id = $this->do_site->add($account_id,$this->post('site_name'),$site_url);
			if($site_id != FALSE){			
				
				if(is_array($this->post('category')) && count($this->post('category')) > 0 && (!in_array('all',$this->post('category')))){
					$this->do_site->set_assoc_category($site_id,$this->post('category'));				
				}
				
				$success = array(
						'response' => 'ok',
						'msg'	 => 'Site has been added successfully!..'
					);
				$account_id = 	$this->user_authentication->account_id;
				$account_type	=	$this->user_authentication->account_type;	
				
				
				/* Activity Log for Add site - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(SITE,SITE_ADD);
		        if($enable=='1')
		        {
					$this->activity_log(SITE,ADD,$site_id);
				}				
				/* Activity Log for Add site - End*/				
							
				/* GET DEFAULT MANAGER EMAIL ID */
				$network_id	=	$this->user_authentication->network_account_id;					
				$agency_id	=	$this->user_authentication->agency_id;
				$result		=	$this->do_networks->agency_owner_details($agency_id);
				$admin_name    	= 	$result['name'];			
				$admin_email	= 	$result['email'];	
				$admin_id   	= 	$result['account_id'];
				 
				if($account_type=='TRAFFICKER')
				{
					$affiliate_id	=	$this->user_authentication->affiliate_id;
					$reciever = $this->do_message->get_affiliate($affiliate_id); 
					 
					$user = $this->do_message->get_profile($admin_id);
					
					$mail_type = "PUBLISHER_SITE_ADD";
					$acc_type='TRAFFICKER';
					
					$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "PUBLISHER_SITE_ADD",
						'string'		=> 'site_add',
						'column_name'	=> 'site'
						);
					$message_data		=	array(
							'sender_id'		=>	$admin_id,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Publisher - Site',
							'content'		=> 	'Site added successfully',
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	"TRAFFICKER",
							'notification_type'	=>	"site",	
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);
																		
					$user_email    	=	$reciever['email'];
					$user_name     	=	$reciever['name'];
					$from 		   	= 	$admin_email;
					$to  		   	= 	$user_email;		
												
					$mail_content	=	array(
										"subject" 	   => "Site add",
										"to_name" 	   => $user_name,				
										"from_name"	   => $admin_name,
										"site_names"   => $this->post('site_name')
										 
									);
					$attachement='';
							
							
					$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
					
				}	
				
				/***************************************/	
				$this->response( $success, 200);
			}
						
		}
	}
	
	
	function fetch_zone_list_get()
	{
		$aff_id=$this->get('aff_id');	
        
        $width=$this->get('width');		
		
		$height=$this->get('height');		
			
		$zone_list = $this->do_site->fetch_exit_popunder_zone($aff_id,$width,$height);			
		
		$this->response($zone_list);
	}
	
	function fetch_get()
	{		
		//Get from library file
		if($this->user_authentication->account_type=='TRAFFICKER')
		  {
			$account_id = $this->user_authentication->account_id;
		  }
		  else
		  {
			$account_id = $this->get('account_id');
		  }
					
		if($account_id){
			$where = array('oxa.account_id'=>$account_id);
		}
			
			$site_id=$this->get('site_id');			
			
			$site_list = $this->do_site->fetch($where,$site_id);			
			
			$this->response($site_list);
		
	}
	
	/********
	 * 
	 *********/
	 
	function fetch_tag_parameters_get()
	{
		//Get from library file
		
		if($this->user_authentication->account_type=='TRAFFICKER')
		{			
			$account_id  = 	$this->user_authentication->account_id;
		}
		else
		{					
			$zone_id	= 	$this->get('zone_id');	
			$aff_list 	= 	$this->do_site->fetch_affiliate_zone($zone_id);					
			$account_id =   $aff_list[0]['account_id'];							
		}		
		
		$zone_id	= 	$this->get('zone_id');	
		
		if($account_id){
			$where = array(
							'publisher_id'	=>	$account_id,
							'tag_id'		=>	$zone_id
							);
			$tag = $this->do_site->fetch_tag_parameters($where);
			$this->response($tag);
		}
	}
	
	/**
       * 
       * name : fetch_site_get()
       * 
       * Fetches the individual website information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_site_get(){
					
		 $site_id = $this->input->get('site_id');
		 	
		if($site_id){
			
			$site_list = $this->do_site->get_info($site_id);
			$this->response($site_list);
			
		}else{
			$error = array(
								'response' => 'error',
								'msg' =>  'Not a correct site id'
							);

			 $this->response( $error, 200);	
		}
	}
	
	
	
	function fetch_sitelist_get(){
		
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id = 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	=	'';
		}	
		
		$site_id=$this->get('site_id');
			
		$site_list = $this->do_site->fetch_siteinfo($account_id,$site_id);
		$this->response($site_list);
		
	}
	
	
	function fetch_applist_get(){
		
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id = 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	=	'';
		}	
			
		$site_list = $this->do_site->fetch_appinfo($account_id);
		$this->response($site_list);
		
	}
	
	
	
	/**
       * 
       * name : fetch_site_cat_get()
       * 
       * Fetches the Site category association
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_site_cat_get(){
		
		 $site_id = $this->get('site_id');
		
		if($site_id){
			
			$site_cat_assoc = $this->do_site->get_site_category_assoc($site_id);
			$this->response($site_cat_assoc);
			
		}else{
			$error = array(
								'response' => 'error',
								'msg' =>  'Not a correct site id'
							);

			 $this->response( $error, 200);	
		}
	}
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		
		$this->form_validation->set_rules('site_name','Site Name', 'required|trim');
		$this->form_validation->set_rules('site_url', 'Website URL', 'required|trim|callback_siteurl_check|edit_unique['.TAB_PUB_SITES.'~site_url~site_id~'.$this->post('site_id').']');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			 $site_url = $this->url_creation($this->post('site_url'));		
			$site_id = $this->do_site->update($this->post(),$site_url);
			$site_cat= $this->post('category');
			if (($key = array_search('all', $site_cat)) !== false) {
			    unset($site_cat[$key]);
			}		
			
			$this->do_site->set_assoc_category($site_id,$site_cat);		
			
				
			$success = array(
									'response' => 'ok',
									'msg'	 => 'Site has been updated successfully!..'
					);
					
					
			$update_site = $this->post('site_name');
			
			$account_id = 	$this->user_authentication->account_id;	 
			 
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
			
			
			/* Activity Log for Edit site - Start*/				
				$enable	=  	$this->default_configurations->activity_log_setting(SITE,SITE_EDIT);
		        if($enable=='1')
		        {
					$this->activity_log(SITE,EDIT,$site_id);
				}				
				/* Activity Log for Add site - End*/	
			/* Activity Log for Edit site - End*/				
					
				
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
			
				$user = $this->do_message->get_profile($admin_id);
				
				$mail_type = "PUBLISHER_SITE_UPDATE";
				$acc_type='TRAFFICKER';
				
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "PUBLISHER_SITE_UPDATE",
					'string'		=> 'site_edit',
					'column_name'	=> 'site'
					);
				$message_data		=	array(
					'sender_id'		=>	$admin_id,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Site',
					'content'		=> 	'Site updated successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"site",	
					'status'		=>	'1',
					'network_id'	=>	$network_id,									
					'date'			=>	date('Y-m-d H:i:s')
					);
					
													
				$user_email    	=	$reciever['email'];
				$user_name     	=	$reciever['name'];
				$from 		   	= 	$admin_email;
				$to  		   	= 	$user_email;		
										
				$mail_content=array(
						"subject" 	   => "Site update",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,					 
						"site_names"   => $update_site
					);
					
				$attachement='';
					
				$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
			}		
					
			/***************************************/
			$this->response($success, 200);
		}
			
		
	}
	
	function site_editcheck($val,$id)
	{		
		if(substr($val, -1)!='/')
		{
			$site_url=$val."/";  
		}
		else
		{
			$site_url=$val;
		}	
		$result=$this->do_site->edit_fetch($id); 
		
		$count=0;
		
		foreach ($result as $res)
		{
			if(substr($res['site_url'], -1)!='/')
			{
				$db_site_url=$res['site_url']."/";  
			}
			else
			{
				$db_site_url=$res['site_url'];
			}	
			if(md5($db_site_url)==md5($site_url))
			{
				$count++;
			}
		}		
				
		if ($count>0)
		{
			$this->form_validation->set_message('site_editcheck', 'Already this website url is being registered. please enter the unique one');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function update_site_post()
	{
		
		$this->form_validation->set_rules('site_name','Site Name', 'required|trim');
		$this->form_validation->set_rules('site_url', 'Website URL', 'required|trim|callback_siteurl_check|callback_site_editcheck['.$this->input->post('site_id').']');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{			
			$domain_url=$this->post('site_url');
			if(substr($domain_url, -1)!='/')
			{
				$domain_url=$domain_url."/";
			}
			else
			{
				$domain_url=$domain_url;
			}	
			$domain = explode("//",$domain_url); 						
			$md5_domain_url= md5($domain[1]);
			
			$db_site=$this->post('db_siteurl');
			if(substr($db_site, -1)!='/')
			{
				$db_site=$db_site."/";
			}
			$db_siteurl = explode("//",$db_site);
			$db_site_url= md5($db_siteurl[1]);
			 $site_url = $this->url_creation($this->post('site_url'));					
			$site_id = $this->do_site->update($this->post(),$site_url);
							
			$site_cat= $this->post('category');
			if (($key = array_search('all', $site_cat)) !== false) {
			    unset($site_cat[$key]);
			}		
			
			$this->do_site->set_assoc_category($site_id,$site_cat);	

			if($md5_domain_url==$db_site_url)
			{
				$site_status='1';
			}
			else
			{
				$site_status='0';  
			}  
			
			$site_data= $this->do_site->fetch_verify($site_id);
																	
			if($site_data[0]['verify']=='1')
			{
				$verification_status='1';
			}
			else
			{
				$verification_status='0';
			} 			
						
				
			$success = array(
									'response' => 'ok',
									'domain_url'=> $md5_domain_url,
									'site_id' => $site_id,
									'change_siteurl'=>$site_status,
									'verify'=>$verification_status,
									'success_site_url'=>$domain_url,
									'success_site_name'=>$this->post('site_name'),						
									'msg'	 => 'Site has been updated successfully!..'
					);
					
					
			$update_site = $this->post('site_name');
			
			$account_id = 	$this->user_authentication->account_id;	 
			 
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
			
			
			/* Activity Log for Edit site - Start*/				
				$enable	=  	$this->default_configurations->activity_log_setting(SITE,SITE_EDIT);
		        if($enable=='1')
		        {
					$this->activity_log(SITE,EDIT,$site_id);
				}				
				/* Activity Log for Add site - End*/	
			/* Activity Log for Edit site - End*/				
					
				
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
			
				$user = $this->do_message->get_profile($admin_id);
				
				$mail_type = "PUBLISHER_SITE_UPDATE";
				$acc_type='TRAFFICKER';
				
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "PUBLISHER_SITE_UPDATE",
					'string'		=> 'site_edit',
					'column_name'	=> 'site'
					);
				$message_data		=	array(
					'sender_id'		=>	$admin_id,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Site',
					'content'		=> 	'Site updated successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"site",	
					'status'		=>	'1',
					'network_id'	=>	$network_id,									
					'date'			=>	date('Y-m-d H:i:s')
					);
					
													
				$user_email    	=	$reciever['email'];
				$user_name     	=	$reciever['name'];
				$from 		   	= 	$admin_email;
				$to  		   	= 	$user_email;		
										
				/*$mail_content=array(
						"subject" 	   => "Site update",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,					 
						"site_names"   => $update_site
					);*/
					
				$attachement='';
					
				//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);*/
				
					$notification_value ='site_edit';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$site_name=$this->post('site_name');
					$site_url = $this->url_creation($this->post('site_url'));	
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{site_name}}",$site_name,$msg);
					$msg = str_replace("{{site_url}}",$site_url,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'"/admin>Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}
					
										
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);			
			}		
					
			/***************************************/
			$this->response($success, 200);
		}
			
		
	}
	
	
	/* Complete ad site
  * 
  * name: complete_ad_site_post
  * 
  * @return boolean (or) string Returns the object on TRUE (or) FALSE
  * */
 
    public function complete_ad_site_post()
    { 
	  $user_auth  =  $this->user_authentication;
	  $account_id =  $user_auth->account_id;
	  $agency_id  =  $user_auth->agency_id; 
	     
	     if($account_id)
		   { 	   
			$site_id  = clean_data($this->post('site_id'));     
			$verify_val  = clean_data($this->post('verify_val'));		  
			$update   = $this->do_site->update_verify($site_id,$verify_val);     
				 
				if($update)
				{
				$success   =  array(
					   'response'  => 'ok',
					   'site_id' => $site_id,
					   'msg'   => 'Site added successfully!..'
					  );     
				$account_type = $this->user_authentication->account_type; 
				$this->response($success, 200);
				}
				else
				{
				 $error = array(
						  'response'  =>  'error',
						  'msg'   =>  'Error! Please try Again..'
						  ); 		
				 $this->response($error, 200);
				}     	  
		   }
		   else
		   {
		     	 $error = array(
						 'response' => 'error',
						 'msg'  => 'Not an valid accountid!..'
					  ); 		
			     $this->response($error, 200);		
		   }
	  }
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{
		$site_id = $this->get('site_id');
		$site_name=array(); 
		$site_url=array();
		if($site_id)
		{
			$sitedel_id	=	explode(',',$site_id);
			if(is_array($sitedel_id))
			{ 
				foreach($sitedel_id as $site_id)
				{		
					/*Site Details */
					$site_res=$this->do_site->get_info($site_id);
					$site_name[]= $site_res[0]['site_name'];
					$site_url[] = $site_res[0]['site_url'];
					/*End*/
					/* Activity Log for Delete site - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(SITE,SITE_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(SITE,DELETE,$site_id);
					}
					/* Activity Log for Delete site - End*/				
			
					$site_id = $this->do_site->remove($site_id);
				}
			}
			else
			{
				/* Activity Log for Delete site - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(SITE,SITE_DELETE);
					if($enable=='1')
					{	
					$this->activity_log(SITE,DELETE,$site_id);
					}
				/* Activity Log for Delete site - End*/		
					$site_res=$this->do_site->get_info($site_id);
					$site_name= $site_res[0]['site_name'];
					$site_url= $site_res[0]['site_url'];
			
				$site_id = $this->do_site->remove($site_id);
				
			}
			$site_lists ='';
					 
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Site has been deleted'
							 );
			 
			$account_id = 	$this->user_authentication->account_id;
			
			$account_type	=	$this->user_authentication->account_type;	
			
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];		
			
						 
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
		 
				$user = $this->do_message->get_profile($admin_id);
				
				$mail_type = "PUBLISHER_SITE_DELETE";
				$acc_type='TRAFFICKER';
				
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "PUBLISHER_SITE_DELETE",
					'string'		=> 'site_del',
					'column_name'	=> 'site'
					);
				$message_data		=	array(
					'sender_id'		=>	$admin_id,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Site',
					'content'		=> 	'Site deleted successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"site",	
					'status'		=>	'1',
					'network_id'	=>	$network_id,									
					'date'			=>	date('Y-m-d H:i:s')
					);
					
													
				$user_email    	=	$reciever['email'];
				$user_name     	=	$reciever['name'];
				$from 		   	= 	$admin_email;
				$to  		   	= 	$user_email;		
										
				/*$mail_content=array(
						"subject" 	   => "Site delete",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,					 
						"site_names"   => $del_site_name
						 
					);*/
					
				$attachement='';					 
					
				//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);*/
				
					$notification_value ='site_del';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{	
					$site_name=(count($site_name)>0)?implode(",",$site_name):$site_name;
					$site_url=(count($site_url)>0)?implode(",",$site_url):$site_url;
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{site_name}}",$site_name,$msg);
					$msg = str_replace("{{site_url}}",$site_url,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);		  			
					}  
					else
					{
						$mail_content=$notification_content;
					}					
										
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);
								
			}		
					
			/***************************************/
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Site id is not found'
					);
			$this->response( $error, 200);
		}
	}
	
	/*******************************************************************************
	 * 								AD BLOCK BY SITE
	 * *****************************************************************************/
	
	
	/**
       * Author: suganthi
       * Date : 13-03-2015 
       * name : fetch_adblocks_get()
       * 
       */
       
       
    /** 
     * name: fetch_adblocks_get
     * @params : account_id and zone_id
     * 
     * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    
	
	public function fetch_affiliate_get()
	{		
		$site_id=$this->get('site_id'); 
		
		$aff_list 	= 	$this->do_site->fetch_affiliate_site($site_id);
			
		$this->response($aff_list);
		
	}
	
	public function fetch_ad_block_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		 {
				$user_auth  	= 	$this->user_authentication;
				$account_id 	= 	$user_auth->account_id;
		}
		else
		{
			    $account_id 	= 	$this->get('account_id');
		}
		$zone_id	   	= 	$this->get('zone_id');	
		
		$size_list 	= 	$this->do_site->fetch_adblock_size($account_id,$zone_id);
			
		$this->response($size_list);		
	}
    
    
	public function fetch_adblocks_get()
	{					
		#$account_id 	= 	$this->get('account_id');
		if($this->user_authentication->account_type=='TRAFFICKER')
		 {
				$user_auth  	= 	$this->user_authentication;
				$account_id 	= 	$user_auth->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}
		$site_id	   	= 	$this->get('site_id');
		$zone_id	   	= 	$this->get('zone_id');	
		$rotator_adblock= 	$this->get('rotator_block_status');
	
		//if($account_id){			
			$adb_list 	= 	$this->do_site->fetch_adblocks($account_id,$site_id,$zone_id,$rotator_adblock);
			
			$this->response($adb_list);
		//}
	}
	public function fetch_appconfig_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		 {
				$user_auth  	= 	$this->user_authentication;
				$account_id 	= 	$user_auth->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}		
		$network_id	=	$this->user_authentication->network_account_id;	
		
			$app_list 	= 	$this->do_app_config->fetch($network_id);
			$this->response($app_list);
     }	
		
	public function fetch_adblocks_filter_get()
	{	
		
		$ad_type=$this->get('ad_type');
		$zone_type=$this->get('zone_type');
		if($this->user_authentication->account_type=='TRAFFICKER')
		 {
				$user_auth  	= 	$this->user_authentication;
				$account_id 	= 	$user_auth->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}		
	
		if($ad_type!='null'||$zone_type!='null')
		{
			$adb_list 	= 	$this->do_site->fetch_adblocks($account_id,'','','',$ad_type,$zone_type);
			$this->response($adb_list);	
		}		 
		else
		{
			$adb_list 	= 	$this->do_site->fetch_adblocks();$this->response($adb_list);		
		}	
		
	}
	
	public function exit_popunder_adblock_post()
	{
		$user_auth  	= 	$this->user_authentication;
		$account_id 	= 	$user_auth->account_id; 		
		$affiliate		=	$this->do_site->fetch_affiliate_default_exit_popunder($account_id);
		if($affiliate=="0" || $affiliate=="FALSE")
		{ 
				$delivery 		= 	delivery_value('3');
				$aff_id			=	$this->do_site->fetch_affiliate($account_id);
				$add_adblock	=	array(	
										"affiliateid"		=>	$aff_id['affiliateid'],
										"zonename"          =>  $this->lang->line('default_exit_popunder'),
										"zonetype"			=>	'3',
										"default_exit_popunder" => '1',
										"delivery"			=>  $delivery,										
										"dj_zone_type"		=>	"W_A_EP",
										"dj_added_date"		=>	date("Y-m-d H:i:s")									
									); 							
													
				$zone_data		=	$this->do_web_adblock->exit_popunder_add($add_adblock);	
				$zone_name=$zone_data[0]['zonename'];  
				$zone_id=$zone_data[0]['zoneid'];
		}
		
		$success 	= 	array(
								'response' 			=> 	'ok',										
								'zoneid'			=> 	$zone_id,
								'zonename'          =>  $zone_name
							  );
												
		$this->response($success, 200);      
			
	}
	
	public function fetch_exit_popunder_adblock_post()
	{
		$user_auth  	= 	$this->user_authentication;
		$account_id 	= 	$user_auth->account_id; 	

		if($this->user_authentication->account_type=='TRAFFICKER')
		{			
			$aff	=	$this->do_site->fetch_affiliate($account_id);
		}
		
		$affiliate		=	$this->do_site->fetch_affiliate_default_exit_popunder($account_id);
		if($affiliate=="0" || $affiliate=="FALSE")
		{ 
				$delivery 		= 	delivery_value('3');
				$aff_id			=	$this->do_site->fetch_affiliate($account_id);
				$add_adblock	=	array(	
										"affiliateid"		=>	$aff_id['affiliateid'],
										"zonename"          =>  $this->lang->line('default_exit_popunder'),
										"zonetype"			=>	'3',
										"default_exit_popunder" => '1',
										"delivery"			=>  $delivery,										
										"dj_zone_type"		=>	"W_A_EP",
										"dj_added_date"		=>	date("Y-m-d H:i:s")									
									); 							
													
				$zone_data		=	$this->do_web_adblock->exit_popunder_add($add_adblock);	
				
		}
		
		$zone_id=$this->post('zone_id');
		
		$size_list 	    =   $this->do_site->fetch_adblock_size($account_id,$zone_id);
			
		$zone_value	    =   $size_list[0];
				
		$zone_list 	    =   $this->do_site->fetch_exit_popunder_zone($aff['affiliateid'],$zone_value['width'],$zone_value['height']);	
												
		$where_exist	=	array("tag_id"=>$zone_id);		
						
		$tag            =   $this->do_site->fetch_tag_parameters_exit($where_exist);	
						
		$exist_zone_id	=	$tag[0]['exit_popunder_id'];
	
	
		$success 		= 	array(
											'response' 	=> 'ok',
											'exit_popunder' => $zone_list,
											'exist_zone_id'=>$exist_zone_id											
								 ); 			 		
												
		$this->response($success, 200);      
			
	}
	
	
	/******** AD BLOCK - FIRST STEP *******/
	
	/* Add Ad block type by site
	 * 
	 * name: add_ad_block_post
	 * 
	 * @return boolean (or) string Returns the object on TRUE (or) FALSE
	 **/
	
    public function add_ad_block_post()
    {			
		$this->form_validation->set_rules('zone_type','Zone Type', 'required|trim');		
		
		$zsize	=	array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML,WEB_AD_BLOCK_LAYER,WEB_AD_BLOCK_CATFISH);
		
		if(in_array($this->post('zone_type'),$zsize))
		{		
			$this->form_validation->set_rules('ad_block_size','Ad Block Size', 'required|trim');
		}
		
		$ztype	=	array(WEB_AD_BLOCK_SITESKIN,MOBILE_AD_BLOCK_SLIDER,MOBILE_AD_BLOCK_PULL);
		
		if(in_array($this->post('zone_type'),$ztype))
		{
			$this->form_validation->set_rules('ad_block_type','Ad Block Type', 'required|trim');
			$adposition	=	clean_data($this->post('ad_block_type'));
		}
		else
		{
			$adposition	=	'';
		}
		
		$type=$this->post('choose_type');
					
		if($this->form_validation->run() === FALSE)
		{  
			 $error_msg = 	$this->form_validation->error_array();			

			 $error 	= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$user_auth  = 	$this->user_authentication;
			$account_id = 	$user_auth->account_id; 
			$agency_id 	= 	$user_auth->agency_id; 	 		
			
			if($account_id)
			{
				/* Fetch Affiliateid */	
				
				$site_id	=	($this->post('site_id')!='')?$this->post('site_id'):$this->post('site_list_id');
				
				$app_id     =   ($this->post('app_id')!='')?$this->post('app_id'):$this->post('app_list_id');
				
				if($this->user_authentication->account_type=='TRAFFICKER')
			    {											
					if($type=='1')
					{
					$affiliate	=	$this->do_site->fetch_affiliate($account_id);
					}
					else if($type=='2')
					{
					$aff_list 	= 	$this->do_site->fetch_affiliate_app($app_id);
					$affiliate 	= 	$aff_list[0];
					$os_type=$aff_list[0]['os_type'];						
					}					
			    }
			    else
			    {						
					if($type=='1')
					{
					$aff_list 	= 	$this->do_site->fetch_affiliate_site($site_id);
					$affiliate 	= 	$aff_list[0];
					$os_type='';					
					}
					else if ($type=='2')
					{
					$aff_list 	= 	$this->do_site->fetch_affiliate_app($app_id);
					$affiliate 	= 	$aff_list[0];
					$os_type=$aff_list[0]['os_type'];
					}
				}								
																
				if($this->post('ad_block_size'))
				{
					$adbsize	=	$this->post('ad_block_size');
				}
				else
				{
					$adbsize	=	$this->post('adb_size');
				}
				
				
				$size			=	explode('x',$adbsize);	
				$width			=	$size[0];
				$height			=	$size[1];
				
				if($this->post('mobile_ad_type')!='')
				{
					$zone_type	=	0;
				}
				else
				{
					$zone_type	=	3;
				}
				if($this->post('rotator') == 'Y'){
					$rotator_adblock = 1;
				}
				else{
					$rotator_adblock = 0;
				}
				if($this->post('market_adblock')==1)
				{
				$market_adblock=1;
				}
				else
				{
				$market_adblock=0;
				}
				//delivery number
				$delivery 		= 	delivery_value($this->post('zone_type'));
				
				$add_adblock	=	array(	
										"affiliateid"		=>	$affiliate['affiliateid'],
										"zonetype"			=>	$zone_type,
										"delivery"			=>  $delivery,										
										"width"				=>  clean_data($width),
										"height"			=>  clean_data($height),
										"dj_ad_position"	=>  $adposition,
										"dj_zone_type"		=>	clean_data($this->post('zone_type')),
										"dj_mobile_ad_type"	=>	$this->post('mobile_ad_type'),
										"dj_added_date"		=>	date("Y-m-d H:i:s"),
										"rotator_block_status"	=>	$market_adblock,
										"dj_is_admarket"	=>	$this->post('admarket'),
										/*,
										"dj_banner_autoreload"=> $this->post('banner_autoload')*/
									); 
									
														 
													
				if($this->post('_adblock_id')=='')
				{		
					$add_adblock["zonename"]=	'adblock'.date('d').'_'.rand(100, 999);
					$zone_id		=	$this->do_web_adblock->add($add_adblock);	
						
					
					if($type=="1")
					{
					$add_adbAssoc 	= 	array(
											"site_id"	=> 	$site_id,
											"zone_id"	=> 	$zone_id	
											);
					
					$this->do_web_adblock->addAssoc($add_adbAssoc);		
					
					/* Activity Log for Add adblock - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADBLOCK,ADB_ADD);
					if($enable=='1')
					{			
					$this->activity_log(ADBLOCK,ADD,$site_id,$zone_id,'');
					}
					/* Activity Log for Add adblock - End*/	
							
					}
					else if($type=="2")
					{
					 $add_adbAssoc 	= 	array(
											"app_id"	=> 	$app_id,
											"zone_id"	=> 	$zone_id,
											"account_id"=>$account_id												
											);					
					 $this->do_web_adblock->add_appAssoc($add_adbAssoc);										
					 
					 /* Activity Log for Add adblock - Start*/
					 $enable	=  	$this->default_configurations->activity_log_setting(ADBLOCK,ADB_ADD);
					if($enable=='1')
					{												
					$this->activity_log(ADBLOCK,ADD,'',$zone_id,$app_id);
					}
					/* Activity Log for Add adblock - End*/						
					}
					
				
				}
				else
				{	
					$zone_id	=	$this->post('_adblock_id');
					$where		=	array(
										"affiliateid"		=>	$affiliate['affiliateid'],
										"zoneid"			=>	$zone_id
									);
									
					$update		= 	$this->do_site->update_ad_block($add_adblock,$where,$agency_id);
					
					/* Activity Log for Edit adblock - Start*/	
					 $enable	=  	$this->default_configurations->activity_log_setting(ADBLOCK,ADB_EDIT);
					
					if($enable=='1')
					{																				
					$this->activity_log(ADBLOCK,EDIT,$site_id,$zone_id);
					}
					/* Activity Log for Edit adblock - End*/				
					
				}				
				
				if($zone_id)
				{
					//Auto Linking ofZones
					if($this->post('rotator') == 'Y'){
					
					}
					else{
						
					$this->do_auto_link->link_ads($zone_id,$agency_id);
					}
					$success 	= 	array(
										'response' 			=> 	'ok',
										'adblock_id'		=> 	$zone_id,
										'adblock_type'		=> 	$this->post('zone_type'),
										'mobile_ad_type'	=> $this->post('mobile_ad_type'),
										'adblock_size'		=> 	$adbsize,
										"os_type"           =>  $os_type,
										'floor_price_enable'=> 	$this->floor_price_enable,
										'pub_enable'		=>	$affiliate['floor_price_enable'],
										'msg'				=> 	'Ad blocks are added successfully!..'
									);
												
					$this->response($success, 200);
				}
				else
				{
					$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error! Please try Again..'
								);	
					$this->response($error, 200);
				}
		
			}else{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Not an valid accountid!..'
								);	
				$this->response($error, 200);
			}
		}

	}
	
	public function download_post()
	{
		$filename=$this->post('file_name'); 		
		$file = realpath( $_SERVER['DOCUMENT_ROOT'] ).'/csv/download/'.$filename.".html";
		chmod($file, 0777);
		$fh = fopen($file, 'w') or die("can't open file");
		$current = file_get_contents($file);
		$current .= '<meta name="adgate" content="'.$filename.'">"';
		file_put_contents($file, $current);
		fclose($file);
		
		$data = file_get_contents($file); // Read the file's contents
		$name = $filename."html";				
		force_download($name, $data);		
	}
	
	public function verify_post()
	{
		$filename=$this->post('file_name');  
		$site_url=$this->post('domain_url');   
		$site_id=$this->post('site_id');
		
		/* Meta tag verification in index file*/
		$tags = get_meta_tags($site_url);   
		
		/* Filename verification in root path */
		if(substr($site_url, -1)!='/')
		{
			$siteurl=$site_url."/";
		}
		else
		{
			$siteurl=$site_url;
		}
		$file=$siteurl.$filename.".html";  
		
		if($tags['adgate'])
		{	
			if($tags['adgate'] == $filename)
			{
				$site_url_change='';
				$db_site_data= $this->do_site->fetch_db_site($site_id);
				if($db_site_data[0]['site_url']!=$site_url)
				{	
					$site_url_change=$site_url;
					$this->do_site->update_db_site($site_id,$site_url);
				}
				
				$update   = $this->do_site->update_verify($site_id,'1');     
			    $success = array(
						'response' => 'ok',
						'status'=>'verified',
						'site_url'=>$site_url_change,
						'msg'	 => 'Metatag Verified'
					);
				$this->response($success,200);
			}
			else
			{
				$update   = $this->do_site->update_verify($site_id,'0');     
				$success = array(
						'response' => 'error',
						'msg'	 => 'meta tag is not avilable in index file'
					);
				$this->response($success,200);				
			}	
			
		}
		else
		{				
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $file);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			$html = curl_exec($ch); 
			curl_close($ch); 
			
			
			$mdata = array(); 
			$doc = new DOMDocument();
			$doc->loadHTML($html);
			$metanodes = $doc->getElementsByTagName('meta'); 
			foreach($metanodes as $node) { 
			$key = $node->getAttribute('name'); 
			$val = $node->getAttribute('content'); 
			if (!empty($key)) { $mdata[$key] = $val; } 
			}
									
			if($mdata['adgate'] == $filename)
			{
				$site_url_change='';
				$db_site_data= $this->do_site->fetch_db_site($site_id);
				if($db_site_data[0]['site_url']!=$site_url)
				{
					$site_url_change=$site_url;
					$this->do_site->update_db_site($site_id,$site_url);
				}
				$update   = $this->do_site->update_verify($site_id,'1');     
			    $success = array(
						'response' => 'ok',
						'status'   => 'verified',
						'site_url'=>$site_url_change,
						'msg'	   => 'Metatag Verified'
					);
				$this->response($success,200);
			}
			else
			{
				$update   = $this->do_site->update_verify($site_id,'0');     
				$success = array(
						'response' => 'error',
						'msg'	 => 'Filename is not avilable in root path'
					);
				$this->response($success,200);
			}
		}
	
		
	}

	function site_check($val)
	{
		if(substr($val, -1)!='/')
		{
			$site_url=$val."/";  
		}
		else
		{
			$site_url=$val;
		}	
		$result=$this->do_site->fetch();
		
		$count=0;
		
		foreach ($result as $res)
		{
			if(md5($res['site_url'])==md5($site_url))
			{
				$count++;
			}
		}		
				
		if ($count>0)
		{
			$this->form_validation->set_message('site_check', 'Already this website url is being registered. please enter the unique one');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}


	public function siteurl_check($url)
	{
		$pattern = "/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i";

		if (preg_match($pattern, $url)) 
		  {
			return TRUE;
		  }
		else
		{
			$this->form_validation->set_message('siteurl_check', 'Please Enter Valid url');
			return FALSE;
		}	
    }	
	public function add_site_post()
    {			
		$this->form_validation->set_rules('site_name','Site Name', 'required|trim|alpha_numeric_dash_space');
		$i_inc = $this->post('i_inc');
		if($i_inc == '0'){
		$this->form_validation->set_rules('site_url', 'Website URL', 'required|trim|callback_siteurl_check|callback_site_check'); //|url_exists  
		$this->form_validation->set_message('is_unique', 'Already this website url is being registered. please enter the unique one');
		}
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			#$account_id = $this->post('account_id');
			//$user_auth  = $this->user_authentication;
			//$account_id = $user_auth->account_id;
			
			if($this->user_authentication->account_type=='TRAFFICKER')
			{
				$account_id = $this->user_authentication->account_id;
			}
			else
			{
				if($this->post('account_id')!='')
				{
					$account_id = $this->post('account_id');  
				}
				else
				{
					$account_id = $this->post('acc_id');
				}
				
			}
			$i_inc = $this->post('i_inc');
			if($i_inc == '0'){
				$site_id = $this->do_site->add($account_id,$this->post('site_name'),$this->post('site_url'));
			}
			else{
				$site_id = $this->post('site_id');
								
				$site_url = $this->url_creation($this->post('site_url'));	
				$sites = 
				array('site_name'=>$this->post('site_name'),
						'site_url'=>$site_url,
						'updated_date'=>date('Y-m-d H:i:s'),
						'site_id' => $site_id
					);
				
				$site_id = $this->do_site->update($sites);
			}
			$domain_url=$site_url; 
			if(substr($domain_url, -1)!='/')
			{
				$domain_url=$domain_url."/";
			}
			else
			{
				$domain_url=$domain_url;
			}			
			$domain = explode("//",$domain_url); 						
			$md5_domain_url= md5($domain[1]); 
			
			if($site_id != FALSE){			
				
				if(is_array($this->post('category')) && count($this->post('category')) > 0 && (!in_array('all',$this->post('category')))){
					$this->do_site->set_assoc_category($site_id,$this->post('category'));				
				}
				
				$success = array(
						'response' => 'ok',
						'domain_url'=> $md5_domain_url,
						'site_id' => $site_id,
						'success_site_url'=>$domain_url,
						'success_site_name'=>$this->post('site_name'),
						'msg'	 => 'Site has been added successfully!..'
					);
				$account_id = 	$this->user_authentication->account_id;
				$account_type	=	$this->user_authentication->account_type;	
				
				
				/* Activity Log for Add site - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(SITE,SITE_ADD);
		        if($enable=='1')
		        {
					$this->activity_log(SITE,ADD,$site_id);
				}				
				/* Activity Log for Add site - End*/				
							
				/* GET DEFAULT MANAGER EMAIL ID */
				$network_id	=	$this->user_authentication->network_account_id;					
				$agency_id	=	$this->user_authentication->agency_id;
				$result		=	$this->do_networks->agency_owner_details($agency_id);
				$admin_name    	= 	$result['name'];			
				$admin_email	= 	$result['email'];	
				$admin_id   	= 	$result['account_id'];
								 
				if($account_type=='TRAFFICKER')
				{
					$affiliate_id	=	$this->user_authentication->affiliate_id;
					$reciever = $this->do_message->get_affiliate($affiliate_id); 					 
					$user = $this->do_message->get_profile($admin_id);
					
					$mail_type = "PUBLISHER_SITE_ADD";
					$acc_type='TRAFFICKER';
					
					$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "PUBLISHER_SITE_ADD",
						'string'		=> 'site_add',
						'column_name'	=> 'site'
						);
					$message_data		=	array(
							'sender_id'		=>	$admin_id,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Publisher - Site',
							'content'		=> 	'Site added successfully',
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	"TRAFFICKER",
							'notification_type'	=>	"site",	
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);
																		
					$user_email    	=	$reciever['email'];
					$user_name     	=	$reciever['name'];
					$from 		   	= 	$admin_email;
					$to  		   	= 	$user_email;		
												
					$attachement='';
									
					$notification_value ='site_add';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$site_name=$this->post('site_name');
					$site_url = $this->url_creation($this->post('site_url'));	
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{site_name}}",$site_name,$msg);
					$msg = str_replace("{{site_url}}",$site_url,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);	
					}
					else
					{
						$mail_content=$notification_content;
					}				
							
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);
								
				}					
				$this->response( $success, 200);   
			}
						
		}
	}
	
	
	public function domain_validate_post()
	{		
		$subdomain_url=$this->post('domain_url');
		$validate_custom_url=checkdnsrr($subdomain_url,"CNAME"); 
		if($validate_custom_url=='1')
		{
			$success 		= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'your Url is Valid'
								);	
			$this->response($success, 200);
		}
		else
		{
			if($subdomain_url=='')
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Enter Custom URL!..'
								);	
			    $this->response($error, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'CNAME is not for the Domain'
								);	
			    $this->response($error, 200);
			}	
		}
	}
	
	/******** AD BLOCK - SECOND STEP *******/
	
	/* Complete Ad block by site
	 * 
	 * name: complete_ad_block_post
	 * 
	 * @return boolean (or) string Returns the object on TRUE (or) FALSE
	 * */
	
    public function complete_ad_block_post()
    {	
		$user_auth  = 	$this->user_authentication;
		$account_id = 	$user_auth->account_id;
		$agency_id 	= 	$user_auth->agency_id;	
		
		/* Fetch Affiliateid */	
		
		if($this->user_authentication->account_type=='TRAFFICKER')
		{			
			$affiliate	=	$this->do_site->fetch_affiliate($account_id);
		}
		else
		{
			$zone_id	=	$this->post('_adblock_id');
			$aff_list 	= 	$this->do_site->fetch_affiliate_zone($zone_id);
			$affiliate 	= 	$aff_list[0];					
		}
			
		$this->form_validation->set_rules('adblock_name','Ad Block Name', 'required|trim');		
		
		if($this->floor_price_enable=='enable')
		{
			if($affiliate['floor_price_enable']=='1')
			{
				$this->form_validation->set_rules('floor_price','Floor Price', 'required|trim|greater_than_equal_to['.$this->min_floor_price.']');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			 $error_msg = 	$this->form_validation->error_array();			

			 $error 	= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{			
			
			if($account_id)
			{	
			
				$zone_id		=	$this->post('_adblock_id');		
									
				$site_id		=	$this->post('site_id');					
				
				$app_id		=	$this->post('app_id');	
				
				// custom serve url custom work	
				
				if($this->post('is_custom_serveurl'))
				{
					$custom_serveurl = 1;
					$subdomain_customurl		=	$this->post('sub_domainurl');
				}
				else
				{
					$custom_serveurl = 0;
				}
				$subdomain_url		=	$this->post('sub_domainurl');
				$cname				=	$this->post('cname_filename');
				
				// custom serve url custom work						
									
				
				$where			=	array(
											"affiliateid"		=>	$affiliate['affiliateid'],
											"zoneid"			=>	$zone_id
										);
				$select_cpm		= $this->post('select_cpm');
				
				if($select_cpm==1)
				{
					$fixed_cpm = $this->post('fixed_cpm_rate');
					$fixed_system_cpm = 0;
				}
				else if($select_cpm==2)
				{
					$fixed_cpm = 0;
					$fixed_system_cpm = $this->post('fixed_system_cpm_rate');
				}
				else
				{
					$fixed_cpm = 0;
					$fixed_system_cpm = 0;
				}
				$Google_txt = 	$this->post('google_text');	
					$key_text	=	$this->post('key_type');
			$key_list_id='';
			if($key_text == "WEB_HIGHLIGHT_TEXT")
			{
			$key_list_id=$this->post('key_list_id');
			}
			else
			{
			$key_list_id='';
			}
								
				 if($Google_txt == "google_text")
				{
				$update_adblock	=	array(							
										"zonename"  		=>	clean_data($this->post('adblock_name')),
										"dj_passback_tag"	=>	stripslashes($this->post('passback')),
										"fixed_cpm"			=>	$fixed_cpm,
										"is_customurl"  	=> $custom_serveurl,
										"subdoamin_url" 	=> $subdomain_url,
										"cname"     		=> $cname,
										"fixed_system_cpm" 	=> 	$fixed_system_cpm,
										"d_width"  			=>	clean_data($this->post('g_width')),
										"d_height"  		=>	clean_data($this->post('g_height')),
										"d_background_color" =>	clean_data($this->post('g_background')),
										"d_border"  		=>	clean_data($this->post('g_border')),
										"d_border_color"  	=>	clean_data($this->post('g_border_color')),
										"d_font_family"  	=>	clean_data($this->post('google_ad_font_family')),
										"d_font_size"  		=>	clean_data($this->post('g_font_size')),
										"d_font_color"  	=>	clean_data($this->post('g_font_color')),
										"d_head_font"  		=>	clean_data($this->post('g_h_font_size')),
										"d_head_font_color" =>	clean_data($this->post('g_h_font_color'))
																				
										);		
										
				}
				else if($this->post('html_template'))
				{ 
					$update_adblock	=	array(							
										"zonename"  		=>	clean_data($this->post('adblock_name')),
										"dj_passback_tag"	=>	stripslashes($this->post('passback')),
										"fixed_cpm"			=>	$fixed_cpm,
										"fixed_system_cpm" 	=> 	$fixed_system_cpm,
										'custom_css'	 	=> $this->post('custom_css'),
										'bg_color' 			=> $this->post('bg_color'),
										'sponsored_prefix'	=> $this->post('sponsored_prefix'),
										'inline_video'   	=> $this->post('inline_video_val'),
										'height'			=> $this->post('image_height'),
										'width'				=> $this->post('image_width'),
										'html_template'		=> $this->post('html_template'),
										'is_customurl'      => $custom_serveurl,
										'subdoamin_url'		=> $subdomain_url,
										'cname'     		=> $cname,
										'css_path'			=> $this->post('css_path')				
										);
				}
				
				else{
					$update_adblock	=	array(							
										"zonename"  		=>	clean_data($this->post('adblock_name')),
										"dj_passback_tag"	=>	stripslashes($this->post('passback')),
										"fixed_cpm"			=>	$fixed_cpm,
										"is_customurl"  	=> $custom_serveurl,
										"subdoamin_url" 	=> $subdomain_url,
										"cname"     		=> $cname,
										"fixed_system_cpm" 	=> 	$fixed_system_cpm,
						 				'keywords'			=> $key_list_id
										
										);		
				}	
											
				if($this->post('floor_price'))
				{
					$update_adblock["dj_floor_price"]	=	$this->post('floor_price');
				}			
				
					
				$size_list 	= 	$this->do_site->fetch_adblock_size($account_id,$zone_id);
			
				$zone_value	=  $size_list[0];
				
				$zone_list 	= $this->do_site->fetch_exit_popunder_zone($affiliate['affiliateid'],$zone_value['width'],$zone_value['height']);			
				$update			=	$this->do_site->update_ad_block($update_adblock,$where,$agency_id);	
				
				if($this->user_authentication->account_type!='TRAFFICKER')
				{	
					/* Data update from Edit adblock*/
					$highlight_zone_val=$this->post('highlight_zone');  
					$this->do_web_adblock->update_highlight_zone_edit($zone_id,$highlight_zone_val);   
					
					/* Publisher created before 30 Days*/
					$aff_id=$affiliate['affiliateid']; 
					$aff_detail	= $this->do_site->fetch_pub_detail($aff_id);  
					$added_date = $aff_detail[0]['added_date'];  
					
					$network_id	 =	$this->user_authentication->network_account_id;					
					$highlight_zone = $this->do_app_config->fetch($network_id);
					$highlight_days = $highlight_zone[0]['highlight_days'];					
					$days="+".$highlight_days." days"; 
					$last_valid_date=date('Y-m-d', strtotime($added_date.$days)); 
					
					$current_date=date('Y-m-d');
								
					if(strtotime($current_date)<=strtotime($last_valid_date))
					{					
						$highlight_zone_val="1";  
						$this->do_web_adblock->update_highlight_zone_edit($zone_id,$highlight_zone_val);   
					}	
					
					/* Send mail to Advertiser who are selected highlight Zone */
					$advertiser_details=$this->do_message->get_all_advertiser_details();
					foreach($advertiser_details as $adv)
					{
					$adv_account_id=$adv['account_id'];   
					$adv_det=$this->do_message->get_profile($adv_account_id);		
					$adv_email=$adv_det['email'];
					$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "HIGHLIGHT_ZONE",
						'string'		=> 'highlight_zone',
						'column_name'	=> 'highlight'
						);
					$message_data		=	array(
						'sender_id'		=>	$admin_id,
						'receiver_id'	=>	$adv_account_id,
						'subject'		=>	'HighLight Zone',
						'content'		=> 	'Changed successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'status'		=>	'1',
						'network_id'	=>	$network_id,									
						'date'			=>	date('Y-m-d H:i:s')
						);
						
					$attachement='';					 
					
								
						$notification_value ='highlight';
						$notification_msg = $this->do_message->get_notification_msg($notification_value); 
						if($notification_msg[0]['msg_type']=='1')
						{
							$notification_content = $notification_msg[0]['content'];
						}
						else
						{
							$template_filename = $notification_msg[0]['template_filename'];
							$csvfilepath 	= $this->config->item('read_settings');	
							$notification_content = file_get_contents($csvfilepath.$template_filename);
						} 
							
						$searchStr=$this->config->item('macros');
						$count=0;
						foreach($searchStr as $search)
						{	
						 if (strpos($notification_content, $search) !== false)
							 {
							$count++;
							}
						}
						if($count>0)
						{	
						$site_name=(count($site_name)>0)?implode(",",$site_name):$site_name;
						$site_url=(count($site_url)>0)?implode(",",$site_url):$site_url;
						$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
						$msg = str_replace("{{advertiser_name}}",$reciever['name'],$msg);	
						$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
						$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
						$mail_content = str_replace("{{click_here}}",'<a     style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);		  			
						}  
						else
						{
							$mail_content=$notification_content;
						}					
								
						$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);			
			}
			
					
					
				}				
				
				if($update)
				{
					
					$success 		= 	array(
											'response' 	=> 'ok',
											'adblock_name' => $this->post('adblock_name'),
											'custom_serveurl' => $subdomain_customurl,
											'exit_popunder' => $zone_list,
											'msg'	 	=> 'Ad blocks input are added successfully!..'  
										); 			 
		
					$account_type	=	$this->user_authentication->account_type;	
					
					/* GET DEFAULT MANAGER EMAIL ID */
					$network_id	=	$this->user_authentication->network_account_id;					
					$agency_id	=	$this->user_authentication->agency_id;
					$result		=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];
					 
					if($account_type=='TRAFFICKER')
					{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$reciever = $this->do_message->get_affiliate($affiliate_id); 
								
						$user = $this->do_message->get_profile($admin_id);
						
						$mail_type = "PUBLISHER_ADBLOCK_ADD";
						$acc_type='TRAFFICKER';
					
						$type_details		=	array(
							'msg_type'		=> $message,
							'type'			=> "PUBLISHER_ADBLOCK_ADD",
							'string'		=> 'adb_add',
							'column_name'	=> 'adblock'
							);
						$message_data		=	array(
							'sender_id'		=>	$admin_id,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Publisher - Adblock',
							'content'		=> 	'Adblock Add/Update successfully',
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	"TRAFFICKER",
							'notification_type'	=>	"site",	
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);
							
															
						$user_email    	=	$reciever['email'];
						$user_name     	=	$reciever['name'];
						$from 		   	= 	$admin_email;
						$to  		   	= 	$user_email;		
											
						/*$mail_content	=	array(
												"subject" 	=> 	"Adblock add/update",
												"to_name" 	=> 	$user_name,				
												"from_name"	=> 	$admin_name,											 
												"zonename"  => 	$this->post('adblock_name')												 
											);*/
											
						$attachement='';  
							
							
						/*$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);*/
						
					if($this->post('notification_adblock')!='')	
					{
						$notification_value ='adb_edit';    
					}
					else
					{
						$notification_value ='adb_add'; 
					}
					
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];  
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$zone_name=$this->post('adblock_name');
					$zone_size = $zone_value['width']."X".$zone_value['height'];  	
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{adcode_name}}",$zone_name,$msg);
					$msg = str_replace("{{adcode_size}}",$zone_size,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}				
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);					
					}
					
					/***************************************/	
					$this->response($success, 200);
				}
				else
				{
					$error = array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error! Please try Again..'
							);	
				
					$this->response($error, 200);
				}					
		
			}else{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Not an valid accountid!..'
				);	
				
				$this->response($error, 200);
			}
		}

	}
	
	/*********************** AD CODE GENERATION *********************/
	
	/**
       * 
       * name : generate_adtags_post()
       * 
       * Generates the Ad tags with custom settings
       * 
       * @return the generated response
    */
	
	
	public function generate_adtags_post()
	{
		
		$zone_id 	= 	$this->post('id');	
		
		if($zone_id)
		{			
			$adblock_tag 	= 	$this->generate_adblock_tag($this->post());
			
			$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag
									);	
			
			$this->response($success);
			
		}else{
			
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Adblock id is not found'
					);
			
			$this->response( $error, 200);
		}
	}	
	
	public function generate_adblock_tag($values =FALSE)
	{
		$site_url 		= 	$this->config->item("adserving_url");		
		$path 			= 	$site_url.$values['adbtype'];
		
						
		if($values['adbtype']!='' && $values['adbtype']!='iframe' && $values['adbtype']!='layer_iframe' )
		{
			$adbtype	=	$values['adbtype'];
			unset($values['api_key']);
			unset($values['adbtype']);	
			
			//Remove empty values		
			foreach($values as $key=>$value)
			{
				if($value=='')
				{
					unset($values[$key]);
				}
			}
			
			$encoded_string =	http_build_query($values);
			
			if($adbtype=='direct')
			{			
				$code	=	$path.'.php?'.$encoded_string;	
			}
			else
			{
				$code	=	'<script type="text/javascript" src="'.$path.'.js?'.$encoded_string.'"></script>';
			}		
		}
		else if($values['adbtype']=='iframe' || $values['adbtype']=='layer_iframe')
		{
			$ran1 	= 	'a'.substr(md5(uniqid('', 1)), 0, 7);	
			
			$code	=	"<iframe id='".$ran1."' name='".$ran1."' src='".$site_url.$values['adbtype'].".php?reload=".$values['refresh_val']."&id=".$values['id']."&target=_blank&cb=INSERT_RANDOM_NUMBER_HERE' frameborder='0' scrolling='no' width='".$values['width']."' height='".(($values['adbtype']=='layer_iframe')?$values['height']+200:$values['height'])."' ></iframe>";
		}
		else
		{
			$code	=	'<script type="text/javascript" src="'.$site_url.'banners.js?id='.$values['id'].'"></script>';
		}
						
		return $code;	
	}
	
	
	public function generate_adblock_video_tag($values =FALSE)
	{
		$site_url 		= 	$this->config->item("adserving_url");		
		$path 			= 	$site_url.$values['adbtype'];
										
		if($values['adbtype']!='' && $values['adbtype']!='iframe' && $values['adbtype']!='layer_iframe' )
		{
			$adbtype	=	$values['adbtype'];
			unset($values['api_key']);
			unset($values['adbtype']);	
			
			//Remove empty values		
			foreach($values as $key=>$value)
			{
				if($value=='')
				{
					unset($values[$key]);
				}
			}
			
			$encoded_string =	http_build_query($values);
			
			if($adbtype=='direct')
			{			
				$code	=	$path.'.php?'.$encoded_string;	
			}
			else if($adbtype=='inline')
			{
				$player=$values['inplayer'];
				$roll=$values['roll'];
				$vast_version=$values['vast_version'];
				if($roll=='1'){$roll_val="preroll";}if($roll=='2'){$roll_val="midroll";}if($roll=='3'){$roll_val="postroll";}
				$limit=$values['limit'];
				  if($player=='4')
				  {
					  
					  if(!empty($limit) && ($vast_version=='vast_pod' || $vast_version=='vast_pod_wrapper'))
					  {
						  $code= $site_url."fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=".$roll_val.":0.0-0%3D".$values['id']."&nz=1&source=&r=R0.05822725687175989&block=1&limit=".$limit."&format=".$vast_version."&charset=UTF-8";
					  }
					  else
					  {
						  $code= $site_url."fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=".$roll_val.":0.0-0%3D".$values['id']."&nz=1&source=&r=R0.05822725687175989&block=1&format=".$vast_version."&charset=UTF-8";
					  }
					
				  }
				  else if($player=="3")
				  {
					 $code	=	'<script type="text/javascript" src="'.$site_url.'inline.js?id='.$values['id'].'"></script>';
				  }
				  else
				  {
					 $code	=	'<script type="text/javascript" src="'.$site_url.'inline.js?id='.$values['id'].'"></script>';
				  }
			}
			
			else if($adbtype=='overlay')
			{					
				$player=$values['ol_player'];
				$vast_version=$values['vast_version'];
				$roll_val="overlay"; 
				if($player=='4')
				  {					 
					 $code= $site_url."fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=".$roll_val.":0.0-0%3D".$values['id']."&nz=1&source=&r=R0.05822725687175989&block=1&format=".$vast_version."&charset=UTF-8";					  		
				  }
				  else if($player=="3")
				  {					
					 $code	=	'<script type="text/javascript" src="'.$site_url.'overlay.js?id='.$values['id'].'"></script>';
				  }
				  else
				  {					
					 $code	=	'<script type="text/javascript" src="'.$site_url.'overlay.js?id='.$values['id'].'"></script>';
				  }
			}			
			else
			{
				$code	=	'<script type="text/javascript" src="'.$path.'.js?'.$encoded_string.'"></script>';
			}		
		}
		else if($values['adbtype']=='iframe' || $values['adbtype']=='layer_iframe')
		{
			$ran1 	= 	'a'.substr(md5(uniqid('', 1)), 0, 7);	
			
			$code	=	"<iframe id='".$ran1."' name='".$ran1."' src='".$site_url.$values['adbtype'].".php?refresh=".$values['refresh_val']."&id=".$values['id']."&target=_blank&cb=INSERT_RANDOM_NUMBER_HERE' frameborder='0' scrolling='no' width='".$values['width']."' height='".(($values['adbtype']=='layer_iframe')?$values['height']+200:$values['height'])."' ></iframe>";
		}
		else
		{
			$code	=	'<script type="text/javascript" src="'.$site_url.'banners.js?id='.$values['id'].'"></script>';
		}
						
		return $code;	
	}	
	
	/** 
     * name: top_bottom_adblock_post
     * @params : account_id and zone_id
     * 
     * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    
	public function top_bottom_adblock_post()
	{					
		#$account_id 	= 	$this->get('account_id');
		$user_auth  	= 	$this->user_authentication;
		$account_id 	= 	$user_auth->account_id;
		$site_id	   	= 	$this->post('site_id');
		$zone	=	array(	'width'	=>	$this->post('width'),
							'height'=>	$this->post('height')
						);
		
		if($account_id){	
			$adb_list 	= 	$this->do_site->fetch_topbottom_adblocks($account_id,$site_id,$zone);
			if($adb_list)
			{
				$this->response($adb_list);	
			}
			else
			{
				$this->response('error',200);
			}
		}
	}		
	
	/************************** Save Tag settings *************************/
	
	public function save_tag_settings_post()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		{			
			$account_id  = 	$this->user_authentication->account_id;
		}
		else
		{
					
			$zone_id 	= 	$this->post('id');			
			$aff_list 	= 	$this->do_site->fetch_affiliate_zone($zone_id);		
			$account_id =   $aff_list[0]['account_id'];							
		}				
		
		$zoneid 	= 	$this->post('id');
			
		$exit_popunder_id=$this->post('exit_zoneid');		
		
		$enable_exit=$this->post('enable_exit');
										
		if($zoneid)
		{	
			//Common Parameters
			if($this->post('adbtype')=='popup' || $this->post('adbtype')=='popunder' || $this->post('adbtype')=='inline' || $this->post('adbtype')=='real' || $this->post('adbtype')=='small' || $this->post('adbtype')=='box' || $this->post('adbtype')=='head' || $this->post('adbtype')=='overlay')
			{
				$auto_reload			=	-1;
				$reload_time			=	-1;				
				$views_count			=	-1;
				$views_time				=	-1;
				$reload_trigger			=	-1;
			}
			else
			{
				if($this->post('banner_autoload')=='enable')
				{
					$auto_reload			=	$this->post('autoreload');
					$reload_time 			=	($this->post('autoreload')!=0)?$this->post('reloadtime'):-1;
				}
				else
				{
					$auto_reload			=	-1;
					$reload_time			=	-1;
				}
				
				$reload_trigger			=	 ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
								
				
				if($this->post('adbtype')=='layer' || $this->post('adbtype')=='catfish'|| $this->post('adbtype')=='slider')
				{
						//$time_set=$this->post('time_set');	
					//	$views_count			=	(clean_data($this->post('session_cap_zone')))?clean_data($this->post('session_cap_zone')):-1;
					//	$views_time				=	(clean_data($this->post('block_zone')))?clean_data($this->post('block_zone')):-1;
					
					if($time_set=="min")
					{
						$views_time=$this->post('layer_block_zone')*60;
					}
					else if($time_set=="hour")
					{
						$views_time=$this->post('layer_block_zone')*3600;
					}
					elseif($time_set=="day")
					{
						$views_time=$this->post('layer_block_zone')*86400;
					}
					else
					{
						$views_time=$this->post('layer_block_zone');
					}	

					$views_count			=	($this->post('layer_session_cap_zone'))?$this->post('layer_session_cap_zone'):-1;
					
				}
				else
				{ 
					$views_count			=	($this->post('session_cap_zone'))?$this->post('session_cap_zone'):-1;
					$views_time				=	($this->post('block_zone'))?$this->post('block_zone'):-1;
				}
			}				
				
			//Popup/popunder Parameters
			$popup_count			=	-1;
			$popup_time				=	-1;
			$popup_time_setting		=	-1;
			$pcwr					=	-1;
			$pcwor					=	-1;
			$reload_time_setting    =   -1;
			$nonreload_time_setting    =   -1;
			$pdwr					=	-1;
			$pdwor					=	-1;
			
			//Layer/Slider Parameters
			$custom_settings         =  '';
			$width					=	-1;
			$height					=	-1;
			$time_setting			=   '';
			$layer_position         =   '';
			$float_position			=	'';
			$clicks_count			=	'';
			$clicks_time			=	'';
			$automatic_close		=	'';
			$automatic_close_time   =   '';
			$auto_scroll			=	'';
			$layer_border			=	'';
			$layer_border_option    =	'';
			$border_backgroundcolor	=	'';			
			$title					=	'';
			$color_style			=	-1;
			$border_color			=	'';
			$mouseover_color		=	'';
			$background_color		=	'';
			$exit_link_color		=	'';
			$title_color			=	'';
			$exit_link				=	-1;
			$frame_url				=	'';
			$exit_link_text			=	'';
			$close_link_position	=	'';
			$top_banner				=	-1;
			$top_adblock			=	-1;
			$bottom_banner			=	-1;
			$bottom_adblock			=	-1;
			$top_background_color	=	'';
			$bottom_background_color=	'';
			$layer_top_option    	=	'';
			$layer_bottom_option    =	'';
			
			//Gamebox Parameters
			$border					=	-1;
			$size					=	-1;
			$ads_count				=	-1;
			$disable_title			=	-1;										
			$auto_scrolling			=	-1;
			$scroll_time			=	-1;
			
			//Bannerbox Parameters
			$title_background_color	=	'';
			$title_link_color		=	'';
			$show_website_url		=	-1;
			$position				=	'';
			$show_website_description=	-1;			
			$website_background_color=	'';
			$banner_background_color=	'';
			
			//Site-skin parameters
			$content_width			=	-1;
			$left_offset 			=	-1;
			$top_offset				=	-1;
			$right_offset			=	-1;
			$z_index				=	0;
			$fixed					=	-1;
			$hide					=	'';
			
			//Inline/overlay parameters
			$vast_version		=	'';
			$player				=	-1;
			$width				=	-1;
			$height				=	-1;
			$video_type			=	-1;
			$progressive_url	=	'';
			$streaming_url		=	'';
			$rtmp_file			=	'';
			$image_url			=	'';
			$auto_play			=	-1;
			$show_companion		=	-1;
			$companion_width	=	-1;
			$companion_height	=	-1;
			$ad_position		=	-1;
			$ad_schedule		=	-1;
			$limit				=   -1;
			$html_video_url     =   '';
			
			$target_age			=	($this->post('target_age'))?$this->post('target_age'):-1;			
			$target_gender		=	($this->post('target_gender'))?$this->post('target_gender'):-1;			
			$target_color		=	($this->post('target_color'))?$this->post('target_color'):-1;			
			$target_height		=	($this->post('target_height'))?$this->post('target_height'):-1;			
			$target_weight		=	($this->post('target_weight'))?$this->post('target_weight'):-1;
					
			if($this->post('adbtype')=='popup' || $this->post('adbtype')=='popunder')
			{
				$popup_count			=	($this->post('popcount'))?$this->post('popcount'):-1;
				$popup_time				=	($this->post('popresettime'))?$this->post('popresettime'):-1;
				$popup_time_setting		=	($this->post('pop_time_set'))?$this->post('pop_time_set'):-1;  
								
				    if($popup_time_setting=="min")
					{
						$popup_time=$this->post('popresettime')*60;  
					}
					else if($popup_time_setting=="hour")
					{
						$popup_time=$this->post('popresettime')*3600;
					}
					elseif($popup_time_setting=="day")
					{
						$popup_time=$this->post('popresettime')*86400;
					}
					else
					{
						$popup_time=$this->post('popresettime');
					}	
									
					
				 $pcwr					=	($this->post('pcwr'))?$this->post('pcwr'):-1; 
				 $pdwr					=	($this->post('pdwr'))?$this->post('pdwr'):-1;
				
				$reload_time_setting	=	($this->post('pdwr_time'))?$this->post('pdwr_time'):-1;
				
					if($reload_time_setting=="sec")
					{
						$pdwr=$pdwr;  
					}
					else if($reload_time_setting=="min")
					{
						$pdwr=$pdwr*60;  
					}
					else if($reload_time_setting=="hour")
					{
						$pdwr=$pdwr*3600;
					}
					elseif($reload_time_setting=="day")
					{
						$pdwr=$pdwr*86400;
					}
					
								
				$pcwor					=	($this->post('pcwor'))?$this->post('pcwor'):-1; 
				$pdwor					=	($this->post('pdwor'))?$this->post('pdwor'):-1;	
				$nonreload_time_setting	=	($this->post('pdwor_time'))?$this->post('pdwor_time'):-1;
					
				if($nonreload_time_setting=="sec")
				{
					$pdwor=$this->post('pdwor');  
				}
				else if($nonreload_time_setting=="min")
				{
					$pdwor=$this->post('pdwor')*60;  
				}
				else if($nonreload_time_setting=="hour")
				{
					$pdwor=$this->post('pdwor')*3600;
				}
				elseif($nonreload_time_setting=="day")
				{
					$pdwor=$this->post('pdwor')*86400;
				}
			}
			elseif($this->post('adbtype')=='web_inters' || $this->post('adbtype')=='mob_interstital')
			{
				$exit_link				=	$this->post('exits');
				$frame_url				=	($this->post('exit_url') && $this->post('exits')==3)?$this->post('exit_url'):'';
			}
			elseif($this->post('adbtype')=='layer')
			{
				$reload_trigger			=   ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
				$clicks_count			=	($this->post('clicks_session_cap_zone'))?$this->post('clicks_session_cap_zone'):'';
				$clicks_time			=	($this->post('clicks_block_zone'))?$this->post('clicks_block_zone'):'';
				$custom_settings        =    $this->post('custom_settings');
				if($custom_settings=='1')
				{
				$width					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$time_setting			=	($this->post('time_set'))?$this->post('time_set'):'';
				$layer_position			=	($this->post('layer_position'))?$this->post('layer_position'):'';
				$float_position			=	($this->post('position'))?$this->post('position'):'';				
				$automatic_close		=	($this->post('automatically_close'))?$this->post('automatically_close'):'';
				$automatic_close_time   =   ($this->post('automatically_close_time'))?$this->post('automatically_close_time'):'';
				$auto_scroll			=	($this->post('auto_scroll'))?$this->post('auto_scroll'):'';
				$layer_border			=	($this->post('layer_border'))?$this->post('layer_border'):'';
				$layer_border_option    =	($this->post('layer_border_option'))?$this->post('layer_border_option'):'';
				if($layer_border_option!="yes")
				{
					$border_backgroundcolor	=	($this->post('border_backgroundcolor'))?$this->post('border_backgroundcolor'):'';							
				}			
				$disable_title			=	$this->post('layer_title');										
				$title					=	($this->post('layer_title')==2 || $this->post('layer_title')==3)?(($this->post('layer_title')==2)?$this->post('layer_custom_text'):$this->post('layer_custom_link')):'';
				$border					=	($this->post('lborder') || $this->post('lborder')==0)?$this->post('lborder'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('lborder')==1)?$this->post('bordercolor'):'';
				$color_style			=	$this->post('layerstyle');
				$background_color		=	($this->post('backgroundcolor') && $this->post('layerstyle')==1)?$this->post('backgroundcolor'):'';
				$exit_link_color		=	($this->post('exitcolor') && $this->post('layerstyle')==1)?$this->post('exitcolor'):'';
				$title_color			=	($this->post('titlecolor') && $this->post('layerstyle')==1)?$this->post('titlecolor'):'';
				$exit_link				=	$this->post('exit');
				$frame_url				=	($this->post('exit_url') && $this->post('exit')==3)?$this->post('exit_url'):'';
				$exit_link_text			=	($this->post('close_txt'))?$this->post('close_txt'):'';
				$close_link_position	=	($this->post('close_position'))?$this->post('close_position'):'';
				$top_banner				=	$this->post('top');
				$top_adblock			=	($this->post('topzone') && $this->post('top')==1)?$this->post('topzone'):-1;
				$layer_top_option    	=	($this->post('layer_top_option'))?$this->post('layer_top_option'):'';
				$bottom_banner			=	$this->post('bottom');
				$bottom_adblock			=	($this->post('bottomzone') && $this->post('bottom')==1)?$this->post('bottomzone'):-1;
				$layer_bottom_option    =	($this->post('layer_bottom_option'))?$this->post('layer_bottom_option'):'';
				if($layer_top_option!='yes')
				{
					$top_background_color	=	($this->post('top_backgroundcolor'))?$this->post('top_backgroundcolor'):'';
				}
				if($layer_bottom_option!='yes')
				{
					$bottom_background_color=	($this->post('bottom_backgroundcolor'))?$this->post('bottom_backgroundcolor'):'';
				}
				}			
				
			}
			elseif($this->post('adbtype')=='slider')
			{
				$reload_trigger			=   ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
				$custom_settings		=    $this->post('custom_settings');
				$clicks_count			=	($this->post('clicks_session_cap_zone'))?$this->post('clicks_session_cap_zone'):'';
				$clicks_time			=	($this->post('clicks_block_zone'))?$this->post('clicks_block_zone'):'';				
				if($custom_settings=='1')
				{
				$width 					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$time_setting			=	($this->post('time_set'))?$this->post('time_set'):'';
				$automatic_close		=	($this->post('automatically_close'))?$this->post('automatically_close'):'';
				$automatic_close_time   =   ($this->post('automatically_close_time'))?$this->post('automatically_close_time'):'';
				$auto_scroll			=	($this->post('sauto_scroll'))?$this->post('sauto_scroll'):'';
				$float_position			=	($this->post('direction'))?$this->post('direction'):'';
				$disable_title			=	$this->post('slider_title');										
				$title					=	($this->post('slider_title')==2 || $this->post('slider_title')==3)?(($this->post('slider_title')==2)?$this->post('slider_custom_text'):$this->post('slider_custom_link')):'';
				$border					=	($this->post('sborder') || $this->post('sborder')==0)?$this->post('sborder'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('sborder')==1)?$this->post('bordercolor'):'';
				$color_style			=	$this->post('sliderstyle');
				$background_color		=	($this->post('backgroundcolor') && $this->post('sliderstyle')==1)?$this->post('backgroundcolor'):'';
				$exit_link_color		=	($this->post('exitcolor') && $this->post('sliderstyle')==1)?$this->post('exitcolor'):'';
				$title_color			=	($this->post('titlecolor') && $this->post('sliderstyle')==1)?$this->post('titlecolor'):'';
				$exit_link				=	$this->post('sexit');
				$frame_url				=	($this->post('exit_url') && $this->post('sexit')==3)?$this->post('exit_url'):'';
				$exit_link_text			=	($this->post('close_txt'))?$this->post('close_txt'):'';
				$close_link_position	=	($this->post('close_position'))?$this->post('close_position'):'';
				}
			}
			elseif($this->post('adbtype')=='gamebox')
			{
				$custom_settings        =    $this->post('custom_settings');
				if($custom_settings=='1')
				{
				$border					=	($this->post('border') || $this->post('border')==0)?$this->post('border'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('border')==1)?$this->post('bordercolor'):'';
				$size					=	$this->post('direction');
				$width 					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$ads_count				=	($this->post('gamecount'))?$this->post('gamecount'):-1;
				$disable_title			=	$this->post('disable_title');										
				$title					=	($this->post('title') && $this->post('disable_title')==0)?$this->post('title'):'';
				$title_color			=	($this->post('titlecolor') && $this->post('disable_title')==0)?$this->post('titlecolor'):'';
				$auto_scrolling			=	$this->post('scroll');
				$scroll_time			=	($this->post('scrolltime') && $this->post('scroll')==1)?$this->post('scrolltime'):-1;
				}				
			}
			elseif($this->post('adbtype')=='bannerbox')
			{
				$custom_settings		=    $this->post('custom_settings');
				if($custom_settings=='1')
				{
				$size					=	$this->post('direction');
				$width 					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$ads_count				=	($this->post('bannercount'))?$this->post('bannercount'):-1;
				$disable_title			=	$this->post('bdisable_title');
				$title					=	($this->post('title') && $this->post('bdisable_title')==0)?$this->post('title'):'';
				$title_background_color	=	($this->post('title_backgroundcolor') && $this->post('bdisable_title')==0)?$this->post('title_backgroundcolor'):'';
				$title_link_color		=	($this->post('title_linkcolor') && $this->post('bdisable_title')==0)?$this->post('title_linkcolor'):'';
				$show_website_url		=	$this->post('website_url');
				$position				=	($this->post('urlposition') && $this->post('website_url')==1)?$this->post('urlposition'):'';
				$show_website_description=	$this->post('wdescription');
				$border_color			=	($this->post('bordercolor'))?$this->post('bordercolor'):'';
				$website_background_color=	($this->post('website_backgroundcolor'))?$this->post('website_backgroundcolor'):'';
				$banner_background_color=	($this->post('banner_backgroundcolor'))?$this->post('banner_backgroundcolor'):'';				
				}
			}
			elseif($this->post('adbtype')=='catfish')
			{
				$reload_trigger			=   ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
				$custom_settings		=    $this->post('custom_settings');
				if($custom_settings=='1')
				{
				$time_setting			=	($this->post('time_set'))?$this->post('time_set'):'';
				$background_color		=	($this->post('backgroundcolor'))?$this->post('backgroundcolor'):'';
				$border					=	($this->post('cborder') || $this->post('cborder')==0)?$this->post('cborder'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('cborder')==1)?$this->post('bordercolor'):'';
				$mouseover_color		=	($this->post('mouseovercolor'))?$this->post('mouseovercolor'):'';
				$close_link_position	=	($this->post('close_position'))?$this->post('close_position'):'';
				$clicks_count			=	($this->post('clicks_session_cap_zone'))?$this->post('clicks_session_cap_zone'):'';
				$clicks_time			=	($this->post('clicks_block_zone'))?$this->post('clicks_block_zone'):'';	
				}
			}
			elseif($this->post('adbtype')=='site-skin')
			{
				$custom_settings		=   $this->post('custom_settings');
				if($custom_settings=='1')
				{
				$content_width			=	($this->post('contentWidth'))?$this->post('contentWidth'):-1;
				$left_offset 			=	($this->post('leftpadding'))?$this->post('leftpadding'):-1;
				$top_offset				=	($this->post('topOffset'))?$this->post('topOffset'):-1;
				$right_offset			=	($this->post('rightpadding'))?$this->post('rightpadding'):-1;
				$z_index				=	($this->post('zindex'))?$this->post('zindex'):0;
				$fixed					=	$this->post('fixed');
				$hide					=	($this->post('hide'))?$this->post('hide'):'';				
				}
			}
			elseif($this->post('adbtype')=='inline')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
				$vast_version       =   ($this->post('vast_version'))?$this->post('vast_version'):'';
				$limit       		=   ($this->post('limit'))?$this->post('limit'):-1;
				$html_video_url     =   ($this->post('html_video_url'))?$this->post('html_video_url'):'';
			}
			elseif($this->post('adbtype')=='real')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			elseif($this->post('adbtype')=='small')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			elseif($this->post('adbtype')=='box')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			elseif($this->post('adbtype')=='head')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			
			elseif($this->post('adbtype')=='overlay')
			{
				$player				=	($this->post('olplayer'))?$this->post('olplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('olcompad');
				$companion_width	=	($this->post('cwidth') && $this->post('olcompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('olcompad')==1)?$this->post('cheight'):-1;
				$ad_schedule		=	($this->post('adstime'))?$this->post('adstime'):-1;
				$vast_version       =   ($this->post('overlay_vast_version'))?$this->post('overlay_vast_version'):'';				
			}	
			
										
			$tag_parameters	=	array(
										'tag_id'						=>	$zoneid,
										'publisher_id'					=>	$account_id,
										'auto_reload'					=>	$auto_reload,
										'reload_time' 					=>	$reload_time,
										'views_count'					=>	$views_count,
										'views_time'					=>	$views_time,
										'time_setting'                  =>  $time_setting,
										'reload_trigger'				=>	$reload_trigger,
										'popup_count' 					=>	$popup_count,
										'popup_time'					=>	$popup_time,
										'popup_time_setting'            =>  $popup_time_setting,
										'popup_count_with_reload'		=>	$pcwr,
										'popup_count_without_reload'	=>	$pcwor,
										'popup_delay_with_reload'		=>	$pdwr,
										'popup_delay_without_reload'	=>	$pdwor,										
										'width' 						=>	$width,
										'height'						=>	$height,
										'float_position'				=>	$float_position,
										'layer_position'				=>	$layer_position,
										'clicks_count'					=>  $clicks_count,
										'clicks_time'					=>	$clicks_time,
										'automatically_close'			=>	$automatic_close,
										'automatically_close_time'   	=>  $automatic_close_time,
										'auto_scroll'			        =>  $auto_scroll,
										'layer_border'			        =>	$layer_border,
										'layer_border_option'           =>  $layer_border_option,
										'border_backgroundcolor'        =>  $border_backgroundcolor,										
										'title'							=>	$title,
										'color_style'					=>	$color_style,
										'border_color'					=>	$border_color,
										'background_color'				=>	$background_color,
										'exit_link_color'				=>	$exit_link_color,
										'title_color'					=>	$title_color,
										'exit_link'						=>	$exit_link,
										'frame_url'						=>	$frame_url,
										'exit_link_text'				=>	$exit_link_text,
										'close_link_position'			=>	$close_link_position,
										'top_banner'					=>	$top_banner,
										'top_adblock'					=>	$top_adblock,
										'layer_top_option'              =>  $layer_top_option,
										'layer_bottom_option'           =>  $layer_bottom_option,
										'bottom_banner'					=>	$bottom_banner,
										'bottom_adblock'				=>	$bottom_adblock,
										'top_backgroundcolor'			=>	$top_background_color,
										'bottom_backgroundcolor'        =>  $bottom_background_color,
										'border'						=>	$border,										
										'size'							=>	$size,										
										'ads_count'						=>	$ads_count,
										'disable_title'					=>	$disable_title,
										'auto_scrolling'				=>	$auto_scrolling,
										'scroll_time'					=>	$scroll_time,
										'title_background_color'		=>	$title_background_color,
										'title_link_color'				=>	$title_link_color,
										'show_website_url'				=>	$show_website_url,										
										'position'						=>	$position,
										'show_website_description'		=>	$show_website_description,
										'website_background_color'		=>	$website_background_color,
										'banner_background_color'		=>	$banner_background_color,
										'content_width'					=>	$content_width,
										'left_offset' 					=>	$left_offset,
										'top_offset'					=>	$top_offset,
										'right_offset'					=>	$right_offset,
										'z_index'						=>	$z_index,										
										'fixed'							=>	$fixed,										
										'hide'							=>	$hide,										
										'player'						=>	$player,
										'video_type'					=>	$video_type,
										'progressive_url'				=>	$progressive_url,
										'streaming_url'					=>	$streaming_url,
										'rtmp_file'						=>	$rtmp_file,
										'image_url'						=>	$image_url,
										'auto_play'						=>	$auto_play,
										'show_companion'				=>	$show_companion,
										'companion_width'				=>	$companion_width,
										'companion_height'				=>	$companion_height,
										'ad_position'					=>	$ad_position,
										'ad_schedule'					=>	$ad_schedule,
										'mouseover_color'				=>	$mouseover_color,
										'vast_version'                  =>  $vast_version,
										'limit'                         =>  $limit,
										'html_video_url'                =>  $html_video_url,
										'target_age'                	=>  $target_age,
										'target_gender'                	=>  $target_gender,
										'target_color'                	=>  $target_color,
										'target_height'                	=>  $target_height,
										'target_weight'                	=>  $target_weight,
										'exit_popunder_id'              =>  $exit_popunder_id,
										'enable_exit_popunder'			=>  $enable_exit,
										'custom_setting'				=>  $custom_settings,
										'nonreload_time_setting'		=>  $nonreload_time_setting,
										'reload_time_setting'           =>  $reload_time_setting
									);	
			$where	=	array(
								'tag_id'		=>	$zoneid,
								'publisher_id'	=>	$account_id
							);
							
			$tagparam	=	$this->do_site->fetch_tag_parameters($where);
			
			if($tagparam!=FALSE)
			{
				$tag 	= 	$this->do_site->update_tag_parameters($where,$tag_parameters);
				
			}
			else
			{
				$tag 	= 	$this->do_site->add_tag_parameters($tag_parameters);
				
			}			
			
			if($tag)
			{
				
				/* Memcache start*/
				
				$mc = new Memcached();

				$isMemcacheAvailable=$mc->addServer("127.0.0.1", 11211);

				if ($isMemcacheAvailable)
				{
					$key="id_".$zoneid;
							
					$mc->set($key,$tag_parameters);	
				}		
				
				/* Memcache -End*/			 
				
				
				$ad_type=$this->post('adbtype');
				$in_player=$this->post('inplayer');				
				$ol_player=$this->post('olplayer');
								
								
				if(!empty($ad_type) && $in_player!='')
				{
					$vast_version=$this->post('vast_version');
					$roll=$this->post('oposition');
					$values['adbtype']=$ad_type;
					$values['inplayer']=$in_player;
					$values['vast_version']=$vast_version;
					$values['roll']=$roll; 
					$values['id']=$zoneid;
					$values['limit']=$limit;
					
					
					$adblock_tag 	= 	$this->generate_adblock_video_tag($values);
														
					$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag,
									'inplayer'  =>  $in_player  
									);	
				}
				else if(!empty($ad_type) && $ol_player!='')
				{
					$vast_version=$this->post('overlay_vast_version');
					$values['vast_version']=$vast_version;
					$values['adbtype']=$ad_type;
					$values['ol_player']=$ol_player;					
					$values['id']=$zoneid;
					
					$adblock_tag 	= 	$this->generate_adblock_video_tag($values);
														
					$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag,
									'inplayer'  =>  $ol_player  
									);
				}
				else
				{
					$adblock_tag 	= 	$this->generate_adblock_tag($this->post());
					
					$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag
									);	
				}			
				$this->response($success);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Error! please try again...'
					);
			
				$this->response( $error, 200);
			}		
			
		}else{
			
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Adblock id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	/** 
    * name: top_bottom_adblock_post
    * @params : account_id and zone_id
    * 
    * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    
	public function reset_adtags_post()
	{					
		$tag_id	= 	$this->post('id');
		$where	=	array('tag_id'	=>	$tag_id);
		
		if($tag_id){	
			$tag 			= 	$this->do_site->reset_tag_parameters($where);
			
			if($tag)
			{
				$adblock_tag 	= 	$this->generate_adblock_tag($this->post());
				$success = array(
								'response' 	=> 'ok',
								'msg'	 	=> $adblock_tag
							);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 'error',
								'msg'	 	=> 'Sorry! Tag parameters are not available to reset.'
							);
				$this->response( $error, 200);
			}
			
		}
	}

	public function fetch_siteid_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		  {
			$account_id = $this->user_authentication->account_id;
		  }
		  else
		  {
			$account_id = $this->get('account_id');
		  }	  
		
		$zone_id = $this->get('zone_id');  
		
		$site_res  = $this->do_site->fetch_siteid($zone_id,$account_id);
		
		
		
		if($site_res)
		{
				
			$this->response( $site_res, 200);
		}
		else
		{
			$error = array(
								'response' 	=> 'error',
								'msg'	 	=> 'Sorry! No Records Found'
							);
				
			$this->response( $error, 200);
		}
		
	}
	
	
	public function fetch_appid_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		  {
			$account_id = $this->user_authentication->account_id;
		  }
		  else
		  {
			$account_id = $this->get('account_id');
		  }	  
		
		$zone_id = $this->get('zone_id');  
		
		$site_res  = $this->do_site->fetch_appid($zone_id,$account_id);	
		
		if($site_res)
		{
				
			$this->response( $site_res, 200);
		}
		else
		{
			$error = array(
								'response' 	=> 'error',
								'msg'	 	=> 'Sorry! No Records Found'
							);
				
			$this->response( $error, 200);
		}
		
	}	
	
	function activity_log($module,$process,$site_id=false,$zone_id=false,$app_id=false)
	{
				/* Activity Log for Add/Edit/Delete site - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");	  						
				$account_id=$this->user_authentication->account_id;
				$publisher_id =	$this->user_authentication->affiliate_id;
				$module=$module;
				$process=$process;				
				$site_id=$site_id;
				
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>$publisher_id,
				"site_id"=>$site_id,
				"app_id"=>$app_id,
				"adblock_id"=>$zone_id);				
																									
				//$this->do_app_config->activity_log($account_id,$activity_log);
				$this->redis_library->logcount($account_id,$activity_log);  
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	
	public function url_creation($url)
	{
		
		if (!preg_match("~^(?:f|ht)tps?://~i", $url)) 
		{
           $site_url = "http://" . $url;
        }
        else
        {
		   $site_url = $url;	
		}	
		//$this->response($site_url,200);
		return $site_url;
    }	
	public function zonevalue_get()
	{ 
		$filter	=	$this->get('zone_type');
		$ad_type1 = array(array('0'=>WEB_AD_BLOCK_BANNER,'1'=>"Banner"),array('0'=>WEB_AD_BLOCK_DHTML,'1'=>"DHtml"),array('0'=>WEB_AD_BLOCK_TEXT,'1'=>"Text"),array('0'=>WEB_AD_BLOCK_EMAIL_NL,'1'=>"Email"),array('0'=>WEB_AD_BLOCK_POPUP,'1'=>"Pop-Up"),array('0'=>WEB_AD_BLOCK_POPUNDER,'1'=>"Pop-Under"),array('0'=>WEB_AD_BLOCK_DIRECT,'1'=>"Direct Link"),array('0'=>WEB_AD_BLOCK_LAYER,'1'=>"Layer"),array('0'=>WEB_AD_BLOCK_INTERSTITIAL,'1'=>"Web Interstitial"),array('0'=>WEB_AD_BLOCK_GAMEBOX,'1'=>"Gamebox"),array('0'=>WEB_AD_BLOCK_BANNERBOX,'1'=>"Bannerbox"),array('0'=>WEB_AD_BLOCK_SLIDER,'1'=>"Slider"),array('0'=>WEB_AD_BLOCK_CATFISH,'1'=>"Catfish"),array('0'=>WEB_AD_BLOCK_SITESKIN,'1'=>"Site-Skin"),array('0'=>WEB_AD_BLOCK_TOPBAR,'1'=>"TopBar"),array('0'=>WEB_AD_BLOCK_NATIVE,'1'=>"Native"),array('0'=>VIDEO_AD_BLOCK_OVERLAY,'1'=>"Video Overlay"),array('0'=>VIDEO_AD_BLOCK_INLINE,'1'=>"Video Inline"),array('0'=>VIDEO_AD_BLOCK_REAL,'1'=>"Video Read"),array('0'=>VIDEO_AD_BLOCK_SMALL,'1'=>"Video Small"),array('0'=>VIDEO_AD_BLOCK_BOX,'1'=>"Video Box"),array('0'=>VIDEO_AD_BLOCK_HEAD,'1'=>"Video Head"),array('0'=>MOBILE_AD_BLOCK_IMAGE,'1'=>"Image"),array('0'=>MOBILE_AD_BLOCK_TEXT,'1'=>"Mobile Text"),array('0'=>MOBILE_AD_BLOCK_INTERSTITIAL,'1'=>"Mobile Interstitial"),array('0'=>MOBILE_AD_BLOCK_EXPAND,'1'=>"Expand"),array('0'=>MOBILE_AD_BLOCK_REVEAL,'1'=>"Reveal"),array('0'=>MOBILE_AD_BLOCK_FLEX,'1'=>"Flex"),array('0'=>MOBILE_AD_BLOCK_ADHENSION,'1'=>"Adhesion"),array('0'=>MOBILE_AD_BLOCK_FLIMSTRIP,'1'=>"Filmstrip"),array('0'=>MOBILE_AD_BLOCK_SLIDER,'1'=>"Slider"),array('0'=>MOBILE_AD_BLOCK_PULL,'1'=>"Pull"),array('0'=>MOBILE_AD_BLOCK_DIALOG,'1'=>"Dialog"),array('0'=>MOBILE_AD_BLOCK_NOTIFICATION,'1'=>"Notification")); 
		
		$ad_type2 = array(array('0'=>MOBILE_APP_AD_BLOCK_INTERSTITIAL,'1'=>"App Interstitial"),array('0'=>MOBILE_APP_AD_BLOCK_FOOTER,'1'=>"Footer"),array('0'=>MOBILE_APP_AD_BLOCK_VIDEO,'1'=>"HTML5 video"));
		
		if($filter=='display')
		{
			
			$ad_type = $ad_type1;
		}
		elseif($filter=='application')
		{
			$ad_type = $ad_type2;
		}
		 else
		 {
			 $ad_type=array_merge($ad_type1,$ad_type2);
		 }
 

		  if($ad_type)
		 {
			 
			$form_data= '<select name="ad_type" id="ad_type" class="input-block-level select2-me input-xlarge" multiple data-nosearch="true" onchange="remove_all_data(\'ad_type\');run(\'ad_type\');" data-placeholder="Select Adtype">';
			
			foreach($ad_type as $sel => $val)
			{
				
				$form_data.='<option value="'.$val['0'].'">'.$val['1'].'</option>';    
			}
			$form_data.='</select>';
			 $response = array(
							'response' 	=> 	'ok',
							'adlist'	=>	$form_data,
						);					
		    $this->response($response, 200);
		 }
		 else
		 {
			 $this->response(array('error'=>'Type could not be found'),404);
		 }
		
	}	 
	
	public function news_post()
	{
		$month=$this->input->post('month');
		$year=$this->input->post('year');
		if($month && $year)
		{
			$news_data  = $this->do_site->fetch_news_data($month,$year);
		}
		else
		{
			$news_data  = $this->do_site->fetch_news_data();
		}
		$this->response($news_data,200);
		
	}
	
	
	public function add_news_post()
	{
		$html_content= $this->input->post('html_content');
		$heading= $this->input->post('heading');
		$image_url= $this->input->post('image_url');
		$add_news  = $this->do_site->add_news_data($heading,$html_content,$image_url);
		if($add_news)
		{
		
			$success = array(
				'response' => 'ok',
				'redirect'=>site_url('admin/news'),
				'msg'	 => 'News has been added successfully!..'
			);
			  
			$this->response($success, 200); 
		}
		else
		{
			$error = array(
				'response' => 'error',
				'redirect'=>site_url('admin/settings/news_create'),
				'msg'	 => 'Error! Try again..'
			);
			  
			$this->response($error, 200); 
		}
	}
	
	public function admarket_pgm_post()
	{
		$adv_id=$this->input->post('adv_id');
		$category=$this->input->post('category');
		$country=$this->input->post('country');
		$campid=$this->input->post('campid');
		$account_id = $this->user_authentication->account_id;
		
		if($adv_id==''|| $adv_id== NULL){ $adv_id=''; }
		$result = $this->do_site->get_market_camp($adv_id,$category,$country,$campid,$account_id);
		$this->response($result, 200); 
	}
	public function admarket_publisher_turnover_post()
	{//$this->response($this->input->post(), 200); 
		$campid=$this->input->post('campid');
		$from_date=$this->input->post('from_date');
		$to_date=$this->input->post('to_date');
		$one_month=$this->input->post('month');
		$result = $this->do_site->get_market_pub_earning($campid,$from_date,$to_date,$one_month);
		$this->response($result, 200); 
	}
	public function admarket_pgm_country_post()
	{
		$market_id=$this->input->post('market_id');
		$result =false;
		if($market_id){
			$result = $this->do_site->get_market_camp_country($market_id);
			$this->response($result, 200); 
		}
		$this->response($market_id, 200); 
	}
	public function banner_count_post()
	{
		$market_id=$this->input->post('market_id');
		if($market_id==''|| $market_id== NULL){ $market_id=''; }
		$result = $this->do_site->banner_counts($market_id);
		$this->response($result, 200); 
	}
	
	public function fetch_ad_materials_post()
	{
		$adv				=	$this->input->post('market_id');
		$type				=	$this->input->post('market_type');
		
		$formats			=	$this->input->post('formats');
		$web_creative_size	=	$this->input->post('web_creative_size');
		$account_id = $this->user_authentication->account_id;
		//$this->response($this->input->post(), 200); 
		$result = $this->do_site->get_market_creatives($adv,$type,$formats,$web_creative_size,$account_id);
		if($result)		$this->response($result, 200); 
		else $this->response(false, 200); 
	}
	
	function fetch_daily_statistics_get()
	{
		$date = date('Y-m-d');
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		if($date)
		{
		$stat_data = $this->do_site->fetch_daily_statistics($date,$account_id);
		}
		$this->response($stat_data, 200);		
	}
	
	function total_balance_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		$stat_data = $this->do_site->total_balance($account_id);
		$this->response($stat_data, 200);		
	}
	public function admarket_new_list_post()
	{
		$campid=$this->input->post('campid');
		
		$result = $this->do_site->admarket_new_list($campid);
		$this->response($result, 200); 
	}
	public function  site_mass_import_post()
	{
		//print_r($this->post());exit;
		
		$file_id=$this->post('upload_name');	
		$zone_imp=$this->post('zone_imp');	
		//$admarket = $this->post('admarket'); // val is 1 admarket val is 0 normal campaign import
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
					
					$file_name		= $this->getLatestFile($csvfilepath);
						
						$data = $this->csvreader->parse_file($file_name);
						

					
					$counter		= '1';	
					$ext_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$num_rows=count($data);	
						
					if($num_rows>0)
					{
											
						
						if ($zone_imp)
						{							 
							$account_id		=	get_session('account_id');
							foreach($data as $row)
							{
								if($row['affiliateid']!='' && $row['zonetype']!='' )
								{								 
									
									  $add_data		=	array(
												'zoneid' 		=> trim($row['zoneid']),
												'affiliateid'  	=> trim($row['affiliateid']),
												'zonename'  	=> trim($row['zonename']),
												'description'  	=> trim($row['description']),
												'delivery' 		=> trim($row['delivery']),
												'zonetype'   	=> trim($row['zonetype']),
												'category'   	=> trim($row['category']),
												'subdoamin_url'  => trim($row['subdoamin_url']),
												'width '   		=> trim($row['width']),
												'height'   		=> trim($row['height']),
												'pricing'   	=> trim($row['pricing']),
												'dj_passback_tag'	=> trim($row['dj_passback_tag']),
												'dj_floor_price' => trim($row['dj_floor_price']),
												'dj_zone_type'   => trim($row['dj_zone_type']),
												'dj_added_date'  => trim($row['dj_added_date']),
												'dj_is_deleted'  => trim($row['dj_is_deleted']),
												'is_div_link'    => trim($row['is_div_link']),
												'custom_css'   	 => trim($row['custom_css']),
												'bg_color'   	 => trim($row['bg_color']),
												'sponsored_prefix'	=> trim($row['sponsored_prefix']),
												'html_template'  => trim($row['html_template']),
												'css_path'   	 => trim($row['css_path']),
												'is_customurl'   => trim($row['is_customurl']),
												'cname'   		 => trim($row['cname']),
												'custom_filename'=> trim($row['custom_filename']),
												'default_exit_popunder' => trim($row['default_exit_popunder']),
												'highlight_zone' => trim($row['highlight_zone']),
												'dj_is_admarket' => trim($row['dj_is_admarket']),
											);
										if(!empty($add_data))
											{														
												$result[]=	 $this->do_site->add_zone_import($add_data);	
												$insert_rec[] =$counter;
											}
											else
											{
													$exist_rec[]=$ext_counter;
											}
									$counter++;	
									$ext_counter++;						
									
								}
								else
								{
									$error = array('response'	=> 'error',
															// 'msg'		=> 'required fields are empty',
															// 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
															'msg'	 => 'The file contains invalid data for this operation..'
															 ); 
											$this->response($error,200);
								}					
							}
						}
					
						else
						{
							foreach($data as $row)
							{
								$account_id		=	get_session('account_id');
								
								if($row['site_id']!='' && $row['account_id']!='' )
								{								 
									
									 $add_data		=	array(
												'site_id' 		=> trim($row['site_id']),
												'account_id'  	=> trim($row['account_id']),
												'site_name'  	=> trim($row['site_name']),
												'site_url' 		=> trim($row['site_url']),
												'is_default'   	=> trim($row['is_default']),
												'added_date'   	=> trim($row['added_date']),
												'updated_date'  => trim($row['updated_date']),
												'is_deleted'   	=> trim($row['is_deleted']),
												'status'   		=> trim($row['status']),
												'verify'   		=> trim($row['verify']),
											);
										if(!empty($add_data))
											{
														
												$result[]=	 $this->do_site->add_import($add_data);
											
													
													$insert_rec[] =$counter;
													
											}
											else
											{
													$exist_rec[]=$ext_counter;
											}
									$counter++;	
									$ext_counter++;						
									
								}
								else
								{
									$error = array('response'	=> 'error',
															// 'msg'		=> 'required fields are empty',
															// 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
															'msg'	 => 'The file contains invalid data for this operation..'
															 ); 
											$this->response($error,200);
								}					
							}
						}
						
						
						
						
						
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' ,
												  'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
							
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('admin/settings/mass_import'),
									'msg'	 => 'There is no data in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	
		
	}
	function getLatestFile($directoryPath)
    {
        $directoryPath = rtrim($directoryPath, '/');
        
        $max = array(
            'path' => null,
            'timestamp' => 0
        );
        
        foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file) {
            $path = $directoryPath . '/' . $file;
            if (!is_file($path)) {
                continue;
            }
            $timestamp = filemtime($path);
            if ($timestamp > $max['timestamp']) {
                $max['path']      = $path;
                $max['timestamp'] = $timestamp;
            }
        }
        
        return $max['path'];
    }
}
