<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Analytics (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Rtb extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_web_adblock');
		$this->load->model('do_email_check');
		$this->load->model('do_app_config');
		$this->load->model('do_rtb');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
	/* 
	* name: fetch_post
	* @param : null
	* @return : return all data from rtb
    */
	public function fetch_get()
	{
	   $agency_id=$this->user_authentication->agency_id;
	   $rtb_list=$this->do_rtb->fetch_rtb_list($agency_id);
	   
	   if($rtb_list)
	     {
		   $this->response( $rtb_list, 200);
		 } 
	}
	
	/* 
	* name: fetch_post
	* @param : null
	* @return : return all data from rtb
    */
	public function add_post()
	{
	
		if(trim($this->post('type'))=='SSP')
		{
			$this->form_validation->set_rules('adx_name_ssp','lang:ad_exchange_name', 'required|trim');
	   
			$this->form_validation->set_rules('ping_url_ssp', 'lang:ping_url', 'required|trim|callback_ping_url');
		}
		else
		{
			$this->form_validation->set_rules('ping_url_dsp', 'lang:ping_url', 'required|trim|callback_ping_url');
		}
		
		$rtb_check=(clean_data($this->post('is_strict_rtb'))!='on')?'0':'1';
		/*if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{*/	
			//print_r($this->post());exit;
			if(trim($this->post('type'))=='SSP')
			{
				$add_data=array( 
							'exchange_name'=>clean_data($this->post('adx_name_ssp')),
							'added_on'=>date('Y-m-d H:i:s'),
							'is_stirct_open_rtb_standard'=>$rtb_check,
							'status'=>1,
							'ping_url'=>clean_data($this->post('ping_url_ssp')),
							'username'=>clean_data($this->post('user_name')),
							'password'=>clean_data($this->post('user_pass')),
							'seller_id'=>clean_data($this->post('sell_id')),
							'authentiction_key'=>clean_data($this->post('auth_key')),
							'auction_currency'=>clean_data($this->post('auction_currency')),
							'auction_type'=>clean_data($this->post('bid_type')),
							'type'=>clean_data($this->post('type')),
							'agency_id'=>$this->user_authentication->agency_id
						  );
			}
			else
			{
				 $add_data=array( 
							'exchange_name'=>clean_data($this->post('adx_name_dsp')),
							'added_on'=>date('Y-m-d H:i:s'),
							'is_stirct_open_rtb_standard'=>$rtb_check,
							'status'=>1,
							'ping_url'=>clean_data($this->post('ping_url_dsp')),
							'username'=>clean_data($this->post('user_name')),
							'password'=>clean_data($this->post('user_pass')),
							'seller_id'=>clean_data($this->post('sell_id')),
							'authentiction_key'=>clean_data($this->post('auth_key')),
							'auction_currency'=>clean_data($this->post('auction_currency')),
							'auction_type'=>clean_data($this->post('bid_type')),
							'type'=>clean_data($this->post('type')),
							'agency_id'=>$this->user_authentication->agency_id
						  );
			}	  
			$add_res=$this->do_rtb->add_rtb_details($add_data);
			
					
					/* Activity Log for rtb Add- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,RTB_ADD);
					if($enable=='1')
					{							
					$this->activity_log(RTB,ADD,$add_res);
					}
					/* Activity Log for rtb Add- End*/	
		  
			if($add_res)
			{		
				if(trim($this->post('type'))=='DSP')
				{
					$ping_url=clean_data($this->post('ping_url_dsp'));
					$tmp = strstr($ping_url, '=');
					$account_name = strtok(substr($tmp, 1),'.');
					$cur_date=date('d-m-Y H:i:s');
					$obj['exc_id']=$add_res;
					$obj['first_name']=$account_name;
					$obj['cur_date']=$cur_date;
					$obj['email']= preg_replace('/\s+/', '', $account_name.time()) . '@' . $this->config->item('prod_name').'.com';
					$obj['account_type']="TRAFFICKER";
					$obj['agency_id']=$this->user_authentication->agency_id;
					$obj['password']="123456";
					$obj['site_url']="www.".$account_name.rand().".com";
					$rtb_pub=$this->do_rtb->add_publisher($obj);
				}
				$success = array( 'response' => 'ok',
						'msg'	 =>$this->lang->line('add_rtb_success')//'RTB sucessfully added',
								);
				$this->response( $success, 200);
			}
			else
			{
			   $success = array(
					'response' => 'error',
					'msg'	 => $this->lang->line('error_try_again'),
				);
						$this->response( $success, 200);
			 } 
		//}
	}
	
	public function get_rtb_edit_get()
	{ 
         $exchange_id=$this->get('exchange_id');
		
		 $api_key=$this->do_rtb->get_rtb_details($exchange_id);
		 
	     $this->response($api_key, 200);
	}
		public function edit_post()
	{
	   if(trim($this->post('type'))=='SSP')
		{
			$this->form_validation->set_rules('adx_name','lang:ad_exchange_name', 'required|trim');
	   
			$this->form_validation->set_rules('ping_url', 'lang:ping_url', 'required|trim|callback_ping_url_check');
		}
		else
		{
			$this->form_validation->set_rules('ping_url', 'lang:ping_url', 'required|trim|callback_ping_url_check');
		}
	   
	   $rtb_check=(clean_data($this->post('is_strict_rtb'))!='on')?'0':'1';
		if(trim($this->post('rtb_type'))=='SSP')
	   {
	   $add_data=array( 
						'exchange_id'=>clean_data($this->post('exchange_id')),
	                    'exchange_name'=>clean_data($this->post('adx_name_ssp')),
						'is_stirct_open_rtb_standard'=>$rtb_check,
						'ping_url'=>clean_data($this->post('ping_url_ssp')),
						'username'=>clean_data($this->post('user_name')),
						'password'=>clean_data($this->post('user_pass')),
						'seller_id'=>clean_data($this->post('sell_id')),
						'authentiction_key'=>clean_data($this->post('auth_key')),
						'auction_currency'=>clean_data($this->post('auction_currency')),
						'auction_type'=>clean_data($this->post('bid_type')),
						'type'=>clean_data($this->post('rtb_type'))
					  );
	  }
	  else
	  {
		  $add_data=array( 
						'exchange_id'=>clean_data($this->post('exchange_id')),
	                    'exchange_name'=>clean_data($this->post('adx_name_dsp')),
						'is_stirct_open_rtb_standard'=>$rtb_check,
						'ping_url'=>clean_data($this->post('ping_url_dsp')),
						'username'=>clean_data($this->post('user_name')),
						'password'=>clean_data($this->post('user_pass')),
						'seller_id'=>clean_data($this->post('sell_id')),
						'authentiction_key'=>clean_data($this->post('auth_key')),
						'auction_currency'=>clean_data($this->post('auction_currency')),
						'auction_type'=>clean_data($this->post('bid_type')),
						'type'=>clean_data($this->post('rtb_type'))
					  );
	  }

	   $add_res=$this->do_rtb->edit_rtb_details($add_data);
	   
					/* Activity Log for rtb Edit- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,RTB_EDIT);
					if($enable=='1')
					{							
					$this->activity_log(RTB,EDIT);
					}
					/* Activity Log for rtb Edit- End*/	
		     
	   
	   if($add_res)
	     {
		   $success = array(
				'response' => 'ok',
				'msg'	 => $this->lang->line('edit_rtb_success'),
									);
					$this->response( $success, 200);
		 }
		 else
		 {
		   $success = array(
				'response' => 'error',
				'msg'	 => $this->lang->line('error_try_again'),
									);
					$this->response( $success, 200);
		 } 
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the RTB information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_rtb_get()
	{	
		$exchange_id = $this->get('id');	
		 
		if($exchange_id)
		{
			$rtb_id	=	explode(',',$exchange_id);
			
			if(is_array($rtb_id))
			{
				foreach($rtb_id as $exchange_id)
				{
					$rtb 	= 	$this->do_rtb->block($exchange_id);
					
					/* Activity Log for rtb Block- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,RTB_BLOCK);
					if($enable=='1')
					{							
					$this->activity_log(RTB,BLOCK);
					}
					/* Activity Log for rtb Block- End*/	
					
				}
			}
			else
			{
				$rtb 	= 	$this->do_rtb->block($exchange_id);
				   /* Activity Log for rtb Block- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,RTB_BLOCK);
					if($enable=='1')
					{							
					$this->activity_log(RTB,BLOCK);
					}
					/* Activity Log for rtb Block- End*/	
					
				
			}
			
			$msg=array( 'response' => 'ok',
			
						 'msg'	 => 'RTB Blocked successfully !',//'RTB Blocked successfully !',
			
			           );
		    $this->response($msg,200);			
		}
	}
	
	/**
       * 
       * name : unblock_rtb_get()
       * 
       * Unblock the RTB information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_rtb_get()
	{	
		$exchange_id = $this->get('id');	
		if($exchange_id)
		{
			$rtb_id	=	explode(',',$exchange_id);
			
			if(is_array($rtb_id))
			{
				foreach($rtb_id as $exchange_id)
				{
					$rtb 	= 	$this->do_rtb->unblock($exchange_id);
					
					/* Activity Log for rtb unBlock- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,RTB_UNBLOCK);
					if($enable=='1')
					{							
					$this->activity_log(RTB,UNBLOCK);
					}
					/* Activity Log for rtb unBlock- End*/	
					
				}
			}
			else
			{
				$rtb 	= 	$this->do_rtb->unblock($exchange_id);
				
				/* Activity Log for rtb unBlock- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,RTB_UNBLOCK);
					if($enable=='1')
					{							
					$this->activity_log(RTB,UNBLOCK);
					}
					/* Activity Log for rtb unBlock- End*/	
					
			}
			
			$msg=array( 'response' => 'ok',
			
						 'msg'	 => 'RTB Un-blocked successfully  !',//'RTB Blocked successfully !',
			
			           );
		    $this->response($msg,200);			
		}
		 
	}

	/*ping_url_check Check
	 * 
	 * 
	 * */ 
	
	function ping_url()
	{
		
		if(clean_data($this->post('ping_url_ssp'))!='')
		{
			$sspdsp_url		=	strtolower(clean_data($this->post('ping_url_ssp')));
		}
		if(clean_data($this->post('ping_url_dsp'))!='')
		{
			$sspdsp_url		=	strtolower(clean_data($this->post('ping_url_dsp')));
		}
		
		$count 		= 	$this->do_email_check->ping_url_check($sspdsp_url);
		
		if($count>0)
		{
			$this->form_validation->set_message('ping_url', $this->lang->line('unique_ping_url'));
			return FALSE;
		}
		else
		{

			return TRUE;
		}
	}
	
	function activity_log($module,$process)
	{
				/* Activity Log for EDIT setting information - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>'',
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
					
				 $this->redis_library->logcount($account_id,$activity_log);  
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for edit settings information - End*/			
		
	}
		
}
