<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Analytics (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Roles extends REST_Controller
{
	function __construct(){
		
		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->model('do_roles');
		$this->load->model('do_networks');
		$this->load->model('do_app_config');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
	/* 
	* name: add_roles_post
	* @param : null
	* @return : insert added roles into djax_rols and djax_role_assoc
    */
	public function add_role_post()
	{		
		if(clean_data($this->post('man_per'))!='')
		{				
			//IF INSERT 
				
			if(clean_data($this->post('process'))!='UPDATE')
			{
				$role_list=$this->do_roles->add_role(clean_data($this->post()));
			}
			else
			{
				//IF UPDATE
				$role_list=$this->do_roles->update_role(clean_data($this->post()));
			}
			
			   /* Activity Log for user role - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,USER_ROLE);
				if($enable=='1')
				{							
				$this->activity_log(USER_ROLE,EDIT);
				}
				/* Activity Log for user role- End*/		
			
			
			if($role_list && clean_data($this->post('process'))!='UPDATE')
			{
				$success = array( 'response' => 'ok',
								 'msg'	 => 'Roles and permissions added successfully!..'
							   );	 			 
				$this->response( $success, 200);
			}
			else 
			{
				$success = array( 'response' => 'ok',
								'msg'	 => 'Roles and permissions updated successfully!..'
							  );
				$this->response( $success, 200);
			}
		}
		else
		{
			$success = array( 'response' => 'error',
								 'msg'	 => 'Select any one of the permissions'
							   );	 			 
			$this->response( $success, 200);
		}
	}
	
	/* 
	* name: edit_role_post
	* @param : null
	* @return : update added role permission into djax_rols and djax_role_assoc
    */
	public function fetch_role_get()
	{
        $role_id = $this->get('id');
		$role_list=$this->do_roles->fetch_role($role_id);
		$this->response($role_list,200); 
	}
	
	public function fetch_role_permission_get()
	{
	    $role_id = $this->get('id');
		$role_list=$this->do_roles->fetch_role_permission($role_id);
		$this->response($role_list,200); 
	}
	
	/* 
	* name: fetch_user_role_list_get
	* @param : null
	* @return : fetch all user_role list from djax_roles
   */
	public function fetch_user_role_list_get()
	{
		$user_role_list=$this->do_roles->fetch_user_role_list();
		if($user_role_list){
			$this->response($user_role_list,200); 
			}
	}
	
	/* 
	* name: block_role_get
	* @param : null
	* @func : block particular roles
   */
	public function block_role_get()
	{  
	    $role_id=$this->get('id');
	    $block_role=$this->do_roles->block_role($role_id);
		if($block_role)
		{
			// SEND EMAIL TO MANAGERS
			$result=$this->do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			
			// GET USERS DETAILS FOR MAIL
			$get_managers = $this->do_networks->get_managers_by_role_id($role_id);
			if(!empty($get_managers)){
			foreach($get_managers as $row)
			{
				$user_email    = $row['email'];
				$user_name     = $row['name'];
				
				// GET MANAGER DETAILS FOR BCC
				$manager_email = $this->do_networks->manager_email_for_BCC($row['u_id']);
				$bcc = $manager_email;
				$type     	   = "MANAGER_ROLE_BLOCK";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> "ACCOUNT BLOCKED",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
			   }
			}
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Selected role is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/* 
	* name: block_role_get
	* @param : null
	* @func : block particular roles
   */
	public function unblock_role_get()
	{  
	    $role_id=$this->get('id');
	    $block_role=$this->do_roles->unblock_role($role_id);
		if($block_role)
		{
			// SEND EMAIL TO MANAGERS
			$result=$this->do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			
			// GET USERS DETAILS FOR MAIL
			$get_managers = $this->do_networks->get_managers_by_role_id($role_id);
			if(!empty($get_managers)){
			foreach($get_managers as $row)
			{
				$user_email    = $row['email'];
				$user_name     = $row['name'];
				
				// GET MANAGER DETAILS FOR BCC
				$manager_email = $this->do_networks->manager_email_for_BCC($row['u_id']);
				$bcc = $manager_email;
				$type     	   = "MANAGER_ROLE_UN_BLOCK";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> "ACCOUNT UN-BLOCKED",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
			  }
			}
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Selected role is unblocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	function activity_log($module,$process)
	{
				/* Activity Log for EDIT setting information - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>'',
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
																									
				//$this->do_app_config->activity_log($account_id,$activity_log);
				 $this->redis_library->logcount($account_id,$activity_log);  
				/* Activity Log for edit settings information - End*/			
		
	}
	
	
	
}
