<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Utilities (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	GETTING REPORTS/ STATISTICS
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com 
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Report extends REST_Controller 
{
	
	function __construct(){
		parent::__construct();
		/*Libraries */
		$this->load->library("PHPExcel");
		$this->load->library("PHPExcel/IOFactory");
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_report');
		$this->load->model('do_notification');
		$this->load->model('do_networks');
		$this->load->config('report_configurations');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
	   
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
         
		if(isset($user_auth->error['response']))
	    {	
	   		$this->response($user_auth->error,200);
	    }	
	}
	
	
	function mail_attachment($filename, $path, $mailto, $from_mail, $from_name, $replyto, $subject, $message) {
    $file = $path.$filename;
    //$file = $path;
    $file_size = filesize($file);
    $handle = fopen($file, "r");
    $content = fread($handle, $file_size);
    fclose($handle);
    $content = chunk_split(base64_encode($content));
    $uid = md5(uniqid(time()));
    $header = "From: ".$from_name." <".$from_mail.">\r\n";
    $header .= "Reply-To: ".$replyto."\r\n";
    $header .= "MIME-Version: 1.0\r\n";
    $header .= "Content-Type: multipart/mixed; boundary=\"".$uid."\"\r\n\r\n";
    $header .= "This is a multi-part message in MIME format.\r\n";
    $header .= "--".$uid."\r\n";
    $header .= "Content-type:text/plain; charset=iso-8859-1\r\n";
    $header .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
    $header .= $message."\r\n\r\n";
    $header .= "--".$uid."\r\n";
    $header .= "Content-Type: application/octet-stream; name=\"".$filename."\"\r\n"; // use different content types here
    $header .= "Content-Transfer-Encoding: base64\r\n";
    $header .= "Content-Disposition: attachment; filename=\"".$filename."\"\r\n\r\n";
    $header .= $content."\r\n\r\n";
    $header .= "--".$uid."--";
    if (mail($mailto, $subject, "", $header)) {
        echo "mail send ... OK"; // or use booleans here
    } else {
        echo "mail send ... ERROR!";
    }
}	
	
	function convert_chart_data($res,$settings){
						
		//print_r($res);
		
		//print_r($res['fields']);
		// Declaration
											
		$chart_data 	= array();
		$chart_x_axis 	= array();
		$i 				= 0;
		$col_settings 	= '';
		$total_values	= array();
		
		if(!empty($res['fields']))
		{
			
			foreach($res['fields'] as $column){
											
				if(array_key_exists($column,$settings['FIELDS'])){
					$col_settings = $settings['FIELDS'][$column];
					if(is_array($col_settings) AND count($col_settings) > 0){
						if(isset($col_settings['name']) AND $col_settings['name'] != ''){
							$chart_data[$i]['name'] = $col_settings['name'];
							$total_values[$i]['name'] = $col_settings['name'];
							$total_values[$i]['key']  = $column;
						}
						
						if(isset($col_settings['data_type']) AND $col_settings['data_type'] != ''){
							$array_column				= array_map($col_settings['data_type'],array_column($res['records'],$column)); 
							$chart_data[$i]['data'] 	= $array_column	; 
							$total_values[$i]['value'] 	= array_sum($array_column);
						}
						else
						{
							$array_column				= array_column($res['records'],$column); 
							$chart_data[$i]['data'] 	= $array_column; 
							$total_values[$i]['value'] 	= array_sum($array_column);
						}
						
						if(isset($col_settings['chart_type']) AND $col_settings['chart_type'] != ''){
							$chart_data[$i]['type'] = $col_settings['chart_type'];
						}
						
						if(isset($col_settings['chart_marker']) AND $col_settings['chart_marker'] != ''){
							$chart_data[$i]['marker'] = $col_settings['chart_marker'];
						}
						$i++;		
					}
				}
				
				if(isset($settings['X_AXIS_FIELD']) AND $settings['X_AXIS_FIELD'] !=='' AND $settings['X_AXIS_FIELD'] === $column){
					$chart_x_axis = array_column($res['records'],$column);
				}
					
			}
		
		}
		
		if(empty($chart_x_axis))
		{
			//$chart_x_axis = array_column($res['records'],clean_data($this->post('interval')));
			$chart_x_axis = array_column($res['records'],'date_time');
		}
		
		$success 	= 	array(
							'response' 		=> 	'ok',
							'chart_data'	=> 	$chart_data,
							'chart_x_axis'  =>  $chart_x_axis,
							'total'			=> 	$total_values,
							'placememt'		=>	count($res['records'])
						);
		
		return 	$success;			
	
	}
	
	
	function fetch_post(){
		
		$key = $this->input->get_post('api_key');
		$camp_id = $this->post('camp_id');
		$campaign_id = $this->post('camp_id_alter');//automatic filter of banner
	
	     if($camp_id=='Campaign' || $camp_id=null || $camp_id=='')
		{
		$search['campaign_id'] ='';
		}
		else
		{
		$search['campaign_id'] =$camp_id;
		} 
		$page 			= $this->post('page');
			
		$display 		= $this->post('display_type');
		$report_type	= $this->post('report_type');
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$group_by 		= $this->post('group_by');
		$adv_types 		= $this->post('adv_types');

		$agency_id 		= FALSE;
		
		switch(strtoupper($account_type)){
			case 'ADMIN';
				$agency_id	= $this->do_notification->getAdminAgencyId($account_id);
				break;
			case 'MANAGER';
				$agency_id	= $this->do_notification->getManagerAgencyId($account_id);
				break;
			case 'ADVERTISER';
				$agency_id	= $this->do_notification->getAdvertiserAgencyId($account_id);
				break;
		}
		
		if($account_type ==='MANAGER')
		{
			$account_type 	= 'ADMIN';
		}
		else
		{
			$account_type 	= $account_type;
		}
		$manager_role_id 	= $this->user_authentication->manager_role_id;
		
		$stat_type 		= ($this->post('stat_type') !== '')?$this->post('stat_type'):'';
				
		// GET DATA BASED ON PREDEFINED CONFIG VALUES
		
		//GET the datatable object or request
		$datatable_obj = $this->post('datatable_obj');
		
		$search['page'] 		= $page; 
		$search['account_id'] 	= $account_id; 
		$search['account_type'] = $account_type;
		$search['report_type'] = $report_type;
		$search['search_term']  = $datatable_obj['sSearch'];
		$columns = array();
		$group = array();
		$order = array();
		$limit = array();
		
		$rep_config = $this->config->item('report_config');
		
		if(isset($rep_config[strtoupper($account_type)][strtoupper($page)])){
					
			$settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
				
			if(is_array($settings) AND count($settings) > 0){
			
				foreach($settings['FIELDS'] as $key => $value){
					
					
					if(isset($rep_config['MANAGER_PERMISSION'][strtoupper($key)]) && strtoupper($account_type) =='ADMIN')
					{
					    
					
						if(check_permission_layout($rep_config['MANAGER_PERMISSION'][strtoupper($key)],$manager_role_id))
						{
							
							array_push($columns,$key);
						}
					}else{
						
						array_push($columns,$key);
					}
				} 				
				
				$group = $settings['GROUP'];
						//$this->response($this->post('adv_type'),200);
				if($page=='REPORT_DASHBOARD'):
					if($this->post('adv_type')!='' && $this->post('adv_type')=='zone'):
						$group	=	array('ZONE_ID');
						
					elseif($this->post('adv_type')!='' && $this->post('adv_type')=='traffic'):
						$group	=	array('AFF_ID');
						elseif($this->post('adv_type')!='' && $this->post('adv_type')=='top_coutry'):
						if($group_by=="COUNTRY")
						{
						
						$group	=array('COUNTRY');
					array_push($columns,"CAM_ID");
					}
					    //~ }else{
							//~ $group	=array('CAM_ID');
							//~ }
					
					endif;
				endif;
                
				$columns = array_unique(array_merge($group,$columns));
		
				//returns the sorting data or false
				
				// GET SEARCH FIELDS 
				if(isset($settings['SEARCH_FIELDS'])){
					$search['search_fields']  = $settings['SEARCH_FIELDS'];
					
				}
				else
				{
					$search['search_fields']  = FALSE;
				}
				
				if( $this->convert_sorting_data($datatable_obj))
				{
					$order = $this->convert_sorting_data($datatable_obj);
				}else{
					$order = $settings['ORDER'];
					
				}
				
				if($this->post('start') != ''){
					$limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
				}
				else
				{
					$limit = $settings['LIMIT'];
				}
				//$this->response($settings['DEFAULT_INTERVAL'],200);
				if($settings['DEFAULT_INTERVAL'] != ''){
					$date = get_search_date($settings['DEFAULT_INTERVAL']);
					
					$search['date_from'] = $date['from_date'].' 00:00:00';
					$search['date_to'] = $date['to_date'].' 23:00:00';
				}	
				
				
				
		
				// ADD SEARCH FIELDS
			
				if($this->post('environment') != '' AND $this->post('environment') != 'all' AND $this->post('environment') != '0'){
					$search['environment'] = $this->post('environment'); 
				}
				
				if($this->post('campaign_id') != '' AND $this->post('campaign_id') != 'all'){
					$search['campaign_id'] = $this->post('campaign_id'); 
				}
				
				if($this->post('bid_price') != '' AND $this->post('bid_price') != ''){
					$search['bid_price'] = $this->post('bid_price'); 
				}
				
				if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
					$search['country_id'] = $this->post('country_id'); 
				}
				
				if($this->post('creative_id') != '' AND $this->post('creative_id') != 'all'){
					$search['creative_id'] = $this->post('creative_id'); 
				}
				
				if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
					$search['site_id'] = $this->post('site_id'); 
				}
				if($this->post('app_id')!='' AND $this->post('app_id')!='all'){
					$search['app_id'] = $this->post('app_id'); 
				}				
				if($this->post('adv_account_id') != '' AND $this->post('adv_account_id') != 'all'){
					$search['adv_account_id'] = $this->post('adv_account_id'); 
				}
				
				if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
					$search['pub_account_id'] = $this->post('pub_account_id'); 
				}
				
				if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
					$search['adblock_id'] = $this->post('adblock_id'); 
				}
				
				if($this->post('country') != '' AND $this->post('country') != 'all'){
					$search['country'] 		= 	$this->post('country'); 
				}
				
				if($this->post('camtyp') != '' AND $this->post('camtyp') != 'all'){
					$search['revenue_type'] = 	$this->post('camtyp'); 
				}
				
				if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
					$search['adsize'] 		= 	$this->post('adsize'); 
				}
				
				if($this->post('browser') != '' AND $this->post('browser') != 'all'){
					$search['browser'] 		= 	$this->post('browser'); 
				}
				
				if($this->post('os') != '' AND $this->post('os') != 'all'){
					$search['os'] 		= 	$this->post('os'); 
				}
				
				if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
					$tz	=	explode(')',$this->post('timezone'));
					$tz1	=	str_replace('(GMT','',$tz[0]);
					$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
				}
				
				if($agency_id != FALSE){
					$search['agency_id'] = $agency_id; 				
				}
				
				if($this->post('date_from') != ''){
						
					if($this->post('timezone') != '' AND $this->post('timezone') != 'utc')
					{
						$fz	=	explode(')',$this->post('timezone'));
						$fd	=	new DateTime($this->post('date_from').' 00:00:00',new DateTimeZone(trim($fz[1])));
						$fd->setTimezone(new DateTimeZone('UTC'));
						$search['date_from'] = $fd->format('Y-m-d H:i:s'); 
					}
					else
					{
						$search['date_from'] = $this->post('date_from').' 00:00:00'; 
					}
				}
				
				if($this->post('date_to') != ''){
					if($this->post('timezone') != '' AND $this->post('timezone') != 'utc')
					{
						$toz=	explode(')',$this->post('timezone'));
						$td	=	new DateTime($this->post('date_to').' 23:00:00',new DateTimeZone(trim($toz[1])));
						$td->setTimezone(new DateTimeZone('UTC'));
						$search['date_to'] = $td->format('Y-m-d H:i:s'); 	
					}
					else
					{
						$search['date_to'] = $this->post('date_to').' 23:00:00'; 
					}
				}
							
				
							
				$dataTable = FALSE;
			
				if($display === 'TABLE'){
				
					$dataTable = TRUE;
				
				}							
				
				$dates_from = $search['date_from'];
				$old_from_date = date("Y/m/d", strtotime("-29 days")). " 00:00:00";		
				switch($stat_type){
					
					case 'COUNTRY';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							//$this->response->($columns,200);
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
								
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;

					
						$res = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
						if(empty($res))
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
							$res = $this->do_report->fetch_country($columns,$search,$group,$order,$limit,$dataTable);
							$search['date_from'] = $old_from_date;
							if(empty($res))
							{
								$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";
								$res = $this->do_report->fetch_country($columns,$search,$group,$order,$limit,$dataTable);
								$search['date_from'] = $old_from_date;
							}							
						}
						break;
					case 'NETWORK';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
								
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;
						if(empty($this->post('dimensions')))
						{
							$group[]	=	'ADSIZE';
						}
						else
						{
							$group	=	$this->post('dimensions');
						}
						$res = $this->do_report->fetch_country($columns,$search,$group,$order,$limit,$dataTable);
						/*if(empty($res))
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
							$res = $this->do_report->fetch_country($columns,$search,$group,$order,$limit,$dataTable);
							
						}*/
						break;
					case 'VIDEO';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'vid.date';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'vid.date';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;
						
						$res = $this->do_report->fetch_video($columns,$search,$group,$order,$limit,$dataTable);
						/*if(empty($res))
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
							$res = $this->do_report->fetch_video($columns,$search,$group,$order,$limit,$dataTable);
							
						}*/
						break;
					
					case 'EXPORT';
							$columns	=	$this->post('columns');
							$group		=	$this->post('dimensions');
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order	=	(is_array($group))?implode(',',$group):'';							
							}
							$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable,$page);	
							/*if(empty($res))
							{
								$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
								$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable,$page);	
								
							}*/													
							
							break;
					case 'ENVIRONMENT';
					case 'PLATFORM';
							if(!empty($this->post('columns')))
							{
							$columns	=	$this->post('columns');
							}
						/*	if(!empty($this->post('dimensions')))
							{
							$group		=	$this->post('dimensions');
							}*/
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						
						$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable,$page);
						/*if(empty($res))
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
							$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable,$page);
						}	*/												
						
						break;		
					
					case 'URL';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							//$this->response->($columns,200);
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;
						
						$res = $this->do_report->fetch_url($columns,$search,$group,$order,$limit,$dataTable);
						/*if(empty($res))
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
							$res = $this->do_report->fetch_url($columns,$search,$group,$order,$limit,$dataTable);
							
						}*/						
						break;	
					case 'DASHBOARD';

						$order	=	$settings['ORDER'];	
						$res 	= 	$this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable);
						/*if(empty($res))
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
							$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable);
						}	*/					
						break;
					default:				
						$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable,FALSE,$campaign_id);	
						//~ print_r($res);exit;	
						/*if(empty($res) && $old_from_date == $search['date_from'])
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
							$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable);
							$search['date_from'] = $old_from_date;
							
						}
												if(empty($res) && $old_from_date == $search['date_from'])
						{
							$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
							$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable);
							$search['date_from'] = $dates_from;
						}*/
						break;
						
				}
								
						// DB Data 
						if($display === 'TABLE'){
								
							if($stat_type==='EXPORT')
							{
								$result_data = $res;//$res['data'];								
								$this->response($result_data,200);
							}
							else
							{				
								// GET CHART SETTINGS AND DATA
								
								$chart_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('chart')];
								
								if($this->post('start') != ''){
									if($this->post('end') <=$chart_settings['LIMIT']['end'])
									{
										$chart_limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
									}else{
										$chart_limit = $chart_settings['LIMIT'];	
									}
								}
								else
								{
									$chart_limit = $chart_settings['LIMIT'];
								}
							
								switch($stat_type){
									
										case 'COUNTRY';
											$ch_settings 	= 	$rep_config[strtoupper($account_type)][strtoupper($page)]['CHART'];
											$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
											if(empty($chart_data_res) && $old_from_date == $search['date_from'])
											{
												$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
												$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
												$search['date_from'] = $old_from_date;
												if(empty($chart_data_res) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
													$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
													$search['date_from'] = $old_from_date;
												}												
											}											
											break;
										case 'NETWORK';
											$ch_settings 	= 	$rep_config[strtoupper($account_type)][strtoupper($page)]['CHART'];
											$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
											if(empty($chart_data_res) && $old_from_date == $search['date_from'])
											{
												$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
												$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
												$search['date_from'] = $old_from_date;
												if(empty($chart_data_res) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
													$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
													$search['date_from'] = $old_from_date;
												}												
											}											
											break;
										case 'VIDEO';
											$chart_data_res = $this->do_report->fetch_video($columns,$search,$group,$order,$chart_limit);
											if(empty($chart_data_res) && $old_from_date == $search['date_from'])
											{
												$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
												$chart_data_res = $this->do_report->fetch_video($columns,$search,$group,$order,$chart_limit);
												$search['date_from'] = $old_from_date;
												if(empty($chart_data_res) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
													$chart_data_res = $this->do_report->fetch_video($columns,$search,$group,$order,$chart_limit);
													$search['date_from'] = $old_from_date;
												}												
											}											
											break;
										case 'URL';
											$chart_data_res = $this->do_report->fetch_url($columns,$search,$group,$order,$chart_limit);
											if(empty($chart_data_res) && $old_from_date == $search['date_from'])
											{
												$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
												$chart_data_res = $this->do_report->fetch_url($columns,$search,$group,$order,$chart_limit);
												$search['date_from'] = $old_from_date;
												if(empty($chart_data_res) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
													$chart_data_res = $this->do_report->fetch_url($columns,$search,$group,$order,$chart_limit);
													$search['date_from'] = $old_from_date;
												}												
											}											
											break;
										case 'ENVIRONMENT';
											$ch_settings 	= 	$rep_config[strtoupper($account_type)][strtoupper($page)]['CHART'];
											$chart_data_res = $this->do_report->fetch($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
											if(empty($chart_data_res) && $old_from_date == $search['date_from'])
											{
												$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
												$chart_data_res = $this->do_report->fetch($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
												$search['date_from'] = $old_from_date;
												if(empty($chart_data_res) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
													$chart_data_res = $this->do_report->fetch($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
													$search['date_from'] = $old_from_date;
												}												
											}											
											break;		
										default:	
											
											//~ $chart_data_res = $this->do_report->fetch($columns,$search,$group,$order,$chart_limit);
											$chart_data_res = $this->do_report->fetch($columns,$search,$group,$order,$chart_limit,FALSE,FALSE,$campaign_id);
											
											if(empty($chart_data_res) && $old_from_date == $search['date_from'])
											{
												$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
												$chart_data_res = $this->do_report->fetch($columns,$search,$group,$order,$chart_limit);
												$search['date_from'] = $old_from_date;
												if(empty($chart_data_res) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
													$chart_data_res = $this->do_report->fetch($columns,$search,$group,$order,$chart_limit);
													$search['date_from'] = $old_from_date;
												}												
											}										
											break;
								}
								
								$chart_data = $this->convert_chart_data($chart_data_res,$chart_settings);
								//$this->response($this->db->last_query(),200);
								//$this->response($chart_data,200);
								//Load Map Settings...if Map is found
								if(isset($rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('map')]))
								{
									$map_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('map')];
									
									if($this->post('start') != ''){
										$map_limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
									}
									else
									{
										$map_limit = $map_settings['LIMIT'];
									}
									$map_columns = array();
									foreach($map_settings['FIELDS'] as $key => $value){
										array_push($map_columns,$key);
									}
					
									$map_group = $map_settings['GROUP'];
								
									$map_columns = array_unique(array_merge($map_group,$map_columns));
									
									/*if( $this->convert_sorting_data($datatable_obj))
									{
										$map_order = $this->convert_sorting_data($datatable_obj);
									}else{*/
										$map_order = $map_settings['ORDER'];
									//}
									
									switch($stat_type){
											case 'COUNTRY';
												$map_columns[]		=	'COUNTRY_CODE';
												$map_data_res = $this->do_report->fetch_country($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
											case 'NETWORK';
												$map_columns[]		=	'COUNTRY_CODE';
												$map_data_res = $this->do_report->fetch_country($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
											case 'VIDEO';
												$map_data_res = $this->do_report->fetch_video($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
											case 'URL';
												$map_data_res = $this->do_report->fetch_url($map_columns,$search,$map_group,$map_order,$map_limit);
												break;	
											default:
												$map_data_res = $this->do_report->fetch($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
									}
									
									$map_data = $this->convert_map_data($map_data_res,$map_settings);
								}
								
								
								switch($account_type){
									case 'ADMIN':
										switch($page){
											case 'REPORT_CREATIVE':
											case 'REPORT_CAMPAIGN':
											case 'REPORT_ADVERTISER':
											case 'REPORT_PUBLISHER':
											case 'REPORT_SITE':
											case 'REPORT_SITE_DETAILS':
											case 'REPORT_SITE_DETAILS_SITEURL':
											case 'REPORT_SITE_DETAILS_IMP':
											case 'REPORT_APP':
											case 'REPORT_ADBLOCK':
											case 'REPORT_ADBLOCK_DETAILS':
											case 'REPORT_ADBLOCK_DETAILS_IMP':
											case 'PLATFORM_REPORT':
											case 'REPORT_ENVIRONMENT':
											 
												$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												if(empty($total) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
													$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);											
													if(empty($total) )
													{
														$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
														$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);											
														
													}													
												}												
												$no_records = ($total !== FALSE)?count($total):0;
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $total;
													$result_data['overview_chart_data'] = $chart_data;
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));													
																										
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';	
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));															
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);	
												break;
											case 'REPORT_GEO_GRAPHICAL':
												
												$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												if(empty($total) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
													$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													if(empty($total))
													{
														$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";
														$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
														
													}													
												}												
												$total1 = $this->do_report->get_impression_count($search);
												$result = array_merge($total, $total1);

												$no_records = ($total !== FALSE)?count($total):0;
											
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $total;
													
													$result_data['overview_chart_data'] = $chart_data;
													$result_data['overall_map_data'] = $map_data;
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));													
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													$result_data['overall_map_data'] = $map_data;	
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));															
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);		
												break;
											default:
												$this->response($res,200);
												break;	
										}
									break;
									
									case 'ADVERTISER':
								
										switch($page){	
											case 'REPORT_OVERVIEW':
										    case 'REPORT_CAMPAIGN':
											case 'REPORT_CREATIVE':
											case 'REPORT_DASHBOARD':
											case 'REPORT_URL':
											case 'REPORT_VIDEO':
												switch($stat_type){
												case 'VIDEO';
												
													$total = $this->do_report->fetch_video($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													
													if(empty($total) && $old_from_date == $search['date_from'])
													{
														$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
														$total = $this->do_report->fetch_video($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
														if(empty($total))
														{
															$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
															$total = $this->do_report->fetch_video($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
															
														}														
													}													
													break;
												case 'URL';
													$total = $this->do_report->fetch_url($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													if(empty($total) && $old_from_date == $search['date_from'])
													{
														$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
														$total = $this->do_report->fetch_url($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
														if(empty($total))
														{
															$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
															$total = $this->do_report->fetch_url($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
															
														}														
													}												
													break;
												default:	
													//$this->response($search,200);	
														
													$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable,FALSE,$campaign_id);
											//echo $this->db->last_query();
										//	$this->response($this->db->last_query(),200);		
													if(empty($total)  && $old_from_date == $search['date_from'])
													{
														$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
														$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
														if(empty($total))
														{
															$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";
															$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
															
														}														
													}													
													
													break;
							
												}
												

												$no_records = ($total !== FALSE)?count($total):0;
												

												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $total;
													//$result_data['aaData'] = $res['data'];
													$result_data['overview_chart_data'] = $chart_data;
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';	

													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));															
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);	
												break;
												case 'REPORT_GEO_GRAPHICAL':
											
													$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable,$adv_types);
													
													//echo $this->db->last_query();
														//$this->response($this->db->last_query(),200);
														//$this->response($total,200);
													if(empty($total) && $old_from_date == $search['date_from'])
													{
														$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
														$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable,$adv_types);
														if(empty($total))
														{
															$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
															$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable,$adv_types);
															
														}														
													}													
													$no_records = ($total !== FALSE)?count($total):0;

												
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $total;

													$result_data['overview_chart_data'] = $chart_data;
													$result_data['overall_map_data'] = $map_data;
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));													
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													$result_data['overall_map_data'] = $map_data;		
													
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));														
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);		
												break;
												default:
												$this->response($res,200);	
										}
									break;
									case 'TRAFFICKER':
										switch($page){
											case 'REPORT_OVERVIEW':
											
										 		/*$total = $this->do_report->fetch_main($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												//$this->response($this->db->last_query(),200);											 			
												$no_records = ($total !== FALSE)?count($total):0;
												
												
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $total;  
													
													$result_data['overview_chart_data'] = $chart_data;
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);*/
																							
											case 'REPORT_ADBLOCK':
											case 'REPORT_ADBLOCK_DETAILS':
											case 'REPORT_ADBLOCK_DETAILS_IMP':
											case 'REPORT_DASHBOARD':
											case 'REPORT_SITE':
											case 'REPORT_SITE_DETAILS':
											case 'REPORT_SITE_DETAILS_IMP':
											case 'REPORT_SITE_DETAILS_SITEURL':
											case 'REPORT_APP':
											case 'REPORT_APP_DETAILS_IMP':
											
											if($this->post('dimensions'))
											{
												$group = $this->post('dimensions');
											}
										 		$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												if(empty($total) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";
													$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													if(empty($total))
													{
														$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";
														$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
														
													}													
												}	
																						 		
												$no_records = ($total !== FALSE)?count($total):0;
												//$no_records = ($res['total'])?$res['total']:0;
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $total;  
													$result_data['overview_chart_data'] = $chart_data;
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));													
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);	
												break;
										case 'REPORT_GEO_GRAPHICAL':
													
												$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													
												if(empty($total) && $old_from_date == $search['date_from'])
												{
													$search['date_from'] = date("Y/m/d", strtotime("-6 months")). " 00:00:00";	
													$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													if(empty($total) )
													{
														$search['date_from'] = date("Y/m/d", strtotime("-12 months")). " 00:00:00";	
														$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
														
													}													
												}
												$no_records = ($total !== FALSE)?count($total):0;
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $total;
//$result_data['aaData'] = $res['data'];
													$result_data['overview_chart_data'] = $chart_data;
													$result_data['overall_map_data'] = $map_data;
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));													
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													$result_data['overall_map_data'] = $map_data;	
													$result_data['dates'] = date("M d,Y", strtotime($search['date_from']));$result_data['date_diff'] = date("m", strtotime($search['date_from'])) - date("m", strtotime($search['date_to']));															
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);		
												break;
											default:
												$this->response($res,200);	
										 }
										 break;
							 	  }
							}
						}
						else if($display==='CHART' AND $res !=FALSE)
						{
							$success = $this->convert_chart_data($res,$settings);	
							$this->response($success,200);	
						}
						else if($display==='MAP' AND $res !=FALSE)
						{
							$success = $this->convert_map_data($res,$settings);	
							$this->response($success,200);	
						}
						else
						{
								/* Monthly calculate impressions/clicks/conversions/spend*/
								$month=date('m');
                                $year=date('Y');								
								$search3['month'] = $month;
								$search3['year'] = $year;								
								$search3['account_id'] 	 = $this->post('adv_account_id'); 
								$search3['account_type'] = 'ADVERTISER';
								$search3['adv_account_id'] = $this->post('adv_account_id');
								$group3[0]= "MONTH";
								
								$month_res=$this->do_report->fetch($columns,$search3,$group3,$order,$limit,$dataTable,$display);
								
															
							if($display==='TILES' AND $account_type==='ADVERTISER')
							{
								
								$spark_chart_config = $rep_config['ADVERTISER']['DASHBOARD']['SPARKLINE'];
															
								$columns2 = array();
								
								foreach($spark_chart_config['FIELDS'] as $key => $value){
									array_push($columns2,$key);
								}
								
								
								$group2 = $spark_chart_config['GROUP'];
								$columns2 = array_unique(array_merge($group,$columns2));
								$order2 = $spark_chart_config['ORDER'];
								$limit2 = $spark_chart_config['LIMIT'];
								
								$date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);

								$search2['date_from'] = $date2['from_date'];
								$search2['date_to'] = $date2['to_date'];
								
								$search2['account_id'] 	 = $this->post('adv_account_id'); 
								$search2['account_type'] = 'ADVERTISER';

								$search2['adv_account_id'] = $this->post('adv_account_id'); 
								
								/*Active campaigns - start */							
								$active_cam=$this->do_report->active_campaign_count($account_id);
								$active_cam_count=$active_cam[0]['count'];	
								$complete_cam=$this->do_report->complete_campaign_count($account_id);
								$complete_cam_count=$complete_cam[0]['count'];										
								/* End*/
								
															
								$tmp_imp_flow = $this->do_report->fetch($columns2,$search2,$group2,$order2,$limit2);
								
																
								if(count($tmp_imp_flow['records'])>0 )
								{
									foreach($tmp_imp_flow['records'] as $imp_data)
									{
										$tmp_impression[]=$imp_data['IMP'];
										
									}
									$imp_flow=implode(',',$tmp_impression);

									$impression_flow=array('impression_flow'=>$imp_flow);	
								}
								else
								{
									$impression_flow=array('impression_flow'=>array());	
								}
								
								if(is_array($impression_flow) AND  count($impression_flow)>0 AND  count($res['records'])>0 )
								{
									$temp = array_merge($res['records'][0],$impression_flow);
									$res['records'][0] = $temp;
								}
								else
								{
									$res['records'][0] = $impression_flow;
								}								
								
								
							}
							if($display==='TILES' AND $account_type==='TRAFFICKER')
							{								
								
								$spark_chart_config = $rep_config['TRAFFICKER']['DASHBOARD']['SPARKLINE'];
								
								$columns2 = array();
								
								foreach($spark_chart_config['FIELDS'] as $key => $value){
									array_push($columns2,$key);
								}
								
								if($this->post('type') && $this->post('type')=='MONTH')
								{									
									$group2 = array('MONTH');
									$search2['date_from'] 	= 	$this->post('date_from');
									$search2['date_to'] 	= 	$this->post('date_to');
									$res = $this->do_report->fetch($columns,$search,$group2,$order,$limit,$dataTable);
								}
								else
								{		
									$group2 = $spark_chart_config['GROUP'];
									
									$date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);

									$search2['date_from'] = $date2['from_date'];
									$search2['date_to'] = $date2['to_date'];
								}
								
								$columns2 = array_unique(array_merge($group,$columns2));
								$order2 = $spark_chart_config['ORDER'];
								$limit2 = $spark_chart_config['LIMIT'];
								
								
								
								$search2['account_id'] 	 = $this->post('pub_account_id'); 
								$search2['account_type'] = 'TRAFFICKER';

								$search2['pub_account_id'] = $this->post('pub_account_id'); 
								
								if($agency_id != FALSE){
									$search2['agency_id'] = $agency_id; 
								}
								
								
								$tmp_earnings_flow = $this->do_report->fetch($columns2,$search2,$group2,$order2,$limit2);
								
								if(count($tmp_earnings_flow['records'])>0 )
								{
									foreach($tmp_earnings_flow['records'] as $earnings_data)
									{
										$tmp_earnings[]=$earnings_data['PUB_EARN'];
										
									}
									$earnings_flow=implode(',',$tmp_earnings);

									$earnings_flow=array('earnings_flow'=>$earnings_flow);	
									
								}
								else
								{
									$earnings_flow=array('impression_flow'=>array());	
								}
								
								if(is_array($earnings_flow) AND  count($earnings_flow)>0 AND  count($res['records'])>0 )
								{
									$temp = array_merge($res['records'][0],$earnings_flow);
									$res['records'][0] = $temp;
								}
								else
								{
									$res['records'][0] = $earnings_flow;
								}
							}
							if($display==='TILES' AND $account_type==='ADMIN')
							{
								
								$spark_chart_config = $rep_config['ADMIN']['DASHBOARD']['SPARKLINE'];
								
								$columns2 = array();
								
								foreach($spark_chart_config['FIELDS'] as $key => $value){
									array_push($columns2,$key);
								}
								
								
								$group2 = $spark_chart_config['GROUP'];
								$columns2 = array_unique(array_merge($group,$columns2));
								$order2 = $spark_chart_config['ORDER'];
								$limit2 = $spark_chart_config['LIMIT'];
								
								$date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);

								$search2['date_from'] = $date2['from_date'];
								$search2['date_to'] = $date2['to_date'];
								
								$search2['account_id'] 	 = $this->post('account_id'); 
								$search2['account_type'] = 'ADMIN';
								
								if($agency_id != FALSE){
									$search2['agency_id'] = $agency_id; 
								}
								
								
								/*Active campaigns - start */							
								$active_cam=$this->do_report->active_campaign_count();
								$active_cam_count=$active_cam[0]['count'];	
								$complete_cam=$this->do_report->complete_campaign_count();
								$complete_cam_count=$complete_cam[0]['count'];										
								/* End*/
								
								
								
								
								$tmp_earnings_flow = $this->do_report->fetch($columns2,$search2,$group2,$order2,$limit2);

								
								
								if(count($tmp_earnings_flow['records'])>0 )
								{
									foreach($tmp_earnings_flow['records'] as $earnings_data)
									{
										$tmp_earnings[]=$earnings_data['ADM_EARN'];
										
									}
									$earnings_flow=implode(',',$tmp_earnings);

									$earnings_flow=array('earnings_flow'=>$earnings_flow);	
								}
								else
								{
									$earnings_flow=array('earnings_flow'=>array());	
								}
								
								$inventory = $this->do_report->get_inventory_count($account_type,$search['date_from'],$agency_id);
								
									
								if(is_array($earnings_flow) AND  count($earnings_flow)>0 AND  count($res['records'])>0 )
								{
									$temp = array_merge($res['records'][0],$earnings_flow);
									$res['records'][0] = $temp;
									if(is_array($inventory) AND  count($inventory)>0)
									{
										$temp = array_merge($res['records'][0],$inventory);
										$res['records'][0] = $temp;
									}
								}
								else
								{
									$res['records'][0] = $earnings_flow;
									
									if(is_array($inventory) AND  count($inventory)>0)
									{
										$temp = array_merge($res['records'][0],$inventory);
										$res['records'][0] = $temp;
									}
								}
							
							}
							
							
							if($display==='TILES'){
								
								// CONVERT NUMERIC VALUES TO SHORT FORM
							
								if(isset($res['records'][0]['IMP'])){
									$res['records'][0]['IMP'] = convert_to_shortform($res['records'][0]['IMP']);
								}
								
								if(isset($res['records'][0]['CLK'])){
									$res['records'][0]['CLK'] = convert_to_shortform($res['records'][0]['CLK']);
								}
								
								if(isset($res['records'][0]['CON'])){
									$res['records'][0]['CON'] = convert_to_shortform($res['records'][0]['CON']);
								}
								
								if(isset($res['records'][0]['UIMP'])){
									$res['records'][0]['UIMP'] = convert_to_shortform($res['records'][0]['UIMP']);
								}
								
								if(isset($res['records'][0]['UCLK'])){
									$res['records'][0]['UCLK'] = convert_to_shortform($res['records'][0]['UCLK']);
								}
								
								if(isset($res['records'][0]['SPEND'])){
									$res['records'][0]['SPEND'] = convert_to_shortform($res['records'][0]['SPEND'],2);
								}
								
								if(isset($res['records'][0]['CTR'])){
									$res['records'][0]['CTR'] = convert_to_shortform($res['records'][0]['CTR'],2);
								}
								
								if(isset($res['records'][0]['ECPM'])){
									$res['records'][0]['ECPM'] = convert_to_shortform($res['records'][0]['ECPM'],2);
								}
								
								if(isset($res['records'][0]['PUB_EARN'])){
									$res['records'][0]['PUB_EARN'] = convert_to_shortform($res['records'][0]['PUB_EARN'],2);
								}
								
								if(isset($res['records'][0]['PUB_ECPM'])){
									$res['records'][0]['PUB_ECPM'] = convert_to_shortform($res['records'][0]['PUB_ECPM'],2);
								}
								
								if(isset($month_res['records'][0]['IMP'])){
									$res['records'][0]['MONTH_IMP'] = convert_to_shortform($month_res['records'][0]['IMP']);
								}
								
								if(isset($month_res['records'][0]['CLK'])){
									$res['records'][0]['MONTH_CLK'] = convert_to_shortform($month_res['records'][0]['CLK']);
								}
								
								if(isset($month_res['records'][0]['CON'])){
									$res['records'][0]['MONTH_CON'] = convert_to_shortform($month_res['records'][0]['CON']);
								}
								
								if(isset($month_res['records'][0]['UIMP'])){
									$res['records'][0]['MONTH_UIMP'] = convert_to_shortform($month_res['records'][0]['UIMP']);
								}
								
								if(isset($month_res['records'][0]['UCLK'])){
									$res['records'][0]['MONTH_UCLK'] = convert_to_shortform($month_res['records'][0]['UCLK']);
								}
								
								if(isset($month_res['records'][0]['SPEND'])){
									$res['records'][0]['MONTH_SPEND'] = convert_to_shortform($month_res['records'][0]['SPEND'],2);
								}
								
								if(isset($month_res['records'][0]['CTR'])){
									$res['records'][0]['MONTH_CTR'] = convert_to_shortform($month_res['records'][0]['CTR'],2);
								}
								
								if(isset($month_res['records'][0]['ECPM'])){
									$res['records'][0]['MONTH_ECPM'] = convert_to_shortform($month_res['records'][0]['ECPM'],2);
								}
								
								if(isset($month_res['records'][0]['PUB_EARN'])){
									$res['records'][0]['MONTH_PUB_EARN'] = convert_to_shortform($month_res['records'][0]['PUB_EARN'],2);
								}
								
								if(isset($month_res['records'][0]['PUB_ECPM'])){
									$res['records'][0]['MONTH_PUB_ECPM'] = convert_to_shortform($month_res['records'][0]['PUB_ECPM'],2);
								}							
								if(!empty($active_cam_count))
								{
									$res['records'][0]['ACTIVE_CAM']=$active_cam_count;
								}
								if(!empty($complete_cam_count))
								{
									$res['records'][0]['COMPLETE_CAM']=$complete_cam_count;
								}
								
															
								// END OF CONVERT PROCESS
							
							}
							
							//exit;
							
							$success 	= 	array(
											'response' 	=> 	'ok',
											'data'		=> 	$res,
										);
										
						  $this->response($success,200);
						}
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_advertiser_get
	 * @param :
	 * @return : $campaign_list
	 * 
	 * Lists advertiser for reports
	 */
	
	function fetch_advertiser_get()
	{

        //Get from library file
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id');

		if($account_id)
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_report->fetch_advertiser($network_id,$network_account_id,$account_id);
			}
			else
			{
				$advertiser = 	$this->do_report->fetch_advertiser($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_report->fetch_advertiser($network_id,$network_account_id);
			}
			else
			{
				$advertiser = 	$this->do_report->fetch_advertiser($network_id);
			}
		}

			
		$this->response($advertiser,200);
		
	}
	
	/*
	 * 
	 * name: fetch_publisher_get
	 * @param :
	 * @return : $campaign_list
	 * 
	 * Lists publisher for reports
	 */
	
	function fetch_publisher_get()
	{
		//Get from library file
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id');
		
		if($account_id)
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_report->fetch_publisher($network_id,$network_account_id,$account_id);
			}
			else
			{
				$publisher = 	$this->do_report->fetch_publisher($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_report->fetch_publisher($network_id,$network_account_id);
			}
			else
			{
				$publisher = 	$this->do_report->fetch_publisher($network_id);
			}
		}
		
		$this->response($publisher,200);
	}
	
	/*
	 * 
	 * name: fetch_publisher_traffic_get
	 * @param :
	 * @return : $campaign_list
	 * 
	 * Lists publisher for reports
	 */
	
	function fetch_publisher_traffic_get()
	{
		//Get from library file
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id');
		
		if($account_id)
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_report->fetch_publisher_traffic_source($network_id,$network_account_id,$account_id);
			}
			else
			{
				$publisher = 	$this->do_report->fetch_publisher_traffic_source($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_report->fetch_publisher_traffic_source($network_id,$network_account_id);
			}
			else
			{
				$publisher = 	$this->do_report->fetch_publisher_traffic_source($network_id);
			}
		}
		
		$this->response($publisher,200);
	}
	
	/*
	 * 
	 * name: fetch_campaigns_get
	 * @param :
	 * @return : $campaign_list
	 * 
	 * Lists a campaigns of an advertiser
	 */
	
	function fetch_campaigns_get()
	{
		//Get from library file
		if($this->user_authentication->account_type=='ADVERTISER'){
			$account_id = 	$this->user_authentication->account_id;
		}
		else{
			$account_id	=	'';
		}
		
		$agency_id 		= 	$this->user_authentication->agency_id;
		
		$campaign_type 	= 	$this->get('campaign_type');
		
		$admarket		=   $this->get('admarket');
		
		$camp_det 		= 	$this->do_report->fetch_campaign($account_id,$campaign_type,$agency_id,$admarket);
		
		if($camp_det)
		{
			$this->response($camp_det, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
	}
	
	/*
	 * 
	 * name: fetch_creative_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a web creative of an advertiser
	 */
	
	function fetch_video_creative_get()
	{
		//Get from library file
		$account_id = $this->user_authentication->account_id;
				
		if($account_id)
		{
			$creative_details = $this->do_report->fetch_video_creatives($account_id);
			//print_r($creative_details); exit;
			if($creative_details)
			{
			  $this->response($creative_details, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details found'),404);
			}
		}
	}

	/*
	 * 
	 * name: fetch_creatives_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a web creative of an advertiser
	 */
	
	function fetch_creatives_get()
	{  
		if($this->user_authentication->account_type=='ADVERTISER'){
			$account_id = 	$this->user_authentication->account_id;
		}
		else{
			$account_id	=	'';
		}				
		
		$agency_id 			= 	$this->user_authentication->agency_id;
		
		$creative_details 	= 	$this->do_report->fetch_creatives($account_id);
		
		//print_r($creative_details); exit;
		if($creative_details)
		{
			$this->response($creative_details, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}		
	}	
	
	/*
	 * 
	 * name: convert_map_data
	 * @param : $res,$settings
	 * @return : map_data
	 * 
	 * Converts the data into map format
	 */
	
	function convert_map_data($res,$settings){
	
		
		// Declaration
		$map_data ='';
		//$map_inner_data ='';
		$map_inner_data = array();
		
											
		if(!empty($res['records']))
		{
			foreach($res['records'] as $values)
			{
				if(isset($values['CON']))
				{
					$conversions = 	'<br/><b>Conversions</b> - '.$values['CON'].'';
				}else{
					$conversions = '';	
				}
				
				$map_value = array('latLng'=>
									array(floatval($values['LATITUDE']),floatval($values['LONGITUDE'])),
									'data'=>'<b>Impression</b> - '.$values['IMP'].',<br/><b>Click</b> - '.$values['CLK'].','.$conversions.'',
									'options'=>
										array('icon'=>'http://maps.google.com/mapfiles/marker_green.png')
							);
								
				
				array_push($map_inner_data,$map_value);
			}
			
			$map_data = json_encode($map_inner_data);
		}else{
			$map_data = '[]';		
		}
			
			//print_r($map_data);
				
		$success 	= 	array(
						'response' 		=> 	'ok',
						'map_data'	=> 	$map_data
					);
	
		return 	$success;	
	
	}
	
	/*
	 * 
	 * name: fetch_sites_get
	 * @param :
	 * @return : $site_list
	 * 
	 * Lists all sites
	 */
	
	
	function fetch_sites_get()
	{
		$site_id=$this->get('siteid');
	    if($this->user_authentication->account_type=='TRAFFICKER'){
		 $account_id = $this->user_authentication->account_id;
		 $data['account_id']=$account_id;
		}
		else
		{
		 $agency_id = $this->user_authentication->agency_id;
		 $data['agency_id']=$agency_id;
		}	
		$site_list = $this->do_report->fetch_sites($data,$site_id);
		$this->response($site_list,200);
			
		
	}
	
	/*
	 * 
	 * name: fetch_apps_get
	 * @param :
	 * @return : $site_list
	 * 
	 * Lists all sites
	 */
	
	
	function fetch_apps_get()
	{
		$app_id=$this->get('appid');
	    if($this->user_authentication->account_type=='TRAFFICKER'){
		 $account_id = $this->user_authentication->account_id;
		 $data['account_id']=$account_id;
		}
		else
		{
		 $agency_id = $this->user_authentication->agency_id;
		 $data['agency_id']=$agency_id;
		}	
		$app_list = $this->do_report->fetch_apps($data,$app_id);
		$this->response($app_list,200);	
	}	
	
	/*
	 * name: convert_sorting_data
	 * @param :
	 * @return : $output or false
	 * 
	 * convert data into order by array
	 */
	function convert_sorting_data($request_data = FALSE)
	{
		if($request_data)
		{
			if ( isset( $request_data['iSortCol_0'] ) )
			{
				//Initialize order by array
				$sorting_order = array();
				
				for ( $i=0 ; $i<intval( $request_data['iSortingCols'] ) ; $i++ )
				{
					if ( $request_data[ 'bSortable_'.intval($request_data['iSortCol_'.$i]) ] == "true" )
					{
						$sorting_order[$request_data[ 'mDataProp_'.intval($request_data['iSortCol_'.$i]) ]] = $request_data[ 'sSortDir_'.$i];	
					}
				}
				return $sorting_order;	
			}else{
				return FALSE;	
			}
		}else{
			return FALSE;	
		}	
		
		
	}
	
	/*
	 * 
	 * name: fetch_adblocks_get
	 * @param :
	 * @return : $adblock_list
	 * 
	 * Lists a adblock of an publisher
	 */
	
	function fetch_adblocks_get()
	{
		//Get from library file
		if($this->user_authentication->account_type=='TRAFFICKER'){
			$account_id = 	$this->user_authentication->account_id;
		}
		else{
			$account_id	=	'';
		}
		
		$agency_id 		= 	$this->user_authentication->agency_id;	
		
		$site_id		=	$this->get('site_id');
		
		$adblock_id		=	$this->get('adblock_id');
		
		$adb_det 		= 	$this->do_report->fetch_adblocks($account_id,$site_id,$agency_id,$adblock_id);
		
		if($adb_det)
		{
			$this->response($adb_det, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
	}
	
	
	
	
	function  fetch_site_adblock_get()
	{
		//Get from library file
		if($this->user_authentication->account_type=='TRAFFICKER'){
			$account_id = 	$this->user_authentication->account_id;
		}
		else{
			$account_id	=	'';
		} 
		
		$agency_id 		= 	$this->user_authentication->agency_id;			
				
		$adblock_id		=	$this->get('adblock_id');
		
		$adb_det 		= 	$this->do_report->fetch_adblocks_site($account_id,$agency_id,$adblock_id);
		
		if($adb_det)
		{
			$this->response($adb_det, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
	}
	
	/*
	* 
	* name: request_report_post
	* @param :
	* @return : $report_list
	* 
	* Lists a adblock of an publisher
	*/
	
	function request_report_post()
	{	
		$network_id				=	$this->user_authentication->network_account_id;		
		$account_id 			= 	$this->user_authentication->account_id;
		$agency_id 				= 	$this->user_authentication->agency_id;	
				
		$account_type	=	$this->user_authentication->account_type;
		$email			=	clean_data($this->post('email'));
		
		$frequency		=	clean_data($this->post('frequency'));
		$type			=	clean_data($this->post('file_type'));
		$format			=	clean_data($this->post('file_format'));
		
		$agency_id 		= 	$agency_id;

		$acc_id=get_session('account_id');
		$user_id=get_session('user_id');
		$account_type=get_session('account_type');
		$acc_det=get_session_acc_details($acc_id,$user_id,$account_type);
	
		$name 			= 	$acc_det['first_name'].' '.$acc_det['last_name'];		
		
		$from_date		= 	clean_data($this->post('date_from'));
		$to_date			= 	clean_data($this->post('date_to'));
		
		$search	=	array(
						'account_id'	=>	$account_id,
						'name'			=>	$name,
						'account_type'	=>	$account_type,
						'email'			=>	$email,
						'frequency'		=>	$frequency,
						'type'			=>	$type,
						'format'		=>	$format,
						'agencyid'		=>	$agency_id,
						'date_time'		=>	date('Y-m-d H:i:s'),
						'status'		=>	1,
						'from_date'		=>	$from_date,
						'to_date'		=>	$to_date,
					);
		
		//Additional Details
		$search['display_by']	= 	clean_data($this->post('interval'));
		$search['device']		= 	clean_data($this->post('environment'));								
			
		if(clean_data($this->post('metrics')) != ''){
			$metrics 				= 	clean_data($this->post('metrics')); 
			$search['columns']		=	($metrics)?((is_array($metrics))?implode(',',$metrics):$metrics):'';
		}
		
		$group_by	=	'';
			
		if(clean_data($this->post('dimensions')) != ''){
			$dimensions 			= 	clean_data($this->post('dimensions')); 
			$group_by		.=	($dimensions)?((is_array($dimensions))?implode(',',$dimensions):$dimensions):'';
		}
		
		if($search['display_by']!='CUMULATIVE'):
			if($search['display_by']=='HOUR'):
				if($this->post('dimensions') != '' && in_array('DATE',explode(',',$this->post('dimensions')))):
					$group_by	.=	','.$search['display_by'];
				else:
					$group_by	.=	',DATE,'.$search['display_by'];					
				endif;
			else:
				$group_by	.=	','.$search['display_by'];
			endif;
		endif;
		
		$search['group_by']	=	ltrim($group_by, ",");
		
		if(clean_data($this->post('advertiser_id')) != '' AND clean_data($this->post('advertiser_id')) != 'all'){
			$advertiser_id 			= 	clean_data($this->post('advertiser_id')); 
			$search['advertiser']	=	($advertiser_id)?((is_array($advertiser_id))?implode(',',$advertiser_id):$advertiser_id):'';
		}
		
		if(clean_data($this->post('campaign_id')) != '' AND clean_data($this->post('campaign_id')) != 'all'){
			$campaign_id		 	= 	clean_data($this->post('campaign_id')); 
			$search['campaign']		=	($campaign_id)?((is_array($campaign_id))?implode(',',$campaign_id):$campaign_id):'';
		}
		
		if(clean_data($this->post('creative_id')) != '' AND clean_data($this->post('creative_id')) != 'all'){
			$creative_id 			= 	clean_data($this->post('creative_id')); 
			$search['creative']		=	($creative_id)?((is_array($creative_id))?implode(',',$creative_id):$creative_id):'';
		}
		
		if(clean_data($this->post('publisher_id')) != '' AND clean_data($this->post('publisher_id')) != 'all'){
			$publisher_id 			= 	clean_data($this->post('publisher_id')); 
			$search['publisher']	=	($publisher_id)?((is_array($publisher_id))?implode(',',$publisher_id):$publisher_id):'';
		}
		
		if(clean_data($this->post('site_id')) != '' AND clean_data($this->post('site_id')) != 'all'){
			$site_id 				= 	clean_data($this->post('site_id')); 
			$search['site']			=	($site_id)?((is_array($site_id))?implode(',',$site_id):$site_id):'';
		}
		
		if(clean_data($this->post('adblock_id')) != '' AND clean_data($this->post('adblock_id')) != 'all'){
			$adblock_id 			= 	clean_data($this->post('adblock_id')); 
			$search['zone']			=	($adblock_id)?((is_array($adblock_id))?implode(',',$adblock_id):$adblock_id):'';
		}	
		
		if(clean_data($this->post('country_id')) != '' AND clean_data($this->post('country_id')) != 'all'){
			$country_id 			= 	clean_data($this->post('country_id')); 
			$search['country']		=	($country_id)?((is_array($country_id))?implode(',',$country_id):$country_id):'';
		}
		
		if(clean_data($this->post('ad_size')) != '' AND clean_data($this->post('ad_size')) != 'all'){
			$adsize 				= 	clean_data($this->post('ad_size')); 
			$search['adsize']		=	($adsize)?((is_array($adsize))?implode(',',$adsize):$adsize):'';
		}
		
		if(clean_data($this->post('rev_type')) != '' AND clean_data($this->post('rev_type')) != 'all'){
			$revtype 				= 	clean_data($this->post('rev_type')); 
			$search['rtype']		=	($revtype)?((is_array($revtype))?implode(',',$revtype):$revtype):'';
		}										
		
		if($search['frequency']!='One')
		{
			$addrequest	= 	$this->do_report->add_request($search);		
			
			if($addrequest)
			{
				$success 		= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Report has been Requested Successfully!.'
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'No data for selected period'
									);
				$this->response( $error, 200);
			}
		}
		else
		{
			if($from_date != '' && $from_date != FALSE){
				$search['date_from'] = $from_date;
			}	
			
			if($to_date != '' && $to_date != FALSE){
				$search['date_to'] = $to_date;
			}	
		
			$rep_data 	= 	$this->do_report->fetch_request_report($search);
			
			$time		=	time();	
			$rep_name	=	'report_'.$time;
			
			$interval	= 	clean_data($this->post('interval'));
			$date_from	= 	date('d/m/Y',strtotime(clean_data($this->post('date_from'))));
			$date_to	= 	date('d/m/Y',strtotime(clean_data($this->post('date_to'))));		
			
			$metrics 	= 	clean_data($this->post('metrics'));
			
			$mcol		= 	clean_data($this->post('m_col'));		
			$dim		= 	clean_data($this->post('dimensions'));
			$dcol		= 	clean_data($this->post('d_col'));
			$dname		= 	clean_data($this->post('d_name'));
			
			$m_col 		= 	($mcol)?((is_array($mcol))?$mcol:explode(',',$mcol)):'';	
			$dimens		= 	($dim)?((is_array($dim))?$dim:explode(',',$dim)):'';			
			$d_col		= 	($dcol)?((is_array($dcol))?$dcol:explode(',',$dcol)):'';
			$d_name 	= 	($dname)?((is_array($dname))?$dname:explode(',',$dname)):'';	
						
			if($rep_data)
			{
				$objPHPExcel= 	new PHPExcel();
				$workSheet	=	$objPHPExcel->getActiveSheet();			
				
				$objPHPExcel->getProperties()->setCreator("Administrator");
				$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
				$objPHPExcel->getProperties()->setTitle();				

				//Default Style Settings For Excel Sheet 
				$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
				$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
				$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

				// Set column width
				
				//Set the dimensions for the Table Title Attributes
				$i='A';
			
				$workSheet->getColumnDimension('B')->setWidth(20);
				
				if($interval!='CUMULATIVE'):				
					if($interval=='HOUR'):	
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
						
						$i++;
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
					else:				
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
					endif;
					$i++;
				endif;
				 
				if(!empty($dimens)):
					foreach($dimens as $d):	
						if($interval=='HOUR')
						{
							if($d!='DATE')
							{
								if($i=='B')
								{
									$workSheet->getColumnDimension($i)->setWidth(20);
								}
								else
								{
									$workSheet->getColumnDimension($i)->setAutoSize(true);
								}	
							}
						}
						else
						{
							if($i=='B')
							{
								$workSheet->getColumnDimension($i)->setWidth(20);
							}
							else
							{
								$workSheet->getColumnDimension($i)->setAutoSize(true);
							}	
						}
						$i++;				
					endforeach;	
				endif;
				
				if(!empty($metrics)):
					foreach($metrics as $m):
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
						$i++;				
					endforeach;	
				endif;
			
				//Set the Row dimensions for Each Row 			
				$workSheet->getRowDimension(6)->setRowHeight(20);
				
				// Decalaration of Style in an Array 		
				
				$titleArray	=	array(
										'font'=>array(
													'bold'	=>	true,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);
				$contentArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);	
									
				$dimensArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);		
										
				$metricsArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
										)	
									);				
							
				// Add some data
				//echo date('H:i:s') . " Add some data\n";
				$objPHPExcel->setActiveSheetIndex(0);
				
				//Set the Title and Start Date ,End Date Details 
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', "Report Name");
				$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Report - '.$date_from.' to '.$date_to);
				$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A2', "Report ID");
				$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B2', $time);
				$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A3', "From Date");
				$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B3', $date_from);	
				$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($contentArray);			
						
				$objPHPExcel->getActiveSheet()->SetCellValue('A4', "To Date");
				$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B4', $date_to);
				$objPHPExcel->getActiveSheet()->getStyle('B4')->applyFromArray($contentArray);
				
				$workSheet->getStyle(6)->applyFromArray($titleArray);
				$j='A';
				if($interval!='CUMULATIVE'):
					if($interval=='HOUR'):
						$workSheet->SetCellValue($j.'6',"Date");
						$j++;
						$workSheet->SetCellValue($j.'6',"Hour");	
					else:
						$workSheet->SetCellValue($j.'6',ucfirst(strtolower($interval)));	
					endif;
					$j++;
				endif;
				
				if(!empty($d_name)):
					foreach($d_name as $d):
						if($interval=='HOUR')
						{
							if($d!='date')
							{
								$workSheet->SetCellValue($j.'6',ucfirst($d));
								$j++;
							}
						}
						else
						{
							$workSheet->SetCellValue($j.'6',ucfirst($d));
							$j++;
						}
					endforeach;	
				endif;
				
				if(!empty($m_col)):
					foreach($m_col as $m):
						$workSheet->SetCellValue($j.'6',ucfirst($m));
						$j++;
					endforeach;	
				endif;
			
				$workSheet->getStyle('A6:H6')->applyFromArray($titleArray);
				
				$col		=	0;
				$row		=	7;
				
				$k=0;
				
				foreach($rep_data as $stat_data):
					$cv=0;
					if($interval!='CUMULATIVE'):
						if($interval=='HOUR'):
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data['DATE']);	
							$cv++;
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data['HOUR']);
						else:
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data[$interval]);	
						endif;
						$cv++;
					endif;
				
					if(!empty($d_col)):
						foreach($d_col as $dc):
							if($interval=='HOUR')
							{
								if($dc!='DATE')
								{
									$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data[$dc]);
									$cv++;
								}
							}
							else
							{
								$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data[$dc]);
								$cv++;
							}
						endforeach;	
					endif;
					
					if(!empty($metrics)):
						foreach($metrics as $m):
							if($m=='FILL_RATE')
							{
								$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data[$m].'%');
							}
							else
							{
								$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data[$m]);
							}					
							
							$cv++;
						endforeach;	
					endif;
					
					$row++;	
				endforeach;			
				
				if($search['format']=='xls'):
					$filename	=		$rep_name.'.xls';
					//********* TO DOWNLOAD THE EXCEL FILE********
					header('Content-Type: application/vnd.ms-excel');
					header('Content-Disposition: attachment;filename="'.$filename.'"');
				elseif($search['format']=='csv'):
					$filename	=		$rep_name.'.csv';
					//********* TO DOWNLOAD THE EXCEL FILE********
					header('Content-Type: text/csv');
					header('Content-Disposition: attachment;filename="'.$filename.'"');
				endif;
				
				$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);	
				
				$objWriter->save($this->config->item('csv_report').$filename);
				// GET Report MAILING DETAILS FOR FROM ADDRESS
				
				$result			=	$this->do_networks->agency_owner_details($agency_id);
				// IF NOT NETWORK ADMIN ADMIN SEND BCC
				
				$admin_name    	= 	$result['name'];			
				$admin_email   	= 	$result['email'];
				
				$type          	= 	'REQUEST_REPORT';		
				$from 	       	= 	$admin_email;
				$to  	       	= 	$search['email'];
				//$to  	       	= 	'sudhakarmuruga@gmail.com';
				
				
				$mail_content	=	array(
										"subject" 		=> 	"Report Details",
										"to_name" 		=> 	$search['name'],			
										"from_name"		=> 	$admin_name,
										"email"  		=> 	$search['email'],
										"account_type"	=>	$search['account_type'],
										"frequency"		=>	$search['frequency'],
										"type"			=>	$search['type'],
										"format"		=>	$search['format'],
										"from_date"		=>	$search['date_from'],
										"to_date"		=>	$search['date_to']
									);									
					
				$attachement 	= 	$this->config->item('csv_report').$filename;
				
				send_mail($type,$from,$to,$mail_content,$attachement);
							
				$success 		= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Requested Report is sent Successfully to your Registered Email.'
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	'No data for selected period.'
									);
				$this->response( $error, 200);
			}
		}		
	}
	
	
	/*
	 * 
	 * name: fetch_adblocks_get
	 * @param :
	 * @return : $adblock_list
	 * 
	 * Lists a adblock of an publisher
	 */
	
	function fetch_request_get()
	{
		$request = 	$this->do_report->get_request();
		
		if($request)
		{
			$this->response($request, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
	}
	
	/*
   * 
   * name: request_update_get
   * @param : reqid
   * @return : success msg
   * 
   */
	public function request_update_get()
	{
	    $req_id		=	$this->get('req_id');
	    $req_type	=	$this->get('req_type');
		if($req_id)
		{
			if($req_type=='pause')
			{
				$where	=	array('status'=>0);
				$msg	=	'Request is paused successfully.';
			}
			elseif($req_type=='active')
			{
				$where	=	array('status'=>1);
				$msg	=	'Request is activated successfully.';
			}
			elseif($req_type=='delete')
			{
				$where	=	array('is_deleted'=>1);
				$msg	=	'Request is deleted successfully.';
			}
			
			$pausereq = $this->do_report->update_request($req_id,$where);
			
			if($pausereq)
			{
				$success = 	array(	'response'	=> 'ok',
									'msg'		=> $msg
								 );
				
				$this->response( $success, 200);
			}
			else
			{
				$error = 	array(	'response'	=> 'error',
									'msg'		=> 'Error! Please try again..'
								 );
				
				$this->response( $error, 200);
			}
		}
	}
	
	function fetch_dsp_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id = $this->user_authentication->agency_id;
	//	$this->response($agency_id,200);
	
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['search_fields']=	array("exchange_name");
	
		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		//$search['search_fields']= 	$this->get('search_fields');
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
		//$this->response($agency_id,200);				
		
		$res   		= 	$this->do_report->fetch_dsp_stats($search,$order,$limit,$agency_id);
		$total 		= 	$this->do_report->fetch_dsp_stats($search,$order,FALSE,$agency_id);
		$no_records = 	($total !== FALSE)?count($total):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		
		$this->response($result_data,200);
	}
	function fetch_dsp_date_post()
	{
		//Get from library file
		$exchange_id	= clean_data($this->post('exchange_id'));
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id = $this->user_authentication->agency_id;
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['search_fields']=	array("dbdate");
		
		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		//$search['search_fields']= 	$this->get('search_fields');
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
		
		$res   		= 	$this->do_report->fetch_dsp_date_stats($exchange_id,$search,$order,$limit,$agency_id);
		$total 		= 	$this->do_report->fetch_dsp_date_stats($exchange_id,$search,$order,FALSE,$agency_id);
		$no_records = 	($total !== FALSE)?count($total):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		
		$this->response($result_data,200);
	}
	
	function fetch_dsp_detail_post()
	{
		//Get from library file
		$exchange_id	= clean_data($this->post('exchange_id'));
		$date 			= clean_data($this->post('date'));
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id = $this->user_authentication->agency_id;
		
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['search_fields']=	array("client_name","camp_name","ban_name");
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
		
		$res 		= 	$this->do_report->fetch_dsp_detail_stats($exchange_id,$date,$search,$order,$limit,$agency_id);
		$total 		= 	$this->do_report->fetch_dsp_detail_stats($exchange_id,$date,$search,$order,FALSE,$agency_id);
		$no_records = 	($total !== FALSE)?count($total):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$total;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	0;
			$result_data['aaData'] 					= 	array();
			//$result_data['overview_chart_data'] 	= 	'';			

		}
		
		$this->response($result_data,200);
	}	
	
	function fetch_ssp_post()
	{
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id = $this->user_authentication->agency_id;
		
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['search_fields']=	array("exchange_name");
		
		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}		
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
		
		$res 		= 	$this->do_report->fetch_ssp_stats($search,$order,$limit,$agency_id);
		$total 		= 	$this->do_report->fetch_ssp_stats($search,$order,false,$agency_id);
		$no_records = 	($total !== FALSE)?count($total):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	0;
			$result_data['aaData'] 					= 	array();
			//$result_data['overview_chart_data'] 	= 	'';			

		}
		
		$this->response($result_data,200);
	}
	
	function fetch_ssp_detail_post()
	{
		//Get from library file
		$exchange_id	= clean_data($this->post('exchange_id'));
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id = $this->user_authentication->agency_id;
		
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['search_fields']=	array("dbdate");
		
		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}	
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
		
		$res 		= 	$this->do_report->fetch_ssp_detail_stats($exchange_id,$search,$order,$limit,$agency_id);
		$total 		= 	$this->do_report->fetch_ssp_detail_stats($exchange_id,$search,$order,false,$agency_id);
		$no_records = 	($total !== FALSE)?count($total):0;
		if($no_records)
		{	
			$result_data['sEcho'] 			= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= $no_records;
			$result_data['iTotalDisplayRecords'] = $no_records;
			$result_data['aaData'] = $res;
			//$result_data['overview_chart_data'] = $chart_data;

		}else{
			$result_data['sEcho'] 			= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= $no_records;
			$result_data['iTotalDisplayRecords'] = 0;
			$result_data['aaData'] = array();
			//$result_data['overview_chart_data'] = '';			

		}
		
		$this->response($result_data,200);
	}
	
	/*
	* 
	* name: download_report_get
	* @param :
	* @return : $report_list
	* 
	* Lists a adblock of an publisher
	*/
	
	function download_report_get()
	{
		
		//Get from library file
		$network_account_id	=	$this->user_authentication->network_account_id;
		$account_id			=	$this->user_authentication->account_id;
		$account_type		=	$this->user_authentication->account_type;
		//$date_from =	$this->post('date_from');
	//	$date_to =	$this->post('date_to');
		
		$where	=	array(
						'account_type'	=>	$account_type,
						'account_id'	=>	$account_id	
						);
		
		$request = 	$this->do_report->fetch_last_request($where);
	
		$this->response($request,200);
	}
	
	


	
	
	/*function fetch_detail_info_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;
		$site_id 		= clean_data($this->post('site_id'));
		$field_name 		= clean_data($this->post('field_name'));
		$app_id 		= clean_data($this->post('app_id'));
		$email 		= clean_data($this->post('email'));
		
		$page 		= clean_data($this->post('page'));
		$display 		= clean_data($this->post('display_type'));
		
	
	
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['site_id']  	= 	$site_id;
		$search['field_name']  	= 	$field_name;
		
		$search['app_id']  		= 	$app_id;
		$search['email']  		= 	$email;
		
		$search['search_fields']=	array("site_name");
		$columns = array();
		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		//$search['search_fields']= 	$this->get('search_fields');
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);


		$rep_config = $this->config->item('report_config');
		if(isset($rep_config[strtoupper($account_type)][strtoupper($page)])){
			
			$settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
						
			if(is_array($settings) AND count($settings) > 0){
			
				foreach($settings['FIELDS'] as $key => $value){
					
					
					if(isset($rep_config['MANAGER_PERMISSION'][strtoupper($key)]) && strtoupper($account_type) =='ADMIN')
					{
					    
					
						if(check_permission_layout($rep_config['MANAGER_PERMISSION'][strtoupper($key)],$manager_role_id))
						{
							
							array_push($columns,$key);
						}
					}else{
						
						array_push($columns,$key);
					}
				} 				
				
				$group = $settings['GROUP'];
				
				if($page=='REPORT_DASHBOARD'):
					if($this->post('adv_type')!='' && $this->post('adv_type')=='zone'):
						$group	=	array('ZONE_ID');
					elseif($this->post('adv_type')!='' && $this->post('adv_type')=='traffic'):
						$group	=	array('AFF_ID');
					endif;
				endif;
								 
				$columns = array_unique(array_merge($group,$columns));


}}

				if( $this->convert_sorting_data($datatable_obj))
				{
					$order = $this->convert_sorting_data($datatable_obj);
				}else{
					$order = $settings['ORDER'];
				}
		
				if($this->post('start') != ''){
					$limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
				}
				else
				{
					$limit = $settings['LIMIT'];
				}
				
	
				if($settings['DEFAULT_INTERVAL'] != ''){
					$date = get_search_date($settings['DEFAULT_INTERVAL']);
					$search['date_from'] = $date['from_date'].' 00:00:00';
					$search['date_to'] = $date['to_date'].' 23:00:00';
				}
								// GET CHART SETTINGS AND DATA
								
								$chart_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('chart')];
								
								if($this->post('start') != ''){
									if($this->post('end') <=$chart_settings['LIMIT']['end'])
									{
										$chart_limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
									}else{
										$chart_limit = $chart_settings['LIMIT'];	
									}
								}
								else
								{
									$chart_limit = $chart_settings['LIMIT'];
								}




						
					
		$chart_data_res = $this->do_report->fetch_detail_info1($columns,$search,$group,$order,NULL,$chart_limit);
		$chart_data = $this->convert_chart_data($chart_data_res,$chart_settings);						
		//$this->response($chart_data_res,200);
		$res   		= 	$this->do_report->fetch_detail_info1($search,$order,$limit,$agency_id);
		$totals = '1';
		$total 		= 	$this->do_report->fetch_detail_info1($search,$order,FALSE,$agency_id,$totals);
		$res[] = $total[0];
		
		
		$no_records = 	($total !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		
		$this->response($result_data,200);
		//$this->response('testing',200);
		
	}*/
	
	function fetch_detail_info2_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$search['limit1']= $datatable_obj['iDisplayStart'];
		$search['limit2']= $datatable_obj['iDisplayLength'];
		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;
		$site_id 		= clean_data($this->post('site_id'));
		$field_name 		= clean_data($this->post('field_name'));
		$app_id 		= clean_data($this->post('app_id'));
		$email 		= clean_data($this->post('email'));
		
		$page 		= clean_data($this->post('page'));
		$display 		= clean_data($this->post('display_type'));
		$adblock_id 	= $this->post('adblock_id');
		
		
		$country		= $this->post('country');
		$device			= $this->post('device');	
	
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['site_id']  	= 	$site_id;
		$search['field_name']  	= 	$field_name;
		
		$search['app_id']  		= 	$app_id;
		$search['email']  		= 	$email;
		$search['adblock_id'] 	= 	$adblock_id; 
		$search['search_fields']=	"site_name";

		$search['country'] 		= 	$country; 
		$search['device'] 		= 	$device; 
		
		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		//$search['search_fields']= 	$this->get('search_fields');
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
						
        if(!empty($site_id))
        {	
				if($search['field_name'] == 'request')
				{
					$res   		= 	$this->do_report->fetch_detail_request_info4($search,$order,$limit,$agency_id);
					
				}
				else
				{											
					$res   		= 	$this->do_report->fetch_detail_info2($search,$order,$limit,$agency_id);
				}
			//$this->response($this->db->last_query(),200);	
		}
		else if(!empty($app_id))
        {		
				if($search['field_name'] == 'request')
				{
					$res   		= 	$this->do_report->fetch_detail_request_info3($search,$order,$limit,$agency_id);
					
				}
				else
				{										
					$res   		= 	$this->do_report->fetch_detail_info3($search,$order,$limit,$agency_id);
				}
			
		}
		else
		{
			$results   		= 	$this->do_report->fetch_app_site_details($search,$order,$limit,$agency_id);
			if(!empty($results))
			{	
				if($search['field_name'] == 'request')
				{
					$res   		= 	$this->do_report->fetch_detail_request_info4($search,$order,$limit,$agency_id);
					
				}
				else
				{
					$res   		= 	$this->do_report->fetch_detail_info4($search,$order,$limit,$agency_id);
				}
				//$this->response($this->db->last_query(),200);	
			}
			else
			{
				$search['search_fields']=	"app_name";
				$res   		= 	$this->do_report->fetch_detail_info4($search,$order,$limit,$agency_id);
				//$this->response($this->db->last_query(),200);	
			}
			
		}
			
		//$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}
	
	
		
	/*function fetch_detail_country_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;
		$site_id 		= clean_data($this->post('site_id'));
		$field_name 	= clean_data($this->post('field_name'));
		$app_id 		= clean_data($this->post('app_id'));
		$email 			= clean_data($this->post('email'));
		$campaign_id 	= clean_data($this->post('campaign'));
		$creative_id 	= clean_data($this->post('creative'));
		
		$page 			= clean_data($this->post('page'));
		$display 		= clean_data($this->post('display_type'));
		$adblock_id 	= $this->post('adblock_id');
		$date			= $this->post('date');
		$country		= $this->post('country');
		$device			= $this->post('device');
		$newDate 		= date("Y-m-d", strtotime($date));
		
		$search['date'] = $newDate;
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['site_id']  	= 	$site_id;
		$search['field_name']  	= 	$field_name;
		
		$search['app_id']  		= 	$app_id;
		$search['campaign_id']  = 	$campaign_id;
		$search['creative_id']  = 	$creative_id;
		$search['device']  		= 	$device;
		$search['email']  		= 	$email;
		$search['adblock_id'] 	= 	$adblock_id; 
		$search['country'] 		= 	$country; 
		$search['search_fields']=	"site_name";

		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		//$search['search_fields']= 	$this->get('search_fields');
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
							
        if(!empty($search['date']))
        {									
			$res   		= 	$this->do_report->fetch_country_detail_info($search,$order,$limit,$agency_id);
			
		}

		//$this->response($res,200);
				
		$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}*/
	


	function fetch_detail_overview_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$search['limit1']= $datatable_obj['iDisplayStart'];
		$search['limit2']= $datatable_obj['iDisplayLength'];
		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;
		$site_id 		= clean_data($this->post('site_id'));
		$field_name 	= clean_data($this->post('field_name'));
		$app_id 		= clean_data($this->post('app_id'));
		$email 			= clean_data($this->post('email'));
		$campaign_id 	= clean_data($this->post('campaign'));
		$creative_id 	= clean_data($this->post('creative'));
		$dimensions 	= clean_data($this->post('dimensions'));
		
		$page 			= clean_data($this->post('page'));
		$display 		= clean_data($this->post('display_type'));
		$report_type	= clean_data($this->post('report_type'));
		$adblock_id 	= $this->post('adblock_id');
		$date			= $this->post('date');
		$country		= $this->post('country');
		$device			= $this->post('device');
		$newDate 		= date("Y-m-d", strtotime($date));
		
		$search['date'] = $newDate;
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];
		$search['site_id']  	= 	$site_id;
		$search['field_name']  	= 	$field_name;
		
		$search['app_id']  		= 	$app_id;
		$search['campaign_id']  = 	$campaign_id;
		$search['creative_id']  = 	$creative_id;
		$search['dimensions']   = 	$dimensions;
		$search['device']  		= 	$device;
		$search['email']  		= 	$email;
		$search['adblock_id'] 	= 	$adblock_id; 
		$search['country'] 		= 	$country; 
		$search['search_fields']=	"site_name";
		$search['report_type']	=	$report_type;

		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		//$search['search_fields']= 	$this->get('search_fields');
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
							
        if(!empty($search['date']))
        {
			if($field_name == 'request')
			{
				$res   		= 	$this->do_report->fetch_request_overview_detail_info($search,$order,$limit,$agency_id);
				
			}
			else 
			{									
				$res   		= 	$this->do_report->fetch_overview_detail_info($search,$order,$limit,$agency_id);
			}
			
		}

		//$this->response($res,200);
				
		//$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}
	
		
		
	function fetch_campaign_detail_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));

		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;

		$field_name 	= clean_data($this->post('field_name'));
		$cam_id 	= clean_data($this->post('cam_id'));
		$camp_name 	= clean_data($this->post('camp_name'));
		$country		= $this->post('country');
		$device			= $this->post('device');
		

		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];

		$search['field_name']  	= 	$field_name;
		$search['cam_id']  		= 	$cam_id;
		$search['camp_name']  	= 	$camp_name;
        $search['country'] 		= 	$country; 									
        $search['device'] 		= 	$device; 
        
		if($field_name == 'request')
		{
			$res   		= 	$this->do_report->fetch_request_campaign_detail_info($search,$order,$limit,$agency_id);
			
		}
		else
		{
			$res   		= 	$this->do_report->fetch_campaign_detail_info($search,$agency_id);
		}
							
		//$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}	
	
	
	function fetch_creative_detail_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));

		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;

		$field_name 	= clean_data($this->post('field_name'));
		$hostname 		= clean_data($this->post('hostname'));
		$ad_id 			= clean_data($this->post('ad_id'));
		$ad_name 		= clean_data($this->post('ad_name'));
		$country		= $this->post('country');
		$device			= $this->post('device');
		
		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}	
		$search['account_id'] 	= 	$account_id; 
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];

		$search['field_name']  	= 	$field_name;
		$search['hostname']  	= 	$hostname;
		$search['ad_id']  		= 	$ad_id;
		$search['ad_name']  	= 	$ad_name;
        $search['country'] 		= 	$country; 									
        $search['device'] 		= 	$device;

		if($field_name == 'request')
		{
			$res   		= 	$this->do_report->fetch_request_creative_detail_info($search,$order,$limit,$agency_id);
			
		}
		else
		{        								
			$res   		= 	$this->do_report->fetch_creative_detail_info($search,$agency_id);
		}
							
		//$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}	
	
	
	function fetch_detail_admin_advertiser_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$search['limit1']= $datatable_obj['iDisplayStart'];
		$search['limit2']= $datatable_obj['iDisplayLength'];
		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;
		$acc_id 		= clean_data($this->post('account_id'));
		$cam_id 		= clean_data($this->post('cam_id'));
		$creative_id	= clean_data($this->post('creative_id'));

		$field_name 	= clean_data($this->post('field_name'));
		
		$page 			= clean_data($this->post('page'));
		$display 		= clean_data($this->post('display_type'));
		$device 		= clean_data($this->post('device'));
		$country 		= clean_data($this->post('country'));
	
		$date			= $this->post('date');
		$newDate 		= date("Y-m-d", strtotime($date));
		
		$search['date'] = $newDate;
		$search['account_id'] 	= 	$acc_id; 
		$search['cam_id'] 		= 	$cam_id;
		$search['creative_id'] 	= 	$creative_id; 
		
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];

		$search['field_name']  	= 	$field_name;
		$search['device']  		= 	$device;
		$search['country']  	= 	$country;
		

		$search['search_fields']=	"site_name";

		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
							
        if(!empty($search['account_id']) || !empty($search['cam_id']) || !empty($search['creative_id']))	
        {						
			$res   		= 	$this->do_report->fetch_adm_adv_detail_info($search,$order,$limit,$agency_id);
			
		}


				
		//$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}
	
	
	function fetch_detail_admin_publisher_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$search['limit1']= $datatable_obj['iDisplayStart'];
		$search['limit2']= $datatable_obj['iDisplayLength'];
		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;
		$acc_id 		= clean_data($this->post('pub_account_id'));
		$site_id 		= clean_data($this->post('site_id'));
		$adblock_id		= clean_data($this->post('adblock_id'));

		$field_name 	= clean_data($this->post('field_name'));
		$device 		= clean_data($this->post('device'));
		$country 		= clean_data($this->post('country'));		
		$page 			= clean_data($this->post('page'));
		$display 		= clean_data($this->post('display_type'));
	
		$date			= $this->post('date');
		$newDate 		= date("Y-m-d", strtotime($date));
		
		$search['date'] = $newDate;
		$search['account_id'] 	= 	$acc_id; 
		$search['site_id'] 		= 	$site_id;
		$search['adblock_id'] 	= 	$adblock_id; 
		
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];

		$search['field_name']  	= 	$field_name;
		$search['device']  		= 	$device;
		$search['country']  	= 	$country;

		$search['search_fields']=	"site_name";

		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
							
        if(!empty($search['account_id']) || !empty($search['site_id']) || !empty($search['adblock_id']))	
        {
			if($search['field_name'] == 'request')
			{
				$res   		= 	$this->do_report->fetch_detail_request_info4($search,$order,$limit,$agency_id);
				
			}
			else
			{						
				$res   		= 	$this->do_report->fetch_adm_pub_detail_info($search,$order,$limit,$agency_id);
			}
		}


				
		//$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}
	function fetch_environment_detail_post()
	{
		
		//Get from library file
		$datatable_obj 	= clean_data($this->post('datatable_obj'));
		$environment 	= clean_data($this->post('environment'));
		
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$agency_id 		= $this->user_authentication->agency_id;


		$field_name 	= clean_data($this->post('field_name'));
		$device 		= clean_data($this->post('device'));
		$country 		= clean_data($this->post('country'));		

	
		$date			= $this->post('date');
		$newDate 		= date("Y-m-d", strtotime($date));
		
		$search['date'] = $newDate;
		$search['account_id'] 	= 	$account_id; 	
		$search['account_type'] = 	$account_type;
		$search['search_term']  = 	$datatable_obj['sSearch'];

		$search['field_name']  	= 	$field_name;
		$search['device']  		= 	$device;
		$search['country']  	= 	$country;
		$search['environment']  = 	$environment;

		$search['search_fields']=	"site_name";

		if(clean_data($this->post('date_from'))!='')
		{
			$search['date_from'] 	= 	clean_data($this->post('date_from'));
		}
		if(clean_data($this->post('date_to'))!='')
		{
			$search['date_to'] 		= 	clean_data($this->post('date_to'));
		}
		
		
		$order	=	clean_data($this->post('order'));
		$limit	=	array(
						"start"	=>	clean_data($this->post('start')),
						"end"	=>	clean_data($this->post('end'))
						);
							
					
			$res   		= 	$this->do_report->fetch_environment_detail_info($search,$order,$limit,$agency_id);
			
		


				
		//$this->response($this->db->last_query(),200);
		$no_records = 	($res !== FALSE)?count($res):0;
		if($no_records)
		{	
			$result_data['sEcho'] 					= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= 	$no_records;
			$result_data['iTotalDisplayRecords'] 	= 	$no_records;
			$result_data['aaData'] 					= 	$res;
			//$result_data['overview_chart_data'] 	= 	$chart_data;

		}else{
			$result_data['sEcho'] 					= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 			= $no_records;
			$result_data['iTotalDisplayRecords'] 	= 0;
			$result_data['aaData']	 				= array();
			//$result_data['overview_chart_data'] 	= '';			

		}
		$this->response($result_data,200);		
	}
	
	function home_fetch_post(){
		$key =$this->post('api_key');
		 
		$account_id = $this->post('account_id');
		$account_type = $this->post('account_type');
		$page 			= $this->post('page');
		$display 		= $this->post('display_type');
		//$account_id 	= $this->user_authentication->account_id;
		//$account_type   = $this->user_authentication->account_type;
		
		$agency_id 		= FALSE;
		//$account_id = '2';
		//$account_type = 'ADMIN';
		
		//+sri
		//$agency_id	= $this->do_notification->getAdminAgencyId($account_id);
		
		switch(strtoupper($account_type)){
			case 'ADMIN';
				$agency_id	= $this->do_notification->getAdminAgencyId($account_id);
				break;
			case 'MANAGER';
				$agency_id	= $this->do_notification->getManagerAgencyId($account_id);
				break;
			case 'ADVERTISER';
				$agency_id	= $this->do_notification->getAdvertiserAgencyId($account_id);
				break;
		}
		
		if($account_type ==='MANAGER')
		{
			$account_type 	= 'ADMIN';
		}
		else
		{
			$account_type 	= $account_type;
		}
		/*sri * $manager_role_id 	= $this->user_authentication->manager_role_id;*/
		
		$stat_type 		= ($this->post('stat_type') !== '')?$this->post('stat_type'):'';
				
		// GET DATA BASED ON PREDEFINED CONFIG VALUES
		
		//GET the datatable object or request
		$datatable_obj = $this->post('datatable_obj');
		
		$search['page'] 		= $page; 
		$search['account_id'] 	= $account_id; 
		$search['account_type'] = $account_type;
		$search['search_term']  = $datatable_obj['sSearch'];
		$columns = array();
		$group = array();
		$order = array();
		$limit = array();
		
		$rep_config = $this->config->item('report_config');
		
		if(isset($rep_config[strtoupper($account_type)][strtoupper($page)])){
			
			$settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
						
			if(is_array($settings) AND count($settings) > 0){
				
	
			
				foreach($settings['FIELDS'] as $key => $value){
					
					array_push($columns,$key);
				/*sri *	if(isset($rep_config['MANAGER_PERMISSION'][strtoupper($key)]) && strtoupper($account_type) =='ADMIN')
					{
					    
					
						if(check_permission_layout($rep_config['MANAGER_PERMISSION'][strtoupper($key)],$manager_role_id))
						{
							
							array_push($columns,$key);
						sri }
					}else{
						
						array_push($columns,$key);
					}*/
				} 
								
					$group = $settings['GROUP'];
				
				
				if($page=='REPORT_DASHBOARD'):
					if($this->post('adv_type')!='' && $this->post('adv_type')=='zone'):
						$group	=	array('ZONE_ID');
					elseif($this->post('adv_type')!='' && $this->post('adv_type')=='traffic'):
						$group	=	array('AFF_ID');
					endif;
				endif;
								 
				$columns = array_unique(array_merge($group,$columns));
				
				if($this->post('dimensions') != ""){
					if($page == 'REPORT_ADVERTISER_HOME'){				
					$parts =  $this->post('dimensions');
					
					
					if(($key = array_search("DATE", $parts)) !== false) {
						unset($parts[$key]);
					}	
					$group =  $parts;
					}
				}
				if($this->post('dimensions') == ""){
					if($page == 'REPORT_PUBLISHER_HOME'){
						$group =  array("DATE");
						//$order =  'date_time';
					}
					
				}
			
				if($this->post('columns') != ""){				
					if($page == 'REPORT_ADVERTISER_HOME'){
						$columns	=	$this->post('columns');
					}	
				}
			
			//$this->response($columns,200);
				//returns the sorting data or false
				
				// GET SEARCH FIELDS 
				if(isset($settings['SEARCH_FIELDS'])){
					$search['search_fields']  = $settings['SEARCH_FIELDS'];
				}
				else
				{
					$search['search_fields']  = FALSE;
				}
				
				if( $this->convert_sorting_data($datatable_obj))
				{
					$order = $this->convert_sorting_data($datatable_obj);
				}else{
					$order = $settings['ORDER'];
				}
		
				if($this->post('start') != ''){
					$limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
				}
				else
				{
					$limit = $settings['LIMIT'];
				}
				
	
				if($settings['DEFAULT_INTERVAL'] != ''){
					$date = get_search_date($settings['DEFAULT_INTERVAL']);
					$search['date_from'] = $date['from_date'].' 00:00:00';
					$search['date_to'] = $date['to_date'].' 23:00:00';
				}	
		
				// ADD SEARCH FIELDS
			
				if($this->post('environment') != '' AND $this->post('environment') != 'all' AND $this->post('environment') != '0'){
					$search['environment'] = $this->post('environment'); 
				}
				
				if($this->post('campaign_id') != '' AND $this->post('campaign_id') != 'all'){
					$search['campaign_id'] = $this->post('campaign_id'); 
				}
				
				if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
					$search['country_id'] = $this->post('country_id'); 
				}
				
				if($this->post('creative_id') != '' AND $this->post('creative_id') != 'all'){
					$search['creative_id'] = $this->post('creative_id'); 
				}
				
				if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
					$search['site_id'] = $this->post('site_id'); 
				}
				if($this->post('app_id')!='' AND $this->post('app_id')!='all'){
					$search['app_id'] = $this->post('app_id'); 
				}				
				if($this->post('adv_account_id') != '' AND $this->post('adv_account_id') != 'all'){
					$search['adv_account_id'] = $this->post('adv_account_id'); 
				}
				
				if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
					$search['pub_account_id'] = $this->post('pub_account_id'); 
				}
				
				if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
					$search['adblock_id'] = $this->post('adblock_id'); 
				}
				
				if($this->post('country') != '' AND $this->post('country') != 'all'){
					$search['country'] 		= 	$this->post('country'); 
				}
				
				if($this->post('camtyp') != '' AND $this->post('camtyp') != 'all'){
					$search['revenue_type'] = 	$this->post('camtyp'); 
				}
				
				if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
					$search['adsize'] 		= 	$this->post('adsize'); 
				}
				
				if($this->post('browser') != '' AND $this->post('browser') != 'all'){
					$search['browser'] 		= 	$this->post('browser'); 
				}
				
				if($this->post('os') != '' AND $this->post('os') != 'all'){
					$search['os'] 		= 	$this->post('os'); 
				}
				
				if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
					$tz	=	explode(')',$this->post('timezone'));
					$tz1	=	str_replace('(GMT','',$tz[0]);
					$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
				}
				
				if($agency_id != FALSE){
					$search['agency_id'] = $agency_id; 				
				}
				
				if($this->post('date_from') != ''){
						
					if($this->post('timezone') != '' AND $this->post('timezone') != 'utc')
					{
						$fz	=	explode(')',$this->post('timezone'));
						$fd	=	new DateTime($this->post('date_from').' 00:00:00',new DateTimeZone(trim($fz[1])));
						$fd->setTimezone(new DateTimeZone('UTC'));
						$search['date_from'] = $fd->format('Y-m-d H:i:s'); 
					}
					else
					{
						$search['date_from'] = $this->post('date_from').' 00:00:00'; 
					}
				}
				
				if($this->post('date_to') != ''){
					if($this->post('timezone') != '' AND $this->post('timezone') != 'utc')
					{
						$toz=	explode(')',$this->post('timezone'));
						$td	=	new DateTime($this->post('date_to').' 23:00:00',new DateTimeZone(trim($toz[1])));
						$td->setTimezone(new DateTimeZone('UTC'));
						$search['date_to'] = $td->format('Y-m-d H:i:s'); 	
					}
					else
					{
						$search['date_to'] = $this->post('date_to').' 23:00:00'; 
					}
				}
							
				
							
				$dataTable = FALSE;
			
				if($display === 'TABLE'){
				
					$dataTable = TRUE;
				
				}
				if($this->post('dimensions') == ""){
					if($page == 'REPORT_PUBLISHER_HOME'){
						
						$order =  'date_time';
					}
					
				}							
				//$this->response($group,200);
				switch($stat_type){
					
					case 'COUNTRY';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							//$this->response->($columns,200);
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;
						
						$res = $this->do_report->fetch_country($columns,$search,$group,$order,$limit,$dataTable);
						//$this->response($res,200);
						break;
					case 'NETWORK';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							//$this->response->($columns,200);
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;
						$group[]	=	'ADSIZE';
						
						$res = $this->do_report->fetch_country($columns,$search,$group,$order,$limit,$dataTable);
						//$this->response($res,200);
						break;
					case 'VIDEO';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							//$this->response->($columns,200);
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'vid.date';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'vid.date';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;
						
						$res = $this->do_report->fetch_video($columns,$search,$group,$order,$limit,$dataTable);
						break;
					
					case 'EXPORT';
							$columns	=	$this->post('columns');
							$group		=	$this->post('dimensions');
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order	=	(is_array($group))?implode(',',$group):'';							
							}
							$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable,$page);							
							
							break;
					case 'ENVIRONMENT';
					case 'PLATFORM';
							$columns	=	$this->post('columns');
							$group		=	$this->post('dimensions');
							//
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						
						$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable,$page);
						
						break;		
					
					case 'URL';
						if($this->post('columns')):
							$columns	=	$this->post('columns');
						endif;	
						if($this->post('dimensions')):
							$group		=	$this->post('dimensions');
							//$this->response->($columns,200);
							if( $this->convert_sorting_data($datatable_obj))
							{
								$order = $this->convert_sorting_data($datatable_obj);
							}else{								
								$order='';
								if(!empty($group)):								
									foreach($group as $key):
										if($key=='HOUR'):
											$ord[] = 'r.date_time';
											$ord[] = $key;	
										elseif($key=='DATE' || $key=='MONTH'):
											$ord[] = 'r.date_time';
										else:										
											$ord[] = $key;	
										endif;									
									endforeach;
									$order	=	implode(',',$ord);
								endif;								
							}
						endif;
						
						$res = $this->do_report->fetch_url($columns,$search,$group,$order,$limit,$dataTable);
						
						break;	
					case 'DASHBOARD';
						$order	=	$settings['ORDER'];
						$res 	= 	$this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable);
						break;
					default:
					/*if($page == 'REPORT_ADVERTISER_HOME'){
					if($this->post('dimensions') == ""){				
							$group = $settings['GROUP'];
						}
						else{
							$parts =  $this->post('dimensions');
							
							
							if(($key = array_search("DATE", $parts)) !== false) {
								unset($parts[$key]);
							}	
							$group =  $parts;
						}
					}*/	
					if($this->post('dimensions')){
							$group		=	$this->post('dimensions');
						}
						$res = $this->do_report->fetch($columns,$search,$group,$order,$limit,$dataTable);	
						//$this->response($res,200);
						break;
						
				}
									
						// DB Data 
						if($display === 'TABLE'){
							
							if($stat_type==='EXPORT')
							{
								$result_data = $res;//$res['data'];								
								$this->response($result_data,200);
							}
							else
							{						
								// GET CHART SETTINGS AND DATA
								
								$chart_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('chart')];
								
								if($this->post('start') != ''){
									if($this->post('end') <=$chart_settings['LIMIT']['end'])
									{
										$chart_limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
									}else{
										$chart_limit = $chart_settings['LIMIT'];	
									}
								}
								else
								{
									$chart_limit = $chart_settings['LIMIT'];
								}
								
								switch($stat_type){
									
										case 'COUNTRY';
											$ch_settings 	= 	$rep_config[strtoupper($account_type)][strtoupper($page)]['CHART'];
											$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
											break;
										case 'NETWORK';
											$ch_settings 	= 	$rep_config[strtoupper($account_type)][strtoupper($page)]['CHART'];
											$chart_data_res = 	$this->do_report->fetch_country($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
											break;
										case 'VIDEO';
											$chart_data_res = $this->do_report->fetch_video($columns,$search,$group,$order,$chart_limit);
											break;
										case 'URL';
											$chart_data_res = $this->do_report->fetch_url($columns,$search,$group,$order,$chart_limit);
											break;
										case 'ENVIRONMENT';
											$ch_settings 	= 	$rep_config[strtoupper($account_type)][strtoupper($page)]['CHART'];
											$chart_data_res = $this->do_report->fetch($columns,$search,$ch_settings['GROUP'],$order,$chart_limit);
											break;		
										default:
											$chart_data_res = $this->do_report->fetch($columns,$search,$group,$order,$chart_limit);
											break;
								}
								
								$chart_data = $this->convert_chart_data($chart_data_res,$chart_settings);
								
								//Load Map Settings...if Map is found
								if(isset($rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('map')]))
								{
									$map_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('map')];
									
									if($this->post('start') != ''){
										$map_limit = array('start'=>$this->post('start'),'end'=>$this->post('end'));
									}
									else
									{
										$map_limit = $map_settings['LIMIT'];
									}
									$map_columns = array();
									foreach($map_settings['FIELDS'] as $key => $value){
										array_push($map_columns,$key);
									}
					
									$map_group = $map_settings['GROUP'];
								
									$map_columns = array_unique(array_merge($map_group,$map_columns));
									
									/*if( $this->convert_sorting_data($datatable_obj))
									{
										$map_order = $this->convert_sorting_data($datatable_obj);
									}else{*/
										$map_order = $map_settings['ORDER'];
									//}
									
									switch($stat_type){
											case 'COUNTRY';
												$map_columns[]		=	'COUNTRY_CODE';
												$map_data_res = $this->do_report->fetch_country($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
											case 'NETWORK';
												$map_columns[]		=	'COUNTRY_CODE';
												$map_data_res = $this->do_report->fetch_country($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
											case 'VIDEO';
												$map_data_res = $this->do_report->fetch_video($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
											case 'URL';
												$map_data_res = $this->do_report->fetch_url($map_columns,$search,$map_group,$map_order,$map_limit);
												break;	
											default:
												$map_data_res = $this->do_report->fetch($map_columns,$search,$map_group,$map_order,$map_limit);
												break;
									}
									
									$map_data = $this->convert_map_data($map_data_res,$map_settings);
								}
								
								
								
								
								
							/**********************************************/
								
										
								switch($account_type){
									case 'ADMIN':
										switch($page){
											case 'REPORT_CREATIVE':
											case 'REPORT_CAMPAIGN':
											case 'REPORT_ADVERTISER':
											case 'REPORT_PUBLISHER':
											case 'REPORT_SITE':
											case 'REPORT_SITE_DETAILS':
											case 'REPORT_SITE_DETAILS_SITEURL':
											case 'REPORT_SITE_DETAILS_IMP':
											case 'REPORT_APP':
											case 'REPORT_ADBLOCK':
											case 'REPORT_ADBLOCK_DETAILS':
											case 'REPORT_ADBLOCK_DETAILS_IMP':
											case 'PLATFORM_REPORT':
											case 'REPORT_ENVIRONMENT':
											   
												$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												$no_records = ($total !== FALSE)?count($total):0;
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $res;
										
													$result_data['overview_chart_data'] = $chart_data;
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);	
												break;
											case 'REPORT_GEO_GRAPHICAL':
												//echo "hhii"; die();
												$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												$total1 = $this->do_report->get_impression_count($search);
												$result = array_merge($total, $total1);
												//print_r($total);
												//$this->response($total,200);
												//exit;
												$no_records = ($total !== FALSE)?count($total):0;
												//$no_records = ($res['total'])?$res['total']:0;
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $res;
													//$result_data['aaData'] = $res['data'];
													$result_data['overview_chart_data'] = $chart_data;
													$result_data['overall_map_data'] = $map_data;
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													$result_data['overall_map_data'] = $map_data;			
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);		
												break;
											default:
												$this->response($res,200);
												break;	
										}
									break;
									case 'ADVERTISER':
										switch($page){
											case 'REPORT_OVERVIEW':
										    case 'REPORT_CAMPAIGN':
											case 'REPORT_CREATIVE':
											case 'REPORT_ADVERTISER_HOME':
											case 'REPORT_DASHBOARD':
											case 'REPORT_URL':
											case 'REPORT_VIDEO':
												switch($stat_type){
												case 'VIDEO';
													$total = $this->do_report->fetch_video($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													
													break;
												case 'URL';
													$total = $this->do_report->fetch_url($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													//$this->response($this->db->last_query(),200);
													break;
												default:
													$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													//$this->response($this->db->last_query(),200);
													break;
							
												}
												
												//$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												$no_records = ($total !== FALSE)?count($total):0;
												//$no_records = ($res['total'])?$res['total']:0;

												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $res;
													//$result_data['aaData'] = $res['data'];
													$result_data['overview_chart_data'] = $chart_data;
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);	
												break;
												case 'REPORT_GEO_GRAPHICAL':
		
													$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
													$no_records = ($total !== FALSE)?count($total):0;

												
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $res;

													$result_data['overview_chart_data'] = $chart_data;
													$result_data['overall_map_data'] = $map_data;
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													$result_data['overall_map_data'] = $map_data;			
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);		
												break;
											default:
												$this->response($res,200);	
										}
									break;
									case 'TRAFFICKER':
										switch($page){
											case 'REPORT_OVERVIEW':
											case 'REPORT_ADBLOCK':
											case 'REPORT_PUBLISHER_HOME':
											case 'REPORT_ADBLOCK_DETAILS':
											case 'REPORT_ADBLOCK_DETAILS_IMP':
											case 'REPORT_DASHBOARD':
											case 'REPORT_SITE':
											case 'REPORT_SITE_DETAILS':
											case 'REPORT_SITE_DETAILS_IMP':
											case 'REPORT_SITE_DETAILS_SITEURL':
											case 'REPORT_APP':
											case 'REPORT_APP_DETAILS_IMP':
											
										 		$total = $this->do_report->fetch($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
										 		
												/*$totals = '1';
												$ress 		= 	$this->do_report->fetch_detail_info1($search,$order,NULL,NULL,$totals);
												$total[] = $ress[0];*/
																							 			
												$no_records = ($total !== FALSE)?count($total):0;
												//$no_records = ($res['total'])?$res['total']:0;
												
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $res;  //$res
													//$result_data['aaData'] = $res['data'];
													$result_data['overview_chart_data'] = $chart_data;
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);	
												break;
										case 'REPORT_GEO_GRAPHICAL':
													
												$total = $this->do_report->fetch_country($columns,$search,$group,$order,$settings['LIMIT'],$dataTable);
												$no_records = ($total !== FALSE)?count($total):0;
//$no_records = ($res['total'])?$res['total']:0;
												
												if($no_records)
												{	
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = $no_records;
													$result_data['aaData'] = $res;
//$result_data['aaData'] = $res['data'];
													$result_data['overview_chart_data'] = $chart_data;
													$result_data['overall_map_data'] = $map_data;
													
												}else{
													$result_data['sEcho'] 			= $datatable_obj['sEcho'];
													$result_data['iTotalRecords'] 	= $no_records;
													$result_data['iTotalDisplayRecords'] = 0;
													$result_data['aaData'] = array();
													$result_data['overview_chart_data'] = '';			
													$result_data['overall_map_data'] = $map_data;			
													
												}
												
												// RETURN DATATABLE AND CHART DATA
												$this->response($result_data,200);		
												break;
											default:
												$this->response($res,200);	
										 }
										 break;
							 	  }
							
								
						
							}
						}
						else if($display==='CHART' AND $res !=FALSE)
						{
							$success = $this->convert_chart_data($res,$settings);	
							$this->response($success,200);	
						}
						else if($display==='MAP' AND $res !=FALSE)
						{
							$success = $this->convert_map_data($res,$settings);	
							$this->response($success,200);	
						}
						else
						{
								/* Monthly calculate impressions/clicks/conversions/spend*/
								$month=date('m');
                                $year=date('Y');								
								$search3['month'] = $month;
								$search3['year'] = $year;								
								$search3['account_id'] 	 = $this->post('adv_account_id'); 
								$search3['account_type'] = 'ADVERTISER';
								$search3['adv_account_id'] = $this->post('adv_account_id');
								$group3[0]= "MONTH";
								
								$month_res=$this->do_report->fetch($columns,$search3,$group3,$order,$limit,$dataTable);
								
															
							if($display==='TILES' AND $account_type==='ADVERTISER')
							{
								
								$spark_chart_config = $rep_config['ADVERTISER']['DASHBOARD']['SPARKLINE'];
															
								$columns2 = array();
								
								foreach($spark_chart_config['FIELDS'] as $key => $value){
									array_push($columns2,$key);
								}
								
								
								$group2 = $spark_chart_config['GROUP'];
								$columns2 = array_unique(array_merge($group,$columns2));
								$order2 = $spark_chart_config['ORDER'];
								$limit2 = $spark_chart_config['LIMIT'];
								
								$date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);

								$search2['date_from'] = $date2['from_date'];
								$search2['date_to'] = $date2['to_date'];
								
								$search2['account_id'] 	 = $this->post('adv_account_id'); 
								$search2['account_type'] = 'ADVERTISER';

								$search2['adv_account_id'] = $this->post('adv_account_id'); 
								
								/*Active campaigns - start */							
								$active_cam=$this->do_report->active_campaign_count($account_id);
								$active_cam_count=$active_cam[0]['count'];	
								$complete_cam=$this->do_report->complete_campaign_count($account_id);
								$complete_cam_count=$complete_cam[0]['count'];										
								/* End*/
								
															
								$tmp_imp_flow = $this->do_report->fetch($columns2,$search2,$group2,$order2,$limit2);
								
																
								if(count($tmp_imp_flow['records'])>0 )
								{
									foreach($tmp_imp_flow['records'] as $imp_data)
									{
										$tmp_impression[]=$imp_data['IMP'];
										
									}
									$imp_flow=implode(',',$tmp_impression);

									$impression_flow=array('impression_flow'=>$imp_flow);	
								}
								else
								{
									$impression_flow=array('impression_flow'=>array());	
								}
								
								if(is_array($impression_flow) AND  count($impression_flow)>0 AND  count($res['records'])>0 )
								{
									$temp = array_merge($res['records'][0],$impression_flow);
									$res['records'][0] = $temp;
								}
								else
								{
									$res['records'][0] = $impression_flow;
								}								
								
								
							}
							if($display==='TILES' AND $account_type==='TRAFFICKER')
							{								
								
								$spark_chart_config = $rep_config['TRAFFICKER']['DASHBOARD']['SPARKLINE'];
								
								$columns2 = array();
								
								foreach($spark_chart_config['FIELDS'] as $key => $value){
									array_push($columns2,$key);
								}
								
								if($this->post('type') && $this->post('type')=='MONTH')
								{									
									$group2 = array('MONTH');
									$search2['date_from'] 	= 	$this->post('date_from');
									$search2['date_to'] 	= 	$this->post('date_to');
									$res = $this->do_report->fetch($columns,$search,$group2,$order,$limit,$dataTable);
								}
								else
								{		
									$group2 = $spark_chart_config['GROUP'];
									
									$date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);

									$search2['date_from'] = $date2['from_date'];
									$search2['date_to'] = $date2['to_date'];
								}
								
								$columns2 = array_unique(array_merge($group,$columns2));
								$order2 = $spark_chart_config['ORDER'];
								$limit2 = $spark_chart_config['LIMIT'];
								
								
								
								$search2['account_id'] 	 = $this->post('pub_account_id'); 
								$search2['account_type'] = 'TRAFFICKER';

								$search2['pub_account_id'] = $this->post('pub_account_id'); 
								
								if($agency_id != FALSE){
									$search2['agency_id'] = $agency_id; 
								}
								
								
								$tmp_earnings_flow = $this->do_report->fetch($columns2,$search2,$group2,$order2,$limit2);
								
								if(count($tmp_earnings_flow['records'])>0 )
								{
									foreach($tmp_earnings_flow['records'] as $earnings_data)
									{
										$tmp_earnings[]=$earnings_data['PUB_EARN'];
										
									}
									$earnings_flow=implode(',',$tmp_earnings);

									$earnings_flow=array('earnings_flow'=>$earnings_flow);	
									
								}
								else
								{
									$earnings_flow=array('impression_flow'=>array());	
								}
								
								if(is_array($earnings_flow) AND  count($earnings_flow)>0 AND  count($res['records'])>0 )
								{
									$temp = array_merge($res['records'][0],$earnings_flow);
									$res['records'][0] = $temp;
								}
								else
								{
									$res['records'][0] = $earnings_flow;
								}
							}
							if($display==='TILES' AND $account_type==='ADMIN')
							{
								
								$spark_chart_config = $rep_config['ADMIN']['DASHBOARD']['SPARKLINE'];
								
								$columns2 = array();
								
								foreach($spark_chart_config['FIELDS'] as $key => $value){
									array_push($columns2,$key);
								}
								
								
								$group2 = $spark_chart_config['GROUP'];
								$columns2 = array_unique(array_merge($group,$columns2));
								$order2 = $spark_chart_config['ORDER'];
								$limit2 = $spark_chart_config['LIMIT'];
								
								$date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);

								$search2['date_from'] = $date2['from_date'];
								$search2['date_to'] = $date2['to_date'];
								
								$search2['account_id'] 	 = $this->post('account_id'); 
								$search2['account_type'] = 'ADMIN';
								
								if($agency_id != FALSE){
									$search2['agency_id'] = $agency_id; 
								}
								
								
								/*Active campaigns - start */							
								$active_cam=$this->do_report->active_campaign_count();
								$active_cam_count=$active_cam[0]['count'];	
								$complete_cam=$this->do_report->complete_campaign_count();
								$complete_cam_count=$complete_cam[0]['count'];										
								/* End*/
								
								
								
								
								$tmp_earnings_flow = $this->do_report->fetch($columns2,$search2,$group2,$order2,$limit2);

								
								
								if(count($tmp_earnings_flow['records'])>0 )
								{
									foreach($tmp_earnings_flow['records'] as $earnings_data)
									{
										$tmp_earnings[]=$earnings_data['ADM_EARN'];
										
									}
									$earnings_flow=implode(',',$tmp_earnings);

									$earnings_flow=array('earnings_flow'=>$earnings_flow);	
								}
								else
								{
									$earnings_flow=array('earnings_flow'=>array());	
								}
								
								$inventory = $this->do_report->get_inventory_count($account_type,$search['date_from'],$agency_id);
								
									
								if(is_array($earnings_flow) AND  count($earnings_flow)>0 AND  count($res['records'])>0 )
								{
									$temp = array_merge($res['records'][0],$earnings_flow);
									$res['records'][0] = $temp;
									if(is_array($inventory) AND  count($inventory)>0)
									{
										$temp = array_merge($res['records'][0],$inventory);
										$res['records'][0] = $temp;
									}
								}
								else
								{
									$res['records'][0] = $earnings_flow;
									
									if(is_array($inventory) AND  count($inventory)>0)
									{
										$temp = array_merge($res['records'][0],$inventory);
										$res['records'][0] = $temp;
									}
								}
							
							}
							
							
							if($display==='TILES'){
								
								// CONVERT NUMERIC VALUES TO SHORT FORM
							
								if(isset($res['records'][0]['IMP'])){
									$res['records'][0]['IMP'] = convert_to_shortform($res['records'][0]['IMP']);
								}
								
								if(isset($res['records'][0]['CLK'])){
									$res['records'][0]['CLK'] = convert_to_shortform($res['records'][0]['CLK']);
								}
								
								if(isset($res['records'][0]['CON'])){
									$res['records'][0]['CON'] = convert_to_shortform($res['records'][0]['CON']);
								}
								
								if(isset($res['records'][0]['UIMP'])){
									$res['records'][0]['UIMP'] = convert_to_shortform($res['records'][0]['UIMP']);
								}
								
								if(isset($res['records'][0]['UCLK'])){
									$res['records'][0]['UCLK'] = convert_to_shortform($res['records'][0]['UCLK']);
								}
								
								if(isset($res['records'][0]['SPEND'])){
									$res['records'][0]['SPEND'] = convert_to_shortform($res['records'][0]['SPEND'],2);
								}
								
								if(isset($res['records'][0]['CTR'])){
									$res['records'][0]['CTR'] = convert_to_shortform($res['records'][0]['CTR'],2);
								}
								
								if(isset($res['records'][0]['ECPM'])){
									$res['records'][0]['ECPM'] = convert_to_shortform($res['records'][0]['ECPM'],2);
								}
								
								if(isset($res['records'][0]['PUB_EARN'])){
									$res['records'][0]['PUB_EARN'] = convert_to_shortform($res['records'][0]['PUB_EARN'],2);
								}
								
								if(isset($res['records'][0]['PUB_ECPM'])){
									$res['records'][0]['PUB_ECPM'] = convert_to_shortform($res['records'][0]['PUB_ECPM'],2);
								}
								
								if(isset($month_res['records'][0]['IMP'])){
									$res['records'][0]['MONTH_IMP'] = convert_to_shortform($month_res['records'][0]['IMP']);
								}
								
								if(isset($month_res['records'][0]['CLK'])){
									$res['records'][0]['MONTH_CLK'] = convert_to_shortform($month_res['records'][0]['CLK']);
								}
								
								if(isset($month_res['records'][0]['CON'])){
									$res['records'][0]['MONTH_CON'] = convert_to_shortform($month_res['records'][0]['CON']);
								}
								
								if(isset($month_res['records'][0]['UIMP'])){
									$res['records'][0]['MONTH_UIMP'] = convert_to_shortform($month_res['records'][0]['UIMP']);
								}
								
								if(isset($month_res['records'][0]['UCLK'])){
									$res['records'][0]['MONTH_UCLK'] = convert_to_shortform($month_res['records'][0]['UCLK']);
								}
								
								if(isset($month_res['records'][0]['SPEND'])){
									$res['records'][0]['MONTH_SPEND'] = convert_to_shortform($month_res['records'][0]['SPEND'],2);
								}
								
								if(isset($month_res['records'][0]['CTR'])){
									$res['records'][0]['MONTH_CTR'] = convert_to_shortform($month_res['records'][0]['CTR'],2);
								}
								
								if(isset($month_res['records'][0]['ECPM'])){
									$res['records'][0]['MONTH_ECPM'] = convert_to_shortform($month_res['records'][0]['ECPM'],2);
								}
								
								if(isset($month_res['records'][0]['PUB_EARN'])){
									$res['records'][0]['MONTH_PUB_EARN'] = convert_to_shortform($month_res['records'][0]['PUB_EARN'],2);
								}
								
								if(isset($month_res['records'][0]['PUB_ECPM'])){
									$res['records'][0]['MONTH_PUB_ECPM'] = convert_to_shortform($month_res['records'][0]['PUB_ECPM'],2);
								}							
								if(!empty($active_cam_count))
								{
									$res['records'][0]['ACTIVE_CAM']=$active_cam_count;
								}
								if(!empty($complete_cam_count))
								{
									$res['records'][0]['COMPLETE_CAM']=$complete_cam_count;
								}
								
															
								// END OF CONVERT PROCESS
							
							}
							
							//exit;
							
							$success 	= 	array(
											'response' 	=> 	'ok',
											'data'		=> 	$res,
										);
										
						  $this->response($success,200);
						}
			}
		}
	
	
	
	
	}
	
	function fetch_top_sources_get()
	{
		
					$date = get_search_date($settings['DEFAULT_INTERVAL']);
					
					$search['date_from'] = $date['from_date'].' 00:00:00';
					$search['date_to'] = $date['to_date'].' 23:00:00';
			
			
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id = '';//$this->user_authentication->default_advertiser_account_id;
		}	
				
		$top_sources = 	$this->do_report->fetch_top_sources($account_id,$search);	
			
	//$this->response($this->db->last_query($top_sources),200);
		$this->response($top_sources,200);
		
	}
	
	function fetch_top_zones_get()
	{
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id = '';//$this->user_authentication->default_advertiser_account_id;
		}									
		$top_sources = 	$this->do_report->fetch_top_zones($account_id);	
			
		$this->response($top_sources,200);
		
	}
	
	public function fetch_traffic_report_get()
	{
		$camp_id= $this->get('campaign_id');
		
		
		$traffic_sources = 	$this->do_report->fetch_traffc_source_total($camp_id);
		if($traffic_sources)
		{
			$this->response($traffic_sources,200);
		}
		else
		{
			$this->response('no result',200);
		}		
	}
	public function fetch_zonebid_tot_get()
	{
		$camp_id= $this->get('campaign_id');
		
		
		$zonebid = 	$this->do_report->fetch_zonebid_total($camp_id);
		if($zonebid)
		{
			$this->response($zonebid,200);
		}
		else
		{
			$this->response('no result',200);
		}		
	}
	public function fetch_countrybid_tot_get()
	{
		$camp_id= $this->get('campaign_id');
		
		
		$countrybid = 	$this->do_report->fetch_countrybid_total($camp_id);
		if($countrybid)
		{
			$this->response($countrybid,200);
		}
		else
		{
			$this->response('no result',200);
		}		
	}
	public function fetch_pixtrack_report_get()
	{
		$camp_id	= 	$this->get('campaign_id');
		$from_date	= 	$this->get('from_date');
		$to_date	= 	$this->get('to_date');				
		$pixresult 	= 	$this->do_report->fetch_pixtrack_report($camp_id,$from_date,$to_date);
		
		if($pixresult)
		{
			$this->response($pixresult,200);
		}
		else
		{
			$this->response('no result',200);
		}		
	}
		//Advertiser earning history
	function fetch_advertise_earn_get() 
	{
		
	    if($this->user_authentication->account_type=='TRAFFICKER'){
		 $account_id = $this->user_authentication->account_id;
		}
	
		$page = 'DASHBOARD';
		$account_type='TRAFFICKER';
		$display='CHART';
		$rep_config = $this->config->item('report_config');
		if(isset($rep_config[strtoupper($account_type)][strtoupper($page)]))
		{
			$settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
			
		}
		$date_from=$this->input->get('date_from');
		$date_to =$this->input->get('date_to');
		if($date_from!=''&& $date_to!='')
		{
		$search['date_from']=$date_from;
		$search['date_to'] =$date_to;
		}
		else
		{
		if($settings['DEFAULT_INTERVAL'] != '')
			{
					$date = get_search_date($settings['DEFAULT_INTERVAL']);
					$search['date_from'] = $date['from_date'].' 00:00:00';
					$search['date_to'] = $date['to_date'].' 23:00:00';
					
			}	 
		}
		$advertiser_list = $this->do_report->fetch_advertiser_earn($account_id,$search);
		//log_message('error','adveriser_history');
		//log_message('error',print_r($advertiser_list,true));
			//	1og_message('error',count($advertiser_list));

		if($advertiser_list)
		{
		$this->response($advertiser_list,200);
		}
		else
		{
			
		$this->response(array('rows'=>'empty'),200);
		}
		
			
		
	}
	
	function fetch_profit_post() //DAC 094
	{ 	//$this->response($this->post('date_from'),200);
		$page 			= $this->post('page');
		$display 		= $this->post('display_type');
		$report_type	= $this->post('report_type');
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;//$this->response($account_id,200);
		$order 		= array('PUB_EARN '=> 'DESC');
		$adv_types 		= $this->post('adv_types');
		$search['page'] 		= $page; 
		
		$search['account_id'] 	= $account_id; 
		$search['account_type'] = $account_type;
		$search['report_type'] = $report_type;
		$search['search_term']  = $datatable_obj['sSearch'];
		$search['date_from'] = $this->post('date_from').' 00:00:00';
		$search['date_to'] = $this->post('date_to').' 23:59:59';
		$chart = $this->do_report->fetch_profit_earn($search,$order);	//print_r($chart);exit;	
		$earnings = $this->do_report->publisher_earnings_menu($search);	//print_r($earnings);exit;	
		$this->response(array('chart'=>$chart,'counts'=>$earnings),200);
		//~ $this->response($total,200);
		
	}			
	
	function fetch_topmenu_report_post() //DAC 094
	{ 	//$this->response($this->post('date_from'),200);
		$page 			= $this->post('page');
		$display 		= $this->post('display_type');
		$report_type	= $this->post('report_type');
		$account_id 	= $this->user_authentication->account_id;
		$account_type   = $this->user_authentication->account_type;
		$order 		= array('PUB_EARN '=> 'DESC');
		$adv_types 		= $this->post('adv_types');
		$search['page'] 		= $page; 
		 
		$search['account_id'] 	= $account_id; 
		$search['account_type'] = $account_type;
		$search['report_type'] = $report_type;
		$search['search_term']  = $datatable_obj['sSearch'];
		$search['date_from'] = $this->post('date_from');
		 
		$total = $this->do_report->fetch_topmenu_model($search,$order);	//print_r($total);exit;	
		$wallet = $this->do_report->wallet_money_advertiser($account_id);	//print_r($total);exit;	
		
		
		$this->response(array('counts'=>$total,'balance'=>$wallet),200);
		
	}			
}
