<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Referral extends REST_Controller
{
	function __construct(){

		parent::__construct();		
		$this->load->model('do_referral');
		
        $this->load->library('user_authentication');
        $this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
	    $key		=	$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = 	$this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }		   
	}
		
       
    /** 
     * name: fetch_adblocks_get
     * @params : account_id and zone_id
     * 
     * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    
	public function fetch_referral_get()
	{					
		$user_auth  	= 	$this->user_authentication;
		$account_id 	= 	$user_auth->account_id;
		
		if($account_id)
		{
			$referral = 	$this->do_referral->fetch($account_id);
		}
		
		if($referral)
		{			
			$this->response($referral,200);
		}
		else
		{
			$this->response( array(), 200);
		}
	}
	
}
